import{s as Tt,n as mt,o as wt}from"../chunks/scheduler.00b97157.js";import{S as jt,i as Ut,e as M,s as n,c as i,h as bt,a as p,d as e,b as a,f as ut,g as r,j as o,k as Jt,l as It,m as s,n as y,t as c,o as u,p as J}from"../chunks/index.a7c1a7a1.js";import{C as dt,H as ht,E as ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.497ce585.js";import{C as K}from"../chunks/CodeBlock.3168271d.js";import{D as Ct}from"../chunks/DocNotebookDropdown.ccd8e45d.js";function vt(Xl){let T,tl,O,el,m,sl,w,nl,j,al,U,$l="रिट्रीवल-ऑगमेंटेड-जनरेशन (RAG) है “एक यूजर के प्रश्न का उत्तर देने के लिए LLM का उपयोग करना, लेकिन उत्तर को एक नॉलेज बेस से प्राप्त जानकारी पर आधारित करना”। इसमें वैनिला या फाइन-ट्यून्ड LLM का उपयोग करने की तुलना में कई फायदे हैं: कुछ नाम लेने के लिए, यह उत्तर को सत्य तथ्यों पर आधारित करने और काल्पनिक बातों को कम करने की अनुमति देता है, यह LLM को डोमेन-विशिष्ट ज्ञान प्रदान करने की अनुमति देता है, और यह नॉलेज बेस से जानकारी तक पहुंच का सूक्ष्म नियंत्रण प्रदान करता है।",Ml,b,Ql="लेकिन वैनिला RAG की सीमाएं हैं, सबसे महत्वपूर्ण ये दो:",pl,I,ql="<li>यह केवल एक रिट्रीवल स्टेप करता है: यदि परिणाम खराब हैं, तो जनरेशन भी बदले में खराब होगा।</li> <li>सिमेंटिक समानता की गणना यूजर के प्रश्न को संदर्भ के रूप में करके की जाती है, जो अनुकूल नहीं हो सकती: उदाहरण के लिए, यूजर का प्रश्न अक्सर एक सवाल होगा, जबकि सही उत्तर देने वाला डॉक्यूमेंट सकारात्मक स्वर में हो सकता है, और इसका समानता स्कोर अन्य स्रोत दस्तावेज़ों की तुलना में कम हो सकता है, जो प्रश्नवाचक स्वर में हो सकते हैं। इससे संबंधित जानकारी को चूकने का जोखिम होता है।</li>",ol,d,El="हम एक RAG एजेंट बनाकर इन समस्याओं को कम कर सकते हैं: बहुत सरल तरीके से, एक रिट्रीवर टूल से लैस एजेंट!",il,h,Sl="यह एजेंट करेगा: ✅ स्वयं क्वेरी तैयार करेगा और ✅ आवश्यकता पड़ने पर पुनः-प्राप्ति के लिए समीक्षा करेगा।",rl,f,Fl="इसलिए यह सहज रूप से कुछ उन्नत RAG तकनीकों को प्राप्त कर लेना चाहिए!",yl,C,zl=`<li>सिमेंटिक खोज में सीधे यूजर क्वेरी का संदर्भ के रूप में उपयोग करने के बजाय, एजेंट स्वयं एक संदर्भ वाक्य तैयार करता है जो लक्षित डॉक्यूमेंट्स के करीब हो सकता है, जैसा कि <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a> में किया गया है।
एजेंट जनरेट किए गए स्निपेट्स का उपयोग कर सकता है और आवश्यकता पड़ने पर पुनः-प्राप्ति कर सकता है, जैसा कि <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a> में किया गया है।</li>`,cl,v,Ll="चलिए इस सिस्टम को बनाते हैं। 🛠️",ul,Z,Yl="आवश्यक डिपेंडेंसी इंस्टॉल करने के लिए नीचे दी गई लाइन चलाएं।",Jl,g,Tl,B,Pl=`HF Inference API को कॉल करने के लिए, आपको अपने एनवायरनमेंट वेरिएबल <code>HF_TOKEN</code> के रूप में एक वैध टोकन की आवश्यकता होगी।
हम इसे लोड करने के लिए python-dotenv का उपयोग करते हैं।`,ml,_,wl,A,Dl="हम पहले एक नॉलेज बेस लोड करते हैं जिस पर हम RAG को लागू करना चाहते हैं: यह डेटा सेट Hugging Face के कई लाइब्रेरी के डॉक्यूमेंट पृष्ठों का संकलन है, जिन्हें Markdown में स्टोर किया गया है। हम केवल <code>transformers</code> लाइब्रेरी के दस्तावेज़ों को रखेंगे।",jl,R,Kl="फिर डेटासेट को प्रोसेस करके और इसे एक वेक्टर डेटाबेस में स्टोर करके नॉलेज बेस तैयार करें जिसे रिट्रीवर द्वारा उपयोग किया जाएगा।",Ul,k,Ol='हम <a href="https://python.langchain.com/docs/introduction/" rel="nofollow">LangChain</a> का उपयोग करते हैं क्योंकि इसमें उत्कृष्ट वेक्टर डेटाबेस उपयोगिताएं हैं।',bl,x,Il,G,lt="अब डॉक्यूमेंट्स तैयार हैं।",dl,N,tt="तो चलिए अपना एजेंटिक RAG सिस्टम बनाएं!",hl,H,et="👉 हमें केवल एक RetrieverTool की आवश्यकता है जिसका उपयोग हमारा एजेंट नॉलेज बेस से जानकारी प्राप्त करने के लिए कर सकता है।",fl,V,st='चूंकि हमें टूल के एट्रीब्यूट के रूप में एक vectordb जोड़ने की आवश्यकता है, हम सरल टूल कंस्ट्रक्टर को <code>@tool</code> डेकोरेटर के साथ सीधे उपयोग नहीं कर सकते: इसलिए हम <a href="../tutorials/tools">tools tutorial</a> में हाइलाइट किए गए सेटअप का पालन करेंगे।',Cl,W,vl,X,nt=`हमने BM25 का उपयोग किया है, जो एक क्लासिक रिट्रीवल विधि है,  क्योंकि इसे सेटअप करना बहुत आसान है।
रिट्रीवल सटीकता में सुधार करने के लिए, आप BM25 को डॉक्यूमेंट्स के लिए वेक्टर प्रतिनिधित्व का उपयोग करके सिमेंटिक खोज से बदल सकते हैं: इस प्रकार आप एक अच्छा एम्बेडिंग मॉडल चुनने के लिए <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> पर जा सकते हैं।`,Zl,$,at="अब यह सीधा है कि एक एजेंट बनाया जाए जो इस <code>retriever_tool</code> का उपयोग करेगा!",gl,Q,Mt="एजेंट को इनिशियलाइजेशन पर इन आर्गुमेंट्स की आवश्यकता होगी:",Bl,q,pt=`<li><code>tools</code>: टूल्स की एक सूची जिन्हें एजेंट कॉल कर सकेगा।</li> <li><code>model</code>: LLM जो एजेंट को पावर देता है।
हमारा <code>model</code> एक कॉलेबल होना चाहिए जो इनपुट के रूप में संदेशों की एक सूची लेता है और टेक्स्ट लौटाता है। इसे एक stop_sequences आर्गुमेंट भी स्वीकार करने की आवश्यकता है जो बताता है कि जनरेशन कब रोकनी है। सुविधा के लिए, हम सीधे पैकेज में प्रदान की गई HfEngine क्लास का उपयोग करते हैं ताकि एक LLM इंजन मिल सके जो Hugging Face के Inference API को कॉल करता है।</li>`,_l,E,ot='और हम <a href="meta-llama/Llama-3.3-70B-Instruct">meta-llama/Llama-3.3-70B-Instruct</a> का उपयोग llm इंजन के रूप में करते हैं क्योंकि:',Al,S,it="<li>इसमें लंबा 128k कॉन्टेक्स्ट है, जो लंबे स्रोत दस्तावेजों को प्रोसेस करने में मददगार है</li> <li>यह हर समय HF के Inference API पर मुफ्त में उपलब्ध है!</li>",Rl,F,rt='<em>नोट:</em> Inference API विभिन्न मानदंडों के आधार पर मॉडल होस्ट करता है, और डिप्लॉय किए गए मॉडल बिना पूर्व सूचना के अपडेट या बदले जा सकते हैं। इसके बारे में अधिक जानें <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">यहां</a> पढ़ें।',kl,z,xl,L,yt="CodeAgent को इनिशियलाइज करने पर, इसे स्वचालित रूप से एक डिफ़ॉल्ट सिस्टम प्रॉम्प्ट दिया गया है जो LLM इंजन को चरण-दर-चरण प्रोसेस करने और कोड स्निपेट्स के रूप में टूल कॉल जनरेट करने के लिए कहता है, लेकिन आप आवश्यकतानुसार इस प्रॉम्प्ट टेम्पलेट को अपने से बदल सकते हैं।",Gl,Y,ct="जब CodeAgent का <code>.run()</code> मेथड लॉन्च किया जाता है, तो एजेंट LLM इंजन को कॉल करने का कार्य करता है, और टूल कॉल्स को निष्पादित करता है, यह सब एक लूप में होता है, जो तब तक चलता है जब तक टूल final_answer के साथ अंतिम उत्तर के रूप में नहीं बुलाया जाता।",Nl,P,Hl,D,Vl,ll,Wl;return m=new dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ht({props:{title:"एजेंटिक RAG",local:"एजटक-rag",headingTag:"h1"}}),j=new Ct({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/tensorflow/rag.ipynb"}]}}),g=new K({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcGFuZGFzJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHJhbmtfYm0yNSUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents pandas langchain langchain-community sentence-transformers rank_bm25 --upgrade -q",wrap:!1}}),_=new K({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),x=new K({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWtub3dsZWRnZV9iYXNlJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGtub3dsZWRnZV9iYXNlLmZpbHRlcihsYW1iZGElMjByb3clM0ElMjByb3clNUIlMjJzb3VyY2UlMjIlNUQuc3RhcnRzd2l0aCglMjJodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyMikpJTBBJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoJTBBJTIwJTIwJTIwJTIwY2h1bmtfc2l6ZSUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcGFyYXRvcnMlM0QlNUIlMjIlNUNuJTVDbiUyMiUyQyUyMCUyMiU1Q24lMjIlMkMlMjAlMjIuJTIyJTJDJTIwJTIyJTIwJTIyJTJDJTIwJTIyJTIyJTVEJTJDJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3Mp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)`,wrap:!1}}),W=new K({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBSZXRyaWV2ZXJUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMnJldHJpZXZlciUyMiUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTIwJTNEJTIwJTIyVXNlcyUyMHNlbWFudGljJTIwc2VhcmNoJTIwdG8lMjByZXRyaWV2ZSUyMHRoZSUyMHBhcnRzJTIwb2YlMjB0cmFuc2Zvcm1lcnMlMjBkb2N1bWVudGF0aW9uJTIwdGhhdCUyMGNvdWxkJTIwYmUlMjBtb3N0JTIwcmVsZXZhbnQlMjB0byUyMGFuc3dlciUyMHlvdXIlMjBxdWVyeS4lMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMlRoZSUyMHF1ZXJ5JTIwdG8lMjBwZXJmb3JtLiUyMFRoaXMlMjBzaG91bGQlMjBiZSUyMHNlbWFudGljYWxseSUyMGNsb3NlJTIwdG8lMjB5b3VyJTIwdGFyZ2V0JTIwZG9jdW1lbnRzLiUyMFVzZSUyMHRoZSUyMGFmZmlybWF0aXZlJTIwZm9ybSUyMHJhdGhlciUyMHRoYW4lMjBhJTIwcXVlc3Rpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlMjAlM0QlMjAlMjJzdHJpbmclMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwZG9jcyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZXRyaWV2ZXIlMjAlM0QlMjBCTTI1UmV0cmlldmVyLmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3MlMkMlMjBrJTNEMTAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwcXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydCUyMGlzaW5zdGFuY2UocXVlcnklMkMlMjBzdHIpJTJDJTIwJTIyWW91ciUyMHNlYXJjaCUyMHF1ZXJ5JTIwbXVzdCUyMGJlJTIwYSUyMHN0cmluZyUyMiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3MlMjAlM0QlMjBzZWxmLnJldHJpZXZlci5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDblJldHJpZXZlZCUyMGRvY3VtZW50cyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTVDbiU1Q24lM0QlM0QlM0QlM0QlM0QlMjBEb2N1bWVudCUyMCU3QnN0cihpKSU3RCUyMCUzRCUzRCUzRCUzRCUzRCU1Q24lMjIlMjAlMkIlMjBkb2MucGFnZV9jb250ZW50JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKGRvY3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbChkb2NzX3Byb2Nlc3NlZCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),z=new K({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIpJTJDJTIwbWF4X3N0ZXBzJTNENCUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(
    tools=[retriever_tool], model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>), max_steps=<span class="hljs-number">4</span>, verbosity_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),P=new K({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkZvciUyMGElMjB0cmFuc2Zvcm1lcnMlMjBtb2RlbCUyMHRyYWluaW5nJTJDJTIwd2hpY2glMjBpcyUyMHNsb3dlciUyQyUyMHRoZSUyMGZvcndhcmQlMjBvciUyMHRoZSUyMGJhY2t3YXJkJTIwcGFzcyUzRiUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`agent_output = agent.run(<span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),D=new ft({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/hi/examples/rag.md"}}),{c(){T=M("meta"),tl=n(),O=M("p"),el=n(),i(m.$$.fragment),sl=n(),i(w.$$.fragment),nl=n(),i(j.$$.fragment),al=n(),U=M("p"),U.textContent=$l,Ml=n(),b=M("p"),b.textContent=Ql,pl=n(),I=M("ul"),I.innerHTML=ql,ol=n(),d=M("p"),d.textContent=El,il=n(),h=M("p"),h.textContent=Sl,rl=n(),f=M("p"),f.textContent=Fl,yl=n(),C=M("ul"),C.innerHTML=zl,cl=n(),v=M("p"),v.textContent=Ll,ul=n(),Z=M("p"),Z.textContent=Yl,Jl=n(),i(g.$$.fragment),Tl=n(),B=M("p"),B.innerHTML=Pl,ml=n(),i(_.$$.fragment),wl=n(),A=M("p"),A.innerHTML=Dl,jl=n(),R=M("p"),R.textContent=Kl,Ul=n(),k=M("p"),k.innerHTML=Ol,bl=n(),i(x.$$.fragment),Il=n(),G=M("p"),G.textContent=lt,dl=n(),N=M("p"),N.textContent=tt,hl=n(),H=M("p"),H.textContent=et,fl=n(),V=M("p"),V.innerHTML=st,Cl=n(),i(W.$$.fragment),vl=n(),X=M("p"),X.innerHTML=nt,Zl=n(),$=M("p"),$.innerHTML=at,gl=n(),Q=M("p"),Q.textContent=Mt,Bl=n(),q=M("ul"),q.innerHTML=pt,_l=n(),E=M("p"),E.innerHTML=ot,Al=n(),S=M("ul"),S.innerHTML=it,Rl=n(),F=M("p"),F.innerHTML=rt,kl=n(),i(z.$$.fragment),xl=n(),L=M("p"),L.textContent=yt,Gl=n(),Y=M("p"),Y.innerHTML=ct,Nl=n(),i(P.$$.fragment),Hl=n(),i(D.$$.fragment),Vl=n(),ll=M("p"),this.h()},l(l){const t=bt("svelte-u9bgzb",document.head);T=p(t,"META",{name:!0,content:!0}),t.forEach(e),tl=a(l),O=p(l,"P",{}),ut(O).forEach(e),el=a(l),r(m.$$.fragment,l),sl=a(l),r(w.$$.fragment,l),nl=a(l),r(j.$$.fragment,l),al=a(l),U=p(l,"P",{"data-svelte-h":!0}),o(U)!=="svelte-eiyiql"&&(U.textContent=$l),Ml=a(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1vx3frp"&&(b.textContent=Ql),pl=a(l),I=p(l,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1cx8z1h"&&(I.innerHTML=ql),ol=a(l),d=p(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-11qeq87"&&(d.textContent=El),il=a(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-15q445b"&&(h.textContent=Sl),rl=a(l),f=p(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1ejqtel"&&(f.textContent=Fl),yl=a(l),C=p(l,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-58t37f"&&(C.innerHTML=zl),cl=a(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-16norjw"&&(v.textContent=Ll),ul=a(l),Z=p(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1ddf4ml"&&(Z.textContent=Yl),Jl=a(l),r(g.$$.fragment,l),Tl=a(l),B=p(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1mcxwml"&&(B.innerHTML=Pl),ml=a(l),r(_.$$.fragment,l),wl=a(l),A=p(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1426897"&&(A.innerHTML=Dl),jl=a(l),R=p(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1j0hesu"&&(R.textContent=Kl),Ul=a(l),k=p(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-cyty5h"&&(k.innerHTML=Ol),bl=a(l),r(x.$$.fragment,l),Il=a(l),G=p(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-i2pe8h"&&(G.textContent=lt),dl=a(l),N=p(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ax8jgo"&&(N.textContent=tt),hl=a(l),H=p(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-sxcnrp"&&(H.textContent=et),fl=a(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-10aecmv"&&(V.innerHTML=st),Cl=a(l),r(W.$$.fragment,l),vl=a(l),X=p(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1j07fca"&&(X.innerHTML=nt),Zl=a(l),$=p(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-671qrx"&&($.innerHTML=at),gl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-16300v8"&&(Q.textContent=Mt),Bl=a(l),q=p(l,"UL",{"data-svelte-h":!0}),o(q)!=="svelte-1q0jors"&&(q.innerHTML=pt),_l=a(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1pu1ttb"&&(E.innerHTML=ot),Al=a(l),S=p(l,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-fyjm9g"&&(S.innerHTML=it),Rl=a(l),F=p(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ybjmzq"&&(F.innerHTML=rt),kl=a(l),r(z.$$.fragment,l),xl=a(l),L=p(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-py4gku"&&(L.textContent=yt),Gl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ixhz84"&&(Y.innerHTML=ct),Nl=a(l),r(P.$$.fragment,l),Hl=a(l),r(D.$$.fragment,l),Vl=a(l),ll=p(l,"P",{}),ut(ll).forEach(e),this.h()},h(){Jt(T,"name","hf:doc:metadata"),Jt(T,"content",Zt)},m(l,t){It(document.head,T),s(l,tl,t),s(l,O,t),s(l,el,t),y(m,l,t),s(l,sl,t),y(w,l,t),s(l,nl,t),y(j,l,t),s(l,al,t),s(l,U,t),s(l,Ml,t),s(l,b,t),s(l,pl,t),s(l,I,t),s(l,ol,t),s(l,d,t),s(l,il,t),s(l,h,t),s(l,rl,t),s(l,f,t),s(l,yl,t),s(l,C,t),s(l,cl,t),s(l,v,t),s(l,ul,t),s(l,Z,t),s(l,Jl,t),y(g,l,t),s(l,Tl,t),s(l,B,t),s(l,ml,t),y(_,l,t),s(l,wl,t),s(l,A,t),s(l,jl,t),s(l,R,t),s(l,Ul,t),s(l,k,t),s(l,bl,t),y(x,l,t),s(l,Il,t),s(l,G,t),s(l,dl,t),s(l,N,t),s(l,hl,t),s(l,H,t),s(l,fl,t),s(l,V,t),s(l,Cl,t),y(W,l,t),s(l,vl,t),s(l,X,t),s(l,Zl,t),s(l,$,t),s(l,gl,t),s(l,Q,t),s(l,Bl,t),s(l,q,t),s(l,_l,t),s(l,E,t),s(l,Al,t),s(l,S,t),s(l,Rl,t),s(l,F,t),s(l,kl,t),y(z,l,t),s(l,xl,t),s(l,L,t),s(l,Gl,t),s(l,Y,t),s(l,Nl,t),y(P,l,t),s(l,Hl,t),y(D,l,t),s(l,Vl,t),s(l,ll,t),Wl=!0},p:mt,i(l){Wl||(c(m.$$.fragment,l),c(w.$$.fragment,l),c(j.$$.fragment,l),c(g.$$.fragment,l),c(_.$$.fragment,l),c(x.$$.fragment,l),c(W.$$.fragment,l),c(z.$$.fragment,l),c(P.$$.fragment,l),c(D.$$.fragment,l),Wl=!0)},o(l){u(m.$$.fragment,l),u(w.$$.fragment,l),u(j.$$.fragment,l),u(g.$$.fragment,l),u(_.$$.fragment,l),u(x.$$.fragment,l),u(W.$$.fragment,l),u(z.$$.fragment,l),u(P.$$.fragment,l),u(D.$$.fragment,l),Wl=!1},d(l){l&&(e(tl),e(O),e(el),e(sl),e(nl),e(al),e(U),e(Ml),e(b),e(pl),e(I),e(ol),e(d),e(il),e(h),e(rl),e(f),e(yl),e(C),e(cl),e(v),e(ul),e(Z),e(Jl),e(Tl),e(B),e(ml),e(wl),e(A),e(jl),e(R),e(Ul),e(k),e(bl),e(Il),e(G),e(dl),e(N),e(hl),e(H),e(fl),e(V),e(Cl),e(vl),e(X),e(Zl),e($),e(gl),e(Q),e(Bl),e(q),e(_l),e(E),e(Al),e(S),e(Rl),e(F),e(kl),e(xl),e(L),e(Gl),e(Y),e(Nl),e(Hl),e(Vl),e(ll)),e(T),J(m,l),J(w,l),J(j,l),J(g,l),J(_,l),J(x,l),J(W,l),J(z,l),J(P,l),J(D,l)}}}const Zt='{"title":"एजेंटिक RAG","local":"एजटक-rag","sections":[],"depth":1}';function gt(Xl){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends jt{constructor(T){super(),Ut(this,T,gt,vt,Tt,{})}}export{xt as component};
