# Agents（智能体）

<Tip warning={true}>

Smolagents 是一个实验性的 API，可能会随时发生变化。由于 API 或底层模型可能发生变化，代理返回的结果也可能有所不同。

</Tip>

要了解有关智能体和工具的更多信息，请务必阅读[入门指南](../index)。本页面包含基础类的 API 文档。

## 智能体（Agents）

我们的智能体继承自 [MultiStepAgent](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.MultiStepAgent)，这意味着它们可以执行多步操作，每一步包含一个思考（thought），然后是一个工具调用和执行。请阅读[概念指南](../conceptual_guides/react)以了解更多信息。

我们提供两种类型的代理，它们基于主要的 `Agent` 类：
  - [CodeAgent](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.CodeAgent) 是默认代理，它以 Python 代码编写工具调用。
  - [ToolCallingAgent](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.ToolCallingAgent) 以 JSON 编写工具调用。

两者在初始化时都需要提供参数 `model` 和工具列表 `tools`。

### 智能体类[[smolagents.MultiStepAgent]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.MultiStepAgent</name><anchor>smolagents.MultiStepAgent</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L266</source><parameters>[{"name": "tools", "val": ": list"}, {"name": "model", "val": ": Model"}, {"name": "prompt_templates", "val": ": smolagents.agents.PromptTemplates | None = None"}, {"name": "instructions", "val": ": str | None = None"}, {"name": "max_steps", "val": ": int = 20"}, {"name": "add_base_tools", "val": ": bool = False"}, {"name": "verbosity_level", "val": ": LogLevel = <LogLevel.INFO: 1>"}, {"name": "managed_agents", "val": ": list | None = None"}, {"name": "step_callbacks", "val": ": list[collections.abc.Callable] | dict[typing.Type[smolagents.memory.MemoryStep], collections.abc.Callable | list[collections.abc.Callable]] | None = None"}, {"name": "planning_interval", "val": ": int | None = None"}, {"name": "name", "val": ": str | None = None"}, {"name": "description", "val": ": str | None = None"}, {"name": "provide_run_summary", "val": ": bool = False"}, {"name": "final_answer_checks", "val": ": list[collections.abc.Callable] | None = None"}, {"name": "return_full_result", "val": ": bool = False"}, {"name": "logger", "val": ": smolagents.monitoring.AgentLogger | None = None"}]</parameters><paramsdesc>- **tools** (`list[Tool]`) -- [Tool](/docs/smolagents/v1.22.0/zh/reference/tools#smolagents.Tool)s that the agent can use.
- **model** (`Callable[[list[dict[str, str]]], ChatMessage]`) -- Model that will generate the agent's actions.
- **prompt_templates** ([PromptTemplates](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.PromptTemplates), *optional*) -- Prompt templates.
- **instructions** (`str`, *optional*) -- Custom instructions for the agent, will be inserted in the system prompt.
- **max_steps** (`int`, default `20`) -- Maximum number of steps the agent can take to solve the task.
- **add_base_tools** (`bool`, default `False`) -- Whether to add the base tools to the agent's tools.
- **verbosity_level** (`LogLevel`, default `LogLevel.INFO`) -- Level of verbosity of the agent's logs.
- **managed_agents** (`list`, *optional*) -- Managed agents that the agent can call.
- **step_callbacks** (`list[Callable]` | `dict[Type[MemoryStep], Callable | list[Callable]]`, *optional*) -- Callbacks that will be called at each step.
- **planning_interval** (`int`, *optional*) -- Interval at which the agent will run a planning step.
- **name** (`str`, *optional*) -- Necessary for a managed agent only - the name by which this agent can be called.
- **description** (`str`, *optional*) -- Necessary for a managed agent only - the description of this agent.
- **provide_run_summary** (`bool`, *optional*) -- Whether to provide a run summary when called as a managed agent.
- **final_answer_checks** (`list[Callable]`, *optional*) -- List of validation functions to run before accepting a final answer.
  Each function should:
  - Take the final answer and the agent's memory as arguments.
  - Return a boolean indicating whether the final answer is valid.
- **return_full_result** (`bool`, default `False`) -- Whether to return the full `RunResult` object or just the final answer output from the agent run.</paramsdesc><paramgroups>0</paramgroups></docstring>

Agent class that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of action (given by the LLM) and observation (obtained from the environment).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>extract_action</name><anchor>smolagents.MultiStepAgent.extract_action</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L783</source><parameters>[{"name": "model_output", "val": ": str"}, {"name": "split_token", "val": ": str"}]</parameters><paramsdesc>- **model_output** (`str`) -- Output of the LLM
- **split_token** (`str`) -- Separator for the action. Should match the example in the system prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Parse action from the LLM output




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_dict</name><anchor>smolagents.MultiStepAgent.from_dict</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1004</source><parameters>[{"name": "agent_dict", "val": ": dict"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **agent_dict** (`dict[str, Any]`) -- Dictionary representation of the agent.
- ****kwargs** -- Additional keyword arguments that will override agent_dict values.</paramsdesc><paramgroups>0</paramgroups><rettype>`MultiStepAgent`</rettype><retdesc>Instance of the agent class.</retdesc></docstring>
Create agent from a dictionary representation.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_folder</name><anchor>smolagents.MultiStepAgent.from_folder</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1102</source><parameters>[{"name": "folder", "val": ": str | pathlib.Path"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **folder** (`str` or `Path`) -- The folder where the agent is saved.
- ****kwargs** -- Additional keyword arguments that will be passed to the agent's init.</paramsdesc><paramgroups>0</paramgroups></docstring>
Loads an agent from a local folder.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_hub</name><anchor>smolagents.MultiStepAgent.from_hub</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1048</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "token", "val": ": str | None = None"}, {"name": "trust_remote_code", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The name of the repo on the Hub where your tool is defined.
- **token** (`str`, *optional*) --
  The token to identify you on hf.co. If unset, will use the token generated when running
  `huggingface-cli login` (stored in `~/.huggingface`).
- **trust_remote_code(`bool`,** *optional*, defaults to False) --
  This flags marks that you understand the risk of running remote code and that you trust this tool.
  If not setting this to True, loading the tool from Hub will fail.
- **kwargs** (additional keyword arguments, *optional*) --
  Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
  `cache_dir`, `revision`, `subfolder`) will be used when downloading the files for your agent, and the
  others will be passed along to its init.</paramsdesc><paramgroups>0</paramgroups></docstring>

Loads an agent defined on the Hub.

<Tip warning={true}>

Loading a tool from the Hub means that you'll download the tool and execute it locally.
ALWAYS inspect the tool you're downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.

</Tip>




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>initialize_system_prompt</name><anchor>smolagents.MultiStepAgent.initialize_system_prompt</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L743</source><parameters>[]</parameters></docstring>
To be implemented in child classes

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>interrupt</name><anchor>smolagents.MultiStepAgent.interrupt</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L748</source><parameters>[]</parameters></docstring>
Interrupts the agent execution.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>provide_final_answer</name><anchor>smolagents.MultiStepAgent.provide_final_answer</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L804</source><parameters>[{"name": "task", "val": ": str"}]</parameters><paramsdesc>- **task** (`str`) -- Task to perform.
- **images** (`list[PIL.Image.Image]`, *optional*) -- Image(s) objects.</paramsdesc><paramgroups>0</paramgroups><rettype>`str`</rettype><retdesc>Final answer to the task.</retdesc></docstring>

Provide the final answer to the task, based on the logs of the agent's interactions.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>push_to_hub</name><anchor>smolagents.MultiStepAgent.push_to_hub</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1134</source><parameters>[{"name": "repo_id", "val": ": str"}, {"name": "commit_message", "val": ": str = 'Upload agent'"}, {"name": "private", "val": ": bool | None = None"}, {"name": "token", "val": ": bool | str | None = None"}, {"name": "create_pr", "val": ": bool = False"}]</parameters><paramsdesc>- **repo_id** (`str`) --
  The name of the repository you want to push to. It should contain your organization name when
  pushing to a given organization.
- **commit_message** (`str`, *optional*, defaults to `"Upload agent"`) --
  Message to commit while pushing.
- **private** (`bool`, *optional*, defaults to `None`) --
  Whether to make the repo private. If `None`, the repo will be public unless the organization's default is private. This value is ignored if the repo already exists.
- **token** (`bool` or `str`, *optional*) --
  The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
  when running `huggingface-cli login` (stored in `~/.huggingface`).
- **create_pr** (`bool`, *optional*, defaults to `False`) --
  Whether to create a PR with the uploaded files or directly commit.</paramsdesc><paramgroups>0</paramgroups></docstring>

Upload the agent to the Hub.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>replay</name><anchor>smolagents.MultiStepAgent.replay</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L853</source><parameters>[{"name": "detailed", "val": ": bool = False"}]</parameters><paramsdesc>- **detailed** (bool, optional) -- If True, also displays the memory at each step. Defaults to False.
  Careful: will increase log length exponentially. Use only for debugging.</paramsdesc><paramgroups>0</paramgroups></docstring>
Prints a pretty replay of the agent's steps.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>run</name><anchor>smolagents.MultiStepAgent.run</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L433</source><parameters>[{"name": "task", "val": ": str"}, {"name": "stream", "val": ": bool = False"}, {"name": "reset", "val": ": bool = True"}, {"name": "images", "val": ": list['PIL.Image.Image'] | None = None"}, {"name": "additional_args", "val": ": dict | None = None"}, {"name": "max_steps", "val": ": int | None = None"}, {"name": "return_full_result", "val": ": bool | None = None"}]</parameters><paramsdesc>- **task** (`str`) -- Task to perform.
- **stream** (`bool`) -- Whether to run in streaming mode.
  If `True`, returns a generator that yields each step as it is executed. You must iterate over this generator to process the individual steps (e.g., using a for loop or `next()`).
  If `False`, executes all steps internally and returns only the final answer after completion.
- **reset** (`bool`) -- Whether to reset the conversation or keep it going from previous run.
- **images** (`list[PIL.Image.Image]`, *optional*) -- Image(s) objects.
- **additional_args** (`dict`, *optional*) -- Any other variables that you want to pass to the agent run, for instance images or dataframes. Give them clear names!
- **max_steps** (`int`, *optional*) -- Maximum number of steps the agent can take to solve the task. if not provided, will use the agent's default value.
- **return_full_result** (`bool`, *optional*) -- Whether to return the full `RunResult` object or just the final answer output.
  If `None` (default), the agent's `self.return_full_result` setting is used.</paramsdesc><paramgroups>0</paramgroups></docstring>

Run the agent for the given task.



<ExampleCodeBlock anchor="smolagents.MultiStepAgent.run.example">

Example:
```py
from smolagents import CodeAgent
agent = CodeAgent(tools=[])
agent.run("What is the result of 2 power 3.7384?")
```

</ExampleCodeBlock>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>save</name><anchor>smolagents.MultiStepAgent.save</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L886</source><parameters>[{"name": "output_dir", "val": ": str | pathlib.Path"}, {"name": "relative_path", "val": ": str | None = None"}]</parameters><paramsdesc>- **output_dir** (`str` or `Path`) -- The folder in which you want to save your agent.</paramsdesc><paramgroups>0</paramgroups></docstring>

Saves the relevant code files for your agent. This will copy the code of your agent in `output_dir` as well as autogenerate:

- a `tools` folder containing the logic for each of the tools under `tools/{tool_name}.py`.
- a `managed_agents` folder containing the logic for each of the managed agents.
- an `agent.json` file containing a dictionary representing your agent.
- a `prompt.yaml` file containing the prompt templates used by your agent.
- an `app.py` file providing a UI for your agent when it is exported to a Space with `agent.push_to_hub()`
- a `requirements.txt` containing the names of the modules used by your tool (as detected when inspecting its
  code)




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>smolagents.MultiStepAgent.step</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L776</source><parameters>[{"name": "memory_step", "val": ": ActionStep"}]</parameters></docstring>

Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
Returns either None if the step is not final, or the final answer.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>to_dict</name><anchor>smolagents.MultiStepAgent.to_dict</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L964</source><parameters>[]</parameters><rettype>`dict`</rettype><retdesc>Dictionary representation of the agent.</retdesc></docstring>
Convert the agent to a dictionary representation.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>visualize</name><anchor>smolagents.MultiStepAgent.visualize</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L849</source><parameters>[]</parameters></docstring>
Creates a rich tree visualization of the agent's structure.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>write_memory_to_messages</name><anchor>smolagents.MultiStepAgent.write_memory_to_messages</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L752</source><parameters>[{"name": "summary_mode", "val": ": bool = False"}]</parameters></docstring>

Reads past llm_outputs, actions, and observations or errors from the memory into a series of messages
that can be used as input to the LLM. Adds a number of keywords (such as PLAN, error, etc) to help
the LLM.


</div></div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.CodeAgent</name><anchor>smolagents.CodeAgent</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1483</source><parameters>[{"name": "tools", "val": ": list"}, {"name": "model", "val": ": Model"}, {"name": "prompt_templates", "val": ": smolagents.agents.PromptTemplates | None = None"}, {"name": "additional_authorized_imports", "val": ": list[str] | None = None"}, {"name": "planning_interval", "val": ": int | None = None"}, {"name": "executor_type", "val": ": typing.Literal['local', 'e2b', 'modal', 'docker', 'wasm'] = 'local'"}, {"name": "executor_kwargs", "val": ": dict[str, typing.Any] | None = None"}, {"name": "max_print_outputs_length", "val": ": int | None = None"}, {"name": "stream_outputs", "val": ": bool = False"}, {"name": "use_structured_outputs_internally", "val": ": bool = False"}, {"name": "code_block_tags", "val": ": str | tuple[str, str] | None = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **tools** (`list[Tool]`) -- [Tool](/docs/smolagents/v1.22.0/zh/reference/tools#smolagents.Tool)s that the agent can use.
- **model** (`Model`) -- Model that will generate the agent's actions.
- **prompt_templates** ([PromptTemplates](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.PromptTemplates), *optional*) -- Prompt templates.
- **additional_authorized_imports** (`list[str]`, *optional*) -- Additional authorized imports for the agent.
- **planning_interval** (`int`, *optional*) -- Interval at which the agent will run a planning step.
- **executor_type** (`Literal["local", "e2b", "modal", "docker", "wasm"]`, default `"local"`) -- Type of code executor.
- **executor_kwargs** (`dict`, *optional*) -- Additional arguments to pass to initialize the executor.
- **max_print_outputs_length** (`int`, *optional*) -- Maximum length of the print outputs.
- **stream_outputs** (`bool`, *optional*, default `False`) -- Whether to stream outputs during execution.
- **use_structured_outputs_internally** (`bool`, default `False`) -- Whether to use structured generation at each action step: improves performance for many models.

  <Added version="1.17.0"/>
- **code_block_tags** (`tuple[str, str]` | `Literal["markdown"]`, *optional*) -- Opening and closing tags for code blocks (regex strings). Pass a custom tuple, or pass 'markdown' to use ("```(?:python|py)", "\n```"), leave empty to use ("<code>", "</code>").
- ****kwargs** -- Additional keyword arguments.</paramsdesc><paramgroups>0</paramgroups></docstring>

In this agent, the tool calls will be formulated by the LLM in code format, then parsed and executed.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>cleanup</name><anchor>smolagents.CodeAgent.cleanup</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1571</source><parameters>[]</parameters></docstring>
Clean up resources used by the agent, such as the remote Python executor.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_dict</name><anchor>smolagents.CodeAgent.from_dict</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1754</source><parameters>[{"name": "agent_dict", "val": ": dict"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **agent_dict** (`dict[str, Any]`) -- Dictionary representation of the agent.
- ****kwargs** -- Additional keyword arguments that will override agent_dict values.</paramsdesc><paramgroups>0</paramgroups><rettype>`CodeAgent`</rettype><retdesc>Instance of the CodeAgent class.</retdesc></docstring>
Create CodeAgent from a dictionary representation.








</div></div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.ToolCallingAgent</name><anchor>smolagents.ToolCallingAgent</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1189</source><parameters>[{"name": "tools", "val": ": list"}, {"name": "model", "val": ": Model"}, {"name": "prompt_templates", "val": ": smolagents.agents.PromptTemplates | None = None"}, {"name": "planning_interval", "val": ": int | None = None"}, {"name": "stream_outputs", "val": ": bool = False"}, {"name": "max_tool_threads", "val": ": int | None = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **tools** (`list[Tool]`) -- [Tool](/docs/smolagents/v1.22.0/zh/reference/tools#smolagents.Tool)s that the agent can use.
- **model** (`Model`) -- Model that will generate the agent's actions.
- **prompt_templates** ([PromptTemplates](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.PromptTemplates), *optional*) -- Prompt templates.
- **planning_interval** (`int`, *optional*) -- Interval at which the agent will run a planning step.
- **stream_outputs** (`bool`, *optional*, default `False`) -- Whether to stream outputs during execution.
- **max_tool_threads** (`int`, *optional*) -- Maximum number of threads for parallel tool calls.
  Higher values increase concurrency but resource usage as well.
  Defaults to `ThreadPoolExecutor`'s default.
- ****kwargs** -- Additional keyword arguments.</paramsdesc><paramgroups>0</paramgroups></docstring>

This agent uses JSON-like tool calls, using method `model.get_tool_call` to leverage the LLM engine's tool calling capabilities.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>execute_tool_call</name><anchor>smolagents.ToolCallingAgent.execute_tool_call</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1431</source><parameters>[{"name": "tool_name", "val": ": str"}, {"name": "arguments", "val": ": dict[str, str] | str"}]</parameters><paramsdesc>- **tool_name** (`str`) -- Name of the tool or managed agent to execute.
- **arguments** (dict[str, str] | str) -- Arguments passed to the tool call.</paramsdesc><paramgroups>0</paramgroups></docstring>

Execute a tool or managed agent with the provided arguments.

The arguments are replaced with the actual values from the state if they refer to state variables.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>process_tool_calls</name><anchor>smolagents.ToolCallingAgent.process_tool_calls</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L1340</source><parameters>[{"name": "chat_message", "val": ": ChatMessage"}, {"name": "memory_step", "val": ": ActionStep"}]</parameters><paramsdesc>- **chat_message** (`ChatMessage`) -- Chat message containing tool calls from the model.
- **memory_step** (`ActionStep)` -- Memory ActionStep to update with results.</paramsdesc><paramgroups>0</paramgroups><yieldtype>`ToolCall | ToolOutput`</yieldtype><yielddesc>The tool call or tool output.</yielddesc></docstring>
Process tool calls from the model output and update agent memory.








</div></div>

### stream_to_gradio[[smolagents.stream_to_gradio]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>smolagents.stream_to_gradio</name><anchor>smolagents.stream_to_gradio</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/gradio_ui.py#L248</source><parameters>[{"name": "agent", "val": ""}, {"name": "task", "val": ": str"}, {"name": "task_images", "val": ": list | None = None"}, {"name": "reset_agent_memory", "val": ": bool = False"}, {"name": "additional_args", "val": ": dict | None = None"}]</parameters></docstring>
Runs an agent with the given task and streams the messages from the agent as gradio ChatMessages.

</div>

### GradioUI[[smolagents.GradioUI]]

> [!TIP]
> 您必须安装 `gradio` 才能使用 UI。如果尚未安装，请运行 `pip install 'smolagents[gradio]'`。

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.GradioUI</name><anchor>smolagents.GradioUI</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/gradio_ui.py#L279</source><parameters>[{"name": "agent", "val": ": MultiStepAgent"}, {"name": "file_upload_folder", "val": ": str | None = None"}, {"name": "reset_agent_memory", "val": ": bool = False"}]</parameters><paramsdesc>- **agent** ([MultiStepAgent](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.MultiStepAgent)) -- The agent to interact with.
- **file_upload_folder** (`str`, *optional*) -- The folder where uploaded files will be saved.
  If not provided, file uploads are disabled.
- **reset_agent_memory** (`bool`, *optional*, defaults to `False`) -- Whether to reset the agent's memory at the start of each interaction.
  If `True`, the agent will not remember previous interactions.</paramsdesc><paramgroups>0</paramgroups><raises>- ``ModuleNotFoundError`` -- If the `gradio` extra is not installed.</raises><raisederrors>``ModuleNotFoundError``</raisederrors></docstring>

Gradio interface for interacting with a [MultiStepAgent](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.MultiStepAgent).

This class provides a web interface to interact with the agent in real-time, allowing users to submit prompts, upload files, and receive responses in a chat-like format.
It  can reset the agent's memory at the start of each interaction if desired.
It supports file uploads, which are saved to a specified folder.
It uses the `gradio.Chatbot` component to display the conversation history.
This class requires the `gradio` extra to be installed: `pip install 'smolagents[gradio]'`.







<ExampleCodeBlock anchor="smolagents.GradioUI.example">

Example:
```python
from smolagents import CodeAgent, GradioUI, InferenceClientModel

model = InferenceClientModel(model_id="meta-llama/Meta-Llama-3.1-8B-Instruct")
agent = CodeAgent(tools=[], model=model)
gradio_ui = GradioUI(agent, file_upload_folder="uploads", reset_agent_memory=True)
gradio_ui.launch()
```

</ExampleCodeBlock>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>launch</name><anchor>smolagents.GradioUI.launch</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/gradio_ui.py#L406</source><parameters>[{"name": "share", "val": ": bool = True"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **share** (`bool`, defaults to `True`) -- Whether to share the app publicly.
- ****kwargs** -- Additional keyword arguments to pass to the Gradio launch method.</paramsdesc><paramgroups>0</paramgroups></docstring>

Launch the Gradio app with the agent interface.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>upload_file</name><anchor>smolagents.GradioUI.upload_file</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/gradio_ui.py#L356</source><parameters>[{"name": "file", "val": ""}, {"name": "file_uploads_log", "val": ""}, {"name": "allowed_file_types", "val": " = None"}]</parameters><paramsdesc>- **file** (`gradio.File`) -- The uploaded file.
- **file_uploads_log** (`list`) -- A list to log uploaded files.
- **allowed_file_types** (`list`, *optional*) -- List of allowed file extensions. Defaults to [".pdf", ".docx", ".txt"].</paramsdesc><paramgroups>0</paramgroups></docstring>

Upload a file and add it to the list of uploaded files in the session state.

The file is saved to the `self.file_upload_folder` folder.
If the file type is not allowed, it returns a message indicating the disallowed file type.




</div></div>

## 提示（Prompts）[[smolagents.PromptTemplates]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.PromptTemplates</name><anchor>smolagents.PromptTemplates</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L164</source><parameters>""</parameters><paramsdesc>- **system_prompt** (`str`) -- System prompt.
- **planning** ([PlanningPromptTemplate](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.PlanningPromptTemplate)) -- Planning prompt templates.
- **managed_agent** ([ManagedAgentPromptTemplate](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.ManagedAgentPromptTemplate)) -- Managed agent prompt templates.
- **final_answer** ([FinalAnswerPromptTemplate](/docs/smolagents/v1.22.0/zh/reference/agents#smolagents.FinalAnswerPromptTemplate)) -- Final answer prompt templates.</paramsdesc><paramgroups>0</paramgroups></docstring>

Prompt templates for the agent.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.PlanningPromptTemplate</name><anchor>smolagents.PlanningPromptTemplate</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L123</source><parameters>""</parameters><paramsdesc>- **plan** (`str`) -- Initial plan prompt.
- **update_plan_pre_messages** (`str`) -- Update plan pre-messages prompt.
- **update_plan_post_messages** (`str`) -- Update plan post-messages prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Prompt templates for the planning step.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.ManagedAgentPromptTemplate</name><anchor>smolagents.ManagedAgentPromptTemplate</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L138</source><parameters>""</parameters><paramsdesc>- **task** (`str`) -- Task prompt.
- **report** (`str`) -- Report prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Prompt templates for the managed agent.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class smolagents.FinalAnswerPromptTemplate</name><anchor>smolagents.FinalAnswerPromptTemplate</anchor><source>https://github.com/huggingface/smolagents/blob/v1.22.0/src/smolagents/agents.py#L151</source><parameters>""</parameters><paramsdesc>- **pre_messages** (`str`) -- Pre-messages prompt.
- **post_messages** (`str`) -- Post-messages prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Prompt templates for the final answer.




</div>

<EditOnGithub source="https://github.com/huggingface/smolagents/blob/main/docs/source/zh/reference/agents.md" />