import{s as Bt,n as vt,o as Gt}from"../chunks/scheduler.85c25b89.js";import{S as Et,i as _t,g as i,s as l,r as o,A as Qt,h as p,f as s,c as n,j as Nt,u as r,x as m,k as kt,y as Xt,a,v as c,d as h,t as M,w as d}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.52fa569e.js";import{H as Y}from"../chunks/Heading.3097d2ed.js";function Rt(ut){let g,H,V,S,j,z,u,Jt=`<strong>Noisy Student Training</strong> is a semi-supervised learning approach. It extends the idea of self-training
and distillation with the use of equal-or-larger student models and noise added to the student during learning. It has three main steps:`,F,J,yt="<li>train a teacher model on labeled images</li> <li>use the teacher to generate pseudo labels on unlabeled images</li> <li>train a student model on the combination of labeled images and pseudo labeled images.</li>",L,y,ft="The algorithm is iterated a few times by treating the student as a teacher to relabel the unlabeled data and training a new student.",q,f,wt="Noisy Student Training seeks to improve on self-training and distillation in two ways. First, it makes the student larger than, or at least equal to, the teacher so the student can better learn from a larger dataset. Second, it adds noise to the student so the noised student is forced to learn harder from the pseudo labels. To noise the student, it uses input noise such as RandAugment data augmentation, and model noise such as dropout and stochastic depth during training.",P,w,D,T,Tt="To load a pretrained model:",K,b,O,U,bt="To load and preprocess the image:",tt,I,et,Z,Ut="To get the model predictions:",st,$,at,C,It="To get the top-5 predictions class names:",lt,x,nt,W,Zt="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ns</code>. You can find the IDs in the model summaries at the top of this page.",it,N,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,k,mt,B,Ct="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ot,v,rt,G,xt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ct,E,ht,_,Wt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Mt,Q,dt,X,gt,A,jt;return j=new Y({props:{title:"Noisy Student (EfficientNet)",local:"noisy-student-efficientnet",headingTag:"h1"}}),w=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9ucyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX25zJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new R({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBzZWxmdHJhaW5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlNlbGYtdHJhaW5pbmclMjB3aXRoJTIwTm9pc3klMjBTdHVkZW50JTIwaW1wcm92ZXMlMjBJbWFnZU5ldCUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUWl6aGUlMjBYaWUlMjBhbmQlMjBNaW5oLVRoYW5nJTIwTHVvbmclMjBhbmQlMjBFZHVhcmQlMjBIb3Z5JTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MTEuMDQyNTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5MRyU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{xie2020selftraining,
      title={Self-training with Noisy Student improves ImageNet classification}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qizhe Xie and Minh-Thang Luong and Eduard Hovy and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1911.04252}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){g=i("meta"),H=l(),V=i("p"),S=l(),o(j.$$.fragment),z=l(),u=i("p"),u.innerHTML=Jt,F=l(),J=i("ol"),J.innerHTML=yt,L=l(),y=i("p"),y.textContent=ft,q=l(),f=i("p"),f.textContent=wt,P=l(),o(w.$$.fragment),D=l(),T=i("p"),T.textContent=Tt,K=l(),o(b.$$.fragment),O=l(),U=i("p"),U.textContent=bt,tt=l(),o(I.$$.fragment),et=l(),Z=i("p"),Z.textContent=Ut,st=l(),o($.$$.fragment),at=l(),C=i("p"),C.textContent=It,lt=l(),o(x.$$.fragment),nt=l(),W=i("p"),W.innerHTML=Zt,it=l(),N=i("p"),N.innerHTML=$t,pt=l(),o(k.$$.fragment),mt=l(),B=i("p"),B.textContent=Ct,ot=l(),o(v.$$.fragment),rt=l(),G=i("p"),G.innerHTML=xt,ct=l(),o(E.$$.fragment),ht=l(),_=i("p"),_.innerHTML=Wt,Mt=l(),o(Q.$$.fragment),dt=l(),o(X.$$.fragment),gt=l(),A=i("p"),this.h()},l(t){const e=Qt("svelte-u9bgzb",document.head);g=p(e,"META",{name:!0,content:!0}),e.forEach(s),H=n(t),V=p(t,"P",{}),Nt(V).forEach(s),S=n(t),r(j.$$.fragment,t),z=n(t),u=p(t,"P",{"data-svelte-h":!0}),m(u)!=="svelte-zn3ycx"&&(u.innerHTML=Jt),F=n(t),J=p(t,"OL",{"data-svelte-h":!0}),m(J)!=="svelte-1nvijn1"&&(J.innerHTML=yt),L=n(t),y=p(t,"P",{"data-svelte-h":!0}),m(y)!=="svelte-5ws6hn"&&(y.textContent=ft),q=n(t),f=p(t,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1w0q41v"&&(f.textContent=wt),P=n(t),r(w.$$.fragment,t),D=n(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-18ywhxh"&&(T.textContent=Tt),K=n(t),r(b.$$.fragment,t),O=n(t),U=p(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1c2ipa8"&&(U.textContent=bt),tt=n(t),r(I.$$.fragment,t),et=n(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1n9qsq1"&&(Z.textContent=Ut),st=n(t),r($.$$.fragment,t),at=n(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-19cnvx1"&&(C.textContent=It),lt=n(t),r(x.$$.fragment,t),nt=n(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-12tmaxg"&&(W.innerHTML=Zt),it=n(t),N=p(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1wmi3ea"&&(N.innerHTML=$t),pt=n(t),r(k.$$.fragment,t),mt=n(t),B=p(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-9sr7nh"&&(B.textContent=Ct),ot=n(t),r(v.$$.fragment,t),rt=n(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1kguc51"&&(G.innerHTML=xt),ct=n(t),r(E.$$.fragment,t),ht=n(t),_=p(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n0coha"&&(_.innerHTML=Wt),Mt=n(t),r(Q.$$.fragment,t),dt=n(t),r(X.$$.fragment,t),gt=n(t),A=p(t,"P",{}),Nt(A).forEach(s),this.h()},h(){kt(g,"name","hf:doc:metadata"),kt(g,"content",Vt)},m(t,e){Xt(document.head,g),a(t,H,e),a(t,V,e),a(t,S,e),c(j,t,e),a(t,z,e),a(t,u,e),a(t,F,e),a(t,J,e),a(t,L,e),a(t,y,e),a(t,q,e),a(t,f,e),a(t,P,e),c(w,t,e),a(t,D,e),a(t,T,e),a(t,K,e),c(b,t,e),a(t,O,e),a(t,U,e),a(t,tt,e),c(I,t,e),a(t,et,e),a(t,Z,e),a(t,st,e),c($,t,e),a(t,at,e),a(t,C,e),a(t,lt,e),c(x,t,e),a(t,nt,e),a(t,W,e),a(t,it,e),a(t,N,e),a(t,pt,e),c(k,t,e),a(t,mt,e),a(t,B,e),a(t,ot,e),c(v,t,e),a(t,rt,e),a(t,G,e),a(t,ct,e),c(E,t,e),a(t,ht,e),a(t,_,e),a(t,Mt,e),c(Q,t,e),a(t,dt,e),c(X,t,e),a(t,gt,e),a(t,A,e),jt=!0},p:vt,i(t){jt||(h(j.$$.fragment,t),h(w.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(k.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),jt=!0)},o(t){M(j.$$.fragment,t),M(w.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(k.$$.fragment,t),M(v.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),M(X.$$.fragment,t),jt=!1},d(t){t&&(s(H),s(V),s(S),s(z),s(u),s(F),s(J),s(L),s(y),s(q),s(f),s(P),s(D),s(T),s(K),s(O),s(U),s(tt),s(et),s(Z),s(st),s(at),s(C),s(lt),s(nt),s(W),s(it),s(N),s(pt),s(mt),s(B),s(ot),s(rt),s(G),s(ct),s(ht),s(_),s(Mt),s(dt),s(gt),s(A)),s(g),d(j,t),d(w,t),d(b,t),d(I,t),d($,t),d(x,t),d(k,t),d(v,t),d(E,t),d(Q,t),d(X,t)}}}const Vt='{"title":"Noisy Student (EfficientNet)","local":"noisy-student-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function At(ut){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Et{constructor(g){super(),_t(this,g,At,Rt,Bt,{})}}export{Ft as component};
