import{s as Zs,n as Ws,o as Gs}from"../chunks/scheduler.85c25b89.js";import{S as Ns,i as Bs,g as p,s as a,r as m,A as ks,h as i,f as l,c as n,j as Is,u as o,x as j,k as xs,y as vs,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as Y,E as Es}from"../chunks/EditOnGithub.b65eee75.js";function _s(gs){let g,A,V,H,d,S,w,ds='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution layers</a>.',z,y,ws='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',F,J,L,u,ys="To load a pretrained model:",D,T,P,f,Js="To load and preprocess the image:",q,b,K,U,us="To get the model predictions:",O,$,ss,C,Ts="To get the top-5 predictions class names:",ts,I,ls,x,fs="Replace the model name with the variant you want to use, e.g. <code>xception</code>. You can find the IDs in the model summaries at the top of this page.",es,Z,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,ns,G,Us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,N,is,B,$s=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,k,os,v,Cs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',cs,E,rs,_,hs,X,Ms,R,js;return d=new Y({props:{title:"Xception",local:"xception",headingTag:"h1"}}),J=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3hjZXB0aW9uJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgneGNlcHRpb24nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new Q({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElNDBtaXNjJTdCY2hvbGxldDIwMTd4Y2VwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWGNlcHRpb24lM0ElMjBEZWVwJTIwTGVhcm5pbmclMjB3aXRoJTIwRGVwdGh3aXNlJTIwU2VwYXJhYmxlJTIwQ29udm9sdXRpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRnJhbiVDMyVBN29pcyUyMENob2xsZXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE2MTAuMDIzNTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="hljs-variable">@article</span>{<span class="hljs-variable constant_">DBLP</span><span class="hljs-symbol">:journals/corr/ZagoruykoK16</span>,
<span class="hljs-variable">@misc</span>{chollet2017xception,
      title={<span class="hljs-title class_">Xception</span>: <span class="hljs-title class_">Deep</span> <span class="hljs-title class_">Learning</span> with <span class="hljs-title class_">Depthwise</span> <span class="hljs-title class_">Separable</span> <span class="hljs-title class_">Convolutions</span>}, 
      author={<span class="hljs-title class_">Fran</span>çois <span class="hljs-title class_">Chollet</span>},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1610.02357</span>},
      archivePrefix={arXiv},
      primaryClass={cs.<span class="hljs-variable constant_">CV</span>}
}`,wrap:!1}}),X=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/xception.mdx"}}),{c(){g=p("meta"),A=a(),V=p("p"),H=a(),m(d.$$.fragment),S=a(),w=p("p"),w.innerHTML=ds,z=a(),y=p("p"),y.innerHTML=ws,F=a(),m(J.$$.fragment),L=a(),u=p("p"),u.textContent=ys,D=a(),m(T.$$.fragment),P=a(),f=p("p"),f.textContent=Js,q=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=us,O=a(),m($.$$.fragment),ss=a(),C=p("p"),C.textContent=Ts,ts=a(),m(I.$$.fragment),ls=a(),x=p("p"),x.innerHTML=fs,es=a(),Z=p("p"),Z.innerHTML=bs,as=a(),m(W.$$.fragment),ns=a(),G=p("p"),G.textContent=Us,ps=a(),m(N.$$.fragment),is=a(),B=p("p"),B.innerHTML=$s,ms=a(),m(k.$$.fragment),os=a(),v=p("p"),v.innerHTML=Cs,cs=a(),m(E.$$.fragment),rs=a(),m(_.$$.fragment),hs=a(),m(X.$$.fragment),Ms=a(),R=p("p"),this.h()},l(s){const t=ks("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),A=n(s),V=i(s,"P",{}),Is(V).forEach(l),H=n(s),o(d.$$.fragment,s),S=n(s),w=i(s,"P",{"data-svelte-h":!0}),j(w)!=="svelte-s14d2h"&&(w.innerHTML=ds),z=n(s),y=i(s,"P",{"data-svelte-h":!0}),j(y)!=="svelte-1nh6o5x"&&(y.innerHTML=ws),F=n(s),o(J.$$.fragment,s),L=n(s),u=i(s,"P",{"data-svelte-h":!0}),j(u)!=="svelte-18ywhxh"&&(u.textContent=ys),D=n(s),o(T.$$.fragment,s),P=n(s),f=i(s,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1c2ipa8"&&(f.textContent=Js),q=n(s),o(b.$$.fragment,s),K=n(s),U=i(s,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1n9qsq1"&&(U.textContent=us),O=n(s),o($.$$.fragment,s),ss=n(s),C=i(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-19cnvx1"&&(C.textContent=Ts),ts=n(s),o(I.$$.fragment,s),ls=n(s),x=i(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-11ggpx2"&&(x.innerHTML=fs),es=n(s),Z=i(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=bs),as=n(s),o(W.$$.fragment,s),ns=n(s),G=i(s,"P",{"data-svelte-h":!0}),j(G)!=="svelte-9sr7nh"&&(G.textContent=Us),ps=n(s),o(N.$$.fragment,s),is=n(s),B=i(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1kguc51"&&(B.innerHTML=$s),ms=n(s),o(k.$$.fragment,s),os=n(s),v=i(s,"P",{"data-svelte-h":!0}),j(v)!=="svelte-xtxxu6"&&(v.innerHTML=Cs),cs=n(s),o(E.$$.fragment,s),rs=n(s),o(_.$$.fragment,s),hs=n(s),o(X.$$.fragment,s),Ms=n(s),R=i(s,"P",{}),Is(R).forEach(l),this.h()},h(){xs(g,"name","hf:doc:metadata"),xs(g,"content",Xs)},m(s,t){vs(document.head,g),e(s,A,t),e(s,V,t),e(s,H,t),c(d,s,t),e(s,S,t),e(s,w,t),e(s,z,t),e(s,y,t),e(s,F,t),c(J,s,t),e(s,L,t),e(s,u,t),e(s,D,t),c(T,s,t),e(s,P,t),e(s,f,t),e(s,q,t),c(b,s,t),e(s,K,t),e(s,U,t),e(s,O,t),c($,s,t),e(s,ss,t),e(s,C,t),e(s,ts,t),c(I,s,t),e(s,ls,t),e(s,x,t),e(s,es,t),e(s,Z,t),e(s,as,t),c(W,s,t),e(s,ns,t),e(s,G,t),e(s,ps,t),c(N,s,t),e(s,is,t),e(s,B,t),e(s,ms,t),c(k,s,t),e(s,os,t),e(s,v,t),e(s,cs,t),c(E,s,t),e(s,rs,t),c(_,s,t),e(s,hs,t),c(X,s,t),e(s,Ms,t),e(s,R,t),js=!0},p:Ws,i(s){js||(r(d.$$.fragment,s),r(J.$$.fragment,s),r(T.$$.fragment,s),r(b.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(W.$$.fragment,s),r(N.$$.fragment,s),r(k.$$.fragment,s),r(E.$$.fragment,s),r(_.$$.fragment,s),r(X.$$.fragment,s),js=!0)},o(s){h(d.$$.fragment,s),h(J.$$.fragment,s),h(T.$$.fragment,s),h(b.$$.fragment,s),h($.$$.fragment,s),h(I.$$.fragment,s),h(W.$$.fragment,s),h(N.$$.fragment,s),h(k.$$.fragment,s),h(E.$$.fragment,s),h(_.$$.fragment,s),h(X.$$.fragment,s),js=!1},d(s){s&&(l(A),l(V),l(H),l(S),l(w),l(z),l(y),l(F),l(L),l(u),l(D),l(P),l(f),l(q),l(K),l(U),l(O),l(ss),l(C),l(ts),l(ls),l(x),l(es),l(Z),l(as),l(ns),l(G),l(ps),l(is),l(B),l(ms),l(os),l(v),l(cs),l(rs),l(hs),l(Ms),l(R)),l(g),M(d,s),M(J,s),M(T,s),M(b,s),M($,s),M(I,s),M(W,s),M(N,s),M(k,s),M(E,s),M(_,s),M(X,s)}}}const Xs='{"title":"Xception","local":"xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(gs){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Ns{constructor(g){super(),Bs(this,g,Qs,_s,Zs,{})}}export{Hs as component};
