import{s as Zs,n as ks,o as Cs}from"../chunks/scheduler.85c25b89.js";import{S as Bs,i as Ws,g as p,s as e,r as i,A as Ns,h as m,f as l,c as n,j as Us,u as o,x as j,k as $s,y as Is,a,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as A}from"../chunks/CodeBlock.e573519b.js";import{H as V,E as Gs}from"../chunks/getInferenceSnippets.2d2e232c.js";function xs(Ms){let g,S,Y,_,d,R,y,js="<strong>Progressive Neural Architecture Search</strong>, or <strong>PNAS</strong>, is a method for learning the structure of convolutional neural networks (CNNs). It uses a sequential model-based optimization (SMBO) strategy, where we search the space of cell structures, starting with simple (shallow) models and progressing to complex ones, pruning out unpromising structures as we go.",H,u,z,w,gs="To load a pretrained model:",F,J,L,T,ds="To load and preprocess the image:",P,b,q,f,ys="To get the model predictions:",D,U,K,$,us="To get the top-5 predictions class names:",O,Z,ss,k,ws="Replace the model name with the variant you want to use, e.g. <code>pnasnet5large</code>. You can find the IDs in the model summaries at the top of this page.",ts,C,Js='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,B,as,W,Ts="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,N,ns,I,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,ms,x,fs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,E,os,Q,rs,X,cs,v,hs;return d=new V({props:{title:"PNASNet",local:"pnasnet",headingTag:"h1"}}),u=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),J=new A({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3BuYXNuZXQ1bGFyZ2UnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new A({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new A({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new A({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncG5hc25ldDVsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new A({props:{code:"JTQwbWlzYyU3QmxpdTIwMThwcm9ncmVzc2l2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCUHJvZ3Jlc3NpdmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JDaGVueGklMjBMaXUlMjBhbmQlMjBCYXJyZXQlMjBab3BoJTIwYW5kJTIwTWF4aW0lMjBOZXVtYW5uJTIwYW5kJTIwSm9uYXRob24lMjBTaGxlbnMlMjBhbmQlMjBXZWklMjBIdWElMjBhbmQlMjBMaS1KaWElMjBMaSUyMGFuZCUyMExpJTIwRmVpLUZlaSUyMGFuZCUyMEFsYW4lMjBZdWlsbGUlMjBhbmQlMjBKb25hdGhhbiUyMEh1YW5nJTIwYW5kJTIwS2V2aW4lMjBNdXJwaHklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MTIuMDA1NTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{liu2018progressive,
      title={Progressive Neural Architecture Search}, 
      author={Chenxi Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Maxim Neumann <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Wei Hua <span class="hljs-keyword">and </span>Li-<span class="hljs-keyword">Jia </span>Li <span class="hljs-keyword">and </span>Li Fei-Fei <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathan </span>Huang <span class="hljs-keyword">and </span>Kevin Murphy},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1712</span>.<span class="hljs-number">00559</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),X=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/pnasnet.mdx"}}),{c(){g=p("meta"),S=e(),Y=p("p"),_=e(),i(d.$$.fragment),R=e(),y=p("p"),y.innerHTML=js,H=e(),i(u.$$.fragment),z=e(),w=p("p"),w.textContent=gs,F=e(),i(J.$$.fragment),L=e(),T=p("p"),T.textContent=ds,P=e(),i(b.$$.fragment),q=e(),f=p("p"),f.textContent=ys,D=e(),i(U.$$.fragment),K=e(),$=p("p"),$.textContent=us,O=e(),i(Z.$$.fragment),ss=e(),k=p("p"),k.innerHTML=ws,ts=e(),C=p("p"),C.innerHTML=Js,ls=e(),i(B.$$.fragment),as=e(),W=p("p"),W.textContent=Ts,es=e(),i(N.$$.fragment),ns=e(),I=p("p"),I.innerHTML=bs,ps=e(),i(G.$$.fragment),ms=e(),x=p("p"),x.innerHTML=fs,is=e(),i(E.$$.fragment),os=e(),i(Q.$$.fragment),rs=e(),i(X.$$.fragment),cs=e(),v=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(s),Y=m(s,"P",{}),Us(Y).forEach(l),_=n(s),o(d.$$.fragment,s),R=n(s),y=m(s,"P",{"data-svelte-h":!0}),j(y)!=="svelte-1wxq1ps"&&(y.innerHTML=js),H=n(s),o(u.$$.fragment,s),z=n(s),w=m(s,"P",{"data-svelte-h":!0}),j(w)!=="svelte-18ywhxh"&&(w.textContent=gs),F=n(s),o(J.$$.fragment,s),L=n(s),T=m(s,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1c2ipa8"&&(T.textContent=ds),P=n(s),o(b.$$.fragment,s),q=n(s),f=m(s,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=ys),D=n(s),o(U.$$.fragment,s),K=n(s),$=m(s,"P",{"data-svelte-h":!0}),j($)!=="svelte-19cnvx1"&&($.textContent=us),O=n(s),o(Z.$$.fragment,s),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1ym24x9"&&(k.innerHTML=ws),ts=n(s),C=m(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1wmi3ea"&&(C.innerHTML=Js),ls=n(s),o(B.$$.fragment,s),as=n(s),W=m(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-9sr7nh"&&(W.textContent=Ts),es=n(s),o(N.$$.fragment,s),ns=n(s),I=m(s,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1kguc51"&&(I.innerHTML=bs),ps=n(s),o(G.$$.fragment,s),ms=n(s),x=m(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-xtxxu6"&&(x.innerHTML=fs),is=n(s),o(E.$$.fragment,s),os=n(s),o(Q.$$.fragment,s),rs=n(s),o(X.$$.fragment,s),cs=n(s),v=m(s,"P",{}),Us(v).forEach(l),this.h()},h(){$s(g,"name","hf:doc:metadata"),$s(g,"content",Es)},m(s,t){Is(document.head,g),a(s,S,t),a(s,Y,t),a(s,_,t),r(d,s,t),a(s,R,t),a(s,y,t),a(s,H,t),r(u,s,t),a(s,z,t),a(s,w,t),a(s,F,t),r(J,s,t),a(s,L,t),a(s,T,t),a(s,P,t),r(b,s,t),a(s,q,t),a(s,f,t),a(s,D,t),r(U,s,t),a(s,K,t),a(s,$,t),a(s,O,t),r(Z,s,t),a(s,ss,t),a(s,k,t),a(s,ts,t),a(s,C,t),a(s,ls,t),r(B,s,t),a(s,as,t),a(s,W,t),a(s,es,t),r(N,s,t),a(s,ns,t),a(s,I,t),a(s,ps,t),r(G,s,t),a(s,ms,t),a(s,x,t),a(s,is,t),r(E,s,t),a(s,os,t),r(Q,s,t),a(s,rs,t),r(X,s,t),a(s,cs,t),a(s,v,t),hs=!0},p:ks,i(s){hs||(c(d.$$.fragment,s),c(u.$$.fragment,s),c(J.$$.fragment,s),c(b.$$.fragment,s),c(U.$$.fragment,s),c(Z.$$.fragment,s),c(B.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),c(X.$$.fragment,s),hs=!0)},o(s){h(d.$$.fragment,s),h(u.$$.fragment,s),h(J.$$.fragment,s),h(b.$$.fragment,s),h(U.$$.fragment,s),h(Z.$$.fragment,s),h(B.$$.fragment,s),h(N.$$.fragment,s),h(G.$$.fragment,s),h(E.$$.fragment,s),h(Q.$$.fragment,s),h(X.$$.fragment,s),hs=!1},d(s){s&&(l(S),l(Y),l(_),l(R),l(y),l(H),l(z),l(w),l(F),l(L),l(T),l(P),l(q),l(f),l(D),l(K),l($),l(O),l(ss),l(k),l(ts),l(C),l(ls),l(as),l(W),l(es),l(ns),l(I),l(ps),l(ms),l(x),l(is),l(os),l(rs),l(cs),l(v)),l(g),M(d,s),M(u,s),M(J,s),M(b,s),M(U,s),M(Z,s),M(B,s),M(N,s),M(G,s),M(E,s),M(Q,s),M(X,s)}}}const Es='{"title":"PNASNet","local":"pnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(Ms){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Bs{constructor(g){super(),Ws(this,g,Qs,xs,Zs,{})}}export{Vs as component};
