import{s as Wt,f as st,n as Rt,o as St}from"../chunks/scheduler.37c15a92.js";import{S as Qt,i as Xt,g as o,s,r as d,A as Yt,h as i,f as l,c as n,j as ue,u as h,x as r,k as p,y as Vt,a,v as y,d as M,t as w,w as f}from"../chunks/index.7cb9c9b8.js";import{C as nt}from"../chunks/CodeBlock.abae2786.js";import{C as Nt}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as ie,E as Pt}from"../chunks/getInferenceSnippets.48a77c36.js";function zt(ot){let T,ce,re,me,b,de,J,he,j,it=`In this section, we will take a closer look at the <code>Interface</code> class, and understand the
main parameters used to create one.`,ye,U,Me,g,rt="You’ll notice that the <code>Interface</code> class has 3 required parameters:",we,v,pt="<code>Interface(fn, inputs, outputs, ...)</code>",fe,I,ut="These parameters are:",Te,C,ct="<li><code>fn</code>: the prediction function that is wrapped by the Gradio interface. This function can take one or more parameters and return one or more values</li> <li><code>inputs</code>: the input component type(s). Gradio provides many pre-built components such as<code>&quot;image&quot;</code> or <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: the output component type(s). Again, Gradio provides many pre-built components e.g. <code>&quot;image&quot;</code> or <code>&quot;label&quot;</code>.</li>",be,k,mt='For a complete list of components, <a href="https://gradio.app/docs" rel="nofollow">see the Gradio docs </a>. Each pre-built component can be customized by instantiating the class corresponding to the component.',Je,x,dt=`For example, as we saw in the <a href="/course/chapter9/2">previous section</a>,
instead of passing in <code>&quot;textbox&quot;</code> to the <code>inputs</code> parameter, you can pass in a <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> component to create a textbox with 7 lines and a label.`,je,$,ht="Let’s take a look at another example, this time with an <code>Audio</code> component.",Ue,q,ge,_,yt=`As mentioned earlier, Gradio provides many different inputs and outputs.
So let’s build an <code>Interface</code> that works with audio.`,ve,A,Mt=`In this example, we’ll build an audio-to-audio function that takes an
audio file and simply reverses it.`,Ie,H,wt=`We will use for the input the <code>Audio</code> component. When using the <code>Audio</code> component,
you can specify whether you want the <code>source</code> of the audio to be a file that the user
uploads or a microphone that the user records their voice with. In this case, let’s
set it to a <code>&quot;microphone&quot;</code>. Just for fun, we’ll add a label to our <code>Audio</code> that says
“Speak here…“.`,Ce,B,ft=`In addition, we’d like to receive the audio as a numpy array so that we can easily
“reverse” it. So we’ll set the <code>&quot;type&quot;</code> to be <code>&quot;numpy&quot;</code>, which passes the input
data as a tuple of (<code>sample_rate</code>, <code>data</code>) into our function.`,ke,G,Tt=`We will also use the <code>Audio</code> output component which can automatically
render a tuple with a sample rate and numpy array of data as a playable audio file.
In this case, we do not need to do any customization, so we will use the string
shortcut <code>&quot;audio&quot;</code>.`,xe,Z,$e,L,bt=`The code above will produce an interface like the one below (if your browser doesn’t
ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,qe,u,Jt,_e,E,jt="You should now be able to record your voice and hear yourself speaking in reverse - spooky 👻!",Ae,W,He,R,Ut=`Let’s say we had a more complicated function, with multiple inputs and outputs.
In the example below, we have a function that takes a dropdown index, a slider value, and number,
and returns an audio sample of a musical tone.`,Be,S,gt=`Take a look how we pass a list of input and output components,
and see if you can follow along what’s happening.`,Ge,Q,vt="The key here is that when you pass:",Ze,X,It="<li>a list of input components, each component corresponds to a parameter in order.</li> <li>a list of output coponents, each component corresponds to a returned value.</li>",Le,Y,Ct="The code snippet below shows how three input components line up with the three arguments of the <code>generate_tone()</code> function:",Ee,V,We,c,kt,Re,N,Se,P,xt=`So far, we have used the <code>launch()</code> method to launch the interface, but we
haven’t really discussed what it does.`,Qe,z,$t=`By default, the <code>launch()</code> method will launch the demo in a web server that
is running locally. If you are running your code in a Jupyter or Colab notebook, then
Gradio will embed the demo GUI in the notebook so you can easily use it.`,Xe,F,qt="You can customize the behavior of <code>launch()</code> through different parameters:",Ye,K,_t="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Ve,D,At="We’ll cover the <code>share</code> parameter in a lot more detail in the next section!",Ne,O,Pe,ee,Ht=`Let’s build an interface that allows you to demo a <strong>speech-recognition</strong> model.
To make it interesting, we will accept <em>either</em> a mic input or an uploaded file.`,ze,te,Bt=`As usual, we’ll load our speech recognition model using the <code>pipeline()</code> function from 🤗 Transformers.
If you need a quick refresher, you can go back to <a href="/course/chapter1/3">that section in Chapter 1</a>.   Next, we’ll implement a <code>transcribe_audio()</code> function that processes the audio and returns the transcription. Finally, we’ll wrap this function in an <code>Interface</code> with the <code>Audio</code> components for the inputs and just text for the output. Altogether, the code for this application is the following:`,Fe,le,Ke,ae,Gt='If your browser doesn’t ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',De,m,Zt,Oe,se,Lt=`That’s it! You can now use this interface to transcribe audio. Notice here that
by passing in the <code>optional</code> parameter as <code>True</code>, we allow the user to either
provide a microphone or an audio file (or neither, but that will return an error message).`,et,ne,Et="Keep going to see how to share your interface with others!",tt,oe,lt,pe,at;return b=new ie({props:{title:"Understanding the Interface class",local:"understanding-the-interface-class",headingTag:"h1"}}),J=new Nt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),U=new ie({props:{title:"How to create an Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),q=new ie({props:{title:"A simple example with audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),Z=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new ie({props:{title:"Handling multiple inputs and outputs",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),V=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLk51bWJlcih2YWx1ZSUzRDElMkMlMjBsYWJlbCUzRCUyMkR1cmF0aW9uJTIwaW4lMjBzZWNvbmRzJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Number(value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),N=new ie({props:{title:"The launch() method",local:"the-launch-method",headingTag:"h3"}}),O=new ie({props:{title:"✏️ Let’s apply it!",local:"lets-apply-it",headingTag:"h2"}}),le=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCUyMnRleHQlMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio</span>):
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),oe=new Pt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/3.mdx"}}),{c(){T=o("meta"),ce=s(),re=o("p"),me=s(),d(b.$$.fragment),de=s(),d(J.$$.fragment),he=s(),j=o("p"),j.innerHTML=it,ye=s(),d(U.$$.fragment),Me=s(),g=o("p"),g.innerHTML=rt,we=s(),v=o("p"),v.innerHTML=pt,fe=s(),I=o("p"),I.textContent=ut,Te=s(),C=o("ul"),C.innerHTML=ct,be=s(),k=o("p"),k.innerHTML=mt,Je=s(),x=o("p"),x.innerHTML=dt,je=s(),$=o("p"),$.innerHTML=ht,Ue=s(),d(q.$$.fragment),ge=s(),_=o("p"),_.innerHTML=yt,ve=s(),A=o("p"),A.textContent=Mt,Ie=s(),H=o("p"),H.innerHTML=wt,Ce=s(),B=o("p"),B.innerHTML=ft,ke=s(),G=o("p"),G.innerHTML=Tt,xe=s(),d(Z.$$.fragment),$e=s(),L=o("p"),L.innerHTML=bt,qe=s(),u=o("iframe"),_e=s(),E=o("p"),E.textContent=jt,Ae=s(),d(W.$$.fragment),He=s(),R=o("p"),R.textContent=Ut,Be=s(),S=o("p"),S.textContent=gt,Ge=s(),Q=o("p"),Q.textContent=vt,Ze=s(),X=o("ul"),X.innerHTML=It,Le=s(),Y=o("p"),Y.innerHTML=Ct,Ee=s(),d(V.$$.fragment),We=s(),c=o("iframe"),Re=s(),d(N.$$.fragment),Se=s(),P=o("p"),P.innerHTML=xt,Qe=s(),z=o("p"),z.innerHTML=$t,Xe=s(),F=o("p"),F.innerHTML=qt,Ye=s(),K=o("ul"),K.innerHTML=_t,Ve=s(),D=o("p"),D.innerHTML=At,Ne=s(),d(O.$$.fragment),Pe=s(),ee=o("p"),ee.innerHTML=Ht,ze=s(),te=o("p"),te.innerHTML=Bt,Fe=s(),d(le.$$.fragment),Ke=s(),ae=o("p"),ae.innerHTML=Gt,De=s(),m=o("iframe"),Oe=s(),se=o("p"),se.innerHTML=Lt,et=s(),ne=o("p"),ne.textContent=Et,tt=s(),d(oe.$$.fragment),lt=s(),pe=o("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),re=i(e,"P",{}),ue(re).forEach(l),me=n(e),h(b.$$.fragment,e),de=n(e),h(J.$$.fragment,e),he=n(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-lkknik"&&(j.innerHTML=it),ye=n(e),h(U.$$.fragment,e),Me=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1gqpygy"&&(g.innerHTML=rt),we=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-5xxju6"&&(v.innerHTML=pt),fe=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1srf6cz"&&(I.textContent=ut),Te=n(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-1cwo97x"&&(C.innerHTML=ct),be=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-a2tvbr"&&(k.innerHTML=mt),Je=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-fgatqp"&&(x.innerHTML=dt),je=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1lphv0c"&&($.innerHTML=ht),Ue=n(e),h(q.$$.fragment,e),ge=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ul4i2u"&&(_.innerHTML=yt),ve=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1i37re5"&&(A.textContent=Mt),Ie=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-172zvxz"&&(H.innerHTML=wt),Ce=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4wa24d"&&(B.innerHTML=ft),ke=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-13zmab1"&&(G.innerHTML=Tt),xe=n(e),h(Z.$$.fragment,e),$e=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-221tzw"&&(L.innerHTML=bt),qe=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(u).forEach(l),_e=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-12uox4i"&&(E.textContent=jt),Ae=n(e),h(W.$$.fragment,e),He=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-185l475"&&(R.textContent=Ut),Be=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-wn7sdm"&&(S.textContent=gt),Ge=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15txj5f"&&(Q.textContent=vt),Ze=n(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1yoqjoi"&&(X.innerHTML=It),Le=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-rsacrc"&&(Y.innerHTML=Ct),Ee=n(e),h(V.$$.fragment,e),We=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(c).forEach(l),Re=n(e),h(N.$$.fragment,e),Se=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1drgann"&&(P.innerHTML=xt),Qe=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-j2w7rs"&&(z.innerHTML=$t),Xe=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-yl79n1"&&(F.innerHTML=qt),Ye=n(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-f1qyss"&&(K.innerHTML=_t),Ve=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-fugi8a"&&(D.innerHTML=At),Ne=n(e),h(O.$$.fragment,e),Pe=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-433a1m"&&(ee.innerHTML=Ht),ze=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1cy2oyt"&&(te.innerHTML=Bt),Fe=n(e),h(le.$$.fragment,e),Ke=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-16m1pd5"&&(ae.innerHTML=Gt),De=n(e),m=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(m).forEach(l),Oe=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1hnmjbo"&&(se.innerHTML=Lt),et=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1egous1"&&(ne.textContent=Et),tt=n(e),h(oe.$$.fragment,e),lt=n(e),pe=i(e,"P",{}),ue(pe).forEach(l),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",Ft),st(u.src,Jt="https://course-demos-audio-reverse.hf.space")||p(u,"src",Jt),p(u,"frameborder","0"),p(u,"height","250"),p(u,"title","Gradio app"),p(u,"class","container p-0 flex-grow space-iframe"),p(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(c.src,kt="https://course-demos-generate-tone.hf.space")||p(c,"src",kt),p(c,"frameborder","0"),p(c,"height","450"),p(c,"title","Gradio app"),p(c,"class","container p-0 flex-grow space-iframe"),p(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(m.src,Zt="https://course-demos-asr.hf.space")||p(m,"src",Zt),p(m,"frameborder","0"),p(m,"height","550"),p(m,"title","Gradio app"),p(m,"class","container p-0 flex-grow space-iframe"),p(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Vt(document.head,T),a(e,ce,t),a(e,re,t),a(e,me,t),y(b,e,t),a(e,de,t),y(J,e,t),a(e,he,t),a(e,j,t),a(e,ye,t),y(U,e,t),a(e,Me,t),a(e,g,t),a(e,we,t),a(e,v,t),a(e,fe,t),a(e,I,t),a(e,Te,t),a(e,C,t),a(e,be,t),a(e,k,t),a(e,Je,t),a(e,x,t),a(e,je,t),a(e,$,t),a(e,Ue,t),y(q,e,t),a(e,ge,t),a(e,_,t),a(e,ve,t),a(e,A,t),a(e,Ie,t),a(e,H,t),a(e,Ce,t),a(e,B,t),a(e,ke,t),a(e,G,t),a(e,xe,t),y(Z,e,t),a(e,$e,t),a(e,L,t),a(e,qe,t),a(e,u,t),a(e,_e,t),a(e,E,t),a(e,Ae,t),y(W,e,t),a(e,He,t),a(e,R,t),a(e,Be,t),a(e,S,t),a(e,Ge,t),a(e,Q,t),a(e,Ze,t),a(e,X,t),a(e,Le,t),a(e,Y,t),a(e,Ee,t),y(V,e,t),a(e,We,t),a(e,c,t),a(e,Re,t),y(N,e,t),a(e,Se,t),a(e,P,t),a(e,Qe,t),a(e,z,t),a(e,Xe,t),a(e,F,t),a(e,Ye,t),a(e,K,t),a(e,Ve,t),a(e,D,t),a(e,Ne,t),y(O,e,t),a(e,Pe,t),a(e,ee,t),a(e,ze,t),a(e,te,t),a(e,Fe,t),y(le,e,t),a(e,Ke,t),a(e,ae,t),a(e,De,t),a(e,m,t),a(e,Oe,t),a(e,se,t),a(e,et,t),a(e,ne,t),a(e,tt,t),y(oe,e,t),a(e,lt,t),a(e,pe,t),at=!0},p:Rt,i(e){at||(M(b.$$.fragment,e),M(J.$$.fragment,e),M(U.$$.fragment,e),M(q.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(V.$$.fragment,e),M(N.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),at=!0)},o(e){w(b.$$.fragment,e),w(J.$$.fragment,e),w(U.$$.fragment,e),w(q.$$.fragment,e),w(Z.$$.fragment,e),w(W.$$.fragment,e),w(V.$$.fragment,e),w(N.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),at=!1},d(e){e&&(l(ce),l(re),l(me),l(de),l(he),l(j),l(ye),l(Me),l(g),l(we),l(v),l(fe),l(I),l(Te),l(C),l(be),l(k),l(Je),l(x),l(je),l($),l(Ue),l(ge),l(_),l(ve),l(A),l(Ie),l(H),l(Ce),l(B),l(ke),l(G),l(xe),l($e),l(L),l(qe),l(u),l(_e),l(E),l(Ae),l(He),l(R),l(Be),l(S),l(Ge),l(Q),l(Ze),l(X),l(Le),l(Y),l(Ee),l(We),l(c),l(Re),l(Se),l(P),l(Qe),l(z),l(Xe),l(F),l(Ye),l(K),l(Ve),l(D),l(Ne),l(Pe),l(ee),l(ze),l(te),l(Fe),l(Ke),l(ae),l(De),l(m),l(Oe),l(se),l(et),l(ne),l(tt),l(lt),l(pe)),l(T),f(b,e),f(J,e),f(U,e),f(q,e),f(Z,e),f(W,e),f(V,e),f(N,e),f(O,e),f(le,e),f(oe,e)}}}const Ft='{"title":"Understanding the Interface class","local":"understanding-the-interface-class","sections":[{"title":"How to create an Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"A simple example with audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Handling multiple inputs and outputs","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"The launch() method","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Let’s apply it!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function Kt(ot){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Qt{constructor(T){super(),Xt(this,T,Kt,zt,Wt,{})}}export{al as component};
