import{s as va,o as _a,n as Qa}from"../chunks/scheduler.37c15a92.js";import{S as Ba,i as Wa,g as a,s as n,r,A as Ra,h as i,f as l,c as p,j as Za,u as c,x as M,k as ip,y as Na,a as t,v as y,d as J,t as m,w as o}from"../chunks/index.2bf4358c.js";import{T as Xa}from"../chunks/Tip.363c041f.js";import{Y as Aa}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4e987730.js";import{C as Ea}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{H as Jl,E as Ga}from"../chunks/getInferenceSnippets.8229e22a.js";function qa(ml){let T,d=`<strong>Далее</strong> если вы протестируете две версии предыдущих нормализаторов на строке, содержащей символ Unicode <code>u&quot;\\u0085&quot;</code>, то наверняка заметите, что эти два нормализатора не совсем эквивалентны.<br/>
Чтобы не усложнять версию с <code>normalizers.Sequence</code>, мы не включили в нее Regex-замены, которые требует <code>BertNormalizer</code>, когда аргумент <code>clean_text</code> установлен в <code>True</code>, что является поведением по умолчанию. Но не волнуйтесь: можно получить точно такую же нормализацию без использования удобного <code>BertNormalizer</code>, добавив два <code>normalizers.Replace</code> в последовательность нормализаторов.`;return{c(){T=a("p"),T.innerHTML=d},l(u){T=i(u,"P",{"data-svelte-h":!0}),M(T)!=="svelte-kju4cm"&&(T.innerHTML=d)},m(u,cl){t(u,T,cl)},p:Qa,d(u){u&&l(T)}}}function La(ml){let T,d,u,cl,k,ol,$,jl,b,Mp="Как мы уже видели в предыдущих разделах, токенизация состоит из нескольких этапов:",Tl,w,rp="<li>Нормализация (любая необходимая очистка текста, например, удаление пробелов или подчеркиваний, нормализация Unicode и т. д.)</li> <li>Предварительная токенизация (разделение входного текста на слова).</li> <li>Прогон входных данных через модель (использование предварительно токенизированных слов для создания последовательности токенов)</li> <li>Постобработка (добавление специальных токенов токенизатора, генерация маски внимания и идентификаторов типов токенов)</li>",ul,C,cp="В качестве напоминания вот еще один взгляд на общий процесс:",fl,f,yp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',Ul,g,Jp='Библиотека 🤗 Tokenizers была создана для того, чтобы предоставить несколько вариантов каждого из этих шагов, которые вы можете смешивать и сочетать между собой. В этом разделе мы рассмотрим, как можно создать токенизатор с нуля, а не обучать новый токенизатор на основе старого, как мы делали в <a href="../chapter6/2">разделе 2</a>. После этого вы сможете создать любой токенизатор, который только сможете придумать!',dl,h,kl,x,mp="Точнее, библиотека построена вокруг центрального класса <code>Tokenizer</code>, а строительные блоки сгруппированы в подмодули:",$l,I,op='<li><code>normalizers</code> содержит все возможные типы нормализаторов текста <code>Normalizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">здесь</a>).</li> <li><code>pre_tokenizers</code> содержит все возможные типы предварительных токенизаторов <code>PreTokenizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">здесь</a>).</li> <li><code>models</code> содержит различные типы моделей <code>Model</code>, которые вы можете использовать, такие как <code>BPE</code>, <code>WordPiece</code> и <code>Unigram</code> (полный список <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">здесь</a>).</li> <li><code>trainers</code> содержит все различные типы <code>Trainer</code>, которые вы можете использовать для обучения модели на корпусе (по одному на каждый тип модели; полный список <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">здесь</a>).</li> <li><code>post_processors</code> содержит различные типы постпроцессоров <code>PostProcessor</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">здесь</a>).</li> <li><code>decoders</code> содержит различные типы декодеров <code>Decoder</code>, которые вы можете использовать для декодирования результатов токенизации (полный список <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">здесь</a>).</li>',bl,V,jp='Весь список блоков вы можете найти <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">здесь</a>.',wl,z,Cl,Z,Tp='Для обучения нашего нового токенизатора мы будем использовать небольшой корпус текстов (чтобы примеры выполнялись быстро). Шаги по сбору корпуса аналогичны тем, что мы делали в <a href="../chapter6/2">начале этой главы</a>, но на этот раз мы будем использовать набор данных <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>:',gl,v,hl,_,up="Функция <code>get_training_corpus()</code> - это генератор, который выдает батч из 1000 текстов, которые мы будем использовать для обучения токенизатора.",xl,Q,fp="🤗 Токенизаторы также можно обучать непосредственно на текстовых файлах. Вот как мы можем сгенерировать текстовый файл, содержащий все тексты/входы из WikiText-2, который мы можем использовать локально:",Il,B,Vl,W,Up="Далее мы покажем вам, как блок за блоком построить собственные токенизаторы BERT, GPT-2 и XLNet. Это даст нам пример каждого из трех основных алгоритмов токенизации: WordPiece, BPE и Unigram. Начнем с BERT!",zl,R,Zl,N,dp="Чтобы создать токенизатор с помощью библиотеки 🤗 Tokenizers, мы начнем с инстанцирования объектов <code>Tokenizer</code> и <code>model</code>, затем установим для их атрибутов <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> и <code>decoder</code> нужные нам значения.",vl,X,kp="Для этого примера мы создадим <code>Tokenizer</code> с моделью WordPiece:",_l,A,Ql,E,$p="Мы должны указать <code>unk_token</code>, чтобы модель знала, что возвращать, когда она встречает символы, которых раньше не видела. Другие аргументы, которые мы можем задать здесь, включают <code>vocab</code> нашей модели (мы собираемся обучать модель, поэтому нам не нужно его задавать) и <code>max_input_chars_per_word</code>, который определяет максимальную длину для каждого слова (слова длиннее переданного значения будут разбиты на части).",Bl,G,bp="Первым шагом токенизации является нормализация, поэтому начнем с нее. Поскольку BERT широко используется, существует <code>BertNormalizer</code> с классическими параметрами, которые мы можем установить для BERT: <code>lowercase</code> и <code>strip_accents</code>, которые не требуют пояснений; <code>clean_text</code> для удаления всех управляющих символов и замены повторяющихся пробелов на один; и <code>handle_chinese_chars</code>, который расставляет пробелы вокруг китайских символов. Чтобы повторить токенизатор <code>bert-base-uncased</code>, мы можем просто установить этот нормализатор:",Wl,q,Rl,L,wp="Однако, как правило, при создании нового токенизатора у вас не будет доступа к такому удобному нормализатору, уже реализованному в библиотеке 🤗 Tokenizers, поэтому давайте посмотрим, как создать нормализатор BERT вручную. Библиотека предоставляет нормализатор <code>Lowercase</code> и нормализатор <code>StripAccents</code>, и вы можете комбинировать несколько нормализаторов с помощью <code>Sequence</code>:",Nl,H,Xl,S,Cp="Мы также используем нормализатор Unicode <code>NFD</code>, поскольку в противном случае нормализатор <code>StripAccents</code> не сможет правильно распознать акцентированные символы и, следовательно, не удалит их.",Al,D,gp="Как мы уже видели ранее, мы можем использовать метод <code>normalize_str()</code> нормализатора, чтобы проверить, как он влияет на данный текст:",El,P,Gl,Y,ql,U,Ll,F,hp="Далее следует этап предварительной токенизации. Опять же, есть готовый <code>BertPreTokenizer</code>, который мы можем использовать:",Hl,K,Sl,O,xp="Или мы можем создать его с нуля:",Dl,ee,Pl,se,Ip="Обратите внимание, что токенизатор <code>Whitespace</code> разделяет пробельные символы и все символы, которые не являются буквами, цифрами или символом подчеркивания, поэтому технически он разделяет пробельные символы и знаки пунктуации:",Yl,le,Fl,te,Kl,ne,Vp="Если вы хотите выполнять разделение только по пробельным символам, то вместо этого следует использовать предварительный токенизатор <code>WhitespaceSplit</code>:",Ol,pe,et,ae,st,ie,zp="Как и в случае с нормализаторами, вы можете использовать <code>Sequence</code> для комбинирования нескольких предварительных токенизаторов:",lt,Me,tt,re,nt,ce,Zp="Следующий шаг в конвейере токенизации - обработка входных данных с помощью модели. Мы уже указали нашу модель в инициализации, но нам все еще нужно обучить ее, для чего потребуется <code>WordPieceTrainer</code>. Главное, что нужно помнить при инстанцировании тренера в 🤗 Tokenizers, это то, что вам нужно передать ему все специальные токены, которые вы собираетесь использовать - иначе он не добавит их в словарь, поскольку их нет в обучающем корпусе:",pt,ye,at,Je,vp="Помимо указания <code>vocab_size</code> и <code>special_tokens</code>, мы можем задать <code>min_frequency</code> (количество раз, которое должен встретиться токен, чтобы быть включенным в словарь) или изменить <code>continuing_subword_prefix</code> (если мы хотим использовать что-то отличное от <code>##</code>).",it,me,_p="Чтобы обучить нашу модель с помощью итератора, который мы определили ранее, достаточно выполнить эту команду:",Mt,oe,rt,je,Qp="Мы также можем использовать текстовые файлы для обучения нашего токенизатора, что будет выглядеть следующим образом (предварительно мы повторно инициализируем модель с пустым <code>WordPiece</code>):",ct,Te,yt,ue,Bp="В обоих случаях мы можем проверить работу токенизатора на тексте, вызвав метод <code>encode()</code>:",Jt,fe,mt,Ue,ot,de,Wp="Полученное <code>encoding</code> представляет собой <code>Encoding</code>, которое содержит все необходимые результаты работы токенизатора в разных атрибутах: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> и <code>overflowing</code>.",jt,ke,Rp="Последний шаг в конвейере токенизации - постобработка. Нам нужно добавить токен <code>[CLS]</code> в начале и токен <code>[SEP]</code> в конце (или после каждого предложения, если у нас есть пара предложений). Для этого мы будем использовать <code>TemplateProcessor</code>, но сначала нам нужно узнать идентификаторы токенов <code>[CLS]</code> и <code>[SEP]</code> в словаре:",Tt,$e,ut,be,ft,we,Np="Чтобы написать шаблон для <code>TemplateProcessor</code>, мы должны указать, как обрабатывать одно предложение и пару предложений. Для обоих случаев мы указываем специальные токены, которые мы хотим использовать; первое (или одиночное) предложение представлено <code>$A</code>, а второе предложение (если кодируется пара) представлено <code>$B</code>. Для каждого из них (специальных токенов и предложений) мы также указываем соответствующий идентификатор типа токена (token type ID) после двоеточия.",Ut,Ce,Xp="Таким образом, классический шаблон BERT определяется следующим образом:",dt,ge,kt,he,Ap="Обратите внимание, что нам нужно передать идентификаторы специальных токенов, чтобы токенизатор мог правильно преобразовать их в их идентификаторы.",$t,xe,Ep="Как только это будет добавлено, вернемся к нашему предыдущему примеру:",bt,Ie,wt,Ve,Ct,ze,Gp="И на паре предложений мы получаем правильный результат:",gt,Ze,ht,ve,xt,_e,qp="Мы почти закончили создание этого токенизатора с нуля - остался последний шаг - добавить декодер:",It,Qe,Vt,Be,Lp="Давайте проверим его на нашем предыдущем <code>encoding</code>:",zt,We,Zt,Re,vt,Ne,Hp="Отлично! Мы можем сохранить наш токенизатор в единственном JSON-файле следующим образом:",_t,Xe,Qt,Ae,Sp="Затем мы можем загрузить этот файл в объект <code>Tokenizer</code> с помощью метода <code>from_file()</code>:",Bt,Ee,Wt,Ge,Dp="Чтобы использовать этот токенизатор в 🤗 Transformers, мы должны обернуть его в <code>PreTrainedTokenizerFast</code>. Мы можем использовать либо общий класс, либо, если наш токенизатор соответствует существующей модели, использовать этот класс (здесь <code>BertTokenizerFast</code>). Если вы используете этот урок для создания нового токенизатора, вам придется использовать первый вариант.",Rt,qe,Pp="Чтобы обернуть токенизатор в <code>PreTrainedTokenizerFast</code>, мы можем либо передать собранный нами токенизатор как <code>tokenizer_object</code>, либо передать сохраненный файл токенизатора как <code>tokenizer_file</code>. Главное помнить, что нам придется вручную задавать все специальные токены, поскольку класс не может определить из объекта <code>tokenizer</code>, какой токен является токеном маски, токеном <code>[CLS]</code> и т. д.:",Nt,Le,Xt,He,Yp="Если вы используете определенный класс токенизатора (например, <code>BertTokenizerFast</code>), вам нужно будет указать только специальные токены, которые отличаются от токенов по умолчанию (здесь их нет):",At,Se,Et,De,Fp="Затем вы можете использовать этот токенизатор, как и любой другой токенизатор 🤗 Transformers. Вы можете сохранить его с помощью метода <code>save_pretrained()</code> или загрузить на хаб с помощью метода <code>push_to_hub()</code>.",Gt,Pe,Kp="Теперь, когда мы рассмотрели, как создать токенизатор WordPiece, давайте сделаем то же самое для токенизатора BPE. Мы будем двигаться немного быстрее, поскольку вы знаете все шаги, и подчеркнем только различия.",qt,Ye,Lt,Fe,Op="Теперь давайте создадим токенизатор GPT-2. Как и в случае с токенизатором BERT, мы начнем с инициализации <code>Tokenizer</code> с моделью BPE:",Ht,Ke,St,Oe,ea="Также, как и в случае с BERT, мы могли бы инициализировать эту модель словарем, если бы он у нас был (в этом случае нам нужно было бы передать <code>vocab</code> и <code>merges</code>), но поскольку мы будем обучать с нуля, нам не нужно этого делать. Нам также не нужно указывать <code>unk_token</code>, потому что GPT-2 использует byte-level BPE, который не требует этого.",Dt,es,sa="GPT-2 не использует нормализатор, поэтому мы пропускаем этот шаг и переходим непосредственно к предварительной токенизации:",Pt,ss,Yt,ls,la="Опция, которую мы добавили к <code>ByteLevel</code>, заключается в том, чтобы не добавлять пробел в начале предложения (в противном случае это происходит по умолчанию). Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",Ft,ts,Kt,ns,Ot,ps,ta="Далее следует модель, которую нужно обучить. Для GPT-2 единственным специальным токеном является токен конца текста:",en,as,sn,is,na="Как и в случае с <code>WordPieceTrainer</code>, а также <code>vocab_size</code> и <code>special_tokens</code>, мы можем указать <code>min_frequency</code>, если хотим, или если у нас есть суффикс конца слова (например, <code>&lt;/w&gt;</code>), мы можем задать его с помощью <code>end_of_word_suffix</code>.",ln,Ms,pa="Этот токенизатор также может быть обучен на текстовых файлах:",tn,rs,nn,cs,aa="Давайте посмотрим на пример токенизации текста:",pn,ys,an,Js,Mn,ms,ia="Мы применяем постобработку на уровне байтов для токенизатора GPT-2 следующим образом:",rn,os,cn,js,Ma="Опция <code>trim_offsets = False</code> указывает постпроцессору, что мы должны оставить смещения токенов, начинающихся с ‘Ġ’, как есть: таким образом, начало смещения будет указывать на пробел перед словом, а не на первый символ слова (поскольку пробел технически является частью токена). Давайте посмотрим на результат с текстом, который мы только что закодировали, где <code>&#39;Ġtest&#39;</code> - это токен с индексом 4:",yn,Ts,Jn,us,mn,fs,ra="Наконец, мы добавляем декодер на уровне байтов:",on,Us,jn,ds,ca="и мы сможем перепроверить, правильно ли он работает:",Tn,ks,un,$s,fn,bs,ya="Отлично! Теперь, когда мы закончили, мы можем сохранить токенизатор, как раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>GPT2TokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers:",Un,ws,dn,Cs,Ja="или:",kn,gs,$n,hs,ma="В качестве последнего примера мы покажем вам, как создать токенизатор Unigram с нуля.",bn,xs,wn,Is,oa="Теперь давайте построим токенизатор XLNet. Как и в предыдущих токенизаторах, мы начнем с инициализации <code>Tokenizer</code> с моделью Unigram:",Cn,Vs,gn,zs,ja="Опять же, мы могли бы инициализировать эту модель словарем, если бы он у нас был.",hn,Zs,Ta="Для нормализации XLNet использует несколько замен (которые пришли из SentencePiece):",xn,vs,In,_s,ua="Он заменяет <code>“</code> и <code>”</code> with <code>”</code> и любую последовательность из двух или более пробелов на один пробел, а также удаляет ударения в токенезируемых текстах.",Vn,Qs,fa="Предварительный токенизатор, который должен использоваться для любого токенизатора SentencePiece, - это <code>Metaspace</code>:",zn,Bs,Zn,Ws,Ua="Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",vn,Rs,_n,Ns,Qn,Xs,da="Далее следует модель, которую нужно обучить. В XLNet довольно много специальных токенов:",Bn,As,Wn,Es,ka="Очень важный аргумент, который не стоит забывать для <code>UnigramTrainer</code> - это <code>unk_token</code>. Мы также можем передавать другие аргументы, специфичные для алгоритма Unigram, такие как <code>shrinking_factor</code> для каждого шага удаления токенов (по умолчанию 0.75) или <code>max_piece_length</code> для указания максимальной длины данного токена (по умолчанию 16).",Rn,Gs,$a="Этот токенизатор также может быть обучен на текстовых файлах:",Nn,qs,Xn,Ls,ba="Давайте посмотрим на токенизацию примера текста:",An,Hs,En,Ss,Gn,Ds,wa="Особенностью XLNet является то, что он помещает токен <code>&lt;cls&gt;</code> в конец предложения с идентификатором типа 2 (чтобы отличить его от других токенов). В результате он помещается слева. Мы можем разобраться со всеми специальными токенами и идентификаторами типов токенов с помощью шаблона, как в BERT, но сначала нам нужно получить идентификаторы токенов <code>&lt;cls&gt;</code> и <code>&lt;sep&gt;</code>:",qn,Ps,Ln,Ys,Hn,Fs,Ca="Шаблон выглядит следующим образом:",Sn,Ks,Dn,Os,ga="И мы можем проверить, как это работает, закодировав пару предложений:",Pn,el,Yn,sl,Fn,ll,ha="Наконец, мы добавляем декодер <code>Metaspace</code>:",Kn,tl,On,nl,xa="и мы закончили работу с этим токенизатором! Мы можем сохранить токенизатор, как и раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>XLNetTokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers. При использовании <code>PreTrainedTokenizerFast</code> следует обратить внимание на то, что помимо специальных токенов, нам нужно указать библиотеке 🤗 Transformers на то, чтобы они располагались слева:",ep,pl,sp,al,Ia="Или альтернативно:",lp,il,tp,Ml,Va="Теперь, когда вы увидели, как различные блоки используются для создания существующих токенизаторов, вы должны быть в состоянии написать любой токенизатор, который вы хотите, с помощью библиотеки 🤗 Tokenizers и использовать его в 🤗 Transformers.",np,rl,pp,yl,ap;return k=new Jl({props:{title:"Создание токенизатора, блок за блоком",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),$=new Ea({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),h=new Aa({props:{id:"MR8tZm5ViWU"}}),z=new Jl({props:{title:"Получение корпуса текста",local:"acquiring-a-corpus",headingTag:"h2"}}),v=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),B=new j({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),R=new Jl({props:{title:"Создание токенизатора WordPiece с нуля",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),q=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),H=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new j({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),Y=new j({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),U=new Xa({props:{$$slots:{default:[qa]},$$scope:{ctx:ml}}}),K=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),le=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),te=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),pe=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ae=new j({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),Me=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),re=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ye=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),oe=new j({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),Te=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),fe=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ue=new j({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$e=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),be=new j({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ge=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ie=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ve=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ve=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Qe=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),We=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Re=new j({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Xe=new j({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ee=new j({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Le=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMCVEMCU5MiUyMCVEMCVCQSVEMCVCMCVEMSU4NyVEMCVCNSVEMSU4MSVEMSU4MiVEMCVCMiVEMCVCNSUyMCVEMCVCMCVEMCVCQiVEMSU4QyVEMSU4MiVEMCVCNSVEMSU4MCVEMCVCRCVEMCVCMCVEMSU4MiVEMCVCOCVEMCVCMiVEMSU4QiUyMCVEMCVCQyVEMCVCRSVEMCVCNiVEMCVCRCVEMCVCRSUyMCVEMCVCNyVEMCVCMCVEMCVCMyVEMSU4MCVEMSU4MyVEMCVCNyVEMCVCOCVEMSU4MiVEMSU4QyUyMCVEMCVCOCVEMCVCNyUyMCVEMSU4NCVEMCVCMCVEMCVCOSVEMCVCQiVEMCVCMCUyMCVEMSU4MiVEMCVCRSVEMCVCQSVEMCVCNSVEMCVCRCVEMCVCOCVEMCVCNyVEMCVCMCVEMSU4MiVEMCVCRSVEMSU4MCVEMCVCMC4lMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # В качестве альтернативы можно загрузить из файла токенизатора.</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ye=new Jl({props:{title:"Создание токенизатора BPE с нуля",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Ke=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ts=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),as=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),rs=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),ys=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Js=new j({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),os=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),Ts=new j({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),us=new j({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),Us=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),ks=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),$s=new j({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),ws=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),gs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),xs=new Jl({props:{title:"Создание токенизатора Unigram с нуля",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),Vs=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),vs=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Bs=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Rs=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Ns=new j({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),As=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),qs=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Hs=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ss=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ys=new j({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),el=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),sl=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),tl=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),pl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),il=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),rl=new Ga({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ru/chapter6/8.mdx"}}),{c(){T=a("meta"),d=n(),u=a("p"),cl=n(),r(k.$$.fragment),ol=n(),r($.$$.fragment),jl=n(),b=a("p"),b.textContent=Mp,Tl=n(),w=a("ul"),w.innerHTML=rp,ul=n(),C=a("p"),C.textContent=cp,fl=n(),f=a("div"),f.innerHTML=yp,Ul=n(),g=a("p"),g.innerHTML=Jp,dl=n(),r(h.$$.fragment),kl=n(),x=a("p"),x.innerHTML=mp,$l=n(),I=a("ul"),I.innerHTML=op,bl=n(),V=a("p"),V.innerHTML=jp,wl=n(),r(z.$$.fragment),Cl=n(),Z=a("p"),Z.innerHTML=Tp,gl=n(),r(v.$$.fragment),hl=n(),_=a("p"),_.innerHTML=up,xl=n(),Q=a("p"),Q.textContent=fp,Il=n(),r(B.$$.fragment),Vl=n(),W=a("p"),W.textContent=Up,zl=n(),r(R.$$.fragment),Zl=n(),N=a("p"),N.innerHTML=dp,vl=n(),X=a("p"),X.innerHTML=kp,_l=n(),r(A.$$.fragment),Ql=n(),E=a("p"),E.innerHTML=$p,Bl=n(),G=a("p"),G.innerHTML=bp,Wl=n(),r(q.$$.fragment),Rl=n(),L=a("p"),L.innerHTML=wp,Nl=n(),r(H.$$.fragment),Xl=n(),S=a("p"),S.innerHTML=Cp,Al=n(),D=a("p"),D.innerHTML=gp,El=n(),r(P.$$.fragment),Gl=n(),r(Y.$$.fragment),ql=n(),r(U.$$.fragment),Ll=n(),F=a("p"),F.innerHTML=hp,Hl=n(),r(K.$$.fragment),Sl=n(),O=a("p"),O.textContent=xp,Dl=n(),r(ee.$$.fragment),Pl=n(),se=a("p"),se.innerHTML=Ip,Yl=n(),r(le.$$.fragment),Fl=n(),r(te.$$.fragment),Kl=n(),ne=a("p"),ne.innerHTML=Vp,Ol=n(),r(pe.$$.fragment),et=n(),r(ae.$$.fragment),st=n(),ie=a("p"),ie.innerHTML=zp,lt=n(),r(Me.$$.fragment),tt=n(),r(re.$$.fragment),nt=n(),ce=a("p"),ce.innerHTML=Zp,pt=n(),r(ye.$$.fragment),at=n(),Je=a("p"),Je.innerHTML=vp,it=n(),me=a("p"),me.textContent=_p,Mt=n(),r(oe.$$.fragment),rt=n(),je=a("p"),je.innerHTML=Qp,ct=n(),r(Te.$$.fragment),yt=n(),ue=a("p"),ue.innerHTML=Bp,Jt=n(),r(fe.$$.fragment),mt=n(),r(Ue.$$.fragment),ot=n(),de=a("p"),de.innerHTML=Wp,jt=n(),ke=a("p"),ke.innerHTML=Rp,Tt=n(),r($e.$$.fragment),ut=n(),r(be.$$.fragment),ft=n(),we=a("p"),we.innerHTML=Np,Ut=n(),Ce=a("p"),Ce.textContent=Xp,dt=n(),r(ge.$$.fragment),kt=n(),he=a("p"),he.textContent=Ap,$t=n(),xe=a("p"),xe.textContent=Ep,bt=n(),r(Ie.$$.fragment),wt=n(),r(Ve.$$.fragment),Ct=n(),ze=a("p"),ze.textContent=Gp,gt=n(),r(Ze.$$.fragment),ht=n(),r(ve.$$.fragment),xt=n(),_e=a("p"),_e.textContent=qp,It=n(),r(Qe.$$.fragment),Vt=n(),Be=a("p"),Be.innerHTML=Lp,zt=n(),r(We.$$.fragment),Zt=n(),r(Re.$$.fragment),vt=n(),Ne=a("p"),Ne.textContent=Hp,_t=n(),r(Xe.$$.fragment),Qt=n(),Ae=a("p"),Ae.innerHTML=Sp,Bt=n(),r(Ee.$$.fragment),Wt=n(),Ge=a("p"),Ge.innerHTML=Dp,Rt=n(),qe=a("p"),qe.innerHTML=Pp,Nt=n(),r(Le.$$.fragment),Xt=n(),He=a("p"),He.innerHTML=Yp,At=n(),r(Se.$$.fragment),Et=n(),De=a("p"),De.innerHTML=Fp,Gt=n(),Pe=a("p"),Pe.textContent=Kp,qt=n(),r(Ye.$$.fragment),Lt=n(),Fe=a("p"),Fe.innerHTML=Op,Ht=n(),r(Ke.$$.fragment),St=n(),Oe=a("p"),Oe.innerHTML=ea,Dt=n(),es=a("p"),es.textContent=sa,Pt=n(),r(ss.$$.fragment),Yt=n(),ls=a("p"),ls.innerHTML=la,Ft=n(),r(ts.$$.fragment),Kt=n(),r(ns.$$.fragment),Ot=n(),ps=a("p"),ps.textContent=ta,en=n(),r(as.$$.fragment),sn=n(),is=a("p"),is.innerHTML=na,ln=n(),Ms=a("p"),Ms.textContent=pa,tn=n(),r(rs.$$.fragment),nn=n(),cs=a("p"),cs.textContent=aa,pn=n(),r(ys.$$.fragment),an=n(),r(Js.$$.fragment),Mn=n(),ms=a("p"),ms.textContent=ia,rn=n(),r(os.$$.fragment),cn=n(),js=a("p"),js.innerHTML=Ma,yn=n(),r(Ts.$$.fragment),Jn=n(),r(us.$$.fragment),mn=n(),fs=a("p"),fs.textContent=ra,on=n(),r(Us.$$.fragment),jn=n(),ds=a("p"),ds.textContent=ca,Tn=n(),r(ks.$$.fragment),un=n(),r($s.$$.fragment),fn=n(),bs=a("p"),bs.innerHTML=ya,Un=n(),r(ws.$$.fragment),dn=n(),Cs=a("p"),Cs.textContent=Ja,kn=n(),r(gs.$$.fragment),$n=n(),hs=a("p"),hs.textContent=ma,bn=n(),r(xs.$$.fragment),wn=n(),Is=a("p"),Is.innerHTML=oa,Cn=n(),r(Vs.$$.fragment),gn=n(),zs=a("p"),zs.textContent=ja,hn=n(),Zs=a("p"),Zs.textContent=Ta,xn=n(),r(vs.$$.fragment),In=n(),_s=a("p"),_s.innerHTML=ua,Vn=n(),Qs=a("p"),Qs.innerHTML=fa,zn=n(),r(Bs.$$.fragment),Zn=n(),Ws=a("p"),Ws.textContent=Ua,vn=n(),r(Rs.$$.fragment),_n=n(),r(Ns.$$.fragment),Qn=n(),Xs=a("p"),Xs.textContent=da,Bn=n(),r(As.$$.fragment),Wn=n(),Es=a("p"),Es.innerHTML=ka,Rn=n(),Gs=a("p"),Gs.textContent=$a,Nn=n(),r(qs.$$.fragment),Xn=n(),Ls=a("p"),Ls.textContent=ba,An=n(),r(Hs.$$.fragment),En=n(),r(Ss.$$.fragment),Gn=n(),Ds=a("p"),Ds.innerHTML=wa,qn=n(),r(Ps.$$.fragment),Ln=n(),r(Ys.$$.fragment),Hn=n(),Fs=a("p"),Fs.textContent=Ca,Sn=n(),r(Ks.$$.fragment),Dn=n(),Os=a("p"),Os.textContent=ga,Pn=n(),r(el.$$.fragment),Yn=n(),r(sl.$$.fragment),Fn=n(),ll=a("p"),ll.innerHTML=ha,Kn=n(),r(tl.$$.fragment),On=n(),nl=a("p"),nl.innerHTML=xa,ep=n(),r(pl.$$.fragment),sp=n(),al=a("p"),al.textContent=Ia,lp=n(),r(il.$$.fragment),tp=n(),Ml=a("p"),Ml.textContent=Va,np=n(),r(rl.$$.fragment),pp=n(),yl=a("p"),this.h()},l(e){const s=Ra("svelte-u9bgzb",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(l),d=p(e),u=i(e,"P",{}),Za(u).forEach(l),cl=p(e),c(k.$$.fragment,e),ol=p(e),c($.$$.fragment,e),jl=p(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-b5kklz"&&(b.textContent=Mp),Tl=p(e),w=i(e,"UL",{"data-svelte-h":!0}),M(w)!=="svelte-1sajjkb"&&(w.innerHTML=rp),ul=p(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-31tofb"&&(C.textContent=cp),fl=p(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(f)!=="svelte-oxfng3"&&(f.innerHTML=yp),Ul=p(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-3ncb60"&&(g.innerHTML=Jp),dl=p(e),c(h.$$.fragment,e),kl=p(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1jjcw0i"&&(x.innerHTML=mp),$l=p(e),I=i(e,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-400a5j"&&(I.innerHTML=op),bl=p(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1dqwrlj"&&(V.innerHTML=jp),wl=p(e),c(z.$$.fragment,e),Cl=p(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-7jvs84"&&(Z.innerHTML=Tp),gl=p(e),c(v.$$.fragment,e),hl=p(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1gsy8ta"&&(_.innerHTML=up),xl=p(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1wtem0y"&&(Q.textContent=fp),Il=p(e),c(B.$$.fragment,e),Vl=p(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-gnegz7"&&(W.textContent=Up),zl=p(e),c(R.$$.fragment,e),Zl=p(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-rdvi8a"&&(N.innerHTML=dp),vl=p(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-17zu5lc"&&(X.innerHTML=kp),_l=p(e),c(A.$$.fragment,e),Ql=p(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1uc1t5u"&&(E.innerHTML=$p),Bl=p(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-14au9ct"&&(G.innerHTML=bp),Wl=p(e),c(q.$$.fragment,e),Rl=p(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-13vk9t1"&&(L.innerHTML=wp),Nl=p(e),c(H.$$.fragment,e),Xl=p(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-eabqpa"&&(S.innerHTML=Cp),Al=p(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1cmtqtp"&&(D.innerHTML=gp),El=p(e),c(P.$$.fragment,e),Gl=p(e),c(Y.$$.fragment,e),ql=p(e),c(U.$$.fragment,e),Ll=p(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1x52eyd"&&(F.innerHTML=hp),Hl=p(e),c(K.$$.fragment,e),Sl=p(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-gv0viq"&&(O.textContent=xp),Dl=p(e),c(ee.$$.fragment,e),Pl=p(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-iy2ywz"&&(se.innerHTML=Ip),Yl=p(e),c(le.$$.fragment,e),Fl=p(e),c(te.$$.fragment,e),Kl=p(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1hk0h2e"&&(ne.innerHTML=Vp),Ol=p(e),c(pe.$$.fragment,e),et=p(e),c(ae.$$.fragment,e),st=p(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1be6pgh"&&(ie.innerHTML=zp),lt=p(e),c(Me.$$.fragment,e),tt=p(e),c(re.$$.fragment,e),nt=p(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ornxe5"&&(ce.innerHTML=Zp),pt=p(e),c(ye.$$.fragment,e),at=p(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-14vfm6y"&&(Je.innerHTML=vp),it=p(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-93abaw"&&(me.textContent=_p),Mt=p(e),c(oe.$$.fragment,e),rt=p(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-y1gxvq"&&(je.innerHTML=Qp),ct=p(e),c(Te.$$.fragment,e),yt=p(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-19sql22"&&(ue.innerHTML=Bp),Jt=p(e),c(fe.$$.fragment,e),mt=p(e),c(Ue.$$.fragment,e),ot=p(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-kyltif"&&(de.innerHTML=Wp),jt=p(e),ke=i(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-1e0xtn8"&&(ke.innerHTML=Rp),Tt=p(e),c($e.$$.fragment,e),ut=p(e),c(be.$$.fragment,e),ft=p(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1nd2ny2"&&(we.innerHTML=Np),Ut=p(e),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-na8mx0"&&(Ce.textContent=Xp),dt=p(e),c(ge.$$.fragment,e),kt=p(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-rveu42"&&(he.textContent=Ap),$t=p(e),xe=i(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-8cfq99"&&(xe.textContent=Ep),bt=p(e),c(Ie.$$.fragment,e),wt=p(e),c(Ve.$$.fragment,e),Ct=p(e),ze=i(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-utpzay"&&(ze.textContent=Gp),gt=p(e),c(Ze.$$.fragment,e),ht=p(e),c(ve.$$.fragment,e),xt=p(e),_e=i(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-7ww78z"&&(_e.textContent=qp),It=p(e),c(Qe.$$.fragment,e),Vt=p(e),Be=i(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-106lhsb"&&(Be.innerHTML=Lp),zt=p(e),c(We.$$.fragment,e),Zt=p(e),c(Re.$$.fragment,e),vt=p(e),Ne=i(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-189m9gi"&&(Ne.textContent=Hp),_t=p(e),c(Xe.$$.fragment,e),Qt=p(e),Ae=i(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-pm7hiy"&&(Ae.innerHTML=Sp),Bt=p(e),c(Ee.$$.fragment,e),Wt=p(e),Ge=i(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1cpidft"&&(Ge.innerHTML=Dp),Rt=p(e),qe=i(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1dxzktr"&&(qe.innerHTML=Pp),Nt=p(e),c(Le.$$.fragment,e),Xt=p(e),He=i(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-ttz8i2"&&(He.innerHTML=Yp),At=p(e),c(Se.$$.fragment,e),Et=p(e),De=i(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1ij2bkd"&&(De.innerHTML=Fp),Gt=p(e),Pe=i(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1x7u3bt"&&(Pe.textContent=Kp),qt=p(e),c(Ye.$$.fragment,e),Lt=p(e),Fe=i(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-ms4jk9"&&(Fe.innerHTML=Op),Ht=p(e),c(Ke.$$.fragment,e),St=p(e),Oe=i(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1efr97x"&&(Oe.innerHTML=ea),Dt=p(e),es=i(e,"P",{"data-svelte-h":!0}),M(es)!=="svelte-zmu7y2"&&(es.textContent=sa),Pt=p(e),c(ss.$$.fragment,e),Yt=p(e),ls=i(e,"P",{"data-svelte-h":!0}),M(ls)!=="svelte-1cizskw"&&(ls.innerHTML=la),Ft=p(e),c(ts.$$.fragment,e),Kt=p(e),c(ns.$$.fragment,e),Ot=p(e),ps=i(e,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-1a0orcp"&&(ps.textContent=ta),en=p(e),c(as.$$.fragment,e),sn=p(e),is=i(e,"P",{"data-svelte-h":!0}),M(is)!=="svelte-1p9vr1i"&&(is.innerHTML=na),ln=p(e),Ms=i(e,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-u4s8kx"&&(Ms.textContent=pa),tn=p(e),c(rs.$$.fragment,e),nn=p(e),cs=i(e,"P",{"data-svelte-h":!0}),M(cs)!=="svelte-cmzjwq"&&(cs.textContent=aa),pn=p(e),c(ys.$$.fragment,e),an=p(e),c(Js.$$.fragment,e),Mn=p(e),ms=i(e,"P",{"data-svelte-h":!0}),M(ms)!=="svelte-1gd6jqz"&&(ms.textContent=ia),rn=p(e),c(os.$$.fragment,e),cn=p(e),js=i(e,"P",{"data-svelte-h":!0}),M(js)!=="svelte-1g95bkh"&&(js.innerHTML=Ma),yn=p(e),c(Ts.$$.fragment,e),Jn=p(e),c(us.$$.fragment,e),mn=p(e),fs=i(e,"P",{"data-svelte-h":!0}),M(fs)!=="svelte-eerktk"&&(fs.textContent=ra),on=p(e),c(Us.$$.fragment,e),jn=p(e),ds=i(e,"P",{"data-svelte-h":!0}),M(ds)!=="svelte-yra0gn"&&(ds.textContent=ca),Tn=p(e),c(ks.$$.fragment,e),un=p(e),c($s.$$.fragment,e),fn=p(e),bs=i(e,"P",{"data-svelte-h":!0}),M(bs)!=="svelte-ka6eer"&&(bs.innerHTML=ya),Un=p(e),c(ws.$$.fragment,e),dn=p(e),Cs=i(e,"P",{"data-svelte-h":!0}),M(Cs)!=="svelte-1cmlt11"&&(Cs.textContent=Ja),kn=p(e),c(gs.$$.fragment,e),$n=p(e),hs=i(e,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-upbbw9"&&(hs.textContent=ma),bn=p(e),c(xs.$$.fragment,e),wn=p(e),Is=i(e,"P",{"data-svelte-h":!0}),M(Is)!=="svelte-gprlmq"&&(Is.innerHTML=oa),Cn=p(e),c(Vs.$$.fragment,e),gn=p(e),zs=i(e,"P",{"data-svelte-h":!0}),M(zs)!=="svelte-1yy918s"&&(zs.textContent=ja),hn=p(e),Zs=i(e,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1n71160"&&(Zs.textContent=Ta),xn=p(e),c(vs.$$.fragment,e),In=p(e),_s=i(e,"P",{"data-svelte-h":!0}),M(_s)!=="svelte-197ybm4"&&(_s.innerHTML=ua),Vn=p(e),Qs=i(e,"P",{"data-svelte-h":!0}),M(Qs)!=="svelte-f4i3wg"&&(Qs.innerHTML=fa),zn=p(e),c(Bs.$$.fragment,e),Zn=p(e),Ws=i(e,"P",{"data-svelte-h":!0}),M(Ws)!=="svelte-xj6oo"&&(Ws.textContent=Ua),vn=p(e),c(Rs.$$.fragment,e),_n=p(e),c(Ns.$$.fragment,e),Qn=p(e),Xs=i(e,"P",{"data-svelte-h":!0}),M(Xs)!=="svelte-1tjrbj7"&&(Xs.textContent=da),Bn=p(e),c(As.$$.fragment,e),Wn=p(e),Es=i(e,"P",{"data-svelte-h":!0}),M(Es)!=="svelte-z62fgj"&&(Es.innerHTML=ka),Rn=p(e),Gs=i(e,"P",{"data-svelte-h":!0}),M(Gs)!=="svelte-u4s8kx"&&(Gs.textContent=$a),Nn=p(e),c(qs.$$.fragment,e),Xn=p(e),Ls=i(e,"P",{"data-svelte-h":!0}),M(Ls)!=="svelte-1gxe1cq"&&(Ls.textContent=ba),An=p(e),c(Hs.$$.fragment,e),En=p(e),c(Ss.$$.fragment,e),Gn=p(e),Ds=i(e,"P",{"data-svelte-h":!0}),M(Ds)!=="svelte-hd4plk"&&(Ds.innerHTML=wa),qn=p(e),c(Ps.$$.fragment,e),Ln=p(e),c(Ys.$$.fragment,e),Hn=p(e),Fs=i(e,"P",{"data-svelte-h":!0}),M(Fs)!=="svelte-1b1rase"&&(Fs.textContent=Ca),Sn=p(e),c(Ks.$$.fragment,e),Dn=p(e),Os=i(e,"P",{"data-svelte-h":!0}),M(Os)!=="svelte-45g554"&&(Os.textContent=ga),Pn=p(e),c(el.$$.fragment,e),Yn=p(e),c(sl.$$.fragment,e),Fn=p(e),ll=i(e,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-1b0rt28"&&(ll.innerHTML=ha),Kn=p(e),c(tl.$$.fragment,e),On=p(e),nl=i(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-tmcl78"&&(nl.innerHTML=xa),ep=p(e),c(pl.$$.fragment,e),sp=p(e),al=i(e,"P",{"data-svelte-h":!0}),M(al)!=="svelte-b94jpj"&&(al.textContent=Ia),lp=p(e),c(il.$$.fragment,e),tp=p(e),Ml=i(e,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-15vwsr5"&&(Ml.textContent=Va),np=p(e),c(rl.$$.fragment,e),pp=p(e),yl=i(e,"P",{}),Za(yl).forEach(l),this.h()},h(){ip(T,"name","hf:doc:metadata"),ip(T,"content",Ha),ip(f,"class","flex justify-center")},m(e,s){Na(document.head,T),t(e,d,s),t(e,u,s),t(e,cl,s),y(k,e,s),t(e,ol,s),y($,e,s),t(e,jl,s),t(e,b,s),t(e,Tl,s),t(e,w,s),t(e,ul,s),t(e,C,s),t(e,fl,s),t(e,f,s),t(e,Ul,s),t(e,g,s),t(e,dl,s),y(h,e,s),t(e,kl,s),t(e,x,s),t(e,$l,s),t(e,I,s),t(e,bl,s),t(e,V,s),t(e,wl,s),y(z,e,s),t(e,Cl,s),t(e,Z,s),t(e,gl,s),y(v,e,s),t(e,hl,s),t(e,_,s),t(e,xl,s),t(e,Q,s),t(e,Il,s),y(B,e,s),t(e,Vl,s),t(e,W,s),t(e,zl,s),y(R,e,s),t(e,Zl,s),t(e,N,s),t(e,vl,s),t(e,X,s),t(e,_l,s),y(A,e,s),t(e,Ql,s),t(e,E,s),t(e,Bl,s),t(e,G,s),t(e,Wl,s),y(q,e,s),t(e,Rl,s),t(e,L,s),t(e,Nl,s),y(H,e,s),t(e,Xl,s),t(e,S,s),t(e,Al,s),t(e,D,s),t(e,El,s),y(P,e,s),t(e,Gl,s),y(Y,e,s),t(e,ql,s),y(U,e,s),t(e,Ll,s),t(e,F,s),t(e,Hl,s),y(K,e,s),t(e,Sl,s),t(e,O,s),t(e,Dl,s),y(ee,e,s),t(e,Pl,s),t(e,se,s),t(e,Yl,s),y(le,e,s),t(e,Fl,s),y(te,e,s),t(e,Kl,s),t(e,ne,s),t(e,Ol,s),y(pe,e,s),t(e,et,s),y(ae,e,s),t(e,st,s),t(e,ie,s),t(e,lt,s),y(Me,e,s),t(e,tt,s),y(re,e,s),t(e,nt,s),t(e,ce,s),t(e,pt,s),y(ye,e,s),t(e,at,s),t(e,Je,s),t(e,it,s),t(e,me,s),t(e,Mt,s),y(oe,e,s),t(e,rt,s),t(e,je,s),t(e,ct,s),y(Te,e,s),t(e,yt,s),t(e,ue,s),t(e,Jt,s),y(fe,e,s),t(e,mt,s),y(Ue,e,s),t(e,ot,s),t(e,de,s),t(e,jt,s),t(e,ke,s),t(e,Tt,s),y($e,e,s),t(e,ut,s),y(be,e,s),t(e,ft,s),t(e,we,s),t(e,Ut,s),t(e,Ce,s),t(e,dt,s),y(ge,e,s),t(e,kt,s),t(e,he,s),t(e,$t,s),t(e,xe,s),t(e,bt,s),y(Ie,e,s),t(e,wt,s),y(Ve,e,s),t(e,Ct,s),t(e,ze,s),t(e,gt,s),y(Ze,e,s),t(e,ht,s),y(ve,e,s),t(e,xt,s),t(e,_e,s),t(e,It,s),y(Qe,e,s),t(e,Vt,s),t(e,Be,s),t(e,zt,s),y(We,e,s),t(e,Zt,s),y(Re,e,s),t(e,vt,s),t(e,Ne,s),t(e,_t,s),y(Xe,e,s),t(e,Qt,s),t(e,Ae,s),t(e,Bt,s),y(Ee,e,s),t(e,Wt,s),t(e,Ge,s),t(e,Rt,s),t(e,qe,s),t(e,Nt,s),y(Le,e,s),t(e,Xt,s),t(e,He,s),t(e,At,s),y(Se,e,s),t(e,Et,s),t(e,De,s),t(e,Gt,s),t(e,Pe,s),t(e,qt,s),y(Ye,e,s),t(e,Lt,s),t(e,Fe,s),t(e,Ht,s),y(Ke,e,s),t(e,St,s),t(e,Oe,s),t(e,Dt,s),t(e,es,s),t(e,Pt,s),y(ss,e,s),t(e,Yt,s),t(e,ls,s),t(e,Ft,s),y(ts,e,s),t(e,Kt,s),y(ns,e,s),t(e,Ot,s),t(e,ps,s),t(e,en,s),y(as,e,s),t(e,sn,s),t(e,is,s),t(e,ln,s),t(e,Ms,s),t(e,tn,s),y(rs,e,s),t(e,nn,s),t(e,cs,s),t(e,pn,s),y(ys,e,s),t(e,an,s),y(Js,e,s),t(e,Mn,s),t(e,ms,s),t(e,rn,s),y(os,e,s),t(e,cn,s),t(e,js,s),t(e,yn,s),y(Ts,e,s),t(e,Jn,s),y(us,e,s),t(e,mn,s),t(e,fs,s),t(e,on,s),y(Us,e,s),t(e,jn,s),t(e,ds,s),t(e,Tn,s),y(ks,e,s),t(e,un,s),y($s,e,s),t(e,fn,s),t(e,bs,s),t(e,Un,s),y(ws,e,s),t(e,dn,s),t(e,Cs,s),t(e,kn,s),y(gs,e,s),t(e,$n,s),t(e,hs,s),t(e,bn,s),y(xs,e,s),t(e,wn,s),t(e,Is,s),t(e,Cn,s),y(Vs,e,s),t(e,gn,s),t(e,zs,s),t(e,hn,s),t(e,Zs,s),t(e,xn,s),y(vs,e,s),t(e,In,s),t(e,_s,s),t(e,Vn,s),t(e,Qs,s),t(e,zn,s),y(Bs,e,s),t(e,Zn,s),t(e,Ws,s),t(e,vn,s),y(Rs,e,s),t(e,_n,s),y(Ns,e,s),t(e,Qn,s),t(e,Xs,s),t(e,Bn,s),y(As,e,s),t(e,Wn,s),t(e,Es,s),t(e,Rn,s),t(e,Gs,s),t(e,Nn,s),y(qs,e,s),t(e,Xn,s),t(e,Ls,s),t(e,An,s),y(Hs,e,s),t(e,En,s),y(Ss,e,s),t(e,Gn,s),t(e,Ds,s),t(e,qn,s),y(Ps,e,s),t(e,Ln,s),y(Ys,e,s),t(e,Hn,s),t(e,Fs,s),t(e,Sn,s),y(Ks,e,s),t(e,Dn,s),t(e,Os,s),t(e,Pn,s),y(el,e,s),t(e,Yn,s),y(sl,e,s),t(e,Fn,s),t(e,ll,s),t(e,Kn,s),y(tl,e,s),t(e,On,s),t(e,nl,s),t(e,ep,s),y(pl,e,s),t(e,sp,s),t(e,al,s),t(e,lp,s),y(il,e,s),t(e,tp,s),t(e,Ml,s),t(e,np,s),y(rl,e,s),t(e,pp,s),t(e,yl,s),ap=!0},p(e,[s]){const za={};s&2&&(za.$$scope={dirty:s,ctx:e}),U.$set(za)},i(e){ap||(J(k.$$.fragment,e),J($.$$.fragment,e),J(h.$$.fragment,e),J(z.$$.fragment,e),J(v.$$.fragment,e),J(B.$$.fragment,e),J(R.$$.fragment,e),J(A.$$.fragment,e),J(q.$$.fragment,e),J(H.$$.fragment,e),J(P.$$.fragment,e),J(Y.$$.fragment,e),J(U.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(te.$$.fragment,e),J(pe.$$.fragment,e),J(ae.$$.fragment,e),J(Me.$$.fragment,e),J(re.$$.fragment,e),J(ye.$$.fragment,e),J(oe.$$.fragment,e),J(Te.$$.fragment,e),J(fe.$$.fragment,e),J(Ue.$$.fragment,e),J($e.$$.fragment,e),J(be.$$.fragment,e),J(ge.$$.fragment,e),J(Ie.$$.fragment,e),J(Ve.$$.fragment,e),J(Ze.$$.fragment,e),J(ve.$$.fragment,e),J(Qe.$$.fragment,e),J(We.$$.fragment,e),J(Re.$$.fragment,e),J(Xe.$$.fragment,e),J(Ee.$$.fragment,e),J(Le.$$.fragment,e),J(Se.$$.fragment,e),J(Ye.$$.fragment,e),J(Ke.$$.fragment,e),J(ss.$$.fragment,e),J(ts.$$.fragment,e),J(ns.$$.fragment,e),J(as.$$.fragment,e),J(rs.$$.fragment,e),J(ys.$$.fragment,e),J(Js.$$.fragment,e),J(os.$$.fragment,e),J(Ts.$$.fragment,e),J(us.$$.fragment,e),J(Us.$$.fragment,e),J(ks.$$.fragment,e),J($s.$$.fragment,e),J(ws.$$.fragment,e),J(gs.$$.fragment,e),J(xs.$$.fragment,e),J(Vs.$$.fragment,e),J(vs.$$.fragment,e),J(Bs.$$.fragment,e),J(Rs.$$.fragment,e),J(Ns.$$.fragment,e),J(As.$$.fragment,e),J(qs.$$.fragment,e),J(Hs.$$.fragment,e),J(Ss.$$.fragment,e),J(Ps.$$.fragment,e),J(Ys.$$.fragment,e),J(Ks.$$.fragment,e),J(el.$$.fragment,e),J(sl.$$.fragment,e),J(tl.$$.fragment,e),J(pl.$$.fragment,e),J(il.$$.fragment,e),J(rl.$$.fragment,e),ap=!0)},o(e){m(k.$$.fragment,e),m($.$$.fragment,e),m(h.$$.fragment,e),m(z.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(R.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(H.$$.fragment,e),m(P.$$.fragment,e),m(Y.$$.fragment,e),m(U.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(te.$$.fragment,e),m(pe.$$.fragment,e),m(ae.$$.fragment,e),m(Me.$$.fragment,e),m(re.$$.fragment,e),m(ye.$$.fragment,e),m(oe.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(be.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Ve.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),m(Qe.$$.fragment,e),m(We.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(Ee.$$.fragment,e),m(Le.$$.fragment,e),m(Se.$$.fragment,e),m(Ye.$$.fragment,e),m(Ke.$$.fragment,e),m(ss.$$.fragment,e),m(ts.$$.fragment,e),m(ns.$$.fragment,e),m(as.$$.fragment,e),m(rs.$$.fragment,e),m(ys.$$.fragment,e),m(Js.$$.fragment,e),m(os.$$.fragment,e),m(Ts.$$.fragment,e),m(us.$$.fragment,e),m(Us.$$.fragment,e),m(ks.$$.fragment,e),m($s.$$.fragment,e),m(ws.$$.fragment,e),m(gs.$$.fragment,e),m(xs.$$.fragment,e),m(Vs.$$.fragment,e),m(vs.$$.fragment,e),m(Bs.$$.fragment,e),m(Rs.$$.fragment,e),m(Ns.$$.fragment,e),m(As.$$.fragment,e),m(qs.$$.fragment,e),m(Hs.$$.fragment,e),m(Ss.$$.fragment,e),m(Ps.$$.fragment,e),m(Ys.$$.fragment,e),m(Ks.$$.fragment,e),m(el.$$.fragment,e),m(sl.$$.fragment,e),m(tl.$$.fragment,e),m(pl.$$.fragment,e),m(il.$$.fragment,e),m(rl.$$.fragment,e),ap=!1},d(e){e&&(l(d),l(u),l(cl),l(ol),l(jl),l(b),l(Tl),l(w),l(ul),l(C),l(fl),l(f),l(Ul),l(g),l(dl),l(kl),l(x),l($l),l(I),l(bl),l(V),l(wl),l(Cl),l(Z),l(gl),l(hl),l(_),l(xl),l(Q),l(Il),l(Vl),l(W),l(zl),l(Zl),l(N),l(vl),l(X),l(_l),l(Ql),l(E),l(Bl),l(G),l(Wl),l(Rl),l(L),l(Nl),l(Xl),l(S),l(Al),l(D),l(El),l(Gl),l(ql),l(Ll),l(F),l(Hl),l(Sl),l(O),l(Dl),l(Pl),l(se),l(Yl),l(Fl),l(Kl),l(ne),l(Ol),l(et),l(st),l(ie),l(lt),l(tt),l(nt),l(ce),l(pt),l(at),l(Je),l(it),l(me),l(Mt),l(rt),l(je),l(ct),l(yt),l(ue),l(Jt),l(mt),l(ot),l(de),l(jt),l(ke),l(Tt),l(ut),l(ft),l(we),l(Ut),l(Ce),l(dt),l(kt),l(he),l($t),l(xe),l(bt),l(wt),l(Ct),l(ze),l(gt),l(ht),l(xt),l(_e),l(It),l(Vt),l(Be),l(zt),l(Zt),l(vt),l(Ne),l(_t),l(Qt),l(Ae),l(Bt),l(Wt),l(Ge),l(Rt),l(qe),l(Nt),l(Xt),l(He),l(At),l(Et),l(De),l(Gt),l(Pe),l(qt),l(Lt),l(Fe),l(Ht),l(St),l(Oe),l(Dt),l(es),l(Pt),l(Yt),l(ls),l(Ft),l(Kt),l(Ot),l(ps),l(en),l(sn),l(is),l(ln),l(Ms),l(tn),l(nn),l(cs),l(pn),l(an),l(Mn),l(ms),l(rn),l(cn),l(js),l(yn),l(Jn),l(mn),l(fs),l(on),l(jn),l(ds),l(Tn),l(un),l(fn),l(bs),l(Un),l(dn),l(Cs),l(kn),l($n),l(hs),l(bn),l(wn),l(Is),l(Cn),l(gn),l(zs),l(hn),l(Zs),l(xn),l(In),l(_s),l(Vn),l(Qs),l(zn),l(Zn),l(Ws),l(vn),l(_n),l(Qn),l(Xs),l(Bn),l(Wn),l(Es),l(Rn),l(Gs),l(Nn),l(Xn),l(Ls),l(An),l(En),l(Gn),l(Ds),l(qn),l(Ln),l(Hn),l(Fs),l(Sn),l(Dn),l(Os),l(Pn),l(Yn),l(Fn),l(ll),l(Kn),l(On),l(nl),l(ep),l(sp),l(al),l(lp),l(tp),l(Ml),l(np),l(pp),l(yl)),l(T),o(k,e),o($,e),o(h,e),o(z,e),o(v,e),o(B,e),o(R,e),o(A,e),o(q,e),o(H,e),o(P,e),o(Y,e),o(U,e),o(K,e),o(ee,e),o(le,e),o(te,e),o(pe,e),o(ae,e),o(Me,e),o(re,e),o(ye,e),o(oe,e),o(Te,e),o(fe,e),o(Ue,e),o($e,e),o(be,e),o(ge,e),o(Ie,e),o(Ve,e),o(Ze,e),o(ve,e),o(Qe,e),o(We,e),o(Re,e),o(Xe,e),o(Ee,e),o(Le,e),o(Se,e),o(Ye,e),o(Ke,e),o(ss,e),o(ts,e),o(ns,e),o(as,e),o(rs,e),o(ys,e),o(Js,e),o(os,e),o(Ts,e),o(us,e),o(Us,e),o(ks,e),o($s,e),o(ws,e),o(gs,e),o(xs,e),o(Vs,e),o(vs,e),o(Bs,e),o(Rs,e),o(Ns,e),o(As,e),o(qs,e),o(Hs,e),o(Ss,e),o(Ps,e),o(Ys,e),o(Ks,e),o(el,e),o(sl,e),o(tl,e),o(pl,e),o(il,e),o(rl,e)}}}const Ha='{"title":"Создание токенизатора, блок за блоком","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Получение корпуса текста","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Создание токенизатора WordPiece с нуля","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора BPE с нуля","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора Unigram с нуля","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function Sa(ml){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class si extends Ba{constructor(T){super(),Wa(this,T,Sa,La,va,{})}}export{si as component};
