import{s as Cl,n as Zl,o as Nl}from"../chunks/scheduler.85c25b89.js";import{S as xl,i as Bl,g as p,s as e,r as i,A as $l,h as m,f as t,c as n,j as Il,u as M,x as o,k as Al,y as Gl,a,v as c,d as r,t as J,w as j}from"../chunks/index.c9bcf812.js";import{C as R}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function Wl(Jl){let h,V,Q,_,T,H,g,jl='A <strong>ResNeXt</strong> repeats a <a href="https://paperswithcode.com/method/resnext-block" rel="nofollow">building block</a> that aggregates a set of transformations with the same topology. Compared to a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>, it exposes a new dimension,  <em>cardinality</em> (the size of the set of transformations) $C$, as an essential factor in addition to the dimensions of depth and width.',z,w,hl='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',S,d,F,y,Tl="To load a pretrained model:",D,u,L,b,gl="To load and preprocess the image:",P,f,q,U,wl="To get the model predictions:",K,I,O,A,dl="To get the top-5 predictions class names:",ll,C,sl,Z,yl="Replace the model name with the variant you want to use, e.g. <code>gluon_resnext101_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",tl,N,ul='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',al,x,el,B,bl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nl,$,pl,G,fl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ml,W,il,E,Ul='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Ml,k,ol,v,cl,X,rl;return T=new Y({props:{title:"(Gluon) ResNeXt",local:"gluon-resnext",headingTag:"h1"}}),d=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3Jlc25leHQxMDFfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),$=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fcmVzbmV4dDEwMV8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),k=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTYWluaW5nJTIwWGllJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm9zcyUyMEIuJTIwR2lyc2hpY2slMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQaW90ciUyMERvbGwlN0IlNUMnJTdCYSU3RCU3RHIlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVvd2VuJTIwVHUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLYWltaW5nJTIwSGUlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkFnZ3JlZ2F0ZWQlMjBSZXNpZHVhbCUyMFRyYW5zZm9ybWF0aW9ucyUyMGZvciUyMERlZXAlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlMjAlMjAlMjAlM0QlMjAlN0JDb1JSJTdEJTJDJTBBJTIwJTIwdm9sdW1lJTIwJTIwJTIwJTIwJTNEJTIwJTdCYWJzJTJGMTYxMS4wNTQzMSU3RCUyQyUwQSUyMCUyMHllYXIlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0IyMDE2JTdEJTJDJTBBJTIwJTIwdXJsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cCUzQSUyRiUyRmFyeGl2Lm9yZyUyRmFicyUyRjE2MTEuMDU0MzElN0QlMkMlMEElMjAlMjBhcmNoaXZlUHJlZml4JTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjBlcHJpbnQlMjAlMjAlMjAlMjAlM0QlMjAlN0IxNjExLjA1NDMxJTdEJTJDJTBBJTIwJTIwdGltZXN0YW1wJTIwJTNEJTIwJTdCTW9uJTJDJTIwMTMlMjBBdWclMjAyMDE4JTIwMTYlM0E0NSUzQTU4JTIwJTJCMDIwMCU3RCUyQyUwQSUyMCUyMGJpYnVybCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHBzJTNBJTJGJTJGZGJscC5vcmclMkZyZWMlMkZqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/XieGDTH16,
  author    = {Saining Xie and
               Ross B. Girshick and
               Piotr Doll{\\&#x27;{a}</span><span class="language-xml">}r and
               Zhuowen Tu and
               Kaiming He},
  title     = </span><span class="hljs-template-variable">{Aggregated Residual Transformations for Deep Neural Networks}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1611.05431}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1611.05431}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1611.05431}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 13 Aug 2018 16:45:58 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/XieGDTH16.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){h=p("meta"),V=e(),Q=p("p"),_=e(),i(T.$$.fragment),H=e(),g=p("p"),g.innerHTML=jl,z=e(),w=p("p"),w.innerHTML=hl,S=e(),i(d.$$.fragment),F=e(),y=p("p"),y.textContent=Tl,D=e(),i(u.$$.fragment),L=e(),b=p("p"),b.textContent=gl,P=e(),i(f.$$.fragment),q=e(),U=p("p"),U.textContent=wl,K=e(),i(I.$$.fragment),O=e(),A=p("p"),A.textContent=dl,ll=e(),i(C.$$.fragment),sl=e(),Z=p("p"),Z.innerHTML=yl,tl=e(),N=p("p"),N.innerHTML=ul,al=e(),i(x.$$.fragment),el=e(),B=p("p"),B.textContent=bl,nl=e(),i($.$$.fragment),pl=e(),G=p("p"),G.innerHTML=fl,ml=e(),i(W.$$.fragment),il=e(),E=p("p"),E.innerHTML=Ul,Ml=e(),i(k.$$.fragment),ol=e(),i(v.$$.fragment),cl=e(),X=p("p"),this.h()},l(l){const s=$l("svelte-u9bgzb",document.head);h=m(s,"META",{name:!0,content:!0}),s.forEach(t),V=n(l),Q=m(l,"P",{}),Il(Q).forEach(t),_=n(l),M(T.$$.fragment,l),H=n(l),g=m(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-lhf39w"&&(g.innerHTML=jl),z=n(l),w=m(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1vag5uc"&&(w.innerHTML=hl),S=n(l),M(d.$$.fragment,l),F=n(l),y=m(l,"P",{"data-svelte-h":!0}),o(y)!=="svelte-18ywhxh"&&(y.textContent=Tl),D=n(l),M(u.$$.fragment,l),L=n(l),b=m(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1c2ipa8"&&(b.textContent=gl),P=n(l),M(f.$$.fragment,l),q=n(l),U=m(l,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1n9qsq1"&&(U.textContent=wl),K=n(l),M(I.$$.fragment,l),O=n(l),A=m(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-19cnvx1"&&(A.textContent=dl),ll=n(l),M(C.$$.fragment,l),sl=n(l),Z=m(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-nnyatb"&&(Z.innerHTML=yl),tl=n(l),N=m(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wmi3ea"&&(N.innerHTML=ul),al=n(l),M(x.$$.fragment,l),el=n(l),B=m(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9sr7nh"&&(B.textContent=bl),nl=n(l),M($.$$.fragment,l),pl=n(l),G=m(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1kguc51"&&(G.innerHTML=fl),ml=n(l),M(W.$$.fragment,l),il=n(l),E=m(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1n0coha"&&(E.innerHTML=Ul),Ml=n(l),M(k.$$.fragment,l),ol=n(l),M(v.$$.fragment,l),cl=n(l),X=m(l,"P",{}),Il(X).forEach(t),this.h()},h(){Al(h,"name","hf:doc:metadata"),Al(h,"content",El)},m(l,s){Gl(document.head,h),a(l,V,s),a(l,Q,s),a(l,_,s),c(T,l,s),a(l,H,s),a(l,g,s),a(l,z,s),a(l,w,s),a(l,S,s),c(d,l,s),a(l,F,s),a(l,y,s),a(l,D,s),c(u,l,s),a(l,L,s),a(l,b,s),a(l,P,s),c(f,l,s),a(l,q,s),a(l,U,s),a(l,K,s),c(I,l,s),a(l,O,s),a(l,A,s),a(l,ll,s),c(C,l,s),a(l,sl,s),a(l,Z,s),a(l,tl,s),a(l,N,s),a(l,al,s),c(x,l,s),a(l,el,s),a(l,B,s),a(l,nl,s),c($,l,s),a(l,pl,s),a(l,G,s),a(l,ml,s),c(W,l,s),a(l,il,s),a(l,E,s),a(l,Ml,s),c(k,l,s),a(l,ol,s),c(v,l,s),a(l,cl,s),a(l,X,s),rl=!0},p:Zl,i(l){rl||(r(T.$$.fragment,l),r(d.$$.fragment,l),r(u.$$.fragment,l),r(f.$$.fragment,l),r(I.$$.fragment,l),r(C.$$.fragment,l),r(x.$$.fragment,l),r($.$$.fragment,l),r(W.$$.fragment,l),r(k.$$.fragment,l),r(v.$$.fragment,l),rl=!0)},o(l){J(T.$$.fragment,l),J(d.$$.fragment,l),J(u.$$.fragment,l),J(f.$$.fragment,l),J(I.$$.fragment,l),J(C.$$.fragment,l),J(x.$$.fragment,l),J($.$$.fragment,l),J(W.$$.fragment,l),J(k.$$.fragment,l),J(v.$$.fragment,l),rl=!1},d(l){l&&(t(V),t(Q),t(_),t(H),t(g),t(z),t(w),t(S),t(F),t(y),t(D),t(L),t(b),t(P),t(q),t(U),t(K),t(O),t(A),t(ll),t(sl),t(Z),t(tl),t(N),t(al),t(el),t(B),t(nl),t(pl),t(G),t(ml),t(il),t(E),t(Ml),t(ol),t(cl),t(X)),t(h),j(T,l),j(d,l),j(u,l),j(f,l),j(I,l),j(C,l),j(x,l),j($,l),j(W,l),j(k,l),j(v,l)}}}const El='{"title":"(Gluon) ResNeXt","local":"gluon-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function kl(Jl){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends xl{constructor(h){super(),Bl(this,h,kl,Wl,Cl,{})}}export{Yl as component};
