import{s as Ut,n as $t,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as Ct,i as kt,g as p,s as e,r as m,A as Wt,h as i,f as l,c as n,j as bt,u as o,x as j,k as ft,y as It,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as R}from"../chunks/CodeBlock.94efc595.js";import{H as A}from"../chunks/Heading.3c6e5b17.js";function Bt(rt){let d,Y,v,S,y,F,g,ht='A <strong>ResNeSt</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>, which instead stacks <a href="https://paperswithcode.com/method/split-attention" rel="nofollow">Split-Attention blocks</a>. The cardinal group representations are then concatenated along the channel dimension: $V = \\text{Concat}${$V^{1},V^{2},\\cdots{V}^{K}$}. As in standard residual blocks, the final output $Y$ of otheur Split-Attention block is produced using a shortcut connection: $Y=V+X$, if the input and output feature-map share the same shape.  For blocks with a stride, an appropriate transformation $\\mathcal{T}$ is applied to the shortcut connection to align the output shapes:  $Y=V+\\mathcal{T}(X)$. For example, $\\mathcal{T}$ can be strided convolution or combined convolution-with-pooling.',X,u,_,w,Mt="To load a pretrained model:",H,J,z,T,jt="To load and preprocess the image:",L,b,D,f,dt="To get the model predictions:",q,U,P,$,yt="To get the top-5 predictions class names:",K,Z,O,C,gt="Replace the model name with the variant you want to use, e.g. <code>resnest101e</code>. You can find the IDs in the model summaries at the top of this page.",tt,k,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,W,lt,I,wt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,B,et,G,Jt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,x,pt,N,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,Q,mt,E,ot,V,ct;return y=new A({props:{title:"ResNeSt",local:"resnest",headingTag:"h1"}}),u=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),J=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25lc3QxMDFlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnest101e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmVzdDEwMWUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnest101e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new R({props:{code:"JTQwbWlzYyU3QnpoYW5nMjAyMHJlc25lc3QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlc05lU3QlM0ElMjBTcGxpdC1BdHRlbnRpb24lMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkhhbmclMjBaaGFuZyUyMGFuZCUyMENob25ncnVvJTIwV3UlMjBhbmQlMjBaaG9uZ3l1ZSUyMFpoYW5nJTIwYW5kJTIwWWklMjBaaHUlMjBhbmQlMjBIYWliaW4lMjBMaW4lMjBhbmQlMjBaaGklMjBaaGFuZyUyMGFuZCUyMFl1ZSUyMFN1biUyMGFuZCUyMFRvbmclMjBIZSUyMGFuZCUyMEpvbmFzJTIwTXVlbGxlciUyMGFuZCUyMFIuJTIwTWFubWF0aGElMjBhbmQlMjBNdSUyMExpJTIwYW5kJTIwQWxleGFuZGVyJTIwU21vbGElN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDQuMDg5NTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zhang2020resnest,
      title={ResNeSt: Split-Attention Networks}, 
      author={Hang Zhang <span class="hljs-keyword">and </span>Chongruo Wu <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span>Yi Zhu <span class="hljs-keyword">and </span>Haibin Lin <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Yue Sun <span class="hljs-keyword">and </span>Tong He <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonas </span>Mueller <span class="hljs-keyword">and </span>R. Manmatha <span class="hljs-keyword">and </span>Mu Li <span class="hljs-keyword">and </span>Alexander Smola},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2004</span>.<span class="hljs-number">08955</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){d=p("meta"),Y=e(),v=p("p"),S=e(),m(y.$$.fragment),F=e(),g=p("p"),g.innerHTML=ht,X=e(),m(u.$$.fragment),_=e(),w=p("p"),w.textContent=Mt,H=e(),m(J.$$.fragment),z=e(),T=p("p"),T.textContent=jt,L=e(),m(b.$$.fragment),D=e(),f=p("p"),f.textContent=dt,q=e(),m(U.$$.fragment),P=e(),$=p("p"),$.textContent=yt,K=e(),m(Z.$$.fragment),O=e(),C=p("p"),C.innerHTML=gt,tt=e(),k=p("p"),k.innerHTML=ut,st=e(),m(W.$$.fragment),lt=e(),I=p("p"),I.textContent=wt,at=e(),m(B.$$.fragment),et=e(),G=p("p"),G.innerHTML=Jt,nt=e(),m(x.$$.fragment),pt=e(),N=p("p"),N.innerHTML=Tt,it=e(),m(Q.$$.fragment),mt=e(),m(E.$$.fragment),ot=e(),V=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(l),Y=n(t),v=i(t,"P",{}),bt(v).forEach(l),S=n(t),o(y.$$.fragment,t),F=n(t),g=i(t,"P",{"data-svelte-h":!0}),j(g)!=="svelte-rzo38z"&&(g.innerHTML=ht),X=n(t),o(u.$$.fragment,t),_=n(t),w=i(t,"P",{"data-svelte-h":!0}),j(w)!=="svelte-18ywhxh"&&(w.textContent=Mt),H=n(t),o(J.$$.fragment,t),z=n(t),T=i(t,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1c2ipa8"&&(T.textContent=jt),L=n(t),o(b.$$.fragment,t),D=n(t),f=i(t,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=dt),q=n(t),o(U.$$.fragment,t),P=n(t),$=i(t,"P",{"data-svelte-h":!0}),j($)!=="svelte-19cnvx1"&&($.textContent=yt),K=n(t),o(Z.$$.fragment,t),O=n(t),C=i(t,"P",{"data-svelte-h":!0}),j(C)!=="svelte-307al9"&&(C.innerHTML=gt),tt=n(t),k=i(t,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ut),st=n(t),o(W.$$.fragment,t),lt=n(t),I=i(t,"P",{"data-svelte-h":!0}),j(I)!=="svelte-9sr7nh"&&(I.textContent=wt),at=n(t),o(B.$$.fragment,t),et=n(t),G=i(t,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1kguc51"&&(G.innerHTML=Jt),nt=n(t),o(x.$$.fragment,t),pt=n(t),N=i(t,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1n0coha"&&(N.innerHTML=Tt),it=n(t),o(Q.$$.fragment,t),mt=n(t),o(E.$$.fragment,t),ot=n(t),V=i(t,"P",{}),bt(V).forEach(l),this.h()},h(){ft(d,"name","hf:doc:metadata"),ft(d,"content",Gt)},m(t,s){It(document.head,d),a(t,Y,s),a(t,v,s),a(t,S,s),c(y,t,s),a(t,F,s),a(t,g,s),a(t,X,s),c(u,t,s),a(t,_,s),a(t,w,s),a(t,H,s),c(J,t,s),a(t,z,s),a(t,T,s),a(t,L,s),c(b,t,s),a(t,D,s),a(t,f,s),a(t,q,s),c(U,t,s),a(t,P,s),a(t,$,s),a(t,K,s),c(Z,t,s),a(t,O,s),a(t,C,s),a(t,tt,s),a(t,k,s),a(t,st,s),c(W,t,s),a(t,lt,s),a(t,I,s),a(t,at,s),c(B,t,s),a(t,et,s),a(t,G,s),a(t,nt,s),c(x,t,s),a(t,pt,s),a(t,N,s),a(t,it,s),c(Q,t,s),a(t,mt,s),c(E,t,s),a(t,ot,s),a(t,V,s),ct=!0},p:$t,i(t){ct||(r(y.$$.fragment,t),r(u.$$.fragment,t),r(J.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r(Z.$$.fragment,t),r(W.$$.fragment,t),r(B.$$.fragment,t),r(x.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),ct=!0)},o(t){h(y.$$.fragment,t),h(u.$$.fragment,t),h(J.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),ct=!1},d(t){t&&(l(Y),l(v),l(S),l(F),l(g),l(X),l(_),l(w),l(H),l(z),l(T),l(L),l(D),l(f),l(q),l(P),l($),l(K),l(O),l(C),l(tt),l(k),l(st),l(lt),l(I),l(at),l(et),l(G),l(nt),l(pt),l(N),l(it),l(mt),l(ot),l(V)),l(d),M(y,t),M(u,t),M(J,t),M(b,t),M(U,t),M(Z,t),M(W,t),M(B,t),M(x,t),M(Q,t),M(E,t)}}}const Gt='{"title":"ResNeSt","local":"resnest","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xt(rt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends Ct{constructor(d){super(),kt(this,d,xt,Bt,Ut,{})}}export{vt as component};
