import{s as Js,A as xs,o as Rs,n as ut}from"../chunks/scheduler.01eeda35.js";import{S as Fs,i as Zs,g as r,s as n,r as m,A as Ws,h as i,f as o,c as a,j as I,u as h,x as c,k as T,y as p,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.6dd51b66.js";import{T as zs}from"../chunks/Tip.de9bae2b.js";import{D as W}from"../chunks/Docstring.76e6b3cf.js";import{C as O}from"../chunks/CodeBlock.864da1b0.js";import{E as Go}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{H as z,E as Bs}from"../chunks/EditOnGithub.7faefd25.js";function ks(C){let l,M="Example:",b,y,v;return y=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBEZXB0aFBybyUyMGFwcGxlJTJGRGVwdGhQcm8lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGVwdGhQcm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwYXBwbGUlMkZEZXB0aFBybyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthPro apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthProConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-11lpom8"&&(l.textContent=M),b=a(d),h(y.$$.fragment,d)},m(d,w){s(d,l,w),s(d,b,w),g(y,d,w),v=!0},p:ut,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){u(y.$$.fragment,d),v=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function Es(C){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(b){l=i(b,"P",{"data-svelte-h":!0}),c(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){s(b,l,y)},p:ut,d(b){b&&o(l)}}}function Hs(C){let l,M="Examples:",b,y,v;return y=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGd3d3LmlsYW5rZWxtYW4ub3JnJTJGc3RvcHNpZ25zJTJGYXVzdHJhbGlhLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFvdXRwdXQubGFzdF9oaWRkZW5fc3RhdGUuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output.last_hidden_state.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">35</span>, <span class="hljs-number">577</span>, <span class="hljs-number">1024</span>])`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),b=a(d),h(y.$$.fragment,d)},m(d,w){s(d,l,w),s(d,b,w),g(y,d,w),v=!0},p:ut,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){u(y.$$.fragment,d),v=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function Gs(C){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(b){l=i(b,"P",{"data-svelte-h":!0}),c(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(b,y){s(b,l,y)},p:ut,d(b){b&&o(l)}}}function Ns(C){let l,M="Examples:",b,y,v;return y=new O({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the field of view (fov) predictions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),b=a(d),h(y.$$.fragment,d)},m(d,w){s(d,l,w),s(d,b,w),g(y,d,w),v=!0},p:ut,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){u(y.$$.fragment,d),v=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function Vs(C){let l,M,b,y,v,d,w,No='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',_t,K,bt,ee,Vo='The DepthPro model was proposed in <a href="https://arxiv.org/abs/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a> by Aleksei Bochkovskii, Amaël Delaunoy, Hugo Germain, Marcel Santos, Yichao Zhou, Stephan R. Richter, Vladlen Koltun.',yt,te,Lo="DepthPro is a foundation model for zero-shot metric monocular depth estimation, designed to generate high-resolution depth maps with remarkable sharpness and fine-grained details. It employs a multi-scale Vision Transformer (ViT)-based architecture, where images are downsampled, divided into patches, and processed using a shared Dinov2 encoder. The extracted patch-level features are merged, upsampled, and refined using a DPT-like fusion stage, enabling precise depth estimation.",vt,oe,So="The abstract from the paper is the following:",wt,se,Xo="<em>We present a foundation model for zero-shot metric monocular depth estimation. Our model, Depth Pro, synthesizes high-resolution depth maps with unparalleled sharpness and high-frequency details. The predictions are metric, with absolute scale, without relying on the availability of metadata such as camera intrinsics. And the model is fast, producing a 2.25-megapixel depth map in 0.3 seconds on a standard GPU. These characteristics are enabled by a number of technical contributions, including an efficient multi-scale vision transformer for dense prediction, a training protocol that combines real and synthetic datasets to achieve high metric accuracy alongside fine boundary tracing, dedicated evaluation metrics for boundary accuracy in estimated depth maps, and state-of-the-art focal length estimation from a single image. Extensive experiments analyze specific design choices and demonstrate that Depth Pro outperforms prior work along multiple dimensions.</em>",Tt,B,qo,Mt,ne,Qo='DepthPro Outputs. Taken from the <a href="https://github.com/apple/ml-depth-pro" target="_blank">official code</a>.',Pt,ae,Ao='This model was contributed by <a href="https://github.com/geetu040" rel="nofollow">geetu040</a>. The original code can be found <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">here</a>.',Dt,re,$t,ie,Yo="The DepthPro model processes an input image by first downsampling it at multiple scales and splitting each scaled version into patches. These patches are then encoded using a shared Vision Transformer (ViT)-based Dinov2 patch encoder, while the full image is processed by a separate image encoder. The extracted patch features are merged into feature maps, upsampled, and fused using a DPT-like decoder to generate the final depth estimation. If enabled, an additional Field of View (FOV) encoder processes the image for estimating the camera’s field of view, aiding in depth accuracy.",jt,le,It,de,Ct,k,Oo,Ut,ce,Ko='DepthPro architecture. Taken from the <a href="https://arxiv.org/abs/2410.02073" target="_blank">original paper</a>.',xt,pe,es="The <code>DepthProForDepthEstimation</code> model uses a <code>DepthProEncoder</code>, for encoding the input image and a <code>FeatureFusionStage</code> for fusing the output features from encoder.",zt,me,ts="The <code>DepthProEncoder</code> further uses two encoders:",Jt,he,os="<li><code>patch_encoder</code><ul><li>Input image is scaled with multiple ratios, as specified in the <code>scaled_images_ratios</code> configuration.</li> <li>Each scaled image is split into smaller <strong>patches</strong> of size <code>patch_size</code> with overlapping areas determined by <code>scaled_images_overlap_ratios</code>.</li> <li>These patches are processed by the <strong><code>patch_encoder</code></strong></li></ul></li> <li><code>image_encoder</code><ul><li>Input image is also rescaled to <code>patch_size</code> and processed by the <strong><code>image_encoder</code></strong></li></ul></li>",Rt,ge,ss="Both these encoders can be configured via <code>patch_model_config</code> and <code>image_model_config</code> respectively, both of which are seperate <code>Dinov2Model</code> by default.",Ft,fe,ns="Outputs from both encoders (<code>last_hidden_state</code>) and selected intermediate states (<code>hidden_states</code>) from <strong><code>patch_encoder</code></strong> are fused by a <code>DPT</code>-based <code>FeatureFusionStage</code> for depth estimation.",Zt,ue,Wt,_e,as="The network is supplemented with a focal length estimation head. A small convolutional head ingests frozen features from the depth estimation network and task-specific features from a separate ViT image encoder to predict the horizontal angular field-of-view.",Bt,be,rs="The <code>use_fov_model</code> parameter in <code>DepthProConfig</code> controls whether <strong>FOV prediction</strong> is enabled. By default, it is set to <code>False</code> to conserve memory and computation. When enabled, the <strong>FOV encoder</strong> is instantiated based on the <code>fov_model_config</code> parameter, which defaults to a <code>Dinov2Model</code>. The <code>use_fov_model</code> parameter can also be passed when initializing the <code>DepthProForDepthEstimation</code> model.",kt,ye,is="The pretrained model at checkpoint <code>apple/DepthPro-hf</code> uses the FOV encoder. To use the pretrained-model without FOV encoder, set <code>use_fov_model=False</code> when loading the model, which saves computation.",Et,ve,Ht,we,ls="To instantiate a new model with FOV encoder, set <code>use_fov_model=True</code> in the config.",Gt,Te,Nt,Me,ds="Or set <code>use_fov_model=True</code> when initializing the model, which overrides the value in config.",Vt,Pe,Lt,De,St,$e,cs=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Xt,je,ps=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,qt,Ie,Qt,Ce,ms="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",At,Ue,hs="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>google/vit-base-patch16-224</code> model, we saw the following speedups during inference.",Yt,xe,gs="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>7</td> <td>6</td> <td>1.17</td></tr> <tr><td>2</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>4</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>8</td> <td>8</td> <td>6</td> <td>1.33</td></tr></tbody>",Ot,ze,Kt,Je,fs="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DepthPro:",eo,Re,us='<li>Research Paper: <a href="https://arxiv.org/pdf/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a></li> <li>Official Implementation: <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">apple/ml-depth-pro</a></li> <li>DepthPro Inference Notebook: <a href="https://github.com/qubvel/transformers-notebooks/blob/main/notebooks/DepthPro_inference.ipynb" rel="nofollow">DepthPro Inference</a></li> <li>DepthPro for Super Resolution and Image Segmentation<ul><li>Read blog on Medium: <a href="https://medium.com/@raoarmaghanshakir040/depth-pro-beyond-depth-9d822fc557ba" rel="nofollow">Depth Pro: Beyond Depth</a></li> <li>Code on Github: <a href="https://github.com/geetu040/depthpro-beyond-depth" rel="nofollow">geetu040/depthpro-beyond-depth</a></li></ul></li>',to,Fe,_s="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",oo,Ze,so,P,We,bo,tt,bs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a>. It is used to instantiate a
DepthPro model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the DepthPro
<a href="https://huggingface.co/apple/DepthPro" rel="nofollow">apple/DepthPro</a> architecture.`,yo,ot,ys=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,vo,E,no,Be,ao,D,ke,wo,st,vs="Constructs a DepthPro image processor.",To,H,Ee,Mo,nt,ws="Preprocess an image or batch of images.",Po,G,He,Do,at,Ts=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,ro,Ge,io,$,Ne,$o,rt,Ms="Constructs a fast DepthPro image processor.",jo,N,Ve,Io,it,Ps="Preprocess an image or batch of images.",Co,V,Le,Uo,lt,Ds=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,lo,Se,co,J,Xe,xo,dt,$s=`The bare DepthPro Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,zo,U,qe,Jo,ct,js='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,L,Fo,S,po,Qe,mo,j,Ae,Zo,pt,Is="DepthPro Model with a depth estimation head on top (consisting of 3 convolutional layers).",Wo,mt,Cs=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Bo,x,Ye,ko,ht,Us='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProForDepthEstimation">DepthProForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Eo,X,Ho,q,ho,Oe,go,ft,fo;return v=new z({props:{title:"DepthPro",local:"depthpro",headingTag:"h1"}}),K=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new z({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),le=new O({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBEZXB0aFByb0ltYWdlUHJvY2Vzc29yRmFzdCUyQyUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMERlcHRoUHJvSW1hZ2VQcm9jZXNzb3JGYXN0LmZyb21fcHJldHJhaW5lZCglMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFwcGxlJTJGRGVwdGhQcm8taGYlMjIpLnRvKGRldmljZSklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBZmllbGRfb2ZfdmlldyUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJmaWVsZF9vZl92aWV3JTIyJTVEJTBBZm9jYWxfbGVuZ3RoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMmZvY2FsX2xlbmd0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwKGRlcHRoJTIwLSUyMGRlcHRoLm1pbigpKSUyMCUyRiUyMGRlcHRoLm1heCgpJTBBZGVwdGglMjAlM0QlMjBkZXB0aCUyMColMjAyNTUuJTBBZGVwdGglMjAlM0QlMjBkZXB0aC5kZXRhY2goKS5jcHUoKS5udW1weSgpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZGVwdGguYXN0eXBlKCUyMnVpbnQ4JTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProImageProcessorFast, DepthProForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = DepthProImageProcessorFast.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (depth - depth.<span class="hljs-built_in">min</span>()) / depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth * <span class="hljs-number">255.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),de=new z({props:{title:"Architecture and Configuration",local:"architecture-and-configuration",headingTag:"h3"}}),ue=new z({props:{title:"Field-of-View (FOV) Prediction",local:"field-of-view-fov-prediction",headingTag:"h3"}}),ve=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMHVzZV9mb3ZfbW9kZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, use_fov_model=<span class="hljs-literal">False</span>)`,wrap:!1}}),Te=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZyh1c2VfZm92X21vZGVsJTNEVHJ1ZSklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig(use_fov_model=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config)`,wrap:!1}}),Pe=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbihjb25maWclMkMlMjB1c2VfZm92X21vZGVsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config, use_fov_model=<span class="hljs-literal">True</span>)`,wrap:!1}}),De=new z({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),Ie=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),ze=new z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ze=new z({props:{title:"DepthProConfig",local:"transformers.DepthProConfig",headingTag:"h2"}}),We=new W({props:{name:"class transformers.DepthProConfig",anchor:"transformers.DepthProConfig",parameters:[{name:"fusion_hidden_size",val:" = 256"},{name:"patch_size",val:" = 384"},{name:"initializer_range",val:" = 0.02"},{name:"intermediate_hook_ids",val:" = [11, 5]"},{name:"intermediate_feature_dims",val:" = [256, 256]"},{name:"scaled_images_ratios",val:" = [0.25, 0.5, 1]"},{name:"scaled_images_overlap_ratios",val:" = [0.0, 0.5, 0.25]"},{name:"scaled_images_feature_dims",val:" = [1024, 1024, 512]"},{name:"merge_padding_value",val:" = 3"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = True"},{name:"use_fov_model",val:" = False"},{name:"num_fov_head_layers",val:" = 2"},{name:"image_model_config",val:" = None"},{name:"patch_model_config",val:" = None"},{name:"fov_model_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthProConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each patch. This is also the image_size for backbone model.`,name:"patch_size"},{anchor:"transformers.DepthProConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthProConfig.intermediate_hook_ids",description:`<strong>intermediate_hook_ids</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[11, 5]</code>) &#x2014;
Indices of the intermediate hidden states from the patch encoder to use for fusion.`,name:"intermediate_hook_ids"},{anchor:"transformers.DepthProConfig.intermediate_feature_dims",description:`<strong>intermediate_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 256]</code>) &#x2014;
Hidden state dimensions during upsampling for each intermediate hidden state in <code>intermediate_hook_ids</code>.`,name:"intermediate_feature_dims"},{anchor:"transformers.DepthProConfig.scaled_images_ratios",description:`<strong>scaled_images_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.25, 0.5, 1]</code>) &#x2014;
Ratios of scaled images to be used by the patch encoder.`,name:"scaled_images_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_overlap_ratios",description:`<strong>scaled_images_overlap_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.0, 0.5, 0.25]</code>) &#x2014;
Overlap ratios between patches for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_overlap_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_feature_dims",description:`<strong>scaled_images_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1024, 1024, 512]</code>) &#x2014;
Hidden state dimensions during upsampling for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_feature_dims"},{anchor:"transformers.DepthProConfig.merge_padding_value",description:`<strong>merge_padding_value</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
When merging smaller patches back to the image size, overlapping sections of this size are removed.`,name:"merge_padding_value"},{anchor:"transformers.DepthProConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use <code>DepthProFovModel</code> to generate the field of view.`,name:"use_fov_model"},{anchor:"transformers.DepthProConfig.num_fov_head_layers",description:`<strong>num_fov_head_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of convolution layers in the head of <code>DepthProFovModel</code>.`,name:"num_fov_head_layers"},{anchor:"transformers.DepthProConfig.image_model_config",description:`<strong>image_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the image encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"image_model_config"},{anchor:"transformers.DepthProConfig.patch_model_config",description:`<strong>patch_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the patch encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"patch_model_config"},{anchor:"transformers.DepthProConfig.fov_model_config",description:`<strong>fov_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the fov encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"fov_model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/configuration_depth_pro.py#L27"}}),E=new Go({props:{anchor:"transformers.DepthProConfig.example",$$slots:{default:[ks]},$$scope:{ctx:C}}}),Be=new z({props:{title:"DepthProImageProcessor",local:"transformers.DepthProImageProcessor",headingTag:"h2"}}),ke=new W({props:{name:"class transformers.DepthProImageProcessor",anchor:"transformers.DepthProImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1536, &quot;width&quot;: 1536}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L56"}}),Ee=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[PIL.Image.Resampling] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DepthProImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DepthProImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L191"}}),He=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ge=new z({props:{title:"DepthProImageProcessorFast",local:"transformers.DepthProImageProcessorFast",headingTag:"h2"}}),Ne=new W({props:{name:"class transformers.DepthProImageProcessorFast",anchor:"transformers.DepthProImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorInitKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.DepthProImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L62"}}),Ve=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorPreprocessKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils_fast.py#L552"}}),Le=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Se=new z({props:{title:"DepthProModel",local:"transformers.DepthProModel",headingTag:"h2"}}),Xe=new W({props:{name:"class transformers.DepthProModel",anchor:"transformers.DepthProModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthProModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig">DepthProConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L715"}}),qe=new W({props:{name:"forward",anchor:"transformers.DepthProModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthProModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L731",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new zs({props:{$$slots:{default:[Es]},$$scope:{ctx:C}}}),S=new Go({props:{anchor:"transformers.DepthProModel.forward.example",$$slots:{default:[Hs]},$$scope:{ctx:C}}}),Qe=new z({props:{title:"DepthProForDepthEstimation",local:"transformers.DepthProForDepthEstimation",headingTag:"h2"}}),Ae=new W({props:{name:"class transformers.DepthProForDepthEstimation",anchor:"transformers.DepthProForDepthEstimation",parameters:[{name:"config",val:""},{name:"use_fov_model",val:" = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig">DepthProConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.DepthProForDepthEstimation.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use <code>DepthProFovModel</code> to generate the field of view.`,name:"use_fov_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1090"}}),Ye=new W({props:{name:"forward",anchor:"transformers.DepthProForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthProForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthProForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1117",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>field_of_view</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>, returned when <code>use_fov_model</code> is provided) — Field of View Scaler.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, n_patches_per_batch, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer and the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, n_patches_per_batch, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new zs({props:{$$slots:{default:[Gs]},$$scope:{ctx:C}}}),q=new Go({props:{anchor:"transformers.DepthProForDepthEstimation.forward.example",$$slots:{default:[Ns]},$$scope:{ctx:C}}}),Oe=new Bs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_pro.md"}}),{c(){l=r("meta"),M=n(),b=r("p"),y=n(),m(v.$$.fragment),d=n(),w=r("div"),w.innerHTML=No,_t=n(),m(K.$$.fragment),bt=n(),ee=r("p"),ee.innerHTML=Vo,yt=n(),te=r("p"),te.textContent=Lo,vt=n(),oe=r("p"),oe.textContent=So,wt=n(),se=r("p"),se.innerHTML=Xo,Tt=n(),B=r("img"),Mt=n(),ne=r("small"),ne.innerHTML=Qo,Pt=n(),ae=r("p"),ae.innerHTML=Ao,Dt=n(),m(re.$$.fragment),$t=n(),ie=r("p"),ie.textContent=Yo,jt=n(),m(le.$$.fragment),It=n(),m(de.$$.fragment),Ct=n(),k=r("img"),Ut=n(),ce=r("small"),ce.innerHTML=Ko,xt=n(),pe=r("p"),pe.innerHTML=es,zt=n(),me=r("p"),me.innerHTML=ts,Jt=n(),he=r("ul"),he.innerHTML=os,Rt=n(),ge=r("p"),ge.innerHTML=ss,Ft=n(),fe=r("p"),fe.innerHTML=ns,Zt=n(),m(ue.$$.fragment),Wt=n(),_e=r("p"),_e.textContent=as,Bt=n(),be=r("p"),be.innerHTML=rs,kt=n(),ye=r("p"),ye.innerHTML=is,Et=n(),m(ve.$$.fragment),Ht=n(),we=r("p"),we.innerHTML=ls,Gt=n(),m(Te.$$.fragment),Nt=n(),Me=r("p"),Me.innerHTML=ds,Vt=n(),m(Pe.$$.fragment),Lt=n(),m(De.$$.fragment),St=n(),$e=r("p"),$e.innerHTML=cs,Xt=n(),je=r("p"),je.innerHTML=ps,qt=n(),m(Ie.$$.fragment),Qt=n(),Ce=r("p"),Ce.innerHTML=ms,At=n(),Ue=r("p"),Ue.innerHTML=hs,Yt=n(),xe=r("table"),xe.innerHTML=gs,Ot=n(),m(ze.$$.fragment),Kt=n(),Je=r("p"),Je.textContent=fs,eo=n(),Re=r("ul"),Re.innerHTML=us,to=n(),Fe=r("p"),Fe.textContent=_s,oo=n(),m(Ze.$$.fragment),so=n(),P=r("div"),m(We.$$.fragment),bo=n(),tt=r("p"),tt.innerHTML=bs,yo=n(),ot=r("p"),ot.innerHTML=ys,vo=n(),m(E.$$.fragment),no=n(),m(Be.$$.fragment),ao=n(),D=r("div"),m(ke.$$.fragment),wo=n(),st=r("p"),st.textContent=vs,To=n(),H=r("div"),m(Ee.$$.fragment),Mo=n(),nt=r("p"),nt.textContent=ws,Po=n(),G=r("div"),m(He.$$.fragment),Do=n(),at=r("p"),at.textContent=Ts,ro=n(),m(Ge.$$.fragment),io=n(),$=r("div"),m(Ne.$$.fragment),$o=n(),rt=r("p"),rt.textContent=Ms,jo=n(),N=r("div"),m(Ve.$$.fragment),Io=n(),it=r("p"),it.textContent=Ps,Co=n(),V=r("div"),m(Le.$$.fragment),Uo=n(),lt=r("p"),lt.textContent=Ds,lo=n(),m(Se.$$.fragment),co=n(),J=r("div"),m(Xe.$$.fragment),xo=n(),dt=r("p"),dt.innerHTML=$s,zo=n(),U=r("div"),m(qe.$$.fragment),Jo=n(),ct=r("p"),ct.innerHTML=js,Ro=n(),m(L.$$.fragment),Fo=n(),m(S.$$.fragment),po=n(),m(Qe.$$.fragment),mo=n(),j=r("div"),m(Ae.$$.fragment),Zo=n(),pt=r("p"),pt.textContent=Is,Wo=n(),mt=r("p"),mt.innerHTML=Cs,Bo=n(),x=r("div"),m(Ye.$$.fragment),ko=n(),ht=r("p"),ht.innerHTML=Us,Eo=n(),m(X.$$.fragment),Ho=n(),m(q.$$.fragment),ho=n(),m(Oe.$$.fragment),go=n(),ft=r("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),M=a(e),b=i(e,"P",{}),I(b).forEach(o),y=a(e),h(v.$$.fragment,e),d=a(e),w=i(e,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-13t8s2t"&&(w.innerHTML=No),_t=a(e),h(K.$$.fragment,e),bt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-17nz7v2"&&(ee.innerHTML=Vo),yt=a(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-iw0dw2"&&(te.textContent=Lo),vt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-vfdo9a"&&(oe.textContent=So),wt=a(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1nlf61n"&&(se.innerHTML=Xo),Tt=a(e),B=i(e,"IMG",{src:!0,alt:!0,width:!0}),Mt=a(e),ne=i(e,"SMALL",{"data-svelte-h":!0}),c(ne)!=="svelte-v29z6c"&&(ne.innerHTML=Qo),Pt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-l2shq"&&(ae.innerHTML=Ao),Dt=a(e),h(re.$$.fragment,e),$t=a(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-186igip"&&(ie.textContent=Yo),jt=a(e),h(le.$$.fragment,e),It=a(e),h(de.$$.fragment,e),Ct=a(e),k=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ut=a(e),ce=i(e,"SMALL",{"data-svelte-h":!0}),c(ce)!=="svelte-1ru2d7g"&&(ce.innerHTML=Ko),xt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-tuav9r"&&(pe.innerHTML=es),zt=a(e),me=i(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-1j3kmo3"&&(me.innerHTML=ts),Jt=a(e),he=i(e,"UL",{"data-svelte-h":!0}),c(he)!=="svelte-z5afbx"&&(he.innerHTML=os),Rt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1tmhlgp"&&(ge.innerHTML=ss),Ft=a(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-52bz7i"&&(fe.innerHTML=ns),Zt=a(e),h(ue.$$.fragment,e),Wt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1ndzez1"&&(_e.textContent=as),Bt=a(e),be=i(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-g9cm15"&&(be.innerHTML=rs),kt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-a9hyvq"&&(ye.innerHTML=is),Et=a(e),h(ve.$$.fragment,e),Ht=a(e),we=i(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1npevgz"&&(we.innerHTML=ls),Gt=a(e),h(Te.$$.fragment,e),Nt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1becr2q"&&(Me.innerHTML=ds),Vt=a(e),h(Pe.$$.fragment,e),Lt=a(e),h(De.$$.fragment,e),St=a(e),$e=i(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1cid2pe"&&($e.innerHTML=cs),Xt=a(e),je=i(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1x11lxg"&&(je.innerHTML=ps),qt=a(e),h(Ie.$$.fragment,e),Qt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-djb2w0"&&(Ce.innerHTML=ms),At=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-18g4o0h"&&(Ue.innerHTML=hs),Yt=a(e),xe=i(e,"TABLE",{"data-svelte-h":!0}),c(xe)!=="svelte-vyu660"&&(xe.innerHTML=gs),Ot=a(e),h(ze.$$.fragment,e),Kt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1ub7hfb"&&(Je.textContent=fs),eo=a(e),Re=i(e,"UL",{"data-svelte-h":!0}),c(Re)!=="svelte-yhgtws"&&(Re.innerHTML=us),to=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1xesile"&&(Fe.textContent=_s),oo=a(e),h(Ze.$$.fragment,e),so=a(e),P=i(e,"DIV",{class:!0});var R=I(P);h(We.$$.fragment,R),bo=a(R),tt=i(R,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-160h4tq"&&(tt.innerHTML=bs),yo=a(R),ot=i(R,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-o55m63"&&(ot.innerHTML=ys),vo=a(R),h(E.$$.fragment,R),R.forEach(o),no=a(e),h(Be.$$.fragment,e),ao=a(e),D=i(e,"DIV",{class:!0});var F=I(D);h(ke.$$.fragment,F),wo=a(F),st=i(F,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1s0ef1w"&&(st.textContent=vs),To=a(F),H=i(F,"DIV",{class:!0});var Ke=I(H);h(Ee.$$.fragment,Ke),Mo=a(Ke),nt=i(Ke,"P",{"data-svelte-h":!0}),c(nt)!=="svelte-1x3yxsa"&&(nt.textContent=ws),Ke.forEach(o),Po=a(F),G=i(F,"DIV",{class:!0});var et=I(G);h(He.$$.fragment,et),Do=a(et),at=i(et,"P",{"data-svelte-h":!0}),c(at)!=="svelte-nc01ic"&&(at.textContent=Ts),et.forEach(o),F.forEach(o),ro=a(e),h(Ge.$$.fragment,e),io=a(e),$=i(e,"DIV",{class:!0});var Z=I($);h(Ne.$$.fragment,Z),$o=a(Z),rt=i(Z,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-4bjcxg"&&(rt.textContent=Ms),jo=a(Z),N=i(Z,"DIV",{class:!0});var uo=I(N);h(Ve.$$.fragment,uo),Io=a(uo),it=i(uo,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1x3yxsa"&&(it.textContent=Ps),uo.forEach(o),Co=a(Z),V=i(Z,"DIV",{class:!0});var _o=I(V);h(Le.$$.fragment,_o),Uo=a(_o),lt=i(_o,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-nc01ic"&&(lt.textContent=Ds),_o.forEach(o),Z.forEach(o),lo=a(e),h(Se.$$.fragment,e),co=a(e),J=i(e,"DIV",{class:!0});var gt=I(J);h(Xe.$$.fragment,gt),xo=a(gt),dt=i(gt,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-xejpql"&&(dt.innerHTML=$s),zo=a(gt),U=i(gt,"DIV",{class:!0});var Q=I(U);h(qe.$$.fragment,Q),Jo=a(Q),ct=i(Q,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-y3si4a"&&(ct.innerHTML=js),Ro=a(Q),h(L.$$.fragment,Q),Fo=a(Q),h(S.$$.fragment,Q),Q.forEach(o),gt.forEach(o),po=a(e),h(Qe.$$.fragment,e),mo=a(e),j=i(e,"DIV",{class:!0});var A=I(j);h(Ae.$$.fragment,A),Zo=a(A),pt=i(A,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-1nk4p0z"&&(pt.textContent=Is),Wo=a(A),mt=i(A,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1gjh92c"&&(mt.innerHTML=Cs),Bo=a(A),x=i(A,"DIV",{class:!0});var Y=I(x);h(Ye.$$.fragment,Y),ko=a(Y),ht=i(Y,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-1n6bje0"&&(ht.innerHTML=Us),Eo=a(Y),h(X.$$.fragment,Y),Ho=a(Y),h(q.$$.fragment,Y),Y.forEach(o),A.forEach(o),ho=a(e),h(Oe.$$.fragment,e),go=a(e),ft=i(e,"P",{}),I(ft).forEach(o),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",Ls),T(w,"class","flex flex-wrap space-x-1"),xs(B.src,qo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_teaser.png")||T(B,"src",qo),T(B,"alt","drawing"),T(B,"width","600"),xs(k.src,Oo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_architecture.png")||T(k,"src",Oo),T(k,"alt","drawing"),T(k,"width","600"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,l),s(e,M,t),s(e,b,t),s(e,y,t),g(v,e,t),s(e,d,t),s(e,w,t),s(e,_t,t),g(K,e,t),s(e,bt,t),s(e,ee,t),s(e,yt,t),s(e,te,t),s(e,vt,t),s(e,oe,t),s(e,wt,t),s(e,se,t),s(e,Tt,t),s(e,B,t),s(e,Mt,t),s(e,ne,t),s(e,Pt,t),s(e,ae,t),s(e,Dt,t),g(re,e,t),s(e,$t,t),s(e,ie,t),s(e,jt,t),g(le,e,t),s(e,It,t),g(de,e,t),s(e,Ct,t),s(e,k,t),s(e,Ut,t),s(e,ce,t),s(e,xt,t),s(e,pe,t),s(e,zt,t),s(e,me,t),s(e,Jt,t),s(e,he,t),s(e,Rt,t),s(e,ge,t),s(e,Ft,t),s(e,fe,t),s(e,Zt,t),g(ue,e,t),s(e,Wt,t),s(e,_e,t),s(e,Bt,t),s(e,be,t),s(e,kt,t),s(e,ye,t),s(e,Et,t),g(ve,e,t),s(e,Ht,t),s(e,we,t),s(e,Gt,t),g(Te,e,t),s(e,Nt,t),s(e,Me,t),s(e,Vt,t),g(Pe,e,t),s(e,Lt,t),g(De,e,t),s(e,St,t),s(e,$e,t),s(e,Xt,t),s(e,je,t),s(e,qt,t),g(Ie,e,t),s(e,Qt,t),s(e,Ce,t),s(e,At,t),s(e,Ue,t),s(e,Yt,t),s(e,xe,t),s(e,Ot,t),g(ze,e,t),s(e,Kt,t),s(e,Je,t),s(e,eo,t),s(e,Re,t),s(e,to,t),s(e,Fe,t),s(e,oo,t),g(Ze,e,t),s(e,so,t),s(e,P,t),g(We,P,null),p(P,bo),p(P,tt),p(P,yo),p(P,ot),p(P,vo),g(E,P,null),s(e,no,t),g(Be,e,t),s(e,ao,t),s(e,D,t),g(ke,D,null),p(D,wo),p(D,st),p(D,To),p(D,H),g(Ee,H,null),p(H,Mo),p(H,nt),p(D,Po),p(D,G),g(He,G,null),p(G,Do),p(G,at),s(e,ro,t),g(Ge,e,t),s(e,io,t),s(e,$,t),g(Ne,$,null),p($,$o),p($,rt),p($,jo),p($,N),g(Ve,N,null),p(N,Io),p(N,it),p($,Co),p($,V),g(Le,V,null),p(V,Uo),p(V,lt),s(e,lo,t),g(Se,e,t),s(e,co,t),s(e,J,t),g(Xe,J,null),p(J,xo),p(J,dt),p(J,zo),p(J,U),g(qe,U,null),p(U,Jo),p(U,ct),p(U,Ro),g(L,U,null),p(U,Fo),g(S,U,null),s(e,po,t),g(Qe,e,t),s(e,mo,t),s(e,j,t),g(Ae,j,null),p(j,Zo),p(j,pt),p(j,Wo),p(j,mt),p(j,Bo),p(j,x),g(Ye,x,null),p(x,ko),p(x,ht),p(x,Eo),g(X,x,null),p(x,Ho),g(q,x,null),s(e,ho,t),g(Oe,e,t),s(e,go,t),s(e,ft,t),fo=!0},p(e,[t]){const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),E.$set(R);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),L.$set(F);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),S.$set(Ke);const et={};t&2&&(et.$$scope={dirty:t,ctx:e}),X.$set(et);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),q.$set(Z)},i(e){fo||(f(v.$$.fragment,e),f(K.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Pe.$$.fragment,e),f(De.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(E.$$.fragment,e),f(Be.$$.fragment,e),f(ke.$$.fragment,e),f(Ee.$$.fragment,e),f(He.$$.fragment,e),f(Ge.$$.fragment,e),f(Ne.$$.fragment,e),f(Ve.$$.fragment,e),f(Le.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(qe.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(Ye.$$.fragment,e),f(X.$$.fragment,e),f(q.$$.fragment,e),f(Oe.$$.fragment,e),fo=!0)},o(e){u(v.$$.fragment,e),u(K.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(E.$$.fragment,e),u(Be.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(He.$$.fragment,e),u(Ge.$$.fragment,e),u(Ne.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(qe.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(Qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(X.$$.fragment,e),u(q.$$.fragment,e),u(Oe.$$.fragment,e),fo=!1},d(e){e&&(o(M),o(b),o(y),o(d),o(w),o(_t),o(bt),o(ee),o(yt),o(te),o(vt),o(oe),o(wt),o(se),o(Tt),o(B),o(Mt),o(ne),o(Pt),o(ae),o(Dt),o($t),o(ie),o(jt),o(It),o(Ct),o(k),o(Ut),o(ce),o(xt),o(pe),o(zt),o(me),o(Jt),o(he),o(Rt),o(ge),o(Ft),o(fe),o(Zt),o(Wt),o(_e),o(Bt),o(be),o(kt),o(ye),o(Et),o(Ht),o(we),o(Gt),o(Nt),o(Me),o(Vt),o(Lt),o(St),o($e),o(Xt),o(je),o(qt),o(Qt),o(Ce),o(At),o(Ue),o(Yt),o(xe),o(Ot),o(Kt),o(Je),o(eo),o(Re),o(to),o(Fe),o(oo),o(so),o(P),o(no),o(ao),o(D),o(ro),o(io),o($),o(lo),o(co),o(J),o(po),o(mo),o(j),o(ho),o(go),o(ft)),o(l),_(v,e),_(K,e),_(re,e),_(le,e),_(de,e),_(ue,e),_(ve,e),_(Te,e),_(Pe,e),_(De,e),_(Ie,e),_(ze,e),_(Ze,e),_(We),_(E),_(Be,e),_(ke),_(Ee),_(He),_(Ge,e),_(Ne),_(Ve),_(Le),_(Se,e),_(Xe),_(qe),_(L),_(S),_(Qe,e),_(Ae),_(Ye),_(X),_(q),_(Oe,e)}}}const Ls='{"title":"DepthPro","local":"depthpro","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Architecture and Configuration","local":"architecture-and-configuration","sections":[],"depth":3},{"title":"Field-of-View (FOV) Prediction","local":"field-of-view-fov-prediction","sections":[],"depth":3},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthProConfig","local":"transformers.DepthProConfig","sections":[],"depth":2},{"title":"DepthProImageProcessor","local":"transformers.DepthProImageProcessor","sections":[],"depth":2},{"title":"DepthProImageProcessorFast","local":"transformers.DepthProImageProcessorFast","sections":[],"depth":2},{"title":"DepthProModel","local":"transformers.DepthProModel","sections":[],"depth":2},{"title":"DepthProForDepthEstimation","local":"transformers.DepthProForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Ss(C){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Fs{constructor(l){super(),Zs(this,l,Ss,Vs,Js,{})}}export{en as component};
