import{s as We,n as Ce,o as ke}from"../chunks/scheduler.01eeda35.js";import{S as ze,i as Fe,g as r,s as l,r as p,A as Ne,h as c,f as s,c as n,j as Ae,u as i,x as w,k as $e,y as ve,a as t,v as o,d,t as h,w as m}from"../chunks/index.6dd51b66.js";import{C as T}from"../chunks/CodeBlock.864da1b0.js";import{H as ye,E as Ve}from"../chunks/EditOnGithub.7faefd25.js";function Ye(fe){let J,S,Y,H,M,Q,y,ue='<a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to simplify distributed training on any type of setup with PyTorch by uniting the most common frameworks (<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel (FSDP)</a> and <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a>) for it into a single interface. <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> is powered by Accelerate under the hood, enabling loading big models and distributed training.',x,f,je='This guide will show you two ways to use Accelerate with Transformers, using FSDP as the backend. The first method demonstrates distributed training with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, and the second method demonstrates adapting a PyTorch training loop. For more detailed information about Accelerate, please refer to the <a href="https://hf.co/docs/accelerate/index" rel="nofollow">documentation</a>.',D,u,P,j,Ue='Start by running <a href="https://hf.co/docs/accelerate/main/en/package_reference/cli#accelerate-config" rel="nofollow">accelerate config</a> in the command line to answer a series of prompts about your training system. This creates and saves a configuration file to help Accelerate correctly set up training based on your setup.',L,U,q,b,be="Depending on your setup and the answers you provide, an example configuration file for distributing training with FSDP on one machine with two GPUs may look like the following.",K,g,O,I,ee,Z,ge='Pass the path to the saved configuration file to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>, and from there, pass your <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>.',ae,_,se,B,te,G,Ie='Accelerate can also be added to any PyTorch training loop to enable distributed training. The <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> is the main entry point for adapting your PyTorch code to work with Accelerate. It automatically detects your distributed training setup and initializes all the necessary components for training. You don’t need to explicitly place your model on a device because <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> knows which device to move your model to.',le,R,ne,X,Ze='All PyTorch objects (model, optimizer, scheduler, dataloaders) should be passed to the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow">prepare</a> method now. This method moves your model to the appropriate device or devices, adapts the optimizer and scheduler to use <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer" rel="nofollow">AcceleratedOptimizer</a> and <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler" rel="nofollow">AcceleratedScheduler</a>, and creates a new shardable dataloader.',re,A,ce,$,_e='Replace <code>loss.backward</code> in your training loop with Accelerates <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow">backward</a> method to scale the gradients and determine the appropriate <code>backward</code> method to use depending on your framework (for example, DeepSpeed or Megatron).',pe,W,ie,C,Be="Combine everything into a function and make it callable as a script.",oe,k,de,z,Ge='From the command line, call <a href="https://hf.co/docs/accelerate/main/en/package_reference/cli#accelerate-launch" rel="nofollow">accelerate launch</a> to run your training script. Any additional arguments or parameters can be passed here as well.',he,F,Re="To launch your training script on two GPUs, add the <code>--num_processes</code> argument.",me,N,we,v,Xe='Refer to the <a href="https://hf.co/docs/accelerate/main/en/basic_tutorials/launch" rel="nofollow">Launching Accelerate scripts</a> for more details.',Je,V,Te,E,Me;return M=new ye({props:{title:"Accelerate",local:"accelerate",headingTag:"h1"}}),u=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),U=new T({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),g=new T({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMEZVTExfU0hBUkQlMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMFNIQVJERURfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfc3luY19tb2R1bGVfc3RhdGVzJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMHRydWUlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-string">FULL_SHARD</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),I=new ye({props:{title:"Trainer",local:"trainer",headingTag:"h2"}}),_=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyeW91ci1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDIlMkMlMEElMjAlMjAlMjAlMjBmc2RwX2NvbmZpZyUzRCUyMnBhdGglMkZ0byUyRmZzZHBfY29uZmlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnNkcF9zdHJhdGVneSUzRCUyMmZ1bGxfc2hhcmQlMjIlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;your-model&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    num_train_epochs=<span class="hljs-number">2</span>,
    fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config&quot;</span>,
    fsdp_strategy=<span class="hljs-string">&quot;full_shard&quot;</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)

trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    processing_class=tokenizer,
    data_collator=data_collator,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),B=new ye({props:{title:"Native PyTorch",local:"native-pytorch",headingTag:"h2"}}),R=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()
device = accelerator.device`,wrap:!1}}),A=new T({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)`,wrap:!1}}),W=new T({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),k=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyMCUyMCUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTIwJTIwKSUwQSUwQSUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgpJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwbWFpbigp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
  
<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
  accelerator = Accelerator()

  model, optimizer, training_dataloader, scheduler = accelerator.prepare(
      model, optimizer, training_dataloader, scheduler
  )

  <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
      optimizer.zero_grad()
      inputs, targets = batch
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      accelerator.backward(loss)
      optimizer.step()
      scheduler.step()

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),N=new T({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUzRDIlMjB5b3VyX3NjcmlwdC5weQ==",highlighted:"accelerate launch --num_processes=2 your_script.py",wrap:!1}}),V=new Ve({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/accelerate.md"}}),{c(){J=r("meta"),S=l(),Y=r("p"),H=l(),p(M.$$.fragment),Q=l(),y=r("p"),y.innerHTML=ue,x=l(),f=r("p"),f.innerHTML=je,D=l(),p(u.$$.fragment),P=l(),j=r("p"),j.innerHTML=Ue,L=l(),p(U.$$.fragment),q=l(),b=r("p"),b.textContent=be,K=l(),p(g.$$.fragment),O=l(),p(I.$$.fragment),ee=l(),Z=r("p"),Z.innerHTML=ge,ae=l(),p(_.$$.fragment),se=l(),p(B.$$.fragment),te=l(),G=r("p"),G.innerHTML=Ie,le=l(),p(R.$$.fragment),ne=l(),X=r("p"),X.innerHTML=Ze,re=l(),p(A.$$.fragment),ce=l(),$=r("p"),$.innerHTML=_e,pe=l(),p(W.$$.fragment),ie=l(),C=r("p"),C.textContent=Be,oe=l(),p(k.$$.fragment),de=l(),z=r("p"),z.innerHTML=Ge,he=l(),F=r("p"),F.innerHTML=Re,me=l(),p(N.$$.fragment),we=l(),v=r("p"),v.innerHTML=Xe,Je=l(),p(V.$$.fragment),Te=l(),E=r("p"),this.h()},l(e){const a=Ne("svelte-u9bgzb",document.head);J=c(a,"META",{name:!0,content:!0}),a.forEach(s),S=n(e),Y=c(e,"P",{}),Ae(Y).forEach(s),H=n(e),i(M.$$.fragment,e),Q=n(e),y=c(e,"P",{"data-svelte-h":!0}),w(y)!=="svelte-dayzxx"&&(y.innerHTML=ue),x=n(e),f=c(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-t97e66"&&(f.innerHTML=je),D=n(e),i(u.$$.fragment,e),P=n(e),j=c(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-rt6hpx"&&(j.innerHTML=Ue),L=n(e),i(U.$$.fragment,e),q=n(e),b=c(e,"P",{"data-svelte-h":!0}),w(b)!=="svelte-1444ksv"&&(b.textContent=be),K=n(e),i(g.$$.fragment,e),O=n(e),i(I.$$.fragment,e),ee=n(e),Z=c(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-q3cz6z"&&(Z.innerHTML=ge),ae=n(e),i(_.$$.fragment,e),se=n(e),i(B.$$.fragment,e),te=n(e),G=c(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1r4b385"&&(G.innerHTML=Ie),le=n(e),i(R.$$.fragment,e),ne=n(e),X=c(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-591tn1"&&(X.innerHTML=Ze),re=n(e),i(A.$$.fragment,e),ce=n(e),$=c(e,"P",{"data-svelte-h":!0}),w($)!=="svelte-3prwkp"&&($.innerHTML=_e),pe=n(e),i(W.$$.fragment,e),ie=n(e),C=c(e,"P",{"data-svelte-h":!0}),w(C)!=="svelte-1b3w16l"&&(C.textContent=Be),oe=n(e),i(k.$$.fragment,e),de=n(e),z=c(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-igpm6b"&&(z.innerHTML=Ge),he=n(e),F=c(e,"P",{"data-svelte-h":!0}),w(F)!=="svelte-1wafclc"&&(F.innerHTML=Re),me=n(e),i(N.$$.fragment,e),we=n(e),v=c(e,"P",{"data-svelte-h":!0}),w(v)!=="svelte-1gxoe3z"&&(v.innerHTML=Xe),Je=n(e),i(V.$$.fragment,e),Te=n(e),E=c(e,"P",{}),Ae(E).forEach(s),this.h()},h(){$e(J,"name","hf:doc:metadata"),$e(J,"content",Ee)},m(e,a){ve(document.head,J),t(e,S,a),t(e,Y,a),t(e,H,a),o(M,e,a),t(e,Q,a),t(e,y,a),t(e,x,a),t(e,f,a),t(e,D,a),o(u,e,a),t(e,P,a),t(e,j,a),t(e,L,a),o(U,e,a),t(e,q,a),t(e,b,a),t(e,K,a),o(g,e,a),t(e,O,a),o(I,e,a),t(e,ee,a),t(e,Z,a),t(e,ae,a),o(_,e,a),t(e,se,a),o(B,e,a),t(e,te,a),t(e,G,a),t(e,le,a),o(R,e,a),t(e,ne,a),t(e,X,a),t(e,re,a),o(A,e,a),t(e,ce,a),t(e,$,a),t(e,pe,a),o(W,e,a),t(e,ie,a),t(e,C,a),t(e,oe,a),o(k,e,a),t(e,de,a),t(e,z,a),t(e,he,a),t(e,F,a),t(e,me,a),o(N,e,a),t(e,we,a),t(e,v,a),t(e,Je,a),o(V,e,a),t(e,Te,a),t(e,E,a),Me=!0},p:Ce,i(e){Me||(d(M.$$.fragment,e),d(u.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(A.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),Me=!0)},o(e){h(M.$$.fragment,e),h(u.$$.fragment,e),h(U.$$.fragment,e),h(g.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(A.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),Me=!1},d(e){e&&(s(S),s(Y),s(H),s(Q),s(y),s(x),s(f),s(D),s(P),s(j),s(L),s(q),s(b),s(K),s(O),s(ee),s(Z),s(ae),s(se),s(te),s(G),s(le),s(ne),s(X),s(re),s(ce),s($),s(pe),s(ie),s(C),s(oe),s(de),s(z),s(he),s(F),s(me),s(we),s(v),s(Je),s(Te),s(E)),s(J),m(M,e),m(u,e),m(U,e),m(g,e),m(I,e),m(_,e),m(B,e),m(R,e),m(A,e),m(W,e),m(k,e),m(N,e),m(V,e)}}}const Ee='{"title":"Accelerate","local":"accelerate","sections":[{"title":"Trainer","local":"trainer","sections":[],"depth":2},{"title":"Native PyTorch","local":"native-pytorch","sections":[],"depth":2}],"depth":1}';function Se(fe){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends ze{constructor(J){super(),Fe(this,J,Se,Ye,We,{})}}export{Pe as component};
