import{s as ya,o as va,n as re}from"../chunks/scheduler.01eeda35.js";import{S as Ta,i as La,g as i,s as n,r as p,A as wa,h as l,f as o,c as a,j as M,u as h,x as m,k as w,y as s,a as r,v as u,d as f,t as g,w as _}from"../chunks/index.6dd51b66.js";import{T as Po}from"../chunks/Tip.de9bae2b.js";import{D as q}from"../chunks/Docstring.76e6b3cf.js";import{C as Ut}from"../chunks/CodeBlock.864da1b0.js";import{E as Io}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{P as ka}from"../chunks/PipelineTag.5efc345e.js";import{H as R,E as xa}from"../chunks/EditOnGithub.7faefd25.js";function Ma(z){let d,y=`The <code>Llama2</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. The checkpoints uploaded on the Hub use <code>torch_dtype = &#39;float16&#39;</code>, which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,c,k,x="The <code>dtype</code> of the online weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online), then it will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>), and finally, if there is a <code>torch_dtype</code> provided in the config, it will be used.",b,L,Ht="Training the model in <code>float16</code> is not recommended and is known to produce <code>nan</code>; as such, the model should be trained in <code>bfloat16</code>.";return{c(){d=i("p"),d.innerHTML=y,c=n(),k=i("p"),k.innerHTML=x,b=n(),L=i("p"),L.innerHTML=Ht},l(C){d=l(C,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1ng8rlw"&&(d.innerHTML=y),c=a(C),k=l(C,"P",{"data-svelte-h":!0}),m(k)!=="svelte-17gt3kv"&&(k.innerHTML=x),b=a(C),L=l(C,"P",{"data-svelte-h":!0}),m(L)!=="svelte-wna3bo"&&(L.innerHTML=Ht)},m(C,j){r(C,d,j),r(C,c,j),r(C,k,j),r(C,b,j),r(C,L,j)},p:re,d(C){C&&(o(d),o(c),o(k),o(b),o(L))}}}function $a(z){let d,y;return d=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hTW9kZWwlMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMTGFNQSUyMGxsYW1hLTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbGxhbWEtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMExsYW1hTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaModel, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a LLaMA llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){h(d.$$.fragment,c)},m(c,k){u(d,c,k),y=!0},p:re,i(c){y||(f(d.$$.fragment,c),y=!0)},o(c){g(d.$$.fragment,c),y=!1},d(c){_(d,c)}}}function za(z){let d,y="sequence pair mask has the following format:",c,k,x;return k=new Ut({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=i("p"),d.textContent=y,c=n(),p(k.$$.fragment)},l(b){d=l(b,"P",{"data-svelte-h":!0}),m(d)!=="svelte-16klr56"&&(d.textContent=y),c=a(b),h(k.$$.fragment,b)},m(b,L){r(b,d,L),r(b,c,L),u(k,b,L),x=!0},p:re,i(b){x||(f(k.$$.fragment,b),x=!0)},o(b){g(k.$$.fragment,b),x=!1},d(b){b&&(o(d),o(c)),_(k,b)}}}function Ca(z){let d,y;return d=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyRmFzdCUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxsYW1hLXRva2VuaXplciUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = LlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){h(d.$$.fragment,c)},m(c,k){u(d,c,k),y=!0},p:re,i(c){y||(f(d.$$.fragment,c),y=!0)},o(c){g(d.$$.fragment,c),y=!1},d(c){_(d,c)}}}function qa(z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=y},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(c,k){r(c,d,k)},p:re,d(c){c&&o(d)}}}function Aa(z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=y},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(c,k){r(c,d,k)},p:re,d(c){c&&o(d)}}}function Fa(z){let d,y="Example:",c,k,x;return k=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=y,c=n(),p(k.$$.fragment)},l(b){d=l(b,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=y),c=a(b),h(k.$$.fragment,b)},m(b,L){r(b,d,L),r(b,c,L),u(k,b,L),x=!0},p:re,i(b){x||(f(k.$$.fragment,b),x=!0)},o(b){g(k.$$.fragment,b),x=!1},d(b){b&&(o(d),o(c)),_(k,b)}}}function Pa(z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=y},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(c,k){r(c,d,k)},p:re,d(c){c&&o(d)}}}function Ia(z){let d,y,c,k,x,b,L,Ht=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/>`,C,j,Jt,ie,$n='The Llama2 model was proposed in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">LLaMA: Open Foundation and Fine-Tuned Chat Models</a> by Hugo Touvron, Louis Martin, Kevin Stone, Peter Albert, Amjad Almahairi, Yasmine Babaei, Nikolay Bashlykov, Soumya Batra, Prajjwal Bhargava, Shruti Bhosale, Dan Bikel, Lukas Blecher, Cristian Canton Ferrer, Moya Chen, Guillem Cucurull, David Esiobu, Jude Fernandes, Jeremy Fu, Wenyin Fu, Brian Fuller, Cynthia Gao, Vedanuj Goswami, Naman Goyal, Anthony Hartshorn, Saghar Hosseini, Rui Hou, Hakan Inan, Marcin Kardas, Viktor Kerkez Madian Khabsa, Isabel Kloumann, Artem Korenev, Punit Singh Koura, Marie-Anne Lachaux, Thibaut Lavril, Jenya Lee, Diana Liskovich, Yinghai Lu, Yuning Mao, Xavier Martinet, Todor Mihaylov, Pushka rMishra, Igor Molybog, Yixin Nie, Andrew Poulton, Jeremy Reizenstein, Rashi Rungta, Kalyan Saladi, Alan Schelten, Ruan Silva, Eric Michael Smith, Ranjan Subramanian, Xiaoqing EllenTan, Binh Tang, Ross Taylor, Adina Williams, Jian Xiang Kuan, Puxin Xu, Zheng Yan, Iliyan Zarov, Yuchen Zhang, Angela Fan, Melanie Kambadur, Sharan Narang, Aurelien Rodriguez, Robert Stojnic, Sergey Edunov, Thomas Scialom. It is a collection of foundation language models ranging from 7B to 70B parameters, with checkpoints finetuned for chat application!',Gt,le,zn="The abstract from the paper is the following:",Zt,de,Cn="<em>In this work, we develop and release Llama 2, a collection of pretrained and fine-tuned large language models (LLMs) ranging in scale from 7 billion to 70 billion parameters. Our fine-tuned LLMs, called Llama 2-Chat, are optimized for dialogue use cases. Our models outperform open-source chat models on most benchmarks we tested, and based on our human evaluations for helpfulness and safety, may be a suitable substitute for closed-source models. We provide a detailed description of our approach to fine-tuning and safety improvements of Llama 2-Chat in order to enable the community to build on our work and contribute to the responsible development of LLMs.</em>",Rt,ce,qn=`Checkout all Llama2 model checkpoints <a href="https://huggingface.co/models?search=llama2" rel="nofollow">here</a>.
This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a> with contributions from <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre Debut</a>. The code of the implementation in Hugging Face is based on GPT-NeoX <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">here</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.`,Ot,me,Dt,D,Bt,pe,An="Tips:",Vt,he,Fn='<li>Weights for the Llama2 models can be obtained by filling out <a href="https://ai.meta.com/resources/models-and-libraries/llama-downloads/" rel="nofollow">this form</a></li> <li>The architecture is very similar to the first Llama, with the addition of Grouped Query Attention (GQA) following this <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">paper</a></li> <li>Setting <code>config.pretraining_tp</code> to a value different than 1 will activate the more accurate but slower computation of the linear layers, which should better match the original logits.</li> <li>The original model uses <code>pad_id = -1</code> which means that there is no padding token. We can’t have the same logic, make sure to add a padding token using <code>tokenizer.add_special_tokens({&quot;pad_token&quot;:&quot;&lt;pad&gt;&quot;})</code> and resize the token embedding accordingly. You should also set the <code>model.config.pad_token_id</code>. The <code>embed_tokens</code> layer of the model is initialized with <code>self.embed_tokens = nn.Embedding(config.vocab_size, config.hidden_size, self.config.padding_idx)</code>, which makes sure that encoding the padding token will output zeros, so passing it when initializing is recommended.</li> <li>After filling out the form and gaining access to the model checkpoints, you should be able to use the already converted checkpoints. Otherwise, if you are converting your own model, feel free to use the <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">conversion script</a>. The script can be called with the following (example) command:</li>',Yt,ue,Xt,fe,Pn="<li>After conversion, the model and tokenizer can be loaded via:</li>",Qt,ge,Kt,_e,In=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM). For the 75B model, it’s thus 145GB of RAM needed.`,eo,be,jn='<li><p>The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.</p></li> <li><p>When using Flash Attention 2 via <code>attn_implementation=&quot;flash_attention_2&quot;</code>, don’t pass <code>torch_dtype</code> to the <code>from_pretrained</code> class method and use Automatic Mixed-Precision training. When using <code>Trainer</code>, it is simply specifying either <code>fp16</code> or <code>bf16</code> to <code>True</code>. Otherwise, make sure you are using <code>torch.autocast</code>. This is required because the Flash Attention only support <code>fp16</code> and <code>bf16</code> data type.</p></li>',to,ke,oo,ye,Wn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with LLaMA2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",no,ve,Un='<li><a href="https://huggingface.co/blog/llama2" rel="nofollow">Llama 2 is here - get it on Hugging Face</a>, a blog post about Llama 2 and how to use it with 🤗 Transformers and 🤗 PEFT.</li> <li><a href="https://www.philschmid.de/llama-2" rel="nofollow">LLaMA 2 - Every Resource you need</a>, a compilation of relevant resources to learn about LLaMA 2 and how to get started quickly.</li>',ao,Te,so,Le,Hn='<li>A <a href="https://colab.research.google.com/drive/1PEQyJO1-f6j0S_XJ8DV50NkpzasXkrzd?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune Llama 2 in Google Colab using QLoRA and 4-bit precision. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/134o_cXcMe_lsvl15ZE_4Y75Kstepsntu?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the “Llama-v2-7b-guanaco” model with 4-bit QLoRA and generate Q&amp;A datasets from PDFs. 🌎</li>',ro,we,io,xe,En='<li>A <a href="https://colab.research.google.com/drive/1ggaa2oRFphdBmqIjSEbnb_HGkcIRC2ZB?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model with QLoRa, TRL, and Korean text classification dataset. 🌎🇰🇷</li>',lo,Me,Sn="⚗️ Optimization",co,$e,Nn='<li><a href="https://huggingface.co/blog/dpo-trl" rel="nofollow">Fine-tune Llama 2 with DPO</a>, a guide to using the TRL library’s DPO method to fine tune Llama 2 on a specific dataset.</li> <li><a href="https://www.philschmid.de/instruction-tune-llama-2" rel="nofollow">Extended Guide: Instruction-tune Llama 2</a>, a guide to training Llama 2 to generate instructions from inputs, transforming the model from instruction-following to instruction-giving.</li> <li>A <a href="https://colab.research.google.com/drive/1SYpgFpcmtIUzdE7pxqknrM4ArCASfkFQ?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model on a personal computer using QLoRa and TRL. 🌎</li>',mo,ze,Jn="⚡️ Inference",po,Ce,Gn='<li>A <a href="https://colab.research.google.com/drive/1TC56ArKerXUpbgRy5vM3woRsbTEVNq7h?usp=sharing" rel="nofollow">notebook</a> on how to quantize the Llama 2 model using GPTQ from the AutoGPTQ library. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/1X1z9Q6domMKl2CnEM0QGHNwidLfR4dW2?usp=sharing" rel="nofollow">notebook</a> on how to run the Llama 2 Chat Model with 4-bit quantization on a local computer or Google Colab. 🌎</li>',ho,qe,Zn="🚀 Deploy",uo,Ae,Rn='<li><a href="https://www.philschmid.de/sagemaker-llama2-qlora" rel="nofollow">Fine-tune LLaMA 2 (7-70B) on Amazon SageMaker</a>, a complete guide from setup to QLoRA fine-tuning and deployment on Amazon SageMaker.</li> <li><a href="https://www.philschmid.de/sagemaker-llama-llm" rel="nofollow">Deploy Llama 2 7B/13B/70B on Amazon SageMaker</a>, a guide on using Hugging Face’s LLM DLC container for secure and scalable deployment.</li>',fo,Fe,go,W,Pe,jo,st,On=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a>. It is used to instantiate an LLaMA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the LLaMA-7B.`,Wo,rt,Dn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Uo,B,_o,Ie,bo,A,je,Ho,it,Bn=`Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as there is
no padding token in the original model.`,Eo,lt,We,So,V,Ue,No,dt,Vn=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Jo,U,He,Go,ct,Yn="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Zo,Y,Ro,mt,Xn="if token_ids_1 is None, only returns the first portion of the mask (0s).",Oo,X,Ee,Do,pt,Qn="Save the vocabulary and special tokens file to a directory.",ko,Se,yo,v,Ne,Bo,ht,Kn="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Vo,ut,ea="This uses notably ByteFallback and no normalization.",Yo,Q,Xo,ft,ta=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Qo,gt,oa=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Ko,_t,Je,en,K,Ge,tn,bt,na=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,on,N,Ze,nn,kt,aa=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,an,yt,sa="Should be overridden in a subclass if the model has a special way of building those.",sn,ee,Re,rn,vt,ra="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",ln,Tt,Oe,vo,De,To,F,Be,dn,Lt,ia=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,cn,wt,la=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mn,xt,da="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>LlamaDecoderLayer</code>",pn,J,Ve,hn,Mt,ca='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> forward method, overrides the <code>__call__</code> special method.',un,te,Lo,Ye,wo,O,Xe,fn,H,Qe,gn,$t,ma='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',_n,oe,bn,ne,xo,Ke,Mo,$,et,kn,zt,pa="The LLaMa Model transformer with a sequence classification head on top (linear layer).",yn,Ct,ha=`<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,vn,qt,ua=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Tn,At,fa=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ln,Ft,ga=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wn,G,tt,xn,Pt,_a='The <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Mn,ae,$o,ot,zo,Et,Co;return x=new R({props:{title:"Llama2",local:"llama2",headingTag:"h1"}}),j=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new R({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),D=new Po({props:{warning:!0,$$slots:{default:[Ma]},$$scope:{ctx:z}}}),ue=new Ut({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),ge=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBMbGFtYVRva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZvdXRwdXQlMkZwYXRoJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, LlamaTokenizer

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),ke=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Te=new ka({props:{pipeline:"text-generation"}}),we=new ka({props:{pipeline:"text-classification"}}),Fe=new R({props:{title:"LlamaConfig",local:"transformers.LlamaConfig",headingTag:"h2"}}),Pe=new q({props:{name:"class transformers.LlamaConfig",anchor:"transformers.LlamaConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"pretraining_tp",val:" = 1"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"mlp_bias",val:" = False"},{name:"head_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the LLaMA model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a>`,name:"vocab_size"},{anchor:"transformers.LlamaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.LlamaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.LlamaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.LlamaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.LlamaConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.LlamaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.LlamaConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Llama 1 supports up to 2048 tokens,
Llama 2 up to 4096, CodeLlama up to 16384.`,name:"max_position_embeddings"},{anchor:"transformers.LlamaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.LlamaConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.LlamaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.LlamaConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.LlamaConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.LlamaConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.LlamaConfig.pretraining_tp",description:`<strong>pretraining_tp</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Experimental feature. Tensor parallelism rank used during pretraining. Please refer to <a href="https://huggingface.co/docs/transformers/main/perf_train_gpu_many#tensor-parallelism" rel="nofollow">this
document</a> to
understand more about it. This value is necessary to ensure exact reproducibility of the pretraining
results. Please refer to <a href="https://github.com/pytorch/pytorch/issues/76232" rel="nofollow">this issue</a>.`,name:"pretraining_tp"},{anchor:"transformers.LlamaConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.LlamaConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.LlamaConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.LlamaConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.LlamaConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.LlamaConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"},{anchor:"transformers.LlamaConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The attention head dimension. If None, it will default to hidden_size // num_attention_heads`,name:"head_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/configuration_llama.py#L26"}}),B=new Io({props:{anchor:"transformers.LlamaConfig.example",$$slots:{default:[$a]},$$scope:{ctx:z}}}),Ie=new R({props:{title:"LlamaTokenizer",local:"transformers.LlamaTokenizer",headingTag:"h2"}}),je=new q({props:{name:"class transformers.LlamaTokenizer",anchor:"transformers.LlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"pad_token",val:" = None"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"spaces_between_special_tokens",val:" = False"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>) &#x2014;
A special token used to make arrays of tokens the same size for batching purpose. Will then be ignored by
attention mechanisms or loss computation.`,name:"pad_token"},{anchor:"transformers.LlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>Dict[str, Any]</code>, <code>Optional</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.LlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizer.spaces_between_special_tokens",description:`<strong>spaces_between_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add spaces between special tokens.`,name:"spaces_between_special_tokens"},{anchor:"transformers.LlamaTokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens.
Make sure to also set <code>from_slow</code> to <code>True</code>.
A simple example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L54"}}),We=new q({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L331"}}),Ue=new q({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),He=new q({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Y=new Io({props:{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[za]},$$scope:{ctx:z}}}),Ee=new q({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L304",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),Se=new R({props:{title:"LlamaTokenizerFast",local:"transformers.LlamaTokenizerFast",headingTag:"h2"}}),Ne=new q({props:{name:"class transformers.LlamaTokenizerFast",anchor:"transformers.LlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.LlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizerFast.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens.
Make sure to also set <code>from_slow</code> to <code>True</code>.
A simple example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L49"}}),Q=new Io({props:{anchor:"transformers.LlamaTokenizerFast.example",$$slots:{default:[Ca]},$$scope:{ctx:z}}}),Je=new q({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L246"}}),Ge=new q({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Ze=new q({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3409",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Re=new q({props:{name:"update_post_processor",anchor:"transformers.LlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L181"}}),Oe=new q({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L225"}}),De=new R({props:{title:"LlamaModel",local:"transformers.LlamaModel",headingTag:"h2"}}),Be=new q({props:{name:"class transformers.LlamaModel",anchor:"transformers.LlamaModel",parameters:[{name:"config",val:": LlamaConfig"}],parametersDescription:[{anchor:"transformers.LlamaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.LlamaModel.config",description:"<strong>config</strong> &#x2014; LlamaConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L491"}}),Ve=new q({props:{name:"forward",anchor:"transformers.LlamaModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.LlamaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L525"}}),te=new Po({props:{$$slots:{default:[qa]},$$scope:{ctx:z}}}),Ye=new R({props:{title:"LlamaForCausalLM",local:"transformers.LlamaForCausalLM",headingTag:"h2"}}),Xe=new q({props:{name:"class transformers.LlamaForCausalLM",anchor:"transformers.LlamaForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L764"}}),Qe=new q({props:{name:"forward",anchor:"transformers.LlamaForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama.modeling_llama.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.LlamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlamaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlamaForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L796",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Po({props:{$$slots:{default:[Aa]},$$scope:{ctx:z}}}),ne=new Io({props:{anchor:"transformers.LlamaForCausalLM.forward.example",$$slots:{default:[Fa]},$$scope:{ctx:z}}}),Ke=new R({props:{title:"LlamaForSequenceClassification",local:"transformers.LlamaForSequenceClassification",headingTag:"h2"}}),et=new q({props:{name:"class transformers.LlamaForSequenceClassification",anchor:"transformers.LlamaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L889"}}),tt=new q({props:{name:"forward",anchor:"transformers.LlamaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlamaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L920"}}),ae=new Po({props:{$$slots:{default:[Pa]},$$scope:{ctx:z}}}),ot=new xa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llama2.md"}}),{c(){d=i("meta"),y=n(),c=i("p"),k=n(),p(x.$$.fragment),b=n(),L=i("div"),L.innerHTML=Ht,C=n(),p(j.$$.fragment),Jt=n(),ie=i("p"),ie.innerHTML=$n,Gt=n(),le=i("p"),le.textContent=zn,Zt=n(),de=i("p"),de.innerHTML=Cn,Rt=n(),ce=i("p"),ce.innerHTML=qn,Ot=n(),p(me.$$.fragment),Dt=n(),p(D.$$.fragment),Bt=n(),pe=i("p"),pe.textContent=An,Vt=n(),he=i("ul"),he.innerHTML=Fn,Yt=n(),p(ue.$$.fragment),Xt=n(),fe=i("ul"),fe.innerHTML=Pn,Qt=n(),p(ge.$$.fragment),Kt=n(),_e=i("p"),_e.textContent=In,eo=n(),be=i("ul"),be.innerHTML=jn,to=n(),p(ke.$$.fragment),oo=n(),ye=i("p"),ye.textContent=Wn,no=n(),ve=i("ul"),ve.innerHTML=Un,ao=n(),p(Te.$$.fragment),so=n(),Le=i("ul"),Le.innerHTML=Hn,ro=n(),p(we.$$.fragment),io=n(),xe=i("ul"),xe.innerHTML=En,lo=n(),Me=i("p"),Me.textContent=Sn,co=n(),$e=i("ul"),$e.innerHTML=Nn,mo=n(),ze=i("p"),ze.textContent=Jn,po=n(),Ce=i("ul"),Ce.innerHTML=Gn,ho=n(),qe=i("p"),qe.textContent=Zn,uo=n(),Ae=i("ul"),Ae.innerHTML=Rn,fo=n(),p(Fe.$$.fragment),go=n(),W=i("div"),p(Pe.$$.fragment),jo=n(),st=i("p"),st.innerHTML=On,Wo=n(),rt=i("p"),rt.innerHTML=Dn,Uo=n(),p(B.$$.fragment),_o=n(),p(Ie.$$.fragment),bo=n(),A=i("div"),p(je.$$.fragment),Ho=n(),it=i("p"),it.textContent=Bn,Eo=n(),lt=i("div"),p(We.$$.fragment),So=n(),V=i("div"),p(Ue.$$.fragment),No=n(),dt=i("p"),dt.innerHTML=Vn,Jo=n(),U=i("div"),p(He.$$.fragment),Go=n(),ct=i("p"),ct.textContent=Yn,Zo=n(),p(Y.$$.fragment),Ro=n(),mt=i("p"),mt.textContent=Xn,Oo=n(),X=i("div"),p(Ee.$$.fragment),Do=n(),pt=i("p"),pt.textContent=Qn,ko=n(),p(Se.$$.fragment),yo=n(),v=i("div"),p(Ne.$$.fragment),Bo=n(),ht=i("p"),ht.textContent=Kn,Vo=n(),ut=i("p"),ut.textContent=ea,Yo=n(),p(Q.$$.fragment),Xo=n(),ft=i("p"),ft.innerHTML=ta,Qo=n(),gt=i("p"),gt.innerHTML=oa,Ko=n(),_t=i("div"),p(Je.$$.fragment),en=n(),K=i("div"),p(Ge.$$.fragment),tn=n(),bt=i("p"),bt.innerHTML=na,on=n(),N=i("div"),p(Ze.$$.fragment),nn=n(),kt=i("p"),kt.innerHTML=aa,an=n(),yt=i("p"),yt.textContent=sa,sn=n(),ee=i("div"),p(Re.$$.fragment),rn=n(),vt=i("p"),vt.innerHTML=ra,ln=n(),Tt=i("div"),p(Oe.$$.fragment),vo=n(),p(De.$$.fragment),To=n(),F=i("div"),p(Be.$$.fragment),dn=n(),Lt=i("p"),Lt.innerHTML=ia,cn=n(),wt=i("p"),wt.innerHTML=la,mn=n(),xt=i("p"),xt.innerHTML=da,pn=n(),J=i("div"),p(Ve.$$.fragment),hn=n(),Mt=i("p"),Mt.innerHTML=ca,un=n(),p(te.$$.fragment),Lo=n(),p(Ye.$$.fragment),wo=n(),O=i("div"),p(Xe.$$.fragment),fn=n(),H=i("div"),p(Qe.$$.fragment),gn=n(),$t=i("p"),$t.innerHTML=ma,_n=n(),p(oe.$$.fragment),bn=n(),p(ne.$$.fragment),xo=n(),p(Ke.$$.fragment),Mo=n(),$=i("div"),p(et.$$.fragment),kn=n(),zt=i("p"),zt.textContent=pa,yn=n(),Ct=i("p"),Ct.innerHTML=ha,vn=n(),qt=i("p"),qt.innerHTML=ua,Tn=n(),At=i("p"),At.innerHTML=fa,Ln=n(),Ft=i("p"),Ft.innerHTML=ga,wn=n(),G=i("div"),p(tt.$$.fragment),xn=n(),Pt=i("p"),Pt.innerHTML=_a,Mn=n(),p(ae.$$.fragment),$o=n(),p(ot.$$.fragment),zo=n(),Et=i("p"),this.h()},l(e){const t=wa("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(o),y=a(e),c=l(e,"P",{}),M(c).forEach(o),k=a(e),h(x.$$.fragment,e),b=a(e),L=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(L)!=="svelte-1l5icot"&&(L.innerHTML=Ht),C=a(e),h(j.$$.fragment,e),Jt=a(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-xm2zag"&&(ie.innerHTML=$n),Gt=a(e),le=l(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-vfdo9a"&&(le.textContent=zn),Zt=a(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1wo3ztj"&&(de.innerHTML=Cn),Rt=a(e),ce=l(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-19rh1s"&&(ce.innerHTML=qn),Ot=a(e),h(me.$$.fragment,e),Dt=a(e),h(D.$$.fragment,e),Bt=a(e),pe=l(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-axv494"&&(pe.textContent=An),Vt=a(e),he=l(e,"UL",{"data-svelte-h":!0}),m(he)!=="svelte-tepalw"&&(he.innerHTML=Fn),Yt=a(e),h(ue.$$.fragment,e),Xt=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-yjbkch"&&(fe.innerHTML=Pn),Qt=a(e),h(ge.$$.fragment,e),Kt=a(e),_e=l(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-199e5ee"&&(_e.textContent=In),eo=a(e),be=l(e,"UL",{"data-svelte-h":!0}),m(be)!=="svelte-eq5y0y"&&(be.innerHTML=jn),to=a(e),h(ke.$$.fragment,e),oo=a(e),ye=l(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1l10g8k"&&(ye.textContent=Wn),no=a(e),ve=l(e,"UL",{"data-svelte-h":!0}),m(ve)!=="svelte-189jef5"&&(ve.innerHTML=Un),ao=a(e),h(Te.$$.fragment,e),so=a(e),Le=l(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-1txpvb1"&&(Le.innerHTML=Hn),ro=a(e),h(we.$$.fragment,e),io=a(e),xe=l(e,"UL",{"data-svelte-h":!0}),m(xe)!=="svelte-13c8j1g"&&(xe.innerHTML=En),lo=a(e),Me=l(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-liq2q7"&&(Me.textContent=Sn),co=a(e),$e=l(e,"UL",{"data-svelte-h":!0}),m($e)!=="svelte-1xuj4g0"&&($e.innerHTML=Nn),mo=a(e),ze=l(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1wntqpp"&&(ze.textContent=Jn),po=a(e),Ce=l(e,"UL",{"data-svelte-h":!0}),m(Ce)!=="svelte-gxsehz"&&(Ce.innerHTML=Gn),ho=a(e),qe=l(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-lk14e4"&&(qe.textContent=Zn),uo=a(e),Ae=l(e,"UL",{"data-svelte-h":!0}),m(Ae)!=="svelte-1f88qgk"&&(Ae.innerHTML=Rn),fo=a(e),h(Fe.$$.fragment,e),go=a(e),W=l(e,"DIV",{class:!0});var E=M(W);h(Pe.$$.fragment,E),jo=a(E),st=l(E,"P",{"data-svelte-h":!0}),m(st)!=="svelte-20uyn0"&&(st.innerHTML=On),Wo=a(E),rt=l(E,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-o55m63"&&(rt.innerHTML=Dn),Uo=a(E),h(B.$$.fragment,E),E.forEach(o),_o=a(e),h(Ie.$$.fragment,e),bo=a(e),A=l(e,"DIV",{class:!0});var P=M(A);h(je.$$.fragment,P),Ho=a(P),it=l(P,"P",{"data-svelte-h":!0}),m(it)!=="svelte-qfiu5a"&&(it.textContent=Bn),Eo=a(P),lt=l(P,"DIV",{class:!0});var St=M(lt);h(We.$$.fragment,St),St.forEach(o),So=a(P),V=l(P,"DIV",{class:!0});var nt=M(V);h(Ue.$$.fragment,nt),No=a(nt),dt=l(nt,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-1f4f5kp"&&(dt.innerHTML=Vn),nt.forEach(o),Jo=a(P),U=l(P,"DIV",{class:!0});var S=M(U);h(He.$$.fragment,S),Go=a(S),ct=l(S,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-13bfd60"&&(ct.textContent=Yn),Zo=a(S),h(Y.$$.fragment,S),Ro=a(S),mt=l(S,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-wtrslu"&&(mt.textContent=Xn),S.forEach(o),Oo=a(P),X=l(P,"DIV",{class:!0});var at=M(X);h(Ee.$$.fragment,at),Do=a(at),pt=l(at,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1slb66l"&&(pt.textContent=Qn),at.forEach(o),P.forEach(o),ko=a(e),h(Se.$$.fragment,e),yo=a(e),v=l(e,"DIV",{class:!0});var T=M(v);h(Ne.$$.fragment,T),Bo=a(T),ht=l(T,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-15tdcz8"&&(ht.textContent=Kn),Vo=a(T),ut=l(T,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-llhmpa"&&(ut.textContent=ea),Yo=a(T),h(Q.$$.fragment,T),Xo=a(T),ft=l(T,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-cnb6q1"&&(ft.innerHTML=ta),Qo=a(T),gt=l(T,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-fh0aq"&&(gt.innerHTML=oa),Ko=a(T),_t=l(T,"DIV",{class:!0});var Nt=M(_t);h(Je.$$.fragment,Nt),Nt.forEach(o),en=a(T),K=l(T,"DIV",{class:!0});var qo=M(K);h(Ge.$$.fragment,qo),tn=a(qo),bt=l(qo,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-1wmjg8a"&&(bt.innerHTML=na),qo.forEach(o),on=a(T),N=l(T,"DIV",{class:!0});var It=M(N);h(Ze.$$.fragment,It),nn=a(It),kt=l(It,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-zj1vf1"&&(kt.innerHTML=aa),an=a(It),yt=l(It,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-9vptpw"&&(yt.textContent=sa),It.forEach(o),sn=a(T),ee=l(T,"DIV",{class:!0});var Ao=M(ee);h(Re.$$.fragment,Ao),rn=a(Ao),vt=l(Ao,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-nfci2w"&&(vt.innerHTML=ra),Ao.forEach(o),ln=a(T),Tt=l(T,"DIV",{class:!0});var ba=M(Tt);h(Oe.$$.fragment,ba),ba.forEach(o),T.forEach(o),vo=a(e),h(De.$$.fragment,e),To=a(e),F=l(e,"DIV",{class:!0});var Z=M(F);h(Be.$$.fragment,Z),dn=a(Z),Lt=l(Z,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-4n5ccz"&&(Lt.innerHTML=ia),cn=a(Z),wt=l(Z,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-hswkmf"&&(wt.innerHTML=la),mn=a(Z),xt=l(Z,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-eom0yk"&&(xt.innerHTML=da),pn=a(Z),J=l(Z,"DIV",{class:!0});var jt=M(J);h(Ve.$$.fragment,jt),hn=a(jt),Mt=l(jt,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1wmin46"&&(Mt.innerHTML=ca),un=a(jt),h(te.$$.fragment,jt),jt.forEach(o),Z.forEach(o),Lo=a(e),h(Ye.$$.fragment,e),wo=a(e),O=l(e,"DIV",{class:!0});var Fo=M(O);h(Xe.$$.fragment,Fo),fn=a(Fo),H=l(Fo,"DIV",{class:!0});var se=M(H);h(Qe.$$.fragment,se),gn=a(se),$t=l(se,"P",{"data-svelte-h":!0}),m($t)!=="svelte-1jc6dk6"&&($t.innerHTML=ma),_n=a(se),h(oe.$$.fragment,se),bn=a(se),h(ne.$$.fragment,se),se.forEach(o),Fo.forEach(o),xo=a(e),h(Ke.$$.fragment,e),Mo=a(e),$=l(e,"DIV",{class:!0});var I=M($);h(et.$$.fragment,I),kn=a(I),zt=l(I,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-62must"&&(zt.textContent=pa),yn=a(I),Ct=l(I,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-jn6jrd"&&(Ct.innerHTML=ha),vn=a(I),qt=l(I,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-10ugs3m"&&(qt.innerHTML=ua),Tn=a(I),At=l(I,"P",{"data-svelte-h":!0}),m(At)!=="svelte-6pahdo"&&(At.innerHTML=fa),Ln=a(I),Ft=l(I,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-hswkmf"&&(Ft.innerHTML=ga),wn=a(I),G=l(I,"DIV",{class:!0});var Wt=M(G);h(tt.$$.fragment,Wt),xn=a(Wt),Pt=l(Wt,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-151dzto"&&(Pt.innerHTML=_a),Mn=a(Wt),h(ae.$$.fragment,Wt),Wt.forEach(o),I.forEach(o),$o=a(e),h(ot.$$.fragment,e),zo=a(e),Et=l(e,"P",{}),M(Et).forEach(o),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",ja),w(L,"class","flex flex-wrap space-x-1"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,d),r(e,y,t),r(e,c,t),r(e,k,t),u(x,e,t),r(e,b,t),r(e,L,t),r(e,C,t),u(j,e,t),r(e,Jt,t),r(e,ie,t),r(e,Gt,t),r(e,le,t),r(e,Zt,t),r(e,de,t),r(e,Rt,t),r(e,ce,t),r(e,Ot,t),u(me,e,t),r(e,Dt,t),u(D,e,t),r(e,Bt,t),r(e,pe,t),r(e,Vt,t),r(e,he,t),r(e,Yt,t),u(ue,e,t),r(e,Xt,t),r(e,fe,t),r(e,Qt,t),u(ge,e,t),r(e,Kt,t),r(e,_e,t),r(e,eo,t),r(e,be,t),r(e,to,t),u(ke,e,t),r(e,oo,t),r(e,ye,t),r(e,no,t),r(e,ve,t),r(e,ao,t),u(Te,e,t),r(e,so,t),r(e,Le,t),r(e,ro,t),u(we,e,t),r(e,io,t),r(e,xe,t),r(e,lo,t),r(e,Me,t),r(e,co,t),r(e,$e,t),r(e,mo,t),r(e,ze,t),r(e,po,t),r(e,Ce,t),r(e,ho,t),r(e,qe,t),r(e,uo,t),r(e,Ae,t),r(e,fo,t),u(Fe,e,t),r(e,go,t),r(e,W,t),u(Pe,W,null),s(W,jo),s(W,st),s(W,Wo),s(W,rt),s(W,Uo),u(B,W,null),r(e,_o,t),u(Ie,e,t),r(e,bo,t),r(e,A,t),u(je,A,null),s(A,Ho),s(A,it),s(A,Eo),s(A,lt),u(We,lt,null),s(A,So),s(A,V),u(Ue,V,null),s(V,No),s(V,dt),s(A,Jo),s(A,U),u(He,U,null),s(U,Go),s(U,ct),s(U,Zo),u(Y,U,null),s(U,Ro),s(U,mt),s(A,Oo),s(A,X),u(Ee,X,null),s(X,Do),s(X,pt),r(e,ko,t),u(Se,e,t),r(e,yo,t),r(e,v,t),u(Ne,v,null),s(v,Bo),s(v,ht),s(v,Vo),s(v,ut),s(v,Yo),u(Q,v,null),s(v,Xo),s(v,ft),s(v,Qo),s(v,gt),s(v,Ko),s(v,_t),u(Je,_t,null),s(v,en),s(v,K),u(Ge,K,null),s(K,tn),s(K,bt),s(v,on),s(v,N),u(Ze,N,null),s(N,nn),s(N,kt),s(N,an),s(N,yt),s(v,sn),s(v,ee),u(Re,ee,null),s(ee,rn),s(ee,vt),s(v,ln),s(v,Tt),u(Oe,Tt,null),r(e,vo,t),u(De,e,t),r(e,To,t),r(e,F,t),u(Be,F,null),s(F,dn),s(F,Lt),s(F,cn),s(F,wt),s(F,mn),s(F,xt),s(F,pn),s(F,J),u(Ve,J,null),s(J,hn),s(J,Mt),s(J,un),u(te,J,null),r(e,Lo,t),u(Ye,e,t),r(e,wo,t),r(e,O,t),u(Xe,O,null),s(O,fn),s(O,H),u(Qe,H,null),s(H,gn),s(H,$t),s(H,_n),u(oe,H,null),s(H,bn),u(ne,H,null),r(e,xo,t),u(Ke,e,t),r(e,Mo,t),r(e,$,t),u(et,$,null),s($,kn),s($,zt),s($,yn),s($,Ct),s($,vn),s($,qt),s($,Tn),s($,At),s($,Ln),s($,Ft),s($,wn),s($,G),u(tt,G,null),s(G,xn),s(G,Pt),s(G,Mn),u(ae,G,null),r(e,$o,t),u(ot,e,t),r(e,zo,t),r(e,Et,t),Co=!0},p(e,[t]){const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),D.$set(E);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),B.$set(P);const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),Y.$set(St);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),Q.$set(nt);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),te.$set(S);const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),oe.$set(at);const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),ne.$set(T);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),ae.$set(Nt)},i(e){Co||(f(x.$$.fragment,e),f(j.$$.fragment,e),f(me.$$.fragment,e),f(D.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(ke.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(Fe.$$.fragment,e),f(Pe.$$.fragment,e),f(B.$$.fragment,e),f(Ie.$$.fragment,e),f(je.$$.fragment,e),f(We.$$.fragment,e),f(Ue.$$.fragment,e),f(He.$$.fragment,e),f(Y.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Ne.$$.fragment,e),f(Q.$$.fragment,e),f(Je.$$.fragment,e),f(Ge.$$.fragment,e),f(Ze.$$.fragment,e),f(Re.$$.fragment,e),f(Oe.$$.fragment,e),f(De.$$.fragment,e),f(Be.$$.fragment,e),f(Ve.$$.fragment,e),f(te.$$.fragment,e),f(Ye.$$.fragment,e),f(Xe.$$.fragment,e),f(Qe.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ae.$$.fragment,e),f(ot.$$.fragment,e),Co=!0)},o(e){g(x.$$.fragment,e),g(j.$$.fragment,e),g(me.$$.fragment,e),g(D.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(ke.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(Fe.$$.fragment,e),g(Pe.$$.fragment,e),g(B.$$.fragment,e),g(Ie.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Ue.$$.fragment,e),g(He.$$.fragment,e),g(Y.$$.fragment,e),g(Ee.$$.fragment,e),g(Se.$$.fragment,e),g(Ne.$$.fragment,e),g(Q.$$.fragment,e),g(Je.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Re.$$.fragment,e),g(Oe.$$.fragment,e),g(De.$$.fragment,e),g(Be.$$.fragment,e),g(Ve.$$.fragment,e),g(te.$$.fragment,e),g(Ye.$$.fragment,e),g(Xe.$$.fragment,e),g(Qe.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ae.$$.fragment,e),g(ot.$$.fragment,e),Co=!1},d(e){e&&(o(y),o(c),o(k),o(b),o(L),o(C),o(Jt),o(ie),o(Gt),o(le),o(Zt),o(de),o(Rt),o(ce),o(Ot),o(Dt),o(Bt),o(pe),o(Vt),o(he),o(Yt),o(Xt),o(fe),o(Qt),o(Kt),o(_e),o(eo),o(be),o(to),o(oo),o(ye),o(no),o(ve),o(ao),o(so),o(Le),o(ro),o(io),o(xe),o(lo),o(Me),o(co),o($e),o(mo),o(ze),o(po),o(Ce),o(ho),o(qe),o(uo),o(Ae),o(fo),o(go),o(W),o(_o),o(bo),o(A),o(ko),o(yo),o(v),o(vo),o(To),o(F),o(Lo),o(wo),o(O),o(xo),o(Mo),o($),o($o),o(zo),o(Et)),o(d),_(x,e),_(j,e),_(me,e),_(D,e),_(ue,e),_(ge,e),_(ke,e),_(Te,e),_(we,e),_(Fe,e),_(Pe),_(B),_(Ie,e),_(je),_(We),_(Ue),_(He),_(Y),_(Ee),_(Se,e),_(Ne),_(Q),_(Je),_(Ge),_(Ze),_(Re),_(Oe),_(De,e),_(Be),_(Ve),_(te),_(Ye,e),_(Xe),_(Qe),_(oe),_(ne),_(Ke,e),_(et),_(tt),_(ae),_(ot,e)}}}const ja='{"title":"Llama2","local":"llama2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"LlamaConfig","local":"transformers.LlamaConfig","sections":[],"depth":2},{"title":"LlamaTokenizer","local":"transformers.LlamaTokenizer","sections":[],"depth":2},{"title":"LlamaTokenizerFast","local":"transformers.LlamaTokenizerFast","sections":[],"depth":2},{"title":"LlamaModel","local":"transformers.LlamaModel","sections":[],"depth":2},{"title":"LlamaForCausalLM","local":"transformers.LlamaForCausalLM","sections":[],"depth":2},{"title":"LlamaForSequenceClassification","local":"transformers.LlamaForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Wa(z){return va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends Ta{constructor(d){super(),La(this,d,Wa,Ia,ya,{})}}export{Ra as component};
