import{s as ft,o as ht,n as ye}from"../chunks/scheduler.01eeda35.js";import{S as ut,i as gt,g as m,s as l,r as _,A as _t,h as p,f as r,c as d,j as fe,u as M,x as k,k as Q,y as f,a as i,v as b,d as T,t as y,w}from"../chunks/index.6dd51b66.js";import{T as st}from"../chunks/Tip.de9bae2b.js";import{D as je}from"../chunks/Docstring.76e6b3cf.js";import{C as De}from"../chunks/CodeBlock.864da1b0.js";import{F as Mt,M as bt}from"../chunks/Markdown.3138439e.js";import{E as Oe}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{P as dt}from"../chunks/PipelineTag.5efc345e.js";import{H as Ee,E as Tt}from"../chunks/EditOnGithub.7faefd25.js";function yt(B){let t,h="Examples:",s,a,u;return a=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vZGVybkJlcnRNb2RlbCUyQyUyME1vZGVybkJlcnRDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTW9kZXJuQmVydCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb2Rlcm5CZXJ0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbW9kZXJuYmVydC1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNb2Rlcm5CZXJ0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ModernBertModel, ModernBertConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ModernBert style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ModernBertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the modernbert-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function wt(B){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(s){t=p(s,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(s,a){i(s,t,a)},p:ye,d(s){s&&r(t)}}}function kt(B){let t,h="Example:",s,a,u;return a=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb2Rlcm5CZXJ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFuc3dlcmRvdGFpJTJGTW9kZXJuQkVSVC1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTW9kZXJuQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJhbnN3ZXJkb3RhaSUyRk1vZGVybkJFUlQtYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ModernBertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertModel.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function vt(B){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(s){t=p(s,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(s,a){i(s,t,a)},p:ye,d(s){s&&r(t)}}}function Bt(B){let t,h="Example:",s,a,u;return a=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb2Rlcm5CZXJ0Rm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFuc3dlcmRvdGFpJTJGTW9kZXJuQkVSVC1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTW9kZXJuQmVydEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJhbnN3ZXJkb3RhaSUyRk1vZGVybkJFUlQtYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjAlNUJNQVNLJTVELiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjByZXRyaWV2ZSUyMGluZGV4JTIwb2YlMjAlNUJNQVNLJTVEJTBBbWFza190b2tlbl9pbmRleCUyMCUzRCUyMChpbnB1dHMuaW5wdXRfaWRzJTIwJTNEJTNEJTIwdG9rZW5pemVyLm1hc2tfdG9rZW5faWQpJTVCMCU1RC5ub256ZXJvKGFzX3R1cGxlJTNEVHJ1ZSklNUIwJTVEJTBBJTBBcHJlZGljdGVkX3Rva2VuX2lkJTIwJTNEJTIwbG9naXRzJTVCMCUyQyUyMG1hc2tfdG9rZW5faW5kZXglNUQuYXJnbWF4KGF4aXMlM0QtMSklMEElMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSUyMyUyMG1hc2slMjBsYWJlbHMlMjBvZiUyMG5vbi0lNUJNQVNLJTVEJTIwdG9rZW5zJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2gud2hlcmUoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkJTJDJTIwbGFiZWxzJTJDJTIwLTEwMCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ModernBertForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForMaskedLM.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-[MASK] tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function $t(B){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(s){t=p(s,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(s,a){i(s,t,a)},p:ye,d(s){s&&r(t)}}}function Ct(B){let t,h="Example of single-label classification:",s,a,u;return a=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1vZGVybkJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBNb2Rlcm5CZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME1vZGVybkJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJhbnN3ZXJkb3RhaSUyRk1vZGVybkJFUlQtYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ModernBertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-ykxpe4"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function Jt(B){let t,h="Example of multi-label classification:",s,a,u;return a=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1vZGVybkJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBNb2Rlcm5CZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME1vZGVybkJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJhbnN3ZXJkb3RhaSUyRk1vZGVybkJFUlQtYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ModernBertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-1l8e32d"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function xt(B){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(s){t=p(s,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(s,a){i(s,t,a)},p:ye,d(s){s&&r(t)}}}function zt(B){let t,h="Example:",s,a,u;return a=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb2Rlcm5CZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBNb2Rlcm5CZXJ0Rm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYW5zd2VyZG90YWklMkZNb2Rlcm5CRVJULWJhc2UlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ModernBertForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ModernBertForTokenClassification.from_pretrained(<span class="hljs-string">&quot;answerdotai/ModernBERT-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,s=l(),_(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=h),s=d(n),M(a.$$.fragment,n)},m(n,v){i(n,t,v),i(n,s,v),b(a,n,v),u=!0},p:ye,i(n){u||(T(a.$$.fragment,n),u=!0)},o(n){y(a.$$.fragment,n),u=!1},d(n){n&&(r(t),r(s)),w(a,n)}}}function jt(B){let t,h,s,a,u,n,v=`The bare ModernBert Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pe,O,he=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ue,z,ue,Fe,R,Ke='The <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertModel">ModernBertModel</a> forward method, overrides the <code>__call__</code> special method.',We,q,Ye,V,H,ge,we,$,_e,qe,G,et=`The ModernBert Model with a decoder head on top that is used for masked language modeling.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ze,N,tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ie,j,X,D,ke,Ve='The <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertForMaskedLM">ModernBertForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',K,L,ee,te,ve,I,Be,C,Me,Re,E,Le=`The ModernBert Model with a sequence classification head on top that performs pooling.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ne,$e,Se=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oe,U,J,se,be,Ce='The <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertForSequenceClassification">ModernBertForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ae,P,Te,re,He,W,Je,Z,xe,x,Y,ze,ae,e=`The ModernBert Model with a token classification head on top, e.g. for Named Entity Recognition (NER) tasks.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,c,F,nt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rt,A,Xe,at,Qe,ct='The <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertForTokenClassification">ModernBertForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',it,Ge,lt,Ne,ot;return t=new Ee({props:{title:"ModernBertModel",local:"transformers.ModernBertModel",headingTag:"h2"}}),a=new je({props:{name:"class transformers.ModernBertModel",anchor:"transformers.ModernBertModel",parameters:[{name:"config",val:": ModernBertConfig"}],parametersDescription:[{anchor:"transformers.ModernBertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig">ModernBertConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L866"}}),ue=new je({props:{name:"forward",anchor:"transformers.ModernBertModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sliding_window_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"indices",val:": typing.Optional[torch.Tensor] = None"},{name:"cu_seqlens",val:": typing.Optional[torch.Tensor] = None"},{name:"max_seqlen",val:": typing.Optional[int] = None"},{name:"batch_size",val:": typing.Optional[int] = None"},{name:"seq_len",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ModernBertModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. With Flash Attention 2.0, padding will be ignored
by default should you provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ModernBertModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ModernBertModel.forward.sliding_window_mask",description:`<strong>sliding_window_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding or far-away tokens. In ModernBert, only every few layers
perform global attention, while the rest perform local attention. This mask is used to avoid attending to
far-away tokens in the local attention layers when not using Flash Attention.`,name:"sliding_window_mask"},{anchor:"transformers.ModernBertModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ModernBertModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ModernBertModel.forward.indices",description:`<strong>indices</strong> (<code>torch.Tensor</code> of shape <code>(total_unpadded_tokens,)</code>, <em>optional</em>) &#x2014;
Indices of the non-padding tokens in the input sequence. Used for unpadding the output.`,name:"indices"},{anchor:"transformers.ModernBertModel.forward.cu_seqlens",description:`<strong>cu_seqlens</strong> (<code>torch.Tensor</code> of shape <code>(batch + 1,)</code>, <em>optional</em>) &#x2014;
Cumulative sequence lengths of the input sequences. Used to index the unpadded tensors.`,name:"cu_seqlens"},{anchor:"transformers.ModernBertModel.forward.max_seqlen",description:`<strong>max_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum sequence length in the batch excluding padding tokens. Used to unpad input_ids and pad output tensors.`,name:"max_seqlen"},{anchor:"transformers.ModernBertModel.forward.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size of the input sequences. Used to pad the output tensors.`,name:"batch_size"},{anchor:"transformers.ModernBertModel.forward.seq_len",description:`<strong>seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sequence length of the input sequences including padding tokens. Used to pad the output tensors.`,name:"seq_len"},{anchor:"transformers.ModernBertModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ModernBertModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ModernBertModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig"
>ModernBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new st({props:{$$slots:{default:[wt]},$$scope:{ctx:B}}}),V=new Oe({props:{anchor:"transformers.ModernBertModel.forward.example",$$slots:{default:[kt]},$$scope:{ctx:B}}}),ge=new Ee({props:{title:"ModernBertForMaskedLM",local:"transformers.ModernBertForMaskedLM",headingTag:"h2"}}),_e=new je({props:{name:"class transformers.ModernBertForMaskedLM",anchor:"transformers.ModernBertForMaskedLM",parameters:[{name:"config",val:": ModernBertConfig"}],parametersDescription:[{anchor:"transformers.ModernBertForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig">ModernBertConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1056"}}),X=new je({props:{name:"forward",anchor:"transformers.ModernBertForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sliding_window_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"indices",val:": typing.Optional[torch.Tensor] = None"},{name:"cu_seqlens",val:": typing.Optional[torch.Tensor] = None"},{name:"max_seqlen",val:": typing.Optional[int] = None"},{name:"batch_size",val:": typing.Optional[int] = None"},{name:"seq_len",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ModernBertForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. With Flash Attention 2.0, padding will be ignored
by default should you provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ModernBertForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ModernBertForMaskedLM.forward.sliding_window_mask",description:`<strong>sliding_window_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding or far-away tokens. In ModernBert, only every few layers
perform global attention, while the rest perform local attention. This mask is used to avoid attending to
far-away tokens in the local attention layers when not using Flash Attention.`,name:"sliding_window_mask"},{anchor:"transformers.ModernBertForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ModernBertForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ModernBertForMaskedLM.forward.indices",description:`<strong>indices</strong> (<code>torch.Tensor</code> of shape <code>(total_unpadded_tokens,)</code>, <em>optional</em>) &#x2014;
Indices of the non-padding tokens in the input sequence. Used for unpadding the output.`,name:"indices"},{anchor:"transformers.ModernBertForMaskedLM.forward.cu_seqlens",description:`<strong>cu_seqlens</strong> (<code>torch.Tensor</code> of shape <code>(batch + 1,)</code>, <em>optional</em>) &#x2014;
Cumulative sequence lengths of the input sequences. Used to index the unpadded tensors.`,name:"cu_seqlens"},{anchor:"transformers.ModernBertForMaskedLM.forward.max_seqlen",description:`<strong>max_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum sequence length in the batch excluding padding tokens. Used to unpad input_ids and pad output tensors.`,name:"max_seqlen"},{anchor:"transformers.ModernBertForMaskedLM.forward.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size of the input sequences. Used to pad the output tensors.`,name:"batch_size"},{anchor:"transformers.ModernBertForMaskedLM.forward.seq_len",description:`<strong>seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sequence length of the input sequences including padding tokens. Used to pad the output tensors.`,name:"seq_len"},{anchor:"transformers.ModernBertForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ModernBertForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ModernBertForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1086",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig"
>ModernBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new st({props:{$$slots:{default:[vt]},$$scope:{ctx:B}}}),te=new Oe({props:{anchor:"transformers.ModernBertForMaskedLM.forward.example",$$slots:{default:[Bt]},$$scope:{ctx:B}}}),I=new Ee({props:{title:"ModernBertForSequenceClassification",local:"transformers.ModernBertForSequenceClassification",headingTag:"h2"}}),Me=new je({props:{name:"class transformers.ModernBertForSequenceClassification",anchor:"transformers.ModernBertForSequenceClassification",parameters:[{name:"config",val:": ModernBertConfig"}],parametersDescription:[{anchor:"transformers.ModernBertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig">ModernBertConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1188"}}),J=new je({props:{name:"forward",anchor:"transformers.ModernBertForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sliding_window_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"indices",val:": typing.Optional[torch.Tensor] = None"},{name:"cu_seqlens",val:": typing.Optional[torch.Tensor] = None"},{name:"max_seqlen",val:": typing.Optional[int] = None"},{name:"batch_size",val:": typing.Optional[int] = None"},{name:"seq_len",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ModernBertForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. With Flash Attention 2.0, padding will be ignored
by default should you provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ModernBertForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ModernBertForSequenceClassification.forward.sliding_window_mask",description:`<strong>sliding_window_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding or far-away tokens. In ModernBert, only every few layers
perform global attention, while the rest perform local attention. This mask is used to avoid attending to
far-away tokens in the local attention layers when not using Flash Attention.`,name:"sliding_window_mask"},{anchor:"transformers.ModernBertForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ModernBertForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ModernBertForSequenceClassification.forward.indices",description:`<strong>indices</strong> (<code>torch.Tensor</code> of shape <code>(total_unpadded_tokens,)</code>, <em>optional</em>) &#x2014;
Indices of the non-padding tokens in the input sequence. Used for unpadding the output.`,name:"indices"},{anchor:"transformers.ModernBertForSequenceClassification.forward.cu_seqlens",description:`<strong>cu_seqlens</strong> (<code>torch.Tensor</code> of shape <code>(batch + 1,)</code>, <em>optional</em>) &#x2014;
Cumulative sequence lengths of the input sequences. Used to index the unpadded tensors.`,name:"cu_seqlens"},{anchor:"transformers.ModernBertForSequenceClassification.forward.max_seqlen",description:`<strong>max_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum sequence length in the batch excluding padding tokens. Used to unpad input_ids and pad output tensors.`,name:"max_seqlen"},{anchor:"transformers.ModernBertForSequenceClassification.forward.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size of the input sequences. Used to pad the output tensors.`,name:"batch_size"},{anchor:"transformers.ModernBertForSequenceClassification.forward.seq_len",description:`<strong>seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sequence length of the input sequences including padding tokens. Used to pad the output tensors.`,name:"seq_len"},{anchor:"transformers.ModernBertForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ModernBertForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ModernBertForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ModernBertForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1206",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig"
>ModernBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new st({props:{$$slots:{default:[$t]},$$scope:{ctx:B}}}),re=new Oe({props:{anchor:"transformers.ModernBertForSequenceClassification.forward.example",$$slots:{default:[Ct]},$$scope:{ctx:B}}}),W=new Oe({props:{anchor:"transformers.ModernBertForSequenceClassification.forward.example-2",$$slots:{default:[Jt]},$$scope:{ctx:B}}}),Z=new Ee({props:{title:"ModernBertForTokenClassification",local:"transformers.ModernBertForTokenClassification",headingTag:"h2"}}),Y=new je({props:{name:"class transformers.ModernBertForTokenClassification",anchor:"transformers.ModernBertForTokenClassification",parameters:[{name:"config",val:": ModernBertConfig"}],parametersDescription:[{anchor:"transformers.ModernBertForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig">ModernBertConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1302"}}),Xe=new je({props:{name:"forward",anchor:"transformers.ModernBertForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sliding_window_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"indices",val:": typing.Optional[torch.Tensor] = None"},{name:"cu_seqlens",val:": typing.Optional[torch.Tensor] = None"},{name:"max_seqlen",val:": typing.Optional[int] = None"},{name:"batch_size",val:": typing.Optional[int] = None"},{name:"seq_len",val:": typing.Optional[int] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ModernBertForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. With Flash Attention 2.0, padding will be ignored
by default should you provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ModernBertForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ModernBertForTokenClassification.forward.sliding_window_mask",description:`<strong>sliding_window_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding or far-away tokens. In ModernBert, only every few layers
perform global attention, while the rest perform local attention. This mask is used to avoid attending to
far-away tokens in the local attention layers when not using Flash Attention.`,name:"sliding_window_mask"},{anchor:"transformers.ModernBertForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ModernBertForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ModernBertForTokenClassification.forward.indices",description:`<strong>indices</strong> (<code>torch.Tensor</code> of shape <code>(total_unpadded_tokens,)</code>, <em>optional</em>) &#x2014;
Indices of the non-padding tokens in the input sequence. Used for unpadding the output.`,name:"indices"},{anchor:"transformers.ModernBertForTokenClassification.forward.cu_seqlens",description:`<strong>cu_seqlens</strong> (<code>torch.Tensor</code> of shape <code>(batch + 1,)</code>, <em>optional</em>) &#x2014;
Cumulative sequence lengths of the input sequences. Used to index the unpadded tensors.`,name:"cu_seqlens"},{anchor:"transformers.ModernBertForTokenClassification.forward.max_seqlen",description:`<strong>max_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum sequence length in the batch excluding padding tokens. Used to unpad input_ids and pad output tensors.`,name:"max_seqlen"},{anchor:"transformers.ModernBertForTokenClassification.forward.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size of the input sequences. Used to pad the output tensors.`,name:"batch_size"},{anchor:"transformers.ModernBertForTokenClassification.forward.seq_len",description:`<strong>seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sequence length of the input sequences including padding tokens. Used to pad the output tensors.`,name:"seq_len"},{anchor:"transformers.ModernBertForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ModernBertForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ModernBertForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ModernBertForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/modeling_modernbert.py#L1319",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertConfig"
>ModernBertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ge=new st({props:{$$slots:{default:[xt]},$$scope:{ctx:B}}}),Ne=new Oe({props:{anchor:"transformers.ModernBertForTokenClassification.forward.example",$$slots:{default:[zt]},$$scope:{ctx:B}}}),{c(){_(t.$$.fragment),h=l(),s=m("div"),_(a.$$.fragment),u=l(),n=m("p"),n.innerHTML=v,Pe=l(),O=m("p"),O.innerHTML=he,Ue=l(),z=m("div"),_(ue.$$.fragment),Fe=l(),R=m("p"),R.innerHTML=Ke,We=l(),_(q.$$.fragment),Ye=l(),_(V.$$.fragment),H=l(),_(ge.$$.fragment),we=l(),$=m("div"),_(_e.$$.fragment),qe=l(),G=m("p"),G.innerHTML=et,Ze=l(),N=m("p"),N.innerHTML=tt,Ie=l(),j=m("div"),_(X.$$.fragment),D=l(),ke=m("p"),ke.innerHTML=Ve,K=l(),_(L.$$.fragment),ee=l(),_(te.$$.fragment),ve=l(),_(I.$$.fragment),Be=l(),C=m("div"),_(Me.$$.fragment),Re=l(),E=m("p"),E.innerHTML=Le,ne=l(),$e=m("p"),$e.innerHTML=Se,oe=l(),U=m("div"),_(J.$$.fragment),se=l(),be=m("p"),be.innerHTML=Ce,Ae=l(),_(P.$$.fragment),Te=l(),_(re.$$.fragment),He=l(),_(W.$$.fragment),Je=l(),_(Z.$$.fragment),xe=l(),x=m("div"),_(Y.$$.fragment),ze=l(),ae=m("p"),ae.innerHTML=e,c=l(),F=m("p"),F.innerHTML=nt,rt=l(),A=m("div"),_(Xe.$$.fragment),at=l(),Qe=m("p"),Qe.innerHTML=ct,it=l(),_(Ge.$$.fragment),lt=l(),_(Ne.$$.fragment),this.h()},l(o){M(t.$$.fragment,o),h=d(o),s=p(o,"DIV",{class:!0});var g=fe(s);M(a.$$.fragment,g),u=d(g),n=p(g,"P",{"data-svelte-h":!0}),k(n)!=="svelte-14lodby"&&(n.innerHTML=v),Pe=d(g),O=p(g,"P",{"data-svelte-h":!0}),k(O)!=="svelte-hswkmf"&&(O.innerHTML=he),Ue=d(g),z=p(g,"DIV",{class:!0});var ie=fe(z);M(ue.$$.fragment,ie),Fe=d(ie),R=p(ie,"P",{"data-svelte-h":!0}),k(R)!=="svelte-1hk3d3n"&&(R.innerHTML=Ke),We=d(ie),M(q.$$.fragment,ie),Ye=d(ie),M(V.$$.fragment,ie),ie.forEach(r),g.forEach(r),H=d(o),M(ge.$$.fragment,o),we=d(o),$=p(o,"DIV",{class:!0});var le=fe($);M(_e.$$.fragment,le),qe=d(le),G=p(le,"P",{"data-svelte-h":!0}),k(G)!=="svelte-16uwas2"&&(G.innerHTML=et),Ze=d(le),N=p(le,"P",{"data-svelte-h":!0}),k(N)!=="svelte-hswkmf"&&(N.innerHTML=tt),Ie=d(le),j=p(le,"DIV",{class:!0});var de=fe(j);M(X.$$.fragment,de),D=d(de),ke=p(de,"P",{"data-svelte-h":!0}),k(ke)!=="svelte-18i89fr"&&(ke.innerHTML=Ve),K=d(de),M(L.$$.fragment,de),ee=d(de),M(te.$$.fragment,de),de.forEach(r),le.forEach(r),ve=d(o),M(I.$$.fragment,o),Be=d(o),C=p(o,"DIV",{class:!0});var ce=fe(C);M(Me.$$.fragment,ce),Re=d(ce),E=p(ce,"P",{"data-svelte-h":!0}),k(E)!=="svelte-11ak7o7"&&(E.innerHTML=Le),ne=d(ce),$e=p(ce,"P",{"data-svelte-h":!0}),k($e)!=="svelte-hswkmf"&&($e.innerHTML=Se),oe=d(ce),U=p(ce,"DIV",{class:!0});var S=fe(U);M(J.$$.fragment,S),se=d(S),be=p(S,"P",{"data-svelte-h":!0}),k(be)!=="svelte-4tzgbv"&&(be.innerHTML=Ce),Ae=d(S),M(P.$$.fragment,S),Te=d(S),M(re.$$.fragment,S),He=d(S),M(W.$$.fragment,S),S.forEach(r),ce.forEach(r),Je=d(o),M(Z.$$.fragment,o),xe=d(o),x=p(o,"DIV",{class:!0});var me=fe(x);M(Y.$$.fragment,me),ze=d(me),ae=p(me,"P",{"data-svelte-h":!0}),k(ae)!=="svelte-1mi2kz4"&&(ae.innerHTML=e),c=d(me),F=p(me,"P",{"data-svelte-h":!0}),k(F)!=="svelte-hswkmf"&&(F.innerHTML=nt),rt=d(me),A=p(me,"DIV",{class:!0});var pe=fe(A);M(Xe.$$.fragment,pe),at=d(pe),Qe=p(pe,"P",{"data-svelte-h":!0}),k(Qe)!=="svelte-3d6wnn"&&(Qe.innerHTML=ct),it=d(pe),M(Ge.$$.fragment,pe),lt=d(pe),M(Ne.$$.fragment,pe),pe.forEach(r),me.forEach(r),this.h()},h(){Q(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,g){b(t,o,g),i(o,h,g),i(o,s,g),b(a,s,null),f(s,u),f(s,n),f(s,Pe),f(s,O),f(s,Ue),f(s,z),b(ue,z,null),f(z,Fe),f(z,R),f(z,We),b(q,z,null),f(z,Ye),b(V,z,null),i(o,H,g),b(ge,o,g),i(o,we,g),i(o,$,g),b(_e,$,null),f($,qe),f($,G),f($,Ze),f($,N),f($,Ie),f($,j),b(X,j,null),f(j,D),f(j,ke),f(j,K),b(L,j,null),f(j,ee),b(te,j,null),i(o,ve,g),b(I,o,g),i(o,Be,g),i(o,C,g),b(Me,C,null),f(C,Re),f(C,E),f(C,ne),f(C,$e),f(C,oe),f(C,U),b(J,U,null),f(U,se),f(U,be),f(U,Ae),b(P,U,null),f(U,Te),b(re,U,null),f(U,He),b(W,U,null),i(o,Je,g),b(Z,o,g),i(o,xe,g),i(o,x,g),b(Y,x,null),f(x,ze),f(x,ae),f(x,c),f(x,F),f(x,rt),f(x,A),b(Xe,A,null),f(A,at),f(A,Qe),f(A,it),b(Ge,A,null),f(A,lt),b(Ne,A,null),ot=!0},p(o,g){const ie={};g&2&&(ie.$$scope={dirty:g,ctx:o}),q.$set(ie);const le={};g&2&&(le.$$scope={dirty:g,ctx:o}),V.$set(le);const de={};g&2&&(de.$$scope={dirty:g,ctx:o}),L.$set(de);const ce={};g&2&&(ce.$$scope={dirty:g,ctx:o}),te.$set(ce);const S={};g&2&&(S.$$scope={dirty:g,ctx:o}),P.$set(S);const me={};g&2&&(me.$$scope={dirty:g,ctx:o}),re.$set(me);const pe={};g&2&&(pe.$$scope={dirty:g,ctx:o}),W.$set(pe);const mt={};g&2&&(mt.$$scope={dirty:g,ctx:o}),Ge.$set(mt);const pt={};g&2&&(pt.$$scope={dirty:g,ctx:o}),Ne.$set(pt)},i(o){ot||(T(t.$$.fragment,o),T(a.$$.fragment,o),T(ue.$$.fragment,o),T(q.$$.fragment,o),T(V.$$.fragment,o),T(ge.$$.fragment,o),T(_e.$$.fragment,o),T(X.$$.fragment,o),T(L.$$.fragment,o),T(te.$$.fragment,o),T(I.$$.fragment,o),T(Me.$$.fragment,o),T(J.$$.fragment,o),T(P.$$.fragment,o),T(re.$$.fragment,o),T(W.$$.fragment,o),T(Z.$$.fragment,o),T(Y.$$.fragment,o),T(Xe.$$.fragment,o),T(Ge.$$.fragment,o),T(Ne.$$.fragment,o),ot=!0)},o(o){y(t.$$.fragment,o),y(a.$$.fragment,o),y(ue.$$.fragment,o),y(q.$$.fragment,o),y(V.$$.fragment,o),y(ge.$$.fragment,o),y(_e.$$.fragment,o),y(X.$$.fragment,o),y(L.$$.fragment,o),y(te.$$.fragment,o),y(I.$$.fragment,o),y(Me.$$.fragment,o),y(J.$$.fragment,o),y(P.$$.fragment,o),y(re.$$.fragment,o),y(W.$$.fragment,o),y(Z.$$.fragment,o),y(Y.$$.fragment,o),y(Xe.$$.fragment,o),y(Ge.$$.fragment,o),y(Ne.$$.fragment,o),ot=!1},d(o){o&&(r(h),r(s),r(H),r(we),r($),r(ve),r(Be),r(C),r(Je),r(xe),r(x)),w(t,o),w(a),w(ue),w(q),w(V),w(ge,o),w(_e),w(X),w(L),w(te),w(I,o),w(Me),w(J),w(P),w(re),w(W),w(Z,o),w(Y),w(Xe),w(Ge),w(Ne)}}}function Ut(B){let t,h;return t=new bt({props:{$$slots:{default:[jt]},$$scope:{ctx:B}}}),{c(){_(t.$$.fragment)},l(s){M(t.$$.fragment,s)},m(s,a){b(t,s,a),h=!0},p(s,a){const u={};a&2&&(u.$$scope={dirty:a,ctx:s}),t.$set(u)},i(s){h||(T(t.$$.fragment,s),h=!0)},o(s){y(t.$$.fragment,s),h=!1},d(s){w(t,s)}}}function Ft(B){let t,h,s,a,u,n,v,Pe='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',O,he,Ue,z,ue='The ModernBERT model was proposed in <a href="https://arxiv.org/abs/2412.13663" rel="nofollow">Smarter, Better, Faster, Longer: A Modern Bidirectional Encoder for Fast, Memory Efficient, and Long Context Finetuning and Inference</a> by Benjamin Warner, Antoine Chaffin, Benjamin Clavié, Orion Weller, Oskar Hallström, Said Taghadouini, Alexis Galalgher, Raja Bisas, Faisal Ladhak, Tom Aarsen, Nathan Cooper, Grifin Adams, Jeremy Howard and Iacopo Poli.',Fe,R,Ke='It is a refresh of the traditional encoder architecture, as used in previous models such as <a href="https://huggingface.co/docs/transformers/en/model_doc/bert" rel="nofollow">BERT</a> and <a href="https://huggingface.co/docs/transformers/en/model_doc/roberta" rel="nofollow">RoBERTa</a>.',We,q,Ye="It builds on BERT and implements many modern architectural improvements which have been developed since its original release, such as:",V,H,ge='<li><a href="https://huggingface.co/blog/designing-positional-encoding" rel="nofollow">Rotary Positional Embeddings</a> to support sequences of up to 8192 tokens.</li> <li><a href="https://arxiv.org/abs/2208.08124" rel="nofollow">Unpadding</a> to ensure no compute is wasted on padding tokens, speeding up processing time for batches with mixed-length sequences.</li> <li><a href="https://arxiv.org/abs/2002.05202" rel="nofollow">GeGLU</a> Replacing the original MLP layers with GeGLU layers, shown to improve performance.</li> <li><a href="https://arxiv.org/abs/2004.05150v2" rel="nofollow">Alternating Attention</a> where most attention layers employ a sliding window of 128 tokens, with Global Attention only used every 3 layers.</li> <li><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Flash Attention</a> to speed up processing.</li> <li>A model designed following recent <a href="https://arxiv.org/abs/2401.14489" rel="nofollow">The Case for Co-Designing Model Architectures with Hardware</a>, ensuring maximum efficiency across inference GPUs.</li> <li>Modern training data scales (2 trillion tokens) and mixtures (including code ande math data)</li>',we,$,_e="The abstract from the paper is the following:",qe,G,et="<em>Encoder-only transformer models such as BERT offer a great performance-size tradeoff for retrieval and classification tasks with respect to larger decoder-only models. Despite being the workhorse of numerous production pipelines, there have been limited Pareto improvements to BERT since its release. In this paper, we introduce ModernBERT, bringing modern model optimizations to encoder-only models and representing a major Pareto improvement over older encoders. Trained on 2 trillion tokens with a native 8192 sequence length, ModernBERT models exhibit state-of-the-art results on a large pool of evaluations encompassing diverse classification tasks and both single and multi-vector retrieval on different domains (including code). In addition to strong downstream performance, ModernBERT is also the most speed and memory efficient encoder and is designed for inference on common GPUs.</em>",Ze,N,tt='The original code can be found <a href="https://github.com/answerdotai/modernbert" rel="nofollow">here</a>.',Ie,j,X,D,ke="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ModernBert.",Ve,K,L,ee,te='<li>A notebook on how to <a href="https://github.com/AnswerDotAI/ModernBERT/blob/main/examples/finetune_modernbert_on_glue.ipynb" rel="nofollow">finetune for General Language Understanding Evaluation (GLUE) with Transformers</a>, also available as a Google Colab <a href="https://colab.research.google.com/github/AnswerDotAI/ModernBERT/blob/main/examples/finetune_modernbert_on_glue.ipynb" rel="nofollow">notebook</a>. 🌎</li>',ve,I,Be,C,Me='<li>A script on how to <a href="https://github.com/AnswerDotAI/ModernBERT/blob/main/examples/train_st.py" rel="nofollow">finetune for text similarity or information retrieval with Sentence Transformers</a>. 🌎</li> <li>A script on how to <a href="https://github.com/AnswerDotAI/ModernBERT/blob/main/examples/train_pylate.py" rel="nofollow">finetune for information retrieval with PyLate</a>. 🌎</li>',Re,E,Le,ne,$e='<li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',Se,oe,U,J,se,be,Ce,Ae=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertModel">ModernBertModel</a>. It is used to instantiate an ModernBert
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ModernBERT-base.
e.g. <a href="https://huggingface.co/answerdotai/ModernBERT-base" rel="nofollow">answerdotai/ModernBERT-base</a>`,P,Te,re=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,He,W,Je,Z,xe,x,Y,ze,ae;return u=new Ee({props:{title:"ModernBERT",local:"modernbert",headingTag:"h1"}}),he=new Ee({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new Ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new dt({props:{pipeline:"text-classification"}}),I=new dt({props:{pipeline:"sentence-similarity"}}),E=new dt({props:{pipeline:"fill-mask"}}),oe=new Ee({props:{title:"ModernBertConfig",local:"transformers.ModernBertConfig",headingTag:"h2"}}),se=new je({props:{name:"class transformers.ModernBertConfig",anchor:"transformers.ModernBertConfig",parameters:[{name:"vocab_size",val:" = 50368"},{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 1152"},{name:"num_hidden_layers",val:" = 22"},{name:"num_attention_heads",val:" = 12"},{name:"hidden_activation",val:" = 'gelu'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_cutoff_factor",val:" = 2.0"},{name:"norm_eps",val:" = 1e-05"},{name:"norm_bias",val:" = False"},{name:"pad_token_id",val:" = 50283"},{name:"eos_token_id",val:" = 50282"},{name:"bos_token_id",val:" = 50281"},{name:"cls_token_id",val:" = 50281"},{name:"sep_token_id",val:" = 50282"},{name:"global_rope_theta",val:" = 160000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"global_attn_every_n_layers",val:" = 3"},{name:"local_attention",val:" = 128"},{name:"local_rope_theta",val:" = 10000.0"},{name:"embedding_dropout",val:" = 0.0"},{name:"mlp_bias",val:" = False"},{name:"mlp_dropout",val:" = 0.0"},{name:"decoder_bias",val:" = True"},{name:"classifier_pooling",val:": typing.Literal['cls', 'mean'] = 'cls'"},{name:"classifier_dropout",val:" = 0.0"},{name:"classifier_bias",val:" = False"},{name:"classifier_activation",val:" = 'gelu'"},{name:"deterministic_flash_attn",val:" = False"},{name:"sparse_prediction",val:" = False"},{name:"sparse_pred_ignore_index",val:" = -100"},{name:"reference_compile",val:" = None"},{name:"repad_logits_with_grad",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ModernBertConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50368) &#x2014;
Vocabulary size of the ModernBert model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/modernbert#transformers.ModernBertModel">ModernBertModel</a>`,name:"vocab_size"},{anchor:"transformers.ModernBertConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.ModernBertConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1152) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.ModernBertConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 22) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.ModernBertConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.ModernBertConfig.hidden_activation",description:`<strong>hidden_activation</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder. Will default to <code>&quot;gelu&quot;</code>
if not specified.`,name:"hidden_activation"},{anchor:"transformers.ModernBertConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.ModernBertConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ModernBertConfig.initializer_cutoff_factor",description:`<strong>initializer_cutoff_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The cutoff factor for the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_cutoff_factor"},{anchor:"transformers.ModernBertConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"norm_eps"},{anchor:"transformers.ModernBertConfig.norm_bias",description:`<strong>norm_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use bias in the normalization layers.`,name:"norm_bias"},{anchor:"transformers.ModernBertConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50283) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.ModernBertConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50282) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.ModernBertConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50281) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.ModernBertConfig.cls_token_id",description:`<strong>cls_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50281) &#x2014;
Classification token id.`,name:"cls_token_id"},{anchor:"transformers.ModernBertConfig.sep_token_id",description:`<strong>sep_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50282) &#x2014;
Separation token id.`,name:"sep_token_id"},{anchor:"transformers.ModernBertConfig.global_rope_theta",description:`<strong>global_rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 160000.0) &#x2014;
The base period of the global RoPE embeddings.`,name:"global_rope_theta"},{anchor:"transformers.ModernBertConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.ModernBertConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.ModernBertConfig.global_attn_every_n_layers",description:`<strong>global_attn_every_n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of layers between global attention layers.`,name:"global_attn_every_n_layers"},{anchor:"transformers.ModernBertConfig.local_attention",description:`<strong>local_attention</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The window size for local attention.`,name:"local_attention"},{anchor:"transformers.ModernBertConfig.local_rope_theta",description:`<strong>local_rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the local RoPE embeddings.`,name:"local_rope_theta"},{anchor:"transformers.ModernBertConfig.embedding_dropout",description:`<strong>embedding_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the embeddings.`,name:"embedding_dropout"},{anchor:"transformers.ModernBertConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use bias in the MLP layers.`,name:"mlp_bias"},{anchor:"transformers.ModernBertConfig.mlp_dropout",description:`<strong>mlp_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the MLP layers.`,name:"mlp_dropout"},{anchor:"transformers.ModernBertConfig.decoder_bias",description:`<strong>decoder_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the decoder layers.`,name:"decoder_bias"},{anchor:"transformers.ModernBertConfig.classifier_pooling",description:`<strong>classifier_pooling</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cls&quot;</code>) &#x2014;
The pooling method for the classifier. Should be either <code>&quot;cls&quot;</code> or <code>&quot;mean&quot;</code>. In local attention layers, the
CLS token doesn&#x2019;t attend to all tokens on long sequences.`,name:"classifier_pooling"},{anchor:"transformers.ModernBertConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the classifier.`,name:"classifier_dropout"},{anchor:"transformers.ModernBertConfig.classifier_bias",description:`<strong>classifier_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use bias in the classifier.`,name:"classifier_bias"},{anchor:"transformers.ModernBertConfig.classifier_activation",description:`<strong>classifier_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function for the classifier.`,name:"classifier_activation"},{anchor:"transformers.ModernBertConfig.deterministic_flash_attn",description:`<strong>deterministic_flash_attn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use deterministic flash attention. If <code>False</code>, inference will be faster but not deterministic.`,name:"deterministic_flash_attn"},{anchor:"transformers.ModernBertConfig.sparse_prediction",description:`<strong>sparse_prediction</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use sparse prediction for the masked language model instead of returning the full dense logits.`,name:"sparse_prediction"},{anchor:"transformers.ModernBertConfig.sparse_pred_ignore_index",description:`<strong>sparse_pred_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to -100) &#x2014;
The index to ignore for the sparse prediction.`,name:"sparse_pred_ignore_index"},{anchor:"transformers.ModernBertConfig.reference_compile",description:`<strong>reference_compile</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to compile the layers of the model which were compiled during pretraining. If <code>None</code>, then parts of
the model will be compiled if 1) <code>triton</code> is installed, 2) the model is not on MPS, 3) the model is not
shared between devices, and 4) the model is not resized after initialization. If <code>True</code>, then the model may
be faster in some scenarios.`,name:"reference_compile"},{anchor:"transformers.ModernBertConfig.repad_logits_with_grad",description:`<strong>repad_logits_with_grad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When True, ModernBertForMaskedLM keeps track of the logits&#x2019; gradient when repadding for output. This only
applies when using Flash Attention 2 with passed labels. Otherwise output logits always have a gradient.`,name:"repad_logits_with_grad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/modernbert/configuration_modernbert.py#L27"}}),W=new Oe({props:{anchor:"transformers.ModernBertConfig.example",$$slots:{default:[yt]},$$scope:{ctx:B}}}),Z=new Mt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Ut]},$$scope:{ctx:B}}}),x=new Tt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/modernbert.md"}}),{c(){t=m("meta"),h=l(),s=m("p"),a=l(),_(u.$$.fragment),n=l(),v=m("div"),v.innerHTML=Pe,O=l(),_(he.$$.fragment),Ue=l(),z=m("p"),z.innerHTML=ue,Fe=l(),R=m("p"),R.innerHTML=Ke,We=l(),q=m("p"),q.textContent=Ye,V=l(),H=m("ul"),H.innerHTML=ge,we=l(),$=m("p"),$.textContent=_e,qe=l(),G=m("p"),G.innerHTML=et,Ze=l(),N=m("p"),N.innerHTML=tt,Ie=l(),_(j.$$.fragment),X=l(),D=m("p"),D.textContent=ke,Ve=l(),_(K.$$.fragment),L=l(),ee=m("ul"),ee.innerHTML=te,ve=l(),_(I.$$.fragment),Be=l(),C=m("ul"),C.innerHTML=Me,Re=l(),_(E.$$.fragment),Le=l(),ne=m("ul"),ne.innerHTML=$e,Se=l(),_(oe.$$.fragment),U=l(),J=m("div"),_(se.$$.fragment),be=l(),Ce=m("p"),Ce.innerHTML=Ae,P=l(),Te=m("p"),Te.innerHTML=re,He=l(),_(W.$$.fragment),Je=l(),_(Z.$$.fragment),xe=l(),_(x.$$.fragment),Y=l(),ze=m("p"),this.h()},l(e){const c=_t("svelte-u9bgzb",document.head);t=p(c,"META",{name:!0,content:!0}),c.forEach(r),h=d(e),s=p(e,"P",{}),fe(s).forEach(r),a=d(e),M(u.$$.fragment,e),n=d(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),k(v)!=="svelte-b95w5j"&&(v.innerHTML=Pe),O=d(e),M(he.$$.fragment,e),Ue=d(e),z=p(e,"P",{"data-svelte-h":!0}),k(z)!=="svelte-196a0gl"&&(z.innerHTML=ue),Fe=d(e),R=p(e,"P",{"data-svelte-h":!0}),k(R)!=="svelte-sstubw"&&(R.innerHTML=Ke),We=d(e),q=p(e,"P",{"data-svelte-h":!0}),k(q)!=="svelte-stkoet"&&(q.textContent=Ye),V=d(e),H=p(e,"UL",{"data-svelte-h":!0}),k(H)!=="svelte-10lgxji"&&(H.innerHTML=ge),we=d(e),$=p(e,"P",{"data-svelte-h":!0}),k($)!=="svelte-vfdo9a"&&($.textContent=_e),qe=d(e),G=p(e,"P",{"data-svelte-h":!0}),k(G)!=="svelte-ue16ct"&&(G.innerHTML=et),Ze=d(e),N=p(e,"P",{"data-svelte-h":!0}),k(N)!=="svelte-u0fxon"&&(N.innerHTML=tt),Ie=d(e),M(j.$$.fragment,e),X=d(e),D=p(e,"P",{"data-svelte-h":!0}),k(D)!=="svelte-1lxsrev"&&(D.textContent=ke),Ve=d(e),M(K.$$.fragment,e),L=d(e),ee=p(e,"UL",{"data-svelte-h":!0}),k(ee)!=="svelte-86n4ls"&&(ee.innerHTML=te),ve=d(e),M(I.$$.fragment,e),Be=d(e),C=p(e,"UL",{"data-svelte-h":!0}),k(C)!=="svelte-tjcnnf"&&(C.innerHTML=Me),Re=d(e),M(E.$$.fragment,e),Le=d(e),ne=p(e,"UL",{"data-svelte-h":!0}),k(ne)!=="svelte-1uvyu41"&&(ne.innerHTML=$e),Se=d(e),M(oe.$$.fragment,e),U=d(e),J=p(e,"DIV",{class:!0});var F=fe(J);M(se.$$.fragment,F),be=d(F),Ce=p(F,"P",{"data-svelte-h":!0}),k(Ce)!=="svelte-byd2t8"&&(Ce.innerHTML=Ae),P=d(F),Te=p(F,"P",{"data-svelte-h":!0}),k(Te)!=="svelte-o55m63"&&(Te.innerHTML=re),He=d(F),M(W.$$.fragment,F),F.forEach(r),Je=d(e),M(Z.$$.fragment,e),xe=d(e),M(x.$$.fragment,e),Y=d(e),ze=p(e,"P",{}),fe(ze).forEach(r),this.h()},h(){Q(t,"name","hf:doc:metadata"),Q(t,"content",Wt),Q(v,"class","flex flex-wrap space-x-1"),Q(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){f(document.head,t),i(e,h,c),i(e,s,c),i(e,a,c),b(u,e,c),i(e,n,c),i(e,v,c),i(e,O,c),b(he,e,c),i(e,Ue,c),i(e,z,c),i(e,Fe,c),i(e,R,c),i(e,We,c),i(e,q,c),i(e,V,c),i(e,H,c),i(e,we,c),i(e,$,c),i(e,qe,c),i(e,G,c),i(e,Ze,c),i(e,N,c),i(e,Ie,c),b(j,e,c),i(e,X,c),i(e,D,c),i(e,Ve,c),b(K,e,c),i(e,L,c),i(e,ee,c),i(e,ve,c),b(I,e,c),i(e,Be,c),i(e,C,c),i(e,Re,c),b(E,e,c),i(e,Le,c),i(e,ne,c),i(e,Se,c),b(oe,e,c),i(e,U,c),i(e,J,c),b(se,J,null),f(J,be),f(J,Ce),f(J,P),f(J,Te),f(J,He),b(W,J,null),i(e,Je,c),b(Z,e,c),i(e,xe,c),b(x,e,c),i(e,Y,c),i(e,ze,c),ae=!0},p(e,[c]){const F={};c&2&&(F.$$scope={dirty:c,ctx:e}),W.$set(F);const nt={};c&2&&(nt.$$scope={dirty:c,ctx:e}),Z.$set(nt)},i(e){ae||(T(u.$$.fragment,e),T(he.$$.fragment,e),T(j.$$.fragment,e),T(K.$$.fragment,e),T(I.$$.fragment,e),T(E.$$.fragment,e),T(oe.$$.fragment,e),T(se.$$.fragment,e),T(W.$$.fragment,e),T(Z.$$.fragment,e),T(x.$$.fragment,e),ae=!0)},o(e){y(u.$$.fragment,e),y(he.$$.fragment,e),y(j.$$.fragment,e),y(K.$$.fragment,e),y(I.$$.fragment,e),y(E.$$.fragment,e),y(oe.$$.fragment,e),y(se.$$.fragment,e),y(W.$$.fragment,e),y(Z.$$.fragment,e),y(x.$$.fragment,e),ae=!1},d(e){e&&(r(h),r(s),r(a),r(n),r(v),r(O),r(Ue),r(z),r(Fe),r(R),r(We),r(q),r(V),r(H),r(we),r($),r(qe),r(G),r(Ze),r(N),r(Ie),r(X),r(D),r(Ve),r(L),r(ee),r(ve),r(Be),r(C),r(Re),r(Le),r(ne),r(Se),r(U),r(J),r(Je),r(xe),r(Y),r(ze)),r(t),w(u,e),w(he,e),w(j,e),w(K,e),w(I,e),w(E,e),w(oe,e),w(se),w(W),w(Z,e),w(x,e)}}}const Wt='{"title":"ModernBERT","local":"modernbert","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ModernBertConfig","local":"transformers.ModernBertConfig","sections":[],"depth":2},{"title":"ModernBertModel","local":"transformers.ModernBertModel","sections":[],"depth":2},{"title":"ModernBertForMaskedLM","local":"transformers.ModernBertForMaskedLM","sections":[],"depth":2},{"title":"ModernBertForSequenceClassification","local":"transformers.ModernBertForSequenceClassification","sections":[],"depth":2},{"title":"ModernBertForTokenClassification","local":"transformers.ModernBertForTokenClassification","sections":[],"depth":2}],"depth":1}';function qt(B){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends ut{constructor(t){super(),gt(this,t,qt,Ft,ft,{})}}export{Ht as component};
