import{s as ms,o as fs,n as ua}from"../chunks/scheduler.01eeda35.js";import{S as cs,i as ys,g as o,s as l,r as p,A as Ms,h as i,f as a,c as n,j as ps,u as d,x as r,k as ds,y as hs,a as s,v as m,d as f,t as c,w as y}from"../chunks/index.6dd51b66.js";import{T as ha}from"../chunks/Tip.de9bae2b.js";import{C as u}from"../chunks/CodeBlock.864da1b0.js";import{H as U,E as us}from"../chunks/EditOnGithub.7faefd25.js";function ws(J){let M,w="In practice, you probably won’t be able to load the entire dataset in memory. Load a chunk of the dataset at a time and convert it to <code>TFRecord</code>, and repeat until the entire dataset is in the <code>TFRecord</code> format. Then you can use a list of all the files to create a <code>TFRecordDataset</code>. The example below demonstrates a single file for simplicity.";return{c(){M=o("p"),M.innerHTML=w},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1njs9h7"&&(M.innerHTML=w)},m(h,T){s(h,M,T)},p:ua,d(h){h&&a(M)}}}function Ts(J){let M,w="We recommend avoiding TPU Nodes if possible because it is more difficult to debug than TPU VMs. TPU Nodes may also be unsupported in the future and become a legacy access method.";return{c(){M=o("p"),M.textContent=w},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-h8mx6j"&&(M.textContent=w)},m(h,T){s(h,M,T)},p:ua,d(h){h&&a(M)}}}function Us(J){let M,w="Execessive padding can also severely slow down training because requires more compute and memory to process.";return{c(){M=o("p"),M.textContent=w},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-aao7ck"&&(M.textContent=w)},m(h,T){s(h,M,T)},p:ua,d(h){h&&a(M)}}}function Js(J){let M,w,h,T,j,Ee,Z,wa='TPU (Tensor Processing Unit) is a type of hardware designed to accelerate tensor computations for training and inference. TPUs are generally accessed through Google cloud services, but smaller TPUs are also available for free from <a href="https://colab.research.google.com/notebooks/tpu.ipynb" rel="nofollow">Google Colab</a> or <a href="https://www.kaggle.com/docs/tpu" rel="nofollow">Kaggle</a>.',Le,I,Ta="This guide focuses on training a Keras model for sequence classification on a TPU from Google Colab. Make sure the TPU runtime is enabled by going to <strong>Runtime &gt; Change runtime type</strong> and selecting a TPU.",Ae,_,Ua='Run the command below to install the latest version of Transformers and <a href="https://huggingface.co/docs/datasets" rel="nofollow">Datasets</a>.',Pe,$,qe,G,Ja='Create an instance of <a href="https://www.tensorflow.org/api_docs/python/tf/distribute/cluster_resolver/TPUClusterResolver" rel="nofollow">tf.distribute.cluster_resolver.TPUClusterResolver</a>, and then connect to the remote cluster and initialize the TPUs.',Ke,R,De,k,ba='There are various distribution strategies for running your model on multiple TPUs. The <a href="https://www.tensorflow.org/api_docs/python/tf/distribute/TPUStrategy" rel="nofollow">tpu.distribute.TPUStrategy</a> offers synchronized distributed training.',Oe,X,et,v,ga='Load and tokenize a dataset - this example uses <a href="https://huggingface.co/datasets/nyu-mll/glue/viewer/cola" rel="nofollow">CoLA</a> from the GLUE benchmark - and pad all samples to the maximum length so it is easier to load as an array and to avoid <a href="#xla">XLA compilation issues</a>.',tt,V,at,F,Ca='The model <strong>must</strong> be created inside <a href="https://www.tensorflow.org/api_docs/python/tf/distribute/MirroredStrategy#scope" rel="nofollow">Strategy.scope</a> in order to replicate the model layers on each TPU device.',st,B,lt,W,ja='TPUs only accept <a href="https://www.tensorflow.org/api_docs/python/tf/data/Dataset" rel="nofollow">tf.data.Dataset</a> inputs unlike the Keras <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> method which accepts a broader range of inputs.',nt,Y,ot,Q,Za='Finally, call <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> to start training.',it,x,rt,H,pt,z,Ia='The dataset created above pads every sample to the maximum length and loads the whole dataset into memory. This may not be possible if you’re working with larger datasets. When training on large datasets, you may want to create a <a href="https://www.tensorflow.org/tutorials/load_data/tfrecord" rel="nofollow">tf.TFRecord</a> or stream the data.',dt,N,mt,S,_a='<a href="https://www.tensorflow.org/tutorials/load_data/tfrecord" rel="nofollow">tf.TFRecord</a> is the standard <a href="https://www.tensorflow.org/guide/data" rel="nofollow">tf.data</a> format for storing training data. For very large training jobs, it’s worth preprocessing your data and storing it in the <code>tf.TFRecord</code> format and building a <code>tf.data</code> pipeline on top. Refer to the table below to help you decide whether <code>tf.TFRecord</code> is helpful for you.',ft,E,$a="<thead><tr><th>pros</th> <th>cons</th></tr></thead> <tbody><tr><td>works on all TPU instances</td> <td>costs associated with cloud storage</td></tr> <tr><td>supports huge datasets and massive throughput</td> <td>some data types (images) can take a lot of space to store</td></tr> <tr><td>suitable for training on entire TPU pods</td> <td></td></tr> <tr><td>preprocessing is done in advance, maximizing training speed</td> <td></td></tr></tbody>",ct,L,Ga="Preprocess and tokenize the dataset before writing it to a <code>tf.TFRecord</code> to avoid writing every time the data is loaded.",yt,A,Ra="An exception is made for <em>train-time augmentations</em>, because augmentations applied after writing to a <code>tf.TFRecord</code> results in the same augmentation for each epoch. Instead, apply augmentations in the <code>tf.data</code> pipeline that loads the data.",Mt,b,ht,P,ut,q,ka='Build a <a href="https://www.tensorflow.org/api_docs/python/tf/data/TFRecordDataset" rel="nofollow">TFRecordDataset</a> using the saved filename to load it.',wt,K,Tt,D,Xa='The dataset can now be passed to the <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> method.',Ut,O,Jt,ee,bt,te,va='Data can be stored in its native format and preprocessed in a <a href="https://www.tensorflow.org/guide/data" rel="nofollow">tf.data</a> pipeline as the data is loaded. This approach isn’t supported for many models with complex tokenization schemes, but some models like BERT are supported because their tokenization can be compiled. Refer to the table below to help you decide whether this approach is helpful for you.',gt,ae,Va="<thead><tr><th>pros</th> <th>cons</th></tr></thead> <tbody><tr><td>suitable for highly compressed big data in native format (images, audio)</td> <td>requires writing a full preprocessing pipeline</td></tr> <tr><td>convenient if raw data is available in a public cloud bucket</td> <td>complex preprocessing on-the-fly can hurt throughput</td></tr> <tr><td>works on all TPU instances if data is stored in Google Cloud</td> <td>must place data in cloud storage if not already there</td></tr> <tr><td></td> <td>not as suitable for text data because writing a tokenization pipeline is hard (use <code>TFRecord</code> for text)</td></tr></tbody>",Ct,se,Fa="The example below demonstrates streaming data for an image model.",jt,le,Ba="Load an image dataset and get a list of the underlying image file paths and labels.",Zt,ne,It,oe,Wa="Convert the local filenames in the dataset into <code>gs://</code> paths in Google Cloud Storage.",_t,ie,$t,re,Ya='Transformers preprocessing classes like <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> are framework-agnostic and can’t be compiled into a pipeline by <code>tf.data</code>. To get around this, get the normalization values (<code>mean</code> and <code>std</code>) from the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and use them in the <code>tf.data</code> pipeline.',Gt,pe,Rt,de,Qa="Use these normalization values to create a function to load and preprocess the images.",kt,me,Xt,fe,xa='The dataset can now be passed to the <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> method.',vt,ce,Vt,ye,Ft,Me,Ha='<a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset">prepare_tf_dataset()</a> creates a <code>tf.data</code> pipeline that loads samples from <a href="https://www.tensorflow.org/api_docs/python/tf/data/Dataset" rel="nofollow">tf.data.Dataset</a>. The pipeline uses <a href="">tf.numpy_function</a> or <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.from_generator" rel="nofollow">from_generator</a>, which can’t be compiled by TensorFlow, to access the underlying <code>tf.data.Dataset</code>. It also won’t work on a Colab TPU or TPU Nodes because the pipeline streams data from a local disk. Refer to the table below to help you decide whether this approach is helpful for you.',Bt,he,za="<thead><tr><th>pros</th> <th>cons</th></tr></thead> <tbody><tr><td>simple code</td> <td>only works on TPU VM</td></tr> <tr><td>same approach on TPU/GPU</td> <td>data must be available as a Hugging Face Dataset</td></tr> <tr><td>dataset doesn’t have to fit in memory</td> <td>data must fit on local storage</td></tr> <tr><td>supports variable padding</td> <td>data loading may be a bottleneck on a big TPU pod slice</td></tr></tbody>",Wt,ue,Na='<a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset">prepare_tf_dataset()</a> only works on <a href="#tpu-types">TPU VM</a>. Add the tokenizer output as columns in the dataset since the dataset is stored on disk, which means it can handle data larger than the available memory. Use <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset">prepare_tf_dataset()</a> to stream data from the dataset by wrapping it with a <code>tf.data</code> pipeline.',Yt,we,Qt,Te,Sa='The dataset can now be passed to the <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> method.',xt,Ue,Ht,Je,zt,be,Ea="There are two types of TPUs, a TPU Node and a TPU VM.",Nt,ge,La="A TPU Node indirectly accesses a remote TPU. It requires a separate VM to initialize your network and data pipeline, and then forwards it to the remote node. Google Colab TPUs are an example of a TPU Node. You can’t use local data because the TPU is remotely located, and data must be stored in Google Cloud Storage where the data pipeline can access it.",St,Ce,Aa="TPU VM are connected directly to the machine the TPU is located on, and they are generally easier to work with, especially when it comes to your data pipeline.",Et,g,Lt,je,Pa="A single TPU (v2-8, v3-8, v4-8) runs 8 replicas. TPUs can exist in <strong>pods</strong> which run hundreds or even thousands of replicas simultaneously. When you only use a portion of a pod, it is referred to as a <strong>pod slice</strong>. On Google Colab, you’ll typically get a single v2-8 TPU.",At,Ze,Pt,Ie,qa='<a href="https://openxla.org/xla" rel="nofollow">XLA</a> is a linear algebra compiler for high-performance execution and it is used by default to improve performance on TPUs.',qt,_e,Ka='Before executing your code on a TPU, it’s a good idea to try it first on a CPU or GPU because it is easier to debug. You can train for a few steps to make sure the model and data pipeline work as expected. Set <code>jit_compile=True</code> in the <a href="https://keras.io/api/models/model_training_apis/#compile-method" rel="nofollow">compile</a> method to enable XLA compilation (but remember to remove this line of code before running on a TPU).',Kt,$e,Da="The section below outlines three rules for making your code XLA-compatible. Transformers enforce the first two rules for models and loss functions by default, but don’t forget about them if you’re writing your own models and loss functions.",Dt,Ge,Ot,Re,Oa='Any <code>if</code> statements cannot depend on values inside a <a href="https://www.tensorflow.org/api_docs/python/tf/Tensor" rel="nofollow">tf.Tensor</a>. The code below can’t be compiled by XLA.',ea,ke,ta,Xe,es='To compile with XLA, use <a href="https://www.tensorflow.org/api_docs/python/tf/cond" rel="nofollow">tf.cond</a> or remove the conditional and use indicator variables instead as shown below.',aa,ve,sa,Ve,la,Fe,ts='The shape of a <a href="https://www.tensorflow.org/api_docs/python/tf/Tensor" rel="nofollow">tf.Tensor</a> cannot depend on their values. For example, <a href="https://www.tensorflow.org/api_docs/python/tf/unique" rel="nofollow">tf.unique</a> can’t be compiled because it returns a tensor containing an instance of each unique value in the input. The shape of this output depends on how repetitive the input <a href="https://www.tensorflow.org/api_docs/python/tf/Tensor" rel="nofollow">tf.Tensor</a> is.',na,Be,as="This is an issue during <strong>label masking</strong>, where labels are set to a negative value to indicate they should be ignored when computing the loss. The code below can’t be compiled by XLA because the shape of <code>masked_outputs</code> and <code>masked_labels</code> depend on how many positions are masked.",oa,We,ia,Ye,ss="To compile with XLA, avoid the data-dependent shapes by computing the loss for every position and zeroing out the masked positions in both the numerator and denominator when calculating the mean. Convert <code>tf.bool</code> to <code>tf.float32</code> as an indicator variable to make your code XLA-compatible.",ra,Qe,pa,xe,da,He,ls="XLA recompiles your model if input shapes are variable which create huge performance problems. It is especially common in text models because input texts have variable lengths after tokenization.",ma,C,fa,ze,ns="To avoid different shapes, use padding to pad all your inputs to the same length and use an <code>attention_mask</code>. Try padding batches of samples to a multiple of 32 or 64 tokens. Use the parameters <code>padding=&quot;max_length&quot;</code>, <code>padding=&quot;longest&quot;</code>, or <code>pad_to_multiple_of</code> to help with padding. This often increases the number of tokens by a small amount, but it significantly reduces the number of unique input shapes because every input shape is a multiple of 32 or 64. Fewer unique input shapes requires fewer recompilation.",ca,Ne,ya,Se,Ma;return j=new U({props:{title:"TPU",local:"tpu",headingTag:"h1"}}),$=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLVUlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cw==",highlighted:"!pip install --U transformers datasets",wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFyZXNvbHZlciUyMCUzRCUyMHRmLmRpc3RyaWJ1dGUuY2x1c3Rlcl9yZXNvbHZlci5UUFVDbHVzdGVyUmVzb2x2ZXIoKSUwQXRmLmNvbmZpZy5leHBlcmltZW50YWxfY29ubmVjdF90b19jbHVzdGVyKHJlc29sdmVyKSUwQXRmLnRwdS5leHBlcmltZW50YWwuaW5pdGlhbGl6ZV90cHVfc3lzdGVtKHJlc29sdmVyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

resolver = tf.distribute.cluster_resolver.TPUClusterResolver()
tf.config.experimental_connect_to_cluster(resolver)
tf.tpu.experimental.initialize_tpu_system(resolver)`,wrap:!1}}),X=new u({props:{code:"c3RyYXRlZ3klMjAlM0QlMjB0Zi5kaXN0cmlidXRlLlRQVVN0cmF0ZWd5KHJlc29sdmVyKQ==",highlighted:"strategy = tf.distribute.TPUStrategy(resolver)",wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdsdWUlMjIlMkMlMjAlMjJjb2xhJTIyKSU1QiUyMnRyYWluJTIyJTVEJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQXRyYWluX2RhdGElMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0QxMjglMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyJTJDJTBBKSUwQXRyYWluX2RhdGElMjAlM0QlMjBkaWN0KHRyYWluX2RhdGEpJTBBdHJhaW5fbGFiZWxzJTIwJTNEJTIwbnAuYXJyYXkoZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dataset = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;cola&quot;</span>)[<span class="hljs-string">&quot;train&quot;</span>]
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-cased&quot;</span>)

train_data = tokenizer(
    dataset[<span class="hljs-string">&quot;sentence&quot;</span>],
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    truncation=<span class="hljs-literal">True</span>,
    max_length=<span class="hljs-number">128</span>,
    return_tensors=<span class="hljs-string">&quot;np&quot;</span>,
)
train_data = <span class="hljs-built_in">dict</span>(train_data)
train_labels = np.array(dataset[<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),B=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXdpdGglMjBzdHJhdGVneS5zY29wZSgpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTIwJTIwJTIwJTIwbW9kZWwuY29tcGlsZShvcHRpbWl6ZXIlM0QlMjJhZGFtJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-keyword">with</span> strategy.scope():
    model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint)
    model.<span class="hljs-built_in">compile</span>(optimizer=<span class="hljs-string">&quot;adam&quot;</span>)`,wrap:!1}}),Y=new u({props:{code:"QkFUQ0hfU0laRSUyMCUzRCUyMDglMjAqJTIwc3RyYXRlZ3kubnVtX3JlcGxpY2FzX2luX3N5bmMlMEElMEF0Zl9kYXRhc2V0JTIwJTNEJTIwdGYuZGF0YS5EYXRhc2V0LmZyb21fdGVuc29yX3NsaWNlcygodHJhaW5fZGF0YSUyQyUyMHRyYWluX2xhYmVscykpJTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmX2RhdGFzZXQuc2h1ZmZsZShsZW4odGZfZGF0YXNldCkpJTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmX2RhdGFzZXQuYmF0Y2goQkFUQ0hfU0laRSUyQyUyMGRyb3BfcmVtYWluZGVyJTNEVHJ1ZSk=",highlighted:`BATCH_SIZE = <span class="hljs-number">8</span> * strategy.num_replicas_in_sync

tf_dataset = tf.data.Dataset.from_tensor_slices((train_data, train_labels))
tf_dataset = tf_dataset.shuffle(<span class="hljs-built_in">len</span>(tf_dataset))
tf_dataset = tf_dataset.batch(BATCH_SIZE, drop_remainder=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new u({props:{code:"bW9kZWwuZml0KHRmX2RhdGFzZXQp",highlighted:"model.fit(tf_dataset)",wrap:!1}}),H=new U({props:{title:"Large datasets",local:"large-datasets",headingTag:"h2"}}),N=new U({props:{title:"tf.TFRecord",local:"tftfrecord",headingTag:"h3"}}),b=new ha({props:{warning:!1,$$slots:{default:[ws]},$$scope:{ctx:J}}}),P=new u({props:{code:"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",highlighted:`tokenized_data = tokenizer(
    dataset[<span class="hljs-string">&quot;sentence&quot;</span>],
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    truncation=<span class="hljs-literal">True</span>,
    max_length=<span class="hljs-number">128</span>,
    return_tensors=<span class="hljs-string">&quot;np&quot;</span>,
)
labels = dataset[<span class="hljs-string">&quot;label&quot;</span>]

<span class="hljs-keyword">with</span> tf.io.TFRecordWriter(<span class="hljs-string">&quot;dataset.tfrecords&quot;</span>) <span class="hljs-keyword">as</span> file_writer:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(labels)):
        features = {
            <span class="hljs-string">&quot;input_ids&quot;</span>: tf.train.Feature(
                int64_list=tf.train.Int64List(value=tokenized_data[<span class="hljs-string">&quot;input_ids&quot;</span>][i])
            ),
            <span class="hljs-string">&quot;attention_mask&quot;</span>: tf.train.Feature(
                int64_list=tf.train.Int64List(value=tokenized_data[<span class="hljs-string">&quot;attention_mask&quot;</span>][i])
            ),
            <span class="hljs-string">&quot;labels&quot;</span>: tf.train.Feature(
                int64_list=tf.train.Int64List(value=[labels[i]])
            ),
        }
        features = tf.train.Features(feature=features)
        example = tf.train.Example(features=features)
        record_bytes = example.SerializeToString()
        file_writer.write(record_bytes)`,wrap:!1}}),K=new u({props:{code:"ZGVmJTIwZGVjb2RlX2ZuKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2lkcyUyMiUzQSUyMHRmLmlvLkZpeGVkTGVuRmVhdHVyZSgoMTI4JTJDKSUyQyUyMGR0eXBlJTNEdGYuaW50NjQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlM0ElMjB0Zi5pby5GaXhlZExlbkZlYXR1cmUoKDEyOCUyQyklMkMlMjBkdHlwZSUzRHRmLmludDY0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhYmVscyUyMiUzQSUyMHRmLmlvLkZpeGVkTGVuRmVhdHVyZSgoMSUyQyklMkMlMjBkdHlwZSUzRHRmLmludDY0KSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRmLmlvLnBhcnNlX2V4YW1wbGUoc2FtcGxlJTJDJTIwZmVhdHVyZXMpJTBBJTBBJTIzJTIwVEZSZWNvcmREYXRhc2V0JTIwY2FuJTIwaGFuZGxlJTIwZ3MlM0ElMkYlMkYlMjBwYXRocyUwQXRmX2RhdGFzZXQlMjAlM0QlMjB0Zi5kYXRhLlRGUmVjb3JkRGF0YXNldCglNUIlMjJncyUzQSUyRiUyRm1hdHQtdGYtdHB1LXR1dG9yaWFsLWRhdGFzZXRzJTJGY29sYSUyRmRhdGFzZXQudGZyZWNvcmRzJTIyJTVEKSUwQXRmX2RhdGFzZXQlMjAlM0QlMjB0Zl9kYXRhc2V0Lm1hcChkZWNvZGVfZm4pJTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmX2RhdGFzZXQuc2h1ZmZsZShsZW4oZGF0YXNldCkpLmJhdGNoKEJBVENIX1NJWkUlMkMlMjBkcm9wX3JlbWFpbmRlciUzRFRydWUpJTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmX2RhdGFzZXQuYXBwbHkoJTBBJTIwJTIwJTIwJTIwdGYuZGF0YS5leHBlcmltZW50YWwuYXNzZXJ0X2NhcmRpbmFsaXR5KGxlbihsYWJlbHMpJTIwJTJGJTJGJTIwQkFUQ0hfU0laRSklMEEp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_fn</span>(<span class="hljs-params">sample</span>):
    features = {
        <span class="hljs-string">&quot;input_ids&quot;</span>: tf.io.FixedLenFeature((<span class="hljs-number">128</span>,), dtype=tf.int64),
        <span class="hljs-string">&quot;attention_mask&quot;</span>: tf.io.FixedLenFeature((<span class="hljs-number">128</span>,), dtype=tf.int64),
        <span class="hljs-string">&quot;labels&quot;</span>: tf.io.FixedLenFeature((<span class="hljs-number">1</span>,), dtype=tf.int64),
    }
    <span class="hljs-keyword">return</span> tf.io.parse_example(sample, features)

<span class="hljs-comment"># TFRecordDataset can handle gs:// paths</span>
tf_dataset = tf.data.TFRecordDataset([<span class="hljs-string">&quot;gs://matt-tf-tpu-tutorial-datasets/cola/dataset.tfrecords&quot;</span>])
tf_dataset = tf_dataset.<span class="hljs-built_in">map</span>(decode_fn)
tf_dataset = tf_dataset.shuffle(<span class="hljs-built_in">len</span>(dataset)).batch(BATCH_SIZE, drop_remainder=<span class="hljs-literal">True</span>)
tf_dataset = tf_dataset.apply(
    tf.data.experimental.assert_cardinality(<span class="hljs-built_in">len</span>(labels) // BATCH_SIZE)
)`,wrap:!1}}),O=new u({props:{code:"bW9kZWwuZml0KHRmX2RhdGFzZXQp",highlighted:"model.fit(tf_dataset)",wrap:!1}}),ee=new U({props:{title:"Stream from raw data",local:"stream-from-raw-data",headingTag:"h3"}}),ne=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiZWFucyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZmlsZW5hbWVzJTIwJTNEJTIwaW1hZ2VfZGF0YXNldCU1QiUyMmltYWdlX2ZpbGVfcGF0aCUyMiU1RCUwQWxhYmVscyUyMCUzRCUyMGltYWdlX2RhdGFzZXQlNUIlMjJsYWJlbHMlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

image_dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
filenames = image_dataset[<span class="hljs-string">&quot;image_file_path&quot;</span>]
labels = image_dataset[<span class="hljs-string">&quot;labels&quot;</span>]`,wrap:!1}}),ie=new u({props:{code:"JTIzJTIwc3RyaXAlMjBldmVyeXRoaW5nJTIwYnV0JTIwdGhlJTIwY2F0ZWdvcnklMjBkaXJlY3RvcnklMjBhbmQlMjBmaWxlbmFtZXMlMEFiYXNlX2ZpbGVuYW1lcyUyMCUzRCUyMCU1QiclMkYnLmpvaW4oZmlsZW5hbWUuc3BsaXQoJyUyRicpJTVCLTIlM0ElNUQpJTIwZm9yJTIwZmlsZW5hbWUlMjBpbiUyMGZpbGVuYW1lcyU1RCUwQSUyMyUyMHByZXBlbmQlMjB0aGUlMjBHb29nbGUlMjBDbG91ZCUyMGJhc2UlMjBwYXRoJTIwdG8lMjBldmVyeXRoaW5nJTIwaW5zdGVhZCUwQWdzX3BhdGhzJTIwJTNEJTIwJTVCJTIyZ3MlM0ElMkYlMkZtYXR0LXRmLXRwdS10dXRvcmlhbC1kYXRhc2V0cyUyRmJlYW5zJTJGJTIyJTJCZmlsZW5hbWUlMjBmb3IlMjBmaWxlbmFtZSUyMGluJTIwYmFzZV9maWxlbmFtZXMlNUQlMEElMEElMjMlMjBjcmVhdGUlMjB0Zl9kYXRhc2V0JTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmLmRhdGEuRGF0YXNldC5mcm9tX3RlbnNvcl9zbGljZXMoJTBBJTIwJTIwJTIwJTIwJTdCJTIyZmlsZW5hbWUlMjIlM0ElMjBnc19wYXRocyUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMGxhYmVscyU3RCUwQSklMEF0Zl9kYXRhc2V0JTIwJTNEJTIwdGZfZGF0YXNldC5zaHVmZmxlKGxlbih0Zl9kYXRhc2V0KSk=",highlighted:`<span class="hljs-comment"># strip everything but the category directory and filenames</span>
base_filenames = [<span class="hljs-string">&#x27;/&#x27;</span>.join(filename.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">2</span>:]) <span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> filenames]
<span class="hljs-comment"># prepend the Google Cloud base path to everything instead</span>
gs_paths = [<span class="hljs-string">&quot;gs://matt-tf-tpu-tutorial-datasets/beans/&quot;</span>+filename <span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> base_filenames]

<span class="hljs-comment"># create tf_dataset</span>
tf_dataset = tf.data.Dataset.from_tensor_slices(
    {<span class="hljs-string">&quot;filename&quot;</span>: gs_paths, <span class="hljs-string">&quot;labels&quot;</span>: labels}
)
tf_dataset = tf_dataset.shuffle(<span class="hljs-built_in">len</span>(tf_dataset))`,wrap:!1}}),pe=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBaW1hZ2Vfc2l6ZSUyMCUzRCUyMChwcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUyQyUyMHByb2Nlc3Nvci5zaXplJTVCJTIyd2lkdGglMjIlNUQpJTBBaW1hZ2VfbWVhbiUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9tZWFuJTBBaW1hZ2Vfc3RkJTIwJTNEJTIwcHJvY2Vzc29yLmltYWdlX3N0ZA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
image_size = (processor.size[<span class="hljs-string">&quot;height&quot;</span>], processor.size[<span class="hljs-string">&quot;width&quot;</span>])
image_mean = processor.image_mean
image_std = processor.image_std`,wrap:!1}}),me=new u({props:{code:"QkFUQ0hfU0laRSUyMCUzRCUyMDglMjAqJTIwc3RyYXRlZ3kubnVtX3JlcGxpY2FzX2luX3N5bmMlMEElMEFkZWYlMjBkZWNvZGVfZm4oc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX2RhdGElMjAlM0QlMjB0Zi5pby5yZWFkX2ZpbGUoc2FtcGxlJTVCJTIyZmlsZW5hbWUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0Zi5pby5kZWNvZGVfanBlZyhpbWFnZV9kYXRhJTJDJTIwY2hhbm5lbHMlM0QzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYuaW1hZ2UucmVzaXplKGltYWdlJTJDJTIwaW1hZ2Vfc2l6ZSklMEElMjAlMjAlMjAlMjBhcnJheSUyMCUzRCUyMHRmLmNhc3QoaW1hZ2UlMkMlMjB0Zi5mbG9hdDMyKSUwQSUyMCUyMCUyMCUyMGFycmF5JTIwJTJGJTNEJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBhcnJheSUyMCUzRCUyMChhcnJheSUyMC0lMjBpbWFnZV9tZWFuKSUyMCUyRiUyMGltYWdlX3N0ZCUwQSUyMCUyMCUyMCUyMGFycmF5JTIwJTNEJTIwdGYudHJhbnNwb3NlKGFycmF5JTJDJTIwcGVybSUzRCU1QjIlMkMlMjAwJTJDJTIwMSU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJwaXhlbF92YWx1ZXMlMjIlM0ElMjBhcnJheSUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMHNhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCU3RCUwQSUwQXRmX2RhdGFzZXQlMjAlM0QlMjB0Zl9kYXRhc2V0Lm1hcChkZWNvZGVfZm4pJTBBdGZfZGF0YXNldCUyMCUzRCUyMHRmX2RhdGFzZXQuYmF0Y2goQkFUQ0hfU0laRSUyQyUyMGRyb3BfcmVtYWluZGVyJTNEVHJ1ZSklMEFwcmludCh0Zl9kYXRhc2V0LmVsZW1lbnRfc3BlYyk=",highlighted:`BATCH_SIZE = <span class="hljs-number">8</span> * strategy.num_replicas_in_sync

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_fn</span>(<span class="hljs-params">sample</span>):
    image_data = tf.io.read_file(sample[<span class="hljs-string">&quot;filename&quot;</span>])
    image = tf.io.decode_jpeg(image_data, channels=<span class="hljs-number">3</span>)
    image = tf.image.resize(image, image_size)
    array = tf.cast(image, tf.float32)
    array /= <span class="hljs-number">255.0</span>
    array = (array - image_mean) / image_std
    array = tf.transpose(array, perm=[<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: array, <span class="hljs-string">&quot;labels&quot;</span>: sample[<span class="hljs-string">&quot;labels&quot;</span>]}

tf_dataset = tf_dataset.<span class="hljs-built_in">map</span>(decode_fn)
tf_dataset = tf_dataset.batch(BATCH_SIZE, drop_remainder=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(tf_dataset.element_spec)`,wrap:!1}}),ce=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXdpdGglMjBzdHJhdGVneS5zY29wZSgpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGltYWdlX21vZGVsX2NoZWNrcG9pbnQpJTBBJTIwJTIwJTIwJTIwbW9kZWwuY29tcGlsZShvcHRpbWl6ZXIlM0QlMjJhZGFtJTIyKSUwQSUwQW1vZGVsLmZpdCh0Zl9kYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForImageClassification

<span class="hljs-keyword">with</span> strategy.scope():
    model = TFAutoModelForImageClassification.from_pretrained(image_model_checkpoint)
    model.<span class="hljs-built_in">compile</span>(optimizer=<span class="hljs-string">&quot;adam&quot;</span>)

model.fit(tf_dataset)`,wrap:!1}}),ye=new U({props:{title:"Stream with prepare_tf_dataset",local:"stream-with-preparetfdataset",headingTag:"h3"}}),we=new u({props:{code:"ZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyc2VudGVuY2UlMjIlNUQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwbWF4X2xlbmd0aCUzRDEyOCUwQSUyMCUyMCUyMCUyMCklMEElMjMlMjBhZGQlMjB0aGUlMjB0b2tlbml6ZXIlMjBvdXRwdXQlMjB0byUyMHRoZSUyMGRhdGFzZXQlMjBhcyUyMG5ldyUyMGNvbHVtbnMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24pJTBBJTBBJTIzJTIwcHJlcGFyZV90Zl9kYXRhc2V0KCklMjBjaG9vc2VzJTIwY29sdW1ucyUyMHRoYXQlMjBtYXRjaCUyMHRoZSUyMG1vZGVscyUyMGlucHV0JTIwbmFtZXMlMEF0Zl9kYXRhc2V0JTIwJTNEJTIwbW9kZWwucHJlcGFyZV90Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEQkFUQ0hfU0laRSUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTBBKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(
        examples[<span class="hljs-string">&quot;sentence&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">128</span>
    )
<span class="hljs-comment"># add the tokenizer output to the dataset as new columns</span>
dataset = dataset.<span class="hljs-built_in">map</span>(tokenize_function)

<span class="hljs-comment"># prepare_tf_dataset() chooses columns that match the models input names</span>
tf_dataset = model.prepare_tf_dataset(
    dataset, batch_size=BATCH_SIZE, shuffle=<span class="hljs-literal">True</span>, tokenizer=tokenizer
)`,wrap:!1}}),Ue=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF3aXRoJTIwc3RyYXRlZ3kuc2NvcGUoKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQSUyMCUyMCUyMCUyMG1vZGVsLmNvbXBpbGUob3B0aW1pemVyJTNEJTIyYWRhbSUyMiklMEElMEFtb2RlbC5maXQodGZfZGF0YXNldCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForSequenceClassification

<span class="hljs-keyword">with</span> strategy.scope():
    model = TFAutoModelForSequenceClassification.from_pretrained(model_checkpoint)
    model.<span class="hljs-built_in">compile</span>(optimizer=<span class="hljs-string">&quot;adam&quot;</span>)

model.fit(tf_dataset)`,wrap:!1}}),Je=new U({props:{title:"TPU types",local:"tpu-types",headingTag:"h2"}}),g=new ha({props:{warning:!1,$$slots:{default:[Ts]},$$scope:{ctx:J}}}),Ze=new U({props:{title:"XLA",local:"xla",headingTag:"h2"}}),Ge=new U({props:{title:"Data dependent conditionals",local:"data-dependent-conditionals",headingTag:"h3"}}),ke=new u({props:{code:"aWYlMjB0Zi5yZWR1Y2Vfc3VtKHRlbnNvciklMjAlM0UlMjAxMCUzQSUwQSUyMCUyMCUyMCUyMHRlbnNvciUyMCUzRCUyMHRlbnNvciUyMCUyRiUyMDIuMA==",highlighted:`<span class="hljs-keyword">if</span> tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>:
    tensor = tensor / <span class="hljs-number">2.0</span>`,wrap:!1}}),ve=new u({props:{code:"c3VtX292ZXJfMTAlMjAlM0QlMjB0Zi5jYXN0KHRmLnJlZHVjZV9zdW0odGVuc29yKSUyMCUzRSUyMDEwJTJDJTIwdGYuZmxvYXQzMiklMEF0ZW5zb3IlMjAlM0QlMjB0ZW5zb3IlMjAlMkYlMjAoMS4wJTIwJTJCJTIwc3VtX292ZXJfMTAp",highlighted:`sum_over_10 = tf.cast(tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>, tf.float32)
tensor = tensor / (<span class="hljs-number">1.0</span> + sum_over_10)`,wrap:!1}}),Ve=new U({props:{title:"Data dependent shapes",local:"data-dependent-shapes",headingTag:"h3"}}),We=new u({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMGxhYmVscyUyMCUzRSUzRCUyMDAlMEFtYXNrZWRfb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUJsYWJlbF9tYXNrJTVEJTBBbWFza2VkX2xhYmVscyUyMCUzRCUyMGxhYmVscyU1QmxhYmVsX21hc2slNUQlMEFsb3NzJTIwJTNEJTIwY29tcHV0ZV9sb3NzKG1hc2tlZF9vdXRwdXRzJTJDJTIwbWFza2VkX2xhYmVscyklMEFtZWFuX2xvc3MlMjAlM0QlMjB0b3JjaC5tZWFuKGxvc3Mp",highlighted:`label_mask = labels &gt;= <span class="hljs-number">0</span>
masked_outputs = outputs[label_mask]
masked_labels = labels[label_mask]
loss = compute_loss(masked_outputs, masked_labels)
mean_loss = torch.mean(loss)`,wrap:!1}}),Qe=new u({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMHRmLmNhc3QobGFiZWxzJTIwJTNFJTNEJTIwMCUyQyUyMHRmLmZsb2F0MzIpJTBBbG9zcyUyMCUzRCUyMGNvbXB1dGVfbG9zcyhvdXRwdXRzJTJDJTIwbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBsb3NzJTIwKiUyMGxhYmVsX21hc2slMEFtZWFuX2xvc3MlMjAlM0QlMjB0Zi5yZWR1Y2Vfc3VtKGxvc3MpJTIwJTJGJTIwdGYucmVkdWNlX3N1bShsYWJlbF9tYXNrKQ==",highlighted:`label_mask = tf.cast(labels &gt;= <span class="hljs-number">0</span>, tf.float32)
loss = compute_loss(outputs, labels)
loss = loss * label_mask
mean_loss = tf.reduce_sum(loss) / tf.reduce_sum(label_mask)`,wrap:!1}}),xe=new U({props:{title:"Recompile different input shapes",local:"recompile-different-input-shapes",headingTag:"h3"}}),C=new ha({props:{warning:!0,$$slots:{default:[Us]},$$scope:{ctx:J}}}),Ne=new us({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_train_tpu_tf.md"}}),{c(){M=o("meta"),w=l(),h=o("p"),T=l(),p(j.$$.fragment),Ee=l(),Z=o("p"),Z.innerHTML=wa,Le=l(),I=o("p"),I.innerHTML=Ta,Ae=l(),_=o("p"),_.innerHTML=Ua,Pe=l(),p($.$$.fragment),qe=l(),G=o("p"),G.innerHTML=Ja,Ke=l(),p(R.$$.fragment),De=l(),k=o("p"),k.innerHTML=ba,Oe=l(),p(X.$$.fragment),et=l(),v=o("p"),v.innerHTML=ga,tt=l(),p(V.$$.fragment),at=l(),F=o("p"),F.innerHTML=Ca,st=l(),p(B.$$.fragment),lt=l(),W=o("p"),W.innerHTML=ja,nt=l(),p(Y.$$.fragment),ot=l(),Q=o("p"),Q.innerHTML=Za,it=l(),p(x.$$.fragment),rt=l(),p(H.$$.fragment),pt=l(),z=o("p"),z.innerHTML=Ia,dt=l(),p(N.$$.fragment),mt=l(),S=o("p"),S.innerHTML=_a,ft=l(),E=o("table"),E.innerHTML=$a,ct=l(),L=o("p"),L.innerHTML=Ga,yt=l(),A=o("p"),A.innerHTML=Ra,Mt=l(),p(b.$$.fragment),ht=l(),p(P.$$.fragment),ut=l(),q=o("p"),q.innerHTML=ka,wt=l(),p(K.$$.fragment),Tt=l(),D=o("p"),D.innerHTML=Xa,Ut=l(),p(O.$$.fragment),Jt=l(),p(ee.$$.fragment),bt=l(),te=o("p"),te.innerHTML=va,gt=l(),ae=o("table"),ae.innerHTML=Va,Ct=l(),se=o("p"),se.textContent=Fa,jt=l(),le=o("p"),le.textContent=Ba,Zt=l(),p(ne.$$.fragment),It=l(),oe=o("p"),oe.innerHTML=Wa,_t=l(),p(ie.$$.fragment),$t=l(),re=o("p"),re.innerHTML=Ya,Gt=l(),p(pe.$$.fragment),Rt=l(),de=o("p"),de.textContent=Qa,kt=l(),p(me.$$.fragment),Xt=l(),fe=o("p"),fe.innerHTML=xa,vt=l(),p(ce.$$.fragment),Vt=l(),p(ye.$$.fragment),Ft=l(),Me=o("p"),Me.innerHTML=Ha,Bt=l(),he=o("table"),he.innerHTML=za,Wt=l(),ue=o("p"),ue.innerHTML=Na,Yt=l(),p(we.$$.fragment),Qt=l(),Te=o("p"),Te.innerHTML=Sa,xt=l(),p(Ue.$$.fragment),Ht=l(),p(Je.$$.fragment),zt=l(),be=o("p"),be.textContent=Ea,Nt=l(),ge=o("p"),ge.textContent=La,St=l(),Ce=o("p"),Ce.textContent=Aa,Et=l(),p(g.$$.fragment),Lt=l(),je=o("p"),je.innerHTML=Pa,At=l(),p(Ze.$$.fragment),Pt=l(),Ie=o("p"),Ie.innerHTML=qa,qt=l(),_e=o("p"),_e.innerHTML=Ka,Kt=l(),$e=o("p"),$e.textContent=Da,Dt=l(),p(Ge.$$.fragment),Ot=l(),Re=o("p"),Re.innerHTML=Oa,ea=l(),p(ke.$$.fragment),ta=l(),Xe=o("p"),Xe.innerHTML=es,aa=l(),p(ve.$$.fragment),sa=l(),p(Ve.$$.fragment),la=l(),Fe=o("p"),Fe.innerHTML=ts,na=l(),Be=o("p"),Be.innerHTML=as,oa=l(),p(We.$$.fragment),ia=l(),Ye=o("p"),Ye.innerHTML=ss,ra=l(),p(Qe.$$.fragment),pa=l(),p(xe.$$.fragment),da=l(),He=o("p"),He.textContent=ls,ma=l(),p(C.$$.fragment),fa=l(),ze=o("p"),ze.innerHTML=ns,ca=l(),p(Ne.$$.fragment),ya=l(),Se=o("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),h=i(e,"P",{}),ps(h).forEach(a),T=n(e),d(j.$$.fragment,e),Ee=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-wejst4"&&(Z.innerHTML=wa),Le=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-26fyhs"&&(I.innerHTML=Ta),Ae=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ggbuxf"&&(_.innerHTML=Ua),Pe=n(e),d($.$$.fragment,e),qe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-2kj0ub"&&(G.innerHTML=Ja),Ke=n(e),d(R.$$.fragment,e),De=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-i4fn8y"&&(k.innerHTML=ba),Oe=n(e),d(X.$$.fragment,e),et=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ntv7za"&&(v.innerHTML=ga),tt=n(e),d(V.$$.fragment,e),at=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-6ywacu"&&(F.innerHTML=Ca),st=n(e),d(B.$$.fragment,e),lt=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-wfm0b8"&&(W.innerHTML=ja),nt=n(e),d(Y.$$.fragment,e),ot=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1nrwj5f"&&(Q.innerHTML=Za),it=n(e),d(x.$$.fragment,e),rt=n(e),d(H.$$.fragment,e),pt=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1rmkxi1"&&(z.innerHTML=Ia),dt=n(e),d(N.$$.fragment,e),mt=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1thxjgi"&&(S.innerHTML=_a),ft=n(e),E=i(e,"TABLE",{"data-svelte-h":!0}),r(E)!=="svelte-1bjnyhm"&&(E.innerHTML=$a),ct=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1pkbze1"&&(L.innerHTML=Ga),yt=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1yh9lje"&&(A.innerHTML=Ra),Mt=n(e),d(b.$$.fragment,e),ht=n(e),d(P.$$.fragment,e),ut=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1kezdht"&&(q.innerHTML=ka),wt=n(e),d(K.$$.fragment,e),Tt=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1s9k8gm"&&(D.innerHTML=Xa),Ut=n(e),d(O.$$.fragment,e),Jt=n(e),d(ee.$$.fragment,e),bt=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-19b2fim"&&(te.innerHTML=va),gt=n(e),ae=i(e,"TABLE",{"data-svelte-h":!0}),r(ae)!=="svelte-eplesd"&&(ae.innerHTML=Va),Ct=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1yanrvl"&&(se.textContent=Fa),jt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1p9l68o"&&(le.textContent=Ba),Zt=n(e),d(ne.$$.fragment,e),It=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-2il5q0"&&(oe.innerHTML=Wa),_t=n(e),d(ie.$$.fragment,e),$t=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ipfgnx"&&(re.innerHTML=Ya),Gt=n(e),d(pe.$$.fragment,e),Rt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-xhmqey"&&(de.textContent=Qa),kt=n(e),d(me.$$.fragment,e),Xt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1s9k8gm"&&(fe.innerHTML=xa),vt=n(e),d(ce.$$.fragment,e),Vt=n(e),d(ye.$$.fragment,e),Ft=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-9cv2g6"&&(Me.innerHTML=Ha),Bt=n(e),he=i(e,"TABLE",{"data-svelte-h":!0}),r(he)!=="svelte-1la2fd5"&&(he.innerHTML=za),Wt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-hg53xl"&&(ue.innerHTML=Na),Yt=n(e),d(we.$$.fragment,e),Qt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1s9k8gm"&&(Te.innerHTML=Sa),xt=n(e),d(Ue.$$.fragment,e),Ht=n(e),d(Je.$$.fragment,e),zt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1xpcsyo"&&(be.textContent=Ea),Nt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1bu3p95"&&(ge.textContent=La),St=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-190h491"&&(Ce.textContent=Aa),Et=n(e),d(g.$$.fragment,e),Lt=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-58j4yw"&&(je.innerHTML=Pa),At=n(e),d(Ze.$$.fragment,e),Pt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-qlxbsa"&&(Ie.innerHTML=qa),qt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1uul0oc"&&(_e.innerHTML=Ka),Kt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-n8bji2"&&($e.textContent=Da),Dt=n(e),d(Ge.$$.fragment,e),Ot=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1chl77v"&&(Re.innerHTML=Oa),ea=n(e),d(ke.$$.fragment,e),ta=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-336eo8"&&(Xe.innerHTML=es),aa=n(e),d(ve.$$.fragment,e),sa=n(e),d(Ve.$$.fragment,e),la=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-eeskwc"&&(Fe.innerHTML=ts),na=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-8wn0zc"&&(Be.innerHTML=as),oa=n(e),d(We.$$.fragment,e),ia=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1wibu7k"&&(Ye.innerHTML=ss),ra=n(e),d(Qe.$$.fragment,e),pa=n(e),d(xe.$$.fragment,e),da=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1sa5b56"&&(He.textContent=ls),ma=n(e),d(C.$$.fragment,e),fa=n(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-12qvhff"&&(ze.innerHTML=ns),ca=n(e),d(Ne.$$.fragment,e),ya=n(e),Se=i(e,"P",{}),ps(Se).forEach(a),this.h()},h(){ds(M,"name","hf:doc:metadata"),ds(M,"content",bs)},m(e,t){hs(document.head,M),s(e,w,t),s(e,h,t),s(e,T,t),m(j,e,t),s(e,Ee,t),s(e,Z,t),s(e,Le,t),s(e,I,t),s(e,Ae,t),s(e,_,t),s(e,Pe,t),m($,e,t),s(e,qe,t),s(e,G,t),s(e,Ke,t),m(R,e,t),s(e,De,t),s(e,k,t),s(e,Oe,t),m(X,e,t),s(e,et,t),s(e,v,t),s(e,tt,t),m(V,e,t),s(e,at,t),s(e,F,t),s(e,st,t),m(B,e,t),s(e,lt,t),s(e,W,t),s(e,nt,t),m(Y,e,t),s(e,ot,t),s(e,Q,t),s(e,it,t),m(x,e,t),s(e,rt,t),m(H,e,t),s(e,pt,t),s(e,z,t),s(e,dt,t),m(N,e,t),s(e,mt,t),s(e,S,t),s(e,ft,t),s(e,E,t),s(e,ct,t),s(e,L,t),s(e,yt,t),s(e,A,t),s(e,Mt,t),m(b,e,t),s(e,ht,t),m(P,e,t),s(e,ut,t),s(e,q,t),s(e,wt,t),m(K,e,t),s(e,Tt,t),s(e,D,t),s(e,Ut,t),m(O,e,t),s(e,Jt,t),m(ee,e,t),s(e,bt,t),s(e,te,t),s(e,gt,t),s(e,ae,t),s(e,Ct,t),s(e,se,t),s(e,jt,t),s(e,le,t),s(e,Zt,t),m(ne,e,t),s(e,It,t),s(e,oe,t),s(e,_t,t),m(ie,e,t),s(e,$t,t),s(e,re,t),s(e,Gt,t),m(pe,e,t),s(e,Rt,t),s(e,de,t),s(e,kt,t),m(me,e,t),s(e,Xt,t),s(e,fe,t),s(e,vt,t),m(ce,e,t),s(e,Vt,t),m(ye,e,t),s(e,Ft,t),s(e,Me,t),s(e,Bt,t),s(e,he,t),s(e,Wt,t),s(e,ue,t),s(e,Yt,t),m(we,e,t),s(e,Qt,t),s(e,Te,t),s(e,xt,t),m(Ue,e,t),s(e,Ht,t),m(Je,e,t),s(e,zt,t),s(e,be,t),s(e,Nt,t),s(e,ge,t),s(e,St,t),s(e,Ce,t),s(e,Et,t),m(g,e,t),s(e,Lt,t),s(e,je,t),s(e,At,t),m(Ze,e,t),s(e,Pt,t),s(e,Ie,t),s(e,qt,t),s(e,_e,t),s(e,Kt,t),s(e,$e,t),s(e,Dt,t),m(Ge,e,t),s(e,Ot,t),s(e,Re,t),s(e,ea,t),m(ke,e,t),s(e,ta,t),s(e,Xe,t),s(e,aa,t),m(ve,e,t),s(e,sa,t),m(Ve,e,t),s(e,la,t),s(e,Fe,t),s(e,na,t),s(e,Be,t),s(e,oa,t),m(We,e,t),s(e,ia,t),s(e,Ye,t),s(e,ra,t),m(Qe,e,t),s(e,pa,t),m(xe,e,t),s(e,da,t),s(e,He,t),s(e,ma,t),m(C,e,t),s(e,fa,t),s(e,ze,t),s(e,ca,t),m(Ne,e,t),s(e,ya,t),s(e,Se,t),Ma=!0},p(e,[t]){const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),b.$set(os);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),g.$set(is);const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),C.$set(rs)},i(e){Ma||(f(j.$$.fragment,e),f($.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(V.$$.fragment,e),f(B.$$.fragment,e),f(Y.$$.fragment,e),f(x.$$.fragment,e),f(H.$$.fragment,e),f(N.$$.fragment,e),f(b.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ce.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f(g.$$.fragment,e),f(Ze.$$.fragment,e),f(Ge.$$.fragment,e),f(ke.$$.fragment,e),f(ve.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Qe.$$.fragment,e),f(xe.$$.fragment,e),f(C.$$.fragment,e),f(Ne.$$.fragment,e),Ma=!0)},o(e){c(j.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(X.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(Y.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(N.$$.fragment,e),c(b.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Je.$$.fragment,e),c(g.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(ke.$$.fragment,e),c(ve.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(Qe.$$.fragment,e),c(xe.$$.fragment,e),c(C.$$.fragment,e),c(Ne.$$.fragment,e),Ma=!1},d(e){e&&(a(w),a(h),a(T),a(Ee),a(Z),a(Le),a(I),a(Ae),a(_),a(Pe),a(qe),a(G),a(Ke),a(De),a(k),a(Oe),a(et),a(v),a(tt),a(at),a(F),a(st),a(lt),a(W),a(nt),a(ot),a(Q),a(it),a(rt),a(pt),a(z),a(dt),a(mt),a(S),a(ft),a(E),a(ct),a(L),a(yt),a(A),a(Mt),a(ht),a(ut),a(q),a(wt),a(Tt),a(D),a(Ut),a(Jt),a(bt),a(te),a(gt),a(ae),a(Ct),a(se),a(jt),a(le),a(Zt),a(It),a(oe),a(_t),a($t),a(re),a(Gt),a(Rt),a(de),a(kt),a(Xt),a(fe),a(vt),a(Vt),a(Ft),a(Me),a(Bt),a(he),a(Wt),a(ue),a(Yt),a(Qt),a(Te),a(xt),a(Ht),a(zt),a(be),a(Nt),a(ge),a(St),a(Ce),a(Et),a(Lt),a(je),a(At),a(Pt),a(Ie),a(qt),a(_e),a(Kt),a($e),a(Dt),a(Ot),a(Re),a(ea),a(ta),a(Xe),a(aa),a(sa),a(la),a(Fe),a(na),a(Be),a(oa),a(ia),a(Ye),a(ra),a(pa),a(da),a(He),a(ma),a(fa),a(ze),a(ca),a(ya),a(Se)),a(M),y(j,e),y($,e),y(R,e),y(X,e),y(V,e),y(B,e),y(Y,e),y(x,e),y(H,e),y(N,e),y(b,e),y(P,e),y(K,e),y(O,e),y(ee,e),y(ne,e),y(ie,e),y(pe,e),y(me,e),y(ce,e),y(ye,e),y(we,e),y(Ue,e),y(Je,e),y(g,e),y(Ze,e),y(Ge,e),y(ke,e),y(ve,e),y(Ve,e),y(We,e),y(Qe,e),y(xe,e),y(C,e),y(Ne,e)}}}const bs='{"title":"TPU","local":"tpu","sections":[{"title":"Large datasets","local":"large-datasets","sections":[{"title":"tf.TFRecord","local":"tftfrecord","sections":[],"depth":3},{"title":"Stream from raw data","local":"stream-from-raw-data","sections":[],"depth":3},{"title":"Stream with prepare_tf_dataset","local":"stream-with-preparetfdataset","sections":[],"depth":3}],"depth":2},{"title":"TPU types","local":"tpu-types","sections":[],"depth":2},{"title":"XLA","local":"xla","sections":[{"title":"Data dependent conditionals","local":"data-dependent-conditionals","sections":[],"depth":3},{"title":"Data dependent shapes","local":"data-dependent-shapes","sections":[],"depth":3},{"title":"Recompile different input shapes","local":"recompile-different-input-shapes","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(J){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends cs{constructor(M){super(),ys(this,M,gs,Js,ms,{})}}export{$s as component};
