import{s as Fi,o as Gi,n as Pi}from"../chunks/scheduler.01eeda35.js";import{S as Vi,i as Bi,g as a,s as n,r as l,A as Ji,h as s,f as r,c as o,j as h,u as d,x as f,k as _,y as t,a as g,v as m,d as c,t as p,w as u}from"../chunks/index.6dd51b66.js";import{T as Ni}from"../chunks/Tip.de9bae2b.js";import{D as b}from"../chunks/Docstring.76e6b3cf.js";import{C as Ei}from"../chunks/CodeBlock.864da1b0.js";import{E as Wi}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{H as z,E as Ui}from"../chunks/EditOnGithub.7faefd25.js";function Ri(on){let $,J='Learn how to quantize models in the <a href="../quantization">Quantization</a> guide.';return{c(){$=a("p"),$.innerHTML=J},l(w){$=s(w,"P",{"data-svelte-h":!0}),f($)!=="svelte-1pv1tva"&&($.innerHTML=J)},m(w,H){g(w,$,H)},p:Pi,d(w){w&&r($)}}}function Zi(on){let $,J="Example:",w,H,D;return H=new Ei({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TorchAoConfig

<span class="hljs-comment"># specific quantization method</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">32</span>)
<span class="hljs-comment"># int4_weight_only quant is only working with *torch.bfloat16* dtype right now</span>
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16, quantization_config=quantization_config)

<span class="hljs-comment"># autoquant</span>
<span class="hljs-comment"># \`autoquant\` is a convenient way for users to search for the best quantization for each layer</span>
<span class="hljs-comment"># \`min_sqnr\` is an option to control the accuracy of the model, higher value means the model is more</span>
<span class="hljs-comment"># accurate, we can start with 30 and adjust it to larger or smaller (e.g. 40, 20)</span>
<span class="hljs-comment"># defaults to None, which means we&#x27;ll try to get the best performing quantized model without</span>
<span class="hljs-comment"># considering accuracy</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;autoquant&quot;</span>, min_sqnr=<span class="hljs-number">30</span>)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16, quantization_config=quantization_config)
<span class="hljs-comment"># run through example inputs, quantization methods will be selected based on the shape of example input</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
model.generate(**input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-comment"># manually ran finalize_autoquant if needed</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(quantized_model, <span class="hljs-string">&quot;finalize_autoquant&quot;</span>):
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;finalizing autoquant&quot;</span>)
  quantized_model.finalize_autoquant()`,wrap:!1}}),{c(){$=a("p"),$.textContent=J,w=n(),l(H.$$.fragment)},l(x){$=s(x,"P",{"data-svelte-h":!0}),f($)!=="svelte-11lpom8"&&($.textContent=J),w=o(x),d(H.$$.fragment,x)},m(x,Q){g(x,$,Q),g(x,w,Q),m(H,x,Q),D=!0},p:Pi,i(x){D||(c(H.$$.fragment,x),D=!0)},o(x){p(H.$$.fragment,x),D=!1},d(x){x&&(r($),r(w)),u(H,x)}}}function Si(on){let $,J,w,H,D,x,Q,Hs="Quantization techniques reduce memory and computational costs by representing weights and activations with lower-precision data types like 8-bit integers (int8). This enables loading larger models you normally wouldn’t be able to fit into memory, and speeding up inference. Transformers supports the AWQ and GPTQ quantization algorithms and it supports 8-bit and 4-bit quantization with bitsandbytes.",yo,Pe,Ds="Quantization techniques that aren’t supported in Transformers can be added with the <code>HfQuantizer</code> class.",vo,Y,$o,Fe,qo,A,Ge,Br,rn,Qs=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>quanto</code>.`,Jr,O,Ve,Nr,an,As="Safety checker that arguments are correct",xo,Be,zo,I,Je,Er,sn,Is="This is a wrapper class about <code>aqlm</code> parameters.",Wr,K,Ne,Ur,ln,js="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",wo,Ee,Co,j,We,Rr,dn,Ps="This is a wrapper class about <code>vptq</code> parameters.",Zr,ee,Ue,Sr,mn,Fs="Safety checker that arguments are correct",To,Re,ko,P,Ze,Xr,cn,Gs=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>auto-awq</code> library awq quantization relying on auto_awq backend.`,Yr,te,Se,Or,pn,Vs="Safety checker that arguments are correct",Mo,Xe,Lo,F,Ye,Kr,un,Bs=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>eetq</code>.`,ea,ne,Oe,ta,fn,Js="Safety checker that arguments are correct",Ho,Ke,Do,T,et,na,gn,Ns=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>optimum</code> api for gptq quantization relying on auto_gptq backend.`,oa,oe,tt,ra,hn,Es="Get compatible class with optimum gptq config dict",aa,re,nt,sa,_n,Ws="Safety checker that arguments are correct",ia,ae,ot,la,bn,Us="Get compatible dict for optimum gptq config",Qo,rt,Ao,q,at,da,yn,Rs=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>bitsandbytes</code>.`,ma,vn,Zs="This replaces <code>load_in_8bit</code> or <code>load_in_4bit</code>therefore both options are mutually exclusive.",ca,$n,Ss=`Currently only supports <code>LLM.int8()</code>, <code>FP4</code>, and <code>NF4</code> quantization. If more methods are added to <code>bitsandbytes</code>,
then more arguments will be added to this class.`,pa,se,st,ua,qn,Xs="Returns <code>True</code> if the model is quantizable, <code>False</code> otherwise.",fa,ie,it,ga,xn,Ys="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",ha,le,lt,_a,zn,Os=`This method returns the quantization method used for the model. If the model is not quantizable, it returns
<code>None</code>.`,ba,de,dt,ya,wn,Ks=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Io,mt,jo,y,ct,va,Cn,ei=`Abstract class of the HuggingFace quantizer. Supports for now quantizing HF transformers models for inference and/or quantization.
This class is used only for transformers.PreTrainedModel.from_pretrained and cannot be easily used outside the scope of that method
yet.`,$a,Tn,ti=`Attributes
quantization_config (<code>transformers.utils.quantization_config.QuantizationConfigMixin</code>):
The quantization config that defines the quantization parameters of your model that you want to quantize.
modules_to_not_convert (<code>List[str]</code>, <em>optional</em>):
The list of module names to not convert when quantizing the model.
required_packages (<code>List[str]</code>, <em>optional</em>):
The list of required pip packages to install prior to using the quantizer
requires_calibration (<code>bool</code>):
Whether the quantization method requires to calibrate the model before using it.
requires_parameters_quantization (<code>bool</code>):
Whether the quantization method requires to create a new Parameter. For example, for bitsandbytes, it is
required to create a new xxxParameter in order to properly quantize the model.`,qa,me,pt,xa,kn,ni="adjust max_memory argument for infer_auto_device_map() if extra memory is needed for quantization",za,ce,ut,wa,Mn,oi=`Override this method if you want to adjust the <code>target_dtype</code> variable used in <code>from_pretrained</code>
to compute the device_map in case the device_map is a <code>str</code>. E.g. for bitsandbytes we force-set <code>target_dtype</code>
to <code>torch.int8</code> and for 4-bit we pass a custom enum <code>accelerate.CustomDtype.int4</code>.`,Ca,pe,ft,Ta,Ln,ri=`checks if a loaded state_dict component is part of quantized param + some validation; only defined if
requires_parameters_quantization == True for quantization methods that require to create a new parameters
for quantization.`,ka,ue,gt,Ma,Hn,ai=`takes needed components from state_dict and creates quantized param; only applicable if
requires_parameters_quantization == True`,La,fe,ht,Ha,Dn,si=`Potentially dequantize the model to retrive the original model, with some loss in accuracy / performance.
Note not all quantization schemes support this.`,Da,ge,_t,Qa,Qn,ii=`returns dtypes for modules that are not quantized - used for the computation of the device_map in case
one passes a str as a device_map. The method will use the <code>modules_to_not_convert</code> that is modified
in <code>_process_model_before_weight_loading</code>.`,Aa,he,bt,Ia,An,li=`Post-process the model post weights loading.
Make sure to override the abstract method <code>_process_model_after_weight_loading</code>.`,ja,_e,yt,Pa,In,di=`Setting model attributes and/or converting model before weights loading. At this point
the model should be initialized on the meta device so you can freely manipulate the skeleton
of the model in order to replace modules in-place. Make sure to override the abstract method <code>_process_model_before_weight_loading</code>.`,Fa,be,vt,Ga,jn,mi=`Override this method if you want to pass a override the existing device map with a new
one. E.g. for bitsandbytes, since <code>accelerate</code> is a hard requirement, if no device_map is
passed, the device_map is set to \`“auto”“`,Va,ye,$t,Ba,Pn,ci="Override this method if you want to adjust the <code>update_expected_keys</code>.",Ja,ve,qt,Na,Fn,pi="Override this method if you want to adjust the <code>missing_keys</code>.",Ea,$e,xt,Wa,Gn,ui=`Override this method if you want to adjust the <code>missing_keys</code> after loading the model params,
but before the model is post-processed.`,Ua,qe,zt,Ra,Vn,fi=`Some quantization methods require to explicitly set the dtype of the model to a
target dtype. You need to override this method in case you want to make sure that behavior is
preserved`,Za,xe,wt,Sa,Bn,gi="Override this method if you want to adjust the <code>unexpected_keys</code>.",Xa,ze,Ct,Ya,Jn,hi=`This method is used to potentially check for potential conflicts with arguments that are
passed in <code>from_pretrained</code>. You need to define it for all future quantizers that are integrated with transformers.
If no explicit check are needed, simply return nothing.`,Po,Tt,Fo,G,kt,Oa,Nn,_i="HiggsConfig is a configuration class for quantization using the HIGGS method.",Ka,we,Mt,es,En,bi="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",Go,Lt,Vo,k,Ht,ts,Wn,yi="This is wrapper around hqq’s BaseQuantizeConfig.",ns,Ce,Dt,os,Un,vi="Override from_dict, used in AutoQuantizationConfig.from_dict in quantizers/auto.py",rs,Te,Qt,as,Rn,$i="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",ss,ke,At,is,Zn,qi=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Bo,It,Jo,Z,jt,ls,Sn,xi=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using fbgemm fp8 quantization.`,No,Pt,Eo,M,Ft,ds,Xn,zi=`This is a wrapper class that handles compressed-tensors quantization config options.
It is a wrapper around <code>compressed_tensors.QuantizationConfig</code>`,ms,Me,Gt,cs,Yn,wi=`Instantiates a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.CompressedTensorsConfig">CompressedTensorsConfig</a> from a Python dictionary of parameters.
Optionally unwraps any args from the nested quantization_config`,ps,N,Vt,us,On,Ci="Quantization config to be added to config.json",fs,Kn,Ti=`Serializes this instance to a Python dictionary. Returns:
<code>Dict[str, Any]</code>: Dictionary of all the attributes that make up this configuration instance.`,gs,Le,Bt,hs,eo,ki=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Wo,Jt,Uo,L,Nt,_s,to,Mi="This is a config class for torchao quantization/sparsity techniques.",bs,He,ys,De,Et,vs,no,Li="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",$s,Qe,Wt,qs,oo,Hi=`Serializes this instance to a Python dictionary, converting any <code>torchao.dtypes.Layout</code>
dataclasses to simple dicts.`,Ro,Ut,Zo,S,Rt,xs,Ae,Zt,zs,ro,Di="Safety checker that arguments are correct",So,St,Xo,V,Xt,ws,ao,Qi="This is a wrapper class about <code>spqr</code> parameters. Refer to the original publication for more details.",Cs,Ie,Yt,Ts,so,Ai="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",Yo,Ot,Oo,B,Kt,ks,io,Ii="FineGrainedFP8Config is a configuration class for fine-grained FP8 quantization used mainly for deepseek models.",Ms,je,en,Ls,lo,ji="Safety checker that arguments are correct",Ko,tn,er,bo,tr;return D=new z({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),Y=new Ni({props:{$$slots:{default:[Ri]},$$scope:{ctx:on}}}),Fe=new z({props:{title:"QuantoConfig",local:"transformers.QuantoConfig",headingTag:"h2"}}),Ge=new b({props:{name:"class transformers.QuantoConfig",anchor:"transformers.QuantoConfig",parameters:[{name:"weights",val:" = 'int8'"},{name:"activations",val:" = None"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.QuantoConfig.weights",description:`<strong>weights</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;int8&quot;</code>) &#x2014;
The target dtype for the weights after quantization. Supported values are (&#x201C;float8&#x201D;,&#x201C;int8&#x201D;,&#x201C;int4&#x201D;,&#x201C;int2&#x201D;)`,name:"weights"},{anchor:"transformers.QuantoConfig.activations",description:`<strong>activations</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The target dtype for the activations after quantization. Supported values are (None,&#x201C;int8&#x201D;,&#x201C;float8&#x201D;)`,name:"activations"},{anchor:"transformers.QuantoConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision (e.g. Whisper encoder, Llava encoder, Mixtral gate layers).`,name:"modules_to_not_convert"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1144"}}),Ve=new b({props:{name:"post_init",anchor:"transformers.QuantoConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1173"}}),Be=new z({props:{title:"AqlmConfig",local:"transformers.AqlmConfig",headingTag:"h2"}}),Je=new b({props:{name:"class transformers.AqlmConfig",anchor:"transformers.AqlmConfig",parameters:[{name:"in_group_size",val:": int = 8"},{name:"out_group_size",val:": int = 1"},{name:"num_codebooks",val:": int = 1"},{name:"nbits_per_codebook",val:": int = 16"},{name:"linear_weights_not_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AqlmConfig.in_group_size",description:`<strong>in_group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The group size along the input dimension.`,name:"in_group_size"},{anchor:"transformers.AqlmConfig.out_group_size",description:`<strong>out_group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The group size along the output dimension. It&#x2019;s recommended to always use 1.`,name:"out_group_size"},{anchor:"transformers.AqlmConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of codebooks for the Additive Quantization procedure.`,name:"num_codebooks"},{anchor:"transformers.AqlmConfig.nbits_per_codebook",description:`<strong>nbits_per_codebook</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of bits encoding a single codebook vector. Codebooks size is 2**nbits_per_codebook.`,name:"nbits_per_codebook"},{anchor:"transformers.AqlmConfig.linear_weights_not_to_quantize",description:`<strong>linear_weights_not_to_quantize</strong> (<code>Optional[List[str]]</code>, <em>optional</em>) &#x2014;
List of full paths of <code>nn.Linear</code> weight parameters that shall not be quantized.`,name:"linear_weights_not_to_quantize"},{anchor:"transformers.AqlmConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L988"}}),Ne=new b({props:{name:"post_init",anchor:"transformers.AqlmConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1026"}}),Ee=new z({props:{title:"VptqConfig",local:"transformers.VptqConfig",headingTag:"h2"}}),We=new b({props:{name:"class transformers.VptqConfig",anchor:"transformers.VptqConfig",parameters:[{name:"enable_proxy_error",val:": bool = False"},{name:"config_for_layers",val:": typing.Dict[str, typing.Any] = {}"},{name:"shared_layer_config",val:": typing.Dict[str, typing.Any] = {}"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VptqConfig.enable_proxy_error",description:"<strong>enable_proxy_error</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; calculate proxy error for each layer",name:"enable_proxy_error"},{anchor:"transformers.VptqConfig.config_for_layers",description:"<strong>config_for_layers</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014; quantization params for each layer",name:"config_for_layers"},{anchor:"transformers.VptqConfig.shared_layer_config",description:"<strong>shared_layer_config</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014; shared quantization params among layers",name:"shared_layer_config"},{anchor:"transformers.VptqConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision (e.g. Whisper encoder, Llava encoder, Mixtral gate layers).`,name:"modules_to_not_convert"},{anchor:"transformers.VptqConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1103"}}),Ue=new b({props:{name:"post_init",anchor:"transformers.VptqConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1134"}}),Re=new z({props:{title:"AwqConfig",local:"transformers.AwqConfig",headingTag:"h2"}}),Ze=new b({props:{name:"class transformers.AwqConfig",anchor:"transformers.AwqConfig",parameters:[{name:"bits",val:": int = 4"},{name:"group_size",val:": int = 128"},{name:"zero_point",val:": bool = True"},{name:"version",val:": AWQLinearVersion = <AWQLinearVersion.GEMM: 'gemm'>"},{name:"backend",val:": AwqBackendPackingMethod = <AwqBackendPackingMethod.AUTOAWQ: 'autoawq'>"},{name:"do_fuse",val:": typing.Optional[bool] = None"},{name:"fuse_max_seq_len",val:": typing.Optional[int] = None"},{name:"modules_to_fuse",val:": typing.Optional[dict] = None"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"exllama_config",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AwqConfig.bits",description:`<strong>bits</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of bits to quantize to.`,name:"bits"},{anchor:"transformers.AwqConfig.group_size",description:`<strong>group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The group size to use for quantization. Recommended value is 128 and -1 uses per-column quantization.`,name:"group_size"},{anchor:"transformers.AwqConfig.zero_point",description:`<strong>zero_point</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use zero point quantization.`,name:"zero_point"},{anchor:"transformers.AwqConfig.version",description:`<strong>version</strong> (<code>AWQLinearVersion</code>, <em>optional</em>, defaults to <code>AWQLinearVersion.GEMM</code>) &#x2014;
The version of the quantization algorithm to use. GEMM is better for big batch_size (e.g. &gt;= 8) otherwise,
GEMV is better (e.g. &lt; 8 ). GEMM models are compatible with Exllama kernels.`,name:"version"},{anchor:"transformers.AwqConfig.backend",description:`<strong>backend</strong> (<code>AwqBackendPackingMethod</code>, <em>optional</em>, defaults to <code>AwqBackendPackingMethod.AUTOAWQ</code>) &#x2014;
The quantization backend. Some models might be quantized using <code>llm-awq</code> backend. This is useful for users
that quantize their own models using <code>llm-awq</code> library.`,name:"backend"},{anchor:"transformers.AwqConfig.do_fuse",description:`<strong>do_fuse</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fuse attention and mlp layers together for faster inference`,name:"do_fuse"},{anchor:"transformers.AwqConfig.fuse_max_seq_len",description:`<strong>fuse_max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The Maximum sequence length to generate when using fusing.`,name:"fuse_max_seq_len"},{anchor:"transformers.AwqConfig.modules_to_fuse",description:`<strong>modules_to_fuse</strong> (<code>dict</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Overwrite the natively supported fusing scheme with the one specified by the users.`,name:"modules_to_fuse"},{anchor:"transformers.AwqConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision (e.g. Whisper encoder, Llava encoder, Mixtral gate layers).
Note you cannot quantize directly with transformers, please refer to <code>AutoAWQ</code> documentation for quantizing HF models.`,name:"modules_to_not_convert"},{anchor:"transformers.AwqConfig.exllama_config",description:`<strong>exllama_config</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
You can specify the version of the exllama kernel through the <code>version</code> key, the maximum sequence
length through the <code>max_input_len</code> key, and the maximum batch size through the <code>max_batch_size</code> key.
Defaults to <code>{&quot;version&quot;: 2, &quot;max_input_len&quot;: 2048, &quot;max_batch_size&quot;: 8}</code> if unset.`,name:"exllama_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L815"}}),Se=new b({props:{name:"post_init",anchor:"transformers.AwqConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L884"}}),Xe=new z({props:{title:"EetqConfig",local:"transformers.EetqConfig",headingTag:"h2"}}),Ye=new b({props:{name:"class transformers.EetqConfig",anchor:"transformers.EetqConfig",parameters:[{name:"weights",val:": str = 'int8'"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EetqConfig.weights",description:`<strong>weights</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;int8&quot;</code>) &#x2014;
The target dtype for the weights. Supported value is only &#x201C;int8&#x201D;`,name:"weights"},{anchor:"transformers.EetqConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision.`,name:"modules_to_not_convert"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1185"}}),Oe=new b({props:{name:"post_init",anchor:"transformers.EetqConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1210"}}),Ke=new z({props:{title:"GPTQConfig",local:"transformers.GPTQConfig",headingTag:"h2"}}),et=new b({props:{name:"class transformers.GPTQConfig",anchor:"transformers.GPTQConfig",parameters:[{name:"bits",val:": int"},{name:"tokenizer",val:": typing.Any = None"},{name:"dataset",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"group_size",val:": int = 128"},{name:"damp_percent",val:": float = 0.1"},{name:"desc_act",val:": bool = False"},{name:"sym",val:": bool = True"},{name:"true_sequential",val:": bool = True"},{name:"checkpoint_format",val:": str = 'gptq'"},{name:"meta",val:": typing.Optional[typing.Dict[str, <built-in function any>]] = None"},{name:"backend",val:": typing.Optional[str] = None"},{name:"use_cuda_fp16",val:": bool = False"},{name:"model_seqlen",val:": typing.Optional[int] = None"},{name:"block_name_to_quantize",val:": typing.Optional[str] = None"},{name:"module_name_preceding_first_block",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"use_exllama",val:": typing.Optional[bool] = None"},{name:"max_input_length",val:": typing.Optional[int] = None"},{name:"exllama_config",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"cache_block_outputs",val:": bool = True"},{name:"modules_in_block_to_quantize",val:": typing.Optional[typing.List[typing.List[str]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTQConfig.bits",description:`<strong>bits</strong> (<code>int</code>) &#x2014;
The number of bits to quantize to, supported numbers are (2, 3, 4, 8).`,name:"bits"},{anchor:"transformers.GPTQConfig.tokenizer",description:`<strong>tokenizer</strong> (<code>str</code> or <code>PreTrainedTokenizerBase</code>, <em>optional</em>) &#x2014;
The tokenizer used to process the dataset. You can pass either:<ul>
<li>A custom tokenizer object.</li>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"tokenizer"},{anchor:"transformers.GPTQConfig.dataset",description:`<strong>dataset</strong> (<code>Union[List[str]]</code>, <em>optional</em>) &#x2014;
The dataset used for quantization. You can provide your own dataset in a list of string or just use the
original datasets used in GPTQ paper [&#x2018;wikitext2&#x2019;,&#x2018;c4&#x2019;,&#x2018;c4-new&#x2019;]`,name:"dataset"},{anchor:"transformers.GPTQConfig.group_size",description:`<strong>group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The group size to use for quantization. Recommended value is 128 and -1 uses per-column quantization.`,name:"group_size"},{anchor:"transformers.GPTQConfig.damp_percent",description:`<strong>damp_percent</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The percent of the average Hessian diagonal to use for dampening. Recommended value is 0.1.`,name:"damp_percent"},{anchor:"transformers.GPTQConfig.desc_act",description:`<strong>desc_act</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to quantize columns in order of decreasing activation size. Setting it to False can significantly
speed up inference but the perplexity may become slightly worse. Also known as act-order.`,name:"desc_act"},{anchor:"transformers.GPTQConfig.sym",description:`<strong>sym</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use symetric quantization.`,name:"sym"},{anchor:"transformers.GPTQConfig.true_sequential",description:`<strong>true_sequential</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to perform sequential quantization even within a single Transformer block. Instead of quantizing
the entire block at once, we perform layer-wise quantization. As a result, each layer undergoes
quantization using inputs that have passed through the previously quantized layers.`,name:"true_sequential"},{anchor:"transformers.GPTQConfig.checkpoint_format",description:`<strong>checkpoint_format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gptq&quot;</code>) &#x2014;
GPTQ weight format. <code>gptq</code>(v1) is supported by both gptqmodel and auto-gptq. <code>gptq_v2</code> is gptqmodel only.`,name:"checkpoint_format"},{anchor:"transformers.GPTQConfig.meta",description:`<strong>meta</strong> (<code>Dict[str, any]</code>, <em>optional</em>) &#x2014;
Properties, such as tooling:version, that do not directly contributes to quantization or quant inference are stored in meta.
i.e. <code>meta.quantizer</code>: [&#x201C;optimum:<em>version</em>&#x201D;, &#x201C;gptqmodel:<em>version</em>&#x201D;]`,name:"meta"},{anchor:"transformers.GPTQConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Controls which gptq kernel to be used. Valid values for gptqmodel are <code>auto</code>, <code>auto_trainable</code> and more. For auto-gptq, only
valid value is None and <code>auto_trainable</code>. Ref gptqmodel backends: <a href="https://github.com/ModelCloud/GPTQModel/blob/main/gptqmodel/utils/backend.py" rel="nofollow">https://github.com/ModelCloud/GPTQModel/blob/main/gptqmodel/utils/backend.py</a>`,name:"backend"},{anchor:"transformers.GPTQConfig.use_cuda_fp16",description:`<strong>use_cuda_fp16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use optimized cuda kernel for fp16 model. Need to have model in fp16. Auto-gptq only.`,name:"use_cuda_fp16"},{anchor:"transformers.GPTQConfig.model_seqlen",description:`<strong>model_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length that the model can take.`,name:"model_seqlen"},{anchor:"transformers.GPTQConfig.block_name_to_quantize",description:`<strong>block_name_to_quantize</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The transformers block name to quantize. If None, we will infer the block name using common patterns (e.g. model.layers)`,name:"block_name_to_quantize"},{anchor:"transformers.GPTQConfig.module_name_preceding_first_block",description:`<strong>module_name_preceding_first_block</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The layers that are preceding the first Transformer block.`,name:"module_name_preceding_first_block"},{anchor:"transformers.GPTQConfig.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The batch size used when processing the dataset`,name:"batch_size"},{anchor:"transformers.GPTQConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The pad token id. Needed to prepare the dataset when <code>batch_size</code> &gt; 1.`,name:"pad_token_id"},{anchor:"transformers.GPTQConfig.use_exllama",description:`<strong>use_exllama</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use exllama backend. Defaults to <code>True</code> if unset. Only works with <code>bits</code> = 4.`,name:"use_exllama"},{anchor:"transformers.GPTQConfig.max_input_length",description:`<strong>max_input_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum input length. This is needed to initialize a buffer that depends on the maximum expected input
length. It is specific to the exllama backend with act-order.`,name:"max_input_length"},{anchor:"transformers.GPTQConfig.exllama_config",description:`<strong>exllama_config</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The exllama config. You can specify the version of the exllama kernel through the <code>version</code> key. Defaults
to <code>{&quot;version&quot;: 1}</code> if unset.`,name:"exllama_config"},{anchor:"transformers.GPTQConfig.cache_block_outputs",description:`<strong>cache_block_outputs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache block outputs to reuse as inputs for the succeeding block.`,name:"cache_block_outputs"},{anchor:"transformers.GPTQConfig.modules_in_block_to_quantize",description:`<strong>modules_in_block_to_quantize</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
List of list of module names to quantize in the specified block. This argument is useful to exclude certain linear modules from being quantized.
The block to quantize can be specified by setting <code>block_name_to_quantize</code>. We will quantize each list sequentially. If not set, we will quantize all linear layers.
Example: <code>modules_in_block_to_quantize =[[&quot;self_attn.k_proj&quot;, &quot;self_attn.v_proj&quot;, &quot;self_attn.q_proj&quot;], [&quot;self_attn.o_proj&quot;]]</code>.
In this example, we will first quantize the q,k,v layers simultaneously since they are independent.
Then, we will quantize <code>self_attn.o_proj</code> layer with the q,k,v layers quantized. This way, we will get
better results since it reflects the real input <code>self_attn.o_proj</code> will get when the model is quantized.`,name:"modules_in_block_to_quantize"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L565"}}),tt=new b({props:{name:"from_dict_optimum",anchor:"transformers.GPTQConfig.from_dict_optimum",parameters:[{name:"config_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L800"}}),nt=new b({props:{name:"post_init",anchor:"transformers.GPTQConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L700"}}),ot=new b({props:{name:"to_dict_optimum",anchor:"transformers.GPTQConfig.to_dict_optimum",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L791"}}),rt=new z({props:{title:"BitsAndBytesConfig",local:"transformers.BitsAndBytesConfig",headingTag:"h2"}}),at=new b({props:{name:"class transformers.BitsAndBytesConfig",anchor:"transformers.BitsAndBytesConfig",parameters:[{name:"load_in_8bit",val:" = False"},{name:"load_in_4bit",val:" = False"},{name:"llm_int8_threshold",val:" = 6.0"},{name:"llm_int8_skip_modules",val:" = None"},{name:"llm_int8_enable_fp32_cpu_offload",val:" = False"},{name:"llm_int8_has_fp16_weight",val:" = False"},{name:"bnb_4bit_compute_dtype",val:" = None"},{name:"bnb_4bit_quant_type",val:" = 'fp4'"},{name:"bnb_4bit_use_double_quant",val:" = False"},{name:"bnb_4bit_quant_storage",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitsAndBytesConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 8-bit quantization with LLM.int8().`,name:"load_in_8bit"},{anchor:"transformers.BitsAndBytesConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 4-bit quantization by replacing the Linear layers with FP4/NF4 layers from
<code>bitsandbytes</code>.`,name:"load_in_4bit"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_threshold",description:`<strong>llm_int8_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
This corresponds to the outlier threshold for outlier detection as described in <code>LLM.int8() : 8-bit Matrix Multiplication for Transformers at Scale</code> paper: <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">https://arxiv.org/abs/2208.07339</a> Any hidden states value
that is above this threshold will be considered an outlier and the operation on those values will be done
in fp16. Values are usually normally distributed, that is, most values are in the range [-3.5, 3.5], but
there are some exceptional systematic outliers that are very differently distributed for large models.
These outliers are often in the interval [-60, -6] or [6, 60]. Int8 quantization works well for values of
magnitude ~5, but beyond that, there is a significant performance penalty. A good default threshold is 6,
but a lower threshold might be needed for more unstable models (small models, fine-tuning).`,name:"llm_int8_threshold"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_skip_modules",description:`<strong>llm_int8_skip_modules</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
An explicit list of the modules that we do not want to convert in 8-bit. This is useful for models such as
Jukebox that has several heads in different places and not necessarily at the last position. For example
for <code>CausalLM</code> models, the last <code>lm_head</code> is kept in its original <code>dtype</code>.`,name:"llm_int8_skip_modules"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_enable_fp32_cpu_offload",description:`<strong>llm_int8_enable_fp32_cpu_offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for advanced use cases and users that are aware of this feature. If you want to split
your model in different parts and run some parts in int8 on GPU and some parts in fp32 on CPU, you can use
this flag. This is useful for offloading large models such as <code>google/flan-t5-xxl</code>. Note that the int8
operations will not be run on CPU.`,name:"llm_int8_enable_fp32_cpu_offload"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_has_fp16_weight",description:`<strong>llm_int8_has_fp16_weight</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag runs LLM.int8() with 16-bit main weights. This is useful for fine-tuning as the weights do not
have to be converted back and forth for the backward pass.`,name:"llm_int8_has_fp16_weight"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_compute_dtype",description:`<strong>bnb_4bit_compute_dtype</strong> (<code>torch.dtype</code> or str, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
This sets the computational type which might be different than the input type. For example, inputs might be
fp32, but computation can be set to bf16 for speedups.`,name:"bnb_4bit_compute_dtype"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>,  <em>optional</em>, defaults to <code>&quot;fp4&quot;</code>) &#x2014;
This sets the quantization data type in the bnb.nn.Linear4Bit layers. Options are FP4 and NF4 data types
which are specified by <code>fp4</code> or <code>nf4</code>.`,name:"bnb_4bit_quant_type"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_use_double_quant",description:`<strong>bnb_4bit_use_double_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for nested quantization where the quantization constants from the first quantization are
quantized again.`,name:"bnb_4bit_use_double_quant"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_quant_storage",description:`<strong>bnb_4bit_quant_storage</strong> (<code>torch.dtype</code> or str, <em>optional</em>, defaults to <code>torch.uint8</code>) &#x2014;
This sets the storage type to pack the quanitzed 4-bit prarams.`,name:"bnb_4bit_quant_storage"},{anchor:"transformers.BitsAndBytesConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L329"}}),st=new b({props:{name:"is_quantizable",anchor:"transformers.BitsAndBytesConfig.is_quantizable",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L500"}}),it=new b({props:{name:"post_init",anchor:"transformers.BitsAndBytesConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L463"}}),lt=new b({props:{name:"quantization_method",anchor:"transformers.BitsAndBytesConfig.quantization_method",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L506"}}),dt=new b({props:{name:"to_diff_dict",anchor:"transformers.BitsAndBytesConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L537",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),mt=new z({props:{title:"HfQuantizer",local:"transformers.quantizers.HfQuantizer",headingTag:"h2"}}),ct=new b({props:{name:"class transformers.quantizers.HfQuantizer",anchor:"transformers.quantizers.HfQuantizer",parameters:[{name:"quantization_config",val:": QuantizationConfigMixin"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L28"}}),pt=new b({props:{name:"adjust_max_memory",anchor:"transformers.quantizers.HfQuantizer.adjust_max_memory",parameters:[{name:"max_memory",val:": typing.Dict[str, typing.Union[int, str]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L164"}}),ut=new b({props:{name:"adjust_target_dtype",anchor:"transformers.quantizers.HfQuantizer.adjust_target_dtype",parameters:[{name:"torch_dtype",val:": torch.dtype"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.adjust_target_dtype.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The torch_dtype that is used to compute the device_map.`,name:"torch_dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L90"}}),ft=new b({props:{name:"check_quantized_param",anchor:"transformers.quantizers.HfQuantizer.check_quantized_param",parameters:[{name:"model",val:": PreTrainedModel"},{name:"param_value",val:": torch.Tensor"},{name:"param_name",val:": str"},{name:"state_dict",val:": typing.Dict[str, typing.Any]"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L168"}}),gt=new b({props:{name:"create_quantized_param",anchor:"transformers.quantizers.HfQuantizer.create_quantized_param",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L183"}}),ht=new b({props:{name:"dequantize",anchor:"transformers.quantizers.HfQuantizer.dequantize",parameters:[{name:"model",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L230"}}),_t=new b({props:{name:"get_special_dtypes_update",anchor:"transformers.quantizers.HfQuantizer.get_special_dtypes_update",parameters:[{name:"model",val:""},{name:"torch_dtype",val:": torch.dtype"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.get_special_dtypes_update.model",description:`<strong>model</strong> (<code>~transformers.PreTrainedModel</code>) &#x2014;
The model to quantize`,name:"model"},{anchor:"transformers.quantizers.HfQuantizer.get_special_dtypes_update.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The dtype passed in <code>from_pretrained</code> method.`,name:"torch_dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L145"}}),bt=new b({props:{name:"postprocess_model",anchor:"transformers.quantizers.HfQuantizer.postprocess_model",parameters:[{name:"model",val:": PreTrainedModel"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.postprocess_model.model",description:`<strong>model</strong> (<code>~transformers.PreTrainedModel</code>) &#x2014;
The model to quantize`,name:"model"},{anchor:"transformers.quantizers.HfQuantizer.postprocess_model.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The keyword arguments that are passed along <code>_process_model_after_weight_loading</code>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L217"}}),yt=new b({props:{name:"preprocess_model",anchor:"transformers.quantizers.HfQuantizer.preprocess_model",parameters:[{name:"model",val:": PreTrainedModel"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.preprocess_model.model",description:`<strong>model</strong> (<code>~transformers.PreTrainedModel</code>) &#x2014;
The model to quantize`,name:"model"},{anchor:"transformers.quantizers.HfQuantizer.preprocess_model.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The keyword arguments that are passed along <code>_process_model_before_weight_loading</code>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L201"}}),vt=new b({props:{name:"update_device_map",anchor:"transformers.quantizers.HfQuantizer.update_device_map",parameters:[{name:"device_map",val:": typing.Optional[typing.Dict[str, typing.Any]]"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_device_map.device_map",description:`<strong>device_map</strong> (<code>Union[dict, str]</code>, <em>optional</em>) &#x2014;
The device_map that is passed through the <code>from_pretrained</code> method.`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L78"}}),$t=new b({props:{name:"update_expected_keys",anchor:"transformers.quantizers.HfQuantizer.update_expected_keys",parameters:[{name:"model",val:""},{name:"expected_keys",val:": typing.List[str]"},{name:"loaded_keys",val:": typing.List[str]"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_expected_keys.expected_keys",description:`<strong>expected_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of the expected keys in the initialized model.`,name:"expected_keys"},{anchor:"transformers.quantizers.HfQuantizer.update_expected_keys.loaded_keys",description:`<strong>loaded_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of the loaded keys in the checkpoint.`,name:"loaded_keys"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L133"}}),qt=new b({props:{name:"update_missing_keys",anchor:"transformers.quantizers.HfQuantizer.update_missing_keys",parameters:[{name:"model",val:""},{name:"missing_keys",val:": typing.List[str]"},{name:"prefix",val:": str"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_missing_keys.missing_keys",description:`<strong>missing_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of missing keys in the checkpoint compared to the state dict of the model`,name:"missing_keys"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L102"}}),xt=new b({props:{name:"update_missing_keys_after_loading",anchor:"transformers.quantizers.HfQuantizer.update_missing_keys_after_loading",parameters:[{name:"model",val:""},{name:"missing_keys",val:": typing.List[str]"},{name:"prefix",val:": str"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_missing_keys_after_loading.missing_keys",description:`<strong>missing_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of missing keys in the checkpoint compared to the state dict of the model`,name:"missing_keys"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L122"}}),zt=new b({props:{name:"update_torch_dtype",anchor:"transformers.quantizers.HfQuantizer.update_torch_dtype",parameters:[{name:"torch_dtype",val:": torch.dtype"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_torch_dtype.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The input dtype that is passed in <code>from_pretrained</code>`,name:"torch_dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L66"}}),wt=new b({props:{name:"update_unexpected_keys",anchor:"transformers.quantizers.HfQuantizer.update_unexpected_keys",parameters:[{name:"model",val:""},{name:"unexpected_keys",val:": typing.List[str]"},{name:"prefix",val:": str"}],parametersDescription:[{anchor:"transformers.quantizers.HfQuantizer.update_unexpected_keys.unexpected_keys",description:`<strong>unexpected_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of unexpected keys in the checkpoint compared to the state dict of the model`,name:"unexpected_keys"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L112"}}),Ct=new b({props:{name:"validate_environment",anchor:"transformers.quantizers.HfQuantizer.validate_environment",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/quantizers/base.py#L193"}}),Tt=new z({props:{title:"HiggsConfig",local:"transformers.HiggsConfig",headingTag:"h2"}}),kt=new b({props:{name:"class transformers.HiggsConfig",anchor:"transformers.HiggsConfig",parameters:[{name:"bits",val:": int = 4"},{name:"p",val:": int = 2"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List[str]] = None"},{name:"hadamard_size",val:": int = 512"},{name:"group_size",val:": int = 256"},{name:"tune_metadata",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.HiggsConfig.bits",description:`<strong>bits</strong> (int, <em>optional</em>, defaults to 4) &#x2014;
Number of bits to use for quantization. Can be 2, 3 or 4. Default is 4.`,name:"bits"},{anchor:"transformers.HiggsConfig.p",description:`<strong>p</strong> (int, <em>optional</em>, defaults to 2) &#x2014;
Quantization grid dimension. 1 and 2 are supported. 2 is always better in practice. Default is 2.`,name:"p"},{anchor:"transformers.HiggsConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to [&#x201C;lm_head&#x201D;]) &#x2014;
List of linear layers that should not be quantized.`,name:"modules_to_not_convert"},{anchor:"transformers.HiggsConfig.hadamard_size",description:`<strong>hadamard_size</strong> (int, <em>optional</em>, defaults to 512) &#x2014;
Hadamard size for the HIGGS method. Default is 512. Input dimension of matrices is padded to this value. Decreasing this below 512 will reduce the quality of the quantization.`,name:"hadamard_size"},{anchor:"transformers.HiggsConfig.group_size",description:`<strong>group_size</strong> (int, <em>optional</em>, defaults to 256) &#x2014;
Group size for the HIGGS method. Can be 64, 128 or 256. Decreasing it barely affects the performance. Default is 256. Must be a divisor of hadamard_size.`,name:"group_size"},{anchor:"transformers.HiggsConfig.tune_metadata",description:`<strong>tune_metadata</strong> (&#x2018;dict&#x2019;, <em>optional</em>, defaults to {}) &#x2014;
Module-wise metadata (gemm block shapes, GPU metadata, etc.) for saving the kernel tuning results. Default is an empty dictionary. Is set automatically during tuning.`,name:"tune_metadata"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1397"}}),Mt=new b({props:{name:"post_init",anchor:"transformers.HiggsConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1441"}}),Lt=new z({props:{title:"HqqConfig",local:"transformers.HqqConfig",headingTag:"h2"}}),Ht=new b({props:{name:"class transformers.HqqConfig",anchor:"transformers.HqqConfig",parameters:[{name:"nbits",val:": int = 4"},{name:"group_size",val:": int = 64"},{name:"view_as_float",val:": bool = False"},{name:"axis",val:": typing.Optional[int] = None"},{name:"dynamic_config",val:": typing.Optional[dict] = None"},{name:"skip_modules",val:": typing.List[str] = ['lm_head']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.HqqConfig.nbits",description:`<strong>nbits</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits. Supported values are (8, 4, 3, 2, 1).`,name:"nbits"},{anchor:"transformers.HqqConfig.group_size",description:`<strong>group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Group-size value. Supported values are any value that is divisble by weight.shape[axis]).`,name:"group_size"},{anchor:"transformers.HqqConfig.view_as_float",description:`<strong>view_as_float</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
View the quantized weight as float (used in distributed training) if set to <code>True</code>.`,name:"view_as_float"},{anchor:"transformers.HqqConfig.axis",description:`<strong>axis</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
Axis along which grouping is performed. Supported values are 0 or 1.`,name:"axis"},{anchor:"transformers.HqqConfig.dynamic_config",description:`<strong>dynamic_config</strong> (dict, <em>optional</em>) &#x2014;
Parameters for dynamic configuration. The key is the name tag of the layer and the value is a quantization config.
If set, each layer specified by its id will use its dedicated quantization configuration.`,name:"dynamic_config"},{anchor:"transformers.HqqConfig.skip_modules",description:`<strong>skip_modules</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&apos;lm_head&apos;]</code>) &#x2014;
List of <code>nn.Linear</code> layers to skip.`,name:"skip_modules"},{anchor:"transformers.HqqConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L204"}}),Dt=new b({props:{name:"from_dict",anchor:"transformers.HqqConfig.from_dict",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L282"}}),Qt=new b({props:{name:"post_init",anchor:"transformers.HqqConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L276"}}),At=new b({props:{name:"to_diff_dict",anchor:"transformers.HqqConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),It=new z({props:{title:"FbgemmFp8Config",local:"transformers.FbgemmFp8Config",headingTag:"h2"}}),jt=new b({props:{name:"class transformers.FbgemmFp8Config",anchor:"transformers.FbgemmFp8Config",parameters:[{name:"activation_scale_ub",val:": float = 1200.0"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FbgemmFp8Config.activation_scale_ub",description:`<strong>activation_scale_ub</strong> (<code>float</code>, <em>optional</em>, defaults to 1200.0) &#x2014;
The activation scale upper bound. This is used when quantizing the input activation.`,name:"activation_scale_ub"},{anchor:"transformers.FbgemmFp8Config.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision.`,name:"modules_to_not_convert"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1366"}}),Pt=new z({props:{title:"CompressedTensorsConfig",local:"transformers.CompressedTensorsConfig",headingTag:"h2"}}),Ft=new b({props:{name:"class transformers.CompressedTensorsConfig",anchor:"transformers.CompressedTensorsConfig",parameters:[{name:"config_groups",val:": typing.Dict[str, typing.Union[ForwardRef('QuantizationScheme'), typing.List[str]]] = None"},{name:"format",val:": str = 'dense'"},{name:"quantization_status",val:": QuantizationStatus = 'initialized'"},{name:"kv_cache_scheme",val:": typing.Optional[ForwardRef('QuantizationArgs')] = None"},{name:"global_compression_ratio",val:": typing.Optional[float] = None"},{name:"ignore",val:": typing.Optional[typing.List[str]] = None"},{name:"sparsity_config",val:": typing.Dict[str, typing.Any] = None"},{name:"quant_method",val:": str = 'compressed-tensors'"},{name:"run_compressed",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CompressedTensorsConfig.config_groups",description:`<strong>config_groups</strong> (<code>typing.Dict[str, typing.Union[ForwardRef(&apos;QuantizationScheme&apos;), typing.List[str]]]</code>, <em>optional</em>) &#x2014;
dictionary mapping group name to a quantization scheme definition`,name:"config_groups"},{anchor:"transformers.CompressedTensorsConfig.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;dense&quot;</code>) &#x2014;
format the model is represented as. Set <code>run_compressed</code> True to execute model as the
compressed format if not <code>dense</code>`,name:"format"},{anchor:"transformers.CompressedTensorsConfig.quantization_status",description:`<strong>quantization_status</strong> (<code>QuantizationStatus</code>, <em>optional</em>, defaults to <code>&quot;initialized&quot;</code>) &#x2014;
status of model in the quantization lifecycle, ie &#x2018;initialized&#x2019;, &#x2018;calibration&#x2019;, &#x2018;frozen&#x2019;`,name:"quantization_status"},{anchor:"transformers.CompressedTensorsConfig.kv_cache_scheme",description:`<strong>kv_cache_scheme</strong> (<code>typing.Union[QuantizationArgs, NoneType]</code>, <em>optional</em>) &#x2014;
specifies quantization of the kv cache. If None, kv cache is not quantized.`,name:"kv_cache_scheme"},{anchor:"transformers.CompressedTensorsConfig.global_compression_ratio",description:`<strong>global_compression_ratio</strong> (<code>typing.Union[float, NoneType]</code>, <em>optional</em>) &#x2014;
0-1 float percentage of model compression`,name:"global_compression_ratio"},{anchor:"transformers.CompressedTensorsConfig.ignore",description:`<strong>ignore</strong> (<code>typing.Union[typing.List[str], NoneType]</code>, <em>optional</em>) &#x2014;
layer names or types to not quantize, supports regex prefixed by &#x2018;re:&#x2019;`,name:"ignore"},{anchor:"transformers.CompressedTensorsConfig.sparsity_config",description:`<strong>sparsity_config</strong> (<code>typing.Dict[str, typing.Any]</code>, <em>optional</em>) &#x2014;
configuration for sparsity compression`,name:"sparsity_config"},{anchor:"transformers.CompressedTensorsConfig.quant_method",description:`<strong>quant_method</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;compressed-tensors&quot;</code>) &#x2014;
do not override, should be compressed-tensors`,name:"quant_method"},{anchor:"transformers.CompressedTensorsConfig.run_compressed",description:`<strong>run_compressed</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; alter submodules (usually linear) in order to
emulate compressed model execution if True, otherwise use default submodule`,name:"run_compressed"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1219"}}),Gt=new b({props:{name:"from_dict",anchor:"transformers.CompressedTensorsConfig.from_dict",parameters:[{name:"config_dict",val:""},{name:"return_unused_kwargs",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CompressedTensorsConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the configuration object.`,name:"config_dict"},{anchor:"transformers.CompressedTensorsConfig.from_dict.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>,<em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a list of unused keyword arguments. Used for <code>from_pretrained</code> method in
<code>PreTrainedModel</code>.`,name:"return_unused_kwargs"},{anchor:"transformers.CompressedTensorsConfig.from_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>QuantizationConfigMixin</code></p>
`}}),Vt=new b({props:{name:"to_dict",anchor:"transformers.CompressedTensorsConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1321"}}),Bt=new b({props:{name:"to_diff_dict",anchor:"transformers.CompressedTensorsConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1341",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Jt=new z({props:{title:"TorchAoConfig",local:"transformers.TorchAoConfig",headingTag:"h2"}}),Nt=new b({props:{name:"class transformers.TorchAoConfig",anchor:"transformers.TorchAoConfig",parameters:[{name:"quant_type",val:": str"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TorchAoConfig.quant_type",description:`<strong>quant_type</strong> (<code>str</code>) &#x2014;
The type of quantization we want to use, currently supporting: <code>int4_weight_only</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code> and <code>autoquant</code>.`,name:"quant_type"},{anchor:"transformers.TorchAoConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The list of modules to not quantize, useful for quantizing models that explicitly require to have
some modules left in their original precision.`,name:"modules_to_not_convert"},{anchor:"transformers.TorchAoConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The keyword arguments for the chosen type of quantization, for example, int4_weight_only quantization supports two keyword arguments
<code>group_size</code> and <code>inner_k_tiles</code> currently. More API examples and documentation of arguments can be found in
<a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques" rel="nofollow">https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques</a>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1455"}}),He=new Wi({props:{anchor:"transformers.TorchAoConfig.example",$$slots:{default:[Zi]},$$scope:{ctx:on}}}),Et=new b({props:{name:"post_init",anchor:"transformers.TorchAoConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1513"}}),Wt=new b({props:{name:"to_dict",anchor:"transformers.TorchAoConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ut=new z({props:{title:"BitNetConfig",local:"transformers.BitNetConfig",headingTag:"h2"}}),Rt=new b({props:{name:"class transformers.BitNetConfig",anchor:"transformers.BitNetConfig",parameters:[{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1598"}}),Zt=new b({props:{name:"post_init",anchor:"transformers.BitNetConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1609"}}),St=new z({props:{title:"SpQRConfig",local:"transformers.SpQRConfig",headingTag:"h2"}}),Xt=new b({props:{name:"class transformers.SpQRConfig",anchor:"transformers.SpQRConfig",parameters:[{name:"bits",val:": int = 3"},{name:"beta1",val:": int = 16"},{name:"beta2",val:": int = 16"},{name:"shapes",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SpQRConfig.bits",description:`<strong>bits</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Specifies the bit count for the weights and first order zero-points and scales.
Currently only bits = 3 is supported.`,name:"bits"},{anchor:"transformers.SpQRConfig.beta1",description:`<strong>beta1</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
SpQR tile width. Currently only beta1 = 16 is supported.`,name:"beta1"},{anchor:"transformers.SpQRConfig.beta2",description:`<strong>beta2</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
SpQR tile height. Currently only beta2 = 16 is supported.`,name:"beta2"},{anchor:"transformers.SpQRConfig.shapes",description:`<strong>shapes</strong> (<code>Optional</code>, <em>optional</em>) &#x2014;
A dictionary holding the shape of each object. We need this because it&#x2019;s impossible
to deduce the exact size of the parameters just from bits, beta1, beta2.`,name:"shapes"},{anchor:"transformers.SpQRConfig.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>Optional[List[str]]</code>, <em>optional</em>) &#x2014;
Optionally, provides a list of full paths of <code>nn.Linear</code> weight parameters that shall not be quantized.
Defaults to None.`,name:"modules_to_not_convert"},{anchor:"transformers.SpQRConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1616"}}),Yt=new b({props:{name:"post_init",anchor:"transformers.SpQRConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1660"}}),Ot=new z({props:{title:"FineGrainedFP8Config",local:"transformers.FineGrainedFP8Config",headingTag:"h2"}}),Kt=new b({props:{name:"class transformers.FineGrainedFP8Config",anchor:"transformers.FineGrainedFP8Config",parameters:[{name:"activation_scheme",val:": str = 'dynamic'"},{name:"weight_block_size",val:": typing.Tuple[int, int] = (128, 128)"},{name:"modules_to_not_convert",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FineGrainedFP8Config.activation_scheme",description:`<strong>activation_scheme</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;dynamic&quot;</code>) &#x2014;
The scheme used for activation, the defaults and only support scheme for now is &#x201C;dynamic&#x201D;.`,name:"activation_scheme"},{anchor:"transformers.FineGrainedFP8Config.weight_block_size",description:`<strong>weight_block_size</strong> (<code>typing.Tuple[int, int]</code>, <em>optional</em>, defaults to <code>(128, 128)</code>) &#x2014;
The size of the weight blocks for quantization, default is (128, 128).`,name:"weight_block_size"},{anchor:"transformers.FineGrainedFP8Config.modules_to_not_convert",description:`<strong>modules_to_not_convert</strong> (<code>list</code>, <em>optional</em>) &#x2014;
A list of module names that should not be converted during quantization.`,name:"modules_to_not_convert"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1685"}}),en=new b({props:{name:"post_init",anchor:"transformers.FineGrainedFP8Config.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/quantization_config.py#L1712"}}),tn=new Ui({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/quantization.md"}}),{c(){$=a("meta"),J=n(),w=a("p"),H=n(),l(D.$$.fragment),x=n(),Q=a("p"),Q.textContent=Hs,yo=n(),Pe=a("p"),Pe.innerHTML=Ds,vo=n(),l(Y.$$.fragment),$o=n(),l(Fe.$$.fragment),qo=n(),A=a("div"),l(Ge.$$.fragment),Br=n(),rn=a("p"),rn.innerHTML=Qs,Jr=n(),O=a("div"),l(Ve.$$.fragment),Nr=n(),an=a("p"),an.textContent=As,xo=n(),l(Be.$$.fragment),zo=n(),I=a("div"),l(Je.$$.fragment),Er=n(),sn=a("p"),sn.innerHTML=Is,Wr=n(),K=a("div"),l(Ne.$$.fragment),Ur=n(),ln=a("p"),ln.textContent=js,wo=n(),l(Ee.$$.fragment),Co=n(),j=a("div"),l(We.$$.fragment),Rr=n(),dn=a("p"),dn.innerHTML=Ps,Zr=n(),ee=a("div"),l(Ue.$$.fragment),Sr=n(),mn=a("p"),mn.textContent=Fs,To=n(),l(Re.$$.fragment),ko=n(),P=a("div"),l(Ze.$$.fragment),Xr=n(),cn=a("p"),cn.innerHTML=Gs,Yr=n(),te=a("div"),l(Se.$$.fragment),Or=n(),pn=a("p"),pn.textContent=Vs,Mo=n(),l(Xe.$$.fragment),Lo=n(),F=a("div"),l(Ye.$$.fragment),Kr=n(),un=a("p"),un.innerHTML=Bs,ea=n(),ne=a("div"),l(Oe.$$.fragment),ta=n(),fn=a("p"),fn.textContent=Js,Ho=n(),l(Ke.$$.fragment),Do=n(),T=a("div"),l(et.$$.fragment),na=n(),gn=a("p"),gn.innerHTML=Ns,oa=n(),oe=a("div"),l(tt.$$.fragment),ra=n(),hn=a("p"),hn.textContent=Es,aa=n(),re=a("div"),l(nt.$$.fragment),sa=n(),_n=a("p"),_n.textContent=Ws,ia=n(),ae=a("div"),l(ot.$$.fragment),la=n(),bn=a("p"),bn.textContent=Us,Qo=n(),l(rt.$$.fragment),Ao=n(),q=a("div"),l(at.$$.fragment),da=n(),yn=a("p"),yn.innerHTML=Rs,ma=n(),vn=a("p"),vn.innerHTML=Zs,ca=n(),$n=a("p"),$n.innerHTML=Ss,pa=n(),se=a("div"),l(st.$$.fragment),ua=n(),qn=a("p"),qn.innerHTML=Xs,fa=n(),ie=a("div"),l(it.$$.fragment),ga=n(),xn=a("p"),xn.textContent=Ys,ha=n(),le=a("div"),l(lt.$$.fragment),_a=n(),zn=a("p"),zn.innerHTML=Os,ba=n(),de=a("div"),l(dt.$$.fragment),ya=n(),wn=a("p"),wn.textContent=Ks,Io=n(),l(mt.$$.fragment),jo=n(),y=a("div"),l(ct.$$.fragment),va=n(),Cn=a("p"),Cn.textContent=ei,$a=n(),Tn=a("p"),Tn.innerHTML=ti,qa=n(),me=a("div"),l(pt.$$.fragment),xa=n(),kn=a("p"),kn.textContent=ni,za=n(),ce=a("div"),l(ut.$$.fragment),wa=n(),Mn=a("p"),Mn.innerHTML=oi,Ca=n(),pe=a("div"),l(ft.$$.fragment),Ta=n(),Ln=a("p"),Ln.textContent=ri,ka=n(),ue=a("div"),l(gt.$$.fragment),Ma=n(),Hn=a("p"),Hn.textContent=ai,La=n(),fe=a("div"),l(ht.$$.fragment),Ha=n(),Dn=a("p"),Dn.textContent=si,Da=n(),ge=a("div"),l(_t.$$.fragment),Qa=n(),Qn=a("p"),Qn.innerHTML=ii,Aa=n(),he=a("div"),l(bt.$$.fragment),Ia=n(),An=a("p"),An.innerHTML=li,ja=n(),_e=a("div"),l(yt.$$.fragment),Pa=n(),In=a("p"),In.innerHTML=di,Fa=n(),be=a("div"),l(vt.$$.fragment),Ga=n(),jn=a("p"),jn.innerHTML=mi,Va=n(),ye=a("div"),l($t.$$.fragment),Ba=n(),Pn=a("p"),Pn.innerHTML=ci,Ja=n(),ve=a("div"),l(qt.$$.fragment),Na=n(),Fn=a("p"),Fn.innerHTML=pi,Ea=n(),$e=a("div"),l(xt.$$.fragment),Wa=n(),Gn=a("p"),Gn.innerHTML=ui,Ua=n(),qe=a("div"),l(zt.$$.fragment),Ra=n(),Vn=a("p"),Vn.textContent=fi,Za=n(),xe=a("div"),l(wt.$$.fragment),Sa=n(),Bn=a("p"),Bn.innerHTML=gi,Xa=n(),ze=a("div"),l(Ct.$$.fragment),Ya=n(),Jn=a("p"),Jn.innerHTML=hi,Po=n(),l(Tt.$$.fragment),Fo=n(),G=a("div"),l(kt.$$.fragment),Oa=n(),Nn=a("p"),Nn.textContent=_i,Ka=n(),we=a("div"),l(Mt.$$.fragment),es=n(),En=a("p"),En.textContent=bi,Go=n(),l(Lt.$$.fragment),Vo=n(),k=a("div"),l(Ht.$$.fragment),ts=n(),Wn=a("p"),Wn.textContent=yi,ns=n(),Ce=a("div"),l(Dt.$$.fragment),os=n(),Un=a("p"),Un.textContent=vi,rs=n(),Te=a("div"),l(Qt.$$.fragment),as=n(),Rn=a("p"),Rn.textContent=$i,ss=n(),ke=a("div"),l(At.$$.fragment),is=n(),Zn=a("p"),Zn.textContent=qi,Bo=n(),l(It.$$.fragment),Jo=n(),Z=a("div"),l(jt.$$.fragment),ls=n(),Sn=a("p"),Sn.textContent=xi,No=n(),l(Pt.$$.fragment),Eo=n(),M=a("div"),l(Ft.$$.fragment),ds=n(),Xn=a("p"),Xn.innerHTML=zi,ms=n(),Me=a("div"),l(Gt.$$.fragment),cs=n(),Yn=a("p"),Yn.innerHTML=wi,ps=n(),N=a("div"),l(Vt.$$.fragment),us=n(),On=a("p"),On.textContent=Ci,fs=n(),Kn=a("p"),Kn.innerHTML=Ti,gs=n(),Le=a("div"),l(Bt.$$.fragment),hs=n(),eo=a("p"),eo.textContent=ki,Wo=n(),l(Jt.$$.fragment),Uo=n(),L=a("div"),l(Nt.$$.fragment),_s=n(),to=a("p"),to.textContent=Mi,bs=n(),l(He.$$.fragment),ys=n(),De=a("div"),l(Et.$$.fragment),vs=n(),no=a("p"),no.textContent=Li,$s=n(),Qe=a("div"),l(Wt.$$.fragment),qs=n(),oo=a("p"),oo.innerHTML=Hi,Ro=n(),l(Ut.$$.fragment),Zo=n(),S=a("div"),l(Rt.$$.fragment),xs=n(),Ae=a("div"),l(Zt.$$.fragment),zs=n(),ro=a("p"),ro.textContent=Di,So=n(),l(St.$$.fragment),Xo=n(),V=a("div"),l(Xt.$$.fragment),ws=n(),ao=a("p"),ao.innerHTML=Qi,Cs=n(),Ie=a("div"),l(Yt.$$.fragment),Ts=n(),so=a("p"),so.textContent=Ai,Yo=n(),l(Ot.$$.fragment),Oo=n(),B=a("div"),l(Kt.$$.fragment),ks=n(),io=a("p"),io.textContent=Ii,Ms=n(),je=a("div"),l(en.$$.fragment),Ls=n(),lo=a("p"),lo.textContent=ji,Ko=n(),l(tn.$$.fragment),er=n(),bo=a("p"),this.h()},l(e){const i=Ji("svelte-u9bgzb",document.head);$=s(i,"META",{name:!0,content:!0}),i.forEach(r),J=o(e),w=s(e,"P",{}),h(w).forEach(r),H=o(e),d(D.$$.fragment,e),x=o(e),Q=s(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1hsjm7z"&&(Q.textContent=Hs),yo=o(e),Pe=s(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-bnel0f"&&(Pe.innerHTML=Ds),vo=o(e),d(Y.$$.fragment,e),$o=o(e),d(Fe.$$.fragment,e),qo=o(e),A=s(e,"DIV",{class:!0});var X=h(A);d(Ge.$$.fragment,X),Br=o(X),rn=s(X,"P",{"data-svelte-h":!0}),f(rn)!=="svelte-b8v0f"&&(rn.innerHTML=Qs),Jr=o(X),O=s(X,"DIV",{class:!0});var nn=h(O);d(Ve.$$.fragment,nn),Nr=o(nn),an=s(nn,"P",{"data-svelte-h":!0}),f(an)!=="svelte-1ozftb6"&&(an.textContent=As),nn.forEach(r),X.forEach(r),xo=o(e),d(Be.$$.fragment,e),zo=o(e),I=s(e,"DIV",{class:!0});var mo=h(I);d(Je.$$.fragment,mo),Er=o(mo),sn=s(mo,"P",{"data-svelte-h":!0}),f(sn)!=="svelte-1s7ccdx"&&(sn.innerHTML=Is),Wr=o(mo),K=s(mo,"DIV",{class:!0});var nr=h(K);d(Ne.$$.fragment,nr),Ur=o(nr),ln=s(nr,"P",{"data-svelte-h":!0}),f(ln)!=="svelte-gy26u4"&&(ln.textContent=js),nr.forEach(r),mo.forEach(r),wo=o(e),d(Ee.$$.fragment,e),Co=o(e),j=s(e,"DIV",{class:!0});var co=h(j);d(We.$$.fragment,co),Rr=o(co),dn=s(co,"P",{"data-svelte-h":!0}),f(dn)!=="svelte-w1pax1"&&(dn.innerHTML=Ps),Zr=o(co),ee=s(co,"DIV",{class:!0});var or=h(ee);d(Ue.$$.fragment,or),Sr=o(or),mn=s(or,"P",{"data-svelte-h":!0}),f(mn)!=="svelte-1ozftb6"&&(mn.textContent=Fs),or.forEach(r),co.forEach(r),To=o(e),d(Re.$$.fragment,e),ko=o(e),P=s(e,"DIV",{class:!0});var po=h(P);d(Ze.$$.fragment,po),Xr=o(po),cn=s(po,"P",{"data-svelte-h":!0}),f(cn)!=="svelte-1i667it"&&(cn.innerHTML=Gs),Yr=o(po),te=s(po,"DIV",{class:!0});var rr=h(te);d(Se.$$.fragment,rr),Or=o(rr),pn=s(rr,"P",{"data-svelte-h":!0}),f(pn)!=="svelte-1ozftb6"&&(pn.textContent=Vs),rr.forEach(r),po.forEach(r),Mo=o(e),d(Xe.$$.fragment,e),Lo=o(e),F=s(e,"DIV",{class:!0});var uo=h(F);d(Ye.$$.fragment,uo),Kr=o(uo),un=s(uo,"P",{"data-svelte-h":!0}),f(un)!=="svelte-438k9a"&&(un.innerHTML=Bs),ea=o(uo),ne=s(uo,"DIV",{class:!0});var ar=h(ne);d(Oe.$$.fragment,ar),ta=o(ar),fn=s(ar,"P",{"data-svelte-h":!0}),f(fn)!=="svelte-1ozftb6"&&(fn.textContent=Js),ar.forEach(r),uo.forEach(r),Ho=o(e),d(Ke.$$.fragment,e),Do=o(e),T=s(e,"DIV",{class:!0});var E=h(T);d(et.$$.fragment,E),na=o(E),gn=s(E,"P",{"data-svelte-h":!0}),f(gn)!=="svelte-i3efvr"&&(gn.innerHTML=Ns),oa=o(E),oe=s(E,"DIV",{class:!0});var sr=h(oe);d(tt.$$.fragment,sr),ra=o(sr),hn=s(sr,"P",{"data-svelte-h":!0}),f(hn)!=="svelte-4jdj2l"&&(hn.textContent=Es),sr.forEach(r),aa=o(E),re=s(E,"DIV",{class:!0});var ir=h(re);d(nt.$$.fragment,ir),sa=o(ir),_n=s(ir,"P",{"data-svelte-h":!0}),f(_n)!=="svelte-1ozftb6"&&(_n.textContent=Ws),ir.forEach(r),ia=o(E),ae=s(E,"DIV",{class:!0});var lr=h(ae);d(ot.$$.fragment,lr),la=o(lr),bn=s(lr,"P",{"data-svelte-h":!0}),f(bn)!=="svelte-pjgtd6"&&(bn.textContent=Us),lr.forEach(r),E.forEach(r),Qo=o(e),d(rt.$$.fragment,e),Ao=o(e),q=s(e,"DIV",{class:!0});var C=h(q);d(at.$$.fragment,C),da=o(C),yn=s(C,"P",{"data-svelte-h":!0}),f(yn)!=="svelte-woamwr"&&(yn.innerHTML=Rs),ma=o(C),vn=s(C,"P",{"data-svelte-h":!0}),f(vn)!=="svelte-ki5gis"&&(vn.innerHTML=Zs),ca=o(C),$n=s(C,"P",{"data-svelte-h":!0}),f($n)!=="svelte-8qsk2q"&&($n.innerHTML=Ss),pa=o(C),se=s(C,"DIV",{class:!0});var dr=h(se);d(st.$$.fragment,dr),ua=o(dr),qn=s(dr,"P",{"data-svelte-h":!0}),f(qn)!=="svelte-10tvzyv"&&(qn.innerHTML=Xs),dr.forEach(r),fa=o(C),ie=s(C,"DIV",{class:!0});var mr=h(ie);d(it.$$.fragment,mr),ga=o(mr),xn=s(mr,"P",{"data-svelte-h":!0}),f(xn)!=="svelte-gy26u4"&&(xn.textContent=Ys),mr.forEach(r),ha=o(C),le=s(C,"DIV",{class:!0});var cr=h(le);d(lt.$$.fragment,cr),_a=o(cr),zn=s(cr,"P",{"data-svelte-h":!0}),f(zn)!=="svelte-19bn0da"&&(zn.innerHTML=Os),cr.forEach(r),ba=o(C),de=s(C,"DIV",{class:!0});var pr=h(de);d(dt.$$.fragment,pr),ya=o(pr),wn=s(pr,"P",{"data-svelte-h":!0}),f(wn)!=="svelte-1p6bdas"&&(wn.textContent=Ks),pr.forEach(r),C.forEach(r),Io=o(e),d(mt.$$.fragment,e),jo=o(e),y=s(e,"DIV",{class:!0});var v=h(y);d(ct.$$.fragment,v),va=o(v),Cn=s(v,"P",{"data-svelte-h":!0}),f(Cn)!=="svelte-1xvcahi"&&(Cn.textContent=ei),$a=o(v),Tn=s(v,"P",{"data-svelte-h":!0}),f(Tn)!=="svelte-twdedh"&&(Tn.innerHTML=ti),qa=o(v),me=s(v,"DIV",{class:!0});var ur=h(me);d(pt.$$.fragment,ur),xa=o(ur),kn=s(ur,"P",{"data-svelte-h":!0}),f(kn)!=="svelte-1d4i4z7"&&(kn.textContent=ni),ur.forEach(r),za=o(v),ce=s(v,"DIV",{class:!0});var fr=h(ce);d(ut.$$.fragment,fr),wa=o(fr),Mn=s(fr,"P",{"data-svelte-h":!0}),f(Mn)!=="svelte-4t526i"&&(Mn.innerHTML=oi),fr.forEach(r),Ca=o(v),pe=s(v,"DIV",{class:!0});var gr=h(pe);d(ft.$$.fragment,gr),Ta=o(gr),Ln=s(gr,"P",{"data-svelte-h":!0}),f(Ln)!=="svelte-1meey31"&&(Ln.textContent=ri),gr.forEach(r),ka=o(v),ue=s(v,"DIV",{class:!0});var hr=h(ue);d(gt.$$.fragment,hr),Ma=o(hr),Hn=s(hr,"P",{"data-svelte-h":!0}),f(Hn)!=="svelte-1j1vsi1"&&(Hn.textContent=ai),hr.forEach(r),La=o(v),fe=s(v,"DIV",{class:!0});var _r=h(fe);d(ht.$$.fragment,_r),Ha=o(_r),Dn=s(_r,"P",{"data-svelte-h":!0}),f(Dn)!=="svelte-1qo65te"&&(Dn.textContent=si),_r.forEach(r),Da=o(v),ge=s(v,"DIV",{class:!0});var br=h(ge);d(_t.$$.fragment,br),Qa=o(br),Qn=s(br,"P",{"data-svelte-h":!0}),f(Qn)!=="svelte-i8h8td"&&(Qn.innerHTML=ii),br.forEach(r),Aa=o(v),he=s(v,"DIV",{class:!0});var yr=h(he);d(bt.$$.fragment,yr),Ia=o(yr),An=s(yr,"P",{"data-svelte-h":!0}),f(An)!=="svelte-1uznum5"&&(An.innerHTML=li),yr.forEach(r),ja=o(v),_e=s(v,"DIV",{class:!0});var vr=h(_e);d(yt.$$.fragment,vr),Pa=o(vr),In=s(vr,"P",{"data-svelte-h":!0}),f(In)!=="svelte-mjhdcv"&&(In.innerHTML=di),vr.forEach(r),Fa=o(v),be=s(v,"DIV",{class:!0});var $r=h(be);d(vt.$$.fragment,$r),Ga=o($r),jn=s($r,"P",{"data-svelte-h":!0}),f(jn)!=="svelte-1e5epn5"&&(jn.innerHTML=mi),$r.forEach(r),Va=o(v),ye=s(v,"DIV",{class:!0});var qr=h(ye);d($t.$$.fragment,qr),Ba=o(qr),Pn=s(qr,"P",{"data-svelte-h":!0}),f(Pn)!=="svelte-1idnt2e"&&(Pn.innerHTML=ci),qr.forEach(r),Ja=o(v),ve=s(v,"DIV",{class:!0});var xr=h(ve);d(qt.$$.fragment,xr),Na=o(xr),Fn=s(xr,"P",{"data-svelte-h":!0}),f(Fn)!=="svelte-13hqoy0"&&(Fn.innerHTML=pi),xr.forEach(r),Ea=o(v),$e=s(v,"DIV",{class:!0});var zr=h($e);d(xt.$$.fragment,zr),Wa=o(zr),Gn=s(zr,"P",{"data-svelte-h":!0}),f(Gn)!=="svelte-jj28f7"&&(Gn.innerHTML=ui),zr.forEach(r),Ua=o(v),qe=s(v,"DIV",{class:!0});var wr=h(qe);d(zt.$$.fragment,wr),Ra=o(wr),Vn=s(wr,"P",{"data-svelte-h":!0}),f(Vn)!=="svelte-1kpdm09"&&(Vn.textContent=fi),wr.forEach(r),Za=o(v),xe=s(v,"DIV",{class:!0});var Cr=h(xe);d(wt.$$.fragment,Cr),Sa=o(Cr),Bn=s(Cr,"P",{"data-svelte-h":!0}),f(Bn)!=="svelte-o8fcb9"&&(Bn.innerHTML=gi),Cr.forEach(r),Xa=o(v),ze=s(v,"DIV",{class:!0});var Tr=h(ze);d(Ct.$$.fragment,Tr),Ya=o(Tr),Jn=s(Tr,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-1lxocan"&&(Jn.innerHTML=hi),Tr.forEach(r),v.forEach(r),Po=o(e),d(Tt.$$.fragment,e),Fo=o(e),G=s(e,"DIV",{class:!0});var fo=h(G);d(kt.$$.fragment,fo),Oa=o(fo),Nn=s(fo,"P",{"data-svelte-h":!0}),f(Nn)!=="svelte-i9o5pz"&&(Nn.textContent=_i),Ka=o(fo),we=s(fo,"DIV",{class:!0});var kr=h(we);d(Mt.$$.fragment,kr),es=o(kr),En=s(kr,"P",{"data-svelte-h":!0}),f(En)!=="svelte-gy26u4"&&(En.textContent=bi),kr.forEach(r),fo.forEach(r),Go=o(e),d(Lt.$$.fragment,e),Vo=o(e),k=s(e,"DIV",{class:!0});var W=h(k);d(Ht.$$.fragment,W),ts=o(W),Wn=s(W,"P",{"data-svelte-h":!0}),f(Wn)!=="svelte-h0fjpw"&&(Wn.textContent=yi),ns=o(W),Ce=s(W,"DIV",{class:!0});var Mr=h(Ce);d(Dt.$$.fragment,Mr),os=o(Mr),Un=s(Mr,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-6lcv9o"&&(Un.textContent=vi),Mr.forEach(r),rs=o(W),Te=s(W,"DIV",{class:!0});var Lr=h(Te);d(Qt.$$.fragment,Lr),as=o(Lr),Rn=s(Lr,"P",{"data-svelte-h":!0}),f(Rn)!=="svelte-gy26u4"&&(Rn.textContent=$i),Lr.forEach(r),ss=o(W),ke=s(W,"DIV",{class:!0});var Hr=h(ke);d(At.$$.fragment,Hr),is=o(Hr),Zn=s(Hr,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-1p6bdas"&&(Zn.textContent=qi),Hr.forEach(r),W.forEach(r),Bo=o(e),d(It.$$.fragment,e),Jo=o(e),Z=s(e,"DIV",{class:!0});var Dr=h(Z);d(jt.$$.fragment,Dr),ls=o(Dr),Sn=s(Dr,"P",{"data-svelte-h":!0}),f(Sn)!=="svelte-1a51md3"&&(Sn.textContent=xi),Dr.forEach(r),No=o(e),d(Pt.$$.fragment,e),Eo=o(e),M=s(e,"DIV",{class:!0});var U=h(M);d(Ft.$$.fragment,U),ds=o(U),Xn=s(U,"P",{"data-svelte-h":!0}),f(Xn)!=="svelte-3h2fkj"&&(Xn.innerHTML=zi),ms=o(U),Me=s(U,"DIV",{class:!0});var Qr=h(Me);d(Gt.$$.fragment,Qr),cs=o(Qr),Yn=s(Qr,"P",{"data-svelte-h":!0}),f(Yn)!=="svelte-1sqc0ks"&&(Yn.innerHTML=wi),Qr.forEach(r),ps=o(U),N=s(U,"DIV",{class:!0});var go=h(N);d(Vt.$$.fragment,go),us=o(go),On=s(go,"P",{"data-svelte-h":!0}),f(On)!=="svelte-1h5q4kg"&&(On.textContent=Ci),fs=o(go),Kn=s(go,"P",{"data-svelte-h":!0}),f(Kn)!=="svelte-4kfdpu"&&(Kn.innerHTML=Ti),go.forEach(r),gs=o(U),Le=s(U,"DIV",{class:!0});var Ar=h(Le);d(Bt.$$.fragment,Ar),hs=o(Ar),eo=s(Ar,"P",{"data-svelte-h":!0}),f(eo)!=="svelte-1p6bdas"&&(eo.textContent=ki),Ar.forEach(r),U.forEach(r),Wo=o(e),d(Jt.$$.fragment,e),Uo=o(e),L=s(e,"DIV",{class:!0});var R=h(L);d(Nt.$$.fragment,R),_s=o(R),to=s(R,"P",{"data-svelte-h":!0}),f(to)!=="svelte-1pwo8e0"&&(to.textContent=Mi),bs=o(R),d(He.$$.fragment,R),ys=o(R),De=s(R,"DIV",{class:!0});var Ir=h(De);d(Et.$$.fragment,Ir),vs=o(Ir),no=s(Ir,"P",{"data-svelte-h":!0}),f(no)!=="svelte-gy26u4"&&(no.textContent=Li),Ir.forEach(r),$s=o(R),Qe=s(R,"DIV",{class:!0});var jr=h(Qe);d(Wt.$$.fragment,jr),qs=o(jr),oo=s(jr,"P",{"data-svelte-h":!0}),f(oo)!=="svelte-kbcfzp"&&(oo.innerHTML=Hi),jr.forEach(r),R.forEach(r),Ro=o(e),d(Ut.$$.fragment,e),Zo=o(e),S=s(e,"DIV",{class:!0});var Pr=h(S);d(Rt.$$.fragment,Pr),xs=o(Pr),Ae=s(Pr,"DIV",{class:!0});var Fr=h(Ae);d(Zt.$$.fragment,Fr),zs=o(Fr),ro=s(Fr,"P",{"data-svelte-h":!0}),f(ro)!=="svelte-1ozftb6"&&(ro.textContent=Di),Fr.forEach(r),Pr.forEach(r),So=o(e),d(St.$$.fragment,e),Xo=o(e),V=s(e,"DIV",{class:!0});var ho=h(V);d(Xt.$$.fragment,ho),ws=o(ho),ao=s(ho,"P",{"data-svelte-h":!0}),f(ao)!=="svelte-1sf4vkr"&&(ao.innerHTML=Qi),Cs=o(ho),Ie=s(ho,"DIV",{class:!0});var Gr=h(Ie);d(Yt.$$.fragment,Gr),Ts=o(Gr),so=s(Gr,"P",{"data-svelte-h":!0}),f(so)!=="svelte-gy26u4"&&(so.textContent=Ai),Gr.forEach(r),ho.forEach(r),Yo=o(e),d(Ot.$$.fragment,e),Oo=o(e),B=s(e,"DIV",{class:!0});var _o=h(B);d(Kt.$$.fragment,_o),ks=o(_o),io=s(_o,"P",{"data-svelte-h":!0}),f(io)!=="svelte-1inuoy"&&(io.textContent=Ii),Ms=o(_o),je=s(_o,"DIV",{class:!0});var Vr=h(je);d(en.$$.fragment,Vr),Ls=o(Vr),lo=s(Vr,"P",{"data-svelte-h":!0}),f(lo)!=="svelte-1ozftb6"&&(lo.textContent=ji),Vr.forEach(r),_o.forEach(r),Ko=o(e),d(tn.$$.fragment,e),er=o(e),bo=s(e,"P",{}),h(bo).forEach(r),this.h()},h(){_($,"name","hf:doc:metadata"),_($,"content",Xi),_(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,$),g(e,J,i),g(e,w,i),g(e,H,i),m(D,e,i),g(e,x,i),g(e,Q,i),g(e,yo,i),g(e,Pe,i),g(e,vo,i),m(Y,e,i),g(e,$o,i),m(Fe,e,i),g(e,qo,i),g(e,A,i),m(Ge,A,null),t(A,Br),t(A,rn),t(A,Jr),t(A,O),m(Ve,O,null),t(O,Nr),t(O,an),g(e,xo,i),m(Be,e,i),g(e,zo,i),g(e,I,i),m(Je,I,null),t(I,Er),t(I,sn),t(I,Wr),t(I,K),m(Ne,K,null),t(K,Ur),t(K,ln),g(e,wo,i),m(Ee,e,i),g(e,Co,i),g(e,j,i),m(We,j,null),t(j,Rr),t(j,dn),t(j,Zr),t(j,ee),m(Ue,ee,null),t(ee,Sr),t(ee,mn),g(e,To,i),m(Re,e,i),g(e,ko,i),g(e,P,i),m(Ze,P,null),t(P,Xr),t(P,cn),t(P,Yr),t(P,te),m(Se,te,null),t(te,Or),t(te,pn),g(e,Mo,i),m(Xe,e,i),g(e,Lo,i),g(e,F,i),m(Ye,F,null),t(F,Kr),t(F,un),t(F,ea),t(F,ne),m(Oe,ne,null),t(ne,ta),t(ne,fn),g(e,Ho,i),m(Ke,e,i),g(e,Do,i),g(e,T,i),m(et,T,null),t(T,na),t(T,gn),t(T,oa),t(T,oe),m(tt,oe,null),t(oe,ra),t(oe,hn),t(T,aa),t(T,re),m(nt,re,null),t(re,sa),t(re,_n),t(T,ia),t(T,ae),m(ot,ae,null),t(ae,la),t(ae,bn),g(e,Qo,i),m(rt,e,i),g(e,Ao,i),g(e,q,i),m(at,q,null),t(q,da),t(q,yn),t(q,ma),t(q,vn),t(q,ca),t(q,$n),t(q,pa),t(q,se),m(st,se,null),t(se,ua),t(se,qn),t(q,fa),t(q,ie),m(it,ie,null),t(ie,ga),t(ie,xn),t(q,ha),t(q,le),m(lt,le,null),t(le,_a),t(le,zn),t(q,ba),t(q,de),m(dt,de,null),t(de,ya),t(de,wn),g(e,Io,i),m(mt,e,i),g(e,jo,i),g(e,y,i),m(ct,y,null),t(y,va),t(y,Cn),t(y,$a),t(y,Tn),t(y,qa),t(y,me),m(pt,me,null),t(me,xa),t(me,kn),t(y,za),t(y,ce),m(ut,ce,null),t(ce,wa),t(ce,Mn),t(y,Ca),t(y,pe),m(ft,pe,null),t(pe,Ta),t(pe,Ln),t(y,ka),t(y,ue),m(gt,ue,null),t(ue,Ma),t(ue,Hn),t(y,La),t(y,fe),m(ht,fe,null),t(fe,Ha),t(fe,Dn),t(y,Da),t(y,ge),m(_t,ge,null),t(ge,Qa),t(ge,Qn),t(y,Aa),t(y,he),m(bt,he,null),t(he,Ia),t(he,An),t(y,ja),t(y,_e),m(yt,_e,null),t(_e,Pa),t(_e,In),t(y,Fa),t(y,be),m(vt,be,null),t(be,Ga),t(be,jn),t(y,Va),t(y,ye),m($t,ye,null),t(ye,Ba),t(ye,Pn),t(y,Ja),t(y,ve),m(qt,ve,null),t(ve,Na),t(ve,Fn),t(y,Ea),t(y,$e),m(xt,$e,null),t($e,Wa),t($e,Gn),t(y,Ua),t(y,qe),m(zt,qe,null),t(qe,Ra),t(qe,Vn),t(y,Za),t(y,xe),m(wt,xe,null),t(xe,Sa),t(xe,Bn),t(y,Xa),t(y,ze),m(Ct,ze,null),t(ze,Ya),t(ze,Jn),g(e,Po,i),m(Tt,e,i),g(e,Fo,i),g(e,G,i),m(kt,G,null),t(G,Oa),t(G,Nn),t(G,Ka),t(G,we),m(Mt,we,null),t(we,es),t(we,En),g(e,Go,i),m(Lt,e,i),g(e,Vo,i),g(e,k,i),m(Ht,k,null),t(k,ts),t(k,Wn),t(k,ns),t(k,Ce),m(Dt,Ce,null),t(Ce,os),t(Ce,Un),t(k,rs),t(k,Te),m(Qt,Te,null),t(Te,as),t(Te,Rn),t(k,ss),t(k,ke),m(At,ke,null),t(ke,is),t(ke,Zn),g(e,Bo,i),m(It,e,i),g(e,Jo,i),g(e,Z,i),m(jt,Z,null),t(Z,ls),t(Z,Sn),g(e,No,i),m(Pt,e,i),g(e,Eo,i),g(e,M,i),m(Ft,M,null),t(M,ds),t(M,Xn),t(M,ms),t(M,Me),m(Gt,Me,null),t(Me,cs),t(Me,Yn),t(M,ps),t(M,N),m(Vt,N,null),t(N,us),t(N,On),t(N,fs),t(N,Kn),t(M,gs),t(M,Le),m(Bt,Le,null),t(Le,hs),t(Le,eo),g(e,Wo,i),m(Jt,e,i),g(e,Uo,i),g(e,L,i),m(Nt,L,null),t(L,_s),t(L,to),t(L,bs),m(He,L,null),t(L,ys),t(L,De),m(Et,De,null),t(De,vs),t(De,no),t(L,$s),t(L,Qe),m(Wt,Qe,null),t(Qe,qs),t(Qe,oo),g(e,Ro,i),m(Ut,e,i),g(e,Zo,i),g(e,S,i),m(Rt,S,null),t(S,xs),t(S,Ae),m(Zt,Ae,null),t(Ae,zs),t(Ae,ro),g(e,So,i),m(St,e,i),g(e,Xo,i),g(e,V,i),m(Xt,V,null),t(V,ws),t(V,ao),t(V,Cs),t(V,Ie),m(Yt,Ie,null),t(Ie,Ts),t(Ie,so),g(e,Yo,i),m(Ot,e,i),g(e,Oo,i),g(e,B,i),m(Kt,B,null),t(B,ks),t(B,io),t(B,Ms),t(B,je),m(en,je,null),t(je,Ls),t(je,lo),g(e,Ko,i),m(tn,e,i),g(e,er,i),g(e,bo,i),tr=!0},p(e,[i]){const X={};i&2&&(X.$$scope={dirty:i,ctx:e}),Y.$set(X);const nn={};i&2&&(nn.$$scope={dirty:i,ctx:e}),He.$set(nn)},i(e){tr||(c(D.$$.fragment,e),c(Y.$$.fragment,e),c(Fe.$$.fragment,e),c(Ge.$$.fragment,e),c(Ve.$$.fragment,e),c(Be.$$.fragment,e),c(Je.$$.fragment,e),c(Ne.$$.fragment,e),c(Ee.$$.fragment,e),c(We.$$.fragment,e),c(Ue.$$.fragment,e),c(Re.$$.fragment,e),c(Ze.$$.fragment,e),c(Se.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(Oe.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(ot.$$.fragment,e),c(rt.$$.fragment,e),c(at.$$.fragment,e),c(st.$$.fragment,e),c(it.$$.fragment,e),c(lt.$$.fragment,e),c(dt.$$.fragment,e),c(mt.$$.fragment,e),c(ct.$$.fragment,e),c(pt.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(gt.$$.fragment,e),c(ht.$$.fragment,e),c(_t.$$.fragment,e),c(bt.$$.fragment,e),c(yt.$$.fragment,e),c(vt.$$.fragment,e),c($t.$$.fragment,e),c(qt.$$.fragment,e),c(xt.$$.fragment,e),c(zt.$$.fragment,e),c(wt.$$.fragment,e),c(Ct.$$.fragment,e),c(Tt.$$.fragment,e),c(kt.$$.fragment,e),c(Mt.$$.fragment,e),c(Lt.$$.fragment,e),c(Ht.$$.fragment,e),c(Dt.$$.fragment,e),c(Qt.$$.fragment,e),c(At.$$.fragment,e),c(It.$$.fragment,e),c(jt.$$.fragment,e),c(Pt.$$.fragment,e),c(Ft.$$.fragment,e),c(Gt.$$.fragment,e),c(Vt.$$.fragment,e),c(Bt.$$.fragment,e),c(Jt.$$.fragment,e),c(Nt.$$.fragment,e),c(He.$$.fragment,e),c(Et.$$.fragment,e),c(Wt.$$.fragment,e),c(Ut.$$.fragment,e),c(Rt.$$.fragment,e),c(Zt.$$.fragment,e),c(St.$$.fragment,e),c(Xt.$$.fragment,e),c(Yt.$$.fragment,e),c(Ot.$$.fragment,e),c(Kt.$$.fragment,e),c(en.$$.fragment,e),c(tn.$$.fragment,e),tr=!0)},o(e){p(D.$$.fragment,e),p(Y.$$.fragment,e),p(Fe.$$.fragment,e),p(Ge.$$.fragment,e),p(Ve.$$.fragment,e),p(Be.$$.fragment,e),p(Je.$$.fragment,e),p(Ne.$$.fragment,e),p(Ee.$$.fragment,e),p(We.$$.fragment,e),p(Ue.$$.fragment,e),p(Re.$$.fragment,e),p(Ze.$$.fragment,e),p(Se.$$.fragment,e),p(Xe.$$.fragment,e),p(Ye.$$.fragment,e),p(Oe.$$.fragment,e),p(Ke.$$.fragment,e),p(et.$$.fragment,e),p(tt.$$.fragment,e),p(nt.$$.fragment,e),p(ot.$$.fragment,e),p(rt.$$.fragment,e),p(at.$$.fragment,e),p(st.$$.fragment,e),p(it.$$.fragment,e),p(lt.$$.fragment,e),p(dt.$$.fragment,e),p(mt.$$.fragment,e),p(ct.$$.fragment,e),p(pt.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(gt.$$.fragment,e),p(ht.$$.fragment,e),p(_t.$$.fragment,e),p(bt.$$.fragment,e),p(yt.$$.fragment,e),p(vt.$$.fragment,e),p($t.$$.fragment,e),p(qt.$$.fragment,e),p(xt.$$.fragment,e),p(zt.$$.fragment,e),p(wt.$$.fragment,e),p(Ct.$$.fragment,e),p(Tt.$$.fragment,e),p(kt.$$.fragment,e),p(Mt.$$.fragment,e),p(Lt.$$.fragment,e),p(Ht.$$.fragment,e),p(Dt.$$.fragment,e),p(Qt.$$.fragment,e),p(At.$$.fragment,e),p(It.$$.fragment,e),p(jt.$$.fragment,e),p(Pt.$$.fragment,e),p(Ft.$$.fragment,e),p(Gt.$$.fragment,e),p(Vt.$$.fragment,e),p(Bt.$$.fragment,e),p(Jt.$$.fragment,e),p(Nt.$$.fragment,e),p(He.$$.fragment,e),p(Et.$$.fragment,e),p(Wt.$$.fragment,e),p(Ut.$$.fragment,e),p(Rt.$$.fragment,e),p(Zt.$$.fragment,e),p(St.$$.fragment,e),p(Xt.$$.fragment,e),p(Yt.$$.fragment,e),p(Ot.$$.fragment,e),p(Kt.$$.fragment,e),p(en.$$.fragment,e),p(tn.$$.fragment,e),tr=!1},d(e){e&&(r(J),r(w),r(H),r(x),r(Q),r(yo),r(Pe),r(vo),r($o),r(qo),r(A),r(xo),r(zo),r(I),r(wo),r(Co),r(j),r(To),r(ko),r(P),r(Mo),r(Lo),r(F),r(Ho),r(Do),r(T),r(Qo),r(Ao),r(q),r(Io),r(jo),r(y),r(Po),r(Fo),r(G),r(Go),r(Vo),r(k),r(Bo),r(Jo),r(Z),r(No),r(Eo),r(M),r(Wo),r(Uo),r(L),r(Ro),r(Zo),r(S),r(So),r(Xo),r(V),r(Yo),r(Oo),r(B),r(Ko),r(er),r(bo)),r($),u(D,e),u(Y,e),u(Fe,e),u(Ge),u(Ve),u(Be,e),u(Je),u(Ne),u(Ee,e),u(We),u(Ue),u(Re,e),u(Ze),u(Se),u(Xe,e),u(Ye),u(Oe),u(Ke,e),u(et),u(tt),u(nt),u(ot),u(rt,e),u(at),u(st),u(it),u(lt),u(dt),u(mt,e),u(ct),u(pt),u(ut),u(ft),u(gt),u(ht),u(_t),u(bt),u(yt),u(vt),u($t),u(qt),u(xt),u(zt),u(wt),u(Ct),u(Tt,e),u(kt),u(Mt),u(Lt,e),u(Ht),u(Dt),u(Qt),u(At),u(It,e),u(jt),u(Pt,e),u(Ft),u(Gt),u(Vt),u(Bt),u(Jt,e),u(Nt),u(He),u(Et),u(Wt),u(Ut,e),u(Rt),u(Zt),u(St,e),u(Xt),u(Yt),u(Ot,e),u(Kt),u(en),u(tn,e)}}}const Xi='{"title":"Quantization","local":"quantization","sections":[{"title":"QuantoConfig","local":"transformers.QuantoConfig","sections":[],"depth":2},{"title":"AqlmConfig","local":"transformers.AqlmConfig","sections":[],"depth":2},{"title":"VptqConfig","local":"transformers.VptqConfig","sections":[],"depth":2},{"title":"AwqConfig","local":"transformers.AwqConfig","sections":[],"depth":2},{"title":"EetqConfig","local":"transformers.EetqConfig","sections":[],"depth":2},{"title":"GPTQConfig","local":"transformers.GPTQConfig","sections":[],"depth":2},{"title":"BitsAndBytesConfig","local":"transformers.BitsAndBytesConfig","sections":[],"depth":2},{"title":"HfQuantizer","local":"transformers.quantizers.HfQuantizer","sections":[],"depth":2},{"title":"HiggsConfig","local":"transformers.HiggsConfig","sections":[],"depth":2},{"title":"HqqConfig","local":"transformers.HqqConfig","sections":[],"depth":2},{"title":"FbgemmFp8Config","local":"transformers.FbgemmFp8Config","sections":[],"depth":2},{"title":"CompressedTensorsConfig","local":"transformers.CompressedTensorsConfig","sections":[],"depth":2},{"title":"TorchAoConfig","local":"transformers.TorchAoConfig","sections":[],"depth":2},{"title":"BitNetConfig","local":"transformers.BitNetConfig","sections":[],"depth":2},{"title":"SpQRConfig","local":"transformers.SpQRConfig","sections":[],"depth":2},{"title":"FineGrainedFP8Config","local":"transformers.FineGrainedFP8Config","sections":[],"depth":2}],"depth":1}';function Yi(on){return Gi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Vi{constructor($){super(),Bi(this,$,Yi,Si,Fi,{})}}export{al as component};
