import{s as bt,o as jt,n as Jt}from"../chunks/scheduler.37c15a92.js";import{S as Ut,i as Tt,g as m,s as a,r as i,A as ft,h as d,f as t,c as n,j as yt,u as o,x as y,k as ht,y as gt,a as s,v as p,d as r,t as M,w as c,m as Ct,n as Zt}from"../chunks/index.2bf4358c.js";import{T as ut}from"../chunks/Tip.363c041f.js";import{Y as wt}from"../chunks/Youtube.1e50a667.js";import{C as h}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Bt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as Ie}from"../chunks/Heading.8ada512a.js";function kt(Ze){let u,w="✏️ <strong>Try it out!</strong> Modify the previous training loop to fine-tune your model on the SST-2 dataset.";return{c(){u=m("p"),u.innerHTML=w},l(b){u=d(b,"P",{"data-svelte-h":!0}),y(u)!=="svelte-14jbd71"&&(u.innerHTML=w)},m(b,Be){s(b,u,Be)},p:Jt,d(b){b&&t(u)}}}function It(Ze){let u;return{c(){u=Ct('⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},l(w){u=Zt(w,'⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},m(w,b){s(w,u,b)},d(w){w&&t(u)}}}function $t(Ze){let u,w,b,Be,U,$e,T,Ge,f,We,g,Al="Now we’ll see how to achieve the same results as we did in the last section without using the <code>Trainer</code> class. Again, we assume you have done the data processing in section 2. Here is a short summary covering everything you will need:",Xe,C,ve,Z,Re,B,Vl="Before actually writing our training loop, we will need to define a few objects. The first ones are the dataloaders we will use to iterate over batches. But before we can define those dataloaders, we need to apply a bit of postprocessing to our <code>tokenized_datasets</code>, to take care of some things that the <code>Trainer</code> did for us automatically. Specifically, we need to:",_e,k,Nl="<li>Remove the columns corresponding to values the model does not expect (like the <code>sentence1</code> and <code>sentence2</code> columns).</li> <li>Rename the column <code>label</code> to <code>labels</code> (because the model expects the argument to be named <code>labels</code>).</li> <li>Set the format of the datasets so they return PyTorch tensors instead of lists.</li>",Ye,I,zl="Our <code>tokenized_datasets</code> has one method for each of those steps:",Ae,$,Ve,G,El="We can then check that the result only has columns that our model will accept:",Ne,W,ze,X,Ql="Now that this is done, we can easily define our dataloaders:",Ee,v,Qe,R,Fl="To quickly check there is no mistake in the data processing, we can inspect a batch like this:",Fe,_,xe,Y,He,A,xl="Note that the actual shapes will probably be slightly different for you since we set <code>shuffle=True</code> for the training dataloader and we are padding to the maximum length inside the batch.",Se,V,Hl="Now that we’re completely finished with data preprocessing (a satisfying yet elusive goal for any ML practitioner), let’s turn to the model. We instantiate it exactly as we did in the previous section:",qe,N,Ke,z,Sl="To make sure that everything will go smoothly during training, we pass our batch to this model:",Le,E,De,Q,Pe,F,ql="All 🤗 Transformers models will return the loss when <code>labels</code> are provided, and we also get the logits (two for each input in our batch, so a tensor of size 8 x 2).",Oe,x,Kl='We’re almost ready to write our training loop! We’re just missing two things: an optimizer and a learning rate scheduler. Since we are trying to replicate what the <code>Trainer</code> was doing by hand, we will use the same defaults. The optimizer used by the <code>Trainer</code> is <code>AdamW</code>, which is the same as Adam, but with a twist for weight decay regularization (see <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> by Ilya Loshchilov and Frank Hutter):',el,H,ll,S,Ll="Finally, the learning rate scheduler used by default is just a linear decay from the maximum value (5e-5) to 0. To properly define it, we need to know the number of training steps we will take, which is the number of epochs we want to run multiplied by the number of training batches (which is the length of our training dataloader). The <code>Trainer</code> uses three epochs by default, so we will follow that:",tl,q,sl,K,al,L,nl,D,Dl="One last thing: we will want to use the GPU if we have access to one (on a CPU, training might take several hours instead of a couple of minutes). To do this, we define a <code>device</code> we will put our model and our batches on:",il,P,ol,O,pl,ee,Pl="We are now ready to train! To get some sense of when training will be finished, we add a progress bar over our number of training steps, using the <code>tqdm</code> library:",rl,le,Ml,te,Ol="You can see that the core of the training loop looks a lot like the one in the introduction. We didn’t ask for any reporting, so this training loop will not tell us anything about how the model fares. We need to add an evaluation loop for that.",cl,se,ml,ae,et="As we did earlier, we will use a metric provided by the 🤗 Evaluate library. We’ve already seen the <code>metric.compute()</code> method, but metrics can actually accumulate batches for us as we go over the prediction loop with the method <code>add_batch()</code>. Once we have accumulated all the batches, we can get the final result with <code>metric.compute()</code>. Here’s how to implement all of this in an evaluation loop:",dl,ne,yl,ie,hl,oe,lt="Again, your results will be slightly different because of the randomness in the model head initialization and the data shuffling, but they should be in the same ballpark.",ul,j,wl,pe,bl,re,jl,Me,tt='The training loop we defined earlier works fine on a single CPU or GPU. But using the <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> library, with just a few adjustments we can enable distributed training on multiple GPUs or TPUs. Starting from the creation of the training and validation dataloaders, here is what our manual training loop looks like:',Jl,ce,Ul,me,st="And here are the changes:",Tl,de,fl,ye,at="The first line to add is the import line. The second line instantiates an <code>Accelerator</code> object that will look at the environment and initialize the proper distributed setup. 🤗 Accelerate handles the device placement for you, so you can remove the lines that put the model on the device (or, if you prefer, change them to use <code>accelerator.device</code> instead of <code>device</code>).",gl,he,nt="Then the main bulk of the work is done in the line that sends the dataloaders, the model, and the optimizer to <code>accelerator.prepare()</code>. This will wrap those objects in the proper container to make sure your distributed training works as intended. The remaining changes to make are removing the line that puts the batch on the <code>device</code> (again, if you want to keep this you can just change it to use <code>accelerator.device</code>) and replacing <code>loss.backward()</code> with <code>accelerator.backward(loss)</code>.",Cl,J,Zl,ue,it="If you’d like to copy and paste it to play around, here’s what the complete training loop looks like with 🤗 Accelerate:",Bl,we,kl,be,ot="Putting this in a <code>train.py</code> script will make that script runnable on any kind of distributed setup. To try it out in your distributed setup, run the command:",Il,je,$l,Je,pt="which will prompt you to answer a few questions and dump your answers in a configuration file used by this command:",Gl,Ue,Wl,Te,rt="which will launch the distributed training.",Xl,fe,Mt="If you want to try this in a Notebook (for instance, to test it with TPUs on Colab), just paste the code in a <code>training_function()</code> and run a last cell with:",vl,ge,Rl,Ce,ct='You can find more examples in the <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',_l,ke,Yl;return U=new Ie({props:{title:"A full training",local:"a-full-training",headingTag:"h1"}}),T=new Bt({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),f=new wt({props:{id:"Dh9CL8fyG80"}}),C=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Z=new Ie({props:{title:"Prepare for training",local:"prepare-for-training",headingTag:"h3"}}),$=new h({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),W=new h({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),_=new h({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),Y=new h({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new h({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Q1ZS01KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new h({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),L=new Ie({props:{title:"The training loop",local:"the-training-loop",headingTag:"h3"}}),P=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),O=new h({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),le=new h({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),se=new Ie({props:{title:"The evaluation loop",local:"the-evaluation-loop",headingTag:"h3"}}),ne=new h({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),ie=new h({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),j=new ut({props:{$$slots:{default:[kt]},$$scope:{ctx:Ze}}}),pe=new Ie({props:{title:"Supercharge your training loop with 🤗 Accelerate",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),re=new wt({props:{id:"s7dy8QRgjJ0"}}),ce=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),de=new h({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),J=new ut({props:{$$slots:{default:[It]},$$scope:{ctx:Ze}}}),we=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),je=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ue=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),ge=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),{c(){u=m("meta"),w=a(),b=m("p"),Be=a(),i(U.$$.fragment),$e=a(),i(T.$$.fragment),Ge=a(),i(f.$$.fragment),We=a(),g=m("p"),g.innerHTML=Al,Xe=a(),i(C.$$.fragment),ve=a(),i(Z.$$.fragment),Re=a(),B=m("p"),B.innerHTML=Vl,_e=a(),k=m("ul"),k.innerHTML=Nl,Ye=a(),I=m("p"),I.innerHTML=zl,Ae=a(),i($.$$.fragment),Ve=a(),G=m("p"),G.textContent=El,Ne=a(),i(W.$$.fragment),ze=a(),X=m("p"),X.textContent=Ql,Ee=a(),i(v.$$.fragment),Qe=a(),R=m("p"),R.textContent=Fl,Fe=a(),i(_.$$.fragment),xe=a(),i(Y.$$.fragment),He=a(),A=m("p"),A.innerHTML=xl,Se=a(),V=m("p"),V.textContent=Hl,qe=a(),i(N.$$.fragment),Ke=a(),z=m("p"),z.textContent=Sl,Le=a(),i(E.$$.fragment),De=a(),i(Q.$$.fragment),Pe=a(),F=m("p"),F.innerHTML=ql,Oe=a(),x=m("p"),x.innerHTML=Kl,el=a(),i(H.$$.fragment),ll=a(),S=m("p"),S.innerHTML=Ll,tl=a(),i(q.$$.fragment),sl=a(),i(K.$$.fragment),al=a(),i(L.$$.fragment),nl=a(),D=m("p"),D.innerHTML=Dl,il=a(),i(P.$$.fragment),ol=a(),i(O.$$.fragment),pl=a(),ee=m("p"),ee.innerHTML=Pl,rl=a(),i(le.$$.fragment),Ml=a(),te=m("p"),te.textContent=Ol,cl=a(),i(se.$$.fragment),ml=a(),ae=m("p"),ae.innerHTML=et,dl=a(),i(ne.$$.fragment),yl=a(),i(ie.$$.fragment),hl=a(),oe=m("p"),oe.textContent=lt,ul=a(),i(j.$$.fragment),wl=a(),i(pe.$$.fragment),bl=a(),i(re.$$.fragment),jl=a(),Me=m("p"),Me.innerHTML=tt,Jl=a(),i(ce.$$.fragment),Ul=a(),me=m("p"),me.textContent=st,Tl=a(),i(de.$$.fragment),fl=a(),ye=m("p"),ye.innerHTML=at,gl=a(),he=m("p"),he.innerHTML=nt,Cl=a(),i(J.$$.fragment),Zl=a(),ue=m("p"),ue.textContent=it,Bl=a(),i(we.$$.fragment),kl=a(),be=m("p"),be.innerHTML=ot,Il=a(),i(je.$$.fragment),$l=a(),Je=m("p"),Je.textContent=pt,Gl=a(),i(Ue.$$.fragment),Wl=a(),Te=m("p"),Te.textContent=rt,Xl=a(),fe=m("p"),fe.innerHTML=Mt,vl=a(),i(ge.$$.fragment),Rl=a(),Ce=m("p"),Ce.innerHTML=ct,_l=a(),ke=m("p"),this.h()},l(e){const l=ft("svelte-u9bgzb",document.head);u=d(l,"META",{name:!0,content:!0}),l.forEach(t),w=n(e),b=d(e,"P",{}),yt(b).forEach(t),Be=n(e),o(U.$$.fragment,e),$e=n(e),o(T.$$.fragment,e),Ge=n(e),o(f.$$.fragment,e),We=n(e),g=d(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-9c0ejj"&&(g.innerHTML=Al),Xe=n(e),o(C.$$.fragment,e),ve=n(e),o(Z.$$.fragment,e),Re=n(e),B=d(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-ci9pg7"&&(B.innerHTML=Vl),_e=n(e),k=d(e,"UL",{"data-svelte-h":!0}),y(k)!=="svelte-pk4vyx"&&(k.innerHTML=Nl),Ye=n(e),I=d(e,"P",{"data-svelte-h":!0}),y(I)!=="svelte-ey27a0"&&(I.innerHTML=zl),Ae=n(e),o($.$$.fragment,e),Ve=n(e),G=d(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-trxw7x"&&(G.textContent=El),Ne=n(e),o(W.$$.fragment,e),ze=n(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-11c0vnt"&&(X.textContent=Ql),Ee=n(e),o(v.$$.fragment,e),Qe=n(e),R=d(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-11wtmu1"&&(R.textContent=Fl),Fe=n(e),o(_.$$.fragment,e),xe=n(e),o(Y.$$.fragment,e),He=n(e),A=d(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-q4m5oq"&&(A.innerHTML=xl),Se=n(e),V=d(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-xq9k1z"&&(V.textContent=Hl),qe=n(e),o(N.$$.fragment,e),Ke=n(e),z=d(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1cfpt2v"&&(z.textContent=Sl),Le=n(e),o(E.$$.fragment,e),De=n(e),o(Q.$$.fragment,e),Pe=n(e),F=d(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-ynwaiq"&&(F.innerHTML=ql),Oe=n(e),x=d(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1my9rg2"&&(x.innerHTML=Kl),el=n(e),o(H.$$.fragment,e),ll=n(e),S=d(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-12ciodg"&&(S.innerHTML=Ll),tl=n(e),o(q.$$.fragment,e),sl=n(e),o(K.$$.fragment,e),al=n(e),o(L.$$.fragment,e),nl=n(e),D=d(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1331u4o"&&(D.innerHTML=Dl),il=n(e),o(P.$$.fragment,e),ol=n(e),o(O.$$.fragment,e),pl=n(e),ee=d(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-s26r6i"&&(ee.innerHTML=Pl),rl=n(e),o(le.$$.fragment,e),Ml=n(e),te=d(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-mcninq"&&(te.textContent=Ol),cl=n(e),o(se.$$.fragment,e),ml=n(e),ae=d(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-1sbu2u1"&&(ae.innerHTML=et),dl=n(e),o(ne.$$.fragment,e),yl=n(e),o(ie.$$.fragment,e),hl=n(e),oe=d(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-14qz8qy"&&(oe.textContent=lt),ul=n(e),o(j.$$.fragment,e),wl=n(e),o(pe.$$.fragment,e),bl=n(e),o(re.$$.fragment,e),jl=n(e),Me=d(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-hmch84"&&(Me.innerHTML=tt),Jl=n(e),o(ce.$$.fragment,e),Ul=n(e),me=d(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-1ysmkb9"&&(me.textContent=st),Tl=n(e),o(de.$$.fragment,e),fl=n(e),ye=d(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-1q9wsp0"&&(ye.innerHTML=at),gl=n(e),he=d(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-15cl91a"&&(he.innerHTML=nt),Cl=n(e),o(J.$$.fragment,e),Zl=n(e),ue=d(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1g09gg4"&&(ue.textContent=it),Bl=n(e),o(we.$$.fragment,e),kl=n(e),be=d(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1476nx"&&(be.innerHTML=ot),Il=n(e),o(je.$$.fragment,e),$l=n(e),Je=d(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-qyc3dl"&&(Je.textContent=pt),Gl=n(e),o(Ue.$$.fragment,e),Wl=n(e),Te=d(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1dc7y78"&&(Te.textContent=rt),Xl=n(e),fe=d(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-529dmx"&&(fe.innerHTML=Mt),vl=n(e),o(ge.$$.fragment,e),Rl=n(e),Ce=d(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-py198"&&(Ce.innerHTML=ct),_l=n(e),ke=d(e,"P",{}),yt(ke).forEach(t),this.h()},h(){ht(u,"name","hf:doc:metadata"),ht(u,"content",Gt)},m(e,l){gt(document.head,u),s(e,w,l),s(e,b,l),s(e,Be,l),p(U,e,l),s(e,$e,l),p(T,e,l),s(e,Ge,l),p(f,e,l),s(e,We,l),s(e,g,l),s(e,Xe,l),p(C,e,l),s(e,ve,l),p(Z,e,l),s(e,Re,l),s(e,B,l),s(e,_e,l),s(e,k,l),s(e,Ye,l),s(e,I,l),s(e,Ae,l),p($,e,l),s(e,Ve,l),s(e,G,l),s(e,Ne,l),p(W,e,l),s(e,ze,l),s(e,X,l),s(e,Ee,l),p(v,e,l),s(e,Qe,l),s(e,R,l),s(e,Fe,l),p(_,e,l),s(e,xe,l),p(Y,e,l),s(e,He,l),s(e,A,l),s(e,Se,l),s(e,V,l),s(e,qe,l),p(N,e,l),s(e,Ke,l),s(e,z,l),s(e,Le,l),p(E,e,l),s(e,De,l),p(Q,e,l),s(e,Pe,l),s(e,F,l),s(e,Oe,l),s(e,x,l),s(e,el,l),p(H,e,l),s(e,ll,l),s(e,S,l),s(e,tl,l),p(q,e,l),s(e,sl,l),p(K,e,l),s(e,al,l),p(L,e,l),s(e,nl,l),s(e,D,l),s(e,il,l),p(P,e,l),s(e,ol,l),p(O,e,l),s(e,pl,l),s(e,ee,l),s(e,rl,l),p(le,e,l),s(e,Ml,l),s(e,te,l),s(e,cl,l),p(se,e,l),s(e,ml,l),s(e,ae,l),s(e,dl,l),p(ne,e,l),s(e,yl,l),p(ie,e,l),s(e,hl,l),s(e,oe,l),s(e,ul,l),p(j,e,l),s(e,wl,l),p(pe,e,l),s(e,bl,l),p(re,e,l),s(e,jl,l),s(e,Me,l),s(e,Jl,l),p(ce,e,l),s(e,Ul,l),s(e,me,l),s(e,Tl,l),p(de,e,l),s(e,fl,l),s(e,ye,l),s(e,gl,l),s(e,he,l),s(e,Cl,l),p(J,e,l),s(e,Zl,l),s(e,ue,l),s(e,Bl,l),p(we,e,l),s(e,kl,l),s(e,be,l),s(e,Il,l),p(je,e,l),s(e,$l,l),s(e,Je,l),s(e,Gl,l),p(Ue,e,l),s(e,Wl,l),s(e,Te,l),s(e,Xl,l),s(e,fe,l),s(e,vl,l),p(ge,e,l),s(e,Rl,l),s(e,Ce,l),s(e,_l,l),s(e,ke,l),Yl=!0},p(e,[l]){const mt={};l&2&&(mt.$$scope={dirty:l,ctx:e}),j.$set(mt);const dt={};l&2&&(dt.$$scope={dirty:l,ctx:e}),J.$set(dt)},i(e){Yl||(r(U.$$.fragment,e),r(T.$$.fragment,e),r(f.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r($.$$.fragment,e),r(W.$$.fragment,e),r(v.$$.fragment,e),r(_.$$.fragment,e),r(Y.$$.fragment,e),r(N.$$.fragment,e),r(E.$$.fragment,e),r(Q.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),r(K.$$.fragment,e),r(L.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(j.$$.fragment,e),r(pe.$$.fragment,e),r(re.$$.fragment,e),r(ce.$$.fragment,e),r(de.$$.fragment,e),r(J.$$.fragment,e),r(we.$$.fragment,e),r(je.$$.fragment,e),r(Ue.$$.fragment,e),r(ge.$$.fragment,e),Yl=!0)},o(e){M(U.$$.fragment,e),M(T.$$.fragment,e),M(f.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M($.$$.fragment,e),M(W.$$.fragment,e),M(v.$$.fragment,e),M(_.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(Q.$$.fragment,e),M(H.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(j.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(J.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(Ue.$$.fragment,e),M(ge.$$.fragment,e),Yl=!1},d(e){e&&(t(w),t(b),t(Be),t($e),t(Ge),t(We),t(g),t(Xe),t(ve),t(Re),t(B),t(_e),t(k),t(Ye),t(I),t(Ae),t(Ve),t(G),t(Ne),t(ze),t(X),t(Ee),t(Qe),t(R),t(Fe),t(xe),t(He),t(A),t(Se),t(V),t(qe),t(Ke),t(z),t(Le),t(De),t(Pe),t(F),t(Oe),t(x),t(el),t(ll),t(S),t(tl),t(sl),t(al),t(nl),t(D),t(il),t(ol),t(pl),t(ee),t(rl),t(Ml),t(te),t(cl),t(ml),t(ae),t(dl),t(yl),t(hl),t(oe),t(ul),t(wl),t(bl),t(jl),t(Me),t(Jl),t(Ul),t(me),t(Tl),t(fl),t(ye),t(gl),t(he),t(Cl),t(Zl),t(ue),t(Bl),t(kl),t(be),t(Il),t($l),t(Je),t(Gl),t(Wl),t(Te),t(Xl),t(fe),t(vl),t(Rl),t(Ce),t(_l),t(ke)),t(u),c(U,e),c(T,e),c(f,e),c(C,e),c(Z,e),c($,e),c(W,e),c(v,e),c(_,e),c(Y,e),c(N,e),c(E,e),c(Q,e),c(H,e),c(q,e),c(K,e),c(L,e),c(P,e),c(O,e),c(le,e),c(se,e),c(ne,e),c(ie,e),c(j,e),c(pe,e),c(re,e),c(ce,e),c(de,e),c(J,e),c(we,e),c(je,e),c(Ue,e),c(ge,e)}}}const Gt='{"title":"A full training","local":"a-full-training","sections":[{"title":"Prepare for training","local":"prepare-for-training","sections":[],"depth":3},{"title":"The training loop","local":"the-training-loop","sections":[],"depth":3},{"title":"The evaluation loop","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"Supercharge your training loop with 🤗 Accelerate","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3}],"depth":1}';function Wt(Ze){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Ut{constructor(u){super(),Tt(this,u,Wt,$t,bt,{})}}export{Nt as component};
