import{s as ao,o as no,n as jl}from"../chunks/scheduler.37c15a92.js";import{S as io,i as oo,g as i,s as a,r as p,A as ro,h as o,f as l,c as n,j as lo,u as h,x as r,k as so,y as po,a as s,v as m,d,t as M,w as c}from"../chunks/index.2bf4358c.js";import{T as bl}from"../chunks/Tip.363c041f.js";import{Y as ho}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as mo}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{F as Mo}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as f}from"../chunks/Heading.8ada512a.js";function co(j){let u,J="✏️ <strong>Your turn!</strong> Check that everything seems correct with the second element of the training dataset.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-f3t9l4"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function uo(j){let u,J="In the next part of the course, we’ll look at more advanced techniques that can help you reduce your memory footprint and let you fine-tune the biggest models.";return{c(){u=i("p"),u.textContent=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-9j5678"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function yo(j){let u,J="💡 You should always make sure you can run <code>trainer.evaluate()</code> before launching <code>trainer.train()</code>, to avoid wasting lots of compute resources before hitting an error.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-g6yrru"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function wo(j){let u,J="💡 If you’re using a manual training loop, the same steps apply to debug your training pipeline, but it’s easier to separate them. Make sure you have not forgotten the <code>model.eval()</code> or <code>model.train()</code> at the right places, or the <code>zero_grad()</code> at each step, however!";return{c(){u=i("p"),u.innerHTML=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-nq8rs"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function Jo(j){let u,J="⚠️ If you are doing distributed training, print samples of your dataset in each process and triple-check that you get the same thing. One common bug is to have some source of randomness in the data creation that makes each process have a different version of the dataset.";return{c(){u=i("p"),u.textContent=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19nz6fs"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function bo(j){let u,J="💡 If your training data is unbalanced, make sure to build a batch of training data containing all the labels.";return{c(){u=i("p"),u.textContent=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-ye7yyo"&&(u.textContent=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function jo(j){let u,J="⚠️ You will have to recreate your model and your <code>Trainer</code> after this test, as the model obtained probably won’t be able to recover and learn something useful on your full dataset.";return{c(){u=i("p"),u.innerHTML=J},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-nhw6g4"&&(u.innerHTML=J)},m(w,b){s(w,u,b)},p:jl,d(w){w&&l(u)}}}function fo(j){let u,J,w,b,T,Tl,v,Ul,B,gl,W,fn='You’ve written a beautiful script to train or fine-tune a model on a given task, dutifully following the advice from <a href="/course/chapter7">Chapter 7</a>. But when you launch the command <code>trainer.train()</code>, something horrible happens: you get an error 😱! Or worse, everything seems to be fine and the training runs without error, but the resulting model is crappy. In this section, we will show you what you can do to debug these kinds of issues.',kl,X,$l,R,Cl,G,Tn="The problem when you encounter an error in <code>trainer.train()</code> is that it could come from multiple sources, as the <code>Trainer</code> usually puts together lots of things. It converts datasets to dataloaders, so the problem could be something wrong in your dataset, or some issue when trying to batch elements of the datasets together. Then it takes a batch of data and feeds it to the model, so the problem could be in the model code. After that, it computes the gradients and performs the optimization step, so the problem could also be in your optimizer. And even if everything goes well for training, something could still go wrong during the evaluation if there is a problem with your metric.",Zl,V,Un="The best way to debug an error that arises in <code>trainer.train()</code> is to manually go through this whole pipeline to see where things went awry. The error is then often very easy to solve.",Il,x,gn='To demonstrate this, we will use the following script that (tries to) fine-tune a DistilBERT model on the <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI dataset</a>:',vl,_,Bl,Y,kn="If you try to execute it, you will be met with a rather cryptic error:",Wl,A,Xl,F,Rl,H,$n="This goes without saying, but if your data is corrupted, the <code>Trainer</code> is not going to be able to form batches, let alone train your model. So first things first, you need to have a look at what is inside your training set.",Gl,z,Cn="To avoid countless hours spent trying to fix something that is not the source of the bug, we recommend you use <code>trainer.train_dataset</code> for your checks and nothing else. So let’s do that here:",Vl,Q,xl,N,_l,E,Zn="Do you notice something wrong? This, in conjunction with the error message about <code>input_ids</code> missing, should make you realize those are texts, not numbers the model can make sense of. Here, the original error is very misleading because the <code>Trainer</code> automatically removes the columns that don’t match the model signature (that is, the arguments expected by the model). That means here, everything apart from the labels was discarded. There was thus no issue with creating batches and then sending them to the model, which in turn complained it didn’t receive the proper input.",Yl,S,In="Why wasn’t the data processed? We did use the <code>Dataset.map()</code> method on the datasets to apply the tokenizer on each sample. But if you look closely at the code, you will see that we made a mistake when passing the training and evaluation sets to the <code>Trainer</code>. Instead of using <code>tokenized_datasets</code> here, we used <code>raw_datasets</code> 🤦. So let’s fix this!",Al,q,Fl,L,vn="This new code will now give a different error (progress!):",Hl,D,zl,P,Bn="Looking at the traceback, we can see the error happens in the data collation step:",Ql,K,Nl,O,Wn="So, we should move to that. Before we do, however, let’s finish inspecting our data, just to be 100% sure it’s correct.",El,ee,Xn="One thing you should always do when debugging a training session is have a look at the decoded inputs of your model. We can’t make sense of the numbers that we feed it directly, so we should look at what those numbers represent. In computer vision, for example, that means looking at the decoded pictures of the pixels you pass, in speech it means listening to the decoded audio samples, and for our NLP example here it means using our tokenizer to decode the inputs:",Sl,te,ql,le,Ll,se,Rn="So that seems correct. You should do this for all the keys in the inputs:",Dl,ae,Pl,ne,Kl,ie,Gn="Note that the keys that don’t correspond to inputs accepted by the model will be automatically discarded, so here we will only keep <code>input_ids</code>, <code>attention_mask</code>, and <code>label</code> (which will be renamed <code>labels</code>). To double-check the model signature, you can print the class of your model, then go check its documentation:",Ol,oe,es,re,ts,pe,Vn='So in our case, we can check the parameters accepted on <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">this page</a>. The <code>Trainer</code> will also log the columns it’s discarding.',ls,he,xn="We have checked that the input IDs are correct by decoding them. Next is the <code>attention_mask</code>:",ss,me,as,de,ns,Me,_n="Since we didn’t apply padding in our preprocessing, this seems perfectly natural. To be sure there is no issue with that attention mask, let’s check it is the same length as our input IDs:",is,ce,os,ue,rs,ye,Yn="That’s good! Lastly, let’s check our label:",ps,we,hs,Je,ms,be,An="Like the input IDs, this is a number that doesn’t really make sense on its own. As we saw before, the map between integers and label names is stored inside the <code>names</code> attribute of the corresponding <em>feature</em> of the dataset:",ds,je,Ms,fe,cs,Te,Fn="So <code>1</code> means <code>neutral</code>, which means the two sentences we saw above are not in contradiction, and the first one does not imply the second one. That seems correct!",us,Ue,Hn="We don’t have token type IDs here, since DistilBERT does not expect them; if you have some in your model, you should also make sure that they properly match where the first and second sentences are in the input.",ys,U,ws,ge,zn="We are only doing the check on the training set here, but you should of course double-check the validation and test sets the same way.",Js,ke,Qn="Now that we know our datasets look good, it’s time to check the next step of the training pipeline.",bs,$e,js,Ce,Nn="The next thing that can go wrong in the training pipeline is when the <code>Trainer</code> tries to form batches from the training or validation set. Once you are sure the <code>Trainer</code>’s datasets are correct, you can try to manually form a batch by executing the following (replace <code>train</code> with <code>eval</code> for the validation dataloader):",fs,Ze,Ts,Ie,En="This code creates the training dataloader, then iterates through it, stopping at the first iteration. If the code executes without error, you have the first training batch that you can inspect, and if the code errors out, you know for sure the problem is in the dataloader, as is the case here:",Us,ve,gs,Be,Sn="Inspecting the last frame of the traceback should be enough to give you a clue, but let’s do a bit more digging. Most of the problems during batch creation arise because of the collation of examples into a single batch, so the first thing to check when in doubt is what <code>collate_fn</code> your <code>DataLoader</code> is using:",ks,We,$s,Xe,Cs,Re,qn="So this is the <code>default_data_collator</code>, but that’s not what we want in this case. We want to pad our examples to the longest sentence in the batch, which is done by the <code>DataCollatorWithPadding</code> collator. And this data collator is supposed to be used by default by the <code>Trainer</code>, so why is it not used here?",Zs,Ge,Ln="The answer is because we did not pass the <code>tokenizer</code> to the <code>Trainer</code>, so it couldn’t create the <code>DataCollatorWithPadding</code> we want. In practice, you should never hesitate to explicitly pass along the data collator you want to use, to make sure you avoid these kinds of errors. Let’s adapt our code to do exactly that:",Is,Ve,vs,xe,Dn="The good news? We don’t get the same error as before, which is definitely progress. The bad news? We get an infamous CUDA error instead:",Bs,_e,Ws,Ye,Pn="This is bad because CUDA errors are extremely hard to debug in general. We will see in a minute how to solve this, but first let’s finish our analysis of batch creation.",Xs,Ae,Kn="If you are sure your data collator is the right one, you should try to apply it on a couple of samples of your dataset:",Rs,Fe,Gs,He,On="This code will fail because the <code>train_dataset</code> contains string columns, which the <code>Trainer</code> usually removes. You can remove them manually, or if you want to replicate exactly what the <code>Trainer</code> is doing behind the scenes, you can call the private <code>Trainer._remove_unused_columns()</code> method that does that:",Vs,ze,xs,Qe,ei="You should then be able to manually debug what happens inside the data collator if the error persists.",_s,Ne,ti="Now that we’ve debugged the batch creation process, it’s time to pass one through the model!",Ys,Ee,As,Se,li="You should be able to get a batch by executing the following command:",Fs,qe,Hs,Le,si="If you’re running this code in a notebook, you may get a CUDA error that’s similar to the one we saw earlier, in which case you need to restart your notebook and reexecute the last snippet without the <code>trainer.train()</code> line. That’s the second most annoying thing about CUDA errors: they irremediably break your kernel. The most annoying thing about them is the fact that they are hard to debug.",zs,De,ai="Why is that? It has to do with the way GPUs work. They are extremely efficient at executing a lot of operations in parallel, but the drawback is that when one of those instructions results in an error, you don’t know it instantly. It’s only when the program calls a synchronization of the multiple processes on the GPU that it will realize something went wrong, so the error is actually raised at a place that has nothing to do with what created it. For instance, if we look at our previous traceback, the error was raised during the backward pass, but we will see in a minute that it actually stems from something in the forward pass.",Qs,Pe,ni="So how do we debug those errors? The answer is easy: we don’t. Unless your CUDA error is an out-of-memory error (which means there is not enough memory in your GPU), you should always go back to the CPU to debug it.",Ns,Ke,ii="To do this in our case, we just have to put the model back on the CPU and call it on our batch — the batch returned by the <code>DataLoader</code> has not been moved to the GPU yet:",Es,Oe,Ss,et,qs,tt,oi="So, the picture is getting clearer. Instead of having a CUDA error, we now have an <code>IndexError</code> in the loss computation (so nothing to do with the backward pass, as we said earlier). More precisely, we can see that it’s target 2 that creates the error, so this is a very good moment to check the number of labels of our model:",Ls,lt,Ds,st,Ps,at,ri="With two labels, only 0s and 1s are allowed as targets, but according to the error message we got a 2. Getting a 2 is actually normal: if we remember the label names we extracted earlier, there were three, so we have indices 0, 1, and 2 in our dataset. The problem is that we didn’t tell that to our model, which should have been created with three labels. So let’s fix that!",Ks,nt,Os,it,pi="We aren’t including the <code>trainer.train()</code> line yet, to take the time to check that everything looks good. If we request a batch and pass it to our model, it now works without error!",ea,ot,ta,rt,hi="The next step is then to move back to the GPU and check that everything still works:",la,pt,sa,ht,mi="If you still get an error, make sure you restart your notebook and only execute the last version of the script.",aa,mt,na,dt,di="Now that we know that we can build batches that actually go through the model, we are ready for the next step of the training pipeline: computing the gradients and performing an optimization step.",ia,Mt,Mi="The first part is just a matter of calling the <code>backward()</code> method on the loss:",oa,ct,ra,ut,ci="It’s pretty rare to get an error at this stage, but if you do get one, make sure to go back to the CPU to get a helpful error message.",pa,yt,ui="To perform the optimization step, we just need to create the <code>optimizer</code> and call its <code>step()</code> method:",ha,wt,ma,Jt,yi="Again, if you’re using the default optimizer in the <code>Trainer</code>, you shouldn’t get an error at this stage, but if you have a custom optimizer, there might be some problems to debug here. Don’t forget to go back to the CPU if you get a weird CUDA error at this stage. Speaking of CUDA errors, earlier we mentioned a special case. Let’s have a look at that now.",da,bt,Ma,jt,wi="Whenever you get an error message that starts with <code>RuntimeError: CUDA out of memory</code>, this indicates that you are out of GPU memory. This is not directly linked to your code, and it can happen with a script that runs perfectly fine. This error means that you tried to put too many things in the internal memory of your GPU, and that resulted in an error. Like with other CUDA errors, you will need to restart your kernel to be in a spot where you can run your training again.",ca,ft,Ji="To solve this issue, you just need to use less GPU space — something that is often easier said than done. First, make sure you don’t have two models on the GPU at the same time (unless that’s required for your problem, of course). Then, you should probably reduce your batch size, as it directly affects the sizes of all the intermediate outputs of the model and their gradients. If the problem persists, consider using a smaller version of your model.",ua,g,ya,Tt,wa,Ut,bi="Now that we’ve solved all the issues with our code, everything is perfect and the training should run smoothly, right? Not so fast! If you run the <code>trainer.train()</code> command, everything will look good at first, but after a while you will get the following:",Ja,gt,ba,kt,ja,$t,ji="You will realize this error appears during the evaluation phase, so this is the last thing we will need to debug.",fa,Ct,fi="You can run the evaluation loop of the <code>Trainer</code> independently form the training like this:",Ta,Zt,Ua,It,ga,k,ka,vt,Ti="Before attempting to debug a problem in the evaluation loop, you should first make sure that you’ve had a look at the data, are able to form a batch properly, and can run your model on it. We’ve completed all of those steps, so the following code can be executed without error:",$a,Bt,Ca,Wt,Ui="The error comes later, at the end of the evaluation phase, and if we look at the traceback we see this:",Za,Xt,Ia,Rt,gi="This tells us that the error originates in the <code>datasets/metric.py</code> module — so this is a problem with our <code>compute_metrics()</code> function. It takes a tuple with the logits and the labels as NumPy arrays, so let’s try to feed it that:",va,Gt,Ba,Vt,Wa,xt,ki="We get the same error, so the problem definitely lies with that function. If we look back at its code, we see it’s just forwarding the <code>predictions</code> and the <code>labels</code> to <code>metric.compute()</code>. So is there a problem with that method? Not really. Let’s have a quick look at the shapes:",Xa,_t,Ra,Yt,Ga,At,$i="Our predictions are still logits, not the actual predictions, which is why the metric is returning this (somewhat obscure) error. The fix is pretty easy; we just have to add an argmax in the <code>compute_metrics()</code> function:",Va,Ft,xa,Ht,_a,zt,Ci="Now our error is fixed! This was the last one, so our script will now train a model properly.",Ya,Qt,Zi="For reference, here is the completely fixed script:",Aa,Nt,Fa,Et,Ii="In this instance, there are no more problems, and our script will fine-tune a model that should give reasonable results. But what can we do when the training proceeds without any error, and the model trained does not perform well at all? That’s the hardest part of machine learning, and we’ll show you a few techniques that can help.",Ha,$,za,St,Qa,qt,vi="What can we do to debug a training that completes without error but doesn’t get good results? We’ll give you some pointers here, but be aware that this kind of debugging is the hardest part of machine learning, and there is no magical answer.",Na,Lt,Ea,Dt,Bi="Your model will only learn something if it’s actually possible to learn anything from your data. If there is a bug that corrupts the data or the labels are attributed randomly, it’s very likely you won’t get any model training on your dataset. So always start by double-checking your decoded inputs and labels, and ask yourself the following questions:",Sa,Pt,Wi="<li>Is the decoded data understandable?</li> <li>Do you agree with the labels?</li> <li>Is there one label that’s more common than the others?</li> <li>What should the loss/metric be if the model predicted a random answer/always the same answer?</li>",qa,C,La,Kt,Xi="After looking at your data, go through a few of the model’s predictions and decode them too. If the model is always predicting the same thing, it might be because your dataset is biased toward one category (for classification problems); techniques like oversampling rare classes might help.",Da,Ot,Ri="If the loss/metric you get on your initial model is very different from the loss/metric you would expect for random predictions, double-check the way your loss or metric is computed, as there is probably a bug there. If you are using several losses that you add at the end, make sure they are of the same scale.",Pa,el,Gi="When you are sure your data is perfect, you can see if the model is capable of training on it with one simple test.",Ka,tl,Oa,ll,Vi="Overfitting is usually something we try to avoid when training, as it means the model is not learning to recognize the general features we want it to but is instead just memorizing the training samples. However, trying to train your model on one batch over and over again is a good test to check if the problem as you framed it can be solved by the model you are attempting to train. It will also help you see if your initial learning rate is too high.",en,sl,xi="Doing this once you have defined your <code>Trainer</code> is really easy; just grab a batch of training data, then run a small manual training loop only using that batch for something like 20 steps:",tn,al,ln,Z,sn,nl,_i="The resulting model should have close-to-perfect results on the same <code>batch</code>. Let’s compute the metric on the resulting predictions:",an,il,nn,ol,on,rl,Yi="100% accuracy, now this is a nice example of overfitting (meaning that if you try your model on any other sentence, it will very likely give you a wrong answer)!",rn,pl,Ai="If you don’t manage to have your model obtain perfect results like this, it means there is something wrong with the way you framed the problem or your data, so you should fix that. Only when you manage to pass the overfitting test can you be sure that your model can actually learn something.",pn,I,hn,hl,mn,ml,Fi="Hyperparameter tuning is always emphasized as being the hardest part of machine learning, but it’s just the last step to help you gain a little bit on the metric. Most of the time, the default hyperparameters of the <code>Trainer</code> will work just fine to give you good results, so don’t launch into a time-consuming and costly hyperparameter search until you have something that beats the baseline you have on your dataset.",dn,dl,Hi="Once you have a good enough model, you can start tweaking a bit. Don’t try launching a thousand runs with different hyperparameters, but compare a couple of runs with different values for one hyperparameter to get an idea of which has the greatest impact.",Mn,Ml,zi="If you are tweaking the model itself, keep it simple and don’t try anything you can’t reasonably justify. Always make sure you go back to the overfitting test to verify that your change hasn’t had any unintended consequences.",cn,cl,un,ul,Qi='Hopefully you will have found some advice in this section that helped you solve your issue, but if that’s not the case, remember you can always ask the community on the <a href="https://discuss.huggingface.co/" rel="nofollow">forums</a>.',yn,yl,Ni="Here are some additional resources that may prove helpful:",wn,wl,Ei='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> by Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> by Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> by Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> by Andrej Karpathy</li>',Jn,Jl,Si="Of course, not every problem you encounter when training neural nets is your own fault! If you encounter something in the 🤗 Transformers or 🤗 Datasets library that does not seem right, you may have encountered a bug. You should definitely tell us all about it, and in the next section we’ll explain exactly how to do that.",bn,fl,jn;return T=new Mo({props:{fw:j[0]}}),v=new f({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h1"}}),B=new mo({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"}]}}),X=new f({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h2"}}),R=new ho({props:{id:"L-WSwUWde1U"}}),_=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),A=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),F=new f({props:{title:"Check your data",local:"check-your-data",headingTag:"h3"}}),Q=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),N=new y({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Ub2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMEElMjAlMjAlMjAlMjBUcmFpbmVyJTJDJTBBKSUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybW5saSUyMiklMEElMEFtb2RlbF9jaGVja3BvaW50JTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIycHJlbWlzZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyaHlwb3RoZXNpcyUyMiU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlKSUwQSUwQSUwQXRva2VuaXplZF9kYXRhc2V0cyUyMCUzRCUyMHJhd19kYXRhc2V0cy5tYXAocHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCklMEElMEFhcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwZiUyMmRpc3RpbGJlcnQtZmluZXR1bmVkLW1ubGklMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMmUtNSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSklMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtbmxpJTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyklMEElMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uX21hdGNoZWQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),D=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),K=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),te=new y({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),le=new y({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ae=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ne=new y({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),oe=new y({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),re=new y({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),me=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),de=new y({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),ce=new y({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),ue=new y({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),we=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),Je=new y({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),je=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),fe=new y({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new bl({props:{$$slots:{default:[co]},$$scope:{ctx:j}}}),$e=new f({props:{title:"From datasets to dataloaders",local:"from-datasets-to-dataloaders",headingTag:"h3"}}),Ze=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),ve=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),We=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Xe=new y({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ve=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),_e=new y({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Fe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),ze=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Ee=new f({props:{title:"Going through the model",local:"going-through-the-model",headingTag:"h3"}}),qe=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Oe=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),et=new y({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),lt=new y({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),st=new y({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),ot=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),pt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),mt=new f({props:{title:"Performing one optimization step",local:"performing-one-optimization-step",headingTag:"h3"}}),ct=new y({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),wt=new y({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),bt=new f({props:{title:"Dealing with CUDA out-of-memory errors",local:"dealing-with-cuda-out-of-memory-errors",headingTag:"h3"}}),g=new bl({props:{$$slots:{default:[uo]},$$scope:{ctx:j}}}),Tt=new f({props:{title:"Evaluating the model",local:"evaluating-the-model",headingTag:"h3"}}),gt=new y({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjB0YWtlJTIwYSUyMGxvbmclMjB0aW1lJTIwYW5kJTIwZXJyb3IlMjBvdXQlMkMlMjBzbyUyMHlvdSUyMHNob3VsZG4ndCUyMHJ1biUyMHRoaXMlMjBjZWxsJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># This will take a long time and error out, so you shouldn&#x27;t run this cell</span>
trainer.train()`,wrap:!1}}),kt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),Zt=new y({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),It=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),k=new bl({props:{$$slots:{default:[yo]},$$scope:{ctx:j}}}),Bt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Xt=new y({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),Gt=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Vt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),_t=new y({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),Yt=new y({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),Ft=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Ht=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),$=new bl({props:{$$slots:{default:[wo]},$$scope:{ctx:j}}}),St=new f({props:{title:"Debugging silent errors during training",local:"debugging-silent-errors-during-training",headingTag:"h2"}}),Lt=new f({props:{title:"Check your data (again!)",local:"check-your-data-again",headingTag:"h3"}}),C=new bl({props:{warning:!0,$$slots:{default:[Jo]},$$scope:{ctx:j}}}),tl=new f({props:{title:"Overfit your model on one batch",local:"overfit-your-model-on-one-batch",headingTag:"h3"}}),al=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),Z=new bl({props:{$$slots:{default:[bo]},$$scope:{ctx:j}}}),il=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),ol=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),I=new bl({props:{warning:!0,$$slots:{default:[jo]},$$scope:{ctx:j}}}),hl=new f({props:{title:"Don’t tune anything until you have a first baseline",local:"dont-tune-anything-until-you-have-a-first-baseline",headingTag:"h3"}}),cl=new f({props:{title:"Ask for help",local:"ask-for-help",headingTag:"h3"}}),{c(){u=i("meta"),J=a(),w=i("p"),b=a(),p(T.$$.fragment),Tl=a(),p(v.$$.fragment),Ul=a(),p(B.$$.fragment),gl=a(),W=i("p"),W.innerHTML=fn,kl=a(),p(X.$$.fragment),$l=a(),p(R.$$.fragment),Cl=a(),G=i("p"),G.innerHTML=Tn,Zl=a(),V=i("p"),V.innerHTML=Un,Il=a(),x=i("p"),x.innerHTML=gn,vl=a(),p(_.$$.fragment),Bl=a(),Y=i("p"),Y.textContent=kn,Wl=a(),p(A.$$.fragment),Xl=a(),p(F.$$.fragment),Rl=a(),H=i("p"),H.innerHTML=$n,Gl=a(),z=i("p"),z.innerHTML=Cn,Vl=a(),p(Q.$$.fragment),xl=a(),p(N.$$.fragment),_l=a(),E=i("p"),E.innerHTML=Zn,Yl=a(),S=i("p"),S.innerHTML=In,Al=a(),p(q.$$.fragment),Fl=a(),L=i("p"),L.textContent=vn,Hl=a(),p(D.$$.fragment),zl=a(),P=i("p"),P.textContent=Bn,Ql=a(),p(K.$$.fragment),Nl=a(),O=i("p"),O.textContent=Wn,El=a(),ee=i("p"),ee.textContent=Xn,Sl=a(),p(te.$$.fragment),ql=a(),p(le.$$.fragment),Ll=a(),se=i("p"),se.textContent=Rn,Dl=a(),p(ae.$$.fragment),Pl=a(),p(ne.$$.fragment),Kl=a(),ie=i("p"),ie.innerHTML=Gn,Ol=a(),p(oe.$$.fragment),es=a(),p(re.$$.fragment),ts=a(),pe=i("p"),pe.innerHTML=Vn,ls=a(),he=i("p"),he.innerHTML=xn,ss=a(),p(me.$$.fragment),as=a(),p(de.$$.fragment),ns=a(),Me=i("p"),Me.textContent=_n,is=a(),p(ce.$$.fragment),os=a(),p(ue.$$.fragment),rs=a(),ye=i("p"),ye.textContent=Yn,ps=a(),p(we.$$.fragment),hs=a(),p(Je.$$.fragment),ms=a(),be=i("p"),be.innerHTML=An,ds=a(),p(je.$$.fragment),Ms=a(),p(fe.$$.fragment),cs=a(),Te=i("p"),Te.innerHTML=Fn,us=a(),Ue=i("p"),Ue.textContent=Hn,ys=a(),p(U.$$.fragment),ws=a(),ge=i("p"),ge.textContent=zn,Js=a(),ke=i("p"),ke.textContent=Qn,bs=a(),p($e.$$.fragment),js=a(),Ce=i("p"),Ce.innerHTML=Nn,fs=a(),p(Ze.$$.fragment),Ts=a(),Ie=i("p"),Ie.textContent=En,Us=a(),p(ve.$$.fragment),gs=a(),Be=i("p"),Be.innerHTML=Sn,ks=a(),p(We.$$.fragment),$s=a(),p(Xe.$$.fragment),Cs=a(),Re=i("p"),Re.innerHTML=qn,Zs=a(),Ge=i("p"),Ge.innerHTML=Ln,Is=a(),p(Ve.$$.fragment),vs=a(),xe=i("p"),xe.textContent=Dn,Bs=a(),p(_e.$$.fragment),Ws=a(),Ye=i("p"),Ye.textContent=Pn,Xs=a(),Ae=i("p"),Ae.textContent=Kn,Rs=a(),p(Fe.$$.fragment),Gs=a(),He=i("p"),He.innerHTML=On,Vs=a(),p(ze.$$.fragment),xs=a(),Qe=i("p"),Qe.textContent=ei,_s=a(),Ne=i("p"),Ne.textContent=ti,Ys=a(),p(Ee.$$.fragment),As=a(),Se=i("p"),Se.textContent=li,Fs=a(),p(qe.$$.fragment),Hs=a(),Le=i("p"),Le.innerHTML=si,zs=a(),De=i("p"),De.textContent=ai,Qs=a(),Pe=i("p"),Pe.textContent=ni,Ns=a(),Ke=i("p"),Ke.innerHTML=ii,Es=a(),p(Oe.$$.fragment),Ss=a(),p(et.$$.fragment),qs=a(),tt=i("p"),tt.innerHTML=oi,Ls=a(),p(lt.$$.fragment),Ds=a(),p(st.$$.fragment),Ps=a(),at=i("p"),at.textContent=ri,Ks=a(),p(nt.$$.fragment),Os=a(),it=i("p"),it.innerHTML=pi,ea=a(),p(ot.$$.fragment),ta=a(),rt=i("p"),rt.textContent=hi,la=a(),p(pt.$$.fragment),sa=a(),ht=i("p"),ht.textContent=mi,aa=a(),p(mt.$$.fragment),na=a(),dt=i("p"),dt.textContent=di,ia=a(),Mt=i("p"),Mt.innerHTML=Mi,oa=a(),p(ct.$$.fragment),ra=a(),ut=i("p"),ut.textContent=ci,pa=a(),yt=i("p"),yt.innerHTML=ui,ha=a(),p(wt.$$.fragment),ma=a(),Jt=i("p"),Jt.innerHTML=yi,da=a(),p(bt.$$.fragment),Ma=a(),jt=i("p"),jt.innerHTML=wi,ca=a(),ft=i("p"),ft.textContent=Ji,ua=a(),p(g.$$.fragment),ya=a(),p(Tt.$$.fragment),wa=a(),Ut=i("p"),Ut.innerHTML=bi,Ja=a(),p(gt.$$.fragment),ba=a(),p(kt.$$.fragment),ja=a(),$t=i("p"),$t.textContent=ji,fa=a(),Ct=i("p"),Ct.innerHTML=fi,Ta=a(),p(Zt.$$.fragment),Ua=a(),p(It.$$.fragment),ga=a(),p(k.$$.fragment),ka=a(),vt=i("p"),vt.textContent=Ti,$a=a(),p(Bt.$$.fragment),Ca=a(),Wt=i("p"),Wt.textContent=Ui,Za=a(),p(Xt.$$.fragment),Ia=a(),Rt=i("p"),Rt.innerHTML=gi,va=a(),p(Gt.$$.fragment),Ba=a(),p(Vt.$$.fragment),Wa=a(),xt=i("p"),xt.innerHTML=ki,Xa=a(),p(_t.$$.fragment),Ra=a(),p(Yt.$$.fragment),Ga=a(),At=i("p"),At.innerHTML=$i,Va=a(),p(Ft.$$.fragment),xa=a(),p(Ht.$$.fragment),_a=a(),zt=i("p"),zt.textContent=Ci,Ya=a(),Qt=i("p"),Qt.textContent=Zi,Aa=a(),p(Nt.$$.fragment),Fa=a(),Et=i("p"),Et.textContent=Ii,Ha=a(),p($.$$.fragment),za=a(),p(St.$$.fragment),Qa=a(),qt=i("p"),qt.textContent=vi,Na=a(),p(Lt.$$.fragment),Ea=a(),Dt=i("p"),Dt.textContent=Bi,Sa=a(),Pt=i("ul"),Pt.innerHTML=Wi,qa=a(),p(C.$$.fragment),La=a(),Kt=i("p"),Kt.textContent=Xi,Da=a(),Ot=i("p"),Ot.textContent=Ri,Pa=a(),el=i("p"),el.textContent=Gi,Ka=a(),p(tl.$$.fragment),Oa=a(),ll=i("p"),ll.textContent=Vi,en=a(),sl=i("p"),sl.innerHTML=xi,tn=a(),p(al.$$.fragment),ln=a(),p(Z.$$.fragment),sn=a(),nl=i("p"),nl.innerHTML=_i,an=a(),p(il.$$.fragment),nn=a(),p(ol.$$.fragment),on=a(),rl=i("p"),rl.textContent=Yi,rn=a(),pl=i("p"),pl.textContent=Ai,pn=a(),p(I.$$.fragment),hn=a(),p(hl.$$.fragment),mn=a(),ml=i("p"),ml.innerHTML=Fi,dn=a(),dl=i("p"),dl.textContent=Hi,Mn=a(),Ml=i("p"),Ml.textContent=zi,cn=a(),p(cl.$$.fragment),un=a(),ul=i("p"),ul.innerHTML=Qi,yn=a(),yl=i("p"),yl.textContent=Ni,wn=a(),wl=i("ul"),wl.innerHTML=Ei,Jn=a(),Jl=i("p"),Jl.textContent=Si,bn=a(),fl=i("p"),this.h()},l(e){const t=ro("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),w=o(e,"P",{}),lo(w).forEach(l),b=n(e),h(T.$$.fragment,e),Tl=n(e),h(v.$$.fragment,e),Ul=n(e),h(B.$$.fragment,e),gl=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ytuhj4"&&(W.innerHTML=fn),kl=n(e),h(X.$$.fragment,e),$l=n(e),h(R.$$.fragment,e),Cl=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-tnyumb"&&(G.innerHTML=Tn),Zl=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-hzxl7e"&&(V.innerHTML=Un),Il=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-q32aak"&&(x.innerHTML=gn),vl=n(e),h(_.$$.fragment,e),Bl=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-3pg78t"&&(Y.textContent=kn),Wl=n(e),h(A.$$.fragment,e),Xl=n(e),h(F.$$.fragment,e),Rl=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-gzpow8"&&(H.innerHTML=$n),Gl=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3sg9xy"&&(z.innerHTML=Cn),Vl=n(e),h(Q.$$.fragment,e),xl=n(e),h(N.$$.fragment,e),_l=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-6jps2k"&&(E.innerHTML=Zn),Yl=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1wolr01"&&(S.innerHTML=In),Al=n(e),h(q.$$.fragment,e),Fl=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1k94mat"&&(L.textContent=vn),Hl=n(e),h(D.$$.fragment,e),zl=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1tmbf0v"&&(P.textContent=Bn),Ql=n(e),h(K.$$.fragment,e),Nl=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10gbmtc"&&(O.textContent=Wn),El=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-4qxohk"&&(ee.textContent=Xn),Sl=n(e),h(te.$$.fragment,e),ql=n(e),h(le.$$.fragment,e),Ll=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1dgrscj"&&(se.textContent=Rn),Dl=n(e),h(ae.$$.fragment,e),Pl=n(e),h(ne.$$.fragment,e),Kl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ojy6k7"&&(ie.innerHTML=Gn),Ol=n(e),h(oe.$$.fragment,e),es=n(e),h(re.$$.fragment,e),ts=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1xoucm3"&&(pe.innerHTML=Vn),ls=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-5x641b"&&(he.innerHTML=xn),ss=n(e),h(me.$$.fragment,e),as=n(e),h(de.$$.fragment,e),ns=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1pojahx"&&(Me.textContent=_n),is=n(e),h(ce.$$.fragment,e),os=n(e),h(ue.$$.fragment,e),rs=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-9qe8oh"&&(ye.textContent=Yn),ps=n(e),h(we.$$.fragment,e),hs=n(e),h(Je.$$.fragment,e),ms=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-z61tvp"&&(be.innerHTML=An),ds=n(e),h(je.$$.fragment,e),Ms=n(e),h(fe.$$.fragment,e),cs=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-tigzcg"&&(Te.innerHTML=Fn),us=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1d4x6k6"&&(Ue.textContent=Hn),ys=n(e),h(U.$$.fragment,e),ws=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1n42cxl"&&(ge.textContent=zn),Js=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-j9xc0o"&&(ke.textContent=Qn),bs=n(e),h($e.$$.fragment,e),js=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-dmtbok"&&(Ce.innerHTML=Nn),fs=n(e),h(Ze.$$.fragment,e),Ts=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-78cxp3"&&(Ie.textContent=En),Us=n(e),h(ve.$$.fragment,e),gs=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1g50zb3"&&(Be.innerHTML=Sn),ks=n(e),h(We.$$.fragment,e),$s=n(e),h(Xe.$$.fragment,e),Cs=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-6x08fd"&&(Re.innerHTML=qn),Zs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-il2k2h"&&(Ge.innerHTML=Ln),Is=n(e),h(Ve.$$.fragment,e),vs=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-ijqm5z"&&(xe.textContent=Dn),Bs=n(e),h(_e.$$.fragment,e),Ws=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1a7o2xm"&&(Ye.textContent=Pn),Xs=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-11i1sfm"&&(Ae.textContent=Kn),Rs=n(e),h(Fe.$$.fragment,e),Gs=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-41j77u"&&(He.innerHTML=On),Vs=n(e),h(ze.$$.fragment,e),xs=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1f68fby"&&(Qe.textContent=ei),_s=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1jk0zgp"&&(Ne.textContent=ti),Ys=n(e),h(Ee.$$.fragment,e),As=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-17wdfhf"&&(Se.textContent=li),Fs=n(e),h(qe.$$.fragment,e),Hs=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1otof6i"&&(Le.innerHTML=si),zs=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-zojoe4"&&(De.textContent=ai),Qs=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-3hnmla"&&(Pe.textContent=ni),Ns=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1f20ywv"&&(Ke.innerHTML=ii),Es=n(e),h(Oe.$$.fragment,e),Ss=n(e),h(et.$$.fragment,e),qs=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1d72w7m"&&(tt.innerHTML=oi),Ls=n(e),h(lt.$$.fragment,e),Ds=n(e),h(st.$$.fragment,e),Ps=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1kos5jb"&&(at.textContent=ri),Ks=n(e),h(nt.$$.fragment,e),Os=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-dvos0i"&&(it.innerHTML=pi),ea=n(e),h(ot.$$.fragment,e),ta=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1mlispf"&&(rt.textContent=hi),la=n(e),h(pt.$$.fragment,e),sa=n(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1ofmtfm"&&(ht.textContent=mi),aa=n(e),h(mt.$$.fragment,e),na=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1jisdcu"&&(dt.textContent=di),ia=n(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-tjcz1h"&&(Mt.innerHTML=Mi),oa=n(e),h(ct.$$.fragment,e),ra=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1rq3476"&&(ut.textContent=ci),pa=n(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-9h4y7g"&&(yt.innerHTML=ui),ha=n(e),h(wt.$$.fragment,e),ma=n(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1yyc42o"&&(Jt.innerHTML=yi),da=n(e),h(bt.$$.fragment,e),Ma=n(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-126rjjn"&&(jt.innerHTML=wi),ca=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-18vu150"&&(ft.textContent=Ji),ua=n(e),h(g.$$.fragment,e),ya=n(e),h(Tt.$$.fragment,e),wa=n(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-2gm1u9"&&(Ut.innerHTML=bi),Ja=n(e),h(gt.$$.fragment,e),ba=n(e),h(kt.$$.fragment,e),ja=n(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-im7b67"&&($t.textContent=ji),fa=n(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1doyjwq"&&(Ct.innerHTML=fi),Ta=n(e),h(Zt.$$.fragment,e),Ua=n(e),h(It.$$.fragment,e),ga=n(e),h(k.$$.fragment,e),ka=n(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1nz2xql"&&(vt.textContent=Ti),$a=n(e),h(Bt.$$.fragment,e),Ca=n(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-ffb80c"&&(Wt.textContent=Ui),Za=n(e),h(Xt.$$.fragment,e),Ia=n(e),Rt=o(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1rvvrss"&&(Rt.innerHTML=gi),va=n(e),h(Gt.$$.fragment,e),Ba=n(e),h(Vt.$$.fragment,e),Wa=n(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-12tu8pl"&&(xt.innerHTML=ki),Xa=n(e),h(_t.$$.fragment,e),Ra=n(e),h(Yt.$$.fragment,e),Ga=n(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-nr86wp"&&(At.innerHTML=$i),Va=n(e),h(Ft.$$.fragment,e),xa=n(e),h(Ht.$$.fragment,e),_a=n(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-26f203"&&(zt.textContent=Ci),Ya=n(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-lmu6ng"&&(Qt.textContent=Zi),Aa=n(e),h(Nt.$$.fragment,e),Fa=n(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-14dxkx4"&&(Et.textContent=Ii),Ha=n(e),h($.$$.fragment,e),za=n(e),h(St.$$.fragment,e),Qa=n(e),qt=o(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-ejwpcu"&&(qt.textContent=vi),Na=n(e),h(Lt.$$.fragment,e),Ea=n(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-12i4wz3"&&(Dt.textContent=Bi),Sa=n(e),Pt=o(e,"UL",{"data-svelte-h":!0}),r(Pt)!=="svelte-1m9el5s"&&(Pt.innerHTML=Wi),qa=n(e),h(C.$$.fragment,e),La=n(e),Kt=o(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1u3f40c"&&(Kt.textContent=Xi),Da=n(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1122ld9"&&(Ot.textContent=Ri),Pa=n(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-8qgi72"&&(el.textContent=Gi),Ka=n(e),h(tl.$$.fragment,e),Oa=n(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-ud8t14"&&(ll.textContent=Vi),en=n(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-mho0en"&&(sl.innerHTML=xi),tn=n(e),h(al.$$.fragment,e),ln=n(e),h(Z.$$.fragment,e),sn=n(e),nl=o(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-zb5hop"&&(nl.innerHTML=_i),an=n(e),h(il.$$.fragment,e),nn=n(e),h(ol.$$.fragment,e),on=n(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-ccee5n"&&(rl.textContent=Yi),rn=n(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1appsmg"&&(pl.textContent=Ai),pn=n(e),h(I.$$.fragment,e),hn=n(e),h(hl.$$.fragment,e),mn=n(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-1inlulo"&&(ml.innerHTML=Fi),dn=n(e),dl=o(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-ngq5bm"&&(dl.textContent=Hi),Mn=n(e),Ml=o(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-17qlrbw"&&(Ml.textContent=zi),cn=n(e),h(cl.$$.fragment,e),un=n(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1kejrvw"&&(ul.innerHTML=Qi),yn=n(e),yl=o(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1wt0l4q"&&(yl.textContent=Ni),wn=n(e),wl=o(e,"UL",{"data-svelte-h":!0}),r(wl)!=="svelte-vkgmp2"&&(wl.innerHTML=Ei),Jn=n(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-vjjrmr"&&(Jl.textContent=Si),bn=n(e),fl=o(e,"P",{}),lo(fl).forEach(l),this.h()},h(){so(u,"name","hf:doc:metadata"),so(u,"content",To)},m(e,t){po(document.head,u),s(e,J,t),s(e,w,t),s(e,b,t),m(T,e,t),s(e,Tl,t),m(v,e,t),s(e,Ul,t),m(B,e,t),s(e,gl,t),s(e,W,t),s(e,kl,t),m(X,e,t),s(e,$l,t),m(R,e,t),s(e,Cl,t),s(e,G,t),s(e,Zl,t),s(e,V,t),s(e,Il,t),s(e,x,t),s(e,vl,t),m(_,e,t),s(e,Bl,t),s(e,Y,t),s(e,Wl,t),m(A,e,t),s(e,Xl,t),m(F,e,t),s(e,Rl,t),s(e,H,t),s(e,Gl,t),s(e,z,t),s(e,Vl,t),m(Q,e,t),s(e,xl,t),m(N,e,t),s(e,_l,t),s(e,E,t),s(e,Yl,t),s(e,S,t),s(e,Al,t),m(q,e,t),s(e,Fl,t),s(e,L,t),s(e,Hl,t),m(D,e,t),s(e,zl,t),s(e,P,t),s(e,Ql,t),m(K,e,t),s(e,Nl,t),s(e,O,t),s(e,El,t),s(e,ee,t),s(e,Sl,t),m(te,e,t),s(e,ql,t),m(le,e,t),s(e,Ll,t),s(e,se,t),s(e,Dl,t),m(ae,e,t),s(e,Pl,t),m(ne,e,t),s(e,Kl,t),s(e,ie,t),s(e,Ol,t),m(oe,e,t),s(e,es,t),m(re,e,t),s(e,ts,t),s(e,pe,t),s(e,ls,t),s(e,he,t),s(e,ss,t),m(me,e,t),s(e,as,t),m(de,e,t),s(e,ns,t),s(e,Me,t),s(e,is,t),m(ce,e,t),s(e,os,t),m(ue,e,t),s(e,rs,t),s(e,ye,t),s(e,ps,t),m(we,e,t),s(e,hs,t),m(Je,e,t),s(e,ms,t),s(e,be,t),s(e,ds,t),m(je,e,t),s(e,Ms,t),m(fe,e,t),s(e,cs,t),s(e,Te,t),s(e,us,t),s(e,Ue,t),s(e,ys,t),m(U,e,t),s(e,ws,t),s(e,ge,t),s(e,Js,t),s(e,ke,t),s(e,bs,t),m($e,e,t),s(e,js,t),s(e,Ce,t),s(e,fs,t),m(Ze,e,t),s(e,Ts,t),s(e,Ie,t),s(e,Us,t),m(ve,e,t),s(e,gs,t),s(e,Be,t),s(e,ks,t),m(We,e,t),s(e,$s,t),m(Xe,e,t),s(e,Cs,t),s(e,Re,t),s(e,Zs,t),s(e,Ge,t),s(e,Is,t),m(Ve,e,t),s(e,vs,t),s(e,xe,t),s(e,Bs,t),m(_e,e,t),s(e,Ws,t),s(e,Ye,t),s(e,Xs,t),s(e,Ae,t),s(e,Rs,t),m(Fe,e,t),s(e,Gs,t),s(e,He,t),s(e,Vs,t),m(ze,e,t),s(e,xs,t),s(e,Qe,t),s(e,_s,t),s(e,Ne,t),s(e,Ys,t),m(Ee,e,t),s(e,As,t),s(e,Se,t),s(e,Fs,t),m(qe,e,t),s(e,Hs,t),s(e,Le,t),s(e,zs,t),s(e,De,t),s(e,Qs,t),s(e,Pe,t),s(e,Ns,t),s(e,Ke,t),s(e,Es,t),m(Oe,e,t),s(e,Ss,t),m(et,e,t),s(e,qs,t),s(e,tt,t),s(e,Ls,t),m(lt,e,t),s(e,Ds,t),m(st,e,t),s(e,Ps,t),s(e,at,t),s(e,Ks,t),m(nt,e,t),s(e,Os,t),s(e,it,t),s(e,ea,t),m(ot,e,t),s(e,ta,t),s(e,rt,t),s(e,la,t),m(pt,e,t),s(e,sa,t),s(e,ht,t),s(e,aa,t),m(mt,e,t),s(e,na,t),s(e,dt,t),s(e,ia,t),s(e,Mt,t),s(e,oa,t),m(ct,e,t),s(e,ra,t),s(e,ut,t),s(e,pa,t),s(e,yt,t),s(e,ha,t),m(wt,e,t),s(e,ma,t),s(e,Jt,t),s(e,da,t),m(bt,e,t),s(e,Ma,t),s(e,jt,t),s(e,ca,t),s(e,ft,t),s(e,ua,t),m(g,e,t),s(e,ya,t),m(Tt,e,t),s(e,wa,t),s(e,Ut,t),s(e,Ja,t),m(gt,e,t),s(e,ba,t),m(kt,e,t),s(e,ja,t),s(e,$t,t),s(e,fa,t),s(e,Ct,t),s(e,Ta,t),m(Zt,e,t),s(e,Ua,t),m(It,e,t),s(e,ga,t),m(k,e,t),s(e,ka,t),s(e,vt,t),s(e,$a,t),m(Bt,e,t),s(e,Ca,t),s(e,Wt,t),s(e,Za,t),m(Xt,e,t),s(e,Ia,t),s(e,Rt,t),s(e,va,t),m(Gt,e,t),s(e,Ba,t),m(Vt,e,t),s(e,Wa,t),s(e,xt,t),s(e,Xa,t),m(_t,e,t),s(e,Ra,t),m(Yt,e,t),s(e,Ga,t),s(e,At,t),s(e,Va,t),m(Ft,e,t),s(e,xa,t),m(Ht,e,t),s(e,_a,t),s(e,zt,t),s(e,Ya,t),s(e,Qt,t),s(e,Aa,t),m(Nt,e,t),s(e,Fa,t),s(e,Et,t),s(e,Ha,t),m($,e,t),s(e,za,t),m(St,e,t),s(e,Qa,t),s(e,qt,t),s(e,Na,t),m(Lt,e,t),s(e,Ea,t),s(e,Dt,t),s(e,Sa,t),s(e,Pt,t),s(e,qa,t),m(C,e,t),s(e,La,t),s(e,Kt,t),s(e,Da,t),s(e,Ot,t),s(e,Pa,t),s(e,el,t),s(e,Ka,t),m(tl,e,t),s(e,Oa,t),s(e,ll,t),s(e,en,t),s(e,sl,t),s(e,tn,t),m(al,e,t),s(e,ln,t),m(Z,e,t),s(e,sn,t),s(e,nl,t),s(e,an,t),m(il,e,t),s(e,nn,t),m(ol,e,t),s(e,on,t),s(e,rl,t),s(e,rn,t),s(e,pl,t),s(e,pn,t),m(I,e,t),s(e,hn,t),m(hl,e,t),s(e,mn,t),s(e,ml,t),s(e,dn,t),s(e,dl,t),s(e,Mn,t),s(e,Ml,t),s(e,cn,t),m(cl,e,t),s(e,un,t),s(e,ul,t),s(e,yn,t),s(e,yl,t),s(e,wn,t),s(e,wl,t),s(e,Jn,t),s(e,Jl,t),s(e,bn,t),s(e,fl,t),jn=!0},p(e,[t]){const qi={};t&1&&(qi.fw=e[0]),T.$set(qi);const Li={};t&2&&(Li.$$scope={dirty:t,ctx:e}),U.$set(Li);const Di={};t&2&&(Di.$$scope={dirty:t,ctx:e}),g.$set(Di);const Pi={};t&2&&(Pi.$$scope={dirty:t,ctx:e}),k.$set(Pi);const Ki={};t&2&&(Ki.$$scope={dirty:t,ctx:e}),$.$set(Ki);const Oi={};t&2&&(Oi.$$scope={dirty:t,ctx:e}),C.$set(Oi);const eo={};t&2&&(eo.$$scope={dirty:t,ctx:e}),Z.$set(eo);const to={};t&2&&(to.$$scope={dirty:t,ctx:e}),I.$set(to)},i(e){jn||(d(T.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(U.$$.fragment,e),d($e.$$.fragment,e),d(Ze.$$.fragment,e),d(ve.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ve.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(ze.$$.fragment,e),d(Ee.$$.fragment,e),d(qe.$$.fragment,e),d(Oe.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(st.$$.fragment,e),d(nt.$$.fragment,e),d(ot.$$.fragment,e),d(pt.$$.fragment,e),d(mt.$$.fragment,e),d(ct.$$.fragment,e),d(wt.$$.fragment,e),d(bt.$$.fragment,e),d(g.$$.fragment,e),d(Tt.$$.fragment,e),d(gt.$$.fragment,e),d(kt.$$.fragment,e),d(Zt.$$.fragment,e),d(It.$$.fragment,e),d(k.$$.fragment,e),d(Bt.$$.fragment,e),d(Xt.$$.fragment,e),d(Gt.$$.fragment,e),d(Vt.$$.fragment,e),d(_t.$$.fragment,e),d(Yt.$$.fragment,e),d(Ft.$$.fragment,e),d(Ht.$$.fragment,e),d(Nt.$$.fragment,e),d($.$$.fragment,e),d(St.$$.fragment,e),d(Lt.$$.fragment,e),d(C.$$.fragment,e),d(tl.$$.fragment,e),d(al.$$.fragment,e),d(Z.$$.fragment,e),d(il.$$.fragment,e),d(ol.$$.fragment,e),d(I.$$.fragment,e),d(hl.$$.fragment,e),d(cl.$$.fragment,e),jn=!0)},o(e){M(T.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M(X.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(A.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(je.$$.fragment,e),M(fe.$$.fragment,e),M(U.$$.fragment,e),M($e.$$.fragment,e),M(Ze.$$.fragment,e),M(ve.$$.fragment,e),M(We.$$.fragment,e),M(Xe.$$.fragment,e),M(Ve.$$.fragment,e),M(_e.$$.fragment,e),M(Fe.$$.fragment,e),M(ze.$$.fragment,e),M(Ee.$$.fragment,e),M(qe.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),M(lt.$$.fragment,e),M(st.$$.fragment,e),M(nt.$$.fragment,e),M(ot.$$.fragment,e),M(pt.$$.fragment,e),M(mt.$$.fragment,e),M(ct.$$.fragment,e),M(wt.$$.fragment,e),M(bt.$$.fragment,e),M(g.$$.fragment,e),M(Tt.$$.fragment,e),M(gt.$$.fragment,e),M(kt.$$.fragment,e),M(Zt.$$.fragment,e),M(It.$$.fragment,e),M(k.$$.fragment,e),M(Bt.$$.fragment,e),M(Xt.$$.fragment,e),M(Gt.$$.fragment,e),M(Vt.$$.fragment,e),M(_t.$$.fragment,e),M(Yt.$$.fragment,e),M(Ft.$$.fragment,e),M(Ht.$$.fragment,e),M(Nt.$$.fragment,e),M($.$$.fragment,e),M(St.$$.fragment,e),M(Lt.$$.fragment,e),M(C.$$.fragment,e),M(tl.$$.fragment,e),M(al.$$.fragment,e),M(Z.$$.fragment,e),M(il.$$.fragment,e),M(ol.$$.fragment,e),M(I.$$.fragment,e),M(hl.$$.fragment,e),M(cl.$$.fragment,e),jn=!1},d(e){e&&(l(J),l(w),l(b),l(Tl),l(Ul),l(gl),l(W),l(kl),l($l),l(Cl),l(G),l(Zl),l(V),l(Il),l(x),l(vl),l(Bl),l(Y),l(Wl),l(Xl),l(Rl),l(H),l(Gl),l(z),l(Vl),l(xl),l(_l),l(E),l(Yl),l(S),l(Al),l(Fl),l(L),l(Hl),l(zl),l(P),l(Ql),l(Nl),l(O),l(El),l(ee),l(Sl),l(ql),l(Ll),l(se),l(Dl),l(Pl),l(Kl),l(ie),l(Ol),l(es),l(ts),l(pe),l(ls),l(he),l(ss),l(as),l(ns),l(Me),l(is),l(os),l(rs),l(ye),l(ps),l(hs),l(ms),l(be),l(ds),l(Ms),l(cs),l(Te),l(us),l(Ue),l(ys),l(ws),l(ge),l(Js),l(ke),l(bs),l(js),l(Ce),l(fs),l(Ts),l(Ie),l(Us),l(gs),l(Be),l(ks),l($s),l(Cs),l(Re),l(Zs),l(Ge),l(Is),l(vs),l(xe),l(Bs),l(Ws),l(Ye),l(Xs),l(Ae),l(Rs),l(Gs),l(He),l(Vs),l(xs),l(Qe),l(_s),l(Ne),l(Ys),l(As),l(Se),l(Fs),l(Hs),l(Le),l(zs),l(De),l(Qs),l(Pe),l(Ns),l(Ke),l(Es),l(Ss),l(qs),l(tt),l(Ls),l(Ds),l(Ps),l(at),l(Ks),l(Os),l(it),l(ea),l(ta),l(rt),l(la),l(sa),l(ht),l(aa),l(na),l(dt),l(ia),l(Mt),l(oa),l(ra),l(ut),l(pa),l(yt),l(ha),l(ma),l(Jt),l(da),l(Ma),l(jt),l(ca),l(ft),l(ua),l(ya),l(wa),l(Ut),l(Ja),l(ba),l(ja),l($t),l(fa),l(Ct),l(Ta),l(Ua),l(ga),l(ka),l(vt),l($a),l(Ca),l(Wt),l(Za),l(Ia),l(Rt),l(va),l(Ba),l(Wa),l(xt),l(Xa),l(Ra),l(Ga),l(At),l(Va),l(xa),l(_a),l(zt),l(Ya),l(Qt),l(Aa),l(Fa),l(Et),l(Ha),l(za),l(Qa),l(qt),l(Na),l(Ea),l(Dt),l(Sa),l(Pt),l(qa),l(La),l(Kt),l(Da),l(Ot),l(Pa),l(el),l(Ka),l(Oa),l(ll),l(en),l(sl),l(tn),l(ln),l(sn),l(nl),l(an),l(nn),l(on),l(rl),l(rn),l(pl),l(pn),l(hn),l(mn),l(ml),l(dn),l(dl),l(Mn),l(Ml),l(cn),l(un),l(ul),l(yn),l(yl),l(wn),l(wl),l(Jn),l(Jl),l(bn),l(fl)),l(u),c(T,e),c(v,e),c(B,e),c(X,e),c(R,e),c(_,e),c(A,e),c(F,e),c(Q,e),c(N,e),c(q,e),c(D,e),c(K,e),c(te,e),c(le,e),c(ae,e),c(ne,e),c(oe,e),c(re,e),c(me,e),c(de,e),c(ce,e),c(ue,e),c(we,e),c(Je,e),c(je,e),c(fe,e),c(U,e),c($e,e),c(Ze,e),c(ve,e),c(We,e),c(Xe,e),c(Ve,e),c(_e,e),c(Fe,e),c(ze,e),c(Ee,e),c(qe,e),c(Oe,e),c(et,e),c(lt,e),c(st,e),c(nt,e),c(ot,e),c(pt,e),c(mt,e),c(ct,e),c(wt,e),c(bt,e),c(g,e),c(Tt,e),c(gt,e),c(kt,e),c(Zt,e),c(It,e),c(k,e),c(Bt,e),c(Xt,e),c(Gt,e),c(Vt,e),c(_t,e),c(Yt,e),c(Ft,e),c(Ht,e),c(Nt,e),c($,e),c(St,e),c(Lt,e),c(C,e),c(tl,e),c(al,e),c(Z,e),c(il,e),c(ol,e),c(I,e),c(hl,e),c(cl,e)}}}const To='{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Check your data","local":"check-your-data","sections":[],"depth":3},{"title":"From datasets to dataloaders","local":"from-datasets-to-dataloaders","sections":[],"depth":3},{"title":"Going through the model","local":"going-through-the-model","sections":[],"depth":3},{"title":"Performing one optimization step","local":"performing-one-optimization-step","sections":[],"depth":3},{"title":"Dealing with CUDA out-of-memory errors","local":"dealing-with-cuda-out-of-memory-errors","sections":[],"depth":3},{"title":"Evaluating the model","local":"evaluating-the-model","sections":[],"depth":3}],"depth":2},{"title":"Debugging silent errors during training","local":"debugging-silent-errors-during-training","sections":[{"title":"Check your data (again!)","local":"check-your-data-again","sections":[],"depth":3},{"title":"Overfit your model on one batch","local":"overfit-your-model-on-one-batch","sections":[],"depth":3},{"title":"Don’t tune anything until you have a first baseline","local":"dont-tune-anything-until-you-have-a-first-baseline","sections":[],"depth":3},{"title":"Ask for help","local":"ask-for-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function Uo(j,u,J){let w="pt";return no(()=>{const b=new URLSearchParams(window.location.search);J(0,w=b.get("fw")||"pt")}),[w]}class Wo extends io{constructor(u){super(),oo(this,u,Uo,fo,ao,{})}}export{Wo as component};
