import{s as ws,f as ht,n as Us,o as Js}from"../chunks/scheduler.389d799c.js";import{S as hs,i as fs,g as M,s as n,r as p,A as Is,h as o,f as t,c as a,j as Fe,u as r,x as i,k as u,y as bs,a as s,v as d,d as y,t as c,w as m}from"../chunks/index.8f81d18f.js";import{C as j}from"../chunks/CodeBlock.3845caa1.js";import{H as h,E as Cs}from"../chunks/EditOnGithub.33306dfe.js";function gs(ft){let J,Qe,Ne,Le,b,qe,C,It="Deploying a 🤗 Transformers models in SageMaker for inference is as easy as:",Pe,g,De,Z,bt='This guide will show you how to deploy models with zero-code using the <a href="https://github.com/aws/sagemaker-huggingface-inference-toolkit" rel="nofollow">Inference Toolkit</a>. The Inference Toolkit builds on top of the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipeline</code> feature</a> from 🤗 Transformers. Learn how to:',Ke,B,Ct='<li><a href="#installation-and-setup">Install and setup the Inference Toolkit</a>.</li> <li><a href="#deploy-a-transformer-model-trained-in-sagemaker">Deploy a 🤗 Transformers model trained in SageMaker</a>.</li> <li><a href="#deploy-a-model-from-the-hub">Deploy a 🤗 Transformers model from the Hugging Face [model Hub](https://huggingface.co/models)</a>.</li> <li><a href="#run-batch-transform-with-transformers-and-sagemaker">Run a Batch Transform Job using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="#user-defined-code-and-modules">Create a custom inference module</a>.</li>',Oe,A,el,k,gt='Before deploying a 🤗 Transformers model to SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',ll,W,Zt="Once you have an AWS account, get started using one of the following:",tl,G,Bt='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',sl,v,At='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',nl,H,kt="Upgrade to the latest <code>sagemaker</code> version.",al,_,Ml,$,Wt="<strong>SageMaker environment</strong>",ol,S,Gt="Setup your SageMaker environment as shown below:",il,R,pl,z,vt="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",rl,V,Ht="<strong>Local environment</strong>",dl,E,_t="Setup your local environment as shown below:",yl,x,cl,X,ml,T,$t,ul,N,St="There are two ways to deploy your Hugging Face model trained in SageMaker:",jl,Y,Rt="<li>Deploy it after your training has finished.</li> <li>Deploy your saved model at a later time from S3 with the <code>model_data</code>.</li>",Tl,F,zt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">deploy_transformer_model_from_s3.ipynb notebook</a> for an example of how to deploy a model from S3 to SageMaker for inference.',wl,Q,Ul,L,Vt="To deploy your model directly after training, ensure all required files are saved in your training script, including the tokenizer and the model.",Jl,q,Et="If you use the Hugging Face <code>Trainer</code>, you can pass your tokenizer as an argument to the <code>Trainer</code>. It will be automatically saved when you call <code>trainer.save_model()</code>.",hl,P,fl,D,xt="After you run your request you can delete the endpoint as shown:",Il,K,bl,O,Cl,ee,Xt="If you’ve already trained your model and want to deploy it at a later time, use the <code>model_data</code> argument to specify the location of your tokenizer and model weights.",gl,le,Zl,te,Nt="After you run our request, you can delete the endpoint again with:",Bl,se,Al,ne,kl,ae,Yt="For later deployment, you can create a <code>model.tar.gz</code> file that contains all the required files, such as:",Wl,Me,Ft="<li><code>pytorch_model.bin</code></li> <li><code>tf_model.h5</code></li> <li><code>tokenizer.json</code></li> <li><code>tokenizer_config.json</code></li>",Gl,oe,Qt="For example, your file should look like this:",vl,ie,Hl,pe,Lt="Create your own <code>model.tar.gz</code> from a model from the 🤗 Hub:",_l,re,qt="<li>Download a model:</li>",$l,de,Sl,f,Pt="<li>Create a <code>tar</code> file:</li>",Rl,ye,zl,I,Dt="<li>Upload <code>model.tar.gz</code> to S3:</li>",Vl,ce,El,me,Kt="Now you can provide the S3 URI to the <code>model_data</code> argument to deploy your model later.",xl,ue,Xl,w,Ot,Nl,je,es="To deploy a model directly from the 🤗 Hub to SageMaker, define two environment variables when you create a <code>HuggingFaceModel</code>:",Yl,Te,ls='<li><code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="http://huggingface.co/models" rel="nofollow">huggingface.co/models</a> when you create a SageMaker endpoint. Access 10,000+ models on he 🤗 Hub through this environment variable.</li> <li><code>HF_TASK</code> defines the task for the 🤗 Transformers <code>pipeline</code>. A complete list of tasks can be found <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.</li>',Fl,we,ts='<p>⚠️ ** Pipelines are not optimized for parallelism (multi-threading) and tend to consume a lot of RAM. For example, on a GPU-based instance, the pipeline operates on a single vCPU. When this vCPU becomes saturated with the inference requests preprocessing, it can create a bottleneck, preventing the GPU from being fully utilized for model inference. Learn more <a href="https://huggingface.co/docs/transformers/en/pipeline_webserver#using-pipelines-for-a-webserver" rel="nofollow">here</a></p>',Ql,Ue,Ll,Je,ss="After you run our request, you can delete the endpoint again with:",ql,he,Pl,fe,ns='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">deploy_transformer_model_from_hf_hub.ipynb notebook</a> for an example of how to deploy a model from the 🤗 Hub to SageMaker for inference.',Dl,Ie,Kl,U,as,Ol,be,Ms='After training a model, you can use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-batch.html" rel="nofollow">SageMaker batch transform</a> to perform inference with the model. Batch transform accepts your inference data as an S3 URI  and then SageMaker will take care of downloading the data, running the prediction, and uploading the results to S3. For more details about batch transform, take a look <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html" rel="nofollow">here</a>.',et,Ce,os="⚠️ The Hugging Face Inference DLC currently only supports <code>.jsonl</code> for batch transform due to the complex structure of textual data.",lt,ge,is="<em>Note: Make sure your <code>inputs</code> fit the <code>max_length</code> of the model during preprocessing.</em>",tt,Ze,ps='If you trained a model using the Hugging Face Estimator, call the <code>transformer()</code> method to create a transform job for a model based on the training job (see <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#sagemaker-batch-transform" rel="nofollow">here</a> for more details):',st,Be,nt,Ae,rs="If you want to run your batch transform job later or with a model from the 🤗 Hub, create a <code>HuggingFaceModel</code> instance and then call the <code>transformer()</code> method:",at,ke,Mt,We,ds="The <code>input.jsonl</code> looks like this:",ot,Ge,it,ve,ys='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run a batch transform job for inference.',pt,He,rt,_e,cs='The Hugging Face Inference Toolkit allows the user to override the default methods of the <code>HuggingFaceHandlerService</code>. You will need to create a folder named <code>code/</code> with an <code>inference.py</code> file in it. See <a href="#create-a-model-artifact-for-deployment">here</a> for more details on how to archive your model artifacts. For example:',dt,$e,yt,Se,ms="The <code>inference.py</code> file contains your custom inference module, and the <code>requirements.txt</code> file contains additional dependencies that should be added. The custom module can override the following methods:",ct,Re,us="<li><code>model_fn(model_dir)</code> overrides the default method for loading a model. The return value <code>model</code> will be used in <code>predict</code> for predictions. <code>predict</code> receives argument the <code>model_dir</code>, the path to your unzipped <code>model.tar.gz</code>.</li> <li><code>transform_fn(model, data, content_type, accept_type)</code> overrides the default transform function with your custom implementation. You will need to implement your own <code>preprocess</code>, <code>predict</code> and <code>postprocess</code> steps in the <code>transform_fn</code>. This method can’t be combined with <code>input_fn</code>, <code>predict_fn</code> or <code>output_fn</code> mentioned below.</li> <li><code>input_fn(input_data, content_type)</code> overrides the default method for preprocessing. The return value <code>data</code> will be used in <code>predict</code> for predictions. The inputs are:<ul><li><code>input_data</code> is the raw body of your request.</li> <li><code>content_type</code> is the content type from the request header.</li></ul></li> <li><code>predict_fn(processed_data, model)</code> overrides the default method for predictions. The return value <code>predictions</code> will be used in <code>postprocess</code>. The input is <code>processed_data</code>, the result from <code>preprocess</code>.</li> <li><code>output_fn(prediction, accept)</code> overrides the default method for postprocessing. The return value <code>result</code> will be the response of your request (e.g.<code>JSON</code>). The inputs are:<ul><li><code>predictions</code> is the result from <code>predict</code>.</li> <li><code>accept</code> is the return accept type from the HTTP Request, e.g. <code>application/json</code>.</li></ul></li>",mt,ze,js="Here is an example of a custom inference module with <code>model_fn</code>, <code>input_fn</code>, <code>predict_fn</code>, and <code>output_fn</code>:",ut,Ve,jt,Ee,Ts="Customize your inference module with only <code>model_fn</code> and <code>transform_fn</code>:",Tt,xe,wt,Xe,Ut,Ye,Jt;return b=new h({props:{title:"Deploy models to Amazon SageMaker",local:"deploy-models-to-amazon-sagemaker",headingTag:"h1"}}),g=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nJTIwRmFjZSUyME1vZGVsJTIwQ2xhc3MlMjBhbmQlMjBkZXBsb3klMjBpdCUyMGFzJTIwU2FnZU1ha2VyJTIwZW5kcG9pbnQlMEFodWdnaW5nZmFjZV9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoLi4uKS5kZXBsb3koKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class and deploy it as SageMaker endpoint</span>
huggingface_model = HuggingFaceModel(...).deploy()`,wrap:!1}}),A=new h({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),_=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),R=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),x=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),X=new h({props:{title:"Deploy a 🤗 Transformers model trained in SageMaker",local:"deploy-a--transformers-model-trained-in-sagemaker",headingTag:"h2"}}),Q=new h({props:{title:"Deploy after training",local:"deploy-after-training",headingTag:"h3"}}),P=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIwcHNldWRvJTIwY29kZSUyMHN0YXJ0JTIwJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBFc3RpbWF0b3IlMjBmb3IlMjB0cmFpbmluZyUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKC4uLi4pJTBBJTBBJTIzJTIwc3RhcnQlMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoLi4uKSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMHBzZXVkbyUyMGNvZGUlMjBlbmQlMjAlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaGZfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMGluc3RhbmNlX3R5cGUlM0QlMjJtbC5tNS54bGFyZ2UlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMHJlcXVlc3QlM0ElMjB5b3UlMjBhbHdheXMlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjAlMjJpbnB1dHMlMjIlMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQ2FtZXJhJTIwLSUyMFlvdSUyMGFyZSUyMGF3YXJkZWQlMjBhJTIwU2lQaXglMjBEaWdpdGFsJTIwQ2FtZXJhISUyMGNhbGwlMjAwOTA2MTIyMTA2NiUyMGZyb21tJTIwbGFuZGxpbmUuJTIwRGVsaXZlcnklMjB3aXRoaW4lMjAyOCUyMGRheXMuJTIyJTBBJTdEJTBBJTBBJTIzJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KGRhdGEp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment">############ pseudo code start ############</span>

<span class="hljs-comment"># create Hugging Face Estimator for training</span>
huggingface_estimator = HuggingFace(....)

<span class="hljs-comment"># start the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(...)

<span class="hljs-comment">############ pseudo code end ############</span>

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = hf_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>, instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 fromm landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),K=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),O=new h({props:{title:"Deploy with model_data",local:"deploy-with-modeldata",headingTag:"h3"}}),le=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   model_data=<span class="hljs-string">&quot;s3://models/my-bert-model/model.tar.gz&quot;</span>,  <span class="hljs-comment"># path to your trained SageMaker model</span>
   role=role,                                            <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                           <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                    <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 fromm landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),se=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),ne=new h({props:{title:"Create a model artifact for deployment",local:"create-a-model-artifact-for-deployment",headingTag:"h3"}}),ie=new j({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMHZvY2FiLnR4dCUwQSU3Qy0lMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElN0MtJTIwY29uZmlnLmpzb24lMEElN0MtJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24=",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- vocab.txt
|- tokenizer_config.json
|- config.json
|- special_tokens_map.json`,wrap:!1}}),de=new j({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwZ2l0JTQwaGYuY28lM0ElN0JyZXBvc2l0b3J5JTdE",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> git@hf.co:{repository}`,wrap:!1}}),ye=new j({props:{code:"Y2QlMjAlN0JyZXBvc2l0b3J5JTdEJTBBdGFyJTIwemN2ZiUyMG1vZGVsLnRhci5neiUyMCo=",highlighted:`<span class="hljs-built_in">cd</span> {repository}
tar zcvf model.tar.gz *`,wrap:!1}}),ce=new j({props:{code:"YXdzJTIwczMlMjBjcCUyMG1vZGVsLnRhci5neiUyMCUzQ3MzJTNBJTJGJTJGJTdCbXktczMtcGF0aCU3RCUzRQ==",highlighted:'aws s3 <span class="hljs-built_in">cp</span> model.tar.gz &lt;s3://{my-s3-path}&gt;',wrap:!1}}),ue=new h({props:{title:"Deploy a model from the 🤗 Hub",local:"deploy-a-model-from-the--hub",headingTag:"h2"}}),Ue=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased-distilled-squad&#x27;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
  <span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;question-answering&#x27;</span>                           <span class="hljs-comment"># NLP task you want to use for predictions</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
<span class="hljs-string">&quot;inputs&quot;</span>: {
	<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What is used for inference?&quot;</span>,
	<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
	}
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),he=new j({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),Ie=new h({props:{title:"Run batch transform with 🤗 Transformers and SageMaker",local:"run-batch-transform-with--transformers-and-sagemaker",headingTag:"h2"}}),Be=new j({props:{code:"YmF0Y2hfam9iJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLnRyYW5zZm9ybWVyKCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjBzdHJhdGVneSUzRCdTaW5nbGVSZWNvcmQnKSUwQSUwQSUwQWJhdGNoX2pvYi50cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCdzMyUzQSUyRiUyRnMzLXVyaS10by1iYXRjaC1kYXRhJyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnRfdHlwZSUzRCdhcHBsaWNhdGlvbiUyRmpzb24nJTJDJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwc3BsaXRfdHlwZSUzRCdMaW5lJyk=",highlighted:`batch_job = huggingface_estimator.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>)


batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://s3-uri-to-batch-data&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>)`,wrap:!1}}),ke=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
	<span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;text-classification&#x27;</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># create transformer to run a batch job</span>
batch_job = huggingface_model.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>
)

<span class="hljs-comment"># starts batch transform job and uses S3 data as input</span>
batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://sagemaker-s3-demo-test/samples/input.jsonl&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>
)`,wrap:!1}}),Ge=new j({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIydGhpcyUyMG1vdmllJTIwaXMlMjB0ZXJyaWJsZSUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwYW1hemluZyUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwdGVycmlibGUlMjIlN0QlMEElN0IlMjJpbnB1dHMlMjIlM0ElMjJ0aGlzJTIwbW92aWUlMjBpcyUyMGFtYXppbmclMjIlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),He=new h({props:{title:"User defined code and modules",local:"user-defined-code-and-modules",headingTag:"h2"}}),$e=new j({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMC4uLi4lMEElN0MtJTIwY29kZSUyRiUwQSUyMCUyMCU3Qy0lMjBpbmZlcmVuY2UucHklMEElMjAlMjAlN0MtJTIwcmVxdWlyZW1lbnRzLnR4dCUyMA==",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- ....
|- code/
  |- inference.py
  |- requirements.txt `,wrap:!1}}),Ve=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjBpbnB1dF9mbihpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMCUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YSUwQSUwQWRlZiUyMHByZWRpY3RfZm4oZGF0YSUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGwlMjB5b3VyJTIwY3VzdG9tJTIwbW9kZWwlMjB3aXRoJTIwdGhlJTIwZGF0YSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChkYXRhJTIwJTJDJTIwLi4uJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZWRpY3Rpb25zJTBBJTBBZGVmJTIwb3V0cHV0X2ZuKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_fn</span>(<span class="hljs-params">input_data, content_type</span>):
    <span class="hljs-comment"># decode the input data  (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)
    <span class="hljs-keyword">return</span> data

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict_fn</span>(<span class="hljs-params">data, model</span>):
    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... )
    <span class="hljs-keyword">return</span> predictions

<span class="hljs-keyword">def</span> <span class="hljs-title function_">output_fn</span>(<span class="hljs-params">prediction, accept</span>):
    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(prediction, accept)
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),xe=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjB0cmFuc2Zvcm1fZm4obW9kZWwlMkMlMjBpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlJTJDJTIwYWNjZXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsbCUyMHlvdXIlMjBjdXN0b20lMjBtb2RlbCUyMHdpdGglMjB0aGUlMjBkYXRhJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGRhdGElMjAlMkMlMjAuLi4lMjApJTIwJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKG91dHB1dCUyQyUyMGFjY2VwdCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_fn</span>(<span class="hljs-params">model, input_data, content_type, accept</span>):
     <span class="hljs-comment"># decode the input data (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)

    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... ) 

    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(output, accept)

    <span class="hljs-keyword">return</span> response`,wrap:!1}}),Xe=new Cs({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/inference.md"}}),{c(){J=M("meta"),Qe=n(),Ne=M("p"),Le=n(),p(b.$$.fragment),qe=n(),C=M("p"),C.textContent=It,Pe=n(),p(g.$$.fragment),De=n(),Z=M("p"),Z.innerHTML=bt,Ke=n(),B=M("ul"),B.innerHTML=Ct,Oe=n(),p(A.$$.fragment),el=n(),k=M("p"),k.innerHTML=gt,ll=n(),W=M("p"),W.textContent=Zt,tl=n(),G=M("ul"),G.innerHTML=Bt,sl=n(),v=M("p"),v.innerHTML=At,nl=n(),H=M("p"),H.innerHTML=kt,al=n(),p(_.$$.fragment),Ml=n(),$=M("p"),$.innerHTML=Wt,ol=n(),S=M("p"),S.textContent=Gt,il=n(),p(R.$$.fragment),pl=n(),z=M("p"),z.innerHTML=vt,rl=n(),V=M("p"),V.innerHTML=Ht,dl=n(),E=M("p"),E.textContent=_t,yl=n(),p(x.$$.fragment),cl=n(),p(X.$$.fragment),ml=n(),T=M("iframe"),ul=n(),N=M("p"),N.textContent=St,jl=n(),Y=M("ul"),Y.innerHTML=Rt,Tl=n(),F=M("p"),F.innerHTML=zt,wl=n(),p(Q.$$.fragment),Ul=n(),L=M("p"),L.textContent=Vt,Jl=n(),q=M("p"),q.innerHTML=Et,hl=n(),p(P.$$.fragment),fl=n(),D=M("p"),D.textContent=xt,Il=n(),p(K.$$.fragment),bl=n(),p(O.$$.fragment),Cl=n(),ee=M("p"),ee.innerHTML=Xt,gl=n(),p(le.$$.fragment),Zl=n(),te=M("p"),te.textContent=Nt,Bl=n(),p(se.$$.fragment),Al=n(),p(ne.$$.fragment),kl=n(),ae=M("p"),ae.innerHTML=Yt,Wl=n(),Me=M("ul"),Me.innerHTML=Ft,Gl=n(),oe=M("p"),oe.textContent=Qt,vl=n(),p(ie.$$.fragment),Hl=n(),pe=M("p"),pe.innerHTML=Lt,_l=n(),re=M("ol"),re.innerHTML=qt,$l=n(),p(de.$$.fragment),Sl=n(),f=M("ol"),f.innerHTML=Pt,Rl=n(),p(ye.$$.fragment),zl=n(),I=M("ol"),I.innerHTML=Dt,Vl=n(),p(ce.$$.fragment),El=n(),me=M("p"),me.innerHTML=Kt,xl=n(),p(ue.$$.fragment),Xl=n(),w=M("iframe"),Nl=n(),je=M("p"),je.innerHTML=es,Yl=n(),Te=M("ul"),Te.innerHTML=ls,Fl=n(),we=M("blockquote"),we.innerHTML=ts,Ql=n(),p(Ue.$$.fragment),Ll=n(),Je=M("p"),Je.textContent=ss,ql=n(),p(he.$$.fragment),Pl=n(),fe=M("p"),fe.innerHTML=ns,Dl=n(),p(Ie.$$.fragment),Kl=n(),U=M("iframe"),Ol=n(),be=M("p"),be.innerHTML=Ms,et=n(),Ce=M("p"),Ce.innerHTML=os,lt=n(),ge=M("p"),ge.innerHTML=is,tt=n(),Ze=M("p"),Ze.innerHTML=ps,st=n(),p(Be.$$.fragment),nt=n(),Ae=M("p"),Ae.innerHTML=rs,at=n(),p(ke.$$.fragment),Mt=n(),We=M("p"),We.innerHTML=ds,ot=n(),p(Ge.$$.fragment),it=n(),ve=M("p"),ve.innerHTML=ys,pt=n(),p(He.$$.fragment),rt=n(),_e=M("p"),_e.innerHTML=cs,dt=n(),p($e.$$.fragment),yt=n(),Se=M("p"),Se.innerHTML=ms,ct=n(),Re=M("ul"),Re.innerHTML=us,mt=n(),ze=M("p"),ze.innerHTML=js,ut=n(),p(Ve.$$.fragment),jt=n(),Ee=M("p"),Ee.innerHTML=Ts,Tt=n(),p(xe.$$.fragment),wt=n(),p(Xe.$$.fragment),Ut=n(),Ye=M("p"),this.h()},l(e){const l=Is("svelte-u9bgzb",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),Qe=a(e),Ne=o(e,"P",{}),Fe(Ne).forEach(t),Le=a(e),r(b.$$.fragment,e),qe=a(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ywypfi"&&(C.textContent=It),Pe=a(e),r(g.$$.fragment,e),De=a(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-lx9xk7"&&(Z.innerHTML=bt),Ke=a(e),B=o(e,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-lmxuwx"&&(B.innerHTML=Ct),Oe=a(e),r(A.$$.fragment,e),el=a(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-uia7yx"&&(k.innerHTML=gt),ll=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-14pz1nf"&&(W.textContent=Zt),tl=a(e),G=o(e,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-nu9uzs"&&(G.innerHTML=Bt),sl=a(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-10vylvb"&&(v.innerHTML=At),nl=a(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-183wm56"&&(H.innerHTML=kt),al=a(e),r(_.$$.fragment,e),Ml=a(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-aqpf90"&&($.innerHTML=Wt),ol=a(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1n86nit"&&(S.textContent=Gt),il=a(e),r(R.$$.fragment,e),pl=a(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-bmcgfj"&&(z.innerHTML=vt),rl=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-12o7543"&&(V.innerHTML=Ht),dl=a(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-qjt50s"&&(E.textContent=_t),yl=a(e),r(x.$$.fragment,e),cl=a(e),r(X.$$.fragment,e),ml=a(e),T=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Fe(T).forEach(t),ul=a(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-gux9y"&&(N.textContent=St),jl=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-g9t1l6"&&(Y.innerHTML=Rt),Tl=a(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1kzoo7i"&&(F.innerHTML=zt),wl=a(e),r(Q.$$.fragment,e),Ul=a(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1bnjjtb"&&(L.textContent=Vt),Jl=a(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-qrjq9z"&&(q.innerHTML=Et),hl=a(e),r(P.$$.fragment,e),fl=a(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1704hsx"&&(D.textContent=xt),Il=a(e),r(K.$$.fragment,e),bl=a(e),r(O.$$.fragment,e),Cl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-xplu1m"&&(ee.innerHTML=Xt),gl=a(e),r(le.$$.fragment,e),Zl=a(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-10df72h"&&(te.textContent=Nt),Bl=a(e),r(se.$$.fragment,e),Al=a(e),r(ne.$$.fragment,e),kl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1bx7pn1"&&(ae.innerHTML=Yt),Wl=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),i(Me)!=="svelte-1yevczk"&&(Me.innerHTML=Ft),Gl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1fj2qwz"&&(oe.textContent=Qt),vl=a(e),r(ie.$$.fragment,e),Hl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-6vx79s"&&(pe.innerHTML=Lt),_l=a(e),re=o(e,"OL",{"data-svelte-h":!0}),i(re)!=="svelte-1oe4mbx"&&(re.innerHTML=qt),$l=a(e),r(de.$$.fragment,e),Sl=a(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dpsw5r"&&(f.innerHTML=Pt),Rl=a(e),r(ye.$$.fragment,e),zl=a(e),I=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(I)!=="svelte-1jup9fl"&&(I.innerHTML=Dt),Vl=a(e),r(ce.$$.fragment,e),El=a(e),me=o(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-fiqqyd"&&(me.innerHTML=Kt),xl=a(e),r(ue.$$.fragment,e),Xl=a(e),w=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Fe(w).forEach(t),Nl=a(e),je=o(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1rqi6h3"&&(je.innerHTML=es),Yl=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-24bif2"&&(Te.innerHTML=ls),Fl=a(e),we=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(we)!=="svelte-1me1jis"&&(we.innerHTML=ts),Ql=a(e),r(Ue.$$.fragment,e),Ll=a(e),Je=o(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-10df72h"&&(Je.textContent=ss),ql=a(e),r(he.$$.fragment,e),Pl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-116ugu4"&&(fe.innerHTML=ns),Dl=a(e),r(Ie.$$.fragment,e),Kl=a(e),U=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Fe(U).forEach(t),Ol=a(e),be=o(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-6zcket"&&(be.innerHTML=Ms),et=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-11i511d"&&(Ce.innerHTML=os),lt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-1aa5m67"&&(ge.innerHTML=is),tt=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-h98oit"&&(Ze.innerHTML=ps),st=a(e),r(Be.$$.fragment,e),nt=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-1ttbskl"&&(Ae.innerHTML=rs),at=a(e),r(ke.$$.fragment,e),Mt=a(e),We=o(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1pml3h7"&&(We.innerHTML=ds),ot=a(e),r(Ge.$$.fragment,e),it=a(e),ve=o(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-1uayvx5"&&(ve.innerHTML=ys),pt=a(e),r(He.$$.fragment,e),rt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-1ryqcdi"&&(_e.innerHTML=cs),dt=a(e),r($e.$$.fragment,e),yt=a(e),Se=o(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1jy9y33"&&(Se.innerHTML=ms),ct=a(e),Re=o(e,"UL",{"data-svelte-h":!0}),i(Re)!=="svelte-1m8cp8l"&&(Re.innerHTML=us),mt=a(e),ze=o(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-d9i7vl"&&(ze.innerHTML=js),ut=a(e),r(Ve.$$.fragment,e),jt=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1cih48j"&&(Ee.innerHTML=Ts),Tt=a(e),r(xe.$$.fragment,e),wt=a(e),r(Xe.$$.fragment,e),Ut=a(e),Ye=o(e,"P",{}),Fe(Ye).forEach(t),this.h()},h(){u(J,"name","hf:doc:metadata"),u(J,"content",Zs),u(T,"width","700"),u(T,"height","394"),ht(T.src,$t="https://www.youtube.com/embed/pfBGgSGnYLs")||u(T,"src",$t),u(T,"title","YouTube video player"),u(T,"frameborder","0"),u(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen="",u(f,"start","2"),u(I,"start","3"),u(w,"width","700"),u(w,"height","394"),ht(w.src,Ot="https://www.youtube.com/embed/l9QZuazbzWM")||u(w,"src",Ot),u(w,"title","YouTube video player"),u(w,"frameborder","0"),u(w,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),w.allowFullscreen="",u(U,"width","700"),u(U,"height","394"),ht(U.src,as="https://www.youtube.com/embed/lnTixz0tUBg")||u(U,"src",as),u(U,"title","YouTube video player"),u(U,"frameborder","0"),u(U,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),U.allowFullscreen=""},m(e,l){bs(document.head,J),s(e,Qe,l),s(e,Ne,l),s(e,Le,l),d(b,e,l),s(e,qe,l),s(e,C,l),s(e,Pe,l),d(g,e,l),s(e,De,l),s(e,Z,l),s(e,Ke,l),s(e,B,l),s(e,Oe,l),d(A,e,l),s(e,el,l),s(e,k,l),s(e,ll,l),s(e,W,l),s(e,tl,l),s(e,G,l),s(e,sl,l),s(e,v,l),s(e,nl,l),s(e,H,l),s(e,al,l),d(_,e,l),s(e,Ml,l),s(e,$,l),s(e,ol,l),s(e,S,l),s(e,il,l),d(R,e,l),s(e,pl,l),s(e,z,l),s(e,rl,l),s(e,V,l),s(e,dl,l),s(e,E,l),s(e,yl,l),d(x,e,l),s(e,cl,l),d(X,e,l),s(e,ml,l),s(e,T,l),s(e,ul,l),s(e,N,l),s(e,jl,l),s(e,Y,l),s(e,Tl,l),s(e,F,l),s(e,wl,l),d(Q,e,l),s(e,Ul,l),s(e,L,l),s(e,Jl,l),s(e,q,l),s(e,hl,l),d(P,e,l),s(e,fl,l),s(e,D,l),s(e,Il,l),d(K,e,l),s(e,bl,l),d(O,e,l),s(e,Cl,l),s(e,ee,l),s(e,gl,l),d(le,e,l),s(e,Zl,l),s(e,te,l),s(e,Bl,l),d(se,e,l),s(e,Al,l),d(ne,e,l),s(e,kl,l),s(e,ae,l),s(e,Wl,l),s(e,Me,l),s(e,Gl,l),s(e,oe,l),s(e,vl,l),d(ie,e,l),s(e,Hl,l),s(e,pe,l),s(e,_l,l),s(e,re,l),s(e,$l,l),d(de,e,l),s(e,Sl,l),s(e,f,l),s(e,Rl,l),d(ye,e,l),s(e,zl,l),s(e,I,l),s(e,Vl,l),d(ce,e,l),s(e,El,l),s(e,me,l),s(e,xl,l),d(ue,e,l),s(e,Xl,l),s(e,w,l),s(e,Nl,l),s(e,je,l),s(e,Yl,l),s(e,Te,l),s(e,Fl,l),s(e,we,l),s(e,Ql,l),d(Ue,e,l),s(e,Ll,l),s(e,Je,l),s(e,ql,l),d(he,e,l),s(e,Pl,l),s(e,fe,l),s(e,Dl,l),d(Ie,e,l),s(e,Kl,l),s(e,U,l),s(e,Ol,l),s(e,be,l),s(e,et,l),s(e,Ce,l),s(e,lt,l),s(e,ge,l),s(e,tt,l),s(e,Ze,l),s(e,st,l),d(Be,e,l),s(e,nt,l),s(e,Ae,l),s(e,at,l),d(ke,e,l),s(e,Mt,l),s(e,We,l),s(e,ot,l),d(Ge,e,l),s(e,it,l),s(e,ve,l),s(e,pt,l),d(He,e,l),s(e,rt,l),s(e,_e,l),s(e,dt,l),d($e,e,l),s(e,yt,l),s(e,Se,l),s(e,ct,l),s(e,Re,l),s(e,mt,l),s(e,ze,l),s(e,ut,l),d(Ve,e,l),s(e,jt,l),s(e,Ee,l),s(e,Tt,l),d(xe,e,l),s(e,wt,l),d(Xe,e,l),s(e,Ut,l),s(e,Ye,l),Jt=!0},p:Us,i(e){Jt||(y(b.$$.fragment,e),y(g.$$.fragment,e),y(A.$$.fragment,e),y(_.$$.fragment,e),y(R.$$.fragment,e),y(x.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(ce.$$.fragment,e),y(ue.$$.fragment,e),y(Ue.$$.fragment,e),y(he.$$.fragment,e),y(Ie.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(He.$$.fragment,e),y($e.$$.fragment,e),y(Ve.$$.fragment,e),y(xe.$$.fragment,e),y(Xe.$$.fragment,e),Jt=!0)},o(e){c(b.$$.fragment,e),c(g.$$.fragment,e),c(A.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(Ue.$$.fragment,e),c(he.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),c(ke.$$.fragment,e),c(Ge.$$.fragment,e),c(He.$$.fragment,e),c($e.$$.fragment,e),c(Ve.$$.fragment,e),c(xe.$$.fragment,e),c(Xe.$$.fragment,e),Jt=!1},d(e){e&&(t(Qe),t(Ne),t(Le),t(qe),t(C),t(Pe),t(De),t(Z),t(Ke),t(B),t(Oe),t(el),t(k),t(ll),t(W),t(tl),t(G),t(sl),t(v),t(nl),t(H),t(al),t(Ml),t($),t(ol),t(S),t(il),t(pl),t(z),t(rl),t(V),t(dl),t(E),t(yl),t(cl),t(ml),t(T),t(ul),t(N),t(jl),t(Y),t(Tl),t(F),t(wl),t(Ul),t(L),t(Jl),t(q),t(hl),t(fl),t(D),t(Il),t(bl),t(Cl),t(ee),t(gl),t(Zl),t(te),t(Bl),t(Al),t(kl),t(ae),t(Wl),t(Me),t(Gl),t(oe),t(vl),t(Hl),t(pe),t(_l),t(re),t($l),t(Sl),t(f),t(Rl),t(zl),t(I),t(Vl),t(El),t(me),t(xl),t(Xl),t(w),t(Nl),t(je),t(Yl),t(Te),t(Fl),t(we),t(Ql),t(Ll),t(Je),t(ql),t(Pl),t(fe),t(Dl),t(Kl),t(U),t(Ol),t(be),t(et),t(Ce),t(lt),t(ge),t(tt),t(Ze),t(st),t(nt),t(Ae),t(at),t(Mt),t(We),t(ot),t(it),t(ve),t(pt),t(rt),t(_e),t(dt),t(yt),t(Se),t(ct),t(Re),t(mt),t(ze),t(ut),t(jt),t(Ee),t(Tt),t(wt),t(Ut),t(Ye)),t(J),m(b,e),m(g,e),m(A,e),m(_,e),m(R,e),m(x,e),m(X,e),m(Q,e),m(P,e),m(K,e),m(O,e),m(le,e),m(se,e),m(ne,e),m(ie,e),m(de,e),m(ye,e),m(ce,e),m(ue,e),m(Ue,e),m(he,e),m(Ie,e),m(Be,e),m(ke,e),m(Ge,e),m(He,e),m($e,e),m(Ve,e),m(xe,e),m(Xe,e)}}}const Zs='{"title":"Deploy models to Amazon SageMaker","local":"deploy-models-to-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Deploy a 🤗 Transformers model trained in SageMaker","local":"deploy-a--transformers-model-trained-in-sagemaker","sections":[{"title":"Deploy after training","local":"deploy-after-training","sections":[],"depth":3},{"title":"Deploy with model_data","local":"deploy-with-modeldata","sections":[],"depth":3},{"title":"Create a model artifact for deployment","local":"create-a-model-artifact-for-deployment","sections":[],"depth":3}],"depth":2},{"title":"Deploy a model from the 🤗 Hub","local":"deploy-a-model-from-the--hub","sections":[],"depth":2},{"title":"Run batch transform with 🤗 Transformers and SageMaker","local":"run-batch-transform-with--transformers-and-sagemaker","sections":[],"depth":2},{"title":"User defined code and modules","local":"user-defined-code-and-modules","sections":[],"depth":2}],"depth":1}';function Bs(ft){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends hs{constructor(J){super(),fs(this,J,Bs,gs,ws,{})}}export{vs as component};
