import{s as Gs,o as Es,n as Yt}from"../chunks/scheduler.b108d059.js";import{S as Ns,i as Hs,g as p,s as a,r,A as Qs,h as i,f as s,c as n,j as Zs,u as h,x as o,k as ks,y as Ls,a as l,v as d,d as m,t as u,w as M}from"../chunks/index.008de539.js";import{T as St}from"../chunks/Tip.aeb15ab7.js";import{C as T}from"../chunks/CodeBlock.3968c746.js";import{H as xe}from"../chunks/Heading.88bfeb84.js";function As(b){let c,w='The <code>type=&quot;module&quot;</code> attribute is important, as it turns our file into a <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules" rel="nofollow">JavaScript module</a>, meaning that we’ll be able to use imports and exports.';return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-kr58bn"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:Yt,d(j){j&&s(c)}}}function Rs(b){let c,w='To keep this tutorial simple, we’ll be loading and running the model in the main (UI) thread. This is not recommended for production applications, since the UI will freeze when we’re performing these actions. This is because JavaScript is a single-threaded language. To overcome this, you can use a <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers" rel="nofollow">web worker</a> to download and run the model in the background. However, we’re not going to do cover that in this tutorial…';return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-g1c7oq"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:Yt,d(j){j&&s(c)}}}function Ss(b){let c,w="NOTE: The <code>detect</code> function needs to be asynchronous, since we’ll <code>await</code> the result of the the model.";return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-2c69hg"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:Yt,d(j){j&&s(c)}}}function Ys(b){let c,w,j,J,I,Ze,U,_t="In this tutorial, you’ll build a simple web application that detects objects in images using Transformers.js! To follow along, all you need is a code editor, a browser, and a simple server (e.g., VS Code Live Server).",ke,C,Vt="Here’s how it works: the user clicks “Upload image” and selects an image using an input dialog. After analysing the image with an object detection model, the predicted bounding boxes are overlaid on top of the image, like this:",Ge,v,qt='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-interence-zebra.png" alt="Demo"/>',Ee,$,zt="Useful links:",Ne,B,Xt='<li><a href="https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector" rel="nofollow">Demo site</a></li> <li><a href="https://scrimba.com/scrim/cKm9bDAg" rel="nofollow">Interactive code walk-through (scrim)</a></li> <li><a href="https://github.com/xenova/transformers.js/tree/main/examples/vanilla-js" rel="nofollow">Source code</a></li>',He,x,Qe,W,Ft="Before we start building with Transformers.js, we first need to lay the groundwork with some markup and styling. Create an <code>index.html</code> file with a basic HTML skeleton, and add the following <code>&lt;main&gt;</code> tag to the <code>&lt;body&gt;</code>:",Le,Z,Ae,k,Pt="<summary>Click here to see a breakdown of this markup.</summary> <p>We’re adding an <code>&lt;input&gt;</code> element with <code>type=&quot;file&quot;</code> that accepts images. This allows the user to select an image from their local file system using a popup dialog. The default styling for this element looks quite bad, so let’s add some styling. The easiest way to achieve this is to wrap the <code>&lt;input&gt;</code> element in a <code>&lt;label&gt;</code>, hide the input, and then style the label as a button.</p> <p>We’re also adding an empty <code>&lt;div&gt;</code> container for displaying the image, plus an empty <code>&lt;p&gt;</code> tag that we’ll use to give status updates to the user while we download and run the model, since both of these operations take some time.</p>",Re,G,Dt="Next, add the following CSS rules in a <code>style.css</code> file and and link it to the HTML:",Se,E,Ye,N,Kt="Here’s how the UI looks at this point:",_e,H,Ot='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-btn.png" alt="Demo"/>',Ve,Q,qe,L,es="With the <em>boring</em> part out of the way, let’s start writing some JavaScript code! Create a file called <code>index.js</code> and link to it in <code>index.html</code> by adding the following to the end of the <code>&lt;body&gt;</code>:",ze,A,Xe,f,Fe,R,ts="Moving into <code>index.js</code>, let’s import Transformers.js by adding the following line to the top of the file:",Pe,S,De,Y,ss="Since we will be downloading the model from the Hugging Face Hub, we can skip the local model check by setting:",Ke,_,Oe,V,ls="Next, let’s create references to the various DOM elements we will access later:",et,q,tt,z,st,X,as='We’re finally ready to create our object detection pipeline! As a reminder, a <a href="./pipelines">pipeline</a>. is a high-level interface provided by the library to perform a specific task. In our case, we will instantiate an object detection pipeline with the <code>pipeline()</code> helper function.',lt,F,ns="Since this can take some time (especially the first time when we have to download the ~40MB model), we first update the <code>status</code> paragraph so that the user knows that we’re about to load the model.",at,P,nt,y,pt,D,ps="We can now call the <code>pipeline()</code> function that we imported at the top of our file, to create our object detection pipeline:",it,K,ot,O,is="We’re passing two arguments into the <code>pipeline()</code> function: (1) task and (2) model.",ct,ee,os='<li><p>The first tells Transformers.js what kind of task we want to perform. In our case, that is <code>object-detection</code>, but there are many other tasks that the library supports, including <code>text-generation</code>, <code>sentiment-analysis</code>, <code>summarization</code>, or <code>automatic-speech-recognition</code>. See <a href="https://huggingface.co/docs/transformers.js/pipelines#tasks" rel="nofollow">here</a> for the full list.</p></li> <li><p>The second argument specifies which model we would like to use to solve the given task. We will use <a href="https://huggingface.co/Xenova/detr-resnet-50" rel="nofollow"><code>Xenova/detr-resnet-50</code></a>, as it is a relatively small (~40MB) but powerful model for detecting objects in an image.</p></li>',rt,te,cs="Once the function returns, we’ll tell the user that the app is ready to be used.",ht,se,dt,le,mt,ae,rs="The next step is to support uploading/selection of images. To achieve this, we will listen for “change” events from the <code>fileUpload</code> element. In the callback function, we use a <code>FileReader()</code> to read the contents of the image if one is selected (and nothing otherwise).",ut,ne,Mt,pe,hs="Once the image has been loaded into the browser, the <code>reader.onload</code> callback function will be invoked. In it, we append the new <code>&lt;img&gt;</code> element to the <code>imageContainer</code> to be displayed to the user.",jt,ie,ds="Don’t worry about the <code>detect(image)</code> function call (which is commented out) - we will explain it later! For now, try to run the app and upload an image to the browser. You should see your image displayed under the button like this:",Tt,oe,ms='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-btn-img.png" alt="Demo"/>',wt,ce,Jt,re,us="We’re finally ready to start interacting with Transformers.js! Let’s uncomment the <code>detect(image)</code> function call from the snippet above. Then we’ll define the function itself:",bt,he,ft,g,yt,de,Ms="Once we’ve updated the <code>status</code> to “Analysing”, we’re ready to perform <em>inference</em>, which simply means to run the model with some data. This is done via the <code>detector()</code> function that was returned from <code>pipeline()</code>. The first argument we’re passing is the image data (<code>img.src</code>).",gt,me,js="The second argument is an options object:",It,ue,Ts="<li>We set the <code>threshold</code> property to <code>0.5</code>. This means that we want the model to be at least 50% confident before claiming it has detected an object in the image. The lower the threshold, the more objects it’ll detect (but may misidentify objects); the higher the threshold, the fewer objects it’ll detect (but may miss objects in the scene).</li> <li>We also specify <code>percentage: true</code>, which means that we want the bounding box for the objects to be returned as percentages (instead of pixels).</li>",Ut,Me,ws="If you now try to run the app and upload an image, you should see the following output logged to the console:",Ct,je,Js='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-console.png" alt="Demo"/>',vt,Te,bs="In the example above, we uploaded an image of two elephants, so the <code>output</code> variable holds an array with two objects, each containing a <code>label</code> (the string “elephant”), a <code>score</code> (indicating the model’s confidence in its prediction) and a <code>box</code> object (representing the bounding box of the detected entity).",$t,we,Bt,Je,fs="The final step is to display the <code>box</code> coordinates as rectangles around each of the elephants.",xt,be,ys="At the end of our <code>detect()</code> function, we’ll run the <code>renderBox</code> function on each object in the <code>output</code> array, using <code>.forEach()</code>.",Wt,fe,Zt,ye,gs="Here’s the code for the <code>renderBox()</code> function with comments to help you understand what’s going on:",kt,ge,Gt,Ie,Is="The bounding box and label span also need some styling, so add the following to the <code>style.css</code> file:",Et,Ue,Nt,Ce,Us="<strong>And that’s it!</strong>",Ht,ve,Cs="You’ve now built your own fully-functional AI application that detects objects in images, which runns completely in your browser: no external server, APIs, or build tools. Pretty cool! 🥳",Qt,$e,vs='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-inference-elephant.png" alt="Demo"/>',Lt,Be,$s='The app is live at the following URL: <a href="https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector" rel="nofollow">https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector</a>',At,We,Rt;return I=new xe({props:{title:"Building a Vanilla JavaScript Application",local:"building-a-vanilla-javascript-application",headingTag:"h1"}}),x=new xe({props:{title:"Step 1:  HTML and CSS setup",local:"step-1-html-and-css-setup",headingTag:"h2"}}),Z=new T({props:{code:"JTNDbWFpbiUyMGNsYXNzJTNEJTIyY29udGFpbmVyJTIyJTNFJTBBJTIwJTIwJTNDbGFiZWwlMjBjbGFzcyUzRCUyMmN1c3RvbS1maWxlLXVwbG9hZCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUzQ2lucHV0JTIwaWQlM0QlMjJmaWxlLXVwbG9hZCUyMiUyMHR5cGUlM0QlMjJmaWxlJTIyJTIwYWNjZXB0JTNEJTIyaW1hZ2UlMkYqJTIyJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTNDaW1nJTIwY2xhc3MlM0QlMjJ1cGxvYWQtaWNvbiUyMiUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ1cGxvYWQtaWNvbi5wbmclMjIlMjAlMkYlM0UlMEElMjAlMjAlMjAlMjBVcGxvYWQlMjBpbWFnZSUwQSUyMCUyMCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTNDZGl2JTIwaWQlM0QlMjJpbWFnZS1jb250YWluZXIlMjIlM0UlM0MlMkZkaXYlM0UlMEElMjAlMjAlM0NwJTIwaWQlM0QlMjJzdGF0dXMlMjIlM0UlM0MlMkZwJTNFJTBBJTNDJTJGbWFpbiUzRQ==",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;container&quot;</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;custom-file-upload&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">input</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;file-upload&quot;</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">accept</span>=<span class="hljs-string">&quot;image/*&quot;</span> /&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">img</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;upload-icon&quot;</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/upload-icon.png&quot;</span> /&gt;</span>
    Upload image
  <span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;image-container&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;status&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),E=new T({props:{code:"aHRtbCUyQyUwQWJvZHklMjAlN0IlMEElMjAlMjAlMjAlMjBmb250LWZhbWlseSUzQSUyMEFyaWFsJTJDJTIwSGVsdmV0aWNhJTJDJTIwc2Fucy1zZXJpZiUzQiUwQSU3RCUwQSUwQS5jb250YWluZXIlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXJnaW4lM0ElMjA0MHB4JTIwYXV0byUzQiUwQSUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwbWF4KDUwdnclMkMlMjA0MDBweCklM0IlMEElMjAlMjAlMjAlMjBkaXNwbGF5JTNBJTIwZmxleCUzQiUwQSUyMCUyMCUyMCUyMGZsZXgtZGlyZWN0aW9uJTNBJTIwY29sdW1uJTNCJTBBJTIwJTIwJTIwJTIwYWxpZ24taXRlbXMlM0ElMjBjZW50ZXIlM0IlMEElN0QlMEElMEEuY3VzdG9tLWZpbGUtdXBsb2FkJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGlzcGxheSUzQSUyMGZsZXglM0IlMEElMjAlMjAlMjAlMjBhbGlnbi1pdGVtcyUzQSUyMGNlbnRlciUzQiUwQSUyMCUyMCUyMCUyMGN1cnNvciUzQSUyMHBvaW50ZXIlM0IlMEElMjAlMjAlMjAlMjBnYXAlM0ElMjAxMHB4JTNCJTBBJTIwJTIwJTIwJTIwYm9yZGVyJTNBJTIwMnB4JTIwc29saWQlMjBibGFjayUzQiUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0ElMjA4cHglMjAxNnB4JTNCJTBBJTIwJTIwJTIwJTIwY3Vyc29yJTNBJTIwcG9pbnRlciUzQiUwQSUyMCUyMCUyMCUyMGJvcmRlci1yYWRpdXMlM0ElMjA2cHglM0IlMEElN0QlMEElMEElMjNmaWxlLXVwbG9hZCUyMCU3QiUwQSUyMCUyMCUyMCUyMGRpc3BsYXklM0ElMjBub25lJTNCJTBBJTdEJTBBJTBBLnVwbG9hZC1pY29uJTIwJTdCJTBBJTIwJTIwJTIwJTIwd2lkdGglM0ElMjAzMHB4JTNCJTBBJTdEJTBBJTBBJTIzaW1hZ2UtY29udGFpbmVyJTIwJTdCJTBBJTIwJTIwJTIwJTIwd2lkdGglM0ElMjAxMDAlMjUlM0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tdG9wJTNBJTIwMjBweCUzQiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNBJTIwcmVsYXRpdmUlM0IlMEElN0QlMEElMEElMjNpbWFnZS1jb250YWluZXIlM0VpbWclMjAlN0IlMEElMjAlMjAlMjAlMjB3aWR0aCUzQSUyMDEwMCUyNSUzQiUwQSU3RA==",highlighted:`<span class="hljs-selector-tag">html</span>,
<span class="hljs-selector-tag">body</span> {
    <span class="hljs-attribute">font-family</span>: Arial, Helvetica, sans-serif;
}

<span class="hljs-selector-class">.container</span> {
    <span class="hljs-attribute">margin</span>: <span class="hljs-number">40px</span> auto;
    <span class="hljs-attribute">width</span>: <span class="hljs-built_in">max</span>(<span class="hljs-number">50vw</span>, <span class="hljs-number">400px</span>);
    <span class="hljs-attribute">display</span>: flex;
    <span class="hljs-attribute">flex-direction</span>: column;
    <span class="hljs-attribute">align-items</span>: center;
}

<span class="hljs-selector-class">.custom-file-upload</span> {
    <span class="hljs-attribute">display</span>: flex;
    <span class="hljs-attribute">align-items</span>: center;
    <span class="hljs-attribute">cursor</span>: pointer;
    <span class="hljs-attribute">gap</span>: <span class="hljs-number">10px</span>;
    <span class="hljs-attribute">border</span>: <span class="hljs-number">2px</span> solid black;
    <span class="hljs-attribute">padding</span>: <span class="hljs-number">8px</span> <span class="hljs-number">16px</span>;
    <span class="hljs-attribute">cursor</span>: pointer;
    <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">6px</span>;
}

<span class="hljs-selector-id">#file-upload</span> {
    <span class="hljs-attribute">display</span>: none;
}

<span class="hljs-selector-class">.upload-icon</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">30px</span>;
}

<span class="hljs-selector-id">#image-container</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">100%</span>;
    <span class="hljs-attribute">margin-top</span>: <span class="hljs-number">20px</span>;
    <span class="hljs-attribute">position</span>: relative;
}

<span class="hljs-selector-id">#image-container</span>&gt;<span class="hljs-selector-tag">img</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">100%</span>;
}`,wrap:!1}}),Q=new xe({props:{title:"Step 2: JavaScript setup",local:"step-2-javascript-setup",headingTag:"h2"}}),A=new T({props:{code:"JTNDc2NyaXB0JTIwc3JjJTNEJTIyLiUyRmluZGV4LmpzJTIyJTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUzQyUyRnNjcmlwdCUzRQ==",highlighted:'<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;./index.js&quot;</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>',wrap:!1}}),f=new St({props:{$$slots:{default:[As]},$$scope:{ctx:b}}}),S=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQweGVub3ZhJTJGdHJhbnNmb3JtZXJzJTQwMi42LjAlMjIlM0I=",highlighted:'<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@xenova/transformers@2.6.0&quot;</span>;',wrap:!1}}),_=new T({props:{code:"ZW52LmFsbG93TG9jYWxNb2RlbHMlMjAlM0QlMjBmYWxzZSUzQg==",highlighted:'env.<span class="hljs-property">allowLocalModels</span> = <span class="hljs-literal">false</span>;',wrap:!1}}),q=new T({props:{code:"Y29uc3QlMjBmaWxlVXBsb2FkJTIwJTNEJTIwZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJTIyZmlsZS11cGxvYWQlMjIpJTNCJTBBY29uc3QlMjBpbWFnZUNvbnRhaW5lciUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMmltYWdlLWNvbnRhaW5lciUyMiklM0IlMEFjb25zdCUyMHN0YXR1cyUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnN0YXR1cyUyMiklM0I=",highlighted:`<span class="hljs-keyword">const</span> fileUpload = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;file-upload&quot;</span>);
<span class="hljs-keyword">const</span> imageContainer = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;image-container&quot;</span>);
<span class="hljs-keyword">const</span> status = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;status&quot;</span>);`,wrap:!1}}),z=new xe({props:{title:"Step 3: Create an object detection pipeline",local:"step-3-create-an-object-detection-pipeline",headingTag:"h2"}}),P=new T({props:{code:"c3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyTG9hZGluZyUyMG1vZGVsLi4uJTIyJTNC",highlighted:'status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Loading model...&quot;</span>;',wrap:!1}}),y=new St({props:{$$slots:{default:[Rs]},$$scope:{ctx:b}}}),K=new T({props:{code:"Y29uc3QlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTIyb2JqZWN0LWRldGVjdGlvbiUyMiUyQyUyMCUyMlhlbm92YSUyRmRldHItcmVzbmV0LTUwJTIyKSUzQg==",highlighted:'<span class="hljs-keyword">const</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&quot;object-detection&quot;</span>, <span class="hljs-string">&quot;Xenova/detr-resnet-50&quot;</span>);',wrap:!1}}),se=new T({props:{code:"c3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyUmVhZHklMjIlM0I=",highlighted:'status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Ready&quot;</span>;',wrap:!1}}),le=new xe({props:{title:"Step 4: Create the image uploader",local:"step-4-create-the-image-uploader",headingTag:"h2"}}),ne=new T({props:{code:"ZmlsZVVwbG9hZC5hZGRFdmVudExpc3RlbmVyKCUyMmNoYW5nZSUyMiUyQyUyMGZ1bmN0aW9uJTIwKGUpJTIwJTdCJTBBJTIwJTIwY29uc3QlMjBmaWxlJTIwJTNEJTIwZS50YXJnZXQuZmlsZXMlNUIwJTVEJTNCJTBBJTIwJTIwaWYlMjAoIWZpbGUpJTIwJTdCJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTNCJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwY29uc3QlMjByZWFkZXIlMjAlM0QlMjBuZXclMjBGaWxlUmVhZGVyKCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBTZXQlMjB1cCUyMGElMjBjYWxsYmFjayUyMHdoZW4lMjB0aGUlMjBmaWxlJTIwaXMlMjBsb2FkZWQlMEElMjAlMjByZWFkZXIub25sb2FkJTIwJTNEJTIwZnVuY3Rpb24lMjAoZTIpJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2VDb250YWluZXIuaW5uZXJIVE1MJTIwJTNEJTIwJTIyJTIyJTNCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBpbWFnZSUyMCUzRCUyMGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJTIyaW1nJTIyKSUzQiUwQSUyMCUyMCUyMCUyMGltYWdlLnNyYyUyMCUzRCUyMGUyLnRhcmdldC5yZXN1bHQlM0IlMEElMjAlMjAlMjAlMjBpbWFnZUNvbnRhaW5lci5hcHBlbmRDaGlsZChpbWFnZSklM0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBkZXRlY3QoaW1hZ2UpJTNCJTIwJTJGJTJGJTIwVW5jb21tZW50JTIwdGhpcyUyMGxpbmUlMjB0byUyMHJ1biUyMHRoZSUyMG1vZGVsJTBBJTIwJTIwJTdEJTNCJTBBJTIwJTIwcmVhZGVyLnJlYWRBc0RhdGFVUkwoZmlsZSklM0IlMEElN0QpJTNC",highlighted:`fileUpload.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;change&quot;</span>, <span class="hljs-keyword">function</span> (<span class="hljs-params">e</span>) {
  <span class="hljs-keyword">const</span> file = e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>];
  <span class="hljs-keyword">if</span> (!file) {
    <span class="hljs-keyword">return</span>;
  }

  <span class="hljs-keyword">const</span> reader = <span class="hljs-keyword">new</span> <span class="hljs-title class_">FileReader</span>();

  <span class="hljs-comment">// Set up a callback when the file is loaded</span>
  reader.<span class="hljs-property">onload</span> = <span class="hljs-keyword">function</span> (<span class="hljs-params">e2</span>) {
    imageContainer.<span class="hljs-property">innerHTML</span> = <span class="hljs-string">&quot;&quot;</span>;
    <span class="hljs-keyword">const</span> image = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;img&quot;</span>);
    image.<span class="hljs-property">src</span> = e2.<span class="hljs-property">target</span>.<span class="hljs-property">result</span>;
    imageContainer.<span class="hljs-title function_">appendChild</span>(image);
    <span class="hljs-comment">// detect(image); // Uncomment this line to run the model</span>
  };
  reader.<span class="hljs-title function_">readAsDataURL</span>(file);
});`,wrap:!1}}),ce=new xe({props:{title:"Step 5: Run the model",local:"step-5-run-the-model",headingTag:"h2"}}),he=new T({props:{code:"YXN5bmMlMjBmdW5jdGlvbiUyMGRldGVjdChpbWcpJTIwJTdCJTBBJTIwJTIwc3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyQW5hbHlzaW5nLi4uJTIyJTNCJTBBJTIwJTIwY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZy5zcmMlMkMlMjAlN0IlMEElMjAlMjAlMjAlMjB0aHJlc2hvbGQlM0ElMjAwLjUlMkMlMEElMjAlMjAlMjAlMjBwZXJjZW50YWdlJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCU3RCklM0IlMEElMjAlMjBzdGF0dXMudGV4dENvbnRlbnQlMjAlM0QlMjAlMjIlMjIlM0IlMEElMjAlMjBjb25zb2xlLmxvZyglMjJvdXRwdXQlMjIlMkMlMjBvdXRwdXQpJTNCJTBBJTIwJTIwJTJGJTJGJTIwLi4uJTBBJTdE",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">detect</span>(<span class="hljs-params">img</span>) {
  status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Analysing...&quot;</span>;
  <span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img.<span class="hljs-property">src</span>, {
    <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.5</span>,
    <span class="hljs-attr">percentage</span>: <span class="hljs-literal">true</span>,
  });
  status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;&quot;</span>;
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;output&quot;</span>, output);
  <span class="hljs-comment">// ...</span>
}`,wrap:!1}}),g=new St({props:{$$slots:{default:[Ss]},$$scope:{ctx:b}}}),we=new xe({props:{title:"Step 6: Render the boxes",local:"step-6-render-the-boxes",headingTag:"h2"}}),fe=new T({props:{code:"b3V0cHV0LmZvckVhY2gocmVuZGVyQm94KSUzQg==",highlighted:'output.<span class="hljs-title function_">forEach</span>(renderBox);',wrap:!1}}),ge=new T({props:{code:"JTJGJTJGJTIwUmVuZGVyJTIwYSUyMGJvdW5kaW5nJTIwYm94JTIwYW5kJTIwbGFiZWwlMjBvbiUyMHRoZSUyMGltYWdlJTBBZnVuY3Rpb24lMjByZW5kZXJCb3goJTdCJTIwYm94JTJDJTIwbGFiZWwlMjAlN0QpJTIwJTdCJTBBJTIwJTIwY29uc3QlMjAlN0IlMjB4bWF4JTJDJTIweG1pbiUyQyUyMHltYXglMkMlMjB5bWluJTIwJTdEJTIwJTNEJTIwYm94JTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwR2VuZXJhdGUlMjBhJTIwcmFuZG9tJTIwY29sb3IlMjBmb3IlMjB0aGUlMjBib3glMEElMjAlMjBjb25zdCUyMGNvbG9yJTIwJTNEJTIwJTIyJTIzJTIyJTIwJTJCJTIwTWF0aC5mbG9vcihNYXRoLnJhbmRvbSgpJTIwKiUyMDB4ZmZmZmZmKS50b1N0cmluZygxNikucGFkU3RhcnQoNiUyQyUyMDApJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwRHJhdyUyMHRoZSUyMGJveCUwQSUyMCUyMGNvbnN0JTIwYm94RWxlbWVudCUyMCUzRCUyMGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJTIyZGl2JTIyKSUzQiUwQSUyMCUyMGJveEVsZW1lbnQuY2xhc3NOYW1lJTIwJTNEJTIwJTIyYm91bmRpbmctYm94JTIyJTNCJTBBJTIwJTIwT2JqZWN0LmFzc2lnbihib3hFbGVtZW50LnN0eWxlJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwYm9yZGVyQ29sb3IlM0ElMjBjb2xvciUyQyUwQSUyMCUyMCUyMCUyMGxlZnQlM0ElMjAxMDAlMjAqJTIweG1pbiUyMCUyQiUyMCUyMiUyNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcCUzQSUyMDEwMCUyMColMjB5bWluJTIwJTJCJTIwJTIyJTI1JTIyJTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0ElMjAxMDAlMjAqJTIwKHhtYXglMjAtJTIweG1pbiklMjAlMkIlMjAlMjIlMjUlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0ElMjAxMDAlMjAqJTIwKHltYXglMjAtJTIweW1pbiklMjAlMkIlMjAlMjIlMjUlMjIlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwRHJhdyUyMHRoZSUyMGxhYmVsJTBBJTIwJTIwY29uc3QlMjBsYWJlbEVsZW1lbnQlMjAlM0QlMjBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCUyMnNwYW4lMjIpJTNCJTBBJTIwJTIwbGFiZWxFbGVtZW50LnRleHRDb250ZW50JTIwJTNEJTIwbGFiZWwlM0IlMEElMjAlMjBsYWJlbEVsZW1lbnQuY2xhc3NOYW1lJTIwJTNEJTIwJTIyYm91bmRpbmctYm94LWxhYmVsJTIyJTNCJTBBJTIwJTIwbGFiZWxFbGVtZW50LnN0eWxlLmJhY2tncm91bmRDb2xvciUyMCUzRCUyMGNvbG9yJTNCJTBBJTBBJTIwJTIwYm94RWxlbWVudC5hcHBlbmRDaGlsZChsYWJlbEVsZW1lbnQpJTNCJTBBJTIwJTIwaW1hZ2VDb250YWluZXIuYXBwZW5kQ2hpbGQoYm94RWxlbWVudCklM0IlMEElN0Q=",highlighted:`<span class="hljs-comment">// Render a bounding box and label on the image</span>
<span class="hljs-keyword">function</span> <span class="hljs-title function_">renderBox</span>(<span class="hljs-params">{ box, label }</span>) {
  <span class="hljs-keyword">const</span> { xmax, xmin, ymax, ymin } = box;

  <span class="hljs-comment">// Generate a random color for the box</span>
  <span class="hljs-keyword">const</span> color = <span class="hljs-string">&quot;#&quot;</span> + <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">floor</span>(<span class="hljs-title class_">Math</span>.<span class="hljs-title function_">random</span>() * <span class="hljs-number">0xffffff</span>).<span class="hljs-title function_">toString</span>(<span class="hljs-number">16</span>).<span class="hljs-title function_">padStart</span>(<span class="hljs-number">6</span>, <span class="hljs-number">0</span>);

  <span class="hljs-comment">// Draw the box</span>
  <span class="hljs-keyword">const</span> boxElement = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;div&quot;</span>);
  boxElement.<span class="hljs-property">className</span> = <span class="hljs-string">&quot;bounding-box&quot;</span>;
  <span class="hljs-title class_">Object</span>.<span class="hljs-title function_">assign</span>(boxElement.<span class="hljs-property">style</span>, {
    <span class="hljs-attr">borderColor</span>: color,
    <span class="hljs-attr">left</span>: <span class="hljs-number">100</span> * xmin + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">top</span>: <span class="hljs-number">100</span> * ymin + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">width</span>: <span class="hljs-number">100</span> * (xmax - xmin) + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">height</span>: <span class="hljs-number">100</span> * (ymax - ymin) + <span class="hljs-string">&quot;%&quot;</span>,
  });

  <span class="hljs-comment">// Draw the label</span>
  <span class="hljs-keyword">const</span> labelElement = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;span&quot;</span>);
  labelElement.<span class="hljs-property">textContent</span> = label;
  labelElement.<span class="hljs-property">className</span> = <span class="hljs-string">&quot;bounding-box-label&quot;</span>;
  labelElement.<span class="hljs-property">style</span>.<span class="hljs-property">backgroundColor</span> = color;

  boxElement.<span class="hljs-title function_">appendChild</span>(labelElement);
  imageContainer.<span class="hljs-title function_">appendChild</span>(boxElement);
}`,wrap:!1}}),Ue=new T({props:{code:"LmJvdW5kaW5nLWJveCUyMCU3QiUwQSUyMCUyMHBvc2l0aW9uJTNBJTIwYWJzb2x1dGUlM0IlMEElMjAlMjBib3gtc2l6aW5nJTNBJTIwYm9yZGVyLWJveCUzQiUwQSU3RCUwQSUwQS5ib3VuZGluZy1ib3gtbGFiZWwlMjAlN0IlMEElMjAlMjBwb3NpdGlvbiUzQSUyMGFic29sdXRlJTNCJTBBJTIwJTIwY29sb3IlM0ElMjB3aGl0ZSUzQiUwQSUyMCUyMGZvbnQtc2l6ZSUzQSUyMDEycHglM0IlMEElN0Q=",highlighted:`<span class="hljs-selector-class">.bounding-box</span> {
  <span class="hljs-attribute">position</span>: absolute;
  <span class="hljs-attribute">box-sizing</span>: border-box;
}

<span class="hljs-selector-class">.bounding-box-label</span> {
  <span class="hljs-attribute">position</span>: absolute;
  <span class="hljs-attribute">color</span>: white;
  <span class="hljs-attribute">font-size</span>: <span class="hljs-number">12px</span>;
}`,wrap:!1}}),{c(){c=p("meta"),w=a(),j=p("p"),J=a(),r(I.$$.fragment),Ze=a(),U=p("p"),U.textContent=_t,ke=a(),C=p("p"),C.textContent=Vt,Ge=a(),v=p("p"),v.innerHTML=qt,Ee=a(),$=p("p"),$.textContent=zt,Ne=a(),B=p("ul"),B.innerHTML=Xt,He=a(),r(x.$$.fragment),Qe=a(),W=p("p"),W.innerHTML=Ft,Le=a(),r(Z.$$.fragment),Ae=a(),k=p("details"),k.innerHTML=Pt,Re=a(),G=p("p"),G.innerHTML=Dt,Se=a(),r(E.$$.fragment),Ye=a(),N=p("p"),N.textContent=Kt,_e=a(),H=p("p"),H.innerHTML=Ot,Ve=a(),r(Q.$$.fragment),qe=a(),L=p("p"),L.innerHTML=es,ze=a(),r(A.$$.fragment),Xe=a(),r(f.$$.fragment),Fe=a(),R=p("p"),R.innerHTML=ts,Pe=a(),r(S.$$.fragment),De=a(),Y=p("p"),Y.textContent=ss,Ke=a(),r(_.$$.fragment),Oe=a(),V=p("p"),V.textContent=ls,et=a(),r(q.$$.fragment),tt=a(),r(z.$$.fragment),st=a(),X=p("p"),X.innerHTML=as,lt=a(),F=p("p"),F.innerHTML=ns,at=a(),r(P.$$.fragment),nt=a(),r(y.$$.fragment),pt=a(),D=p("p"),D.innerHTML=ps,it=a(),r(K.$$.fragment),ot=a(),O=p("p"),O.innerHTML=is,ct=a(),ee=p("ol"),ee.innerHTML=os,rt=a(),te=p("p"),te.textContent=cs,ht=a(),r(se.$$.fragment),dt=a(),r(le.$$.fragment),mt=a(),ae=p("p"),ae.innerHTML=rs,ut=a(),r(ne.$$.fragment),Mt=a(),pe=p("p"),pe.innerHTML=hs,jt=a(),ie=p("p"),ie.innerHTML=ds,Tt=a(),oe=p("p"),oe.innerHTML=ms,wt=a(),r(ce.$$.fragment),Jt=a(),re=p("p"),re.innerHTML=us,bt=a(),r(he.$$.fragment),ft=a(),r(g.$$.fragment),yt=a(),de=p("p"),de.innerHTML=Ms,gt=a(),me=p("p"),me.textContent=js,It=a(),ue=p("ul"),ue.innerHTML=Ts,Ut=a(),Me=p("p"),Me.textContent=ws,Ct=a(),je=p("p"),je.innerHTML=Js,vt=a(),Te=p("p"),Te.innerHTML=bs,$t=a(),r(we.$$.fragment),Bt=a(),Je=p("p"),Je.innerHTML=fs,xt=a(),be=p("p"),be.innerHTML=ys,Wt=a(),r(fe.$$.fragment),Zt=a(),ye=p("p"),ye.innerHTML=gs,kt=a(),r(ge.$$.fragment),Gt=a(),Ie=p("p"),Ie.innerHTML=Is,Et=a(),r(Ue.$$.fragment),Nt=a(),Ce=p("p"),Ce.innerHTML=Us,Ht=a(),ve=p("p"),ve.textContent=Cs,Qt=a(),$e=p("p"),$e.innerHTML=vs,Lt=a(),Be=p("p"),Be.innerHTML=$s,At=a(),We=p("p"),this.h()},l(e){const t=Qs("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(s),w=n(e),j=i(e,"P",{}),Zs(j).forEach(s),J=n(e),h(I.$$.fragment,e),Ze=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-124rffi"&&(U.textContent=_t),ke=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-10r3y0k"&&(C.textContent=Vt),Ge=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-13hi3r9"&&(v.innerHTML=qt),Ee=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1tlxmzn"&&($.textContent=zt),Ne=n(e),B=i(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-chjo94"&&(B.innerHTML=Xt),He=n(e),h(x.$$.fragment,e),Qe=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ro6f4o"&&(W.innerHTML=Ft),Le=n(e),h(Z.$$.fragment,e),Ae=n(e),k=i(e,"DETAILS",{"data-svelte-h":!0}),o(k)!=="svelte-m0rku7"&&(k.innerHTML=Pt),Re=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ipxrld"&&(G.innerHTML=Dt),Se=n(e),h(E.$$.fragment,e),Ye=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-9b3nck"&&(N.textContent=Kt),_e=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-mwib6l"&&(H.innerHTML=Ot),Ve=n(e),h(Q.$$.fragment,e),qe=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-k9jxb8"&&(L.innerHTML=es),ze=n(e),h(A.$$.fragment,e),Xe=n(e),h(f.$$.fragment,e),Fe=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-mqvw0e"&&(R.innerHTML=ts),Pe=n(e),h(S.$$.fragment,e),De=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1cxz7vo"&&(Y.textContent=ss),Ke=n(e),h(_.$$.fragment,e),Oe=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-2hgpai"&&(V.textContent=ls),et=n(e),h(q.$$.fragment,e),tt=n(e),h(z.$$.fragment,e),st=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-8aqvuv"&&(X.innerHTML=as),lt=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-4x6koj"&&(F.innerHTML=ns),at=n(e),h(P.$$.fragment,e),nt=n(e),h(y.$$.fragment,e),pt=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-nzqjt5"&&(D.innerHTML=ps),it=n(e),h(K.$$.fragment,e),ot=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-eu4w8s"&&(O.innerHTML=is),ct=n(e),ee=i(e,"OL",{"data-svelte-h":!0}),o(ee)!=="svelte-1fsg0h3"&&(ee.innerHTML=os),rt=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1qhlioo"&&(te.textContent=cs),ht=n(e),h(se.$$.fragment,e),dt=n(e),h(le.$$.fragment,e),mt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1s0f9r2"&&(ae.innerHTML=rs),ut=n(e),h(ne.$$.fragment,e),Mt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1lk01wa"&&(pe.innerHTML=hs),jt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-4ka4xl"&&(ie.innerHTML=ds),Tt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-16s7klb"&&(oe.innerHTML=ms),wt=n(e),h(ce.$$.fragment,e),Jt=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-17edfdz"&&(re.innerHTML=us),bt=n(e),h(he.$$.fragment,e),ft=n(e),h(g.$$.fragment,e),yt=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-8pzcmm"&&(de.innerHTML=Ms),gt=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-vbn04e"&&(me.textContent=js),It=n(e),ue=i(e,"UL",{"data-svelte-h":!0}),o(ue)!=="svelte-1flghaj"&&(ue.innerHTML=Ts),Ut=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-vz1vzo"&&(Me.textContent=ws),Ct=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1e4bl98"&&(je.innerHTML=Js),vt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-ey5r3r"&&(Te.innerHTML=bs),$t=n(e),h(we.$$.fragment,e),Bt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-xglmdw"&&(Je.innerHTML=fs),xt=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-6b76js"&&(be.innerHTML=ys),Wt=n(e),h(fe.$$.fragment,e),Zt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-88zjgn"&&(ye.innerHTML=gs),kt=n(e),h(ge.$$.fragment,e),Gt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1otf5ry"&&(Ie.innerHTML=Is),Et=n(e),h(Ue.$$.fragment,e),Nt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-4x54i7"&&(Ce.innerHTML=Us),Ht=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1gkj58a"&&(ve.textContent=Cs),Qt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1yhdijg"&&($e.innerHTML=vs),Lt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-9xei6b"&&(Be.innerHTML=$s),At=n(e),We=i(e,"P",{}),Zs(We).forEach(s),this.h()},h(){ks(c,"name","hf:doc:metadata"),ks(c,"content",_s)},m(e,t){Ls(document.head,c),l(e,w,t),l(e,j,t),l(e,J,t),d(I,e,t),l(e,Ze,t),l(e,U,t),l(e,ke,t),l(e,C,t),l(e,Ge,t),l(e,v,t),l(e,Ee,t),l(e,$,t),l(e,Ne,t),l(e,B,t),l(e,He,t),d(x,e,t),l(e,Qe,t),l(e,W,t),l(e,Le,t),d(Z,e,t),l(e,Ae,t),l(e,k,t),l(e,Re,t),l(e,G,t),l(e,Se,t),d(E,e,t),l(e,Ye,t),l(e,N,t),l(e,_e,t),l(e,H,t),l(e,Ve,t),d(Q,e,t),l(e,qe,t),l(e,L,t),l(e,ze,t),d(A,e,t),l(e,Xe,t),d(f,e,t),l(e,Fe,t),l(e,R,t),l(e,Pe,t),d(S,e,t),l(e,De,t),l(e,Y,t),l(e,Ke,t),d(_,e,t),l(e,Oe,t),l(e,V,t),l(e,et,t),d(q,e,t),l(e,tt,t),d(z,e,t),l(e,st,t),l(e,X,t),l(e,lt,t),l(e,F,t),l(e,at,t),d(P,e,t),l(e,nt,t),d(y,e,t),l(e,pt,t),l(e,D,t),l(e,it,t),d(K,e,t),l(e,ot,t),l(e,O,t),l(e,ct,t),l(e,ee,t),l(e,rt,t),l(e,te,t),l(e,ht,t),d(se,e,t),l(e,dt,t),d(le,e,t),l(e,mt,t),l(e,ae,t),l(e,ut,t),d(ne,e,t),l(e,Mt,t),l(e,pe,t),l(e,jt,t),l(e,ie,t),l(e,Tt,t),l(e,oe,t),l(e,wt,t),d(ce,e,t),l(e,Jt,t),l(e,re,t),l(e,bt,t),d(he,e,t),l(e,ft,t),d(g,e,t),l(e,yt,t),l(e,de,t),l(e,gt,t),l(e,me,t),l(e,It,t),l(e,ue,t),l(e,Ut,t),l(e,Me,t),l(e,Ct,t),l(e,je,t),l(e,vt,t),l(e,Te,t),l(e,$t,t),d(we,e,t),l(e,Bt,t),l(e,Je,t),l(e,xt,t),l(e,be,t),l(e,Wt,t),d(fe,e,t),l(e,Zt,t),l(e,ye,t),l(e,kt,t),d(ge,e,t),l(e,Gt,t),l(e,Ie,t),l(e,Et,t),d(Ue,e,t),l(e,Nt,t),l(e,Ce,t),l(e,Ht,t),l(e,ve,t),l(e,Qt,t),l(e,$e,t),l(e,Lt,t),l(e,Be,t),l(e,At,t),l(e,We,t),Rt=!0},p(e,[t]){const Bs={};t&2&&(Bs.$$scope={dirty:t,ctx:e}),f.$set(Bs);const xs={};t&2&&(xs.$$scope={dirty:t,ctx:e}),y.$set(xs);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),g.$set(Ws)},i(e){Rt||(m(I.$$.fragment,e),m(x.$$.fragment,e),m(Z.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(f.$$.fragment,e),m(S.$$.fragment,e),m(_.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(y.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(g.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(Ue.$$.fragment,e),Rt=!0)},o(e){u(I.$$.fragment,e),u(x.$$.fragment,e),u(Z.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(f.$$.fragment,e),u(S.$$.fragment,e),u(_.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(y.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(g.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Ue.$$.fragment,e),Rt=!1},d(e){e&&(s(w),s(j),s(J),s(Ze),s(U),s(ke),s(C),s(Ge),s(v),s(Ee),s($),s(Ne),s(B),s(He),s(Qe),s(W),s(Le),s(Ae),s(k),s(Re),s(G),s(Se),s(Ye),s(N),s(_e),s(H),s(Ve),s(qe),s(L),s(ze),s(Xe),s(Fe),s(R),s(Pe),s(De),s(Y),s(Ke),s(Oe),s(V),s(et),s(tt),s(st),s(X),s(lt),s(F),s(at),s(nt),s(pt),s(D),s(it),s(ot),s(O),s(ct),s(ee),s(rt),s(te),s(ht),s(dt),s(mt),s(ae),s(ut),s(Mt),s(pe),s(jt),s(ie),s(Tt),s(oe),s(wt),s(Jt),s(re),s(bt),s(ft),s(yt),s(de),s(gt),s(me),s(It),s(ue),s(Ut),s(Me),s(Ct),s(je),s(vt),s(Te),s($t),s(Bt),s(Je),s(xt),s(be),s(Wt),s(Zt),s(ye),s(kt),s(Gt),s(Ie),s(Et),s(Nt),s(Ce),s(Ht),s(ve),s(Qt),s($e),s(Lt),s(Be),s(At),s(We)),s(c),M(I,e),M(x,e),M(Z,e),M(E,e),M(Q,e),M(A,e),M(f,e),M(S,e),M(_,e),M(q,e),M(z,e),M(P,e),M(y,e),M(K,e),M(se,e),M(le,e),M(ne,e),M(ce,e),M(he,e),M(g,e),M(we,e),M(fe,e),M(ge,e),M(Ue,e)}}}const _s='{"title":"Building a Vanilla JavaScript Application","local":"building-a-vanilla-javascript-application","sections":[{"title":"Step 1:  HTML and CSS setup","local":"step-1-html-and-css-setup","sections":[],"depth":2},{"title":"Step 2: JavaScript setup","local":"step-2-javascript-setup","sections":[],"depth":2},{"title":"Step 3: Create an object detection pipeline","local":"step-3-create-an-object-detection-pipeline","sections":[],"depth":2},{"title":"Step 4: Create the image uploader","local":"step-4-create-the-image-uploader","sections":[],"depth":2},{"title":"Step 5: Run the model","local":"step-5-run-the-model","sections":[],"depth":2},{"title":"Step 6: Render the boxes","local":"step-6-render-the-boxes","sections":[],"depth":2}],"depth":1}';function Vs(b){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ns{constructor(c){super(),Hs(this,c,Vs,Ys,Gs,{})}}export{Ds as component};
