import{s as na,o as pa,n as ia}from"../chunks/scheduler.bdbef820.js";import{S as ma,i as ca,g as p,s as l,r as o,A as oa,h as i,f as t,c as n,j as la,u as r,x as m,k as D,y as ra,a as e,v as M,d as h,t as g,w as j}from"../chunks/index.c0aea24a.js";import{T as Ma}from"../chunks/Tip.31005f7d.js";import{C as u}from"../chunks/CodeBlock.6ccca92e.js";import{H as ha}from"../chunks/Heading.2eb892cb.js";function ga(as){let c,w=`Now that you know how to process a dataset for semantic segmentation, learn
<a href="https://huggingface.co/docs/transformers/tasks/semantic_segmentation" rel="nofollow">how to train a semantic segmentation model</a>
and use it for inference.`;return{c(){c=p("p"),c.innerHTML=w},l(y){c=i(y,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1tl2bt5"&&(c.innerHTML=w)},m(y,O){e(y,c,O)},p:ia,d(y){y&&t(c)}}}function ja(as){let c,w,y,O,C,ts,v,Qs=`Semantic segmentation datasets are used to train a model to classify every pixel in an image. There are
a wide variety of applications enabled by these datasets such as background removal from images, stylizing
images, or scene understanding for autonomous driving. This guide will show you how to apply transformations
to an image segmentation dataset.`,es,I,Gs="Before you start, make sure you have up-to-date versions of <code>albumentations</code> and <code>cv2</code> installed:",ls,Z,ns,x,Ys=`<a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> is a Python library for performing data augmentation
for computer vision. It supports various computer vision tasks such as image classification, object
detection, segmentation, and keypoint estimation.`,ps,k,zs=`This guide uses the <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">Scene Parsing</a> dataset for segmenting
and parsing an image into different image regions associated with semantic categories, such as sky, road, person, and bed.`,is,B,Vs="Load the <code>train</code> split of the dataset and take a look at an example:",ms,_,cs,$,Rs="The dataset has three fields:",os,W,Fs="<li><code>image</code>: a PIL image object.</li> <li><code>annotation</code>: segmentation mask of the image.</li> <li><code>scene_category</code>: the label or scene category of the image (like “kitchen” or “office”).</li>",rs,X,Ns="Next, check out an image with:",Ms,Q,hs,d,Ss='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/image_seg.png"/>',gs,G,Es="Similarly, you can check out the respective segmentation mask:",js,Y,ys,f,Hs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/seg_mask.png"/>',us,z,As=`We can also add a <a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">color palette</a> on the
segmentation mask and overlay it on top of the original image to visualize the dataset:`,ds,V,Ls="After defining the color palette, you should be ready to visualize some overlays.",fs,R,Js,J,qs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/seg_overlay.png"/>',Us,F,Ps="Now apply some augmentations with <code>albumentations</code>. You’ll first resize the image and adjust its brightness.",bs,N,Ts,S,Ks="Create a function to apply the transformation to the images:",ws,E,Cs,H,Ds='Use the <a href="/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transformation on-the-fly to batches of the dataset to consume less disk space:',vs,A,Is,L,Os="You can verify the transformation worked by indexing into the <code>pixel_values</code> and <code>label</code> of an example:",Zs,q,xs,U,sa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/albumentations_seg.png"/>',ks,P,aa="In this guide, you have used <code>albumentations</code> for augmenting the dataset. It’s also possible to use <code>torchvision</code> to apply some similar transforms.",Bs,K,_s,b,ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/torchvision_seg.png"/>',$s,T,Ws,ss,Xs;return C=new ha({props:{title:"Semantic segmentation",local:"semantic-segmentation",headingTag:"h1"}}),Z=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjBvcGVuY3YtcHl0aG9u",highlighted:"pip install -U albumentations opencv-python",wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzY2VuZV9wYXJzZV8xNTAlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWluZGV4JTIwJTNEJTIwMTAlMEFkYXRhc2V0JTVCaW5kZXglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>index = <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=683x512 at <span class="hljs-number">0x7FB37B0EC810</span>&gt;,
 <span class="hljs-string">&#x27;annotation&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=L size=683x512 at <span class="hljs-number">0x7FB37B0EC9D0</span>&gt;,
 <span class="hljs-string">&#x27;scene_category&#x27;</span>: <span class="hljs-number">927</span>}`,wrap:!1}}),Q=new u({props:{code:"ZGF0YXNldCU1QmluZGV4JTVEJTVCJTIyaW1hZ2UlMjIlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),Y=new u({props:{code:"ZGF0YXNldCU1QmluZGV4JTVEJTVCJTIyYW5ub3RhdGlvbiUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index][<span class="hljs-string">&quot;annotation&quot;</span>]',wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWRlZiUyMHZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUzQSUyMG5wLm5kYXJyYXklMkMlMjBtYXNrJTNBJTIwbnAubmRhcnJheSklM0ElMEElMjAlMjAlMjBjb2xvcl9zZWclMjAlM0QlMjBucC56ZXJvcygobWFzay5zaGFwZSU1QjAlNUQlMkMlMjBtYXNrLnNoYXBlJTVCMSU1RCUyQyUyMDMpJTJDJTIwZHR5cGUlM0RucC51aW50OCklMEElMjAlMjAlMjBwYWxldHRlJTIwJTNEJTIwbnAuYXJyYXkoY3JlYXRlX2FkZTIwa19sYWJlbF9jb2xvcm1hcCgpKSUwQSUyMCUyMCUyMGZvciUyMGxhYmVsJTJDJTIwY29sb3IlMjBpbiUyMGVudW1lcmF0ZShwYWxldHRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbG9yX3NlZyU1Qm1hc2slMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBJTIwJTIwJTIwY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEElMjAlMjAlMjBpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEElMjAlMjAlMjBpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMHBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEElMjAlMjAlMjBwbHQuaW1zaG93KGltZyklMEElMjAlMjAlMjBwbHQuYXhpcyglMjJvZmYlMjIpJTBBJTIwJTIwJTIwcGx0LnNob3coKSUwQSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayglMEElMjAlMjAlMjAlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJpbWFnZSUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJhbm5vdGF0aW9uJTIyJTVEKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">visualize_seg_mask</span>(<span class="hljs-params">image: np.ndarray, mask: np.ndarray</span>):
<span class="hljs-meta">... </span>   color_seg = np.zeros((mask.shape[<span class="hljs-number">0</span>], mask.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
<span class="hljs-meta">... </span>   palette = np.array(create_ade20k_label_colormap())
<span class="hljs-meta">... </span>   <span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
<span class="hljs-meta">... </span>       color_seg[mask == label, :] = color
<span class="hljs-meta">... </span>   color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

<span class="hljs-meta">... </span>   img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
<span class="hljs-meta">... </span>   img = img.astype(np.uint8)

<span class="hljs-meta">... </span>   plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">... </span>   plt.imshow(img)
<span class="hljs-meta">... </span>   plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>   plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(
<span class="hljs-meta">... </span>    np.array(dataset[index][<span class="hljs-string">&quot;image&quot;</span>]),
<span class="hljs-meta">... </span>    np.array(dataset[index][<span class="hljs-string">&quot;annotation&quot;</span>])
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new u({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEElMEF0cmFuc2Zvcm0lMjAlM0QlMjBhbGJ1bWVudGF0aW9ucy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJlc2l6ZSgyNTYlMkMlMjAyNTYpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmFuZG9tQnJpZ2h0bmVzc0NvbnRyYXN0KGJyaWdodG5lc3NfbGltaXQlM0QwLjMlMkMlMjBjb250cmFzdF9saW1pdCUzRDAuMyUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(brightness_limit=<span class="hljs-number">0.3</span>, contrast_limit=<span class="hljs-number">0.3</span>, p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new u({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9pbWFnZXMlMkMlMjB0cmFuc2Zvcm1lZF9tYXNrcyUyMCUzRCUyMCU1QiU1RCUyQyUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGltYWdlJTJDJTIwc2VnX21hc2slMjBpbiUyMHppcChleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJhbm5vdGF0aW9uJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTJDJTIwc2VnX21hc2slMjAlM0QlMjBucC5hcnJheShpbWFnZSklMkMlMjBucC5hcnJheShzZWdfbWFzayklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwbWFzayUzRHNlZ19tYXNrKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVkX2ltYWdlcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9tYXNrcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJtYXNrJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwdHJhbnNmb3JtZWRfaW1hZ2VzJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJsYWJlbCUyMiU1RCUyMCUzRCUyMHRyYW5zZm9ybWVkX21hc2tzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    transformed_images, transformed_masks = [], []
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, seg_mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;annotation&quot;</span>]):
<span class="hljs-meta">... </span>        image, seg_mask = np.array(image), np.array(seg_mask)
<span class="hljs-meta">... </span>        transformed = transform(image=image, mask=seg_mask)
<span class="hljs-meta">... </span>        transformed_images.append(transformed[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        transformed_masks.append(transformed[<span class="hljs-string">&quot;mask&quot;</span>])
...
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = transformed_images
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;label&quot;</span>] = transformed_masks
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),A=new u({props:{code:"ZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transforms)',wrap:!1}}),q=new u({props:{code:"aW1hZ2UlMjAlM0QlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQpJTBBbWFzayUyMCUzRCUyMG5wLmFycmF5KGRhdGFzZXQlNUJpbmRleCU1RCU1QiUyMmxhYmVsJTIyJTVEKSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(dataset[index][<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.array(dataset[index][<span class="hljs-string">&quot;label&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(image, mask)`,wrap:!1}}),K=new u({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBSZXNpemUlMkMlMjBDb2xvckppdHRlciUyQyUyMENvbXBvc2UlMEElMEF0cmFuc2Zvcm1hdGlvbl9jaGFpbiUyMCUzRCUyMENvbXBvc2UoJTVCJTBBJTIwJTIwJTIwJTIwUmVzaXplKCgyNTYlMkMlMjAyNTYpKSUyQyUwQSUyMCUyMCUyMCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEpJTBBJTVEKSUwQXJlc2l6ZSUyMCUzRCUyMFJlc2l6ZSgoMjU2JTJDJTIwMjU2KSklMEElMEFkZWYlMjB0cmFpbl90cmFuc2Zvcm1zKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYW5zZm9ybWF0aW9uX2NoYWluKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwJTVCcmVzaXplKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmFubm90YXRpb24lMjIlNUQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlX2JhdGNoJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYWluX3RyYW5zZm9ybXMpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQpJTBBbWFzayUyMCUzRCUyMG5wLmFycmF5KGRhdGFzZXQlNUJpbmRleCU1RCU1QiUyMmxhYmVsJTIyJTVEKSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Resize, ColorJitter, Compose

<span class="hljs-meta">&gt;&gt;&gt; </span>transformation_chain = Compose([
<span class="hljs-meta">... </span>    Resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>)),
<span class="hljs-meta">... </span>    ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">... </span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>resize = Resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [transformation_chain(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    example_batch[<span class="hljs-string">&quot;label&quot;</span>] = [resize(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(train_transforms)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(dataset[index][<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.array(dataset[index][<span class="hljs-string">&quot;label&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(image, mask)`,wrap:!1}}),T=new Ma({props:{$$slots:{default:[ga]},$$scope:{ctx:as}}}),{c(){c=p("meta"),w=l(),y=p("p"),O=l(),o(C.$$.fragment),ts=l(),v=p("p"),v.textContent=Qs,es=l(),I=p("p"),I.innerHTML=Gs,ls=l(),o(Z.$$.fragment),ns=l(),x=p("p"),x.innerHTML=Ys,ps=l(),k=p("p"),k.innerHTML=zs,is=l(),B=p("p"),B.innerHTML=Vs,ms=l(),o(_.$$.fragment),cs=l(),$=p("p"),$.textContent=Rs,os=l(),W=p("ul"),W.innerHTML=Fs,rs=l(),X=p("p"),X.textContent=Ns,Ms=l(),o(Q.$$.fragment),hs=l(),d=p("div"),d.innerHTML=Ss,gs=l(),G=p("p"),G.textContent=Es,js=l(),o(Y.$$.fragment),ys=l(),f=p("div"),f.innerHTML=Hs,us=l(),z=p("p"),z.innerHTML=As,ds=l(),V=p("p"),V.textContent=Ls,fs=l(),o(R.$$.fragment),Js=l(),J=p("div"),J.innerHTML=qs,Us=l(),F=p("p"),F.innerHTML=Ps,bs=l(),o(N.$$.fragment),Ts=l(),S=p("p"),S.textContent=Ks,ws=l(),o(E.$$.fragment),Cs=l(),H=p("p"),H.innerHTML=Ds,vs=l(),o(A.$$.fragment),Is=l(),L=p("p"),L.innerHTML=Os,Zs=l(),o(q.$$.fragment),xs=l(),U=p("div"),U.innerHTML=sa,ks=l(),P=p("p"),P.innerHTML=aa,Bs=l(),o(K.$$.fragment),_s=l(),b=p("div"),b.innerHTML=ta,$s=l(),o(T.$$.fragment),Ws=l(),ss=p("p"),this.h()},l(s){const a=oa("svelte-u9bgzb",document.head);c=i(a,"META",{name:!0,content:!0}),a.forEach(t),w=n(s),y=i(s,"P",{}),la(y).forEach(t),O=n(s),r(C.$$.fragment,s),ts=n(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-fw4ret"&&(v.textContent=Qs),es=n(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1qtuikq"&&(I.innerHTML=Gs),ls=n(s),r(Z.$$.fragment,s),ns=n(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-180f5nb"&&(x.innerHTML=Ys),ps=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1jjf6cy"&&(k.innerHTML=zs),is=n(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-pju1x0"&&(B.innerHTML=Vs),ms=n(s),r(_.$$.fragment,s),cs=n(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-jjwn46"&&($.textContent=Rs),os=n(s),W=i(s,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-1r68wni"&&(W.innerHTML=Fs),rs=n(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-15dthpv"&&(X.textContent=Ns),Ms=n(s),r(Q.$$.fragment,s),hs=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(d)!=="svelte-1337354"&&(d.innerHTML=Ss),gs=n(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-qlholw"&&(G.textContent=Es),js=n(s),r(Y.$$.fragment,s),ys=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-ru2vd9"&&(f.innerHTML=Hs),us=n(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vzaie7"&&(z.innerHTML=As),ds=n(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-vvbf2j"&&(V.textContent=Ls),fs=n(s),r(R.$$.fragment,s),Js=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-1unth95"&&(J.innerHTML=qs),Us=n(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-c3rxqx"&&(F.innerHTML=Ps),bs=n(s),r(N.$$.fragment,s),Ts=n(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-50733g"&&(S.textContent=Ks),ws=n(s),r(E.$$.fragment,s),Cs=n(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-12ygsy7"&&(H.innerHTML=Ds),vs=n(s),r(A.$$.fragment,s),Is=n(s),L=i(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-11iow8s"&&(L.innerHTML=Os),Zs=n(s),r(q.$$.fragment,s),xs=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-rz0i83"&&(U.innerHTML=sa),ks=n(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-o9kxh2"&&(P.innerHTML=aa),Bs=n(s),r(K.$$.fragment,s),_s=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-jb5bqb"&&(b.innerHTML=ta),$s=n(s),r(T.$$.fragment,s),Ws=n(s),ss=i(s,"P",{}),la(ss).forEach(t),this.h()},h(){D(c,"name","hf:doc:metadata"),D(c,"content",ya),D(d,"class","flex justify-center"),D(f,"class","flex justify-center"),D(J,"class","flex justify-center"),D(U,"class","flex justify-center"),D(b,"class","flex justify-center")},m(s,a){ra(document.head,c),e(s,w,a),e(s,y,a),e(s,O,a),M(C,s,a),e(s,ts,a),e(s,v,a),e(s,es,a),e(s,I,a),e(s,ls,a),M(Z,s,a),e(s,ns,a),e(s,x,a),e(s,ps,a),e(s,k,a),e(s,is,a),e(s,B,a),e(s,ms,a),M(_,s,a),e(s,cs,a),e(s,$,a),e(s,os,a),e(s,W,a),e(s,rs,a),e(s,X,a),e(s,Ms,a),M(Q,s,a),e(s,hs,a),e(s,d,a),e(s,gs,a),e(s,G,a),e(s,js,a),M(Y,s,a),e(s,ys,a),e(s,f,a),e(s,us,a),e(s,z,a),e(s,ds,a),e(s,V,a),e(s,fs,a),M(R,s,a),e(s,Js,a),e(s,J,a),e(s,Us,a),e(s,F,a),e(s,bs,a),M(N,s,a),e(s,Ts,a),e(s,S,a),e(s,ws,a),M(E,s,a),e(s,Cs,a),e(s,H,a),e(s,vs,a),M(A,s,a),e(s,Is,a),e(s,L,a),e(s,Zs,a),M(q,s,a),e(s,xs,a),e(s,U,a),e(s,ks,a),e(s,P,a),e(s,Bs,a),M(K,s,a),e(s,_s,a),e(s,b,a),e(s,$s,a),M(T,s,a),e(s,Ws,a),e(s,ss,a),Xs=!0},p(s,[a]){const ea={};a&2&&(ea.$$scope={dirty:a,ctx:s}),T.$set(ea)},i(s){Xs||(h(C.$$.fragment,s),h(Z.$$.fragment,s),h(_.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(R.$$.fragment,s),h(N.$$.fragment,s),h(E.$$.fragment,s),h(A.$$.fragment,s),h(q.$$.fragment,s),h(K.$$.fragment,s),h(T.$$.fragment,s),Xs=!0)},o(s){g(C.$$.fragment,s),g(Z.$$.fragment,s),g(_.$$.fragment,s),g(Q.$$.fragment,s),g(Y.$$.fragment,s),g(R.$$.fragment,s),g(N.$$.fragment,s),g(E.$$.fragment,s),g(A.$$.fragment,s),g(q.$$.fragment,s),g(K.$$.fragment,s),g(T.$$.fragment,s),Xs=!1},d(s){s&&(t(w),t(y),t(O),t(ts),t(v),t(es),t(I),t(ls),t(ns),t(x),t(ps),t(k),t(is),t(B),t(ms),t(cs),t($),t(os),t(W),t(rs),t(X),t(Ms),t(hs),t(d),t(gs),t(G),t(js),t(ys),t(f),t(us),t(z),t(ds),t(V),t(fs),t(Js),t(J),t(Us),t(F),t(bs),t(Ts),t(S),t(ws),t(Cs),t(H),t(vs),t(Is),t(L),t(Zs),t(xs),t(U),t(ks),t(P),t(Bs),t(_s),t(b),t($s),t(Ws),t(ss)),t(c),j(C,s),j(Z,s),j(_,s),j(Q,s),j(Y,s),j(R,s),j(N,s),j(E,s),j(A,s),j(q,s),j(K,s),j(T,s)}}}const ya='{"title":"Semantic segmentation","local":"semantic-segmentation","sections":[],"depth":1}';function ua(as){return pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends ma{constructor(c){super(),ca(this,c,ua,ja,na,{})}}export{Ta as component};
