import{s as Zt,n as vt,o as Wt}from"../chunks/scheduler.85c25b89.js";import{S as Gt,i as kt,g as p,s as a,r as i,A as Bt,h as m,f as l,c as n,j as Ct,u as o,x as g,k as It,y as Nt,a as e,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as A,E as Qt}from"../chunks/index.b36f1b99.js";function _t(jt){let j,Y,R,H,d,S,w,dt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',z,y,wt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',F,J,L,u,yt="To load a pretrained model:",D,f,P,T,Jt="To load and preprocess the image:",q,b,K,U,ut="To get the model predictions:",O,$,tt,x,ft="To get the top-5 predictions class names:",st,C,lt,I,Tt="Replace the model name with the variant you want to use, e.g. <code>tf_mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",et,Z,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,v,nt,W,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,G,mt,k,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,N,xt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Q,ct,_,ht,E,Mt,X,gt;return d=new A({props:{title:"(Tensorflow) MixNet",local:"tensorflow-mixnet",headingTag:"h1"}}),J=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new V({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),E=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tf-mixnet.mdx"}}),{c(){j=p("meta"),Y=a(),R=p("p"),H=a(),i(d.$$.fragment),S=a(),w=p("p"),w.innerHTML=dt,z=a(),y=p("p"),y.innerHTML=wt,F=a(),i(J.$$.fragment),L=a(),u=p("p"),u.textContent=yt,D=a(),i(f.$$.fragment),P=a(),T=p("p"),T.textContent=Jt,q=a(),i(b.$$.fragment),K=a(),U=p("p"),U.textContent=ut,O=a(),i($.$$.fragment),tt=a(),x=p("p"),x.textContent=ft,st=a(),i(C.$$.fragment),lt=a(),I=p("p"),I.innerHTML=Tt,et=a(),Z=p("p"),Z.innerHTML=bt,at=a(),i(v.$$.fragment),nt=a(),W=p("p"),W.textContent=Ut,pt=a(),i(G.$$.fragment),mt=a(),k=p("p"),k.innerHTML=$t,it=a(),i(B.$$.fragment),ot=a(),N=p("p"),N.innerHTML=xt,rt=a(),i(Q.$$.fragment),ct=a(),i(_.$$.fragment),ht=a(),i(E.$$.fragment),Mt=a(),X=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),Y=n(t),R=m(t,"P",{}),Ct(R).forEach(l),H=n(t),o(d.$$.fragment,t),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-ipcg9j"&&(w.innerHTML=dt),z=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-k8hpf1"&&(y.innerHTML=wt),F=n(t),o(J.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=yt),D=n(t),o(f.$$.fragment,t),P=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),q=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),O=n(t),o($.$$.fragment,t),tt=n(t),x=m(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-19cnvx1"&&(x.textContent=ft),st=n(t),o(C.$$.fragment,t),lt=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-148p09n"&&(I.innerHTML=Tt),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=bt),at=n(t),o(v.$$.fragment,t),nt=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=Ut),pt=n(t),o(G.$$.fragment,t),mt=n(t),k=m(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1kguc51"&&(k.innerHTML=$t),it=n(t),o(B.$$.fragment,t),ot=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-xtxxu6"&&(N.innerHTML=xt),rt=n(t),o(Q.$$.fragment,t),ct=n(t),o(_.$$.fragment,t),ht=n(t),o(E.$$.fragment,t),Mt=n(t),X=m(t,"P",{}),Ct(X).forEach(l),this.h()},h(){It(j,"name","hf:doc:metadata"),It(j,"content",Et)},m(t,s){Nt(document.head,j),e(t,Y,s),e(t,R,s),e(t,H,s),r(d,t,s),e(t,S,s),e(t,w,s),e(t,z,s),e(t,y,s),e(t,F,s),r(J,t,s),e(t,L,s),e(t,u,s),e(t,D,s),r(f,t,s),e(t,P,s),e(t,T,s),e(t,q,s),r(b,t,s),e(t,K,s),e(t,U,s),e(t,O,s),r($,t,s),e(t,tt,s),e(t,x,s),e(t,st,s),r(C,t,s),e(t,lt,s),e(t,I,s),e(t,et,s),e(t,Z,s),e(t,at,s),r(v,t,s),e(t,nt,s),e(t,W,s),e(t,pt,s),r(G,t,s),e(t,mt,s),e(t,k,s),e(t,it,s),r(B,t,s),e(t,ot,s),e(t,N,s),e(t,rt,s),r(Q,t,s),e(t,ct,s),r(_,t,s),e(t,ht,s),r(E,t,s),e(t,Mt,s),e(t,X,s),gt=!0},p:vt,i(t){gt||(c(d.$$.fragment,t),c(J.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(Q.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),gt=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),h(E.$$.fragment,t),gt=!1},d(t){t&&(l(Y),l(R),l(H),l(S),l(w),l(z),l(y),l(F),l(L),l(u),l(D),l(P),l(T),l(q),l(K),l(U),l(O),l(tt),l(x),l(st),l(lt),l(I),l(et),l(Z),l(at),l(nt),l(W),l(pt),l(mt),l(k),l(it),l(ot),l(N),l(rt),l(ct),l(ht),l(Mt),l(X)),l(j),M(d,t),M(J,t),M(f,t),M(b,t),M($,t),M(C,t),M(v,t),M(G,t),M(B,t),M(Q,t),M(_,t),M(E,t)}}}const Et='{"title":"(Tensorflow) MixNet","local":"tensorflow-mixnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Gt{constructor(j){super(),kt(this,j,Vt,_t,Zt,{})}}export{Ht as component};
