import{s as Is,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Ws,g as p,s as a,r as i,A as Ns,h as m,f as l,c as n,j as fs,u as o,x as j,k as Cs,y as xs,a as e,v as r,d as M,t as c,w as h}from"../chunks/index.c9837788.js";import{C as G}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Bs}from"../chunks/index.b36f1b99.js";function Es(hs){let y,X,v,H,J,Y,d,js='<strong>Wide Residual Networks</strong> are a variant on <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> where we decrease depth and increase the width of residual networks. This is achieved through the use of <a href="https://paperswithcode.com/method/wide-residual-block" rel="nofollow">wide residual blocks</a>.',S,g,z,w,ys="To load a pretrained model:",F,T,D,u,Js="To load and preprocess the image:",L,b,q,U,ds="To get the model predictions:",P,f,K,C,gs="To get the top-5 predictions class names:",O,I,ss,Z,ws="Replace the model name with the variant you want to use, e.g. <code>wide_resnet101_2</code>. You can find the IDs in the model summaries at the top of this page.",ts,$,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,k,es,W,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,N,ns,x,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,B,ms,E,Us='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,R,os,A,rs,Q,Ms,V,cs;return J=new _({props:{title:"Wide ResNet",local:"wide-resnet",headingTag:"h1"}}),g=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new G({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3dpZGVfcmVzbmV0MTAxXzInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new G({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new G({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new G({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnd2lkZV9yZXNuZXQxMDFfMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new G({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTZXJnZXklMjBaYWdvcnV5a28lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOaWtvcyUyMEtvbW9kYWtpcyU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCV2lkZSUyMFJlc2lkdWFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDUuMDcxNDYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA1LjA3MTQ2JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwNS4wNzE0NiU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEzJTIwQXVnJTIwMjAxOCUyMDE2JTNBNDYlM0E0MiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGWmFnb3J1eWtvSzE2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16,
  author    = {Sergey Zagoruyko and
               Nikos Komodakis},
  title     = {Wide Residual Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1605.07146</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1605.07146</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1605.07146</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">46</span>:<span class="hljs-number">42</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),Q=new Bs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/wide-resnet.mdx"}}),{c(){y=p("meta"),X=a(),v=p("p"),H=a(),i(J.$$.fragment),Y=a(),d=p("p"),d.innerHTML=js,S=a(),i(g.$$.fragment),z=a(),w=p("p"),w.textContent=ys,F=a(),i(T.$$.fragment),D=a(),u=p("p"),u.textContent=Js,L=a(),i(b.$$.fragment),q=a(),U=p("p"),U.textContent=ds,P=a(),i(f.$$.fragment),K=a(),C=p("p"),C.textContent=gs,O=a(),i(I.$$.fragment),ss=a(),Z=p("p"),Z.innerHTML=ws,ts=a(),$=p("p"),$.innerHTML=Ts,ls=a(),i(k.$$.fragment),es=a(),W=p("p"),W.textContent=us,as=a(),i(N.$$.fragment),ns=a(),x=p("p"),x.innerHTML=bs,ps=a(),i(B.$$.fragment),ms=a(),E=p("p"),E.innerHTML=Us,is=a(),i(R.$$.fragment),os=a(),i(A.$$.fragment),rs=a(),i(Q.$$.fragment),Ms=a(),V=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);y=m(t,"META",{name:!0,content:!0}),t.forEach(l),X=n(s),v=m(s,"P",{}),fs(v).forEach(l),H=n(s),o(J.$$.fragment,s),Y=n(s),d=m(s,"P",{"data-svelte-h":!0}),j(d)!=="svelte-k7y9u3"&&(d.innerHTML=js),S=n(s),o(g.$$.fragment,s),z=n(s),w=m(s,"P",{"data-svelte-h":!0}),j(w)!=="svelte-18ywhxh"&&(w.textContent=ys),F=n(s),o(T.$$.fragment,s),D=n(s),u=m(s,"P",{"data-svelte-h":!0}),j(u)!=="svelte-1c2ipa8"&&(u.textContent=Js),L=n(s),o(b.$$.fragment,s),q=n(s),U=m(s,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1n9qsq1"&&(U.textContent=ds),P=n(s),o(f.$$.fragment,s),K=n(s),C=m(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-19cnvx1"&&(C.textContent=gs),O=n(s),o(I.$$.fragment,s),ss=n(s),Z=m(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1x7kcxy"&&(Z.innerHTML=ws),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),j($)!=="svelte-1wmi3ea"&&($.innerHTML=Ts),ls=n(s),o(k.$$.fragment,s),es=n(s),W=m(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-9sr7nh"&&(W.textContent=us),as=n(s),o(N.$$.fragment,s),ns=n(s),x=m(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1kguc51"&&(x.innerHTML=bs),ps=n(s),o(B.$$.fragment,s),ms=n(s),E=m(s,"P",{"data-svelte-h":!0}),j(E)!=="svelte-xtxxu6"&&(E.innerHTML=Us),is=n(s),o(R.$$.fragment,s),os=n(s),o(A.$$.fragment,s),rs=n(s),o(Q.$$.fragment,s),Ms=n(s),V=m(s,"P",{}),fs(V).forEach(l),this.h()},h(){Cs(y,"name","hf:doc:metadata"),Cs(y,"content",Rs)},m(s,t){xs(document.head,y),e(s,X,t),e(s,v,t),e(s,H,t),r(J,s,t),e(s,Y,t),e(s,d,t),e(s,S,t),r(g,s,t),e(s,z,t),e(s,w,t),e(s,F,t),r(T,s,t),e(s,D,t),e(s,u,t),e(s,L,t),r(b,s,t),e(s,q,t),e(s,U,t),e(s,P,t),r(f,s,t),e(s,K,t),e(s,C,t),e(s,O,t),r(I,s,t),e(s,ss,t),e(s,Z,t),e(s,ts,t),e(s,$,t),e(s,ls,t),r(k,s,t),e(s,es,t),e(s,W,t),e(s,as,t),r(N,s,t),e(s,ns,t),e(s,x,t),e(s,ps,t),r(B,s,t),e(s,ms,t),e(s,E,t),e(s,is,t),r(R,s,t),e(s,os,t),r(A,s,t),e(s,rs,t),r(Q,s,t),e(s,Ms,t),e(s,V,t),cs=!0},p:Zs,i(s){cs||(M(J.$$.fragment,s),M(g.$$.fragment,s),M(T.$$.fragment,s),M(b.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(B.$$.fragment,s),M(R.$$.fragment,s),M(A.$$.fragment,s),M(Q.$$.fragment,s),cs=!0)},o(s){c(J.$$.fragment,s),c(g.$$.fragment,s),c(T.$$.fragment,s),c(b.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(N.$$.fragment,s),c(B.$$.fragment,s),c(R.$$.fragment,s),c(A.$$.fragment,s),c(Q.$$.fragment,s),cs=!1},d(s){s&&(l(X),l(v),l(H),l(Y),l(d),l(S),l(z),l(w),l(F),l(D),l(u),l(L),l(q),l(U),l(P),l(K),l(C),l(O),l(ss),l(Z),l(ts),l($),l(ls),l(es),l(W),l(as),l(ns),l(x),l(ps),l(ms),l(E),l(is),l(os),l(rs),l(Ms),l(V)),l(y),h(J,s),h(g,s),h(T,s),h(b,s),h(f,s),h(I,s),h(k,s),h(N,s),h(B,s),h(R,s),h(A,s),h(Q,s)}}}const Rs='{"title":"Wide ResNet","local":"wide-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function As(hs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ks{constructor(y){super(),Ws(this,y,As,Es,Is,{})}}export{_s as component};
