import{s as Ke,n as Oe,o as sa}from"../chunks/scheduler.9991993c.js";import{S as la,i as ta,g as p,s as a,r as y,A as ea,h as M,f as t,c as n,j as De,u as J,x as i,k as Pe,y as aa,a as e,v as o,d as c,t as m,w as U}from"../chunks/index.7fc9a5e7.js";import{C as T}from"../chunks/CodeBlock.e11cba92.js";import{H as j,E as na}from"../chunks/EditOnGithub.84ab7f0e.js";function pa(Pt){let r,Ml,nl,il,d,yl,h,Jl,u,Kt=`LLM 的一个常见应用场景是聊天。在聊天上下文中，不再是连续的文本字符串构成的语句（不同于标准的语言模型），
聊天模型由一条或多条消息组成的对话组成，每条消息都有一个“用户”或“助手”等 <strong>角色</strong>，还包括消息文本。`,ol,w,Ot=`与<code>Tokenizer</code>类似，不同的模型对聊天的输入格式要求也不同。这就是我们添加<strong>聊天模板</strong>作为一个功能的原因。
聊天模板是<code>Tokenizer</code>的一部分。用来把问答的对话内容转换为模型的输入<code>prompt</code>。`,cl,I,se=`让我们通过一个快速的示例来具体说明，使用<code>BlenderBot</code>模型。
BlenderBot有一个非常简单的默认模板，主要是在对话轮之间添加空格：`,ml,g,Ul,f,le=`注意，整个聊天对话内容被压缩成了一整个字符串。如果我们使用默认设置的<code>tokenize=True</code>，那么该字符串也将被tokenized处理。
不过，为了看到更复杂的模板实际运行，让我们使用<code>mistralai/Mistral-7B-Instruct-v0.1</code>模型。`,Tl,C,jl,b,te=`可以看到，这一次tokenizer已经添加了[INST]和[/INST]来表示用户消息的开始和结束。
Mistral-instruct是有使用这些token进行训练的，但BlenderBot没有。`,rl,Z,dl,G,ee=`正如您在上面的示例中所看到的，聊天模板非常容易使用。只需构建一系列带有<code>role</code>和<code>content</code>键的消息，
然后将其传递给<a href="/docs/transformers/v4.40.2/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>方法。
另外，在将聊天模板用作模型预测的输入时，还建议使用<code>add_generation_prompt=True</code>来添加<a href="#%E4%BB%80%E4%B9%88%E6%98%AFgeneration-prompts">generation prompt</a>。`,hl,N,ae="这是一个准备<code>model.generate()</code>的示例，使用<code>Zephyr</code>模型：",ul,x,wl,$,ne="这将生成Zephyr期望的输入格式的字符串。它看起来像这样：",Il,B,gl,Q,pe="现在我们已经按照<code>Zephyr</code>的要求传入prompt了，我们可以使用模型来生成对用户问题的回复：",fl,v,Cl,W,Me="输出结果是：",bl,z,Zl,k,ie="啊，原来这么容易！",Gl,S,Nl,V,ye='有的，<a href="/docs/transformers/v4.40.2/zh/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>。这个<code>pipeline</code>的设计是为了方便使用聊天模型。让我们再试一次 Zephyr 的例子，但这次使用<code>pipeline</code>：',xl,_,$l,R,Bl,H,Je='<a href="/docs/transformers/v4.40.2/zh/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>将负责处理所有的<code>tokenized</code>并调用<code>apply_chat_template</code>，一旦模型有了聊天模板，您只需要初始化pipeline并传递消息列表！',Ql,A,vl,X,oe=`您可能已经注意到<code>apply_chat_template</code>方法有一个<code>add_generation_prompt</code>参数。
这个参数告诉模板添加模型开始答复的标记。例如，考虑以下对话：`,Wl,q,zl,F,ce="这是<code>add_generation_prompt=False</code>的结果，使用ChatML模板：",kl,E,Sl,Y,me="下面这是<code>add_generation_prompt=True</code>的结果：",Vl,L,_l,D,Ue=`这一次我们添加了模型开始答复的标记。这可以确保模型生成文本时只会给出答复，而不会做出意外的行为，比如继续用户的消息。
记住，聊天模型只是语言模型，它们被训练来继续文本，而聊天对它们来说只是一种特殊的文本！
你需要用适当的控制标记来引导它们，让它们知道自己应该做什么。`,Rl,P,Te=`并非所有模型都需要生成提示。一些模型，如BlenderBot和LLaMA，在模型回复之前没有任何特殊标记。
在这些情况下，<code>add_generation_prompt</code>参数将不起作用。<code>add_generation_prompt</code>参数取决于你所使用的模板。`,Hl,K,Al,O,je=`可以！我们建议您将聊天模板应用为数据集的预处理步骤。之后，您可以像进行任何其他语言模型训练任务一样继续。
在训练时，通常应该设置<code>add_generation_prompt=False</code>，因为添加的助手标记在训练过程中并不会有帮助。
让我们看一个例子：`,Xl,ss,ql,ls,re="结果是：",Fl,ts,El,es,de="这样，后面你可以使用<code>formatted_chat</code>列，跟标准语言建模任务中一样训练即可。",Yl,as,Ll,ns,he=`模型的聊天模板存储在<code>tokenizer.chat_template</code>属性上。如果没有设置，则将使用该模型的默认模板。
让我们来看看<code>BlenderBot</code>的模板：`,Dl,ps,Pl,Ms,ue=`这看着有点复杂。让我们添加一些换行和缩进，使其更易读。
请注意，默认情况下忽略每个块后的第一个换行以及块之前的任何前导空格，
使用Jinja的<code>trim_blocks</code>和<code>lstrip_blocks</code>标签。
这里，请注意空格的使用。我们强烈建议您仔细检查模板是否打印了多余的空格！`,Kl,is,Ol,ys,we=`如果你之前不了解<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>。
Jinja是一种模板语言，允许你编写简单的代码来生成文本。
在许多方面，代码和语法类似于Python。在纯Python中，这个模板看起来会像这样：`,st,Js,lt,os,Ie="这里使用Jinja模板处理如下三步：",tt,cs,ge="<li>对于每条消息，如果消息是用户消息，则在其前面添加一个空格，否则不打印任何内容</li> <li>添加消息内容</li> <li>如果消息不是最后一条，请在其后添加两个空格。在最后一条消息之后，打印<code>EOS</code>。</li>",et,ms,fe=`这是一个简单的模板，它不添加任何控制tokens，也不支持<code>system</code>消息（常用于指导模型在后续对话中如何表现）。
但 Jinja 给了你很大的灵活性来做这些事情！让我们看一个 Jinja 模板，
它可以实现类似于LLaMA的prompt输入（请注意，真正的LLaMA模板包括<code>system</code>消息，请不要在实际代码中使用这个简单模板！）`,at,Us,nt,Ts,Ce=`这里稍微看一下，就能明白这个模板的作用：它根据每条消息的“角色”添加对应的消息。
<code>user</code>、<code>assistant</code>、<code>system</code>的消息需要分别处理，因为它们代表不同的角色输入。`,pt,js,Mt,rs,it,ds,be=`很简单，你只需编写一个jinja模板并设置<code>tokenizer.chat_template</code>。你也可以从一个现有模板开始，只需要简单编辑便可以！
例如，我们可以采用上面的LLaMA模板，并在助手消息中添加”[ASST]“和”[/ASST]“：`,yt,hs,Jt,us,Ze=`现在，只需设置<code>tokenizer.chat_template</code>属性。下次使用<a href="/docs/transformers/v4.40.2/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>时，它将使用您的新模板！
此属性将保存在<code>tokenizer_config.json</code>文件中，因此您可以使用<a href="/docs/transformers/v4.40.2/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>将新模板上传到 Hub，
这样每个人都可以使用你模型的模板！`,ot,ws,ct,Is,Ge=`由于<a href="/docs/transformers/v4.40.2/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>方法是由<a href="/docs/transformers/v4.40.2/zh/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>类调用，
因此一旦你设置了聊天模板，您的模型将自动与<a href="/docs/transformers/v4.40.2/zh/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>兼容。`,mt,gs,Ut,fs,Ne=`在引入聊天模板（chat_template）之前，聊天prompt是在模型中通过硬编码处理的。为了向前兼容，我们保留了这种硬编码处理聊天prompt的方法。
如果一个模型没有设置聊天模板，但其模型有默认模板，<code>ConversationalPipeline</code>类和<code>apply_chat_template</code>等方法将使用该模型的聊天模板。
您可以通过检查<code>tokenizer.default_chat_template</code>属性来查找<code>tokenizer</code>的默认模板。`,Tt,Cs,xe=`这是我们纯粹为了向前兼容性而做的事情，以避免破坏任何现有的工作流程。即使默认的聊天模板适用于您的模型，
我们强烈建议通过显式设置<code>chat_template</code>属性来覆盖默认模板，以便向用户清楚地表明您的模型已经正确的配置了聊天模板，
并且为了未来防范默认模板被修改或弃用的情况。`,jt,bs,rt,Zs,$e=`在为已经训练过的聊天模型设置模板时，您应确保模板与模型在训练期间看到的消息格式完全匹配，否则可能会导致性能下降。
即使您继续对模型进行训练，也应保持聊天模板不变，这样可能会获得最佳性能。
这与<code>tokenization</code>非常类似，在推断时，你选用跟训练时一样的<code>tokenization</code>，通常会获得最佳性能。`,dt,Gs,Be=`如果您从头开始训练模型，或者在微调基础语言模型进行聊天时，您有很大的自由选择适当的模板！
LLMs足够聪明，可以学会处理许多不同的输入格式。我们为没有特定类别模板的模型提供一个默认模板，该模板遵循
<code>ChatML</code> format格式要求，对于许多用例来说，
这是一个很好的、灵活的选择。`,ht,Ns,Qe="默认模板看起来像这样：",ut,xs,wt,$s,ve=`如果您喜欢这个模板，下面是一行代码的模板形式，它可以直接复制到您的代码中。这一行代码还包括了[generation prompts](#什么是”generation prompts”?)，
但请注意它不会添加<code>BOS</code>或<code>EOS</code>token。
如果您的模型需要这些token，它们不会被<code>apply_chat_template</code>自动添加，换句话说，文本的默认处理参数是<code>add_special_tokens=False</code>。
这是为了避免模板和<code>add_special_tokens</code>逻辑产生冲突，如果您的模型需要特殊tokens，请确保将它们添加到模板中！`,It,Bs,gt,Qs,We="该模板将每条消息包装在<code>&lt;|im_start|&gt;</code>和<code>&lt;|im_end|&gt;</code>tokens里面，并将角色简单地写为字符串，这样可以灵活地训练角色。输出如下：",ft,vs,Ct,Ws,ze=`<code>user</code>，<code>system</code>和<code>assistant</code>是对话助手模型的标准角色，如果您的模型要与<a href="/docs/transformers/v4.40.2/zh/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>兼容，我们建议你使用这些角色。
但您可以不局限于这些角色，模板非常灵活，任何字符串都可以成为角色。`,bt,zs,Zt,ks,ke=`如果您有任何聊天模型，您应该设置它们的<code>tokenizer.chat_template</code>属性，并使用<a href="/docs/transformers/v4.40.2/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>测试，
然后将更新后的<code>tokenizer</code>推送到 Hub。
即使您不是模型所有者，如果您正在使用一个空的聊天模板或者仍在使用默认的聊天模板，
请发起一个<a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a>，以便正确设置该属性！`,Gt,Ss,Se=`一旦属性设置完成，就完成了！<code>tokenizer.apply_chat_template</code>现在将在该模型中正常工作，
这意味着它也会自动支持在诸如<code>ConversationalPipeline</code>的地方！`,Nt,Vs,Ve=`通过确保模型具有这一属性，我们可以确保整个社区都能充分利用开源模型的全部功能。
格式不匹配已经困扰这个领域并悄悄地损害了性能太久了，是时候结束它们了！`,xt,_s,$t,Rs,_e="如果你对Jinja不熟悉，我们通常发现编写聊天模板的最简单方法是先编写一个简短的Python脚本，按照你想要的方式格式化消息，然后将该脚本转换为模板。",Bt,Hs,Re=`请记住，模板处理程序将接收对话历史作为名为<code>messages</code>的变量。每条<code>message</code>都是一个带有两个键<code>role</code>和<code>content</code>的字典。
您可以在模板中像在Python中一样访问<code>messages</code>，这意味着您可以使用<code>{% for message in messages %}</code>进行循环，
或者例如使用<code>{{ messages[0] }}</code>访问单个消息。`,Qt,As,He="您也可以使用以下提示将您的代码转换为Jinja：",vt,Xs,Wt,qs,Ae="在Jinja中，for循环看起来像这样：",zt,Fs,kt,Es,Xe="请注意，<code>{{ expression block }}</code>中的内容将被打印到输出。您可以在表达式块中使用像<code>+</code>这样的运算符来组合字符串。",St,Ys,Vt,Ls,qe="Jinja中的if语句如下所示：",_t,Ds,Rt,Ps,Fe="注意Jinja使用<code>{% endfor %}</code>和<code>{% endif %}</code>来表示<code>for</code>和<code>if</code>的结束。",Ht,Ks,At,Os,Ee=`在您的模板中，您将可以访问<code>messages</code>列表，但您还可以访问其他几个特殊变量。
这些包括特殊<code>token</code>，如<code>bos_token</code>和<code>eos_token</code>，以及我们上面讨论过的<code>add_generation_prompt</code>变量。
您还可以使用<code>loop</code>变量来访问有关当前循环迭代的信息，例如使用<code>{% if loop.last %}</code>来检查当前消息是否是对话中的最后一条消息。`,Xt,sl,Ye="以下是一个示例，如果<code>add_generation_prompt=True</code>需要在对话结束时添加<code>generate_prompt</code>：",qt,ll,Ft,tl,Et,el,Le=`我们已经尽可能尝试让Jinja忽略除<code>{{ expressions }}</code>之外的空格。
然而，请注意Jinja是一个通用的模板引擎，它可能会将同一行文本块之间的空格视为重要，并将其打印到输出中。
我们<strong>强烈</strong>建议在上传模板之前检查一下，确保模板没有在不应该的地方打印额外的空格！`,Yt,al,Lt,pl,Dt;return d=new j({props:{title:"聊天模型的模板",local:"聊天模型的模板",headingTag:"h1"}}),h=new j({props:{title:"介绍",local:"介绍",headingTag:"h2"}}),g=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),C=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),Z=new j({props:{title:"我如何使用聊天模板？",local:"我如何使用聊天模板",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),B=new T({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),v=new T({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),z=new T({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),S=new j({props:{title:"有自动化的聊天 pipeline 吗？",local:"有自动化的聊天-pipeline-吗",headingTag:"h2"}}),_=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmNvbnZlcnNhdGlvbmFsJTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBcHJpbnQocGlwZShtZXNzYWdlcykp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;conversational&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages))`,wrap:!1}}),R=new T({props:{code:"Q29udmVyc2F0aW9uJTIwaWQlM0ElMjA3NmQ4ODZhMC03NGJkLTQ1NGUtOTgwNC0wNDY3MDQxYTYzZGMlMEFzeXN0ZW0lM0ElMjBZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTBBdXNlciUzQSUyMEhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUwQWFzc2lzdGFudCUzQSUyME1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`Conversation id: 76d886a0-74bd-454e-9804-0467041a63dc
system: You are a friendly chatbot who always responds in the style of a pirate
user: How many helicopters can a human eat in one sitting?
assistant: Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),A=new j({props:{title:"什么是”generation prompts”?",local:"什么是generation-prompts",headingTag:"h2"}}),q=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),E=new T({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),L=new T({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new j({props:{title:"我可以在训练中使用聊天模板吗？",local:"我可以在训练中使用聊天模板吗",headingTag:"h2"}}),ss=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ts=new T({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),as=new j({props:{title:"高级：聊天模板是如何工作的？",local:"高级聊天模板是如何工作的",headingTag:"h2"}}),ps=new T({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),is=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),Js=new T({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),Us=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),js=new j({props:{title:"高级：编辑聊天模板",local:"高级编辑聊天模板",headingTag:"h2"}}),rs=new j({props:{title:"如何创建聊天模板？",local:"如何创建聊天模板",headingTag:"h3"}}),hs=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ws=new T({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),gs=new j({props:{title:"“默认”模板是什么？",local:"默认模板是什么",headingTag:"h3"}}),bs=new j({props:{title:"我应该使用哪个模板？",local:"我应该使用哪个模板",headingTag:"h3"}}),xs=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Bs=new T({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),vs=new T({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),zs=new j({props:{title:"如何添加聊天模板？",local:"如何添加聊天模板",headingTag:"h3"}}),_s=new j({props:{title:"高级：模板写作技巧",local:"高级模板写作技巧",headingTag:"h2"}}),Xs=new j({props:{title:"For循环",local:"for循环",headingTag:"h3"}}),Fs=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Ys=new j({props:{title:"If语句",local:"if语句",headingTag:"h3"}}),Ds=new T({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ks=new j({props:{title:"特殊变量",local:"特殊变量",headingTag:"h3"}}),ll=new T({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),tl=new j({props:{title:"空格的注意事项",local:"空格的注意事项",headingTag:"h3"}}),al=new na({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/chat_templating.md"}}),{c(){r=p("meta"),Ml=a(),nl=p("p"),il=a(),y(d.$$.fragment),yl=a(),y(h.$$.fragment),Jl=a(),u=p("p"),u.innerHTML=Kt,ol=a(),w=p("p"),w.innerHTML=Ot,cl=a(),I=p("p"),I.innerHTML=se,ml=a(),y(g.$$.fragment),Ul=a(),f=p("p"),f.innerHTML=le,Tl=a(),y(C.$$.fragment),jl=a(),b=p("p"),b.textContent=te,rl=a(),y(Z.$$.fragment),dl=a(),G=p("p"),G.innerHTML=ee,hl=a(),N=p("p"),N.innerHTML=ae,ul=a(),y(x.$$.fragment),wl=a(),$=p("p"),$.textContent=ne,Il=a(),y(B.$$.fragment),gl=a(),Q=p("p"),Q.innerHTML=pe,fl=a(),y(v.$$.fragment),Cl=a(),W=p("p"),W.textContent=Me,bl=a(),y(z.$$.fragment),Zl=a(),k=p("p"),k.textContent=ie,Gl=a(),y(S.$$.fragment),Nl=a(),V=p("p"),V.innerHTML=ye,xl=a(),y(_.$$.fragment),$l=a(),y(R.$$.fragment),Bl=a(),H=p("p"),H.innerHTML=Je,Ql=a(),y(A.$$.fragment),vl=a(),X=p("p"),X.innerHTML=oe,Wl=a(),y(q.$$.fragment),zl=a(),F=p("p"),F.innerHTML=ce,kl=a(),y(E.$$.fragment),Sl=a(),Y=p("p"),Y.innerHTML=me,Vl=a(),y(L.$$.fragment),_l=a(),D=p("p"),D.textContent=Ue,Rl=a(),P=p("p"),P.innerHTML=Te,Hl=a(),y(K.$$.fragment),Al=a(),O=p("p"),O.innerHTML=je,Xl=a(),y(ss.$$.fragment),ql=a(),ls=p("p"),ls.textContent=re,Fl=a(),y(ts.$$.fragment),El=a(),es=p("p"),es.innerHTML=de,Yl=a(),y(as.$$.fragment),Ll=a(),ns=p("p"),ns.innerHTML=he,Dl=a(),y(ps.$$.fragment),Pl=a(),Ms=p("p"),Ms.innerHTML=ue,Kl=a(),y(is.$$.fragment),Ol=a(),ys=p("p"),ys.innerHTML=we,st=a(),y(Js.$$.fragment),lt=a(),os=p("p"),os.textContent=Ie,tt=a(),cs=p("ol"),cs.innerHTML=ge,et=a(),ms=p("p"),ms.innerHTML=fe,at=a(),y(Us.$$.fragment),nt=a(),Ts=p("p"),Ts.innerHTML=Ce,pt=a(),y(js.$$.fragment),Mt=a(),y(rs.$$.fragment),it=a(),ds=p("p"),ds.innerHTML=be,yt=a(),y(hs.$$.fragment),Jt=a(),us=p("p"),us.innerHTML=Ze,ot=a(),y(ws.$$.fragment),ct=a(),Is=p("p"),Is.innerHTML=Ge,mt=a(),y(gs.$$.fragment),Ut=a(),fs=p("p"),fs.innerHTML=Ne,Tt=a(),Cs=p("p"),Cs.innerHTML=xe,jt=a(),y(bs.$$.fragment),rt=a(),Zs=p("p"),Zs.innerHTML=$e,dt=a(),Gs=p("p"),Gs.innerHTML=Be,ht=a(),Ns=p("p"),Ns.textContent=Qe,ut=a(),y(xs.$$.fragment),wt=a(),$s=p("p"),$s.innerHTML=ve,It=a(),y(Bs.$$.fragment),gt=a(),Qs=p("p"),Qs.innerHTML=We,ft=a(),y(vs.$$.fragment),Ct=a(),Ws=p("p"),Ws.innerHTML=ze,bt=a(),y(zs.$$.fragment),Zt=a(),ks=p("p"),ks.innerHTML=ke,Gt=a(),Ss=p("p"),Ss.innerHTML=Se,Nt=a(),Vs=p("p"),Vs.textContent=Ve,xt=a(),y(_s.$$.fragment),$t=a(),Rs=p("p"),Rs.textContent=_e,Bt=a(),Hs=p("p"),Hs.innerHTML=Re,Qt=a(),As=p("p"),As.textContent=He,vt=a(),y(Xs.$$.fragment),Wt=a(),qs=p("p"),qs.textContent=Ae,zt=a(),y(Fs.$$.fragment),kt=a(),Es=p("p"),Es.innerHTML=Xe,St=a(),y(Ys.$$.fragment),Vt=a(),Ls=p("p"),Ls.textContent=qe,_t=a(),y(Ds.$$.fragment),Rt=a(),Ps=p("p"),Ps.innerHTML=Fe,Ht=a(),y(Ks.$$.fragment),At=a(),Os=p("p"),Os.innerHTML=Ee,Xt=a(),sl=p("p"),sl.innerHTML=Ye,qt=a(),y(ll.$$.fragment),Ft=a(),y(tl.$$.fragment),Et=a(),el=p("p"),el.innerHTML=Le,Yt=a(),y(al.$$.fragment),Lt=a(),pl=p("p"),this.h()},l(s){const l=ea("svelte-u9bgzb",document.head);r=M(l,"META",{name:!0,content:!0}),l.forEach(t),Ml=n(s),nl=M(s,"P",{}),De(nl).forEach(t),il=n(s),J(d.$$.fragment,s),yl=n(s),J(h.$$.fragment,s),Jl=n(s),u=M(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-12gr1zf"&&(u.innerHTML=Kt),ol=n(s),w=M(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-jqg83q"&&(w.innerHTML=Ot),cl=n(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1hl9y7g"&&(I.innerHTML=se),ml=n(s),J(g.$$.fragment,s),Ul=n(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-2gdq6c"&&(f.innerHTML=le),Tl=n(s),J(C.$$.fragment,s),jl=n(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1uu5txi"&&(b.textContent=te),rl=n(s),J(Z.$$.fragment,s),dl=n(s),G=M(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-vl8s7d"&&(G.innerHTML=ee),hl=n(s),N=M(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-18wsdqk"&&(N.innerHTML=ae),ul=n(s),J(x.$$.fragment,s),wl=n(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-szjh6z"&&($.textContent=ne),Il=n(s),J(B.$$.fragment,s),gl=n(s),Q=M(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1mnwvlc"&&(Q.innerHTML=pe),fl=n(s),J(v.$$.fragment,s),Cl=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-z7s6bp"&&(W.textContent=Me),bl=n(s),J(z.$$.fragment,s),Zl=n(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-6li582"&&(k.textContent=ie),Gl=n(s),J(S.$$.fragment,s),Nl=n(s),V=M(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1n5e1vv"&&(V.innerHTML=ye),xl=n(s),J(_.$$.fragment,s),$l=n(s),J(R.$$.fragment,s),Bl=n(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-vnzngf"&&(H.innerHTML=Je),Ql=n(s),J(A.$$.fragment,s),vl=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-iu4par"&&(X.innerHTML=oe),Wl=n(s),J(q.$$.fragment,s),zl=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-n9il4r"&&(F.innerHTML=ce),kl=n(s),J(E.$$.fragment,s),Sl=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-53qjqh"&&(Y.innerHTML=me),Vl=n(s),J(L.$$.fragment,s),_l=n(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-d7wbjj"&&(D.textContent=Ue),Rl=n(s),P=M(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1w6qwu1"&&(P.innerHTML=Te),Hl=n(s),J(K.$$.fragment,s),Al=n(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-b1lzbk"&&(O.innerHTML=je),Xl=n(s),J(ss.$$.fragment,s),ql=n(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1j2yk26"&&(ls.textContent=re),Fl=n(s),J(ts.$$.fragment,s),El=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-g2qoag"&&(es.innerHTML=de),Yl=n(s),J(as.$$.fragment,s),Ll=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-faviix"&&(ns.innerHTML=he),Dl=n(s),J(ps.$$.fragment,s),Pl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1ur5734"&&(Ms.innerHTML=ue),Kl=n(s),J(is.$$.fragment,s),Ol=n(s),ys=M(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1xg0oyk"&&(ys.innerHTML=we),st=n(s),J(Js.$$.fragment,s),lt=n(s),os=M(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-126w0pj"&&(os.textContent=Ie),tt=n(s),cs=M(s,"OL",{"data-svelte-h":!0}),i(cs)!=="svelte-1i1qfyx"&&(cs.innerHTML=ge),et=n(s),ms=M(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-1f8rf5v"&&(ms.innerHTML=fe),at=n(s),J(Us.$$.fragment,s),nt=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-16pwtdq"&&(Ts.innerHTML=Ce),pt=n(s),J(js.$$.fragment,s),Mt=n(s),J(rs.$$.fragment,s),it=n(s),ds=M(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-qjomqd"&&(ds.innerHTML=be),yt=n(s),J(hs.$$.fragment,s),Jt=n(s),us=M(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-v1n940"&&(us.innerHTML=Ze),ot=n(s),J(ws.$$.fragment,s),ct=n(s),Is=M(s,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-ddqiyp"&&(Is.innerHTML=Ge),mt=n(s),J(gs.$$.fragment,s),Ut=n(s),fs=M(s,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-tmyexz"&&(fs.innerHTML=Ne),Tt=n(s),Cs=M(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-uaicwn"&&(Cs.innerHTML=xe),jt=n(s),J(bs.$$.fragment,s),rt=n(s),Zs=M(s,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-1h7775y"&&(Zs.innerHTML=$e),dt=n(s),Gs=M(s,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1ewfwsy"&&(Gs.innerHTML=Be),ht=n(s),Ns=M(s,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-1t3g01w"&&(Ns.textContent=Qe),ut=n(s),J(xs.$$.fragment,s),wt=n(s),$s=M(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1t0o56l"&&($s.innerHTML=ve),It=n(s),J(Bs.$$.fragment,s),gt=n(s),Qs=M(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-11rufda"&&(Qs.innerHTML=We),ft=n(s),J(vs.$$.fragment,s),Ct=n(s),Ws=M(s,"P",{"data-svelte-h":!0}),i(Ws)!=="svelte-q0dtjg"&&(Ws.innerHTML=ze),bt=n(s),J(zs.$$.fragment,s),Zt=n(s),ks=M(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-mxd77"&&(ks.innerHTML=ke),Gt=n(s),Ss=M(s,"P",{"data-svelte-h":!0}),i(Ss)!=="svelte-huv77r"&&(Ss.innerHTML=Se),Nt=n(s),Vs=M(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1qxn4vk"&&(Vs.textContent=Ve),xt=n(s),J(_s.$$.fragment,s),$t=n(s),Rs=M(s,"P",{"data-svelte-h":!0}),i(Rs)!=="svelte-t1396b"&&(Rs.textContent=_e),Bt=n(s),Hs=M(s,"P",{"data-svelte-h":!0}),i(Hs)!=="svelte-59uiu8"&&(Hs.innerHTML=Re),Qt=n(s),As=M(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-1aooy9k"&&(As.textContent=He),vt=n(s),J(Xs.$$.fragment,s),Wt=n(s),qs=M(s,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-1qr6npj"&&(qs.textContent=Ae),zt=n(s),J(Fs.$$.fragment,s),kt=n(s),Es=M(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-1necxra"&&(Es.innerHTML=Xe),St=n(s),J(Ys.$$.fragment,s),Vt=n(s),Ls=M(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-1ioywy7"&&(Ls.textContent=qe),_t=n(s),J(Ds.$$.fragment,s),Rt=n(s),Ps=M(s,"P",{"data-svelte-h":!0}),i(Ps)!=="svelte-6wil9x"&&(Ps.innerHTML=Fe),Ht=n(s),J(Ks.$$.fragment,s),At=n(s),Os=M(s,"P",{"data-svelte-h":!0}),i(Os)!=="svelte-y2yvc0"&&(Os.innerHTML=Ee),Xt=n(s),sl=M(s,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-mdpqzu"&&(sl.innerHTML=Ye),qt=n(s),J(ll.$$.fragment,s),Ft=n(s),J(tl.$$.fragment,s),Et=n(s),el=M(s,"P",{"data-svelte-h":!0}),i(el)!=="svelte-u83arb"&&(el.innerHTML=Le),Yt=n(s),J(al.$$.fragment,s),Lt=n(s),pl=M(s,"P",{}),De(pl).forEach(t),this.h()},h(){Pe(r,"name","hf:doc:metadata"),Pe(r,"content",Ma)},m(s,l){aa(document.head,r),e(s,Ml,l),e(s,nl,l),e(s,il,l),o(d,s,l),e(s,yl,l),o(h,s,l),e(s,Jl,l),e(s,u,l),e(s,ol,l),e(s,w,l),e(s,cl,l),e(s,I,l),e(s,ml,l),o(g,s,l),e(s,Ul,l),e(s,f,l),e(s,Tl,l),o(C,s,l),e(s,jl,l),e(s,b,l),e(s,rl,l),o(Z,s,l),e(s,dl,l),e(s,G,l),e(s,hl,l),e(s,N,l),e(s,ul,l),o(x,s,l),e(s,wl,l),e(s,$,l),e(s,Il,l),o(B,s,l),e(s,gl,l),e(s,Q,l),e(s,fl,l),o(v,s,l),e(s,Cl,l),e(s,W,l),e(s,bl,l),o(z,s,l),e(s,Zl,l),e(s,k,l),e(s,Gl,l),o(S,s,l),e(s,Nl,l),e(s,V,l),e(s,xl,l),o(_,s,l),e(s,$l,l),o(R,s,l),e(s,Bl,l),e(s,H,l),e(s,Ql,l),o(A,s,l),e(s,vl,l),e(s,X,l),e(s,Wl,l),o(q,s,l),e(s,zl,l),e(s,F,l),e(s,kl,l),o(E,s,l),e(s,Sl,l),e(s,Y,l),e(s,Vl,l),o(L,s,l),e(s,_l,l),e(s,D,l),e(s,Rl,l),e(s,P,l),e(s,Hl,l),o(K,s,l),e(s,Al,l),e(s,O,l),e(s,Xl,l),o(ss,s,l),e(s,ql,l),e(s,ls,l),e(s,Fl,l),o(ts,s,l),e(s,El,l),e(s,es,l),e(s,Yl,l),o(as,s,l),e(s,Ll,l),e(s,ns,l),e(s,Dl,l),o(ps,s,l),e(s,Pl,l),e(s,Ms,l),e(s,Kl,l),o(is,s,l),e(s,Ol,l),e(s,ys,l),e(s,st,l),o(Js,s,l),e(s,lt,l),e(s,os,l),e(s,tt,l),e(s,cs,l),e(s,et,l),e(s,ms,l),e(s,at,l),o(Us,s,l),e(s,nt,l),e(s,Ts,l),e(s,pt,l),o(js,s,l),e(s,Mt,l),o(rs,s,l),e(s,it,l),e(s,ds,l),e(s,yt,l),o(hs,s,l),e(s,Jt,l),e(s,us,l),e(s,ot,l),o(ws,s,l),e(s,ct,l),e(s,Is,l),e(s,mt,l),o(gs,s,l),e(s,Ut,l),e(s,fs,l),e(s,Tt,l),e(s,Cs,l),e(s,jt,l),o(bs,s,l),e(s,rt,l),e(s,Zs,l),e(s,dt,l),e(s,Gs,l),e(s,ht,l),e(s,Ns,l),e(s,ut,l),o(xs,s,l),e(s,wt,l),e(s,$s,l),e(s,It,l),o(Bs,s,l),e(s,gt,l),e(s,Qs,l),e(s,ft,l),o(vs,s,l),e(s,Ct,l),e(s,Ws,l),e(s,bt,l),o(zs,s,l),e(s,Zt,l),e(s,ks,l),e(s,Gt,l),e(s,Ss,l),e(s,Nt,l),e(s,Vs,l),e(s,xt,l),o(_s,s,l),e(s,$t,l),e(s,Rs,l),e(s,Bt,l),e(s,Hs,l),e(s,Qt,l),e(s,As,l),e(s,vt,l),o(Xs,s,l),e(s,Wt,l),e(s,qs,l),e(s,zt,l),o(Fs,s,l),e(s,kt,l),e(s,Es,l),e(s,St,l),o(Ys,s,l),e(s,Vt,l),e(s,Ls,l),e(s,_t,l),o(Ds,s,l),e(s,Rt,l),e(s,Ps,l),e(s,Ht,l),o(Ks,s,l),e(s,At,l),e(s,Os,l),e(s,Xt,l),e(s,sl,l),e(s,qt,l),o(ll,s,l),e(s,Ft,l),o(tl,s,l),e(s,Et,l),e(s,el,l),e(s,Yt,l),o(al,s,l),e(s,Lt,l),e(s,pl,l),Dt=!0},p:Oe,i(s){Dt||(c(d.$$.fragment,s),c(h.$$.fragment,s),c(g.$$.fragment,s),c(C.$$.fragment,s),c(Z.$$.fragment,s),c(x.$$.fragment,s),c(B.$$.fragment,s),c(v.$$.fragment,s),c(z.$$.fragment,s),c(S.$$.fragment,s),c(_.$$.fragment,s),c(R.$$.fragment,s),c(A.$$.fragment,s),c(q.$$.fragment,s),c(E.$$.fragment,s),c(L.$$.fragment,s),c(K.$$.fragment,s),c(ss.$$.fragment,s),c(ts.$$.fragment,s),c(as.$$.fragment,s),c(ps.$$.fragment,s),c(is.$$.fragment,s),c(Js.$$.fragment,s),c(Us.$$.fragment,s),c(js.$$.fragment,s),c(rs.$$.fragment,s),c(hs.$$.fragment,s),c(ws.$$.fragment,s),c(gs.$$.fragment,s),c(bs.$$.fragment,s),c(xs.$$.fragment,s),c(Bs.$$.fragment,s),c(vs.$$.fragment,s),c(zs.$$.fragment,s),c(_s.$$.fragment,s),c(Xs.$$.fragment,s),c(Fs.$$.fragment,s),c(Ys.$$.fragment,s),c(Ds.$$.fragment,s),c(Ks.$$.fragment,s),c(ll.$$.fragment,s),c(tl.$$.fragment,s),c(al.$$.fragment,s),Dt=!0)},o(s){m(d.$$.fragment,s),m(h.$$.fragment,s),m(g.$$.fragment,s),m(C.$$.fragment,s),m(Z.$$.fragment,s),m(x.$$.fragment,s),m(B.$$.fragment,s),m(v.$$.fragment,s),m(z.$$.fragment,s),m(S.$$.fragment,s),m(_.$$.fragment,s),m(R.$$.fragment,s),m(A.$$.fragment,s),m(q.$$.fragment,s),m(E.$$.fragment,s),m(L.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(ts.$$.fragment,s),m(as.$$.fragment,s),m(ps.$$.fragment,s),m(is.$$.fragment,s),m(Js.$$.fragment,s),m(Us.$$.fragment,s),m(js.$$.fragment,s),m(rs.$$.fragment,s),m(hs.$$.fragment,s),m(ws.$$.fragment,s),m(gs.$$.fragment,s),m(bs.$$.fragment,s),m(xs.$$.fragment,s),m(Bs.$$.fragment,s),m(vs.$$.fragment,s),m(zs.$$.fragment,s),m(_s.$$.fragment,s),m(Xs.$$.fragment,s),m(Fs.$$.fragment,s),m(Ys.$$.fragment,s),m(Ds.$$.fragment,s),m(Ks.$$.fragment,s),m(ll.$$.fragment,s),m(tl.$$.fragment,s),m(al.$$.fragment,s),Dt=!1},d(s){s&&(t(Ml),t(nl),t(il),t(yl),t(Jl),t(u),t(ol),t(w),t(cl),t(I),t(ml),t(Ul),t(f),t(Tl),t(jl),t(b),t(rl),t(dl),t(G),t(hl),t(N),t(ul),t(wl),t($),t(Il),t(gl),t(Q),t(fl),t(Cl),t(W),t(bl),t(Zl),t(k),t(Gl),t(Nl),t(V),t(xl),t($l),t(Bl),t(H),t(Ql),t(vl),t(X),t(Wl),t(zl),t(F),t(kl),t(Sl),t(Y),t(Vl),t(_l),t(D),t(Rl),t(P),t(Hl),t(Al),t(O),t(Xl),t(ql),t(ls),t(Fl),t(El),t(es),t(Yl),t(Ll),t(ns),t(Dl),t(Pl),t(Ms),t(Kl),t(Ol),t(ys),t(st),t(lt),t(os),t(tt),t(cs),t(et),t(ms),t(at),t(nt),t(Ts),t(pt),t(Mt),t(it),t(ds),t(yt),t(Jt),t(us),t(ot),t(ct),t(Is),t(mt),t(Ut),t(fs),t(Tt),t(Cs),t(jt),t(rt),t(Zs),t(dt),t(Gs),t(ht),t(Ns),t(ut),t(wt),t($s),t(It),t(gt),t(Qs),t(ft),t(Ct),t(Ws),t(bt),t(Zt),t(ks),t(Gt),t(Ss),t(Nt),t(Vs),t(xt),t($t),t(Rs),t(Bt),t(Hs),t(Qt),t(As),t(vt),t(Wt),t(qs),t(zt),t(kt),t(Es),t(St),t(Vt),t(Ls),t(_t),t(Rt),t(Ps),t(Ht),t(At),t(Os),t(Xt),t(sl),t(qt),t(Ft),t(Et),t(el),t(Yt),t(Lt),t(pl)),t(r),U(d,s),U(h,s),U(g,s),U(C,s),U(Z,s),U(x,s),U(B,s),U(v,s),U(z,s),U(S,s),U(_,s),U(R,s),U(A,s),U(q,s),U(E,s),U(L,s),U(K,s),U(ss,s),U(ts,s),U(as,s),U(ps,s),U(is,s),U(Js,s),U(Us,s),U(js,s),U(rs,s),U(hs,s),U(ws,s),U(gs,s),U(bs,s),U(xs,s),U(Bs,s),U(vs,s),U(zs,s),U(_s,s),U(Xs,s),U(Fs,s),U(Ys,s),U(Ds,s),U(Ks,s),U(ll,s),U(tl,s),U(al,s)}}}const Ma='{"title":"聊天模型的模板","local":"聊天模型的模板","sections":[{"title":"介绍","local":"介绍","sections":[],"depth":2},{"title":"我如何使用聊天模板？","local":"我如何使用聊天模板","sections":[],"depth":2},{"title":"有自动化的聊天 pipeline 吗？","local":"有自动化的聊天-pipeline-吗","sections":[],"depth":2},{"title":"什么是”generation prompts”?","local":"什么是generation-prompts","sections":[],"depth":2},{"title":"我可以在训练中使用聊天模板吗？","local":"我可以在训练中使用聊天模板吗","sections":[],"depth":2},{"title":"高级：聊天模板是如何工作的？","local":"高级聊天模板是如何工作的","sections":[],"depth":2},{"title":"高级：编辑聊天模板","local":"高级编辑聊天模板","sections":[{"title":"如何创建聊天模板？","local":"如何创建聊天模板","sections":[],"depth":3},{"title":"“默认”模板是什么？","local":"默认模板是什么","sections":[],"depth":3},{"title":"我应该使用哪个模板？","local":"我应该使用哪个模板","sections":[],"depth":3},{"title":"如何添加聊天模板？","local":"如何添加聊天模板","sections":[],"depth":3}],"depth":2},{"title":"高级：模板写作技巧","local":"高级模板写作技巧","sections":[{"title":"For循环","local":"for循环","sections":[],"depth":3},{"title":"If语句","local":"if语句","sections":[],"depth":3},{"title":"特殊变量","local":"特殊变量","sections":[],"depth":3},{"title":"空格的注意事项","local":"空格的注意事项","sections":[],"depth":3}],"depth":2}],"depth":1}';function ia(Pt){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends la{constructor(r){super(),ta(this,r,ia,pa,Ke,{})}}export{ma as component};
