import{s as aa,n as na,o as ia}from"../chunks/scheduler.d6170356.js";import{S as sa,i as oa,g as s,s as n,r as y,A as ra,h as o,f as l,c as i,j as c,u as h,x as r,k as zt,y as p,a,v as d,d as f,t as u,w as m}from"../chunks/index.fcd4cc08.js";import{C as M}from"../chunks/CodeBlock.7b16bdef.js";import{H as U}from"../chunks/Heading.8660bd0e.js";function pa(ul){let _,Se,qe,Re,$,Ve,v,ml='The Hugging Face Hub aims to facilitate sharing machine learning models, checkpoints, and artifacts. This endeavor includes integrating the Hub into many of the amazing third-party libraries in the community. Some of the ones already integrated include <a href="https://spacy.io/usage/projects#huggingface_hub" rel="nofollow">spaCy</a>, <a href="https://allennlp.org/" rel="nofollow">AllenNLP</a>, and <a href="https://rwightman.github.io/pytorch-image-models/" rel="nofollow">timm</a>, among many others. Integration means users can download and upload files to the Hub directly from your library. We hope you will integrate your library and join us in democratizing artificial intelligence for everyone!',ze,k,Ml="Integrating the Hub with your library provides many benefits, including:",Oe,x,cl='<li>Free model hosting for you and your users.</li> <li>Built-in file versioning - even for huge files - made possible by <a href="https://git-lfs.github.com/" rel="nofollow">Git-LFS</a>.</li> <li>All public models are powered by the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>.</li> <li>In-browser widgets allow users to interact with your hosted models directly.</li>',Ke,H,gl="This tutorial will help you integrate the Hub into your library so your users can benefit from all the features offered by the Hub.",et,A,wl='Before you begin, we recommend you create a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face account</a> from which you can manage your repositories and files.',tt,N,Tl='If you need help with the integration, feel free to open an <a href="https://github.com/huggingface/huggingface_hub/issues/new/choose" rel="nofollow">issue</a>, and we would be more than happy to help you!',lt,L,at,w,Q,xe,Ul="Install the <code>huggingface_hub</code> library with pip in your environment:",Ot,X,Kt,b,He,_l="Once you have successfully installed the <code>huggingface_hub</code> library, log in to your Hugging Face account:",el,Z,tl,G,ll,J,Ae,bl="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, login with <code>notebook_login</code>:",al,D,nl,Ne,Jl="<code>notebook_login</code> will launch a widget in your notebook from which you can enter your Hugging Face credentials.",nt,B,it,F,Cl="Integration allows users to download your hosted files directly from the Hub using your library.",st,W,jl="Use the <code>hf_hub_download</code> function to retrieve a URL and download files from your repository. Downloaded files are stored in your cache: <code>~/.cache/huggingface/hub</code>. You don’t have to re-download the file the next time you use it, and for larger files, this can save a lot of time. Furthermore, if the repository is updated with a new version of the file, <code>huggingface_hub</code> will automatically download the latest version and store it in the cache for you. Users don’t have to worry about updating their files.",ot,P,Il='For example, download the <code>config.json</code> file from the <a href="https://huggingface.co/lysandre/arxiv-nlp" rel="nofollow">lysandre/arxiv-nlp</a> repository:',rt,E,pt,q,$l="Download a specific version of the file by specifying the <code>revision</code> parameter. The <code>revision</code> parameter can be a branch name, tag, or commit hash.",yt,Y,vl="The commit hash must be a full-length hash instead of the shorter 7-character commit hash:",ht,S,dt,R,kl="Use the <code>cache_dir</code> parameter to change where a file is stored:",ft,V,ut,z,mt,O,xl="We recommend adding a code snippet to explain how to use a model in your downstream library.",Mt,C,Hl='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet-dark.png"/>',ct,K,Al='Add a code snippet by updating the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">model-libraries.ts file</a> with instructions for your model. For example, the <a href="https://huggingface.co/asteroid-team" rel="nofollow">Asteroid</a> integration includes a brief code snippet for how to load and use an Asteroid model:',gt,ee,wt,te,Nl="Doing so will also add a tag to your model so users can quickly identify models from your library.",Tt,j,Ll='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags-dark.png"/>',Ut,le,_t,ae,Ql="You might also want to provide a method for creating model repositories and uploading files to the Hub directly from your library. The <code>huggingface_hub</code> library offers two ways to assist you with creating repositories and uploading files:",bt,ne,Xl="<li><code>create_repo</code> creates a repository on the Hub.</li> <li><code>upload_file</code> directly uploads files to a repository on the Hub.</li>",Jt,ie,Ct,se,Zl="The <code>create_repo</code> method creates a repository on the Hub. Use the <code>name</code> parameter to provide a name for your repository:",jt,oe,It,re,Gl="When you check your Hugging Face account, you should now see a <code>test-model</code> repository under your namespace.",$t,pe,vt,ye,Dl="The <code>upload_file</code> method uploads files to the Hub. This method requires the following:",kt,he,Bl="<li>A path to the file to upload.</li> <li>The final path in the repository.</li> <li>The repository you wish to push the files to.</li>",xt,de,Fl="For example:",Ht,fe,At,ue,Wl='If you need to upload more than one file, look at the <a href="https://huggingface.co/docs/huggingface_hub/package_reference/repository" rel="nofollow">utilities offered by the <code>Repository</code> class</a>.',Nt,me,Pl="Once again, if you check your Hugging Face account, you should see the file inside your repository.",Lt,Me,El='Lastly, it is important to add a model card so users understand how to use your model. See <a href="./model-cards">here</a> for more details about how to create a model card.',Qt,ce,Xt,ge,ql="Our Inference API powers models uploaded to the Hub through your library.",Zt,we,Gt,Te,Yl='All third-party libraries are Dockerized, so you can install the dependencies you’ll need for your library to work correctly. Add your library to the existing Docker images by navigating to the <a href="https://github.com/huggingface/api-inference-community/tree/main/docker_images" rel="nofollow">Docker images folder</a>.',Dt,T,Le,Sl="<p>Copy the <code>common</code> folder and rename it with the name of your library (e.g. <code>docker/common</code> to <code>docker/your-awesome-library</code>).</p>",il,Ue,Qe,Rl="There are four files you need to edit:",sl,g,Xe,Vl="<p>List the packages required for your library to work in <code>requirements.txt</code>.</p>",ol,_e,Ze,zl='Update <code>app/main.py</code> with the tasks supported by your model (see <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">here</a> for a complete list of available tasks). Look out for the <code>IMPLEMENT_THIS</code> flag to add your supported task.',rl,be,pl,Ge,Ol='<p>For each task your library supports, modify the <code>app/pipelines/task_name.py</code> files accordingly. We have also added an <code>IMPLEMENT_THIS</code> flag in the pipeline files to guide you. If there isn’t a pipeline that supports your task, feel free to add one. Open an <a href="https://github.com/huggingface/huggingface.js/issues/new" rel="nofollow">issue</a> here, and we will be happy to help you.</p>',yl,Je,De,Kl="Add your model and task to the <code>tests/test_api.py</code> file. For example, if you have a text generation model:",hl,Ce,dl,je,Be,ea="Finally, run the following test to ensure everything works as expected:",fl,Ie,Bt,$e,Ft,ve,ta='To register the tasks supported by your library on the hub you’ll need to add a mapping from your library name to its supported tasks in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/library-to-tasks.ts" rel="nofollow">library-to-tasks.ts file</a>. This will ensure the inference API is registered for tasks supported by your model. This file is automatically generated as part of a <a href="https://github.com/huggingface/api-inference-community/actions/workflows/python-api-export-tasks.yaml" rel="nofollow">GitHub Action</a> in the <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">api-inference-community repository</a> repository. You can see an example of this <a href="https://github.com/huggingface/api-inference-community/actions/runs/5126874210/jobs/9221890853#step:5:8" rel="nofollow">here</a>.',Wt,ke,la="With these simple but powerful methods, you brought the full functionality of the Hub into your library. Users can download files stored on the Hub from your library with <code>hf_hub_download</code>, create repositories with <code>create_repo</code>, and upload files with <code>upload_file</code>. You also set up Inference API with your library, allowing users to interact with your models on the Hub from inside a browser.",Pt,Ye,Et;return $=new U({props:{title:"Integrate your library with the Hub",local:"integrate-your-library-with-the-hub",headingTag:"h1"}}),L=new U({props:{title:"Installation",local:"installation",headingTag:"h2"}}),X=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"python -m pip install huggingface_hub",wrap:!1}}),Z=new M({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),G=new M({props:{code:"JTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0NfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTBBJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUwQSUyMCUyMCUyMCUyMCUyMCUwQVVzZXJuYW1lJTNBJTIwJTBBUGFzc3dvcmQlM0E=",highlighted:`     _|    _|  _|    _|    _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|_|_|_|    _|_|      _|_|_|  _|_|_|_|
     _|    _|  _|    _|  _|        _|          _|    _|_|    _|  _|            _|        _|    _|  _|        _|
     _|_|_|_|  _|    _|  _|  _|_|  _|  _|_|    _|    _|  _|  _|  _|  _|_|      _|_|_|    _|_|_|_|  _|        _|_|_|
     _|    _|  _|    _|  _|    _|  _|    _|    _|    _|    _|_|  _|    _|      _|        _|    _|  _|        _|
     _|    _|    _|_|      _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|        _|    _|    _|_|_|  _|_|_|_|

     
Username: 
Password:`,wrap:!1}}),D=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),B=new U({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h2"}}),E=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwY2FjaGVfZGlyJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, cache_dir=<span class="hljs-string">&quot;/home/lysandre/test&quot;</span>)`,wrap:!1}}),z=new U({props:{title:"Code sample",local:"code-sample",headingTag:"h3"}}),ee=new M({props:{code:"Y29uc3QlMjBhc3Rlcm9pZCUyMCUzRCUyMChtb2RlbCUzQSUyME1vZGVsRGF0YSklMjAlM0QlM0UlMEElNjBmcm9tJTIwYXN0ZXJvaWQubW9kZWxzJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTBBJTIwJTIwJTBBbW9kZWwlMjAlM0QlMjBCYXNlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyNCU3Qm1vZGVsLmlkJTdEJTIyKSU2MCUzQg==",highlighted:'<span class="hljs-keyword">const</span> <span class="hljs-title function_">asteroid</span> = (<span class="hljs-params">model: ModelData</span>) =&gt;\n<span class="hljs-string">`from asteroid.models import BaseModel\n  \nmodel = BaseModel.from_pretrained(&quot;<span class="hljs-subst">${model.id}</span>&quot;)`</span>;',wrap:!1}}),le=new U({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h2"}}),ie=new U({props:{title:"create_repo",local:"createrepo",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8ocmVwb19pZCUzRCUyMnRlc3QtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(repo_id=<span class="hljs-string">&quot;test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),pe=new U({props:{title:"upload_file",local:"uploadfile",headingTag:"h3"}}),fe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGZHVtbXktdGVzdCUyRlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRnRlc3QtbW9kZWwlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>   path_or_fileobj=<span class="hljs-string">&quot;/home/lysandre/dummy-test/README.md&quot;</span>, 
<span class="hljs-meta">... </span>   path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, 
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model/blob/main/README.md&#x27;</span>`,wrap:!1}}),ce=new U({props:{title:"Set up the Inference API",local:"set-up-the-inference-api",headingTag:"h2"}}),we=new U({props:{title:"Create an Inference API Docker image",local:"create-an-inference-api-docker-image",headingTag:"h3"}}),be=new M({props:{code:"QUxMT1dFRF9UQVNLUyUzQSUyMERpY3QlNUJzdHIlMkMlMjBUeXBlJTVCUGlwZWxpbmUlNUQlNUQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0b2tlbi1jbGFzc2lmaWNhdGlvbiUyMiUzQSUyMFRva2VuQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQSU3RA==",highlighted:`ALLOWED_TASKS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Type</span>[Pipeline]] = {
    <span class="hljs-string">&quot;token-classification&quot;</span>: TokenClassificationPipeline
}`,wrap:!1}}),Ce=new M({props:{code:"VEVTVEFCTEVfTU9ERUxTJTNBJTIwRGljdCU1QnN0ciUyQ3N0ciU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUzQSUyMCUyMm15LWdwdDItbW9kZWwlMjIlMEElN0Q=",highlighted:`TESTABLE_MODELS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>,<span class="hljs-built_in">str</span>] = {
    <span class="hljs-string">&quot;text-generation&quot;</span>: <span class="hljs-string">&quot;my-gpt2-model&quot;</span>
}`,wrap:!1}}),Ie=new M({props:{code:"cHl0ZXN0JTIwLXN2JTIwLS1yb290ZGlyJTIwZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJGZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJG",highlighted:"pytest -sv --rootdir docker_images/your-awesome-library/docker_images/your-awesome-library/",wrap:!1}}),$e=new U({props:{title:"Register your libraries supported tasks on the hub",local:"register-your-libraries-supported-tasks-on-the-hub",headingTag:"h3"}}),{c(){_=s("meta"),Se=n(),qe=s("p"),Re=n(),y($.$$.fragment),Ve=n(),v=s("p"),v.innerHTML=ml,ze=n(),k=s("p"),k.textContent=Ml,Oe=n(),x=s("ul"),x.innerHTML=cl,Ke=n(),H=s("p"),H.textContent=gl,et=n(),A=s("p"),A.innerHTML=wl,tt=n(),N=s("p"),N.innerHTML=Tl,lt=n(),y(L.$$.fragment),at=n(),w=s("ol"),Q=s("li"),xe=s("p"),xe.innerHTML=Ul,Ot=n(),y(X.$$.fragment),Kt=n(),b=s("li"),He=s("p"),He.innerHTML=_l,el=n(),y(Z.$$.fragment),tl=n(),y(G.$$.fragment),ll=n(),J=s("li"),Ae=s("p"),Ae.innerHTML=bl,al=n(),y(D.$$.fragment),nl=n(),Ne=s("p"),Ne.innerHTML=Jl,nt=n(),y(B.$$.fragment),it=n(),F=s("p"),F.textContent=Cl,st=n(),W=s("p"),W.innerHTML=jl,ot=n(),P=s("p"),P.innerHTML=Il,rt=n(),y(E.$$.fragment),pt=n(),q=s("p"),q.innerHTML=$l,yt=n(),Y=s("p"),Y.textContent=vl,ht=n(),y(S.$$.fragment),dt=n(),R=s("p"),R.innerHTML=kl,ft=n(),y(V.$$.fragment),ut=n(),y(z.$$.fragment),mt=n(),O=s("p"),O.textContent=xl,Mt=n(),C=s("div"),C.innerHTML=Hl,ct=n(),K=s("p"),K.innerHTML=Al,gt=n(),y(ee.$$.fragment),wt=n(),te=s("p"),te.textContent=Nl,Tt=n(),j=s("div"),j.innerHTML=Ll,Ut=n(),y(le.$$.fragment),_t=n(),ae=s("p"),ae.innerHTML=Ql,bt=n(),ne=s("ul"),ne.innerHTML=Xl,Jt=n(),y(ie.$$.fragment),Ct=n(),se=s("p"),se.innerHTML=Zl,jt=n(),y(oe.$$.fragment),It=n(),re=s("p"),re.innerHTML=Gl,$t=n(),y(pe.$$.fragment),vt=n(),ye=s("p"),ye.innerHTML=Dl,kt=n(),he=s("ul"),he.innerHTML=Bl,xt=n(),de=s("p"),de.textContent=Fl,Ht=n(),y(fe.$$.fragment),At=n(),ue=s("p"),ue.innerHTML=Wl,Nt=n(),me=s("p"),me.textContent=Pl,Lt=n(),Me=s("p"),Me.innerHTML=El,Qt=n(),y(ce.$$.fragment),Xt=n(),ge=s("p"),ge.textContent=ql,Zt=n(),y(we.$$.fragment),Gt=n(),Te=s("p"),Te.innerHTML=Yl,Dt=n(),T=s("ol"),Le=s("li"),Le.innerHTML=Sl,il=n(),Ue=s("li"),Qe=s("p"),Qe.textContent=Rl,sl=n(),g=s("ul"),Xe=s("li"),Xe.innerHTML=Vl,ol=n(),_e=s("li"),Ze=s("p"),Ze.innerHTML=zl,rl=n(),y(be.$$.fragment),pl=n(),Ge=s("li"),Ge.innerHTML=Ol,yl=n(),Je=s("li"),De=s("p"),De.innerHTML=Kl,hl=n(),y(Ce.$$.fragment),dl=n(),je=s("li"),Be=s("p"),Be.textContent=ea,fl=n(),y(Ie.$$.fragment),Bt=n(),y($e.$$.fragment),Ft=n(),ve=s("p"),ve.innerHTML=ta,Wt=n(),ke=s("p"),ke.innerHTML=la,Pt=n(),Ye=s("p"),this.h()},l(e){const t=ra("svelte-u9bgzb",document.head);_=o(t,"META",{name:!0,content:!0}),t.forEach(l),Se=i(e),qe=o(e,"P",{}),c(qe).forEach(l),Re=i(e),h($.$$.fragment,e),Ve=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-h18ltv"&&(v.innerHTML=ml),ze=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1h76lqo"&&(k.textContent=Ml),Oe=i(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1f2b9dq"&&(x.innerHTML=cl),Ke=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-tideui"&&(H.textContent=gl),et=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bv6wqp"&&(A.innerHTML=wl),tt=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1dgevba"&&(N.innerHTML=Tl),lt=i(e),h(L.$$.fragment,e),at=i(e),w=o(e,"OL",{});var Fe=c(w);Q=o(Fe,"LI",{});var qt=c(Q);xe=o(qt,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1un3zii"&&(xe.innerHTML=Ul),Ot=i(qt),h(X.$$.fragment,qt),qt.forEach(l),Kt=i(Fe),b=o(Fe,"LI",{});var We=c(b);He=o(We,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1n5fxns"&&(He.innerHTML=_l),el=i(We),h(Z.$$.fragment,We),tl=i(We),h(G.$$.fragment,We),We.forEach(l),ll=i(Fe),J=o(Fe,"LI",{});var Pe=c(J);Ae=o(Pe,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-lceb1h"&&(Ae.innerHTML=bl),al=i(Pe),h(D.$$.fragment,Pe),nl=i(Pe),Ne=o(Pe,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1utjkvu"&&(Ne.innerHTML=Jl),Pe.forEach(l),Fe.forEach(l),nt=i(e),h(B.$$.fragment,e),it=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1xrlxrq"&&(F.textContent=Cl),st=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-mlcwe8"&&(W.innerHTML=jl),ot=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-22k4ir"&&(P.innerHTML=Il),rt=i(e),h(E.$$.fragment,e),pt=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nqohuu"&&(q.innerHTML=$l),yt=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-jz20t2"&&(Y.textContent=vl),ht=i(e),h(S.$$.fragment,e),dt=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1g7ex70"&&(R.innerHTML=kl),ft=i(e),h(V.$$.fragment,e),ut=i(e),h(z.$$.fragment,e),mt=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-kjqwtb"&&(O.textContent=xl),Mt=i(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-k2vnd3"&&(C.innerHTML=Hl),ct=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1u0tlve"&&(K.innerHTML=Al),gt=i(e),h(ee.$$.fragment,e),wt=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1s18u9b"&&(te.textContent=Nl),Tt=i(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1n378h3"&&(j.innerHTML=Ll),Ut=i(e),h(le.$$.fragment,e),_t=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1kwmyjl"&&(ae.innerHTML=Ql),bt=i(e),ne=o(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1kcwgoq"&&(ne.innerHTML=Xl),Jt=i(e),h(ie.$$.fragment,e),Ct=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-rngk60"&&(se.innerHTML=Zl),jt=i(e),h(oe.$$.fragment,e),It=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-aiu9oy"&&(re.innerHTML=Gl),$t=i(e),h(pe.$$.fragment,e),vt=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-co0lqw"&&(ye.innerHTML=Dl),kt=i(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-9phsay"&&(he.innerHTML=Bl),xt=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gkqha7"&&(de.textContent=Fl),Ht=i(e),h(fe.$$.fragment,e),At=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-m2kxf2"&&(ue.innerHTML=Wl),Nt=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-269fdk"&&(me.textContent=Pl),Lt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-dxh4k0"&&(Me.innerHTML=El),Qt=i(e),h(ce.$$.fragment,e),Xt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-lhddhv"&&(ge.textContent=ql),Zt=i(e),h(we.$$.fragment,e),Gt=i(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-9nvj4e"&&(Te.innerHTML=Yl),Dt=i(e),T=o(e,"OL",{});var Ee=c(T);Le=o(Ee,"LI",{"data-svelte-h":!0}),r(Le)!=="svelte-l76mxy"&&(Le.innerHTML=Sl),il=i(Ee),Ue=o(Ee,"LI",{});var Yt=c(Ue);Qe=o(Yt,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-ey431t"&&(Qe.textContent=Rl),sl=i(Yt),g=o(Yt,"UL",{});var I=c(g);Xe=o(I,"LI",{"data-svelte-h":!0}),r(Xe)!=="svelte-1nu45ed"&&(Xe.innerHTML=Vl),ol=i(I),_e=o(I,"LI",{});var St=c(_e);Ze=o(St,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-db8jal"&&(Ze.innerHTML=zl),rl=i(St),h(be.$$.fragment,St),St.forEach(l),pl=i(I),Ge=o(I,"LI",{"data-svelte-h":!0}),r(Ge)!=="svelte-1lyepfm"&&(Ge.innerHTML=Ol),yl=i(I),Je=o(I,"LI",{});var Rt=c(Je);De=o(Rt,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1anbe36"&&(De.innerHTML=Kl),hl=i(Rt),h(Ce.$$.fragment,Rt),Rt.forEach(l),I.forEach(l),Yt.forEach(l),dl=i(Ee),je=o(Ee,"LI",{});var Vt=c(je);Be=o(Vt,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1aut65a"&&(Be.textContent=ea),fl=i(Vt),h(Ie.$$.fragment,Vt),Vt.forEach(l),Ee.forEach(l),Bt=i(e),h($e.$$.fragment,e),Ft=i(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-c66868"&&(ve.innerHTML=ta),Wt=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-udfx7c"&&(ke.innerHTML=la),Pt=i(e),Ye=o(e,"P",{}),c(Ye).forEach(l),this.h()},h(){zt(_,"name","hf:doc:metadata"),zt(_,"content",ya),zt(C,"class","flex justify-center"),zt(j,"class","flex justify-center")},m(e,t){p(document.head,_),a(e,Se,t),a(e,qe,t),a(e,Re,t),d($,e,t),a(e,Ve,t),a(e,v,t),a(e,ze,t),a(e,k,t),a(e,Oe,t),a(e,x,t),a(e,Ke,t),a(e,H,t),a(e,et,t),a(e,A,t),a(e,tt,t),a(e,N,t),a(e,lt,t),d(L,e,t),a(e,at,t),a(e,w,t),p(w,Q),p(Q,xe),p(Q,Ot),d(X,Q,null),p(w,Kt),p(w,b),p(b,He),p(b,el),d(Z,b,null),p(b,tl),d(G,b,null),p(w,ll),p(w,J),p(J,Ae),p(J,al),d(D,J,null),p(J,nl),p(J,Ne),a(e,nt,t),d(B,e,t),a(e,it,t),a(e,F,t),a(e,st,t),a(e,W,t),a(e,ot,t),a(e,P,t),a(e,rt,t),d(E,e,t),a(e,pt,t),a(e,q,t),a(e,yt,t),a(e,Y,t),a(e,ht,t),d(S,e,t),a(e,dt,t),a(e,R,t),a(e,ft,t),d(V,e,t),a(e,ut,t),d(z,e,t),a(e,mt,t),a(e,O,t),a(e,Mt,t),a(e,C,t),a(e,ct,t),a(e,K,t),a(e,gt,t),d(ee,e,t),a(e,wt,t),a(e,te,t),a(e,Tt,t),a(e,j,t),a(e,Ut,t),d(le,e,t),a(e,_t,t),a(e,ae,t),a(e,bt,t),a(e,ne,t),a(e,Jt,t),d(ie,e,t),a(e,Ct,t),a(e,se,t),a(e,jt,t),d(oe,e,t),a(e,It,t),a(e,re,t),a(e,$t,t),d(pe,e,t),a(e,vt,t),a(e,ye,t),a(e,kt,t),a(e,he,t),a(e,xt,t),a(e,de,t),a(e,Ht,t),d(fe,e,t),a(e,At,t),a(e,ue,t),a(e,Nt,t),a(e,me,t),a(e,Lt,t),a(e,Me,t),a(e,Qt,t),d(ce,e,t),a(e,Xt,t),a(e,ge,t),a(e,Zt,t),d(we,e,t),a(e,Gt,t),a(e,Te,t),a(e,Dt,t),a(e,T,t),p(T,Le),p(T,il),p(T,Ue),p(Ue,Qe),p(Ue,sl),p(Ue,g),p(g,Xe),p(g,ol),p(g,_e),p(_e,Ze),p(_e,rl),d(be,_e,null),p(g,pl),p(g,Ge),p(g,yl),p(g,Je),p(Je,De),p(Je,hl),d(Ce,Je,null),p(T,dl),p(T,je),p(je,Be),p(je,fl),d(Ie,je,null),a(e,Bt,t),d($e,e,t),a(e,Ft,t),a(e,ve,t),a(e,Wt,t),a(e,ke,t),a(e,Pt,t),a(e,Ye,t),Et=!0},p:na,i(e){Et||(f($.$$.fragment,e),f(L.$$.fragment,e),f(X.$$.fragment,e),f(Z.$$.fragment,e),f(G.$$.fragment,e),f(D.$$.fragment,e),f(B.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(V.$$.fragment,e),f(z.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(Ce.$$.fragment,e),f(Ie.$$.fragment,e),f($e.$$.fragment,e),Et=!0)},o(e){u($.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(D.$$.fragment,e),u(B.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(ce.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u($e.$$.fragment,e),Et=!1},d(e){e&&(l(Se),l(qe),l(Re),l(Ve),l(v),l(ze),l(k),l(Oe),l(x),l(Ke),l(H),l(et),l(A),l(tt),l(N),l(lt),l(at),l(w),l(nt),l(it),l(F),l(st),l(W),l(ot),l(P),l(rt),l(pt),l(q),l(yt),l(Y),l(ht),l(dt),l(R),l(ft),l(ut),l(mt),l(O),l(Mt),l(C),l(ct),l(K),l(gt),l(wt),l(te),l(Tt),l(j),l(Ut),l(_t),l(ae),l(bt),l(ne),l(Jt),l(Ct),l(se),l(jt),l(It),l(re),l($t),l(vt),l(ye),l(kt),l(he),l(xt),l(de),l(Ht),l(At),l(ue),l(Nt),l(me),l(Lt),l(Me),l(Qt),l(Xt),l(ge),l(Zt),l(Gt),l(Te),l(Dt),l(T),l(Bt),l(Ft),l(ve),l(Wt),l(ke),l(Pt),l(Ye)),l(_),m($,e),m(L,e),m(X),m(Z),m(G),m(D),m(B,e),m(E,e),m(S,e),m(V,e),m(z,e),m(ee,e),m(le,e),m(ie,e),m(oe,e),m(pe,e),m(fe,e),m(ce,e),m(we,e),m(be),m(Ce),m(Ie),m($e,e)}}}const ya='{"title":"Integrate your library with the Hub","local":"integrate-your-library-with-the-hub","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Code sample","local":"code-sample","sections":[],"depth":3}],"depth":2},{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"create_repo","local":"createrepo","sections":[],"depth":3},{"title":"upload_file","local":"uploadfile","sections":[],"depth":3}],"depth":2},{"title":"Set up the Inference API","local":"set-up-the-inference-api","sections":[{"title":"Create an Inference API Docker image","local":"create-an-inference-api-docker-image","sections":[],"depth":3},{"title":"Register your libraries supported tasks on the hub","local":"register-your-libraries-supported-tasks-on-the-hub","sections":[],"depth":3}],"depth":2}],"depth":1}';function ha(ul){return ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends sa{constructor(_){super(),oa(this,_,ha,pa,aa,{})}}export{Ma as component};
