import{s as ye,n as ve,o as we}from"../chunks/scheduler.d6170356.js";import{S as Te,i as $e,g as s,s as l,r as m,A as Me,h as a,f as i,c as o,j as he,u as p,x as r,k as Bt,y as Ge,a as n,v as g,d as f,t as c,w as d}from"../chunks/index.fcd4cc08.js";import{C as Ft}from"../chunks/CodeBlock.7b16bdef.js";import{H as tt}from"../chunks/Heading.8660bd0e.js";function ke(At){let u,et,D,it,v,nt,w,Zt="<code>git</code> has an authentication layer to control who can push commits to a repo, but it does not authenticate the actual commit authors.",lt,T,qt="In other words, you can commit changes as <code>Elon Musk &lt;elon@tesla.com&gt;</code>, push them to your preferred <code>git</code> host (for instance github.com), and your commit will link to Elon’s GitHub profile. (Try it! But don’t blame us if Elon gets mad at you for impersonating him.)",ot,$,Ot="The reasons we implemented GPG signing were:",st,M,Nt="<li>To provide finer-grained security, especially as more and more Enterprise users rely on the Hub.</li> <li>To provide ML benchmarks backed by a cryptographically-secure source.</li>",at,G,zt='See Ale Segala’s <a href="https://withblue.ink/2020/05/17/how-and-why-to-sign-git-commits.html" rel="nofollow">How (and why) to sign <code>git</code> commits</a> for more context.',rt,k,Qt="You can prove a commit was authored by you with GNU Privacy Guard (GPG) and a key server. GPG is a cryptographic tool used to verify the authenticity of a message’s origin. We’ll explain how to set this up on Hugging Face below.",ut,x,Vt='The Pro Git book is, as usual, a good resource about commit signing: <a href="https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work" rel="nofollow">Pro Git: Signing your work</a>.',mt,b,pt,C,Kt='You will need to install <a href="https://gnupg.org/" rel="nofollow">GPG</a> on your system in order to execute the following commands.',gt,P,Xt=`<p>It’s included by default in most Linux distributions.
On Windows, it is included in Git Bash (which comes with <code>git</code> for Windows).</p>`,ft,L,Dt=`You can sign your commits locally using <a href="https://gnupg.org/" rel="nofollow">GPG</a>.
Then configure your profile to mark these commits as <strong>verified</strong> on the Hub,
so other people can be confident that they come from a trusted source.`,ct,H,Rt='For a more in-depth explanation of how git and GPG interact, please visit the the <a href="https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work" rel="nofollow">git documentation on the subject</a>',dt,_,te="Commits can have the following signing statuses:",ht,U,ee="<thead><tr><th>Status</th> <th>Explanation</th></tr></thead> <tbody><tr><td>Verified</td> <td>The commit is signed and the signature is verified</td></tr> <tr><td>Unverified</td> <td>The commit is signed but the signature could not be verified</td></tr> <tr><td>No signing status</td> <td>The commit is not signed</td></tr></tbody>",yt,E,ie="For a commit to be marked as <strong>verified</strong>, you need to upload the public key used to sign it on your Hugging Face account.",vt,S,ne=`Use the <code>gpg --list-secret-keys</code> command to list the GPG keys for which you have both a public and private key.
A private key is required for signing commits or tags.`,wt,I,le="If you don’t have a GPG key pair or you don’t want to use the existing keys to sign your commits, go to <strong>Generating a new GPG key</strong>.",Tt,J,oe='Otherwise, go straight to  <a href="#adding-a-gpg-key-to-your-account">Adding a GPG key to your account</a>.',$t,W,Mt,Y,se="To generate a GPG key, run the following:",Gt,j,kt,B,ae="GPG will then guide you through the process of creating a GPG key pair.",xt,F,re='Make sure you specify an email address for this key, and that the email address matches the one you specified in your Hugging Face <a href="https://huggingface.co/settings/account" rel="nofollow">account</a>.',bt,A,Ct,Z,ue='<li><p>First, select or generate a GPG key on your computer. Make sure the email address of the key matches the one in your Hugging Face <a href="https://huggingface.co/settings/account" rel="nofollow">account</a> and that the email of your account is verified.</p></li> <li><p>Export the public part of the selected key:</p></li>',Pt,q,Lt,h,me='<li>Then visit your profile <a href="https://huggingface.co/settings/keys" rel="nofollow">settings page</a> and click on <strong>Add GPG Key</strong>.</li>',Ht,O,pe="Copy &amp; paste the output of the <code>gpg --export</code> command in the text area and click on <strong>Add Key</strong>.",_t,y,ge="<li>Congratulations! 🎉  You’ve just added a GPG key to your account!</li>",Ut,N,Et,z,fe="The last step is to configure git to sign your commits:",St,Q,It,V,ce="Then add the <code>-S</code> flag to your <code>git commit</code> commands to sign your commits!",Jt,K,Wt,X,de="Once pushed on the Hub, you should see the commit with a “Verified” badge.",Yt,R,jt;return v=new tt({props:{title:"Signing commits with GPG",local:"signing-commits-with-gpg",headingTag:"h1"}}),b=new tt({props:{title:"Setting up signed commits verification",local:"setting-up-signed-commits-verification",headingTag:"h2"}}),W=new tt({props:{title:"Generating a new GPG key",local:"generating-a-new-gpg-key",headingTag:"h2"}}),j=new Ft({props:{code:"Z3BnJTIwLS1nZW4ta2V5",highlighted:"gpg --gen-key",wrap:!1}}),A=new tt({props:{title:"Adding a GPG key to your account",local:"adding-a-gpg-key-to-your-account",headingTag:"h2"}}),q=new Ft({props:{code:"Z3BnJTIwLS1hcm1vciUyMC0tZXhwb3J0JTIwJTNDWU9VUiUyMEtFWSUyMElEJTNF",highlighted:'gpg --armor --<span class="hljs-built_in">export</span> &lt;YOUR KEY ID&gt;',wrap:!1}}),N=new tt({props:{title:"Configure git to sign your commits with GPG",local:"configure-git-to-sign-your-commits-with-gpg",headingTag:"h2"}}),Q=new Ft({props:{code:"Z2l0JTIwY29uZmlnJTIwdXNlci5zaWduaW5na2V5JTIwJTNDWW91ciUyMEdQRyUyMEtleSUyMElEJTNFJTBBZ2l0JTIwY29uZmlnJTIwdXNlci5lbWFpbCUyMCUzQ1lvdXIlMjBlbWFpbCUyMG9uJTIwaGYuY28lM0U=",highlighted:`git config user.signingkey &lt;Your GPG Key ID&gt;
git config user.email &lt;Your email on hf.co&gt;`,wrap:!1}}),K=new Ft({props:{code:"Z2l0JTIwY29tbWl0JTIwLVMlMjAtbSUyMCUyMk15JTIwZmlyc3QlMjBzaWduZWQlMjBjb21taXQlMjI=",highlighted:'git commit -S -m <span class="hljs-string">&quot;My first signed commit&quot;</span>',wrap:!1}}),{c(){u=s("meta"),et=l(),D=s("p"),it=l(),m(v.$$.fragment),nt=l(),w=s("p"),w.innerHTML=Zt,lt=l(),T=s("p"),T.innerHTML=qt,ot=l(),$=s("p"),$.textContent=Ot,st=l(),M=s("ul"),M.innerHTML=Nt,at=l(),G=s("p"),G.innerHTML=zt,rt=l(),k=s("p"),k.textContent=Qt,ut=l(),x=s("p"),x.innerHTML=Vt,mt=l(),m(b.$$.fragment),pt=l(),C=s("p"),C.innerHTML=Kt,gt=l(),P=s("blockquote"),P.innerHTML=Xt,ft=l(),L=s("p"),L.innerHTML=Dt,ct=l(),H=s("p"),H.innerHTML=Rt,dt=l(),_=s("p"),_.textContent=te,ht=l(),U=s("table"),U.innerHTML=ee,yt=l(),E=s("p"),E.innerHTML=ie,vt=l(),S=s("p"),S.innerHTML=ne,wt=l(),I=s("p"),I.innerHTML=le,Tt=l(),J=s("p"),J.innerHTML=oe,$t=l(),m(W.$$.fragment),Mt=l(),Y=s("p"),Y.textContent=se,Gt=l(),m(j.$$.fragment),kt=l(),B=s("p"),B.textContent=ae,xt=l(),F=s("p"),F.innerHTML=re,bt=l(),m(A.$$.fragment),Ct=l(),Z=s("ol"),Z.innerHTML=ue,Pt=l(),m(q.$$.fragment),Lt=l(),h=s("ol"),h.innerHTML=me,Ht=l(),O=s("p"),O.innerHTML=pe,_t=l(),y=s("ol"),y.innerHTML=ge,Ut=l(),m(N.$$.fragment),Et=l(),z=s("p"),z.textContent=fe,St=l(),m(Q.$$.fragment),It=l(),V=s("p"),V.innerHTML=ce,Jt=l(),m(K.$$.fragment),Wt=l(),X=s("p"),X.textContent=de,Yt=l(),R=s("p"),this.h()},l(t){const e=Me("svelte-u9bgzb",document.head);u=a(e,"META",{name:!0,content:!0}),e.forEach(i),et=o(t),D=a(t,"P",{}),he(D).forEach(i),it=o(t),p(v.$$.fragment,t),nt=o(t),w=a(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-16xioii"&&(w.innerHTML=Zt),lt=o(t),T=a(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1496un1"&&(T.innerHTML=qt),ot=o(t),$=a(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-iec5lg"&&($.textContent=Ot),st=o(t),M=a(t,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-1ruuqle"&&(M.innerHTML=Nt),at=o(t),G=a(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y864g7"&&(G.innerHTML=zt),rt=o(t),k=a(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-n96a7q"&&(k.textContent=Qt),ut=o(t),x=a(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-138n0c9"&&(x.innerHTML=Vt),mt=o(t),p(b.$$.fragment,t),pt=o(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1p8rrlz"&&(C.innerHTML=Kt),gt=o(t),P=a(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(P)!=="svelte-osktdt"&&(P.innerHTML=Xt),ft=o(t),L=a(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-6aimav"&&(L.innerHTML=Dt),ct=o(t),H=a(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-10krbex"&&(H.innerHTML=Rt),dt=o(t),_=a(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-b4b7dr"&&(_.textContent=te),ht=o(t),U=a(t,"TABLE",{"data-svelte-h":!0}),r(U)!=="svelte-8x81wm"&&(U.innerHTML=ee),yt=o(t),E=a(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-fgh5wb"&&(E.innerHTML=ie),vt=o(t),S=a(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1pe2s2l"&&(S.innerHTML=ne),wt=o(t),I=a(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-okgo5j"&&(I.innerHTML=le),Tt=o(t),J=a(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1dhnlqh"&&(J.innerHTML=oe),$t=o(t),p(W.$$.fragment,t),Mt=o(t),Y=a(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-emmsc9"&&(Y.textContent=se),Gt=o(t),p(j.$$.fragment,t),kt=o(t),B=a(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-yy4ur9"&&(B.textContent=ae),xt=o(t),F=a(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1u70yn5"&&(F.innerHTML=re),bt=o(t),p(A.$$.fragment,t),Ct=o(t),Z=a(t,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-1wz0fdq"&&(Z.innerHTML=ue),Pt=o(t),p(q.$$.fragment,t),Lt=o(t),h=a(t,"OL",{start:!0,"data-svelte-h":!0}),r(h)!=="svelte-1cndhv3"&&(h.innerHTML=me),Ht=o(t),O=a(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1gi8bl1"&&(O.innerHTML=pe),_t=o(t),y=a(t,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1wu31pe"&&(y.innerHTML=ge),Ut=o(t),p(N.$$.fragment,t),Et=o(t),z=a(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ui06bn"&&(z.textContent=fe),St=o(t),p(Q.$$.fragment,t),It=o(t),V=a(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-t1hkz2"&&(V.innerHTML=ce),Jt=o(t),p(K.$$.fragment,t),Wt=o(t),X=a(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-j4g221"&&(X.textContent=de),Yt=o(t),R=a(t,"P",{}),he(R).forEach(i),this.h()},h(){Bt(u,"name","hf:doc:metadata"),Bt(u,"content",xe),Bt(h,"start","3"),Bt(y,"start","4")},m(t,e){Ge(document.head,u),n(t,et,e),n(t,D,e),n(t,it,e),g(v,t,e),n(t,nt,e),n(t,w,e),n(t,lt,e),n(t,T,e),n(t,ot,e),n(t,$,e),n(t,st,e),n(t,M,e),n(t,at,e),n(t,G,e),n(t,rt,e),n(t,k,e),n(t,ut,e),n(t,x,e),n(t,mt,e),g(b,t,e),n(t,pt,e),n(t,C,e),n(t,gt,e),n(t,P,e),n(t,ft,e),n(t,L,e),n(t,ct,e),n(t,H,e),n(t,dt,e),n(t,_,e),n(t,ht,e),n(t,U,e),n(t,yt,e),n(t,E,e),n(t,vt,e),n(t,S,e),n(t,wt,e),n(t,I,e),n(t,Tt,e),n(t,J,e),n(t,$t,e),g(W,t,e),n(t,Mt,e),n(t,Y,e),n(t,Gt,e),g(j,t,e),n(t,kt,e),n(t,B,e),n(t,xt,e),n(t,F,e),n(t,bt,e),g(A,t,e),n(t,Ct,e),n(t,Z,e),n(t,Pt,e),g(q,t,e),n(t,Lt,e),n(t,h,e),n(t,Ht,e),n(t,O,e),n(t,_t,e),n(t,y,e),n(t,Ut,e),g(N,t,e),n(t,Et,e),n(t,z,e),n(t,St,e),g(Q,t,e),n(t,It,e),n(t,V,e),n(t,Jt,e),g(K,t,e),n(t,Wt,e),n(t,X,e),n(t,Yt,e),n(t,R,e),jt=!0},p:ve,i(t){jt||(f(v.$$.fragment,t),f(b.$$.fragment,t),f(W.$$.fragment,t),f(j.$$.fragment,t),f(A.$$.fragment,t),f(q.$$.fragment,t),f(N.$$.fragment,t),f(Q.$$.fragment,t),f(K.$$.fragment,t),jt=!0)},o(t){c(v.$$.fragment,t),c(b.$$.fragment,t),c(W.$$.fragment,t),c(j.$$.fragment,t),c(A.$$.fragment,t),c(q.$$.fragment,t),c(N.$$.fragment,t),c(Q.$$.fragment,t),c(K.$$.fragment,t),jt=!1},d(t){t&&(i(et),i(D),i(it),i(nt),i(w),i(lt),i(T),i(ot),i($),i(st),i(M),i(at),i(G),i(rt),i(k),i(ut),i(x),i(mt),i(pt),i(C),i(gt),i(P),i(ft),i(L),i(ct),i(H),i(dt),i(_),i(ht),i(U),i(yt),i(E),i(vt),i(S),i(wt),i(I),i(Tt),i(J),i($t),i(Mt),i(Y),i(Gt),i(kt),i(B),i(xt),i(F),i(bt),i(Ct),i(Z),i(Pt),i(Lt),i(h),i(Ht),i(O),i(_t),i(y),i(Ut),i(Et),i(z),i(St),i(It),i(V),i(Jt),i(Wt),i(X),i(Yt),i(R)),i(u),d(v,t),d(b,t),d(W,t),d(j,t),d(A,t),d(q,t),d(N,t),d(Q,t),d(K,t)}}}const xe='{"title":"Signing commits with GPG","local":"signing-commits-with-gpg","sections":[{"title":"Setting up signed commits verification","local":"setting-up-signed-commits-verification","sections":[],"depth":2},{"title":"Generating a new GPG key","local":"generating-a-new-gpg-key","sections":[],"depth":2},{"title":"Adding a GPG key to your account","local":"adding-a-gpg-key-to-your-account","sections":[],"depth":2},{"title":"Configure git to sign your commits with GPG","local":"configure-git-to-sign-your-commits-with-gpg","sections":[],"depth":2}],"depth":1}';function be(At){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends Te{constructor(u){super(),$e(this,u,be,ke,ye,{})}}export{_e as component};
