import{s as Xs,n as Fs,o as Rs}from"../chunks/scheduler.7da89386.js";import{S as gs,i as Vs,g as i,s as t,r as o,A as Cs,h as M,f as e,c as n,j as Bs,u as r,x as p,k as Gs,y as ks,a,v as m,d as c,t as y,w as d}from"../chunks/index.0b7befd3.js";import{C as J}from"../chunks/CodeBlock.ce33a881.js";import{H as h}from"../chunks/Heading.8a936589.js";function Ys(as){let T,rl,pl,ml,j,cl,w,yl,U,ts='The examples below provide a quick overview on the various features supported in <code>setfit</code>. For more examples, check out the <a href="https://github.com/huggingface/setfit/tree/main/notebooks" rel="nofollow"><code>notebooks</code></a> folder.',dl,u,Jl,b,ns='<code>setfit</code> is integrated with the <a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a> and provides two main classes:',Tl,I,is='<li><code>SetFitModel</code>: a wrapper that combines a pretrained body from <code>sentence_transformers</code> and a classification head from either <a href="https://scikit-learn.org/stable/modules/generated/sklearn.linear_model.LogisticRegression.html" rel="nofollow"><code>scikit-learn</code></a> or <a href="https://github.com/huggingface/setfit/blob/main/src/setfit/modeling.py" rel="nofollow"><code>SetFitHead</code></a> (a differentiable head built upon <code>PyTorch</code> with similar APIs to <code>sentence_transformers</code>).</li> <li><code>SetFitTrainer</code>: a helper class that wraps the fine-tuning process of SetFit.</li>',hl,Z,Ms="Here is an end-to-end example using a classification head from <code>scikit-learn</code>:",jl,f,wl,W,ps="Here is an end-to-end example using <code>SetFitHead</code>:",Ul,B,ul,G,os='Based on our experiments, <code>SetFitHead</code> can achieve similar performance as using a <code>scikit-learn</code> head. We use <code>AdamW</code> as the optimizer and scale down learning rates by 0.5 every 5 epochs. For more details about the experiments, please check out <a href="https://github.com/huggingface/setfit/pull/112#issuecomment-1295773537" rel="nofollow">here</a>. We recommend using a large learning rate (e.g. <code>1e-2</code>) for <code>SetFitHead</code> and a small learning rate (e.g. <code>1e-5</code>) for the body in your first attempt.',bl,X,Il,F,rs="To train SetFit models on multilabel datasets, specify the <code>multi_target_strategy</code> argument when loading the pretrained model:",Zl,R,fl,g,Wl,V,ms="This will initialise a multilabel classification head from <code>sklearn</code> - the following options are available for <code>multi_target_strategy</code>:",Bl,C,cs="<li><code>one-vs-rest</code>: uses a <code>OneVsRestClassifier</code> head.</li> <li><code>multi-output</code>: uses a <code>MultiOutputClassifier</code> head.</li> <li><code>classifier-chain</code>: uses a <code>ClassifierChain</code> head.</li>",Gl,k,ys="From here, you can instantiate a <code>SetFitTrainer</code> using the same example above, and train it as usual.",Xl,Y,Fl,v,Rl,_,ds="<strong>Note:</strong> If you use the differentiable <code>SetFitHead</code> classifier head, it will automatically use <code>BCEWithLogitsLoss</code> for training. The prediction involves a <code>sigmoid</code> after which probabilities are rounded to 1 or 0. Furthermore, the <code>&quot;one-vs-rest&quot;</code> and <code>&quot;multi-output&quot;</code> multi-target strategies are equivalent for the differentiable <code>SetFitHead</code>.",gl,Q,Vl,S,Js="SetFit can also be applied to scenarios where no labels are available. To do so, create a synthetic dataset of training examples:",Cl,N,kl,z,Ts="This will create examples of the form <code>&quot;This sentence is {}&quot;</code>, where the <code>{}</code> is filled in with one of the candidate labels. From here you can train a SetFit model as usual:",Yl,E,vl,H,hs='We find this approach typically outperforms the <a href="https://huggingface.co/docs/transformers/v4.24.0/en/main_classes/pipelines#transformers.ZeroShotClassificationPipeline" rel="nofollow">zero-shot pipeline</a> in 🤗 Transformers (based on MNLI with Bart), while being 5x faster to generate predictions with.',_l,q,Ql,$,js="<code>SetFitTrainer</code> provides a <code>hyperparameter_search()</code> method that you can use to find good hyperparameters for your data. To use this feature, first install the <code>optuna</code> backend:",Sl,A,Nl,x,ws="To use this method, you need to define two functions:",zl,L,Us="<li><code>model_init()</code>: A function that instantiates the model to be used. If provided, each call to <code>train()</code> will start from a new instance of the model as given by this function.</li> <li><code>hp_space()</code>: A function that defines the hyperparameter search space.</li>",El,D,us="Here is an example of a <code>model_init()</code> function that we’ll use to scan over the hyperparameters associated with the classification head in <code>SetFitModel</code>:",Hl,K,ql,P,bs="Similarly, to scan over hyperparameters associated with the SetFit training process, we can define a <code>hp_space()</code> function as follows:",$l,O,Al,ll,Is="<strong>Note:</strong> In practice, we found <code>num_iterations</code> to be the most important hyperparameter for the contrastive learning process.",xl,sl,Zs="The next step is to instantiate a <code>SetFitTrainer</code> and call <code>hyperparameter_search()</code>:",Ll,el,Dl,al,fs=`Finally, you can apply the hyperparameters you found to the trainer, and lock in the optimal model, before training for
a final time.`,Kl,tl,Pl,nl,Ol,il,Ws="If you have access to unlabeled data, you can use knowledge distillation to compress a trained SetFit model into a smaller version. The result is a model that can run inference much faster, with little to no drop in accuracy. Here’s an end-to-end example (see our paper for more details):",ls,Ml,ss,ol,es;return j=new h({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),w=new h({props:{title:"Usage",local:"usage",headingTag:"h2"}}),u=new h({props:{title:"Training a SetFit model",local:"training-a-setfit-model",headingTag:"h3"}}),f=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> sentence_transformers.losses <span class="hljs-keyword">import</span> CosineSimilarityLoss

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, SetFitTrainer, sample_dataset


<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;sst2&quot;</span>)

<span class="hljs-comment"># Simulate the few-shot regime by sampling 8 examples per class</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
eval_dataset = dataset[<span class="hljs-string">&quot;validation&quot;</span>]

<span class="hljs-comment"># Load a SetFit model from Hub</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)

<span class="hljs-comment"># Create trainer</span>
trainer = SetFitTrainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    loss_class=CosineSimilarityLoss,
    metric=<span class="hljs-string">&quot;accuracy&quot;</span>,
    batch_size=<span class="hljs-number">16</span>,
    num_iterations=<span class="hljs-number">20</span>, <span class="hljs-comment"># The number of text pairs to generate for contrastive learning</span>
    num_epochs=<span class="hljs-number">1</span>, <span class="hljs-comment"># The number of epochs to use for contrastive learning</span>
    column_mapping={<span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>} <span class="hljs-comment"># Map dataset columns to text/label expected by trainer</span>
)

<span class="hljs-comment"># Train and evaluate</span>
trainer.train()
metrics = trainer.evaluate()

<span class="hljs-comment"># Push model to the Hub</span>
trainer.push_to_hub(<span class="hljs-string">&quot;my-awesome-setfit-model&quot;</span>)

<span class="hljs-comment"># Download from Hub and run inference</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;lewtun/my-awesome-setfit-model&quot;</span>)
<span class="hljs-comment"># Run inference</span>
preds = model([<span class="hljs-string">&quot;i loved the spiderman movie!&quot;</span>, <span class="hljs-string">&quot;pineapple on pizza is the worst 🤮&quot;</span>])`,wrap:!1}}),B=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> sentence_transformers.losses <span class="hljs-keyword">import</span> CosineSimilarityLoss

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, SetFitTrainer, sample_dataset


<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;sst2&quot;</span>)

<span class="hljs-comment"># Simulate the few-shot regime by sampling 8 examples per class</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
eval_dataset = dataset[<span class="hljs-string">&quot;validation&quot;</span>]

<span class="hljs-comment"># Load a SetFit model from Hub</span>
model = SetFitModel.from_pretrained(
    <span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>,
    use_differentiable_head=<span class="hljs-literal">True</span>,
    head_params={<span class="hljs-string">&quot;out_features&quot;</span>: num_classes},
)

<span class="hljs-comment"># Create trainer</span>
trainer = SetFitTrainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    loss_class=CosineSimilarityLoss,
    metric=<span class="hljs-string">&quot;accuracy&quot;</span>,
    batch_size=<span class="hljs-number">16</span>,
    num_iterations=<span class="hljs-number">20</span>, <span class="hljs-comment"># The number of text pairs to generate for contrastive learning</span>
    num_epochs=<span class="hljs-number">1</span>, <span class="hljs-comment"># The number of epochs to use for contrastive learning</span>
    column_mapping={<span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>} <span class="hljs-comment"># Map dataset columns to text/label expected by trainer</span>
)

<span class="hljs-comment"># Train and evaluate</span>
trainer.freeze() <span class="hljs-comment"># Freeze the head</span>
trainer.train() <span class="hljs-comment"># Train only the body</span>

<span class="hljs-comment"># Unfreeze the head and freeze the body -&gt; head-only training</span>
trainer.unfreeze(keep_body_frozen=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># Unfreeze the head and unfreeze the body -&gt; end-to-end training</span>
trainer.unfreeze(keep_body_frozen=<span class="hljs-literal">False</span>)

trainer.train(
    num_epochs=<span class="hljs-number">25</span>, <span class="hljs-comment"># The number of epochs to train the head or the whole model (body and head)</span>
    batch_size=<span class="hljs-number">16</span>,
    body_learning_rate=<span class="hljs-number">1e-5</span>, <span class="hljs-comment"># The body&#x27;s learning rate</span>
    learning_rate=<span class="hljs-number">1e-2</span>, <span class="hljs-comment"># The head&#x27;s learning rate</span>
    l2_weight=<span class="hljs-number">0.0</span>, <span class="hljs-comment"># Weight decay on **both** the body and head. If \`None\`, will use 0.01.</span>
)
metrics = trainer.evaluate()

<span class="hljs-comment"># Push model to the Hub</span>
trainer.push_to_hub(<span class="hljs-string">&quot;my-awesome-setfit-model&quot;</span>)

<span class="hljs-comment"># Download from Hub and run inference</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;lewtun/my-awesome-setfit-model&quot;</span>)
<span class="hljs-comment"># Run inference</span>
preds = model([<span class="hljs-string">&quot;i loved the spiderman movie!&quot;</span>, <span class="hljs-string">&quot;pineapple on pizza is the worst 🤮&quot;</span>])`,wrap:!1}}),X=new h({props:{title:"Training on multilabel datasets",local:"training-on-multilabel-datasets",headingTag:"h3"}}),R=new h({props:{title:"Example using a classification head from scikit-learn :",local:"example-using-a-classification-head-from-scikit-learn-",headingTag:"h4"}}),g=new J({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBtdWx0aV90YXJnZXRfc3RyYXRlZ3klM0QlMjJvbmUtdnMtcmVzdCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

model = SetFitModel.from_pretrained(
    model_id,
    multi_target_strategy=<span class="hljs-string">&quot;one-vs-rest&quot;</span>,
)`,wrap:!1}}),Y=new h({props:{title:"Example using the differentiable SetFitHead :",local:"example-using-the-differentiable-setfithead-",headingTag:"h4"}}),v=new J({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBtdWx0aV90YXJnZXRfc3RyYXRlZ3klM0QlMjJvbmUtdnMtcmVzdCUyMiUwQSUyMCUyMCUyMCUyMHVzZV9kaWZmZXJlbnRpYWJsZV9oZWFkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGhlYWRfcGFyYW1zJTNEJTdCJTIyb3V0X2ZlYXR1cmVzJTIyJTNBJTIwbnVtX2NsYXNzZXMlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

model = SetFitModel.from_pretrained(
    model_id,
    multi_target_strategy=<span class="hljs-string">&quot;one-vs-rest&quot;</span>
    use_differentiable_head=<span class="hljs-literal">True</span>,
    head_params={<span class="hljs-string">&quot;out_features&quot;</span>: num_classes},
)`,wrap:!1}}),Q=new h({props:{title:"Zero-shot text classification",local:"zero-shot-text-classification",headingTag:"h3"}}),N=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQlMEElMEFjYW5kaWRhdGVfbGFiZWxzJTIwJTNEJTIwJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQoY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMlMkMlMjBzYW1wbGVfc2l6ZSUzRDgp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset

candidate_labels = [<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>]
train_dataset = get_templated_dataset(candidate_labels=candidate_labels, sample_size=<span class="hljs-number">8</span>)`,wrap:!1}}),E=new J({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwU2V0Rml0VHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRnBhcmFwaHJhc2UtbXBuZXQtYmFzZS12MiUyMiklMEF0cmFpbmVyJTIwJTNEJTIwU2V0Rml0VHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, SetFitTrainer

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)
trainer = SetFitTrainer(
    model=model,
    train_dataset=train_dataset
)
trainer.train()`,wrap:!1}}),q=new h({props:{title:"Running hyperparameter search",local:"running-hyperparameter-search",headingTag:"h3"}}),A=new J({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwc2V0Zml0JTVCb3B0dW5hJTVE",highlighted:"python -m pip install setfit[optuna]",wrap:!1}}),K=new J({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBZGVmJTIwbW9kZWxfaW5pdChwYXJhbXMpJTNBJTBBJTIwJTIwJTIwJTIwcGFyYW1zJTIwJTNEJTIwcGFyYW1zJTIwb3IlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBtYXhfaXRlciUyMCUzRCUyMHBhcmFtcy5nZXQoJTIybWF4X2l0ZXIlMjIlMkMlMjAxMDApJTBBJTIwJTIwJTIwJTIwc29sdmVyJTIwJTNEJTIwcGFyYW1zLmdldCglMjJzb2x2ZXIlMjIlMkMlMjAlMjJsaWJsaW5lYXIlMjIpJTBBJTIwJTIwJTIwJTIwcGFyYW1zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGVhZF9wYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfaXRlciUyMiUzQSUyMG1heF9pdGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc29sdmVyJTIyJTNBJTIwc29sdmVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRnBhcmFwaHJhc2UtYWxiZXJ0LXNtYWxsLXYyJTIyJTJDJTIwKipwYXJhbXMp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">params</span>):
    params = params <span class="hljs-keyword">or</span> {}
    max_iter = params.get(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">100</span>)
    solver = params.get(<span class="hljs-string">&quot;solver&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>)
    params = {
        <span class="hljs-string">&quot;head_params&quot;</span>: {
            <span class="hljs-string">&quot;max_iter&quot;</span>: max_iter,
            <span class="hljs-string">&quot;solver&quot;</span>: solver,
        }
    }
    <span class="hljs-keyword">return</span> SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-albert-small-v2&quot;</span>, **params)`,wrap:!1}}),O=new J({props:{code:"ZGVmJTIwaHBfc3BhY2UodHJpYWwpJTNBJTIwJTIwJTIzJTIwVHJhaW5pbmclMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMHRyaWFsLnN1Z2dlc3RfZmxvYXQoJTIybGVhcm5pbmdfcmF0ZSUyMiUyQyUyMDFlLTYlMkMlMjAxZS00JTJDJTIwbG9nJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fZXBvY2hzJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9pbnQoJTIybnVtX2Vwb2NocyUyMiUyQyUyMDElMkMlMjA1KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJhdGNoX3NpemUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2NhdGVnb3JpY2FsKCUyMmJhdGNoX3NpemUlMjIlMkMlMjAlNUI0JTJDJTIwOCUyQyUyMDE2JTJDJTIwMzIlMkMlMjA2NCU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZWVkJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9pbnQoJTIyc2VlZCUyMiUyQyUyMDElMkMlMjA0MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1faXRlcmF0aW9ucyUyMiUzQSUyMHRyaWFsLnN1Z2dlc3RfY2F0ZWdvcmljYWwoJTIybnVtX2l0ZXJhdGlvbnMlMjIlMkMlMjAlNUI1JTJDJTIwMTAlMkMlMjAyMCU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfaXRlciUyMiUzQSUyMHRyaWFsLnN1Z2dlc3RfaW50KCUyMm1heF9pdGVyJTIyJTJDJTIwNTAlMkMlMjAzMDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc29sdmVyJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJzb2x2ZXIlMjIlMkMlMjAlNUIlMjJuZXd0b24tY2clMjIlMkMlMjAlMjJsYmZncyUyMiUyQyUyMCUyMmxpYmxpbmVhciUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">hp_space</span>(<span class="hljs-params">trial</span>):  <span class="hljs-comment"># Training parameters</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;num_epochs&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;num_epochs&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">5</span>),
        <span class="hljs-string">&quot;batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;batch_size&quot;</span>, [<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>]),
        <span class="hljs-string">&quot;seed&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;seed&quot;</span>, <span class="hljs-number">1</span>, <span class="hljs-number">40</span>),
        <span class="hljs-string">&quot;num_iterations&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;num_iterations&quot;</span>, [<span class="hljs-number">5</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>]),
        <span class="hljs-string">&quot;max_iter&quot;</span>: trial.suggest_int(<span class="hljs-string">&quot;max_iter&quot;</span>, <span class="hljs-number">50</span>, <span class="hljs-number">300</span>),
        <span class="hljs-string">&quot;solver&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;solver&quot;</span>, [<span class="hljs-string">&quot;newton-cg&quot;</span>, <span class="hljs-string">&quot;lbfgs&quot;</span>, <span class="hljs-string">&quot;liblinear&quot;</span>]),
    }`,wrap:!1}}),el=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBTZXRGaXRUcmFpbmVyJTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnRleHRfbmV3JTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlMkMlMjAlMjJjJTIyJTVEJTJDJTIwJTIybGFiZWxfbmV3JTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTJDJTIwJTIyZXh0cmFfY29sdW1uJTIyJTNBJTIwJTVCJTIyZCUyMiUyQyUyMCUyMmUlMjIlMkMlMjAlMjJmJTIyJTVEJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTZXRGaXRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwY29sdW1uX21hcHBpbmclM0QlN0IlMjJ0ZXh0X25ldyUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJsYWJlbF9uZXclMjIlM0ElMjAlMjJsYWJlbCUyMiU3RCUyQyUwQSklMEFiZXN0X3J1biUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTIwaHBfc3BhY2UlM0RocF9zcGFjZSUyQyUyMG5fdHJpYWxzJTNEMjAp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitTrainer

dataset = Dataset.from_dict(
            {<span class="hljs-string">&quot;text_new&quot;</span>: [<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>], <span class="hljs-string">&quot;label_new&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>], <span class="hljs-string">&quot;extra_column&quot;</span>: [<span class="hljs-string">&quot;d&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>, <span class="hljs-string">&quot;f&quot;</span>]}
        )

trainer = SetFitTrainer(
    train_dataset=dataset,
    eval_dataset=dataset,
    model_init=model_init,
    column_mapping={<span class="hljs-string">&quot;text_new&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;label_new&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>},
)
best_run = trainer.hyperparameter_search(direction=<span class="hljs-string">&quot;maximize&quot;</span>, hp_space=hp_space, n_trials=<span class="hljs-number">20</span>)`,wrap:!1}}),tl=new J({props:{code:"dHJhaW5lci5hcHBseV9oeXBlcnBhcmFtZXRlcnMoYmVzdF9ydW4uaHlwZXJwYXJhbWV0ZXJzJTJDJTIwZmluYWxfbW9kZWwlM0RUcnVlKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer.apply_hyperparameters(best_run.hyperparameters, final_model=<span class="hljs-literal">True</span>)
trainer.train()`,wrap:!1}}),nl=new h({props:{title:"Compressing a SetFit model with knowledge distillation",local:"compressing-a-setfit-model-with-knowledge-distillation",headingTag:"h2"}}),Ml=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> sentence_transformers.losses <span class="hljs-keyword">import</span> CosineSimilarityLoss

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, SetFitTrainer, DistillationSetFitTrainer, sample_dataset

<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;ag_news&quot;</span>)

<span class="hljs-comment"># Create a sample few-shot dataset to train the teacher model</span>
train_dataset_teacher = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">16</span>)
<span class="hljs-comment"># Create a dataset of unlabeled examples to train the student</span>
train_dataset_student = dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">0</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))
<span class="hljs-comment"># Dataset for evaluation</span>
eval_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Load teacher model</span>
teacher_model = SetFitModel.from_pretrained(
    <span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>
)

<span class="hljs-comment"># Create trainer for teacher model</span>
teacher_trainer = SetFitTrainer(
    model=teacher_model,
    train_dataset=train_dataset_teacher,
    eval_dataset=eval_dataset,
    loss_class=CosineSimilarityLoss,
)

<span class="hljs-comment"># Train teacher model</span>
teacher_trainer.train()

<span class="hljs-comment"># Load small student model</span>
student_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;paraphrase-MiniLM-L3-v2&quot;</span>)

<span class="hljs-comment"># Create trainer for knowledge distillation</span>
student_trainer = DistillationSetFitTrainer(
    teacher_model=teacher_model,
    train_dataset=train_dataset_student,
    student_model=student_model,
    eval_dataset=eval_dataset,
    loss_class=CosineSimilarityLoss,
    metric=<span class="hljs-string">&quot;accuracy&quot;</span>,
    batch_size=<span class="hljs-number">16</span>,
    num_iterations=<span class="hljs-number">20</span>,
    num_epochs=<span class="hljs-number">1</span>,
)

<span class="hljs-comment"># Train student with knowledge distillation</span>
student_trainer.train()`,wrap:!1}}),{c(){T=i("meta"),rl=t(),pl=i("p"),ml=t(),o(j.$$.fragment),cl=t(),o(w.$$.fragment),yl=t(),U=i("p"),U.innerHTML=ts,dl=t(),o(u.$$.fragment),Jl=t(),b=i("p"),b.innerHTML=ns,Tl=t(),I=i("ul"),I.innerHTML=is,hl=t(),Z=i("p"),Z.innerHTML=Ms,jl=t(),o(f.$$.fragment),wl=t(),W=i("p"),W.innerHTML=ps,Ul=t(),o(B.$$.fragment),ul=t(),G=i("p"),G.innerHTML=os,bl=t(),o(X.$$.fragment),Il=t(),F=i("p"),F.innerHTML=rs,Zl=t(),o(R.$$.fragment),fl=t(),o(g.$$.fragment),Wl=t(),V=i("p"),V.innerHTML=ms,Bl=t(),C=i("ul"),C.innerHTML=cs,Gl=t(),k=i("p"),k.innerHTML=ys,Xl=t(),o(Y.$$.fragment),Fl=t(),o(v.$$.fragment),Rl=t(),_=i("p"),_.innerHTML=ds,gl=t(),o(Q.$$.fragment),Vl=t(),S=i("p"),S.textContent=Js,Cl=t(),o(N.$$.fragment),kl=t(),z=i("p"),z.innerHTML=Ts,Yl=t(),o(E.$$.fragment),vl=t(),H=i("p"),H.innerHTML=hs,_l=t(),o(q.$$.fragment),Ql=t(),$=i("p"),$.innerHTML=js,Sl=t(),o(A.$$.fragment),Nl=t(),x=i("p"),x.textContent=ws,zl=t(),L=i("ul"),L.innerHTML=Us,El=t(),D=i("p"),D.innerHTML=us,Hl=t(),o(K.$$.fragment),ql=t(),P=i("p"),P.innerHTML=bs,$l=t(),o(O.$$.fragment),Al=t(),ll=i("p"),ll.innerHTML=Is,xl=t(),sl=i("p"),sl.innerHTML=Zs,Ll=t(),o(el.$$.fragment),Dl=t(),al=i("p"),al.textContent=fs,Kl=t(),o(tl.$$.fragment),Pl=t(),o(nl.$$.fragment),Ol=t(),il=i("p"),il.textContent=Ws,ls=t(),o(Ml.$$.fragment),ss=t(),ol=i("p"),this.h()},l(l){const s=Cs("svelte-u9bgzb",document.head);T=M(s,"META",{name:!0,content:!0}),s.forEach(e),rl=n(l),pl=M(l,"P",{}),Bs(pl).forEach(e),ml=n(l),r(j.$$.fragment,l),cl=n(l),r(w.$$.fragment,l),yl=n(l),U=M(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-16mv4kk"&&(U.innerHTML=ts),dl=n(l),r(u.$$.fragment,l),Jl=n(l),b=M(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-f3bjeq"&&(b.innerHTML=ns),Tl=n(l),I=M(l,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-i7827m"&&(I.innerHTML=is),hl=n(l),Z=M(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-w5qh2g"&&(Z.innerHTML=Ms),jl=n(l),r(f.$$.fragment,l),wl=n(l),W=M(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-14w4s3k"&&(W.innerHTML=ps),Ul=n(l),r(B.$$.fragment,l),ul=n(l),G=M(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-b5mqr9"&&(G.innerHTML=os),bl=n(l),r(X.$$.fragment,l),Il=n(l),F=M(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-a51xc0"&&(F.innerHTML=rs),Zl=n(l),r(R.$$.fragment,l),fl=n(l),r(g.$$.fragment,l),Wl=n(l),V=M(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1be5bj9"&&(V.innerHTML=ms),Bl=n(l),C=M(l,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-ircko4"&&(C.innerHTML=cs),Gl=n(l),k=M(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-ibydqb"&&(k.innerHTML=ys),Xl=n(l),r(Y.$$.fragment,l),Fl=n(l),r(v.$$.fragment,l),Rl=n(l),_=M(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-o6qtpj"&&(_.innerHTML=ds),gl=n(l),r(Q.$$.fragment,l),Vl=n(l),S=M(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-reulg6"&&(S.textContent=Js),Cl=n(l),r(N.$$.fragment,l),kl=n(l),z=M(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ha9x4l"&&(z.innerHTML=Ts),Yl=n(l),r(E.$$.fragment,l),vl=n(l),H=M(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-soi3eu"&&(H.innerHTML=hs),_l=n(l),r(q.$$.fragment,l),Ql=n(l),$=M(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-88vqf1"&&($.innerHTML=js),Sl=n(l),r(A.$$.fragment,l),Nl=n(l),x=M(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1h1g3w1"&&(x.textContent=ws),zl=n(l),L=M(l,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-16e6dsc"&&(L.innerHTML=Us),El=n(l),D=M(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-gq9zgk"&&(D.innerHTML=us),Hl=n(l),r(K.$$.fragment,l),ql=n(l),P=M(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1l6sj1w"&&(P.innerHTML=bs),$l=n(l),r(O.$$.fragment,l),Al=n(l),ll=M(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-5j87i5"&&(ll.innerHTML=Is),xl=n(l),sl=M(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-3gia6k"&&(sl.innerHTML=Zs),Ll=n(l),r(el.$$.fragment,l),Dl=n(l),al=M(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-p8mtac"&&(al.textContent=fs),Kl=n(l),r(tl.$$.fragment,l),Pl=n(l),r(nl.$$.fragment,l),Ol=n(l),il=M(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1s6la9t"&&(il.textContent=Ws),ls=n(l),r(Ml.$$.fragment,l),ss=n(l),ol=M(l,"P",{}),Bs(ol).forEach(e),this.h()},h(){Gs(T,"name","hf:doc:metadata"),Gs(T,"content",vs)},m(l,s){ks(document.head,T),a(l,rl,s),a(l,pl,s),a(l,ml,s),m(j,l,s),a(l,cl,s),m(w,l,s),a(l,yl,s),a(l,U,s),a(l,dl,s),m(u,l,s),a(l,Jl,s),a(l,b,s),a(l,Tl,s),a(l,I,s),a(l,hl,s),a(l,Z,s),a(l,jl,s),m(f,l,s),a(l,wl,s),a(l,W,s),a(l,Ul,s),m(B,l,s),a(l,ul,s),a(l,G,s),a(l,bl,s),m(X,l,s),a(l,Il,s),a(l,F,s),a(l,Zl,s),m(R,l,s),a(l,fl,s),m(g,l,s),a(l,Wl,s),a(l,V,s),a(l,Bl,s),a(l,C,s),a(l,Gl,s),a(l,k,s),a(l,Xl,s),m(Y,l,s),a(l,Fl,s),m(v,l,s),a(l,Rl,s),a(l,_,s),a(l,gl,s),m(Q,l,s),a(l,Vl,s),a(l,S,s),a(l,Cl,s),m(N,l,s),a(l,kl,s),a(l,z,s),a(l,Yl,s),m(E,l,s),a(l,vl,s),a(l,H,s),a(l,_l,s),m(q,l,s),a(l,Ql,s),a(l,$,s),a(l,Sl,s),m(A,l,s),a(l,Nl,s),a(l,x,s),a(l,zl,s),a(l,L,s),a(l,El,s),a(l,D,s),a(l,Hl,s),m(K,l,s),a(l,ql,s),a(l,P,s),a(l,$l,s),m(O,l,s),a(l,Al,s),a(l,ll,s),a(l,xl,s),a(l,sl,s),a(l,Ll,s),m(el,l,s),a(l,Dl,s),a(l,al,s),a(l,Kl,s),m(tl,l,s),a(l,Pl,s),m(nl,l,s),a(l,Ol,s),a(l,il,s),a(l,ls,s),m(Ml,l,s),a(l,ss,s),a(l,ol,s),es=!0},p:Fs,i(l){es||(c(j.$$.fragment,l),c(w.$$.fragment,l),c(u.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(X.$$.fragment,l),c(R.$$.fragment,l),c(g.$$.fragment,l),c(Y.$$.fragment,l),c(v.$$.fragment,l),c(Q.$$.fragment,l),c(N.$$.fragment,l),c(E.$$.fragment,l),c(q.$$.fragment,l),c(A.$$.fragment,l),c(K.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(tl.$$.fragment,l),c(nl.$$.fragment,l),c(Ml.$$.fragment,l),es=!0)},o(l){y(j.$$.fragment,l),y(w.$$.fragment,l),y(u.$$.fragment,l),y(f.$$.fragment,l),y(B.$$.fragment,l),y(X.$$.fragment,l),y(R.$$.fragment,l),y(g.$$.fragment,l),y(Y.$$.fragment,l),y(v.$$.fragment,l),y(Q.$$.fragment,l),y(N.$$.fragment,l),y(E.$$.fragment,l),y(q.$$.fragment,l),y(A.$$.fragment,l),y(K.$$.fragment,l),y(O.$$.fragment,l),y(el.$$.fragment,l),y(tl.$$.fragment,l),y(nl.$$.fragment,l),y(Ml.$$.fragment,l),es=!1},d(l){l&&(e(rl),e(pl),e(ml),e(cl),e(yl),e(U),e(dl),e(Jl),e(b),e(Tl),e(I),e(hl),e(Z),e(jl),e(wl),e(W),e(Ul),e(ul),e(G),e(bl),e(Il),e(F),e(Zl),e(fl),e(Wl),e(V),e(Bl),e(C),e(Gl),e(k),e(Xl),e(Fl),e(Rl),e(_),e(gl),e(Vl),e(S),e(Cl),e(kl),e(z),e(Yl),e(vl),e(H),e(_l),e(Ql),e($),e(Sl),e(Nl),e(x),e(zl),e(L),e(El),e(D),e(Hl),e(ql),e(P),e($l),e(Al),e(ll),e(xl),e(sl),e(Ll),e(Dl),e(al),e(Kl),e(Pl),e(Ol),e(il),e(ls),e(ss),e(ol)),e(T),d(j,l),d(w,l),d(u,l),d(f,l),d(B,l),d(X,l),d(R,l),d(g,l),d(Y,l),d(v,l),d(Q,l),d(N,l),d(E,l),d(q,l),d(A,l),d(K,l),d(O,l),d(el,l),d(tl,l),d(nl,l),d(Ml,l)}}}const vs='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Usage","local":"usage","sections":[{"title":"Training a SetFit model","local":"training-a-setfit-model","sections":[],"depth":3},{"title":"Training on multilabel datasets","local":"training-on-multilabel-datasets","sections":[{"title":"Example using a classification head from scikit-learn :","local":"example-using-a-classification-head-from-scikit-learn-","sections":[],"depth":4},{"title":"Example using the differentiable SetFitHead :","local":"example-using-the-differentiable-setfithead-","sections":[],"depth":4}],"depth":3},{"title":"Zero-shot text classification","local":"zero-shot-text-classification","sections":[],"depth":3},{"title":"Running hyperparameter search","local":"running-hyperparameter-search","sections":[],"depth":3}],"depth":2},{"title":"Compressing a SetFit model with knowledge distillation","local":"compressing-a-setfit-model-with-knowledge-distillation","sections":[],"depth":2}],"depth":1}';function _s(as){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends gs{constructor(T){super(),Vs(this,T,_s,Ys,Xs,{})}}export{Es as component};
