import{s as Ls,n as Qs,o as As}from"../chunks/scheduler.6062bdaf.js";import{S as Ps,i as Ds,g as p,s as l,r as m,A as Ks,h as i,f as t,c as n,j as q,u as c,x as o,k as Xs,y as r,a,v as h,d,t as g,w as u}from"../chunks/index.4bca734e.js";import{C as Q}from"../chunks/CodeBlock.fa01571c.js";import{H as Zs,E as Os}from"../chunks/EditOnGithub.74ab2baa.js";function se(Rs){let f,D,A,K,J,O,w,vs='In addition to the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds on top of the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',ss,j,es,T,ts,b,$s="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",as,U,Ss="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",ls,Z,ns,k,Fs='The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ps,I,is,y,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',os,G,Ws="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",ms,_,Ys='Some interesting integrations where <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',cs,z,X,V,Hs='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',ks,R,rs,v,Cs='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',hs,M,$,N,xs='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Is,S,Gs,F,L,Es='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',_s,B,ds,W,gs,Y,qs='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',us,H,zs='It is also possible to log in programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',fs,C,ys,x,Vs="If you log in this way, be careful not to accidentally leak the token when sharing your source code!",Ms,E,Js,P,ws;return J=new Zs({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),j=new Zs({props:{title:"Usage",local:"usage",headingTag:"h2"}}),T=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiolMkYqLmNzdiUyMiklMEElMEElMjMlMjBSZWFkJTIwYSUyMHJlbW90ZSUyMGZpbGUlMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnRyYWluLmNzdiUyMiUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YSUyMCUzRCUyMGYucmVhZGxpbmVzKCklMEElMEElMjMlMjBSZWFkJTIwdGhlJTIwY29udGVudCUyMG9mJTIwYSUyMHJlbW90ZSUyMGZpbGUlMjBhcyUyMGElMjBzdHJpbmclMEF0cmFpbl9kYXRhJTIwJTNEJTIwZnMucmVhZF90ZXh0KCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJkZXYlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdmFsaWRhdGlvbi5jc3YlMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIydGV4dCUyQ2xhYmVsJTIyKSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIyRmFudGFzdGljJTIwbW92aWUhJTJDZ29vZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**/*.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),Z=new Zs({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),I=new Q({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),R=new Q({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),S=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),B=new Q({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),W=new Zs({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),C=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),E=new Os({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/hf_file_system.md"}}),{c(){f=p("meta"),D=l(),A=p("p"),K=l(),m(J.$$.fragment),O=l(),w=p("p"),w.innerHTML=vs,ss=l(),m(j.$$.fragment),es=l(),m(T.$$.fragment),ts=l(),b=p("p"),b.innerHTML=$s,as=l(),U=p("p"),U.innerHTML=Ss,ls=l(),m(Z.$$.fragment),ns=l(),k=p("p"),k.innerHTML=Fs,ps=l(),m(I.$$.fragment),is=l(),y=p("div"),y.innerHTML=Bs,os=l(),G=p("p"),G.innerHTML=Ws,ms=l(),_=p("p"),_.innerHTML=Ys,cs=l(),z=p("ul"),X=p("li"),V=p("p"),V.innerHTML=Hs,ks=l(),m(R.$$.fragment),rs=l(),v=p("p"),v.innerHTML=Cs,hs=l(),M=p("ul"),$=p("li"),N=p("p"),N.innerHTML=xs,Is=l(),m(S.$$.fragment),Gs=l(),F=p("li"),L=p("p"),L.innerHTML=Es,_s=l(),m(B.$$.fragment),ds=l(),m(W.$$.fragment),gs=l(),Y=p("p"),Y.innerHTML=qs,us=l(),H=p("p"),H.innerHTML=zs,fs=l(),m(C.$$.fragment),ys=l(),x=p("p"),x.textContent=Vs,Ms=l(),m(E.$$.fragment),Js=l(),P=p("p"),this.h()},l(s){const e=Ks("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(t),D=n(s),A=i(s,"P",{}),q(A).forEach(t),K=n(s),c(J.$$.fragment,s),O=n(s),w=i(s,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1tojfmw"&&(w.innerHTML=vs),ss=n(s),c(j.$$.fragment,s),es=n(s),c(T.$$.fragment,s),ts=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-fkc5g9"&&(b.innerHTML=$s),as=n(s),U=i(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-2xrojz"&&(U.innerHTML=Ss),ls=n(s),c(Z.$$.fragment,s),ns=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-qh16s5"&&(k.innerHTML=Fs),ps=n(s),c(I.$$.fragment,s),is=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-167v4fl"&&(y.innerHTML=Bs),os=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1x0g0bv"&&(G.innerHTML=Ws),ms=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-v2qldv"&&(_.innerHTML=Ys),cs=n(s),z=i(s,"UL",{});var Ns=q(z);X=i(Ns,"LI",{});var js=q(X);V=i(js,"P",{"data-svelte-h":!0}),o(V)!=="svelte-8bmxp4"&&(V.innerHTML=Hs),ks=n(js),c(R.$$.fragment,js),js.forEach(t),Ns.forEach(t),rs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-evo4u9"&&(v.innerHTML=Cs),hs=n(s),M=i(s,"UL",{});var Ts=q(M);$=i(Ts,"LI",{});var bs=q($);N=i(bs,"P",{"data-svelte-h":!0}),o(N)!=="svelte-14x5nlf"&&(N.innerHTML=xs),Is=n(bs),c(S.$$.fragment,bs),bs.forEach(t),Gs=n(Ts),F=i(Ts,"LI",{});var Us=q(F);L=i(Us,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1abwu1e"&&(L.innerHTML=Es),_s=n(Us),c(B.$$.fragment,Us),Us.forEach(t),Ts.forEach(t),ds=n(s),c(W.$$.fragment,s),gs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-kwqcxw"&&(Y.innerHTML=qs),us=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-cxfkyz"&&(H.innerHTML=zs),fs=n(s),c(C.$$.fragment,s),ys=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-172urp9"&&(x.textContent=Vs),Ms=n(s),c(E.$$.fragment,s),Js=n(s),P=i(s,"P",{}),q(P).forEach(t),this.h()},h(){Xs(f,"name","hf:doc:metadata"),Xs(f,"content",ee),Xs(y,"class","flex justify-center")},m(s,e){r(document.head,f),a(s,D,e),a(s,A,e),a(s,K,e),h(J,s,e),a(s,O,e),a(s,w,e),a(s,ss,e),h(j,s,e),a(s,es,e),h(T,s,e),a(s,ts,e),a(s,b,e),a(s,as,e),a(s,U,e),a(s,ls,e),h(Z,s,e),a(s,ns,e),a(s,k,e),a(s,ps,e),h(I,s,e),a(s,is,e),a(s,y,e),a(s,os,e),a(s,G,e),a(s,ms,e),a(s,_,e),a(s,cs,e),a(s,z,e),r(z,X),r(X,V),r(X,ks),h(R,X,null),a(s,rs,e),a(s,v,e),a(s,hs,e),a(s,M,e),r(M,$),r($,N),r($,Is),h(S,$,null),r(M,Gs),r(M,F),r(F,L),r(F,_s),h(B,F,null),a(s,ds,e),h(W,s,e),a(s,gs,e),a(s,Y,e),a(s,us,e),a(s,H,e),a(s,fs,e),h(C,s,e),a(s,ys,e),a(s,x,e),a(s,Ms,e),h(E,s,e),a(s,Js,e),a(s,P,e),ws=!0},p:Qs,i(s){ws||(d(J.$$.fragment,s),d(j.$$.fragment,s),d(T.$$.fragment,s),d(Z.$$.fragment,s),d(I.$$.fragment,s),d(R.$$.fragment,s),d(S.$$.fragment,s),d(B.$$.fragment,s),d(W.$$.fragment,s),d(C.$$.fragment,s),d(E.$$.fragment,s),ws=!0)},o(s){g(J.$$.fragment,s),g(j.$$.fragment,s),g(T.$$.fragment,s),g(Z.$$.fragment,s),g(I.$$.fragment,s),g(R.$$.fragment,s),g(S.$$.fragment,s),g(B.$$.fragment,s),g(W.$$.fragment,s),g(C.$$.fragment,s),g(E.$$.fragment,s),ws=!1},d(s){s&&(t(D),t(A),t(K),t(O),t(w),t(ss),t(es),t(ts),t(b),t(as),t(U),t(ls),t(ns),t(k),t(ps),t(is),t(y),t(os),t(G),t(ms),t(_),t(cs),t(z),t(rs),t(v),t(hs),t(M),t(ds),t(gs),t(Y),t(us),t(H),t(fs),t(ys),t(x),t(Ms),t(Js),t(P)),t(f),u(J,s),u(j,s),u(T,s),u(Z,s),u(I,s),u(R),u(S),u(B),u(W,s),u(C,s),u(E,s)}}}const ee='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function te(Rs){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ie extends Ps{constructor(f){super(),Ds(this,f,te,se,Ls,{})}}export{ie as component};
