import{s as Ja,n as Ua,o as Fa}from"../chunks/scheduler.85c25b89.js";import{S as Za,i as La,g as l,s as n,r as p,A as Ha,h as i,f as t,c as o,j as v,u as _,x as m,k as b,y as r,a as s,v as g,d as u,t as f,w as h}from"../chunks/index.c142fe32.js";import{D as T}from"../chunks/Docstring.e6639b56.js";import{C as Ot}from"../chunks/CodeBlock.a5e95a57.js";import{H as Z,E as Ia}from"../chunks/EditOnGithub.a592e7aa.js";function Ea(ta){let x,ze,Pe,De,L,Ge,H,aa='<a href="https://huggingface.co/models?other=bco,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-BCO-blue"/></a>',je,I,na=`TRL supports the Binary Classifier Optimization (BCO).
The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
For a full example have a look at  <code>examples/scripts/bco.py</code>.`,Xe,E,Re,V,oa=`The <a href="/docs/trl/main/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> requires an <a href="dataset_formats#unpaired-preference">unpaired preference dataset</a>.
The <a href="/docs/trl/main/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.`,Ae,P,Qe,W,ra="The BCO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",qe,z,Se,D,la="For a detailed example have a look at the <code>examples/scripts/bco.py</code> script. At a high level we need to initialize the <code>BCOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",Ye,G,ia="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ke,j,et,X,sa="After this one can then call:",tt,R,at,A,nt,Q,da=`In practical scenarios, the thumbs-up and thumbs-down datasets are likely to have divergent underlying distributions of prompts.
Consider an LLM deployed for user feedback: if the model excels in writing tasks but underperforms in coding, the thumbs-up dataset will be dominated by writing-related prompts, while the thumbs-down dataset will contain mostly coding-related prompts.<br/>
If the prompts in your desired and undesired datasets differ a lot, it is useful to enable UDM.`,ot,q,ma="Choose an embedding model and tokenizer:",rt,S,lt,Y,ca="Set <code>prompt_sample_size</code> to defined how many prompts are selected to train the UDM classifier and start the training with the provided embedding function:",it,K,st,ee,dt,te,pa=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,mt,ae,_a=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,ct,ne,pt,d,oe,Mt,be,ga='Initialize BCOTrainer from <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.',Bt,O,re,Nt,Te,ua="Compute the BCO loss for a batch of policy and reference model log probabilities.",kt,M,le,Jt,ye,fa="Computes log probabilities of the reference model for a single padded batch of a BCO specific dataset.",Ut,B,ie,Ft,Ce,ha="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Zt,C,se,Lt,$e,va=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ht,we,ba="Works both with or without labels.",It,N,de,Et,xe,Ta="Generate samples from the model and reference model for the given batch of inputs.",Vt,k,me,Pt,Oe,ya="Compute the log probabilities of the given labels under the given logits.",Wt,J,ce,zt,Me,Ca="Compute the BCO loss and other metrics for the given batch of inputs for train or test.",Dt,$,pe,Gt,Be,$a="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",jt,Ne,wa="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Xt,w,_e,Rt,ke,xa="Returns the training <code>~torch.utils.data.DataLoader</code>.",At,Je,Oa="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Qt,U,ge,qt,Ue,Ma="Log <code>logs</code> on the various objects watching training, including stored metrics.",St,F,ue,Yt,Fe,Ba="Context manager for handling null reference model (that is, peft adapter manipulation).",_t,fe,gt,y,he,Kt,Ze,Na='Configuration class for the <a href="/docs/trl/main/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a>.',ea,Le,ka=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ut,ve,ft,We,ht;return L=new Z({props:{title:"BCO Trainer",local:"bco-trainer",headingTag:"h1"}}),E=new Z({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),P=new Z({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),z=new Z({props:{title:"Using the BCOTrainer",local:"using-the-bcotrainer",headingTag:"h2"}}),j=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
)`,wrap:!1}}),R=new Ot({props:{code:"YmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"bco_trainer.train()",wrap:!1}}),A=new Z({props:{title:"Underlying Distribution matching (UDM)",local:"underlying-distribution-matching-udm",headingTag:"h2"}}),S=new Ot({props:{code:"ZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQWVtYmVkZGluZ190b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQSUwQSUyMyUyMGN1c3RvbWl6ZSUyMHRoaXMlMjBmdW5jdGlvbiUyMGRlcGVuZGluZyUyMG9uJTIweW91ciUyMGVtYmVkZGluZyUyMG1vZGVsJTBBZGVmJTIwZW1iZWRfcHJvbXB0KGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTNEYXR0ZW50aW9uX21hc2spJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZS5tZWFuKGRpbSUzRDEpJTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQWNjZWxlcmF0b3IoKS5wcmVwYXJlX21vZGVsKHNlbGYuZW1iZWRkaW5nX21vZGVsKSUwQWVtYmVkZGluZ19mdW5jJTIwJTNEJTIwcGFydGlhbChlbWJlZF9wcm9tcHQlMkMlMjBtb2RlbCUzRGVtYmVkZGluZ19tb2RlbCk=",highlighted:`embedding_model = AutoModel.from_pretrained(your_model_id)
embedding_tokenizer = AutoTokenizer.from_pretrained(your_model_id)

<span class="hljs-comment"># customize this function depending on your embedding model</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompt</span>(<span class="hljs-params">input_ids, attention_mask, model</span>):
    outputs = model(input_ids=input_ids, attention_mask=attention_mask)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)

embedding_model = Accelerator().prepare_model(self.embedding_model)
embedding_func = partial(embed_prompt, model=embedding_model)`,wrap:!1}}),K=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3NhbXBsZV9zaXplJTNENTEyJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX2Z1bmMlM0RlbWJlZGRpbmdfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ190b2tlbml6ZXIlM0RzZWxmLmVtYmVkZGluZ190b2tlbml6ZXIlMkMlMEEpJTBBJTBBYmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
    prompt_sample_size=<span class="hljs-number">512</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
    embedding_func=embedding_func,
    embedding_tokenizer=self.embedding_tokenizer,
)

bco_trainer.train()`,wrap:!1}}),ee=new Z({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),ne=new Z({props:{title:"BCOTrainer",local:"trl.BCOTrainer",headingTag:"h2"}}),oe=new T({props:{name:"class trl.BCOTrainer",anchor:"trl.BCOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": BCOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"processing_class",val:": Union = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"embedding_func",val:": Optional = None"},{name:"embedding_tokenizer",val:": Optional = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.BCOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.BCOTrainer.args",description:`<strong>args</strong> (<code>BCOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.BCOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.BCOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.BCOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.BCOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.BCOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.BCOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.BCOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.BCOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.BCOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.BCOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.BCOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.BCOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.BCOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L274"}}),re=new T({props:{name:"bco_loss",anchor:"trl.BCOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": Optional"},{name:"rejected_embeddings",val:": Optional"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, delta).
The losses tensor contains the BCO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),le=new T({props:{name:"compute_reference_log_probs",anchor:"trl.BCOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L978"}}),ie=new T({props:{name:"create_model_card",anchor:"trl.BCOTrainer.create_model_card",parameters:[{name:"model_name",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"tags",val:": Union = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.BCOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.BCOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or None, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1471"}}),se=new T({props:{name:"evaluation_loop",anchor:"trl.BCOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1382"}}),de=new T({props:{name:"generate_from_model_and_ref",anchor:"trl.BCOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1297"}}),me=new T({props:{name:"get_batch_logps",anchor:"trl.BCOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1021",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ce=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.BCOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1181"}}),pe=new T({props:{name:"get_eval_dataloader",anchor:"trl.BCOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L932"}}),_e=new T({props:{name:"get_train_dataloader",anchor:"trl.BCOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L898"}}),ge=new T({props:{name:"log",anchor:"trl.BCOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.BCOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L1438"}}),ue=new T({props:{name:"null_ref_context",anchor:"trl.BCOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_trainer.py#L886"}}),fe=new Z({props:{title:"BCOConfig",local:"trl.BCOConfig",headingTag:"h2"}}),he=new T({props:{name:"class trl.BCOConfig",anchor:"trl.BCOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"average_tokens_across_devices",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.BCOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.BCOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.BCOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.BCOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model.`,name:"beta"},{anchor:"trl.BCOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>,  <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.BCOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.BCOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.BCOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from both the model and the reference model to W&amp;B during
evaluation.`,name:"generate_during_eval"},{anchor:"trl.BCOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.BCOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.BCOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.BCOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.BCOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.BCOConfig.prompt_sample_size",description:`<strong>prompt_sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of prompts that are fed to density ratio classifier.`,name:"prompt_sample_size"},{anchor:"trl.BCOConfig.min_density_ratio",description:`<strong>min_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Minimum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"min_density_ratio"},{anchor:"trl.BCOConfig.max_density_ratio",description:`<strong>max_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10.0</code>) &#x2014;
Maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"max_density_ratio"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/bco_config.py#L20"}}),ve=new Ia({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/bco_trainer.mdx"}}),{c(){x=l("meta"),ze=n(),Pe=l("p"),De=n(),p(L.$$.fragment),Ge=n(),H=l("p"),H.innerHTML=aa,je=n(),I=l("p"),I.innerHTML=na,Xe=n(),p(E.$$.fragment),Re=n(),V=l("p"),V.innerHTML=oa,Ae=n(),p(P.$$.fragment),Qe=n(),W=l("p"),W.innerHTML=ra,qe=n(),p(z.$$.fragment),Se=n(),D=l("p"),D.innerHTML=la,Ye=n(),G=l("p"),G.innerHTML=ia,Ke=n(),p(j.$$.fragment),et=n(),X=l("p"),X.textContent=sa,tt=n(),p(R.$$.fragment),at=n(),p(A.$$.fragment),nt=n(),Q=l("p"),Q.innerHTML=da,ot=n(),q=l("p"),q.textContent=ma,rt=n(),p(S.$$.fragment),lt=n(),Y=l("p"),Y.innerHTML=ca,it=n(),p(K.$$.fragment),st=n(),p(ee.$$.fragment),dt=n(),te=l("p"),te.innerHTML=pa,mt=n(),ae=l("p"),ae.innerHTML=_a,ct=n(),p(ne.$$.fragment),pt=n(),d=l("div"),p(oe.$$.fragment),Mt=n(),be=l("p"),be.innerHTML=ga,Bt=n(),O=l("div"),p(re.$$.fragment),Nt=n(),Te=l("p"),Te.textContent=ua,kt=n(),M=l("div"),p(le.$$.fragment),Jt=n(),ye=l("p"),ye.textContent=fa,Ut=n(),B=l("div"),p(ie.$$.fragment),Ft=n(),Ce=l("p"),Ce.innerHTML=ha,Zt=n(),C=l("div"),p(se.$$.fragment),Lt=n(),$e=l("p"),$e.innerHTML=va,Ht=n(),we=l("p"),we.textContent=ba,It=n(),N=l("div"),p(de.$$.fragment),Et=n(),xe=l("p"),xe.textContent=Ta,Vt=n(),k=l("div"),p(me.$$.fragment),Pt=n(),Oe=l("p"),Oe.textContent=ya,Wt=n(),J=l("div"),p(ce.$$.fragment),zt=n(),Me=l("p"),Me.textContent=Ca,Dt=n(),$=l("div"),p(pe.$$.fragment),Gt=n(),Be=l("p"),Be.innerHTML=$a,jt=n(),Ne=l("p"),Ne.innerHTML=wa,Xt=n(),w=l("div"),p(_e.$$.fragment),Rt=n(),ke=l("p"),ke.innerHTML=xa,At=n(),Je=l("p"),Je.innerHTML=Oa,Qt=n(),U=l("div"),p(ge.$$.fragment),qt=n(),Ue=l("p"),Ue.innerHTML=Ma,St=n(),F=l("div"),p(ue.$$.fragment),Yt=n(),Fe=l("p"),Fe.textContent=Ba,_t=n(),p(fe.$$.fragment),gt=n(),y=l("div"),p(he.$$.fragment),Kt=n(),Ze=l("p"),Ze.innerHTML=Na,ea=n(),Le=l("p"),Le.innerHTML=ka,ut=n(),p(ve.$$.fragment),ft=n(),We=l("p"),this.h()},l(e){const a=Ha("svelte-u9bgzb",document.head);x=i(a,"META",{name:!0,content:!0}),a.forEach(t),ze=o(e),Pe=i(e,"P",{}),v(Pe).forEach(t),De=o(e),_(L.$$.fragment,e),Ge=o(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-n86tfs"&&(H.innerHTML=aa),je=o(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-r130jr"&&(I.innerHTML=na),Xe=o(e),_(E.$$.fragment,e),Re=o(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-178qhza"&&(V.innerHTML=oa),Ae=o(e),_(P.$$.fragment,e),Qe=o(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-a13xh1"&&(W.innerHTML=ra),qe=o(e),_(z.$$.fragment,e),Se=o(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1xv0q10"&&(D.innerHTML=la),Ye=o(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1eil2tw"&&(G.innerHTML=ia),Ke=o(e),_(j.$$.fragment,e),et=o(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1lg6q1l"&&(X.textContent=sa),tt=o(e),_(R.$$.fragment,e),at=o(e),_(A.$$.fragment,e),nt=o(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-16kpfu0"&&(Q.innerHTML=da),ot=o(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1hlwkqm"&&(q.textContent=ma),rt=o(e),_(S.$$.fragment,e),lt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-ef1qid"&&(Y.innerHTML=ca),it=o(e),_(K.$$.fragment,e),st=o(e),_(ee.$$.fragment,e),dt=o(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-3kfva2"&&(te.innerHTML=pa),mt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1c01yo3"&&(ae.innerHTML=_a),ct=o(e),_(ne.$$.fragment,e),pt=o(e),d=i(e,"DIV",{class:!0});var c=v(d);_(oe.$$.fragment,c),Mt=o(c),be=i(c,"P",{"data-svelte-h":!0}),m(be)!=="svelte-13v1u5r"&&(be.innerHTML=ga),Bt=o(c),O=i(c,"DIV",{class:!0});var vt=v(O);_(re.$$.fragment,vt),Nt=o(vt),Te=i(vt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-2814fy"&&(Te.textContent=ua),vt.forEach(t),kt=o(c),M=i(c,"DIV",{class:!0});var bt=v(M);_(le.$$.fragment,bt),Jt=o(bt),ye=i(bt,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-2l3xud"&&(ye.textContent=fa),bt.forEach(t),Ut=o(c),B=i(c,"DIV",{class:!0});var Tt=v(B);_(ie.$$.fragment,Tt),Ft=o(Tt),Ce=i(Tt,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1mh859w"&&(Ce.innerHTML=ha),Tt.forEach(t),Zt=o(c),C=i(c,"DIV",{class:!0});var He=v(C);_(se.$$.fragment,He),Lt=o(He),$e=i(He,"P",{"data-svelte-h":!0}),m($e)!=="svelte-8qlty5"&&($e.innerHTML=va),Ht=o(He),we=i(He,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1tyo99t"&&(we.textContent=ba),He.forEach(t),It=o(c),N=i(c,"DIV",{class:!0});var yt=v(N);_(de.$$.fragment,yt),Et=o(yt),xe=i(yt,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-18uwvbi"&&(xe.textContent=Ta),yt.forEach(t),Vt=o(c),k=i(c,"DIV",{class:!0});var Ct=v(k);_(me.$$.fragment,Ct),Pt=o(Ct),Oe=i(Ct,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-4nmimv"&&(Oe.textContent=ya),Ct.forEach(t),Wt=o(c),J=i(c,"DIV",{class:!0});var $t=v(J);_(ce.$$.fragment,$t),zt=o($t),Me=i($t,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1syv8mg"&&(Me.textContent=Ca),$t.forEach(t),Dt=o(c),$=i(c,"DIV",{class:!0});var Ie=v($);_(pe.$$.fragment,Ie),Gt=o(Ie),Be=i(Ie,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-xesobz"&&(Be.innerHTML=$a),jt=o(Ie),Ne=i(Ie,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-qg43tm"&&(Ne.innerHTML=wa),Ie.forEach(t),Xt=o(c),w=i(c,"DIV",{class:!0});var Ee=v(w);_(_e.$$.fragment,Ee),Rt=o(Ee),ke=i(Ee,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-dkae9b"&&(ke.innerHTML=xa),At=o(Ee),Je=i(Ee,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-hmd5cw"&&(Je.innerHTML=Oa),Ee.forEach(t),Qt=o(c),U=i(c,"DIV",{class:!0});var wt=v(U);_(ge.$$.fragment,wt),qt=o(wt),Ue=i(wt,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-nqksfz"&&(Ue.innerHTML=Ma),wt.forEach(t),St=o(c),F=i(c,"DIV",{class:!0});var xt=v(F);_(ue.$$.fragment,xt),Yt=o(xt),Fe=i(xt,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-17kjsy4"&&(Fe.textContent=Ba),xt.forEach(t),c.forEach(t),_t=o(e),_(fe.$$.fragment,e),gt=o(e),y=i(e,"DIV",{class:!0});var Ve=v(y);_(he.$$.fragment,Ve),Kt=o(Ve),Ze=i(Ve,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-r4ou6y"&&(Ze.innerHTML=Na),ea=o(Ve),Le=i(Ve,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-ekuf1t"&&(Le.innerHTML=ka),Ve.forEach(t),ut=o(e),_(ve.$$.fragment,e),ft=o(e),We=i(e,"P",{}),v(We).forEach(t),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",Va),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){r(document.head,x),s(e,ze,a),s(e,Pe,a),s(e,De,a),g(L,e,a),s(e,Ge,a),s(e,H,a),s(e,je,a),s(e,I,a),s(e,Xe,a),g(E,e,a),s(e,Re,a),s(e,V,a),s(e,Ae,a),g(P,e,a),s(e,Qe,a),s(e,W,a),s(e,qe,a),g(z,e,a),s(e,Se,a),s(e,D,a),s(e,Ye,a),s(e,G,a),s(e,Ke,a),g(j,e,a),s(e,et,a),s(e,X,a),s(e,tt,a),g(R,e,a),s(e,at,a),g(A,e,a),s(e,nt,a),s(e,Q,a),s(e,ot,a),s(e,q,a),s(e,rt,a),g(S,e,a),s(e,lt,a),s(e,Y,a),s(e,it,a),g(K,e,a),s(e,st,a),g(ee,e,a),s(e,dt,a),s(e,te,a),s(e,mt,a),s(e,ae,a),s(e,ct,a),g(ne,e,a),s(e,pt,a),s(e,d,a),g(oe,d,null),r(d,Mt),r(d,be),r(d,Bt),r(d,O),g(re,O,null),r(O,Nt),r(O,Te),r(d,kt),r(d,M),g(le,M,null),r(M,Jt),r(M,ye),r(d,Ut),r(d,B),g(ie,B,null),r(B,Ft),r(B,Ce),r(d,Zt),r(d,C),g(se,C,null),r(C,Lt),r(C,$e),r(C,Ht),r(C,we),r(d,It),r(d,N),g(de,N,null),r(N,Et),r(N,xe),r(d,Vt),r(d,k),g(me,k,null),r(k,Pt),r(k,Oe),r(d,Wt),r(d,J),g(ce,J,null),r(J,zt),r(J,Me),r(d,Dt),r(d,$),g(pe,$,null),r($,Gt),r($,Be),r($,jt),r($,Ne),r(d,Xt),r(d,w),g(_e,w,null),r(w,Rt),r(w,ke),r(w,At),r(w,Je),r(d,Qt),r(d,U),g(ge,U,null),r(U,qt),r(U,Ue),r(d,St),r(d,F),g(ue,F,null),r(F,Yt),r(F,Fe),s(e,_t,a),g(fe,e,a),s(e,gt,a),s(e,y,a),g(he,y,null),r(y,Kt),r(y,Ze),r(y,ea),r(y,Le),s(e,ut,a),g(ve,e,a),s(e,ft,a),s(e,We,a),ht=!0},p:Ua,i(e){ht||(u(L.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(z.$$.fragment,e),u(j.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(_e.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(ve.$$.fragment,e),ht=!0)},o(e){f(L.$$.fragment,e),f(E.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f(A.$$.fragment,e),f(S.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(_e.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(ve.$$.fragment,e),ht=!1},d(e){e&&(t(ze),t(Pe),t(De),t(Ge),t(H),t(je),t(I),t(Xe),t(Re),t(V),t(Ae),t(Qe),t(W),t(qe),t(Se),t(D),t(Ye),t(G),t(Ke),t(et),t(X),t(tt),t(at),t(nt),t(Q),t(ot),t(q),t(rt),t(lt),t(Y),t(it),t(st),t(dt),t(te),t(mt),t(ae),t(ct),t(pt),t(d),t(_t),t(gt),t(y),t(ut),t(ft),t(We)),t(x),h(L,e),h(E,e),h(P,e),h(z,e),h(j,e),h(R,e),h(A,e),h(S,e),h(K,e),h(ee,e),h(ne,e),h(oe),h(re),h(le),h(ie),h(se),h(de),h(me),h(ce),h(pe),h(_e),h(ge),h(ue),h(fe,e),h(he),h(ve,e)}}}const Va='{"title":"BCO Trainer","local":"bco-trainer","sections":[{"title":"Expected dataset type","local":"expected-dataset-type","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the BCOTrainer","local":"using-the-bcotrainer","sections":[],"depth":2},{"title":"Underlying Distribution matching (UDM)","local":"underlying-distribution-matching-udm","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"BCOTrainer","local":"trl.BCOTrainer","sections":[],"depth":2},{"title":"BCOConfig","local":"trl.BCOConfig","sections":[],"depth":2}],"depth":1}';function Pa(ta){return Fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends Za{constructor(x){super(),La(this,x,Pa,Ea,Ja,{})}}export{Xa as component};
