import{s as PJ,f as d,n as KJ,o as OJ}from"../chunks/scheduler.37c15a92.js";import{S as em,i as lm,g as a,s as i,u as y,A as tm,h as n,f as l,c as o,j as h,v as w,y as M,k as r,o as p,a as s,w as c,d as u,t as J,x as m}from"../chunks/index.b01106c0.js";import{I as j}from"../chunks/IconCopyLink.77b762b4.js";import{C as T}from"../chunks/CodeBlock.00a4ae02.js";import{C as sm}from"../chunks/CourseFloatingBanner.9c5d96ce.js";function am(hy){let U,Ii,$n,bi,f,ne,Sn,el,Bh,en,yy="Hands-on",vi,ll,gi,tl,wy="Now that we studied the Q-Learning algorithm, let’s implement it from scratch and train our Q-Learning agent in two environments:",Ci,sl,cy='<li><a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">Frozen-Lake-v1  (non-slippery and slippery version)</a> ☃️ : where our agent will need to <strong>go from the starting state (S) to the goal state (G)</strong> by walking only on frozen tiles (F) and avoiding holes (H).</li> <li><a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">An autonomous taxi</a> 🚖 will need <strong>to learn to navigate</strong> a city to <strong>transport its passengers from point A to point B.</strong></li>',Bi,al,uy,Ai,nl,Jy='Thanks to a <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a>, you’ll be able to compare your results with other classmates and exchange the best practices to improve your agent’s scores. Who will win the challenge for Unit 2?',Gi,il,my='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained Taxi model to the Hub and <strong>get a result of &gt;= 4.5</strong>.',Zi,ol,Ty='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',_i,rl,jy='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',ki,Ml,dy='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',Wi,pl,Uy="<strong>To start the hands-on click on the Open In Colab button</strong> 👇 :",xi,hl,fy='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit2/unit2.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',Ei,yl,Iy="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",Qi,wl,by="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",$i,I,ie,Xn,cl,Ah,ln,vy="Unit 2: Q-Learning with FrozenLake-v1 ⛄ and Taxi-v3 🚕",Si,ul,gy,Xi,Jl,Cy="In this notebook, <strong>you’ll code your first Reinforcement Learning agent from scratch</strong> to play FrozenLake ❄️ using Q-Learning, share it with the community, and experiment with different configurations.",Yi,ml,By="⬇️ Here is an example of what <strong>you will achieve in just a couple of minutes.</strong> ⬇️",Ri,Tl,Ay,Fi,b,oe,Yn,jl,Gh,tn,Gy="🎮 Environments:",Hi,dl,Zy='<li><a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">FrozenLake-v1</a></li> <li><a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">Taxi-v3</a></li>',Vi,v,re,Rn,Ul,Zh,sn,_y="📚 RL-Library:",Ni,fl,ky='<li>Python and NumPy</li> <li><a href="https://gymnasium.farama.org/" rel="nofollow">Gymnasium</a></li>',zi,Il,Wy='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',qi,g,Me,Fn,bl,_h,an,xy="Objectives of this notebook 🏆",Li,vl,Ey="At the end of the notebook, you will:",Di,gl,Qy="<li>Be able to use <strong>Gymnasium</strong>, the environment library.</li> <li>Be able to code a Q-Learning agent from scratch.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Pi,C,pe,Hn,Cl,kh,nn,$y="This notebook is from the Deep Reinforcement Learning Course",Ki,Bl,Sy,Oi,Al,Xy="In this free course, you will:",eo,Gl,Yy="<li>📖 Study Deep Reinforcement Learning in <strong>theory and practice</strong>.</li> <li>🧑‍💻 Learn to <strong>use famous Deep RL libraries</strong> such as Stable Baselines3, RL Baselines3 Zoo, CleanRL and Sample Factory 2.0.</li> <li>🤖 Train <strong>agents in unique environments</strong></li>",lo,Zl,Ry='And more check 📚 the syllabus 👉 <a href="https://simoninithomas.github.io/deep-rl-course" rel="nofollow">https://simoninithomas.github.io/deep-rl-course</a>',to,_l,Fy='Don’t forget to <strong><a href="http://eepurl.com/ic5ZUD">sign up to the course</a></strong> (we are collecting your email to be able to <strong>send you the links when each Unit is published and give you information about the challenges and updates).</strong>',so,kl,Hy='The best way to keep in touch is to join our discord server to exchange with the community and with us 👉🏻 <a href="https://discord.gg/ydHrjt3WP5" rel="nofollow">https://discord.gg/ydHrjt3WP5</a>',ao,B,he,Vn,Wl,Wh,on,Vy="Prerequisites 🏗️",no,xl,Ny="Before diving into the notebook, you need to:",io,El,zy='🔲 📚 <strong>Study <a href="https://huggingface.co/deep-rl-course/unit2/introduction" rel="nofollow">Q-Learning by reading Unit 2</a></strong>  🤗',oo,A,ye,Nn,Ql,xh,rn,qy="A small recap of Q-Learning",ro,$l,Ly="<em>Q-Learning</em> <strong>is the RL algorithm that</strong>:",Mo,Sl,Dy="<li><p>Trains <em>Q-Function</em>, an <strong>action-value function</strong> that is encoded, in internal memory, by a <em>Q-table</em> <strong>that contains all the state-action pair values.</strong></p></li> <li><p>Given a state and action, our Q-Function <strong>will search the Q-table for the corresponding value.</strong></p></li>",po,we,Py,ho,Xl,Ky=`<li><p>When the training is done, <strong>we have an optimal Q-Function, so an optimal Q-Table.</strong></p></li> <li><p>And if we <strong>have an optimal Q-function</strong>, we
have an optimal policy, since we <strong>know for each state, the best action to take.</strong></p></li>`,yo,ce,Oy,wo,Yl,ew="But, in the beginning, our <strong>Q-Table is useless since it gives arbitrary value for each state-action pair (most of the time we initialize the Q-Table to 0 values)</strong>. But, as we’ll explore the environment and update our Q-Table it will give us better and better approximations",co,ue,lw,uo,Rl,tw="This is the Q-Learning pseudocode:",Jo,Je,sw,mo,G,me,zn,Fl,Eh,Mn,aw="Let's code our first Reinforcement Learning algorithm 🚀",To,Hl,nw='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained Taxi model to the Hub and <strong>get a result of &gt;= 4.5</strong>.',jo,Vl,iw='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Uo,Nl,ow='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',fo,Z,Te,qn,zl,Qh,pn,rw="Install dependencies and create a virtual display 🔽",Io,ql,Mw="In the notebook, we’ll need to generate a replay video. To do so, with Colab, <strong>we need to have a virtual screen to render the environment</strong> (and thus record the frames).",bo,Ll,pw="Hence the following cell will install the libraries and create and run a virtual screen 🖥",vo,Dl,hw="We’ll install multiple ones:",go,Pl,yw="<li><code>gymnasium</code>: Contains the FrozenLake-v1 ⛄ and Taxi-v3 🚕 environments.</li> <li><code>pygame</code>: Used for the FrozenLake-v1 and Taxi-v3 UI.</li> <li><code>numpy</code>: Used for handling our Q-table.</li>",Co,Kl,ww="The Hugging Face Hub 🤗 works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations and other features that will allow you to easily collaborate with others.",Bo,Ol,cw='You can see here all the Deep RL models available (if they use Q Learning) here 👉 <a href="https://huggingface.co/models?other=q-learning" rel="nofollow">https://huggingface.co/models?other=q-learning</a>',Ao,et,Go,lt,Zo,tt,uw="To make sure the new installed libraries are used, <strong>sometimes it’s required to restart the notebook runtime</strong>. The next cell will force the <strong>runtime to crash, so you’ll need to connect again and run the code starting from here</strong>. Thanks to this trick, <strong>we will be able to run our virtual screen.</strong>",_o,st,ko,at,Wo,_,je,Ln,nt,$h,hn,Jw="Import the packages 📦",xo,it,mw="In addition to the installed libraries, we also use:",Eo,ot,Tw="<li><code>random</code>: To generate random numbers (that will be useful for epsilon-greedy policy).</li> <li><code>imageio</code>: To generate a replay video.</li>",Qo,rt,$o,Mt,jw="We’re now ready to code our Q-Learning algorithm 🔥",So,k,de,Dn,pt,Sh,yn,dw="Part 1: Frozen Lake ⛄ (non slippery version)",Xo,ht,Uw='<h2 id="create-and-understand-frozenlake-environment-httpsgymnasiumfaramaorgenvironmentstoytextfrozenlake">Create and understand [FrozenLake environment ⛄]((<a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">https://gymnasium.farama.org/environments/toy_text/frozen_lake/</a>)</h2>',Yo,yt,fw="💡 A good habit when you start to use an environment is to check its documentation",Ro,wt,Iw='👉 <a href="https://gymnasium.farama.org/environments/toy_text/frozen_lake/" rel="nofollow">https://gymnasium.farama.org/environments/toy_text/frozen_lake/</a>',Fo,Ho,Vo,ct,bw="We’re going to train our Q-Learning agent <strong>to navigate from the starting state (S) to the goal state (G) by walking only on frozen tiles (F) and avoid holes (H)</strong>.",No,ut,vw="We can have two sizes of environment:",zo,Jt,gw="<li><code>map_name=&quot;4x4&quot;</code>: a 4x4 grid version</li> <li><code>map_name=&quot;8x8&quot;</code>: a 8x8 grid version</li>",qo,mt,Cw="The environment has two modes:",Lo,Tt,Bw="<li><code>is_slippery=False</code>: The agent always moves <strong>in the intended direction</strong> due to the non-slippery nature of the frozen lake (deterministic).</li> <li><code>is_slippery=True</code>: The agent <strong>may not always move in the intended direction</strong> due to the slippery nature of the frozen lake (stochastic).</li>",Do,jt,Aw=`For now let’s keep it simple with the 4x4 map and non-slippery.
We add a parameter called <code>render_mode</code> that specifies how the environment should be visualised. In our case because we <strong>want to record a video of the environment at the end, we need to set render_mode to rgb_array</strong>.`,Po,dt,Gw='As <a href="https://gymnasium.farama.org/api/env/#gymnasium.Env.render" rel="nofollow">explained in the documentation</a> “rgb_array”: Return a single frame representing the current state of the environment. A frame is a np.ndarray with shape (x, y, 3) representing RGB values for an x-by-y pixel image.',Ko,Ut,Oo,W,Ue,Pn,ft,Xh,wn,Zw="Solution",er,It,lr,bt,_w="You can create your own custom grid like this:",tr,vt,sr,gt,kw="but we’ll use the default environment for now.",ar,x,fe,Kn,Ct,Yh,cn,Ww="Let's see what the Environment looks like:",nr,Bt,ir,At,xw="We see with <code>Observation Space Shape Discrete(16)</code> that the observation is an integer representing the <strong>agent’s current position as current_row * ncols + current_col (where both the row and col start at 0)</strong>.",or,Gt,Ew="For example, the goal position in the 4x4 map can be calculated as follows: 3 * 4 + 3 = 15. The number of possible observations is dependent on the size of the map. <strong>For example, the 4x4 map has 16 possible observations.</strong>",rr,Zt,Qw="For instance, this is what state = 0 looks like:",Mr,_t,$w,pr,kt,hr,Wt,Sw="The action space (the set of possible actions the agent can take) is discrete with 4 actions available 🎮:",yr,xt,Xw="<li>0: GO LEFT</li> <li>1: GO DOWN</li> <li>2: GO RIGHT</li> <li>3: GO UP</li>",wr,Et,Yw="Reward function 💰:",cr,Qt,Rw="<li>Reach goal: +1</li> <li>Reach hole: 0</li> <li>Reach frozen: 0</li>",ur,E,Ie,On,$t,Rh,un,Fw="Create and Initialize the Q-table 🗄️",Jr,St,Hw="(👀 Step 1 of the pseudocode)",mr,be,Vw,Tr,Xt,Nw="It’s time to initialize our Q-table! To know how many rows (states) and columns (actions) to use, we need to know the action and observation space. We already know their values from before, but we’ll want to obtain them programmatically so that our algorithm generalizes for different environments. Gym provides us a way to do that: <code>env.action_space.n</code> and <code>env.observation_space.n</code>",jr,Yt,dr,Rt,Ur,Ft,fr,Q,ve,ei,Ht,Fh,Jn,zw="Solution",Ir,Vt,br,Nt,vr,zt,gr,$,ge,li,qt,Hh,mn,qw="Define the greedy policy 🤖",Cr,Lt,Lw="Remember we have two policies since Q-Learning is an <strong>off-policy</strong> algorithm. This means we’re using a <strong>different policy for acting and updating the value function</strong>.",Br,Dt,Dw="<li>Epsilon-greedy policy (acting policy)</li> <li>Greedy-policy (updating policy)</li>",Ar,Pt,Pw="The greedy policy will also be the final policy we’ll have when the Q-learning agent completes training. The greedy policy is used to select an action using the Q-table.",Gr,Ce,Kw,Zr,Kt,_r,S,Be,ti,Ot,Vh,Tn,Ow="Solution",kr,es,Wr,X,Ae,si,ls,Nh,jn,ec="Define the epsilon-greedy policy 🤖",xr,ts,lc="Epsilon-greedy is the training policy that handles the exploration/exploitation trade-off.",Er,ss,tc="The idea with epsilon-greedy:",Qr,as,sc="<li><p>With <em>probability 1 - ɛ</em> : <strong>we do exploitation</strong> (i.e. our agent selects the action with the highest state-action pair value).</p></li> <li><p>With <em>probability ɛ</em>: we do <strong>exploration</strong> (trying a random action).</p></li>",$r,ns,ac="As the training continues, we progressively <strong>reduce the epsilon value since we will need less and less exploration and more exploitation.</strong>",Sr,Ge,nc,Xr,is,Yr,Y,Ze,ai,os,zh,dn,ic="Solution",Rr,rs,Fr,R,_e,ni,Ms,qh,Un,oc="Define the hyperparameters ⚙️",Hr,ps,rc="The exploration related hyperparamters are some of the most important ones.",Vr,hs,Mc="<li>We need to make sure that our agent <strong>explores enough of the state space</strong> to learn a good value approximation. To do that, we need to have progressive decay of the epsilon.</li> <li>If you decrease epsilon too fast (too high decay_rate), <strong>you take the risk that your agent will be stuck</strong>, since your agent didn’t explore enough of the state space and hence can’t solve the problem.</li>",Nr,ys,zr,F,ke,ii,ws,Lh,fn,pc="Create the training loop method",qr,We,hc,Lr,cs,yc="The training loop goes like this:",Dr,us,Pr,Js,Kr,H,xe,oi,ms,Dh,In,wc="Solution",Or,Ts,eM,V,Ee,ri,js,Ph,bn,cc="Train the Q-Learning agent 🏃",lM,ds,tM,N,Qe,Mi,Us,Kh,vn,uc="Let's see what our Q-Learning table looks like now 👀",sM,fs,aM,z,$e,pi,Is,Oh,gn,Jc="The evaluation method 📝",nM,bs,mc="<li>We defined the evaluation method that we’re going to use to test our Q-Learning agent.</li>",iM,vs,oM,q,Se,hi,gs,ey,Cn,Tc="Evaluate our Q-Learning agent 📈",rM,Cs,jc='<li>Usually, you should have a mean reward of 1.0</li> <li>The <strong>environment is relatively easy</strong> since the state space is really small (16). What you can try to do is <a href="https://www.gymlibrary.dev/environments/toy_text/frozen_lake/" rel="nofollow">to replace it with the slippery version</a>, which introduces stochasticity, making the environment more complex.</li>',MM,Bs,pM,L,Xe,yi,As,ly,Bn,dc="Publish our trained model to the Hub 🔥",hM,Gs,Uc="Now that we saw good results after the training, <strong>we can publish our trained model to the Hub 🤗 with one line of code</strong>.",yM,Zs,fc="Here’s an example of a Model Card:",wM,Ye,Ic,cM,_s,bc="Under the hood, the Hub uses git-based repositories (don’t worry if you don’t know what git is), which means you can update the model with new versions as you experiment and improve your agent.",uM,D,Re,wi,ks,ty,An,vc="Do not modify this code",JM,Ws,mM,xs,TM,Es,jM,Fe,gc=".",dM,Qs,Cc="By using <code>push_to_hub</code> <strong>you evaluate, record a replay, generate a model card of your agent and push it to the Hub</strong>.",UM,$s,Bc="This way:",fM,Ss,Ac='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share an agent with the community that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',IM,Xs,Gc="To be able to share your model with the community there are three more steps to follow:",bM,Ys,Zc='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',vM,Rs,_c="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",gM,Fs,kc='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',CM,Hs,Wc,BM,Vs,AM,Ns,xc="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code> (or <code>login</code>)",GM,zs,Ec="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>push_to_hub()</code> function",ZM,qs,Qc="<li>Let’s create <strong>the model dictionary that contains the hyperparameters and the Q_table</strong>.</li>",_M,Ls,kM,Ds,$c="Let’s fill the <code>push_to_hub</code> function:",WM,Ps,Sc=`<li><code>repo_id</code>: the name of the Hugging Face Hub Repository that will be created/updated <code>(repo_id = {username}/{repo_name})</code>
💡 A good <code>repo_id</code> is <code>{username}/q-{env_id}</code></li> <li><code>model</code>: our model dictionary containing the hyperparameters and the Qtable.</li> <li><code>env</code>: the environment.</li> <li><code>commit_message</code>: message of the commit</li>`,xM,Ks,EM,Os,QM,ea,Xc=`Congrats 🥳 you’ve just implemented from scratch, trained, and uploaded your first Reinforcement Learning agent.
FrozenLake-v1 no_slippery is very simple environment, let’s try a harder one 🔥.`,$M,P,He,ci,la,sy,Gn,Yc="Part 2: Taxi-v3 🚖",SM,ta,Rc='<h2 id="create-and-understand-taxiv3-httpsgymnasiumfaramaorgenvironmentstoytexttaxi">Create and understand <a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">Taxi-v3 🚕</a></h2>',XM,sa,Fc="💡 A good habit when you start to use an environment is to check its documentation",YM,aa,Hc='👉 <a href="https://gymnasium.farama.org/environments/toy_text/taxi/" rel="nofollow">https://gymnasium.farama.org/environments/toy_text/taxi/</a>',RM,FM,HM,na,Vc="In <code>Taxi-v3</code> 🚕, there are four designated locations in the grid world indicated by R(ed), G(reen), Y(ellow), and B(lue).",VM,ia,Nc="When the episode starts, <strong>the taxi starts off at a random square</strong> and the passenger is at a random location. The taxi drives to the passenger’s location, <strong>picks up the passenger</strong>, drives to the passenger’s destination (another one of the four specified locations), and then <strong>drops off the passenger</strong>. Once the passenger is dropped off, the episode ends.",NM,oa,zc,zM,ra,qM,Ma,qc="There are <strong>500 discrete states since there are 25 taxi positions, 5 possible locations of the passenger</strong> (including the case when the passenger is in the taxi), and <strong>4 destination locations.</strong>",LM,pa,DM,ha,PM,ya,Lc="The action space (the set of possible actions the agent can take) is discrete with <strong>6 actions available 🎮</strong>:",KM,wa,Dc="<li>0: move south</li> <li>1: move north</li> <li>2: move east</li> <li>3: move west</li> <li>4: pickup passenger</li> <li>5: drop off passenger</li>",OM,ca,Pc="Reward function 💰:",ep,ua,Kc="<li>-1 per step unless other reward is triggered.</li> <li>+20 delivering passenger.</li> <li>-10 executing “pickup” and “drop-off” actions illegally.</li>",lp,Ja,tp,K,Ve,ui,ma,ay,Zn,Oc="Define the hyperparameters ⚙️",sp,Ta,eu="⚠ DO NOT MODIFY EVAL_SEED: the eval_seed array <strong>allows us to evaluate your agent with the same taxi starting positions for every classmate</strong>",ap,ja,np,O,Ne,Ji,da,ny,_n,lu="Train our Q-Learning agent 🏃",ip,Ua,op,ee,ze,mi,fa,iy,kn,tu="Create a model dictionary 💾 and publish our trained model to the Hub 🔥",rp,Ia,su="<li>We create a model dictionary that will contain all the training hyperparameters for reproducibility and the Q-Table.</li>",Mp,ba,pp,va,hp,ga,au='Now that it’s on the Hub, you can compare the results of your Taxi-v3 with your classmates using the leaderboard 🏆 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a>',yp,Ca,nu,wp,le,qe,Ti,Ba,oy,Wn,iu="Part 3: Load from Hub 🔽",cp,Aa,ou="What’s amazing with Hugging Face Hub 🤗 is that you can easily load powerful models from the community.",up,Ga,ru="Loading a saved model from the Hub is really easy:",Jp,Za,Mu='<li>You go <a href="https://huggingface.co/models?other=q-learning" rel="nofollow">https://huggingface.co/models?other=q-learning</a> to see the list of all the q-learning saved models.</li> <li>You select one and copy its repo_id</li>',mp,_a,pu,Tp,Le,hu="<li>Then we just need to use <code>load_from_hub</code> with:</li>",jp,ka,yu="<li>The repo_id</li> <li>The filename: the saved model inside the repo.</li>",dp,te,De,ji,Wa,ry,xn,wu="Do not modify this code",Up,xa,fp,Pe,cu=".",Ip,Ea,bp,Qa,vp,se,Ke,di,$a,My,En,uu="Some additional challenges 🏆",gp,Sa,Ju="The best way to learn <strong>is to try things on your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!",Cp,Xa,mu='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',Bp,Ya,Tu="Here are some ideas to climb up the leaderboard:",Ap,Ra,ju="<li>Train more steps</li> <li>Try different hyperparameters by looking at what your classmates have done.</li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li>",Gp,Fa,du='Are walking on ice and driving taxis too boring to you? Try to <strong>change the environment</strong>, why not use FrozenLake-v1 slippery version? Check how they work <a href="https://gymnasium.farama.org/" rel="nofollow">using the gymnasium documentation</a> and have fun 🎉.',Zp,_p,kp,Ha,Uu="Congrats 🥳, you’ve just implemented, trained, and uploaded your first Reinforcement Learning agent.",Wp,Va,fu="Understanding Q-Learning is an <strong>important step to understanding value-based methods.</strong>",xp,Na,Iu="In the next Unit with Deep Q-Learning, we’ll see that while creating and updating a Q-table was a good strategy — <strong>however, it is not scalable.</strong>",Ep,za,bu="For instance, imagine you create an agent that learns to play Doom.",Qp,qa,vu,$p,La,gu="Doom is a large environment with a huge state space (millions of different states). Creating and updating a Q-table for that environment would not be efficient.",Sp,Da,Cu="That’s why we’ll study Deep Q-Learning in the next unit, an algorithm <strong>where we use a neural network that approximates, given a state, the different Q-values for each action.</strong>",Xp,Pa,Bu,Yp,Ka,Au="See you in Unit 3! 🔥",Rp,ae,Oe,Ui,Oa,py,Qn,Gu="Keep learning, stay awesome 🤗",Fp,fi,Hp;return el=new j({}),ll=new sm({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit2/unit2.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),cl=new j({}),jl=new j({}),Ul=new j({}),bl=new j({}),Cl=new j({}),Wl=new j({}),Ql=new j({}),Fl=new j({}),zl=new j({}),et=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkZWVwLXJsLWNsYXNzJTJGbWFpbiUyRm5vdGVib29rcyUyRnVuaXQyJTJGcmVxdWlyZW1lbnRzLXVuaXQyLnR4dA==",highlighted:"pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit2/requirements-unit2.txt",wrap:!1}}),lt=new T({props:{code:"c3VkbyUyMGFwdC1nZXQlMjB1cGRhdGUlMEFzdWRvJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMHB5dGhvbjMtb3BlbmdsJTBBYXB0JTIwaW5zdGFsbCUyMGZmbXBlZyUyMHh2ZmIlMEFwaXAzJTIwaW5zdGFsbCUyMHB5dmlydHVhbGRpc3BsYXk=",highlighted:`sudo apt-get update
sudo apt-get install -y python3-opengl
apt install ffmpeg xvfb
pip3 install pyvirtualdisplay`,wrap:!1}}),st=new T({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5raWxsKG9zLmdldHBpZCgpJTJDJTIwOSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.kill(os.getpid(), <span class="hljs-number">9</span>)`,wrap:!1}}),at=new T({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),nt=new j({}),rt=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3ltbmFzaXVtJTIwYXMlMjBneW0lMEFpbXBvcnQlMjByYW5kb20lMEFpbXBvcnQlMjBpbWFnZWlvJTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0cWRtJTBBJTBBaW1wb3J0JTIwcGlja2xlNSUyMGFzJTIwcGlja2xlJTBBZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRt",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">import</span> pickle5 <span class="hljs-keyword">as</span> pickle
<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),pt=new j({}),Ut=new T({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwRnJvemVuTGFrZS12MSUyMGVudmlyb25tZW50JTIwdXNpbmclMjA0eDQlMjBtYXAlMjBhbmQlMjBub24tc2xpcHBlcnklMjB2ZXJzaW9uJTIwYW5kJTIwcmVuZGVyX21vZGUlM0QlMjJyZ2JfYXJyYXklMjIlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSgpJTIwJTIwJTIzJTIwVE9ETyUyMHVzZSUyMHRoZSUyMGNvcnJlY3QlMjBwYXJhbWV0ZXJz",highlighted:`<span class="hljs-comment"># Create the FrozenLake-v1 environment using 4x4 map and non-slippery version and render_mode=&quot;rgb_array&quot;</span>
env = gym.make()  <span class="hljs-comment"># TODO use the correct parameters</span>`,wrap:!1}}),ft=new j({}),It=new T({props:{code:"ZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyRnJvemVuTGFrZS12MSUyMiUyQyUyMG1hcF9uYW1lJTNEJTIyNHg0JTIyJTJDJTIwaXNfc2xpcHBlcnklM0RGYWxzZSUyQyUyMHJlbmRlcl9tb2RlJTNEJTIycmdiX2FycmF5JTIyKQ==",highlighted:'env = gym.make(<span class="hljs-string">&quot;FrozenLake-v1&quot;</span>, map_name=<span class="hljs-string">&quot;4x4&quot;</span>, is_slippery=<span class="hljs-literal">False</span>, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)',wrap:!1}}),vt=new T({props:{code:"ZGVzYyUzRCU1QiUyMlNGRkYlMjIlMkMlMjAlMjJGSEZIJTIyJTJDJTIwJTIyRkZGSCUyMiUyQyUyMCUyMkhGRkclMjIlNUQlMEFneW0ubWFrZSgnRnJvemVuTGFrZS12MSclMkMlMjBkZXNjJTNEZGVzYyUyQyUyMGlzX3NsaXBwZXJ5JTNEVHJ1ZSk=",highlighted:`desc=[<span class="hljs-string">&quot;SFFF&quot;</span>, <span class="hljs-string">&quot;FHFH&quot;</span>, <span class="hljs-string">&quot;FFFH&quot;</span>, <span class="hljs-string">&quot;HFFG&quot;</span>]
gym.make(<span class="hljs-string">&#x27;FrozenLake-v1&#x27;</span>, desc=desc, is_slippery=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ct=new j({}),Bt=new T({props:{code:"JTIzJTIwV2UlMjBjcmVhdGUlMjBvdXIlMjBlbnZpcm9ubWVudCUyMHdpdGglMjBneW0ubWFrZSglMjIlM0NuYW1lX29mX3RoZV9lbnZpcm9ubWVudCUzRSUyMiktJTIwJTYwaXNfc2xpcHBlcnklM0RGYWxzZSU2MCUzQSUyMFRoZSUyMGFnZW50JTIwYWx3YXlzJTIwbW92ZXMlMjBpbiUyMHRoZSUyMGludGVuZGVkJTIwZGlyZWN0aW9uJTIwZHVlJTIwdG8lMjB0aGUlMjBub24tc2xpcHBlcnklMjBuYXR1cmUlMjBvZiUyMHRoZSUyMGZyb3plbiUyMGxha2UlMjAoZGV0ZXJtaW5pc3RpYykuJTBBcHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMk9ic2VydmF0aW9uJTIwU3BhY2UlMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UpJTBBcHJpbnQoJTIyU2FtcGxlJTIwb2JzZXJ2YXRpb24lMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwR2V0JTIwYSUyMHJhbmRvbSUyMG9ic2VydmF0aW9u",highlighted:`<span class="hljs-comment"># We create our environment with gym.make(&quot;&lt;name_of_the_environment&gt;&quot;)- \`is_slippery=False\`: The agent always moves in the intended direction due to the non-slippery nature of the frozen lake (deterministic).</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Observation Space&quot;</span>, env.observation_space)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),kt=new T({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyQWN0aW9uJTIwU3BhY2UlMjBTaGFwZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2UubiklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Shape&quot;</span>, env.action_space.n)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),$t=new j({}),Yt=new T({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMEFwcmludCglMjJUaGVyZSUyMGFyZSUyMCUyMiUyQyUyMHN0YXRlX3NwYWNlJTJDJTIwJTIyJTIwcG9zc2libGUlMjBzdGF0ZXMlMjIpJTBBJTBBYWN0aW9uX3NwYWNlJTIwJTNEJTBBcHJpbnQoJTIyVGhlcmUlMjBhcmUlMjAlMjIlMkMlMjBhY3Rpb25fc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMGFjdGlvbnMlMjIp",highlighted:`state_space =
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)

action_space =
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),Rt=new T({props:{code:"JTIzJTIwTGV0J3MlMjBjcmVhdGUlMjBvdXIlMjBRdGFibGUlMjBvZiUyMHNpemUlMjAoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpJTIwYW5kJTIwaW5pdGlhbGl6ZWQlMjBlYWNoJTIwdmFsdWVzJTIwYXQlMjAwJTIwdXNpbmclMjBucC56ZXJvcy4lMjBucC56ZXJvcyUyMG5lZWRzJTIwYSUyMHR1cGxlJTIwKGElMkNiKSUwQWRlZiUyMGluaXRpYWxpemVfcV90YWJsZShzdGF0ZV9zcGFjZSUyQyUyMGFjdGlvbl9zcGFjZSklM0ElMEElMjAlMjBRdGFibGUlMjAlM0QlMEElMjAlMjByZXR1cm4lMjBRdGFibGU=",highlighted:`<span class="hljs-comment"># Let&#x27;s create our Qtable of size (state_space, action_space) and initialized each values at 0 using np.zeros. np.zeros needs a tuple (a,b)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">initialize_q_table</span>(<span class="hljs-params">state_space, action_space</span>):
  Qtable =
  <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),Ft=new T({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjBpbml0aWFsaXplX3FfdGFibGUoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2Up",highlighted:"Qtable_frozenlake = initialize_q_table(state_space, action_space)",wrap:!1}}),Ht=new j({}),Vt=new T({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UubiUwQXByaW50KCUyMlRoZXJlJTIwYXJlJTIwJTIyJTJDJTIwc3RhdGVfc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMHN0YXRlcyUyMiklMEElMEFhY3Rpb25fc3BhY2UlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4lMEFwcmludCglMjJUaGVyZSUyMGFyZSUyMCUyMiUyQyUyMGFjdGlvbl9zcGFjZSUyQyUyMCUyMiUyMHBvc3NpYmxlJTIwYWN0aW9ucyUyMik=",highlighted:`state_space = env.observation_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)

action_space = env.action_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),Nt=new T({props:{code:"JTIzJTIwTGV0J3MlMjBjcmVhdGUlMjBvdXIlMjBRdGFibGUlMjBvZiUyMHNpemUlMjAoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpJTIwYW5kJTIwaW5pdGlhbGl6ZWQlMjBlYWNoJTIwdmFsdWVzJTIwYXQlMjAwJTIwdXNpbmclMjBucC56ZXJvcyUwQWRlZiUyMGluaXRpYWxpemVfcV90YWJsZShzdGF0ZV9zcGFjZSUyQyUyMGFjdGlvbl9zcGFjZSklM0ElMEElMjAlMjAlMjAlMjBRdGFibGUlMjAlM0QlMjBucC56ZXJvcygoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2UpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFF0YWJsZQ==",highlighted:`<span class="hljs-comment"># Let&#x27;s create our Qtable of size (state_space, action_space) and initialized each values at 0 using np.zeros</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">initialize_q_table</span>(<span class="hljs-params">state_space, action_space</span>):
    Qtable = np.zeros((state_space, action_space))
    <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),zt=new T({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjBpbml0aWFsaXplX3FfdGFibGUoc3RhdGVfc3BhY2UlMkMlMjBhY3Rpb25fc3BhY2Up",highlighted:"Qtable_frozenlake = initialize_q_table(state_space, action_space)",wrap:!1}}),qt=new j({}),Kt=new T({props:{code:"ZGVmJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjMlMjBFeHBsb2l0YXRpb24lM0ElMjB0YWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjBzdGF0ZSUyQyUyMGFjdGlvbiUyMHZhbHVlJTBBJTIwJTIwYWN0aW9uJTIwJTNEJTBBJTBBJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_policy</span>(<span class="hljs-params">Qtable, state</span>):
  <span class="hljs-comment"># Exploitation: take the action with the highest state, action value</span>
  action =

  <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ot=new j({}),es=new T({props:{code:"ZGVmJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFeHBsb2l0YXRpb24lM0ElMjB0YWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjBzdGF0ZSUyQyUyMGFjdGlvbiUyMHZhbHVlJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwbnAuYXJnbWF4KFF0YWJsZSU1QnN0YXRlJTVEJTVCJTNBJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_policy</span>(<span class="hljs-params">Qtable, state</span>):
    <span class="hljs-comment"># Exploitation: take the action with the highest state, action value</span>
    action = np.argmax(Qtable[state][:])

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),ls=new j({}),is=new T({props:{code:"ZGVmJTIwZXBzaWxvbl9ncmVlZHlfcG9saWN5KFF0YWJsZSUyQyUyMHN0YXRlJTJDJTIwZXBzaWxvbiklM0ElMEElMjAlMjAlMjMlMjBSYW5kb21seSUyMGdlbmVyYXRlJTIwYSUyMG51bWJlciUyMGJldHdlZW4lMjAwJTIwYW5kJTIwMSUwQSUyMCUyMHJhbmRvbV9udW0lMjAlM0QlMEElMjAlMjAlMjMlMjBpZiUyMHJhbmRvbV9udW0lMjAlM0UlMjBncmVhdGVyJTIwdGhhbiUyMGVwc2lsb24lMjAtLSUzRSUyMGV4cGxvaXRhdGlvbiUwQSUyMCUyMGlmJTIwcmFuZG9tX251bSUyMCUzRSUyMGVwc2lsb24lM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjB2YWx1ZSUyMGdpdmVuJTIwYSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIzJTIwbnAuYXJnbWF4JTIwY2FuJTIwYmUlMjB1c2VmdWwlMjBoZXJlJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTBBJTIwJTIwJTIzJTIwZWxzZSUyMC0tJTNFJTIwZXhwbG9yYXRpb24lMEElMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24lMEElMEElMjAlMjByZXR1cm4lMjBhY3Rpb24=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">epsilon_greedy_policy</span>(<span class="hljs-params">Qtable, state, epsilon</span>):
  <span class="hljs-comment"># Randomly generate a number between 0 and 1</span>
  random_num =
  <span class="hljs-comment"># if random_num &gt; greater than epsilon --&gt; exploitation</span>
  <span class="hljs-keyword">if</span> random_num &gt; epsilon:
    <span class="hljs-comment"># Take the action with the highest value given a state</span>
    <span class="hljs-comment"># np.argmax can be useful here</span>
    action =
  <span class="hljs-comment"># else --&gt; exploration</span>
  <span class="hljs-keyword">else</span>:
    action = <span class="hljs-comment"># Take a random action</span>

  <span class="hljs-keyword">return</span> action`,wrap:!1}}),os=new j({}),rs=new T({props:{code:"ZGVmJTIwZXBzaWxvbl9ncmVlZHlfcG9saWN5KFF0YWJsZSUyQyUyMHN0YXRlJTJDJTIwZXBzaWxvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSYW5kb21seSUyMGdlbmVyYXRlJTIwYSUyMG51bWJlciUyMGJldHdlZW4lMjAwJTIwYW5kJTIwMSUwQSUyMCUyMCUyMCUyMHJhbmRvbV9udW0lMjAlM0QlMjByYW5kb20udW5pZm9ybSgwJTJDJTIwMSklMEElMjAlMjAlMjAlMjAlMjMlMjBpZiUyMHJhbmRvbV9udW0lMjAlM0UlMjBncmVhdGVyJTIwdGhhbiUyMGVwc2lsb24lMjAtLSUzRSUyMGV4cGxvaXRhdGlvbiUwQSUyMCUyMCUyMCUyMGlmJTIwcmFuZG9tX251bSUyMCUzRSUyMGVwc2lsb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwd2l0aCUyMHRoZSUyMGhpZ2hlc3QlMjB2YWx1ZSUyMGdpdmVuJTIwYSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbnAuYXJnbWF4JTIwY2FuJTIwYmUlMjB1c2VmdWwlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwZ3JlZWR5X3BvbGljeShRdGFibGUlMkMlMjBzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjMlMjBlbHNlJTIwLS0lM0UlMjBleHBsb3JhdGlvbiUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLnNhbXBsZSgpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">epsilon_greedy_policy</span>(<span class="hljs-params">Qtable, state, epsilon</span>):
    <span class="hljs-comment"># Randomly generate a number between 0 and 1</span>
    random_num = random.uniform(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-comment"># if random_num &gt; greater than epsilon --&gt; exploitation</span>
    <span class="hljs-keyword">if</span> random_num &gt; epsilon:
        <span class="hljs-comment"># Take the action with the highest value given a state</span>
        <span class="hljs-comment"># np.argmax can be useful here</span>
        action = greedy_policy(Qtable, state)
    <span class="hljs-comment"># else --&gt; exploration</span>
    <span class="hljs-keyword">else</span>:
        action = env.action_space.sample()

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ms=new j({}),ys=new T({props:{code:"JTIzJTIwVHJhaW5pbmclMjBwYXJhbWV0ZXJzJTBBbl90cmFpbmluZ19lcGlzb2RlcyUyMCUzRCUyMDEwMDAwJTIwJTIwJTIzJTIwVG90YWwlMjB0cmFpbmluZyUyMGVwaXNvZGVzJTBBbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDAuNyUyMCUyMCUyMyUyMExlYXJuaW5nJTIwcmF0ZSUwQSUwQSUyMyUyMEV2YWx1YXRpb24lMjBwYXJhbWV0ZXJzJTBBbl9ldmFsX2VwaXNvZGVzJTIwJTNEJTIwMTAwJTIwJTIwJTIzJTIwVG90YWwlMjBudW1iZXIlMjBvZiUyMHRlc3QlMjBlcGlzb2RlcyUwQSUwQSUyMyUyMEVudmlyb25tZW50JTIwcGFyYW1ldGVycyUwQWVudl9pZCUyMCUzRCUyMCUyMkZyb3plbkxha2UtdjElMjIlMjAlMjAlMjMlMjBOYW1lJTIwb2YlMjB0aGUlMjBlbnZpcm9ubWVudCUwQW1heF9zdGVwcyUyMCUzRCUyMDk5JTIwJTIwJTIzJTIwTWF4JTIwc3RlcHMlMjBwZXIlMjBlcGlzb2RlJTBBZ2FtbWElMjAlM0QlMjAwLjk1JTIwJTIwJTIzJTIwRGlzY291bnRpbmclMjByYXRlJTBBZXZhbF9zZWVkJTIwJTNEJTIwJTVCJTVEJTIwJTIwJTIzJTIwVGhlJTIwZXZhbHVhdGlvbiUyMHNlZWQlMjBvZiUyMHRoZSUyMGVudmlyb25tZW50JTBBJTBBJTIzJTIwRXhwbG9yYXRpb24lMjBwYXJhbWV0ZXJzJTBBbWF4X2Vwc2lsb24lMjAlM0QlMjAxLjAlMjAlMjAlMjMlMjBFeHBsb3JhdGlvbiUyMHByb2JhYmlsaXR5JTIwYXQlMjBzdGFydCUwQW1pbl9lcHNpbG9uJTIwJTNEJTIwMC4wNSUyMCUyMCUyMyUyME1pbmltdW0lMjBleHBsb3JhdGlvbiUyMHByb2JhYmlsaXR5JTBBZGVjYXlfcmF0ZSUyMCUzRCUyMDAuMDAwNSUyMCUyMCUyMyUyMEV4cG9uZW50aWFsJTIwZGVjYXklMjByYXRlJTIwZm9yJTIwZXhwbG9yYXRpb24lMjBwcm9i",highlighted:`<span class="hljs-comment"># Training parameters</span>
n_training_episodes = <span class="hljs-number">10000</span>  <span class="hljs-comment"># Total training episodes</span>
learning_rate = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># Learning rate</span>

<span class="hljs-comment"># Evaluation parameters</span>
n_eval_episodes = <span class="hljs-number">100</span>  <span class="hljs-comment"># Total number of test episodes</span>

<span class="hljs-comment"># Environment parameters</span>
env_id = <span class="hljs-string">&quot;FrozenLake-v1&quot;</span>  <span class="hljs-comment"># Name of the environment</span>
max_steps = <span class="hljs-number">99</span>  <span class="hljs-comment"># Max steps per episode</span>
gamma = <span class="hljs-number">0.95</span>  <span class="hljs-comment"># Discounting rate</span>
eval_seed = []  <span class="hljs-comment"># The evaluation seed of the environment</span>

<span class="hljs-comment"># Exploration parameters</span>
max_epsilon = <span class="hljs-number">1.0</span>  <span class="hljs-comment"># Exploration probability at start</span>
min_epsilon = <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Minimum exploration probability</span>
decay_rate = <span class="hljs-number">0.0005</span>  <span class="hljs-comment"># Exponential decay rate for exploration prob</span>`,wrap:!1}}),ws=new j({}),us=new T({props:{code:"Rm9yJTIwZXBpc29kZSUyMGluJTIwdGhlJTIwdG90YWwlMjBvZiUyMHRyYWluaW5nJTIwZXBpc29kZXMlM0ElMEElMEFSZWR1Y2UlMjBlcHNpbG9uJTIwKHNpbmNlJTIwd2UlMjBuZWVkJTIwbGVzcyUyMGFuZCUyMGxlc3MlMjBleHBsb3JhdGlvbiklMEFSZXNldCUyMHRoZSUyMGVudmlyb25tZW50JTBBJTBBJTIwJTIwRm9yJTIwc3RlcCUyMGluJTIwbWF4JTIwdGltZXN0ZXBzJTNBJTBBJTIwJTIwJTIwJTIwQ2hvb3NlJTIwdGhlJTIwYWN0aW9uJTIwQXQlMjB1c2luZyUyMGVwc2lsb24lMjBncmVlZHklMjBwb2xpY3klMEElMjAlMjAlMjAlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGEpJTIwYW5kJTIwb2JzZXJ2ZSUyMHRoZSUyMG91dGNvbWUlMjBzdGF0ZShzJyklMjBhbmQlMjByZXdhcmQlMjAociklMEElMjAlMjAlMjAlMjBVcGRhdGUlMjB0aGUlMjBRLXZhbHVlJTIwUShzJTJDYSklMjB1c2luZyUyMEJlbGxtYW4lMjBlcXVhdGlvbiUyMFEocyUyQ2EpJTIwJTJCJTIwbHIlMjAlNUJSKHMlMkNhKSUyMCUyQiUyMGdhbW1hJTIwKiUyMG1heCUyMFEocyclMkNhJyklMjAtJTIwUShzJTJDYSklNUQlMEElMjAlMjAlMjAlMjBJZiUyMGRvbmUlMkMlMjBmaW5pc2glMjB0aGUlMjBlcGlzb2RlJTBBJTIwJTIwJTIwJTIwT3VyJTIwbmV4dCUyMHN0YXRlJTIwaXMlMjB0aGUlMjBuZXclMjBzdGF0ZQ==",highlighted:`For episode <span class="hljs-keyword">in</span> the total of training episodes:

Reduce epsilon (since we need less and less exploration)
Reset the environment

  For step <span class="hljs-keyword">in</span> <span class="hljs-keyword">max</span> timesteps:
    Choose the action At using epsilon greedy policy
    Take the action (a) and observe the outcome <span class="hljs-keyword">state</span>(s&#x27;) and reward (r)
    Update the Q-value Q(s,a) using Bellman equation Q(s,a) + lr [R(s,a) + gamma * <span class="hljs-keyword">max</span> Q(s&#x27;,a&#x27;) - Q(s,a)]
    If done, finish the episode
    Our next <span class="hljs-keyword">state</span> is the new <span class="hljs-keyword">state</span>`,wrap:!1}}),Js=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train</span>(<span class="hljs-params">n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable</span>):
  <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_training_episodes)):
    <span class="hljs-comment"># Reduce epsilon (because we need less and less exploration)</span>
    epsilon = min_epsilon + (max_epsilon - min_epsilon)*np.exp(-decay_rate*episode)
    <span class="hljs-comment"># Reset the environment</span>
    state, info = env.reset()
    step = <span class="hljs-number">0</span>
    terminated = <span class="hljs-literal">False</span>
    truncated = <span class="hljs-literal">False</span>

    <span class="hljs-comment"># repeat</span>
    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
      <span class="hljs-comment"># Choose the action At using epsilon greedy policy</span>
      action =

      <span class="hljs-comment"># Take action At and observe Rt+1 and St+1</span>
      <span class="hljs-comment"># Take the action (a) and observe the outcome state(s&#x27;) and reward (r)</span>
      new_state, reward, terminated, truncated, info =

      <span class="hljs-comment"># Update Q(s,a):= Q(s,a) + lr [R(s,a) + gamma * max Q(s&#x27;,a&#x27;) - Q(s,a)]</span>
      Qtable[state][action] =

      <span class="hljs-comment"># If terminated or truncated finish the episode</span>
      <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>

      <span class="hljs-comment"># Our next state is the new state</span>
      state = new_state
  <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),ms=new j({}),Ts=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train</span>(<span class="hljs-params">n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable</span>):
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_training_episodes)):
        <span class="hljs-comment"># Reduce epsilon (because we need less and less exploration)</span>
        epsilon = min_epsilon + (max_epsilon - min_epsilon) * np.exp(-decay_rate * episode)
        <span class="hljs-comment"># Reset the environment</span>
        state, info = env.reset()
        step = <span class="hljs-number">0</span>
        terminated = <span class="hljs-literal">False</span>
        truncated = <span class="hljs-literal">False</span>

        <span class="hljs-comment"># repeat</span>
        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            <span class="hljs-comment"># Choose the action At using epsilon greedy policy</span>
            action = epsilon_greedy_policy(Qtable, state, epsilon)

            <span class="hljs-comment"># Take action At and observe Rt+1 and St+1</span>
            <span class="hljs-comment"># Take the action (a) and observe the outcome state(s&#x27;) and reward (r)</span>
            new_state, reward, terminated, truncated, info = env.step(action)

            <span class="hljs-comment"># Update Q(s,a):= Q(s,a) + lr [R(s,a) + gamma * max Q(s&#x27;,a&#x27;) - Q(s,a)]</span>
            Qtable[state][action] = Qtable[state][action] + learning_rate * (
                reward + gamma * np.<span class="hljs-built_in">max</span>(Qtable[new_state]) - Qtable[state][action]
            )

            <span class="hljs-comment"># If terminated or truncated finish the episode</span>
            <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
                <span class="hljs-keyword">break</span>

            <span class="hljs-comment"># Our next state is the new state</span>
            state = new_state
    <span class="hljs-keyword">return</span> Qtable`,wrap:!1}}),js=new j({}),ds=new T({props:{code:"UXRhYmxlX2Zyb3plbmxha2UlMjAlM0QlMjB0cmFpbihuX3RyYWluaW5nX2VwaXNvZGVzJTJDJTIwbWluX2Vwc2lsb24lMkMlMjBtYXhfZXBzaWxvbiUyQyUyMGRlY2F5X3JhdGUlMkMlMjBlbnYlMkMlMjBtYXhfc3RlcHMlMkMlMjBRdGFibGVfZnJvemVubGFrZSk=",highlighted:"Qtable_frozenlake = train(n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable_frozenlake)",wrap:!1}}),Us=new j({}),fs=new T({props:{code:"UXRhYmxlX2Zyb3plbmxha2U=",highlighted:"Qtable_frozenlake",wrap:!1}}),Is=new j({}),vs=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_agent</span>(<span class="hljs-params">env, max_steps, n_eval_episodes, Q, seed</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param Q: The Q-table
    :param seed: The evaluation seed array (for taxi-v3)
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(n_eval_episodes)):
        <span class="hljs-keyword">if</span> seed:
            state, info = env.reset(seed=seed[episode])
        <span class="hljs-keyword">else</span>:
            state, info = env.reset()
        step = <span class="hljs-number">0</span>
        truncated = <span class="hljs-literal">False</span>
        terminated = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
            action = greedy_policy(Q, state)
            new_state, reward, terminated, truncated, info = env.step(action)
            total_rewards_ep += reward

            <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward`,wrap:!1}}),gs=new j({}),Bs=new T({props:{code:"JTIzJTIwRXZhbHVhdGUlMjBvdXIlMjBBZ2VudCUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX2FnZW50KGVudiUyQyUyMG1heF9zdGVwcyUyQyUyMG5fZXZhbF9lcGlzb2RlcyUyQyUyMFF0YWJsZV9mcm96ZW5sYWtlJTJDJTIwZXZhbF9zZWVkKSUwQXByaW50KGYlMjJNZWFuX3Jld2FyZCUzRCU3Qm1lYW5fcmV3YXJkJTNBLjJmJTdEJTIwJTJCJTJGLSUyMCU3QnN0ZF9yZXdhcmQlM0EuMmYlN0QlMjIp",highlighted:`<span class="hljs-comment"># Evaluate our Agent</span>
mean_reward, std_reward = evaluate_agent(env, max_steps, n_eval_episodes, Qtable_frozenlake, eval_seed)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),As=new j({}),ks=new j({}),Ws=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwc25hcHNob3RfZG93bmxvYWQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQlMkMlMjBtZXRhZGF0YV9zYXZlJTBBJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, snapshot_download
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> json`,wrap:!1}}),xs=new T({props:{code:"ZGVmJTIwcmVjb3JkX3ZpZGVvKGVudiUyQyUyMFF0YWJsZSUyQyUyMG91dF9kaXJlY3RvcnklMkMlMjBmcHMlM0QxKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEdlbmVyYXRlJTIwYSUyMHJlcGxheSUyMHZpZGVvJTIwb2YlMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZW52JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBRdGFibGUlM0ElMjBRdGFibGUlMjBvZiUyMG91ciUyMGFnZW50JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBvdXRfZGlyZWN0b3J5JTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjBmcHMlM0ElMjBob3clMjBtYW55JTIwZnJhbWUlMjBwZXIlMjBzZWNvbmRzJTIwKHdpdGglMjB0YXhpLXYzJTIwYW5kJTIwZnJvemVubGFrZS12MSUyMHdlJTIwdXNlJTIwMSklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjB0ZXJtaW5hdGVkJTIwJTNEJTIwRmFsc2UlMEElMjAlMjAlMjAlMjB0cnVuY2F0ZWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMHN0YXRlJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5yZXNldChzZWVkJTNEcmFuZG9tLnJhbmRpbnQoMCUyQyUyMDUwMCkpJTBBJTIwJTIwJTIwJTIwaW1nJTIwJTNEJTIwZW52LnJlbmRlcigpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzLmFwcGVuZChpbWcpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBub3QlMjB0ZXJtaW5hdGVkJTIwb3IlMjB0cnVuY2F0ZWQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGluZGV4KSUyMHRoYXQlMjBoYXZlJTIwdGhlJTIwbWF4aW11bSUyMGV4cGVjdGVkJTIwZnV0dXJlJTIwcmV3YXJkJTIwZ2l2ZW4lMjB0aGF0JTIwc3RhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBucC5hcmdtYXgoUXRhYmxlJTVCc3RhdGUlNUQlNUIlM0ElNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMkMlMjByZXdhcmQlMkMlMjB0ZXJtaW5hdGVkJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5zdGVwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMjAlMjAlMjMlMjBXZSUyMGRpcmVjdGx5JTIwcHV0JTIwbmV4dF9zdGF0ZSUyMCUzRCUyMHN0YXRlJTIwZm9yJTIwcmVjb3JkaW5nJTIwbG9naWMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWclMjAlM0QlMjBlbnYucmVuZGVyKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjBpbWFnZWlvLm1pbXNhdmUob3V0X2RpcmVjdG9yeSUyQyUyMCU1Qm5wLmFycmF5KGltZyklMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSU1RCUyQyUyMGZwcyUzRGZwcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, Qtable, out_directory, fps=<span class="hljs-number">1</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a replay video of the agent
    :param env
    :param Qtable: Qtable of our agent
    :param out_directory
    :param fps: how many frame per seconds (with taxi-v3 and frozenlake-v1 we use 1)
    &quot;&quot;&quot;</span>
    images = []
    terminated = <span class="hljs-literal">False</span>
    truncated = <span class="hljs-literal">False</span>
    state, info = env.reset(seed=random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">500</span>))
    img = env.render()
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action = np.argmax(Qtable[state][:])
        state, reward, terminated, truncated, info = env.step(
            action
        )  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render()
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)`,wrap:!1}}),Es=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">repo_id, model, env, video_fps=<span class="hljs-number">1</span>, local_repo_path=<span class="hljs-string">&quot;hub&quot;</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate, Generate a video and Upload a model to Hugging Face Hub.
    This method does the complete pipeline:
    - It evaluates the model
    - It generates the model card
    - It generates a replay video of the agent
    - It pushes everything to the Hub

    :param repo_id: repo_id: id of the model repository from the Hugging Face Hub
    :param env
    :param video_fps: how many frame per seconds to record our video replay
    (with taxi-v3 and frozenlake-v1 we use 1)
    :param local_repo_path: where the local repository is
    &quot;&quot;&quot;</span>
    _, repo_name = repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)

    eval_env = env
    api = HfApi()

    <span class="hljs-comment"># Step 1: Create the repo</span>
    repo_url = api.create_repo(
        repo_id=repo_id,
        exist_ok=<span class="hljs-literal">True</span>,
    )

    <span class="hljs-comment"># Step 2: Download files</span>
    repo_local_path = Path(snapshot_download(repo_id=repo_id))

    <span class="hljs-comment"># Step 3: Save the model</span>
    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>):
        model[<span class="hljs-string">&quot;map_name&quot;</span>] = env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>)
        <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;is_slippery&quot;</span>, <span class="hljs-string">&quot;&quot;</span>) == <span class="hljs-literal">False</span>:
            model[<span class="hljs-string">&quot;slippery&quot;</span>] = <span class="hljs-literal">False</span>

    <span class="hljs-comment"># Pickle the model</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>((repo_local_path) / <span class="hljs-string">&quot;q-learning.pkl&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        pickle.dump(model, f)

    <span class="hljs-comment"># Step 4: Evaluate the model and build JSON with evaluation metrics</span>
    mean_reward, std_reward = evaluate_agent(
        eval_env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>]
    )

    evaluate_data = {
        <span class="hljs-string">&quot;env_id&quot;</span>: model[<span class="hljs-string">&quot;env_id&quot;</span>],
        <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
        <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>],
        <span class="hljs-string">&quot;eval_datetime&quot;</span>: datetime.datetime.now().isoformat(),
    }

    <span class="hljs-comment"># Write a JSON file called &quot;results.json&quot; that will contain the</span>
    <span class="hljs-comment"># evaluation results</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(repo_local_path / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
        json.dump(evaluate_data, outfile)

    <span class="hljs-comment"># Step 5: Create the model card</span>
    env_name = model[<span class="hljs-string">&quot;env_id&quot;</span>]
    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>):
        env_name += <span class="hljs-string">&quot;-&quot;</span> + env.spec.kwargs.get(<span class="hljs-string">&quot;map_name&quot;</span>)

    <span class="hljs-keyword">if</span> env.spec.kwargs.get(<span class="hljs-string">&quot;is_slippery&quot;</span>, <span class="hljs-string">&quot;&quot;</span>) == <span class="hljs-literal">False</span>:
        env_name += <span class="hljs-string">&quot;-&quot;</span> + <span class="hljs-string">&quot;no_slippery&quot;</span>

    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [env_name, <span class="hljs-string">&quot;q-learning&quot;</span>, <span class="hljs-string">&quot;reinforcement-learning&quot;</span>, <span class="hljs-string">&quot;custom-implementation&quot;</span>]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=repo_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_name,
        dataset_id=env_name,
    )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # **Q-Learning** Agent playing1 **<span class="hljs-subst">{env_id}</span>**
  This is a trained model of a **Q-Learning** agent playing **<span class="hljs-subst">{env_id}</span>** .

  ## Usage

  model = load_from_hub(repo_id=&quot;<span class="hljs-subst">{repo_id}</span>&quot;, filename=&quot;q-learning.pkl&quot;)

  # Don&#x27;t forget to check if you need to add additional attributes (is_slippery=False etc)
  env = gym.make(model[&quot;env_id&quot;])
  &quot;&quot;&quot;</span>

    evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])

    readme_path = repo_local_path / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(readme_path.exists())
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
            readme = f.read()
    <span class="hljs-keyword">else</span>:
        readme = model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)

    <span class="hljs-comment"># Step 6: Record a video</span>
    video_path = repo_local_path / <span class="hljs-string">&quot;replay.mp4&quot;</span>
    record_video(env, model[<span class="hljs-string">&quot;qtable&quot;</span>], video_path, video_fps)

    <span class="hljs-comment"># Step 7. Push everything to the Hub</span>
    api.upload_folder(
        repo_id=repo_id,
        folder_path=repo_local_path,
        path_in_repo=<span class="hljs-string">&quot;.&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Your model is pushed to the Hub. You can view your model here: &quot;</span>, repo_url)`,wrap:!1}}),Vs=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ls=new T({props:{code:"bW9kZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJtYXhfc3RlcHMlMjIlM0ElMjBtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwbl90cmFpbmluZ19lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbF9lcGlzb2RlcyUyMiUzQSUyMG5fZXZhbF9lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc2VlZCUyMiUzQSUyMGV2YWxfc2VlZCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjBsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjBnYW1tYSUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9lcHNpbG9uJTIyJTNBJTIwbWF4X2Vwc2lsb24lMkMlMEElMjAlMjAlMjAlMjAlMjJtaW5fZXBzaWxvbiUyMiUzQSUyMG1pbl9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGVjYXlfcmF0ZSUyMiUzQSUyMGRlY2F5X3JhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjJxdGFibGUlMjIlM0ElMjBRdGFibGVfZnJvemVubGFrZSUyQyUwQSU3RA==",highlighted:`model = {
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;max_steps&quot;</span>: max_steps,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: n_training_episodes,
    <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: n_eval_episodes,
    <span class="hljs-string">&quot;eval_seed&quot;</span>: eval_seed,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: learning_rate,
    <span class="hljs-string">&quot;gamma&quot;</span>: gamma,
    <span class="hljs-string">&quot;max_epsilon&quot;</span>: max_epsilon,
    <span class="hljs-string">&quot;min_epsilon&quot;</span>: min_epsilon,
    <span class="hljs-string">&quot;decay_rate&quot;</span>: decay_rate,
    <span class="hljs-string">&quot;qtable&quot;</span>: Qtable_frozenlake,
}`,wrap:!1}}),Ks=new T({props:{code:"bW9kZWw=",highlighted:"model",wrap:!1}}),Os=new T({props:{code:"dXNlcm5hbWUlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBGSUxMJTIwVEhJUyUwQXJlcG9fbmFtZSUyMCUzRCUyMCUyMnEtRnJvemVuTGFrZS12MS00eDQtbm9TbGlwcGVyeSUyMiUwQXB1c2hfdG9faHViKHJlcG9faWQlM0RmJTIyJTdCdXNlcm5hbWUlN0QlMkYlN0JyZXBvX25hbWUlN0QlMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZW52JTNEZW52KQ==",highlighted:`username = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
repo_name = <span class="hljs-string">&quot;q-FrozenLake-v1-4x4-noSlippery&quot;</span>
push_to_hub(repo_id=<span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{repo_name}</span>&quot;</span>, model=model, env=env)`,wrap:!1}}),la=new j({}),ra=new T({props:{code:"ZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyVGF4aS12MyUyMiUyQyUyMHJlbmRlcl9tb2RlJTNEJTIycmdiX2FycmF5JTIyKQ==",highlighted:'env = gym.make(<span class="hljs-string">&quot;Taxi-v3&quot;</span>, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)',wrap:!1}}),pa=new T({props:{code:"c3RhdGVfc3BhY2UlMjAlM0QlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2UubiUwQXByaW50KCUyMlRoZXJlJTIwYXJlJTIwJTIyJTJDJTIwc3RhdGVfc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMHN0YXRlcyUyMik=",highlighted:`state_space = env.observation_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, state_space, <span class="hljs-string">&quot; possible states&quot;</span>)`,wrap:!1}}),ha=new T({props:{code:"YWN0aW9uX3NwYWNlJTIwJTNEJTIwZW52LmFjdGlvbl9zcGFjZS5uJTBBcHJpbnQoJTIyVGhlcmUlMjBhcmUlMjAlMjIlMkMlMjBhY3Rpb25fc3BhY2UlMkMlMjAlMjIlMjBwb3NzaWJsZSUyMGFjdGlvbnMlMjIp",highlighted:`action_space = env.action_space.n
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;There are &quot;</span>, action_space, <span class="hljs-string">&quot; possible actions&quot;</span>)`,wrap:!1}}),Ja=new T({props:{code:"JTIzJTIwQ3JlYXRlJTIwb3VyJTIwUSUyMHRhYmxlJTIwd2l0aCUyMHN0YXRlX3NpemUlMjByb3dzJTIwYW5kJTIwYWN0aW9uX3NpemUlMjBjb2x1bW5zJTIwKDUwMHg2KSUwQVF0YWJsZV90YXhpJTIwJTNEJTIwaW5pdGlhbGl6ZV9xX3RhYmxlKHN0YXRlX3NwYWNlJTJDJTIwYWN0aW9uX3NwYWNlKSUwQXByaW50KFF0YWJsZV90YXhpKSUwQXByaW50KCUyMlEtdGFibGUlMjBzaGFwZSUzQSUyMCUyMiUyQyUyMFF0YWJsZV90YXhpLnNoYXBlKQ==",highlighted:`<span class="hljs-comment"># Create our Q table with state_size rows and action_size columns (500x6)</span>
Qtable_taxi = initialize_q_table(state_space, action_space)
<span class="hljs-built_in">print</span>(Qtable_taxi)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Q-table shape: &quot;</span>, Qtable_taxi.shape)`,wrap:!1}}),ma=new j({}),ja=new T({props:{code:"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",highlighted:`<span class="hljs-comment"># Training parameters</span>
n_training_episodes = <span class="hljs-number">25000</span>  <span class="hljs-comment"># Total training episodes</span>
learning_rate = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># Learning rate</span>

<span class="hljs-comment"># Evaluation parameters</span>
n_eval_episodes = <span class="hljs-number">100</span>  <span class="hljs-comment"># Total number of test episodes</span>

<span class="hljs-comment"># DO NOT MODIFY EVAL_SEED</span>
eval_seed = [
    <span class="hljs-number">16</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">165</span>,
    <span class="hljs-number">177</span>,
    <span class="hljs-number">191</span>,
    <span class="hljs-number">191</span>,
    <span class="hljs-number">120</span>,
    <span class="hljs-number">80</span>,
    <span class="hljs-number">149</span>,
    <span class="hljs-number">178</span>,
    <span class="hljs-number">48</span>,
    <span class="hljs-number">38</span>,
    <span class="hljs-number">6</span>,
    <span class="hljs-number">125</span>,
    <span class="hljs-number">174</span>,
    <span class="hljs-number">73</span>,
    <span class="hljs-number">50</span>,
    <span class="hljs-number">172</span>,
    <span class="hljs-number">100</span>,
    <span class="hljs-number">148</span>,
    <span class="hljs-number">146</span>,
    <span class="hljs-number">6</span>,
    <span class="hljs-number">25</span>,
    <span class="hljs-number">40</span>,
    <span class="hljs-number">68</span>,
    <span class="hljs-number">148</span>,
    <span class="hljs-number">49</span>,
    <span class="hljs-number">167</span>,
    <span class="hljs-number">9</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">164</span>,
    <span class="hljs-number">176</span>,
    <span class="hljs-number">61</span>,
    <span class="hljs-number">7</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">55</span>,
    <span class="hljs-number">161</span>,
    <span class="hljs-number">131</span>,
    <span class="hljs-number">184</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">170</span>,
    <span class="hljs-number">12</span>,
    <span class="hljs-number">120</span>,
    <span class="hljs-number">113</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">126</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">98</span>,
    <span class="hljs-number">36</span>,
    <span class="hljs-number">135</span>,
    <span class="hljs-number">54</span>,
    <span class="hljs-number">82</span>,
    <span class="hljs-number">45</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">89</span>,
    <span class="hljs-number">59</span>,
    <span class="hljs-number">95</span>,
    <span class="hljs-number">124</span>,
    <span class="hljs-number">9</span>,
    <span class="hljs-number">113</span>,
    <span class="hljs-number">58</span>,
    <span class="hljs-number">85</span>,
    <span class="hljs-number">51</span>,
    <span class="hljs-number">134</span>,
    <span class="hljs-number">121</span>,
    <span class="hljs-number">169</span>,
    <span class="hljs-number">105</span>,
    <span class="hljs-number">21</span>,
    <span class="hljs-number">30</span>,
    <span class="hljs-number">11</span>,
    <span class="hljs-number">50</span>,
    <span class="hljs-number">65</span>,
    <span class="hljs-number">12</span>,
    <span class="hljs-number">43</span>,
    <span class="hljs-number">82</span>,
    <span class="hljs-number">145</span>,
    <span class="hljs-number">152</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">106</span>,
    <span class="hljs-number">55</span>,
    <span class="hljs-number">31</span>,
    <span class="hljs-number">85</span>,
    <span class="hljs-number">38</span>,
    <span class="hljs-number">112</span>,
    <span class="hljs-number">102</span>,
    <span class="hljs-number">168</span>,
    <span class="hljs-number">123</span>,
    <span class="hljs-number">97</span>,
    <span class="hljs-number">21</span>,
    <span class="hljs-number">83</span>,
    <span class="hljs-number">158</span>,
    <span class="hljs-number">26</span>,
    <span class="hljs-number">80</span>,
    <span class="hljs-number">63</span>,
    <span class="hljs-number">5</span>,
    <span class="hljs-number">81</span>,
    <span class="hljs-number">32</span>,
    <span class="hljs-number">11</span>,
    <span class="hljs-number">28</span>,
    <span class="hljs-number">148</span>,
]  <span class="hljs-comment"># Evaluation seed, this ensures that all classmates agents are trained on the same taxi starting position</span>
<span class="hljs-comment"># Each seed has a specific starting state</span>

<span class="hljs-comment"># Environment parameters</span>
env_id = <span class="hljs-string">&quot;Taxi-v3&quot;</span>  <span class="hljs-comment"># Name of the environment</span>
max_steps = <span class="hljs-number">99</span>  <span class="hljs-comment"># Max steps per episode</span>
gamma = <span class="hljs-number">0.95</span>  <span class="hljs-comment"># Discounting rate</span>

<span class="hljs-comment"># Exploration parameters</span>
max_epsilon = <span class="hljs-number">1.0</span>  <span class="hljs-comment"># Exploration probability at start</span>
min_epsilon = <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Minimum exploration probability</span>
decay_rate = <span class="hljs-number">0.005</span>  <span class="hljs-comment"># Exponential decay rate for exploration prob</span>`,wrap:!1}}),da=new j({}),Ua=new T({props:{code:"UXRhYmxlX3RheGklMjAlM0QlMjB0cmFpbihuX3RyYWluaW5nX2VwaXNvZGVzJTJDJTIwbWluX2Vwc2lsb24lMkMlMjBtYXhfZXBzaWxvbiUyQyUyMGRlY2F5X3JhdGUlMkMlMjBlbnYlMkMlMjBtYXhfc3RlcHMlMkMlMjBRdGFibGVfdGF4aSklMEFRdGFibGVfdGF4aQ==",highlighted:`Qtable_taxi = train(n_training_episodes, min_epsilon, max_epsilon, decay_rate, env, max_steps, Qtable_taxi)
Qtable_taxi`,wrap:!1}}),fa=new j({}),ba=new T({props:{code:"bW9kZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJtYXhfc3RlcHMlMjIlM0ElMjBtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwbl90cmFpbmluZ19lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbF9lcGlzb2RlcyUyMiUzQSUyMG5fZXZhbF9lcGlzb2RlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc2VlZCUyMiUzQSUyMGV2YWxfc2VlZCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjBsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjBnYW1tYSUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9lcHNpbG9uJTIyJTNBJTIwbWF4X2Vwc2lsb24lMkMlMEElMjAlMjAlMjAlMjAlMjJtaW5fZXBzaWxvbiUyMiUzQSUyMG1pbl9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGVjYXlfcmF0ZSUyMiUzQSUyMGRlY2F5X3JhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjJxdGFibGUlMjIlM0ElMjBRdGFibGVfdGF4aSUyQyUwQSU3RA==",highlighted:`model = {
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;max_steps&quot;</span>: max_steps,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: n_training_episodes,
    <span class="hljs-string">&quot;n_eval_episodes&quot;</span>: n_eval_episodes,
    <span class="hljs-string">&quot;eval_seed&quot;</span>: eval_seed,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: learning_rate,
    <span class="hljs-string">&quot;gamma&quot;</span>: gamma,
    <span class="hljs-string">&quot;max_epsilon&quot;</span>: max_epsilon,
    <span class="hljs-string">&quot;min_epsilon&quot;</span>: min_epsilon,
    <span class="hljs-string">&quot;decay_rate&quot;</span>: decay_rate,
    <span class="hljs-string">&quot;qtable&quot;</span>: Qtable_taxi,
}`,wrap:!1}}),va=new T({props:{code:"dXNlcm5hbWUlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBGSUxMJTIwVEhJUyUwQXJlcG9fbmFtZSUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMEZJTEwlMjBUSElTJTBBcHVzaF90b19odWIocmVwb19pZCUzRGYlMjIlN0J1c2VybmFtZSU3RCUyRiU3QnJlcG9fbmFtZSU3RCUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBlbnYlM0RlbnYp",highlighted:`username = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
repo_name = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># FILL THIS</span>
push_to_hub(repo_id=<span class="hljs-string">f&quot;<span class="hljs-subst">{username}</span>/<span class="hljs-subst">{repo_name}</span>&quot;</span>, model=model, env=env)`,wrap:!1}}),Ba=new j({}),Wa=new j({}),xa=new T({props:{code:"ZnJvbSUyMHVybGxpYi5lcnJvciUyMGltcG9ydCUyMEhUVFBFcnJvciUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEElMEElMEFkZWYlMjBsb2FkX2Zyb21faHViKHJlcG9faWQlM0ElMjBzdHIlMkMlMjBmaWxlbmFtZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwRG93bmxvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwJTNBcGFyYW0lMjByZXBvX2lkJTNBJTIwaWQlMjBvZiUyMHRoZSUyMG1vZGVsJTIwcmVwb3NpdG9yeSUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZmlsZW5hbWUlM0ElMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMHppcCUyMGZpbGUlMjBmcm9tJTIwdGhlJTIwcmVwb3NpdG9yeSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMHRoZSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUyQyUyMGRvd25sb2FkJTIwYW5kJTIwY2FjaGUlMjB0aGUlMjBtb2RlbCUyMG9uJTIweW91ciUyMGxvY2FsJTIwZGlzayUwQSUyMCUyMCUyMCUyMHBpY2tsZV9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUpJTBBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4ocGlja2xlX21vZGVsJTJDJTIwJTIycmIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9tb2RlbF9maWxlJTIwJTNEJTIwcGlja2xlLmxvYWQoZiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkb3dubG9hZGVkX21vZGVsX2ZpbGU=",highlighted:`<span class="hljs-keyword">from</span> urllib.error <span class="hljs-keyword">import</span> HTTPError

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download


<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_from_hub</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span>, filename: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Download a model from Hugging Face Hub.
    :param repo_id: id of the model repository from the Hugging Face Hub
    :param filename: name of the model zip file from the repository
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the model from the Hub, download and cache the model on your local disk</span>
    pickle_model = hf_hub_download(repo_id=repo_id, filename=filename)

    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(pickle_model, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
        downloaded_model_file = pickle.load(f)

    <span class="hljs-keyword">return</span> downloaded_model_file`,wrap:!1}}),Ea=new T({props:{code:"bW9kZWwlMjAlM0QlMjBsb2FkX2Zyb21faHViKHJlcG9faWQlM0QlMjJUaG9tYXNTaW1vbmluaSUyRnEtVGF4aS12MyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycS1sZWFybmluZy5wa2wlMjIpJTIwJTIwJTIzJTIwVHJ5JTIwdG8lMjB1c2UlMjBhbm90aGVyJTIwbW9kZWwlMEElMEFwcmludChtb2RlbCklMEFlbnYlMjAlM0QlMjBneW0ubWFrZShtb2RlbCU1QiUyMmVudl9pZCUyMiU1RCklMEElMEFldmFsdWF0ZV9hZ2VudChlbnYlMkMlMjBtb2RlbCU1QiUyMm1heF9zdGVwcyUyMiU1RCUyQyUyMG1vZGVsJTVCJTIybl9ldmFsX2VwaXNvZGVzJTIyJTVEJTJDJTIwbW9kZWwlNUIlMjJxdGFibGUlMjIlNUQlMkMlMjBtb2RlbCU1QiUyMmV2YWxfc2VlZCUyMiU1RCk=",highlighted:`model = load_from_hub(repo_id=<span class="hljs-string">&quot;ThomasSimonini/q-Taxi-v3&quot;</span>, filename=<span class="hljs-string">&quot;q-learning.pkl&quot;</span>)  <span class="hljs-comment"># Try to use another model</span>

<span class="hljs-built_in">print</span>(model)
env = gym.make(model[<span class="hljs-string">&quot;env_id&quot;</span>])

evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])`,wrap:!1}}),Qa=new T({props:{code:"bW9kZWwlMjAlM0QlMjBsb2FkX2Zyb21faHViKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJUaG9tYXNTaW1vbmluaSUyRnEtRnJvemVuTGFrZS12MS1uby1zbGlwcGVyeSUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycS1sZWFybmluZy5wa2wlMjIlMEEpJTIwJTIwJTIzJTIwVHJ5JTIwdG8lMjB1c2UlMjBhbm90aGVyJTIwbW9kZWwlMEElMEFlbnYlMjAlM0QlMjBneW0ubWFrZShtb2RlbCU1QiUyMmVudl9pZCUyMiU1RCUyQyUyMGlzX3NsaXBwZXJ5JTNERmFsc2UpJTBBJTBBZXZhbHVhdGVfYWdlbnQoZW52JTJDJTIwbW9kZWwlNUIlMjJtYXhfc3RlcHMlMjIlNUQlMkMlMjBtb2RlbCU1QiUyMm5fZXZhbF9lcGlzb2RlcyUyMiU1RCUyQyUyMG1vZGVsJTVCJTIycXRhYmxlJTIyJTVEJTJDJTIwbW9kZWwlNUIlMjJldmFsX3NlZWQlMjIlNUQp",highlighted:`model = load_from_hub(
    repo_id=<span class="hljs-string">&quot;ThomasSimonini/q-FrozenLake-v1-no-slippery&quot;</span>, filename=<span class="hljs-string">&quot;q-learning.pkl&quot;</span>
)  <span class="hljs-comment"># Try to use another model</span>

env = gym.make(model[<span class="hljs-string">&quot;env_id&quot;</span>], is_slippery=<span class="hljs-literal">False</span>)

evaluate_agent(env, model[<span class="hljs-string">&quot;max_steps&quot;</span>], model[<span class="hljs-string">&quot;n_eval_episodes&quot;</span>], model[<span class="hljs-string">&quot;qtable&quot;</span>], model[<span class="hljs-string">&quot;eval_seed&quot;</span>])`,wrap:!1}}),$a=new j({}),Oa=new j({}),{c(){U=a("meta"),Ii=i(),$n=a("p"),bi=i(),f=a("h1"),ne=a("a"),Sn=a("span"),y(el.$$.fragment),Bh=i(),en=a("span"),en.textContent=yy,vi=i(),y(ll.$$.fragment),gi=i(),tl=a("p"),tl.textContent=wy,Ci=i(),sl=a("ol"),sl.innerHTML=cy,Bi=i(),al=a("img"),Ai=i(),nl=a("p"),nl.innerHTML=Jy,Gi=i(),il=a("p"),il.innerHTML=my,Zi=i(),ol=a("p"),ol.innerHTML=Ty,_i=i(),rl=a("p"),rl.innerHTML=jy,ki=i(),Ml=a("p"),Ml.innerHTML=dy,Wi=i(),pl=a("p"),pl.innerHTML=Uy,xi=i(),hl=a("p"),hl.innerHTML=fy,Ei=i(),yl=a("p"),yl.innerHTML=Iy,Qi=i(),wl=a("p"),wl.innerHTML=by,$i=i(),I=a("h1"),ie=a("a"),Xn=a("span"),y(cl.$$.fragment),Ah=i(),ln=a("span"),ln.textContent=vy,Si=i(),ul=a("img"),Xi=i(),Jl=a("p"),Jl.innerHTML=Cy,Yi=i(),ml=a("p"),ml.innerHTML=By,Ri=i(),Tl=a("img"),Fi=i(),b=a("h3"),oe=a("a"),Yn=a("span"),y(jl.$$.fragment),Gh=i(),tn=a("span"),tn.textContent=Gy,Hi=i(),dl=a("ul"),dl.innerHTML=Zy,Vi=i(),v=a("h3"),re=a("a"),Rn=a("span"),y(Ul.$$.fragment),Zh=i(),sn=a("span"),sn.textContent=_y,Ni=i(),fl=a("ul"),fl.innerHTML=ky,zi=i(),Il=a("p"),Il.innerHTML=Wy,qi=i(),g=a("h2"),Me=a("a"),Fn=a("span"),y(bl.$$.fragment),_h=i(),an=a("span"),an.textContent=xy,Li=i(),vl=a("p"),vl.textContent=Ey,Di=i(),gl=a("ul"),gl.innerHTML=Qy,Pi=i(),C=a("h2"),pe=a("a"),Hn=a("span"),y(Cl.$$.fragment),kh=i(),nn=a("span"),nn.textContent=$y,Ki=i(),Bl=a("img"),Oi=i(),Al=a("p"),Al.textContent=Xy,eo=i(),Gl=a("ul"),Gl.innerHTML=Yy,lo=i(),Zl=a("p"),Zl.innerHTML=Ry,to=i(),_l=a("p"),_l.innerHTML=Fy,so=i(),kl=a("p"),kl.innerHTML=Hy,ao=i(),B=a("h2"),he=a("a"),Vn=a("span"),y(Wl.$$.fragment),Wh=i(),on=a("span"),on.textContent=Vy,no=i(),xl=a("p"),xl.textContent=Ny,io=i(),El=a("p"),El.innerHTML=zy,oo=i(),A=a("h2"),ye=a("a"),Nn=a("span"),y(Ql.$$.fragment),xh=i(),rn=a("span"),rn.textContent=qy,ro=i(),$l=a("p"),$l.innerHTML=Ly,Mo=i(),Sl=a("ul"),Sl.innerHTML=Dy,po=i(),we=a("img"),ho=i(),Xl=a("ul"),Xl.innerHTML=Ky,yo=i(),ce=a("img"),wo=i(),Yl=a("p"),Yl.innerHTML=ew,co=i(),ue=a("img"),uo=i(),Rl=a("p"),Rl.textContent=tw,Jo=i(),Je=a("img"),mo=i(),G=a("h1"),me=a("a"),zn=a("span"),y(Fl.$$.fragment),Eh=i(),Mn=a("span"),Mn.textContent=aw,To=i(),Hl=a("p"),Hl.innerHTML=nw,jo=i(),Vl=a("p"),Vl.innerHTML=iw,Uo=i(),Nl=a("p"),Nl.innerHTML=ow,fo=i(),Z=a("h2"),Te=a("a"),qn=a("span"),y(zl.$$.fragment),Qh=i(),pn=a("span"),pn.textContent=rw,Io=i(),ql=a("p"),ql.innerHTML=Mw,bo=i(),Ll=a("p"),Ll.textContent=pw,vo=i(),Dl=a("p"),Dl.textContent=hw,go=i(),Pl=a("ul"),Pl.innerHTML=yw,Co=i(),Kl=a("p"),Kl.textContent=ww,Bo=i(),Ol=a("p"),Ol.innerHTML=cw,Ao=i(),y(et.$$.fragment),Go=i(),y(lt.$$.fragment),Zo=i(),tt=a("p"),tt.innerHTML=uw,_o=i(),y(st.$$.fragment),ko=i(),y(at.$$.fragment),Wo=i(),_=a("h2"),je=a("a"),Ln=a("span"),y(nt.$$.fragment),$h=i(),hn=a("span"),hn.textContent=Jw,xo=i(),it=a("p"),it.textContent=mw,Eo=i(),ot=a("ul"),ot.innerHTML=Tw,Qo=i(),y(rt.$$.fragment),$o=i(),Mt=a("p"),Mt.textContent=jw,So=i(),k=a("h1"),de=a("a"),Dn=a("span"),y(pt.$$.fragment),Sh=i(),yn=a("span"),yn.textContent=dw,Xo=i(),ht=a("h2"),ht.innerHTML=Uw,Yo=i(),yt=a("p"),yt.textContent=fw,Ro=i(),wt=a("p"),wt.innerHTML=Iw,Fo=i(),Ho=a("hr"),Vo=i(),ct=a("p"),ct.innerHTML=bw,No=i(),ut=a("p"),ut.textContent=vw,zo=i(),Jt=a("ul"),Jt.innerHTML=gw,qo=i(),mt=a("p"),mt.textContent=Cw,Lo=i(),Tt=a("ul"),Tt.innerHTML=Bw,Do=i(),jt=a("p"),jt.innerHTML=Aw,Po=i(),dt=a("p"),dt.innerHTML=Gw,Ko=i(),y(Ut.$$.fragment),Oo=i(),W=a("h3"),Ue=a("a"),Pn=a("span"),y(ft.$$.fragment),Xh=i(),wn=a("span"),wn.textContent=Zw,er=i(),y(It.$$.fragment),lr=i(),bt=a("p"),bt.textContent=_w,tr=i(),y(vt.$$.fragment),sr=i(),gt=a("p"),gt.textContent=kw,ar=i(),x=a("h3"),fe=a("a"),Kn=a("span"),y(Ct.$$.fragment),Yh=i(),cn=a("span"),cn.textContent=Ww,nr=i(),y(Bt.$$.fragment),ir=i(),At=a("p"),At.innerHTML=xw,or=i(),Gt=a("p"),Gt.innerHTML=Ew,rr=i(),Zt=a("p"),Zt.textContent=Qw,Mr=i(),_t=a("img"),pr=i(),y(kt.$$.fragment),hr=i(),Wt=a("p"),Wt.textContent=Sw,yr=i(),xt=a("ul"),xt.innerHTML=Xw,wr=i(),Et=a("p"),Et.textContent=Yw,cr=i(),Qt=a("ul"),Qt.innerHTML=Rw,ur=i(),E=a("h2"),Ie=a("a"),On=a("span"),y($t.$$.fragment),Rh=i(),un=a("span"),un.textContent=Fw,Jr=i(),St=a("p"),St.textContent=Hw,mr=i(),be=a("img"),Tr=i(),Xt=a("p"),Xt.innerHTML=Nw,jr=i(),y(Yt.$$.fragment),dr=i(),y(Rt.$$.fragment),Ur=i(),y(Ft.$$.fragment),fr=i(),Q=a("h3"),ve=a("a"),ei=a("span"),y(Ht.$$.fragment),Fh=i(),Jn=a("span"),Jn.textContent=zw,Ir=i(),y(Vt.$$.fragment),br=i(),y(Nt.$$.fragment),vr=i(),y(zt.$$.fragment),gr=i(),$=a("h2"),ge=a("a"),li=a("span"),y(qt.$$.fragment),Hh=i(),mn=a("span"),mn.textContent=qw,Cr=i(),Lt=a("p"),Lt.innerHTML=Lw,Br=i(),Dt=a("ul"),Dt.innerHTML=Dw,Ar=i(),Pt=a("p"),Pt.textContent=Pw,Gr=i(),Ce=a("img"),Zr=i(),y(Kt.$$.fragment),_r=i(),S=a("h4"),Be=a("a"),ti=a("span"),y(Ot.$$.fragment),Vh=i(),Tn=a("span"),Tn.textContent=Ow,kr=i(),y(es.$$.fragment),Wr=i(),X=a("h2"),Ae=a("a"),si=a("span"),y(ls.$$.fragment),Nh=i(),jn=a("span"),jn.textContent=ec,xr=i(),ts=a("p"),ts.textContent=lc,Er=i(),ss=a("p"),ss.textContent=tc,Qr=i(),as=a("ul"),as.innerHTML=sc,$r=i(),ns=a("p"),ns.innerHTML=ac,Sr=i(),Ge=a("img"),Xr=i(),y(is.$$.fragment),Yr=i(),Y=a("h4"),Ze=a("a"),ai=a("span"),y(os.$$.fragment),zh=i(),dn=a("span"),dn.textContent=ic,Rr=i(),y(rs.$$.fragment),Fr=i(),R=a("h2"),_e=a("a"),ni=a("span"),y(Ms.$$.fragment),qh=i(),Un=a("span"),Un.textContent=oc,Hr=i(),ps=a("p"),ps.textContent=rc,Vr=i(),hs=a("ul"),hs.innerHTML=Mc,Nr=i(),y(ys.$$.fragment),zr=i(),F=a("h2"),ke=a("a"),ii=a("span"),y(ws.$$.fragment),Lh=i(),fn=a("span"),fn.textContent=pc,qr=i(),We=a("img"),Lr=i(),cs=a("p"),cs.textContent=yc,Dr=i(),y(us.$$.fragment),Pr=i(),y(Js.$$.fragment),Kr=i(),H=a("h4"),xe=a("a"),oi=a("span"),y(ms.$$.fragment),Dh=i(),In=a("span"),In.textContent=wc,Or=i(),y(Ts.$$.fragment),eM=i(),V=a("h2"),Ee=a("a"),ri=a("span"),y(js.$$.fragment),Ph=i(),bn=a("span"),bn.textContent=cc,lM=i(),y(ds.$$.fragment),tM=i(),N=a("h2"),Qe=a("a"),Mi=a("span"),y(Us.$$.fragment),Kh=i(),vn=a("span"),vn.textContent=uc,sM=i(),y(fs.$$.fragment),aM=i(),z=a("h2"),$e=a("a"),pi=a("span"),y(Is.$$.fragment),Oh=i(),gn=a("span"),gn.textContent=Jc,nM=i(),bs=a("ul"),bs.innerHTML=mc,iM=i(),y(vs.$$.fragment),oM=i(),q=a("h2"),Se=a("a"),hi=a("span"),y(gs.$$.fragment),ey=i(),Cn=a("span"),Cn.textContent=Tc,rM=i(),Cs=a("ul"),Cs.innerHTML=jc,MM=i(),y(Bs.$$.fragment),pM=i(),L=a("h2"),Xe=a("a"),yi=a("span"),y(As.$$.fragment),ly=i(),Bn=a("span"),Bn.textContent=dc,hM=i(),Gs=a("p"),Gs.innerHTML=Uc,yM=i(),Zs=a("p"),Zs.textContent=fc,wM=i(),Ye=a("img"),cM=i(),_s=a("p"),_s.textContent=bc,uM=i(),D=a("h4"),Re=a("a"),wi=a("span"),y(ks.$$.fragment),ty=i(),An=a("span"),An.textContent=vc,JM=i(),y(Ws.$$.fragment),mM=i(),y(xs.$$.fragment),TM=i(),y(Es.$$.fragment),jM=i(),Fe=a("h3"),Fe.textContent=gc,dM=i(),Qs=a("p"),Qs.innerHTML=Cc,UM=i(),$s=a("p"),$s.textContent=Bc,fM=i(),Ss=a("ul"),Ss.innerHTML=Ac,IM=i(),Xs=a("p"),Xs.textContent=Gc,bM=i(),Ys=a("p"),Ys.innerHTML=Zc,vM=i(),Rs=a("p"),Rs.textContent=_c,gM=i(),Fs=a("ul"),Fs.innerHTML=kc,CM=i(),Hs=a("img"),BM=i(),y(Vs.$$.fragment),AM=i(),Ns=a("p"),Ns.innerHTML=xc,GM=i(),zs=a("p"),zs.innerHTML=Ec,ZM=i(),qs=a("ul"),qs.innerHTML=Qc,_M=i(),y(Ls.$$.fragment),kM=i(),Ds=a("p"),Ds.innerHTML=$c,WM=i(),Ps=a("ul"),Ps.innerHTML=Sc,xM=i(),y(Ks.$$.fragment),EM=i(),y(Os.$$.fragment),QM=i(),ea=a("p"),ea.textContent=Xc,$M=i(),P=a("h1"),He=a("a"),ci=a("span"),y(la.$$.fragment),sy=i(),Gn=a("span"),Gn.textContent=Yc,SM=i(),ta=a("h2"),ta.innerHTML=Rc,XM=i(),sa=a("p"),sa.textContent=Fc,YM=i(),aa=a("p"),aa.innerHTML=Hc,RM=i(),FM=a("hr"),HM=i(),na=a("p"),na.innerHTML=Vc,VM=i(),ia=a("p"),ia.innerHTML=Nc,NM=i(),oa=a("img"),zM=i(),y(ra.$$.fragment),qM=i(),Ma=a("p"),Ma.innerHTML=qc,LM=i(),y(pa.$$.fragment),DM=i(),y(ha.$$.fragment),PM=i(),ya=a("p"),ya.innerHTML=Lc,KM=i(),wa=a("ul"),wa.innerHTML=Dc,OM=i(),ca=a("p"),ca.textContent=Pc,ep=i(),ua=a("ul"),ua.innerHTML=Kc,lp=i(),y(Ja.$$.fragment),tp=i(),K=a("h2"),Ve=a("a"),ui=a("span"),y(ma.$$.fragment),ay=i(),Zn=a("span"),Zn.textContent=Oc,sp=i(),Ta=a("p"),Ta.innerHTML=eu,ap=i(),y(ja.$$.fragment),np=i(),O=a("h2"),Ne=a("a"),Ji=a("span"),y(da.$$.fragment),ny=i(),_n=a("span"),_n.textContent=lu,ip=i(),y(Ua.$$.fragment),op=i(),ee=a("h2"),ze=a("a"),mi=a("span"),y(fa.$$.fragment),iy=i(),kn=a("span"),kn.textContent=tu,rp=i(),Ia=a("ul"),Ia.innerHTML=su,Mp=i(),y(ba.$$.fragment),pp=i(),y(va.$$.fragment),hp=i(),ga=a("p"),ga.innerHTML=au,yp=i(),Ca=a("img"),wp=i(),le=a("h1"),qe=a("a"),Ti=a("span"),y(Ba.$$.fragment),oy=i(),Wn=a("span"),Wn.textContent=iu,cp=i(),Aa=a("p"),Aa.textContent=ou,up=i(),Ga=a("p"),Ga.textContent=ru,Jp=i(),Za=a("ol"),Za.innerHTML=Mu,mp=i(),_a=a("img"),Tp=i(),Le=a("ol"),Le.innerHTML=hu,jp=i(),ka=a("ul"),ka.innerHTML=yu,dp=i(),te=a("h4"),De=a("a"),ji=a("span"),y(Wa.$$.fragment),ry=i(),xn=a("span"),xn.textContent=wu,Up=i(),y(xa.$$.fragment),fp=i(),Pe=a("h3"),Pe.textContent=cu,Ip=i(),y(Ea.$$.fragment),bp=i(),y(Qa.$$.fragment),vp=i(),se=a("h2"),Ke=a("a"),di=a("span"),y($a.$$.fragment),My=i(),En=a("span"),En.textContent=uu,gp=i(),Sa=a("p"),Sa.innerHTML=Ju,Cp=i(),Xa=a("p"),Xa.innerHTML=mu,Bp=i(),Ya=a("p"),Ya.textContent=Tu,Ap=i(),Ra=a("ul"),Ra.innerHTML=ju,Gp=i(),Fa=a("p"),Fa.innerHTML=du,Zp=i(),_p=a("hr"),kp=i(),Ha=a("p"),Ha.textContent=Uu,Wp=i(),Va=a("p"),Va.innerHTML=fu,xp=i(),Na=a("p"),Na.innerHTML=Iu,Ep=i(),za=a("p"),za.textContent=bu,Qp=i(),qa=a("img"),$p=i(),La=a("p"),La.textContent=gu,Sp=i(),Da=a("p"),Da.innerHTML=Cu,Xp=i(),Pa=a("img"),Yp=i(),Ka=a("p"),Ka.textContent=Au,Rp=i(),ae=a("h2"),Oe=a("a"),Ui=a("span"),y(Oa.$$.fragment),py=i(),Qn=a("span"),Qn.textContent=Gu,Fp=i(),fi=a("p"),this.h()},l(e){const t=tm("svelte-1phssyn",document.head);U=n(t,"META",{name:!0,content:!0}),t.forEach(l),Ii=o(e),$n=n(e,"P",{}),h($n).forEach(l),bi=o(e),f=n(e,"H1",{class:!0});var Vp=h(f);ne=n(Vp,"A",{id:!0,class:!0,href:!0});var Zu=h(ne);Sn=n(Zu,"SPAN",{});var _u=h(Sn);w(el.$$.fragment,_u),_u.forEach(l),Zu.forEach(l),Bh=o(Vp),en=n(Vp,"SPAN",{"data-svelte-h":!0}),M(en)!=="svelte-14b5dvv"&&(en.textContent=yy),Vp.forEach(l),vi=o(e),w(ll.$$.fragment,e),gi=o(e),tl=n(e,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-1f5e3v9"&&(tl.textContent=wy),Ci=o(e),sl=n(e,"OL",{"data-svelte-h":!0}),M(sl)!=="svelte-191gi6t"&&(sl.innerHTML=cy),Bi=o(e),al=n(e,"IMG",{src:!0,alt:!0}),Ai=o(e),nl=n(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-3cojf7"&&(nl.innerHTML=Jy),Gi=o(e),il=n(e,"P",{"data-svelte-h":!0}),M(il)!=="svelte-hl4dc4"&&(il.innerHTML=my),Zi=o(e),ol=n(e,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-lt0dbq"&&(ol.innerHTML=Ty),_i=o(e),rl=n(e,"P",{"data-svelte-h":!0}),M(rl)!=="svelte-1qkxyrx"&&(rl.innerHTML=jy),ki=o(e),Ml=n(e,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-znarat"&&(Ml.innerHTML=dy),Wi=o(e),pl=n(e,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-iw09i5"&&(pl.innerHTML=Uy),xi=o(e),hl=n(e,"P",{"data-svelte-h":!0}),M(hl)!=="svelte-1if5l3v"&&(hl.innerHTML=fy),Ei=o(e),yl=n(e,"P",{"data-svelte-h":!0}),M(yl)!=="svelte-1ecbzo8"&&(yl.innerHTML=Iy),Qi=o(e),wl=n(e,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-p9mrd0"&&(wl.innerHTML=by),$i=o(e),I=n(e,"H1",{class:!0});var Np=h(I);ie=n(Np,"A",{id:!0,class:!0,href:!0});var ku=h(ie);Xn=n(ku,"SPAN",{});var Wu=h(Xn);w(cl.$$.fragment,Wu),Wu.forEach(l),ku.forEach(l),Ah=o(Np),ln=n(Np,"SPAN",{"data-svelte-h":!0}),M(ln)!=="svelte-17j89g5"&&(ln.textContent=vy),Np.forEach(l),Si=o(e),ul=n(e,"IMG",{src:!0,alt:!0}),Xi=o(e),Jl=n(e,"P",{"data-svelte-h":!0}),M(Jl)!=="svelte-vi2h6e"&&(Jl.innerHTML=Cy),Yi=o(e),ml=n(e,"P",{"data-svelte-h":!0}),M(ml)!=="svelte-rjslfr"&&(ml.innerHTML=By),Ri=o(e),Tl=n(e,"IMG",{src:!0,alt:!0}),Fi=o(e),b=n(e,"H3",{class:!0});var zp=h(b);oe=n(zp,"A",{id:!0,class:!0,href:!0});var xu=h(oe);Yn=n(xu,"SPAN",{});var Eu=h(Yn);w(jl.$$.fragment,Eu),Eu.forEach(l),xu.forEach(l),Gh=o(zp),tn=n(zp,"SPAN",{"data-svelte-h":!0}),M(tn)!=="svelte-ul8fdn"&&(tn.textContent=Gy),zp.forEach(l),Hi=o(e),dl=n(e,"UL",{"data-svelte-h":!0}),M(dl)!=="svelte-1u1g1n7"&&(dl.innerHTML=Zy),Vi=o(e),v=n(e,"H3",{class:!0});var qp=h(v);re=n(qp,"A",{id:!0,class:!0,href:!0});var Qu=h(re);Rn=n(Qu,"SPAN",{});var $u=h(Rn);w(Ul.$$.fragment,$u),$u.forEach(l),Qu.forEach(l),Zh=o(qp),sn=n(qp,"SPAN",{"data-svelte-h":!0}),M(sn)!=="svelte-15n18n6"&&(sn.textContent=_y),qp.forEach(l),Ni=o(e),fl=n(e,"UL",{"data-svelte-h":!0}),M(fl)!=="svelte-2cigth"&&(fl.innerHTML=ky),zi=o(e),Il=n(e,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-qqj2y4"&&(Il.innerHTML=Wy),qi=o(e),g=n(e,"H2",{class:!0});var Lp=h(g);Me=n(Lp,"A",{id:!0,class:!0,href:!0});var Su=h(Me);Fn=n(Su,"SPAN",{});var Xu=h(Fn);w(bl.$$.fragment,Xu),Xu.forEach(l),Su.forEach(l),_h=o(Lp),an=n(Lp,"SPAN",{"data-svelte-h":!0}),M(an)!=="svelte-ygr1lr"&&(an.textContent=xy),Lp.forEach(l),Li=o(e),vl=n(e,"P",{"data-svelte-h":!0}),M(vl)!=="svelte-nsjs09"&&(vl.textContent=Ey),Di=o(e),gl=n(e,"UL",{"data-svelte-h":!0}),M(gl)!=="svelte-as9usj"&&(gl.innerHTML=Qy),Pi=o(e),C=n(e,"H2",{class:!0});var Dp=h(C);pe=n(Dp,"A",{id:!0,class:!0,href:!0});var Yu=h(pe);Hn=n(Yu,"SPAN",{});var Ru=h(Hn);w(Cl.$$.fragment,Ru),Ru.forEach(l),Yu.forEach(l),kh=o(Dp),nn=n(Dp,"SPAN",{"data-svelte-h":!0}),M(nn)!=="svelte-5hev"&&(nn.textContent=$y),Dp.forEach(l),Ki=o(e),Bl=n(e,"IMG",{src:!0,alt:!0}),Oi=o(e),Al=n(e,"P",{"data-svelte-h":!0}),M(Al)!=="svelte-6wur6d"&&(Al.textContent=Xy),eo=o(e),Gl=n(e,"UL",{"data-svelte-h":!0}),M(Gl)!=="svelte-1aijka3"&&(Gl.innerHTML=Yy),lo=o(e),Zl=n(e,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-lpcvpy"&&(Zl.innerHTML=Ry),to=o(e),_l=n(e,"P",{"data-svelte-h":!0}),M(_l)!=="svelte-i91mrq"&&(_l.innerHTML=Fy),so=o(e),kl=n(e,"P",{"data-svelte-h":!0}),M(kl)!=="svelte-15ow6yh"&&(kl.innerHTML=Hy),ao=o(e),B=n(e,"H2",{class:!0});var Pp=h(B);he=n(Pp,"A",{id:!0,class:!0,href:!0});var Fu=h(he);Vn=n(Fu,"SPAN",{});var Hu=h(Vn);w(Wl.$$.fragment,Hu),Hu.forEach(l),Fu.forEach(l),Wh=o(Pp),on=n(Pp,"SPAN",{"data-svelte-h":!0}),M(on)!=="svelte-14bgx92"&&(on.textContent=Vy),Pp.forEach(l),no=o(e),xl=n(e,"P",{"data-svelte-h":!0}),M(xl)!=="svelte-1v25wk6"&&(xl.textContent=Ny),io=o(e),El=n(e,"P",{"data-svelte-h":!0}),M(El)!=="svelte-tnvrvw"&&(El.innerHTML=zy),oo=o(e),A=n(e,"H2",{class:!0});var Kp=h(A);ye=n(Kp,"A",{id:!0,class:!0,href:!0});var Vu=h(ye);Nn=n(Vu,"SPAN",{});var Nu=h(Nn);w(Ql.$$.fragment,Nu),Nu.forEach(l),Vu.forEach(l),xh=o(Kp),rn=n(Kp,"SPAN",{"data-svelte-h":!0}),M(rn)!=="svelte-1bf6673"&&(rn.textContent=qy),Kp.forEach(l),ro=o(e),$l=n(e,"P",{"data-svelte-h":!0}),M($l)!=="svelte-35riax"&&($l.innerHTML=Ly),Mo=o(e),Sl=n(e,"UL",{"data-svelte-h":!0}),M(Sl)!=="svelte-y53e1m"&&(Sl.innerHTML=Dy),po=o(e),we=n(e,"IMG",{src:!0,alt:!0,width:!0}),ho=o(e),Xl=n(e,"UL",{"data-svelte-h":!0}),M(Xl)!=="svelte-ewg9tp"&&(Xl.innerHTML=Ky),yo=o(e),ce=n(e,"IMG",{src:!0,alt:!0,width:!0}),wo=o(e),Yl=n(e,"P",{"data-svelte-h":!0}),M(Yl)!=="svelte-ts6iuu"&&(Yl.innerHTML=ew),co=o(e),ue=n(e,"IMG",{src:!0,alt:!0,width:!0}),uo=o(e),Rl=n(e,"P",{"data-svelte-h":!0}),M(Rl)!=="svelte-1v1evpe"&&(Rl.textContent=tw),Jo=o(e),Je=n(e,"IMG",{src:!0,alt:!0,width:!0}),mo=o(e),G=n(e,"H1",{class:!0});var Op=h(G);me=n(Op,"A",{id:!0,class:!0,href:!0});var zu=h(me);zn=n(zu,"SPAN",{});var qu=h(zn);w(Fl.$$.fragment,qu),qu.forEach(l),zu.forEach(l),Eh=o(Op),Mn=n(Op,"SPAN",{"data-svelte-h":!0}),M(Mn)!=="svelte-12ywmma"&&(Mn.textContent=aw),Op.forEach(l),To=o(e),Hl=n(e,"P",{"data-svelte-h":!0}),M(Hl)!=="svelte-hl4dc4"&&(Hl.innerHTML=nw),jo=o(e),Vl=n(e,"P",{"data-svelte-h":!0}),M(Vl)!=="svelte-lt0dbq"&&(Vl.innerHTML=iw),Uo=o(e),Nl=n(e,"P",{"data-svelte-h":!0}),M(Nl)!=="svelte-1qkxyrx"&&(Nl.innerHTML=ow),fo=o(e),Z=n(e,"H2",{class:!0});var eh=h(Z);Te=n(eh,"A",{id:!0,class:!0,href:!0});var Lu=h(Te);qn=n(Lu,"SPAN",{});var Du=h(qn);w(zl.$$.fragment,Du),Du.forEach(l),Lu.forEach(l),Qh=o(eh),pn=n(eh,"SPAN",{"data-svelte-h":!0}),M(pn)!=="svelte-1ymzmge"&&(pn.textContent=rw),eh.forEach(l),Io=o(e),ql=n(e,"P",{"data-svelte-h":!0}),M(ql)!=="svelte-1qz55yt"&&(ql.innerHTML=Mw),bo=o(e),Ll=n(e,"P",{"data-svelte-h":!0}),M(Ll)!=="svelte-1edv84f"&&(Ll.textContent=pw),vo=o(e),Dl=n(e,"P",{"data-svelte-h":!0}),M(Dl)!=="svelte-p5tnmj"&&(Dl.textContent=hw),go=o(e),Pl=n(e,"UL",{"data-svelte-h":!0}),M(Pl)!=="svelte-1a6kaa0"&&(Pl.innerHTML=yw),Co=o(e),Kl=n(e,"P",{"data-svelte-h":!0}),M(Kl)!=="svelte-1ub567"&&(Kl.textContent=ww),Bo=o(e),Ol=n(e,"P",{"data-svelte-h":!0}),M(Ol)!=="svelte-z5knmu"&&(Ol.innerHTML=cw),Ao=o(e),w(et.$$.fragment,e),Go=o(e),w(lt.$$.fragment,e),Zo=o(e),tt=n(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-bx852m"&&(tt.innerHTML=uw),_o=o(e),w(st.$$.fragment,e),ko=o(e),w(at.$$.fragment,e),Wo=o(e),_=n(e,"H2",{class:!0});var lh=h(_);je=n(lh,"A",{id:!0,class:!0,href:!0});var Pu=h(je);Ln=n(Pu,"SPAN",{});var Ku=h(Ln);w(nt.$$.fragment,Ku),Ku.forEach(l),Pu.forEach(l),$h=o(lh),hn=n(lh,"SPAN",{"data-svelte-h":!0}),M(hn)!=="svelte-1oue0e3"&&(hn.textContent=Jw),lh.forEach(l),xo=o(e),it=n(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-15y0mfy"&&(it.textContent=mw),Eo=o(e),ot=n(e,"UL",{"data-svelte-h":!0}),M(ot)!=="svelte-1diir2b"&&(ot.innerHTML=Tw),Qo=o(e),w(rt.$$.fragment,e),$o=o(e),Mt=n(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-10wfdos"&&(Mt.textContent=jw),So=o(e),k=n(e,"H1",{class:!0});var th=h(k);de=n(th,"A",{id:!0,class:!0,href:!0});var Ou=h(de);Dn=n(Ou,"SPAN",{});var eJ=h(Dn);w(pt.$$.fragment,eJ),eJ.forEach(l),Ou.forEach(l),Sh=o(th),yn=n(th,"SPAN",{"data-svelte-h":!0}),M(yn)!=="svelte-11wtock"&&(yn.textContent=dw),th.forEach(l),Xo=o(e),ht=n(e,"H2",{"data-svelte-h":!0}),M(ht)!=="svelte-1b8y8x"&&(ht.innerHTML=Uw),Yo=o(e),yt=n(e,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1y7jkk2"&&(yt.textContent=fw),Ro=o(e),wt=n(e,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1g9dnfd"&&(wt.innerHTML=Iw),Fo=o(e),Ho=n(e,"HR",{}),Vo=o(e),ct=n(e,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1opykko"&&(ct.innerHTML=bw),No=o(e),ut=n(e,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-69seoq"&&(ut.textContent=vw),zo=o(e),Jt=n(e,"UL",{"data-svelte-h":!0}),M(Jt)!=="svelte-1bqo6ps"&&(Jt.innerHTML=gw),qo=o(e),mt=n(e,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-ikftvi"&&(mt.textContent=Cw),Lo=o(e),Tt=n(e,"UL",{"data-svelte-h":!0}),M(Tt)!=="svelte-1xh74m5"&&(Tt.innerHTML=Bw),Do=o(e),jt=n(e,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-28qiy3"&&(jt.innerHTML=Aw),Po=o(e),dt=n(e,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-13axk10"&&(dt.innerHTML=Gw),Ko=o(e),w(Ut.$$.fragment,e),Oo=o(e),W=n(e,"H3",{class:!0});var sh=h(W);Ue=n(sh,"A",{id:!0,class:!0,href:!0});var lJ=h(Ue);Pn=n(lJ,"SPAN",{});var tJ=h(Pn);w(ft.$$.fragment,tJ),tJ.forEach(l),lJ.forEach(l),Xh=o(sh),wn=n(sh,"SPAN",{"data-svelte-h":!0}),M(wn)!=="svelte-13h1zkw"&&(wn.textContent=Zw),sh.forEach(l),er=o(e),w(It.$$.fragment,e),lr=o(e),bt=n(e,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-tce60o"&&(bt.textContent=_w),tr=o(e),w(vt.$$.fragment,e),sr=o(e),gt=n(e,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-1inu12x"&&(gt.textContent=kw),ar=o(e),x=n(e,"H3",{class:!0});var ah=h(x);fe=n(ah,"A",{id:!0,class:!0,href:!0});var sJ=h(fe);Kn=n(sJ,"SPAN",{});var aJ=h(Kn);w(Ct.$$.fragment,aJ),aJ.forEach(l),sJ.forEach(l),Yh=o(ah),cn=n(ah,"SPAN",{"data-svelte-h":!0}),M(cn)!=="svelte-8up7w4"&&(cn.textContent=Ww),ah.forEach(l),nr=o(e),w(Bt.$$.fragment,e),ir=o(e),At=n(e,"P",{"data-svelte-h":!0}),M(At)!=="svelte-1moftaa"&&(At.innerHTML=xw),or=o(e),Gt=n(e,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-194e91w"&&(Gt.innerHTML=Ew),rr=o(e),Zt=n(e,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1rshm9z"&&(Zt.textContent=Qw),Mr=o(e),_t=n(e,"IMG",{src:!0,alt:!0}),pr=o(e),w(kt.$$.fragment,e),hr=o(e),Wt=n(e,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-us31f2"&&(Wt.textContent=Sw),yr=o(e),xt=n(e,"UL",{"data-svelte-h":!0}),M(xt)!=="svelte-1i38xji"&&(xt.innerHTML=Xw),wr=o(e),Et=n(e,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-1s6ywkk"&&(Et.textContent=Yw),cr=o(e),Qt=n(e,"UL",{"data-svelte-h":!0}),M(Qt)!=="svelte-fsx41z"&&(Qt.innerHTML=Rw),ur=o(e),E=n(e,"H2",{class:!0});var nh=h(E);Ie=n(nh,"A",{id:!0,class:!0,href:!0});var nJ=h(Ie);On=n(nJ,"SPAN",{});var iJ=h(On);w($t.$$.fragment,iJ),iJ.forEach(l),nJ.forEach(l),Rh=o(nh),un=n(nh,"SPAN",{"data-svelte-h":!0}),M(un)!=="svelte-mf37sl"&&(un.textContent=Fw),nh.forEach(l),Jr=o(e),St=n(e,"P",{"data-svelte-h":!0}),M(St)!=="svelte-ya8m6q"&&(St.textContent=Hw),mr=o(e),be=n(e,"IMG",{src:!0,alt:!0,width:!0}),Tr=o(e),Xt=n(e,"P",{"data-svelte-h":!0}),M(Xt)!=="svelte-1u12uzl"&&(Xt.innerHTML=Nw),jr=o(e),w(Yt.$$.fragment,e),dr=o(e),w(Rt.$$.fragment,e),Ur=o(e),w(Ft.$$.fragment,e),fr=o(e),Q=n(e,"H3",{class:!0});var ih=h(Q);ve=n(ih,"A",{id:!0,class:!0,href:!0});var oJ=h(ve);ei=n(oJ,"SPAN",{});var rJ=h(ei);w(Ht.$$.fragment,rJ),rJ.forEach(l),oJ.forEach(l),Fh=o(ih),Jn=n(ih,"SPAN",{"data-svelte-h":!0}),M(Jn)!=="svelte-13h1zkw"&&(Jn.textContent=zw),ih.forEach(l),Ir=o(e),w(Vt.$$.fragment,e),br=o(e),w(Nt.$$.fragment,e),vr=o(e),w(zt.$$.fragment,e),gr=o(e),$=n(e,"H2",{class:!0});var oh=h($);ge=n(oh,"A",{id:!0,class:!0,href:!0});var MJ=h(ge);li=n(MJ,"SPAN",{});var pJ=h(li);w(qt.$$.fragment,pJ),pJ.forEach(l),MJ.forEach(l),Hh=o(oh),mn=n(oh,"SPAN",{"data-svelte-h":!0}),M(mn)!=="svelte-1l8oxdp"&&(mn.textContent=qw),oh.forEach(l),Cr=o(e),Lt=n(e,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-d4nx75"&&(Lt.innerHTML=Lw),Br=o(e),Dt=n(e,"UL",{"data-svelte-h":!0}),M(Dt)!=="svelte-1p5h2yo"&&(Dt.innerHTML=Dw),Ar=o(e),Pt=n(e,"P",{"data-svelte-h":!0}),M(Pt)!=="svelte-r5d24i"&&(Pt.textContent=Pw),Gr=o(e),Ce=n(e,"IMG",{src:!0,alt:!0,width:!0}),Zr=o(e),w(Kt.$$.fragment,e),_r=o(e),S=n(e,"H4",{class:!0});var rh=h(S);Be=n(rh,"A",{id:!0,class:!0,href:!0});var hJ=h(Be);ti=n(hJ,"SPAN",{});var yJ=h(ti);w(Ot.$$.fragment,yJ),yJ.forEach(l),hJ.forEach(l),Vh=o(rh),Tn=n(rh,"SPAN",{"data-svelte-h":!0}),M(Tn)!=="svelte-13h1zkw"&&(Tn.textContent=Ow),rh.forEach(l),kr=o(e),w(es.$$.fragment,e),Wr=o(e),X=n(e,"H2",{class:!0});var Mh=h(X);Ae=n(Mh,"A",{id:!0,class:!0,href:!0});var wJ=h(Ae);si=n(wJ,"SPAN",{});var cJ=h(si);w(ls.$$.fragment,cJ),cJ.forEach(l),wJ.forEach(l),Nh=o(Mh),jn=n(Mh,"SPAN",{"data-svelte-h":!0}),M(jn)!=="svelte-13y88qk"&&(jn.textContent=ec),Mh.forEach(l),xr=o(e),ts=n(e,"P",{"data-svelte-h":!0}),M(ts)!=="svelte-15kc6ix"&&(ts.textContent=lc),Er=o(e),ss=n(e,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-12b3gcn"&&(ss.textContent=tc),Qr=o(e),as=n(e,"UL",{"data-svelte-h":!0}),M(as)!=="svelte-1capiq3"&&(as.innerHTML=sc),$r=o(e),ns=n(e,"P",{"data-svelte-h":!0}),M(ns)!=="svelte-1xegqik"&&(ns.innerHTML=ac),Sr=o(e),Ge=n(e,"IMG",{src:!0,alt:!0,width:!0}),Xr=o(e),w(is.$$.fragment,e),Yr=o(e),Y=n(e,"H4",{class:!0});var ph=h(Y);Ze=n(ph,"A",{id:!0,class:!0,href:!0});var uJ=h(Ze);ai=n(uJ,"SPAN",{});var JJ=h(ai);w(os.$$.fragment,JJ),JJ.forEach(l),uJ.forEach(l),zh=o(ph),dn=n(ph,"SPAN",{"data-svelte-h":!0}),M(dn)!=="svelte-13h1zkw"&&(dn.textContent=ic),ph.forEach(l),Rr=o(e),w(rs.$$.fragment,e),Fr=o(e),R=n(e,"H2",{class:!0});var hh=h(R);_e=n(hh,"A",{id:!0,class:!0,href:!0});var mJ=h(_e);ni=n(mJ,"SPAN",{});var TJ=h(ni);w(Ms.$$.fragment,TJ),TJ.forEach(l),mJ.forEach(l),qh=o(hh),Un=n(hh,"SPAN",{"data-svelte-h":!0}),M(Un)!=="svelte-h5i9lp"&&(Un.textContent=oc),hh.forEach(l),Hr=o(e),ps=n(e,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-1vceqb8"&&(ps.textContent=rc),Vr=o(e),hs=n(e,"UL",{"data-svelte-h":!0}),M(hs)!=="svelte-1sx31jt"&&(hs.innerHTML=Mc),Nr=o(e),w(ys.$$.fragment,e),zr=o(e),F=n(e,"H2",{class:!0});var yh=h(F);ke=n(yh,"A",{id:!0,class:!0,href:!0});var jJ=h(ke);ii=n(jJ,"SPAN",{});var dJ=h(ii);w(ws.$$.fragment,dJ),dJ.forEach(l),jJ.forEach(l),Lh=o(yh),fn=n(yh,"SPAN",{"data-svelte-h":!0}),M(fn)!=="svelte-lbacof"&&(fn.textContent=pc),yh.forEach(l),qr=o(e),We=n(e,"IMG",{src:!0,alt:!0,width:!0}),Lr=o(e),cs=n(e,"P",{"data-svelte-h":!0}),M(cs)!=="svelte-mo6epg"&&(cs.textContent=yc),Dr=o(e),w(us.$$.fragment,e),Pr=o(e),w(Js.$$.fragment,e),Kr=o(e),H=n(e,"H4",{class:!0});var wh=h(H);xe=n(wh,"A",{id:!0,class:!0,href:!0});var UJ=h(xe);oi=n(UJ,"SPAN",{});var fJ=h(oi);w(ms.$$.fragment,fJ),fJ.forEach(l),UJ.forEach(l),Dh=o(wh),In=n(wh,"SPAN",{"data-svelte-h":!0}),M(In)!=="svelte-13h1zkw"&&(In.textContent=wc),wh.forEach(l),Or=o(e),w(Ts.$$.fragment,e),eM=o(e),V=n(e,"H2",{class:!0});var ch=h(V);Ee=n(ch,"A",{id:!0,class:!0,href:!0});var IJ=h(Ee);ri=n(IJ,"SPAN",{});var bJ=h(ri);w(js.$$.fragment,bJ),bJ.forEach(l),IJ.forEach(l),Ph=o(ch),bn=n(ch,"SPAN",{"data-svelte-h":!0}),M(bn)!=="svelte-1vk6ywk"&&(bn.textContent=cc),ch.forEach(l),lM=o(e),w(ds.$$.fragment,e),tM=o(e),N=n(e,"H2",{class:!0});var uh=h(N);Qe=n(uh,"A",{id:!0,class:!0,href:!0});var vJ=h(Qe);Mi=n(vJ,"SPAN",{});var gJ=h(Mi);w(Us.$$.fragment,gJ),gJ.forEach(l),vJ.forEach(l),Kh=o(uh),vn=n(uh,"SPAN",{"data-svelte-h":!0}),M(vn)!=="svelte-1qmmce7"&&(vn.textContent=uc),uh.forEach(l),sM=o(e),w(fs.$$.fragment,e),aM=o(e),z=n(e,"H2",{class:!0});var Jh=h(z);$e=n(Jh,"A",{id:!0,class:!0,href:!0});var CJ=h($e);pi=n(CJ,"SPAN",{});var BJ=h(pi);w(Is.$$.fragment,BJ),BJ.forEach(l),CJ.forEach(l),Oh=o(Jh),gn=n(Jh,"SPAN",{"data-svelte-h":!0}),M(gn)!=="svelte-r5mgh3"&&(gn.textContent=Jc),Jh.forEach(l),nM=o(e),bs=n(e,"UL",{"data-svelte-h":!0}),M(bs)!=="svelte-1hothf3"&&(bs.innerHTML=mc),iM=o(e),w(vs.$$.fragment,e),oM=o(e),q=n(e,"H2",{class:!0});var mh=h(q);Se=n(mh,"A",{id:!0,class:!0,href:!0});var AJ=h(Se);hi=n(AJ,"SPAN",{});var GJ=h(hi);w(gs.$$.fragment,GJ),GJ.forEach(l),AJ.forEach(l),ey=o(mh),Cn=n(mh,"SPAN",{"data-svelte-h":!0}),M(Cn)!=="svelte-1avq7ec"&&(Cn.textContent=Tc),mh.forEach(l),rM=o(e),Cs=n(e,"UL",{"data-svelte-h":!0}),M(Cs)!=="svelte-1snb10p"&&(Cs.innerHTML=jc),MM=o(e),w(Bs.$$.fragment,e),pM=o(e),L=n(e,"H2",{class:!0});var Th=h(L);Xe=n(Th,"A",{id:!0,class:!0,href:!0});var ZJ=h(Xe);yi=n(ZJ,"SPAN",{});var _J=h(yi);w(As.$$.fragment,_J),_J.forEach(l),ZJ.forEach(l),ly=o(Th),Bn=n(Th,"SPAN",{"data-svelte-h":!0}),M(Bn)!=="svelte-1rv5pjp"&&(Bn.textContent=dc),Th.forEach(l),hM=o(e),Gs=n(e,"P",{"data-svelte-h":!0}),M(Gs)!=="svelte-1djb4oi"&&(Gs.innerHTML=Uc),yM=o(e),Zs=n(e,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1ifum22"&&(Zs.textContent=fc),wM=o(e),Ye=n(e,"IMG",{src:!0,alt:!0,width:!0}),cM=o(e),_s=n(e,"P",{"data-svelte-h":!0}),M(_s)!=="svelte-1pr3qlz"&&(_s.textContent=bc),uM=o(e),D=n(e,"H4",{class:!0});var jh=h(D);Re=n(jh,"A",{id:!0,class:!0,href:!0});var kJ=h(Re);wi=n(kJ,"SPAN",{});var WJ=h(wi);w(ks.$$.fragment,WJ),WJ.forEach(l),kJ.forEach(l),ty=o(jh),An=n(jh,"SPAN",{"data-svelte-h":!0}),M(An)!=="svelte-re6m98"&&(An.textContent=vc),jh.forEach(l),JM=o(e),w(Ws.$$.fragment,e),mM=o(e),w(xs.$$.fragment,e),TM=o(e),w(Es.$$.fragment,e),jM=o(e),Fe=n(e,"H3",{id:!0,"data-svelte-h":!0}),M(Fe)!=="svelte-18n2j84"&&(Fe.textContent=gc),dM=o(e),Qs=n(e,"P",{"data-svelte-h":!0}),M(Qs)!=="svelte-fovdf1"&&(Qs.innerHTML=Cc),UM=o(e),$s=n(e,"P",{"data-svelte-h":!0}),M($s)!=="svelte-vgzxi7"&&($s.textContent=Bc),fM=o(e),Ss=n(e,"UL",{"data-svelte-h":!0}),M(Ss)!=="svelte-bcjr5d"&&(Ss.innerHTML=Ac),IM=o(e),Xs=n(e,"P",{"data-svelte-h":!0}),M(Xs)!=="svelte-6k9qpu"&&(Xs.textContent=Gc),bM=o(e),Ys=n(e,"P",{"data-svelte-h":!0}),M(Ys)!=="svelte-932u9c"&&(Ys.innerHTML=Zc),vM=o(e),Rs=n(e,"P",{"data-svelte-h":!0}),M(Rs)!=="svelte-1cn3tld"&&(Rs.textContent=_c),gM=o(e),Fs=n(e,"UL",{"data-svelte-h":!0}),M(Fs)!=="svelte-19b5tev"&&(Fs.innerHTML=kc),CM=o(e),Hs=n(e,"IMG",{src:!0,alt:!0}),BM=o(e),w(Vs.$$.fragment,e),AM=o(e),Ns=n(e,"P",{"data-svelte-h":!0}),M(Ns)!=="svelte-49nrvg"&&(Ns.innerHTML=xc),GM=o(e),zs=n(e,"P",{"data-svelte-h":!0}),M(zs)!=="svelte-98z2qn"&&(zs.innerHTML=Ec),ZM=o(e),qs=n(e,"UL",{"data-svelte-h":!0}),M(qs)!=="svelte-1hssbsu"&&(qs.innerHTML=Qc),_M=o(e),w(Ls.$$.fragment,e),kM=o(e),Ds=n(e,"P",{"data-svelte-h":!0}),M(Ds)!=="svelte-ofvu76"&&(Ds.innerHTML=$c),WM=o(e),Ps=n(e,"UL",{"data-svelte-h":!0}),M(Ps)!=="svelte-1nfxrjn"&&(Ps.innerHTML=Sc),xM=o(e),w(Ks.$$.fragment,e),EM=o(e),w(Os.$$.fragment,e),QM=o(e),ea=n(e,"P",{"data-svelte-h":!0}),M(ea)!=="svelte-1jklivl"&&(ea.textContent=Xc),$M=o(e),P=n(e,"H1",{class:!0});var dh=h(P);He=n(dh,"A",{id:!0,class:!0,href:!0});var xJ=h(He);ci=n(xJ,"SPAN",{});var EJ=h(ci);w(la.$$.fragment,EJ),EJ.forEach(l),xJ.forEach(l),sy=o(dh),Gn=n(dh,"SPAN",{"data-svelte-h":!0}),M(Gn)!=="svelte-iv3gpj"&&(Gn.textContent=Yc),dh.forEach(l),SM=o(e),ta=n(e,"H2",{"data-svelte-h":!0}),M(ta)!=="svelte-vbtt44"&&(ta.innerHTML=Rc),XM=o(e),sa=n(e,"P",{"data-svelte-h":!0}),M(sa)!=="svelte-1y7jkk2"&&(sa.textContent=Fc),YM=o(e),aa=n(e,"P",{"data-svelte-h":!0}),M(aa)!=="svelte-1ip08fr"&&(aa.innerHTML=Hc),RM=o(e),FM=n(e,"HR",{}),HM=o(e),na=n(e,"P",{"data-svelte-h":!0}),M(na)!=="svelte-1f0umdd"&&(na.innerHTML=Vc),VM=o(e),ia=n(e,"P",{"data-svelte-h":!0}),M(ia)!=="svelte-17rt1na"&&(ia.innerHTML=Nc),NM=o(e),oa=n(e,"IMG",{src:!0,alt:!0}),zM=o(e),w(ra.$$.fragment,e),qM=o(e),Ma=n(e,"P",{"data-svelte-h":!0}),M(Ma)!=="svelte-lidq2q"&&(Ma.innerHTML=qc),LM=o(e),w(pa.$$.fragment,e),DM=o(e),w(ha.$$.fragment,e),PM=o(e),ya=n(e,"P",{"data-svelte-h":!0}),M(ya)!=="svelte-17m9qrz"&&(ya.innerHTML=Lc),KM=o(e),wa=n(e,"UL",{"data-svelte-h":!0}),M(wa)!=="svelte-18vb0lv"&&(wa.innerHTML=Dc),OM=o(e),ca=n(e,"P",{"data-svelte-h":!0}),M(ca)!=="svelte-1s6ywkk"&&(ca.textContent=Pc),ep=o(e),ua=n(e,"UL",{"data-svelte-h":!0}),M(ua)!=="svelte-lauea"&&(ua.innerHTML=Kc),lp=o(e),w(Ja.$$.fragment,e),tp=o(e),K=n(e,"H2",{class:!0});var Uh=h(K);Ve=n(Uh,"A",{id:!0,class:!0,href:!0});var QJ=h(Ve);ui=n(QJ,"SPAN",{});var $J=h(ui);w(ma.$$.fragment,$J),$J.forEach(l),QJ.forEach(l),ay=o(Uh),Zn=n(Uh,"SPAN",{"data-svelte-h":!0}),M(Zn)!=="svelte-h5i9lp"&&(Zn.textContent=Oc),Uh.forEach(l),sp=o(e),Ta=n(e,"P",{"data-svelte-h":!0}),M(Ta)!=="svelte-w1y0j"&&(Ta.innerHTML=eu),ap=o(e),w(ja.$$.fragment,e),np=o(e),O=n(e,"H2",{class:!0});var fh=h(O);Ne=n(fh,"A",{id:!0,class:!0,href:!0});var SJ=h(Ne);Ji=n(SJ,"SPAN",{});var XJ=h(Ji);w(da.$$.fragment,XJ),XJ.forEach(l),SJ.forEach(l),ny=o(fh),_n=n(fh,"SPAN",{"data-svelte-h":!0}),M(_n)!=="svelte-f0co5d"&&(_n.textContent=lu),fh.forEach(l),ip=o(e),w(Ua.$$.fragment,e),op=o(e),ee=n(e,"H2",{class:!0});var Ih=h(ee);ze=n(Ih,"A",{id:!0,class:!0,href:!0});var YJ=h(ze);mi=n(YJ,"SPAN",{});var RJ=h(mi);w(fa.$$.fragment,RJ),RJ.forEach(l),YJ.forEach(l),iy=o(Ih),kn=n(Ih,"SPAN",{"data-svelte-h":!0}),M(kn)!=="svelte-1a7tiin"&&(kn.textContent=tu),Ih.forEach(l),rp=o(e),Ia=n(e,"UL",{"data-svelte-h":!0}),M(Ia)!=="svelte-1khpmsn"&&(Ia.innerHTML=su),Mp=o(e),w(ba.$$.fragment,e),pp=o(e),w(va.$$.fragment,e),hp=o(e),ga=n(e,"P",{"data-svelte-h":!0}),M(ga)!=="svelte-oh8wqa"&&(ga.innerHTML=au),yp=o(e),Ca=n(e,"IMG",{src:!0,alt:!0}),wp=o(e),le=n(e,"H1",{class:!0});var bh=h(le);qe=n(bh,"A",{id:!0,class:!0,href:!0});var FJ=h(qe);Ti=n(FJ,"SPAN",{});var HJ=h(Ti);w(Ba.$$.fragment,HJ),HJ.forEach(l),FJ.forEach(l),oy=o(bh),Wn=n(bh,"SPAN",{"data-svelte-h":!0}),M(Wn)!=="svelte-uduwve"&&(Wn.textContent=iu),bh.forEach(l),cp=o(e),Aa=n(e,"P",{"data-svelte-h":!0}),M(Aa)!=="svelte-iv76jo"&&(Aa.textContent=ou),up=o(e),Ga=n(e,"P",{"data-svelte-h":!0}),M(Ga)!=="svelte-hdbqg"&&(Ga.textContent=ru),Jp=o(e),Za=n(e,"OL",{"data-svelte-h":!0}),M(Za)!=="svelte-qkijdo"&&(Za.innerHTML=Mu),mp=o(e),_a=n(e,"IMG",{src:!0,alt:!0}),Tp=o(e),Le=n(e,"OL",{start:!0,"data-svelte-h":!0}),M(Le)!=="svelte-1faxh4"&&(Le.innerHTML=hu),jp=o(e),ka=n(e,"UL",{"data-svelte-h":!0}),M(ka)!=="svelte-29nsg7"&&(ka.innerHTML=yu),dp=o(e),te=n(e,"H4",{class:!0});var vh=h(te);De=n(vh,"A",{id:!0,class:!0,href:!0});var VJ=h(De);ji=n(VJ,"SPAN",{});var NJ=h(ji);w(Wa.$$.fragment,NJ),NJ.forEach(l),VJ.forEach(l),ry=o(vh),xn=n(vh,"SPAN",{"data-svelte-h":!0}),M(xn)!=="svelte-re6m98"&&(xn.textContent=wu),vh.forEach(l),Up=o(e),w(xa.$$.fragment,e),fp=o(e),Pe=n(e,"H3",{id:!0,"data-svelte-h":!0}),M(Pe)!=="svelte-18n2j84"&&(Pe.textContent=cu),Ip=o(e),w(Ea.$$.fragment,e),bp=o(e),w(Qa.$$.fragment,e),vp=o(e),se=n(e,"H2",{class:!0});var gh=h(se);Ke=n(gh,"A",{id:!0,class:!0,href:!0});var zJ=h(Ke);di=n(zJ,"SPAN",{});var qJ=h(di);w($a.$$.fragment,qJ),qJ.forEach(l),zJ.forEach(l),My=o(gh),En=n(gh,"SPAN",{"data-svelte-h":!0}),M(En)!=="svelte-a17ig2"&&(En.textContent=uu),gh.forEach(l),gp=o(e),Sa=n(e,"P",{"data-svelte-h":!0}),M(Sa)!=="svelte-1nokp82"&&(Sa.innerHTML=Ju),Cp=o(e),Xa=n(e,"P",{"data-svelte-h":!0}),M(Xa)!=="svelte-131ixzr"&&(Xa.innerHTML=mu),Bp=o(e),Ya=n(e,"P",{"data-svelte-h":!0}),M(Ya)!=="svelte-1uth36j"&&(Ya.textContent=Tu),Ap=o(e),Ra=n(e,"UL",{"data-svelte-h":!0}),M(Ra)!=="svelte-17mmf24"&&(Ra.innerHTML=ju),Gp=o(e),Fa=n(e,"P",{"data-svelte-h":!0}),M(Fa)!=="svelte-vf0l4f"&&(Fa.innerHTML=du),Zp=o(e),_p=n(e,"HR",{}),kp=o(e),Ha=n(e,"P",{"data-svelte-h":!0}),M(Ha)!=="svelte-4y921w"&&(Ha.textContent=Uu),Wp=o(e),Va=n(e,"P",{"data-svelte-h":!0}),M(Va)!=="svelte-1xc37hs"&&(Va.innerHTML=fu),xp=o(e),Na=n(e,"P",{"data-svelte-h":!0}),M(Na)!=="svelte-1m4pzec"&&(Na.innerHTML=Iu),Ep=o(e),za=n(e,"P",{"data-svelte-h":!0}),M(za)!=="svelte-cgragb"&&(za.textContent=bu),Qp=o(e),qa=n(e,"IMG",{src:!0,alt:!0}),$p=o(e),La=n(e,"P",{"data-svelte-h":!0}),M(La)!=="svelte-1oiipwt"&&(La.textContent=gu),Sp=o(e),Da=n(e,"P",{"data-svelte-h":!0}),M(Da)!=="svelte-11vrr72"&&(Da.innerHTML=Cu),Xp=o(e),Pa=n(e,"IMG",{src:!0,alt:!0}),Yp=o(e),Ka=n(e,"P",{"data-svelte-h":!0}),M(Ka)!=="svelte-so7imd"&&(Ka.textContent=Au),Rp=o(e),ae=n(e,"H2",{class:!0});var Ch=h(ae);Oe=n(Ch,"A",{id:!0,class:!0,href:!0});var LJ=h(Oe);Ui=n(LJ,"SPAN",{});var DJ=h(Ui);w(Oa.$$.fragment,DJ),DJ.forEach(l),LJ.forEach(l),py=o(Ch),Qn=n(Ch,"SPAN",{"data-svelte-h":!0}),M(Qn)!=="svelte-i9a3z3"&&(Qn.textContent=Gu),Ch.forEach(l),Fp=o(e),fi=n(e,"P",{}),h(fi).forEach(l),this.h()},h(){r(U,"name","hf:doc:metadata"),r(U,"content",JSON.stringify(nm)),r(ne,"id","hands-on"),r(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ne,"href","#hands-on"),r(f,"class","relative group"),d(al.src,uy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/envs.gif")||r(al,"src",uy),r(al,"alt","Environments"),r(ie,"id","unit-2-qlearning-with-frozenlakev1-and-taxiv3"),r(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ie,"href","#unit-2-qlearning-with-frozenlakev1-and-taxiv3"),r(I,"class","relative group"),d(ul.src,gy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/thumbnail.jpg")||r(ul,"src",gy),r(ul,"alt","Unit 2 Thumbnail"),d(Tl.src,Ay="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/envs.gif")||r(Tl,"src",Ay),r(Tl,"alt","Environments"),r(oe,"id","environments"),r(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(oe,"href","#environments"),r(b,"class","relative group"),r(re,"id","rllibrary"),r(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(re,"href","#rllibrary"),r(v,"class","relative group"),r(Me,"id","objectives-of-this-notebook"),r(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Me,"href","#objectives-of-this-notebook"),r(g,"class","relative group"),r(pe,"id","this-notebook-is-from-the-deep-reinforcement-learning-course"),r(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(pe,"href","#this-notebook-is-from-the-deep-reinforcement-learning-course"),r(C,"class","relative group"),d(Bl.src,Sy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/deep-rl-course-illustration.jpg")||r(Bl,"src",Sy),r(Bl,"alt","Deep RL Course illustration"),r(he,"id","prerequisites"),r(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(he,"href","#prerequisites"),r(B,"class","relative group"),r(ye,"id","a-small-recap-of-qlearning"),r(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ye,"href","#a-small-recap-of-qlearning"),r(A,"class","relative group"),d(we.src,Py="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-function-2.jpg")||r(we,"src",Py),r(we,"alt","Q function"),r(we,"width","100%"),d(ce.src,Oy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/link-value-policy.jpg")||r(ce,"src",Oy),r(ce,"alt","Link value policy"),r(ce,"width","100%"),d(ue.src,lw="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/q-learning.jpeg")||r(ue,"src",lw),r(ue,"alt","q-learning.jpeg"),r(ue,"width","100%"),d(Je.src,sw="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||r(Je,"src",sw),r(Je,"alt","Q-Learning"),r(Je,"width","100%"),r(me,"id","lets-code-our-first-reinforcement-learning-algorithm"),r(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(me,"href","#lets-code-our-first-reinforcement-learning-algorithm"),r(G,"class","relative group"),r(Te,"id","install-dependencies-and-create-a-virtual-display"),r(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Te,"href","#install-dependencies-and-create-a-virtual-display"),r(Z,"class","relative group"),r(je,"id","import-the-packages"),r(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(je,"href","#import-the-packages"),r(_,"class","relative group"),r(de,"id","part-1-frozen-lake-non-slippery-version"),r(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(de,"href","#part-1-frozen-lake-non-slippery-version"),r(k,"class","relative group"),r(Ue,"id","solution"),r(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ue,"href","#solution"),r(W,"class","relative group"),r(fe,"id","lets-see-what-the-environment-looks-like"),r(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(fe,"href","#lets-see-what-the-environment-looks-like"),r(x,"class","relative group"),d(_t.src,$w="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/frozenlake.png")||r(_t,"src",$w),r(_t,"alt","FrozenLake"),r(Ie,"id","create-and-initialize-the-qtable"),r(Ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ie,"href","#create-and-initialize-the-qtable"),r(E,"class","relative group"),d(be.src,Vw="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||r(be,"src",Vw),r(be,"alt","Q-Learning"),r(be,"width","100%"),r(ve,"id","solution"),r(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ve,"href","#solution"),r(Q,"class","relative group"),r(ge,"id","define-the-greedy-policy"),r(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ge,"href","#define-the-greedy-policy"),r($,"class","relative group"),d(Ce.src,Kw="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-4.jpg")||r(Ce,"src",Kw),r(Ce,"alt","Q-Learning"),r(Ce,"width","100%"),r(Be,"id","solution"),r(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Be,"href","#solution"),r(S,"class","relative group"),r(Ae,"id","define-the-epsilongreedy-policy"),r(Ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ae,"href","#define-the-epsilongreedy-policy"),r(X,"class","relative group"),d(Ge.src,nc="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-4.jpg")||r(Ge,"src",nc),r(Ge,"alt","Q-Learning"),r(Ge,"width","100%"),r(Ze,"id","solution"),r(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ze,"href","#solution"),r(Y,"class","relative group"),r(_e,"id","define-the-hyperparameters"),r(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_e,"href","#define-the-hyperparameters"),r(R,"class","relative group"),r(ke,"id","create-the-training-loop-method"),r(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ke,"href","#create-the-training-loop-method"),r(F,"class","relative group"),d(We.src,hc="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||r(We,"src",hc),r(We,"alt","Q-Learning"),r(We,"width","100%"),r(xe,"id","solution"),r(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(xe,"href","#solution"),r(H,"class","relative group"),r(Ee,"id","train-the-qlearning-agent"),r(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ee,"href","#train-the-qlearning-agent"),r(V,"class","relative group"),r(Qe,"id","lets-see-what-our-qlearning-table-looks-like-now"),r(Qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Qe,"href","#lets-see-what-our-qlearning-table-looks-like-now"),r(N,"class","relative group"),r($e,"id","the-evaluation-method"),r($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($e,"href","#the-evaluation-method"),r(z,"class","relative group"),r(Se,"id","evaluate-our-qlearning-agent"),r(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Se,"href","#evaluate-our-qlearning-agent"),r(q,"class","relative group"),r(Xe,"id","publish-our-trained-model-to-the-hub"),r(Xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Xe,"href","#publish-our-trained-model-to-the-hub"),r(L,"class","relative group"),d(Ye.src,Ic="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/modelcard.png")||r(Ye,"src",Ic),r(Ye,"alt","Model card"),r(Ye,"width","100%"),r(Re,"id","do-not-modify-this-code"),r(Re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Re,"href","#do-not-modify-this-code"),r(D,"class","relative group"),r(Fe,"id",""),d(Hs.src,Wc="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||r(Hs,"src",Wc),r(Hs,"alt","Create HF Token"),r(He,"id","part-2-taxiv3"),r(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(He,"href","#part-2-taxiv3"),r(P,"class","relative group"),d(oa.src,zc="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/taxi.png")||r(oa,"src",zc),r(oa,"alt","Taxi"),r(Ve,"id","define-the-hyperparameters"),r(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ve,"href","#define-the-hyperparameters"),r(K,"class","relative group"),r(Ne,"id","train-our-qlearning-agent"),r(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ne,"href","#train-our-qlearning-agent"),r(O,"class","relative group"),r(ze,"id","create-a-model-dictionary-and-publish-our-trained-model-to-the-hub"),r(ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ze,"href","#create-a-model-dictionary-and-publish-our-trained-model-to-the-hub"),r(ee,"class","relative group"),d(Ca.src,nu="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/taxi-leaderboard.png")||r(Ca,"src",nu),r(Ca,"alt","Taxi Leaderboard"),r(qe,"id","part-3-load-from-hub"),r(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(qe,"href","#part-3-load-from-hub"),r(le,"class","relative group"),d(_a.src,pu="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit2/copy-id.png")||r(_a,"src",pu),r(_a,"alt","Copy id"),r(Le,"start","3"),r(De,"id","do-not-modify-this-code"),r(De,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(De,"href","#do-not-modify-this-code"),r(te,"class","relative group"),r(Pe,"id",""),r(Ke,"id","some-additional-challenges"),r(Ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ke,"href","#some-additional-challenges"),r(se,"class","relative group"),d(qa.src,vu="https://vizdoom.cs.put.edu.pl/user/pages/01.tutorial/basic.png")||r(qa,"src",vu),r(qa,"alt","Doom"),d(Pa.src,Bu="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/atari-envs.gif")||r(Pa,"src",Bu),r(Pa,"alt","Environments"),r(Oe,"id","keep-learning-stay-awesome"),r(Oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Oe,"href","#keep-learning-stay-awesome"),r(ae,"class","relative group")},m(e,t){p(document.head,U),s(e,Ii,t),s(e,$n,t),s(e,bi,t),s(e,f,t),p(f,ne),p(ne,Sn),c(el,Sn,null),p(f,Bh),p(f,en),s(e,vi,t),c(ll,e,t),s(e,gi,t),s(e,tl,t),s(e,Ci,t),s(e,sl,t),s(e,Bi,t),s(e,al,t),s(e,Ai,t),s(e,nl,t),s(e,Gi,t),s(e,il,t),s(e,Zi,t),s(e,ol,t),s(e,_i,t),s(e,rl,t),s(e,ki,t),s(e,Ml,t),s(e,Wi,t),s(e,pl,t),s(e,xi,t),s(e,hl,t),s(e,Ei,t),s(e,yl,t),s(e,Qi,t),s(e,wl,t),s(e,$i,t),s(e,I,t),p(I,ie),p(ie,Xn),c(cl,Xn,null),p(I,Ah),p(I,ln),s(e,Si,t),s(e,ul,t),s(e,Xi,t),s(e,Jl,t),s(e,Yi,t),s(e,ml,t),s(e,Ri,t),s(e,Tl,t),s(e,Fi,t),s(e,b,t),p(b,oe),p(oe,Yn),c(jl,Yn,null),p(b,Gh),p(b,tn),s(e,Hi,t),s(e,dl,t),s(e,Vi,t),s(e,v,t),p(v,re),p(re,Rn),c(Ul,Rn,null),p(v,Zh),p(v,sn),s(e,Ni,t),s(e,fl,t),s(e,zi,t),s(e,Il,t),s(e,qi,t),s(e,g,t),p(g,Me),p(Me,Fn),c(bl,Fn,null),p(g,_h),p(g,an),s(e,Li,t),s(e,vl,t),s(e,Di,t),s(e,gl,t),s(e,Pi,t),s(e,C,t),p(C,pe),p(pe,Hn),c(Cl,Hn,null),p(C,kh),p(C,nn),s(e,Ki,t),s(e,Bl,t),s(e,Oi,t),s(e,Al,t),s(e,eo,t),s(e,Gl,t),s(e,lo,t),s(e,Zl,t),s(e,to,t),s(e,_l,t),s(e,so,t),s(e,kl,t),s(e,ao,t),s(e,B,t),p(B,he),p(he,Vn),c(Wl,Vn,null),p(B,Wh),p(B,on),s(e,no,t),s(e,xl,t),s(e,io,t),s(e,El,t),s(e,oo,t),s(e,A,t),p(A,ye),p(ye,Nn),c(Ql,Nn,null),p(A,xh),p(A,rn),s(e,ro,t),s(e,$l,t),s(e,Mo,t),s(e,Sl,t),s(e,po,t),s(e,we,t),s(e,ho,t),s(e,Xl,t),s(e,yo,t),s(e,ce,t),s(e,wo,t),s(e,Yl,t),s(e,co,t),s(e,ue,t),s(e,uo,t),s(e,Rl,t),s(e,Jo,t),s(e,Je,t),s(e,mo,t),s(e,G,t),p(G,me),p(me,zn),c(Fl,zn,null),p(G,Eh),p(G,Mn),s(e,To,t),s(e,Hl,t),s(e,jo,t),s(e,Vl,t),s(e,Uo,t),s(e,Nl,t),s(e,fo,t),s(e,Z,t),p(Z,Te),p(Te,qn),c(zl,qn,null),p(Z,Qh),p(Z,pn),s(e,Io,t),s(e,ql,t),s(e,bo,t),s(e,Ll,t),s(e,vo,t),s(e,Dl,t),s(e,go,t),s(e,Pl,t),s(e,Co,t),s(e,Kl,t),s(e,Bo,t),s(e,Ol,t),s(e,Ao,t),c(et,e,t),s(e,Go,t),c(lt,e,t),s(e,Zo,t),s(e,tt,t),s(e,_o,t),c(st,e,t),s(e,ko,t),c(at,e,t),s(e,Wo,t),s(e,_,t),p(_,je),p(je,Ln),c(nt,Ln,null),p(_,$h),p(_,hn),s(e,xo,t),s(e,it,t),s(e,Eo,t),s(e,ot,t),s(e,Qo,t),c(rt,e,t),s(e,$o,t),s(e,Mt,t),s(e,So,t),s(e,k,t),p(k,de),p(de,Dn),c(pt,Dn,null),p(k,Sh),p(k,yn),s(e,Xo,t),s(e,ht,t),s(e,Yo,t),s(e,yt,t),s(e,Ro,t),s(e,wt,t),s(e,Fo,t),s(e,Ho,t),s(e,Vo,t),s(e,ct,t),s(e,No,t),s(e,ut,t),s(e,zo,t),s(e,Jt,t),s(e,qo,t),s(e,mt,t),s(e,Lo,t),s(e,Tt,t),s(e,Do,t),s(e,jt,t),s(e,Po,t),s(e,dt,t),s(e,Ko,t),c(Ut,e,t),s(e,Oo,t),s(e,W,t),p(W,Ue),p(Ue,Pn),c(ft,Pn,null),p(W,Xh),p(W,wn),s(e,er,t),c(It,e,t),s(e,lr,t),s(e,bt,t),s(e,tr,t),c(vt,e,t),s(e,sr,t),s(e,gt,t),s(e,ar,t),s(e,x,t),p(x,fe),p(fe,Kn),c(Ct,Kn,null),p(x,Yh),p(x,cn),s(e,nr,t),c(Bt,e,t),s(e,ir,t),s(e,At,t),s(e,or,t),s(e,Gt,t),s(e,rr,t),s(e,Zt,t),s(e,Mr,t),s(e,_t,t),s(e,pr,t),c(kt,e,t),s(e,hr,t),s(e,Wt,t),s(e,yr,t),s(e,xt,t),s(e,wr,t),s(e,Et,t),s(e,cr,t),s(e,Qt,t),s(e,ur,t),s(e,E,t),p(E,Ie),p(Ie,On),c($t,On,null),p(E,Rh),p(E,un),s(e,Jr,t),s(e,St,t),s(e,mr,t),s(e,be,t),s(e,Tr,t),s(e,Xt,t),s(e,jr,t),c(Yt,e,t),s(e,dr,t),c(Rt,e,t),s(e,Ur,t),c(Ft,e,t),s(e,fr,t),s(e,Q,t),p(Q,ve),p(ve,ei),c(Ht,ei,null),p(Q,Fh),p(Q,Jn),s(e,Ir,t),c(Vt,e,t),s(e,br,t),c(Nt,e,t),s(e,vr,t),c(zt,e,t),s(e,gr,t),s(e,$,t),p($,ge),p(ge,li),c(qt,li,null),p($,Hh),p($,mn),s(e,Cr,t),s(e,Lt,t),s(e,Br,t),s(e,Dt,t),s(e,Ar,t),s(e,Pt,t),s(e,Gr,t),s(e,Ce,t),s(e,Zr,t),c(Kt,e,t),s(e,_r,t),s(e,S,t),p(S,Be),p(Be,ti),c(Ot,ti,null),p(S,Vh),p(S,Tn),s(e,kr,t),c(es,e,t),s(e,Wr,t),s(e,X,t),p(X,Ae),p(Ae,si),c(ls,si,null),p(X,Nh),p(X,jn),s(e,xr,t),s(e,ts,t),s(e,Er,t),s(e,ss,t),s(e,Qr,t),s(e,as,t),s(e,$r,t),s(e,ns,t),s(e,Sr,t),s(e,Ge,t),s(e,Xr,t),c(is,e,t),s(e,Yr,t),s(e,Y,t),p(Y,Ze),p(Ze,ai),c(os,ai,null),p(Y,zh),p(Y,dn),s(e,Rr,t),c(rs,e,t),s(e,Fr,t),s(e,R,t),p(R,_e),p(_e,ni),c(Ms,ni,null),p(R,qh),p(R,Un),s(e,Hr,t),s(e,ps,t),s(e,Vr,t),s(e,hs,t),s(e,Nr,t),c(ys,e,t),s(e,zr,t),s(e,F,t),p(F,ke),p(ke,ii),c(ws,ii,null),p(F,Lh),p(F,fn),s(e,qr,t),s(e,We,t),s(e,Lr,t),s(e,cs,t),s(e,Dr,t),c(us,e,t),s(e,Pr,t),c(Js,e,t),s(e,Kr,t),s(e,H,t),p(H,xe),p(xe,oi),c(ms,oi,null),p(H,Dh),p(H,In),s(e,Or,t),c(Ts,e,t),s(e,eM,t),s(e,V,t),p(V,Ee),p(Ee,ri),c(js,ri,null),p(V,Ph),p(V,bn),s(e,lM,t),c(ds,e,t),s(e,tM,t),s(e,N,t),p(N,Qe),p(Qe,Mi),c(Us,Mi,null),p(N,Kh),p(N,vn),s(e,sM,t),c(fs,e,t),s(e,aM,t),s(e,z,t),p(z,$e),p($e,pi),c(Is,pi,null),p(z,Oh),p(z,gn),s(e,nM,t),s(e,bs,t),s(e,iM,t),c(vs,e,t),s(e,oM,t),s(e,q,t),p(q,Se),p(Se,hi),c(gs,hi,null),p(q,ey),p(q,Cn),s(e,rM,t),s(e,Cs,t),s(e,MM,t),c(Bs,e,t),s(e,pM,t),s(e,L,t),p(L,Xe),p(Xe,yi),c(As,yi,null),p(L,ly),p(L,Bn),s(e,hM,t),s(e,Gs,t),s(e,yM,t),s(e,Zs,t),s(e,wM,t),s(e,Ye,t),s(e,cM,t),s(e,_s,t),s(e,uM,t),s(e,D,t),p(D,Re),p(Re,wi),c(ks,wi,null),p(D,ty),p(D,An),s(e,JM,t),c(Ws,e,t),s(e,mM,t),c(xs,e,t),s(e,TM,t),c(Es,e,t),s(e,jM,t),s(e,Fe,t),s(e,dM,t),s(e,Qs,t),s(e,UM,t),s(e,$s,t),s(e,fM,t),s(e,Ss,t),s(e,IM,t),s(e,Xs,t),s(e,bM,t),s(e,Ys,t),s(e,vM,t),s(e,Rs,t),s(e,gM,t),s(e,Fs,t),s(e,CM,t),s(e,Hs,t),s(e,BM,t),c(Vs,e,t),s(e,AM,t),s(e,Ns,t),s(e,GM,t),s(e,zs,t),s(e,ZM,t),s(e,qs,t),s(e,_M,t),c(Ls,e,t),s(e,kM,t),s(e,Ds,t),s(e,WM,t),s(e,Ps,t),s(e,xM,t),c(Ks,e,t),s(e,EM,t),c(Os,e,t),s(e,QM,t),s(e,ea,t),s(e,$M,t),s(e,P,t),p(P,He),p(He,ci),c(la,ci,null),p(P,sy),p(P,Gn),s(e,SM,t),s(e,ta,t),s(e,XM,t),s(e,sa,t),s(e,YM,t),s(e,aa,t),s(e,RM,t),s(e,FM,t),s(e,HM,t),s(e,na,t),s(e,VM,t),s(e,ia,t),s(e,NM,t),s(e,oa,t),s(e,zM,t),c(ra,e,t),s(e,qM,t),s(e,Ma,t),s(e,LM,t),c(pa,e,t),s(e,DM,t),c(ha,e,t),s(e,PM,t),s(e,ya,t),s(e,KM,t),s(e,wa,t),s(e,OM,t),s(e,ca,t),s(e,ep,t),s(e,ua,t),s(e,lp,t),c(Ja,e,t),s(e,tp,t),s(e,K,t),p(K,Ve),p(Ve,ui),c(ma,ui,null),p(K,ay),p(K,Zn),s(e,sp,t),s(e,Ta,t),s(e,ap,t),c(ja,e,t),s(e,np,t),s(e,O,t),p(O,Ne),p(Ne,Ji),c(da,Ji,null),p(O,ny),p(O,_n),s(e,ip,t),c(Ua,e,t),s(e,op,t),s(e,ee,t),p(ee,ze),p(ze,mi),c(fa,mi,null),p(ee,iy),p(ee,kn),s(e,rp,t),s(e,Ia,t),s(e,Mp,t),c(ba,e,t),s(e,pp,t),c(va,e,t),s(e,hp,t),s(e,ga,t),s(e,yp,t),s(e,Ca,t),s(e,wp,t),s(e,le,t),p(le,qe),p(qe,Ti),c(Ba,Ti,null),p(le,oy),p(le,Wn),s(e,cp,t),s(e,Aa,t),s(e,up,t),s(e,Ga,t),s(e,Jp,t),s(e,Za,t),s(e,mp,t),s(e,_a,t),s(e,Tp,t),s(e,Le,t),s(e,jp,t),s(e,ka,t),s(e,dp,t),s(e,te,t),p(te,De),p(De,ji),c(Wa,ji,null),p(te,ry),p(te,xn),s(e,Up,t),c(xa,e,t),s(e,fp,t),s(e,Pe,t),s(e,Ip,t),c(Ea,e,t),s(e,bp,t),c(Qa,e,t),s(e,vp,t),s(e,se,t),p(se,Ke),p(Ke,di),c($a,di,null),p(se,My),p(se,En),s(e,gp,t),s(e,Sa,t),s(e,Cp,t),s(e,Xa,t),s(e,Bp,t),s(e,Ya,t),s(e,Ap,t),s(e,Ra,t),s(e,Gp,t),s(e,Fa,t),s(e,Zp,t),s(e,_p,t),s(e,kp,t),s(e,Ha,t),s(e,Wp,t),s(e,Va,t),s(e,xp,t),s(e,Na,t),s(e,Ep,t),s(e,za,t),s(e,Qp,t),s(e,qa,t),s(e,$p,t),s(e,La,t),s(e,Sp,t),s(e,Da,t),s(e,Xp,t),s(e,Pa,t),s(e,Yp,t),s(e,Ka,t),s(e,Rp,t),s(e,ae,t),p(ae,Oe),p(Oe,Ui),c(Oa,Ui,null),p(ae,py),p(ae,Qn),s(e,Fp,t),s(e,fi,t),Hp=!0},p:KJ,i(e){Hp||(u(el.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(jl.$$.fragment,e),u(Ul.$$.fragment,e),u(bl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Ql.$$.fragment,e),u(Fl.$$.fragment,e),u(zl.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(st.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(pt.$$.fragment,e),u(Ut.$$.fragment,e),u(ft.$$.fragment,e),u(It.$$.fragment,e),u(vt.$$.fragment,e),u(Ct.$$.fragment,e),u(Bt.$$.fragment,e),u(kt.$$.fragment,e),u($t.$$.fragment,e),u(Yt.$$.fragment,e),u(Rt.$$.fragment,e),u(Ft.$$.fragment,e),u(Ht.$$.fragment,e),u(Vt.$$.fragment,e),u(Nt.$$.fragment,e),u(zt.$$.fragment,e),u(qt.$$.fragment,e),u(Kt.$$.fragment,e),u(Ot.$$.fragment,e),u(es.$$.fragment,e),u(ls.$$.fragment,e),u(is.$$.fragment,e),u(os.$$.fragment,e),u(rs.$$.fragment,e),u(Ms.$$.fragment,e),u(ys.$$.fragment,e),u(ws.$$.fragment,e),u(us.$$.fragment,e),u(Js.$$.fragment,e),u(ms.$$.fragment,e),u(Ts.$$.fragment,e),u(js.$$.fragment,e),u(ds.$$.fragment,e),u(Us.$$.fragment,e),u(fs.$$.fragment,e),u(Is.$$.fragment,e),u(vs.$$.fragment,e),u(gs.$$.fragment,e),u(Bs.$$.fragment,e),u(As.$$.fragment,e),u(ks.$$.fragment,e),u(Ws.$$.fragment,e),u(xs.$$.fragment,e),u(Es.$$.fragment,e),u(Vs.$$.fragment,e),u(Ls.$$.fragment,e),u(Ks.$$.fragment,e),u(Os.$$.fragment,e),u(la.$$.fragment,e),u(ra.$$.fragment,e),u(pa.$$.fragment,e),u(ha.$$.fragment,e),u(Ja.$$.fragment,e),u(ma.$$.fragment,e),u(ja.$$.fragment,e),u(da.$$.fragment,e),u(Ua.$$.fragment,e),u(fa.$$.fragment,e),u(ba.$$.fragment,e),u(va.$$.fragment,e),u(Ba.$$.fragment,e),u(Wa.$$.fragment,e),u(xa.$$.fragment,e),u(Ea.$$.fragment,e),u(Qa.$$.fragment,e),u($a.$$.fragment,e),u(Oa.$$.fragment,e),Hp=!0)},o(e){J(el.$$.fragment,e),J(ll.$$.fragment,e),J(cl.$$.fragment,e),J(jl.$$.fragment,e),J(Ul.$$.fragment,e),J(bl.$$.fragment,e),J(Cl.$$.fragment,e),J(Wl.$$.fragment,e),J(Ql.$$.fragment,e),J(Fl.$$.fragment,e),J(zl.$$.fragment,e),J(et.$$.fragment,e),J(lt.$$.fragment,e),J(st.$$.fragment,e),J(at.$$.fragment,e),J(nt.$$.fragment,e),J(rt.$$.fragment,e),J(pt.$$.fragment,e),J(Ut.$$.fragment,e),J(ft.$$.fragment,e),J(It.$$.fragment,e),J(vt.$$.fragment,e),J(Ct.$$.fragment,e),J(Bt.$$.fragment,e),J(kt.$$.fragment,e),J($t.$$.fragment,e),J(Yt.$$.fragment,e),J(Rt.$$.fragment,e),J(Ft.$$.fragment,e),J(Ht.$$.fragment,e),J(Vt.$$.fragment,e),J(Nt.$$.fragment,e),J(zt.$$.fragment,e),J(qt.$$.fragment,e),J(Kt.$$.fragment,e),J(Ot.$$.fragment,e),J(es.$$.fragment,e),J(ls.$$.fragment,e),J(is.$$.fragment,e),J(os.$$.fragment,e),J(rs.$$.fragment,e),J(Ms.$$.fragment,e),J(ys.$$.fragment,e),J(ws.$$.fragment,e),J(us.$$.fragment,e),J(Js.$$.fragment,e),J(ms.$$.fragment,e),J(Ts.$$.fragment,e),J(js.$$.fragment,e),J(ds.$$.fragment,e),J(Us.$$.fragment,e),J(fs.$$.fragment,e),J(Is.$$.fragment,e),J(vs.$$.fragment,e),J(gs.$$.fragment,e),J(Bs.$$.fragment,e),J(As.$$.fragment,e),J(ks.$$.fragment,e),J(Ws.$$.fragment,e),J(xs.$$.fragment,e),J(Es.$$.fragment,e),J(Vs.$$.fragment,e),J(Ls.$$.fragment,e),J(Ks.$$.fragment,e),J(Os.$$.fragment,e),J(la.$$.fragment,e),J(ra.$$.fragment,e),J(pa.$$.fragment,e),J(ha.$$.fragment,e),J(Ja.$$.fragment,e),J(ma.$$.fragment,e),J(ja.$$.fragment,e),J(da.$$.fragment,e),J(Ua.$$.fragment,e),J(fa.$$.fragment,e),J(ba.$$.fragment,e),J(va.$$.fragment,e),J(Ba.$$.fragment,e),J(Wa.$$.fragment,e),J(xa.$$.fragment,e),J(Ea.$$.fragment,e),J(Qa.$$.fragment,e),J($a.$$.fragment,e),J(Oa.$$.fragment,e),Hp=!1},d(e){e&&(l(Ii),l($n),l(bi),l(f),l(vi),l(gi),l(tl),l(Ci),l(sl),l(Bi),l(al),l(Ai),l(nl),l(Gi),l(il),l(Zi),l(ol),l(_i),l(rl),l(ki),l(Ml),l(Wi),l(pl),l(xi),l(hl),l(Ei),l(yl),l(Qi),l(wl),l($i),l(I),l(Si),l(ul),l(Xi),l(Jl),l(Yi),l(ml),l(Ri),l(Tl),l(Fi),l(b),l(Hi),l(dl),l(Vi),l(v),l(Ni),l(fl),l(zi),l(Il),l(qi),l(g),l(Li),l(vl),l(Di),l(gl),l(Pi),l(C),l(Ki),l(Bl),l(Oi),l(Al),l(eo),l(Gl),l(lo),l(Zl),l(to),l(_l),l(so),l(kl),l(ao),l(B),l(no),l(xl),l(io),l(El),l(oo),l(A),l(ro),l($l),l(Mo),l(Sl),l(po),l(we),l(ho),l(Xl),l(yo),l(ce),l(wo),l(Yl),l(co),l(ue),l(uo),l(Rl),l(Jo),l(Je),l(mo),l(G),l(To),l(Hl),l(jo),l(Vl),l(Uo),l(Nl),l(fo),l(Z),l(Io),l(ql),l(bo),l(Ll),l(vo),l(Dl),l(go),l(Pl),l(Co),l(Kl),l(Bo),l(Ol),l(Ao),l(Go),l(Zo),l(tt),l(_o),l(ko),l(Wo),l(_),l(xo),l(it),l(Eo),l(ot),l(Qo),l($o),l(Mt),l(So),l(k),l(Xo),l(ht),l(Yo),l(yt),l(Ro),l(wt),l(Fo),l(Ho),l(Vo),l(ct),l(No),l(ut),l(zo),l(Jt),l(qo),l(mt),l(Lo),l(Tt),l(Do),l(jt),l(Po),l(dt),l(Ko),l(Oo),l(W),l(er),l(lr),l(bt),l(tr),l(sr),l(gt),l(ar),l(x),l(nr),l(ir),l(At),l(or),l(Gt),l(rr),l(Zt),l(Mr),l(_t),l(pr),l(hr),l(Wt),l(yr),l(xt),l(wr),l(Et),l(cr),l(Qt),l(ur),l(E),l(Jr),l(St),l(mr),l(be),l(Tr),l(Xt),l(jr),l(dr),l(Ur),l(fr),l(Q),l(Ir),l(br),l(vr),l(gr),l($),l(Cr),l(Lt),l(Br),l(Dt),l(Ar),l(Pt),l(Gr),l(Ce),l(Zr),l(_r),l(S),l(kr),l(Wr),l(X),l(xr),l(ts),l(Er),l(ss),l(Qr),l(as),l($r),l(ns),l(Sr),l(Ge),l(Xr),l(Yr),l(Y),l(Rr),l(Fr),l(R),l(Hr),l(ps),l(Vr),l(hs),l(Nr),l(zr),l(F),l(qr),l(We),l(Lr),l(cs),l(Dr),l(Pr),l(Kr),l(H),l(Or),l(eM),l(V),l(lM),l(tM),l(N),l(sM),l(aM),l(z),l(nM),l(bs),l(iM),l(oM),l(q),l(rM),l(Cs),l(MM),l(pM),l(L),l(hM),l(Gs),l(yM),l(Zs),l(wM),l(Ye),l(cM),l(_s),l(uM),l(D),l(JM),l(mM),l(TM),l(jM),l(Fe),l(dM),l(Qs),l(UM),l($s),l(fM),l(Ss),l(IM),l(Xs),l(bM),l(Ys),l(vM),l(Rs),l(gM),l(Fs),l(CM),l(Hs),l(BM),l(AM),l(Ns),l(GM),l(zs),l(ZM),l(qs),l(_M),l(kM),l(Ds),l(WM),l(Ps),l(xM),l(EM),l(QM),l(ea),l($M),l(P),l(SM),l(ta),l(XM),l(sa),l(YM),l(aa),l(RM),l(FM),l(HM),l(na),l(VM),l(ia),l(NM),l(oa),l(zM),l(qM),l(Ma),l(LM),l(DM),l(PM),l(ya),l(KM),l(wa),l(OM),l(ca),l(ep),l(ua),l(lp),l(tp),l(K),l(sp),l(Ta),l(ap),l(np),l(O),l(ip),l(op),l(ee),l(rp),l(Ia),l(Mp),l(pp),l(hp),l(ga),l(yp),l(Ca),l(wp),l(le),l(cp),l(Aa),l(up),l(Ga),l(Jp),l(Za),l(mp),l(_a),l(Tp),l(Le),l(jp),l(ka),l(dp),l(te),l(Up),l(fp),l(Pe),l(Ip),l(bp),l(vp),l(se),l(gp),l(Sa),l(Cp),l(Xa),l(Bp),l(Ya),l(Ap),l(Ra),l(Gp),l(Fa),l(Zp),l(_p),l(kp),l(Ha),l(Wp),l(Va),l(xp),l(Na),l(Ep),l(za),l(Qp),l(qa),l($p),l(La),l(Sp),l(Da),l(Xp),l(Pa),l(Yp),l(Ka),l(Rp),l(ae),l(Fp),l(fi)),l(U),m(el),m(ll,e),m(cl),m(jl),m(Ul),m(bl),m(Cl),m(Wl),m(Ql),m(Fl),m(zl),m(et,e),m(lt,e),m(st,e),m(at,e),m(nt),m(rt,e),m(pt),m(Ut,e),m(ft),m(It,e),m(vt,e),m(Ct),m(Bt,e),m(kt,e),m($t),m(Yt,e),m(Rt,e),m(Ft,e),m(Ht),m(Vt,e),m(Nt,e),m(zt,e),m(qt),m(Kt,e),m(Ot),m(es,e),m(ls),m(is,e),m(os),m(rs,e),m(Ms),m(ys,e),m(ws),m(us,e),m(Js,e),m(ms),m(Ts,e),m(js),m(ds,e),m(Us),m(fs,e),m(Is),m(vs,e),m(gs),m(Bs,e),m(As),m(ks),m(Ws,e),m(xs,e),m(Es,e),m(Vs,e),m(Ls,e),m(Ks,e),m(Os,e),m(la),m(ra,e),m(pa,e),m(ha,e),m(Ja,e),m(ma),m(ja,e),m(da),m(Ua,e),m(fa),m(ba,e),m(va,e),m(Ba),m(Wa),m(xa,e),m(Ea,e),m(Qa,e),m($a),m(Oa)}}}const nm={local:"part-3-load-from-hub",sections:[{local:null,sections:[{local:null,sections:[{local:"do-not-modify-this-code",title:"Do not modify this code"}],title:null},{local:"",title:"."}],title:null},{local:"some-additional-challenges",title:"Some additional challenges 🏆"},{local:"keep-learning-stay-awesome",title:"Keep learning, stay awesome 🤗"}],title:"Part 3: Load from Hub 🔽"};function im(hy){return OJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ym extends em{constructor(U){super(),lm(this,U,im,am,PJ,{})}}export{ym as component};
