import{s as cm,f as Pe,n as wm,o as mm}from"../chunks/scheduler.37c15a92.js";import{S as Jm,i as Tm,g as a,s as i,u as h,m as d,H as en,A as Um,h as n,f as t,c as o,j as y,v as c,y as M,n as j,B as tn,k as p,o as r,a as s,w,d as m,t as J,x as T}from"../chunks/index.b01106c0.js";import{I as U}from"../chunks/IconCopyLink.77b762b4.js";import{C as u}from"../chunks/CodeBlock.00a4ae02.js";import{C as um}from"../chunks/CourseFloatingBanner.9c5d96ce.js";function dm(ay){let f,Yn,ln,zn,v,pe,sn,Ke,iM,pa,ny="Hands on",Fn,De,Ln,Oe,iy="Now that we’ve studied the theory behind Reinforce, <strong>you’re ready to code your Reinforce agent with PyTorch</strong>. And you’ll test its robustness using CartPole-v1 and PixelCopter,.",qn,et,oy="You’ll then be able to iterate and improve this implementation for more advanced environments.",Pn,Me,ry='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif" alt="Environments"/>',Kn,tt,py="To validate this hands-on for the certification process, you need to push your trained models to the Hub and:",Dn,lt,My="<li>Get a result of &gt;= 350 for <code>Cartpole-v1</code></li> <li>Get a result of &gt;= 5 for <code>PixelCopter</code>.</li>",On,st,yy="To find your result, go to the leaderboard and find your model, <strong>the result = mean_reward - std of reward</strong>. <strong>If you don’t see your model on the leaderboard, go at the bottom of the leaderboard page and click on the refresh button</strong>.",ei,at,hy="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",ti,nt,cy='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',li,it,wy='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',si,ot,my="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",ai,rt,Jy='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit4/unit4.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',ni,pt,Ty="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",ii,Mt,Uy="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",oi,b,ye,an,yt,oM,Ma,uy="Unit 4: Code your first Deep Reinforcement Learning Algorithm with PyTorch: Reinforce. And test its robustness 💪",ri,ht,dy,pi,ct,jy="In this notebook, you’ll code your first Deep Reinforcement Learning algorithm from scratch: Reinforce (also called Monte Carlo Policy Gradient).",Mi,wt,Iy="Reinforce is a <em>Policy-based method</em>: a Deep Reinforcement Learning algorithm that tries <strong>to optimize the policy directly without using an action-value function</strong>.",yi,mt,Cy="More precisely, Reinforce is a <em>Policy-gradient method</em>, a subclass of <em>Policy-based methods</em> that aims <strong>to optimize the policy directly by estimating the weights of the optimal policy using gradient ascent</strong>.",hi,Jt,fy="To test its robustness, we’re going to train it in 2 different simple environments:",ci,Tt,vy="<li>Cartpole-v1</li> <li>PixelcopterEnv</li>",wi,Ut,by="⬇️ Here is an example of what <strong>you will achieve at the end of this notebook.</strong> ⬇️",mi,ut,gy,Ji,g,he,nn,dt,rM,ya,By="🎮 Environments:",Ti,jt,Gy='<li><a href="https://www.gymlibrary.dev/environments/classic_control/cart_pole/" rel="nofollow">CartPole-v1</a></li> <li><a href="https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html" rel="nofollow">PixelCopter</a></li>',Ui,B,ce,on,It,pM,ha,Zy="📚 RL-Library:",ui,Ct,Ay="<li>Python</li> <li>PyTorch</li>",di,ft,_y='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',ji,G,we,rn,vt,MM,ca,ky="Objectives of this notebook 🏆",Ii,bt,Sy="At the end of the notebook, you will:",Ci,gt,Xy="<li>Be able to <strong>code a Reinforce algorithm from scratch using PyTorch.</strong></li> <li>Be able to <strong>test the robustness of your agent using simple environments.</strong></li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",fi,Z,me,pn,Bt,yM,wa,xy="Prerequisites 🏗️",vi,Gt,Wy="Before diving into the notebook, you need to:",bi,Zt,Ey='🔲 📚 <a href="https://huggingface.co/deep-rl-course/unit4/introduction" rel="nofollow">Study Policy Gradients by reading Unit 4</a>',gi,A,Je,Mn,At,hM,ma,Hy="Let's code Reinforce algorithm from scratch 🔥",Bi,_,Te,yn,_t,cM,Ja,Ny="Some advice 💡",Gi,kt,Vy="It’s better to run this colab in a copy on your Google Drive, so that <strong>if it times out</strong> you still have the saved notebook on your Google Drive and do not need to fill everything in from scratch.",Zi,St,Ry="To do that you can either do <code>Ctrl + S</code> or <code>File &gt; Save a copy in Google Drive.</code>",Ai,k,Ue,hn,Xt,wM,Ta,Qy="Set the GPU 💪",_i,xt,$y="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",ki,Wt,Yy,Si,Et,zy="<li><code>Hardware Accelerator &gt; GPU</code></li>",Xi,Ht,Fy,xi,S,ue,cn,Nt,mM,Ua,Ly="Create a virtual display 🖥",Wi,Vt,qy="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",Ei,Rt,Py="The following cell will install the librairies and create and run a virtual screen 🖥",Hi,Qt,Ni,$t,Vi,X,de,wn,Yt,JM,ua,Ky="Install the dependencies 🔽",Ri,zt,Dy="The first step is to install the dependencies. We’ll install multiple ones:",Qi,Ft,Oy="<li><code>gym</code></li> <li><code>gym-games</code>: Extra gym environments made with PyGame.</li> <li><code>huggingface_hub</code>: The Hub works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations, and other features that will allow you to easily collaborate with others.</li>",$i,Lt,eh="You may be wondering why we install gym and not gymnasium, a more recent version of gym? <strong>Because the gym-games we are using are not updated yet with gymnasium</strong>.",Yi,qt,th="The differences you’ll encounter here:",zi,Pt,lh="<li>In <code>gym</code> we don’t have <code>terminated</code> and <code>truncated</code> but only <code>done</code>.</li> <li>In <code>gym</code> using <code>env.step()</code> returns <code>state, reward, done, info</code></li>",Fi,Kt,sh='You can learn more about the differences between Gym and Gymnasium here 👉 <a href="https://gymnasium.farama.org/content/migration-guide/" rel="nofollow">https://gymnasium.farama.org/content/migration-guide/</a>',Li,Dt,ah='You can see here all the Reinforce models available 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a>',qi,Ot,nh='And you can find all the Deep Reinforcement Learning models here 👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning</a>',Pi,el,Ki,x,je,mn,tl,TM,da,ih="Import the packages 📦",Di,ll,oh="In addition to importing the installed libraries, we also import:",Oi,sl,rh="<li><code>imageio</code>: A library that will help us to generate a replay video</li>",eo,al,to,W,Ie,Jn,nl,UM,ja,ph="Check if we have a GPU",lo,il,Mh="<li>Let’s check if we have a GPU</li> <li>If it’s the case you should see <code>device:cuda0</code></li>",so,ol,ao,rl,no,pl,yh="We’re now ready to implement our Reinforce algorithm 🔥",io,E,Ce,Tn,Ml,uM,Ia,hh="First agent: Playing CartPole-v1 🤖",oo,H,fe,Un,yl,dM,Ca,ch="Create the CartPole environment and understand how it works",ro,N,ve,un,hl,jM,fa,wh="[The environment 🎮](https://www.gymlibrary.dev/environments/classic_control/cart_pole/)",po,V,be,dn,cl,IM,va,mh="Why do we use a simple environment like CartPole-v1?",Mo,wl,Jh='As explained in <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">Reinforcement Learning Tips and Tricks</a>, when you implement your agent from scratch, you need <strong>to be sure that it works correctly and find bugs with easy environments before going deeper</strong> as finding bugs will be much easier in simple environments.',yo,ml,Th="<p>Try to have some “sign of life” on toy problems</p>",ho,Jl,Uh="<p>Validate the implementation by making it run on harder and harder envs (you can compare results against the RL zoo). You usually need to run hyperparameter optimization for that step.</p>",co,R,ge,jn,Tl,CM,ba,uh="The CartPole-v1 environment",wo,Ul,dh="<p>A pole is attached by an un-actuated joint to a cart, which moves along a frictionless track. The pendulum is placed upright on the cart and the goal is to balance the pole by applying forces in the left and right direction on the cart.</p>",mo,ul,jh="So, we start with CartPole-v1. The goal is to push the cart left or right <strong>so that the pole stays in the equilibrium.</strong>",Jo,dl,Ih="The episode ends if:",To,jl,Ch="<li>The pole Angle is greater than ±12°</li> <li>The Cart Position is greater than ±2.4</li> <li>The episode length is greater than 500</li>",Uo,Il,fh="We get a reward 💰 of +1 every timestep that the Pole stays in the equilibrium.",uo,Cl,jo,fl,Io,vl,Co,Q,Be,In,bl,fM,ga,vh="Let's build the Reinforce Architecture",fo,gl,bh="This implementation is based on three implementations:",vo,Bl,gh='<li><a href="https://github.com/pytorch/examples/blob/main/reinforcement_learning/reinforce.py" rel="nofollow">PyTorch official Reinforcement Learning example</a></li> <li><a href="https://github.com/udacity/deep-reinforcement-learning/blob/master/reinforce/REINFORCE.ipynb" rel="nofollow">Udacity Reinforce</a></li> <li><a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">Improvement of the integration by Chris1nexus</a></li>',bo,Gl,Bh,go,Zl,Gh="So we want:",Bo,Al,Zh="<li>Two fully connected layers (fc1 and fc2).</li> <li>To use ReLU as activation function of fc1</li> <li>To use Softmax to output a probability distribution over actions</li>",Go,_l,Zo,$,Ge,Cn,kl,vM,Ba,Ah="Solution",Ao,Sl,_o,Xl,_h="I made a mistake, can you guess where?",ko,xl,kh="<li>To find out let’s make a forward pass:</li>",So,Wl,Xo,El,Sh="<li><p>Here we see that the error says <code>ValueError: The value argument to log_prob must be a Tensor</code></p></li> <li><p>It means that <code>action</code> in <code>m.log_prob(action)</code> must be a Tensor <strong>but it’s not.</strong></p></li> <li><p>Do you know why? Check the act function and try to see why it does not work.</p></li>",xo,Hl,Xh="Advice 💡: Something is wrong in this implementation. Remember that for the act function <strong>we want to sample an action from the probability distribution over actions</strong>.",Wo,Y,Ze,fn,Nl,bM,Ga,xh="(Real) Solution",Eo,Vl,Ho,Rl,Wh="By using CartPole, it was easier to debug since <strong>we know that the bug comes from our integration and not from our simple environment</strong>.",No,Ql,Eh="<li><p>Since <strong>we want to sample an action from the probability distribution over actions</strong>, we can’t use <code>action = np.argmax(m)</code> since it will always output the action that has the highest probability.</p></li> <li><p>We need to replace this with <code>action = m.sample()</code> which will sample an action from the probability distribution P(.|s)</p></li>",Vo,z,Ae,vn,$l,gM,Za,Hh="Let's build the Reinforce Training Algorithm",Ro,Yl,Nh,Qo,zl,Vh='<li><p>When we calculate the return Gt (line 6), we see that we calculate the sum of discounted rewards <strong>starting at timestep t</strong>.</p></li> <li><p>Why? Because our policy should only <strong>reinforce actions on the basis of the consequences</strong>: so rewards obtained before taking an action are useless (since they were not because of the action), <strong>only the ones that come after the action matters</strong>.</p></li> <li><p>Before coding this you should read this section <a href="https://spinningup.openai.com/en/latest/spinningup/rl_intro3.html#don-t-let-the-past-distract-you" rel="nofollow">don’t let the past distract you</a> that explains why we use reward-to-go policy gradient.</p></li>',$o,Fl,Rh=`We use an interesting technique coded by <a href="https://github.com/Chris1nexus" rel="nofollow">Chris1nexus</a> to <strong>compute the return at each timestep efficiently</strong>. The comments explained the procedure. Don’t hesitate also <a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">to check the PR explanation</a>
But overall the idea is to <strong>compute the return at each timestep efficiently</strong>.`,Yo,Ll,Qh="The second question you may ask is <strong>why do we minimize the loss</strong>? Didn’t we talk about Gradient Ascent, not Gradient Descent earlier?",zo,Aa,ql,BM,_a,$h="minimize an objective function.",I,ka,Yh="So let’s say we want to reinforce action 3 at a certain timestep. Before training this action P is 0.25.",GM,_e,ZM,Fo,om='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi><mi>h</mi><mi>e</mi><mi>t</mi><mi>a</mi></mrow><annotation encoding="application/x-tex">theta </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">t</span><span class="mord mathnormal">h</span><span class="mord mathnormal">e</span><span class="mord mathnormal">t</span><span class="mord mathnormal">a</span></span></span></span>',Lo,qo,rm='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo><mo>&gt;</mo><mn>0.25</mn></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta) &gt; 0.25 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.25</span></span></span></span>',AM,ke,_M,Po,pm='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi><msub><mi>i</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">p</span><span class="mord"><span class="mord mathnormal">i</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',Ko,Sa,zh="minimize other action probability.",kM,Xa,SM,Pl,XM,Do,Mm='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>−</mo><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">1 - \\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',Oo,xM,Kl,WM,er,ym='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',tr,EM,xa,HM,lr,hm='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',sr,Dl,ar,F,Se,bn,Ol,NM,Wa,Fh="Solution",nr,es,ir,L,Xe,gn,ts,VM,Ea,Lh="Train it",or,ls,rr,ss,pr,as,Mr,q,xe,Bn,ns,RM,Ha,qh="Define evaluation method 📝",yr,is,hr,P,We,Gn,os,QM,Na,Ph="Evaluate our agent 📈",cr,rs,wr,K,Ee,Zn,ps,$M,Va,Kh="Publish our trained model on the Hub 🔥",mr,Ms,Dh="Here’s an example of a Model Card:",Jr,Ra,Oh,Tr,D,He,An,ys,YM,Qa,ec="Push to the Hub",Ur,O,Ne,_n,hs,zM,$a,tc="Do not modify this code",ur,cs,dr,ws,jr,ms,Ir,Js,lc="By using <code>push_to_hub</code>, <strong>you evaluate, record a replay, generate a model card of your agent, and push it to the Hub</strong>.",Cr,Ts,sc="This way:",fr,Us,ac='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share an agent with the community that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',vr,us,nc="To be able to share your model with the community there are three more steps to follow:",br,ds,ic='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',gr,js,oc="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",Br,Is,rc='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Gr,Cs,pc,Zr,fs,Ar,vs,Mc="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code> (or <code>login</code>)",_r,bs,yc="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",kr,gs,Sr,Bs,hc="Now that we tested the robustness of our implementation, let’s try a more complex environment: PixelCopter 🚁",Xr,ee,Ve,kn,Gs,FM,Ya,cc="Second agent: PixelCopter 🚁",xr,te,Re,Sn,Zs,LM,za,wc="Study the PixelCopter environment 👀",Wr,As,Er,_s,Hr,ks,Nr,Ss,mc="The observation space (7) 👀:",Vr,Xs,Jc="<li>player y position</li> <li>player velocity</li> <li>player distance to floor</li> <li>player distance to ceiling</li> <li>next block x distance to player</li> <li>next blocks top y location</li> <li>next blocks bottom y location</li>",Rr,xs,Tc="The action space(2) 🎮:",Qr,Ws,Uc="<li>Up (press accelerator)</li> <li>Do nothing (don’t press accelerator)</li>",$r,Es,uc="The reward function 💰:",Yr,Hs,dc="<li>For each vertical block it passes, it gains a positive reward of +1. Each time a terminal state is reached it receives a negative reward of -1.</li>",zr,le,Qe,Xn,Ns,qM,Fa,jc="Define the new Policy 🧠",Fr,Vs,Lr,se,$e,xn,Rs,PM,La,Ic="Solution",qr,Qs,Pr,ae,Ye,Wn,$s,KM,qa,Cc="Define the hyperparameters ⚙️",Kr,Ys,Dr,ne,ze,En,zs,DM,Pa,fc="Train it",Or,Fs,ep,Ls,tp,ie,Fe,Hn,qs,OM,Ka,vc="Publish our trained model on the Hub 🔥",lp,Ps,sp,oe,Le,Nn,Ks,ey,Da,bc="Some additional challenges 🏆",ap,Ds,gc="The best way to learn <strong>is to try things on your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. But also try to find better parameters.",np,Os,Bc='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',ip,ea,Gc="Here are some ideas to climb up the leaderboard:",op,ta,Zc=`<li>Train more steps</li> <li>Try different hyperparameters by looking at what your classmates have done 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a></li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li> <li><strong>Improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?</li>`,rp,pp,Mp,la,Ac=`<strong>Congrats on finishing this unit</strong>! There was a lot of information.
And congrats on finishing the tutorial. You’ve just coded your first Deep Reinforcement Learning agent from scratch using PyTorch and shared it on the Hub 🥳.`,yp,sa,_c=`Don’t hesitate to iterate on this unit <strong>by improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?`,hp,aa,kc=`In the next unit, <strong>we’re going to learn more about Unity MLAgents</strong>, by training agents in Unity environments. This way, you will be ready to participate in the <strong>AI vs AI challenges where you’ll train your agents
to compete against other agents in a snowball fight and a soccer game.</strong>`,cp,na,Sc="Sound fun? See you next time!",wp,ia,Xc='Finally, we would love <strong>to hear what you think of the course and how we can improve it</strong>. If you have some feedback then please 👉  <a href="https://forms.gle/BzKXWzLAGZESGNaE9" rel="nofollow">fill this form</a>',mp,oa,xc="See you in Unit 5! 🔥",Jp,re,qe,Vn,ra,ty,Oa,Wc="Keep Learning, stay awesome 🤗",Tp,Rn,Up;return Ke=new U({}),De=new um({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit4/unit4.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),yt=new U({}),dt=new U({}),It=new U({}),vt=new U({}),Bt=new U({}),At=new U({}),_t=new U({}),Xt=new U({}),Nt=new U({}),Qt=new u({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcCUyMGluc3RhbGwlMjBweXZpcnR1YWxkaXNwbGF5JTBBIXBpcCUyMGluc3RhbGwlMjBweWdsZXQlM0QlM0QxLjUuMQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip install pyvirtualdisplay
!pip install pyglet==<span class="hljs-number">1.5</span><span class="hljs-number">.1</span>`,wrap:!1}}),$t=new u({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),Yt=new U({}),el=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtciUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGVlcC1ybC1jbGFzcyUyRm1haW4lMkZub3RlYm9va3MlMkZ1bml0NCUyRnJlcXVpcmVtZW50cy11bml0NC50eHQ=",highlighted:"!pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit4/requirements-unit4.txt",wrap:!1}}),tl=new U({}),al=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVxdWUlMEElMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTI1bWF0cGxvdGxpYiUyMGlubGluZSUwQSUwQSUyMyUyMFB5VG9yY2glMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBhcyUyMEYlMEFpbXBvcnQlMjB0b3JjaC5vcHRpbSUyMGFzJTIwb3B0aW0lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0aW9ucyUyMGltcG9ydCUyMENhdGVnb3JpY2FsJTBBJTBBJTIzJTIwR3ltJTBBaW1wb3J0JTIwZ3ltJTBBaW1wb3J0JTIwZ3ltX3B5Z2FtZSUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEFpbXBvcnQlMjBpbWFnZWlv",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> deque

<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
%matplotlib inline

<span class="hljs-comment"># PyTorch</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torch.optim <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> torch.distributions <span class="hljs-keyword">import</span> Categorical

<span class="hljs-comment"># Gym</span>
<span class="hljs-keyword">import</span> gym
<span class="hljs-keyword">import</span> gym_pygame

<span class="hljs-comment"># Hugging Face Hub</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>
<span class="hljs-keyword">import</span> imageio`,wrap:!1}}),nl=new U({}),ol=new u({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElM0EwJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMik=",highlighted:'device = torch.device(<span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)',wrap:!1}}),rl=new u({props:{code:"cHJpbnQoZGV2aWNlKQ==",highlighted:'<span class="hljs-built_in">print</span>(device)',wrap:!1}}),Ml=new U({}),yl=new U({}),hl=new U({}),cl=new U({}),Tl=new U({}),Cl=new u({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyQ2FydFBvbGUtdjElMjIlMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBlbnYlMEFlbnYlMjAlM0QlMjBneW0ubWFrZShlbnZfaWQpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGVudiUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;CartPole-v1&quot;</span>
<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Create the evaluation env</span>
eval_env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),fl=new u({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),vl=new u({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),bl=new U({}),_l=new u({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMHR3byUyMGZ1bGx5JTIwY29ubmVjdGVkJTIwbGF5ZXJzJTBBJTBBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHN0YXRlJTIwZ29lcyUyMHRvJTIwZmMxJTIwdGhlbiUyMHdlJTIwYXBwbHklMjBSZUxVJTIwYWN0aXZhdGlvbiUyMGZ1bmN0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZmMxJTIwb3V0cHV0cyUyMGdvZXMlMjB0byUyMGZjMiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwb3V0cHV0JTIwdGhlJTIwc29mdG1heCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR2l2ZW4lMjBhJTIwc3RhdGUlMkMlMjB0YWtlJTIwYWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG5wLmFyZ21heChtKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Create two fully connected layers</span>



    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward pass</span>
        <span class="hljs-comment"># state goes to fc1 then we apply ReLU activation function</span>

        <span class="hljs-comment"># fc1 outputs goes to fc2</span>

        <span class="hljs-comment"># We output the softmax</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Given a state, take action
        &quot;&quot;&quot;</span>
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),kl=new U({}),Sl=new u({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBucC5hcmdtYXgobSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Wl=new u({props:{code:"ZGVidWdfcG9saWN5JTIwJTNEJTIwUG9saWN5KHNfc2l6ZSUyQyUyMGFfc2l6ZSUyQyUyMDY0KS50byhkZXZpY2UpJTBBZGVidWdfcG9saWN5LmFjdChlbnYucmVzZXQoKSk=",highlighted:`debug_policy = Policy(s_size, a_size, <span class="hljs-number">64</span>).to(device)
debug_policy.act(env.reset())`,wrap:!1}}),Nl=new U({}),Vl=new u({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBtLnNhbXBsZSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9uLml0ZW0oKSUyQyUyMG0ubG9nX3Byb2IoYWN0aW9uKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),$l=new U({}),Dl=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes+<span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> reset the environment</span>
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = <span class="hljs-comment"># TODO get the action</span>
            saved_log_probs.append(log_prob)
            state, reward, done, _ = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> take an env step</span>
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>

        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>


        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = (returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns)&gt;<span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>)
            returns.appendleft(    ) <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> complete here</span>

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()

        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Episode {}\\tAverage Score: {:.2f}&#x27;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),Ol=new U({}),es=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes + <span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = env.reset()
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = policy.act(state)
            saved_log_probs.append(log_prob)
            state, reward, done, _ = env.step(action)
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as</span>
        <span class="hljs-comment">#      the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>

        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>
            returns.appendleft(gamma * disc_return_t + rewards[t])

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()
        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Episode {}\\tAverage Score: {:.2f}&quot;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),ts=new U({}),ls=new u({props:{code:"Y2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3QlMjIlM0ElMjAxMDAwJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjAxLjAlMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`cartpole_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">16</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),ss=new u({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBY2FydHBvbGVfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBY2FydHBvbGVfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShjYXJ0cG9sZV9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
cartpole_policy = Policy(
    cartpole_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
cartpole_optimizer = optim.Adam(cartpole_policy.parameters(), lr=cartpole_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),as=new u({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwJTJDJTBBKQ==",highlighted:`scores = reinforce(
    cartpole_policy,
    cartpole_optimizer,
    cartpole_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">100</span>,
)`,wrap:!1}}),ns=new U({}),is=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_agent</span>(<span class="hljs-params">env, max_steps, n_eval_episodes, policy</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param policy: The Reinforce agent
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_eval_episodes):
        state = env.reset()
        step = <span class="hljs-number">0</span>
        done = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            action, _ = policy.act(state)
            new_state, reward, done, info = env.step(action)
            total_rewards_ep += reward

            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward`,wrap:!1}}),os=new U({}),rs=new u({props:{code:"ZXZhbHVhdGVfYWdlbnQoJTBBJTIwJTIwJTIwJTIwZXZhbF9lbnYlMkMlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiU1RCUyQyUyMGNhcnRwb2xlX3BvbGljeSUwQSk=",highlighted:`evaluate_agent(
    eval_env, cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>], cartpole_hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>], cartpole_policy
)`,wrap:!1}}),ps=new U({}),ys=new U({}),hs=new U({}),cs=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwc25hcHNob3RfZG93bmxvYWQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQlMkMlMjBtZXRhZGF0YV9zYXZlJTBBJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjBqc29uJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQWltcG9ydCUyMHRlbXBmaWxlJTBBJTBBaW1wb3J0JTIwb3M=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, snapshot_download
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> imageio

<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> os`,wrap:!1}}),ws=new u({props:{code:"ZGVmJTIwcmVjb3JkX3ZpZGVvKGVudiUyQyUyMHBvbGljeSUyQyUyMG91dF9kaXJlY3RvcnklMkMlMjBmcHMlM0QzMCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMGElMjByZXBsYXklMjB2aWRlbyUyMG9mJTIwdGhlJTIwYWdlbnQlMEElMjAlMjAlMjAlMjAlM0FwYXJhbSUyMGVudiUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwUXRhYmxlJTNBJTIwUXRhYmxlJTIwb2YlMjBvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwb3V0X2RpcmVjdG9yeSUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZnBzJTNBJTIwaG93JTIwbWFueSUyMGZyYW1lJTIwcGVyJTIwc2Vjb25kcyUyMCh3aXRoJTIwdGF4aS12MyUyMGFuZCUyMGZyb3plbmxha2UtdjElMjB3ZSUyMHVzZSUyMDEpJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZG9uZSUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjB3aGlsZSUyMG5vdCUyMGRvbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGluZGV4KSUyMHRoYXQlMjBoYXZlJTIwdGhlJTIwbWF4aW11bSUyMGV4cGVjdGVkJTIwZnV0dXJlJTIwcmV3YXJkJTIwZ2l2ZW4lMjB0aGF0JTIwc3RhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMkMlMjBfJTIwJTNEJTIwcG9saWN5LmFjdChzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyQyUyMHJld2FyZCUyQyUyMGRvbmUlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUyMCUyMCUyMyUyMFdlJTIwZGlyZWN0bHklMjBwdXQlMjBuZXh0X3N0YXRlJTIwJTNEJTIwc3RhdGUlMjBmb3IlMjByZWNvcmRpbmclMjBsb2dpYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjBpbWFnZWlvLm1pbXNhdmUob3V0X2RpcmVjdG9yeSUyQyUyMCU1Qm5wLmFycmF5KGltZyklMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSU1RCUyQyUyMGZwcyUzRGZwcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, policy, out_directory, fps=<span class="hljs-number">30</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a replay video of the agent
    :param env
    :param Qtable: Qtable of our agent
    :param out_directory
    :param fps: how many frame per seconds (with taxi-v3 and frozenlake-v1 we use 1)
    &quot;&quot;&quot;</span>
    images = []
    done = <span class="hljs-literal">False</span>
    state = env.reset()
    img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action, _ = policy.act(state)
        state, reward, done, info = env.step(action)  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)`,wrap:!1}}),ms=new u({props:{code:"ZGVmJTIwcHVzaF90b19odWIocmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHlwZXJwYXJhbWV0ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb19mcHMlM0QzMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjIlMjIlMjIlMEElMjAlMjBFdmFsdWF0ZSUyQyUyMEdlbmVyYXRlJTIwYSUyMHZpZGVvJTIwYW5kJTIwVXBsb2FkJTIwYSUyMG1vZGVsJTIwdG8lMjBIdWdnaW5nJTIwRmFjZSUyMEh1Yi4lMEElMjAlMjBUaGlzJTIwbWV0aG9kJTIwZG9lcyUyMHRoZSUyMGNvbXBsZXRlJTIwcGlwZWxpbmUlM0ElMEElMjAlMjAtJTIwSXQlMjBldmFsdWF0ZXMlMjB0aGUlMjBtb2RlbCUwQSUyMCUyMC0lMjBJdCUyMGdlbmVyYXRlcyUyMHRoZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMC0lMjBJdCUyMGdlbmVyYXRlcyUyMGElMjByZXBsYXklMjB2aWRlbyUyMG9mJTIwdGhlJTIwYWdlbnQlMEElMjAlMjAtJTIwSXQlMjBwdXNoZXMlMjBldmVyeXRoaW5nJTIwdG8lMjB0aGUlMjBIdWIlMEElMEElMjAlMjAlM0FwYXJhbSUyMHJlcG9faWQlM0ElMjByZXBvX2lkJTNBJTIwaWQlMjBvZiUyMHRoZSUyMG1vZGVsJTIwcmVwb3NpdG9yeSUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQSUyMCUyMCUzQXBhcmFtJTIwbW9kZWwlM0ElMjB0aGUlMjBweXRvcmNoJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlM0FwYXJhbSUyMGh5cGVycGFyYW1ldGVycyUzQSUyMHRyYWluaW5nJTIwaHlwZXJwYXJhbWV0ZXJzJTBBJTIwJTIwJTNBcGFyYW0lMjBldmFsX2VudiUzQSUyMGV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUzQXBhcmFtJTIwdmlkZW9fZnBzJTNBJTIwaG93JTIwbWFueSUyMGZyYW1lJTIwcGVyJTIwc2Vjb25kcyUyMHRvJTIwcmVjb3JkJTIwb3VyJTIwdmlkZW8lMjByZXBsYXklMEElMjAlMjAlMjIlMjIlMjIlMEElMEElMjAlMjBfJTJDJTIwcmVwb19uYW1lJTIwJTNEJTIwcmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTBBJTIwJTIwYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQSUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwQ3JlYXRlJTIwdGhlJTIwcmVwbyUwQSUyMCUyMHJlcG9fdXJsJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhpc3Rfb2slM0RUcnVlJTJDJTBBJTIwJTIwKSUwQSUwQSUyMCUyMHdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wZGlybmFtZSUzQSUwQSUyMCUyMCUyMCUyMGxvY2FsX2RpcmVjdG9yeSUyMCUzRCUyMFBhdGgodG1wZGlybmFtZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMiUzQSUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwlMkMlMjBsb2NhbF9kaXJlY3RvcnklMjAlMkYlMjAlMjJtb2RlbC5wdCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMyUzQSUyMFNhdmUlMjB0aGUlMjBoeXBlcnBhcmFtZXRlcnMlMjB0byUyMEpTT04lMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihsb2NhbF9kaXJlY3RvcnklMjAlMkYlMjAlMjJoeXBlcnBhcmFtZXRlcnMuanNvbiUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBvdXRmaWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwanNvbi5kdW1wKGh5cGVycGFyYW1ldGVycyUyQyUyMG91dGZpbGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDQlM0ElMjBFdmFsdWF0ZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwYnVpbGQlMjBKU09OJTBBJTIwJTIwJTIwJTIwbWVhbl9yZXdhcmQlMkMlMjBzdGRfcmV3YXJkJTIwJTNEJTIwZXZhbHVhdGVfYWdlbnQoZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyU1QiUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMGRhdGV0aW1lJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRldGltZSUyMCUzRCUyMGRhdGV0aW1lLmRhdGV0aW1lLm5vdygpJTBBJTIwJTIwJTIwJTIwZXZhbF9mb3JtX2RhdGV0aW1lJTIwJTNEJTIwZXZhbF9kYXRldGltZS5pc29mb3JtYXQoKSUwQSUwQSUyMCUyMCUyMCUyMGV2YWx1YXRlX2RhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBoeXBlcnBhcmFtZXRlcnMlNUIlMjJlbnZfaWQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZWFuX3Jld2FyZCUyMiUzQSUyMG1lYW5fcmV3YXJkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybl9ldmFsdWF0aW9uX2VwaXNvZGVzJTIyJTNBJTIwaHlwZXJwYXJhbWV0ZXJzJTVCJTIybl9ldmFsdWF0aW9uX2VwaXNvZGVzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXZhbF9kYXRldGltZSUyMiUzQSUyMGV2YWxfZm9ybV9kYXRldGltZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFdyaXRlJTIwYSUyMEpTT04lMjBmaWxlJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4obG9jYWxfZGlyZWN0b3J5JTIwJTJGJTIwJTIycmVzdWx0cy5qc29uJTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMG91dGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uLmR1bXAoZXZhbHVhdGVfZGF0YSUyQyUyMG91dGZpbGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDUlM0ElMjBDcmVhdGUlMjB0aGUlMjBtb2RlbCUyMGNhcmQlMEElMjAlMjAlMjAlMjBlbnZfbmFtZSUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyU1QiUyMmVudl9pZCUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElNUIlMjJ0YWdzJTIyJTVEJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWluZm9yY2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWluZm9yY2VtZW50LWxlYXJuaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VzdG9tLWltcGxlbWVudGF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVlcC1ybC1jbGFzcyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFkZCUyMG1ldHJpY3MlMEElMjAlMjAlMjAlMjBldmFsJTIwJTNEJTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfcHJldHR5X25hbWUlM0RyZXBvX25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3ByZXR0eV9uYW1lJTNEJTIycmVpbmZvcmNlbWVudC1sZWFybmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tfaWQlM0QlMjJyZWluZm9yY2VtZW50LWxlYXJuaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljc19wcmV0dHlfbmFtZSUzRCUyMm1lYW5fcmV3YXJkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljc19pZCUzRCUyMm1lYW5fcmV3YXJkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljc192YWx1ZSUzRGYlMjIlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTNBLjJmJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF9wcmV0dHlfbmFtZSUzRGVudl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF9pZCUzRGVudl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME1lcmdlcyUyMGJvdGglMjBkaWN0aW9uYXJpZXMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YSUyMCUzRCUyMCU3QioqbWV0YWRhdGElMkMlMjAqKmV2YWwlN0QlMEElMEElMjAlMjAlMjAlMjBtb2RlbF9jYXJkJTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMyUyMCoqUmVpbmZvcmNlKiolMjBBZ2VudCUyMHBsYXlpbmclMjAqKiU3QmVudl9pZCU3RCoqJTBBJTIwJTIwVGhpcyUyMGlzJTIwYSUyMHRyYWluZWQlMjBtb2RlbCUyMG9mJTIwYSUyMCoqUmVpbmZvcmNlKiolMjBhZ2VudCUyMHBsYXlpbmclMjAqKiU3QmVudl9pZCU3RCoqJTIwLiUwQSUyMCUyMFRvJTIwbGVhcm4lMjB0byUyMHVzZSUyMHRoaXMlMjBtb2RlbCUyMGFuZCUyMHRyYWluJTIweW91cnMlMjBjaGVjayUyMFVuaXQlMjA0JTIwb2YlMjB0aGUlMjBEZWVwJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTIwQ291cnNlJTNBJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRlZXAtcmwtY291cnNlJTJGdW5pdDQlMkZpbnRyb2R1Y3Rpb24lMEElMjAlMjAlMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjByZWFkbWVfcGF0aCUyMCUzRCUyMGxvY2FsX2RpcmVjdG9yeSUyMCUyRiUyMCUyMlJFQURNRS5tZCUyMiUwQSUyMCUyMCUyMCUyMHJlYWRtZSUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwcmVhZG1lX3BhdGguZXhpc3RzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwcmVhZG1lX3BhdGgub3BlbiglMjJyJTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGY4JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlYWRtZSUyMCUzRCUyMGYucmVhZCgpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlYWRtZSUyMCUzRCUyMG1vZGVsX2NhcmQlMEElMEElMjAlMjAlMjAlMjB3aXRoJTIwcmVhZG1lX3BhdGgub3BlbiglMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKHJlYWRtZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwb3VyJTIwbWV0cmljcyUyMHRvJTIwUmVhZG1lJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9zYXZlKHJlYWRtZV9wYXRoJTJDJTIwbWV0YWRhdGEpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDYlM0ElMjBSZWNvcmQlMjBhJTIwdmlkZW8lMEElMjAlMjAlMjAlMjB2aWRlb19wYXRoJTIwJTNEJTIwJTIwbG9jYWxfZGlyZWN0b3J5JTIwJTJGJTIwJTIycmVwbGF5Lm1wNCUyMiUwQSUyMCUyMCUyMCUyMHJlY29yZF92aWRlbyhlbnYlMkMlMjBtb2RlbCUyQyUyMHZpZGVvX3BhdGglMkMlMjB2aWRlb19mcHMpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDcuJTIwUHVzaCUyMGV2ZXJ5dGhpbmclMjB0byUyMHRoZSUyMEh1YiUwQSUyMCUyMCUyMCUyMGFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0Rsb2NhbF9kaXJlY3RvcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJZb3VyJTIwbW9kZWwlMjBpcyUyMHB1c2hlZCUyMHRvJTIwdGhlJTIwSHViLiUyMFlvdSUyMGNhbiUyMHZpZXclMjB5b3VyJTIwbW9kZWwlMjBoZXJlJTNBJTIwJTdCcmVwb191cmwlN0QlMjIp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">repo_id,
                model,
                hyperparameters,
                eval_env,
                video_fps=<span class="hljs-number">30</span>
                </span>):
  <span class="hljs-string">&quot;&quot;&quot;
  Evaluate, Generate a video and Upload a model to Hugging Face Hub.
  This method does the complete pipeline:
  - It evaluates the model
  - It generates the model card
  - It generates a replay video of the agent
  - It pushes everything to the Hub

  :param repo_id: repo_id: id of the model repository from the Hugging Face Hub
  :param model: the pytorch model we want to save
  :param hyperparameters: training hyperparameters
  :param eval_env: evaluation environment
  :param video_fps: how many frame per seconds to record our video replay
  &quot;&quot;&quot;</span>

  _, repo_name = repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)
  api = HfApi()

  <span class="hljs-comment"># Step 1: Create the repo</span>
  repo_url = api.create_repo(
        repo_id=repo_id,
        exist_ok=<span class="hljs-literal">True</span>,
  )

  <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdirname:
    local_directory = Path(tmpdirname)

    <span class="hljs-comment"># Step 2: Save the model</span>
    torch.save(model, local_directory / <span class="hljs-string">&quot;model.pt&quot;</span>)

    <span class="hljs-comment"># Step 3: Save the hyperparameters to JSON</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;hyperparameters.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
      json.dump(hyperparameters, outfile)

    <span class="hljs-comment"># Step 4: Evaluate the model and build JSON</span>
    mean_reward, std_reward = evaluate_agent(eval_env,
                                            hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
                                            hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
                                            model)
    <span class="hljs-comment"># Get datetime</span>
    eval_datetime = datetime.datetime.now()
    eval_form_datetime = eval_datetime.isoformat()

    evaluate_data = {
          <span class="hljs-string">&quot;env_id&quot;</span>: hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>],
          <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
          <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
          <span class="hljs-string">&quot;eval_datetime&quot;</span>: eval_form_datetime,
    }

    <span class="hljs-comment"># Write a JSON file</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
        json.dump(evaluate_data, outfile)

    <span class="hljs-comment"># Step 5: Create the model card</span>
    env_name = hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>]

    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [
          env_name,
          <span class="hljs-string">&quot;reinforce&quot;</span>,
          <span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
          <span class="hljs-string">&quot;custom-implementation&quot;</span>,
          <span class="hljs-string">&quot;deep-rl-class&quot;</span>
      ]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=repo_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_name,
        dataset_id=env_name,
      )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # **Reinforce** Agent playing **<span class="hljs-subst">{env_id}</span>**
  This is a trained model of a **Reinforce** agent playing **<span class="hljs-subst">{env_id}</span>** .
  To learn to use this model and train yours check Unit 4 of the Deep Reinforcement Learning Course: https://huggingface.co/deep-rl-course/unit4/introduction
  &quot;&quot;&quot;</span>

    readme_path = local_directory / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
          readme = f.read()
    <span class="hljs-keyword">else</span>:
      readme = model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
      f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)

    <span class="hljs-comment"># Step 6: Record a video</span>
    video_path =  local_directory / <span class="hljs-string">&quot;replay.mp4&quot;</span>
    record_video(env, model, video_path, video_fps)

    <span class="hljs-comment"># Step 7. Push everything to the Hub</span>
    api.upload_folder(
          repo_id=repo_id,
          folder_path=local_directory,
          path_in_repo=<span class="hljs-string">&quot;.&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Your model is pushed to the Hub. You can view your model here: <span class="hljs-subst">{repo_url}</span>&quot;</span>)`,wrap:!1}}),fs=new u({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),gs=new u({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    cartpole_policy,  <span class="hljs-comment"># The model we want to save</span>
    cartpole_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),Gs=new U({}),Zs=new U({}),As=new u({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGl4ZWxjb3B0ZXItUExFLXYwJTIyJTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;Pixelcopter-PLE-v0&quot;</span>
env = gym.make(env_id)
eval_env = gym.make(env_id)
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),_s=new u({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),ks=new u({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Ns=new U({}),Vs=new u({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRocmVlJTIwbGF5ZXJzJTIwaGVyZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGVmaW5lJTIwdGhlJTIwZm9yd2FyZCUyMHByb2Nlc3MlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zb2Z0bWF4KHglMkMlMjBkaW0lM0QxKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG0uc2FtcGxlKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Define the three layers here</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward process here</span>
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Rs=new U({}),Qs=new u({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBoX3NpemUlMjAqJTIwMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMyUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMjAqJTIwMiUyQyUyMGFfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBGLnJlbHUoc2VsZi5mYzEoeCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMEYucmVsdShzZWxmLmZjMih4KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5mYzMoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBGLnNvZnRtYXgoeCUyQyUyMGRpbSUzRDEpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwYWN0KHNlbGYlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoc3RhdGUpLmZsb2F0KCkudW5zcXVlZXplKDApLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9icyUyMCUzRCUyMHNlbGYuZm9yd2FyZChzdGF0ZSkuY3B1KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtJTIwJTNEJTIwQ2F0ZWdvcmljYWwocHJvYnMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwbS5zYW1wbGUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, h_size * <span class="hljs-number">2</span>)
        self.fc3 = nn.Linear(h_size * <span class="hljs-number">2</span>, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),$s=new U({}),Ys=new u({props:{code:"cGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwNjQlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwNTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJuX2V2YWx1YXRpb25fZXBpc29kZXMlMjIlM0ElMjAxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90JTIyJTNBJTIwMTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJnYW1tYSUyMiUzQSUyMDAuOTklMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`pixelcopter_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">64</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">50000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">10000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">0.99</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-4</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),zs=new U({}),Fs=new u({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBJTIzJTIwdG9yY2gubWFudWFsX3NlZWQoNTApJTBBcGl4ZWxjb3B0ZXJfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBcGl4ZWxjb3B0ZXJfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShwaXhlbGNvcHRlcl9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
<span class="hljs-comment"># torch.manual_seed(50)</span>
pixelcopter_policy = Policy(
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
pixelcopter_optimizer = optim.Adam(pixelcopter_policy.parameters(), lr=pixelcopter_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),Ls=new u({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwMCUyQyUwQSk=",highlighted:`scores = reinforce(
    pixelcopter_policy,
    pixelcopter_optimizer,
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">1000</span>,
)`,wrap:!1}}),qs=new U({}),Ps=new u({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    pixelcopter_policy,  <span class="hljs-comment"># The model we want to save</span>
    pixelcopter_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),Ks=new U({}),ra=new U({}),{c(){f=a("meta"),Yn=i(),ln=a("p"),zn=i(),v=a("h1"),pe=a("a"),sn=a("span"),h(Ke.$$.fragment),iM=i(),pa=a("span"),pa.textContent=ny,Fn=i(),h(De.$$.fragment),Ln=i(),Oe=a("p"),Oe.innerHTML=iy,qn=i(),et=a("p"),et.textContent=oy,Pn=i(),Me=a("figure"),Me.innerHTML=ry,Kn=i(),tt=a("p"),tt.textContent=py,Dn=i(),lt=a("ul"),lt.innerHTML=My,On=i(),st=a("p"),st.innerHTML=yy,ei=i(),at=a("p"),at.innerHTML=hy,ti=i(),nt=a("p"),nt.innerHTML=cy,li=i(),it=a("p"),it.innerHTML=wy,si=i(),ot=a("p"),ot.innerHTML=my,ai=i(),rt=a("p"),rt.innerHTML=Jy,ni=i(),pt=a("p"),pt.innerHTML=Ty,ii=i(),Mt=a("p"),Mt.innerHTML=Uy,oi=i(),b=a("h1"),ye=a("a"),an=a("span"),h(yt.$$.fragment),oM=i(),Ma=a("span"),Ma.textContent=uy,ri=i(),ht=a("img"),pi=i(),ct=a("p"),ct.textContent=jy,Mi=i(),wt=a("p"),wt.innerHTML=Iy,yi=i(),mt=a("p"),mt.innerHTML=Cy,hi=i(),Jt=a("p"),Jt.textContent=fy,ci=i(),Tt=a("ul"),Tt.innerHTML=vy,wi=i(),Ut=a("p"),Ut.innerHTML=by,mi=i(),ut=a("img"),Ji=i(),g=a("h3"),he=a("a"),nn=a("span"),h(dt.$$.fragment),rM=i(),ya=a("span"),ya.textContent=By,Ti=i(),jt=a("ul"),jt.innerHTML=Gy,Ui=i(),B=a("h3"),ce=a("a"),on=a("span"),h(It.$$.fragment),pM=i(),ha=a("span"),ha.textContent=Zy,ui=i(),Ct=a("ul"),Ct.innerHTML=Ay,di=i(),ft=a("p"),ft.innerHTML=_y,ji=i(),G=a("h2"),we=a("a"),rn=a("span"),h(vt.$$.fragment),MM=i(),ca=a("span"),ca.textContent=ky,Ii=i(),bt=a("p"),bt.textContent=Sy,Ci=i(),gt=a("ul"),gt.innerHTML=Xy,fi=i(),Z=a("h2"),me=a("a"),pn=a("span"),h(Bt.$$.fragment),yM=i(),wa=a("span"),wa.textContent=xy,vi=i(),Gt=a("p"),Gt.textContent=Wy,bi=i(),Zt=a("p"),Zt.innerHTML=Ey,gi=i(),A=a("h1"),Je=a("a"),Mn=a("span"),h(At.$$.fragment),hM=i(),ma=a("span"),ma.textContent=Hy,Bi=i(),_=a("h2"),Te=a("a"),yn=a("span"),h(_t.$$.fragment),cM=i(),Ja=a("span"),Ja.textContent=Ny,Gi=i(),kt=a("p"),kt.innerHTML=Vy,Zi=i(),St=a("p"),St.innerHTML=Ry,Ai=i(),k=a("h2"),Ue=a("a"),hn=a("span"),h(Xt.$$.fragment),wM=i(),Ta=a("span"),Ta.textContent=Qy,_i=i(),xt=a("ul"),xt.innerHTML=$y,ki=i(),Wt=a("img"),Si=i(),Et=a("ul"),Et.innerHTML=zy,Xi=i(),Ht=a("img"),xi=i(),S=a("h2"),ue=a("a"),cn=a("span"),h(Nt.$$.fragment),mM=i(),Ua=a("span"),Ua.textContent=Ly,Wi=i(),Vt=a("p"),Vt.innerHTML=qy,Ei=i(),Rt=a("p"),Rt.textContent=Py,Hi=i(),h(Qt.$$.fragment),Ni=i(),h($t.$$.fragment),Vi=i(),X=a("h2"),de=a("a"),wn=a("span"),h(Yt.$$.fragment),JM=i(),ua=a("span"),ua.textContent=Ky,Ri=i(),zt=a("p"),zt.textContent=Dy,Qi=i(),Ft=a("ul"),Ft.innerHTML=Oy,$i=i(),Lt=a("p"),Lt.innerHTML=eh,Yi=i(),qt=a("p"),qt.textContent=th,zi=i(),Pt=a("ul"),Pt.innerHTML=lh,Fi=i(),Kt=a("p"),Kt.innerHTML=sh,Li=i(),Dt=a("p"),Dt.innerHTML=ah,qi=i(),Ot=a("p"),Ot.innerHTML=nh,Pi=i(),h(el.$$.fragment),Ki=i(),x=a("h2"),je=a("a"),mn=a("span"),h(tl.$$.fragment),TM=i(),da=a("span"),da.textContent=ih,Di=i(),ll=a("p"),ll.textContent=oh,Oi=i(),sl=a("ul"),sl.innerHTML=rh,eo=i(),h(al.$$.fragment),to=i(),W=a("h2"),Ie=a("a"),Jn=a("span"),h(nl.$$.fragment),UM=i(),ja=a("span"),ja.textContent=ph,lo=i(),il=a("ul"),il.innerHTML=Mh,so=i(),h(ol.$$.fragment),ao=i(),h(rl.$$.fragment),no=i(),pl=a("p"),pl.textContent=yh,io=i(),E=a("h1"),Ce=a("a"),Tn=a("span"),h(Ml.$$.fragment),uM=i(),Ia=a("span"),Ia.textContent=hh,oo=i(),H=a("h2"),fe=a("a"),Un=a("span"),h(yl.$$.fragment),dM=i(),Ca=a("span"),Ca.textContent=ch,ro=i(),N=a("h3"),ve=a("a"),un=a("span"),h(hl.$$.fragment),jM=i(),fa=a("span"),fa.textContent=wh,po=i(),V=a("h3"),be=a("a"),dn=a("span"),h(cl.$$.fragment),IM=i(),va=a("span"),va.textContent=mh,Mo=i(),wl=a("p"),wl.innerHTML=Jh,yo=i(),ml=a("blockquote"),ml.innerHTML=Th,ho=i(),Jl=a("blockquote"),Jl.innerHTML=Uh,co=i(),R=a("h3"),ge=a("a"),jn=a("span"),h(Tl.$$.fragment),CM=i(),ba=a("span"),ba.textContent=uh,wo=i(),Ul=a("blockquote"),Ul.innerHTML=dh,mo=i(),ul=a("p"),ul.innerHTML=jh,Jo=i(),dl=a("p"),dl.textContent=Ih,To=i(),jl=a("ul"),jl.innerHTML=Ch,Uo=i(),Il=a("p"),Il.textContent=fh,uo=i(),h(Cl.$$.fragment),jo=i(),h(fl.$$.fragment),Io=i(),h(vl.$$.fragment),Co=i(),Q=a("h2"),Be=a("a"),In=a("span"),h(bl.$$.fragment),fM=i(),ga=a("span"),ga.textContent=vh,fo=i(),gl=a("p"),gl.textContent=bh,vo=i(),Bl=a("ul"),Bl.innerHTML=gh,bo=i(),Gl=a("img"),go=i(),Zl=a("p"),Zl.textContent=Gh,Bo=i(),Al=a("ul"),Al.innerHTML=Zh,Go=i(),h(_l.$$.fragment),Zo=i(),$=a("h3"),Ge=a("a"),Cn=a("span"),h(kl.$$.fragment),vM=i(),Ba=a("span"),Ba.textContent=Ah,Ao=i(),h(Sl.$$.fragment),_o=i(),Xl=a("p"),Xl.textContent=_h,ko=i(),xl=a("ul"),xl.innerHTML=kh,So=i(),h(Wl.$$.fragment),Xo=i(),El=a("ul"),El.innerHTML=Sh,xo=i(),Hl=a("p"),Hl.innerHTML=Xh,Wo=i(),Y=a("h3"),Ze=a("a"),fn=a("span"),h(Nl.$$.fragment),bM=i(),Ga=a("span"),Ga.textContent=xh,Eo=i(),h(Vl.$$.fragment),Ho=i(),Rl=a("p"),Rl.innerHTML=Wh,No=i(),Ql=a("ul"),Ql.innerHTML=Eh,Vo=i(),z=a("h3"),Ae=a("a"),vn=a("span"),h($l.$$.fragment),gM=i(),Za=a("span"),Za.textContent=Hh,Ro=d(`


This is the Reinforce algorithm pseudocode:
`),Yl=a("img"),Qo=i(),zl=a("ul"),zl.innerHTML=Vh,$o=i(),Fl=a("p"),Fl.innerHTML=Rh,Yo=i(),Ll=a("p"),Ll.innerHTML=Qh,zo=i(),Aa=a("ul"),ql=a("li"),BM=d("We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),_a=a("strong"),_a.textContent=$h,I=a("ul"),ka=a("li"),ka.textContent=Yh,GM=i(),_e=a("li"),ZM=d("So we want to modify "),Fo=new en(!1),Lo=d(" such that "),qo=new en(!1),AM=i(),ke=a("li"),_M=d("Because all P must sum to 1, max "),Po=new en(!1),Ko=d(" will "),Sa=a("strong"),Sa.textContent=zh,kM=i(),Xa=a("li"),SM=d("So we should tell PyTorch "),Pl=a("strong"),XM=d("to min "),Do=new en(!1),Oo=d("."),xM=i(),Kl=a("li"),WM=d("This loss function approaches 0 as "),er=new en(!1),tr=d(" nears 1."),EM=i(),xa=a("li"),HM=d("So we are encouraging the gradient to max "),lr=new en(!1),sr=i(),h(Dl.$$.fragment),ar=i(),F=a("h4"),Se=a("a"),bn=a("span"),h(Ol.$$.fragment),NM=i(),Wa=a("span"),Wa.textContent=Fh,nr=i(),h(es.$$.fragment),ir=i(),L=a("h2"),Xe=a("a"),gn=a("span"),h(ts.$$.fragment),VM=i(),Ea=a("span"),Ea.textContent=Lh,or=d(`


- We're now ready to train our agent.
- But first, we define a variable containing all the training hyperparameters.
- You can change the training parameters (and should 😉)

	`),h(ls.$$.fragment),rr=i(),h(ss.$$.fragment),pr=i(),h(as.$$.fragment),Mr=i(),q=a("h2"),xe=a("a"),Bn=a("span"),h(ns.$$.fragment),RM=i(),Ha=a("span"),Ha.textContent=qh,yr=d(`


- Here we define the evaluation method that we're going to use to test our Reinforce agent.

	`),h(is.$$.fragment),hr=i(),P=a("h2"),We=a("a"),Gn=a("span"),h(os.$$.fragment),QM=i(),Na=a("span"),Na.textContent=Ph,cr=i(),h(rs.$$.fragment),wr=i(),K=a("h3"),Ee=a("a"),Zn=a("span"),h(ps.$$.fragment),$M=i(),Va=a("span"),Va.textContent=Kh,mr=d(`


Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.
`),Ms=a("p"),Ms.textContent=Dh,Jr=i(),Ra=a("img"),Tr=i(),D=a("h3"),He=a("a"),An=a("span"),h(ys.$$.fragment),YM=i(),Qa=a("span"),Qa.textContent=ec,Ur=i(),O=a("h4"),Ne=a("a"),_n=a("span"),h(hs.$$.fragment),zM=i(),$a=a("span"),$a.textContent=tc,ur=i(),h(cs.$$.fragment),dr=i(),h(ws.$$.fragment),jr=i(),h(ms.$$.fragment),Ir=i(),Js=a("p"),Js.innerHTML=lc,Cr=i(),Ts=a("p"),Ts.textContent=sc,fr=i(),Us=a("ul"),Us.innerHTML=ac,vr=i(),us=a("p"),us.textContent=nc,br=i(),ds=a("p"),ds.innerHTML=ic,gr=i(),js=a("p"),js.textContent=oc,Br=i(),Is=a("ul"),Is.innerHTML=rc,Gr=i(),Cs=a("img"),Zr=i(),h(fs.$$.fragment),Ar=i(),vs=a("p"),vs.innerHTML=Mc,_r=i(),bs=a("p"),bs.innerHTML=yc,kr=i(),h(gs.$$.fragment),Sr=i(),Bs=a("p"),Bs.textContent=hc,Xr=i(),ee=a("h2"),Ve=a("a"),kn=a("span"),h(Gs.$$.fragment),FM=i(),Ya=a("span"),Ya.textContent=cc,xr=i(),te=a("h3"),Re=a("a"),Sn=a("span"),h(Zs.$$.fragment),LM=i(),za=a("span"),za.textContent=wc,Wr=d(`


- [The Environment documentation](https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html)

	`),h(As.$$.fragment),Er=i(),h(_s.$$.fragment),Hr=i(),h(ks.$$.fragment),Nr=i(),Ss=a("p"),Ss.textContent=mc,Vr=i(),Xs=a("ul"),Xs.innerHTML=Jc,Rr=i(),xs=a("p"),xs.textContent=Tc,Qr=i(),Ws=a("ul"),Ws.innerHTML=Uc,$r=i(),Es=a("p"),Es.textContent=uc,Yr=i(),Hs=a("ul"),Hs.innerHTML=dc,zr=i(),le=a("h3"),Qe=a("a"),Xn=a("span"),h(Ns.$$.fragment),qM=i(),Fa=a("span"),Fa.textContent=jc,Fr=d(`


- We need to have a deeper neural network since the environment is more complex

	`),h(Vs.$$.fragment),Lr=i(),se=a("h4"),$e=a("a"),xn=a("span"),h(Rs.$$.fragment),PM=i(),La=a("span"),La.textContent=Ic,qr=i(),h(Qs.$$.fragment),Pr=i(),ae=a("h3"),Ye=a("a"),Wn=a("span"),h($s.$$.fragment),KM=i(),qa=a("span"),qa.textContent=Cc,Kr=d(`


- Because this environment is more complex.
- Especially for the hidden size, we need more neurons.

	`),h(Ys.$$.fragment),Dr=i(),ne=a("h3"),ze=a("a"),En=a("span"),h(zs.$$.fragment),DM=i(),Pa=a("span"),Pa.textContent=fc,Or=d(`


- We're now ready to train our agent 🔥.

	`),h(Fs.$$.fragment),ep=i(),h(Ls.$$.fragment),tp=i(),ie=a("h3"),Fe=a("a"),Hn=a("span"),h(qs.$$.fragment),OM=i(),Ka=a("span"),Ka.textContent=vc,lp=i(),h(Ps.$$.fragment),sp=i(),oe=a("h2"),Le=a("a"),Nn=a("span"),h(Ks.$$.fragment),ey=i(),Da=a("span"),Da.textContent=bc,ap=i(),Ds=a("p"),Ds.innerHTML=gc,np=i(),Os=a("p"),Os.innerHTML=Bc,ip=i(),ea=a("p"),ea.textContent=Gc,op=i(),ta=a("ul"),ta.innerHTML=Zc,rp=i(),pp=a("hr"),Mp=i(),la=a("p"),la.innerHTML=Ac,yp=i(),sa=a("p"),sa.innerHTML=_c,hp=i(),aa=a("p"),aa.innerHTML=kc,cp=i(),na=a("p"),na.textContent=Sc,wp=i(),ia=a("p"),ia.innerHTML=Xc,mp=i(),oa=a("p"),oa.textContent=xc,Jp=i(),re=a("h3"),qe=a("a"),Vn=a("span"),h(ra.$$.fragment),ty=i(),Oa=a("span"),Oa.textContent=Wc,Tp=i(),Rn=a("p"),this.h()},l(e){const l=Um("svelte-1phssyn",document.head);f=n(l,"META",{name:!0,content:!0}),l.forEach(t),Yn=o(e),ln=n(e,"P",{}),y(ln).forEach(t),zn=o(e),v=n(e,"H1",{class:!0});var up=y(v);pe=n(up,"A",{id:!0,class:!0,href:!0});var Ec=y(pe);sn=n(Ec,"SPAN",{});var Hc=y(sn);c(Ke.$$.fragment,Hc),Hc.forEach(t),Ec.forEach(t),iM=o(up),pa=n(up,"SPAN",{"data-svelte-h":!0}),M(pa)!=="svelte-hp103o"&&(pa.textContent=ny),up.forEach(t),Fn=o(e),c(De.$$.fragment,e),Ln=o(e),Oe=n(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-fi9d8o"&&(Oe.innerHTML=iy),qn=o(e),et=n(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-liqaak"&&(et.textContent=oy),Pn=o(e),Me=n(e,"FIGURE",{class:!0,"data-svelte-h":!0}),M(Me)!=="svelte-1dadvfq"&&(Me.innerHTML=ry),Kn=o(e),tt=n(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1u0hqjo"&&(tt.textContent=py),Dn=o(e),lt=n(e,"UL",{"data-svelte-h":!0}),M(lt)!=="svelte-qqschq"&&(lt.innerHTML=My),On=o(e),st=n(e,"P",{"data-svelte-h":!0}),M(st)!=="svelte-h6mhk8"&&(st.innerHTML=yy),ei=o(e),at=n(e,"P",{"data-svelte-h":!0}),M(at)!=="svelte-1c0nyzi"&&(at.innerHTML=hy),ti=o(e),nt=n(e,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1qkxyrx"&&(nt.innerHTML=cy),li=o(e),it=n(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-znarat"&&(it.innerHTML=wy),si=o(e),ot=n(e,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-10pdw2g"&&(ot.innerHTML=my),ai=o(e),rt=n(e,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-8tt267"&&(rt.innerHTML=Jy),ni=o(e),pt=n(e,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-uilrpw"&&(pt.innerHTML=Ty),ii=o(e),Mt=n(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-p9mrd0"&&(Mt.innerHTML=Uy),oi=o(e),b=n(e,"H1",{class:!0});var dp=y(b);ye=n(dp,"A",{id:!0,class:!0,href:!0});var Nc=y(ye);an=n(Nc,"SPAN",{});var Vc=y(an);c(yt.$$.fragment,Vc),Vc.forEach(t),Nc.forEach(t),oM=o(dp),Ma=n(dp,"SPAN",{"data-svelte-h":!0}),M(Ma)!=="svelte-38q2rz"&&(Ma.textContent=uy),dp.forEach(t),ri=o(e),ht=n(e,"IMG",{src:!0,alt:!0}),pi=o(e),ct=n(e,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-11hwml8"&&(ct.textContent=jy),Mi=o(e),wt=n(e,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-nwil7u"&&(wt.innerHTML=Iy),yi=o(e),mt=n(e,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-jsssl2"&&(mt.innerHTML=Cy),hi=o(e),Jt=n(e,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-1wpzntl"&&(Jt.textContent=fy),ci=o(e),Tt=n(e,"UL",{"data-svelte-h":!0}),M(Tt)!=="svelte-1c5irle"&&(Tt.innerHTML=vy),wi=o(e),Ut=n(e,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-4ucrls"&&(Ut.innerHTML=by),mi=o(e),ut=n(e,"IMG",{src:!0,alt:!0}),Ji=o(e),g=n(e,"H3",{class:!0});var jp=y(g);he=n(jp,"A",{id:!0,class:!0,href:!0});var Rc=y(he);nn=n(Rc,"SPAN",{});var Qc=y(nn);c(dt.$$.fragment,Qc),Qc.forEach(t),Rc.forEach(t),rM=o(jp),ya=n(jp,"SPAN",{"data-svelte-h":!0}),M(ya)!=="svelte-ul8fdn"&&(ya.textContent=By),jp.forEach(t),Ti=o(e),jt=n(e,"UL",{"data-svelte-h":!0}),M(jt)!=="svelte-1tbp2wd"&&(jt.innerHTML=Gy),Ui=o(e),B=n(e,"H3",{class:!0});var Ip=y(B);ce=n(Ip,"A",{id:!0,class:!0,href:!0});var $c=y(ce);on=n($c,"SPAN",{});var Yc=y(on);c(It.$$.fragment,Yc),Yc.forEach(t),$c.forEach(t),pM=o(Ip),ha=n(Ip,"SPAN",{"data-svelte-h":!0}),M(ha)!=="svelte-15n18n6"&&(ha.textContent=Zy),Ip.forEach(t),ui=o(e),Ct=n(e,"UL",{"data-svelte-h":!0}),M(Ct)!=="svelte-ud7zzn"&&(Ct.innerHTML=Ay),di=o(e),ft=n(e,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-qqj2y4"&&(ft.innerHTML=_y),ji=o(e),G=n(e,"H2",{class:!0});var Cp=y(G);we=n(Cp,"A",{id:!0,class:!0,href:!0});var zc=y(we);rn=n(zc,"SPAN",{});var Fc=y(rn);c(vt.$$.fragment,Fc),Fc.forEach(t),zc.forEach(t),MM=o(Cp),ca=n(Cp,"SPAN",{"data-svelte-h":!0}),M(ca)!=="svelte-ygr1lr"&&(ca.textContent=ky),Cp.forEach(t),Ii=o(e),bt=n(e,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-nsjs09"&&(bt.textContent=Sy),Ci=o(e),gt=n(e,"UL",{"data-svelte-h":!0}),M(gt)!=="svelte-14xf3th"&&(gt.innerHTML=Xy),fi=o(e),Z=n(e,"H2",{class:!0});var fp=y(Z);me=n(fp,"A",{id:!0,class:!0,href:!0});var Lc=y(me);pn=n(Lc,"SPAN",{});var qc=y(pn);c(Bt.$$.fragment,qc),qc.forEach(t),Lc.forEach(t),yM=o(fp),wa=n(fp,"SPAN",{"data-svelte-h":!0}),M(wa)!=="svelte-14bgx92"&&(wa.textContent=xy),fp.forEach(t),vi=o(e),Gt=n(e,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-1v25wk6"&&(Gt.textContent=Wy),bi=o(e),Zt=n(e,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1rlbolh"&&(Zt.innerHTML=Ey),gi=o(e),A=n(e,"H1",{class:!0});var vp=y(A);Je=n(vp,"A",{id:!0,class:!0,href:!0});var Pc=y(Je);Mn=n(Pc,"SPAN",{});var Kc=y(Mn);c(At.$$.fragment,Kc),Kc.forEach(t),Pc.forEach(t),hM=o(vp),ma=n(vp,"SPAN",{"data-svelte-h":!0}),M(ma)!=="svelte-tmroid"&&(ma.textContent=Hy),vp.forEach(t),Bi=o(e),_=n(e,"H2",{class:!0});var bp=y(_);Te=n(bp,"A",{id:!0,class:!0,href:!0});var Dc=y(Te);yn=n(Dc,"SPAN",{});var Oc=y(yn);c(_t.$$.fragment,Oc),Oc.forEach(t),Dc.forEach(t),cM=o(bp),Ja=n(bp,"SPAN",{"data-svelte-h":!0}),M(Ja)!=="svelte-uicksz"&&(Ja.textContent=Ny),bp.forEach(t),Gi=o(e),kt=n(e,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-ob9gmy"&&(kt.innerHTML=Vy),Zi=o(e),St=n(e,"P",{"data-svelte-h":!0}),M(St)!=="svelte-kifkkx"&&(St.innerHTML=Ry),Ai=o(e),k=n(e,"H2",{class:!0});var gp=y(k);Ue=n(gp,"A",{id:!0,class:!0,href:!0});var ew=y(Ue);hn=n(ew,"SPAN",{});var tw=y(hn);c(Xt.$$.fragment,tw),tw.forEach(t),ew.forEach(t),wM=o(gp),Ta=n(gp,"SPAN",{"data-svelte-h":!0}),M(Ta)!=="svelte-wdjh5x"&&(Ta.textContent=Qy),gp.forEach(t),_i=o(e),xt=n(e,"UL",{"data-svelte-h":!0}),M(xt)!=="svelte-1funvfi"&&(xt.innerHTML=$y),ki=o(e),Wt=n(e,"IMG",{src:!0,alt:!0}),Si=o(e),Et=n(e,"UL",{"data-svelte-h":!0}),M(Et)!=="svelte-1cge6gn"&&(Et.innerHTML=zy),Xi=o(e),Ht=n(e,"IMG",{src:!0,alt:!0}),xi=o(e),S=n(e,"H2",{class:!0});var Bp=y(S);ue=n(Bp,"A",{id:!0,class:!0,href:!0});var lw=y(ue);cn=n(lw,"SPAN",{});var sw=y(cn);c(Nt.$$.fragment,sw),sw.forEach(t),lw.forEach(t),mM=o(Bp),Ua=n(Bp,"SPAN",{"data-svelte-h":!0}),M(Ua)!=="svelte-tigov7"&&(Ua.textContent=Ly),Bp.forEach(t),Wi=o(e),Vt=n(e,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-pdx5k3"&&(Vt.innerHTML=qy),Ei=o(e),Rt=n(e,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-tsd2zd"&&(Rt.textContent=Py),Hi=o(e),c(Qt.$$.fragment,e),Ni=o(e),c($t.$$.fragment,e),Vi=o(e),X=n(e,"H2",{class:!0});var Gp=y(X);de=n(Gp,"A",{id:!0,class:!0,href:!0});var aw=y(de);wn=n(aw,"SPAN",{});var nw=y(wn);c(Yt.$$.fragment,nw),nw.forEach(t),aw.forEach(t),JM=o(Gp),ua=n(Gp,"SPAN",{"data-svelte-h":!0}),M(ua)!=="svelte-p6dx12"&&(ua.textContent=Ky),Gp.forEach(t),Ri=o(e),zt=n(e,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-1pw2whq"&&(zt.textContent=Dy),Qi=o(e),Ft=n(e,"UL",{"data-svelte-h":!0}),M(Ft)!=="svelte-k2qrfp"&&(Ft.innerHTML=Oy),$i=o(e),Lt=n(e,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-1vmixr"&&(Lt.innerHTML=eh),Yi=o(e),qt=n(e,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-1wv28c2"&&(qt.textContent=th),zi=o(e),Pt=n(e,"UL",{"data-svelte-h":!0}),M(Pt)!=="svelte-myoczt"&&(Pt.innerHTML=lh),Fi=o(e),Kt=n(e,"P",{"data-svelte-h":!0}),M(Kt)!=="svelte-1qs6q29"&&(Kt.innerHTML=sh),Li=o(e),Dt=n(e,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-xcqr7v"&&(Dt.innerHTML=ah),qi=o(e),Ot=n(e,"P",{"data-svelte-h":!0}),M(Ot)!=="svelte-hj7hlz"&&(Ot.innerHTML=nh),Pi=o(e),c(el.$$.fragment,e),Ki=o(e),x=n(e,"H2",{class:!0});var Zp=y(x);je=n(Zp,"A",{id:!0,class:!0,href:!0});var iw=y(je);mn=n(iw,"SPAN",{});var ow=y(mn);c(tl.$$.fragment,ow),ow.forEach(t),iw.forEach(t),TM=o(Zp),da=n(Zp,"SPAN",{"data-svelte-h":!0}),M(da)!=="svelte-1oue0e3"&&(da.textContent=ih),Zp.forEach(t),Di=o(e),ll=n(e,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-dqxg7f"&&(ll.textContent=oh),Oi=o(e),sl=n(e,"UL",{"data-svelte-h":!0}),M(sl)!=="svelte-1gjders"&&(sl.innerHTML=rh),eo=o(e),c(al.$$.fragment,e),to=o(e),W=n(e,"H2",{class:!0});var Ap=y(W);Ie=n(Ap,"A",{id:!0,class:!0,href:!0});var rw=y(Ie);Jn=n(rw,"SPAN",{});var pw=y(Jn);c(nl.$$.fragment,pw),pw.forEach(t),rw.forEach(t),UM=o(Ap),ja=n(Ap,"SPAN",{"data-svelte-h":!0}),M(ja)!=="svelte-11va0k5"&&(ja.textContent=ph),Ap.forEach(t),lo=o(e),il=n(e,"UL",{"data-svelte-h":!0}),M(il)!=="svelte-1gy9cwb"&&(il.innerHTML=Mh),so=o(e),c(ol.$$.fragment,e),ao=o(e),c(rl.$$.fragment,e),no=o(e),pl=n(e,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-vuxvq9"&&(pl.textContent=yh),io=o(e),E=n(e,"H1",{class:!0});var _p=y(E);Ce=n(_p,"A",{id:!0,class:!0,href:!0});var Mw=y(Ce);Tn=n(Mw,"SPAN",{});var yw=y(Tn);c(Ml.$$.fragment,yw),yw.forEach(t),Mw.forEach(t),uM=o(_p),Ia=n(_p,"SPAN",{"data-svelte-h":!0}),M(Ia)!=="svelte-ts6v8e"&&(Ia.textContent=hh),_p.forEach(t),oo=o(e),H=n(e,"H2",{class:!0});var kp=y(H);fe=n(kp,"A",{id:!0,class:!0,href:!0});var hw=y(fe);Un=n(hw,"SPAN",{});var cw=y(Un);c(yl.$$.fragment,cw),cw.forEach(t),hw.forEach(t),dM=o(kp),Ca=n(kp,"SPAN",{"data-svelte-h":!0}),M(Ca)!=="svelte-1t9ndg5"&&(Ca.textContent=ch),kp.forEach(t),ro=o(e),N=n(e,"H3",{class:!0});var Sp=y(N);ve=n(Sp,"A",{id:!0,class:!0,href:!0});var ww=y(ve);un=n(ww,"SPAN",{});var mw=y(un);c(hl.$$.fragment,mw),mw.forEach(t),ww.forEach(t),jM=o(Sp),fa=n(Sp,"SPAN",{"data-svelte-h":!0}),M(fa)!=="svelte-jvw8wu"&&(fa.textContent=wh),Sp.forEach(t),po=o(e),V=n(e,"H3",{class:!0});var Xp=y(V);be=n(Xp,"A",{id:!0,class:!0,href:!0});var Jw=y(be);dn=n(Jw,"SPAN",{});var Tw=y(dn);c(cl.$$.fragment,Tw),Tw.forEach(t),Jw.forEach(t),IM=o(Xp),va=n(Xp,"SPAN",{"data-svelte-h":!0}),M(va)!=="svelte-186o0p7"&&(va.textContent=mh),Xp.forEach(t),Mo=o(e),wl=n(e,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-gt4x2w"&&(wl.innerHTML=Jh),yo=o(e),ml=n(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(ml)!=="svelte-1tbaqzz"&&(ml.innerHTML=Th),ho=o(e),Jl=n(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Jl)!=="svelte-183qkv9"&&(Jl.innerHTML=Uh),co=o(e),R=n(e,"H3",{class:!0});var xp=y(R);ge=n(xp,"A",{id:!0,class:!0,href:!0});var Uw=y(ge);jn=n(Uw,"SPAN",{});var uw=y(jn);c(Tl.$$.fragment,uw),uw.forEach(t),Uw.forEach(t),CM=o(xp),ba=n(xp,"SPAN",{"data-svelte-h":!0}),M(ba)!=="svelte-t7c3ab"&&(ba.textContent=uh),xp.forEach(t),wo=o(e),Ul=n(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Ul)!=="svelte-9v2bo0"&&(Ul.innerHTML=dh),mo=o(e),ul=n(e,"P",{"data-svelte-h":!0}),M(ul)!=="svelte-13r4rlx"&&(ul.innerHTML=jh),Jo=o(e),dl=n(e,"P",{"data-svelte-h":!0}),M(dl)!=="svelte-oceozx"&&(dl.textContent=Ih),To=o(e),jl=n(e,"UL",{"data-svelte-h":!0}),M(jl)!=="svelte-1c26av6"&&(jl.innerHTML=Ch),Uo=o(e),Il=n(e,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-poz2v2"&&(Il.textContent=fh),uo=o(e),c(Cl.$$.fragment,e),jo=o(e),c(fl.$$.fragment,e),Io=o(e),c(vl.$$.fragment,e),Co=o(e),Q=n(e,"H2",{class:!0});var Wp=y(Q);Be=n(Wp,"A",{id:!0,class:!0,href:!0});var dw=y(Be);In=n(dw,"SPAN",{});var jw=y(In);c(bl.$$.fragment,jw),jw.forEach(t),dw.forEach(t),fM=o(Wp),ga=n(Wp,"SPAN",{"data-svelte-h":!0}),M(ga)!=="svelte-1dv6r21"&&(ga.textContent=vh),Wp.forEach(t),fo=o(e),gl=n(e,"P",{"data-svelte-h":!0}),M(gl)!=="svelte-2qybsb"&&(gl.textContent=bh),vo=o(e),Bl=n(e,"UL",{"data-svelte-h":!0}),M(Bl)!=="svelte-1sj03by"&&(Bl.innerHTML=gh),bo=o(e),Gl=n(e,"IMG",{src:!0,alt:!0}),go=o(e),Zl=n(e,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-56izqm"&&(Zl.textContent=Gh),Bo=o(e),Al=n(e,"UL",{"data-svelte-h":!0}),M(Al)!=="svelte-5b172v"&&(Al.innerHTML=Zh),Go=o(e),c(_l.$$.fragment,e),Zo=o(e),$=n(e,"H3",{class:!0});var Ep=y($);Ge=n(Ep,"A",{id:!0,class:!0,href:!0});var Iw=y(Ge);Cn=n(Iw,"SPAN",{});var Cw=y(Cn);c(kl.$$.fragment,Cw),Cw.forEach(t),Iw.forEach(t),vM=o(Ep),Ba=n(Ep,"SPAN",{"data-svelte-h":!0}),M(Ba)!=="svelte-13h1zkw"&&(Ba.textContent=Ah),Ep.forEach(t),Ao=o(e),c(Sl.$$.fragment,e),_o=o(e),Xl=n(e,"P",{"data-svelte-h":!0}),M(Xl)!=="svelte-131hsl5"&&(Xl.textContent=_h),ko=o(e),xl=n(e,"UL",{"data-svelte-h":!0}),M(xl)!=="svelte-f2pb1"&&(xl.innerHTML=kh),So=o(e),c(Wl.$$.fragment,e),Xo=o(e),El=n(e,"UL",{"data-svelte-h":!0}),M(El)!=="svelte-kheb3v"&&(El.innerHTML=Sh),xo=o(e),Hl=n(e,"P",{"data-svelte-h":!0}),M(Hl)!=="svelte-r1i79m"&&(Hl.innerHTML=Xh),Wo=o(e),Y=n(e,"H3",{class:!0});var Hp=y(Y);Ze=n(Hp,"A",{id:!0,class:!0,href:!0});var fw=y(Ze);fn=n(fw,"SPAN",{});var vw=y(fn);c(Nl.$$.fragment,vw),vw.forEach(t),fw.forEach(t),bM=o(Hp),Ga=n(Hp,"SPAN",{"data-svelte-h":!0}),M(Ga)!=="svelte-1tpq7r5"&&(Ga.textContent=xh),Hp.forEach(t),Eo=o(e),c(Vl.$$.fragment,e),Ho=o(e),Rl=n(e,"P",{"data-svelte-h":!0}),M(Rl)!=="svelte-tmktf2"&&(Rl.innerHTML=Wh),No=o(e),Ql=n(e,"UL",{"data-svelte-h":!0}),M(Ql)!=="svelte-mzudog"&&(Ql.innerHTML=Eh),Vo=o(e),z=n(e,"H3",{class:!0});var Np=y(z);Ae=n(Np,"A",{id:!0,class:!0,href:!0});var bw=y(Ae);vn=n(bw,"SPAN",{});var gw=y(vn);c($l.$$.fragment,gw),gw.forEach(t),bw.forEach(t),gM=o(Np),Za=n(Np,"SPAN",{"data-svelte-h":!0}),M(Za)!=="svelte-1ng31t9"&&(Za.textContent=Hh),Np.forEach(t),Ro=j(e,`


This is the Reinforce algorithm pseudocode:
`),Yl=n(e,"IMG",{src:!0,alt:!0}),Qo=o(e),zl=n(e,"UL",{"data-svelte-h":!0}),M(zl)!=="svelte-1wxltag"&&(zl.innerHTML=Vh),$o=o(e),Fl=n(e,"P",{"data-svelte-h":!0}),M(Fl)!=="svelte-1ucwq0c"&&(Fl.innerHTML=Rh),Yo=o(e),Ll=n(e,"P",{"data-svelte-h":!0}),M(Ll)!=="svelte-1tam5jq"&&(Ll.innerHTML=Qh),zo=o(e),Aa=n(e,"UL",{});var Bw=y(Aa);ql=n(Bw,"LI",{});var Vp=y(ql);BM=j(Vp,"We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),_a=n(Vp,"STRONG",{"data-svelte-h":!0}),M(_a)!=="svelte-147747o"&&(_a.textContent=$h),I=n(Vp,"UL",{});var C=y(I);ka=n(C,"LI",{"data-svelte-h":!0}),M(ka)!=="svelte-1pp5ztk"&&(ka.textContent=Yh),GM=o(C),_e=n(C,"LI",{});var Qn=y(_e);ZM=j(Qn,"So we want to modify "),Fo=tn(Qn,!1),Lo=j(Qn," such that "),qo=tn(Qn,!1),Qn.forEach(t),AM=o(C),ke=n(C,"LI",{});var $n=y(ke);_M=j($n,"Because all P must sum to 1, max "),Po=tn($n,!1),Ko=j($n," will "),Sa=n($n,"STRONG",{"data-svelte-h":!0}),M(Sa)!=="svelte-5xkb6z"&&(Sa.textContent=zh),$n.forEach(t),kM=o(C),Xa=n(C,"LI",{});var ly=y(Xa);SM=j(ly,"So we should tell PyTorch "),Pl=n(ly,"STRONG",{});var Rp=y(Pl);XM=j(Rp,"to min "),Do=tn(Rp,!1),Oo=j(Rp,"."),Rp.forEach(t),ly.forEach(t),xM=o(C),Kl=n(C,"LI",{});var Qp=y(Kl);WM=j(Qp,"This loss function approaches 0 as "),er=tn(Qp,!1),tr=j(Qp," nears 1."),Qp.forEach(t),EM=o(C),xa=n(C,"LI",{});var sy=y(xa);HM=j(sy,"So we are encouraging the gradient to max "),lr=tn(sy,!1),sy.forEach(t),C.forEach(t),Vp.forEach(t),Bw.forEach(t),sr=o(e),c(Dl.$$.fragment,e),ar=o(e),F=n(e,"H4",{class:!0});var $p=y(F);Se=n($p,"A",{id:!0,class:!0,href:!0});var Gw=y(Se);bn=n(Gw,"SPAN",{});var Zw=y(bn);c(Ol.$$.fragment,Zw),Zw.forEach(t),Gw.forEach(t),NM=o($p),Wa=n($p,"SPAN",{"data-svelte-h":!0}),M(Wa)!=="svelte-13h1zkw"&&(Wa.textContent=Fh),$p.forEach(t),nr=o(e),c(es.$$.fragment,e),ir=o(e),L=n(e,"H2",{class:!0});var Yp=y(L);Xe=n(Yp,"A",{id:!0,class:!0,href:!0});var Aw=y(Xe);gn=n(Aw,"SPAN",{});var _w=y(gn);c(ts.$$.fragment,_w),_w.forEach(t),Aw.forEach(t),VM=o(Yp),Ea=n(Yp,"SPAN",{"data-svelte-h":!0}),M(Ea)!=="svelte-f0m8hw"&&(Ea.textContent=Lh),Yp.forEach(t),or=j(e,`


- We're now ready to train our agent.
- But first, we define a variable containing all the training hyperparameters.
- You can change the training parameters (and should 😉)

	`),c(ls.$$.fragment,e),rr=o(e),c(ss.$$.fragment,e),pr=o(e),c(as.$$.fragment,e),Mr=o(e),q=n(e,"H2",{class:!0});var zp=y(q);xe=n(zp,"A",{id:!0,class:!0,href:!0});var kw=y(xe);Bn=n(kw,"SPAN",{});var Sw=y(Bn);c(ns.$$.fragment,Sw),Sw.forEach(t),kw.forEach(t),RM=o(zp),Ha=n(zp,"SPAN",{"data-svelte-h":!0}),M(Ha)!=="svelte-1r1hw71"&&(Ha.textContent=qh),zp.forEach(t),yr=j(e,`


- Here we define the evaluation method that we're going to use to test our Reinforce agent.

	`),c(is.$$.fragment,e),hr=o(e),P=n(e,"H2",{class:!0});var Fp=y(P);We=n(Fp,"A",{id:!0,class:!0,href:!0});var Xw=y(We);Gn=n(Xw,"SPAN",{});var xw=y(Gn);c(os.$$.fragment,xw),xw.forEach(t),Xw.forEach(t),QM=o(Fp),Na=n(Fp,"SPAN",{"data-svelte-h":!0}),M(Na)!=="svelte-1qa220i"&&(Na.textContent=Ph),Fp.forEach(t),cr=o(e),c(rs.$$.fragment,e),wr=o(e),K=n(e,"H3",{class:!0});var Lp=y(K);Ee=n(Lp,"A",{id:!0,class:!0,href:!0});var Ww=y(Ee);Zn=n(Ww,"SPAN",{});var Ew=y(Zn);c(ps.$$.fragment,Ew),Ew.forEach(t),Ww.forEach(t),$M=o(Lp),Va=n(Lp,"SPAN",{"data-svelte-h":!0}),M(Va)!=="svelte-a4wiux"&&(Va.textContent=Kh),Lp.forEach(t),mr=j(e,`


Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.
`),Ms=n(e,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-1ifum22"&&(Ms.textContent=Dh),Jr=o(e),Ra=n(e,"IMG",{src:!0}),Tr=o(e),D=n(e,"H3",{class:!0});var qp=y(D);He=n(qp,"A",{id:!0,class:!0,href:!0});var Hw=y(He);An=n(Hw,"SPAN",{});var Nw=y(An);c(ys.$$.fragment,Nw),Nw.forEach(t),Hw.forEach(t),YM=o(qp),Qa=n(qp,"SPAN",{"data-svelte-h":!0}),M(Qa)!=="svelte-ta2ms6"&&(Qa.textContent=ec),qp.forEach(t),Ur=o(e),O=n(e,"H4",{class:!0});var Pp=y(O);Ne=n(Pp,"A",{id:!0,class:!0,href:!0});var Vw=y(Ne);_n=n(Vw,"SPAN",{});var Rw=y(_n);c(hs.$$.fragment,Rw),Rw.forEach(t),Vw.forEach(t),zM=o(Pp),$a=n(Pp,"SPAN",{"data-svelte-h":!0}),M($a)!=="svelte-re6m98"&&($a.textContent=tc),Pp.forEach(t),ur=o(e),c(cs.$$.fragment,e),dr=o(e),c(ws.$$.fragment,e),jr=o(e),c(ms.$$.fragment,e),Ir=o(e),Js=n(e,"P",{"data-svelte-h":!0}),M(Js)!=="svelte-1ss5nh"&&(Js.innerHTML=lc),Cr=o(e),Ts=n(e,"P",{"data-svelte-h":!0}),M(Ts)!=="svelte-vgzxi7"&&(Ts.textContent=sc),fr=o(e),Us=n(e,"UL",{"data-svelte-h":!0}),M(Us)!=="svelte-bcjr5d"&&(Us.innerHTML=ac),vr=o(e),us=n(e,"P",{"data-svelte-h":!0}),M(us)!=="svelte-6k9qpu"&&(us.textContent=nc),br=o(e),ds=n(e,"P",{"data-svelte-h":!0}),M(ds)!=="svelte-932u9c"&&(ds.innerHTML=ic),gr=o(e),js=n(e,"P",{"data-svelte-h":!0}),M(js)!=="svelte-1cn3tld"&&(js.textContent=oc),Br=o(e),Is=n(e,"UL",{"data-svelte-h":!0}),M(Is)!=="svelte-19b5tev"&&(Is.innerHTML=rc),Gr=o(e),Cs=n(e,"IMG",{src:!0,alt:!0}),Zr=o(e),c(fs.$$.fragment,e),Ar=o(e),vs=n(e,"P",{"data-svelte-h":!0}),M(vs)!=="svelte-14yhksh"&&(vs.innerHTML=Mc),_r=o(e),bs=n(e,"P",{"data-svelte-h":!0}),M(bs)!=="svelte-1enm9m5"&&(bs.innerHTML=yc),kr=o(e),c(gs.$$.fragment,e),Sr=o(e),Bs=n(e,"P",{"data-svelte-h":!0}),M(Bs)!=="svelte-s4clfq"&&(Bs.textContent=hc),Xr=o(e),ee=n(e,"H2",{class:!0});var Kp=y(ee);Ve=n(Kp,"A",{id:!0,class:!0,href:!0});var Qw=y(Ve);kn=n(Qw,"SPAN",{});var $w=y(kn);c(Gs.$$.fragment,$w),$w.forEach(t),Qw.forEach(t),FM=o(Kp),Ya=n(Kp,"SPAN",{"data-svelte-h":!0}),M(Ya)!=="svelte-321hd7"&&(Ya.textContent=cc),Kp.forEach(t),xr=o(e),te=n(e,"H3",{class:!0});var Dp=y(te);Re=n(Dp,"A",{id:!0,class:!0,href:!0});var Yw=y(Re);Sn=n(Yw,"SPAN",{});var zw=y(Sn);c(Zs.$$.fragment,zw),zw.forEach(t),Yw.forEach(t),LM=o(Dp),za=n(Dp,"SPAN",{"data-svelte-h":!0}),M(za)!=="svelte-mkaoto"&&(za.textContent=wc),Dp.forEach(t),Wr=j(e,`


- [The Environment documentation](https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html)

	`),c(As.$$.fragment,e),Er=o(e),c(_s.$$.fragment,e),Hr=o(e),c(ks.$$.fragment,e),Nr=o(e),Ss=n(e,"P",{"data-svelte-h":!0}),M(Ss)!=="svelte-xr9zu2"&&(Ss.textContent=mc),Vr=o(e),Xs=n(e,"UL",{"data-svelte-h":!0}),M(Xs)!=="svelte-hfzbwg"&&(Xs.innerHTML=Jc),Rr=o(e),xs=n(e,"P",{"data-svelte-h":!0}),M(xs)!=="svelte-1j0vapy"&&(xs.textContent=Tc),Qr=o(e),Ws=n(e,"UL",{"data-svelte-h":!0}),M(Ws)!=="svelte-109j46n"&&(Ws.innerHTML=Uc),$r=o(e),Es=n(e,"P",{"data-svelte-h":!0}),M(Es)!=="svelte-1kwknxb"&&(Es.textContent=uc),Yr=o(e),Hs=n(e,"UL",{"data-svelte-h":!0}),M(Hs)!=="svelte-14go64c"&&(Hs.innerHTML=dc),zr=o(e),le=n(e,"H3",{class:!0});var Op=y(le);Qe=n(Op,"A",{id:!0,class:!0,href:!0});var Fw=y(Qe);Xn=n(Fw,"SPAN",{});var Lw=y(Xn);c(Ns.$$.fragment,Lw),Lw.forEach(t),Fw.forEach(t),qM=o(Op),Fa=n(Op,"SPAN",{"data-svelte-h":!0}),M(Fa)!=="svelte-15qzegz"&&(Fa.textContent=jc),Op.forEach(t),Fr=j(e,`


- We need to have a deeper neural network since the environment is more complex

	`),c(Vs.$$.fragment,e),Lr=o(e),se=n(e,"H4",{class:!0});var eM=y(se);$e=n(eM,"A",{id:!0,class:!0,href:!0});var qw=y($e);xn=n(qw,"SPAN",{});var Pw=y(xn);c(Rs.$$.fragment,Pw),Pw.forEach(t),qw.forEach(t),PM=o(eM),La=n(eM,"SPAN",{"data-svelte-h":!0}),M(La)!=="svelte-13h1zkw"&&(La.textContent=Ic),eM.forEach(t),qr=o(e),c(Qs.$$.fragment,e),Pr=o(e),ae=n(e,"H3",{class:!0});var tM=y(ae);Ye=n(tM,"A",{id:!0,class:!0,href:!0});var Kw=y(Ye);Wn=n(Kw,"SPAN",{});var Dw=y(Wn);c($s.$$.fragment,Dw),Dw.forEach(t),Kw.forEach(t),KM=o(tM),qa=n(tM,"SPAN",{"data-svelte-h":!0}),M(qa)!=="svelte-h5i9lp"&&(qa.textContent=Cc),tM.forEach(t),Kr=j(e,`


- Because this environment is more complex.
- Especially for the hidden size, we need more neurons.

	`),c(Ys.$$.fragment,e),Dr=o(e),ne=n(e,"H3",{class:!0});var lM=y(ne);ze=n(lM,"A",{id:!0,class:!0,href:!0});var Ow=y(ze);En=n(Ow,"SPAN",{});var em=y(En);c(zs.$$.fragment,em),em.forEach(t),Ow.forEach(t),DM=o(lM),Pa=n(lM,"SPAN",{"data-svelte-h":!0}),M(Pa)!=="svelte-f0m8hw"&&(Pa.textContent=fc),lM.forEach(t),Or=j(e,`


- We're now ready to train our agent 🔥.

	`),c(Fs.$$.fragment,e),ep=o(e),c(Ls.$$.fragment,e),tp=o(e),ie=n(e,"H3",{class:!0});var sM=y(ie);Fe=n(sM,"A",{id:!0,class:!0,href:!0});var tm=y(Fe);Hn=n(tm,"SPAN",{});var lm=y(Hn);c(qs.$$.fragment,lm),lm.forEach(t),tm.forEach(t),OM=o(sM),Ka=n(sM,"SPAN",{"data-svelte-h":!0}),M(Ka)!=="svelte-a4wiux"&&(Ka.textContent=vc),sM.forEach(t),lp=o(e),c(Ps.$$.fragment,e),sp=o(e),oe=n(e,"H2",{class:!0});var aM=y(oe);Le=n(aM,"A",{id:!0,class:!0,href:!0});var sm=y(Le);Nn=n(sm,"SPAN",{});var am=y(Nn);c(Ks.$$.fragment,am),am.forEach(t),sm.forEach(t),ey=o(aM),Da=n(aM,"SPAN",{"data-svelte-h":!0}),M(Da)!=="svelte-a17ig2"&&(Da.textContent=bc),aM.forEach(t),ap=o(e),Ds=n(e,"P",{"data-svelte-h":!0}),M(Ds)!=="svelte-h9supy"&&(Ds.innerHTML=gc),np=o(e),Os=n(e,"P",{"data-svelte-h":!0}),M(Os)!=="svelte-131ixzr"&&(Os.innerHTML=Bc),ip=o(e),ea=n(e,"P",{"data-svelte-h":!0}),M(ea)!=="svelte-1uth36j"&&(ea.textContent=Gc),op=o(e),ta=n(e,"UL",{"data-svelte-h":!0}),M(ta)!=="svelte-su8kur"&&(ta.innerHTML=Zc),rp=o(e),pp=n(e,"HR",{}),Mp=o(e),la=n(e,"P",{"data-svelte-h":!0}),M(la)!=="svelte-jb70tl"&&(la.innerHTML=Ac),yp=o(e),sa=n(e,"P",{"data-svelte-h":!0}),M(sa)!=="svelte-h09rnt"&&(sa.innerHTML=_c),hp=o(e),aa=n(e,"P",{"data-svelte-h":!0}),M(aa)!=="svelte-st4ijf"&&(aa.innerHTML=kc),cp=o(e),na=n(e,"P",{"data-svelte-h":!0}),M(na)!=="svelte-2auufk"&&(na.textContent=Sc),wp=o(e),ia=n(e,"P",{"data-svelte-h":!0}),M(ia)!=="svelte-ol1ouv"&&(ia.innerHTML=Xc),mp=o(e),oa=n(e,"P",{"data-svelte-h":!0}),M(oa)!=="svelte-kyrcnn"&&(oa.textContent=xc),Jp=o(e),re=n(e,"H3",{class:!0});var nM=y(re);qe=n(nM,"A",{id:!0,class:!0,href:!0});var nm=y(qe);Vn=n(nm,"SPAN",{});var im=y(Vn);c(ra.$$.fragment,im),im.forEach(t),nm.forEach(t),ty=o(nM),Oa=n(nM,"SPAN",{"data-svelte-h":!0}),M(Oa)!=="svelte-i2bdz3"&&(Oa.textContent=Wc),nM.forEach(t),Tp=o(e),Rn=n(e,"P",{}),y(Rn).forEach(t),this.h()},h(){p(f,"name","hf:doc:metadata"),p(f,"content",JSON.stringify(jm)),p(pe,"id","hands-on"),p(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(pe,"href","#hands-on"),p(v,"class","relative group"),p(Me,"class","image table text-center m-0 w-full"),p(ye,"id","unit-4-code-your-first-deep-reinforcement-learning-algorithm-with-pytorch-reinforce-and-test-its-robustness"),p(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ye,"href","#unit-4-code-your-first-deep-reinforcement-learning-algorithm-with-pytorch-reinforce-and-test-its-robustness"),p(b,"class","relative group"),Pe(ht.src,dy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/thumbnail.png")||p(ht,"src",dy),p(ht,"alt","thumbnail"),Pe(ut.src,gy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif")||p(ut,"src",gy),p(ut,"alt","Environments"),p(he,"id","environments"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#environments"),p(g,"class","relative group"),p(ce,"id","rllibrary"),p(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ce,"href","#rllibrary"),p(B,"class","relative group"),p(we,"id","objectives-of-this-notebook"),p(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(we,"href","#objectives-of-this-notebook"),p(G,"class","relative group"),p(me,"id","prerequisites"),p(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(me,"href","#prerequisites"),p(Z,"class","relative group"),p(Je,"id","lets-code-reinforce-algorithm-from-scratch"),p(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Je,"href","#lets-code-reinforce-algorithm-from-scratch"),p(A,"class","relative group"),p(Te,"id","some-advice"),p(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Te,"href","#some-advice"),p(_,"class","relative group"),p(Ue,"id","set-the-gpu"),p(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ue,"href","#set-the-gpu"),p(k,"class","relative group"),Pe(Wt.src,Yy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||p(Wt,"src",Yy),p(Wt,"alt","GPU Step 1"),Pe(Ht.src,Fy="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||p(Ht,"src",Fy),p(Ht,"alt","GPU Step 2"),p(ue,"id","create-a-virtual-display"),p(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ue,"href","#create-a-virtual-display"),p(S,"class","relative group"),p(de,"id","install-the-dependencies"),p(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(de,"href","#install-the-dependencies"),p(X,"class","relative group"),p(je,"id","import-the-packages"),p(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(je,"href","#import-the-packages"),p(x,"class","relative group"),p(Ie,"id","check-if-we-have-a-gpu"),p(Ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ie,"href","#check-if-we-have-a-gpu"),p(W,"class","relative group"),p(Ce,"id","first-agent-playing-cartpolev1"),p(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ce,"href","#first-agent-playing-cartpolev1"),p(E,"class","relative group"),p(fe,"id","create-the-cartpole-environment-and-understand-how-it-works"),p(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(fe,"href","#create-the-cartpole-environment-and-understand-how-it-works"),p(H,"class","relative group"),p(ve,"id","the-environment-httpswwwgymlibrarydevenvironmentsclassiccontrolcartpole"),p(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ve,"href","#the-environment-httpswwwgymlibrarydevenvironmentsclassiccontrolcartpole"),p(N,"class","relative group"),p(be,"id","why-do-we-use-a-simple-environment-like-cartpolev1"),p(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(be,"href","#why-do-we-use-a-simple-environment-like-cartpolev1"),p(V,"class","relative group"),p(ge,"id","the-cartpolev1-environment"),p(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ge,"href","#the-cartpolev1-environment"),p(R,"class","relative group"),p(Be,"id","lets-build-the-reinforce-architecture"),p(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Be,"href","#lets-build-the-reinforce-architecture"),p(Q,"class","relative group"),Pe(Gl.src,Bh="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/reinforce.png")||p(Gl,"src",Bh),p(Gl,"alt","Reinforce"),p(Ge,"id","solution"),p(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ge,"href","#solution"),p($,"class","relative group"),p(Ze,"id","real-solution"),p(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ze,"href","#real-solution"),p(Y,"class","relative group"),p(Ae,"id","lets-build-the-reinforce-training-algorithm"),p(Ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ae,"href","#lets-build-the-reinforce-training-algorithm"),p(z,"class","relative group"),Pe(Yl.src,Nh="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/pg_pseudocode.png")||p(Yl,"src",Nh),p(Yl,"alt","Policy gradient pseudocode"),Fo.a=Lo,qo.a=null,Po.a=Ko,Do.a=Oo,er.a=tr,lr.a=null,p(Se,"id","solution"),p(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Se,"href","#solution"),p(F,"class","relative group"),p(Xe,"id","train-it"),p(Xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Xe,"href","#train-it"),p(L,"class","relative group"),p(xe,"id","define-evaluation-method"),p(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(xe,"href","#define-evaluation-method"),p(q,"class","relative group"),p(We,"id","evaluate-our-agent"),p(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(We,"href","#evaluate-our-agent"),p(P,"class","relative group"),p(Ee,"id","publish-our-trained-model-on-the-hub"),p(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ee,"href","#publish-our-trained-model-on-the-hub"),p(K,"class","relative group"),Pe(Ra.src,Oh="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/modelcard.png")||p(Ra,"src",Oh),p(He,"id","push-to-the-hub"),p(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(He,"href","#push-to-the-hub"),p(D,"class","relative group"),p(Ne,"id","do-not-modify-this-code"),p(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ne,"href","#do-not-modify-this-code"),p(O,"class","relative group"),Pe(Cs.src,pc="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||p(Cs,"src",pc),p(Cs,"alt","Create HF Token"),p(Ve,"id","second-agent-pixelcopter"),p(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ve,"href","#second-agent-pixelcopter"),p(ee,"class","relative group"),p(Re,"id","study-the-pixelcopter-environment"),p(Re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Re,"href","#study-the-pixelcopter-environment"),p(te,"class","relative group"),p(Qe,"id","define-the-new-policy"),p(Qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Qe,"href","#define-the-new-policy"),p(le,"class","relative group"),p($e,"id","solution"),p($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($e,"href","#solution"),p(se,"class","relative group"),p(Ye,"id","define-the-hyperparameters"),p(Ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ye,"href","#define-the-hyperparameters"),p(ae,"class","relative group"),p(ze,"id","train-it"),p(ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ze,"href","#train-it"),p(ne,"class","relative group"),p(Fe,"id","publish-our-trained-model-on-the-hub"),p(Fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Fe,"href","#publish-our-trained-model-on-the-hub"),p(ie,"class","relative group"),p(Le,"id","some-additional-challenges"),p(Le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Le,"href","#some-additional-challenges"),p(oe,"class","relative group"),p(qe,"id","keep-learning-stay-awesome"),p(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(qe,"href","#keep-learning-stay-awesome"),p(re,"class","relative group")},m(e,l){r(document.head,f),s(e,Yn,l),s(e,ln,l),s(e,zn,l),s(e,v,l),r(v,pe),r(pe,sn),w(Ke,sn,null),r(v,iM),r(v,pa),s(e,Fn,l),w(De,e,l),s(e,Ln,l),s(e,Oe,l),s(e,qn,l),s(e,et,l),s(e,Pn,l),s(e,Me,l),s(e,Kn,l),s(e,tt,l),s(e,Dn,l),s(e,lt,l),s(e,On,l),s(e,st,l),s(e,ei,l),s(e,at,l),s(e,ti,l),s(e,nt,l),s(e,li,l),s(e,it,l),s(e,si,l),s(e,ot,l),s(e,ai,l),s(e,rt,l),s(e,ni,l),s(e,pt,l),s(e,ii,l),s(e,Mt,l),s(e,oi,l),s(e,b,l),r(b,ye),r(ye,an),w(yt,an,null),r(b,oM),r(b,Ma),s(e,ri,l),s(e,ht,l),s(e,pi,l),s(e,ct,l),s(e,Mi,l),s(e,wt,l),s(e,yi,l),s(e,mt,l),s(e,hi,l),s(e,Jt,l),s(e,ci,l),s(e,Tt,l),s(e,wi,l),s(e,Ut,l),s(e,mi,l),s(e,ut,l),s(e,Ji,l),s(e,g,l),r(g,he),r(he,nn),w(dt,nn,null),r(g,rM),r(g,ya),s(e,Ti,l),s(e,jt,l),s(e,Ui,l),s(e,B,l),r(B,ce),r(ce,on),w(It,on,null),r(B,pM),r(B,ha),s(e,ui,l),s(e,Ct,l),s(e,di,l),s(e,ft,l),s(e,ji,l),s(e,G,l),r(G,we),r(we,rn),w(vt,rn,null),r(G,MM),r(G,ca),s(e,Ii,l),s(e,bt,l),s(e,Ci,l),s(e,gt,l),s(e,fi,l),s(e,Z,l),r(Z,me),r(me,pn),w(Bt,pn,null),r(Z,yM),r(Z,wa),s(e,vi,l),s(e,Gt,l),s(e,bi,l),s(e,Zt,l),s(e,gi,l),s(e,A,l),r(A,Je),r(Je,Mn),w(At,Mn,null),r(A,hM),r(A,ma),s(e,Bi,l),s(e,_,l),r(_,Te),r(Te,yn),w(_t,yn,null),r(_,cM),r(_,Ja),s(e,Gi,l),s(e,kt,l),s(e,Zi,l),s(e,St,l),s(e,Ai,l),s(e,k,l),r(k,Ue),r(Ue,hn),w(Xt,hn,null),r(k,wM),r(k,Ta),s(e,_i,l),s(e,xt,l),s(e,ki,l),s(e,Wt,l),s(e,Si,l),s(e,Et,l),s(e,Xi,l),s(e,Ht,l),s(e,xi,l),s(e,S,l),r(S,ue),r(ue,cn),w(Nt,cn,null),r(S,mM),r(S,Ua),s(e,Wi,l),s(e,Vt,l),s(e,Ei,l),s(e,Rt,l),s(e,Hi,l),w(Qt,e,l),s(e,Ni,l),w($t,e,l),s(e,Vi,l),s(e,X,l),r(X,de),r(de,wn),w(Yt,wn,null),r(X,JM),r(X,ua),s(e,Ri,l),s(e,zt,l),s(e,Qi,l),s(e,Ft,l),s(e,$i,l),s(e,Lt,l),s(e,Yi,l),s(e,qt,l),s(e,zi,l),s(e,Pt,l),s(e,Fi,l),s(e,Kt,l),s(e,Li,l),s(e,Dt,l),s(e,qi,l),s(e,Ot,l),s(e,Pi,l),w(el,e,l),s(e,Ki,l),s(e,x,l),r(x,je),r(je,mn),w(tl,mn,null),r(x,TM),r(x,da),s(e,Di,l),s(e,ll,l),s(e,Oi,l),s(e,sl,l),s(e,eo,l),w(al,e,l),s(e,to,l),s(e,W,l),r(W,Ie),r(Ie,Jn),w(nl,Jn,null),r(W,UM),r(W,ja),s(e,lo,l),s(e,il,l),s(e,so,l),w(ol,e,l),s(e,ao,l),w(rl,e,l),s(e,no,l),s(e,pl,l),s(e,io,l),s(e,E,l),r(E,Ce),r(Ce,Tn),w(Ml,Tn,null),r(E,uM),r(E,Ia),s(e,oo,l),s(e,H,l),r(H,fe),r(fe,Un),w(yl,Un,null),r(H,dM),r(H,Ca),s(e,ro,l),s(e,N,l),r(N,ve),r(ve,un),w(hl,un,null),r(N,jM),r(N,fa),s(e,po,l),s(e,V,l),r(V,be),r(be,dn),w(cl,dn,null),r(V,IM),r(V,va),s(e,Mo,l),s(e,wl,l),s(e,yo,l),s(e,ml,l),s(e,ho,l),s(e,Jl,l),s(e,co,l),s(e,R,l),r(R,ge),r(ge,jn),w(Tl,jn,null),r(R,CM),r(R,ba),s(e,wo,l),s(e,Ul,l),s(e,mo,l),s(e,ul,l),s(e,Jo,l),s(e,dl,l),s(e,To,l),s(e,jl,l),s(e,Uo,l),s(e,Il,l),s(e,uo,l),w(Cl,e,l),s(e,jo,l),w(fl,e,l),s(e,Io,l),w(vl,e,l),s(e,Co,l),s(e,Q,l),r(Q,Be),r(Be,In),w(bl,In,null),r(Q,fM),r(Q,ga),s(e,fo,l),s(e,gl,l),s(e,vo,l),s(e,Bl,l),s(e,bo,l),s(e,Gl,l),s(e,go,l),s(e,Zl,l),s(e,Bo,l),s(e,Al,l),s(e,Go,l),w(_l,e,l),s(e,Zo,l),s(e,$,l),r($,Ge),r(Ge,Cn),w(kl,Cn,null),r($,vM),r($,Ba),s(e,Ao,l),w(Sl,e,l),s(e,_o,l),s(e,Xl,l),s(e,ko,l),s(e,xl,l),s(e,So,l),w(Wl,e,l),s(e,Xo,l),s(e,El,l),s(e,xo,l),s(e,Hl,l),s(e,Wo,l),s(e,Y,l),r(Y,Ze),r(Ze,fn),w(Nl,fn,null),r(Y,bM),r(Y,Ga),s(e,Eo,l),w(Vl,e,l),s(e,Ho,l),s(e,Rl,l),s(e,No,l),s(e,Ql,l),s(e,Vo,l),s(e,z,l),r(z,Ae),r(Ae,vn),w($l,vn,null),r(z,gM),r(z,Za),s(e,Ro,l),s(e,Yl,l),s(e,Qo,l),s(e,zl,l),s(e,$o,l),s(e,Fl,l),s(e,Yo,l),s(e,Ll,l),s(e,zo,l),s(e,Aa,l),r(Aa,ql),r(ql,BM),r(ql,_a),r(ql,I),r(I,ka),r(I,GM),r(I,_e),r(_e,ZM),Fo.m(om,_e),r(_e,Lo),qo.m(rm,_e),r(I,AM),r(I,ke),r(ke,_M),Po.m(pm,ke),r(ke,Ko),r(ke,Sa),r(I,kM),r(I,Xa),r(Xa,SM),r(Xa,Pl),r(Pl,XM),Do.m(Mm,Pl),r(Pl,Oo),r(I,xM),r(I,Kl),r(Kl,WM),er.m(ym,Kl),r(Kl,tr),r(I,EM),r(I,xa),r(xa,HM),lr.m(hm,xa),s(e,sr,l),w(Dl,e,l),s(e,ar,l),s(e,F,l),r(F,Se),r(Se,bn),w(Ol,bn,null),r(F,NM),r(F,Wa),s(e,nr,l),w(es,e,l),s(e,ir,l),s(e,L,l),r(L,Xe),r(Xe,gn),w(ts,gn,null),r(L,VM),r(L,Ea),s(e,or,l),w(ls,e,l),s(e,rr,l),w(ss,e,l),s(e,pr,l),w(as,e,l),s(e,Mr,l),s(e,q,l),r(q,xe),r(xe,Bn),w(ns,Bn,null),r(q,RM),r(q,Ha),s(e,yr,l),w(is,e,l),s(e,hr,l),s(e,P,l),r(P,We),r(We,Gn),w(os,Gn,null),r(P,QM),r(P,Na),s(e,cr,l),w(rs,e,l),s(e,wr,l),s(e,K,l),r(K,Ee),r(Ee,Zn),w(ps,Zn,null),r(K,$M),r(K,Va),s(e,mr,l),s(e,Ms,l),s(e,Jr,l),s(e,Ra,l),s(e,Tr,l),s(e,D,l),r(D,He),r(He,An),w(ys,An,null),r(D,YM),r(D,Qa),s(e,Ur,l),s(e,O,l),r(O,Ne),r(Ne,_n),w(hs,_n,null),r(O,zM),r(O,$a),s(e,ur,l),w(cs,e,l),s(e,dr,l),w(ws,e,l),s(e,jr,l),w(ms,e,l),s(e,Ir,l),s(e,Js,l),s(e,Cr,l),s(e,Ts,l),s(e,fr,l),s(e,Us,l),s(e,vr,l),s(e,us,l),s(e,br,l),s(e,ds,l),s(e,gr,l),s(e,js,l),s(e,Br,l),s(e,Is,l),s(e,Gr,l),s(e,Cs,l),s(e,Zr,l),w(fs,e,l),s(e,Ar,l),s(e,vs,l),s(e,_r,l),s(e,bs,l),s(e,kr,l),w(gs,e,l),s(e,Sr,l),s(e,Bs,l),s(e,Xr,l),s(e,ee,l),r(ee,Ve),r(Ve,kn),w(Gs,kn,null),r(ee,FM),r(ee,Ya),s(e,xr,l),s(e,te,l),r(te,Re),r(Re,Sn),w(Zs,Sn,null),r(te,LM),r(te,za),s(e,Wr,l),w(As,e,l),s(e,Er,l),w(_s,e,l),s(e,Hr,l),w(ks,e,l),s(e,Nr,l),s(e,Ss,l),s(e,Vr,l),s(e,Xs,l),s(e,Rr,l),s(e,xs,l),s(e,Qr,l),s(e,Ws,l),s(e,$r,l),s(e,Es,l),s(e,Yr,l),s(e,Hs,l),s(e,zr,l),s(e,le,l),r(le,Qe),r(Qe,Xn),w(Ns,Xn,null),r(le,qM),r(le,Fa),s(e,Fr,l),w(Vs,e,l),s(e,Lr,l),s(e,se,l),r(se,$e),r($e,xn),w(Rs,xn,null),r(se,PM),r(se,La),s(e,qr,l),w(Qs,e,l),s(e,Pr,l),s(e,ae,l),r(ae,Ye),r(Ye,Wn),w($s,Wn,null),r(ae,KM),r(ae,qa),s(e,Kr,l),w(Ys,e,l),s(e,Dr,l),s(e,ne,l),r(ne,ze),r(ze,En),w(zs,En,null),r(ne,DM),r(ne,Pa),s(e,Or,l),w(Fs,e,l),s(e,ep,l),w(Ls,e,l),s(e,tp,l),s(e,ie,l),r(ie,Fe),r(Fe,Hn),w(qs,Hn,null),r(ie,OM),r(ie,Ka),s(e,lp,l),w(Ps,e,l),s(e,sp,l),s(e,oe,l),r(oe,Le),r(Le,Nn),w(Ks,Nn,null),r(oe,ey),r(oe,Da),s(e,ap,l),s(e,Ds,l),s(e,np,l),s(e,Os,l),s(e,ip,l),s(e,ea,l),s(e,op,l),s(e,ta,l),s(e,rp,l),s(e,pp,l),s(e,Mp,l),s(e,la,l),s(e,yp,l),s(e,sa,l),s(e,hp,l),s(e,aa,l),s(e,cp,l),s(e,na,l),s(e,wp,l),s(e,ia,l),s(e,mp,l),s(e,oa,l),s(e,Jp,l),s(e,re,l),r(re,qe),r(qe,Vn),w(ra,Vn,null),r(re,ty),r(re,Oa),s(e,Tp,l),s(e,Rn,l),Up=!0},p:wm,i(e){Up||(m(Ke.$$.fragment,e),m(De.$$.fragment,e),m(yt.$$.fragment,e),m(dt.$$.fragment,e),m(It.$$.fragment,e),m(vt.$$.fragment,e),m(Bt.$$.fragment,e),m(At.$$.fragment,e),m(_t.$$.fragment,e),m(Xt.$$.fragment,e),m(Nt.$$.fragment,e),m(Qt.$$.fragment,e),m($t.$$.fragment,e),m(Yt.$$.fragment,e),m(el.$$.fragment,e),m(tl.$$.fragment,e),m(al.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(rl.$$.fragment,e),m(Ml.$$.fragment,e),m(yl.$$.fragment,e),m(hl.$$.fragment,e),m(cl.$$.fragment,e),m(Tl.$$.fragment,e),m(Cl.$$.fragment,e),m(fl.$$.fragment,e),m(vl.$$.fragment,e),m(bl.$$.fragment,e),m(_l.$$.fragment,e),m(kl.$$.fragment,e),m(Sl.$$.fragment,e),m(Wl.$$.fragment,e),m(Nl.$$.fragment,e),m(Vl.$$.fragment,e),m($l.$$.fragment,e),m(Dl.$$.fragment,e),m(Ol.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(ls.$$.fragment,e),m(ss.$$.fragment,e),m(as.$$.fragment,e),m(ns.$$.fragment,e),m(is.$$.fragment,e),m(os.$$.fragment,e),m(rs.$$.fragment,e),m(ps.$$.fragment,e),m(ys.$$.fragment,e),m(hs.$$.fragment,e),m(cs.$$.fragment,e),m(ws.$$.fragment,e),m(ms.$$.fragment,e),m(fs.$$.fragment,e),m(gs.$$.fragment,e),m(Gs.$$.fragment,e),m(Zs.$$.fragment,e),m(As.$$.fragment,e),m(_s.$$.fragment,e),m(ks.$$.fragment,e),m(Ns.$$.fragment,e),m(Vs.$$.fragment,e),m(Rs.$$.fragment,e),m(Qs.$$.fragment,e),m($s.$$.fragment,e),m(Ys.$$.fragment,e),m(zs.$$.fragment,e),m(Fs.$$.fragment,e),m(Ls.$$.fragment,e),m(qs.$$.fragment,e),m(Ps.$$.fragment,e),m(Ks.$$.fragment,e),m(ra.$$.fragment,e),Up=!0)},o(e){J(Ke.$$.fragment,e),J(De.$$.fragment,e),J(yt.$$.fragment,e),J(dt.$$.fragment,e),J(It.$$.fragment,e),J(vt.$$.fragment,e),J(Bt.$$.fragment,e),J(At.$$.fragment,e),J(_t.$$.fragment,e),J(Xt.$$.fragment,e),J(Nt.$$.fragment,e),J(Qt.$$.fragment,e),J($t.$$.fragment,e),J(Yt.$$.fragment,e),J(el.$$.fragment,e),J(tl.$$.fragment,e),J(al.$$.fragment,e),J(nl.$$.fragment,e),J(ol.$$.fragment,e),J(rl.$$.fragment,e),J(Ml.$$.fragment,e),J(yl.$$.fragment,e),J(hl.$$.fragment,e),J(cl.$$.fragment,e),J(Tl.$$.fragment,e),J(Cl.$$.fragment,e),J(fl.$$.fragment,e),J(vl.$$.fragment,e),J(bl.$$.fragment,e),J(_l.$$.fragment,e),J(kl.$$.fragment,e),J(Sl.$$.fragment,e),J(Wl.$$.fragment,e),J(Nl.$$.fragment,e),J(Vl.$$.fragment,e),J($l.$$.fragment,e),J(Dl.$$.fragment,e),J(Ol.$$.fragment,e),J(es.$$.fragment,e),J(ts.$$.fragment,e),J(ls.$$.fragment,e),J(ss.$$.fragment,e),J(as.$$.fragment,e),J(ns.$$.fragment,e),J(is.$$.fragment,e),J(os.$$.fragment,e),J(rs.$$.fragment,e),J(ps.$$.fragment,e),J(ys.$$.fragment,e),J(hs.$$.fragment,e),J(cs.$$.fragment,e),J(ws.$$.fragment,e),J(ms.$$.fragment,e),J(fs.$$.fragment,e),J(gs.$$.fragment,e),J(Gs.$$.fragment,e),J(Zs.$$.fragment,e),J(As.$$.fragment,e),J(_s.$$.fragment,e),J(ks.$$.fragment,e),J(Ns.$$.fragment,e),J(Vs.$$.fragment,e),J(Rs.$$.fragment,e),J(Qs.$$.fragment,e),J($s.$$.fragment,e),J(Ys.$$.fragment,e),J(zs.$$.fragment,e),J(Fs.$$.fragment,e),J(Ls.$$.fragment,e),J(qs.$$.fragment,e),J(Ps.$$.fragment,e),J(Ks.$$.fragment,e),J(ra.$$.fragment,e),Up=!1},d(e){e&&(t(Yn),t(ln),t(zn),t(v),t(Fn),t(Ln),t(Oe),t(qn),t(et),t(Pn),t(Me),t(Kn),t(tt),t(Dn),t(lt),t(On),t(st),t(ei),t(at),t(ti),t(nt),t(li),t(it),t(si),t(ot),t(ai),t(rt),t(ni),t(pt),t(ii),t(Mt),t(oi),t(b),t(ri),t(ht),t(pi),t(ct),t(Mi),t(wt),t(yi),t(mt),t(hi),t(Jt),t(ci),t(Tt),t(wi),t(Ut),t(mi),t(ut),t(Ji),t(g),t(Ti),t(jt),t(Ui),t(B),t(ui),t(Ct),t(di),t(ft),t(ji),t(G),t(Ii),t(bt),t(Ci),t(gt),t(fi),t(Z),t(vi),t(Gt),t(bi),t(Zt),t(gi),t(A),t(Bi),t(_),t(Gi),t(kt),t(Zi),t(St),t(Ai),t(k),t(_i),t(xt),t(ki),t(Wt),t(Si),t(Et),t(Xi),t(Ht),t(xi),t(S),t(Wi),t(Vt),t(Ei),t(Rt),t(Hi),t(Ni),t(Vi),t(X),t(Ri),t(zt),t(Qi),t(Ft),t($i),t(Lt),t(Yi),t(qt),t(zi),t(Pt),t(Fi),t(Kt),t(Li),t(Dt),t(qi),t(Ot),t(Pi),t(Ki),t(x),t(Di),t(ll),t(Oi),t(sl),t(eo),t(to),t(W),t(lo),t(il),t(so),t(ao),t(no),t(pl),t(io),t(E),t(oo),t(H),t(ro),t(N),t(po),t(V),t(Mo),t(wl),t(yo),t(ml),t(ho),t(Jl),t(co),t(R),t(wo),t(Ul),t(mo),t(ul),t(Jo),t(dl),t(To),t(jl),t(Uo),t(Il),t(uo),t(jo),t(Io),t(Co),t(Q),t(fo),t(gl),t(vo),t(Bl),t(bo),t(Gl),t(go),t(Zl),t(Bo),t(Al),t(Go),t(Zo),t($),t(Ao),t(_o),t(Xl),t(ko),t(xl),t(So),t(Xo),t(El),t(xo),t(Hl),t(Wo),t(Y),t(Eo),t(Ho),t(Rl),t(No),t(Ql),t(Vo),t(z),t(Ro),t(Yl),t(Qo),t(zl),t($o),t(Fl),t(Yo),t(Ll),t(zo),t(Aa),t(sr),t(ar),t(F),t(nr),t(ir),t(L),t(or),t(rr),t(pr),t(Mr),t(q),t(yr),t(hr),t(P),t(cr),t(wr),t(K),t(mr),t(Ms),t(Jr),t(Ra),t(Tr),t(D),t(Ur),t(O),t(ur),t(dr),t(jr),t(Ir),t(Js),t(Cr),t(Ts),t(fr),t(Us),t(vr),t(us),t(br),t(ds),t(gr),t(js),t(Br),t(Is),t(Gr),t(Cs),t(Zr),t(Ar),t(vs),t(_r),t(bs),t(kr),t(Sr),t(Bs),t(Xr),t(ee),t(xr),t(te),t(Wr),t(Er),t(Hr),t(Nr),t(Ss),t(Vr),t(Xs),t(Rr),t(xs),t(Qr),t(Ws),t($r),t(Es),t(Yr),t(Hs),t(zr),t(le),t(Fr),t(Lr),t(se),t(qr),t(Pr),t(ae),t(Kr),t(Dr),t(ne),t(Or),t(ep),t(tp),t(ie),t(lp),t(sp),t(oe),t(ap),t(Ds),t(np),t(Os),t(ip),t(ea),t(op),t(ta),t(rp),t(pp),t(Mp),t(la),t(yp),t(sa),t(hp),t(aa),t(cp),t(na),t(wp),t(ia),t(mp),t(oa),t(Jp),t(re),t(Tp),t(Rn)),t(f),T(Ke),T(De,e),T(yt),T(dt),T(It),T(vt),T(Bt),T(At),T(_t),T(Xt),T(Nt),T(Qt,e),T($t,e),T(Yt),T(el,e),T(tl),T(al,e),T(nl),T(ol,e),T(rl,e),T(Ml),T(yl),T(hl),T(cl),T(Tl),T(Cl,e),T(fl,e),T(vl,e),T(bl),T(_l,e),T(kl),T(Sl,e),T(Wl,e),T(Nl),T(Vl,e),T($l),T(Dl,e),T(Ol),T(es,e),T(ts),T(ls,e),T(ss,e),T(as,e),T(ns),T(is,e),T(os),T(rs,e),T(ps),T(ys),T(hs),T(cs,e),T(ws,e),T(ms,e),T(fs,e),T(gs,e),T(Gs),T(Zs),T(As,e),T(_s,e),T(ks,e),T(Ns),T(Vs,e),T(Rs),T(Qs,e),T($s),T(Ys,e),T(zs),T(Fs,e),T(Ls,e),T(qs),T(Ps,e),T(Ks),T(ra)}}}const jm={local:"first-agent-playing-cartpolev1",sections:[{local:"create-the-cartpole-environment-and-understand-how-it-works",sections:[{local:"the-environment-httpswwwgymlibrarydevenvironmentsclassiccontrolcartpole",title:"[The environment 🎮](https://www.gymlibrary.dev/environments/classic_control/cart_pole/)"},{local:"why-do-we-use-a-simple-environment-like-cartpolev1",title:"Why do we use a simple environment like CartPole-v1?"},{local:"the-cartpolev1-environment",title:"The CartPole-v1 environment"}],title:"Create the CartPole environment and understand how it works"},{local:"lets-build-the-reinforce-architecture",sections:[{local:"solution",title:"Solution"},{local:"real-solution",title:"(Real) Solution"},{local:"lets-build-the-reinforce-training-algorithm",sections:[{local:"solution",title:"Solution"}],title:"Let's build the Reinforce Training Algorithm"}],title:"Let's build the Reinforce Architecture"},{local:"train-it",title:"Train it"},{local:"define-evaluation-method",title:"Define evaluation method 📝"},{local:"evaluate-our-agent",sections:[{local:"publish-our-trained-model-on-the-hub",title:"Publish our trained model on the Hub 🔥"},{local:"push-to-the-hub",sections:[{local:"do-not-modify-this-code",title:"Do not modify this code"}],title:"Push to the Hub"}],title:"Evaluate our agent 📈"},{local:"second-agent-pixelcopter",sections:[{local:"study-the-pixelcopter-environment",title:"Study the PixelCopter environment 👀"},{local:"define-the-new-policy",sections:[{local:"solution",title:"Solution"}],title:"Define the new Policy 🧠"},{local:"define-the-hyperparameters",title:"Define the hyperparameters ⚙️"},{local:"train-it",title:"Train it"},{local:"publish-our-trained-model-on-the-hub",title:"Publish our trained model on the Hub 🔥"}],title:"Second agent: PixelCopter 🚁"},{local:"some-additional-challenges",sections:[{local:"keep-learning-stay-awesome",title:"Keep Learning, stay awesome 🤗"}],title:"Some additional challenges 🏆"}],title:"First agent: Playing CartPole-v1 🤖"};function Im(ay){return mm(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bm extends Jm{constructor(f){super(),Tm(this,f,Im,dm,cm,{})}}export{Bm as component};
