import{s as Lr,f as As,n as Yr,o as Fr}from"../chunks/scheduler.37c15a92.js";import{S as Xr,i as zr,g as a,s as i,u as c,A as Rr,h as s,f as t,c as o,j as u,v as m,y as p,k as r,o as h,a as n,w as d,d as v,t as f,x as y}from"../chunks/index.b01106c0.js";import{I as w}from"../chunks/IconCopyLink.77b762b4.js";import{C as M}from"../chunks/CodeBlock.00a4ae02.js";import{C as qr}from"../chunks/CourseFloatingBanner.9c5d96ce.js";function Dr(ci){let b,mn,Nl,dn,g,Y,Al,ve,Ps,fl,mi="Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",vn,fe,fn,ye,di="Now that you’ve studied the theory behind Advantage Actor Critic (A2C), <strong>you’re ready to train your A2C agent</strong> using Stable-Baselines3 in a robotic environment. And train a:",yn,we,vi="<li>A robotic arm 🦾 to move to the correct position.</li>",wn,Me,fi="We’re going to use",Mn,be,yi='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">panda-gym</a></li>',bn,ge,wi="To validate this hands-on for the certification process, you need to push your two trained models to the Hub and get the following results:",gn,Te,Mi="<li><code>PandaReachDense-v3</code> get a result of &gt;= -3.5.</li>",Tn,Ue,bi='To find your result, <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">go to the leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Un,Ce,gi='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',Cn,Je,Ti="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",Jn,_e,Ui='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit6/unit6.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',_n,T,F,Pl,$e,Qs,yl,Ci="Unit 6: Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",$n,U,X,Ql,je,Ls,wl,Ji="🎮 Environments:",jn,ke,_i='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">Panda-Gym</a></li>',kn,C,z,Ll,xe,Ys,Ml,$i="📚 RL-Library:",xn,Ze,ji='<li><a href="https://stable-baselines3.readthedocs.io/" rel="nofollow">Stable-Baselines3</a></li>',Zn,Ie,ki='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',In,J,R,Yl,We,Fs,bl,xi="Objectives of this notebook 🏆",Wn,Be,Zi="At the end of the notebook, you will:",Bn,Ge,Ii="<li>Be able to use <strong>Panda-Gym</strong>, the environment library.</li> <li>Be able to <strong>train robots using A2C</strong>.</li> <li>Understand why <strong>we need to normalize the input</strong>.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Gn,_,q,Fl,Ee,Xs,gl,Wi="Prerequisites 🏗️",En,Se,Bi="Before diving into the notebook, you need to:",Sn,He,Gi='🔲 📚 Study <a href="https://huggingface.co/deep-rl-course/unit6/introduction" rel="nofollow">Actor-Critic methods by reading Unit 6</a> 🤗',Hn,$,D,Xl,Ve,zs,Tl,Ei="Let's train our first robots 🤖",Vn,j,K,zl,Ne,Rs,Ul,Si="Set the GPU 💪",Nn,Ae,Hi="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",An,Pe,Vi,Pn,Qe,Ni="<li><code>Hardware Accelerator &gt; GPU</code></li>",Qn,Le,Ai,Ln,k,O,Rl,Ye,qs,Cl,Pi="Create a virtual display 🔽",Yn,Fe,Qi="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",Fn,Xe,Li="The following cell will install the librairies and create and run a virtual screen 🖥",Xn,ze,zn,Re,Rn,x,ee,ql,qe,Ds,Jl,Yi="Install dependencies 🔽",qn,De,Fi="We’ll install multiple ones:",Dn,Ke,Xi="<li><code>gymnasium</code></li> <li><code>panda-gym</code>: Contains the robotics arm environments.</li> <li><code>stable-baselines3</code>: The SB3 deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li> <li><code>huggingface_hub</code>: Library allowing anyone to work with the Hub repositories.</li>",Kn,Oe,On,Z,te,Dl,et,Ks,_l,zi="Import the packages 📦",ea,tt,ta,I,le,Kl,lt,Os,$l,Ri="PandaReachDense-v3 🦾",la,nt,qi="The agent we’re going to train is a robotic arm that needs to do controls (moving the arm and using the end-effector).",na,at,Di="In robotics, the <em>end-effector</em> is the device at the end of a robotic arm designed to interact with the environment.",aa,st,Ki="In <code>PandaReach</code>, the robot must place its end-effector at a target position (green ball).",sa,it,Oi="We’re going to use the dense version of this environment. It means we’ll get a <em>dense reward function</em> that <strong>will provide a reward at each timestep</strong> (the closer the agent is to completing the task, the higher the reward). Contrary to a <em>sparse reward function</em> where the environment <strong>return a reward if and only if the task is completed</strong>.",ia,ot,eo="Also, we’re going to use the <em>End-effector displacement control</em>, it means the <strong>action corresponds to the displacement of the end-effector</strong>. We don’t control the individual motion of each joint (joint control).",oa,rt,to,ra,ht,lo="This way <strong>the training will be easier</strong>.",ha,W,ne,Ol,pt,ei,jl,no="Create the environment",pa,B,ae,en,ut,ti,kl,ao="The environment 🎮",ua,ct,so="In <code>PandaReachDense-v3</code> the robotic arm must place its end-effector at a target position (green ball).",ca,mt,ma,dt,da,vt,io="The observation space <strong>is a dictionary with 3 different elements</strong>:",va,ft,oo="<li><code>achieved_goal</code>: (x,y,z) position of the goal.</li> <li><code>desired_goal</code>: (x,y,z) distance between the goal position and the current object position.</li> <li><code>observation</code>: position (x,y,z) and velocity of the end-effector (vx, vy, vz).</li>",fa,yt,ro="Given it’s a dictionary as observation, <strong>we will need to use a MultiInputPolicy policy instead of MlpPolicy</strong>.",ya,wt,wa,Mt,ho="The action space is a vector with 3 values:",Ma,bt,po="<li>Control x, y, z movement</li>",ba,G,se,tn,gt,li,xl,uo="Normalize observation and rewards",ga,Tt,co='A good practice in reinforcement learning is to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">normalize input features</a>.',Ta,Ut,mo="For that purpose, there is a wrapper that will compute a running average and standard deviation of input features.",Ua,Ct,vo="We also normalize rewards with this same wrapper by adding <code>norm_reward = True</code>",Ca,Jt,fo='<a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">You should check the documentation to fill this cell</a>',Ja,_t,_a,E,ie,ln,$t,ni,Zl,yo="Solution",$a,jt,ja,S,oe,nn,kt,ai,Il,wo="Create the A2C Model 🤖",ka,xt,Mo='For more information about A2C implementation with StableBaselines3 check: <a href="https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes</a>',xa,Zt,bo='To find the best parameters I checked the <a href="https://huggingface.co/sb3" rel="nofollow">official trained agents by Stable-Baselines3 team</a>.',Za,It,Ia,H,re,an,Wt,si,Wl,go="Solution",Wa,Bt,Ba,V,he,sn,Gt,ii,Bl,To="Train the A2C agent 🏃",Ga,Et,Uo="<li>Let’s train our agent for 1,000,000 timesteps, don’t forget to use GPU on Colab. It will take approximately ~25-40min</li>",Ea,St,Sa,Ht,Ha,N,pe,on,Vt,oi,Gl,Co="Evaluate the agent 📈",Va,Nt,Jo="<li>Now that’s our  agent is trained, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code></li>",Na,At,Aa,A,ue,rn,Pt,ri,El,_o="Publish your trained model on the Hub 🔥",Pa,Qt,$o="Now that we saw we got good results after the training, we can publish our trained model on the Hub with one line of code.",Qa,Lt,jo='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',La,Yt,ko="By using <code>package_to_hub</code>, as we already mentionned in the former units, <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",Ya,Ft,xo="This way:",Fa,Xt,Zo='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Xa,zt,Io="To be able to share your model with the community there are three more steps to follow:",za,Rt,Wo='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',Ra,qt,Bo="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",qa,Dt,Go='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Da,Kt,Eo,Ka,Ot,So="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",Oa,el,es,tl,Ho="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",ts,ll,Vo=`3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function.
For this environment, <strong>running this cell can take approximately 10min</strong>`,ls,nl,ns,P,ce,hn,al,hi,Sl,No="Some additional challenges 🏆",as,sl,Ao="The best way to learn <strong>is to try things by your own</strong>! Why not trying  <code>PandaPickAndPlace-v3</code>?",ss,il,Po="If you want to try more advanced tasks for panda-gym, you need to check what was done using <strong>TQC or SAC</strong> (a more sample-efficient algorithm suited for robotics tasks). In real robotics, you’ll use a more sample-efficient algorithm for a simple reason: contrary to a simulation <strong>if you move your robotic arm too much, you have a risk of breaking it</strong>.",is,ol,Qo='PandaPickAndPlace-v1 (this model uses the v1 version of the environment): <a href="https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1" rel="nofollow">https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1</a>',os,rl,Lo='And don’t hesitate to check panda-gym documentation here: <a href="https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html" rel="nofollow">https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html</a>',rs,hl,Yo="We provide you the steps to train another agent (optional):",hs,pl,Fo='<li>Define the environment called “PandaPickAndPlace-v3”</li> <li>Make a vectorized environment</li> <li>Add a wrapper to normalize the observations and rewards. <a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">Check the documentation</a></li> <li>Create the A2C Model (don’t forget verbose=1 to print the training logs).</li> <li>Train it for 1M Timesteps</li> <li>Save the model and  VecNormalize statistics when saving the agent</li> <li>Evaluate your agent</li> <li>Publish your trained model on the Hub 🔥 with <code>package_to_hub</code></li>',ps,Q,me,pn,ul,pi,Hl,Xo="Solution (optional)",us,cl,cs,ml,ms,dl,zo="See you on Unit 7! 🔥",ds,L,de,un,vl,ui,Vl,Ro="Keep learning, stay awesome 🤗",vs,cn,fs;return ve=new w({}),fe=new qr({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit6/unit6.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),$e=new w({}),je=new w({}),xe=new w({}),We=new w({}),Ee=new w({}),Ve=new w({}),Ne=new w({}),Ye=new w({}),ze=new M({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcDMlMjBpbnN0YWxsJTIwcHl2aXJ0dWFsZGlzcGxheQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip3 install pyvirtualdisplay`,wrap:!1}}),Re=new M({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),qe=new w({}),Oe=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzdGFibGUtYmFzZWxpbmVzMyU1QmV4dHJhJTVEJTBBIXBpcCUyMGluc3RhbGwlMjBneW1uYXNpdW0lMEEhcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX3NiMyUwQSFwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBIXBpcCUyMGluc3RhbGwlMjBwYW5kYV9neW0=",highlighted:`!pip install stable-baselines3[extra]
!pip install gymnasium
!pip install huggingface_sb3
!pip install huggingface_hub
!pip install panda_gym`,wrap:!1}}),et=new w({}),tt=new M({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBneW1uYXNpdW0lMjBhcyUyMGd5bSUwQWltcG9ydCUyMHBhbmRhX2d5bSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9zYjMlMjBpbXBvcnQlMjBsb2FkX2Zyb21faHViJTJDJTIwcGFja2FnZV90b19odWIlMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBBMkMlMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmV2YWx1YXRpb24lMjBpbXBvcnQlMjBldmFsdWF0ZV9wb2xpY3klMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLnZlY19lbnYlMjBpbXBvcnQlMjBEdW1teVZlY0VudiUyQyUyMFZlY05vcm1hbGl6ZSUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24uZW52X3V0aWwlMjBpbXBvcnQlMjBtYWtlX3ZlY19lbnYlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbm90ZWJvb2tfbG9naW4=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">import</span> panda_gym

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> A2C
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login`,wrap:!1}}),lt=new w({}),pt=new w({}),ut=new w({}),mt=new M({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFSZWFjaERlbnNlLXYzJTIyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52JTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSUwQWFfc2l6ZSUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2U=",highlighted:`env_id = <span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>

<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape
a_size = env.action_space`,wrap:!1}}),dt=new M({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample()) <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),wt=new M({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample()) <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),gt=new w({}),_t=new M({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBJTIzJTIwQWRkaW5nJTIwdGhpcyUyMHdyYXBwZXIlMjB0byUyMG5vcm1hbGl6ZSUyMHRoZSUyMG9ic2VydmF0aW9uJTIwYW5kJTIwdGhlJTIwcmV3YXJkJTBBZW52JTIwJTNEJTIwJTIzJTIwVE9ETyUzQSUyMEFkZCUyMHRoZSUyMHdyYXBwZXI=",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># Adding this wrapper to normalize the observation and the reward</span>
env = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Add the wrapper</span>`,wrap:!1}}),$t=new w({}),jt=new M({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKQ==",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)`,wrap:!1}}),kt=new w({}),It=new M({props:{code:"bW9kZWwlMjAlM0QlMjAlMjMlMjBDcmVhdGUlMjB0aGUlMjBBMkMlMjBtb2RlbCUyMGFuZCUyMHRyeSUyMHRvJTIwZmluZCUyMHRoZSUyMGJlc3QlMjBwYXJhbWV0ZXJz",highlighted:'model = <span class="hljs-comment"># Create the A2C model and try to find the best parameters</span>',wrap:!1}}),Wt=new w({}),Bt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBMkMocG9saWN5JTIwJTNEJTIwJTIyTXVsdGlJbnB1dFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudiUyMCUzRCUyMGVudiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZlcmJvc2UlM0QxKQ==",highlighted:`model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)`,wrap:!1}}),Gt=new w({}),St=new M({props:{code:"bW9kZWwubGVhcm4oMV8wMDBfMDAwKQ==",highlighted:'model.learn(<span class="hljs-number">1_000_000</span>)',wrap:!1}}),Ht=new M({props:{code:"JTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwJTIwVmVjTm9ybWFsaXplJTIwc3RhdGlzdGljcyUyMHdoZW4lMjBzYXZpbmclMjB0aGUlMjBhZ2VudCUwQW1vZGVsLnNhdmUoJTIyYTJjLVBhbmRhUmVhY2hEZW5zZS12MyUyMiklMEFlbnYuc2F2ZSglMjJ2ZWNfbm9ybWFsaXplLnBrbCUyMik=",highlighted:`<span class="hljs-comment"># Save the model and  VecNormalize statistics when saving the agent</span>
model.save(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)`,wrap:!1}}),Vt=new w({}),At=new M({props:{code:"ZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi52ZWNfZW52JTIwaW1wb3J0JTIwRHVtbXlWZWNFbnYlMkMlMjBWZWNOb3JtYWxpemUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwc2F2ZWQlMjBzdGF0aXN0aWNzJTBBZXZhbF9lbnYlMjAlM0QlMjBEdW1teVZlY0VudiglNUJsYW1iZGElM0ElMjBneW0ubWFrZSglMjJQYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjBXZSUyMG5lZWQlMjB0byUyMG92ZXJyaWRlJTIwdGhlJTIwcmVuZGVyX21vZGUlMEFldmFsX2Vudi5yZW5kZXJfbW9kZSUyMCUzRCUyMCUyMnJnYl9hcnJheSUyMiUwQSUwQSUyMyUyMCUyMGRvJTIwbm90JTIwdXBkYXRlJTIwdGhlbSUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi50cmFpbmluZyUyMCUzRCUyMEZhbHNlJTBBJTIzJTIwcmV3YXJkJTIwbm9ybWFsaXphdGlvbiUyMGlzJTIwbm90JTIwbmVlZGVkJTIwYXQlMjB0ZXN0JTIwdGltZSUwQWV2YWxfZW52Lm5vcm1fcmV3YXJkJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMEEyQy5sb2FkKCUyMmEyYy1QYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTBBJTBBbWVhbl9yZXdhcmQlMkMlMjBzdGRfcmV3YXJkJTIwJTNEJTIwZXZhbHVhdGVfcG9saWN5KG1vZGVsJTJDJTIwZXZhbF9lbnYpJTBBJTBBcHJpbnQoZiUyMk1lYW4lMjByZXdhcmQlMjAlM0QlMjAlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTNBLjJmJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment"># We need to override the render_mode</span>
eval_env.render_mode = <span class="hljs-string">&quot;rgb_array&quot;</span>

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Pt=new w({}),el=new M({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),nl=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMHBhY2thZ2VfdG9faHViJTBBJTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMENoYW5nZSUyMHRoZSUyMHVzZXJuYW1lJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJJbml0aWFsJTIwY29tbWl0JTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),al=new w({}),ul=new w({}),cl=new M({props:{code:"JTIzJTIwMSUyMC0lMjAyJTBBZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoZW52X2lkJTJDJTIwbl9lbnZzJTNENCklMEElMEElMjMlMjAzJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKSUwQSUwQSUyMyUyMDQlMEFtb2RlbCUyMCUzRCUyMEEyQyhwb2xpY3klMjAlM0QlMjAlMjJNdWx0aUlucHV0UG9saWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52JTIwJTNEJTIwZW52JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDEpJTBBJTIzJTIwNSUwQW1vZGVsLmxlYXJuKDFfMDAwXzAwMCk=",highlighted:`<span class="hljs-comment"># 1 - 2</span>
env_id = <span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>
env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># 3</span>
env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)

<span class="hljs-comment"># 4</span>
model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)
<span class="hljs-comment"># 5</span>
model.learn(<span class="hljs-number">1_000_000</span>)`,wrap:!1}}),ml=new M({props:{code:"JTIzJTIwNiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJhMmMtUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlM0IlMEFtb2RlbC5zYXZlKG1vZGVsX25hbWUpJTBBZW52LnNhdmUoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIpJTBBJTBBJTIzJTIwNyUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24udmVjX2VudiUyMGltcG9ydCUyMER1bW15VmVjRW52JTJDJTIwVmVjTm9ybWFsaXplJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHNhdmVkJTIwc3RhdGlzdGljcyUwQWV2YWxfZW52JTIwJTNEJTIwRHVtbXlWZWNFbnYoJTVCbGFtYmRhJTNBJTIwZ3ltLm1ha2UoJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjAlMjBkbyUyMG5vdCUyMHVwZGF0ZSUyMHRoZW0lMjBhdCUyMHRlc3QlMjB0aW1lJTBBZXZhbF9lbnYudHJhaW5pbmclMjAlM0QlMjBGYWxzZSUwQSUyMyUyMHJld2FyZCUyMG5vcm1hbGl6YXRpb24lMjBpcyUyMG5vdCUyMG5lZWRlZCUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi5ub3JtX3Jld2FyZCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGFnZW50JTBBbW9kZWwlMjAlM0QlMjBBMkMubG9hZChtb2RlbF9uYW1lKSUwQSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52KSUwQSUwQXByaW50KGYlMjJNZWFuJTIwcmV3YXJkJTIwJTNEJTIwJTdCbWVhbl9yZXdhcmQlM0EuMmYlN0QlMjAlMkIlMkYtJTIwJTdCc3RkX3Jld2FyZCUzQS4yZiU3RCUyMiklMEElMEElMjMlMjA4JTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMFRPRE8lM0ElMjBDaGFuZ2UlMjB0aGUlMjB1c2VybmFtZSUwQSUyMCUyMCUyMCUyMGNvbW1pdF9tZXNzYWdlJTNEJTIySW5pdGlhbCUyMGNvbW1pdCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># 6</span>
model_name = <span class="hljs-string">&quot;a2c-PandaPickAndPlace-v3&quot;</span>;
model.save(model_name)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)

<span class="hljs-comment"># 7</span>
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(model_name)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># 8</span>
package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),vl=new w({}),{c(){b=a("meta"),mn=i(),Nl=a("p"),dn=i(),g=a("h1"),Y=a("a"),Al=a("span"),c(ve.$$.fragment),Ps=i(),fl=a("span"),fl.textContent=mi,vn=i(),c(fe.$$.fragment),fn=i(),ye=a("p"),ye.innerHTML=di,yn=i(),we=a("ul"),we.innerHTML=vi,wn=i(),Me=a("p"),Me.textContent=fi,Mn=i(),be=a("ul"),be.innerHTML=yi,bn=i(),ge=a("p"),ge.textContent=wi,gn=i(),Te=a("ul"),Te.innerHTML=Mi,Tn=i(),Ue=a("p"),Ue.innerHTML=bi,Un=i(),Ce=a("p"),Ce.innerHTML=gi,Cn=i(),Je=a("p"),Je.innerHTML=Ti,Jn=i(),_e=a("p"),_e.innerHTML=Ui,_n=i(),T=a("h1"),F=a("a"),Pl=a("span"),c($e.$$.fragment),Qs=i(),yl=a("span"),yl.textContent=Ci,$n=i(),U=a("h3"),X=a("a"),Ql=a("span"),c(je.$$.fragment),Ls=i(),wl=a("span"),wl.textContent=Ji,jn=i(),ke=a("ul"),ke.innerHTML=_i,kn=i(),C=a("h3"),z=a("a"),Ll=a("span"),c(xe.$$.fragment),Ys=i(),Ml=a("span"),Ml.textContent=$i,xn=i(),Ze=a("ul"),Ze.innerHTML=ji,Zn=i(),Ie=a("p"),Ie.innerHTML=ki,In=i(),J=a("h2"),R=a("a"),Yl=a("span"),c(We.$$.fragment),Fs=i(),bl=a("span"),bl.textContent=xi,Wn=i(),Be=a("p"),Be.textContent=Zi,Bn=i(),Ge=a("ul"),Ge.innerHTML=Ii,Gn=i(),_=a("h2"),q=a("a"),Fl=a("span"),c(Ee.$$.fragment),Xs=i(),gl=a("span"),gl.textContent=Wi,En=i(),Se=a("p"),Se.textContent=Bi,Sn=i(),He=a("p"),He.innerHTML=Gi,Hn=i(),$=a("h1"),D=a("a"),Xl=a("span"),c(Ve.$$.fragment),zs=i(),Tl=a("span"),Tl.textContent=Ei,Vn=i(),j=a("h2"),K=a("a"),zl=a("span"),c(Ne.$$.fragment),Rs=i(),Ul=a("span"),Ul.textContent=Si,Nn=i(),Ae=a("ul"),Ae.innerHTML=Hi,An=i(),Pe=a("img"),Pn=i(),Qe=a("ul"),Qe.innerHTML=Ni,Qn=i(),Le=a("img"),Ln=i(),k=a("h2"),O=a("a"),Rl=a("span"),c(Ye.$$.fragment),qs=i(),Cl=a("span"),Cl.textContent=Pi,Yn=i(),Fe=a("p"),Fe.innerHTML=Qi,Fn=i(),Xe=a("p"),Xe.textContent=Li,Xn=i(),c(ze.$$.fragment),zn=i(),c(Re.$$.fragment),Rn=i(),x=a("h3"),ee=a("a"),ql=a("span"),c(qe.$$.fragment),Ds=i(),Jl=a("span"),Jl.textContent=Yi,qn=i(),De=a("p"),De.textContent=Fi,Dn=i(),Ke=a("ul"),Ke.innerHTML=Xi,Kn=i(),c(Oe.$$.fragment),On=i(),Z=a("h2"),te=a("a"),Dl=a("span"),c(et.$$.fragment),Ks=i(),_l=a("span"),_l.textContent=zi,ea=i(),c(tt.$$.fragment),ta=i(),I=a("h2"),le=a("a"),Kl=a("span"),c(lt.$$.fragment),Os=i(),$l=a("span"),$l.textContent=Ri,la=i(),nt=a("p"),nt.textContent=qi,na=i(),at=a("p"),at.innerHTML=Di,aa=i(),st=a("p"),st.innerHTML=Ki,sa=i(),it=a("p"),it.innerHTML=Oi,ia=i(),ot=a("p"),ot.innerHTML=eo,oa=i(),rt=a("img"),ra=i(),ht=a("p"),ht.innerHTML=lo,ha=i(),W=a("h3"),ne=a("a"),Ol=a("span"),c(pt.$$.fragment),ei=i(),jl=a("span"),jl.textContent=no,pa=i(),B=a("h4"),ae=a("a"),en=a("span"),c(ut.$$.fragment),ti=i(),kl=a("span"),kl.textContent=ao,ua=i(),ct=a("p"),ct.innerHTML=so,ca=i(),c(mt.$$.fragment),ma=i(),c(dt.$$.fragment),da=i(),vt=a("p"),vt.innerHTML=io,va=i(),ft=a("ul"),ft.innerHTML=oo,fa=i(),yt=a("p"),yt.innerHTML=ro,ya=i(),c(wt.$$.fragment),wa=i(),Mt=a("p"),Mt.textContent=ho,Ma=i(),bt=a("ul"),bt.innerHTML=po,ba=i(),G=a("h3"),se=a("a"),tn=a("span"),c(gt.$$.fragment),li=i(),xl=a("span"),xl.textContent=uo,ga=i(),Tt=a("p"),Tt.innerHTML=co,Ta=i(),Ut=a("p"),Ut.textContent=mo,Ua=i(),Ct=a("p"),Ct.innerHTML=vo,Ca=i(),Jt=a("p"),Jt.innerHTML=fo,Ja=i(),c(_t.$$.fragment),_a=i(),E=a("h4"),ie=a("a"),ln=a("span"),c($t.$$.fragment),ni=i(),Zl=a("span"),Zl.textContent=yo,$a=i(),c(jt.$$.fragment),ja=i(),S=a("h3"),oe=a("a"),nn=a("span"),c(kt.$$.fragment),ai=i(),Il=a("span"),Il.textContent=wo,ka=i(),xt=a("p"),xt.innerHTML=Mo,xa=i(),Zt=a("p"),Zt.innerHTML=bo,Za=i(),c(It.$$.fragment),Ia=i(),H=a("h4"),re=a("a"),an=a("span"),c(Wt.$$.fragment),si=i(),Wl=a("span"),Wl.textContent=go,Wa=i(),c(Bt.$$.fragment),Ba=i(),V=a("h3"),he=a("a"),sn=a("span"),c(Gt.$$.fragment),ii=i(),Bl=a("span"),Bl.textContent=To,Ga=i(),Et=a("ul"),Et.innerHTML=Uo,Ea=i(),c(St.$$.fragment),Sa=i(),c(Ht.$$.fragment),Ha=i(),N=a("h3"),pe=a("a"),on=a("span"),c(Vt.$$.fragment),oi=i(),Gl=a("span"),Gl.textContent=Co,Va=i(),Nt=a("ul"),Nt.innerHTML=Jo,Na=i(),c(At.$$.fragment),Aa=i(),A=a("h3"),ue=a("a"),rn=a("span"),c(Pt.$$.fragment),ri=i(),El=a("span"),El.textContent=_o,Pa=i(),Qt=a("p"),Qt.textContent=$o,Qa=i(),Lt=a("p"),Lt.innerHTML=jo,La=i(),Yt=a("p"),Yt.innerHTML=ko,Ya=i(),Ft=a("p"),Ft.textContent=xo,Fa=i(),Xt=a("ul"),Xt.innerHTML=Zo,Xa=i(),zt=a("p"),zt.textContent=Io,za=i(),Rt=a("p"),Rt.innerHTML=Wo,Ra=i(),qt=a("p"),qt.textContent=Bo,qa=i(),Dt=a("ul"),Dt.innerHTML=Go,Da=i(),Kt=a("img"),Ka=i(),Ot=a("ul"),Ot.innerHTML=So,Oa=i(),c(el.$$.fragment),es=i(),tl=a("p"),tl.innerHTML=Ho,ts=i(),ll=a("p"),ll.innerHTML=Vo,ls=i(),c(nl.$$.fragment),ns=i(),P=a("h2"),ce=a("a"),hn=a("span"),c(al.$$.fragment),hi=i(),Sl=a("span"),Sl.textContent=No,as=i(),sl=a("p"),sl.innerHTML=Ao,ss=i(),il=a("p"),il.innerHTML=Po,is=i(),ol=a("p"),ol.innerHTML=Qo,os=i(),rl=a("p"),rl.innerHTML=Lo,rs=i(),hl=a("p"),hl.textContent=Yo,hs=i(),pl=a("ol"),pl.innerHTML=Fo,ps=i(),Q=a("h3"),me=a("a"),pn=a("span"),c(ul.$$.fragment),pi=i(),Hl=a("span"),Hl.textContent=Xo,us=i(),c(cl.$$.fragment),cs=i(),c(ml.$$.fragment),ms=i(),dl=a("p"),dl.textContent=zo,ds=i(),L=a("h2"),de=a("a"),un=a("span"),c(vl.$$.fragment),ui=i(),Vl=a("span"),Vl.textContent=Ro,vs=i(),cn=a("p"),this.h()},l(e){const l=Rr("svelte-1phssyn",document.head);b=s(l,"META",{name:!0,content:!0}),l.forEach(t),mn=o(e),Nl=s(e,"P",{}),u(Nl).forEach(t),dn=o(e),g=s(e,"H1",{class:!0});var ys=u(g);Y=s(ys,"A",{id:!0,class:!0,href:!0});var qo=u(Y);Al=s(qo,"SPAN",{});var Do=u(Al);m(ve.$$.fragment,Do),Do.forEach(t),qo.forEach(t),Ps=o(ys),fl=s(ys,"SPAN",{"data-svelte-h":!0}),p(fl)!=="svelte-18ix8r7"&&(fl.textContent=mi),ys.forEach(t),vn=o(e),m(fe.$$.fragment,e),fn=o(e),ye=s(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1v5g4pl"&&(ye.innerHTML=di),yn=o(e),we=s(e,"UL",{"data-svelte-h":!0}),p(we)!=="svelte-10o7xql"&&(we.innerHTML=vi),wn=o(e),Me=s(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-f6gxjq"&&(Me.textContent=fi),Mn=o(e),be=s(e,"UL",{"data-svelte-h":!0}),p(be)!=="svelte-1sbq1c5"&&(be.innerHTML=yi),bn=o(e),ge=s(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-30j4nk"&&(ge.textContent=wi),gn=o(e),Te=s(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-1f7nbkh"&&(Te.innerHTML=Mi),Tn=o(e),Ue=s(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-13r3vs2"&&(Ue.innerHTML=bi),Un=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1qkxyrx"&&(Ce.innerHTML=gi),Cn=o(e),Je=s(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-10pdw2g"&&(Je.innerHTML=Ti),Jn=o(e),_e=s(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-t0f4sr"&&(_e.innerHTML=Ui),_n=o(e),T=s(e,"H1",{class:!0});var ws=u(T);F=s(ws,"A",{id:!0,class:!0,href:!0});var Ko=u(F);Pl=s(Ko,"SPAN",{});var Oo=u(Pl);m($e.$$.fragment,Oo),Oo.forEach(t),Ko.forEach(t),Qs=o(ws),yl=s(ws,"SPAN",{"data-svelte-h":!0}),p(yl)!=="svelte-1fz6er"&&(yl.textContent=Ci),ws.forEach(t),$n=o(e),U=s(e,"H3",{class:!0});var Ms=u(U);X=s(Ms,"A",{id:!0,class:!0,href:!0});var er=u(X);Ql=s(er,"SPAN",{});var tr=u(Ql);m(je.$$.fragment,tr),tr.forEach(t),er.forEach(t),Ls=o(Ms),wl=s(Ms,"SPAN",{"data-svelte-h":!0}),p(wl)!=="svelte-ul8fdn"&&(wl.textContent=Ji),Ms.forEach(t),jn=o(e),ke=s(e,"UL",{"data-svelte-h":!0}),p(ke)!=="svelte-w3db45"&&(ke.innerHTML=_i),kn=o(e),C=s(e,"H3",{class:!0});var bs=u(C);z=s(bs,"A",{id:!0,class:!0,href:!0});var lr=u(z);Ll=s(lr,"SPAN",{});var nr=u(Ll);m(xe.$$.fragment,nr),nr.forEach(t),lr.forEach(t),Ys=o(bs),Ml=s(bs,"SPAN",{"data-svelte-h":!0}),p(Ml)!=="svelte-15n18n6"&&(Ml.textContent=$i),bs.forEach(t),xn=o(e),Ze=s(e,"UL",{"data-svelte-h":!0}),p(Ze)!=="svelte-11wwfn0"&&(Ze.innerHTML=ji),Zn=o(e),Ie=s(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-qqj2y4"&&(Ie.innerHTML=ki),In=o(e),J=s(e,"H2",{class:!0});var gs=u(J);R=s(gs,"A",{id:!0,class:!0,href:!0});var ar=u(R);Yl=s(ar,"SPAN",{});var sr=u(Yl);m(We.$$.fragment,sr),sr.forEach(t),ar.forEach(t),Fs=o(gs),bl=s(gs,"SPAN",{"data-svelte-h":!0}),p(bl)!=="svelte-ygr1lr"&&(bl.textContent=xi),gs.forEach(t),Wn=o(e),Be=s(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-nsjs09"&&(Be.textContent=Zi),Bn=o(e),Ge=s(e,"UL",{"data-svelte-h":!0}),p(Ge)!=="svelte-1eap3pb"&&(Ge.innerHTML=Ii),Gn=o(e),_=s(e,"H2",{class:!0});var Ts=u(_);q=s(Ts,"A",{id:!0,class:!0,href:!0});var ir=u(q);Fl=s(ir,"SPAN",{});var or=u(Fl);m(Ee.$$.fragment,or),or.forEach(t),ir.forEach(t),Xs=o(Ts),gl=s(Ts,"SPAN",{"data-svelte-h":!0}),p(gl)!=="svelte-14bgx92"&&(gl.textContent=Wi),Ts.forEach(t),En=o(e),Se=s(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1v25wk6"&&(Se.textContent=Bi),Sn=o(e),He=s(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-rlt93v"&&(He.innerHTML=Gi),Hn=o(e),$=s(e,"H1",{class:!0});var Us=u($);D=s(Us,"A",{id:!0,class:!0,href:!0});var rr=u(D);Xl=s(rr,"SPAN",{});var hr=u(Xl);m(Ve.$$.fragment,hr),hr.forEach(t),rr.forEach(t),zs=o(Us),Tl=s(Us,"SPAN",{"data-svelte-h":!0}),p(Tl)!=="svelte-myrm1x"&&(Tl.textContent=Ei),Us.forEach(t),Vn=o(e),j=s(e,"H2",{class:!0});var Cs=u(j);K=s(Cs,"A",{id:!0,class:!0,href:!0});var pr=u(K);zl=s(pr,"SPAN",{});var ur=u(zl);m(Ne.$$.fragment,ur),ur.forEach(t),pr.forEach(t),Rs=o(Cs),Ul=s(Cs,"SPAN",{"data-svelte-h":!0}),p(Ul)!=="svelte-wdjh5x"&&(Ul.textContent=Si),Cs.forEach(t),Nn=o(e),Ae=s(e,"UL",{"data-svelte-h":!0}),p(Ae)!=="svelte-1funvfi"&&(Ae.innerHTML=Hi),An=o(e),Pe=s(e,"IMG",{src:!0,alt:!0}),Pn=o(e),Qe=s(e,"UL",{"data-svelte-h":!0}),p(Qe)!=="svelte-1cge6gn"&&(Qe.innerHTML=Ni),Qn=o(e),Le=s(e,"IMG",{src:!0,alt:!0}),Ln=o(e),k=s(e,"H2",{class:!0});var Js=u(k);O=s(Js,"A",{id:!0,class:!0,href:!0});var cr=u(O);Rl=s(cr,"SPAN",{});var mr=u(Rl);m(Ye.$$.fragment,mr),mr.forEach(t),cr.forEach(t),qs=o(Js),Cl=s(Js,"SPAN",{"data-svelte-h":!0}),p(Cl)!=="svelte-137j17f"&&(Cl.textContent=Pi),Js.forEach(t),Yn=o(e),Fe=s(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-pdx5k3"&&(Fe.innerHTML=Qi),Fn=o(e),Xe=s(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-tsd2zd"&&(Xe.textContent=Li),Xn=o(e),m(ze.$$.fragment,e),zn=o(e),m(Re.$$.fragment,e),Rn=o(e),x=s(e,"H3",{class:!0});var _s=u(x);ee=s(_s,"A",{id:!0,class:!0,href:!0});var dr=u(ee);ql=s(dr,"SPAN",{});var vr=u(ql);m(qe.$$.fragment,vr),vr.forEach(t),dr.forEach(t),Ds=o(_s),Jl=s(_s,"SPAN",{"data-svelte-h":!0}),p(Jl)!=="svelte-1e93059"&&(Jl.textContent=Yi),_s.forEach(t),qn=o(e),De=s(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-p5tnmj"&&(De.textContent=Fi),Dn=o(e),Ke=s(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-homj1k"&&(Ke.innerHTML=Xi),Kn=o(e),m(Oe.$$.fragment,e),On=o(e),Z=s(e,"H2",{class:!0});var $s=u(Z);te=s($s,"A",{id:!0,class:!0,href:!0});var fr=u(te);Dl=s(fr,"SPAN",{});var yr=u(Dl);m(et.$$.fragment,yr),yr.forEach(t),fr.forEach(t),Ks=o($s),_l=s($s,"SPAN",{"data-svelte-h":!0}),p(_l)!=="svelte-1oue0e3"&&(_l.textContent=zi),$s.forEach(t),ea=o(e),m(tt.$$.fragment,e),ta=o(e),I=s(e,"H2",{class:!0});var js=u(I);le=s(js,"A",{id:!0,class:!0,href:!0});var wr=u(le);Kl=s(wr,"SPAN",{});var Mr=u(Kl);m(lt.$$.fragment,Mr),Mr.forEach(t),wr.forEach(t),Os=o(js),$l=s(js,"SPAN",{"data-svelte-h":!0}),p($l)!=="svelte-2f5cid"&&($l.textContent=Ri),js.forEach(t),la=o(e),nt=s(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-e8xztq"&&(nt.textContent=qi),na=o(e),at=s(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1ahmo9k"&&(at.innerHTML=Di),aa=o(e),st=s(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1xkj275"&&(st.innerHTML=Ki),sa=o(e),it=s(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1lvp1mx"&&(it.innerHTML=Oi),ia=o(e),ot=s(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1eh1xh8"&&(ot.innerHTML=eo),oa=o(e),rt=s(e,"IMG",{src:!0,alt:!0}),ra=o(e),ht=s(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1wf8xm5"&&(ht.innerHTML=lo),ha=o(e),W=s(e,"H3",{class:!0});var ks=u(W);ne=s(ks,"A",{id:!0,class:!0,href:!0});var br=u(ne);Ol=s(br,"SPAN",{});var gr=u(Ol);m(pt.$$.fragment,gr),gr.forEach(t),br.forEach(t),ei=o(ks),jl=s(ks,"SPAN",{"data-svelte-h":!0}),p(jl)!=="svelte-rfpw23"&&(jl.textContent=no),ks.forEach(t),pa=o(e),B=s(e,"H4",{class:!0});var xs=u(B);ae=s(xs,"A",{id:!0,class:!0,href:!0});var Tr=u(ae);en=s(Tr,"SPAN",{});var Ur=u(en);m(ut.$$.fragment,Ur),Ur.forEach(t),Tr.forEach(t),ti=o(xs),kl=s(xs,"SPAN",{"data-svelte-h":!0}),p(kl)!=="svelte-annmn1"&&(kl.textContent=ao),xs.forEach(t),ua=o(e),ct=s(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-xvsrum"&&(ct.innerHTML=so),ca=o(e),m(mt.$$.fragment,e),ma=o(e),m(dt.$$.fragment,e),da=o(e),vt=s(e,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-33hohs"&&(vt.innerHTML=io),va=o(e),ft=s(e,"UL",{"data-svelte-h":!0}),p(ft)!=="svelte-1lszzw1"&&(ft.innerHTML=oo),fa=o(e),yt=s(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-27bxb4"&&(yt.innerHTML=ro),ya=o(e),m(wt.$$.fragment,e),wa=o(e),Mt=s(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1o9n9bc"&&(Mt.textContent=ho),Ma=o(e),bt=s(e,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-pf09j6"&&(bt.innerHTML=po),ba=o(e),G=s(e,"H3",{class:!0});var Zs=u(G);se=s(Zs,"A",{id:!0,class:!0,href:!0});var Cr=u(se);tn=s(Cr,"SPAN",{});var Jr=u(tn);m(gt.$$.fragment,Jr),Jr.forEach(t),Cr.forEach(t),li=o(Zs),xl=s(Zs,"SPAN",{"data-svelte-h":!0}),p(xl)!=="svelte-abhbk3"&&(xl.textContent=uo),Zs.forEach(t),ga=o(e),Tt=s(e,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-to6bf0"&&(Tt.innerHTML=co),Ta=o(e),Ut=s(e,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-1tj0ynw"&&(Ut.textContent=mo),Ua=o(e),Ct=s(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-1a42rkj"&&(Ct.innerHTML=vo),Ca=o(e),Jt=s(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-e6bsr5"&&(Jt.innerHTML=fo),Ja=o(e),m(_t.$$.fragment,e),_a=o(e),E=s(e,"H4",{class:!0});var Is=u(E);ie=s(Is,"A",{id:!0,class:!0,href:!0});var _r=u(ie);ln=s(_r,"SPAN",{});var $r=u(ln);m($t.$$.fragment,$r),$r.forEach(t),_r.forEach(t),ni=o(Is),Zl=s(Is,"SPAN",{"data-svelte-h":!0}),p(Zl)!=="svelte-13h1zkw"&&(Zl.textContent=yo),Is.forEach(t),$a=o(e),m(jt.$$.fragment,e),ja=o(e),S=s(e,"H3",{class:!0});var Ws=u(S);oe=s(Ws,"A",{id:!0,class:!0,href:!0});var jr=u(oe);nn=s(jr,"SPAN",{});var kr=u(nn);m(kt.$$.fragment,kr),kr.forEach(t),jr.forEach(t),ai=o(Ws),Il=s(Ws,"SPAN",{"data-svelte-h":!0}),p(Il)!=="svelte-pdy4rd"&&(Il.textContent=wo),Ws.forEach(t),ka=o(e),xt=s(e,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-15t97zk"&&(xt.innerHTML=Mo),xa=o(e),Zt=s(e,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1n4jzw0"&&(Zt.innerHTML=bo),Za=o(e),m(It.$$.fragment,e),Ia=o(e),H=s(e,"H4",{class:!0});var Bs=u(H);re=s(Bs,"A",{id:!0,class:!0,href:!0});var xr=u(re);an=s(xr,"SPAN",{});var Zr=u(an);m(Wt.$$.fragment,Zr),Zr.forEach(t),xr.forEach(t),si=o(Bs),Wl=s(Bs,"SPAN",{"data-svelte-h":!0}),p(Wl)!=="svelte-13h1zkw"&&(Wl.textContent=go),Bs.forEach(t),Wa=o(e),m(Bt.$$.fragment,e),Ba=o(e),V=s(e,"H3",{class:!0});var Gs=u(V);he=s(Gs,"A",{id:!0,class:!0,href:!0});var Ir=u(he);sn=s(Ir,"SPAN",{});var Wr=u(sn);m(Gt.$$.fragment,Wr),Wr.forEach(t),Ir.forEach(t),ii=o(Gs),Bl=s(Gs,"SPAN",{"data-svelte-h":!0}),p(Bl)!=="svelte-1geh35i"&&(Bl.textContent=To),Gs.forEach(t),Ga=o(e),Et=s(e,"UL",{"data-svelte-h":!0}),p(Et)!=="svelte-f47qdr"&&(Et.innerHTML=Uo),Ea=o(e),m(St.$$.fragment,e),Sa=o(e),m(Ht.$$.fragment,e),Ha=o(e),N=s(e,"H3",{class:!0});var Es=u(N);pe=s(Es,"A",{id:!0,class:!0,href:!0});var Br=u(pe);on=s(Br,"SPAN",{});var Gr=u(on);m(Vt.$$.fragment,Gr),Gr.forEach(t),Br.forEach(t),oi=o(Es),Gl=s(Es,"SPAN",{"data-svelte-h":!0}),p(Gl)!=="svelte-119enb5"&&(Gl.textContent=Co),Es.forEach(t),Va=o(e),Nt=s(e,"UL",{"data-svelte-h":!0}),p(Nt)!=="svelte-bfd0w6"&&(Nt.innerHTML=Jo),Na=o(e),m(At.$$.fragment,e),Aa=o(e),A=s(e,"H3",{class:!0});var Ss=u(A);ue=s(Ss,"A",{id:!0,class:!0,href:!0});var Er=u(ue);rn=s(Er,"SPAN",{});var Sr=u(rn);m(Pt.$$.fragment,Sr),Sr.forEach(t),Er.forEach(t),ri=o(Ss),El=s(Ss,"SPAN",{"data-svelte-h":!0}),p(El)!=="svelte-v7gao2"&&(El.textContent=_o),Ss.forEach(t),Pa=o(e),Qt=s(e,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-1hqv8cs"&&(Qt.textContent=$o),Qa=o(e),Lt=s(e,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1vcevn6"&&(Lt.innerHTML=jo),La=o(e),Yt=s(e,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-1j3gce8"&&(Yt.innerHTML=ko),Ya=o(e),Ft=s(e,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-vgzxi7"&&(Ft.textContent=xo),Fa=o(e),Xt=s(e,"UL",{"data-svelte-h":!0}),p(Xt)!=="svelte-19ddql5"&&(Xt.innerHTML=Zo),Xa=o(e),zt=s(e,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-6k9qpu"&&(zt.textContent=Io),za=o(e),Rt=s(e,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-932u9c"&&(Rt.innerHTML=Wo),Ra=o(e),qt=s(e,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-1cn3tld"&&(qt.textContent=Bo),qa=o(e),Dt=s(e,"UL",{"data-svelte-h":!0}),p(Dt)!=="svelte-19b5tev"&&(Dt.innerHTML=Go),Da=o(e),Kt=s(e,"IMG",{src:!0,alt:!0}),Ka=o(e),Ot=s(e,"UL",{"data-svelte-h":!0}),p(Ot)!=="svelte-mbo7r4"&&(Ot.innerHTML=So),Oa=o(e),m(el.$$.fragment,e),es=o(e),tl=s(e,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1g9v6di"&&(tl.innerHTML=Ho),ts=o(e),ll=s(e,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-13wg35g"&&(ll.innerHTML=Vo),ls=o(e),m(nl.$$.fragment,e),ns=o(e),P=s(e,"H2",{class:!0});var Hs=u(P);ce=s(Hs,"A",{id:!0,class:!0,href:!0});var Hr=u(ce);hn=s(Hr,"SPAN",{});var Vr=u(hn);m(al.$$.fragment,Vr),Vr.forEach(t),Hr.forEach(t),hi=o(Hs),Sl=s(Hs,"SPAN",{"data-svelte-h":!0}),p(Sl)!=="svelte-a17ig2"&&(Sl.textContent=No),Hs.forEach(t),as=o(e),sl=s(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-o2mw87"&&(sl.innerHTML=Ao),ss=o(e),il=s(e,"P",{"data-svelte-h":!0}),p(il)!=="svelte-10ft4lt"&&(il.innerHTML=Po),is=o(e),ol=s(e,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-11q3awl"&&(ol.innerHTML=Qo),os=o(e),rl=s(e,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-orosy6"&&(rl.innerHTML=Lo),rs=o(e),hl=s(e,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-75fqx0"&&(hl.textContent=Yo),hs=o(e),pl=s(e,"OL",{"data-svelte-h":!0}),p(pl)!=="svelte-k2am8z"&&(pl.innerHTML=Fo),ps=o(e),Q=s(e,"H3",{class:!0});var Vs=u(Q);me=s(Vs,"A",{id:!0,class:!0,href:!0});var Nr=u(me);pn=s(Nr,"SPAN",{});var Ar=u(pn);m(ul.$$.fragment,Ar),Ar.forEach(t),Nr.forEach(t),pi=o(Vs),Hl=s(Vs,"SPAN",{"data-svelte-h":!0}),p(Hl)!=="svelte-1yts0d1"&&(Hl.textContent=Xo),Vs.forEach(t),us=o(e),m(cl.$$.fragment,e),cs=o(e),m(ml.$$.fragment,e),ms=o(e),dl=s(e,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-1szhxef"&&(dl.textContent=zo),ds=o(e),L=s(e,"H2",{class:!0});var Ns=u(L);de=s(Ns,"A",{id:!0,class:!0,href:!0});var Pr=u(de);un=s(Pr,"SPAN",{});var Qr=u(un);m(vl.$$.fragment,Qr),Qr.forEach(t),Pr.forEach(t),ui=o(Ns),Vl=s(Ns,"SPAN",{"data-svelte-h":!0}),p(Vl)!=="svelte-i9a3z3"&&(Vl.textContent=Ro),Ns.forEach(t),vs=o(e),cn=s(e,"P",{}),u(cn).forEach(t),this.h()},h(){r(b,"name","hf:doc:metadata"),r(b,"content",JSON.stringify(Kr)),r(Y,"id","hands-on"),r(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Y,"href","#hands-on"),r(g,"class","relative group"),r(F,"id","unit-6-advantage-actor-critic-a2c-using-robotics-simulations-with-pandagym"),r(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(F,"href","#unit-6-advantage-actor-critic-a2c-using-robotics-simulations-with-pandagym"),r(T,"class","relative group"),r(X,"id","environments"),r(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(X,"href","#environments"),r(U,"class","relative group"),r(z,"id","rllibrary"),r(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(z,"href","#rllibrary"),r(C,"class","relative group"),r(R,"id","objectives-of-this-notebook"),r(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(R,"href","#objectives-of-this-notebook"),r(J,"class","relative group"),r(q,"id","prerequisites"),r(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(q,"href","#prerequisites"),r(_,"class","relative group"),r(D,"id","lets-train-our-first-robots"),r(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(D,"href","#lets-train-our-first-robots"),r($,"class","relative group"),r(K,"id","set-the-gpu"),r(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(K,"href","#set-the-gpu"),r(j,"class","relative group"),As(Pe.src,Vi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||r(Pe,"src",Vi),r(Pe,"alt","GPU Step 1"),As(Le.src,Ai="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||r(Le,"src",Ai),r(Le,"alt","GPU Step 2"),r(O,"id","create-a-virtual-display"),r(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(O,"href","#create-a-virtual-display"),r(k,"class","relative group"),r(ee,"id","install-dependencies"),r(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ee,"href","#install-dependencies"),r(x,"class","relative group"),r(te,"id","import-the-packages"),r(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(te,"href","#import-the-packages"),r(Z,"class","relative group"),r(le,"id","pandareachdensev3"),r(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(le,"href","#pandareachdensev3"),r(I,"class","relative group"),As(rt.src,to="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit8/robotics.jpg")||r(rt,"src",to),r(rt,"alt","Robotics"),r(ne,"id","create-the-environment"),r(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ne,"href","#create-the-environment"),r(W,"class","relative group"),r(ae,"id","the-environment"),r(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ae,"href","#the-environment"),r(B,"class","relative group"),r(se,"id","normalize-observation-and-rewards"),r(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(se,"href","#normalize-observation-and-rewards"),r(G,"class","relative group"),r(ie,"id","solution"),r(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ie,"href","#solution"),r(E,"class","relative group"),r(oe,"id","create-the-a2c-model"),r(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(oe,"href","#create-the-a2c-model"),r(S,"class","relative group"),r(re,"id","solution"),r(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(re,"href","#solution"),r(H,"class","relative group"),r(he,"id","train-the-a2c-agent"),r(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(he,"href","#train-the-a2c-agent"),r(V,"class","relative group"),r(pe,"id","evaluate-the-agent"),r(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(pe,"href","#evaluate-the-agent"),r(N,"class","relative group"),r(ue,"id","publish-your-trained-model-on-the-hub"),r(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ue,"href","#publish-your-trained-model-on-the-hub"),r(A,"class","relative group"),As(Kt.src,Eo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||r(Kt,"src",Eo),r(Kt,"alt","Create HF Token"),r(ce,"id","some-additional-challenges"),r(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ce,"href","#some-additional-challenges"),r(P,"class","relative group"),r(me,"id","solution-optional"),r(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(me,"href","#solution-optional"),r(Q,"class","relative group"),r(de,"id","keep-learning-stay-awesome"),r(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(de,"href","#keep-learning-stay-awesome"),r(L,"class","relative group")},m(e,l){h(document.head,b),n(e,mn,l),n(e,Nl,l),n(e,dn,l),n(e,g,l),h(g,Y),h(Y,Al),d(ve,Al,null),h(g,Ps),h(g,fl),n(e,vn,l),d(fe,e,l),n(e,fn,l),n(e,ye,l),n(e,yn,l),n(e,we,l),n(e,wn,l),n(e,Me,l),n(e,Mn,l),n(e,be,l),n(e,bn,l),n(e,ge,l),n(e,gn,l),n(e,Te,l),n(e,Tn,l),n(e,Ue,l),n(e,Un,l),n(e,Ce,l),n(e,Cn,l),n(e,Je,l),n(e,Jn,l),n(e,_e,l),n(e,_n,l),n(e,T,l),h(T,F),h(F,Pl),d($e,Pl,null),h(T,Qs),h(T,yl),n(e,$n,l),n(e,U,l),h(U,X),h(X,Ql),d(je,Ql,null),h(U,Ls),h(U,wl),n(e,jn,l),n(e,ke,l),n(e,kn,l),n(e,C,l),h(C,z),h(z,Ll),d(xe,Ll,null),h(C,Ys),h(C,Ml),n(e,xn,l),n(e,Ze,l),n(e,Zn,l),n(e,Ie,l),n(e,In,l),n(e,J,l),h(J,R),h(R,Yl),d(We,Yl,null),h(J,Fs),h(J,bl),n(e,Wn,l),n(e,Be,l),n(e,Bn,l),n(e,Ge,l),n(e,Gn,l),n(e,_,l),h(_,q),h(q,Fl),d(Ee,Fl,null),h(_,Xs),h(_,gl),n(e,En,l),n(e,Se,l),n(e,Sn,l),n(e,He,l),n(e,Hn,l),n(e,$,l),h($,D),h(D,Xl),d(Ve,Xl,null),h($,zs),h($,Tl),n(e,Vn,l),n(e,j,l),h(j,K),h(K,zl),d(Ne,zl,null),h(j,Rs),h(j,Ul),n(e,Nn,l),n(e,Ae,l),n(e,An,l),n(e,Pe,l),n(e,Pn,l),n(e,Qe,l),n(e,Qn,l),n(e,Le,l),n(e,Ln,l),n(e,k,l),h(k,O),h(O,Rl),d(Ye,Rl,null),h(k,qs),h(k,Cl),n(e,Yn,l),n(e,Fe,l),n(e,Fn,l),n(e,Xe,l),n(e,Xn,l),d(ze,e,l),n(e,zn,l),d(Re,e,l),n(e,Rn,l),n(e,x,l),h(x,ee),h(ee,ql),d(qe,ql,null),h(x,Ds),h(x,Jl),n(e,qn,l),n(e,De,l),n(e,Dn,l),n(e,Ke,l),n(e,Kn,l),d(Oe,e,l),n(e,On,l),n(e,Z,l),h(Z,te),h(te,Dl),d(et,Dl,null),h(Z,Ks),h(Z,_l),n(e,ea,l),d(tt,e,l),n(e,ta,l),n(e,I,l),h(I,le),h(le,Kl),d(lt,Kl,null),h(I,Os),h(I,$l),n(e,la,l),n(e,nt,l),n(e,na,l),n(e,at,l),n(e,aa,l),n(e,st,l),n(e,sa,l),n(e,it,l),n(e,ia,l),n(e,ot,l),n(e,oa,l),n(e,rt,l),n(e,ra,l),n(e,ht,l),n(e,ha,l),n(e,W,l),h(W,ne),h(ne,Ol),d(pt,Ol,null),h(W,ei),h(W,jl),n(e,pa,l),n(e,B,l),h(B,ae),h(ae,en),d(ut,en,null),h(B,ti),h(B,kl),n(e,ua,l),n(e,ct,l),n(e,ca,l),d(mt,e,l),n(e,ma,l),d(dt,e,l),n(e,da,l),n(e,vt,l),n(e,va,l),n(e,ft,l),n(e,fa,l),n(e,yt,l),n(e,ya,l),d(wt,e,l),n(e,wa,l),n(e,Mt,l),n(e,Ma,l),n(e,bt,l),n(e,ba,l),n(e,G,l),h(G,se),h(se,tn),d(gt,tn,null),h(G,li),h(G,xl),n(e,ga,l),n(e,Tt,l),n(e,Ta,l),n(e,Ut,l),n(e,Ua,l),n(e,Ct,l),n(e,Ca,l),n(e,Jt,l),n(e,Ja,l),d(_t,e,l),n(e,_a,l),n(e,E,l),h(E,ie),h(ie,ln),d($t,ln,null),h(E,ni),h(E,Zl),n(e,$a,l),d(jt,e,l),n(e,ja,l),n(e,S,l),h(S,oe),h(oe,nn),d(kt,nn,null),h(S,ai),h(S,Il),n(e,ka,l),n(e,xt,l),n(e,xa,l),n(e,Zt,l),n(e,Za,l),d(It,e,l),n(e,Ia,l),n(e,H,l),h(H,re),h(re,an),d(Wt,an,null),h(H,si),h(H,Wl),n(e,Wa,l),d(Bt,e,l),n(e,Ba,l),n(e,V,l),h(V,he),h(he,sn),d(Gt,sn,null),h(V,ii),h(V,Bl),n(e,Ga,l),n(e,Et,l),n(e,Ea,l),d(St,e,l),n(e,Sa,l),d(Ht,e,l),n(e,Ha,l),n(e,N,l),h(N,pe),h(pe,on),d(Vt,on,null),h(N,oi),h(N,Gl),n(e,Va,l),n(e,Nt,l),n(e,Na,l),d(At,e,l),n(e,Aa,l),n(e,A,l),h(A,ue),h(ue,rn),d(Pt,rn,null),h(A,ri),h(A,El),n(e,Pa,l),n(e,Qt,l),n(e,Qa,l),n(e,Lt,l),n(e,La,l),n(e,Yt,l),n(e,Ya,l),n(e,Ft,l),n(e,Fa,l),n(e,Xt,l),n(e,Xa,l),n(e,zt,l),n(e,za,l),n(e,Rt,l),n(e,Ra,l),n(e,qt,l),n(e,qa,l),n(e,Dt,l),n(e,Da,l),n(e,Kt,l),n(e,Ka,l),n(e,Ot,l),n(e,Oa,l),d(el,e,l),n(e,es,l),n(e,tl,l),n(e,ts,l),n(e,ll,l),n(e,ls,l),d(nl,e,l),n(e,ns,l),n(e,P,l),h(P,ce),h(ce,hn),d(al,hn,null),h(P,hi),h(P,Sl),n(e,as,l),n(e,sl,l),n(e,ss,l),n(e,il,l),n(e,is,l),n(e,ol,l),n(e,os,l),n(e,rl,l),n(e,rs,l),n(e,hl,l),n(e,hs,l),n(e,pl,l),n(e,ps,l),n(e,Q,l),h(Q,me),h(me,pn),d(ul,pn,null),h(Q,pi),h(Q,Hl),n(e,us,l),d(cl,e,l),n(e,cs,l),d(ml,e,l),n(e,ms,l),n(e,dl,l),n(e,ds,l),n(e,L,l),h(L,de),h(de,un),d(vl,un,null),h(L,ui),h(L,Vl),n(e,vs,l),n(e,cn,l),fs=!0},p:Yr,i(e){fs||(v(ve.$$.fragment,e),v(fe.$$.fragment,e),v($e.$$.fragment,e),v(je.$$.fragment,e),v(xe.$$.fragment,e),v(We.$$.fragment,e),v(Ee.$$.fragment,e),v(Ve.$$.fragment,e),v(Ne.$$.fragment,e),v(Ye.$$.fragment,e),v(ze.$$.fragment,e),v(Re.$$.fragment,e),v(qe.$$.fragment,e),v(Oe.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(lt.$$.fragment,e),v(pt.$$.fragment,e),v(ut.$$.fragment,e),v(mt.$$.fragment,e),v(dt.$$.fragment,e),v(wt.$$.fragment,e),v(gt.$$.fragment,e),v(_t.$$.fragment,e),v($t.$$.fragment,e),v(jt.$$.fragment,e),v(kt.$$.fragment,e),v(It.$$.fragment,e),v(Wt.$$.fragment,e),v(Bt.$$.fragment,e),v(Gt.$$.fragment,e),v(St.$$.fragment,e),v(Ht.$$.fragment,e),v(Vt.$$.fragment,e),v(At.$$.fragment,e),v(Pt.$$.fragment,e),v(el.$$.fragment,e),v(nl.$$.fragment,e),v(al.$$.fragment,e),v(ul.$$.fragment,e),v(cl.$$.fragment,e),v(ml.$$.fragment,e),v(vl.$$.fragment,e),fs=!0)},o(e){f(ve.$$.fragment,e),f(fe.$$.fragment,e),f($e.$$.fragment,e),f(je.$$.fragment,e),f(xe.$$.fragment,e),f(We.$$.fragment,e),f(Ee.$$.fragment,e),f(Ve.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(ze.$$.fragment,e),f(Re.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(pt.$$.fragment,e),f(ut.$$.fragment,e),f(mt.$$.fragment,e),f(dt.$$.fragment,e),f(wt.$$.fragment,e),f(gt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(jt.$$.fragment,e),f(kt.$$.fragment,e),f(It.$$.fragment,e),f(Wt.$$.fragment,e),f(Bt.$$.fragment,e),f(Gt.$$.fragment,e),f(St.$$.fragment,e),f(Ht.$$.fragment,e),f(Vt.$$.fragment,e),f(At.$$.fragment,e),f(Pt.$$.fragment,e),f(el.$$.fragment,e),f(nl.$$.fragment,e),f(al.$$.fragment,e),f(ul.$$.fragment,e),f(cl.$$.fragment,e),f(ml.$$.fragment,e),f(vl.$$.fragment,e),fs=!1},d(e){e&&(t(mn),t(Nl),t(dn),t(g),t(vn),t(fn),t(ye),t(yn),t(we),t(wn),t(Me),t(Mn),t(be),t(bn),t(ge),t(gn),t(Te),t(Tn),t(Ue),t(Un),t(Ce),t(Cn),t(Je),t(Jn),t(_e),t(_n),t(T),t($n),t(U),t(jn),t(ke),t(kn),t(C),t(xn),t(Ze),t(Zn),t(Ie),t(In),t(J),t(Wn),t(Be),t(Bn),t(Ge),t(Gn),t(_),t(En),t(Se),t(Sn),t(He),t(Hn),t($),t(Vn),t(j),t(Nn),t(Ae),t(An),t(Pe),t(Pn),t(Qe),t(Qn),t(Le),t(Ln),t(k),t(Yn),t(Fe),t(Fn),t(Xe),t(Xn),t(zn),t(Rn),t(x),t(qn),t(De),t(Dn),t(Ke),t(Kn),t(On),t(Z),t(ea),t(ta),t(I),t(la),t(nt),t(na),t(at),t(aa),t(st),t(sa),t(it),t(ia),t(ot),t(oa),t(rt),t(ra),t(ht),t(ha),t(W),t(pa),t(B),t(ua),t(ct),t(ca),t(ma),t(da),t(vt),t(va),t(ft),t(fa),t(yt),t(ya),t(wa),t(Mt),t(Ma),t(bt),t(ba),t(G),t(ga),t(Tt),t(Ta),t(Ut),t(Ua),t(Ct),t(Ca),t(Jt),t(Ja),t(_a),t(E),t($a),t(ja),t(S),t(ka),t(xt),t(xa),t(Zt),t(Za),t(Ia),t(H),t(Wa),t(Ba),t(V),t(Ga),t(Et),t(Ea),t(Sa),t(Ha),t(N),t(Va),t(Nt),t(Na),t(Aa),t(A),t(Pa),t(Qt),t(Qa),t(Lt),t(La),t(Yt),t(Ya),t(Ft),t(Fa),t(Xt),t(Xa),t(zt),t(za),t(Rt),t(Ra),t(qt),t(qa),t(Dt),t(Da),t(Kt),t(Ka),t(Ot),t(Oa),t(es),t(tl),t(ts),t(ll),t(ls),t(ns),t(P),t(as),t(sl),t(ss),t(il),t(is),t(ol),t(os),t(rl),t(rs),t(hl),t(hs),t(pl),t(ps),t(Q),t(us),t(cs),t(ms),t(dl),t(ds),t(L),t(vs),t(cn)),t(b),y(ve),y(fe,e),y($e),y(je),y(xe),y(We),y(Ee),y(Ve),y(Ne),y(Ye),y(ze,e),y(Re,e),y(qe),y(Oe,e),y(et),y(tt,e),y(lt),y(pt),y(ut),y(mt,e),y(dt,e),y(wt,e),y(gt),y(_t,e),y($t),y(jt,e),y(kt),y(It,e),y(Wt),y(Bt,e),y(Gt),y(St,e),y(Ht,e),y(Vt),y(At,e),y(Pt),y(el,e),y(nl,e),y(al),y(ul),y(cl,e),y(ml,e),y(vl)}}}const Kr={local:"lets-train-our-first-robots",sections:[{local:"set-the-gpu",title:"Set the GPU 💪"},{local:"create-a-virtual-display",sections:[{local:"install-dependencies",title:"Install dependencies 🔽"}],title:"Create a virtual display 🔽"},{local:"import-the-packages",title:"Import the packages 📦"},{local:"pandareachdensev3",sections:[{local:"create-the-environment",sections:[{local:"the-environment",title:"The environment 🎮"}],title:"Create the environment"},{local:"normalize-observation-and-rewards",sections:[{local:"solution",title:"Solution"}],title:"Normalize observation and rewards"},{local:"create-the-a2c-model",sections:[{local:"solution",title:"Solution"}],title:"Create the A2C Model 🤖"},{local:"train-the-a2c-agent",title:"Train the A2C agent 🏃"},{local:"evaluate-the-agent",title:"Evaluate the agent 📈"},{local:"publish-your-trained-model-on-the-hub",title:"Publish your trained model on the Hub 🔥"}],title:"PandaReachDense-v3 🦾"},{local:"some-additional-challenges",sections:[{local:"solution-optional",title:"Solution (optional)"}],title:"Some additional challenges 🏆"},{local:"keep-learning-stay-awesome",title:"Keep learning, stay awesome 🤗"}],title:"Let's train our first robots 🤖"};function Or(ci){return Fr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sh extends Xr{constructor(b){super(),zr(this,b,Or,Dr,Lr,{})}}export{sh as component};
