import{s as pn,f as Za,n as mn,o as rn}from"../chunks/scheduler.37c15a92.js";import{S as on,i as hn,g as n,s as i,u as P,H as Fs,A as cn,h as l,f as t,c as p,j as h,v as H,y as m,B as Js,k as r,o,a,w as $,d as A,t as z,x as S}from"../chunks/index.b01106c0.js";import{I}from"../chunks/IconCopyLink.77b762b4.js";function gn(ze){let c,lt,Qs,it,g,b,Vs,O,Te,zs,Se="Self-Play: a classic technique to train competitive agents in adversarial games",pt,q,Ie="Now that we’ve studied the basics of multi-agents, we’re ready to go deeper. As mentioned in the introduction, we’re going <strong>to train agents in an adversarial game with SoccerTwos, a 2vs2 game</strong>.",mt,N,Oe='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/soccertwos.gif" alt="SoccerTwos"/> <figcaption>This environment was made by the <a href="https://github.com/Unity-Technologies/ml-agents">Unity MLAgents Team</a></figcaption>',rt,u,_,Xs,B,Me,Ss,qe="What is Self-Play?",ot,U,Ne="Training agents correctly in an adversarial game can be <strong>quite complex</strong>.",ht,W,Be="On the one hand, we need to find how to get a well-trained opponent to play against your training agent. And on the other hand, if you find a very good trained opponent, how will your agent improve its policy when the opponent is too strong?",ct,j,Ue="Think of a child that just started to learn soccer. Playing against a very good soccer player will be useless since it will be too hard to win or at least get the ball from time to time. So the child will continuously lose without having time to learn a good policy.",gt,G,We="The best solution would be <strong>to have an opponent that is on the same level as the agent and will upgrade its level as the agent upgrades its own</strong>. Because if the opponent is too strong, we’ll learn nothing; if it is too weak, we’ll overlearn useless behavior against a stronger opponent then.",ut,K,je="This solution is called <em>self-play</em>. In self-play, <strong>the agent uses former copies of itself (of its policy) as an opponent</strong>. This way, the agent will play against an agent of the same level (challenging but not too much), have opportunities to gradually improve its policy, and then update its opponent as it becomes better. It’s a way to bootstrap an opponent and progressively increase the opponent’s complexity.",vt,R,Ge="It’s the same way humans learn in competition:",ft,D,Ke="<li>We start to train against an opponent of similar level</li> <li>Then we learn from it, and when we acquire some skills, we can move further with stronger opponents.</li>",yt,F,Re="We do the same with self-play:",dt,J,De="<li>We <strong>start with a copy of our agent as an opponent</strong> this way, this opponent is on a similar level.</li> <li>We <strong>learn from it</strong> and, when we acquire some skills, we <strong>update our opponent with a more recent copy of our training policy</strong>.</li>",wt,Q,Fe='The theory behind self-play is not something new. It was already used by Arthur Samuel’s checker player system in the fifties and by Gerald Tesauro’s TD-Gammon in 1995. If you want to learn more about the history of self-play <a href="https://blog.unity.com/technology/training-intelligent-adversaries-using-self-play-with-ml-agents" rel="nofollow">check out this very good blogpost by Andrew Cohen</a>',xt,v,L,Ys,V,ke,Is,Je="Self-Play in MLAgents",bt,X,Qe="Self-Play is integrated into the MLAgents library and is managed by multiple hyperparameters that we’re going to study. But the main focus, as explained in the documentation, is the <strong>tradeoff between the skill level and generality of the final policy and the stability of learning</strong>.",_t,Y,Ve="Training against a set of slowly changing or unchanging adversaries with low diversity <strong>results in more stable training. But a risk to overfit if the change is too slow.</strong>",Lt,Z,Xe="So we need to control:",Ct,ss,Ye=`<li>How <strong>often we change opponents</strong> with the <code>swap_steps</code> and <code>team_change</code> parameters.</li> <li>The <strong>number of opponents saved</strong> with the <code>window</code> parameter. A larger value of <code>window</code>
 means that an agent’s pool of opponents will contain a larger diversity of behaviors since it will contain policies from earlier in the training run.</li> <li>The <strong>probability of playing against the current self vs opponent</strong> sampled from the pool with <code>play_against_latest_model_ratio</code>. A larger value of <code>play_against_latest_model_ratio</code>
 indicates that an agent will be playing against the current opponent more often.</li> <li>The <strong>number of training steps before saving a new opponent</strong> with <code>save_steps</code> parameters. A larger value of <code>save_steps</code>
 will yield a set of opponents that cover a wider range of skill levels and possibly play styles since the policy receives more training.</li>`,Tt,ts,Ze='To get more details about these hyperparameters, you definitely need <a href="https://github.com/Unity-Technologies/ml-agents/blob/develop/docs/Training-Configuration-File.md#self-play" rel="nofollow">to check out this part of the documentation</a>',Mt,f,C,Zs,es,Ee,Os,sa="The ELO Score to evaluate our agent",kt,y,T,st,as,Pe,qs,ta="What is ELO Score?",Et,ns,ea="In adversarial games, tracking the <strong>cumulative reward is not always a meaningful metric to track the learning progress:</strong> because this metric is <strong>dependent only on the skill of the opponent.</strong>",Pt,ls,aa="Instead, we’re using an <strong><em>ELO rating system</em></strong> (named after Arpad Elo) that calculates the <strong>relative skill level</strong> between 2 players from a given population in a zero-sum game.",Ht,is,na="In a zero-sum game: one agent wins, and the other agent loses. It’s a mathematical representation of a situation in which each participant’s gain or loss of utility <strong>is exactly balanced by the gain or loss of the utility of the other participants.</strong> We talk about zero-sum games because the sum of utility is equal to zero.",$t,ps,la="This ELO (starting at a specific score: frequently 1200) can decrease initially but should increase progressively during the training.",At,ms,ia="The Elo system is <strong>inferred from the losses and draws against other players.</strong> It means that player ratings depend <strong>on the ratings of their opponents and the results scored against them.</strong>",zt,rs,pa="Elo defines an Elo score that is the relative skills of a player in a zero-sum game. <strong>We say relative because it depends on the performance of opponents.</strong>",St,os,ma="The central idea is to think of the performance of a player <strong>as a random variable that is normally distributed.</strong>",It,hs,ra="The difference in rating between 2 players serves as <strong>the predictor of the outcomes of a match.</strong> If the player wins, but the probability of winning is high, it will only win a few points from its opponent since it means that it is much stronger than it.",Ot,cs,oa="After every game:",qt,gs,ha="<li>The winning player takes <strong>points from the losing one.</strong></li> <li>The number of points is determined <strong>by the difference in the 2 players ratings (hence relative).</strong><ul><li>If the higher-rated player wins → few points will be taken from the lower-rated player.</li> <li>If the lower-rated player wins → a lot of points will be taken from the high-rated player.</li> <li>If it’s a draw → the lower-rated player gains a few points from the higher.</li></ul></li>",Nt,us,ca="So if A and B have rating Ra, and Rb, then the <strong>expected scores are</strong> given by:",Bt,vs,ga,Ut,fs,ua="Then, at the end of the game, we need to update the player’s actual Elo score. We use a linear adjustment <strong>proportional to the amount by which the player over-performed or under-performed.</strong>",Wt,ys,va="We also define a maximum adjustment rating per game: K-factor.",jt,ds,fa="<li>K=16 for master.</li> <li>K=32 for weaker players.</li>",Gt,ws,ya="If Player A has Ea points but scored Sa points, then the player’s rating is updated using the formula:",Kt,xs,da,Rt,d,M,tt,bs,He,Ns,wa="Example",Dt,_s,xa="If we take an example:",Ft,Ls,ba="Player A has a rating of 2600",Jt,Cs,_a="Player B has a rating of 2300",Qt,Ts,La="<li>We first calculate the expected score:</li>",Vt,Bs,Xt,sn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>E</mi><mi>A</mi></msub><mo>=</mo><mfrac><mn>1</mn><mrow><mn>1</mn><mo>+</mo><mn>1</mn><msup><mn>0</mn><mrow><mo stretchy="false">(</mo><mn>2300</mn><mo>−</mo><mn>2600</mn><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mn>400</mn></mrow></msup></mrow></mfrac><mo>=</mo><mn>0.849</mn></mrow><annotation encoding="application/x-tex">E_{A} = \\frac{1}{1+10^{(2300-2600)/400}} = 0.849 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">A</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2889em;vertical-align:-0.4438em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8451em;"><span style="top:-2.6146em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span><span class="mbin mtight">+</span><span class="mord mtight">1</span><span class="mord mtight"><span class="mord mtight">0</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.822em;"><span style="top:-2.822em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5357em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mtight">2300</span><span class="mbin mtight">−</span><span class="mord mtight">2600</span><span class="mclose mtight">)</span><span class="mord mtight">/400</span></span></span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4438em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.849</span></span></span></span>',Yt,Us,Zt,tn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>E</mi><mi>B</mi></msub><mo>=</mo><mfrac><mn>1</mn><mrow><mn>1</mn><mo>+</mo><mn>1</mn><msup><mn>0</mn><mrow><mo stretchy="false">(</mo><mn>2600</mn><mo>−</mo><mn>2300</mn><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mn>400</mn></mrow></msup></mrow></mfrac><mo>=</mo><mn>0.151</mn></mrow><annotation encoding="application/x-tex">E_{B} = \\frac{1}{1+10^{(2600-2300)/400}} = 0.151 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.2889em;vertical-align:-0.4438em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8451em;"><span style="top:-2.6146em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span><span class="mbin mtight">+</span><span class="mord mtight">1</span><span class="mord mtight"><span class="mord mtight">0</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.822em;"><span style="top:-2.822em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5357em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mtight">2600</span><span class="mbin mtight">−</span><span class="mord mtight">2300</span><span class="mclose mtight">)</span><span class="mord mtight">/400</span></span></span></span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.4438em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.151</span></span></span></span>',se,Ms,Ca="<li>If the organizers determined that K=16 and A wins, the new rating would be:</li>",te,Ws,ee,en='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>A</mi></msub><mo>=</mo><mn>2600</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>0.849</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2602</mn></mrow><annotation encoding="application/x-tex">ELO_A = 2600 + 16*(1-0.849) = 2602 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">A</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2600</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.849</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2602</span></span></span></span>',ae,js,ne,an='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>B</mi></msub><mo>=</mo><mn>2300</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>0</mn><mo>−</mo><mn>0.151</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2298</mn></mrow><annotation encoding="application/x-tex">ELO_B = 2300 + 16*(0-0.151) = 2298 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2300</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">0</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.151</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2298</span></span></span></span>',le,ks,Ta="<li>If the organizers determined that K=16 and B wins, the new rating would be:</li>",ie,Gs,pe,nn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>A</mi></msub><mo>=</mo><mn>2600</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>0</mn><mo>−</mo><mn>0.849</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2586</mn></mrow><annotation encoding="application/x-tex">ELO_A = 2600 + 16*(0-0.849) = 2586 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">A</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2600</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">0</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.849</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2586</span></span></span></span>',me,Ks,re,ln='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>E</mi><mi>L</mi><msub><mi>O</mi><mi>B</mi></msub><mo>=</mo><mn>2300</mn><mo>+</mo><mn>16</mn><mo>∗</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mn>0.151</mn><mo stretchy="false">)</mo><mo>=</mo><mn>2314</mn></mrow><annotation encoding="application/x-tex">ELO_B = 2300 + 16 *(1-0.151) = 2314 </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">E</span><span class="mord mathnormal">L</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05017em;">B</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">2300</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">0.151</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2314</span></span></span></span>',oe,w,k,et,Es,$e,Rs,Ma="The Advantages",he,Ps,ka="Using the ELO score has multiple advantages:",ce,Hs,Ea="<li>Points are <strong>always balanced</strong> (more points are exchanged when there is an unexpected outcome, but the sum is always the same).</li> <li>It is a <strong>self-corrected system</strong> since if a player wins against a weak player, they will only win a few points.</li> <li>It <strong>works with team games</strong>: we calculate the average for each team and use it in Elo.</li>",ge,x,E,at,$s,Ae,Ds,Pa="The Disadvantages",ue,As,Ha="<li>ELO <strong>does not take into account the individual contribution</strong> of each people in the team.</li> <li>Rating deflation: <strong>a good rating requires skill over time to keep the same rating</strong>.</li> <li><strong>Can’t compare rating in history</strong>.</li>",ve,nt,fe;return O=new I({}),B=new I({}),V=new I({}),es=new I({}),as=new I({}),bs=new I({}),Es=new I({}),$s=new I({}),{c(){c=n("meta"),lt=i(),Qs=n("p"),it=i(),g=n("h1"),b=n("a"),Vs=n("span"),P(O.$$.fragment),Te=i(),zs=n("span"),zs.textContent=Se,pt=i(),q=n("p"),q.innerHTML=Ie,mt=i(),N=n("figure"),N.innerHTML=Oe,rt=i(),u=n("h2"),_=n("a"),Xs=n("span"),P(B.$$.fragment),Me=i(),Ss=n("span"),Ss.textContent=qe,ot=i(),U=n("p"),U.innerHTML=Ne,ht=i(),W=n("p"),W.textContent=Be,ct=i(),j=n("p"),j.textContent=Ue,gt=i(),G=n("p"),G.innerHTML=We,ut=i(),K=n("p"),K.innerHTML=je,vt=i(),R=n("p"),R.textContent=Ge,ft=i(),D=n("ul"),D.innerHTML=Ke,yt=i(),F=n("p"),F.textContent=Re,dt=i(),J=n("ul"),J.innerHTML=De,wt=i(),Q=n("p"),Q.innerHTML=Fe,xt=i(),v=n("h2"),L=n("a"),Ys=n("span"),P(V.$$.fragment),ke=i(),Is=n("span"),Is.textContent=Je,bt=i(),X=n("p"),X.innerHTML=Qe,_t=i(),Y=n("p"),Y.innerHTML=Ve,Lt=i(),Z=n("p"),Z.textContent=Xe,Ct=i(),ss=n("ul"),ss.innerHTML=Ye,Tt=i(),ts=n("p"),ts.innerHTML=Ze,Mt=i(),f=n("h2"),C=n("a"),Zs=n("span"),P(es.$$.fragment),Ee=i(),Os=n("span"),Os.textContent=sa,kt=i(),y=n("h3"),T=n("a"),st=n("span"),P(as.$$.fragment),Pe=i(),qs=n("span"),qs.textContent=ta,Et=i(),ns=n("p"),ns.innerHTML=ea,Pt=i(),ls=n("p"),ls.innerHTML=aa,Ht=i(),is=n("p"),is.innerHTML=na,$t=i(),ps=n("p"),ps.textContent=la,At=i(),ms=n("p"),ms.innerHTML=ia,zt=i(),rs=n("p"),rs.innerHTML=pa,St=i(),os=n("p"),os.innerHTML=ma,It=i(),hs=n("p"),hs.innerHTML=ra,Ot=i(),cs=n("p"),cs.textContent=oa,qt=i(),gs=n("ul"),gs.innerHTML=ha,Nt=i(),us=n("p"),us.innerHTML=ca,Bt=i(),vs=n("img"),Ut=i(),fs=n("p"),fs.innerHTML=ua,Wt=i(),ys=n("p"),ys.textContent=va,jt=i(),ds=n("ul"),ds.innerHTML=fa,Gt=i(),ws=n("p"),ws.textContent=ya,Kt=i(),xs=n("img"),Rt=i(),d=n("h3"),M=n("a"),tt=n("span"),P(bs.$$.fragment),He=i(),Ns=n("span"),Ns.textContent=wa,Dt=i(),_s=n("p"),_s.textContent=xa,Ft=i(),Ls=n("p"),Ls.textContent=ba,Jt=i(),Cs=n("p"),Cs.textContent=_a,Qt=i(),Ts=n("ul"),Ts.innerHTML=La,Vt=i(),Bs=n("p"),Xt=new Fs(!1),Yt=i(),Us=n("p"),Zt=new Fs(!1),se=i(),Ms=n("ul"),Ms.innerHTML=Ca,te=i(),Ws=n("p"),ee=new Fs(!1),ae=i(),js=n("p"),ne=new Fs(!1),le=i(),ks=n("ul"),ks.innerHTML=Ta,ie=i(),Gs=n("p"),pe=new Fs(!1),me=i(),Ks=n("p"),re=new Fs(!1),oe=i(),w=n("h3"),k=n("a"),et=n("span"),P(Es.$$.fragment),$e=i(),Rs=n("span"),Rs.textContent=Ma,he=i(),Ps=n("p"),Ps.textContent=ka,ce=i(),Hs=n("ul"),Hs.innerHTML=Ea,ge=i(),x=n("h3"),E=n("a"),at=n("span"),P($s.$$.fragment),Ae=i(),Ds=n("span"),Ds.textContent=Pa,ue=i(),As=n("ul"),As.innerHTML=Ha,ve=i(),nt=n("p"),this.h()},l(s){const e=cn("svelte-1phssyn",document.head);c=l(e,"META",{name:!0,content:!0}),e.forEach(t),lt=p(s),Qs=l(s,"P",{}),h(Qs).forEach(t),it=p(s),g=l(s,"H1",{class:!0});var ye=h(g);b=l(ye,"A",{id:!0,class:!0,href:!0});var $a=h(b);Vs=l($a,"SPAN",{});var Aa=h(Vs);H(O.$$.fragment,Aa),Aa.forEach(t),$a.forEach(t),Te=p(ye),zs=l(ye,"SPAN",{"data-svelte-h":!0}),m(zs)!=="svelte-ixyj6d"&&(zs.textContent=Se),ye.forEach(t),pt=p(s),q=l(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-11761za"&&(q.innerHTML=Ie),mt=p(s),N=l(s,"FIGURE",{"data-svelte-h":!0}),m(N)!=="svelte-100gprn"&&(N.innerHTML=Oe),rt=p(s),u=l(s,"H2",{class:!0});var de=h(u);_=l(de,"A",{id:!0,class:!0,href:!0});var za=h(_);Xs=l(za,"SPAN",{});var Sa=h(Xs);H(B.$$.fragment,Sa),Sa.forEach(t),za.forEach(t),Me=p(de),Ss=l(de,"SPAN",{"data-svelte-h":!0}),m(Ss)!=="svelte-1se861v"&&(Ss.textContent=qe),de.forEach(t),ot=p(s),U=l(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-lpi75"&&(U.innerHTML=Ne),ht=p(s),W=l(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-14lxxwh"&&(W.textContent=Be),ct=p(s),j=l(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-p0ulb9"&&(j.textContent=Ue),gt=p(s),G=l(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-u5xaw1"&&(G.innerHTML=We),ut=p(s),K=l(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1h64ov0"&&(K.innerHTML=je),vt=p(s),R=l(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-55g9r1"&&(R.textContent=Ge),ft=p(s),D=l(s,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-lzd6wo"&&(D.innerHTML=Ke),yt=p(s),F=l(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1o4lxst"&&(F.textContent=Re),dt=p(s),J=l(s,"UL",{"data-svelte-h":!0}),m(J)!=="svelte-1emhb1j"&&(J.innerHTML=De),wt=p(s),Q=l(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-kbldhc"&&(Q.innerHTML=Fe),xt=p(s),v=l(s,"H2",{class:!0});var we=h(v);L=l(we,"A",{id:!0,class:!0,href:!0});var Ia=h(L);Ys=l(Ia,"SPAN",{});var Oa=h(Ys);H(V.$$.fragment,Oa),Oa.forEach(t),Ia.forEach(t),ke=p(we),Is=l(we,"SPAN",{"data-svelte-h":!0}),m(Is)!=="svelte-1socyq"&&(Is.textContent=Je),we.forEach(t),bt=p(s),X=l(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1ebc5gu"&&(X.innerHTML=Qe),_t=p(s),Y=l(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-10ql4ev"&&(Y.innerHTML=Ve),Lt=p(s),Z=l(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1ai24rk"&&(Z.textContent=Xe),Ct=p(s),ss=l(s,"UL",{"data-svelte-h":!0}),m(ss)!=="svelte-1mu3qvi"&&(ss.innerHTML=Ye),Tt=p(s),ts=l(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-1cykdly"&&(ts.innerHTML=Ze),Mt=p(s),f=l(s,"H2",{class:!0});var xe=h(f);C=l(xe,"A",{id:!0,class:!0,href:!0});var qa=h(C);Zs=l(qa,"SPAN",{});var Na=h(Zs);H(es.$$.fragment,Na),Na.forEach(t),qa.forEach(t),Ee=p(xe),Os=l(xe,"SPAN",{"data-svelte-h":!0}),m(Os)!=="svelte-1x5zi5r"&&(Os.textContent=sa),xe.forEach(t),kt=p(s),y=l(s,"H3",{class:!0});var be=h(y);T=l(be,"A",{id:!0,class:!0,href:!0});var Ba=h(T);st=l(Ba,"SPAN",{});var Ua=h(st);H(as.$$.fragment,Ua),Ua.forEach(t),Ba.forEach(t),Pe=p(be),qs=l(be,"SPAN",{"data-svelte-h":!0}),m(qs)!=="svelte-wrkqyo"&&(qs.textContent=ta),be.forEach(t),Et=p(s),ns=l(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-1mqy8v4"&&(ns.innerHTML=ea),Pt=p(s),ls=l(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-gobmv7"&&(ls.innerHTML=aa),Ht=p(s),is=l(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-1o35bla"&&(is.innerHTML=na),$t=p(s),ps=l(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-15oqr9w"&&(ps.textContent=la),At=p(s),ms=l(s,"P",{"data-svelte-h":!0}),m(ms)!=="svelte-157lnkz"&&(ms.innerHTML=ia),zt=p(s),rs=l(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1y39nsv"&&(rs.innerHTML=pa),St=p(s),os=l(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-131w5mi"&&(os.innerHTML=ma),It=p(s),hs=l(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-1dcyvr4"&&(hs.innerHTML=ra),Ot=p(s),cs=l(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-aiamx5"&&(cs.textContent=oa),qt=p(s),gs=l(s,"UL",{"data-svelte-h":!0}),m(gs)!=="svelte-f0z965"&&(gs.innerHTML=ha),Nt=p(s),us=l(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-1arvr0c"&&(us.innerHTML=ca),Bt=p(s),vs=l(s,"IMG",{src:!0,alt:!0}),Ut=p(s),fs=l(s,"P",{"data-svelte-h":!0}),m(fs)!=="svelte-18tm8in"&&(fs.innerHTML=ua),Wt=p(s),ys=l(s,"P",{"data-svelte-h":!0}),m(ys)!=="svelte-1rjqydl"&&(ys.textContent=va),jt=p(s),ds=l(s,"UL",{"data-svelte-h":!0}),m(ds)!=="svelte-11vizph"&&(ds.innerHTML=fa),Gt=p(s),ws=l(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-vcvh8c"&&(ws.textContent=ya),Kt=p(s),xs=l(s,"IMG",{src:!0,alt:!0}),Rt=p(s),d=l(s,"H3",{class:!0});var _e=h(d);M=l(_e,"A",{id:!0,class:!0,href:!0});var Wa=h(M);tt=l(Wa,"SPAN",{});var ja=h(tt);H(bs.$$.fragment,ja),ja.forEach(t),Wa.forEach(t),He=p(_e),Ns=l(_e,"SPAN",{"data-svelte-h":!0}),m(Ns)!=="svelte-1o0sfn1"&&(Ns.textContent=wa),_e.forEach(t),Dt=p(s),_s=l(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-w96c5b"&&(_s.textContent=xa),Ft=p(s),Ls=l(s,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-1xxccyh"&&(Ls.textContent=ba),Jt=p(s),Cs=l(s,"P",{"data-svelte-h":!0}),m(Cs)!=="svelte-g7g8r5"&&(Cs.textContent=_a),Qt=p(s),Ts=l(s,"UL",{"data-svelte-h":!0}),m(Ts)!=="svelte-6kyfto"&&(Ts.innerHTML=La),Vt=p(s),Bs=l(s,"P",{});var Ga=h(Bs);Xt=Js(Ga,!1),Ga.forEach(t),Yt=p(s),Us=l(s,"P",{});var Ka=h(Us);Zt=Js(Ka,!1),Ka.forEach(t),se=p(s),Ms=l(s,"UL",{"data-svelte-h":!0}),m(Ms)!=="svelte-19f3iy9"&&(Ms.innerHTML=Ca),te=p(s),Ws=l(s,"P",{});var Ra=h(Ws);ee=Js(Ra,!1),Ra.forEach(t),ae=p(s),js=l(s,"P",{});var Da=h(js);ne=Js(Da,!1),Da.forEach(t),le=p(s),ks=l(s,"UL",{"data-svelte-h":!0}),m(ks)!=="svelte-1aqpfwy"&&(ks.innerHTML=Ta),ie=p(s),Gs=l(s,"P",{});var Fa=h(Gs);pe=Js(Fa,!1),Fa.forEach(t),me=p(s),Ks=l(s,"P",{});var Ja=h(Ks);re=Js(Ja,!1),Ja.forEach(t),oe=p(s),w=l(s,"H3",{class:!0});var Le=h(w);k=l(Le,"A",{id:!0,class:!0,href:!0});var Qa=h(k);et=l(Qa,"SPAN",{});var Va=h(et);H(Es.$$.fragment,Va),Va.forEach(t),Qa.forEach(t),$e=p(Le),Rs=l(Le,"SPAN",{"data-svelte-h":!0}),m(Rs)!=="svelte-1jp7tj4"&&(Rs.textContent=Ma),Le.forEach(t),he=p(s),Ps=l(s,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-9bi3av"&&(Ps.textContent=ka),ce=p(s),Hs=l(s,"UL",{"data-svelte-h":!0}),m(Hs)!=="svelte-1uibl83"&&(Hs.innerHTML=Ea),ge=p(s),x=l(s,"H3",{class:!0});var Ce=h(x);E=l(Ce,"A",{id:!0,class:!0,href:!0});var Xa=h(E);at=l(Xa,"SPAN",{});var Ya=h(at);H($s.$$.fragment,Ya),Ya.forEach(t),Xa.forEach(t),Ae=p(Ce),Ds=l(Ce,"SPAN",{"data-svelte-h":!0}),m(Ds)!=="svelte-1hfv8xm"&&(Ds.textContent=Pa),Ce.forEach(t),ue=p(s),As=l(s,"UL",{"data-svelte-h":!0}),m(As)!=="svelte-s7jtcw"&&(As.innerHTML=Ha),ve=p(s),nt=l(s,"P",{}),h(nt).forEach(t),this.h()},h(){r(c,"name","hf:doc:metadata"),r(c,"content",JSON.stringify(un)),r(b,"id","selfplay-a-classic-technique-to-train-competitive-agents-in-adversarial-games"),r(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(b,"href","#selfplay-a-classic-technique-to-train-competitive-agents-in-adversarial-games"),r(g,"class","relative group"),r(_,"id","what-is-selfplay"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#what-is-selfplay"),r(u,"class","relative group"),r(L,"id","selfplay-in-mlagents"),r(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(L,"href","#selfplay-in-mlagents"),r(v,"class","relative group"),r(C,"id","the-elo-score-to-evaluate-our-agent"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#the-elo-score-to-evaluate-our-agent"),r(f,"class","relative group"),r(T,"id","what-is-elo-score"),r(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(T,"href","#what-is-elo-score"),r(y,"class","relative group"),Za(vs.src,ga="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/elo1.png")||r(vs,"src",ga),r(vs,"alt","ELO Score"),Za(xs.src,da="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit10/elo2.png")||r(xs,"src",da),r(xs,"alt","ELO Score"),r(M,"id","example"),r(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(M,"href","#example"),r(d,"class","relative group"),Xt.a=null,Zt.a=null,ee.a=null,ne.a=null,pe.a=null,re.a=null,r(k,"id","the-advantages"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#the-advantages"),r(w,"class","relative group"),r(E,"id","the-disadvantages"),r(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(E,"href","#the-disadvantages"),r(x,"class","relative group")},m(s,e){o(document.head,c),a(s,lt,e),a(s,Qs,e),a(s,it,e),a(s,g,e),o(g,b),o(b,Vs),$(O,Vs,null),o(g,Te),o(g,zs),a(s,pt,e),a(s,q,e),a(s,mt,e),a(s,N,e),a(s,rt,e),a(s,u,e),o(u,_),o(_,Xs),$(B,Xs,null),o(u,Me),o(u,Ss),a(s,ot,e),a(s,U,e),a(s,ht,e),a(s,W,e),a(s,ct,e),a(s,j,e),a(s,gt,e),a(s,G,e),a(s,ut,e),a(s,K,e),a(s,vt,e),a(s,R,e),a(s,ft,e),a(s,D,e),a(s,yt,e),a(s,F,e),a(s,dt,e),a(s,J,e),a(s,wt,e),a(s,Q,e),a(s,xt,e),a(s,v,e),o(v,L),o(L,Ys),$(V,Ys,null),o(v,ke),o(v,Is),a(s,bt,e),a(s,X,e),a(s,_t,e),a(s,Y,e),a(s,Lt,e),a(s,Z,e),a(s,Ct,e),a(s,ss,e),a(s,Tt,e),a(s,ts,e),a(s,Mt,e),a(s,f,e),o(f,C),o(C,Zs),$(es,Zs,null),o(f,Ee),o(f,Os),a(s,kt,e),a(s,y,e),o(y,T),o(T,st),$(as,st,null),o(y,Pe),o(y,qs),a(s,Et,e),a(s,ns,e),a(s,Pt,e),a(s,ls,e),a(s,Ht,e),a(s,is,e),a(s,$t,e),a(s,ps,e),a(s,At,e),a(s,ms,e),a(s,zt,e),a(s,rs,e),a(s,St,e),a(s,os,e),a(s,It,e),a(s,hs,e),a(s,Ot,e),a(s,cs,e),a(s,qt,e),a(s,gs,e),a(s,Nt,e),a(s,us,e),a(s,Bt,e),a(s,vs,e),a(s,Ut,e),a(s,fs,e),a(s,Wt,e),a(s,ys,e),a(s,jt,e),a(s,ds,e),a(s,Gt,e),a(s,ws,e),a(s,Kt,e),a(s,xs,e),a(s,Rt,e),a(s,d,e),o(d,M),o(M,tt),$(bs,tt,null),o(d,He),o(d,Ns),a(s,Dt,e),a(s,_s,e),a(s,Ft,e),a(s,Ls,e),a(s,Jt,e),a(s,Cs,e),a(s,Qt,e),a(s,Ts,e),a(s,Vt,e),a(s,Bs,e),Xt.m(sn,Bs),a(s,Yt,e),a(s,Us,e),Zt.m(tn,Us),a(s,se,e),a(s,Ms,e),a(s,te,e),a(s,Ws,e),ee.m(en,Ws),a(s,ae,e),a(s,js,e),ne.m(an,js),a(s,le,e),a(s,ks,e),a(s,ie,e),a(s,Gs,e),pe.m(nn,Gs),a(s,me,e),a(s,Ks,e),re.m(ln,Ks),a(s,oe,e),a(s,w,e),o(w,k),o(k,et),$(Es,et,null),o(w,$e),o(w,Rs),a(s,he,e),a(s,Ps,e),a(s,ce,e),a(s,Hs,e),a(s,ge,e),a(s,x,e),o(x,E),o(E,at),$($s,at,null),o(x,Ae),o(x,Ds),a(s,ue,e),a(s,As,e),a(s,ve,e),a(s,nt,e),fe=!0},p:mn,i(s){fe||(A(O.$$.fragment,s),A(B.$$.fragment,s),A(V.$$.fragment,s),A(es.$$.fragment,s),A(as.$$.fragment,s),A(bs.$$.fragment,s),A(Es.$$.fragment,s),A($s.$$.fragment,s),fe=!0)},o(s){z(O.$$.fragment,s),z(B.$$.fragment,s),z(V.$$.fragment,s),z(es.$$.fragment,s),z(as.$$.fragment,s),z(bs.$$.fragment,s),z(Es.$$.fragment,s),z($s.$$.fragment,s),fe=!1},d(s){s&&(t(lt),t(Qs),t(it),t(g),t(pt),t(q),t(mt),t(N),t(rt),t(u),t(ot),t(U),t(ht),t(W),t(ct),t(j),t(gt),t(G),t(ut),t(K),t(vt),t(R),t(ft),t(D),t(yt),t(F),t(dt),t(J),t(wt),t(Q),t(xt),t(v),t(bt),t(X),t(_t),t(Y),t(Lt),t(Z),t(Ct),t(ss),t(Tt),t(ts),t(Mt),t(f),t(kt),t(y),t(Et),t(ns),t(Pt),t(ls),t(Ht),t(is),t($t),t(ps),t(At),t(ms),t(zt),t(rs),t(St),t(os),t(It),t(hs),t(Ot),t(cs),t(qt),t(gs),t(Nt),t(us),t(Bt),t(vs),t(Ut),t(fs),t(Wt),t(ys),t(jt),t(ds),t(Gt),t(ws),t(Kt),t(xs),t(Rt),t(d),t(Dt),t(_s),t(Ft),t(Ls),t(Jt),t(Cs),t(Qt),t(Ts),t(Vt),t(Bs),t(Yt),t(Us),t(se),t(Ms),t(te),t(Ws),t(ae),t(js),t(le),t(ks),t(ie),t(Gs),t(me),t(Ks),t(oe),t(w),t(he),t(Ps),t(ce),t(Hs),t(ge),t(x),t(ue),t(As),t(ve),t(nt)),t(c),S(O),S(B),S(V),S(es),S(as),S(bs),S(Es),S($s)}}}const un={local:"selfplay-a-classic-technique-to-train-competitive-agents-in-adversarial-games",sections:[{local:"what-is-selfplay",title:"What is Self-Play?"},{local:"selfplay-in-mlagents",title:"Self-Play in MLAgents"},{local:"the-elo-score-to-evaluate-our-agent",sections:[{local:"what-is-elo-score",title:"What is ELO Score?"},{local:"example",title:"Example"},{local:"the-advantages",title:"The Advantages"},{local:"the-disadvantages",title:"The Disadvantages"}],title:"The ELO Score to evaluate our agent"}],title:"Self-Play: a classic technique to train competitive agents in adversarial games"};function vn(ze){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends on{constructor(c){super(),hn(this,c,vn,gn,pn,{})}}export{wn as component};
