import{s as Zi,f as Ft,n as Ii,o as ki}from"../chunks/scheduler.37c15a92.js";import{S as Ci,i as $i,g as n,s as o,u as c,A as Gi,h as s,f as t,c as i,j as m,v as u,y as h,k as r,o as p,a,w as d,d as f,t as y,x as M}from"../chunks/index.b01106c0.js";import{I as w}from"../chunks/IconCopyLink.77b762b4.js";import{C as v}from"../chunks/CodeBlock.00a4ae02.js";import{C as Bi}from"../chunks/CourseFloatingBanner.9c5d96ce.js";function Wi(ds){let g,xl,dl,Hl,J,V,fl,se,Qn,Qt,fs="Hands-on: advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",El,oe,Xl,ie,ys=`The colab notebook:
<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit8/unit8_part2.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>`,Al,T,N,yl,re,Pn,Pt,Ms="Unit 8 Part 2: Advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",Vl,pe,ws,Nl,he,vs='In this notebook, we will learn how to train a Deep Neural Network to collect objects in a 3D environment based on the game of Doom, a video of the resulting policy is shown below. We train this policy using <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a>, an asynchronous implementation of the PPO algorithm.',Sl,me,gs="Please note the following points:",Rl,ce,Js='<li><p><a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is an advanced RL framework and <strong>only functions on Linux and Mac</strong> (not Windows).</p></li> <li><p>The framework performs best on a <strong>GPU machine with many CPU cores</strong>, where it can achieve speeds of 100k interactions per second. The resources available on a standard Colab notebook <strong>limit the performance of this library</strong>. So the speed in this setting <strong>does not reflect the real-world performance</strong>.</p></li> <li><p>Benchmarks for Sample Factory are available in a number of settings, check out the <a href="https://github.com/alex-petrenko/sample-factory/tree/master/sf_examples" rel="nofollow">examples</a> if you want to find out more.</p></li>',zl,ue,Ll,de,Ts='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push one model:',ql,fe,bs="<li><code>doom_health_gathering_supreme</code> get a result of &gt;= 5.</li>",Yl,ye,js='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Fl,Me,Us="If you don’t find your model, <strong>go to the bottom of the page and click on the refresh button</strong>",Ql,we,_s='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',Pl,b,S,Ml,ve,Dn,Dt,Zs="Set the GPU 💪",Dl,ge,Is="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",Kl,Je,ks,Ol,Te,Cs="<li><code>Hardware Accelerator &gt; GPU</code></li>",ea,be,$s,ta,je,Gs="Before starting to train our agent, let’s <strong>study the library and environments we’re going to use</strong>.",la,j,R,wl,Ue,Kn,Kt,Bs="Sample Factory",aa,_e,Ws='<a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is one of the <strong>fastest RL libraries focused on very efficient synchronous and asynchronous implementations of policy gradients (PPO)</strong>.',na,Ze,xs="Sample Factory is thoroughly <strong>tested, used by many researchers and practitioners</strong>, and is actively maintained. Our implementation is known to <strong>reach SOTA performance in a variety of domains while minimizing RL experiment training time and hardware requirements</strong>.",sa,Ie,Hs,oa,U,z,vl,ke,On,Ot,Es="Key features",ia,Ce,Xs='<li>Highly optimized algorithm <a href="https://www.samplefactory.dev/06-architecture/overview/" rel="nofollow">architecture</a> for maximum learning throughput</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/sync-async/" rel="nofollow">Synchronous and asynchronous</a> training regimes</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/serial-mode/" rel="nofollow">Serial (single-process) mode</a> for easy debugging</li> <li>Optimal performance in both CPU-based and <a href="https://www.samplefactory.dev/09-environment-integrations/isaacgym/" rel="nofollow">GPU-accelerated environments</a></li> <li>Single- &amp; multi-agent training, self-play, supports <a href="https://www.samplefactory.dev/07-advanced-topics/multi-policy-training/" rel="nofollow">training multiple policies</a> at once on one or many GPUs</li> <li>Population-Based Training (<a href="https://www.samplefactory.dev/07-advanced-topics/pbt/" rel="nofollow">PBT</a>)</li> <li>Discrete, continuous, hybrid action spaces</li> <li>Vector-based, image-based, dictionary observation spaces</li> <li>Automatically creates a model architecture by parsing action/observation space specification. Supports <a href="https://www.samplefactory.dev/03-customization/custom-models/" rel="nofollow">custom model architectures</a></li> <li>Designed to be imported into other projects, <a href="https://www.samplefactory.dev/03-customization/custom-environments/" rel="nofollow">custom environments</a> are first-class citizens</li> <li>Detailed <a href="https://www.samplefactory.dev/05-monitoring/metrics-reference/" rel="nofollow">WandB and Tensorboard summaries</a>, <a href="https://www.samplefactory.dev/05-monitoring/custom-metrics/" rel="nofollow">custom metrics</a></li> <li><a href="https://www.samplefactory.dev/10-huggingface/huggingface/" rel="nofollow">HuggingFace 🤗 integration</a> (upload trained models and metrics to the Hub)</li> <li><a href="https://www.samplefactory.dev/09-environment-integrations/mujoco/" rel="nofollow">Multiple</a> <a href="https://www.samplefactory.dev/09-environment-integrations/atari/" rel="nofollow">example</a> <a href="https://www.samplefactory.dev/09-environment-integrations/vizdoom/" rel="nofollow">environment</a> <a href="https://www.samplefactory.dev/09-environment-integrations/dmlab/" rel="nofollow">integrations</a> with tuned parameters and trained models</li>',ra,$e,As='All of the above policies are available on the 🤗 hub. Search for the tag <a href="https://huggingface.co/models?library=sample-factory&amp;sort=downloads" rel="nofollow">sample-factory</a>',pa,_,L,gl,Ge,es,el,Vs="How sample-factory works",ha,Be,Ns="Sample-factory is one of the <strong>most highly optimized RL implementations available to the community</strong>.",ma,We,Ss="It works by <strong>spawning multiple processes that run rollout workers, inference workers and a learner worker</strong>.",ca,xe,Rs="The <em>workers</em> <strong>communicate through shared memory, which lowers the communication cost between processes</strong>.",ua,He,zs="The <em>rollout workers</em> interact with the environment and send observations to the <em>inference workers</em>.",da,Ee,Ls="The <em>inferences workers</em> query a fixed version of the policy and <strong>send actions back to the rollout worker</strong>.",fa,Xe,qs="After <em>k</em> steps the rollout works send a trajectory of experience to the learner worker, <strong>which it uses to update the agent’s policy network</strong>.",ya,Ae,Ys,Ma,Z,q,Jl,Ve,ts,tl,Fs="Actor Critic models in Sample-factory",wa,Ne,Qs="Actor Critic models in Sample Factory are composed of three components:",va,Se,Ps="<li><strong>Encoder</strong> - Process input observations (images, vectors) and map them to a vector. This is the part of the model you will most likely want to customize.</li> <li><strong>Core</strong> - Intergrate vectors from one or more encoders, can optionally include a single- or multi-layer LSTM/GRU in a memory-based agent.</li> <li><strong>Decoder</strong> - Apply additional layers to the output of the model core before computing the policy and value outputs.</li>",ga,Re,Ds='The library has been designed to automatically support any observation and action spaces. Users can easily add their custom models. You can find out more in the <a href="https://www.samplefactory.dev/03-customization/custom-models/#actor-critic-models-in-sample-factory" rel="nofollow">documentation</a>.',Ja,I,Y,Tl,ze,ls,ll,Ks="ViZDoom",Ta,Le,Os='<a href="https://vizdoom.cs.put.edu.pl/" rel="nofollow">ViZDoom</a> is an <strong>open-source python interface for the Doom Engine</strong>.',ba,qe,eo="The library was created in 2016 by Marek Wydmuch, Michal Kempka  at the Institute of Computing Science, Poznan University of Technology, Poland.",ja,Ye,to="The library enables the <strong>training of agents directly from the screen pixels in a number of scenarios</strong>, including team deathmatch, shown in the video below. Because the ViZDoom environment is based on a game the was created in the 90s, it can be run on modern hardware at accelerated speeds, <strong>allowing us to learn complex AI behaviors fairly quickly</strong>.",Ua,Fe,lo="The library includes feature such as:",_a,Qe,ao='<li>Multi-platform (Linux, macOS, Windows),</li> <li>API for Python and C++,</li> <li><a href="https://www.gymlibrary.dev/" rel="nofollow">OpenAI Gym</a> environment wrappers</li> <li>Easy-to-create custom scenarios (visual editors, scripting language, and examples available),</li> <li>Async and sync single-player and multiplayer modes,</li> <li>Lightweight (few MBs) and fast (up to 7000 fps in sync mode, single-threaded),</li> <li>Customizable resolution and rendering parameters,</li> <li>Access to the depth buffer (3D vision),</li> <li>Automatic labeling of game objects visible in the frame,</li> <li>Access to the audio buffer</li> <li>Access to the list of actors/objects and map geometry,</li> <li>Off-screen rendering and episode recording,</li> <li>Time scaling in async mode.</li>',Za,k,F,bl,Pe,as,al,no="We first need to install some dependencies that are required for the ViZDoom environment",Ia,De,so="Now that our Colab runtime is set up, we can start by installing the dependencies required to run ViZDoom on linux.",ka,Ke,oo='If you are following on your machine on Mac, you will want to follow the installation instructions on the <a href="https://github.com/Farama-Foundation/ViZDoom/blob/master/doc/Quickstart.md#-quickstart-for-macos-and-anaconda3-python-36" rel="nofollow">github page</a>.',Ca,Oe,$a,C,Q,jl,et,ns,nl,io="Then we can install Sample Factory and ViZDoom",Ga,tt,ro="<li>This can take 7min</li>",Ba,lt,Wa,$,P,Ul,at,ss,sl,po="Setting up the Doom Environment in sample-factory",xa,nt,Ha,st,ho="Now that the setup if complete, we can train the agent. We have chosen here to learn a ViZDoom task called <code>Health Gathering Supreme</code>.",Ea,G,D,_l,ot,os,ol,mo="The scenario: Health Gathering Supreme",Xa,it,co,Aa,rt,uo="The objective of this scenario is to <strong>teach the agent how to survive without knowing what makes it survive</strong>. The Agent know only that <strong>life is precious</strong> and death is bad so <strong>it must learn what prolongs its existence and that its health is connected with survival</strong>.",Va,pt,fo="The map is a rectangle containing walls and with a green, acidic floor which <strong>hurts the player periodically</strong>. Initially there are some medkits spread uniformly over the map. A new medkit falls from the skies every now and then. <strong>Medkits heal some portions of player’s health</strong> - to survive, the agent needs to pick them up. The episode finishes after the player’s death or on timeout.",Na,ht,yo="Further configuration:",Sa,mt,Mo="<li>Living_reward = 1</li> <li>3 available buttons: turn left, turn right, move forward</li> <li>1 available game variable: HEALTH</li> <li>death penalty = 100</li>",Ra,ct,wo='You can find out more about the scenarios available in ViZDoom <a href="https://github.com/Farama-Foundation/ViZDoom/tree/master/scenarios" rel="nofollow">here</a>.',za,ut,vo='There are also a number of more complex scenarios that have been create for ViZDoom, such as the ones detailed on <a href="https://github.com/edbeeching/3d_control_deep_rl" rel="nofollow">this github page</a>.',La,B,K,Zl,dt,is,il,go="Training the agent",qa,ft,Jo="<li>We’re going to train the agent for 4000000 steps. It will take approximately 20min</li>",Ya,yt,Fa,W,O,Il,Mt,rs,rl,To="Let's take a look at the performance of the trained policy and output a video of the agent.",Qa,wt,Pa,x,ee,kl,vt,ps,pl,bo="Now lets visualize the performance of the agent",Da,gt,Ka,Jt,jo="The agent has learned something, but its performance could be better. We would clearly need to train for longer. But let’s upload this model to the Hub.",Oa,H,te,Cl,Tt,hs,hl,Uo="Now lets upload your checkpoint and video to the Hugging Face Hub",en,bt,_o="To be able to share your model with the community there are three more steps to follow:",tn,jt,Zo='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',ln,Ut,Io="2️⃣ Sign in and get your authentication token from the Hugging Face website.",an,_t,ko='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',nn,Zt,Co,sn,It,$o="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",on,kt,Go="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",rn,Ct,pn,$t,hn,E,le,$l,Gt,ms,ml,Bo="Let's load another model",mn,Bt,Wo="This agent’s performance was good, but we can do better! Let’s download and visualize an agent trained for 10B timesteps from the hub.",cn,Wt,un,xt,dn,Ht,fn,Et,yn,X,ae,Gl,Xt,cs,cl,xo="Some additional challenges 🏆: Doom Deathmatch",Mn,At,Ho="Training an agent to play a Doom deathmatch <strong>takes many hours on a more beefy machine than is available in Colab</strong>.",wn,Vt,Eo="Fortunately, we have have <strong>already trained an agent in this scenario and it is available in the 🤗 Hub!</strong> Let’s download the model and visualize the agent’s performance.",vn,Nt,gn,St,Xo="Given the agent plays for a long time the video generation can take <strong>10 minutes</strong>.",Jn,Rt,Tn,zt,Ao=`You <strong>can try to train your agent in this environment</strong> using the code above, but not on colab.
<strong>Good luck 🤞</strong>`,bn,Lt,Vo="If you prefer an easier scenario, <strong>why not try training in another ViZDoom scenario such as <code>doom_deadly_corridor</code> or <code>doom_defend_the_center</code>.</strong>",jn,Un,_n,qt,No="This concludes the last unit. But we are not finished yet! 🤗 The following <strong>bonus section include some of the most interesting, advanced, and cutting edge work in Deep Reinforcement Learning</strong>.",Zn,A,ne,Bl,Yt,us,ul,So="Keep learning, stay awesome 🤗",In,Wl,kn;return se=new w({}),oe=new Bi({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit8/unit8_part2.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),re=new w({}),ue=new v({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEhUTUwlMEElMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUzQ3ZpZGVvJTIwd2lkdGglM0QlMjI2NDAlMjIlMjBoZWlnaHQlM0QlMjI0ODAlMjIlMjBjb250cm9scyUzRSUwQSUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZlZGJlZWNoaW5nJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMzMzMyUyRnJlc29sdmUlMkZtYWluJTJGcmVwbGF5Lm1wNCUyMiUwQSUyMCUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRVlvdXIlMjBicm93c2VyJTIwZG9lcyUyMG5vdCUyMHN1cHBvcnQlMjB0aGUlMjB2aWRlbyUyMHRhZy4lM0MlMkZ2aWRlbyUzRSUyMiUyMiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

HTML(
    <span class="hljs-string">&quot;&quot;&quot;&lt;video width=&quot;640&quot; height=&quot;480&quot; controls&gt;
  &lt;source src=&quot;https://huggingface.co/edbeeching/doom_health_gathering_supreme_3333/resolve/main/replay.mp4&quot;
  type=&quot;video/mp4&quot;&gt;Your browser does not support the video tag.&lt;/video&gt;&quot;&quot;&quot;</span>
)`,wrap:!1}}),ve=new w({}),Ue=new w({}),ke=new w({}),Ge=new w({}),Ve=new w({}),ze=new w({}),Pe=new w({}),Oe=new v({props:{code:"JTIzJTIwSW5zdGFsbCUyMFZpWkRvb20lMjBkZXBzJTIwZnJvbSUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRm13eWRtdWNoJTJGVmlaRG9vbSUyRmJsb2IlMkZtYXN0ZXIlMkZkb2MlMkZCdWlsZGluZy5tZCUyMy1saW51eCUwQSUwQWFwdC1nZXQlMjBpbnN0YWxsJTIwYnVpbGQtZXNzZW50aWFsJTIwemxpYjFnLWRldiUyMGxpYnNkbDItZGV2JTIwbGlianBlZy1kZXYlMjAlNUMlMEFuYXNtJTIwdGFyJTIwbGliYnoyLWRldiUyMGxpYmd0azIuMC1kZXYlMjBjbWFrZSUyMGdpdCUyMGxpYmZsdWlkc3ludGgtZGV2JTIwbGliZ21lLWRldiUyMCU1QyUwQWxpYm9wZW5hbC1kZXYlMjB0aW1pZGl0eSUyMGxpYndpbGRtaWRpLWRldiUyMHVuemlwJTIwZmZtcGVnJTBBJTBBJTIzJTIwQm9vc3QlMjBsaWJyYXJpZXMlMEFhcHQtZ2V0JTIwaW5zdGFsbCUyMGxpYmJvb3N0LWFsbC1kZXYlMEElMEElMjMlMjBMdWElMjBiaW5kaW5nJTIwZGVwZW5kZW5jaWVzJTBBYXB0LWdldCUyMGluc3RhbGwlMjBsaWJsdWE1LjEtZGV2",highlighted:`<span class="hljs-comment"># Install ViZDoom deps from</span>
<span class="hljs-comment"># https://github.com/mwydmuch/ViZDoom/blob/master/doc/Building.md#-linux</span>

apt-get install build-essential zlib1g-dev libsdl2-dev libjpeg-dev \\
nasm tar libbz2-dev libgtk2<span class="hljs-number">.0</span>-dev cmake git libfluidsynth-dev libgme-dev \\
libopenal-dev timidity libwildmidi-dev unzip ffmpeg

<span class="hljs-comment"># Boost libraries</span>
apt-get install libboost-<span class="hljs-built_in">all</span>-dev

<span class="hljs-comment"># Lua binding dependencies</span>
apt-get install liblua5<span class="hljs-number">.1</span>-dev`,wrap:!1}}),et=new w({}),lt=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhbXBsZS1mYWN0b3J5JTBBcGlwJTIwaW5zdGFsbCUyMHZpemRvb20=",highlighted:`pip install sample-factory
pip install vizdoom`,wrap:!1}}),at=new w({}),nt=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> functools

<span class="hljs-keyword">from</span> sample_factory.algo.utils.context <span class="hljs-keyword">import</span> global_model_factory
<span class="hljs-keyword">from</span> sample_factory.cfg.arguments <span class="hljs-keyword">import</span> parse_full_cfg, parse_sf_args
<span class="hljs-keyword">from</span> sample_factory.envs.env_utils <span class="hljs-keyword">import</span> register_env
<span class="hljs-keyword">from</span> sample_factory.train <span class="hljs-keyword">import</span> run_rl

<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_model <span class="hljs-keyword">import</span> make_vizdoom_encoder
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_params <span class="hljs-keyword">import</span> add_doom_env_args, doom_override_defaults
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_utils <span class="hljs-keyword">import</span> DOOM_ENVS, make_doom_env_from_spec


<span class="hljs-comment"># Registers all the ViZDoom environments</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_envs</span>():
    <span class="hljs-keyword">for</span> env_spec <span class="hljs-keyword">in</span> DOOM_ENVS:
        make_env_func = functools.partial(make_doom_env_from_spec, env_spec)
        register_env(env_spec.name, make_env_func)


<span class="hljs-comment"># Sample Factory allows the registration of a custom Neural Network architecture</span>
<span class="hljs-comment"># See https://github.com/alex-petrenko/sample-factory/blob/master/sf_examples/vizdoom/doom/doom_model.py for more details</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_models</span>():
    global_model_factory().register_encoder_factory(make_vizdoom_encoder)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_components</span>():
    register_vizdoom_envs()
    register_vizdoom_models()


<span class="hljs-comment"># parse the command line args and create a config</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_vizdoom_cfg</span>(<span class="hljs-params">argv=<span class="hljs-literal">None</span>, evaluation=<span class="hljs-literal">False</span></span>):
    parser, _ = parse_sf_args(argv=argv, evaluation=evaluation)
    <span class="hljs-comment"># parameters specific to Doom envs</span>
    add_doom_env_args(parser)
    <span class="hljs-comment"># override Doom default values for algo parameters</span>
    doom_override_defaults(parser)
    <span class="hljs-comment"># second parsing pass yields the final configuration</span>
    final_cfg = parse_full_cfg(parser, argv)
    <span class="hljs-keyword">return</span> final_cfg`,wrap:!1}}),ot=new w({}),dt=new w({}),yt=new v({props:{code:"JTIzJTIzJTIwU3RhcnQlMjB0aGUlMjB0cmFpbmluZyUyQyUyMHRoaXMlMjBzaG91bGQlMjB0YWtlJTIwYXJvdW5kJTIwMTUlMjBtaW51dGVzJTBBcmVnaXN0ZXJfdml6ZG9vbV9jb21wb25lbnRzKCklMEElMEElMjMlMjBUaGUlMjBzY2VuYXJpbyUyMHdlJTIwdHJhaW4lMjBvbiUyMHRvZGF5JTIwaXMlMjBoZWFsdGglMjBnYXRoZXJpbmclMEElMjMlMjBvdGhlciUyMHNjZW5hcmlvcyUyMGluY2x1ZGUlMjAlMjJkb29tX2Jhc2ljJTIyJTJDJTIwJTIyZG9vbV90d29fY29sb3JzX2Vhc3klMjIlMkMlMjAlMjJkb29tX2RtJTIyJTJDJTIwJTIyZG9vbV9kd2FuZ281JTIyJTJDJTIwJTIyZG9vbV9teV93YXlfaG9tZSUyMiUyQyUyMCUyMmRvb21fZGVhZGx5X2NvcnJpZG9yJTIyJTJDJTIwJTIyZG9vbV9kZWZlbmRfdGhlX2NlbnRlciUyMiUyQyUyMCUyMmRvb21fZGVmZW5kX3RoZV9saW5lJTIyJTBBZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDglMjIlMkMlMjAlMjItLW51bV9lbnZzX3Blcl93b3JrZXIlM0Q0JTIyJTJDJTIwJTIyLS10cmFpbl9mb3JfZW52X3N0ZXBzJTNENDAwMDAwMCUyMiU1RCUwQSklMEElMEFzdGF0dXMlMjAlM0QlMjBydW5fcmwoY2ZnKQ==",highlighted:`<span class="hljs-comment">## Start the training, this should take around 15 minutes</span>
register_vizdoom_components()

<span class="hljs-comment"># The scenario we train on today is health gathering</span>
<span class="hljs-comment"># other scenarios include &quot;doom_basic&quot;, &quot;doom_two_colors_easy&quot;, &quot;doom_dm&quot;, &quot;doom_dwango5&quot;, &quot;doom_my_way_home&quot;, &quot;doom_deadly_corridor&quot;, &quot;doom_defend_the_center&quot;, &quot;doom_defend_the_line&quot;</span>
env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=8&quot;</span>, <span class="hljs-string">&quot;--num_envs_per_worker=4&quot;</span>, <span class="hljs-string">&quot;--train_for_env_steps=4000000&quot;</span>]
)

status = run_rl(cfg)`,wrap:!1}}),Mt=new w({}),wt=new v({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTVEJTJDJTIwZXZhbHVhdGlvbiUzRFRydWUlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=1&quot;</span>, <span class="hljs-string">&quot;--save_video&quot;</span>, <span class="hljs-string">&quot;--no_render&quot;</span>, <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>], evaluation=<span class="hljs-literal">True</span>
)
status = enjoy(cfg)`,wrap:!1}}),vt=new w({}),gt=new v({props:{code:"ZnJvbSUyMGJhc2U2NCUyMGltcG9ydCUyMGI2NGVuY29kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBIVE1MJTBBJTBBbXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZGVmYXVsdF9leHBlcmltZW50JTJGcmVwbGF5Lm1wNCUyMiUyQyUyMCUyMnJiJTIyKS5yZWFkKCklMEFkYXRhX3VybCUyMCUzRCUyMCUyMmRhdGElM0F2aWRlbyUyRm1wNCUzQmJhc2U2NCUyQyUyMiUyMCUyQiUyMGI2NGVuY29kZShtcDQpLmRlY29kZSgpJTBBSFRNTCglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElM0N2aWRlbyUyMHdpZHRoJTNENjQwJTIwY29udHJvbHMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0Nzb3VyY2UlMjBzcmMlM0QlMjIlMjVzJTIyJTIwdHlwZSUzRCUyMnZpZGVvJTJGbXA0JTIyJTNFJTBBJTNDJTJGdmlkZW8lM0UlMEElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjUlMjBkYXRhX3VybCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> base64 <span class="hljs-keyword">import</span> b64encode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/default_experiment/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Tt=new w({}),Ct=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),$t=new v({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFoZl91c2VybmFtZSUyMCUzRCUyMCUyMlRob21hc1NpbW9uaW5pJTIyJTIwJTIwJTIzJTIwaW5zZXJ0JTIweW91ciUyMEh1Z2dpbmdGYWNlJTIwdXNlcm5hbWUlMjBoZXJlJTBBJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9mcmFtZXMlM0QxMDAwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXB1c2hfdG9faHViJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0taGZfcmVwb3NpdG9yeSUzRCU3QmhmX3VzZXJuYW1lJTdEJTJGcmxfY291cnNlX3ZpemRvb21faGVhbHRoX2dhdGhlcmluZ19zdXByZW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

hf_username = <span class="hljs-string">&quot;ThomasSimonini&quot;</span>  <span class="hljs-comment"># insert your HuggingFace username here</span>

cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--max_num_frames=100000&quot;</span>,
        <span class="hljs-string">&quot;--push_to_hub&quot;</span>,
        <span class="hljs-string">f&quot;--hf_repository=<span class="hljs-subst">{hf_username}</span>/rl_course_vizdoom_health_gathering_supreme&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Gt=new w({}),Wt=new v({props:{code:"JTIzZG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment">#download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_health_gathering_supreme_2222 -d ./train_dir`,wrap:!1}}),xt=new v({props:{code:"bHMlMjB0cmFpbl9kaXIlMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIy",highlighted:'<span class="hljs-built_in">ls</span> train_dir/doom_health_gathering_supreme_2222',wrap:!1}}),Ht=new v({props:{code:"ZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_health_gathering_supreme_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Et=new v({props:{code:"bXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyRnJlcGxheS5tcDQlMjIlMkMlMjAlMjJyYiUyMikucmVhZCgpJTBBZGF0YV91cmwlMjAlM0QlMjAlMjJkYXRhJTNBdmlkZW8lMkZtcDQlM0JiYXNlNjQlMkMlMjIlMjAlMkIlMjBiNjRlbmNvZGUobXA0KS5kZWNvZGUoKSUwQUhUTUwoJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTNDdmlkZW8lMjB3aWR0aCUzRDY0MCUyMGNvbnRyb2xzJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDc291cmNlJTIwc3JjJTNEJTIyJTI1cyUyMiUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRSUwQSUzQyUyRnZpZGVvJTNFJTBBJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTI1JTIwZGF0YV91cmwlMEEp",highlighted:`mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_health_gathering_supreme_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Xt=new w({}),Nt=new v({props:{code:"JTIzJTIwRG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2RlYXRobWF0Y2hfYm90c18yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment"># Download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_deathmatch_bots_2222 -d ./train_dir`,wrap:!1}}),Rt=new v({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFyZWdpc3Rlcl92aXpkb29tX2NvbXBvbmVudHMoKSUwQWVudiUyMCUzRCUyMCUyMmRvb21fZGVhdGhtYXRjaF9ib3RzJTIyJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9kZWF0aG1hdGNoX2JvdHNfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKSUwQW1wNCUyMCUzRCUyMG9wZW4oJTIyJTJGY29udGVudCUyRnRyYWluX2RpciUyRmRvb21fZGVhdGhtYXRjaF9ib3RzXzIyMjIlMkZyZXBsYXkubXA0JTIyJTJDJTIwJTIycmIlMjIpLnJlYWQoKSUwQWRhdGFfdXJsJTIwJTNEJTIwJTIyZGF0YSUzQXZpZGVvJTJGbXA0JTNCYmFzZTY0JTJDJTIyJTIwJTJCJTIwYjY0ZW5jb2RlKG1wNCkuZGVjb2RlKCklMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUzQ3ZpZGVvJTIwd2lkdGglM0Q2NDAlMjBjb250cm9scyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMiUyNXMlMjIlMjB0eXBlJTNEJTIydmlkZW8lMkZtcDQlMjIlM0UlMEElM0MlMkZ2aWRlbyUzRSUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyNSUyMGRhdGFfdXJsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

register_vizdoom_components()
env = <span class="hljs-string">&quot;doom_deathmatch_bots&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=1&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_deathmatch_bots_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)
mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_deathmatch_bots_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Yt=new w({}),{c(){g=n("meta"),xl=o(),dl=n("p"),Hl=o(),J=n("h1"),V=n("a"),fl=n("span"),c(se.$$.fragment),Qn=o(),Qt=n("span"),Qt.textContent=fs,El=o(),c(oe.$$.fragment),Xl=o(),ie=n("p"),ie.innerHTML=ys,Al=o(),T=n("h1"),N=n("a"),yl=n("span"),c(re.$$.fragment),Pn=o(),Pt=n("span"),Pt.textContent=Ms,Vl=o(),pe=n("img"),Nl=o(),he=n("p"),he.innerHTML=vs,Sl=o(),me=n("p"),me.textContent=gs,Rl=o(),ce=n("ul"),ce.innerHTML=Js,zl=o(),c(ue.$$.fragment),Ll=o(),de=n("p"),de.innerHTML=Ts,ql=o(),fe=n("ul"),fe.innerHTML=bs,Yl=o(),ye=n("p"),ye.innerHTML=js,Fl=o(),Me=n("p"),Me.innerHTML=Us,Ql=o(),we=n("p"),we.innerHTML=_s,Pl=o(),b=n("h2"),S=n("a"),Ml=n("span"),c(ve.$$.fragment),Dn=o(),Dt=n("span"),Dt.textContent=Zs,Dl=o(),ge=n("ul"),ge.innerHTML=Is,Kl=o(),Je=n("img"),Ol=o(),Te=n("ul"),Te.innerHTML=Cs,ea=o(),be=n("img"),ta=o(),je=n("p"),je.innerHTML=Gs,la=o(),j=n("h2"),R=n("a"),wl=n("span"),c(Ue.$$.fragment),Kn=o(),Kt=n("span"),Kt.textContent=Bs,aa=o(),_e=n("p"),_e.innerHTML=Ws,na=o(),Ze=n("p"),Ze.innerHTML=xs,sa=o(),Ie=n("img"),oa=o(),U=n("h3"),z=n("a"),vl=n("span"),c(ke.$$.fragment),On=o(),Ot=n("span"),Ot.textContent=Es,ia=o(),Ce=n("ul"),Ce.innerHTML=Xs,ra=o(),$e=n("p"),$e.innerHTML=As,pa=o(),_=n("h3"),L=n("a"),gl=n("span"),c(Ge.$$.fragment),es=o(),el=n("span"),el.textContent=Vs,ha=o(),Be=n("p"),Be.innerHTML=Ns,ma=o(),We=n("p"),We.innerHTML=Ss,ca=o(),xe=n("p"),xe.innerHTML=Rs,ua=o(),He=n("p"),He.innerHTML=zs,da=o(),Ee=n("p"),Ee.innerHTML=Ls,fa=o(),Xe=n("p"),Xe.innerHTML=qs,ya=o(),Ae=n("img"),Ma=o(),Z=n("h3"),q=n("a"),Jl=n("span"),c(Ve.$$.fragment),ts=o(),tl=n("span"),tl.textContent=Fs,wa=o(),Ne=n("p"),Ne.textContent=Qs,va=o(),Se=n("ul"),Se.innerHTML=Ps,ga=o(),Re=n("p"),Re.innerHTML=Ds,Ja=o(),I=n("h2"),Y=n("a"),Tl=n("span"),c(ze.$$.fragment),ls=o(),ll=n("span"),ll.textContent=Ks,Ta=o(),Le=n("p"),Le.innerHTML=Os,ba=o(),qe=n("p"),qe.textContent=eo,ja=o(),Ye=n("p"),Ye.innerHTML=to,Ua=o(),Fe=n("p"),Fe.textContent=lo,_a=o(),Qe=n("ul"),Qe.innerHTML=ao,Za=o(),k=n("h2"),F=n("a"),bl=n("span"),c(Pe.$$.fragment),as=o(),al=n("span"),al.textContent=no,Ia=o(),De=n("p"),De.textContent=so,ka=o(),Ke=n("p"),Ke.innerHTML=oo,Ca=o(),c(Oe.$$.fragment),$a=o(),C=n("h2"),Q=n("a"),jl=n("span"),c(et.$$.fragment),ns=o(),nl=n("span"),nl.textContent=io,Ga=o(),tt=n("ul"),tt.innerHTML=ro,Ba=o(),c(lt.$$.fragment),Wa=o(),$=n("h2"),P=n("a"),Ul=n("span"),c(at.$$.fragment),ss=o(),sl=n("span"),sl.textContent=po,xa=o(),c(nt.$$.fragment),Ha=o(),st=n("p"),st.innerHTML=ho,Ea=o(),G=n("h3"),D=n("a"),_l=n("span"),c(ot.$$.fragment),os=o(),ol=n("span"),ol.textContent=mo,Xa=o(),it=n("img"),Aa=o(),rt=n("p"),rt.innerHTML=uo,Va=o(),pt=n("p"),pt.innerHTML=fo,Na=o(),ht=n("p"),ht.textContent=yo,Sa=o(),mt=n("ul"),mt.innerHTML=Mo,Ra=o(),ct=n("p"),ct.innerHTML=wo,za=o(),ut=n("p"),ut.innerHTML=vo,La=o(),B=n("h2"),K=n("a"),Zl=n("span"),c(dt.$$.fragment),is=o(),il=n("span"),il.textContent=go,qa=o(),ft=n("ul"),ft.innerHTML=Jo,Ya=o(),c(yt.$$.fragment),Fa=o(),W=n("h2"),O=n("a"),Il=n("span"),c(Mt.$$.fragment),rs=o(),rl=n("span"),rl.textContent=To,Qa=o(),c(wt.$$.fragment),Pa=o(),x=n("h2"),ee=n("a"),kl=n("span"),c(vt.$$.fragment),ps=o(),pl=n("span"),pl.textContent=bo,Da=o(),c(gt.$$.fragment),Ka=o(),Jt=n("p"),Jt.textContent=jo,Oa=o(),H=n("h2"),te=n("a"),Cl=n("span"),c(Tt.$$.fragment),hs=o(),hl=n("span"),hl.textContent=Uo,en=o(),bt=n("p"),bt.textContent=_o,tn=o(),jt=n("p"),jt.innerHTML=Zo,ln=o(),Ut=n("p"),Ut.textContent=Io,an=o(),_t=n("ul"),_t.innerHTML=ko,nn=o(),Zt=n("img"),sn=o(),It=n("ul"),It.innerHTML=$o,on=o(),kt=n("p"),kt.innerHTML=Go,rn=o(),c(Ct.$$.fragment),pn=o(),c($t.$$.fragment),hn=o(),E=n("h2"),le=n("a"),$l=n("span"),c(Gt.$$.fragment),ms=o(),ml=n("span"),ml.textContent=Bo,mn=o(),Bt=n("p"),Bt.textContent=Wo,cn=o(),c(Wt.$$.fragment),un=o(),c(xt.$$.fragment),dn=o(),c(Ht.$$.fragment),fn=o(),c(Et.$$.fragment),yn=o(),X=n("h2"),ae=n("a"),Gl=n("span"),c(Xt.$$.fragment),cs=o(),cl=n("span"),cl.textContent=xo,Mn=o(),At=n("p"),At.innerHTML=Ho,wn=o(),Vt=n("p"),Vt.innerHTML=Eo,vn=o(),c(Nt.$$.fragment),gn=o(),St=n("p"),St.innerHTML=Xo,Jn=o(),c(Rt.$$.fragment),Tn=o(),zt=n("p"),zt.innerHTML=Ao,bn=o(),Lt=n("p"),Lt.innerHTML=Vo,jn=o(),Un=n("hr"),_n=o(),qt=n("p"),qt.innerHTML=No,Zn=o(),A=n("h2"),ne=n("a"),Bl=n("span"),c(Yt.$$.fragment),us=o(),ul=n("span"),ul.textContent=So,In=o(),Wl=n("p"),this.h()},l(e){const l=Gi("svelte-1phssyn",document.head);g=s(l,"META",{name:!0,content:!0}),l.forEach(t),xl=i(e),dl=s(e,"P",{}),m(dl).forEach(t),Hl=i(e),J=s(e,"H1",{class:!0});var Cn=m(J);V=s(Cn,"A",{id:!0,class:!0,href:!0});var Ro=m(V);fl=s(Ro,"SPAN",{});var zo=m(fl);u(se.$$.fragment,zo),zo.forEach(t),Ro.forEach(t),Qn=i(Cn),Qt=s(Cn,"SPAN",{"data-svelte-h":!0}),h(Qt)!=="svelte-u3gyyz"&&(Qt.textContent=fs),Cn.forEach(t),El=i(e),u(oe.$$.fragment,e),Xl=i(e),ie=s(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1rvwns4"&&(ie.innerHTML=ys),Al=i(e),T=s(e,"H1",{class:!0});var $n=m(T);N=s($n,"A",{id:!0,class:!0,href:!0});var Lo=m(N);yl=s(Lo,"SPAN",{});var qo=m(yl);u(re.$$.fragment,qo),qo.forEach(t),Lo.forEach(t),Pn=i($n),Pt=s($n,"SPAN",{"data-svelte-h":!0}),h(Pt)!=="svelte-wjwzlg"&&(Pt.textContent=Ms),$n.forEach(t),Vl=i(e),pe=s(e,"IMG",{src:!0,alt:!0}),Nl=i(e),he=s(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-1emi8cy"&&(he.innerHTML=vs),Sl=i(e),me=s(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1r1z9s5"&&(me.textContent=gs),Rl=i(e),ce=s(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-14d2rd7"&&(ce.innerHTML=Js),zl=i(e),u(ue.$$.fragment,e),Ll=i(e),de=s(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-1aajwkw"&&(de.innerHTML=Ts),ql=i(e),fe=s(e,"UL",{"data-svelte-h":!0}),h(fe)!=="svelte-17i4cff"&&(fe.innerHTML=bs),Yl=i(e),ye=s(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-lt0dbq"&&(ye.innerHTML=js),Fl=i(e),Me=s(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-19noeh0"&&(Me.innerHTML=Us),Ql=i(e),we=s(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1qkxyrx"&&(we.innerHTML=_s),Pl=i(e),b=s(e,"H2",{class:!0});var Gn=m(b);S=s(Gn,"A",{id:!0,class:!0,href:!0});var Yo=m(S);Ml=s(Yo,"SPAN",{});var Fo=m(Ml);u(ve.$$.fragment,Fo),Fo.forEach(t),Yo.forEach(t),Dn=i(Gn),Dt=s(Gn,"SPAN",{"data-svelte-h":!0}),h(Dt)!=="svelte-wdjh5x"&&(Dt.textContent=Zs),Gn.forEach(t),Dl=i(e),ge=s(e,"UL",{"data-svelte-h":!0}),h(ge)!=="svelte-1funvfi"&&(ge.innerHTML=Is),Kl=i(e),Je=s(e,"IMG",{src:!0,alt:!0}),Ol=i(e),Te=s(e,"UL",{"data-svelte-h":!0}),h(Te)!=="svelte-1cge6gn"&&(Te.innerHTML=Cs),ea=i(e),be=s(e,"IMG",{src:!0,alt:!0}),ta=i(e),je=s(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1s4z5f"&&(je.innerHTML=Gs),la=i(e),j=s(e,"H2",{class:!0});var Bn=m(j);R=s(Bn,"A",{id:!0,class:!0,href:!0});var Qo=m(R);wl=s(Qo,"SPAN",{});var Po=m(wl);u(Ue.$$.fragment,Po),Po.forEach(t),Qo.forEach(t),Kn=i(Bn),Kt=s(Bn,"SPAN",{"data-svelte-h":!0}),h(Kt)!=="svelte-110ijvx"&&(Kt.textContent=Bs),Bn.forEach(t),aa=i(e),_e=s(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-1x4am13"&&(_e.innerHTML=Ws),na=i(e),Ze=s(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-2jys3z"&&(Ze.innerHTML=xs),sa=i(e),Ie=s(e,"IMG",{src:!0,alt:!0}),oa=i(e),U=s(e,"H3",{class:!0});var Wn=m(U);z=s(Wn,"A",{id:!0,class:!0,href:!0});var Do=m(z);vl=s(Do,"SPAN",{});var Ko=m(vl);u(ke.$$.fragment,Ko),Ko.forEach(t),Do.forEach(t),On=i(Wn),Ot=s(Wn,"SPAN",{"data-svelte-h":!0}),h(Ot)!=="svelte-m7anyz"&&(Ot.textContent=Es),Wn.forEach(t),ia=i(e),Ce=s(e,"UL",{"data-svelte-h":!0}),h(Ce)!=="svelte-fckxaw"&&(Ce.innerHTML=Xs),ra=i(e),$e=s(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-10g6all"&&($e.innerHTML=As),pa=i(e),_=s(e,"H3",{class:!0});var xn=m(_);L=s(xn,"A",{id:!0,class:!0,href:!0});var Oo=m(L);gl=s(Oo,"SPAN",{});var ei=m(gl);u(Ge.$$.fragment,ei),ei.forEach(t),Oo.forEach(t),es=i(xn),el=s(xn,"SPAN",{"data-svelte-h":!0}),h(el)!=="svelte-qu7voa"&&(el.textContent=Vs),xn.forEach(t),ha=i(e),Be=s(e,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-1x9lpru"&&(Be.innerHTML=Ns),ma=i(e),We=s(e,"P",{"data-svelte-h":!0}),h(We)!=="svelte-1n6rwii"&&(We.innerHTML=Ss),ca=i(e),xe=s(e,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-15dyw52"&&(xe.innerHTML=Rs),ua=i(e),He=s(e,"P",{"data-svelte-h":!0}),h(He)!=="svelte-1smvsi5"&&(He.innerHTML=zs),da=i(e),Ee=s(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-hrlu55"&&(Ee.innerHTML=Ls),fa=i(e),Xe=s(e,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1j1f3jo"&&(Xe.innerHTML=qs),ya=i(e),Ae=s(e,"IMG",{src:!0,alt:!0}),Ma=i(e),Z=s(e,"H3",{class:!0});var Hn=m(Z);q=s(Hn,"A",{id:!0,class:!0,href:!0});var ti=m(q);Jl=s(ti,"SPAN",{});var li=m(Jl);u(Ve.$$.fragment,li),li.forEach(t),ti.forEach(t),ts=i(Hn),tl=s(Hn,"SPAN",{"data-svelte-h":!0}),h(tl)!=="svelte-1214ksk"&&(tl.textContent=Fs),Hn.forEach(t),wa=i(e),Ne=s(e,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-gd99jz"&&(Ne.textContent=Qs),va=i(e),Se=s(e,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-ct17ue"&&(Se.innerHTML=Ps),ga=i(e),Re=s(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-89bve0"&&(Re.innerHTML=Ds),Ja=i(e),I=s(e,"H2",{class:!0});var En=m(I);Y=s(En,"A",{id:!0,class:!0,href:!0});var ai=m(Y);Tl=s(ai,"SPAN",{});var ni=m(Tl);u(ze.$$.fragment,ni),ni.forEach(t),ai.forEach(t),ls=i(En),ll=s(En,"SPAN",{"data-svelte-h":!0}),h(ll)!=="svelte-1je149z"&&(ll.textContent=Ks),En.forEach(t),Ta=i(e),Le=s(e,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-60uig6"&&(Le.innerHTML=Os),ba=i(e),qe=s(e,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-wd45l7"&&(qe.textContent=eo),ja=i(e),Ye=s(e,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-7tc00l"&&(Ye.innerHTML=to),Ua=i(e),Fe=s(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-j6e0v0"&&(Fe.textContent=lo),_a=i(e),Qe=s(e,"UL",{"data-svelte-h":!0}),h(Qe)!=="svelte-120m9nl"&&(Qe.innerHTML=ao),Za=i(e),k=s(e,"H2",{class:!0});var Xn=m(k);F=s(Xn,"A",{id:!0,class:!0,href:!0});var si=m(F);bl=s(si,"SPAN",{});var oi=m(bl);u(Pe.$$.fragment,oi),oi.forEach(t),si.forEach(t),as=i(Xn),al=s(Xn,"SPAN",{"data-svelte-h":!0}),h(al)!=="svelte-1e1152h"&&(al.textContent=no),Xn.forEach(t),Ia=i(e),De=s(e,"P",{"data-svelte-h":!0}),h(De)!=="svelte-eon89t"&&(De.textContent=so),ka=i(e),Ke=s(e,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-bboubd"&&(Ke.innerHTML=oo),Ca=i(e),u(Oe.$$.fragment,e),$a=i(e),C=s(e,"H2",{class:!0});var An=m(C);Q=s(An,"A",{id:!0,class:!0,href:!0});var ii=m(Q);jl=s(ii,"SPAN",{});var ri=m(jl);u(et.$$.fragment,ri),ri.forEach(t),ii.forEach(t),ns=i(An),nl=s(An,"SPAN",{"data-svelte-h":!0}),h(nl)!=="svelte-uf667e"&&(nl.textContent=io),An.forEach(t),Ga=i(e),tt=s(e,"UL",{"data-svelte-h":!0}),h(tt)!=="svelte-1az788b"&&(tt.innerHTML=ro),Ba=i(e),u(lt.$$.fragment,e),Wa=i(e),$=s(e,"H2",{class:!0});var Vn=m($);P=s(Vn,"A",{id:!0,class:!0,href:!0});var pi=m(P);Ul=s(pi,"SPAN",{});var hi=m(Ul);u(at.$$.fragment,hi),hi.forEach(t),pi.forEach(t),ss=i(Vn),sl=s(Vn,"SPAN",{"data-svelte-h":!0}),h(sl)!=="svelte-1924end"&&(sl.textContent=po),Vn.forEach(t),xa=i(e),u(nt.$$.fragment,e),Ha=i(e),st=s(e,"P",{"data-svelte-h":!0}),h(st)!=="svelte-1f19xzu"&&(st.innerHTML=ho),Ea=i(e),G=s(e,"H3",{class:!0});var Nn=m(G);D=s(Nn,"A",{id:!0,class:!0,href:!0});var mi=m(D);_l=s(mi,"SPAN",{});var ci=m(_l);u(ot.$$.fragment,ci),ci.forEach(t),mi.forEach(t),os=i(Nn),ol=s(Nn,"SPAN",{"data-svelte-h":!0}),h(ol)!=="svelte-ofsxbq"&&(ol.textContent=mo),Nn.forEach(t),Xa=i(e),it=s(e,"IMG",{src:!0,alt:!0}),Aa=i(e),rt=s(e,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-1trz4y3"&&(rt.innerHTML=uo),Va=i(e),pt=s(e,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-1s302cc"&&(pt.innerHTML=fo),Na=i(e),ht=s(e,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-g7fw6"&&(ht.textContent=yo),Sa=i(e),mt=s(e,"UL",{"data-svelte-h":!0}),h(mt)!=="svelte-7pwo6w"&&(mt.innerHTML=Mo),Ra=i(e),ct=s(e,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-zzrzje"&&(ct.innerHTML=wo),za=i(e),ut=s(e,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-xo5xn7"&&(ut.innerHTML=vo),La=i(e),B=s(e,"H2",{class:!0});var Sn=m(B);K=s(Sn,"A",{id:!0,class:!0,href:!0});var ui=m(K);Zl=s(ui,"SPAN",{});var di=m(Zl);u(dt.$$.fragment,di),di.forEach(t),ui.forEach(t),is=i(Sn),il=s(Sn,"SPAN",{"data-svelte-h":!0}),h(il)!=="svelte-vwz5ap"&&(il.textContent=go),Sn.forEach(t),qa=i(e),ft=s(e,"UL",{"data-svelte-h":!0}),h(ft)!=="svelte-18mvbc9"&&(ft.innerHTML=Jo),Ya=i(e),u(yt.$$.fragment,e),Fa=i(e),W=s(e,"H2",{class:!0});var Rn=m(W);O=s(Rn,"A",{id:!0,class:!0,href:!0});var fi=m(O);Il=s(fi,"SPAN",{});var yi=m(Il);u(Mt.$$.fragment,yi),yi.forEach(t),fi.forEach(t),rs=i(Rn),rl=s(Rn,"SPAN",{"data-svelte-h":!0}),h(rl)!=="svelte-14ezo45"&&(rl.textContent=To),Rn.forEach(t),Qa=i(e),u(wt.$$.fragment,e),Pa=i(e),x=s(e,"H2",{class:!0});var zn=m(x);ee=s(zn,"A",{id:!0,class:!0,href:!0});var Mi=m(ee);kl=s(Mi,"SPAN",{});var wi=m(kl);u(vt.$$.fragment,wi),wi.forEach(t),Mi.forEach(t),ps=i(zn),pl=s(zn,"SPAN",{"data-svelte-h":!0}),h(pl)!=="svelte-mc1iub"&&(pl.textContent=bo),zn.forEach(t),Da=i(e),u(gt.$$.fragment,e),Ka=i(e),Jt=s(e,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-1fqobdf"&&(Jt.textContent=jo),Oa=i(e),H=s(e,"H2",{class:!0});var Ln=m(H);te=s(Ln,"A",{id:!0,class:!0,href:!0});var vi=m(te);Cl=s(vi,"SPAN",{});var gi=m(Cl);u(Tt.$$.fragment,gi),gi.forEach(t),vi.forEach(t),hs=i(Ln),hl=s(Ln,"SPAN",{"data-svelte-h":!0}),h(hl)!=="svelte-1ic7nuk"&&(hl.textContent=Uo),Ln.forEach(t),en=i(e),bt=s(e,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-6k9qpu"&&(bt.textContent=_o),tn=i(e),jt=s(e,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-932u9c"&&(jt.innerHTML=Zo),ln=i(e),Ut=s(e,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-adopwf"&&(Ut.textContent=Io),an=i(e),_t=s(e,"UL",{"data-svelte-h":!0}),h(_t)!=="svelte-19b5tev"&&(_t.innerHTML=ko),nn=i(e),Zt=s(e,"IMG",{src:!0,alt:!0}),sn=i(e),It=s(e,"UL",{"data-svelte-h":!0}),h(It)!=="svelte-mbo7r4"&&(It.innerHTML=$o),on=i(e),kt=s(e,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-1gq4mmb"&&(kt.innerHTML=Go),rn=i(e),u(Ct.$$.fragment,e),pn=i(e),u($t.$$.fragment,e),hn=i(e),E=s(e,"H2",{class:!0});var qn=m(E);le=s(qn,"A",{id:!0,class:!0,href:!0});var Ji=m(le);$l=s(Ji,"SPAN",{});var Ti=m($l);u(Gt.$$.fragment,Ti),Ti.forEach(t),Ji.forEach(t),ms=i(qn),ml=s(qn,"SPAN",{"data-svelte-h":!0}),h(ml)!=="svelte-yseges"&&(ml.textContent=Bo),qn.forEach(t),mn=i(e),Bt=s(e,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-10mw4u3"&&(Bt.textContent=Wo),cn=i(e),u(Wt.$$.fragment,e),un=i(e),u(xt.$$.fragment,e),dn=i(e),u(Ht.$$.fragment,e),fn=i(e),u(Et.$$.fragment,e),yn=i(e),X=s(e,"H2",{class:!0});var Yn=m(X);ae=s(Yn,"A",{id:!0,class:!0,href:!0});var bi=m(ae);Gl=s(bi,"SPAN",{});var ji=m(Gl);u(Xt.$$.fragment,ji),ji.forEach(t),bi.forEach(t),cs=i(Yn),cl=s(Yn,"SPAN",{"data-svelte-h":!0}),h(cl)!=="svelte-eoonta"&&(cl.textContent=xo),Yn.forEach(t),Mn=i(e),At=s(e,"P",{"data-svelte-h":!0}),h(At)!=="svelte-dn0c28"&&(At.innerHTML=Ho),wn=i(e),Vt=s(e,"P",{"data-svelte-h":!0}),h(Vt)!=="svelte-1pu1now"&&(Vt.innerHTML=Eo),vn=i(e),u(Nt.$$.fragment,e),gn=i(e),St=s(e,"P",{"data-svelte-h":!0}),h(St)!=="svelte-una3pz"&&(St.innerHTML=Xo),Jn=i(e),u(Rt.$$.fragment,e),Tn=i(e),zt=s(e,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-2fsgzg"&&(zt.innerHTML=Ao),bn=i(e),Lt=s(e,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-1sdymzl"&&(Lt.innerHTML=Vo),jn=i(e),Un=s(e,"HR",{}),_n=i(e),qt=s(e,"P",{"data-svelte-h":!0}),h(qt)!=="svelte-oaatl0"&&(qt.innerHTML=No),Zn=i(e),A=s(e,"H2",{class:!0});var Fn=m(A);ne=s(Fn,"A",{id:!0,class:!0,href:!0});var Ui=m(ne);Bl=s(Ui,"SPAN",{});var _i=m(Bl);u(Yt.$$.fragment,_i),_i.forEach(t),Ui.forEach(t),us=i(Fn),ul=s(Fn,"SPAN",{"data-svelte-h":!0}),h(ul)!=="svelte-i9a3z3"&&(ul.textContent=So),Fn.forEach(t),In=i(e),Wl=s(e,"P",{}),m(Wl).forEach(t),this.h()},h(){r(g,"name","hf:doc:metadata"),r(g,"content",JSON.stringify(xi)),r(V,"id","handson-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels"),r(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(V,"href","#handson-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels"),r(J,"class","relative group"),r(N,"id","unit-8-part-2-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels"),r(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(N,"href","#unit-8-part-2-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels"),r(T,"class","relative group"),Ft(pe.src,ws="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/thumbnail2.png")||r(pe,"src",ws),r(pe,"alt","Thumbnail"),r(S,"id","set-the-gpu"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#set-the-gpu"),r(b,"class","relative group"),Ft(Je.src,ks="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||r(Je,"src",ks),r(Je,"alt","GPU Step 1"),Ft(be.src,$s="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||r(be,"src",$s),r(be,"alt","GPU Step 2"),r(R,"id","sample-factory"),r(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(R,"href","#sample-factory"),r(j,"class","relative group"),Ft(Ie.src,Hs="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactoryenvs.png")||r(Ie,"src",Hs),r(Ie,"alt","Sample factory"),r(z,"id","key-features"),r(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(z,"href","#key-features"),r(U,"class","relative group"),r(L,"id","how-samplefactory-works"),r(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(L,"href","#how-samplefactory-works"),r(_,"class","relative group"),Ft(Ae.src,Ys="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactory.png")||r(Ae,"src",Ys),r(Ae,"alt","Sample factory"),r(q,"id","actor-critic-models-in-samplefactory"),r(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(q,"href","#actor-critic-models-in-samplefactory"),r(Z,"class","relative group"),r(Y,"id","vizdoom"),r(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Y,"href","#vizdoom"),r(I,"class","relative group"),r(F,"id","we-first-need-to-install-some-dependencies-that-are-required-for-the-vizdoom-environment"),r(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(F,"href","#we-first-need-to-install-some-dependencies-that-are-required-for-the-vizdoom-environment"),r(k,"class","relative group"),r(Q,"id","then-we-can-install-sample-factory-and-vizdoom"),r(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Q,"href","#then-we-can-install-sample-factory-and-vizdoom"),r(C,"class","relative group"),r(P,"id","setting-up-the-doom-environment-in-samplefactory"),r(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(P,"href","#setting-up-the-doom-environment-in-samplefactory"),r($,"class","relative group"),r(D,"id","the-scenario-health-gathering-supreme"),r(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(D,"href","#the-scenario-health-gathering-supreme"),r(G,"class","relative group"),Ft(it.src,co="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/Health-Gathering-Supreme.png")||r(it,"src",co),r(it,"alt","Health-Gathering-Supreme"),r(K,"id","training-the-agent"),r(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(K,"href","#training-the-agent"),r(B,"class","relative group"),r(O,"id","lets-take-a-look-at-the-performance-of-the-trained-policy-and-output-a-video-of-the-agent"),r(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(O,"href","#lets-take-a-look-at-the-performance-of-the-trained-policy-and-output-a-video-of-the-agent"),r(W,"class","relative group"),r(ee,"id","now-lets-visualize-the-performance-of-the-agent"),r(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ee,"href","#now-lets-visualize-the-performance-of-the-agent"),r(x,"class","relative group"),r(te,"id","now-lets-upload-your-checkpoint-and-video-to-the-hugging-face-hub"),r(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(te,"href","#now-lets-upload-your-checkpoint-and-video-to-the-hugging-face-hub"),r(H,"class","relative group"),Ft(Zt.src,Co="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||r(Zt,"src",Co),r(Zt,"alt","Create HF Token"),r(le,"id","lets-load-another-model"),r(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(le,"href","#lets-load-another-model"),r(E,"class","relative group"),r(ae,"id","some-additional-challenges-doom-deathmatch"),r(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ae,"href","#some-additional-challenges-doom-deathmatch"),r(X,"class","relative group"),r(ne,"id","keep-learning-stay-awesome"),r(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ne,"href","#keep-learning-stay-awesome"),r(A,"class","relative group")},m(e,l){p(document.head,g),a(e,xl,l),a(e,dl,l),a(e,Hl,l),a(e,J,l),p(J,V),p(V,fl),d(se,fl,null),p(J,Qn),p(J,Qt),a(e,El,l),d(oe,e,l),a(e,Xl,l),a(e,ie,l),a(e,Al,l),a(e,T,l),p(T,N),p(N,yl),d(re,yl,null),p(T,Pn),p(T,Pt),a(e,Vl,l),a(e,pe,l),a(e,Nl,l),a(e,he,l),a(e,Sl,l),a(e,me,l),a(e,Rl,l),a(e,ce,l),a(e,zl,l),d(ue,e,l),a(e,Ll,l),a(e,de,l),a(e,ql,l),a(e,fe,l),a(e,Yl,l),a(e,ye,l),a(e,Fl,l),a(e,Me,l),a(e,Ql,l),a(e,we,l),a(e,Pl,l),a(e,b,l),p(b,S),p(S,Ml),d(ve,Ml,null),p(b,Dn),p(b,Dt),a(e,Dl,l),a(e,ge,l),a(e,Kl,l),a(e,Je,l),a(e,Ol,l),a(e,Te,l),a(e,ea,l),a(e,be,l),a(e,ta,l),a(e,je,l),a(e,la,l),a(e,j,l),p(j,R),p(R,wl),d(Ue,wl,null),p(j,Kn),p(j,Kt),a(e,aa,l),a(e,_e,l),a(e,na,l),a(e,Ze,l),a(e,sa,l),a(e,Ie,l),a(e,oa,l),a(e,U,l),p(U,z),p(z,vl),d(ke,vl,null),p(U,On),p(U,Ot),a(e,ia,l),a(e,Ce,l),a(e,ra,l),a(e,$e,l),a(e,pa,l),a(e,_,l),p(_,L),p(L,gl),d(Ge,gl,null),p(_,es),p(_,el),a(e,ha,l),a(e,Be,l),a(e,ma,l),a(e,We,l),a(e,ca,l),a(e,xe,l),a(e,ua,l),a(e,He,l),a(e,da,l),a(e,Ee,l),a(e,fa,l),a(e,Xe,l),a(e,ya,l),a(e,Ae,l),a(e,Ma,l),a(e,Z,l),p(Z,q),p(q,Jl),d(Ve,Jl,null),p(Z,ts),p(Z,tl),a(e,wa,l),a(e,Ne,l),a(e,va,l),a(e,Se,l),a(e,ga,l),a(e,Re,l),a(e,Ja,l),a(e,I,l),p(I,Y),p(Y,Tl),d(ze,Tl,null),p(I,ls),p(I,ll),a(e,Ta,l),a(e,Le,l),a(e,ba,l),a(e,qe,l),a(e,ja,l),a(e,Ye,l),a(e,Ua,l),a(e,Fe,l),a(e,_a,l),a(e,Qe,l),a(e,Za,l),a(e,k,l),p(k,F),p(F,bl),d(Pe,bl,null),p(k,as),p(k,al),a(e,Ia,l),a(e,De,l),a(e,ka,l),a(e,Ke,l),a(e,Ca,l),d(Oe,e,l),a(e,$a,l),a(e,C,l),p(C,Q),p(Q,jl),d(et,jl,null),p(C,ns),p(C,nl),a(e,Ga,l),a(e,tt,l),a(e,Ba,l),d(lt,e,l),a(e,Wa,l),a(e,$,l),p($,P),p(P,Ul),d(at,Ul,null),p($,ss),p($,sl),a(e,xa,l),d(nt,e,l),a(e,Ha,l),a(e,st,l),a(e,Ea,l),a(e,G,l),p(G,D),p(D,_l),d(ot,_l,null),p(G,os),p(G,ol),a(e,Xa,l),a(e,it,l),a(e,Aa,l),a(e,rt,l),a(e,Va,l),a(e,pt,l),a(e,Na,l),a(e,ht,l),a(e,Sa,l),a(e,mt,l),a(e,Ra,l),a(e,ct,l),a(e,za,l),a(e,ut,l),a(e,La,l),a(e,B,l),p(B,K),p(K,Zl),d(dt,Zl,null),p(B,is),p(B,il),a(e,qa,l),a(e,ft,l),a(e,Ya,l),d(yt,e,l),a(e,Fa,l),a(e,W,l),p(W,O),p(O,Il),d(Mt,Il,null),p(W,rs),p(W,rl),a(e,Qa,l),d(wt,e,l),a(e,Pa,l),a(e,x,l),p(x,ee),p(ee,kl),d(vt,kl,null),p(x,ps),p(x,pl),a(e,Da,l),d(gt,e,l),a(e,Ka,l),a(e,Jt,l),a(e,Oa,l),a(e,H,l),p(H,te),p(te,Cl),d(Tt,Cl,null),p(H,hs),p(H,hl),a(e,en,l),a(e,bt,l),a(e,tn,l),a(e,jt,l),a(e,ln,l),a(e,Ut,l),a(e,an,l),a(e,_t,l),a(e,nn,l),a(e,Zt,l),a(e,sn,l),a(e,It,l),a(e,on,l),a(e,kt,l),a(e,rn,l),d(Ct,e,l),a(e,pn,l),d($t,e,l),a(e,hn,l),a(e,E,l),p(E,le),p(le,$l),d(Gt,$l,null),p(E,ms),p(E,ml),a(e,mn,l),a(e,Bt,l),a(e,cn,l),d(Wt,e,l),a(e,un,l),d(xt,e,l),a(e,dn,l),d(Ht,e,l),a(e,fn,l),d(Et,e,l),a(e,yn,l),a(e,X,l),p(X,ae),p(ae,Gl),d(Xt,Gl,null),p(X,cs),p(X,cl),a(e,Mn,l),a(e,At,l),a(e,wn,l),a(e,Vt,l),a(e,vn,l),d(Nt,e,l),a(e,gn,l),a(e,St,l),a(e,Jn,l),d(Rt,e,l),a(e,Tn,l),a(e,zt,l),a(e,bn,l),a(e,Lt,l),a(e,jn,l),a(e,Un,l),a(e,_n,l),a(e,qt,l),a(e,Zn,l),a(e,A,l),p(A,ne),p(ne,Bl),d(Yt,Bl,null),p(A,us),p(A,ul),a(e,In,l),a(e,Wl,l),kn=!0},p:Ii,i(e){kn||(f(se.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ue.$$.fragment,e),f(ve.$$.fragment,e),f(Ue.$$.fragment,e),f(ke.$$.fragment,e),f(Ge.$$.fragment,e),f(Ve.$$.fragment,e),f(ze.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(lt.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(dt.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(gt.$$.fragment,e),f(Tt.$$.fragment,e),f(Ct.$$.fragment,e),f($t.$$.fragment,e),f(Gt.$$.fragment,e),f(Wt.$$.fragment,e),f(xt.$$.fragment,e),f(Ht.$$.fragment,e),f(Et.$$.fragment,e),f(Xt.$$.fragment,e),f(Nt.$$.fragment,e),f(Rt.$$.fragment,e),f(Yt.$$.fragment,e),kn=!0)},o(e){y(se.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(ve.$$.fragment,e),y(Ue.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(Ve.$$.fragment,e),y(ze.$$.fragment,e),y(Pe.$$.fragment,e),y(Oe.$$.fragment,e),y(et.$$.fragment,e),y(lt.$$.fragment,e),y(at.$$.fragment,e),y(nt.$$.fragment,e),y(ot.$$.fragment,e),y(dt.$$.fragment,e),y(yt.$$.fragment,e),y(Mt.$$.fragment,e),y(wt.$$.fragment,e),y(vt.$$.fragment,e),y(gt.$$.fragment,e),y(Tt.$$.fragment,e),y(Ct.$$.fragment,e),y($t.$$.fragment,e),y(Gt.$$.fragment,e),y(Wt.$$.fragment,e),y(xt.$$.fragment,e),y(Ht.$$.fragment,e),y(Et.$$.fragment,e),y(Xt.$$.fragment,e),y(Nt.$$.fragment,e),y(Rt.$$.fragment,e),y(Yt.$$.fragment,e),kn=!1},d(e){e&&(t(xl),t(dl),t(Hl),t(J),t(El),t(Xl),t(ie),t(Al),t(T),t(Vl),t(pe),t(Nl),t(he),t(Sl),t(me),t(Rl),t(ce),t(zl),t(Ll),t(de),t(ql),t(fe),t(Yl),t(ye),t(Fl),t(Me),t(Ql),t(we),t(Pl),t(b),t(Dl),t(ge),t(Kl),t(Je),t(Ol),t(Te),t(ea),t(be),t(ta),t(je),t(la),t(j),t(aa),t(_e),t(na),t(Ze),t(sa),t(Ie),t(oa),t(U),t(ia),t(Ce),t(ra),t($e),t(pa),t(_),t(ha),t(Be),t(ma),t(We),t(ca),t(xe),t(ua),t(He),t(da),t(Ee),t(fa),t(Xe),t(ya),t(Ae),t(Ma),t(Z),t(wa),t(Ne),t(va),t(Se),t(ga),t(Re),t(Ja),t(I),t(Ta),t(Le),t(ba),t(qe),t(ja),t(Ye),t(Ua),t(Fe),t(_a),t(Qe),t(Za),t(k),t(Ia),t(De),t(ka),t(Ke),t(Ca),t($a),t(C),t(Ga),t(tt),t(Ba),t(Wa),t($),t(xa),t(Ha),t(st),t(Ea),t(G),t(Xa),t(it),t(Aa),t(rt),t(Va),t(pt),t(Na),t(ht),t(Sa),t(mt),t(Ra),t(ct),t(za),t(ut),t(La),t(B),t(qa),t(ft),t(Ya),t(Fa),t(W),t(Qa),t(Pa),t(x),t(Da),t(Ka),t(Jt),t(Oa),t(H),t(en),t(bt),t(tn),t(jt),t(ln),t(Ut),t(an),t(_t),t(nn),t(Zt),t(sn),t(It),t(on),t(kt),t(rn),t(pn),t(hn),t(E),t(mn),t(Bt),t(cn),t(un),t(dn),t(fn),t(yn),t(X),t(Mn),t(At),t(wn),t(Vt),t(vn),t(gn),t(St),t(Jn),t(Tn),t(zt),t(bn),t(Lt),t(jn),t(Un),t(_n),t(qt),t(Zn),t(A),t(In),t(Wl)),t(g),M(se),M(oe,e),M(re),M(ue,e),M(ve),M(Ue),M(ke),M(Ge),M(Ve),M(ze),M(Pe),M(Oe,e),M(et),M(lt,e),M(at),M(nt,e),M(ot),M(dt),M(yt,e),M(Mt),M(wt,e),M(vt),M(gt,e),M(Tt),M(Ct,e),M($t,e),M(Gt),M(Wt,e),M(xt,e),M(Ht,e),M(Et,e),M(Xt),M(Nt,e),M(Rt,e),M(Yt)}}}const xi={local:"unit-8-part-2-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels",sections:[{local:"set-the-gpu",title:"Set the GPU 💪"},{local:"sample-factory",sections:[{local:"key-features",title:"Key features"},{local:"how-samplefactory-works",title:"How sample-factory works"},{local:"actor-critic-models-in-samplefactory",title:"Actor Critic models in Sample-factory"}],title:"Sample Factory"},{local:"vizdoom",title:"ViZDoom"},{local:"we-first-need-to-install-some-dependencies-that-are-required-for-the-vizdoom-environment",title:"We first need to install some dependencies that are required for the ViZDoom environment"},{local:"then-we-can-install-sample-factory-and-vizdoom",title:"Then we can install Sample Factory and ViZDoom"},{local:"setting-up-the-doom-environment-in-samplefactory",sections:[{local:"the-scenario-health-gathering-supreme",title:"The scenario: Health Gathering Supreme"}],title:"Setting up the Doom Environment in sample-factory"},{local:"training-the-agent",title:"Training the agent"},{local:"lets-take-a-look-at-the-performance-of-the-trained-policy-and-output-a-video-of-the-agent",title:"Let's take a look at the performance of the trained policy and output a video of the agent."},{local:"now-lets-visualize-the-performance-of-the-agent",title:"Now lets visualize the performance of the agent"},{local:"now-lets-upload-your-checkpoint-and-video-to-the-hugging-face-hub",title:"Now lets upload your checkpoint and video to the Hugging Face Hub"},{local:"lets-load-another-model",title:"Let's load another model"},{local:"some-additional-challenges-doom-deathmatch",title:"Some additional challenges 🏆: Doom Deathmatch"},{local:"keep-learning-stay-awesome",title:"Keep learning, stay awesome 🤗"}],title:"Unit 8 Part 2: Advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels"};function Hi(ds){return ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Si extends Ci{constructor(g){super(),$i(this,g,Hi,Wi,Zi,{})}}export{Si as component};
