import{s as Ln,f as Ae,n as Wn,o as Xn}from"../chunks/scheduler.37c15a92.js";import{S as Hn,i as $n,g as s,s as a,u,A as Nn,h as o,f as t,c as i,j as c,v as d,y as h,k as r,o as p,a as n,w as m,d as g,t as f,x as M}from"../chunks/index.b01106c0.js";import{I as E}from"../chunks/IconCopyLink.77b762b4.js";import{C as ml}from"../chunks/CodeBlock.00a4ae02.js";function Qn(jl){let w,lt,Ye,nt,v,_,Fe,R,gl,Le,Ul="Godot RL Agents",st,A,Jl='<a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">Godot RL Agents</a> is an Open Source package that allows video game creators, AI researchers, and hobbyists the opportunity <strong>to learn complex behaviors for their Non Player Characters or agents</strong>.',ot,L,xl="The library provides:",at,W,_l='<li>An interface between games created in the <a href="https://godotengine.org/" rel="nofollow">Godot Engine</a> and Machine Learning algorithms running in Python</li> <li>Wrappers for four well known rl frameworks: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">StableBaselines3</a>, <a href="https://docs.cleanrl.dev/" rel="nofollow">CleanRL</a>, <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> and <a href="https://docs.ray.io/en/latest/rllib-algorithms.html" rel="nofollow">Ray RLLib</a></li> <li>Support for memory-based agents with LSTM or attention based interfaces</li> <li>Support for <em>2D and 3D games</em></li> <li>A suite of <em>AI sensors</em> to augment your agent’s capacity to observe the game world</li> <li>Godot and Godot RL Agents are <strong>completely free and open source under a very permissive MIT license</strong>. No strings attached, no royalties, nothing.</li>',it,X,Cl='You can find out more about Godot RL agents on their <a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">GitHub page</a> or their AAAI-2022 Workshop <a href="https://arxiv.org/abs/2112.03636" rel="nofollow">paper</a>. The library’s creator, <a href="https://edbeeching.github.io/" rel="nofollow">Ed Beeching</a>, is a Research Scientist here at Hugging Face.',rt,H,Gl="Installation of the library is simple: <code>pip install godot-rl</code>",ht,y,C,Pe,$,fl,We,kl="Create a custom RL environment with Godot RL Agents",pt,N,Sl="In this section, you will <strong>learn how to create a custom environment in the Godot Game Engine</strong> and then implement an AI controller that learns to play with Deep Reinforcement Learning.",ct,Q,Zl="The example game we create today is simple, <strong>but shows off many of the features of the Godot Engine and the Godot RL Agents library</strong>. You can then dive into the examples for more complex environments and behaviors.",ut,z,Il="The environment we will be building today is called Ring Pong, the game of pong but the pitch is a ring and the paddle moves around the ring. The <strong>objective is to keep the ball bouncing inside the ring</strong>.",dt,Y,Bl,mt,b,G,qe,F,Ml,Xe,El="Installing the Godot Game Engine",gt,P,Rl='The <a href="https://godotengine.org/" rel="nofollow">Godot game engine</a> is an open source tool for the <strong>creation of video games, tools and user interfaces</strong>.',ft,q,Al="Godot Engine is a feature-packed, cross-platform game engine designed to create 2D and 3D games from a unified interface. It provides a comprehensive set of common tools, so users <strong>can focus on making games without having to reinvent the wheel</strong>. Games can be exported in one click to a number of platforms, including the major desktop platforms (Linux, macOS, Windows) as well as mobile (Android, iOS) and web-based (HTML5) platforms.",Mt,V,Ll='While we will guide you through the steps to implement your agent, you may wish to learn more about the Godot Game Engine. Their <a href="https://docs.godotengine.org/en/latest/index.html" rel="nofollow">documentation</a> is thorough, and there are many tutorials on YouTube we would also recommend <a href="https://www.gdquest.com/" rel="nofollow">GDQuest</a>, <a href="https://kidscancode.org/godot_recipes/4.x/" rel="nofollow">KidsCanCode</a> and <a href="https://www.youtube.com/channel/UCczi7Aq_dTKrQPF5ZV5J3gg" rel="nofollow">Bramwell</a> as sources of information.',wt,D,Wl="In order to create games in Godot, <strong>you must first download the editor</strong>. Godot RL Agents supports the latest version of Godot, Godot 4.0.",vt,O,Xl="Which can be downloaded at the following links:",yt,K,Hl='<li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_win64.exe.zip" rel="nofollow">Windows</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_macos.universal.zip" rel="nofollow">Mac</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_linux.x86_64.zip" rel="nofollow">Linux</a></li>',bt,T,k,Ve,ee,wl,He,$l="Loading the starter project",Tt,te,Nl="We provide two versions of the codebase:",jt,le,Ql='<li><a href="https://drive.google.com/file/d/1C7xd3TibJHlxFEJPBgBLpksgxrFZ3D8e/view?usp=share_link" rel="nofollow">A starter project, to download and follow along for this tutorial</a></li> <li><a href="https://drive.google.com/file/d/1k-b2Bu7uIA6poApbouX4c3sq98xqogpZ/view?usp=share_link" rel="nofollow">A final version of the project, for comparison and debugging.</a></li>',Ut,ne,zl="To load the project, in the Godot Project Manager click <strong>Import</strong>, navigate to where the files are located and load the <strong>project.godot</strong> file.",Jt,se,Yl="If you press F5 or play in the editor, you should be able to play the game in human mode. There are several instances of the game running, this is because we want to speed up training our AI agent with many parallel environments.",xt,j,S,De,oe,vl,$e,Fl="Installing the Godot RL Agents plugin",_t,ae,Pl="The Godot RL Agents plugin can be installed from the Github repo or with the Godot Asset Lib in the editor.",Ct,ie,ql="First click on the AssetLib and search for “rl”",Gt,re,Vl,kt,he,Dl='Then click on Godot RL Agents, click Download and unselect the LICIENSE and <a href="http://README.md" rel="nofollow">README.md</a> files. Then click install.',St,pe,Ol,Zt,ce,Kl="The Godot RL Agents plugin is now downloaded to your machine your machine. Now click on Project → Project settings and enable the addon:",It,ue,en,Bt,U,Z,Oe,de,yl,Ne,tn="Adding the AI controller",Et,me,ln="We now want to add an AI controller to our game. Open the player.tscn scene, on the left you should see a hierarchy of nodes that looks like this:",Rt,ge,nn,At,fe,sn="Right click the <strong>Player</strong> node and click <strong>Add Child Node.</strong> There are many nodes listed here, search for AIController3D and create it.",Lt,Me,on,Wt,we,an="The AI Controller Node should have been added to the scene tree, next to it is a scroll. Click on it to open the script that is attached to the AIController. The Godot game engine uses a scripting language called GDScript, which is syntactically similar to python. The script contains methods that need to be implemented in order to get our AI controller working.",Xt,ve,Ht,ye,rn="In order to implement these methods, we will need to create a class that inherits from AIController3D. This is easy to do in Godot, and is called “extending” a class.",$t,be,hn="Right click the AIController3D Node and click “Extend Script” and call the new script <code>controller.gd</code>. You should now have an almost empty script file that looks like this:",Nt,Te,Qt,je,pn="We will now implement the 4 missing methods, delete this code, and replace it with the following:",zt,Ue,Yt,Je,cn="We have now defined the agent’s observation, which is the position and velocity of the ball in its local cooridinate space. We have also defined the action space of the agent, which is a single contuninous value ranging from -1 to +1.",Ft,xe,un="The next step is to update the Player’s script to use the actions from the AIController, edit the Player’s script by clicking on the scroll next to the player node, update the code in <code>Player.gd</code> to the following the following:",Pt,_e,qt,Ce,dn="We now need to synchronize between the game running in Godot and the neural network being trained in Python. Godot RL agents provides a node that does just that. Open the train.tscn scene, right click on the root node, and click “Add child node”. Then, search for “sync” and add a Godot RL Agents Sync node. This node handles the communication between Python and Godot over TCP.",Vt,Ge,mn="You can run training live in the the editor, by first launching the python training with <code>gdrl</code>",Dt,ke,gn="In this simple example, a reasonable policy is learned in several minutes. You may wish to speed up training, click on the Sync node in the train scene and you will see there is a “Speed Up” property exposed in the editor:",Ot,Se,fn,Kt,Ze,Mn="Try setting this property up to 8 to speed up training. This can be a great benefit on more complex environments, like the multi-player FPS we will learn about in the next chapter.",el,J,I,Ke,Ie,bl,Qe,wn="There’s more!",tl,Be,vn='We have only scratched the surface of what can be achieved with Godot RL Agents, the library includes custom sensors and cameras to enrich the information available to the agent. Take a look at the <a href="https://github.com/edbeeching/godot_rl_agents_examples" rel="nofollow">examples</a> to find out more!',ll,x,B,et,Ee,Tl,ze,yn="Author",nl,Re,bn='This section was written by <a href="https://twitter.com/edwardbeeching">Edward Beeching</a>',sl,tt,ol;return R=new E({}),$=new E({}),F=new E({}),ee=new E({}),oe=new E({}),de=new E({}),ve=new ml({props:{code:"JTIzLS0lMjBNZXRob2RzJTIwdGhhdCUyMG5lZWQlMjBpbXBsZW1lbnRpbmclMjB1c2luZyUyMHRoZSUyMCUyMmV4dGVuZCUyMHNjcmlwdCUyMiUyMG9wdGlvbiUyMGluJTIwR29kb3QlMjAtLSUyMyUwQWZ1bmMlMjBnZXRfb2JzKCklMjAtJTNFJTIwRGljdGlvbmFyeSUzQSUwQSUwOWFzc2VydChmYWxzZSUyQyUyMCUyMnRoZSUyMGdldF9vYnMlMjBtZXRob2QlMjBpcyUyMG5vdCUyMGltcGxlbWVudGVkJTIwd2hlbiUyMGV4dGVuZGluZyUyMGZyb20lMjBhaV9jb250cm9sbGVyJTIyKSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQSU1QiU1RCU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXRfcmV3YXJkJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAwLjAlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBnZXRfYWN0aW9uX3NwYWNlJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfY29udGlub3VzJTIyJTIwJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTIyc2l6ZSUyMiUzQSUyMDIlMkMlMEElMDklMDklMDklMjJhY3Rpb25fdHlwZSUyMiUzQSUyMCUyMmNvbnRpbnVvdXMlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfZGlzY3JldGUlMjIlMjAlM0ElMjAlN0IlMEElMDklMDklMDklMjJzaXplJTIyJTNBJTIwMiUyQyUwQSUwOSUwOSUwOSUyMmFjdGlvbl90eXBlJTIyJTNBJTIwJTIyZGlzY3JldGUlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklN0QlMEElMEFmdW5jJTIwc2V0X2FjdGlvbihhY3Rpb24pJTIwLSUzRSUyMHZvaWQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBzZXRfYWN0aW9uJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMjMlMjAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMw==",highlighted:`<span class="hljs-comment">#-- Methods that need implementing using the &quot;extend script&quot; option in Godot --#</span>
func get_obs() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_obs method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:[]}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_reward method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> <span class="hljs-number">0.0</span>

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get get_action_space method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;example_actions_continous&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		<span class="hljs-string">&quot;example_actions_discrete&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;discrete&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get set_action method is not implemented when extending from ai_controller&quot;</span>)
<span class="hljs-comment"># -----------------------------------------------------------------------------#</span>`,wrap:!1}}),Te=new ml({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwQ2FsbGVkJTIwd2hlbiUyMHRoZSUyMG5vZGUlMjBlbnRlcnMlMjB0aGUlMjBzY2VuZSUyMHRyZWUlMjBmb3IlMjB0aGUlMjBmaXJzdCUyMHRpbWUuJTBBZnVuYyUyMF9yZWFkeSgpJTNBJTBBJTA5cGFzcyUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIwZnVuY3Rpb24lMjBib2R5LiUwQSUwQSUyMyUyMENhbGxlZCUyMGV2ZXJ5JTIwZnJhbWUuJTIwJ2RlbHRhJyUyMGlzJTIwdGhlJTIwZWxhcHNlZCUyMHRpbWUlMjBzaW5jZSUyMHRoZSUyMHByZXZpb3VzJTIwZnJhbWUuJTBBZnVuYyUyMF9wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOXBhc3M=",highlighted:`extends AIController3D

<span class="hljs-comment"># Called when the node enters the scene tree for the first time.</span>
func _ready():
	<span class="hljs-keyword">pass</span> <span class="hljs-comment"># Replace with function body.</span>

<span class="hljs-comment"># Called every frame. &#x27;delta&#x27; is the elapsed time since the previous frame.</span>
func _process(delta):
	<span class="hljs-keyword">pass</span>`,wrap:!1}}),Ue=new ml({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwU3RvcmVzJTIwdGhlJTIwYWN0aW9uJTIwc2FtcGxlZCUyMGZvciUyMHRoZSUyMGFnZW50J3MlMjBwb2xpY3klMkMlMjBydW5uaW5nJTIwaW4lMjBweXRob24lMEF2YXIlMjBtb3ZlX2FjdGlvbiUyMCUzQSUyMGZsb2F0JTIwJTNEJTIwMC4wJTBBJTBBZnVuYyUyMGdldF9vYnMoKSUyMC0lM0UlMjBEaWN0aW9uYXJ5JTNBJTBBJTA5JTIzJTIwZ2V0JTIwdGhlJTIwYmFsbHMlMjBwb3NpdGlvbiUyMGFuZCUyMHZlbG9jaXR5JTIwaW4lMjB0aGUlMjBwYWRkbGUncyUyMGZyYW1lJTIwb2YlMjByZWZlcmVuY2UlMEElMDl2YXIlMjBiYWxsX3BvcyUyMCUzRCUyMHRvX2xvY2FsKF9wbGF5ZXIuYmFsbC5nbG9iYWxfcG9zaXRpb24pJTBBJTA5dmFyJTIwYmFsbF92ZWwlMjAlM0QlMjB0b19sb2NhbChfcGxheWVyLmJhbGwubGluZWFyX3ZlbG9jaXR5KSUwQSUwOXZhciUyMG9icyUyMCUzRCUyMCU1QmJhbGxfcG9zLnglMkMlMjBiYWxsX3Bvcy56JTJDJTIwYmFsbF92ZWwueCUyRjEwLjAlMkMlMjBiYWxsX3ZlbC56JTJGMTAuMCU1RCUwQSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQW9icyU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlyZXR1cm4lMjByZXdhcmQlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJtb3ZlX2FjdGlvbiUyMiUyMCUzQSUyMCU3QiUwQSUwOSUwOSUwOSUyMnNpemUlMjIlM0ElMjAxJTJDJTBBJTA5JTA5JTA5JTIyYWN0aW9uX3R5cGUlMjIlM0ElMjAlMjJjb250aW51b3VzJTIyJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTA5JTdEJTBBJTBBZnVuYyUyMHNldF9hY3Rpb24oYWN0aW9uKSUyMC0lM0UlMjB2b2lkJTNBJTBBJTA5bW92ZV9hY3Rpb24lMjAlM0QlMjBjbGFtcChhY3Rpb24lNUIlMjJtb3ZlX2FjdGlvbiUyMiU1RCU1QjAlNUQlMkMlMjAtMS4wJTJDJTIwMS4wKQ==",highlighted:`extends AIController3D

<span class="hljs-comment"># Stores the action sampled for the agent&#x27;s policy, running in python</span>
var move_action : <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

func get_obs() -&gt; Dictionary:
	<span class="hljs-comment"># get the balls position and velocity in the paddle&#x27;s frame of reference</span>
	var ball_pos = to_local(_player.ball.global_position)
	var ball_vel = to_local(_player.ball.linear_velocity)
	var obs = [ball_pos.x, ball_pos.z, ball_vel.x/<span class="hljs-number">10.0</span>, ball_vel.z/<span class="hljs-number">10.0</span>]

	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:obs}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;move_action&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	move_action = clamp(action[<span class="hljs-string">&quot;move_action&quot;</span>][<span class="hljs-number">0</span>], -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),_e=new ml({props:{code:"ZXh0ZW5kcyUyME5vZGUzRCUwQSUwQSU0MGV4cG9ydCUyMHZhciUyMHJvdGF0aW9uX3NwZWVkJTIwJTNEJTIwMy4wJTBBJTQwb25yZWFkeSUyMHZhciUyMGJhbGwlMjAlM0QlMjBnZXRfbm9kZSglMjIuLiUyRkJhbGwlMjIpJTBBJTQwb25yZWFkeSUyMHZhciUyMGFpX2NvbnRyb2xsZXIlMjAlM0QlMjAlMjRBSUNvbnRyb2xsZXIzRCUwQSUwQWZ1bmMlMjBfcmVhZHkoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuaW5pdChzZWxmKSUwQSUwQWZ1bmMlMjBnYW1lX292ZXIoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuZG9uZSUyMCUzRCUyMHRydWUlMEElMDlhaV9jb250cm9sbGVyLm5lZWRzX3Jlc2V0JTIwJTNEJTIwdHJ1ZSUwQSUwQWZ1bmMlMjBfcGh5c2ljc19wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOWlmJTIwYWlfY29udHJvbGxlci5uZWVkc19yZXNldCUzQSUwQSUwOSUwOWFpX2NvbnRyb2xsZXIucmVzZXQoKSUwQSUwOSUwOWJhbGwucmVzZXQoKSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOXZhciUyMG1vdmVtZW50JTIwJTNBJTIwZmxvYXQlMEElMDlpZiUyMGFpX2NvbnRyb2xsZXIuaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlM0ElMEElMDklMDltb3ZlbWVudCUyMCUzRCUyMElucHV0LmdldF9heGlzKCUyMnJvdGF0ZV9hbnRpY2xvY2t3aXNlJTIyJTJDJTIwJTIycm90YXRlX2Nsb2Nrd2lzZSUyMiklMEElMDllbHNlJTNBJTBBJTA5JTA5bW92ZW1lbnQlMjAlM0QlMjBhaV9jb250cm9sbGVyLm1vdmVfYWN0aW9uJTBBJTA5cm90YXRlX3kobW92ZW1lbnQqZGVsdGEqcm90YXRpb25fc3BlZWQpJTBBJTBBZnVuYyUyMF9vbl9hcmVhXzNkX2JvZHlfZW50ZXJlZChib2R5KSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIucmV3YXJkJTIwJTJCJTNEJTIwMS4w",highlighted:`extends Node3D

<span class="hljs-meta">@export var rotation_speed = <span class="hljs-number">3.0</span></span>
<span class="hljs-meta">@onready var ball = get_node(<span class="hljs-params"><span class="hljs-string">&quot;../Ball&quot;</span></span>)</span>
<span class="hljs-meta">@onready var ai_controller = $AIController3D</span>

func _ready():
	ai_controller.init(self)

func game_over():
	ai_controller.done = true
	ai_controller.needs_reset = true

func _physics_process(delta):
	<span class="hljs-keyword">if</span> ai_controller.needs_reset:
		ai_controller.reset()
		ball.reset()
		<span class="hljs-keyword">return</span>

	var movement : <span class="hljs-built_in">float</span>
	<span class="hljs-keyword">if</span> ai_controller.heuristic == <span class="hljs-string">&quot;human&quot;</span>:
		movement = Input.get_axis(<span class="hljs-string">&quot;rotate_anticlockwise&quot;</span>, <span class="hljs-string">&quot;rotate_clockwise&quot;</span>)
	<span class="hljs-keyword">else</span>:
		movement = ai_controller.move_action
	rotate_y(movement*delta*rotation_speed)

func _on_area_3d_body_entered(body):
	ai_controller.reward += <span class="hljs-number">1.0</span>`,wrap:!1}}),Ie=new E({}),Ee=new E({}),{c(){w=s("meta"),lt=a(),Ye=s("p"),nt=a(),v=s("h1"),_=s("a"),Fe=s("span"),u(R.$$.fragment),gl=a(),Le=s("span"),Le.textContent=Ul,st=a(),A=s("p"),A.innerHTML=Jl,ot=a(),L=s("p"),L.textContent=xl,at=a(),W=s("ul"),W.innerHTML=_l,it=a(),X=s("p"),X.innerHTML=Cl,rt=a(),H=s("p"),H.innerHTML=Gl,ht=a(),y=s("h2"),C=s("a"),Pe=s("span"),u($.$$.fragment),fl=a(),We=s("span"),We.textContent=kl,pt=a(),N=s("p"),N.innerHTML=Sl,ct=a(),Q=s("p"),Q.innerHTML=Zl,ut=a(),z=s("p"),z.innerHTML=Il,dt=a(),Y=s("img"),mt=a(),b=s("h3"),G=s("a"),qe=s("span"),u(F.$$.fragment),Ml=a(),Xe=s("span"),Xe.textContent=El,gt=a(),P=s("p"),P.innerHTML=Rl,ft=a(),q=s("p"),q.innerHTML=Al,Mt=a(),V=s("p"),V.innerHTML=Ll,wt=a(),D=s("p"),D.innerHTML=Wl,vt=a(),O=s("p"),O.textContent=Xl,yt=a(),K=s("ul"),K.innerHTML=Hl,bt=a(),T=s("h3"),k=s("a"),Ve=s("span"),u(ee.$$.fragment),wl=a(),He=s("span"),He.textContent=$l,Tt=a(),te=s("p"),te.textContent=Nl,jt=a(),le=s("ul"),le.innerHTML=Ql,Ut=a(),ne=s("p"),ne.innerHTML=zl,Jt=a(),se=s("p"),se.textContent=Yl,xt=a(),j=s("h3"),S=s("a"),De=s("span"),u(oe.$$.fragment),vl=a(),$e=s("span"),$e.textContent=Fl,_t=a(),ae=s("p"),ae.textContent=Pl,Ct=a(),ie=s("p"),ie.textContent=ql,Gt=a(),re=s("img"),kt=a(),he=s("p"),he.innerHTML=Dl,St=a(),pe=s("img"),Zt=a(),ce=s("p"),ce.textContent=Kl,It=a(),ue=s("img"),Bt=a(),U=s("h3"),Z=s("a"),Oe=s("span"),u(de.$$.fragment),yl=a(),Ne=s("span"),Ne.textContent=tn,Et=a(),me=s("p"),me.textContent=ln,Rt=a(),ge=s("img"),At=a(),fe=s("p"),fe.innerHTML=sn,Lt=a(),Me=s("img"),Wt=a(),we=s("p"),we.textContent=an,Xt=a(),u(ve.$$.fragment),Ht=a(),ye=s("p"),ye.textContent=rn,$t=a(),be=s("p"),be.innerHTML=hn,Nt=a(),u(Te.$$.fragment),Qt=a(),je=s("p"),je.textContent=pn,zt=a(),u(Ue.$$.fragment),Yt=a(),Je=s("p"),Je.textContent=cn,Ft=a(),xe=s("p"),xe.innerHTML=un,Pt=a(),u(_e.$$.fragment),qt=a(),Ce=s("p"),Ce.textContent=dn,Vt=a(),Ge=s("p"),Ge.innerHTML=mn,Dt=a(),ke=s("p"),ke.textContent=gn,Ot=a(),Se=s("img"),Kt=a(),Ze=s("p"),Ze.textContent=Mn,el=a(),J=s("h3"),I=s("a"),Ke=s("span"),u(Ie.$$.fragment),bl=a(),Qe=s("span"),Qe.textContent=wn,tl=a(),Be=s("p"),Be.innerHTML=vn,ll=a(),x=s("h2"),B=s("a"),et=s("span"),u(Ee.$$.fragment),Tl=a(),ze=s("span"),ze.textContent=yn,nl=a(),Re=s("p"),Re.innerHTML=bn,sl=a(),tt=s("p"),this.h()},l(e){const l=Nn("svelte-1phssyn",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),lt=i(e),Ye=o(e,"P",{}),c(Ye).forEach(t),nt=i(e),v=o(e,"H1",{class:!0});var al=c(v);_=o(al,"A",{id:!0,class:!0,href:!0});var Tn=c(_);Fe=o(Tn,"SPAN",{});var jn=c(Fe);d(R.$$.fragment,jn),jn.forEach(t),Tn.forEach(t),gl=i(al),Le=o(al,"SPAN",{"data-svelte-h":!0}),h(Le)!=="svelte-1ryjy8i"&&(Le.textContent=Ul),al.forEach(t),st=i(e),A=o(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-2p47v5"&&(A.innerHTML=Jl),ot=i(e),L=o(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1py9j1o"&&(L.textContent=xl),at=i(e),W=o(e,"UL",{"data-svelte-h":!0}),h(W)!=="svelte-fbxqzk"&&(W.innerHTML=_l),it=i(e),X=o(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-f5k4w1"&&(X.innerHTML=Cl),rt=i(e),H=o(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1tilrrq"&&(H.innerHTML=Gl),ht=i(e),y=o(e,"H2",{class:!0});var il=c(y);C=o(il,"A",{id:!0,class:!0,href:!0});var Un=c(C);Pe=o(Un,"SPAN",{});var Jn=c(Pe);d($.$$.fragment,Jn),Jn.forEach(t),Un.forEach(t),fl=i(il),We=o(il,"SPAN",{"data-svelte-h":!0}),h(We)!=="svelte-ywyt4x"&&(We.textContent=kl),il.forEach(t),pt=i(e),N=o(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-j43km5"&&(N.innerHTML=Sl),ct=i(e),Q=o(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1bia7ve"&&(Q.innerHTML=Zl),ut=i(e),z=o(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-18kdqtx"&&(z.innerHTML=Il),dt=i(e),Y=o(e,"IMG",{src:!0,alt:!0}),mt=i(e),b=o(e,"H3",{class:!0});var rl=c(b);G=o(rl,"A",{id:!0,class:!0,href:!0});var xn=c(G);qe=o(xn,"SPAN",{});var _n=c(qe);d(F.$$.fragment,_n),_n.forEach(t),xn.forEach(t),Ml=i(rl),Xe=o(rl,"SPAN",{"data-svelte-h":!0}),h(Xe)!=="svelte-1mz6v7c"&&(Xe.textContent=El),rl.forEach(t),gt=i(e),P=o(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-12z31zk"&&(P.innerHTML=Rl),ft=i(e),q=o(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-15j420f"&&(q.innerHTML=Al),Mt=i(e),V=o(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-11gpv3q"&&(V.innerHTML=Ll),wt=i(e),D=o(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-sbxy1m"&&(D.innerHTML=Wl),vt=i(e),O=o(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1qow1fz"&&(O.textContent=Xl),yt=i(e),K=o(e,"UL",{"data-svelte-h":!0}),h(K)!=="svelte-113hcwa"&&(K.innerHTML=Hl),bt=i(e),T=o(e,"H3",{class:!0});var hl=c(T);k=o(hl,"A",{id:!0,class:!0,href:!0});var Cn=c(k);Ve=o(Cn,"SPAN",{});var Gn=c(Ve);d(ee.$$.fragment,Gn),Gn.forEach(t),Cn.forEach(t),wl=i(hl),He=o(hl,"SPAN",{"data-svelte-h":!0}),h(He)!=="svelte-1gryrnq"&&(He.textContent=$l),hl.forEach(t),Tt=i(e),te=o(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-4xjw3c"&&(te.textContent=Nl),jt=i(e),le=o(e,"UL",{"data-svelte-h":!0}),h(le)!=="svelte-14f47bb"&&(le.innerHTML=Ql),Ut=i(e),ne=o(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-n5pdey"&&(ne.innerHTML=zl),Jt=i(e),se=o(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-82774z"&&(se.textContent=Yl),xt=i(e),j=o(e,"H3",{class:!0});var pl=c(j);S=o(pl,"A",{id:!0,class:!0,href:!0});var kn=c(S);De=o(kn,"SPAN",{});var Sn=c(De);d(oe.$$.fragment,Sn),Sn.forEach(t),kn.forEach(t),vl=i(pl),$e=o(pl,"SPAN",{"data-svelte-h":!0}),h($e)!=="svelte-11hkyyl"&&($e.textContent=Fl),pl.forEach(t),_t=i(e),ae=o(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1czivbr"&&(ae.textContent=Pl),Ct=i(e),ie=o(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1mue8hu"&&(ie.textContent=ql),Gt=i(e),re=o(e,"IMG",{src:!0,alt:!0}),kt=i(e),he=o(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-lujuq9"&&(he.innerHTML=Dl),St=i(e),pe=o(e,"IMG",{src:!0,alt:!0}),Zt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-15nk9bg"&&(ce.textContent=Kl),It=i(e),ue=o(e,"IMG",{src:!0,alt:!0}),Bt=i(e),U=o(e,"H3",{class:!0});var cl=c(U);Z=o(cl,"A",{id:!0,class:!0,href:!0});var Zn=c(Z);Oe=o(Zn,"SPAN",{});var In=c(Oe);d(de.$$.fragment,In),In.forEach(t),Zn.forEach(t),yl=i(cl),Ne=o(cl,"SPAN",{"data-svelte-h":!0}),h(Ne)!=="svelte-kji07x"&&(Ne.textContent=tn),cl.forEach(t),Et=i(e),me=o(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1k1rgr4"&&(me.textContent=ln),Rt=i(e),ge=o(e,"IMG",{src:!0,alt:!0}),At=i(e),fe=o(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-wi5wbl"&&(fe.innerHTML=sn),Lt=i(e),Me=o(e,"IMG",{src:!0,alt:!0}),Wt=i(e),we=o(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-g41mxc"&&(we.textContent=an),Xt=i(e),d(ve.$$.fragment,e),Ht=i(e),ye=o(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-1nxuc10"&&(ye.textContent=rn),$t=i(e),be=o(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-10r5ldp"&&(be.innerHTML=hn),Nt=i(e),d(Te.$$.fragment,e),Qt=i(e),je=o(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1bzu5xq"&&(je.textContent=pn),zt=i(e),d(Ue.$$.fragment,e),Yt=i(e),Je=o(e,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-mym9fn"&&(Je.textContent=cn),Ft=i(e),xe=o(e,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-wxjevn"&&(xe.innerHTML=un),Pt=i(e),d(_e.$$.fragment,e),qt=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-vvgyl6"&&(Ce.textContent=dn),Vt=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-cbe1vr"&&(Ge.innerHTML=mn),Dt=i(e),ke=o(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-1wvpaln"&&(ke.textContent=gn),Ot=i(e),Se=o(e,"IMG",{src:!0,alt:!0}),Kt=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1da9kc0"&&(Ze.textContent=Mn),el=i(e),J=o(e,"H3",{class:!0});var ul=c(J);I=o(ul,"A",{id:!0,class:!0,href:!0});var Bn=c(I);Ke=o(Bn,"SPAN",{});var En=c(Ke);d(Ie.$$.fragment,En),En.forEach(t),Bn.forEach(t),bl=i(ul),Qe=o(ul,"SPAN",{"data-svelte-h":!0}),h(Qe)!=="svelte-skuzrh"&&(Qe.textContent=wn),ul.forEach(t),tl=i(e),Be=o(e,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-w6yf05"&&(Be.innerHTML=vn),ll=i(e),x=o(e,"H2",{class:!0});var dl=c(x);B=o(dl,"A",{id:!0,class:!0,href:!0});var Rn=c(B);et=o(Rn,"SPAN",{});var An=c(et);d(Ee.$$.fragment,An),An.forEach(t),Rn.forEach(t),Tl=i(dl),ze=o(dl,"SPAN",{"data-svelte-h":!0}),h(ze)!=="svelte-hw3i4s"&&(ze.textContent=yn),dl.forEach(t),nl=i(e),Re=o(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-11016ov"&&(Re.innerHTML=bn),sl=i(e),tt=o(e,"P",{}),c(tt).forEach(t),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",JSON.stringify(zn)),r(_,"id","godot-rl-agents"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#godot-rl-agents"),r(v,"class","relative group"),r(C,"id","create-a-custom-rl-environment-with-godot-rl-agents"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#create-a-custom-rl-environment-with-godot-rl-agents"),r(y,"class","relative group"),Ae(Y.src,Bl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/ringpong.gif")||r(Y,"src",Bl),r(Y,"alt","Ring Pong"),r(G,"id","installing-the-godot-game-engine"),r(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(G,"href","#installing-the-godot-game-engine"),r(b,"class","relative group"),r(k,"id","loading-the-starter-project"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#loading-the-starter-project"),r(T,"class","relative group"),r(S,"id","installing-the-godot-rl-agents-plugin"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#installing-the-godot-rl-agents-plugin"),r(j,"class","relative group"),Ae(re.src,Vl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot1.png")||r(re,"src",Vl),r(re,"alt","Godot"),Ae(pe.src,Ol="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot2.png")||r(pe,"src",Ol),r(pe,"alt","Godot"),Ae(ue.src,en="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot3.png")||r(ue,"src",en),r(ue,"alt","Godot"),r(Z,"id","adding-the-ai-controller"),r(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Z,"href","#adding-the-ai-controller"),r(U,"class","relative group"),Ae(ge.src,nn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot4.png")||r(ge,"src",nn),r(ge,"alt","Godot"),Ae(Me.src,on="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot5.png")||r(Me,"src",on),r(Me,"alt","Godot"),Ae(Se.src,fn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot6.png")||r(Se,"src",fn),r(Se,"alt","Godot"),r(I,"id","theres-more"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#theres-more"),r(J,"class","relative group"),r(B,"id","author"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#author"),r(x,"class","relative group")},m(e,l){p(document.head,w),n(e,lt,l),n(e,Ye,l),n(e,nt,l),n(e,v,l),p(v,_),p(_,Fe),m(R,Fe,null),p(v,gl),p(v,Le),n(e,st,l),n(e,A,l),n(e,ot,l),n(e,L,l),n(e,at,l),n(e,W,l),n(e,it,l),n(e,X,l),n(e,rt,l),n(e,H,l),n(e,ht,l),n(e,y,l),p(y,C),p(C,Pe),m($,Pe,null),p(y,fl),p(y,We),n(e,pt,l),n(e,N,l),n(e,ct,l),n(e,Q,l),n(e,ut,l),n(e,z,l),n(e,dt,l),n(e,Y,l),n(e,mt,l),n(e,b,l),p(b,G),p(G,qe),m(F,qe,null),p(b,Ml),p(b,Xe),n(e,gt,l),n(e,P,l),n(e,ft,l),n(e,q,l),n(e,Mt,l),n(e,V,l),n(e,wt,l),n(e,D,l),n(e,vt,l),n(e,O,l),n(e,yt,l),n(e,K,l),n(e,bt,l),n(e,T,l),p(T,k),p(k,Ve),m(ee,Ve,null),p(T,wl),p(T,He),n(e,Tt,l),n(e,te,l),n(e,jt,l),n(e,le,l),n(e,Ut,l),n(e,ne,l),n(e,Jt,l),n(e,se,l),n(e,xt,l),n(e,j,l),p(j,S),p(S,De),m(oe,De,null),p(j,vl),p(j,$e),n(e,_t,l),n(e,ae,l),n(e,Ct,l),n(e,ie,l),n(e,Gt,l),n(e,re,l),n(e,kt,l),n(e,he,l),n(e,St,l),n(e,pe,l),n(e,Zt,l),n(e,ce,l),n(e,It,l),n(e,ue,l),n(e,Bt,l),n(e,U,l),p(U,Z),p(Z,Oe),m(de,Oe,null),p(U,yl),p(U,Ne),n(e,Et,l),n(e,me,l),n(e,Rt,l),n(e,ge,l),n(e,At,l),n(e,fe,l),n(e,Lt,l),n(e,Me,l),n(e,Wt,l),n(e,we,l),n(e,Xt,l),m(ve,e,l),n(e,Ht,l),n(e,ye,l),n(e,$t,l),n(e,be,l),n(e,Nt,l),m(Te,e,l),n(e,Qt,l),n(e,je,l),n(e,zt,l),m(Ue,e,l),n(e,Yt,l),n(e,Je,l),n(e,Ft,l),n(e,xe,l),n(e,Pt,l),m(_e,e,l),n(e,qt,l),n(e,Ce,l),n(e,Vt,l),n(e,Ge,l),n(e,Dt,l),n(e,ke,l),n(e,Ot,l),n(e,Se,l),n(e,Kt,l),n(e,Ze,l),n(e,el,l),n(e,J,l),p(J,I),p(I,Ke),m(Ie,Ke,null),p(J,bl),p(J,Qe),n(e,tl,l),n(e,Be,l),n(e,ll,l),n(e,x,l),p(x,B),p(B,et),m(Ee,et,null),p(x,Tl),p(x,ze),n(e,nl,l),n(e,Re,l),n(e,sl,l),n(e,tt,l),ol=!0},p:Wn,i(e){ol||(g(R.$$.fragment,e),g($.$$.fragment,e),g(F.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(de.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(Ue.$$.fragment,e),g(_e.$$.fragment,e),g(Ie.$$.fragment,e),g(Ee.$$.fragment,e),ol=!0)},o(e){f(R.$$.fragment,e),f($.$$.fragment,e),f(F.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(de.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Ue.$$.fragment,e),f(_e.$$.fragment,e),f(Ie.$$.fragment,e),f(Ee.$$.fragment,e),ol=!1},d(e){e&&(t(lt),t(Ye),t(nt),t(v),t(st),t(A),t(ot),t(L),t(at),t(W),t(it),t(X),t(rt),t(H),t(ht),t(y),t(pt),t(N),t(ct),t(Q),t(ut),t(z),t(dt),t(Y),t(mt),t(b),t(gt),t(P),t(ft),t(q),t(Mt),t(V),t(wt),t(D),t(vt),t(O),t(yt),t(K),t(bt),t(T),t(Tt),t(te),t(jt),t(le),t(Ut),t(ne),t(Jt),t(se),t(xt),t(j),t(_t),t(ae),t(Ct),t(ie),t(Gt),t(re),t(kt),t(he),t(St),t(pe),t(Zt),t(ce),t(It),t(ue),t(Bt),t(U),t(Et),t(me),t(Rt),t(ge),t(At),t(fe),t(Lt),t(Me),t(Wt),t(we),t(Xt),t(Ht),t(ye),t($t),t(be),t(Nt),t(Qt),t(je),t(zt),t(Yt),t(Je),t(Ft),t(xe),t(Pt),t(qt),t(Ce),t(Vt),t(Ge),t(Dt),t(ke),t(Ot),t(Se),t(Kt),t(Ze),t(el),t(J),t(tl),t(Be),t(ll),t(x),t(nl),t(Re),t(sl),t(tt)),t(w),M(R),M($),M(F),M(ee),M(oe),M(de),M(ve,e),M(Te,e),M(Ue,e),M(_e,e),M(Ie),M(Ee)}}}const zn={local:"godot-rl-agents",sections:[{local:"create-a-custom-rl-environment-with-godot-rl-agents",sections:[{local:"installing-the-godot-game-engine",title:"Installing the Godot Game Engine"},{local:"loading-the-starter-project",title:"Loading the starter project"},{local:"installing-the-godot-rl-agents-plugin",title:"Installing the Godot RL Agents plugin"},{local:"adding-the-ai-controller",title:"Adding the AI controller"},{local:"theres-more",title:"There’s more!"}],title:"Create a custom RL environment with Godot RL Agents"},{local:"author",title:"Author"}],title:"Godot RL Agents"};function Yn(jl){return Xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends Hn{constructor(w){super(),$n(this,w,Yn,Qn,Ln,{})}}export{Dn as component};
