import{s as Bt,n as St,o as It}from"../chunks/scheduler.53228c21.js";import{S as At,i as Zt,e as i,s as o,c,h as xt,a as s,d as n,b as l,f as jt,g as h,j as d,k as Q,l as Pt,m as a,n as p,t as m,o as f,p as u}from"../chunks/index.100fac89.js";import{C as Ft}from"../chunks/CopyLLMTxtMenu.b0ff86f3.js";import{C as mt}from"../chunks/CodeBlock.d30a6509.js";import{H as pt,E as Gt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.136ef3fd.js";function Wt(ft){let r,H,W,q,y,L,g,Y,b,ut="<p>The attention dispatcher is an experimental feature. Please open an issue if you have any feedback or encounter any problems.</p>",X,_,bt="Diffusers provides several optimized attention algorithms that are more memory and computationally efficient through it’s <em>attention dispatcher</em>. The dispatcher acts as a router for managing and switching between different attention implementations and provides a unified interface for interacting with them.",E,T,Mt='Refer to the table below for an overview of the available attention families and to the <a href="#available-backends">Available backends</a> section for a more complete list.',D,k,wt='<thead><tr><th>attention family</th> <th>main feature</th></tr></thead> <tbody><tr><td>FlashAttention</td> <td>minimizes memory reads/writes through tiling and recomputation</td></tr> <tr><td>SageAttention</td> <td>quantizes attention to int8</td></tr> <tr><td>PyTorch native</td> <td>built-in PyTorch implementation using <a href="./fp16#scaled-dot-product-attention">scaled_dot_product_attention</a></td></tr> <tr><td>xFormers</td> <td>memory-efficient attention with support for various attention kernels</td></tr></tbody>',V,v,yt="This guide will show you how to set and use the different attention backends.",z,J,N,U,gt='The <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> method iterates through all the modules in the model and sets the appropriate attention backend to use. The attention backend setting persists until <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a> is called.',R,$,_t='The example below demonstrates how to enable the <code>_flash_3_hub</code> implementation for FlashAttention-3 from the <a href="https://github.com/huggingface/kernels" rel="nofollow">kernel</a> library, which allows you to instantly use optimized compute kernels from the Hub without requiring any setup.',K,M,Tt="<p>FlashAttention-3 is not supported for non-Hopper architectures, in which case, use FlashAttention with <code>set_attention_backend(&quot;flash&quot;)</code>.</p>",O,j,tt,B,kt='To restore the default attention backend, call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.reset_attention_backend">reset_attention_backend()</a>.',et,S,nt,I,at,A,vt='The <a href="https://github.com/huggingface/diffusers/blob/5e181eddfe7e44c1444a2511b0d8e21d177850a0/src/diffusers/models/attention_dispatch.py#L225" rel="nofollow">attention_backend</a> context manager temporarily sets an attention backend for a model within the context. Outside the context, the default attention (PyTorch’s native scaled dot product attention) is used. This is useful if you want to use different backends for different parts of a pipeline or if you want to test the different backends.',ot,Z,lt,w,Jt="<p>Most attention backends support <code>torch.compile</code> without graph breaks and can be used to further speed up inference.</p>",it,x,st,P,Ut="Refer to the table below for a complete list of available attention backends and their variants.",dt,F,$t='<summary>Expand</summary> <table><thead><tr><th>Backend Name</th> <th>Family</th> <th>Description</th></tr></thead> <tbody><tr><td><code>native</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Default backend using PyTorch’s scaled_dot_product_attention</td></tr> <tr><td><code>flex</code></td> <td><a href="https://docs.pytorch.org/docs/stable/nn.attention.flex_attention.html#module-torch.nn.attention.flex_attention" rel="nofollow">FlexAttention</a></td> <td>PyTorch FlexAttention implementation</td></tr> <tr><td><code>_native_cudnn</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>CuDNN-optimized attention</td></tr> <tr><td><code>_native_efficient</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Memory-efficient attention</td></tr> <tr><td><code>_native_flash</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>PyTorch’s FlashAttention</td></tr> <tr><td><code>_native_math</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>Math-based attention (fallback)</td></tr> <tr><td><code>_native_npu</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>NPU-optimized attention</td></tr> <tr><td><code>_native_xla</code></td> <td><a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.attention.SDPBackend.html#torch.nn.attention.SDPBackend" rel="nofollow">PyTorch native</a></td> <td>XLA-optimized attention</td></tr> <tr><td><code>flash</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-2</td></tr> <tr><td><code>flash_varlen</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention</td></tr> <tr><td><code>_flash_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3</td></tr> <tr><td><code>_flash_varlen_3</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>Variable length FlashAttention-3</td></tr> <tr><td><code>_flash_3_hub</code></td> <td><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a></td> <td>FlashAttention-3 from kernels</td></tr> <tr><td><code>sage</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Quantized attention (INT8 QK)</td></tr> <tr><td><code>sage_varlen</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>Variable length SageAttention</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp8_cuda_sm90</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP8 PV (SM90)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_cuda</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (CUDA)</td></tr> <tr><td><code>_sage_qk_int8_pv_fp16_triton</code></td> <td><a href="https://github.com/thu-ml/SageAttention" rel="nofollow">SageAttention</a></td> <td>INT8 QK + FP16 PV (Triton)</td></tr> <tr><td><code>xformers</code></td> <td><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a></td> <td>Memory-efficient attention</td></tr></tbody></table>',rt,G,ct,C,ht;return y=new Ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new pt({props:{title:"Attention backends",local:"attention-backends",headingTag:"h1"}}),J=new pt({props:{title:"set_attention_backend",local:"setattentionbackend",headingTag:"h2"}}),j=new mt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS50cmFuc2Zvcm1lci5zZXRfYXR0ZW50aW9uX2JhY2tlbmQoJTIyX2ZsYXNoXzNfaHViJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQWNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTBBaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTBBJTIyJTIyJTIyJTBBcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new mt({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIucmVzZXRfYXR0ZW50aW9uX2JhY2tlbmQoKQ==",highlighted:"pipeline.transformer.reset_attention_backend()",wrap:!1}}),I=new pt({props:{title:"attention_backend context manager",local:"attentionbackend-context-manager",headingTag:"h2"}}),Z=new mt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSUwQXdpdGglMjBhdHRlbnRpb25fYmFja2VuZCglMjJfZmxhc2hfM19odWIlMjIpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

<span class="hljs-keyword">with</span> attention_backend(<span class="hljs-string">&quot;_flash_3_hub&quot;</span>):
    image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),x=new pt({props:{title:"Available backends",local:"available-backends",headingTag:"h2"}}),G=new Gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/attention_backends.md"}}),{c(){r=i("meta"),H=o(),W=i("p"),q=o(),c(y.$$.fragment),L=o(),c(g.$$.fragment),Y=o(),b=i("blockquote"),b.innerHTML=ut,X=o(),_=i("p"),_.innerHTML=bt,E=o(),T=i("p"),T.innerHTML=Mt,D=o(),k=i("table"),k.innerHTML=wt,V=o(),v=i("p"),v.textContent=yt,z=o(),c(J.$$.fragment),N=o(),U=i("p"),U.innerHTML=gt,R=o(),$=i("p"),$.innerHTML=_t,K=o(),M=i("blockquote"),M.innerHTML=Tt,O=o(),c(j.$$.fragment),tt=o(),B=i("p"),B.innerHTML=kt,et=o(),c(S.$$.fragment),nt=o(),c(I.$$.fragment),at=o(),A=i("p"),A.innerHTML=vt,ot=o(),c(Z.$$.fragment),lt=o(),w=i("blockquote"),w.innerHTML=Jt,it=o(),c(x.$$.fragment),st=o(),P=i("p"),P.textContent=Ut,dt=o(),F=i("details"),F.innerHTML=$t,rt=o(),c(G.$$.fragment),ct=o(),C=i("p"),this.h()},l(t){const e=xt("svelte-u9bgzb",document.head);r=s(e,"META",{name:!0,content:!0}),e.forEach(n),H=l(t),W=s(t,"P",{}),jt(W).forEach(n),q=l(t),h(y.$$.fragment,t),L=l(t),h(g.$$.fragment,t),Y=l(t),b=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-7ay7vy"&&(b.innerHTML=ut),X=l(t),_=s(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1p5wykf"&&(_.innerHTML=bt),E=l(t),T=s(t,"P",{"data-svelte-h":!0}),d(T)!=="svelte-q2vvjg"&&(T.innerHTML=Mt),D=l(t),k=s(t,"TABLE",{"data-svelte-h":!0}),d(k)!=="svelte-1eo6jrm"&&(k.innerHTML=wt),V=l(t),v=s(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1o85kpy"&&(v.textContent=yt),z=l(t),h(J.$$.fragment,t),N=l(t),U=s(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-k822hv"&&(U.innerHTML=gt),R=l(t),$=s(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-142if5b"&&($.innerHTML=_t),K=l(t),M=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(M)!=="svelte-j6ruup"&&(M.innerHTML=Tt),O=l(t),h(j.$$.fragment,t),tt=l(t),B=s(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-41vsbn"&&(B.innerHTML=kt),et=l(t),h(S.$$.fragment,t),nt=l(t),h(I.$$.fragment,t),at=l(t),A=s(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-g6fiju"&&(A.innerHTML=vt),ot=l(t),h(Z.$$.fragment,t),lt=l(t),w=s(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(w)!=="svelte-1mkj6ep"&&(w.innerHTML=Jt),it=l(t),h(x.$$.fragment,t),st=l(t),P=s(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-frsh1o"&&(P.textContent=Ut),dt=l(t),F=s(t,"DETAILS",{"data-svelte-h":!0}),d(F)!=="svelte-1a11wal"&&(F.innerHTML=$t),rt=l(t),h(G.$$.fragment,t),ct=l(t),C=s(t,"P",{}),jt(C).forEach(n),this.h()},h(){Q(r,"name","hf:doc:metadata"),Q(r,"content",Ct),Q(b,"class","note"),Q(M,"class","note"),Q(w,"class","tip")},m(t,e){Pt(document.head,r),a(t,H,e),a(t,W,e),a(t,q,e),p(y,t,e),a(t,L,e),p(g,t,e),a(t,Y,e),a(t,b,e),a(t,X,e),a(t,_,e),a(t,E,e),a(t,T,e),a(t,D,e),a(t,k,e),a(t,V,e),a(t,v,e),a(t,z,e),p(J,t,e),a(t,N,e),a(t,U,e),a(t,R,e),a(t,$,e),a(t,K,e),a(t,M,e),a(t,O,e),p(j,t,e),a(t,tt,e),a(t,B,e),a(t,et,e),p(S,t,e),a(t,nt,e),p(I,t,e),a(t,at,e),a(t,A,e),a(t,ot,e),p(Z,t,e),a(t,lt,e),a(t,w,e),a(t,it,e),p(x,t,e),a(t,st,e),a(t,P,e),a(t,dt,e),a(t,F,e),a(t,rt,e),p(G,t,e),a(t,ct,e),a(t,C,e),ht=!0},p:St,i(t){ht||(m(y.$$.fragment,t),m(g.$$.fragment,t),m(J.$$.fragment,t),m(j.$$.fragment,t),m(S.$$.fragment,t),m(I.$$.fragment,t),m(Z.$$.fragment,t),m(x.$$.fragment,t),m(G.$$.fragment,t),ht=!0)},o(t){f(y.$$.fragment,t),f(g.$$.fragment,t),f(J.$$.fragment,t),f(j.$$.fragment,t),f(S.$$.fragment,t),f(I.$$.fragment,t),f(Z.$$.fragment,t),f(x.$$.fragment,t),f(G.$$.fragment,t),ht=!1},d(t){t&&(n(H),n(W),n(q),n(L),n(Y),n(b),n(X),n(_),n(E),n(T),n(D),n(k),n(V),n(v),n(z),n(N),n(U),n(R),n($),n(K),n(M),n(O),n(tt),n(B),n(et),n(nt),n(at),n(A),n(ot),n(lt),n(w),n(it),n(st),n(P),n(dt),n(F),n(rt),n(ct),n(C)),n(r),u(y,t),u(g,t),u(J,t),u(j,t),u(S,t),u(I,t),u(Z,t),u(x,t),u(G,t)}}}const Ct='{"title":"Attention backends","local":"attention-backends","sections":[{"title":"set_attention_backend","local":"setattentionbackend","sections":[],"depth":2},{"title":"attention_backend context manager","local":"attentionbackend-context-manager","sections":[],"depth":2},{"title":"Available backends","local":"available-backends","sections":[],"depth":2}],"depth":1}';function Qt(ft){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends At{constructor(r){super(),Zt(this,r,Qt,Wt,Bt,{})}}export{Et as component};
