# AutoencoderKLLTXVideo

The 3D variational autoencoder (VAE) model with KL loss used in [LTX](https://huggingface.co/Lightricks/LTX-Video) was introduced by Lightricks.

The model can be loaded with the following code snippet.

```python
from diffusers import AutoencoderKLLTXVideo

vae = AutoencoderKLLTXVideo.from_pretrained("Lightricks/LTX-Video", subfolder="vae", torch_dtype=torch.float32).to("cuda")
```

## AutoencoderKLLTXVideo[[diffusers.AutoencoderKLLTXVideo]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.AutoencoderKLLTXVideo</name><anchor>diffusers.AutoencoderKLLTXVideo</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1037</source><parameters>[{"name": "in_channels", "val": ": int = 3"}, {"name": "out_channels", "val": ": int = 3"}, {"name": "latent_channels", "val": ": int = 128"}, {"name": "block_out_channels", "val": ": typing.Tuple[int, ...] = (128, 256, 512, 512)"}, {"name": "down_block_types", "val": ": typing.Tuple[str, ...] = ('LTXVideoDownBlock3D', 'LTXVideoDownBlock3D', 'LTXVideoDownBlock3D', 'LTXVideoDownBlock3D')"}, {"name": "decoder_block_out_channels", "val": ": typing.Tuple[int, ...] = (128, 256, 512, 512)"}, {"name": "layers_per_block", "val": ": typing.Tuple[int, ...] = (4, 3, 3, 3, 4)"}, {"name": "decoder_layers_per_block", "val": ": typing.Tuple[int, ...] = (4, 3, 3, 3, 4)"}, {"name": "spatio_temporal_scaling", "val": ": typing.Tuple[bool, ...] = (True, True, True, False)"}, {"name": "decoder_spatio_temporal_scaling", "val": ": typing.Tuple[bool, ...] = (True, True, True, False)"}, {"name": "decoder_inject_noise", "val": ": typing.Tuple[bool, ...] = (False, False, False, False, False)"}, {"name": "downsample_type", "val": ": typing.Tuple[str, ...] = ('conv', 'conv', 'conv', 'conv')"}, {"name": "upsample_residual", "val": ": typing.Tuple[bool, ...] = (False, False, False, False)"}, {"name": "upsample_factor", "val": ": typing.Tuple[int, ...] = (1, 1, 1, 1)"}, {"name": "timestep_conditioning", "val": ": bool = False"}, {"name": "patch_size", "val": ": int = 4"}, {"name": "patch_size_t", "val": ": int = 1"}, {"name": "resnet_norm_eps", "val": ": float = 1e-06"}, {"name": "scaling_factor", "val": ": float = 1.0"}, {"name": "encoder_causal", "val": ": bool = True"}, {"name": "decoder_causal", "val": ": bool = False"}, {"name": "spatial_compression_ratio", "val": ": int = None"}, {"name": "temporal_compression_ratio", "val": ": int = None"}]</parameters><paramsdesc>- **in_channels** (`int`, defaults to `3`) --
  Number of input channels.
- **out_channels** (`int`, defaults to `3`) --
  Number of output channels.
- **latent_channels** (`int`, defaults to `128`) --
  Number of latent channels.
- **block_out_channels** (`Tuple[int, ...]`, defaults to `(128, 256, 512, 512)`) --
  The number of output channels for each block.
- **spatio_temporal_scaling** (`Tuple[bool, ...], defaults to `(True, True, True, False)` --
  Whether a block should contain spatio-temporal downscaling or not.
- **layers_per_block** (`Tuple[int, ...]`, defaults to `(4, 3, 3, 3, 4)`) --
  The number of layers per block.
- **patch_size** (`int`, defaults to `4`) --
  The size of spatial patches.
- **patch_size_t** (`int`, defaults to `1`) --
  The size of temporal patches.
- **resnet_norm_eps** (`float`, defaults to `1e-6`) --
  Epsilon value for ResNet normalization layers.
- **scaling_factor** (`float`, *optional*, defaults to `1.0`) --
  The component-wise standard deviation of the trained latent space computed using the first batch of the
  training set. This is used to scale the latent space to have unit variance when training the diffusion
  model. The latents are scaled with the formula `z = z * scaling_factor` before being passed to the
  diffusion model. When decoding, the latents are scaled back to the original scale with the formula: `z = 1
  / scaling_factor * z`. For more details, refer to sections 4.3.2 and D.1 of the [High-Resolution Image
  Synthesis with Latent Diffusion Models](https://huggingface.co/papers/2112.10752) paper.
- **encoder_causal** (`bool`, defaults to `True`) --
  Whether the encoder should behave causally (future frames depend only on past frames) or not.
- **decoder_causal** (`bool`, defaults to `False`) --
  Whether the decoder should behave causally (future frames depend only on past frames) or not.</paramsdesc><paramgroups>0</paramgroups></docstring>

A VAE model with KL loss for encoding images into latents and decoding latent representations into images. Used in
[LTX](https://huggingface.co/Lightricks/LTX-Video).

This model inherits from [ModelMixin](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin). Check the superclass documentation for it's generic methods implemented
for all models (such as downloading or saving).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>wrapper</name><anchor>diffusers.AutoencoderKLLTXVideo.decode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>wrapper</name><anchor>diffusers.AutoencoderKLLTXVideo.encode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>disable_slicing</name><anchor>diffusers.AutoencoderKLLTXVideo.disable_slicing</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1236</source><parameters>[]</parameters></docstring>

Disable sliced VAE decoding. If `enable_slicing` was previously enabled, this method will go back to computing
decoding in one step.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>disable_tiling</name><anchor>diffusers.AutoencoderKLLTXVideo.disable_tiling</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1222</source><parameters>[]</parameters></docstring>

Disable tiled VAE decoding. If `enable_tiling` was previously enabled, this method will go back to computing
decoding in one step.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_slicing</name><anchor>diffusers.AutoencoderKLLTXVideo.enable_slicing</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1229</source><parameters>[]</parameters></docstring>

Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_tiling</name><anchor>diffusers.AutoencoderKLLTXVideo.enable_tiling</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1188</source><parameters>[{"name": "tile_sample_min_height", "val": ": typing.Optional[int] = None"}, {"name": "tile_sample_min_width", "val": ": typing.Optional[int] = None"}, {"name": "tile_sample_min_num_frames", "val": ": typing.Optional[int] = None"}, {"name": "tile_sample_stride_height", "val": ": typing.Optional[float] = None"}, {"name": "tile_sample_stride_width", "val": ": typing.Optional[float] = None"}, {"name": "tile_sample_stride_num_frames", "val": ": typing.Optional[float] = None"}]</parameters><paramsdesc>- **tile_sample_min_height** (`int`, *optional*) --
  The minimum height required for a sample to be separated into tiles across the height dimension.
- **tile_sample_min_width** (`int`, *optional*) --
  The minimum width required for a sample to be separated into tiles across the width dimension.
- **tile_sample_stride_height** (`int`, *optional*) --
  The minimum amount of overlap between two consecutive vertical tiles. This is to ensure that there are
  no tiling artifacts produced across the height dimension.
- **tile_sample_stride_width** (`int`, *optional*) --
  The stride between two consecutive horizontal tiles. This is to ensure that there are no tiling
  artifacts produced across the width dimension.</paramsdesc><paramgroups>0</paramgroups></docstring>

Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>tiled_decode</name><anchor>diffusers.AutoencoderKLLTXVideo.tiled_decode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1412</source><parameters>[{"name": "z", "val": ": Tensor"}, {"name": "temb", "val": ": typing.Optional[torch.Tensor]"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **z** (`torch.Tensor`) -- Input batch of latent vectors.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `~models.vae.DecoderOutput` instead of a plain tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>`~models.vae.DecoderOutput` or `tuple`</rettype><retdesc>If return_dict is True, a `~models.vae.DecoderOutput` is returned, otherwise a plain `tuple` is
returned.</retdesc></docstring>

Decode a batch of images using a tiled decoder.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>tiled_encode</name><anchor>diffusers.AutoencoderKLLTXVideo.tiled_encode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1361</source><parameters>[{"name": "x", "val": ": Tensor"}]</parameters><paramsdesc>- **x** (`torch.Tensor`) -- Input batch of videos.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The latent representation of the encoded videos.</retdesc></docstring>
Encode a batch of images using a tiled encoder.








</div></div>

## AutoencoderKLOutput[[diffusers.models.modeling_outputs.AutoencoderKLOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.AutoencoderKLOutput</name><anchor>diffusers.models.modeling_outputs.AutoencoderKLOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L7</source><parameters>[{"name": "latent_dist", "val": ": DiagonalGaussianDistribution"}]</parameters><paramsdesc>- **latent_dist** (`DiagonalGaussianDistribution`) --
  Encoded outputs of `Encoder` represented as the mean and logvar of `DiagonalGaussianDistribution`.
  `DiagonalGaussianDistribution` allows for sampling latents from the distribution.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output of AutoencoderKL encoding method.




</div>

## DecoderOutput[[diffusers.models.autoencoders.vae.DecoderOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.autoencoders.vae.DecoderOutput</name><anchor>diffusers.models.autoencoders.vae.DecoderOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L47</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "commit_loss", "val": ": typing.Optional[torch.FloatTensor] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)`) --
  The decoded output sample from the last layer of the model.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output of decoding method.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/autoencoderkl_ltx_video.md" />