# Pipeline states

## PipelineState[[diffusers.modular_pipelines.PipelineState]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.PipelineState</name><anchor>diffusers.modular_pipelines.PipelineState</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L68</source><parameters>[{"name": "values", "val": ": typing.Dict[str, typing.Any] = <factory>"}, {"name": "kwargs_mapping", "val": ": typing.Dict[str, typing.List[str]] = <factory>"}]</parameters></docstring>

`PipelineState` stores the state of a pipeline. It is used to pass data between pipeline blocks.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get</name><anchor>diffusers.modular_pipelines.PipelineState.get</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L93</source><parameters>[{"name": "keys", "val": ": typing.Union[str, typing.List[str]]"}, {"name": "default", "val": ": typing.Any = None"}]</parameters><paramsdesc>- **keys** (Union[str, List[str]]) -- Key or list of keys for the values
- **default** (Any) -- The default value to return if not found</paramsdesc><paramgroups>0</paramgroups><rettype>Union[Any, Dict[str, Any]]</rettype><retdesc>Single value if keys is str, dictionary of values if keys is list</retdesc></docstring>

Get one or multiple values from the pipeline state.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_by_kwargs</name><anchor>diffusers.modular_pipelines.PipelineState.get_by_kwargs</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L108</source><parameters>[{"name": "kwargs_type", "val": ": str"}]</parameters><paramsdesc>- **kwargs_type** (str) -- The kwargs_type to filter by</paramsdesc><paramgroups>0</paramgroups><rettype>Dict[str, Any]</rettype><retdesc>Dictionary of values with matching kwargs_type</retdesc></docstring>

Get all values with matching kwargs_type.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set</name><anchor>diffusers.modular_pipelines.PipelineState.set</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L76</source><parameters>[{"name": "key", "val": ": str"}, {"name": "value", "val": ": typing.Any"}, {"name": "kwargs_type", "val": ": str = None"}]</parameters><paramsdesc>- **key** (str) -- The key for the value
- **value** (Any) -- The value to store
- **kwargs_type** (str) -- The kwargs_type with which the value is associated</paramsdesc><paramgroups>0</paramgroups></docstring>

Add a value to the pipeline state.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>to_dict</name><anchor>diffusers.modular_pipelines.PipelineState.to_dict</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L121</source><parameters>[]</parameters></docstring>

Convert PipelineState to a dictionary.


</div></div>

## BlockState[[diffusers.modular_pipelines.BlockState]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.BlockState</name><anchor>diffusers.modular_pipelines.BlockState</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L152</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters></docstring>

Container for block state data with attribute access and formatted representation.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>as_dict</name><anchor>diffusers.modular_pipelines.BlockState.as_dict</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L169</source><parameters>[]</parameters><rettype>Dict[str, Any]</rettype><retdesc>Dictionary containing all attributes of the BlockState</retdesc></docstring>

Convert BlockState to a dictionary.






</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/modular_diffusers/pipeline_states.md" />