import{s as ut,n as dt,o as ft}from"../chunks/scheduler.23542ac5.js";import{S as rt,i as yt,e as i,s as n,c as M,h as mt,a as p,d as e,b as a,f as ct,g as c,j as o,k as Te,l as Jt,m as t,n as u,t as d,o as f,p as r}from"../chunks/index.9b1f405b.js";import{C as Ut,H as m,E as Tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.1d640393.js";import{C as y}from"../chunks/CodeBlock.e0f68650.js";function jt(je){let J,zl,Sl,Hl,j,Yl,Z,Dl,b,Ze="기본적으로 diffusion 모델은 다양한 컴포넌트들(모델, 토크나이저, 스케줄러) 간의 복잡한 상호작용을 기반으로 동작합니다. 디퓨저스(Diffusers)는 이러한 diffusion 모델을 보다 쉽고 간편한 API로 제공하는 것을 목표로 설계되었습니다. <code>DiffusionPipeline</code>은 diffusion 모델이 갖는 복잡성을 하나의 파이프라인 API로 통합하고, 동시에 이를 구성하는 각각의 컴포넌트들을 태스크에 맞춰 유연하게 커스터마이징할 수 있도록 지원하고 있습니다.",Ll,h,be="diffusion 모델의 훈련과 추론에 필요한 모든 것은 <code>DiffusionPipeline.from_pretrained()</code> 메서드를 통해 접근할 수 있습니다. (이 말의 의미는 다음 단락에서 보다 자세하게 다뤄보도록 하겠습니다.)",Fl,w,he="이 문서에서는 설명할 내용은 다음과 같습니다.",Pl,I,we="<li><p>허브를 통해 혹은 로컬로 파이프라인을 불러오는 법</p></li> <li><p>파이프라인에 다른 컴포넌트들을 적용하는 법</p></li> <li><p>오리지널 체크포인트가 아닌 variant를 불러오는 법  (variant란 기본으로 설정된 <code>fp32</code>가 아닌 다른  부동 소수점 타입(예: <code>fp16</code>)을 사용하거나 Non-EMA 가중치를 사용하는 체크포인트들을 의미합니다.)</p></li> <li><p>모델과 스케줄러를 불러오는 법</p></li>",Ol,C,Kl,U,Ie='<p>💡 <code>DiffusionPipeline</code> 클래스가 동작하는 방식에 보다 자세한 내용이 궁금하다면,  <a href="#diffusionpipeline%EC%97%90-%EB%8C%80%ED%95%B4-%EC%95%8C%EC%95%84%EB%B3%B4%EA%B8%B0">DiffusionPipeline explained</a> 섹션을 확인해보세요.</p>',ls,W,Ce='<code>DiffusionPipeline</code> 클래스는 diffusion 모델을 <a href="https://huggingface.co/models?library=diffusers" rel="nofollow">허브</a>로부터 불러오는 가장 심플하면서 보편적인 방식입니다. <code>DiffusionPipeline.from_pretrained()</code> 메서드는 적합한 파이프라인 클래스를 자동으로 탐지하고, 필요한 구성요소(configuration)와 가중치(weight) 파일들을 다운로드하고 캐싱한 다음, 해당 파이프라인 인스턴스를 반환합니다.',ss,k,es,V,We="물론 <code>DiffusionPipeline</code> 클래스를 사용하지 않고, 명시적으로 직접 해당 파이프라인 클래스를 불러오는 것도 가능합니다. 아래 예시 코드는 위 예시와 동일한 인스턴스를 반환합니다.",ts,G,ns,v,ke='<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">CompVis/stable-diffusion-v1-4</a>이나 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> 같은 체크포인트들의 경우, 하나 이상의 다양한 태스크에 활용될 수 있습니다. (예를 들어 위의 두 체크포인트의 경우, text-to-image와 image-to-image에 모두 활용될 수 있습니다.)  만약 이러한 체크포인트들을 기본 설정 태스크가 아닌 다른 태스크에 활용하고자 한다면, 해당 태스크에 대응되는 파이프라인(task-specific pipeline)을 사용해야 합니다.',as,N,is,$,ps,g,Ve="파이프라인을 로컬로 불러오고자 한다면, <code>git-lfs</code>를 사용하여 직접 체크포인트를 로컬 디스크에 다운로드 받아야 합니다. 아래의 명령어를 실행하면 <code>./stable-diffusion-v1-5</code>란 이름으로 폴더가 로컬디스크에 생성됩니다.",os,B,Ms,R,Ge="그런 다음 해당 로컬 경로를 <code>from_pretrained()</code> 메서드에 전달합니다.",cs,_,us,E,ve="위의 예시코드처럼 만약 <code>repo_id</code>가 로컬 패스(local path)라면, <code>from_pretrained()</code> 메서드는 이를 자동으로 감지하여 허브에서 파일을 다운로드하지 않습니다. 만약 로컬 디스크에 저장된 파이프라인 체크포인트가 최신 버전이 아닐 경우에도, 최신 버전을 다운로드하지 않고 기존 로컬 디스크에 저장된 체크포인트를 사용한다는 것을 의미합니다.",ds,Q,fs,q,Ne="파이프라인 내부의 컴포넌트들은 호환 가능한 다른 컴포넌트로 교체될 수 있습니다. 이와 같은 컴포넌트 교체가 중요한 이유는 다음과 같습니다.",rs,X,$e="<li>어떤 스케줄러를 사용할 것인가는 생성속도와 생성품질 간의 트레이드오프를 정의하는 중요한 요소입니다.</li> <li>diffusion 모델 내부의 컴포넌트들은 일반적으로 각각 독립적으로 훈련되기 때문에, 더 좋은 성능을 보여주는 컴포넌트가 있다면 그걸로 교체하는 식으로 성능을 향상시킬 수 있습니다.</li> <li>파인 튜닝 단계에서는 일반적으로 UNet 혹은 텍스트 인코더와 같은 일부 컴포넌트들만 훈련하게 됩니다.</li>",ys,x,ge="어떤 스케줄러들이 호환가능한지는 <code>compatibles</code> 속성을 통해 확인할 수 있습니다.",ms,S,Js,A,Be='이번에는 <code>SchedulerMixin.from_pretrained()</code> 메서드를 사용해서, 기존 기본 스케줄러였던 <code>PNDMScheduler</code>를 보다 우수한 성능의 <code>EulerDiscreteScheduler</code>로 바꿔봅시다. 스케줄러를 로드할 때는 <code>subfolder</code> 인자를 통해, 해당 파이프라인의 리포지토리에서 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">스케줄러에 관한 하위폴더</a>를  명시해주어야 합니다.',Us,z,Re="그 다음 새롭게 생성한 <code>EulerDiscreteScheduler</code> 인스턴스를 <code>DiffusionPipeline</code>의 <code>scheduler</code> 인자에 전달합니다.",Ts,H,js,Y,Zs,D,_e='스테이블 diffusion과 같은 diffusion 모델들은 유해한 이미지를 생성할 수도 있습니다. 이를 예방하기 위해 디퓨저스는 생성된 이미지의 유해성을 판단하는 <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">세이프티 체커(safety checker)</a> 기능을 지원하고 있습니다. 만약 세이프티 체커의 사용을 원하지 않는다면, <code>safety_checker</code> 인자에 <code>None</code>을 전달해주시면 됩니다.',bs,L,hs,F,ws,P,Ee="복수의 파이프라인에 동일한 모델이 반복적으로 사용한다면, 굳이 해당 모델의 동일한 가중치를 중복으로 RAM에 불러올 필요는 없을 것입니다.  <code>components</code> 속성을 통해 파이프라인 내부의 컴포넌트들을 참조할 수 있는데, 이번 단락에서는 이를 통해 동일한 모델 가중치를 RAM에 중복으로 불러오는 것을 방지하는 법에 대해 알아보겠습니다.",Is,O,Cs,K,Qe="그 다음 위 예시 코드에서 선언한 <code>components</code> 변수를 다른 파이프라인에 전달함으로써, 모델의 가중치를 중복으로 RAM에 로딩하지 않고, 동일한 컴포넌트를 재사용할 수 있습니다.",Ws,ll,ks,sl,qe="물론 각각의 컴포넌트들을 따로 따로 파이프라인에 전달할 수도 있습니다.  예를 들어 <code>stable_diffusion_txt2img</code> 파이프라인 안의 컴포넌트들 가운데서 세이프티 체커(<code>safety_checker</code>)와 피쳐 익스트랙터(<code>feature_extractor</code>)를 제외한 컴포넌트들만 <code>stable_diffusion_img2img</code> 파이프라인에서 재사용하는 방식 역시 가능합니다.",Vs,el,Gs,tl,vs,nl,Xe="Variant란 일반적으로 다음과 같은 체크포인트들을 의미합니다.",Ns,al,xe="<li><code>torch.float16</code>과 같이 정밀도는 더 낮지만, 용량 역시 더 작은 부동소수점 타입의 가중치를 사용하는 체크포인트. <em>(다만 이와 같은 variant의 경우, 추가적인 훈련과 CPU환경에서의 구동이 불가능합니다.)</em></li> <li>Non-EMA 가중치를 사용하는 체크포인트. <em>(Non-EMA 가중치의 경우, 파인 튜닝 단계에서 사용하는 것이 권장되는데, 추론 단계에선 사용하지 않는 것이 권장됩니다.)</em></li>",$s,T,Se="<p>💡 모델 구조는 동일하지만 서로 다른 학습 환경에서 서로 다른 데이터셋으로 학습된 체크포인트들이 있을 경우, 해당 체크포인트들은 variant 단계가 아닌 리포지토리 단계에서 분리되어 관리되어야 합니다. (즉, 해당 체크포인트들은 서로 다른 리포지토리에서 따로 관리되어야 합니다. 예시: <code>stable-diffusion-v1-4</code>, <code>stable-diffusion-v1-5</code>).</p>",gs,il,Ae="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",Bs,pl,ze="variant를 로드할 때 2개의 중요한 argument가 있습니다.",Rs,ol,He='<li><code>torch_dtype</code>은 불러올 체크포인트의 부동소수점을 정의합니다. 예를 들어 <code>torch_dtype=torch.float16</code>을 명시함으로써 가중치의 부동소수점 타입을 <code>fl16</code>으로 변환할 수 있습니다. (만약 따로 설정하지 않을 경우, 기본값으로 <code>fp32</code> 타입의 가중치가 로딩됩니다.) 또한 <code>variant</code> 인자를 명시하지 않은 채로 체크포인트를 불러온 다음, 해당 체크포인트를 <code>torch_dtype=torch.float16</code> 인자를 통해 <code>fp16</code> 타입으로 변환하는 것 역시 가능합니다. 이 경우 기본으로 설정된 <code>fp32</code> 가중치가 먼저 다운로드되고, 해당 가중치들을 불러온 다음 <code>fp16</code> 타입으로 변환하게 됩니다.</li> <li><code>variant</code> 인자는 리포지토리에서 어떤 variant를 불러올 것인가를 정의합니다. 가령  <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> 리포지토리로부터 <code>non_ema</code> 체크포인트를 불러오고자 한다면, <code>variant=&quot;non_ema&quot;</code> 인자를 전달해야 합니다.</li>',_s,Ml,Es,cl,Ye="다른 부동소수점 타입의 가중치 혹은 non-EMA 가중치를 사용하는 체크포인트를 저장하기 위해서는, <code>DiffusionPipeline.save_pretrained()</code> 메서드를 사용해야 하며, 이 때 <code>variant</code> 인자를 명시해줘야 합니다. 원래의 체크포인트와 동일한 폴더에 variant를 저장해야 하며, 이렇게 하면 동일한 폴더에서 오리지널 체크포인트과 variant를 모두 불러올 수 있습니다.",Qs,ul,qs,dl,De="만약 variant를 기존 폴더에 저장하지 않을 경우, <code>variant</code> 인자를 반드시 명시해야 합니다. 그렇게 하지 않을 경우 원래의 오리지널 체크포인트를 찾을 수 없게 되기 때문에 에러가 발생합니다.",Xs,fl,xs,rl,Ss,yl,Le="모델들은 <code>ModelMixin.from_pretrained()</code> 메서드를 통해 불러올 수 있습니다. 해당 메서드는 최신 버전의 모델 가중치 파일과 설정 파일(configurations)을 다운로드하고 캐싱합니다. 만약 이러한 파일들이 최신 버전으로 로컬 캐시에 저장되어 있다면, <code>ModelMixin.from_pretrained()</code>는 굳이 해당 파일들을 다시 다운로드하지 않으며, 그저 캐시에 있는 최신 파일들을 재사용합니다.",As,ml,Fe='모델은 <code>subfolder</code> 인자에 명시된 하위 폴더로부터 로드됩니다. 예를 들어 <code>stable-diffusion-v1-5/stable-diffusion-v1-5</code>의 UNet 모델의 가중치는 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> 폴더에 저장되어 있습니다.',zs,Jl,Hs,Ul,Pe='혹은 <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">해당 모델의 리포지토리</a>로부터 다이렉트로 가져오는 것 역시 가능합니다.',Ys,Tl,Ds,jl,Oe="또한 앞서 봤던 <code>variant</code> 인자를 명시함으로써, Non-EMA나 <code>fp16</code>의 가중치를 가져오는 것 역시 가능합니다.",Ls,Zl,Fs,bl,Ps,hl,Ke="스케줄러들은 <code>SchedulerMixin.from_pretrained()</code> 메서드를 통해 불러올 수 있습니다. 모델과 달리 스케줄러는 별도의 가중치를 갖지 않으며, 따라서 당연히 별도의 학습과정을 요구하지 않습니다. 이러한 스케줄러들은 (해당 스케줄러 하위폴더의) configration 파일을 통해 정의됩니다.",Os,wl,lt="여러개의 스케줄러를 불러온다고 해서 많은 메모리를 소모하는 것은 아니며, 다양한 스케줄러들에 동일한 스케줄러 configration을  적용하는 것 역시 가능합니다. 다음 예시 코드에서 불러오는 스케줄러들은 모두 <code>StableDiffusionPipeline</code>과 호환되는데, 이는 곧 해당 스케줄러들에 동일한 스케줄러 configration 파일을 적용할 수 있음을 의미합니다.",Ks,Il,le,Cl,se,Wl,st="클래스 메서드로서  <code>DiffusionPipeline.from_pretrained()</code>은 2가지를 담당합니다.",ee,kl,et="<li>첫째로, <code>from_pretrained</code> 메서드는 최신 버전의 파이프라인을 다운로드하고, 캐시에 저장합니다. 이미 로컬 캐시에 최신 버전의 파이프라인이 저장되어 있다면, <code>DiffusionPipeline.from_pretrained()</code>은 해당 파일들을 다시 다운로드하지 않고, 로컬 캐시에 저장되어 있는 파이프라인을 불러옵니다.</li> <li><code>model_index.json</code> 파일을 통해 체크포인트에 대응되는 적합한 파이프라인 클래스로 불러옵니다.</li>",te,Vl,tt='파이프라인의 폴더 구조는 해당 파이프라인 클래스의 구조와 직접적으로 일치합니다. 예를 들어 <code>StableDiffusionPipeline</code> 클래스는 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> 리포지토리와 대응되는 구조를 갖습니다.',ne,Gl,ae,vl,nt="위의 코드 출력 결과를 확인해보면, <code>pipeline</code>은 <code>StableDiffusionPipeline</code>의 인스턴스이며, 다음과 같이 총 7개의 컴포넌트로 구성된다는 것을 알 수 있습니다.",ie,Nl,at='<li><code>&quot;feature_extractor&quot;</code>: <code>CLIPImageProcessor</code>의 인스턴스</li> <li><code>&quot;safety_checker&quot;</code>: 유해한 컨텐츠를 스크리닝하기 위한 <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">컴포넌트</a></li> <li><code>&quot;scheduler&quot;</code>: <code>PNDMScheduler</code>의 인스턴스</li> <li><code>&quot;text_encoder&quot;</code>: <code>CLIPTextModel</code>의 인스턴스</li> <li><code>&quot;tokenizer&quot;</code>: a <code>CLIPTokenizer</code>의 인스턴스</li> <li><code>&quot;unet&quot;</code>: <code>UNet2DConditionModel</code>의 인스턴스</li> <li><code>&quot;vae&quot;</code> <code>AutoencoderKL</code>의 인스턴스</li>',pe,$l,oe,gl,it='파이프라인 인스턴스의 컴포넌트들을  <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>의 폴더 구조와 비교해볼 경우, 각각의 컴포넌트마다 별도의 폴더가 있음을 확인할 수 있습니다.',Me,Bl,ce,Rl,pt="또한 각각의 컴포넌트들을 파이프라인 인스턴스의 속성으로써 참조할 수 있습니다.",ue,_l,de,El,fe,Ql,ot="모든 파이프라인은 <code>model_index.json</code> 파일을 통해 <code>DiffusionPipeline</code>에 다음과 같은 정보를 전달합니다.",re,ql,Mt="<li><code>_class_name</code> 는 어떤 파이프라인 클래스를 사용해야 하는지에 대해 알려줍니다.</li> <li><code>_diffusers_version</code>는 어떤 버전의 디퓨저스로 파이프라인 안의 모델들이 만들어졌는지를 알려줍니다.</li> <li>그 다음은 각각의 컴포넌트들이 어떤 라이브러리의 어떤 클래스로 만들어졌는지에 대해 알려줍니다. (아래 예시에서 <code>&quot;feature_extractor&quot; : [&quot;transformers&quot;, &quot;CLIPImageProcessor&quot;]</code>의 경우, <code>feature_extractor</code> 컴포넌트는 <code>transformers</code> 라이브러리의 <code>CLIPImageProcessor</code> 클래스를 통해 만들어졌다는 것을 의미합니다.)</li>",ye,Xl,me,xl,Je,Al,Ue;return j=new Ut({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new m({props:{title:"파이프라인, 모델, 스케줄러 불러오기",local:"파이프라인-모델-스케줄러-불러오기",headingTag:"h1"}}),C=new m({props:{title:"Diffusion 파이프라인",local:"diffusion-파이프라인",headingTag:"h2"}}),k=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),$=new m({props:{title:"로컬 파이프라인",local:"로컬-파이프라인",headingTag:"h3"}}),B=new y({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),_=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),Q=new m({props:{title:"파이프라인 내부의 컴포넌트 교체하기",local:"파이프라인-내부의-컴포넌트-교체하기",headingTag:"h3"}}),S=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQSUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHNjaGVkdWxlciUzRHNjaGVkdWxlcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler, DPMSolverMultistepScheduler

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>

scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler)`,wrap:!1}}),Y=new m({props:{title:"세이프티 체커",local:"세이프티-체커",headingTag:"h3"}}),L=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>)`,wrap:!1}}),F=new m({props:{title:"컴포넌트 재사용",local:"컴포넌트-재사용",headingTag:"h3"}}),O=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id)

components = stable_diffusion_txt2img.components`,wrap:!1}}),ll=new y({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),el=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),tl=new m({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),Ml=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwbG9hZCUyMGZwMTYlMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMjMlMjBsb2FkJTIwbm9uX2VtYSUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),ul=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEElMjMlMjBzYXZlJTIwYXMlMjBub24tZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),fl=new y({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjAlRjAlOUYlOTElOEQlMjB0aGlzJTIwd29ya3MlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSk=",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
)`,wrap:!1}}),rl=new m({props:{title:"모델 불러오기",local:"모델-불러오기",headingTag:"h3"}}),Jl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),Tl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id)`,wrap:!1}}),Zl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub24tZW1hJTIyKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub24tZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>)`,wrap:!1}}),bl=new m({props:{title:"스케줄러",local:"스케줄러",headingTag:"h3"}}),Il=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFkZHBtJTIwJTNEJTIwRERQTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEFkZGltJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEFwbmRtJTIwJTNEJTIwUE5ETVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEFsbXMlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEFldWxlcl9hbmMlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEFkcG0lMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBJTBBJTIzJTIwcmVwbGFjZSUyMCU2MGRwbSU2MCUyMHdpdGglMjBhbnklMjBvZiUyMCU2MGRkcG0lNjAlMkMlMjAlNjBkZGltJTYwJTJDJTIwJTYwcG5kbSU2MCUyQyUyMCU2MGxtcyU2MCUyQyUyMCU2MGV1bGVyX2FuYyU2MCUyQyUyMCU2MGV1bGVyJTYwJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHNjaGVkdWxlciUzRGRwbSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm)`,wrap:!1}}),Cl=new m({props:{title:"DiffusionPipeline에 대해 알아보기",local:"diffusionpipeline에-대해-알아보기",headingTag:"h3"}}),Gl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),$l=new y({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Bl=new y({props:{code:"LiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGZlYXR1cmVfZXh0cmFjdG9yJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHJlcHJvY2Vzc29yX2NvbmZpZy5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbW9kZWxfaW5kZXguanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNhZmV0eV9jaGVja2VyJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBweXRvcmNoX21vZGVsLmJpbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlciUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlcl9jb25maWcuanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRleHRfZW5jb2RlciUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXIlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtZXJnZXMudHh0JTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB2b2NhYi5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdW5ldCUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuYmluJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwdmFlJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5iaW4=",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.<span class="hljs-keyword">json
</span>├── model_index.<span class="hljs-keyword">json
</span>├── safety_checker
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── <span class="hljs-keyword">scheduler
</span>│   └── <span class="hljs-keyword">scheduler_config.json
</span>├── text_encoder
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.<span class="hljs-keyword">json
</span>│   ├── tokenizer_config.<span class="hljs-keyword">json
</span>│   └── vocab.<span class="hljs-keyword">json
</span>├── unet
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   ├── <span class="hljs-keyword">diffusion_pytorch_model.bin
</span>└── vae
    ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>    ├── <span class="hljs-keyword">diffusion_pytorch_model.bin</span>`,wrap:!1}}),_l=new y({props:{code:"cGlwZWxpbmUudG9rZW5pemVy",highlighted:"pipeline.tokenizer",wrap:!1}}),El=new y({props:{code:"Q0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
)`,wrap:!1}}),Xl=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),xl=new Tt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/loading.md"}}),{c(){J=i("meta"),zl=n(),Sl=i("p"),Hl=n(),M(j.$$.fragment),Yl=n(),M(Z.$$.fragment),Dl=n(),b=i("p"),b.innerHTML=Ze,Ll=n(),h=i("p"),h.innerHTML=be,Fl=n(),w=i("p"),w.textContent=he,Pl=n(),I=i("ul"),I.innerHTML=we,Ol=n(),M(C.$$.fragment),Kl=n(),U=i("blockquote"),U.innerHTML=Ie,ls=n(),W=i("p"),W.innerHTML=Ce,ss=n(),M(k.$$.fragment),es=n(),V=i("p"),V.innerHTML=We,ts=n(),M(G.$$.fragment),ns=n(),v=i("p"),v.innerHTML=ke,as=n(),M(N.$$.fragment),is=n(),M($.$$.fragment),ps=n(),g=i("p"),g.innerHTML=Ve,os=n(),M(B.$$.fragment),Ms=n(),R=i("p"),R.innerHTML=Ge,cs=n(),M(_.$$.fragment),us=n(),E=i("p"),E.innerHTML=ve,ds=n(),M(Q.$$.fragment),fs=n(),q=i("p"),q.textContent=Ne,rs=n(),X=i("ul"),X.innerHTML=$e,ys=n(),x=i("p"),x.innerHTML=ge,ms=n(),M(S.$$.fragment),Js=n(),A=i("p"),A.innerHTML=Be,Us=n(),z=i("p"),z.innerHTML=Re,Ts=n(),M(H.$$.fragment),js=n(),M(Y.$$.fragment),Zs=n(),D=i("p"),D.innerHTML=_e,bs=n(),M(L.$$.fragment),hs=n(),M(F.$$.fragment),ws=n(),P=i("p"),P.innerHTML=Ee,Is=n(),M(O.$$.fragment),Cs=n(),K=i("p"),K.innerHTML=Qe,Ws=n(),M(ll.$$.fragment),ks=n(),sl=i("p"),sl.innerHTML=qe,Vs=n(),M(el.$$.fragment),Gs=n(),M(tl.$$.fragment),vs=n(),nl=i("p"),nl.textContent=Xe,Ns=n(),al=i("ul"),al.innerHTML=xe,$s=n(),T=i("blockquote"),T.innerHTML=Se,gs=n(),il=i("table"),il.innerHTML=Ae,Bs=n(),pl=i("p"),pl.textContent=ze,Rs=n(),ol=i("ul"),ol.innerHTML=He,_s=n(),M(Ml.$$.fragment),Es=n(),cl=i("p"),cl.innerHTML=Ye,Qs=n(),M(ul.$$.fragment),qs=n(),dl=i("p"),dl.innerHTML=De,Xs=n(),M(fl.$$.fragment),xs=n(),M(rl.$$.fragment),Ss=n(),yl=i("p"),yl.innerHTML=Le,As=n(),ml=i("p"),ml.innerHTML=Fe,zs=n(),M(Jl.$$.fragment),Hs=n(),Ul=i("p"),Ul.innerHTML=Pe,Ys=n(),M(Tl.$$.fragment),Ds=n(),jl=i("p"),jl.innerHTML=Oe,Ls=n(),M(Zl.$$.fragment),Fs=n(),M(bl.$$.fragment),Ps=n(),hl=i("p"),hl.innerHTML=Ke,Os=n(),wl=i("p"),wl.innerHTML=lt,Ks=n(),M(Il.$$.fragment),le=n(),M(Cl.$$.fragment),se=n(),Wl=i("p"),Wl.innerHTML=st,ee=n(),kl=i("ul"),kl.innerHTML=et,te=n(),Vl=i("p"),Vl.innerHTML=tt,ne=n(),M(Gl.$$.fragment),ae=n(),vl=i("p"),vl.innerHTML=nt,ie=n(),Nl=i("ul"),Nl.innerHTML=at,pe=n(),M($l.$$.fragment),oe=n(),gl=i("p"),gl.innerHTML=it,Me=n(),M(Bl.$$.fragment),ce=n(),Rl=i("p"),Rl.textContent=pt,ue=n(),M(_l.$$.fragment),de=n(),M(El.$$.fragment),fe=n(),Ql=i("p"),Ql.innerHTML=ot,re=n(),ql=i("ul"),ql.innerHTML=Mt,ye=n(),M(Xl.$$.fragment),me=n(),M(xl.$$.fragment),Je=n(),Al=i("p"),this.h()},l(l){const s=mt("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(e),zl=a(l),Sl=p(l,"P",{}),ct(Sl).forEach(e),Hl=a(l),c(j.$$.fragment,l),Yl=a(l),c(Z.$$.fragment,l),Dl=a(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1iglxvj"&&(b.innerHTML=Ze),Ll=a(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-sykc41"&&(h.innerHTML=be),Fl=a(l),w=p(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1qc8l60"&&(w.textContent=he),Pl=a(l),I=p(l,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1wwzf1i"&&(I.innerHTML=we),Ol=a(l),c(C.$$.fragment,l),Kl=a(l),U=p(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-e56hur"&&(U.innerHTML=Ie),ls=a(l),W=p(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1mpandj"&&(W.innerHTML=Ce),ss=a(l),c(k.$$.fragment,l),es=a(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-y0yakz"&&(V.innerHTML=We),ts=a(l),c(G.$$.fragment,l),ns=a(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-g3awyc"&&(v.innerHTML=ke),as=a(l),c(N.$$.fragment,l),is=a(l),c($.$$.fragment,l),ps=a(l),g=p(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-as0lxn"&&(g.innerHTML=Ve),os=a(l),c(B.$$.fragment,l),Ms=a(l),R=p(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1h76dl8"&&(R.innerHTML=Ge),cs=a(l),c(_.$$.fragment,l),us=a(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-tfqrd7"&&(E.innerHTML=ve),ds=a(l),c(Q.$$.fragment,l),fs=a(l),q=p(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-ev6drw"&&(q.textContent=Ne),rs=a(l),X=p(l,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-82p6pl"&&(X.innerHTML=$e),ys=a(l),x=p(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1pepgag"&&(x.innerHTML=ge),ms=a(l),c(S.$$.fragment,l),Js=a(l),A=p(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1shig3c"&&(A.innerHTML=Be),Us=a(l),z=p(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1lidbe0"&&(z.innerHTML=Re),Ts=a(l),c(H.$$.fragment,l),js=a(l),c(Y.$$.fragment,l),Zs=a(l),D=p(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1n7a5c5"&&(D.innerHTML=_e),bs=a(l),c(L.$$.fragment,l),hs=a(l),c(F.$$.fragment,l),ws=a(l),P=p(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1dfvcjh"&&(P.innerHTML=Ee),Is=a(l),c(O.$$.fragment,l),Cs=a(l),K=p(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1scbzg6"&&(K.innerHTML=Qe),Ws=a(l),c(ll.$$.fragment,l),ks=a(l),sl=p(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-nhbv2z"&&(sl.innerHTML=qe),Vs=a(l),c(el.$$.fragment,l),Gs=a(l),c(tl.$$.fragment,l),vs=a(l),nl=p(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-1k13zzw"&&(nl.textContent=Xe),Ns=a(l),al=p(l,"UL",{"data-svelte-h":!0}),o(al)!=="svelte-1fqsbsa"&&(al.innerHTML=xe),$s=a(l),T=p(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-apxf5j"&&(T.innerHTML=Se),gs=a(l),il=p(l,"TABLE",{"data-svelte-h":!0}),o(il)!=="svelte-1e3wdtx"&&(il.innerHTML=Ae),Bs=a(l),pl=p(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-ca126c"&&(pl.textContent=ze),Rs=a(l),ol=p(l,"UL",{"data-svelte-h":!0}),o(ol)!=="svelte-1w04sbb"&&(ol.innerHTML=He),_s=a(l),c(Ml.$$.fragment,l),Es=a(l),cl=p(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-tbk23x"&&(cl.innerHTML=Ye),Qs=a(l),c(ul.$$.fragment,l),qs=a(l),dl=p(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-16u45h8"&&(dl.innerHTML=De),Xs=a(l),c(fl.$$.fragment,l),xs=a(l),c(rl.$$.fragment,l),Ss=a(l),yl=p(l,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-113i68p"&&(yl.innerHTML=Le),As=a(l),ml=p(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1n538s7"&&(ml.innerHTML=Fe),zs=a(l),c(Jl.$$.fragment,l),Hs=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-b6xx87"&&(Ul.innerHTML=Pe),Ys=a(l),c(Tl.$$.fragment,l),Ds=a(l),jl=p(l,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-16vh3vr"&&(jl.innerHTML=Oe),Ls=a(l),c(Zl.$$.fragment,l),Fs=a(l),c(bl.$$.fragment,l),Ps=a(l),hl=p(l,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-chn043"&&(hl.innerHTML=Ke),Os=a(l),wl=p(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-1m0or8s"&&(wl.innerHTML=lt),Ks=a(l),c(Il.$$.fragment,l),le=a(l),c(Cl.$$.fragment,l),se=a(l),Wl=p(l,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-1afe7fa"&&(Wl.innerHTML=st),ee=a(l),kl=p(l,"UL",{"data-svelte-h":!0}),o(kl)!=="svelte-1nokmbb"&&(kl.innerHTML=et),te=a(l),Vl=p(l,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-5cs5s"&&(Vl.innerHTML=tt),ne=a(l),c(Gl.$$.fragment,l),ae=a(l),vl=p(l,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-12sqgdm"&&(vl.innerHTML=nt),ie=a(l),Nl=p(l,"UL",{"data-svelte-h":!0}),o(Nl)!=="svelte-1guvx6v"&&(Nl.innerHTML=at),pe=a(l),c($l.$$.fragment,l),oe=a(l),gl=p(l,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-a7ioqv"&&(gl.innerHTML=it),Me=a(l),c(Bl.$$.fragment,l),ce=a(l),Rl=p(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-hkob1v"&&(Rl.textContent=pt),ue=a(l),c(_l.$$.fragment,l),de=a(l),c(El.$$.fragment,l),fe=a(l),Ql=p(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-md3cg7"&&(Ql.innerHTML=ot),re=a(l),ql=p(l,"UL",{"data-svelte-h":!0}),o(ql)!=="svelte-1ezuhwq"&&(ql.innerHTML=Mt),ye=a(l),c(Xl.$$.fragment,l),me=a(l),c(xl.$$.fragment,l),Je=a(l),Al=p(l,"P",{}),ct(Al).forEach(e),this.h()},h(){Te(J,"name","hf:doc:metadata"),Te(J,"content",Zt),Te(U,"class","tip"),Te(T,"class","tip")},m(l,s){Jt(document.head,J),t(l,zl,s),t(l,Sl,s),t(l,Hl,s),u(j,l,s),t(l,Yl,s),u(Z,l,s),t(l,Dl,s),t(l,b,s),t(l,Ll,s),t(l,h,s),t(l,Fl,s),t(l,w,s),t(l,Pl,s),t(l,I,s),t(l,Ol,s),u(C,l,s),t(l,Kl,s),t(l,U,s),t(l,ls,s),t(l,W,s),t(l,ss,s),u(k,l,s),t(l,es,s),t(l,V,s),t(l,ts,s),u(G,l,s),t(l,ns,s),t(l,v,s),t(l,as,s),u(N,l,s),t(l,is,s),u($,l,s),t(l,ps,s),t(l,g,s),t(l,os,s),u(B,l,s),t(l,Ms,s),t(l,R,s),t(l,cs,s),u(_,l,s),t(l,us,s),t(l,E,s),t(l,ds,s),u(Q,l,s),t(l,fs,s),t(l,q,s),t(l,rs,s),t(l,X,s),t(l,ys,s),t(l,x,s),t(l,ms,s),u(S,l,s),t(l,Js,s),t(l,A,s),t(l,Us,s),t(l,z,s),t(l,Ts,s),u(H,l,s),t(l,js,s),u(Y,l,s),t(l,Zs,s),t(l,D,s),t(l,bs,s),u(L,l,s),t(l,hs,s),u(F,l,s),t(l,ws,s),t(l,P,s),t(l,Is,s),u(O,l,s),t(l,Cs,s),t(l,K,s),t(l,Ws,s),u(ll,l,s),t(l,ks,s),t(l,sl,s),t(l,Vs,s),u(el,l,s),t(l,Gs,s),u(tl,l,s),t(l,vs,s),t(l,nl,s),t(l,Ns,s),t(l,al,s),t(l,$s,s),t(l,T,s),t(l,gs,s),t(l,il,s),t(l,Bs,s),t(l,pl,s),t(l,Rs,s),t(l,ol,s),t(l,_s,s),u(Ml,l,s),t(l,Es,s),t(l,cl,s),t(l,Qs,s),u(ul,l,s),t(l,qs,s),t(l,dl,s),t(l,Xs,s),u(fl,l,s),t(l,xs,s),u(rl,l,s),t(l,Ss,s),t(l,yl,s),t(l,As,s),t(l,ml,s),t(l,zs,s),u(Jl,l,s),t(l,Hs,s),t(l,Ul,s),t(l,Ys,s),u(Tl,l,s),t(l,Ds,s),t(l,jl,s),t(l,Ls,s),u(Zl,l,s),t(l,Fs,s),u(bl,l,s),t(l,Ps,s),t(l,hl,s),t(l,Os,s),t(l,wl,s),t(l,Ks,s),u(Il,l,s),t(l,le,s),u(Cl,l,s),t(l,se,s),t(l,Wl,s),t(l,ee,s),t(l,kl,s),t(l,te,s),t(l,Vl,s),t(l,ne,s),u(Gl,l,s),t(l,ae,s),t(l,vl,s),t(l,ie,s),t(l,Nl,s),t(l,pe,s),u($l,l,s),t(l,oe,s),t(l,gl,s),t(l,Me,s),u(Bl,l,s),t(l,ce,s),t(l,Rl,s),t(l,ue,s),u(_l,l,s),t(l,de,s),u(El,l,s),t(l,fe,s),t(l,Ql,s),t(l,re,s),t(l,ql,s),t(l,ye,s),u(Xl,l,s),t(l,me,s),u(xl,l,s),t(l,Je,s),t(l,Al,s),Ue=!0},p:dt,i(l){Ue||(d(j.$$.fragment,l),d(Z.$$.fragment,l),d(C.$$.fragment,l),d(k.$$.fragment,l),d(G.$$.fragment,l),d(N.$$.fragment,l),d($.$$.fragment,l),d(B.$$.fragment,l),d(_.$$.fragment,l),d(Q.$$.fragment,l),d(S.$$.fragment,l),d(H.$$.fragment,l),d(Y.$$.fragment,l),d(L.$$.fragment,l),d(F.$$.fragment,l),d(O.$$.fragment,l),d(ll.$$.fragment,l),d(el.$$.fragment,l),d(tl.$$.fragment,l),d(Ml.$$.fragment,l),d(ul.$$.fragment,l),d(fl.$$.fragment,l),d(rl.$$.fragment,l),d(Jl.$$.fragment,l),d(Tl.$$.fragment,l),d(Zl.$$.fragment,l),d(bl.$$.fragment,l),d(Il.$$.fragment,l),d(Cl.$$.fragment,l),d(Gl.$$.fragment,l),d($l.$$.fragment,l),d(Bl.$$.fragment,l),d(_l.$$.fragment,l),d(El.$$.fragment,l),d(Xl.$$.fragment,l),d(xl.$$.fragment,l),Ue=!0)},o(l){f(j.$$.fragment,l),f(Z.$$.fragment,l),f(C.$$.fragment,l),f(k.$$.fragment,l),f(G.$$.fragment,l),f(N.$$.fragment,l),f($.$$.fragment,l),f(B.$$.fragment,l),f(_.$$.fragment,l),f(Q.$$.fragment,l),f(S.$$.fragment,l),f(H.$$.fragment,l),f(Y.$$.fragment,l),f(L.$$.fragment,l),f(F.$$.fragment,l),f(O.$$.fragment,l),f(ll.$$.fragment,l),f(el.$$.fragment,l),f(tl.$$.fragment,l),f(Ml.$$.fragment,l),f(ul.$$.fragment,l),f(fl.$$.fragment,l),f(rl.$$.fragment,l),f(Jl.$$.fragment,l),f(Tl.$$.fragment,l),f(Zl.$$.fragment,l),f(bl.$$.fragment,l),f(Il.$$.fragment,l),f(Cl.$$.fragment,l),f(Gl.$$.fragment,l),f($l.$$.fragment,l),f(Bl.$$.fragment,l),f(_l.$$.fragment,l),f(El.$$.fragment,l),f(Xl.$$.fragment,l),f(xl.$$.fragment,l),Ue=!1},d(l){l&&(e(zl),e(Sl),e(Hl),e(Yl),e(Dl),e(b),e(Ll),e(h),e(Fl),e(w),e(Pl),e(I),e(Ol),e(Kl),e(U),e(ls),e(W),e(ss),e(es),e(V),e(ts),e(ns),e(v),e(as),e(is),e(ps),e(g),e(os),e(Ms),e(R),e(cs),e(us),e(E),e(ds),e(fs),e(q),e(rs),e(X),e(ys),e(x),e(ms),e(Js),e(A),e(Us),e(z),e(Ts),e(js),e(Zs),e(D),e(bs),e(hs),e(ws),e(P),e(Is),e(Cs),e(K),e(Ws),e(ks),e(sl),e(Vs),e(Gs),e(vs),e(nl),e(Ns),e(al),e($s),e(T),e(gs),e(il),e(Bs),e(pl),e(Rs),e(ol),e(_s),e(Es),e(cl),e(Qs),e(qs),e(dl),e(Xs),e(xs),e(Ss),e(yl),e(As),e(ml),e(zs),e(Hs),e(Ul),e(Ys),e(Ds),e(jl),e(Ls),e(Fs),e(Ps),e(hl),e(Os),e(wl),e(Ks),e(le),e(se),e(Wl),e(ee),e(kl),e(te),e(Vl),e(ne),e(ae),e(vl),e(ie),e(Nl),e(pe),e(oe),e(gl),e(Me),e(ce),e(Rl),e(ue),e(de),e(fe),e(Ql),e(re),e(ql),e(ye),e(me),e(Je),e(Al)),e(J),r(j,l),r(Z,l),r(C,l),r(k,l),r(G,l),r(N,l),r($,l),r(B,l),r(_,l),r(Q,l),r(S,l),r(H,l),r(Y,l),r(L,l),r(F,l),r(O,l),r(ll,l),r(el,l),r(tl,l),r(Ml,l),r(ul,l),r(fl,l),r(rl,l),r(Jl,l),r(Tl,l),r(Zl,l),r(bl,l),r(Il,l),r(Cl,l),r(Gl,l),r($l,l),r(Bl,l),r(_l,l),r(El,l),r(Xl,l),r(xl,l)}}}const Zt='{"title":"파이프라인, 모델, 스케줄러 불러오기","local":"파이프라인-모델-스케줄러-불러오기","sections":[{"title":"Diffusion 파이프라인","local":"diffusion-파이프라인","sections":[{"title":"로컬 파이프라인","local":"로컬-파이프라인","sections":[],"depth":3},{"title":"파이프라인 내부의 컴포넌트 교체하기","local":"파이프라인-내부의-컴포넌트-교체하기","sections":[],"depth":3},{"title":"세이프티 체커","local":"세이프티-체커","sections":[],"depth":3},{"title":"컴포넌트 재사용","local":"컴포넌트-재사용","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[{"title":"모델 불러오기","local":"모델-불러오기","sections":[],"depth":3},{"title":"스케줄러","local":"스케줄러","sections":[],"depth":3},{"title":"DiffusionPipeline에 대해 알아보기","local":"diffusionpipeline에-대해-알아보기","sections":[],"depth":3}],"depth":2}],"depth":1}';function bt(je){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends rt{constructor(J){super(),yt(this,J,bt,jt,ut,{})}}export{Wt as component};
