import{s as zi,o as Ui,n as Vi}from"../chunks/scheduler.7da89386.js";import{S as ki,i as Wi,g as o,s as n,r as d,A as ji,h as s,f as i,c as l,j as Ci,u as p,x as r,k as Ji,y as Zi,a,v as c,d as m,t as u,w as b}from"../chunks/index.20910acc.js";import{T as qi}from"../chunks/Tip.53e22153.js";import{C as f}from"../chunks/CodeBlock.143bd81e.js";import{H as y}from"../chunks/getInferenceSnippets.6a415d4d.js";function Ii(kt){let g,v="If quantization_config is not provided, model will be exported in 8 bits by default when it has more than 1 billion parameters. You can disable it with <code>load_in_8bit=False</code>.";return{c(){g=o("p"),g.innerHTML=v},l(h){g=s(h,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1g2mh0l"&&(g.innerHTML=v)},m(h,Ut){a(h,g,Ut)},p:Vi,d(h){h&&i(g)}}}function Qi(kt){let g,v,h,Ut,w,Wt,T,Be='🤗 Optimum Intel provides an <code>openvino</code> package that enables you to apply a variety of model quantization methods on many models hosted on the 🤗 hub using the <a href="https://docs.openvino.ai/2024/openvino-workflow/model-optimization.html" rel="nofollow">NNCF</a> framework.',jt,x,Xe="Quantization is a technique to reduce the computational and memory costs of running inference by representing the weights and / or the activations with lower precision data types like 8-bit or 4-bit.",Zt,_,qt,C,Ge="Click on a ✅ to copy the command/code for the corresponding optimization case.",It,J,Le='<thead><tr><th rowspan="3">Task<br/>(OV Model Class)</th> <th colspan="4">Weight-only Quantization</th> <th colspan="2" rowspan="2">Hybrid Quantization</th> <th colspan="2" rowspan="2">Full Quantization</th> <th colspan="2" rowspan="2">Mixed Quantization</th></tr> <tr><th colspan="2">Data-free</th> <th colspan="2">Data-aware</th></tr> <tr><th>CLI</th> <th>Python</th> <th>CLI</th> <th>Python</th> <th>CLI</th> <th>Python</th> <th>CLI</th> <th>Python</th> <th>CLI</th> <th>Python</th></tr></thead> <tbody><tr><td style="text-align: center; vertical-align: middle;">text-generation<br/>(OVModelForCausalLM)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m TinyLlama/TinyLlama-1.1B-Chat-v1.0 --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForCausalLM.from_pretrained(&#39;TinyLlama/TinyLlama-1.1B-Chat-v1.0&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m TinyLlama/TinyLlama-1.1B-Chat-v1.0 --weight-format int4 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForCausalLM.from_pretrained(&#39;TinyLlama/TinyLlama-1.1B-Chat-v1.0&#39;, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">-</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m TinyLlama/TinyLlama-1.1B-Chat-v1.0 --quant-mode int8 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForCausalLM.from_pretrained(&#39;TinyLlama/TinyLlama-1.1B-Chat-v1.0&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m TinyLlama/TinyLlama-1.1B-Chat-v1.0 --quant-mode nf4_f8e4m3 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForCausalLM.from_pretrained(&#39;TinyLlama/TinyLlama-1.1B-Chat-v1.0&#39;, quantization_config=OVMixedQuantizationConfig(OVWeightQuantizationConfig(bits=4, dtype=&#39;nf4&#39;), OVQuantizationConfig(dtype=&#39;f8e4m3&#39;, dataset=&#39;wikitext2&#39;))).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td></tr> <tr><td style="text-align: center; vertical-align: middle;">image-text-to-text<br/>(OVModelForVisualCausalLM)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --task image-text-to-text -m OpenGVLab/InternVL2-1B --trust-remote-code --weight-format int4 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForVisualCausalLM.from_pretrained(&#39;OpenGVLab/InternVL2-1B&#39;, trust_remote_code=True, quantization_config=OVWeightQuantizationConfig(bits=4)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --task image-text-to-text -m OpenGVLab/InternVL2-1B --trust-remote-code --weight-format int4 --dataset contextual ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForVisualCausalLM.from_pretrained(&#39;OpenGVLab/InternVL2-1B&#39;, trust_remote_code=True, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;contextual&#39;, trust_remote_code=True)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --task image-text-to-text -m OpenGVLab/InternVL2-1B --trust-remote-code --quant-mode int8 --dataset contextual ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForVisualCausalLM.from_pretrained(&#39;OpenGVLab/InternVL2-1B&#39;, trust_remote_code=True, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;contextual&#39;, trust_remote_code=True)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td></tr> <tr><td style="text-align: center; vertical-align: middle;">text-to-image<br/>(OVStableDiffusionPipeline)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m dreamlike-art/dreamlike-anime-1.0 --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVStableDiffusionPipeline.from_pretrained(&#39;dreamlike-art/dreamlike-anime-1.0&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m dreamlike-art/dreamlike-anime-1.0 --weight-format int8 --dataset conceptual_captions ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVStableDiffusionPipeline.from_pretrained(&#39;dreamlike-art/dreamlike-anime-1.0&#39;, quantization_config=OVWeightQuantizationConfig(bits=8, quant_method=&#39;hybrid&#39;, dataset=&#39;conceptual_captions&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m dreamlike-art/dreamlike-anime-1.0 --quant-mode int8 --dataset conceptual_captions ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVStableDiffusionPipeline.from_pretrained(&#39;dreamlike-art/dreamlike-anime-1.0&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;conceptual_captions&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td></tr> <tr><td style="text-align: center; vertical-align: middle;">automatic-speech-recognition<br/>(OVModelForSpeechSeq2Seq)</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m openai/whisper-large-v3-turbo --quant-mode int8 --dataset librispeech --num-samples 10 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForSpeechSeq2Seq.from_pretrained(&#39;openai/whisper-large-v3-turbo&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;librispeech&#39;, num_samples=10)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">–</td></tr> <tr><td style="text-align: center; vertical-align: middle;">feature-extraction<br/>(OVModelForFeatureExtraction)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m microsoft/codebert-base --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForFeatureExtraction.from_pretrained(&#39;microsoft/codebert-base&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m microsoft/codebert-base --weight-format int4 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForFeatureExtraction.from_pretrained(&#39;microsoft/codebert-base&#39;, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">-</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m microsoft/codebert-base --quant-mode int8 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForFeatureExtraction.from_pretrained(&#39;microsoft/codebert-base&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m microsoft/codebert-base --quant-mode nf4_f8e4m3 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForFeatureExtraction.from_pretrained(&#39;microsoft/codebert-base&#39;, quantization_config=OVMixedQuantizationConfig(OVWeightQuantizationConfig(bits=4, dtype=&#39;nf4&#39;), OVQuantizationConfig(dtype=&#39;f8e4m3&#39;, dataset=&#39;wikitext2&#39;))).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td></tr> <tr><td style="text-align: center; vertical-align: middle;">feature-extraction<br/>(OVSentenceTransformer)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --library sentence_transformers -m sentence-transformers/all-mpnet-base-v2 --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVSentenceTransformer.from_pretrained(&#39;sentence-transformers/all-mpnet-base-v2&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --library sentence_transformers -m sentence-transformers/all-mpnet-base-v2 --weight-format int4 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVSentenceTransformer.from_pretrained(&#39;sentence-transformers/all-mpnet-base-v2&#39;, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">-</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --library sentence_transformers -m sentence-transformers/all-mpnet-base-v2 --quant-mode int8 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVSentenceTransformer.from_pretrained(&#39;sentence-transformers/all-mpnet-base-v2&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino --library sentence_transformers -m sentence-transformers/all-mpnet-base-v2 --quant-mode nf4_f8e4m3 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVSentenceTransformer.from_pretrained(&#39;sentence-transformers/all-mpnet-base-v2&#39;, quantization_config=OVMixedQuantizationConfig(OVWeightQuantizationConfig(bits=4, dtype=&#39;nf4&#39;), OVQuantizationConfig(dtype=&#39;f8e4m3&#39;, dataset=&#39;wikitext2&#39;))).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td></tr> <tr><td style="text-align: center; vertical-align: middle;">fill-mask<br/>(OVModelForMaskedLM)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m FacebookAI/roberta-base --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForMaskedLM.from_pretrained(&#39;FacebookAI/roberta-base&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m FacebookAI/roberta-base --weight-format int4 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForMaskedLM.from_pretrained(&#39;FacebookAI/roberta-base&#39;, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">-</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m FacebookAI/roberta-base --quant-mode int8 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForMaskedLM.from_pretrained(&#39;FacebookAI/roberta-base&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;wikitext2&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m FacebookAI/roberta-base --quant-mode nf4_f8e4m3 --dataset wikitext2 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForMaskedLM.from_pretrained(&#39;FacebookAI/roberta-base&#39;, quantization_config=OVMixedQuantizationConfig(OVWeightQuantizationConfig(bits=4, dtype=&#39;nf4&#39;), OVQuantizationConfig(dtype=&#39;f8e4m3&#39;, dataset=&#39;wikitext2&#39;))).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td></tr> <tr><td style="text-align: center; vertical-align: middle;">zero-shot-image-classification<br/>(OVModelForZeroShotImageClassification)</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m openai/clip-vit-base-patch16 --weight-format int8 ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForZeroShotImageClassification.from_pretrained(&#39;openai/clip-vit-base-patch16&#39;, quantization_config=OVWeightQuantizationConfig(bits=8)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m openai/clip-vit-base-patch16 --weight-format int4 --dataset conceptual_captions ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForZeroShotImageClassification.from_pretrained(&#39;openai/clip-vit-base-patch16&#39;, quantization_config=OVWeightQuantizationConfig(bits=4, dataset=&#39;conceptual_captions&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;">–</td> <td style="text-align: center; vertical-align: middle;">-</td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m openai/clip-vit-base-patch16 --quant-mode int8 --dataset conceptual_captions ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForZeroShotImageClassification.from_pretrained(&#39;openai/clip-vit-base-patch16&#39;, quantization_config=OVQuantizationConfig(bits=8, dataset=&#39;conceptual_captions&#39;)).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;optimum-cli export openvino -m openai/clip-vit-base-patch16 --quant-mode nf4_f8e4m3 --dataset conceptual_captions ./save_dir&#39;)">✅</button></td> <td style="text-align: center; vertical-align: middle;"><button onclick="navigator.clipboard.writeText(&#39;OVModelForZeroShotImageClassification.from_pretrained(&#39;openai/clip-vit-base-patch16&#39;, quantization_config=OVMixedQuantizationConfig(OVWeightQuantizationConfig(bits=4, dtype=&#39;nf4&#39;), OVQuantizationConfig(dtype=&#39;f8e4m3&#39;, dataset=&#39;conceptual_captions&#39;))).save_pretrained(&#39;save_dir&#39;)&#39;)">✅</button></td></tr></tbody>',Qt,z,$t,U,Oe="Quantization can be applied on the model’s Linear, Convolutional and Embedding layers, enabling the loading of large models on memory-limited devices. For example, when applying 8-bit quantization, the resulting model will be x4 smaller than its fp32 counterpart. For 4-bit quantization, the reduction in memory could theoretically reach x8, but is closer to x6 in practice.",Ft,V,Rt,k,Ee="For the 8-bit weight quantization you can provide <code>quantization_config</code> equal to <code>OVWeightQuantizationConfig(bits=8)</code> to load your model’s weights in 8-bit:",Bt,W,Xt,j,He="Weights of language models inside vision-language pipelines can be quantized in a similar way:",Gt,Z,Lt,M,Ot,q,Et,I,Ye="4-bit weight quantization can be achieved in a similar way:",Ht,Q,Yt,$,Se="Or for vision-language pipelines:",St,F,Nt,R,Ne="You can tune quantization parameters to achieve a better performance accuracy trade-off as follows:",At,B,Pt,X,Ae="Note: <code>OVWeightQuantizationConfig</code> also accepts keyword arguments that are not listed in its constructor. In this case such arguments will be passed directly to <code>nncf.compress_weights()</code> call. This is useful for passing additional parameters to the quantization algorithm.",Dt,G,Pe='By default the quantization scheme will be <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/training_time_compression/other_algorithms/LegacyQuantization.md#asymmetric-quantization" rel="nofollow">asymmetric</a>, to make it <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/training_time_compression/other_algorithms/LegacyQuantization.md#symmetric-quantization" rel="nofollow">symmetric</a> you can add <code>sym=True</code>.',Kt,L,De="For 4-bit quantization you can also specify the following arguments in the quantization configuration :",te,O,Ke="<li>The <code>group_size</code> parameter will define the group size to use for quantization, <code>-1</code> it will results in per-column quantization.</li> <li>The <code>ratio</code> parameter controls the ratio between 4-bit and 8-bit quantization. If set to 0.9, it means that 90% of the layers will be quantized to <code>int4</code> while 10% will be quantized to <code>int8</code>.</li>",ee,E,ti="Smaller <code>group_size</code> and <code>ratio</code> values usually improve accuracy at the sacrifice of the model size and inference latency.",ie,H,ei="Quality of 4-bit weight compressed model can further be improved by employing one of the following data-dependent methods:",ae,Y,ii="<li><strong>AWQ</strong> which stands for Activation Aware Quantization is an algorithm that tunes model weights for more accurate 4-bit compression. It slightly improves generation quality of compressed LLMs, but requires significant additional time and memory for tuning weights on a calibration dataset. Please note that it is possible that there will be no matching patterns in the model to apply AWQ, in such case it will be skipped. There is also a data-free version of AWQ available that relies on per-column magnitudes of weights instead of activations.</li> <li><strong>Scale Estimation</strong> is a method that tunes quantization scales to minimize the <code>L2</code> error between the original and compressed layers. Providing a dataset is required to run scale estimation. Using this method also incurs additional time and memory overhead.</li> <li><strong>GPTQ</strong> optimizes compressed weights in a layer-wise fashion to minimize the difference between activations of a compressed and original layer.</li> <li><strong>LoRA Correction</strong> mitigates quantization noise introduced during weight compression by leveraging low-rank adaptation.</li>",ne,S,ai="Data-aware algorithms can be applied together or separately. For that, provide corresponding arguments to the 4-bit <code>OVWeightQuantizationConfig</code> together with a dataset. For example:",le,N,oe,A,ni="Note: GPTQ and LoRA Correction algorithms can’t be applied simultaneously.",se,P,re,D,li=`When applying post-training full quantization, both the weights and the activations are quantized.
To apply quantization on the activations, an additional calibration step is needed which consists in feeding a <code>calibration_dataset</code> to the network in order to estimate the quantization activations parameters.`,de,K,oi="Here is how to apply full quantization on a fine-tuned DistilBERT given your own <code>calibration_dataset</code>:",pe,tt,ce,et,si="The calibration dataset can also be created easily using your <code>OVQuantizer</code>:",me,it,ue,at,ri="The <code>quantize()</code> method applies post-training quantization and export the resulting quantized model to the OpenVINO Intermediate Representation (IR). The resulting graph is represented with two files: an XML file describing the network topology and a binary file describing the weights. The resulting model can be run on any target Intel device.",be,nt,ge,lt,di="The speech-to-text Whisper model can be quantized without the need for preparing a custom calibration dataset. Please see example below.",fe,ot,he,st,pi="With this, encoder, decoder and decoder-with-past models of the Whisper pipeline will be fully quantized, including activations.",ye,rt,Me,dt,ci=`Traditional optimization methods like post-training 8-bit quantization do not work well for Stable Diffusion (SD) models and can lead to poor generation results. On the other hand, weight compression does not improve performance significantly when applied to Stable Diffusion models, as the size of activations is comparable to weights.
The U-Net component takes up most of the overall execution time of the pipeline. Thus, optimizing just this one component can bring substantial benefits in terms of inference speed while keeping acceptable accuracy without fine-tuning. Quantizing the rest of the diffusion pipeline does not significantly improve inference performance but could potentially lead to substantial accuracy degradation.
Therefore, the proposal is to apply quantization in <em>hybrid mode</em> for the U-Net model and weight-only quantization for the rest of the pipeline components :`,ve,pt,mi="<li>U-Net : quantization applied on both the weights and activations</li> <li>The text encoder, VAE encoder / decoder : quantization applied on the weights</li>",we,ct,ui="The hybrid mode involves the quantization of weights in MatMul and Embedding layers, and activations of other layers, facilitating accuracy preservation post-optimization while reducing the model size.",Te,mt,bi="The <code>quantization_config</code> is utilized to define optimization parameters for optimizing the SD pipeline. To enable hybrid quantization, specify the quantization dataset in the <code>quantization_config</code>. If the dataset is not defined, weight-only quantization will be applied on all components.",xe,ut,_e,bt,gi='For more details, please refer to the corresponding NNCF <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/post_training_compression/weights_compression/Usage.md" rel="nofollow">documentation</a>.',Ce,gt,Je,ft,fi="Mixed quantization is a technique that combines weight-only quantization with full quantization. During mixed quantization we separately quantize:",ze,ht,hi="<li>weights of weighted layers to one precision, and</li> <li>activations (and possibly, weights, if some were skipped at the first step) of other supported layers to another precision.</li>",Ue,yt,yi="By default, weights of all weighted layers are quantized in the first step. In the second step activations of weighted and non-weighted layers are quantized. If some layers are instructed to be ignored in the first step with <code>weight_quantization_config.ignored_scope</code> parameter, both weights and activations of these layers are quantized to the precision given in the <code>full_quantization_config</code>.",Ve,Mt,Mi="When running this kind of optimization through Python API, <code>OVMixedQuantizationConfig</code> should be used. In such case the precision for the first step should be provided with <code>weight_quantization_config</code> argument and the precision for the second step with <code>full_quantization_config</code> argument. For example:",ke,vt,We,wt,vi="To apply mixed quantization through CLI, the <code>--quant-mode</code> argument should be used. For example:",je,Tt,Ze,xt,wi="Don’t forget to provide a dataset since it is required for the calibration procedure during full quantization.",qe,_t,Ie,Ct,Ti="There are multimodal pipelines that consist of multiple components, such as Stable Diffusion or Visual Language models. In these cases, there may be a need to apply different quantization methods to different components of the pipeline. For example, you may want to apply int4 data-aware weight-only quantization to a language model in visual-language pipeline, while applying int8 weight-only quantization to other components. In this case you can use the <code>OVPipelineQuantizationConfig</code> class to specify the quantization configuration for each component of the pipeline.",Qe,Jt,xi="For example, the code below quantizes weights and activations of a language model inside InternVL2-1B, compresses weights of a text embedding model and skips any quantization for vision embedding model.",$e,zt,Fe,Vt,Re;return w=new y({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_=new y({props:{title:"Optimization Support Matrix",local:"optimization-support-matrix",headingTag:"h2"}}),z=new y({props:{title:"Weight-only Quantization",local:"weight-only-quantization",headingTag:"h2"}}),V=new y({props:{title:"8-bit",local:"8-bit",headingTag:"h3"}}),W=new f({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yQ2F1c2FsTE0lMkMlMjBPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyaGVsZW5haSUyRmdwdDItb3YlMjIlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwT1ZXZWlnaHRRdWFudGl6YXRpb25Db25maWcoYml0cyUzRDgpJTBBbW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBJTBBJTIzJTIwU2F2ZXMlMjB0aGUlMjBpbnQ4JTIwbW9kZWwlMjB0aGF0JTIwd2lsbCUyMGJlJTIweDQlMjBzbWFsbGVyJTIwdGhhbiUyMGl0cyUyMGZwMzIlMjBjb3VudGVycGFydCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZChzYXZpbmdfZGlyZWN0b3J5KQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForCausalLM, OVWeightQuantizationConfig

model_id = <span class="hljs-string">&quot;helenai/gpt2-ov&quot;</span>
quantization_config = OVWeightQuantizationConfig(bits=<span class="hljs-number">8</span>)
model = OVModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)

<span class="hljs-comment"># Saves the int8 model that will be x4 smaller than its fp32 counterpart</span>
model.save_pretrained(saving_directory)`,wrap:!1}}),Z=new f({props:{code:"bW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yVmlzdWFsQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMEEp",highlighted:`model = OVModelForVisualCausalLM.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>,
    quantization_config=quantization_config
)`,wrap:!1}}),M=new qi({props:{warning:!0,$$slots:{default:[Ii]},$$scope:{ctx:kt}}}),q=new y({props:{title:"4-bit",local:"4-bit",headingTag:"h3"}}),Q=new f({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yQ2F1c2FsTE0lMkMlMjBPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyhiaXRzJTNENCklMEFtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForCausalLM, OVWeightQuantizationConfig

quantization_config = OVWeightQuantizationConfig(bits=<span class="hljs-number">4</span>)
model = OVModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)`,wrap:!1}}),F=new f({props:{code:"bW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yVmlzdWFsQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMEEp",highlighted:`model = OVModelForVisualCausalLM.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>,
    quantization_config=quantization_config
)`,wrap:!1}}),B=new f({props:{code:"cXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyME9WV2VpZ2h0UXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJpdHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwc3ltJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjByYXRpbyUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X21ldGhvZCUzRCUyMmF3cSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0QlMjJ3aWtpdGV4dDIlMjIlMEEp",highlighted:`quantization_config = OVWeightQuantizationConfig(
    bits=<span class="hljs-number">4</span>,
    sym=<span class="hljs-literal">False</span>,
    ratio=<span class="hljs-number">0.8</span>,
    quant_method=<span class="hljs-string">&quot;awq&quot;</span>,
    dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>
)`,wrap:!1}}),N=new f({props:{code:"cXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyME9WV2VpZ2h0UXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJpdHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwc3ltJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjByYXRpbyUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X21ldGhvZCUzRCUyMmF3cSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjYWxlX2VzdGltYXRpb24lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3B0cSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0JTNEJTIyd2lraXRleHQyJTIyJTBBKQ==",highlighted:`quantization_config = OVWeightQuantizationConfig(
    bits=<span class="hljs-number">4</span>,
    sym=<span class="hljs-literal">False</span>,
    ratio=<span class="hljs-number">0.8</span>,
    quant_method=<span class="hljs-string">&quot;awq&quot;</span>,
    scale_estimation=<span class="hljs-literal">True</span>,
    gptq=<span class="hljs-literal">True</span>,
    dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>
)`,wrap:!1}}),P=new y({props:{title:"Full quantization",local:"full-quantization",headingTag:"h2"}}),tt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WUXVhbnRpemVyJTJDJTIwT1ZNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBPVkNvbmZpZyUyQyUyME9WUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQW1vZGVsJTIwJTNEJTIwT1ZNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBUaGUlMjBkaXJlY3RvcnklMjB3aGVyZSUyMHRoZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwd2lsbCUyMGJlJTIwc2F2ZWQlMEFzYXZlX2RpciUyMCUzRCUyMCUyMnB0cV9tb2RlbCUyMiUwQSUwQXF1YW50aXplciUyMCUzRCUyME9WUXVhbnRpemVyLmZyb21fcHJldHJhaW5lZChtb2RlbCklMEElMEElMjMlMjBBcHBseSUyMGZ1bGwlMjBxdWFudGl6YXRpb24lMjBhbmQlMjBleHBvcnQlMjB0aGUlMjByZXN1bHRpbmclMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHRvJTIwT3BlblZJTk8lMjBJUiUyMGZvcm1hdCUwQW92X2NvbmZpZyUyMCUzRCUyME9WQ29uZmlnKHF1YW50aXphdGlvbl9jb25maWclM0RPVlF1YW50aXphdGlvbkNvbmZpZygpKSUwQXF1YW50aXplci5xdWFudGl6ZShvdl9jb25maWclM0Rvdl9jb25maWclMkMlMjBjYWxpYnJhdGlvbl9kYXRhc2V0JTNEY2FsaWJyYXRpb25fZGF0YXNldCUyQyUyMHNhdmVfZGlyZWN0b3J5JTNEc2F2ZV9kaXIpJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMHRva2VuaXplciUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVQuantizer, OVModelForSequenceClassification, OVConfig, OVQuantizationConfig

model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
model = OVModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-comment"># The directory where the quantized model will be saved</span>
save_dir = <span class="hljs-string">&quot;ptq_model&quot;</span>

quantizer = OVQuantizer.from_pretrained(model)

<span class="hljs-comment"># Apply full quantization and export the resulting quantized model to OpenVINO IR format</span>
ov_config = OVConfig(quantization_config=OVQuantizationConfig())
quantizer.quantize(ov_config=ov_config, calibration_dataset=calibration_dataset, save_directory=save_dir)
<span class="hljs-comment"># Save the tokenizer</span>
tokenizer.save_pretrained(save_dir)`,wrap:!1}}),it=new f({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFkZWYlMjBwcmVwcm9jZXNzX2Z1bmN0aW9uKGV4YW1wbGVzJTJDJTIwdG9rZW5pemVyKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplcihleGFtcGxlcyU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjBtYXhfbGVuZ3RoJTNEMTI4JTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwY2FsaWJyYXRpb24lMjBkYXRhc2V0JTIwdXNlZCUyMHRvJTIwcGVyZm9ybSUyMGZ1bGwlMjBxdWFudGl6YXRpb24lMEFjYWxpYnJhdGlvbl9kYXRhc2V0JTIwJTNEJTIwcXVhbnRpemVyLmdldF9jYWxpYnJhdGlvbl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmdsdWUlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X2NvbmZpZ19uYW1lJTNEJTIyc3N0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lM0RwYXJ0aWFsKHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3NhbXBsZXMlM0QzMDAlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X3NwbGl0JTNEJTIydHJhaW4lMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, tokenizer</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;sentence&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">128</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Create the calibration dataset used to perform full quantization</span>
calibration_dataset = quantizer.get_calibration_dataset(
    <span class="hljs-string">&quot;glue&quot;</span>,
    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
    preprocess_function=partial(preprocess_function, tokenizer=tokenizer),
    num_samples=<span class="hljs-number">300</span>,
    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
)`,wrap:!1}}),nt=new y({props:{title:"Speech-to-text Models Quantization",local:"speech-to-text-models-quantization",headingTag:"h3"}}),ot=new f({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXRpbnklMjIlMEFvdl9tb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RPVlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fc2FtcGxlcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldCUzRCUyMmxpYnJpc3BlZWNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc29yJTNEbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXRtdWxfc3FfYWxwaGElM0QwLjk1JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`model_id = <span class="hljs-string">&quot;openai/whisper-tiny&quot;</span>
ov_model = OVModelForSpeechSeq2Seq.from_pretrained(
    model_id,
    quantization_config=OVQuantizationConfig(
        num_samples=<span class="hljs-number">10</span>,
        dataset=<span class="hljs-string">&quot;librispeech&quot;</span>,
        processor=model_id,
        matmul_sq_alpha=<span class="hljs-number">0.95</span>,
    )
)`,wrap:!1}}),rt=new y({props:{title:"Hybrid quantization",local:"hybrid-quantization",headingTag:"h2"}}),ut=new f({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwT1ZXZWlnaHRRdWFudGl6YXRpb25Db25maWclMEElMEFtb2RlbCUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyhiaXRzJTNEOCUyQyUyMGRhdGFzZXQlM0QlMjJjb25jZXB0dWFsX2NhcHRpb25zJTIyKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline, OVWeightQuantizationConfig

model = OVStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    quantization_config=OVWeightQuantizationConfig(bits=<span class="hljs-number">8</span>, dataset=<span class="hljs-string">&quot;conceptual_captions&quot;</span>),
)`,wrap:!1}}),gt=new y({props:{title:"Mixed Quantization",local:"mixed-quantization",headingTag:"h2"}}),vt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCdUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYxLjAnJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRE9WTWl4ZWRRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2VpZ2h0X3F1YW50aXphdGlvbl9jb25maWclM0RPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyhiaXRzJTNENCUyQyUyMGR0eXBlJTNEJ25mNCcpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnVsbF9xdWFudGl6YXRpb25fY29uZmlnJTNET1ZRdWFudGl6YXRpb25Db25maWcoZHR5cGUlM0QnZjhlNG0zJyUyQyUyMGRhdGFzZXQlM0Qnd2lraXRleHQyJyklMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`model = OVModelForCausalLM.from_pretrained(
    <span class="hljs-string">&#x27;TinyLlama/TinyLlama-1.1B-Chat-v1.0&#x27;</span>,
    quantization_config=OVMixedQuantizationConfig(
        weight_quantization_config=OVWeightQuantizationConfig(bits=<span class="hljs-number">4</span>, dtype=<span class="hljs-string">&#x27;nf4&#x27;</span>),
        full_quantization_config=OVQuantizationConfig(dtype=<span class="hljs-string">&#x27;f8e4m3&#x27;</span>, dataset=<span class="hljs-string">&#x27;wikitext2&#x27;</span>)
    )
)`,wrap:!1}}),Tt=new f({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvcGVudmlubyUyMC1tJTIwVGlueUxsYW1hJTJGVGlueUxsYW1hLTEuMUItQ2hhdC12MS4wJTIwLS1xdWFudC1tb2RlJTIwbmY0X2Y4ZTRtMyUyMC0tZGF0YXNldCUyMHdpa2l0ZXh0MiUyMC4lMkZzYXZlX2Rpcg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> openvino -m TinyLlama/TinyLlama-1.1B-Chat-v1.0 --quant-mode nf4_f8e4m3 --dataset wikitext2 ./save_dir',wrap:!1}}),_t=new y({props:{title:"Pipeline Quantization",local:"pipeline-quantization",headingTag:"h2"}}),zt=new f({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yVmlzdWFsQ2F1c2FsTE0lMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWclMkMlMjBPVlF1YW50aXphdGlvbkNvbmZpZyUyQyUyME9WV2VpZ2h0UXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJPcGVuR1ZMYWIlMkZJbnRlcm5WTDItMUIlMjIlMEFtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JWaXN1YWxDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRE9WUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZ3MlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsbV9tb2RlbCUyMiUzQSUyME9WUXVhbnRpemF0aW9uQ29uZmlnKGJpdHMlM0Q4KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW1iZWRkaW5nc19tb2RlbCUyMiUzQSUyME9WV2VpZ2h0UXVhbnRpemF0aW9uQ29uZmlnKGJpdHMlM0Q4KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXQlM0QlMjJjb250ZXh0dWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForVisualCausalLM
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVPipelineQuantizationConfig, OVQuantizationConfig, OVWeightQuantizationConfig

model_id = <span class="hljs-string">&quot;OpenGVLab/InternVL2-1B&quot;</span>
model = OVModelForVisualCausalLM.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
    quantization_config=OVPipelineQuantizationConfig(
        quantization_configs={
            <span class="hljs-string">&quot;lm_model&quot;</span>: OVQuantizationConfig(bits=<span class="hljs-number">8</span>),
            <span class="hljs-string">&quot;text_embeddings_model&quot;</span>: OVWeightQuantizationConfig(bits=<span class="hljs-number">8</span>),
        },
        dataset=<span class="hljs-string">&quot;contextual&quot;</span>,
        trust_remote_code=<span class="hljs-literal">True</span>,
    )
)`,wrap:!1}}),{c(){g=o("meta"),v=n(),h=o("p"),Ut=n(),d(w.$$.fragment),Wt=n(),T=o("p"),T.innerHTML=Be,jt=n(),x=o("p"),x.textContent=Xe,Zt=n(),d(_.$$.fragment),qt=n(),C=o("p"),C.textContent=Ge,It=n(),J=o("table"),J.innerHTML=Le,Qt=n(),d(z.$$.fragment),$t=n(),U=o("p"),U.textContent=Oe,Ft=n(),d(V.$$.fragment),Rt=n(),k=o("p"),k.innerHTML=Ee,Bt=n(),d(W.$$.fragment),Xt=n(),j=o("p"),j.textContent=He,Gt=n(),d(Z.$$.fragment),Lt=n(),d(M.$$.fragment),Ot=n(),d(q.$$.fragment),Et=n(),I=o("p"),I.textContent=Ye,Ht=n(),d(Q.$$.fragment),Yt=n(),$=o("p"),$.textContent=Se,St=n(),d(F.$$.fragment),Nt=n(),R=o("p"),R.textContent=Ne,At=n(),d(B.$$.fragment),Pt=n(),X=o("p"),X.innerHTML=Ae,Dt=n(),G=o("p"),G.innerHTML=Pe,Kt=n(),L=o("p"),L.textContent=De,te=n(),O=o("ul"),O.innerHTML=Ke,ee=n(),E=o("p"),E.innerHTML=ti,ie=n(),H=o("p"),H.textContent=ei,ae=n(),Y=o("ul"),Y.innerHTML=ii,ne=n(),S=o("p"),S.innerHTML=ai,le=n(),d(N.$$.fragment),oe=n(),A=o("p"),A.textContent=ni,se=n(),d(P.$$.fragment),re=n(),D=o("p"),D.innerHTML=li,de=n(),K=o("p"),K.innerHTML=oi,pe=n(),d(tt.$$.fragment),ce=n(),et=o("p"),et.innerHTML=si,me=n(),d(it.$$.fragment),ue=n(),at=o("p"),at.innerHTML=ri,be=n(),d(nt.$$.fragment),ge=n(),lt=o("p"),lt.textContent=di,fe=n(),d(ot.$$.fragment),he=n(),st=o("p"),st.textContent=pi,ye=n(),d(rt.$$.fragment),Me=n(),dt=o("p"),dt.innerHTML=ci,ve=n(),pt=o("ul"),pt.innerHTML=mi,we=n(),ct=o("p"),ct.textContent=ui,Te=n(),mt=o("p"),mt.innerHTML=bi,xe=n(),d(ut.$$.fragment),_e=n(),bt=o("p"),bt.innerHTML=gi,Ce=n(),d(gt.$$.fragment),Je=n(),ft=o("p"),ft.textContent=fi,ze=n(),ht=o("ol"),ht.innerHTML=hi,Ue=n(),yt=o("p"),yt.innerHTML=yi,Ve=n(),Mt=o("p"),Mt.innerHTML=Mi,ke=n(),d(vt.$$.fragment),We=n(),wt=o("p"),wt.innerHTML=vi,je=n(),d(Tt.$$.fragment),Ze=n(),xt=o("p"),xt.textContent=wi,qe=n(),d(_t.$$.fragment),Ie=n(),Ct=o("p"),Ct.innerHTML=Ti,Qe=n(),Jt=o("p"),Jt.textContent=xi,$e=n(),d(zt.$$.fragment),Fe=n(),Vt=o("p"),this.h()},l(t){const e=ji("svelte-u9bgzb",document.head);g=s(e,"META",{name:!0,content:!0}),e.forEach(i),v=l(t),h=s(t,"P",{}),Ci(h).forEach(i),Ut=l(t),p(w.$$.fragment,t),Wt=l(t),T=s(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1kqt85y"&&(T.innerHTML=Be),jt=l(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1bioojp"&&(x.textContent=Xe),Zt=l(t),p(_.$$.fragment,t),qt=l(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-yz1bv9"&&(C.textContent=Ge),It=l(t),J=s(t,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-1ub72h7"&&(J.innerHTML=Le),Qt=l(t),p(z.$$.fragment,t),$t=l(t),U=s(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-17xp9b"&&(U.textContent=Oe),Ft=l(t),p(V.$$.fragment,t),Rt=l(t),k=s(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-vqgrfh"&&(k.innerHTML=Ee),Bt=l(t),p(W.$$.fragment,t),Xt=l(t),j=s(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-16a1vs2"&&(j.textContent=He),Gt=l(t),p(Z.$$.fragment,t),Lt=l(t),p(M.$$.fragment,t),Ot=l(t),p(q.$$.fragment,t),Et=l(t),I=s(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ynyujr"&&(I.textContent=Ye),Ht=l(t),p(Q.$$.fragment,t),Yt=l(t),$=s(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-ckhwzy"&&($.textContent=Se),St=l(t),p(F.$$.fragment,t),Nt=l(t),R=s(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1oj65vk"&&(R.textContent=Ne),At=l(t),p(B.$$.fragment,t),Pt=l(t),X=s(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-jq996k"&&(X.innerHTML=Ae),Dt=l(t),G=s(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-11zrdex"&&(G.innerHTML=Pe),Kt=l(t),L=s(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1edxsd4"&&(L.textContent=De),te=l(t),O=s(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1xdcez2"&&(O.innerHTML=Ke),ee=l(t),E=s(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1pvf0nk"&&(E.innerHTML=ti),ie=l(t),H=s(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-27zu87"&&(H.textContent=ei),ae=l(t),Y=s(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-o0edvn"&&(Y.innerHTML=ii),ne=l(t),S=s(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1xeos13"&&(S.innerHTML=ai),le=l(t),p(N.$$.fragment,t),oe=l(t),A=s(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-19pmlig"&&(A.textContent=ni),se=l(t),p(P.$$.fragment,t),re=l(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-9ojby0"&&(D.innerHTML=li),de=l(t),K=s(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-u6rwxg"&&(K.innerHTML=oi),pe=l(t),p(tt.$$.fragment,t),ce=l(t),et=s(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1bmrgi2"&&(et.innerHTML=si),me=l(t),p(it.$$.fragment,t),ue=l(t),at=s(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1tr5712"&&(at.innerHTML=ri),be=l(t),p(nt.$$.fragment,t),ge=l(t),lt=s(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-2xlwma"&&(lt.textContent=di),fe=l(t),p(ot.$$.fragment,t),he=l(t),st=s(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1euukhf"&&(st.textContent=pi),ye=l(t),p(rt.$$.fragment,t),Me=l(t),dt=s(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1r5icyl"&&(dt.innerHTML=ci),ve=l(t),pt=s(t,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-5q7f0v"&&(pt.innerHTML=mi),we=l(t),ct=s(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-5c3t0d"&&(ct.textContent=ui),Te=l(t),mt=s(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1vn2n7x"&&(mt.innerHTML=bi),xe=l(t),p(ut.$$.fragment,t),_e=l(t),bt=s(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1w2f7fi"&&(bt.innerHTML=gi),Ce=l(t),p(gt.$$.fragment,t),Je=l(t),ft=s(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-5y3yhc"&&(ft.textContent=fi),ze=l(t),ht=s(t,"OL",{"data-svelte-h":!0}),r(ht)!=="svelte-1shxxwh"&&(ht.innerHTML=hi),Ue=l(t),yt=s(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-2bh5m6"&&(yt.innerHTML=yi),Ve=l(t),Mt=s(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-m6e5t3"&&(Mt.innerHTML=Mi),ke=l(t),p(vt.$$.fragment,t),We=l(t),wt=s(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-d2xo64"&&(wt.innerHTML=vi),je=l(t),p(Tt.$$.fragment,t),Ze=l(t),xt=s(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-4hpsr0"&&(xt.textContent=wi),qe=l(t),p(_t.$$.fragment,t),Ie=l(t),Ct=s(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1e55rgb"&&(Ct.innerHTML=Ti),Qe=l(t),Jt=s(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-17ga14b"&&(Jt.textContent=xi),$e=l(t),p(zt.$$.fragment,t),Fe=l(t),Vt=s(t,"P",{}),Ci(Vt).forEach(i),this.h()},h(){Ji(g,"name","hf:doc:metadata"),Ji(g,"content",$i)},m(t,e){Zi(document.head,g),a(t,v,e),a(t,h,e),a(t,Ut,e),c(w,t,e),a(t,Wt,e),a(t,T,e),a(t,jt,e),a(t,x,e),a(t,Zt,e),c(_,t,e),a(t,qt,e),a(t,C,e),a(t,It,e),a(t,J,e),a(t,Qt,e),c(z,t,e),a(t,$t,e),a(t,U,e),a(t,Ft,e),c(V,t,e),a(t,Rt,e),a(t,k,e),a(t,Bt,e),c(W,t,e),a(t,Xt,e),a(t,j,e),a(t,Gt,e),c(Z,t,e),a(t,Lt,e),c(M,t,e),a(t,Ot,e),c(q,t,e),a(t,Et,e),a(t,I,e),a(t,Ht,e),c(Q,t,e),a(t,Yt,e),a(t,$,e),a(t,St,e),c(F,t,e),a(t,Nt,e),a(t,R,e),a(t,At,e),c(B,t,e),a(t,Pt,e),a(t,X,e),a(t,Dt,e),a(t,G,e),a(t,Kt,e),a(t,L,e),a(t,te,e),a(t,O,e),a(t,ee,e),a(t,E,e),a(t,ie,e),a(t,H,e),a(t,ae,e),a(t,Y,e),a(t,ne,e),a(t,S,e),a(t,le,e),c(N,t,e),a(t,oe,e),a(t,A,e),a(t,se,e),c(P,t,e),a(t,re,e),a(t,D,e),a(t,de,e),a(t,K,e),a(t,pe,e),c(tt,t,e),a(t,ce,e),a(t,et,e),a(t,me,e),c(it,t,e),a(t,ue,e),a(t,at,e),a(t,be,e),c(nt,t,e),a(t,ge,e),a(t,lt,e),a(t,fe,e),c(ot,t,e),a(t,he,e),a(t,st,e),a(t,ye,e),c(rt,t,e),a(t,Me,e),a(t,dt,e),a(t,ve,e),a(t,pt,e),a(t,we,e),a(t,ct,e),a(t,Te,e),a(t,mt,e),a(t,xe,e),c(ut,t,e),a(t,_e,e),a(t,bt,e),a(t,Ce,e),c(gt,t,e),a(t,Je,e),a(t,ft,e),a(t,ze,e),a(t,ht,e),a(t,Ue,e),a(t,yt,e),a(t,Ve,e),a(t,Mt,e),a(t,ke,e),c(vt,t,e),a(t,We,e),a(t,wt,e),a(t,je,e),c(Tt,t,e),a(t,Ze,e),a(t,xt,e),a(t,qe,e),c(_t,t,e),a(t,Ie,e),a(t,Ct,e),a(t,Qe,e),a(t,Jt,e),a(t,$e,e),c(zt,t,e),a(t,Fe,e),a(t,Vt,e),Re=!0},p(t,[e]){const _i={};e&2&&(_i.$$scope={dirty:e,ctx:t}),M.$set(_i)},i(t){Re||(m(w.$$.fragment,t),m(_.$$.fragment,t),m(z.$$.fragment,t),m(V.$$.fragment,t),m(W.$$.fragment,t),m(Z.$$.fragment,t),m(M.$$.fragment,t),m(q.$$.fragment,t),m(Q.$$.fragment,t),m(F.$$.fragment,t),m(B.$$.fragment,t),m(N.$$.fragment,t),m(P.$$.fragment,t),m(tt.$$.fragment,t),m(it.$$.fragment,t),m(nt.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(ut.$$.fragment,t),m(gt.$$.fragment,t),m(vt.$$.fragment,t),m(Tt.$$.fragment,t),m(_t.$$.fragment,t),m(zt.$$.fragment,t),Re=!0)},o(t){u(w.$$.fragment,t),u(_.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(W.$$.fragment,t),u(Z.$$.fragment,t),u(M.$$.fragment,t),u(q.$$.fragment,t),u(Q.$$.fragment,t),u(F.$$.fragment,t),u(B.$$.fragment,t),u(N.$$.fragment,t),u(P.$$.fragment,t),u(tt.$$.fragment,t),u(it.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(ut.$$.fragment,t),u(gt.$$.fragment,t),u(vt.$$.fragment,t),u(Tt.$$.fragment,t),u(_t.$$.fragment,t),u(zt.$$.fragment,t),Re=!1},d(t){t&&(i(v),i(h),i(Ut),i(Wt),i(T),i(jt),i(x),i(Zt),i(qt),i(C),i(It),i(J),i(Qt),i($t),i(U),i(Ft),i(Rt),i(k),i(Bt),i(Xt),i(j),i(Gt),i(Lt),i(Ot),i(Et),i(I),i(Ht),i(Yt),i($),i(St),i(Nt),i(R),i(At),i(Pt),i(X),i(Dt),i(G),i(Kt),i(L),i(te),i(O),i(ee),i(E),i(ie),i(H),i(ae),i(Y),i(ne),i(S),i(le),i(oe),i(A),i(se),i(re),i(D),i(de),i(K),i(pe),i(ce),i(et),i(me),i(ue),i(at),i(be),i(ge),i(lt),i(fe),i(he),i(st),i(ye),i(Me),i(dt),i(ve),i(pt),i(we),i(ct),i(Te),i(mt),i(xe),i(_e),i(bt),i(Ce),i(Je),i(ft),i(ze),i(ht),i(Ue),i(yt),i(Ve),i(Mt),i(ke),i(We),i(wt),i(je),i(Ze),i(xt),i(qe),i(Ie),i(Ct),i(Qe),i(Jt),i($e),i(Fe),i(Vt)),i(g),b(w,t),b(_,t),b(z,t),b(V,t),b(W,t),b(Z,t),b(M,t),b(q,t),b(Q,t),b(F,t),b(B,t),b(N,t),b(P,t),b(tt,t),b(it,t),b(nt,t),b(ot,t),b(rt,t),b(ut,t),b(gt,t),b(vt,t),b(Tt,t),b(_t,t),b(zt,t)}}}const $i='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimization Support Matrix","local":"optimization-support-matrix","sections":[],"depth":2},{"title":"Weight-only Quantization","local":"weight-only-quantization","sections":[{"title":"8-bit","local":"8-bit","sections":[],"depth":3},{"title":"4-bit","local":"4-bit","sections":[],"depth":3}],"depth":2},{"title":"Full quantization","local":"full-quantization","sections":[{"title":"Speech-to-text Models Quantization","local":"speech-to-text-models-quantization","sections":[],"depth":3}],"depth":2},{"title":"Hybrid quantization","local":"hybrid-quantization","sections":[],"depth":2},{"title":"Mixed Quantization","local":"mixed-quantization","sections":[],"depth":2},{"title":"Pipeline Quantization","local":"pipeline-quantization","sections":[],"depth":2}],"depth":1}';function Fi(kt){return Ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oi extends ki{constructor(g){super(),Wi(this,g,Fi,Qi,zi,{})}}export{Oi as component};
