import{s as Be,o as Le,n as ze}from"../chunks/scheduler.bdbef820.js";import{S as Re,i as Ae,g as p,s as l,r as c,A as Ze,h as r,f as s,c as n,j as He,u as f,x as m,k as Ie,y as Ge,a,v as h,d as u,t as d,w as M}from"../chunks/index.c0aea24a.js";import{T as Pe}from"../chunks/Tip.31005f7d.js";import{C as N}from"../chunks/CodeBlock.6ccca92e.js";import{H as de}from"../chunks/Heading.2eb892cb.js";function De(Q){let i,j='The following example uses <a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a>, but feel free to use other data augmentation libraries like <a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a>, <a href="https://kornia.readthedocs.io/en/latest/" rel="nofollow">Kornia</a>, and <a href="https://imgaug.readthedocs.io/en/latest/" rel="nofollow">imgaug</a>.';return{c(){i=p("p"),i.innerHTML=j},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-7kbokn"&&(i.innerHTML=j)},m(o,D){a(o,i,D)},p:ze,d(o){o&&s(i)}}}function Ee(Q){let i,j,o,D,g,F,w,Me="This guide shows specific methods for processing image datasets. Learn how to:",X,T,ye='<li>Use <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with image dataset.</li> <li>Apply data augmentations to a dataset with <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a>.</li>',q,b,je='For a guide on how to process any type of dataset, take a look at the <a class="underline decoration-sky-400 decoration-2 font-semibold" href="./process">general process guide</a>.',W,$,V,_,ge='The <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function can apply transforms over an entire dataset.',Y,v,we='For example, create a basic <a href="https://pytorch.org/vision/stable/generated/torchvision.transforms.Resize.html" rel="nofollow"><code>Resize</code></a> function:',K,J,S,U,Te='Now use the <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function to resize the entire dataset, and set <code>batched=True</code> to speed up the process by accepting batches of examples. The transform returns <code>pixel_values</code> as a cacheable <code>PIL.Image</code> object:',O,x,ee,k,be='The cache file saves time because you don’t have to execute the same transform twice. The <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function is best for operations you only run once per training - like resizing an image - instead of using it for operations executed for each epoch, like data augmentations.',te,C,$e='<a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> takes up some memory, but you can reduce its memory requirements with the following parameters:',se,H,_e='<li><a href="./package_reference/main_classes#datasets.DatasetDict.map.batch_size"><code>batch_size</code></a> determines the number of examples that are processed in one call to the transform function.</li> <li><a href="./package_reference/main_classes#datasets.DatasetDict.map.writer_batch_size"><code>writer_batch_size</code></a> determines the number of processed examples that are kept in memory before they are stored away.</li>',ae,I,ve='Both parameter values default to 1000, which can be expensive if you are storing images. Lower these values to use less memory when you use <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a>.',le,B,ne,L,Je='🤗 Datasets applies data augmentations from any library or package to your dataset. Transforms can be applied on-the-fly on batches of data with <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a>, which consumes less disk space.',pe,y,re,z,Ue="For example, if you’d like to change the color properties of an image randomly:",ie,R,me,A,xe="Create a function to apply the <code>ColorJitter</code> transform:",oe,Z,ce,G,ke='Apply the transform with the <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function:',fe,P,he,E,ue;return g=new de({props:{title:"Process image data",local:"process-image-data",headingTag:"h1"}}),$=new de({props:{title:"Map",local:"map",headingTag:"h2"}}),J=new N({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QmltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKS5yZXNpemUoKDEwMCUyQzEwMCkpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGV4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>).resize((<span class="hljs-number">100</span>,<span class="hljs-number">100</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),x=new N({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRyYW5zZm9ybXMlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMmltYWdlJTIyJTVEJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(transforms, remove_columns=[<span class="hljs-string">&quot;image&quot;</span>], batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>,
 <span class="hljs-string">&#x27;pixel_values&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=RGB size=100x100 at <span class="hljs-number">0x7F058237BB10</span>&gt;}`,wrap:!1}}),B=new de({props:{title:"Apply transforms",local:"apply-transforms",headingTag:"h2"}}),y=new Pe({props:{$$slots:{default:[De]},$$scope:{ctx:Q}}}),R=new N({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwQ29sb3JKaXR0ZXIlMkMlMjBUb1RlbnNvciUwQSUwQWppdHRlciUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29sb3JKaXR0ZXIoYnJpZ2h0bmVzcyUzRDAuMjUlMkMlMjBjb250cmFzdCUzRDAuMjUlMkMlMjBzYXR1cmF0aW9uJTNEMC4yNSUyQyUyMGh1ZSUzRDAuNyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb1RlbnNvcigpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, ColorJitter, ToTensor

<span class="hljs-meta">&gt;&gt;&gt; </span>jitter = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>         ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>         ToTensor(),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),Z=new N({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QmppdHRlcihpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGV4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [jitter(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),P=new N({props:{code:"ZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transforms)',wrap:!1}}),{c(){i=p("meta"),j=l(),o=p("p"),D=l(),c(g.$$.fragment),F=l(),w=p("p"),w.textContent=Me,X=l(),T=p("ul"),T.innerHTML=ye,q=l(),b=p("p"),b.innerHTML=je,W=l(),c($.$$.fragment),V=l(),_=p("p"),_.innerHTML=ge,Y=l(),v=p("p"),v.innerHTML=we,K=l(),c(J.$$.fragment),S=l(),U=p("p"),U.innerHTML=Te,O=l(),c(x.$$.fragment),ee=l(),k=p("p"),k.innerHTML=be,te=l(),C=p("p"),C.innerHTML=$e,se=l(),H=p("ul"),H.innerHTML=_e,ae=l(),I=p("p"),I.innerHTML=ve,le=l(),c(B.$$.fragment),ne=l(),L=p("p"),L.innerHTML=Je,pe=l(),c(y.$$.fragment),re=l(),z=p("p"),z.textContent=Ue,ie=l(),c(R.$$.fragment),me=l(),A=p("p"),A.innerHTML=xe,oe=l(),c(Z.$$.fragment),ce=l(),G=p("p"),G.innerHTML=ke,fe=l(),c(P.$$.fragment),he=l(),E=p("p"),this.h()},l(e){const t=Ze("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(s),j=n(e),o=r(e,"P",{}),He(o).forEach(s),D=n(e),f(g.$$.fragment,e),F=n(e),w=r(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-7uwdmt"&&(w.textContent=Me),X=n(e),T=r(e,"UL",{"data-svelte-h":!0}),m(T)!=="svelte-1iwobbh"&&(T.innerHTML=ye),q=n(e),b=r(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-3s2bzp"&&(b.innerHTML=je),W=n(e),f($.$$.fragment,e),V=n(e),_=r(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-ubqjk5"&&(_.innerHTML=ge),Y=n(e),v=r(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-3s9pec"&&(v.innerHTML=we),K=n(e),f(J.$$.fragment,e),S=n(e),U=r(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-eq6lc5"&&(U.innerHTML=Te),O=n(e),f(x.$$.fragment,e),ee=n(e),k=r(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-6ikxk"&&(k.innerHTML=be),te=n(e),C=r(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-bq5olk"&&(C.innerHTML=$e),se=n(e),H=r(e,"UL",{"data-svelte-h":!0}),m(H)!=="svelte-1uuk8jl"&&(H.innerHTML=_e),ae=n(e),I=r(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-zw3343"&&(I.innerHTML=ve),le=n(e),f(B.$$.fragment,e),ne=n(e),L=r(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-5mr11y"&&(L.innerHTML=Je),pe=n(e),f(y.$$.fragment,e),re=n(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1dscypy"&&(z.textContent=Ue),ie=n(e),f(R.$$.fragment,e),me=n(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1qyarbp"&&(A.innerHTML=xe),oe=n(e),f(Z.$$.fragment,e),ce=n(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1vlexo9"&&(G.innerHTML=ke),fe=n(e),f(P.$$.fragment,e),he=n(e),E=r(e,"P",{}),He(E).forEach(s),this.h()},h(){Ie(i,"name","hf:doc:metadata"),Ie(i,"content",Ne)},m(e,t){Ge(document.head,i),a(e,j,t),a(e,o,t),a(e,D,t),h(g,e,t),a(e,F,t),a(e,w,t),a(e,X,t),a(e,T,t),a(e,q,t),a(e,b,t),a(e,W,t),h($,e,t),a(e,V,t),a(e,_,t),a(e,Y,t),a(e,v,t),a(e,K,t),h(J,e,t),a(e,S,t),a(e,U,t),a(e,O,t),h(x,e,t),a(e,ee,t),a(e,k,t),a(e,te,t),a(e,C,t),a(e,se,t),a(e,H,t),a(e,ae,t),a(e,I,t),a(e,le,t),h(B,e,t),a(e,ne,t),a(e,L,t),a(e,pe,t),h(y,e,t),a(e,re,t),a(e,z,t),a(e,ie,t),h(R,e,t),a(e,me,t),a(e,A,t),a(e,oe,t),h(Z,e,t),a(e,ce,t),a(e,G,t),a(e,fe,t),h(P,e,t),a(e,he,t),a(e,E,t),ue=!0},p(e,[t]){const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),y.$set(Ce)},i(e){ue||(u(g.$$.fragment,e),u($.$$.fragment,e),u(J.$$.fragment,e),u(x.$$.fragment,e),u(B.$$.fragment,e),u(y.$$.fragment,e),u(R.$$.fragment,e),u(Z.$$.fragment,e),u(P.$$.fragment,e),ue=!0)},o(e){d(g.$$.fragment,e),d($.$$.fragment,e),d(J.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(y.$$.fragment,e),d(R.$$.fragment,e),d(Z.$$.fragment,e),d(P.$$.fragment,e),ue=!1},d(e){e&&(s(j),s(o),s(D),s(F),s(w),s(X),s(T),s(q),s(b),s(W),s(V),s(_),s(Y),s(v),s(K),s(S),s(U),s(O),s(ee),s(k),s(te),s(C),s(se),s(H),s(ae),s(I),s(le),s(ne),s(L),s(pe),s(re),s(z),s(ie),s(me),s(A),s(oe),s(ce),s(G),s(fe),s(he),s(E)),s(i),M(g,e),M($,e),M(J,e),M(x,e),M(B,e),M(y,e),M(R,e),M(Z,e),M(P,e)}}}const Ne='{"title":"Process image data","local":"process-image-data","sections":[{"title":"Map","local":"map","sections":[],"depth":2},{"title":"Apply transforms","local":"apply-transforms","sections":[],"depth":2}],"depth":1}';function Qe(Q){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends Re{constructor(i){super(),Ae(this,i,Qe,Ee,Be,{})}}export{Ye as component};
