import{s as Ya,n as za,o as xa}from"../chunks/scheduler.bdbef820.js";import{S as Qa,i as Wa,g as i,s as l,r as p,A as Na,h as r,f as s,c as n,j as Ba,u as d,x as c,k as Fa,y as Da,a as t,v as o,d as m,t as h,w as f}from"../chunks/index.c0aea24a.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as u}from"../chunks/Heading.2eb892cb.js";function Sa(oa){let M,fe,me,ye,w,Me,b,ma=`There are two types of dataset objects, a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
Whichever type of dataset you choose to use or create depends on the size of the dataset.
In general, an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is ideal for big datasets (think hundreds of GBs!) due to its lazy behavior and speed advantages, while a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> is great for everything else.
This page will compare the differences between a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> to help you pick the right dataset object for you.`,ue,j,we,J,ha=`When you have a regular <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, you can access it using <code>my_dataset[0]</code>. This provides random access to the rows.
Such datasets are also called “map-style” datasets.
For example you can download ImageNet-1k like this and access any row:`,be,T,je,U,fa=`But one caveat is that you must have the entire dataset stored on your disk or in memory, which blocks you from accessing datasets bigger than the disk.
Because it can become inconvenient for big datasets, there exists another type of dataset, the <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
When you have an <code>IterableDataset</code>, you can access it using a <code>for</code> loop to load the data progressively as you iterate over the dataset.
This way, only a small fraction of examples is loaded in memory, and you don’t write anything on disk.`,Je,_,ya="For example, you can stream the ImageNet-1k dataset without downloading it on disk:",Te,g,Ue,Z,Ma=`Streaming can read online data without writing any file to disk.
For example, you can stream datasets made out of multiple shards, each of which is hundreds of gigabytes like <a href="https://huggingface.co/datasets/c4" rel="nofollow">C4</a>, <a href="https://huggingface.co/datasets/oscar" rel="nofollow">OSCAR</a> or <a href="https://huggingface.co/datasets/laion/laion2B-en" rel="nofollow">LAION-2B</a>.
Learn more about how to stream a dataset in the <a href="./stream">Dataset Streaming Guide</a>.`,_e,X,ua="This is not the only difference though, because the “lazy” behavior of an <code>IterableDataset</code> is also present when it comes to dataset creation and processing.",ge,I,Ze,k,wa='You can create a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using lists or dictionaries, and the data is entirely converted to Arrow so you can easily access any row:',Xe,G,Ie,C,ba=`To create an <code>IterableDataset</code> on the other hand, you must provide a “lazy” way to load the data.
In Python, we generally use generator functions. These functions <code>yield</code> one example at a time, which means you can’t access a row by slicing it like a regular <code>Dataset</code>:`,ke,$,Ge,v,Ce,V,ja='It is possible to convert local or remote data files to an Arrow <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',$e,R,ve,B,Ja="However, this requires a conversion step from CSV to Arrow format, which takes time and disk space if your dataset is big.",Ve,F,Ta=`To save disk space and skip the conversion step, you can define an <code>IterableDataset</code> by streaming from the local files directly.
This way, the data is read progressively from the local files as you iterate over the dataset:`,Re,Y,Be,z,Ua=`Many file formats are supported, like CSV, JSONL, and Parquet, as well as image and audio files.
You can find more information in the corresponding guides for loading <a href="./tabular_load">tabular</a>, <a href="./nlp_load">text</a>, <a href="./image_load">vision</a>, and <a href="./audio_load%5D">audio</a> datasets.`,Fe,x,Ye,Q,_a=`When you process a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object using <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a>, the entire dataset is processed immediately and returned.
This is similar to how <code>pandas</code> works for example.`,ze,W,xe,N,ga=`On the other hand, due to the “lazy” nature of an <code>IterableDataset</code>, calling <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> does not apply your <code>map</code> function over the full dataset.
Instead, your <code>map</code> function is applied on-the-fly.`,Qe,D,Za="Because of that, you can chain multiple processing steps and they will all run at once when you start iterating over the dataset:",We,S,Ne,H,De,E,Xa=`When you shuffle a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a>, you apply an exact shuffling of the dataset.
It works by taking a list of indices <code>[0, 1, 2, ... len(my_dataset) - 1]</code> and shuffling this list.
Then, accessing <code>my_dataset[0]</code> returns the row and index defined by the first element of the indices mapping that has been shuffled:`,Se,A,He,q,Ia=`Since we don’t have random access to the rows in the case of an <code>IterableDataset</code>, we can’t use a shuffled list of indices and access a row at an arbitrary position.
This prevents the use of exact shuffling.
Instead, a fast approximate shuffling is used in <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It uses a shuffle buffer to sample random examples iteratively from the dataset.
Since the dataset is still read iteratively, it provides excellent speed performance:`,Ee,L,Ae,P,ka='But using a shuffle buffer is not enough to provide a satisfactory shuffling for machine learning model training. So <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> also shuffles the dataset shards if your dataset is made of multiple files or sources:',qe,K,Le,O,Pe,ee,Ga=`Regular <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> objects are based on Arrow which provides fast random access to the rows.
Thanks to memory mapping and the fact that Arrow is an in-memory format, reading data from disk doesn’t do expensive system calls and deserialization.
It provides even faster data loading when iterating using a <code>for</code> loop by iterating on contiguous Arrow record batches.`,Ke,ae,Ca=`However as soon as your <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping (via <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a> for example), the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
This may take a lot of time depending of the size of your dataset though:`,Oe,se,ea,te,$a=`In this case, we recommend switching to an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leveraging its fast approximate shuffling method <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It only shuffles the shards order and adds a shuffle buffer to your dataset, which keeps the speed of your dataset optimal.
You can also reshuffle the dataset easily:`,aa,le,sa,ne,va=`If you’re using your dataset on multiple epochs, the effective seed to shuffle the shards order in the shuffle buffer is <code>seed + epoch</code>.
It makes it easy to reshuffle a dataset between epochs:`,ta,ie,la,re,na,pe,Va='If you want to benefit from the “lazy” behavior of an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> or their speed advantages, you can switch your map-style <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> to an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',ia,de,ra,ce,Ra='If you want to shuffle your dataset or <a href="./use_with_pytorch#stream-data">use it with a PyTorch DataLoader</a>, we recommend generating a sharded <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',pa,oe,da,he,ca;return w=new u({props:{title:"Differences between Dataset and IterableDataset",local:"differences-between-dataset-and-iterabledataset",headingTag:"h1"}}),j=new u({props:{title:"Downloading and streaming",local:"downloading-and-streaming",headingTag:"h2"}}),T=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUyMCUyMCUyMyUyMGRvd25sb2FkcyUyMHRoZSUyMGZ1bGwlMjBkYXRhc2V0JTBBcHJpbnQoaW1hZ2VuZXQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)  <span class="hljs-comment"># downloads the full dataset</span>
<span class="hljs-built_in">print</span>(imagenet[<span class="hljs-number">0</span>])`,wrap:!1}}),g=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMjAlMjAlMjMlMjB3aWxsJTIwc3RhcnQlMjBsb2FkaW5nJTIwdGhlJTIwZGF0YSUyMHdoZW4lMjBpdGVyYXRlZCUyMG92ZXIlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBpbWFnZW5ldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># will start loading the data when iterated over</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> imagenet:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),I=new u({props:{title:"Creating map-style datasets and iterable datasets",local:"creating-map-style-datasets-and-iterable-datasets",headingTag:"h2"}}),G=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmNvbF8xJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCU3RCklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = Dataset.from_dict({<span class="hljs-string">&quot;col_1&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]})
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),$=new y({props:{code:"ZGVmJTIwbXlfZ2VuZXJhdG9yKG4pJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMCU3QiUyMmNvbF8xJTIyJTNBJTIwaSU3RCUwQSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMm4lMjIlM0ElMjAxMCU3RCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n</span>):
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
        <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;col_1&quot;</span>: i}

my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs={<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>})
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),v=new u({props:{title:"Loading local files entirely and progressively",local:"loading-local-files-entirely-and-progressively",headingTag:"h2"}}),R=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),Y=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwbXlfaXRlcmFibGVfZGF0YXNldCUzQSUyMCUyMCUyMyUyMHRoaXMlMjByZWFkcyUyMHRoZSUyMENTViUyMGZpbGUlMjBwcm9ncmVzc2l2ZWx5JTIwYXMlMjB5b3UlMjBpdGVyYXRlJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># this reads the CSV file progressively as you iterate over the dataset</span>
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),x=new u({props:{title:"Eager data processing and lazy data processing",local:"eager-data-processing-and-lazy-data-processing",headingTag:"h2"}}),W=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQubWFwKHByb2Nlc3NfZm4pJTIwJTIwJTIzJTIwcHJvY2Vzc19mbiUyMGlzJTIwYXBwbGllZCUyMG9uJTIwYWxsJTIwdGhlJTIwZXhhbXBsZXMlMjBvZiUyMHRoZSUyMGRhdGFzZXQlMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = my_dataset.<span class="hljs-built_in">map</span>(process_fn)  <span class="hljs-comment"># process_fn is applied on all the examples of the dataset</span>
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),S=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQubWFwKHByb2Nlc3NfZm5fMSklMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5maWx0ZXIoZmlsdGVyX2ZuKSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0Lm1hcChwcm9jZXNzX2ZuXzIpJTBBJTBBJTIzJTIwcHJvY2Vzc19mbl8xJTJDJTIwZmlsdGVyX2ZuJTIwYW5kJTIwcHJvY2Vzc19mbl8yJTIwYXJlJTIwYXBwbGllZCUyMG9uLXRoZS1mbHklMjB3aGVuJTIwaXRlcmF0aW5nJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_1)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">filter</span>(filter_fn)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_2)

<span class="hljs-comment"># process_fn_1, filter_fn and process_fn_2 are applied on-the-fly when iterating over the dataset</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),H=new u({props:{title:"Exact and fast approximate shuffling",local:"exact-and-fast-approximate-shuffling",headingTag:"h2"}}),A=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBcHJpbnQobXlfZGF0YXNldCU1QjAlNUQp",highlighted:`my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),L=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIlMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwU3RyZWFtJTIwZnJvbSUyMHRoZSUyMGludGVybmV0JTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMzklMEElMEElMjMlMjBTdHJlYW0lMjBmcm9tJTIwbG9jYWwlMjBmaWxlcyUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlN0IlMjJ0cmFpbiUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QuY3N2JTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQlMEElMEElMjMlMjBGcm9tJTIwYSUyMGdlbmVyYXRvciUyMGZ1bmN0aW9uJTBBZGVmJTIwbXlfZ2VuZXJhdG9yKG4lMkMlMjBzb3VyY2VzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHNvdXJjZSUyMGluJTIwc291cmNlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGVfaWRfZm9yX2N1cnJlbnRfc291cmNlJTIwaW4lMjByYW5nZShuKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTdCJTIyZXhhbXBsZV9pZCUyMiUzQSUyMGYlMjIlN0Jzb3VyY2UlN0RfJTdCZXhhbXBsZV9pZF9mb3JfY3VycmVudF9zb3VyY2UlN0QlMjIlN0QlMEElMEFnZW5fa3dhcmdzJTIwJTNEJTIwJTdCJTIybiUyMiUzQSUyMDEwJTJDJTIwJTIyc291cmNlcyUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QlMjIlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDI0KSU1RCU3RCUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRGdlbl9rd2FyZ3MpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQ=",highlighted:`<span class="hljs-comment"># Stream from the internet</span>
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 39</span>

<span class="hljs-comment"># Stream from local files</span>
data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>.csv&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>

<span class="hljs-comment"># From a generator function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n, sources</span>):
    <span class="hljs-keyword">for</span> source <span class="hljs-keyword">in</span> sources:
        <span class="hljs-keyword">for</span> example_id_for_current_source <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
            <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;example_id&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{source}</span>_<span class="hljs-subst">{example_id_for_current_source}</span>&quot;</span>}

gen_kwargs = {<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;sources&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs=gen_kwargs)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),O=new u({props:{title:"Speed differences",local:"speed-differences",headingTag:"h2"}}),se=new y({props:{code:"bXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjB1cCUyMHRvJTIwMTB4JTIwc2xvd2VyJTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuZmxhdHRlbl9pbmRpY2VzKCklMjAlMjAlMjMlMjByZXdyaXRlJTIwdGhlJTIwc2h1ZmZsZWQlMjBkYXRhc2V0JTIwb24lMjBkaXNrJTIwYXMlMjBjb250aWd1b3VzJTIwY2h1bmtzJTIwb2YlMjBkYXRhJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTIwYWdhaW4=",highlighted:`my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast</span>
my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># up to 10x slower</span>
my_dataset = my_dataset.flatten_indices()  <span class="hljs-comment"># rewrite the shuffled dataset on disk as contiguous chunks of data</span>
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast again</span>`,wrap:!1}}),le=new y({props:{code:"Zm9yJTIwZXhhbXBsZSUyMGluJTIwZW51bWVyYXRlKG15X2l0ZXJhYmxlX2RhdGFzZXQpJTNBJTIwJTIwJTIzJTIwZmFzdCUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEFzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5zaHVmZmxlKHNlZWQlM0Q0MiUyQyUyMGJ1ZmZlcl9zaXplJTNEMTAwKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGVudW1lcmF0ZShzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0KSUzQSUyMCUyMCUyMyUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDEzMzclMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMjAlMjAlMjMlMjByZXNodWZmbGluZyUyMHVzaW5nJTIwYW5vdGhlciUyMHNlZWQlMjBpcyUyMGluc3RhbnRhbmVvdXMlMEElMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBlbnVtZXJhdGUoc2h1ZmZsZWRfaXRlcmFibGVfZGF0YXNldCklM0ElMjAlMjAlMjMlMjBzdGlsbCUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(my_iterable_dataset):  <span class="hljs-comment"># fast</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># as fast as before</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">1337</span>, buffer_size=<span class="hljs-number">100</span>)  <span class="hljs-comment"># reshuffling using another seed is instantaneous</span>

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># still as fast as before</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),ie=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG5fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMG15X2l0ZXJhYmxlX2RhdGFzZXQlM0ElMjAlMjAlMjMlMjBmYXN0JTIwJTJCJTIwcmVzaHVmZmxlZCUyMGF0JTIwZWFjaCUyMGVwb2NoJTIwdXNpbmclMjAlNjBlZmZlY3RpdmVfc2VlZCUyMCUzRCUyMHNlZWQlMjAlMkIlMjBlcG9jaCU2MCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):
    my_iterable_dataset.set_epoch(epoch)
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># fast + reshuffled at each epoch using \`effective_seed = seed + epoch\`</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),re=new u({props:{title:"Switch from map-style to iterable",local:"switch-from-map-style-to-iterable",headingTag:"h2"}}),de=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldCgp",highlighted:"my_iterable_dataset = my_dataset.to_iterable_dataset()",wrap:!1}}),oe=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTAyNCklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMTAyNA==",highlighted:`my_iterable_dataset = my_dataset.to_iterable_dataset(num_shards=<span class="hljs-number">1024</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),{c(){M=i("meta"),fe=l(),me=i("p"),ye=l(),p(w.$$.fragment),Me=l(),b=i("p"),b.innerHTML=ma,ue=l(),p(j.$$.fragment),we=l(),J=i("p"),J.innerHTML=ha,be=l(),p(T.$$.fragment),je=l(),U=i("p"),U.innerHTML=fa,Je=l(),_=i("p"),_.textContent=ya,Te=l(),p(g.$$.fragment),Ue=l(),Z=i("p"),Z.innerHTML=Ma,_e=l(),X=i("p"),X.innerHTML=ua,ge=l(),p(I.$$.fragment),Ze=l(),k=i("p"),k.innerHTML=wa,Xe=l(),p(G.$$.fragment),Ie=l(),C=i("p"),C.innerHTML=ba,ke=l(),p($.$$.fragment),Ge=l(),p(v.$$.fragment),Ce=l(),V=i("p"),V.innerHTML=ja,$e=l(),p(R.$$.fragment),ve=l(),B=i("p"),B.textContent=Ja,Ve=l(),F=i("p"),F.innerHTML=Ta,Re=l(),p(Y.$$.fragment),Be=l(),z=i("p"),z.innerHTML=Ua,Fe=l(),p(x.$$.fragment),Ye=l(),Q=i("p"),Q.innerHTML=_a,ze=l(),p(W.$$.fragment),xe=l(),N=i("p"),N.innerHTML=ga,Qe=l(),D=i("p"),D.textContent=Za,We=l(),p(S.$$.fragment),Ne=l(),p(H.$$.fragment),De=l(),E=i("p"),E.innerHTML=Xa,Se=l(),p(A.$$.fragment),He=l(),q=i("p"),q.innerHTML=Ia,Ee=l(),p(L.$$.fragment),Ae=l(),P=i("p"),P.innerHTML=ka,qe=l(),p(K.$$.fragment),Le=l(),p(O.$$.fragment),Pe=l(),ee=i("p"),ee.innerHTML=Ga,Ke=l(),ae=i("p"),ae.innerHTML=Ca,Oe=l(),p(se.$$.fragment),ea=l(),te=i("p"),te.innerHTML=$a,aa=l(),p(le.$$.fragment),sa=l(),ne=i("p"),ne.innerHTML=va,ta=l(),p(ie.$$.fragment),la=l(),p(re.$$.fragment),na=l(),pe=i("p"),pe.innerHTML=Va,ia=l(),p(de.$$.fragment),ra=l(),ce=i("p"),ce.innerHTML=Ra,pa=l(),p(oe.$$.fragment),da=l(),he=i("p"),this.h()},l(e){const a=Na("svelte-u9bgzb",document.head);M=r(a,"META",{name:!0,content:!0}),a.forEach(s),fe=n(e),me=r(e,"P",{}),Ba(me).forEach(s),ye=n(e),d(w.$$.fragment,e),Me=n(e),b=r(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1y5wxk0"&&(b.innerHTML=ma),ue=n(e),d(j.$$.fragment,e),we=n(e),J=r(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1yc4shr"&&(J.innerHTML=ha),be=n(e),d(T.$$.fragment,e),je=n(e),U=r(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1lcyocl"&&(U.innerHTML=fa),Je=n(e),_=r(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-p27tn9"&&(_.textContent=ya),Te=n(e),d(g.$$.fragment,e),Ue=n(e),Z=r(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-qlt0xf"&&(Z.innerHTML=Ma),_e=n(e),X=r(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1ik5e8b"&&(X.innerHTML=ua),ge=n(e),d(I.$$.fragment,e),Ze=n(e),k=r(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-ohku2m"&&(k.innerHTML=wa),Xe=n(e),d(G.$$.fragment,e),Ie=n(e),C=r(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-z2r7k0"&&(C.innerHTML=ba),ke=n(e),d($.$$.fragment,e),Ge=n(e),d(v.$$.fragment,e),Ce=n(e),V=r(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-vep6ve"&&(V.innerHTML=ja),$e=n(e),d(R.$$.fragment,e),ve=n(e),B=r(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-gryvti"&&(B.textContent=Ja),Ve=n(e),F=r(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-gn3sd"&&(F.innerHTML=Ta),Re=n(e),d(Y.$$.fragment,e),Be=n(e),z=r(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-u916f6"&&(z.innerHTML=Ua),Fe=n(e),d(x.$$.fragment,e),Ye=n(e),Q=r(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-jp1tlw"&&(Q.innerHTML=_a),ze=n(e),d(W.$$.fragment,e),xe=n(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-o95ueh"&&(N.innerHTML=ga),Qe=n(e),D=r(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-vsuw18"&&(D.textContent=Za),We=n(e),d(S.$$.fragment,e),Ne=n(e),d(H.$$.fragment,e),De=n(e),E=r(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1rt3hvu"&&(E.innerHTML=Xa),Se=n(e),d(A.$$.fragment,e),He=n(e),q=r(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-24hoal"&&(q.innerHTML=Ia),Ee=n(e),d(L.$$.fragment,e),Ae=n(e),P=r(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-wqkz26"&&(P.innerHTML=ka),qe=n(e),d(K.$$.fragment,e),Le=n(e),d(O.$$.fragment,e),Pe=n(e),ee=r(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-3kafwa"&&(ee.innerHTML=Ga),Ke=n(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-n0x2jo"&&(ae.innerHTML=Ca),Oe=n(e),d(se.$$.fragment,e),ea=n(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-pndz7h"&&(te.innerHTML=$a),aa=n(e),d(le.$$.fragment,e),sa=n(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1yhobsx"&&(ne.innerHTML=va),ta=n(e),d(ie.$$.fragment,e),la=n(e),d(re.$$.fragment,e),na=n(e),pe=r(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-gjrv3o"&&(pe.innerHTML=Va),ia=n(e),d(de.$$.fragment,e),ra=n(e),ce=r(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-e1ce4t"&&(ce.innerHTML=Ra),pa=n(e),d(oe.$$.fragment,e),da=n(e),he=r(e,"P",{}),Ba(he).forEach(s),this.h()},h(){Fa(M,"name","hf:doc:metadata"),Fa(M,"content",Ha)},m(e,a){Da(document.head,M),t(e,fe,a),t(e,me,a),t(e,ye,a),o(w,e,a),t(e,Me,a),t(e,b,a),t(e,ue,a),o(j,e,a),t(e,we,a),t(e,J,a),t(e,be,a),o(T,e,a),t(e,je,a),t(e,U,a),t(e,Je,a),t(e,_,a),t(e,Te,a),o(g,e,a),t(e,Ue,a),t(e,Z,a),t(e,_e,a),t(e,X,a),t(e,ge,a),o(I,e,a),t(e,Ze,a),t(e,k,a),t(e,Xe,a),o(G,e,a),t(e,Ie,a),t(e,C,a),t(e,ke,a),o($,e,a),t(e,Ge,a),o(v,e,a),t(e,Ce,a),t(e,V,a),t(e,$e,a),o(R,e,a),t(e,ve,a),t(e,B,a),t(e,Ve,a),t(e,F,a),t(e,Re,a),o(Y,e,a),t(e,Be,a),t(e,z,a),t(e,Fe,a),o(x,e,a),t(e,Ye,a),t(e,Q,a),t(e,ze,a),o(W,e,a),t(e,xe,a),t(e,N,a),t(e,Qe,a),t(e,D,a),t(e,We,a),o(S,e,a),t(e,Ne,a),o(H,e,a),t(e,De,a),t(e,E,a),t(e,Se,a),o(A,e,a),t(e,He,a),t(e,q,a),t(e,Ee,a),o(L,e,a),t(e,Ae,a),t(e,P,a),t(e,qe,a),o(K,e,a),t(e,Le,a),o(O,e,a),t(e,Pe,a),t(e,ee,a),t(e,Ke,a),t(e,ae,a),t(e,Oe,a),o(se,e,a),t(e,ea,a),t(e,te,a),t(e,aa,a),o(le,e,a),t(e,sa,a),t(e,ne,a),t(e,ta,a),o(ie,e,a),t(e,la,a),o(re,e,a),t(e,na,a),t(e,pe,a),t(e,ia,a),o(de,e,a),t(e,ra,a),t(e,ce,a),t(e,pa,a),o(oe,e,a),t(e,da,a),t(e,he,a),ca=!0},p:za,i(e){ca||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(R.$$.fragment,e),m(Y.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),m(S.$$.fragment,e),m(H.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(oe.$$.fragment,e),ca=!0)},o(e){h(w.$$.fragment,e),h(j.$$.fragment,e),h(T.$$.fragment,e),h(g.$$.fragment,e),h(I.$$.fragment,e),h(G.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(x.$$.fragment,e),h(W.$$.fragment,e),h(S.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(L.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(oe.$$.fragment,e),ca=!1},d(e){e&&(s(fe),s(me),s(ye),s(Me),s(b),s(ue),s(we),s(J),s(be),s(je),s(U),s(Je),s(_),s(Te),s(Ue),s(Z),s(_e),s(X),s(ge),s(Ze),s(k),s(Xe),s(Ie),s(C),s(ke),s(Ge),s(Ce),s(V),s($e),s(ve),s(B),s(Ve),s(F),s(Re),s(Be),s(z),s(Fe),s(Ye),s(Q),s(ze),s(xe),s(N),s(Qe),s(D),s(We),s(Ne),s(De),s(E),s(Se),s(He),s(q),s(Ee),s(Ae),s(P),s(qe),s(Le),s(Pe),s(ee),s(Ke),s(ae),s(Oe),s(ea),s(te),s(aa),s(sa),s(ne),s(ta),s(la),s(na),s(pe),s(ia),s(ra),s(ce),s(pa),s(da),s(he)),s(M),f(w,e),f(j,e),f(T,e),f(g,e),f(I,e),f(G,e),f($,e),f(v,e),f(R,e),f(Y,e),f(x,e),f(W,e),f(S,e),f(H,e),f(A,e),f(L,e),f(K,e),f(O,e),f(se,e),f(le,e),f(ie,e),f(re,e),f(de,e),f(oe,e)}}}const Ha='{"title":"Differences between Dataset and IterableDataset","local":"differences-between-dataset-and-iterabledataset","sections":[{"title":"Downloading and streaming","local":"downloading-and-streaming","sections":[],"depth":2},{"title":"Creating map-style datasets and iterable datasets","local":"creating-map-style-datasets-and-iterable-datasets","sections":[],"depth":2},{"title":"Loading local files entirely and progressively","local":"loading-local-files-entirely-and-progressively","sections":[],"depth":2},{"title":"Eager data processing and lazy data processing","local":"eager-data-processing-and-lazy-data-processing","sections":[],"depth":2},{"title":"Exact and fast approximate shuffling","local":"exact-and-fast-approximate-shuffling","sections":[],"depth":2},{"title":"Speed differences","local":"speed-differences","sections":[],"depth":2},{"title":"Switch from map-style to iterable","local":"switch-from-map-style-to-iterable","sections":[],"depth":2}],"depth":1}';function Ea(oa){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends Qa{constructor(M){super(),Wa(this,M,Ea,Sa,Ya,{})}}export{Ka as component};
