import{s as Mr,o as Tr,n as U}from"../chunks/scheduler.bdbef820.js";import{S as Jr,i as Cr,g as c,s as o,r as f,A as kr,h as p,f as i,c as r,j as M,u as h,x as v,k as T,y as n,a as u,v as _,d as b,t as $,w as x}from"../chunks/index.c0aea24a.js";import{D as J}from"../chunks/Docstring.34291e8a.js";import{C as R}from"../chunks/CodeBlock.6ccca92e.js";import{E as k}from"../chunks/ExampleCodeBlock.241e4203.js";import{H as es,E as Ur}from"../chunks/EditOnGithub.725ee0c1.js";function Rr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSgpJTBBZHMlMjAlM0QlMjBidWlsZGVyLmFzX2RhdGFzZXQoc3BsaXQlM0QndHJhaW4nKSUwQWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = builder.as_dataset(split=<span class="hljs-string">&#x27;train&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">8530</span>
})`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function jr(y){let a,w="Download and prepare the dataset as Arrow files that can be loaded as a Dataset using <code>builder.as_dataset()</code>:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-i6fpq7"&&(a.innerHTML=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Gr(y){let a,w="Download and prepare the dataset as sharded Parquet files locally:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoJTIyLiUyRm91dHB1dF9kaXIlMjIlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;./output_dir&quot;</span>, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1035kd7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Nr(y){let a,w="Download and prepare the dataset as sharded Parquet files in a cloud storage:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFzdG9yYWdlX29wdGlvbnMlMjAlM0QlMjAlN0IlMjJrZXklMjIlM0ElMjBhd3NfYWNjZXNzX2tleV9pZCUyQyUyMCUyMnNlY3JldCUyMiUzQSUyMGF3c19zZWNyZXRfYWNjZXNzX2tleSU3RCUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJyb3R0ZW5fdG9tYXRvZXMlMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSglMjJzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRm15X3JvdHRlbl90b21hdG9lcyUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;s3://my-bucket/my_rotten_tomatoes&quot;</span>, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-y7m7rz"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Ir(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfYWxsX2V4cG9ydGVkX2RhdGFzZXRfaW5mb3MoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_all_exported_dataset_infos()
{<span class="hljs-string">&#x27;default&#x27;</span>: DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)}</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Xr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfZXhwb3J0ZWRfZGF0YXNldF9pbmZvKCklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_exported_dataset_info()
DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Zr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Br(y){let a,w="Is roughly equivalent to:",d,s,l;return s=new R({props:{code:"ZXh0cmFjdGVkX3BhdGhzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRsX21hbmFnZXIuZG93bmxvYWQodXJsX29yX3VybHMpKQ==",highlighted:'<span class="hljs-attr">extracted_paths</span> = dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-yva38v"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Dr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Fr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function zr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Sr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Vr(y){let a,w="Is equivalent to:",d,s,l;return s=new R({props:{code:"dXJscyUyMCUzRCUyMGRsX21hbmFnZXIuZXh0cmFjdChkbF9tYW5hZ2VyLmRvd25sb2FkKHVybF9vcl91cmxzKSk=",highlighted:'<span class="hljs-attribute">urls</span> <span class="hljs-operator">=</span> dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-b0lbw9"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Er(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Qr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Lr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Yr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KHVybCklN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and_extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Wr(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVkFMSURBVElPTiUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVEVTVCUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ0ZXN0JTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.VALIDATION,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;validation&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TEST,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;test&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Hr(y){let a,w="Each descriptor can be composed with other using addition or slice:",d,s,l;return s=new R({props:{code:"c3BsaXQlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCMCUzQTI1JTVEKSUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1Q=",highlighted:'split = datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">0</span>:<span class="hljs-number">25</span>]) + datasets.Split.TEST',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-in376m"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Ar(y){let a,w="A split cannot be added twice, so the following will fail:",d,s,l;return s=new R({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRSQUlOLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUI3NSUzQSU1RCklMEEpJTIwJTIwJTIzJTIwRXJyb3IlMEFzcGxpdCUyMCUzRCUyMGRhdGFzZXRzLlNwbGl0LlRFU1QlMjAlMkIlMjBkYXRhc2V0cy5TcGxpdC5BTEwlMjAlMjAlMjMlMjBFcnJvcg==",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">75</span>:])
)  <span class="hljs-comment"># Error</span>
split = datasets.Split.TEST + datasets.Split.ALL  <span class="hljs-comment"># Error</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1dn84z5"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Pr(y){let a,w="The slices can be applied only one time. So the following are valid:",d,s,l;return s=new R({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRFU1Quc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKSUwQSklMEFzcGxpdCUyMCUzRCUyMChkYXRhc2V0cy5TcGxpdC5UUkFJTiUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1QpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0E1MCU1RCk=",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TEST.subsplit(datasets.percent[:<span class="hljs-number">50</span>])
)
split = (datasets.Split.TRAIN + datasets.Split.TEST).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-f377rx"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function qr(y){let a,w="But this is not valid:",d,s,l;return s=new R({props:{code:"dHJhaW4lMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTiUwQXRlc3QlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5URVNUJTBBc3BsaXQlMjAlM0QlMjB0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0EyNSU1RCklMEFzcGxpdCUyMCUzRCUyMCh0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpJTIwJTJCJTIwdGVzdCkuc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKQ==",highlighted:`train = datasets.Split.TRAIN
test = datasets.Split.TEST
split = train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]).subsplit(datasets.percent[:<span class="hljs-number">25</span>])
split = (train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) + test).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1jf0xuu"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Or(y){let a,w="Examples:",d,s,l;return s=new R({props:{code:"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",highlighted:`<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(<span class="hljs-string">&#x27;test[:33%]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=(
datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>) +
datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=<span class="hljs-number">1</span>, to=-<span class="hljs-number">1</span>, unit=<span class="hljs-string">&#x27;abs&#x27;</span>)))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>, rounding=<span class="hljs-string">&quot;pct1_dropremainder&quot;</span>))

<span class="hljs-comment"># 10-fold validation:</span>
tests = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k, to=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])
trains = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, to=k, unit=<span class="hljs-string">&#x27;%&#x27;</span>) + datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Kr(y){let a,w="Examples:",d,s,l;return s=new R({props:{code:"dGVzdCUzQSUyMHRlc3QlMjBzcGxpdC4lMEF0ZXN0JTIwJTJCJTIwdmFsaWRhdGlvbiUzQSUyMHRlc3QlMjBzcGxpdCUyMCUyQiUyMHZhbGlkYXRpb24lMjBzcGxpdC4lMEF0ZXN0JTVCMTAlM0ElNUQlM0ElMjB0ZXN0JTIwc3BsaXQlMkMlMjBtaW51cyUyMGl0cyUyMGZpcnN0JTIwMTAlMjByZWNvcmRzLiUwQXRlc3QlNUIlM0ExMCUyNSU1RCUzQSUyMGZpcnN0JTIwMTAlMjUlMjByZWNvcmRzJTIwb2YlMjB0ZXN0JTIwc3BsaXQuJTBBdGVzdCU1QiUzQTIwJTI1JTVEKHBjdDFfZHJvcHJlbWFpbmRlciklM0ElMjBmaXJzdCUyMDEwJTI1JTIwcmVjb3JkcyUyQyUyMHJvdW5kZWQlMjB3aXRoJTIwdGhlJTIwcGN0MV9kcm9wcmVtYWluZGVyJTIwcm91bmRpbmcuJTBBdGVzdCU1QiUzQS01JTI1JTVEJTJCdHJhaW4lNUI0MCUyNSUzQTYwJTI1JTVEJTNBJTIwZmlyc3QlMjA5NSUyNSUyMG9mJTIwdGVzdCUyMCUyQiUyMG1pZGRsZSUyMDIwJTI1JTIwb2YlMjB0cmFpbi4=",highlighted:`<span class="hljs-keyword">test: test</span> split.
<span class="hljs-keyword">test </span>+ validation: test split + validation split.
test[10:]: test split, minus its first 10 records.
test[:10%]: first 10% records of test split.
test[:20%](pct1_dropremainder): first 10% records, rounded with the pct1_dropremainder rounding.
test[:<span class="hljs-string">-5</span>%]+train[40%:60%]: first 95% of test + middle 20% of train.`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function el(y){let a,w="Example:",d,s,l;return s=new R({props:{code:"VkVSU0lPTiUyMCUzRCUyMGRhdGFzZXRzLlZlcnNpb24oJTIyMS4wLjAlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>VERSION = datasets.Version(<span class="hljs-string">&quot;1.0.0&quot;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:U,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function tl(y){let a,w,d,s,l,e,m,as,rt,xo='🤗 Datasets relies on two main classes during the dataset building process: <a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a> and <a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a>.',ss,C,lt,Js,Ht,vo="Abstract base class for all datasets.",Cs,At,wo="<code>DatasetBuilder</code> has 3 key methods:",ks,Pt,yo=`<li><code>DatasetBuilder.info</code>: Documents the dataset, including feature
names, types, shapes, version, splits, citation, etc.</li> <li><a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.DatasetBuilder.download_and_prepare">DatasetBuilder.download_and_prepare()</a>: Downloads the source data
and writes it to disk.</li> <li><a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.DatasetBuilder.as_dataset">DatasetBuilder.as_dataset()</a>: Generates a <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a>.</li>`,Us,qt,Mo=`Some <code>DatasetBuilder</code>s expose multiple variants of the
dataset by defining a <a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass and accepting a
config object (or name) on construction. Configurable datasets expose a
pre-defined set of configurations in <code>DatasetBuilder.builder_configs()</code>.`,Rs,re,dt,js,Ot,To="Return a Dataset for the specified split.",Gs,Ne,Ns,B,it,Is,Kt,Jo="Downloads and prepares dataset for reading.",Xs,ea,Co="Example:",Zs,Ie,Bs,Xe,Ds,Ze,Fs,le,ct,zs,ta,ko="Empty dict if doesn’t exist",Ss,Be,Vs,de,pt,Es,aa,Uo="Empty <code>DatasetInfo</code> if doesn’t exist",Qs,De,Ls,Fe,mt,Ys,sa,Ro="Return the path of the module of this class or subclass.",ns,K,gt,Ws,na,jo="Base class for datasets with data generation based on dict generators.",Hs,oa,Go=`<code>GeneratorBasedBuilder</code> is a convenience class that abstracts away much
of the data writing and reading of <code>DatasetBuilder</code>. It expects subclasses to
implement generators of feature dictionaries across the dataset splits
(<code>_split_generators</code>). See the method docstrings for details.`,os,$e,ut,As,ra,No="Base class for datasets with data generation based on Arrow loading functions (CSV/JSON/Parquet).",rs,L,ft,Ps,la,Io="Base class for <code>DatasetBuilder</code> data configuration.",qs,da,Xo=`<code>DatasetBuilder</code> subclasses with data configuration options should subclass
<code>BuilderConfig</code> and add their own properties.`,Os,A,ht,Ks,ia,Zo=`The config id is used to build the cache directory.
By default it is equal to the config name.
However the name of a config is not sufficient to have a unique identifier for the dataset being generated
since it doesn’t take into account:`,en,ca,Bo="<li>the config kwargs that can be used to overwrite attributes</li> <li>the custom features used to write the dataset</li> <li>the data_files for json/text/csv/pandas datasets</li>",tn,pa,Do="Therefore the config id is just the config name with an optional suffix based on these.",ls,_t,ds,X,bt,an,P,$t,sn,ma,Fo="Download given URL(s).",nn,ga,zo="By default, only one process is used for download. Pass customized <code>download_config.num_proc</code> to change this behavior.",on,ze,rn,ie,xt,ln,ua,So="Download and extract given <code>url_or_urls</code>.",dn,Se,cn,ce,vt,pn,fa,Vo="Extract given path(s).",mn,Ve,gn,pe,wt,un,ha,Eo="Iterate over files within an archive.",fn,Ee,hn,me,yt,_n,_a,Qo="Iterate over file paths.",bn,Qe,is,N,Mt,$n,ba,Lo=`Download manager that uses the ”::” separator to navigate through (possibly remote) compressed archives.
Contrary to the regular <code>DownloadManager</code>, the <code>download</code> and <code>extract</code> methods don’t actually download nor extract
data, but they rather return the path or url that could be opened using the <code>xopen</code> function which extends the
built-in <code>open</code> function to stream data from remote files.`,xn,ge,Tt,vn,$a,Yo=`Normalize URL(s) of files to stream data from.
This is the lazy version of <code>DownloadManager.download</code> for streaming.`,wn,Le,yn,q,Jt,Mn,xa,Wo="Prepare given <code>url_or_urls</code> for streaming (add extraction protocol).",Tn,va,Ho="This is the lazy version of <code>DownloadManager.download_and_extract</code> for streaming.",Jn,Ye,Cn,O,Ct,kn,wa,Ao="Add extraction protocol for given url(s) for streaming.",Un,ya,Po="This is the lazy version of <code>DownloadManager.extract</code> for streaming.",Rn,We,jn,ue,kt,Gn,Ma,qo="Iterate over files within an archive.",Nn,He,In,fe,Ut,Xn,Ta,Oo="Iterate over files.",Zn,Ae,cs,xe,Rt,Bn,Ja,Ko="Configuration for our cached path manager.",ps,F,jt,Dn,Ca,er="<code>Enum</code> for how to treat pre-existing downloads and data.",Fn,ka,tr=`The default mode is <code>REUSE_DATASET_IF_EXISTS</code>, which will reuse both
raw downloads and the prepared dataset if they exist.`,zn,Ua,ar="The generations modes:",Sn,Ra,sr="<thead><tr><th></th> <th>Downloads</th> <th>Dataset</th></tr></thead> <tbody><tr><td><code>REUSE_DATASET_IF_EXISTS</code> (default)</td> <td>Reuse</td> <td>Reuse</td></tr> <tr><td><code>REUSE_CACHE_IF_EXISTS</code></td> <td>Reuse</td> <td>Fresh</td></tr> <tr><td><code>FORCE_REDOWNLOAD</code></td> <td>Fresh</td> <td>Fresh</td></tr></tbody>",ms,Gt,gs,z,Nt,Vn,ja,nr="<code>Enum</code> that specifies which verification checks to run.",En,Ga,or=`The default mode is <code>BASIC_CHECKS</code>, which will perform only rudimentary checks to avoid slowdowns
when generating/downloading a dataset for the first time.`,Qn,Na,rr="The verification modes:",Ln,Ia,lr="<thead><tr><th></th> <th>Verification checks</th></tr></thead> <tbody><tr><td><code>ALL_CHECKS</code></td> <td>Split checks, uniqueness of the keys yielded in case of the GeneratorBuilder</td></tr> <tr><td></td> <td>and the validity (number of files, checksums, etc.) of downloaded files</td></tr> <tr><td><code>BASIC_CHECKS</code> (default)</td> <td>Same as <code>ALL_CHECKS</code> but without checking downloaded files</td></tr> <tr><td><code>NO_CHECKS</code></td> <td>None</td></tr></tbody>",us,It,fs,Y,Xt,Yn,Xa,dr="Defines the split information for the generator.",Wn,Za,ir=`This should be used as returned value of
<code>GeneratorBasedBuilder._split_generators</code>.
See <code>GeneratorBasedBuilder._split_generators</code> for more info and example
of usage.`,Hn,Pe,hs,I,Zt,An,Ba,cr="<code>Enum</code> for dataset splits.",Pn,Da,pr=`Datasets are typically split into different subsets to be used at various
stages of training and evaluation.`,qn,Fa,mr=`<li><code>TRAIN</code>: the training data.</li> <li><code>VALIDATION</code>: the validation data. If present, this is typically used as
evaluation data while iterating on a model (e.g. changing hyperparameters,
model architecture, etc.).</li> <li><code>TEST</code>: the testing data. This is the data to report metrics on. Typically
you do not want to use this during model iteration as you may overfit to it.</li> <li><code>ALL</code>: the union of all defined dataset splits.</li>`,On,za,gr="All splits, including compositions inherit from <code>datasets.SplitBase</code>.",Kn,Sa,ur='See the <a href="../load_hub#splits">guide</a> on splits for more information.',eo,qe,_s,G,Bt,to,Va,fr="Descriptor corresponding to a named split (train, test, …).",ao,Ea,hr="Example:",so,Oe,no,Qa,_r=`The resulting split will correspond to 25% of the train split merged with
100% of the test split.`,oo,Ke,ro,et,lo,tt,bs,ve,Dt,io,La,br="Split corresponding to the union of all defined dataset splits.",$s,S,Ft,co,Ya,$r="Reading instruction for a dataset.",po,at,mo,he,zt,go,Wa,xr="Creates a <code>ReadInstruction</code> instance out of a string spec.",uo,st,fo,_e,St,ho,Ha,vr="Translate instruction into a list of absolute instructions.",_o,Aa,wr="Those absolute instructions are then to be added together.",xs,Vt,vs,ee,Et,bo,Pa,yr="Dataset version <code>MAJOR.MINOR.PATCH</code>.",$o,nt,ws,Qt,ys,ts,Ms;return l=new es({props:{title:"Builder classes",local:"builder-classes",headingTag:"h1"}}),m=new es({props:{title:"Builders",local:"datasets.DatasetBuilder",headingTag:"h2"}}),lt=new J({props:{name:"class datasets.DatasetBuilder",anchor:"datasets.DatasetBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to cache data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.DatasetBuilder.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset, if different from the builder name. Useful for packaged builders
like csv, imagefolder, audiofolder, etc. to reflect the difference between datasets
that use the same packaged builder.`,name:"dataset_name"},{anchor:"datasets.DatasetBuilder.config_name",description:`<strong>config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset configuration.
It affects the data generated on disk. Different configurations will have their own subdirectories and
versions.
If not provided, the default configuration is used (if it exists).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.3.0</p>
						
<p>Parameter <code>name</code> was renamed to <code>config_name</code>.</p>

					</div>`,name:"config_name"},{anchor:"datasets.DatasetBuilder.hash",description:`<strong>hash</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hash specific to the dataset code. Used to update the caching directory when the
dataset loading script code is updated (to avoid reusing old data).
The typical caching directory (defined in <code>self._relative_data_dir</code>) is <code>name/version/hash/</code>.`,name:"hash"},{anchor:"datasets.DatasetBuilder.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files.
This can be a remote URL.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.features",description:`<strong>features</strong> (<a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Features">Features</a>, <em>optional</em>) &#x2014;
Features types to use with this dataset.
It can be used to change the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Features">Features</a> types of a dataset, for example.`,name:"features"},{anchor:"datasets.DatasetBuilder.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
String or boolean to use as Bearer token for remote files on the
Datasets Hub. If <code>True</code>, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.DatasetBuilder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset repository.
Used to distinguish builders with the same name but not coming from the same namespace, for example &#x201C;squad&#x201D;
and &#x201C;lhoestq/squad&#x201D; repo IDs. In the latter, the builder name would be &#x201C;lhoestq___squad&#x201D;.`,name:"repo_id"},{anchor:"datasets.DatasetBuilder.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).
For builders like &#x201C;csv&#x201D; or &#x201C;json&#x201D; that need the user to specify data files. They can be either
local or remote files. For convenience, you can use a <code>DataFilesDict</code>.`,name:"data_files"},{anchor:"datasets.DatasetBuilder.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to directory containing source data file(s).
Use only if <code>data_files</code> is not passed, in which case it is equivalent to passing
<code>os.path.join(data_dir, &quot;**&quot;)</code> as <code>data_files</code>.
For builders that require manual download, it must be the path to the local directory containing the
manually downloaded data.`,name:"data_dir"},{anchor:"datasets.DatasetBuilder.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.writer_batch_size",description:`<strong>writer_batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size used by the ArrowWriter.
It defines the number of samples that are kept in memory before writing them
and also the length of the arrow chunks.
None means that the ArrowWriter will use its default value.`,name:"writer_batch_size"},{anchor:"datasets.DatasetBuilder.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments to be passed to the corresponding builder
configuration class, set on the class attribute <a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.BuilderConfig">DatasetBuilder.BUILDER_CONFIG_CLASS</a>. The builder
configuration class is <a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> or a subclass of it.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L209"}}),dt=new J({props:{name:"as_dataset",anchor:"datasets.DatasetBuilder.as_dataset",parameters:[{name:"split",val:": Optional = None"},{name:"run_post_process",val:" = True"},{name:"verification_mode",val:": Union = None"},{name:"in_memory",val:" = False"}],parametersDescription:[{anchor:"datasets.DatasetBuilder.as_dataset.split",description:`<strong>split</strong> (<code>datasets.Split</code>) &#x2014;
Which subset of the data to return.`,name:"split"},{anchor:"datasets.DatasetBuilder.as_dataset.run_post_process",description:`<strong>run_post_process</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to run post-processing dataset transforms and/or add
indexes.`,name:"run_post_process"},{anchor:"datasets.DatasetBuilder.as_dataset.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.as_dataset.in_memory",description:`<strong>in_memory</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to copy the data in-memory.`,name:"in_memory"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L1065",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>datasets.Dataset</p>
`}}),Ne=new k({props:{anchor:"datasets.DatasetBuilder.as_dataset.example",$$slots:{default:[Rr]},$$scope:{ctx:y}}}),it=new J({props:{name:"download_and_prepare",anchor:"datasets.DatasetBuilder.download_and_prepare",parameters:[{name:"output_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"verification_mode",val:": Union = None"},{name:"dl_manager",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"file_format",val:": str = 'arrow'"},{name:"max_shard_size",val:": Union = None"},{name:"num_proc",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"**download_and_prepare_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.download_and_prepare.output_dir",description:`<strong>output_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Output directory for the dataset.
Default to this builder&#x2019;s <code>cache_dir</code>, which is inside <code>~/.cache/huggingface/datasets</code> by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"output_dir"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_config",description:`<strong>download_config</strong> (<code>DownloadConfig</code>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, <em>optional</em>) &#x2014;
Select the download/generate mode, default to <code>REUSE_DATASET_IF_EXISTS</code>.`,name:"download_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/v3.0.2/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.dl_manager",description:`<strong>dl_manager</strong> (<code>DownloadManager</code>, <em>optional</em>) &#x2014;
Specific <code>DownloadManger</code> to use.`,name:"dl_manager"},{anchor:"datasets.DatasetBuilder.download_and_prepare.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files. This can be a remote url.
If not specified, the value of the <code>base_path</code> attribute (<code>self.base_path</code>) will be used instead.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.download_and_prepare.file_format",description:`<strong>file_format</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Format of the data files in which the dataset will be written.
Supported formats: &#x201C;arrow&#x201D;, &#x201C;parquet&#x201D;. Default to &#x201C;arrow&#x201D; format.
If the format is &#x201C;parquet&#x201D;, then image and audio data are embedded into the Parquet files instead of pointing to local files.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"file_format"},{anchor:"datasets.DatasetBuilder.download_and_prepare.max_shard_size",description:`<strong>max_shard_size</strong> (<code>Union[str, int]</code>, <em>optional</em>) &#x2014;
Maximum number of bytes written per shard, default is &#x201C;500MB&#x201D;.
The size is based on uncompressed data size, so in practice your shard files may be smaller than
<code>max_shard_size</code> thanks to Parquet compression for example.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"max_shard_size"},{anchor:"datasets.DatasetBuilder.download_and_prepare.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes when downloading and generating the dataset locally.
Multiprocessing is disabled by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.7.0</p>
						
					</div>`,name:"num_proc"},{anchor:"datasets.DatasetBuilder.download_and_prepare.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the caching file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.download_and_prepare.*download_and_prepare_kwargs",description:"*<strong>*download_and_prepare_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments.",name:"*download_and_prepare_kwargs"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L721"}}),Ie=new k({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example",$$slots:{default:[jr]},$$scope:{ctx:y}}}),Xe=new k({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-2",$$slots:{default:[Gr]},$$scope:{ctx:y}}}),Ze=new k({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-3",$$slots:{default:[Nr]},$$scope:{ctx:y}}}),ct=new J({props:{name:"get_all_exported_dataset_infos",anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos",parameters:[],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L505"}}),Be=new k({props:{anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos.example",$$slots:{default:[Ir]},$$scope:{ctx:y}}}),pt=new J({props:{name:"get_exported_dataset_info",anchor:"datasets.DatasetBuilder.get_exported_dataset_info",parameters:[],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L520"}}),De=new k({props:{anchor:"datasets.DatasetBuilder.get_exported_dataset_info.example",$$slots:{default:[Xr]},$$scope:{ctx:y}}}),mt=new J({props:{name:"get_imported_module_dir",anchor:"datasets.DatasetBuilder.get_imported_module_dir",parameters:[],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L713"}}),gt=new J({props:{name:"class datasets.GeneratorBasedBuilder",anchor:"datasets.GeneratorBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L1394"}}),ut=new J({props:{name:"class datasets.ArrowBasedBuilder",anchor:"datasets.ArrowBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L1659"}}),ft=new J({props:{name:"class datasets.BuilderConfig",anchor:"datasets.BuilderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"}],parametersDescription:[{anchor:"datasets.BuilderConfig.name",description:`<strong>name</strong> (<code>str</code>, defaults to <code>default</code>) &#x2014;
The name of the configuration.`,name:"name"},{anchor:"datasets.BuilderConfig.version",description:`<strong>version</strong> (<code>Version</code> or <code>str</code>, defaults to <code>0.0.0</code>) &#x2014;
The version of the configuration.`,name:"version"},{anchor:"datasets.BuilderConfig.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the directory containing the source data.`,name:"data_dir"},{anchor:"datasets.BuilderConfig.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.BuilderConfig.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A human description of the configuration.`,name:"description"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L95"}}),ht=new J({props:{name:"create_config_id",anchor:"datasets.BuilderConfig.create_config_id",parameters:[{name:"config_kwargs",val:": dict"},{name:"custom_features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/builder.py#L139"}}),_t=new es({props:{title:"Download",local:"datasets.DownloadManager",headingTag:"h2"}}),bt=new J({props:{name:"class datasets.DownloadManager",anchor:"datasets.DownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"record_checksums",val:" = True"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L71"}}),$t=new J({props:{name:"download",anchor:"datasets.DownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downloaded paths matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list</code> or <code>dict</code></p>
`}}),ze=new k({props:{anchor:"datasets.DownloadManager.download.example",$$slots:{default:[Zr]},$$scope:{ctx:y}}}),xt=new J({props:{name:"download_and_extract",anchor:"datasets.DownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, extracted paths of given URL(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Se=new k({props:{anchor:"datasets.DownloadManager.download_and_extract.example",$$slots:{default:[Br]},$$scope:{ctx:y}}}),vt=new J({props:{name:"extract",anchor:"datasets.DownloadManager.extract",parameters:[{name:"path_or_paths",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.extract.path_or_paths",description:`<strong>path_or_paths</strong> (path or <code>list</code> or <code>dict</code>) &#x2014;
Path of file to extract. Each path is a <code>str</code>.`,name:"path_or_paths"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L278",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The extracted paths matching the given input
path_or_paths.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Ve=new k({props:{anchor:"datasets.DownloadManager.extract.example",$$slots:{default:[Dr]},$$scope:{ctx:y}}}),wt=new J({props:{name:"iter_archive",anchor:"datasets.DownloadManager.iter_archive",parameters:[{name:"path_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_archive.path_or_buf",description:`<strong>path_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"path_or_buf"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L234",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),Ee=new k({props:{anchor:"datasets.DownloadManager.iter_archive.example",$$slots:{default:[Fr]},$$scope:{ctx:y}}}),yt=new J({props:{name:"iter_files",anchor:"datasets.DownloadManager.iter_files",parameters:[{name:"paths",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_files.paths",description:`<strong>paths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"paths"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L259",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,isYield:!0}}),Qe=new k({props:{anchor:"datasets.DownloadManager.iter_files.example",$$slots:{default:[zr]},$$scope:{ctx:y}}}),Mt=new J({props:{name:"class datasets.StreamingDownloadManager",anchor:"datasets.StreamingDownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L46"}}),Tt=new J({props:{name:"download",anchor:"datasets.StreamingDownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input url_or_urls.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Le=new k({props:{anchor:"datasets.StreamingDownloadManager.download.example",$$slots:{default:[Sr]},$$scope:{ctx:y}}}),Jt=new J({props:{name:"download_and_extract",anchor:"datasets.StreamingDownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) to stream from data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L148",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Ye=new k({props:{anchor:"datasets.StreamingDownloadManager.download_and_extract.example",$$slots:{default:[Vr]},$$scope:{ctx:y}}}),Ct=new J({props:{name:"extract",anchor:"datasets.StreamingDownloadManager.extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),We=new k({props:{anchor:"datasets.StreamingDownloadManager.extract.example",$$slots:{default:[Er]},$$scope:{ctx:y}}}),kt=new J({props:{name:"iter_archive",anchor:"datasets.StreamingDownloadManager.iter_archive",parameters:[{name:"urlpath_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_archive.urlpath_or_buf",description:`<strong>urlpath_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"urlpath_or_buf"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L168",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),He=new k({props:{anchor:"datasets.StreamingDownloadManager.iter_archive.example",$$slots:{default:[Qr]},$$scope:{ctx:y}}}),Ut=new J({props:{name:"iter_files",anchor:"datasets.StreamingDownloadManager.iter_files",parameters:[{name:"urlpaths",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_files.urlpaths",description:`<strong>urlpaths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"urlpaths"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/streaming_download_manager.py#L193",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`,isYield:!0}}),Ae=new k({props:{anchor:"datasets.StreamingDownloadManager.iter_files.example",$$slots:{default:[Lr]},$$scope:{ctx:y}}}),Rt=new J({props:{name:"class datasets.DownloadConfig",anchor:"datasets.DownloadConfig",parameters:[{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"user_agent",val:": Optional = None"},{name:"extract_compressed_file",val:": bool = False"},{name:"force_extract",val:": bool = False"},{name:"delete_extracted",val:": bool = False"},{name:"extract_on_the_fly",val:": bool = False"},{name:"use_etag",val:": bool = True"},{name:"num_proc",val:": Optional = None"},{name:"max_retries",val:": int = 1"},{name:"token",val:": Union = None"},{name:"storage_options",val:": Dict = <factory>"},{name:"download_desc",val:": Optional = None"},{name:"disable_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"datasets.DownloadConfig.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
Specify a cache directory to save the file to (overwrite the
default cache dir).`,name:"cache_dir"},{anchor:"datasets.DownloadConfig.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, re-dowload the file even if it&#x2019;s already cached in
the cache dir.`,name:"force_download"},{anchor:"datasets.DownloadConfig.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, resume the download if an incompletely received file is
found.`,name:"resume_download"},{anchor:"datasets.DownloadConfig.proxies",description:"<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;",name:"proxies"},{anchor:"datasets.DownloadConfig.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional string or dict that will be appended to the user-agent on remote
requests.`,name:"user_agent"},{anchor:"datasets.DownloadConfig.extract_compressed_file",description:`<strong>extract_compressed_file</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> and the path point to a zip or tar file,
extract the compressed file in a folder along the archive.`,name:"extract_compressed_file"},{anchor:"datasets.DownloadConfig.force_extract",description:`<strong>force_extract</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> when <code>extract_compressed_file</code> is <code>True</code> and the archive
was already extracted, re-extract the archive and override the folder where it was extracted.`,name:"force_extract"},{anchor:"datasets.DownloadConfig.delete_extracted",description:`<strong>delete_extracted</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to delete (or keep) the extracted files.`,name:"delete_extracted"},{anchor:"datasets.DownloadConfig.extract_on_the_fly",description:`<strong>extract_on_the_fly</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, extract compressed files while they are being read.`,name:"extract_on_the_fly"},{anchor:"datasets.DownloadConfig.use_etag",description:`<strong>use_etag</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the ETag HTTP response header to validate the cached files.`,name:"use_etag"},{anchor:"datasets.DownloadConfig.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of processes to launch to download the files in parallel.`,name:"num_proc"},{anchor:"datasets.DownloadConfig.max_retries",description:`<strong>max_retries</strong> (<code>int</code>, default to <code>1</code>) &#x2014;
The number of times to retry an HTTP request if it fails.`,name:"max_retries"},{anchor:"datasets.DownloadConfig.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.`,name:"token"},{anchor:"datasets.DownloadConfig.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DownloadConfig.download_desc",description:`<strong>download_desc</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A description to be displayed alongside with the progress bar while downloading the files.`,name:"download_desc"},{anchor:"datasets.DownloadConfig.disable_tqdm",description:`<strong>disable_tqdm</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the individual files download progress bar`,name:"disable_tqdm"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_config.py#L9"}}),jt=new J({props:{name:"class datasets.DownloadMode",anchor:"datasets.DownloadMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/download/download_manager.py#L50"}}),Gt=new es({props:{title:"Verification",local:"datasets.VerificationMode",headingTag:"h2"}}),Nt=new J({props:{name:"class datasets.VerificationMode",anchor:"datasets.VerificationMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/utils/info_utils.py#L22"}}),It=new es({props:{title:"Splits",local:"datasets.SplitGenerator",headingTag:"h2"}}),Xt=new J({props:{name:"class datasets.SplitGenerator",anchor:"datasets.SplitGenerator",parameters:[{name:"name",val:": str"},{name:"gen_kwargs",val:": Dict = <factory>"}],parametersDescription:[{anchor:"datasets.SplitGenerator.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the <code>Split</code> for which the generator will
create the examples.`,name:"name"},{anchor:"datasets.SplitGenerator.*gen_kwargs",description:`*<strong>*gen_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to forward to the <code>DatasetBuilder._generate_examples</code> method
of the builder.`,name:"*gen_kwargs"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/splits.py#L601"}}),Pe=new k({props:{anchor:"datasets.SplitGenerator.example",$$slots:{default:[Yr]},$$scope:{ctx:y}}}),Zt=new J({props:{name:"class datasets.Split",anchor:"datasets.Split",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/splits.py#L406"}}),qe=new k({props:{anchor:"datasets.Split.example",$$slots:{default:[Wr]},$$scope:{ctx:y}}}),Bt=new J({props:{name:"class datasets.NamedSplit",anchor:"datasets.NamedSplit",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/splits.py#L314"}}),Oe=new k({props:{anchor:"datasets.NamedSplit.example",$$slots:{default:[Hr]},$$scope:{ctx:y}}}),Ke=new k({props:{anchor:"datasets.NamedSplit.example-2",$$slots:{default:[Ar]},$$scope:{ctx:y}}}),et=new k({props:{anchor:"datasets.NamedSplit.example-3",$$slots:{default:[Pr]},$$scope:{ctx:y}}}),tt=new k({props:{anchor:"datasets.NamedSplit.example-4",$$slots:{default:[qr]},$$scope:{ctx:y}}}),Dt=new J({props:{name:"class datasets.NamedSplitAll",anchor:"datasets.NamedSplitAll",parameters:[],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/splits.py#L391"}}),Ft=new J({props:{name:"class datasets.ReadInstruction",anchor:"datasets.ReadInstruction",parameters:[{name:"split_name",val:""},{name:"rounding",val:" = None"},{name:"from_",val:" = None"},{name:"to",val:" = None"},{name:"unit",val:" = None"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/arrow_reader.py#L456"}}),at=new k({props:{anchor:"datasets.ReadInstruction.example",$$slots:{default:[Or]},$$scope:{ctx:y}}}),zt=new J({props:{name:"from_spec",anchor:"datasets.ReadInstruction.from_spec",parameters:[{name:"spec",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.from_spec.spec",description:`<strong>spec</strong> (<code>str</code>) &#x2014;
Split(s) + optional slice(s) to read + optional rounding
if percents are used as the slicing unit. A slice can be specified,
using absolute numbers (<code>int</code>) or percentages (<code>int</code>).`,name:"spec"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/arrow_reader.py#L536",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>ReadInstruction instance.</p>
`}}),st=new k({props:{anchor:"datasets.ReadInstruction.from_spec.example",$$slots:{default:[Kr]},$$scope:{ctx:y}}}),St=new J({props:{name:"to_absolute",anchor:"datasets.ReadInstruction.to_absolute",parameters:[{name:"name2len",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.to_absolute.name2len",description:`<strong>name2len</strong> (<code>dict</code>) &#x2014;
Associating split names to number of examples.`,name:"name2len"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/arrow_reader.py#L608",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of _AbsoluteInstruction instances (corresponds to the + in spec).</p>
`}}),Vt=new es({props:{title:"Version",local:"datasets.Version",headingTag:"h2"}}),Et=new J({props:{name:"class datasets.Version",anchor:"datasets.Version",parameters:[{name:"version_str",val:": str"},{name:"description",val:": Optional = None"},{name:"major",val:": Union = None"},{name:"minor",val:": Union = None"},{name:"patch",val:": Union = None"}],parametersDescription:[{anchor:"datasets.Version.version_str",description:`<strong>version_str</strong> (<code>str</code>) &#x2014;
The dataset version.`,name:"version_str"},{anchor:"datasets.Version.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
A description of what is new in this version.`,name:"description"},{anchor:"datasets.Version.major",description:"<strong>major</strong> (<code>str</code>) &#x2014;",name:"major"},{anchor:"datasets.Version.minor",description:"<strong>minor</strong> (<code>str</code>) &#x2014;",name:"minor"},{anchor:"datasets.Version.patch",description:"<strong>patch</strong> (<code>str</code>) &#x2014;",name:"patch"}],source:"https://github.com/huggingface/datasets/blob/3.0.2/src/datasets/utils/version.py#L28"}}),nt=new k({props:{anchor:"datasets.Version.example",$$slots:{default:[el]},$$scope:{ctx:y}}}),Qt=new Ur({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/package_reference/builder_classes.mdx"}}),{c(){a=c("meta"),w=o(),d=c("p"),s=o(),f(l.$$.fragment),e=o(),f(m.$$.fragment),as=o(),rt=c("p"),rt.innerHTML=xo,ss=o(),C=c("div"),f(lt.$$.fragment),Js=o(),Ht=c("p"),Ht.textContent=vo,Cs=o(),At=c("p"),At.innerHTML=wo,ks=o(),Pt=c("ul"),Pt.innerHTML=yo,Us=o(),qt=c("p"),qt.innerHTML=Mo,Rs=o(),re=c("div"),f(dt.$$.fragment),js=o(),Ot=c("p"),Ot.textContent=To,Gs=o(),f(Ne.$$.fragment),Ns=o(),B=c("div"),f(it.$$.fragment),Is=o(),Kt=c("p"),Kt.textContent=Jo,Xs=o(),ea=c("p"),ea.textContent=Co,Zs=o(),f(Ie.$$.fragment),Bs=o(),f(Xe.$$.fragment),Ds=o(),f(Ze.$$.fragment),Fs=o(),le=c("div"),f(ct.$$.fragment),zs=o(),ta=c("p"),ta.textContent=ko,Ss=o(),f(Be.$$.fragment),Vs=o(),de=c("div"),f(pt.$$.fragment),Es=o(),aa=c("p"),aa.innerHTML=Uo,Qs=o(),f(De.$$.fragment),Ls=o(),Fe=c("div"),f(mt.$$.fragment),Ys=o(),sa=c("p"),sa.textContent=Ro,ns=o(),K=c("div"),f(gt.$$.fragment),Ws=o(),na=c("p"),na.textContent=jo,Hs=o(),oa=c("p"),oa.innerHTML=Go,os=o(),$e=c("div"),f(ut.$$.fragment),As=o(),ra=c("p"),ra.textContent=No,rs=o(),L=c("div"),f(ft.$$.fragment),Ps=o(),la=c("p"),la.innerHTML=Io,qs=o(),da=c("p"),da.innerHTML=Xo,Os=o(),A=c("div"),f(ht.$$.fragment),Ks=o(),ia=c("p"),ia.textContent=Zo,en=o(),ca=c("ul"),ca.innerHTML=Bo,tn=o(),pa=c("p"),pa.textContent=Do,ls=o(),f(_t.$$.fragment),ds=o(),X=c("div"),f(bt.$$.fragment),an=o(),P=c("div"),f($t.$$.fragment),sn=o(),ma=c("p"),ma.textContent=Fo,nn=o(),ga=c("p"),ga.innerHTML=zo,on=o(),f(ze.$$.fragment),rn=o(),ie=c("div"),f(xt.$$.fragment),ln=o(),ua=c("p"),ua.innerHTML=So,dn=o(),f(Se.$$.fragment),cn=o(),ce=c("div"),f(vt.$$.fragment),pn=o(),fa=c("p"),fa.textContent=Vo,mn=o(),f(Ve.$$.fragment),gn=o(),pe=c("div"),f(wt.$$.fragment),un=o(),ha=c("p"),ha.textContent=Eo,fn=o(),f(Ee.$$.fragment),hn=o(),me=c("div"),f(yt.$$.fragment),_n=o(),_a=c("p"),_a.textContent=Qo,bn=o(),f(Qe.$$.fragment),is=o(),N=c("div"),f(Mt.$$.fragment),$n=o(),ba=c("p"),ba.innerHTML=Lo,xn=o(),ge=c("div"),f(Tt.$$.fragment),vn=o(),$a=c("p"),$a.innerHTML=Yo,wn=o(),f(Le.$$.fragment),yn=o(),q=c("div"),f(Jt.$$.fragment),Mn=o(),xa=c("p"),xa.innerHTML=Wo,Tn=o(),va=c("p"),va.innerHTML=Ho,Jn=o(),f(Ye.$$.fragment),Cn=o(),O=c("div"),f(Ct.$$.fragment),kn=o(),wa=c("p"),wa.textContent=Ao,Un=o(),ya=c("p"),ya.innerHTML=Po,Rn=o(),f(We.$$.fragment),jn=o(),ue=c("div"),f(kt.$$.fragment),Gn=o(),Ma=c("p"),Ma.textContent=qo,Nn=o(),f(He.$$.fragment),In=o(),fe=c("div"),f(Ut.$$.fragment),Xn=o(),Ta=c("p"),Ta.textContent=Oo,Zn=o(),f(Ae.$$.fragment),cs=o(),xe=c("div"),f(Rt.$$.fragment),Bn=o(),Ja=c("p"),Ja.textContent=Ko,ps=o(),F=c("div"),f(jt.$$.fragment),Dn=o(),Ca=c("p"),Ca.innerHTML=er,Fn=o(),ka=c("p"),ka.innerHTML=tr,zn=o(),Ua=c("p"),Ua.textContent=ar,Sn=o(),Ra=c("table"),Ra.innerHTML=sr,ms=o(),f(Gt.$$.fragment),gs=o(),z=c("div"),f(Nt.$$.fragment),Vn=o(),ja=c("p"),ja.innerHTML=nr,En=o(),Ga=c("p"),Ga.innerHTML=or,Qn=o(),Na=c("p"),Na.textContent=rr,Ln=o(),Ia=c("table"),Ia.innerHTML=lr,us=o(),f(It.$$.fragment),fs=o(),Y=c("div"),f(Xt.$$.fragment),Yn=o(),Xa=c("p"),Xa.textContent=dr,Wn=o(),Za=c("p"),Za.innerHTML=ir,Hn=o(),f(Pe.$$.fragment),hs=o(),I=c("div"),f(Zt.$$.fragment),An=o(),Ba=c("p"),Ba.innerHTML=cr,Pn=o(),Da=c("p"),Da.textContent=pr,qn=o(),Fa=c("ul"),Fa.innerHTML=mr,On=o(),za=c("p"),za.innerHTML=gr,Kn=o(),Sa=c("p"),Sa.innerHTML=ur,eo=o(),f(qe.$$.fragment),_s=o(),G=c("div"),f(Bt.$$.fragment),to=o(),Va=c("p"),Va.textContent=fr,ao=o(),Ea=c("p"),Ea.textContent=hr,so=o(),f(Oe.$$.fragment),no=o(),Qa=c("p"),Qa.textContent=_r,oo=o(),f(Ke.$$.fragment),ro=o(),f(et.$$.fragment),lo=o(),f(tt.$$.fragment),bs=o(),ve=c("div"),f(Dt.$$.fragment),io=o(),La=c("p"),La.textContent=br,$s=o(),S=c("div"),f(Ft.$$.fragment),co=o(),Ya=c("p"),Ya.textContent=$r,po=o(),f(at.$$.fragment),mo=o(),he=c("div"),f(zt.$$.fragment),go=o(),Wa=c("p"),Wa.innerHTML=xr,uo=o(),f(st.$$.fragment),fo=o(),_e=c("div"),f(St.$$.fragment),ho=o(),Ha=c("p"),Ha.textContent=vr,_o=o(),Aa=c("p"),Aa.textContent=wr,xs=o(),f(Vt.$$.fragment),vs=o(),ee=c("div"),f(Et.$$.fragment),bo=o(),Pa=c("p"),Pa.innerHTML=yr,$o=o(),f(nt.$$.fragment),ws=o(),f(Qt.$$.fragment),ys=o(),ts=c("p"),this.h()},l(t){const g=kr("svelte-u9bgzb",document.head);a=p(g,"META",{name:!0,content:!0}),g.forEach(i),w=r(t),d=p(t,"P",{}),M(d).forEach(i),s=r(t),h(l.$$.fragment,t),e=r(t),h(m.$$.fragment,t),as=r(t),rt=p(t,"P",{"data-svelte-h":!0}),v(rt)!=="svelte-b1cfho"&&(rt.innerHTML=xo),ss=r(t),C=p(t,"DIV",{class:!0});var j=M(C);h(lt.$$.fragment,j),Js=r(j),Ht=p(j,"P",{"data-svelte-h":!0}),v(Ht)!=="svelte-krqj9a"&&(Ht.textContent=vo),Cs=r(j),At=p(j,"P",{"data-svelte-h":!0}),v(At)!=="svelte-apl31e"&&(At.innerHTML=wo),ks=r(j),Pt=p(j,"UL",{"data-svelte-h":!0}),v(Pt)!=="svelte-1n4pn49"&&(Pt.innerHTML=yo),Us=r(j),qt=p(j,"P",{"data-svelte-h":!0}),v(qt)!=="svelte-1hj9qy5"&&(qt.innerHTML=Mo),Rs=r(j),re=p(j,"DIV",{class:!0});var we=M(re);h(dt.$$.fragment,we),js=r(we),Ot=p(we,"P",{"data-svelte-h":!0}),v(Ot)!=="svelte-1q1652n"&&(Ot.textContent=To),Gs=r(we),h(Ne.$$.fragment,we),we.forEach(i),Ns=r(j),B=p(j,"DIV",{class:!0});var V=M(B);h(it.$$.fragment,V),Is=r(V),Kt=p(V,"P",{"data-svelte-h":!0}),v(Kt)!=="svelte-9mag6f"&&(Kt.textContent=Jo),Xs=r(V),ea=p(V,"P",{"data-svelte-h":!0}),v(ea)!=="svelte-11lpom8"&&(ea.textContent=Co),Zs=r(V),h(Ie.$$.fragment,V),Bs=r(V),h(Xe.$$.fragment,V),Ds=r(V),h(Ze.$$.fragment,V),V.forEach(i),Fs=r(j),le=p(j,"DIV",{class:!0});var ye=M(le);h(ct.$$.fragment,ye),zs=r(ye),ta=p(ye,"P",{"data-svelte-h":!0}),v(ta)!=="svelte-1o5q38l"&&(ta.textContent=ko),Ss=r(ye),h(Be.$$.fragment,ye),ye.forEach(i),Vs=r(j),de=p(j,"DIV",{class:!0});var Me=M(de);h(pt.$$.fragment,Me),Es=r(Me),aa=p(Me,"P",{"data-svelte-h":!0}),v(aa)!=="svelte-168h2s0"&&(aa.innerHTML=Uo),Qs=r(Me),h(De.$$.fragment,Me),Me.forEach(i),Ls=r(j),Fe=p(j,"DIV",{class:!0});var Lt=M(Fe);h(mt.$$.fragment,Lt),Ys=r(Lt),sa=p(Lt,"P",{"data-svelte-h":!0}),v(sa)!=="svelte-1jq5ljq"&&(sa.textContent=Ro),Lt.forEach(i),j.forEach(i),ns=r(t),K=p(t,"DIV",{class:!0});var Te=M(K);h(gt.$$.fragment,Te),Ws=r(Te),na=p(Te,"P",{"data-svelte-h":!0}),v(na)!=="svelte-5e48ll"&&(na.textContent=jo),Hs=r(Te),oa=p(Te,"P",{"data-svelte-h":!0}),v(oa)!=="svelte-1b18j1y"&&(oa.innerHTML=Go),Te.forEach(i),os=r(t),$e=p(t,"DIV",{class:!0});var Yt=M($e);h(ut.$$.fragment,Yt),As=r(Yt),ra=p(Yt,"P",{"data-svelte-h":!0}),v(ra)!=="svelte-17aolem"&&(ra.textContent=No),Yt.forEach(i),rs=r(t),L=p(t,"DIV",{class:!0});var te=M(L);h(ft.$$.fragment,te),Ps=r(te),la=p(te,"P",{"data-svelte-h":!0}),v(la)!=="svelte-15gz2dy"&&(la.innerHTML=Io),qs=r(te),da=p(te,"P",{"data-svelte-h":!0}),v(da)!=="svelte-1m2o9um"&&(da.innerHTML=Xo),Os=r(te),A=p(te,"DIV",{class:!0});var ae=M(A);h(ht.$$.fragment,ae),Ks=r(ae),ia=p(ae,"P",{"data-svelte-h":!0}),v(ia)!=="svelte-1h03lp6"&&(ia.textContent=Zo),en=r(ae),ca=p(ae,"UL",{"data-svelte-h":!0}),v(ca)!=="svelte-y69nf2"&&(ca.innerHTML=Bo),tn=r(ae),pa=p(ae,"P",{"data-svelte-h":!0}),v(pa)!=="svelte-d2y9u1"&&(pa.textContent=Do),ae.forEach(i),te.forEach(i),ls=r(t),h(_t.$$.fragment,t),ds=r(t),X=p(t,"DIV",{class:!0});var E=M(X);h(bt.$$.fragment,E),an=r(E),P=p(E,"DIV",{class:!0});var se=M(P);h($t.$$.fragment,se),sn=r(se),ma=p(se,"P",{"data-svelte-h":!0}),v(ma)!=="svelte-19i8z0e"&&(ma.textContent=Fo),nn=r(se),ga=p(se,"P",{"data-svelte-h":!0}),v(ga)!=="svelte-a30fyv"&&(ga.innerHTML=zo),on=r(se),h(ze.$$.fragment,se),se.forEach(i),rn=r(E),ie=p(E,"DIV",{class:!0});var Je=M(ie);h(xt.$$.fragment,Je),ln=r(Je),ua=p(Je,"P",{"data-svelte-h":!0}),v(ua)!=="svelte-xkawo0"&&(ua.innerHTML=So),dn=r(Je),h(Se.$$.fragment,Je),Je.forEach(i),cn=r(E),ce=p(E,"DIV",{class:!0});var Ce=M(ce);h(vt.$$.fragment,Ce),pn=r(Ce),fa=p(Ce,"P",{"data-svelte-h":!0}),v(fa)!=="svelte-1vlembv"&&(fa.textContent=Vo),mn=r(Ce),h(Ve.$$.fragment,Ce),Ce.forEach(i),gn=r(E),pe=p(E,"DIV",{class:!0});var ke=M(pe);h(wt.$$.fragment,ke),un=r(ke),ha=p(ke,"P",{"data-svelte-h":!0}),v(ha)!=="svelte-1ephcm7"&&(ha.textContent=Eo),fn=r(ke),h(Ee.$$.fragment,ke),ke.forEach(i),hn=r(E),me=p(E,"DIV",{class:!0});var Ue=M(me);h(yt.$$.fragment,Ue),_n=r(Ue),_a=p(Ue,"P",{"data-svelte-h":!0}),v(_a)!=="svelte-1sadrg0"&&(_a.textContent=Qo),bn=r(Ue),h(Qe.$$.fragment,Ue),Ue.forEach(i),E.forEach(i),is=r(t),N=p(t,"DIV",{class:!0});var Z=M(N);h(Mt.$$.fragment,Z),$n=r(Z),ba=p(Z,"P",{"data-svelte-h":!0}),v(ba)!=="svelte-2x5qds"&&(ba.innerHTML=Lo),xn=r(Z),ge=p(Z,"DIV",{class:!0});var Re=M(ge);h(Tt.$$.fragment,Re),vn=r(Re),$a=p(Re,"P",{"data-svelte-h":!0}),v($a)!=="svelte-z89fig"&&($a.innerHTML=Yo),wn=r(Re),h(Le.$$.fragment,Re),Re.forEach(i),yn=r(Z),q=p(Z,"DIV",{class:!0});var ne=M(q);h(Jt.$$.fragment,ne),Mn=r(ne),xa=p(ne,"P",{"data-svelte-h":!0}),v(xa)!=="svelte-vb22br"&&(xa.innerHTML=Wo),Tn=r(ne),va=p(ne,"P",{"data-svelte-h":!0}),v(va)!=="svelte-1hkl2pt"&&(va.innerHTML=Ho),Jn=r(ne),h(Ye.$$.fragment,ne),ne.forEach(i),Cn=r(Z),O=p(Z,"DIV",{class:!0});var oe=M(O);h(Ct.$$.fragment,oe),kn=r(oe),wa=p(oe,"P",{"data-svelte-h":!0}),v(wa)!=="svelte-sgtbuc"&&(wa.textContent=Ao),Un=r(oe),ya=p(oe,"P",{"data-svelte-h":!0}),v(ya)!=="svelte-5qr3om"&&(ya.innerHTML=Po),Rn=r(oe),h(We.$$.fragment,oe),oe.forEach(i),jn=r(Z),ue=p(Z,"DIV",{class:!0});var je=M(ue);h(kt.$$.fragment,je),Gn=r(je),Ma=p(je,"P",{"data-svelte-h":!0}),v(Ma)!=="svelte-1ephcm7"&&(Ma.textContent=qo),Nn=r(je),h(He.$$.fragment,je),je.forEach(i),In=r(Z),fe=p(Z,"DIV",{class:!0});var Ge=M(fe);h(Ut.$$.fragment,Ge),Xn=r(Ge),Ta=p(Ge,"P",{"data-svelte-h":!0}),v(Ta)!=="svelte-1kdi5en"&&(Ta.textContent=Oo),Zn=r(Ge),h(Ae.$$.fragment,Ge),Ge.forEach(i),Z.forEach(i),cs=r(t),xe=p(t,"DIV",{class:!0});var Wt=M(xe);h(Rt.$$.fragment,Wt),Bn=r(Wt),Ja=p(Wt,"P",{"data-svelte-h":!0}),v(Ja)!=="svelte-1equdtb"&&(Ja.textContent=Ko),Wt.forEach(i),ps=r(t),F=p(t,"DIV",{class:!0});var W=M(F);h(jt.$$.fragment,W),Dn=r(W),Ca=p(W,"P",{"data-svelte-h":!0}),v(Ca)!=="svelte-nmj2uv"&&(Ca.innerHTML=er),Fn=r(W),ka=p(W,"P",{"data-svelte-h":!0}),v(ka)!=="svelte-xtdw9q"&&(ka.innerHTML=tr),zn=r(W),Ua=p(W,"P",{"data-svelte-h":!0}),v(Ua)!=="svelte-a4zsdi"&&(Ua.textContent=ar),Sn=r(W),Ra=p(W,"TABLE",{"data-svelte-h":!0}),v(Ra)!=="svelte-pv0x4r"&&(Ra.innerHTML=sr),W.forEach(i),ms=r(t),h(Gt.$$.fragment,t),gs=r(t),z=p(t,"DIV",{class:!0});var H=M(z);h(Nt.$$.fragment,H),Vn=r(H),ja=p(H,"P",{"data-svelte-h":!0}),v(ja)!=="svelte-1eqexd"&&(ja.innerHTML=nr),En=r(H),Ga=p(H,"P",{"data-svelte-h":!0}),v(Ga)!=="svelte-13iynk4"&&(Ga.innerHTML=or),Qn=r(H),Na=p(H,"P",{"data-svelte-h":!0}),v(Na)!=="svelte-1luabaw"&&(Na.textContent=rr),Ln=r(H),Ia=p(H,"TABLE",{"data-svelte-h":!0}),v(Ia)!=="svelte-6p84mg"&&(Ia.innerHTML=lr),H.forEach(i),us=r(t),h(It.$$.fragment,t),fs=r(t),Y=p(t,"DIV",{class:!0});var ot=M(Y);h(Xt.$$.fragment,ot),Yn=r(ot),Xa=p(ot,"P",{"data-svelte-h":!0}),v(Xa)!=="svelte-18qkgha"&&(Xa.textContent=dr),Wn=r(ot),Za=p(ot,"P",{"data-svelte-h":!0}),v(Za)!=="svelte-fn7w0y"&&(Za.innerHTML=ir),Hn=r(ot),h(Pe.$$.fragment,ot),ot.forEach(i),hs=r(t),I=p(t,"DIV",{class:!0});var Q=M(I);h(Zt.$$.fragment,Q),An=r(Q),Ba=p(Q,"P",{"data-svelte-h":!0}),v(Ba)!=="svelte-ewaslg"&&(Ba.innerHTML=cr),Pn=r(Q),Da=p(Q,"P",{"data-svelte-h":!0}),v(Da)!=="svelte-l59ai2"&&(Da.textContent=pr),qn=r(Q),Fa=p(Q,"UL",{"data-svelte-h":!0}),v(Fa)!=="svelte-sbyekb"&&(Fa.innerHTML=mr),On=r(Q),za=p(Q,"P",{"data-svelte-h":!0}),v(za)!=="svelte-20xdby"&&(za.innerHTML=gr),Kn=r(Q),Sa=p(Q,"P",{"data-svelte-h":!0}),v(Sa)!=="svelte-1cn2wk0"&&(Sa.innerHTML=ur),eo=r(Q),h(qe.$$.fragment,Q),Q.forEach(i),_s=r(t),G=p(t,"DIV",{class:!0});var D=M(G);h(Bt.$$.fragment,D),to=r(D),Va=p(D,"P",{"data-svelte-h":!0}),v(Va)!=="svelte-124iux6"&&(Va.textContent=fr),ao=r(D),Ea=p(D,"P",{"data-svelte-h":!0}),v(Ea)!=="svelte-11lpom8"&&(Ea.textContent=hr),so=r(D),h(Oe.$$.fragment,D),no=r(D),Qa=p(D,"P",{"data-svelte-h":!0}),v(Qa)!=="svelte-5jjbkq"&&(Qa.textContent=_r),oo=r(D),h(Ke.$$.fragment,D),ro=r(D),h(et.$$.fragment,D),lo=r(D),h(tt.$$.fragment,D),D.forEach(i),bs=r(t),ve=p(t,"DIV",{class:!0});var Ts=M(ve);h(Dt.$$.fragment,Ts),io=r(Ts),La=p(Ts,"P",{"data-svelte-h":!0}),v(La)!=="svelte-11ie63y"&&(La.textContent=br),Ts.forEach(i),$s=r(t),S=p(t,"DIV",{class:!0});var be=M(S);h(Ft.$$.fragment,be),co=r(be),Ya=p(be,"P",{"data-svelte-h":!0}),v(Ya)!=="svelte-3dhs2m"&&(Ya.textContent=$r),po=r(be),h(at.$$.fragment,be),mo=r(be),he=p(be,"DIV",{class:!0});var qa=M(he);h(zt.$$.fragment,qa),go=r(qa),Wa=p(qa,"P",{"data-svelte-h":!0}),v(Wa)!=="svelte-1g1y80g"&&(Wa.innerHTML=xr),uo=r(qa),h(st.$$.fragment,qa),qa.forEach(i),fo=r(be),_e=p(be,"DIV",{class:!0});var Oa=M(_e);h(St.$$.fragment,Oa),ho=r(Oa),Ha=p(Oa,"P",{"data-svelte-h":!0}),v(Ha)!=="svelte-14tg07e"&&(Ha.textContent=vr),_o=r(Oa),Aa=p(Oa,"P",{"data-svelte-h":!0}),v(Aa)!=="svelte-l773xk"&&(Aa.textContent=wr),Oa.forEach(i),be.forEach(i),xs=r(t),h(Vt.$$.fragment,t),vs=r(t),ee=p(t,"DIV",{class:!0});var Ka=M(ee);h(Et.$$.fragment,Ka),bo=r(Ka),Pa=p(Ka,"P",{"data-svelte-h":!0}),v(Pa)!=="svelte-14lq7j5"&&(Pa.innerHTML=yr),$o=r(Ka),h(nt.$$.fragment,Ka),Ka.forEach(i),ws=r(t),h(Qt.$$.fragment,t),ys=r(t),ts=p(t,"P",{}),M(ts).forEach(i),this.h()},h(){T(a,"name","hf:doc:metadata"),T(a,"content",al),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,g){n(document.head,a),u(t,w,g),u(t,d,g),u(t,s,g),_(l,t,g),u(t,e,g),_(m,t,g),u(t,as,g),u(t,rt,g),u(t,ss,g),u(t,C,g),_(lt,C,null),n(C,Js),n(C,Ht),n(C,Cs),n(C,At),n(C,ks),n(C,Pt),n(C,Us),n(C,qt),n(C,Rs),n(C,re),_(dt,re,null),n(re,js),n(re,Ot),n(re,Gs),_(Ne,re,null),n(C,Ns),n(C,B),_(it,B,null),n(B,Is),n(B,Kt),n(B,Xs),n(B,ea),n(B,Zs),_(Ie,B,null),n(B,Bs),_(Xe,B,null),n(B,Ds),_(Ze,B,null),n(C,Fs),n(C,le),_(ct,le,null),n(le,zs),n(le,ta),n(le,Ss),_(Be,le,null),n(C,Vs),n(C,de),_(pt,de,null),n(de,Es),n(de,aa),n(de,Qs),_(De,de,null),n(C,Ls),n(C,Fe),_(mt,Fe,null),n(Fe,Ys),n(Fe,sa),u(t,ns,g),u(t,K,g),_(gt,K,null),n(K,Ws),n(K,na),n(K,Hs),n(K,oa),u(t,os,g),u(t,$e,g),_(ut,$e,null),n($e,As),n($e,ra),u(t,rs,g),u(t,L,g),_(ft,L,null),n(L,Ps),n(L,la),n(L,qs),n(L,da),n(L,Os),n(L,A),_(ht,A,null),n(A,Ks),n(A,ia),n(A,en),n(A,ca),n(A,tn),n(A,pa),u(t,ls,g),_(_t,t,g),u(t,ds,g),u(t,X,g),_(bt,X,null),n(X,an),n(X,P),_($t,P,null),n(P,sn),n(P,ma),n(P,nn),n(P,ga),n(P,on),_(ze,P,null),n(X,rn),n(X,ie),_(xt,ie,null),n(ie,ln),n(ie,ua),n(ie,dn),_(Se,ie,null),n(X,cn),n(X,ce),_(vt,ce,null),n(ce,pn),n(ce,fa),n(ce,mn),_(Ve,ce,null),n(X,gn),n(X,pe),_(wt,pe,null),n(pe,un),n(pe,ha),n(pe,fn),_(Ee,pe,null),n(X,hn),n(X,me),_(yt,me,null),n(me,_n),n(me,_a),n(me,bn),_(Qe,me,null),u(t,is,g),u(t,N,g),_(Mt,N,null),n(N,$n),n(N,ba),n(N,xn),n(N,ge),_(Tt,ge,null),n(ge,vn),n(ge,$a),n(ge,wn),_(Le,ge,null),n(N,yn),n(N,q),_(Jt,q,null),n(q,Mn),n(q,xa),n(q,Tn),n(q,va),n(q,Jn),_(Ye,q,null),n(N,Cn),n(N,O),_(Ct,O,null),n(O,kn),n(O,wa),n(O,Un),n(O,ya),n(O,Rn),_(We,O,null),n(N,jn),n(N,ue),_(kt,ue,null),n(ue,Gn),n(ue,Ma),n(ue,Nn),_(He,ue,null),n(N,In),n(N,fe),_(Ut,fe,null),n(fe,Xn),n(fe,Ta),n(fe,Zn),_(Ae,fe,null),u(t,cs,g),u(t,xe,g),_(Rt,xe,null),n(xe,Bn),n(xe,Ja),u(t,ps,g),u(t,F,g),_(jt,F,null),n(F,Dn),n(F,Ca),n(F,Fn),n(F,ka),n(F,zn),n(F,Ua),n(F,Sn),n(F,Ra),u(t,ms,g),_(Gt,t,g),u(t,gs,g),u(t,z,g),_(Nt,z,null),n(z,Vn),n(z,ja),n(z,En),n(z,Ga),n(z,Qn),n(z,Na),n(z,Ln),n(z,Ia),u(t,us,g),_(It,t,g),u(t,fs,g),u(t,Y,g),_(Xt,Y,null),n(Y,Yn),n(Y,Xa),n(Y,Wn),n(Y,Za),n(Y,Hn),_(Pe,Y,null),u(t,hs,g),u(t,I,g),_(Zt,I,null),n(I,An),n(I,Ba),n(I,Pn),n(I,Da),n(I,qn),n(I,Fa),n(I,On),n(I,za),n(I,Kn),n(I,Sa),n(I,eo),_(qe,I,null),u(t,_s,g),u(t,G,g),_(Bt,G,null),n(G,to),n(G,Va),n(G,ao),n(G,Ea),n(G,so),_(Oe,G,null),n(G,no),n(G,Qa),n(G,oo),_(Ke,G,null),n(G,ro),_(et,G,null),n(G,lo),_(tt,G,null),u(t,bs,g),u(t,ve,g),_(Dt,ve,null),n(ve,io),n(ve,La),u(t,$s,g),u(t,S,g),_(Ft,S,null),n(S,co),n(S,Ya),n(S,po),_(at,S,null),n(S,mo),n(S,he),_(zt,he,null),n(he,go),n(he,Wa),n(he,uo),_(st,he,null),n(S,fo),n(S,_e),_(St,_e,null),n(_e,ho),n(_e,Ha),n(_e,_o),n(_e,Aa),u(t,xs,g),_(Vt,t,g),u(t,vs,g),u(t,ee,g),_(Et,ee,null),n(ee,bo),n(ee,Pa),n(ee,$o),_(nt,ee,null),u(t,ws,g),_(Qt,t,g),u(t,ys,g),u(t,ts,g),Ms=!0},p(t,[g]){const j={};g&2&&(j.$$scope={dirty:g,ctx:t}),Ne.$set(j);const we={};g&2&&(we.$$scope={dirty:g,ctx:t}),Ie.$set(we);const V={};g&2&&(V.$$scope={dirty:g,ctx:t}),Xe.$set(V);const ye={};g&2&&(ye.$$scope={dirty:g,ctx:t}),Ze.$set(ye);const Me={};g&2&&(Me.$$scope={dirty:g,ctx:t}),Be.$set(Me);const Lt={};g&2&&(Lt.$$scope={dirty:g,ctx:t}),De.$set(Lt);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:t}),ze.$set(Te);const Yt={};g&2&&(Yt.$$scope={dirty:g,ctx:t}),Se.$set(Yt);const te={};g&2&&(te.$$scope={dirty:g,ctx:t}),Ve.$set(te);const ae={};g&2&&(ae.$$scope={dirty:g,ctx:t}),Ee.$set(ae);const E={};g&2&&(E.$$scope={dirty:g,ctx:t}),Qe.$set(E);const se={};g&2&&(se.$$scope={dirty:g,ctx:t}),Le.$set(se);const Je={};g&2&&(Je.$$scope={dirty:g,ctx:t}),Ye.$set(Je);const Ce={};g&2&&(Ce.$$scope={dirty:g,ctx:t}),We.$set(Ce);const ke={};g&2&&(ke.$$scope={dirty:g,ctx:t}),He.$set(ke);const Ue={};g&2&&(Ue.$$scope={dirty:g,ctx:t}),Ae.$set(Ue);const Z={};g&2&&(Z.$$scope={dirty:g,ctx:t}),Pe.$set(Z);const Re={};g&2&&(Re.$$scope={dirty:g,ctx:t}),qe.$set(Re);const ne={};g&2&&(ne.$$scope={dirty:g,ctx:t}),Oe.$set(ne);const oe={};g&2&&(oe.$$scope={dirty:g,ctx:t}),Ke.$set(oe);const je={};g&2&&(je.$$scope={dirty:g,ctx:t}),et.$set(je);const Ge={};g&2&&(Ge.$$scope={dirty:g,ctx:t}),tt.$set(Ge);const Wt={};g&2&&(Wt.$$scope={dirty:g,ctx:t}),at.$set(Wt);const W={};g&2&&(W.$$scope={dirty:g,ctx:t}),st.$set(W);const H={};g&2&&(H.$$scope={dirty:g,ctx:t}),nt.$set(H)},i(t){Ms||(b(l.$$.fragment,t),b(m.$$.fragment,t),b(lt.$$.fragment,t),b(dt.$$.fragment,t),b(Ne.$$.fragment,t),b(it.$$.fragment,t),b(Ie.$$.fragment,t),b(Xe.$$.fragment,t),b(Ze.$$.fragment,t),b(ct.$$.fragment,t),b(Be.$$.fragment,t),b(pt.$$.fragment,t),b(De.$$.fragment,t),b(mt.$$.fragment,t),b(gt.$$.fragment,t),b(ut.$$.fragment,t),b(ft.$$.fragment,t),b(ht.$$.fragment,t),b(_t.$$.fragment,t),b(bt.$$.fragment,t),b($t.$$.fragment,t),b(ze.$$.fragment,t),b(xt.$$.fragment,t),b(Se.$$.fragment,t),b(vt.$$.fragment,t),b(Ve.$$.fragment,t),b(wt.$$.fragment,t),b(Ee.$$.fragment,t),b(yt.$$.fragment,t),b(Qe.$$.fragment,t),b(Mt.$$.fragment,t),b(Tt.$$.fragment,t),b(Le.$$.fragment,t),b(Jt.$$.fragment,t),b(Ye.$$.fragment,t),b(Ct.$$.fragment,t),b(We.$$.fragment,t),b(kt.$$.fragment,t),b(He.$$.fragment,t),b(Ut.$$.fragment,t),b(Ae.$$.fragment,t),b(Rt.$$.fragment,t),b(jt.$$.fragment,t),b(Gt.$$.fragment,t),b(Nt.$$.fragment,t),b(It.$$.fragment,t),b(Xt.$$.fragment,t),b(Pe.$$.fragment,t),b(Zt.$$.fragment,t),b(qe.$$.fragment,t),b(Bt.$$.fragment,t),b(Oe.$$.fragment,t),b(Ke.$$.fragment,t),b(et.$$.fragment,t),b(tt.$$.fragment,t),b(Dt.$$.fragment,t),b(Ft.$$.fragment,t),b(at.$$.fragment,t),b(zt.$$.fragment,t),b(st.$$.fragment,t),b(St.$$.fragment,t),b(Vt.$$.fragment,t),b(Et.$$.fragment,t),b(nt.$$.fragment,t),b(Qt.$$.fragment,t),Ms=!0)},o(t){$(l.$$.fragment,t),$(m.$$.fragment,t),$(lt.$$.fragment,t),$(dt.$$.fragment,t),$(Ne.$$.fragment,t),$(it.$$.fragment,t),$(Ie.$$.fragment,t),$(Xe.$$.fragment,t),$(Ze.$$.fragment,t),$(ct.$$.fragment,t),$(Be.$$.fragment,t),$(pt.$$.fragment,t),$(De.$$.fragment,t),$(mt.$$.fragment,t),$(gt.$$.fragment,t),$(ut.$$.fragment,t),$(ft.$$.fragment,t),$(ht.$$.fragment,t),$(_t.$$.fragment,t),$(bt.$$.fragment,t),$($t.$$.fragment,t),$(ze.$$.fragment,t),$(xt.$$.fragment,t),$(Se.$$.fragment,t),$(vt.$$.fragment,t),$(Ve.$$.fragment,t),$(wt.$$.fragment,t),$(Ee.$$.fragment,t),$(yt.$$.fragment,t),$(Qe.$$.fragment,t),$(Mt.$$.fragment,t),$(Tt.$$.fragment,t),$(Le.$$.fragment,t),$(Jt.$$.fragment,t),$(Ye.$$.fragment,t),$(Ct.$$.fragment,t),$(We.$$.fragment,t),$(kt.$$.fragment,t),$(He.$$.fragment,t),$(Ut.$$.fragment,t),$(Ae.$$.fragment,t),$(Rt.$$.fragment,t),$(jt.$$.fragment,t),$(Gt.$$.fragment,t),$(Nt.$$.fragment,t),$(It.$$.fragment,t),$(Xt.$$.fragment,t),$(Pe.$$.fragment,t),$(Zt.$$.fragment,t),$(qe.$$.fragment,t),$(Bt.$$.fragment,t),$(Oe.$$.fragment,t),$(Ke.$$.fragment,t),$(et.$$.fragment,t),$(tt.$$.fragment,t),$(Dt.$$.fragment,t),$(Ft.$$.fragment,t),$(at.$$.fragment,t),$(zt.$$.fragment,t),$(st.$$.fragment,t),$(St.$$.fragment,t),$(Vt.$$.fragment,t),$(Et.$$.fragment,t),$(nt.$$.fragment,t),$(Qt.$$.fragment,t),Ms=!1},d(t){t&&(i(w),i(d),i(s),i(e),i(as),i(rt),i(ss),i(C),i(ns),i(K),i(os),i($e),i(rs),i(L),i(ls),i(ds),i(X),i(is),i(N),i(cs),i(xe),i(ps),i(F),i(ms),i(gs),i(z),i(us),i(fs),i(Y),i(hs),i(I),i(_s),i(G),i(bs),i(ve),i($s),i(S),i(xs),i(vs),i(ee),i(ws),i(ys),i(ts)),i(a),x(l,t),x(m,t),x(lt),x(dt),x(Ne),x(it),x(Ie),x(Xe),x(Ze),x(ct),x(Be),x(pt),x(De),x(mt),x(gt),x(ut),x(ft),x(ht),x(_t,t),x(bt),x($t),x(ze),x(xt),x(Se),x(vt),x(Ve),x(wt),x(Ee),x(yt),x(Qe),x(Mt),x(Tt),x(Le),x(Jt),x(Ye),x(Ct),x(We),x(kt),x(He),x(Ut),x(Ae),x(Rt),x(jt),x(Gt,t),x(Nt),x(It,t),x(Xt),x(Pe),x(Zt),x(qe),x(Bt),x(Oe),x(Ke),x(et),x(tt),x(Dt),x(Ft),x(at),x(zt),x(st),x(St),x(Vt,t),x(Et),x(nt),x(Qt,t)}}}const al='{"title":"Builder classes","local":"builder-classes","sections":[{"title":"Builders","local":"datasets.DatasetBuilder","sections":[],"depth":2},{"title":"Download","local":"datasets.DownloadManager","sections":[],"depth":2},{"title":"Verification","local":"datasets.VerificationMode","sections":[],"depth":2},{"title":"Splits","local":"datasets.SplitGenerator","sections":[],"depth":2},{"title":"Version","local":"datasets.Version","sections":[],"depth":2}],"depth":1}';function sl(y){return Tr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Jr{constructor(a){super(),Cr(this,a,sl,tl,Mr,{})}}export{cl as component};
