import{s as Np,o as Fp,n as je}from"../chunks/scheduler.bdbef820.js";import{S as Bp,i as Qp,g as p,s as n,r as c,A as Wp,h as i,f as e,c as l,j as Yp,u as h,x as r,k as Vp,y as qp,a as t,v as o,d as m,t as d,w as u}from"../chunks/index.c0aea24a.js";import{T as ue}from"../chunks/Tip.31005f7d.js";import{C as g}from"../chunks/CodeBlock.6ccca92e.js";import{H as M,E as zp}from"../chunks/EditOnGithub.725ee0c1.js";function Ep(w){let j,y='All processing methods in this guide return a new <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. Modification is not done in-place. Be careful about overriding your previous dataset!';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wnsnr4"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:je,d(f){f&&e(j)}}}function Hp(w){let j,y="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&quot;int32&quot;)</code> to <code>Value(&quot;bool&quot;)</code> if the original column only contains ones and zeros.";return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1cevxd4"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:je,d(f){f&&e(j)}}}function Ap(w){let j,y='🤗 Datasets also has a <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function which is faster because it doesn’t copy the data of the remaining columns.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-156vdk8"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:je,d(f){f&&e(j)}}}function Sp(w){let j,y='🤗 Datasets also provides support for other common data formats such as NumPy, Pandas, and JAX. Check out the <a href="https://huggingface.co/docs/datasets/master/en/use_with_tensorflow#using-totfdataset" rel="nofollow">Using Datasets with TensorFlow</a> guide for more details on how to efficiently create a TensorFlow dataset.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1alh0vh"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:je,d(f){f&&e(j)}}}function Lp(w){let j,y='Want to save your dataset to a cloud storage provider? Read our <a href="./filesystems">Cloud Storage</a> guide to learn how to save your dataset to AWS or Google Cloud Storage.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1vp9a9n"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:je,d(f){f&&e(j)}}}function Dp(w){let j,y,f,b,_,ge,k,cl="🤗 Datasets provides many tools for modifying the structure and content of a dataset. These tools are important for tidying up a dataset, creating additional columns, converting between features and formats, and much more.",fe,I,hl="This guide will show you how to:",Me,C,ol="<li>Reorder rows and split the dataset.</li> <li>Rename and remove columns, and other common column operations.</li> <li>Apply processing functions to each example in a dataset.</li> <li>Concatenate datasets.</li> <li>Apply a custom formatting transform.</li> <li>Save and export processed datasets.</li>",ye,Z,ml='For more details specific to processing other dataset modalities, take a look at the <a class="underline decoration-pink-400 decoration-2 font-semibold" href="./audio_process">process audio dataset guide</a>, the <a class="underline decoration-yellow-400 decoration-2 font-semibold" href="./image_process">process image dataset guide</a>, or the <a class="underline decoration-green-400 decoration-2 font-semibold" href="./nlp_process">process text dataset guide</a>.',be,v,dl="The examples in this guide use the MRPC dataset, but feel free to load any dataset of your choice and follow along!",we,G,Te,T,Je,X,Ue,R,ul=`There are several functions for rearranging the structure of a dataset.
These functions are useful for selecting only the rows you want, creating train and test splits, and sharding very large datasets into smaller chunks.`,xe,Y,$e,V,jl='Use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.sort">sort()</a> to sort column values according to their numerical values. The provided column must be NumPy compatible.',_e,N,ke,F,gl=`Under the hood, this creates a list of indices that is sorted according to values of the column.
This indices mapping is then used to access the right rows in the underlying Arrow table.`,Ie,B,Ce,Q,fl='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.shuffle">shuffle()</a> function randomly rearranges the column values. You can specify the <code>generator</code> parameter in this function to use a different <code>numpy.random.Generator</code> if you want more control over the algorithm used to shuffle the dataset.',Ze,W,ve,q,Ml=`Shuffling takes the list of indices <code>[0:len(my_dataset)]</code> and shuffles it to create an indices mapping.
However as soon as your <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping, the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
Alternatively, you can switch to an <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leverage its fast approximate shuffling <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>:`,Ge,z,Xe,E,Re,H,yl='There are two options for filtering rows in a dataset: <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.select">select()</a> and <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a>.',Ye,A,bl='<li><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.select">select()</a> returns rows according to a list of indices:</li>',Ve,S,Ne,L,wl='<li><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> returns rows that match a specified condition:</li>',Fe,D,Be,P,Tl='<a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',Qe,K,We,O,Jl="Unless the list of indices to keep is contiguous, those methods also create an indices mapping under the hood.",qe,ss,ze,as,Ul='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.train_test_split">train_test_split()</a> function creates train and test splits if your dataset doesn’t already have them. This allows you to adjust the relative proportions or an absolute number of samples in each split. In the example below, use the <code>test_size</code> parameter to create a test split that is 10% of the original dataset:',Ee,es,He,ts,xl="The splits are shuffled by default, but you can set <code>shuffle=False</code> to prevent shuffling.",Ae,ns,Se,ls,$l='🤗 Datasets supports sharding to divide a very large dataset into a predefined number of chunks. Specify the <code>num_shards</code> parameter in <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.shard">shard()</a> to determine the number of shards to split the dataset into. You’ll also need to provide the shard you want to return with the <code>index</code> parameter.',Le,ps,_l='For example, the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">imdb</a> dataset has 25000 examples:',De,is,Pe,rs,kl="After sharding the dataset into four chunks, the first shard will only have 6250 examples:",Ke,cs,Oe,hs,st,os,Il="The following functions allow you to modify the columns of a dataset. These functions are useful for renaming or removing columns, changing columns to a new set of features, and flattening nested column structures.",at,ms,et,ds,Cl='Use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',tt,us,Zl='Provide <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> with the name of the original column, and the new column name:',nt,js,lt,gs,pt,fs,vl='When you need to remove one or more columns, provide the column name to remove to the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function. Remove more than one column by providing a list of column names:',it,Ms,rt,ys,Gl='Conversely, <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.select_columns">select_columns()</a> selects one or more columns to keep and removes the rest. This function takes either one or a list of column names:',ct,bs,ht,ws,ot,Ts,Xl='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.cast">cast()</a> function transforms the feature type of one or more columns. This function accepts your new <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Features">Features</a> as its argument. The example below demonstrates how to change the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> and <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Value">Value</a> features:',mt,Js,dt,J,ut,Us,Rl='Use the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function to change the feature type of a single column. Pass the column name and its new feature type as arguments:',jt,xs,gt,$s,ft,_s,Yl="Sometimes a column can be a nested structure of several types. Take a look at the nested structure below from the SQuAD dataset:",Mt,ks,yt,Is,Vl='The <code>answers</code> field contains two subfields: <code>text</code> and <code>answer_start</code>. Use the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.flatten">flatten()</a> function to extract the subfields into their own separate columns:',bt,Cs,wt,Zs,Nl="Notice how the subfields are now their own independent columns: <code>answers.text</code> and <code>answers.answer_start</code>.",Tt,vs,Jt,Gs,Fl='Some of the more powerful applications of 🤗 Datasets come from using the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function. The primary purpose of <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> is to speed up processing functions. It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.',Ut,Xs,Bl="In the following example, prefix each <code>sentence1</code> value in the dataset with <code>&#39;My sentence: &#39;</code>.",xt,Rs,Ql="Start by creating a function that adds <code>&#39;My sentence: &#39;</code> to the beginning of each sentence. The function needs to accept and output a <code>dict</code>:",$t,Ys,_t,Vs,Wl='Now use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the <code>add_prefix</code> function to the entire dataset:',kt,Ns,It,Fs,ql='Let’s take a look at another example, except this time, you’ll remove a column with <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',Ct,Bs,zl='Specify the column to remove with the <code>remove_columns</code> parameter in <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',Zt,Qs,vt,U,Gt,Ws,El='You can also use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with indices if you set <code>with_indices=True</code>. The example below adds the index to the beginning of each sentence:',Xt,qs,Rt,zs,Yt,Es,Hl='Multiprocessing significantly speeds up processing by parallelizing processes on the CPU. Set the <code>num_proc</code> parameter in <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to set the number of processes to use:',Vt,Hs,Nt,As,Al='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> also works with the rank of the process if you set <code>with_rank=True</code>. This is analogous to the <code>with_indices</code> parameter. The <code>with_rank</code> parameter in the mapped function goes after the <code>index</code> one if it is already present.',Ft,Ss,Bt,Ls,Sl="The main use-case for rank is to parallelize computation across several GPUs. This requires setting <code>multiprocess.set_start_method(&quot;spawn&quot;)</code>. If you don’t you’ll receive the following CUDA error:",Qt,Ds,Wt,Ps,qt,Ks,Ll='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> parameter. Batch processing enables interesting applications such as splitting long sentences into shorter chunks and data augmentation.',zt,Os,Et,sa,Dl="When examples are too long, you may want to split them into several smaller chunks. Begin by creating a function that:",Ht,aa,Pl="<li><p>Splits the <code>sentence1</code> field into chunks of 50 characters.</p></li> <li><p>Stacks all the chunks together to create the new dataset.</p></li>",At,ea,St,ta,Kl='Apply the function with <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',Lt,na,Dt,la,Ol="Notice how the sentences are split into shorter chunks now, and there are more rows in the dataset.",Pt,pa,Kt,ia,Ot,ra,sp='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function could also be used for data augmentation. The following example generates additional words for a masked token in a sentence.',sn,ca,ap='Load and use the <a href="https://huggingface.co/roberta-base" rel="nofollow">RoBERTA</a> model in 🤗 Transformers’ <a href="https://huggingface.co/transformers/main_classes/pipelines#transformers.FillMaskPipeline" rel="nofollow">FillMaskPipeline</a>:',an,ha,en,oa,ep="Create a function to randomly select a word to mask in the sentence. The function should also return the original sentence and the top two replacements generated by RoBERTA.",tn,ma,nn,da,tp='Use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the function over the whole dataset:',ln,ua,pn,ja,np="For each original sentence, RoBERTA augmented a random word with three alternatives. The original word <code>distorting</code> is supplemented by <code>withholding</code>, <code>suppressing</code>, and <code>destroying</code>.",rn,ga,cn,fa,lp='Many datasets have splits that can be processed simultaneously with <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.DatasetDict.map">DatasetDict.map()</a>. For example, tokenize the <code>sentence1</code> field in the train and test split by:',hn,Ma,on,ya,mn,ba,pp='When you use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> in a distributed setting, you should also use <a href="https://pytorch.org/docs/stable/distributed?highlight=barrier#torch.distributed.barrier" rel="nofollow">torch.distributed.barrier</a>. This ensures the main process performs the mapping, while the other processes load the results, thereby avoiding duplicate work.',dn,wa,ip="The following example shows how you can use <code>torch.distributed.barrier</code> to synchronize the processes:",un,Ta,jn,Ja,gn,Ua,rp="The <code>batch()</code> method allows you to group samples from the dataset into batches. This is particularly useful when you want to create batches of data for training or evaluation, especially when working with deep learning models.",fn,xa,cp="Here’s an example of how to use the <code>batch()</code> method:",Mn,$a,yn,_a,hp="The <code>batch()</code> method accepts the following parameters:",bn,ka,op="<li><code>batch_size</code> (<code>int</code>): The number of samples in each batch.</li> <li><code>drop_last_batch</code> (<code>bool</code>, defaults to <code>False</code>): Whether to drop the last incomplete batch if the dataset size is not divisible by the batch size.</li> <li><code>num_proc</code> (<code>int</code>, optional, defaults to <code>None</code>): The number of processes to use for multiprocessing. If None, no multiprocessing is used. This can significantly speed up batching for large datasets.</li>",wn,Ia,mp='Note that <code>Dataset.batch()</code> returns a new <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a> where each item is a batch of multiple samples from the original dataset. If you want to process data in batches, you should use a batched <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.map">map()</a> directly, which applies a function to batches but the output dataset is unbatched.',Tn,Ca,Jn,Za,dp='Separate datasets can be concatenated if they share the same column types. Concatenate datasets with <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a>:',Un,va,xn,Ga,up="You can also concatenate two datasets horizontally by setting <code>axis=1</code> as long as the datasets have the same number of rows:",$n,Xa,_n,Ra,kn,Ya,jp=`You can also mix several datasets together by taking alternating examples from each one to create a new dataset. This is known as <em>interleaving</em>, which is enabled by the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> function. Both <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> and <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a> work with regular <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.
Refer to the <a href="./stream#interleave">Stream</a> guide for an example of how to interleave <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.`,In,Va,gp=`You can define sampling probabilities for each of the original datasets to specify how to interleave the datasets.
In this case, the new dataset is constructed by getting examples one by one from a random dataset until one of the datasets runs out of samples.`,Cn,Na,Zn,Fa,fp=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,vn,Ba,Gn,Qa,Xn,Wa,Mp='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.set_format">set_format()</a> function changes the format of a column to be compatible with some common data formats. Specify the output you’d like in the <code>type</code> parameter and the columns you want to format. Formatting is applied on-the-fly.',Rn,qa,yp="For example, create PyTorch tensors by setting <code>type=&quot;torch&quot;</code>:",Yn,za,Vn,Ea,bp='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.with_format">with_format()</a> function also changes the format of a column, except it returns a new <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object:',Nn,Ha,Fn,x,Bn,Aa,wp='If you need to reset the dataset to its original format, use the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.reset_format">reset_format()</a> function:',Qn,Sa,Wn,La,qn,Da,Tp='The <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function applies a custom formatting transform on-the-fly. This function replaces any previously specified format. For example, you can use this function to tokenize and pad tokens on-the-fly. Tokenization is only applied when examples are accessed:',zn,Pa,En,Ka,Jp='You can also use the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to decode formats not supported by <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Features">Features</a>. For example, the <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Audio">Audio</a> feature uses <a href="https://python-soundfile.readthedocs.io/en/0.11.0/" rel="nofollow"><code>soundfile</code></a> - a fast and simple library to install - but it does not provide support for less common audio formats. Here is where you can use <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> to apply a custom decoding transform on the fly. You’re free to use any library you like to decode the audio files.',Hn,Oa,Up='The example below uses the <a href="http://pydub.com/" rel="nofollow"><code>pydub</code></a> package to open an audio format not supported by <code>soundfile</code>:',An,se,Sn,ae,Ln,ee,xp='Once you are done processing your dataset, you can save and reuse it later with <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.save_to_disk">save_to_disk()</a>.',Dn,te,$p="Save your dataset by providing the path to the directory you wish to save it to:",Pn,ne,Kn,le,_p='Use the <a href="/docs/datasets/v3.0.2/en/package_reference/loading_methods#datasets.load_from_disk">load_from_disk()</a> function to reload the dataset:',On,pe,sl,$,al,ie,el,re,kp="🤗 Datasets supports exporting as well so you can work with your dataset in other applications. The following table shows currently supported file formats you can export to:",tl,ce,Ip='<thead><tr><th>File type</th> <th>Export method</th></tr></thead> <tbody><tr><td>CSV</td> <td><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_csv">Dataset.to_csv()</a></td></tr> <tr><td>JSON</td> <td><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_json">Dataset.to_json()</a></td></tr> <tr><td>Parquet</td> <td><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_parquet">Dataset.to_parquet()</a></td></tr> <tr><td>SQL</td> <td><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_sql">Dataset.to_sql()</a></td></tr> <tr><td>In-memory Python object</td> <td><a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_pandas">Dataset.to_pandas()</a> or <a href="/docs/datasets/v3.0.2/en/package_reference/main_classes#datasets.Dataset.to_dict">Dataset.to_dict()</a></td></tr></tbody>',nl,he,Cp="For example, export your dataset to a CSV file like this:",ll,oe,pl,me,il,de,rl;return _=new M({props:{title:"Process",local:"process",headingTag:"h1"}}),G=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),T=new ue({props:{warning:!0,$$slots:{default:[Ep]},$$scope:{ctx:w}}}),X=new M({props:{title:"Sort, shuffle, select, split, and shard",local:"sort-shuffle-select-split-and-shard",headingTag:"h2"}}),Y=new M({props:{title:"Sort",local:"sort",headingTag:"h3"}}),N=new g({props:{code:"ZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJsYWJlbCUyMiklMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCLTEwJTNBJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset = dataset.sort(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][-<span class="hljs-number">10</span>:]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),B=new M({props:{title:"Shuffle",local:"shuffle",headingTag:"h3"}}),W=new g({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHNvcnRlZF9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyKSUwQXNodWZmbGVkX2RhdGFzZXQlNUIlMjJsYWJlbCUyMiU1RCU1QiUzQTEwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = sorted_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),z=new g({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTI4KSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBpdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMDAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">128</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_iterable_dataset = iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">1000</span>)`,wrap:!1}}),E=new M({props:{title:"Select and Filter",local:"select-and-filter",headingTag:"h3"}}),S=new g({props:{code:"c21hbGxfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0KCU1QjAlMkMlMjAxMCUyQyUyMDIwJTJDJTIwMzAlMkMlMjA0MCUyQyUyMDUwJTVEKSUwQWxlbihzbWFsbF9kYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_dataset = dataset.select([<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">30</span>, <span class="hljs-number">40</span>, <span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(small_dataset)
<span class="hljs-number">6</span>`,wrap:!1}}),D=new g({props:{code:"c3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVELnN0YXJ0c3dpdGgoJTIyQXIlMjIpKSUwQWxlbihzdGFydF93aXRoX2FyKSUwQXN0YXJ0X3dpdGhfYXIlNUIlMjJzZW50ZW5jZTElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&quot;sentence1&quot;</span>].startswith(<span class="hljs-string">&quot;Ar&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(start_with_ar)
<span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar[<span class="hljs-string">&quot;sentence1&quot;</span>]
[<span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
<span class="hljs-string">&#x27;Arison said Mann may have been one of the pioneers of the world music movement and he had a deep love of Brazilian music .&#x27;</span>,
<span class="hljs-string">&#x27;Arts helped coach the youth on an eighth-grade football team at Lombardi Middle School in Green Bay .&#x27;</span>,
<span class="hljs-string">&#x27;Around 9 : 00 a.m. EDT ( 1300 GMT ) , the euro was at $ 1.1566 against the dollar , up 0.07 percent on the day .&#x27;</span>,
<span class="hljs-string">&quot;Arguing that the case was an isolated example , Canada has threatened a trade backlash if Tokyo &#x27;s ban is not justified on scientific grounds .&quot;</span>,
<span class="hljs-string">&#x27;Artists are worried the plan would harm those who need help most - performers who have a difficult time lining up shows .&#x27;</span>
]`,wrap:!1}}),K=new g({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsZW4oZXZlbl9kYXRhc2V0KSUwQWxlbihkYXRhc2V0KSUyMCUyRiUyMDI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(even_dataset)
<span class="hljs-number">1834</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset) / <span class="hljs-number">2</span>
<span class="hljs-number">1834.0</span>`,wrap:!1}}),ss=new M({props:{title:"Split",local:"split",headingTag:"h3"}}),es=new g({props:{code:"ZGF0YXNldC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSklMEEwLjElMjAqJTIwbGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)
{<span class="hljs-string">&#x27;train&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">3301</span>),
<span class="hljs-string">&#x27;test&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">367</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-number">0.1</span> * <span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">366.8</span>`,wrap:!1}}),ns=new M({props:{title:"Shard",local:"shard",headingTag:"h3"}}),is=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWRiJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwcmludChkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">25000</span>
})`,wrap:!1}}),cs=new g({props:{code:"ZGF0YXNldC5zaGFyZChudW1fc2hhcmRzJTNENCUyQyUyMGluZGV4JTNEMCklMEFwcmludCgyNTAwMCUyRjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.shard(num_shards=<span class="hljs-number">4</span>, index=<span class="hljs-number">0</span>)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">6250</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-number">25000</span>/<span class="hljs-number">4</span>)
<span class="hljs-number">6250.0</span>`,wrap:!1}}),hs=new M({props:{title:"Rename, remove, cast, and flatten",local:"rename-remove-cast-and-flatten",headingTag:"h2"}}),ms=new M({props:{title:"Rename",local:"rename",headingTag:"h3"}}),js=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UxJTIyJTJDJTIwJTIyc2VudGVuY2VBJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UyJTIyJTJDJTIwJTIyc2VudGVuY2VCJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentenceA&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;sentenceB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentenceA&#x27;</span>, <span class="hljs-string">&#x27;sentenceB&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),gs=new M({props:{title:"Remove",local:"remove",headingTag:"h3"}}),Ms=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTIybGFiZWwlMjIpJTBBZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiU1RCklMEFkYXRhc2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),bs=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdF9jb2x1bW5zKCU1QidzZW50ZW5jZTEnJTJDJTIwJ3NlbnRlbmNlMiclMkMlMjAnaWR4JyU1RCklMEFkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0X2NvbHVtbnMoJ2lkeCcpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns([<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns(<span class="hljs-string">&#x27;idx&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),ws=new M({props:{title:"Cast",local:"cast",headingTag:"h3"}}),Js=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMENsYXNzTGFiZWwlMkMlMjBWYWx1ZSUwQW5ld19mZWF0dXJlcyUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMuY29weSgpJTBBbmV3X2ZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQlMjAlM0QlMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklMEFuZXdfZmVhdHVyZXMlNUIlMjJpZHglMjIlNUQlMjAlM0QlMjBWYWx1ZSglMjJpbnQ2NCUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5jYXN0KG5ld19mZWF0dXJlcyklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&quot;int64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),J=new ue({props:{$$slots:{default:[Hp]},$$scope:{ctx:w}}}),xs=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),$s=new M({props:{title:"Flatten",local:"flatten",headingTag:"h3"}}),ks=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcXVhZCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;answers&#x27;</span>: <span class="hljs-type">Sequence</span>(feature={<span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), <span class="hljs-string">&#x27;answer_start&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}, length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;context&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;title&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Cs=new g({props:{code:"ZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;context&#x27;</span>, <span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;answers.text&#x27;</span>, <span class="hljs-string">&#x27;answers.answer_start&#x27;</span>],
 num_rows: <span class="hljs-number">87599</span>
})`,wrap:!1}}),vs=new M({props:{title:"Map",local:"map",headingTag:"h2"}}),Ys=new g({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMjAlM0QlMjAnTXklMjBzZW50ZW5jZSUzQSUyMCclMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;sentence1&quot;</span>] = <span class="hljs-string">&#x27;My sentence: &#x27;</span> + example[<span class="hljs-string">&quot;sentence1&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Ns=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTElMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = small_dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence1&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;My sentence: Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&quot;My sentence: Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
<span class="hljs-string">&#x27;My sentence: They had published an advertisement on the Internet on June 10 , offering the cargo for sale , he added .&#x27;</span>,
<span class="hljs-string">&#x27;My sentence: Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
]`,wrap:!1}}),Qs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMm5ld19zZW50ZW5jZSUyMiUzQSUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnNlbnRlbmNlMSUyMiU1RCklMEF1cGRhdGVkX2RhdGFzZXQuY29sdW1uX25hbWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;new_sentence&quot;</span>: example[<span class="hljs-string">&quot;sentence1&quot;</span>]}, remove_columns=[<span class="hljs-string">&quot;sentence1&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset.column_names
[<span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;new_sentence&#x27;</span>]`,wrap:!1}}),U=new ue({props:{$$slots:{default:[Ap]},$$scope:{ctx:w}}}),qs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTIlMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence2&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;0: Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&quot;1: Yucaipa bought Dominick &#x27;s in 1995 for $ 693 million and sold it to Safeway for $ 1.8 billion in 1998 .&quot;</span>,
 <span class="hljs-string">&quot;2: On June 10 , the ship &#x27;s owners had published an advertisement on the Internet , offering the explosives for sale .&quot;</span>,
 <span class="hljs-string">&#x27;3: Tab shares jumped 20 cents , or 4.6 % , to set a record closing high at A $ 4.57 .&#x27;</span>,
 <span class="hljs-string">&#x27;4: PG &amp; E Corp. shares jumped $ 1.63 or 8 percent to $ 21.03 on the New York Stock Exchange on Friday .&#x27;</span>
]`,wrap:!1}}),zs=new M({props:{title:"Multiprocessing",local:"multiprocessing",headingTag:"h3"}}),Hs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSUyQyUyMG51bV9wcm9jJTNENCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, with_indices=<span class="hljs-literal">True</span>, num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),Ss=new g({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> multiprocess <span class="hljs-keyword">import</span> set_start_method
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get an example dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;fka/awesome-chatgpt-prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get an example model and its tokenizer </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen1.5-0.5B-Chat&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen1.5-0.5B-Chat&quot;</span>)
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">gpu_computation</span>(<span class="hljs-params">batch, rank</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Move the model on the right GPU if it&#x27;s not there already</span>
<span class="hljs-meta">... </span>    device = <span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{(rank <span class="hljs-keyword">or</span> <span class="hljs-number">0</span>) % torch.cuda.device_count()}</span>&quot;</span>
<span class="hljs-meta">... </span>    model.to(device)
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Your big GPU call goes here, for example:</span>
<span class="hljs-meta">... </span>    chats = [[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}
<span class="hljs-meta">... </span>    ] <span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;prompt&quot;</span>]]
<span class="hljs-meta">... </span>    texts = [tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>        chat,
<span class="hljs-meta">... </span>        tokenize=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    ) <span class="hljs-keyword">for</span> chat <span class="hljs-keyword">in</span> chats]
<span class="hljs-meta">... </span>    model_inputs = tokenizer(texts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">512</span>)
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;output&quot;</span>] = tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
<span class="hljs-meta">... </span>    set_start_method(<span class="hljs-string">&quot;spawn&quot;</span>)
<span class="hljs-meta">... </span>    updated_dataset = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>        gpu_computation,
<span class="hljs-meta">... </span>        batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>        with_rank=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        num_proc=torch.cuda.device_count(),  <span class="hljs-comment"># one process per GPU</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Ds=new g({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ2Fubm90JTIwcmUtaW5pdGlhbGl6ZSUyMENVREElMjBpbiUyMGZvcmtlZCUyMHN1YnByb2Nlc3MuJTIwVG8lMjB1c2UlMjBDVURBJTIwd2l0aCUyMG11bHRpcHJvY2Vzc2luZyUyQyUyMHlvdSUyMG11c3QlMjB1c2UlMjB0aGUlMjAnc3Bhd24nJTIwc3RhcnQlMjBtZXRob2Qu",highlighted:'RuntimeError: Cannot re-initialize CUDA <span class="hljs-keyword">in</span> forked subprocess. To use CUDA with multiprocessing, you must use the <span class="hljs-string">&#x27;spawn&#x27;</span> start method.',wrap:!1}}),Ps=new M({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),Os=new M({props:{title:"Split long examples",local:"split-long-examples",headingTag:"h4"}}),ea=new g({props:{code:"ZGVmJTIwY2h1bmtfZXhhbXBsZXMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc2VudGVuY2UlMjBpbiUyMGV4YW1wbGVzJTVCJTIyc2VudGVuY2UxJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUJpJTNBaSUyMCUyQiUyMDUwJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihzZW50ZW5jZSklMkMlMjA1MCklNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJjaHVua3MlMjIlM0ElMjBjaHVua3MlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk_examples</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    chunks = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        chunks += [sentence[i:i + <span class="hljs-number">50</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(sentence), <span class="hljs-number">50</span>)]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chunks&quot;</span>: chunks}`,wrap:!1}}),na=new g({props:{code:"Y2h1bmtlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2h1bmtfZXhhbXBsZXMlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMpJTBBY2h1bmtlZF9kYXRhc2V0JTVCJTNBMTAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset = dataset.<span class="hljs-built_in">map</span>(chunk_examples, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names)
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset[:<span class="hljs-number">10</span>]
{<span class="hljs-string">&#x27;chunks&#x27;</span>: [<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the &#x27;</span>,
            <span class="hljs-string">&#x27;witness &quot; , of deliberately distorting his evidenc&#x27;</span>,
            <span class="hljs-string">&#x27;e .&#x27;</span>,
            <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain&quot;</span>,
            <span class="hljs-string">&#x27; to Safeway in 1998 for $ 2.5 billion .&#x27;</span>,
            <span class="hljs-string">&#x27;They had published an advertisement on the Interne&#x27;</span>,
            <span class="hljs-string">&#x27;t on June 10 , offering the cargo for sale , he ad&#x27;</span>,
            <span class="hljs-string">&#x27;ded .&#x27;</span>,
            <span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or&#x27;</span>,
            <span class="hljs-string">&#x27; 4.4 % , at A $ 4.56 , having earlier set a record&#x27;</span>]}`,wrap:!1}}),pa=new g({props:{code:"ZGF0YXNldCUwQWNodW5rZWRfZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
 features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
 num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;chunks&#x27;</span>],
    num_rows: <span class="hljs-number">10470</span>
})`,wrap:!1}}),ia=new M({props:{title:"Data augmentation",local:"data-augmentation",headingTag:"h4"}}),ha=new g({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRpbnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFmaWxsbWFzayUyMCUzRCUyMHBpcGVsaW5lKCUyMmZpbGwtbWFzayUyMiUyQyUyMG1vZGVsJTNEJTIycm9iZXJ0YS1iYXNlJTIyKSUwQW1hc2tfdG9rZW4lMjAlM0QlMjBmaWxsbWFzay50b2tlbml6ZXIubWFza190b2tlbiUwQXNtYWxsZXJfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGUlMkMlMjBpJTNBJTIwaSUzQzEwMCUyQyUyMHdpdGhfaW5kaWNlcyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>fillmask = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=<span class="hljs-string">&quot;roberta-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token = fillmask.tokenizer.mask_token
<span class="hljs-meta">&gt;&gt;&gt; </span>smaller_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> e, i: i&lt;<span class="hljs-number">100</span>, with_indices=<span class="hljs-literal">True</span>)`,wrap:!1}}),ma=new g({props:{code:"ZGVmJTIwYXVnbWVudF9kYXRhKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBzZW50ZW5jZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3JkcyUyMCUzRCUyMHNlbnRlbmNlLnNwbGl0KCclMjAnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEslMjAlM0QlMjByYW5kaW50KDElMkMlMjBsZW4od29yZHMpLTEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFza2VkX3NlbnRlbmNlJTIwJTNEJTIwJTIyJTIwJTIyLmpvaW4od29yZHMlNUIlM0FLJTVEJTIwJTIwJTJCJTIwJTVCbWFza190b2tlbiU1RCUyMCUyQiUyMHdvcmRzJTVCSyUyQjElM0ElNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBmaWxsbWFzayhtYXNrZWRfc2VudGVuY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVnbWVudGVkX3NlcXVlbmNlcyUyMCUzRCUyMCU1QnByZWRpY3Rpb25zJTVCaSU1RCU1QiUyMnNlcXVlbmNlJTIyJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUQlMjAlMkIlMjBhdWdtZW50ZWRfc2VxdWVuY2VzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyZGF0YSUyMiUzQSUyMG91dHB1dHMlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">augment_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    outputs = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        words = sentence.split(<span class="hljs-string">&#x27; &#x27;</span>)
<span class="hljs-meta">... </span>        K = randint(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(words)-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        masked_sentence = <span class="hljs-string">&quot; &quot;</span>.join(words[:K]  + [mask_token] + words[K+<span class="hljs-number">1</span>:])
<span class="hljs-meta">... </span>        predictions = fillmask(masked_sentence)
<span class="hljs-meta">... </span>        augmented_sequences = [predictions[i][<span class="hljs-string">&quot;sequence&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>)]
<span class="hljs-meta">... </span>        outputs += [sentence] + augmented_sequences
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;data&quot;</span>: outputs}`,wrap:!1}}),ua=new g({props:{code:"YXVnbWVudGVkX2RhdGFzZXQlMjAlM0QlMjBzbWFsbGVyX2RhdGFzZXQubWFwKGF1Z21lbnRfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0LmNvbHVtbl9uYW1lcyUyQyUyMGJhdGNoX3NpemUlM0Q4KSUwQWF1Z21lbnRlZF9kYXRhc2V0JTVCJTNBOSU1RCU1QiUyMmRhdGElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset = smaller_dataset.<span class="hljs-built_in">map</span>(augment_data, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset[:<span class="hljs-number">9</span>][<span class="hljs-string">&quot;data&quot;</span>]
[<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately withholding his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately suppressing his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately destroying his evidence.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Stores before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick&#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion.&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Pizza before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>
]`,wrap:!1}}),ga=new M({props:{title:"Process multiple splits",local:"process-multiple-splits",headingTag:"h3"}}),Ma=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYycpJTBBZW5jb2RlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZXMlM0ElMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBZW5jb2RlZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># load all the splits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> examples: tokenizer(examples[<span class="hljs-string">&quot;sentence1&quot;</span>]), batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
<span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
<span class="hljs-string">&#x27;input_ids&#x27;</span>: [  <span class="hljs-number">101</span>,  <span class="hljs-number">7277</span>,  <span class="hljs-number">2180</span>,  <span class="hljs-number">5303</span>,  <span class="hljs-number">4806</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">1711</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">2292</span>, <span class="hljs-number">1119</span>,  <span class="hljs-number">1270</span>,   <span class="hljs-number">107</span>,  <span class="hljs-number">1103</span>,  <span class="hljs-number">7737</span>,   <span class="hljs-number">107</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">1104</span>,  <span class="hljs-number">9938</span>, <span class="hljs-number">4267</span>, <span class="hljs-number">12223</span>, <span class="hljs-number">21811</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">2554</span>,   <span class="hljs-number">119</span>,   <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]
}`,wrap:!1}}),ya=new M({props:{title:"Distributed usage",local:"distributed-usage",headingTag:"h3"}}),Ta=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHRvcmNoLmRpc3RyaWJ1dGVkJTBBJTBBZGF0YXNldDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQSUwQWlmJTIwdHJhaW5pbmdfYXJncy5sb2NhbF9yYW5rJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMldhaXRpbmclMjBmb3IlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwcGVyZm9ybSUyMHRoZSUyMG1hcHBpbmclMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigpJTBBJTBBZGF0YXNldDIlMjAlM0QlMjBkYXRhc2V0MS5tYXAobGFtYmRhJTIweCUzQSUyMCU3QiUyMmElMjIlM0ElMjB4JTVCJTIyYSUyMiU1RCUyMCUyQiUyMDElN0QpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmxvY2FsX3JhbmslMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTG9hZGluZyUyMHJlc3VsdHMlMjBmcm9tJTIwbWFpbiUyMHByb2Nlc3MlMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.distributed

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank &gt; <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for main process to perform the mapping&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset2 = dataset1.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;a&quot;</span>: x[<span class="hljs-string">&quot;a&quot;</span>] + <span class="hljs-number">1</span>})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading results from main process&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()`,wrap:!1}}),Ja=new M({props:{title:"Batch",local:"batch",headingTag:"h2"}}),$a=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWJhdGNoZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuYmF0Y2goYmF0Y2hfc2l6ZSUzRDQpJTBBYmF0Y2hlZF9kYXRhc2V0JTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batched_dataset = dataset.batch(batch_size=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batched_dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
        <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
        <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
        <span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>],
<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),Ca=new M({props:{title:"Concatenate",local:"concatenate",headingTag:"h2"}}),va=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwY29uY2F0ZW5hdGVfZGF0YXNldHMlMkMlMjBsb2FkX2RhdGFzZXQlMEElMEFib29rY29ycHVzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmJvb2tjb3JwdXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyd2lraXBlZGlhJTIyJTJDJTIwJTIyMjAyMjAzMDEuZW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjB3aWtpLnJlbW92ZV9jb2x1bW5zKCU1QmNvbCUyMGZvciUyMGNvbCUyMGluJTIwd2lraS5jb2x1bW5fbmFtZXMlMjBpZiUyMGNvbCUyMCElM0QlMjAlMjJ0ZXh0JTIyJTVEKSUyMCUyMCUyMyUyMG9ubHklMjBrZWVwJTIwdGhlJTIwJ3RleHQnJTIwY29sdW1uJTBBJTBBYXNzZXJ0JTIwYm9va2NvcnB1cy5mZWF0dXJlcy50eXBlJTIwJTNEJTNEJTIwd2lraS5mZWF0dXJlcy50eXBlJTBBYmVydF9kYXRhc2V0JTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMHdpa2klNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> concatenate_datasets, load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus = load_dataset(<span class="hljs-string">&quot;bookcorpus&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = load_dataset(<span class="hljs-string">&quot;wikipedia&quot;</span>, <span class="hljs-string">&quot;20220301.en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = wiki.remove_columns([col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> wiki.column_names <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>])  <span class="hljs-comment"># only keep the &#x27;text&#x27; column</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> bookcorpus.features.<span class="hljs-built_in">type</span> == wiki.features.<span class="hljs-built_in">type</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bert_dataset = concatenate_datasets([bookcorpus, wiki])`,wrap:!1}}),Xa=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWJvb2tjb3JwdXNfaWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaWRzJTIyJTNBJTIwbGlzdChyYW5nZShsZW4oYm9va2NvcnB1cykpKSU3RCklMEFib29rY29ycHVzX3dpdGhfaWRzJTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMGJvb2tjb3JwdXNfaWRzJTVEJTJDJTIwYXhpcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_ids = Dataset.from_dict({<span class="hljs-string">&quot;ids&quot;</span>: <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(bookcorpus)))})
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_with_ids = concatenate_datasets([bookcorpus, bookcorpus_ids], axis=<span class="hljs-number">1</span>)`,wrap:!1}}),Ra=new M({props:{title:"Interleave",local:"interleave",headingTag:"h3"}}),Na=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGludGVybGVhdmVfZGF0YXNldHMlMEFzZWVkJTIwJTNEJTIwNDIlMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwJTVCMC4zJTJDJTIwMC41JTJDJTIwMC4yJTVEJTBBZDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWQyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTVEJTdEKSUwQWQzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjIwJTJDJTIwMjElMkMlMjAyMiU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJkMSUyQyUyMGQyJTJDJTIwZDMlNUQlMkMlMjBwcm9iYWJpbGl0aWVzJTNEcHJvYmFiaWxpdGllcyUyQyUyMHNlZWQlM0RzZWVkKSUwQWRhdGFzZXQlNUIlMjJhJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>seed = <span class="hljs-number">42</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], probabilities=probabilities, seed=seed)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">20</span>, <span class="hljs-number">12</span>, <span class="hljs-number">0</span>, <span class="hljs-number">21</span>, <span class="hljs-number">13</span>]`,wrap:!1}}),Ba=new g({props:{code:"ZDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWQyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTVEJTdEKSUwQWQzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjIwJTJDJTIwMjElMkMlMjAyMiU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJkMSUyQyUyMGQyJTJDJTIwZDMlNUQlMkMlMjBzdG9wcGluZ19zdHJhdGVneSUzRCUyMmFsbF9leGhhdXN0ZWQlMjIpJTBBZGF0YXNldCU1QiUyMmElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], stopping_strategy=<span class="hljs-string">&quot;all_exhausted&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">1</span>, <span class="hljs-number">11</span>, <span class="hljs-number">21</span>, <span class="hljs-number">2</span>, <span class="hljs-number">12</span>, <span class="hljs-number">22</span>, <span class="hljs-number">0</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),Qa=new M({props:{title:"Format",local:"format",headingTag:"h2"}}),za=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkYXRhc2V0LnNldF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Ha=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])',wrap:!1}}),x=new ue({props:{$$slots:{default:[Sp]},$$scope:{ctx:w}}}),Sa=new g({props:{code:"ZGF0YXNldC5mb3JtYXQlMEFkYXRhc2V0LnJlc2V0X2Zvcm1hdCgpJTBBZGF0YXNldC5mb3JtYXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;torch&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;label&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.reset_format()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),La=new M({props:{title:"Format transform",local:"format-transform",headingTag:"h3"}}),Pa=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFkZWYlMjBlbmNvZGUoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGJhdGNoJTVCJTIyc2VudGVuY2UxJTIyJTVEJTJDJTIwYmF0Y2glNUIlMjJzZW50ZW5jZTIlMjIlNUQlMkMlMjBwYWRkaW5nJTNEJTIybG9uZ2VzdCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwbWF4X2xlbmd0aCUzRDUxMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKGVuY29kZSklMEFkYXRhc2V0LmZvcm1hdA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;sentence1&quot;</span>], batch[<span class="hljs-string">&quot;sentence2&quot;</span>], padding=<span class="hljs-string">&quot;longest&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">512</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(encode)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;custom&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {<span class="hljs-string">&#x27;transform&#x27;</span>: &lt;function __main__.encode(batch)&gt;}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),se=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMHB5ZHViJTIwaW1wb3J0JTIwQXVkaW9TZWdtZW50JTBBJTBBYXVkaW9fZGF0YXNldF9hbXIlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMCU1QiUyMmF1ZGlvX3NhbXBsZXMlMkZhdWRpby5hbXIlMjIlNUQlN0QpJTBBJTBBZGVmJTIwZGVjb2RlX2F1ZGlvX3dpdGhfcHlkdWIoYmF0Y2glMkMlMjBzYW1wbGluZ19yYXRlJTNEMTZfMDAwKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB5ZHViX2RlY29kZV9maWxlKGF1ZGlvX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291bmQlMjAlM0QlMjBBdWRpb1NlZ21lbnQuZnJvbV9maWxlKGF1ZGlvX3BhdGgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzb3VuZC5mcmFtZV9yYXRlJTIwISUzRCUyMHNhbXBsaW5nX3JhdGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzb3VuZCUyMCUzRCUyMHNvdW5kLnNldF9mcmFtZV9yYXRlKHNhbXBsaW5nX3JhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhbm5lbF9zb3VuZHMlMjAlM0QlMjBzb3VuZC5zcGxpdF90b19tb25vKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwJTVCcy5nZXRfYXJyYXlfb2Zfc2FtcGxlcygpJTIwZm9yJTIwcyUyMGluJTIwY2hhbm5lbF9zb3VuZHMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcF9hcnIlMjAlM0QlMjBucC5hcnJheShzYW1wbGVzKS5ULmFzdHlwZShucC5mbG9hdDMyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwX2FyciUyMCUyRiUzRCUyMG5wLmlpbmZvKHNhbXBsZXMlNUIwJTVELnR5cGVjb2RlKS5tYXglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmcF9hcnIlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTIwJTNEJTIwJTVCcHlkdWJfZGVjb2RlX2ZpbGUoYXVkaW9fcGF0aCklMjBmb3IlMjBhdWRpb19wYXRoJTIwaW4lMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEFhdWRpb19kYXRhc2V0X2Ftci5zZXRfdHJhbnNmb3JtKGRlY29kZV9hdWRpb193aXRoX3B5ZHViKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pydub <span class="hljs-keyword">import</span> AudioSegment

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;audio_samples/audio.amr&quot;</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_audio_with_pydub</span>(<span class="hljs-params">batch, sampling_rate=<span class="hljs-number">16_000</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">pydub_decode_file</span>(<span class="hljs-params">audio_path</span>):
<span class="hljs-meta">... </span>        sound = AudioSegment.from_file(audio_path)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> sound.frame_rate != sampling_rate:
<span class="hljs-meta">... </span>            sound = sound.set_frame_rate(sampling_rate)
<span class="hljs-meta">... </span>        channel_sounds = sound.split_to_mono()
<span class="hljs-meta">... </span>        samples = [s.get_array_of_samples() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> channel_sounds]
<span class="hljs-meta">... </span>        fp_arr = np.array(samples).T.astype(np.float32)
<span class="hljs-meta">... </span>        fp_arr /= np.iinfo(samples[<span class="hljs-number">0</span>].typecode).<span class="hljs-built_in">max</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> fp_arr
...
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;audio&quot;</span>] = [pydub_decode_file(audio_path) <span class="hljs-keyword">for</span> audio_path <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;audio&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr.set_transform(decode_audio_with_pydub)`,wrap:!1}}),ae=new M({props:{title:"Save",local:"save",headingTag:"h2"}}),ne=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQlMkZkaXJlY3RvcnklMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)',wrap:!1}}),pe=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFyZWxvYWRlZF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9mcm9tX2Rpc2soJTIycGF0aCUyRm9mJTJGbXklMkZkYXRhc2V0JTJGZGlyZWN0b3J5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_dataset = load_from_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)`,wrap:!1}}),$=new ue({props:{$$slots:{default:[Lp]},$$scope:{ctx:w}}}),ie=new M({props:{title:"Export",local:"export",headingTag:"h2"}}),oe=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnRvX2NzdiglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQuY3N2JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.to_csv(<span class="hljs-string">&quot;path/of/my/dataset.csv&quot;</span>)',wrap:!1}}),me=new zp({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/process.mdx"}}),{c(){j=p("meta"),y=n(),f=p("p"),b=n(),c(_.$$.fragment),ge=n(),k=p("p"),k.textContent=cl,fe=n(),I=p("p"),I.textContent=hl,Me=n(),C=p("ul"),C.innerHTML=ol,ye=n(),Z=p("p"),Z.innerHTML=ml,be=n(),v=p("p"),v.textContent=dl,we=n(),c(G.$$.fragment),Te=n(),c(T.$$.fragment),Je=n(),c(X.$$.fragment),Ue=n(),R=p("p"),R.textContent=ul,xe=n(),c(Y.$$.fragment),$e=n(),V=p("p"),V.innerHTML=jl,_e=n(),c(N.$$.fragment),ke=n(),F=p("p"),F.textContent=gl,Ie=n(),c(B.$$.fragment),Ce=n(),Q=p("p"),Q.innerHTML=fl,Ze=n(),c(W.$$.fragment),ve=n(),q=p("p"),q.innerHTML=Ml,Ge=n(),c(z.$$.fragment),Xe=n(),c(E.$$.fragment),Re=n(),H=p("p"),H.innerHTML=yl,Ye=n(),A=p("ul"),A.innerHTML=bl,Ve=n(),c(S.$$.fragment),Ne=n(),L=p("ul"),L.innerHTML=wl,Fe=n(),c(D.$$.fragment),Be=n(),P=p("p"),P.innerHTML=Tl,Qe=n(),c(K.$$.fragment),We=n(),O=p("p"),O.textContent=Jl,qe=n(),c(ss.$$.fragment),ze=n(),as=p("p"),as.innerHTML=Ul,Ee=n(),c(es.$$.fragment),He=n(),ts=p("p"),ts.innerHTML=xl,Ae=n(),c(ns.$$.fragment),Se=n(),ls=p("p"),ls.innerHTML=$l,Le=n(),ps=p("p"),ps.innerHTML=_l,De=n(),c(is.$$.fragment),Pe=n(),rs=p("p"),rs.textContent=kl,Ke=n(),c(cs.$$.fragment),Oe=n(),c(hs.$$.fragment),st=n(),os=p("p"),os.textContent=Il,at=n(),c(ms.$$.fragment),et=n(),ds=p("p"),ds.innerHTML=Cl,tt=n(),us=p("p"),us.innerHTML=Zl,nt=n(),c(js.$$.fragment),lt=n(),c(gs.$$.fragment),pt=n(),fs=p("p"),fs.innerHTML=vl,it=n(),c(Ms.$$.fragment),rt=n(),ys=p("p"),ys.innerHTML=Gl,ct=n(),c(bs.$$.fragment),ht=n(),c(ws.$$.fragment),ot=n(),Ts=p("p"),Ts.innerHTML=Xl,mt=n(),c(Js.$$.fragment),dt=n(),c(J.$$.fragment),ut=n(),Us=p("p"),Us.innerHTML=Rl,jt=n(),c(xs.$$.fragment),gt=n(),c($s.$$.fragment),ft=n(),_s=p("p"),_s.textContent=Yl,Mt=n(),c(ks.$$.fragment),yt=n(),Is=p("p"),Is.innerHTML=Vl,bt=n(),c(Cs.$$.fragment),wt=n(),Zs=p("p"),Zs.innerHTML=Nl,Tt=n(),c(vs.$$.fragment),Jt=n(),Gs=p("p"),Gs.innerHTML=Fl,Ut=n(),Xs=p("p"),Xs.innerHTML=Bl,xt=n(),Rs=p("p"),Rs.innerHTML=Ql,$t=n(),c(Ys.$$.fragment),_t=n(),Vs=p("p"),Vs.innerHTML=Wl,kt=n(),c(Ns.$$.fragment),It=n(),Fs=p("p"),Fs.innerHTML=ql,Ct=n(),Bs=p("p"),Bs.innerHTML=zl,Zt=n(),c(Qs.$$.fragment),vt=n(),c(U.$$.fragment),Gt=n(),Ws=p("p"),Ws.innerHTML=El,Xt=n(),c(qs.$$.fragment),Rt=n(),c(zs.$$.fragment),Yt=n(),Es=p("p"),Es.innerHTML=Hl,Vt=n(),c(Hs.$$.fragment),Nt=n(),As=p("p"),As.innerHTML=Al,Ft=n(),c(Ss.$$.fragment),Bt=n(),Ls=p("p"),Ls.innerHTML=Sl,Qt=n(),c(Ds.$$.fragment),Wt=n(),c(Ps.$$.fragment),qt=n(),Ks=p("p"),Ks.innerHTML=Ll,zt=n(),c(Os.$$.fragment),Et=n(),sa=p("p"),sa.textContent=Dl,Ht=n(),aa=p("ol"),aa.innerHTML=Pl,At=n(),c(ea.$$.fragment),St=n(),ta=p("p"),ta.innerHTML=Kl,Lt=n(),c(na.$$.fragment),Dt=n(),la=p("p"),la.textContent=Ol,Pt=n(),c(pa.$$.fragment),Kt=n(),c(ia.$$.fragment),Ot=n(),ra=p("p"),ra.innerHTML=sp,sn=n(),ca=p("p"),ca.innerHTML=ap,an=n(),c(ha.$$.fragment),en=n(),oa=p("p"),oa.textContent=ep,tn=n(),c(ma.$$.fragment),nn=n(),da=p("p"),da.innerHTML=tp,ln=n(),c(ua.$$.fragment),pn=n(),ja=p("p"),ja.innerHTML=np,rn=n(),c(ga.$$.fragment),cn=n(),fa=p("p"),fa.innerHTML=lp,hn=n(),c(Ma.$$.fragment),on=n(),c(ya.$$.fragment),mn=n(),ba=p("p"),ba.innerHTML=pp,dn=n(),wa=p("p"),wa.innerHTML=ip,un=n(),c(Ta.$$.fragment),jn=n(),c(Ja.$$.fragment),gn=n(),Ua=p("p"),Ua.innerHTML=rp,fn=n(),xa=p("p"),xa.innerHTML=cp,Mn=n(),c($a.$$.fragment),yn=n(),_a=p("p"),_a.innerHTML=hp,bn=n(),ka=p("ul"),ka.innerHTML=op,wn=n(),Ia=p("p"),Ia.innerHTML=mp,Tn=n(),c(Ca.$$.fragment),Jn=n(),Za=p("p"),Za.innerHTML=dp,Un=n(),c(va.$$.fragment),xn=n(),Ga=p("p"),Ga.innerHTML=up,$n=n(),c(Xa.$$.fragment),_n=n(),c(Ra.$$.fragment),kn=n(),Ya=p("p"),Ya.innerHTML=jp,In=n(),Va=p("p"),Va.textContent=gp,Cn=n(),c(Na.$$.fragment),Zn=n(),Fa=p("p"),Fa.innerHTML=fp,vn=n(),c(Ba.$$.fragment),Gn=n(),c(Qa.$$.fragment),Xn=n(),Wa=p("p"),Wa.innerHTML=Mp,Rn=n(),qa=p("p"),qa.innerHTML=yp,Yn=n(),c(za.$$.fragment),Vn=n(),Ea=p("p"),Ea.innerHTML=bp,Nn=n(),c(Ha.$$.fragment),Fn=n(),c(x.$$.fragment),Bn=n(),Aa=p("p"),Aa.innerHTML=wp,Qn=n(),c(Sa.$$.fragment),Wn=n(),c(La.$$.fragment),qn=n(),Da=p("p"),Da.innerHTML=Tp,zn=n(),c(Pa.$$.fragment),En=n(),Ka=p("p"),Ka.innerHTML=Jp,Hn=n(),Oa=p("p"),Oa.innerHTML=Up,An=n(),c(se.$$.fragment),Sn=n(),c(ae.$$.fragment),Ln=n(),ee=p("p"),ee.innerHTML=xp,Dn=n(),te=p("p"),te.textContent=$p,Pn=n(),c(ne.$$.fragment),Kn=n(),le=p("p"),le.innerHTML=_p,On=n(),c(pe.$$.fragment),sl=n(),c($.$$.fragment),al=n(),c(ie.$$.fragment),el=n(),re=p("p"),re.textContent=kp,tl=n(),ce=p("table"),ce.innerHTML=Ip,nl=n(),he=p("p"),he.textContent=Cp,ll=n(),c(oe.$$.fragment),pl=n(),c(me.$$.fragment),il=n(),de=p("p"),this.h()},l(s){const a=Wp("svelte-u9bgzb",document.head);j=i(a,"META",{name:!0,content:!0}),a.forEach(e),y=l(s),f=i(s,"P",{}),Yp(f).forEach(e),b=l(s),h(_.$$.fragment,s),ge=l(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-o0c0lx"&&(k.textContent=cl),fe=l(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1aff4p7"&&(I.textContent=hl),Me=l(s),C=i(s,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-141dx8c"&&(C.innerHTML=ol),ye=l(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1xlvt1h"&&(Z.innerHTML=ml),be=l(s),v=i(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1bplt66"&&(v.textContent=dl),we=l(s),h(G.$$.fragment,s),Te=l(s),h(T.$$.fragment,s),Je=l(s),h(X.$$.fragment,s),Ue=l(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bmil1o"&&(R.textContent=ul),xe=l(s),h(Y.$$.fragment,s),$e=l(s),V=i(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-eeg7n4"&&(V.innerHTML=jl),_e=l(s),h(N.$$.fragment,s),ke=l(s),F=i(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-50nyg6"&&(F.textContent=gl),Ie=l(s),h(B.$$.fragment,s),Ce=l(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-dqcksx"&&(Q.innerHTML=fl),Ze=l(s),h(W.$$.fragment,s),ve=l(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1jk2wqb"&&(q.innerHTML=Ml),Ge=l(s),h(z.$$.fragment,s),Xe=l(s),h(E.$$.fragment,s),Re=l(s),H=i(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-8c2kzl"&&(H.innerHTML=yl),Ye=l(s),A=i(s,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1yfpp8t"&&(A.innerHTML=bl),Ve=l(s),h(S.$$.fragment,s),Ne=l(s),L=i(s,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-gl79mb"&&(L.innerHTML=wl),Fe=l(s),h(D.$$.fragment,s),Be=l(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ut71hh"&&(P.innerHTML=Tl),Qe=l(s),h(K.$$.fragment,s),We=l(s),O=i(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1y27i4k"&&(O.textContent=Jl),qe=l(s),h(ss.$$.fragment,s),ze=l(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-1e3urfi"&&(as.innerHTML=Ul),Ee=l(s),h(es.$$.fragment,s),He=l(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-kxs7ja"&&(ts.innerHTML=xl),Ae=l(s),h(ns.$$.fragment,s),Se=l(s),ls=i(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1kekmup"&&(ls.innerHTML=$l),Le=l(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1fijfvt"&&(ps.innerHTML=_l),De=l(s),h(is.$$.fragment,s),Pe=l(s),rs=i(s,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-189aje2"&&(rs.textContent=kl),Ke=l(s),h(cs.$$.fragment,s),Oe=l(s),h(hs.$$.fragment,s),st=l(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1vk4iy9"&&(os.textContent=Il),at=l(s),h(ms.$$.fragment,s),et=l(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1q0xoza"&&(ds.innerHTML=Cl),tt=l(s),us=i(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-shib55"&&(us.innerHTML=Zl),nt=l(s),h(js.$$.fragment,s),lt=l(s),h(gs.$$.fragment,s),pt=l(s),fs=i(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1a2l0gw"&&(fs.innerHTML=vl),it=l(s),h(Ms.$$.fragment,s),rt=l(s),ys=i(s,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-l6yhq9"&&(ys.innerHTML=Gl),ct=l(s),h(bs.$$.fragment,s),ht=l(s),h(ws.$$.fragment,s),ot=l(s),Ts=i(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1jxd9ru"&&(Ts.innerHTML=Xl),mt=l(s),h(Js.$$.fragment,s),dt=l(s),h(J.$$.fragment,s),ut=l(s),Us=i(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-1jn3qr0"&&(Us.innerHTML=Rl),jt=l(s),h(xs.$$.fragment,s),gt=l(s),h($s.$$.fragment,s),ft=l(s),_s=i(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-68ctim"&&(_s.textContent=Yl),Mt=l(s),h(ks.$$.fragment,s),yt=l(s),Is=i(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-41xmbg"&&(Is.innerHTML=Vl),bt=l(s),h(Cs.$$.fragment,s),wt=l(s),Zs=i(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-80t9a4"&&(Zs.innerHTML=Nl),Tt=l(s),h(vs.$$.fragment,s),Jt=l(s),Gs=i(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-14h40ei"&&(Gs.innerHTML=Fl),Ut=l(s),Xs=i(s,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-1tkgss"&&(Xs.innerHTML=Bl),xt=l(s),Rs=i(s,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-1t98b4r"&&(Rs.innerHTML=Ql),$t=l(s),h(Ys.$$.fragment,s),_t=l(s),Vs=i(s,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-1e87g7l"&&(Vs.innerHTML=Wl),kt=l(s),h(Ns.$$.fragment,s),It=l(s),Fs=i(s,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-16dgsft"&&(Fs.innerHTML=ql),Ct=l(s),Bs=i(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-171qw1j"&&(Bs.innerHTML=zl),Zt=l(s),h(Qs.$$.fragment,s),vt=l(s),h(U.$$.fragment,s),Gt=l(s),Ws=i(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-13sdzzh"&&(Ws.innerHTML=El),Xt=l(s),h(qs.$$.fragment,s),Rt=l(s),h(zs.$$.fragment,s),Yt=l(s),Es=i(s,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-h56zcg"&&(Es.innerHTML=Hl),Vt=l(s),h(Hs.$$.fragment,s),Nt=l(s),As=i(s,"P",{"data-svelte-h":!0}),r(As)!=="svelte-3r8edy"&&(As.innerHTML=Al),Ft=l(s),h(Ss.$$.fragment,s),Bt=l(s),Ls=i(s,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-1k52pqi"&&(Ls.innerHTML=Sl),Qt=l(s),h(Ds.$$.fragment,s),Wt=l(s),h(Ps.$$.fragment,s),qt=l(s),Ks=i(s,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-kj4je5"&&(Ks.innerHTML=Ll),zt=l(s),h(Os.$$.fragment,s),Et=l(s),sa=i(s,"P",{"data-svelte-h":!0}),r(sa)!=="svelte-1k1qy5p"&&(sa.textContent=Dl),Ht=l(s),aa=i(s,"OL",{"data-svelte-h":!0}),r(aa)!=="svelte-75f7q"&&(aa.innerHTML=Pl),At=l(s),h(ea.$$.fragment,s),St=l(s),ta=i(s,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-1iuqsbr"&&(ta.innerHTML=Kl),Lt=l(s),h(na.$$.fragment,s),Dt=l(s),la=i(s,"P",{"data-svelte-h":!0}),r(la)!=="svelte-cmzler"&&(la.textContent=Ol),Pt=l(s),h(pa.$$.fragment,s),Kt=l(s),h(ia.$$.fragment,s),Ot=l(s),ra=i(s,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-1ptmbmd"&&(ra.innerHTML=sp),sn=l(s),ca=i(s,"P",{"data-svelte-h":!0}),r(ca)!=="svelte-2g3b8l"&&(ca.innerHTML=ap),an=l(s),h(ha.$$.fragment,s),en=l(s),oa=i(s,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-17o5i9a"&&(oa.textContent=ep),tn=l(s),h(ma.$$.fragment,s),nn=l(s),da=i(s,"P",{"data-svelte-h":!0}),r(da)!=="svelte-woc6lj"&&(da.innerHTML=tp),ln=l(s),h(ua.$$.fragment,s),pn=l(s),ja=i(s,"P",{"data-svelte-h":!0}),r(ja)!=="svelte-1ww14wc"&&(ja.innerHTML=np),rn=l(s),h(ga.$$.fragment,s),cn=l(s),fa=i(s,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-esu4th"&&(fa.innerHTML=lp),hn=l(s),h(Ma.$$.fragment,s),on=l(s),h(ya.$$.fragment,s),mn=l(s),ba=i(s,"P",{"data-svelte-h":!0}),r(ba)!=="svelte-1lr2l6d"&&(ba.innerHTML=pp),dn=l(s),wa=i(s,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-1jo5sei"&&(wa.innerHTML=ip),un=l(s),h(Ta.$$.fragment,s),jn=l(s),h(Ja.$$.fragment,s),gn=l(s),Ua=i(s,"P",{"data-svelte-h":!0}),r(Ua)!=="svelte-1grzzpy"&&(Ua.innerHTML=rp),fn=l(s),xa=i(s,"P",{"data-svelte-h":!0}),r(xa)!=="svelte-11s6yeq"&&(xa.innerHTML=cp),Mn=l(s),h($a.$$.fragment,s),yn=l(s),_a=i(s,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-1dww357"&&(_a.innerHTML=hp),bn=l(s),ka=i(s,"UL",{"data-svelte-h":!0}),r(ka)!=="svelte-1ip99b0"&&(ka.innerHTML=op),wn=l(s),Ia=i(s,"P",{"data-svelte-h":!0}),r(Ia)!=="svelte-1c8nm1c"&&(Ia.innerHTML=mp),Tn=l(s),h(Ca.$$.fragment,s),Jn=l(s),Za=i(s,"P",{"data-svelte-h":!0}),r(Za)!=="svelte-o9pm62"&&(Za.innerHTML=dp),Un=l(s),h(va.$$.fragment,s),xn=l(s),Ga=i(s,"P",{"data-svelte-h":!0}),r(Ga)!=="svelte-qilcw"&&(Ga.innerHTML=up),$n=l(s),h(Xa.$$.fragment,s),_n=l(s),h(Ra.$$.fragment,s),kn=l(s),Ya=i(s,"P",{"data-svelte-h":!0}),r(Ya)!=="svelte-1wiqbgf"&&(Ya.innerHTML=jp),In=l(s),Va=i(s,"P",{"data-svelte-h":!0}),r(Va)!=="svelte-1k6sf3c"&&(Va.textContent=gp),Cn=l(s),h(Na.$$.fragment,s),Zn=l(s),Fa=i(s,"P",{"data-svelte-h":!0}),r(Fa)!=="svelte-13euv56"&&(Fa.innerHTML=fp),vn=l(s),h(Ba.$$.fragment,s),Gn=l(s),h(Qa.$$.fragment,s),Xn=l(s),Wa=i(s,"P",{"data-svelte-h":!0}),r(Wa)!=="svelte-12xevsw"&&(Wa.innerHTML=Mp),Rn=l(s),qa=i(s,"P",{"data-svelte-h":!0}),r(qa)!=="svelte-n6dynl"&&(qa.innerHTML=yp),Yn=l(s),h(za.$$.fragment,s),Vn=l(s),Ea=i(s,"P",{"data-svelte-h":!0}),r(Ea)!=="svelte-102a0ut"&&(Ea.innerHTML=bp),Nn=l(s),h(Ha.$$.fragment,s),Fn=l(s),h(x.$$.fragment,s),Bn=l(s),Aa=i(s,"P",{"data-svelte-h":!0}),r(Aa)!=="svelte-qk6rsc"&&(Aa.innerHTML=wp),Qn=l(s),h(Sa.$$.fragment,s),Wn=l(s),h(La.$$.fragment,s),qn=l(s),Da=i(s,"P",{"data-svelte-h":!0}),r(Da)!=="svelte-8l9yor"&&(Da.innerHTML=Tp),zn=l(s),h(Pa.$$.fragment,s),En=l(s),Ka=i(s,"P",{"data-svelte-h":!0}),r(Ka)!=="svelte-jlhh1u"&&(Ka.innerHTML=Jp),Hn=l(s),Oa=i(s,"P",{"data-svelte-h":!0}),r(Oa)!=="svelte-14kj1ho"&&(Oa.innerHTML=Up),An=l(s),h(se.$$.fragment,s),Sn=l(s),h(ae.$$.fragment,s),Ln=l(s),ee=i(s,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-ayd55m"&&(ee.innerHTML=xp),Dn=l(s),te=i(s,"P",{"data-svelte-h":!0}),r(te)!=="svelte-14rfihg"&&(te.textContent=$p),Pn=l(s),h(ne.$$.fragment,s),Kn=l(s),le=i(s,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1hjycb8"&&(le.innerHTML=_p),On=l(s),h(pe.$$.fragment,s),sl=l(s),h($.$$.fragment,s),al=l(s),h(ie.$$.fragment,s),el=l(s),re=i(s,"P",{"data-svelte-h":!0}),r(re)!=="svelte-t9rz5l"&&(re.textContent=kp),tl=l(s),ce=i(s,"TABLE",{"data-svelte-h":!0}),r(ce)!=="svelte-oxt0"&&(ce.innerHTML=Ip),nl=l(s),he=i(s,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1w51t97"&&(he.textContent=Cp),ll=l(s),h(oe.$$.fragment,s),pl=l(s),h(me.$$.fragment,s),il=l(s),de=i(s,"P",{}),Yp(de).forEach(e),this.h()},h(){Vp(j,"name","hf:doc:metadata"),Vp(j,"content",Pp)},m(s,a){qp(document.head,j),t(s,y,a),t(s,f,a),t(s,b,a),o(_,s,a),t(s,ge,a),t(s,k,a),t(s,fe,a),t(s,I,a),t(s,Me,a),t(s,C,a),t(s,ye,a),t(s,Z,a),t(s,be,a),t(s,v,a),t(s,we,a),o(G,s,a),t(s,Te,a),o(T,s,a),t(s,Je,a),o(X,s,a),t(s,Ue,a),t(s,R,a),t(s,xe,a),o(Y,s,a),t(s,$e,a),t(s,V,a),t(s,_e,a),o(N,s,a),t(s,ke,a),t(s,F,a),t(s,Ie,a),o(B,s,a),t(s,Ce,a),t(s,Q,a),t(s,Ze,a),o(W,s,a),t(s,ve,a),t(s,q,a),t(s,Ge,a),o(z,s,a),t(s,Xe,a),o(E,s,a),t(s,Re,a),t(s,H,a),t(s,Ye,a),t(s,A,a),t(s,Ve,a),o(S,s,a),t(s,Ne,a),t(s,L,a),t(s,Fe,a),o(D,s,a),t(s,Be,a),t(s,P,a),t(s,Qe,a),o(K,s,a),t(s,We,a),t(s,O,a),t(s,qe,a),o(ss,s,a),t(s,ze,a),t(s,as,a),t(s,Ee,a),o(es,s,a),t(s,He,a),t(s,ts,a),t(s,Ae,a),o(ns,s,a),t(s,Se,a),t(s,ls,a),t(s,Le,a),t(s,ps,a),t(s,De,a),o(is,s,a),t(s,Pe,a),t(s,rs,a),t(s,Ke,a),o(cs,s,a),t(s,Oe,a),o(hs,s,a),t(s,st,a),t(s,os,a),t(s,at,a),o(ms,s,a),t(s,et,a),t(s,ds,a),t(s,tt,a),t(s,us,a),t(s,nt,a),o(js,s,a),t(s,lt,a),o(gs,s,a),t(s,pt,a),t(s,fs,a),t(s,it,a),o(Ms,s,a),t(s,rt,a),t(s,ys,a),t(s,ct,a),o(bs,s,a),t(s,ht,a),o(ws,s,a),t(s,ot,a),t(s,Ts,a),t(s,mt,a),o(Js,s,a),t(s,dt,a),o(J,s,a),t(s,ut,a),t(s,Us,a),t(s,jt,a),o(xs,s,a),t(s,gt,a),o($s,s,a),t(s,ft,a),t(s,_s,a),t(s,Mt,a),o(ks,s,a),t(s,yt,a),t(s,Is,a),t(s,bt,a),o(Cs,s,a),t(s,wt,a),t(s,Zs,a),t(s,Tt,a),o(vs,s,a),t(s,Jt,a),t(s,Gs,a),t(s,Ut,a),t(s,Xs,a),t(s,xt,a),t(s,Rs,a),t(s,$t,a),o(Ys,s,a),t(s,_t,a),t(s,Vs,a),t(s,kt,a),o(Ns,s,a),t(s,It,a),t(s,Fs,a),t(s,Ct,a),t(s,Bs,a),t(s,Zt,a),o(Qs,s,a),t(s,vt,a),o(U,s,a),t(s,Gt,a),t(s,Ws,a),t(s,Xt,a),o(qs,s,a),t(s,Rt,a),o(zs,s,a),t(s,Yt,a),t(s,Es,a),t(s,Vt,a),o(Hs,s,a),t(s,Nt,a),t(s,As,a),t(s,Ft,a),o(Ss,s,a),t(s,Bt,a),t(s,Ls,a),t(s,Qt,a),o(Ds,s,a),t(s,Wt,a),o(Ps,s,a),t(s,qt,a),t(s,Ks,a),t(s,zt,a),o(Os,s,a),t(s,Et,a),t(s,sa,a),t(s,Ht,a),t(s,aa,a),t(s,At,a),o(ea,s,a),t(s,St,a),t(s,ta,a),t(s,Lt,a),o(na,s,a),t(s,Dt,a),t(s,la,a),t(s,Pt,a),o(pa,s,a),t(s,Kt,a),o(ia,s,a),t(s,Ot,a),t(s,ra,a),t(s,sn,a),t(s,ca,a),t(s,an,a),o(ha,s,a),t(s,en,a),t(s,oa,a),t(s,tn,a),o(ma,s,a),t(s,nn,a),t(s,da,a),t(s,ln,a),o(ua,s,a),t(s,pn,a),t(s,ja,a),t(s,rn,a),o(ga,s,a),t(s,cn,a),t(s,fa,a),t(s,hn,a),o(Ma,s,a),t(s,on,a),o(ya,s,a),t(s,mn,a),t(s,ba,a),t(s,dn,a),t(s,wa,a),t(s,un,a),o(Ta,s,a),t(s,jn,a),o(Ja,s,a),t(s,gn,a),t(s,Ua,a),t(s,fn,a),t(s,xa,a),t(s,Mn,a),o($a,s,a),t(s,yn,a),t(s,_a,a),t(s,bn,a),t(s,ka,a),t(s,wn,a),t(s,Ia,a),t(s,Tn,a),o(Ca,s,a),t(s,Jn,a),t(s,Za,a),t(s,Un,a),o(va,s,a),t(s,xn,a),t(s,Ga,a),t(s,$n,a),o(Xa,s,a),t(s,_n,a),o(Ra,s,a),t(s,kn,a),t(s,Ya,a),t(s,In,a),t(s,Va,a),t(s,Cn,a),o(Na,s,a),t(s,Zn,a),t(s,Fa,a),t(s,vn,a),o(Ba,s,a),t(s,Gn,a),o(Qa,s,a),t(s,Xn,a),t(s,Wa,a),t(s,Rn,a),t(s,qa,a),t(s,Yn,a),o(za,s,a),t(s,Vn,a),t(s,Ea,a),t(s,Nn,a),o(Ha,s,a),t(s,Fn,a),o(x,s,a),t(s,Bn,a),t(s,Aa,a),t(s,Qn,a),o(Sa,s,a),t(s,Wn,a),o(La,s,a),t(s,qn,a),t(s,Da,a),t(s,zn,a),o(Pa,s,a),t(s,En,a),t(s,Ka,a),t(s,Hn,a),t(s,Oa,a),t(s,An,a),o(se,s,a),t(s,Sn,a),o(ae,s,a),t(s,Ln,a),t(s,ee,a),t(s,Dn,a),t(s,te,a),t(s,Pn,a),o(ne,s,a),t(s,Kn,a),t(s,le,a),t(s,On,a),o(pe,s,a),t(s,sl,a),o($,s,a),t(s,al,a),o(ie,s,a),t(s,el,a),t(s,re,a),t(s,tl,a),t(s,ce,a),t(s,nl,a),t(s,he,a),t(s,ll,a),o(oe,s,a),t(s,pl,a),o(me,s,a),t(s,il,a),t(s,de,a),rl=!0},p(s,[a]){const Zp={};a&2&&(Zp.$$scope={dirty:a,ctx:s}),T.$set(Zp);const vp={};a&2&&(vp.$$scope={dirty:a,ctx:s}),J.$set(vp);const Gp={};a&2&&(Gp.$$scope={dirty:a,ctx:s}),U.$set(Gp);const Xp={};a&2&&(Xp.$$scope={dirty:a,ctx:s}),x.$set(Xp);const Rp={};a&2&&(Rp.$$scope={dirty:a,ctx:s}),$.$set(Rp)},i(s){rl||(m(_.$$.fragment,s),m(G.$$.fragment,s),m(T.$$.fragment,s),m(X.$$.fragment,s),m(Y.$$.fragment,s),m(N.$$.fragment,s),m(B.$$.fragment,s),m(W.$$.fragment,s),m(z.$$.fragment,s),m(E.$$.fragment,s),m(S.$$.fragment,s),m(D.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(es.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(cs.$$.fragment,s),m(hs.$$.fragment,s),m(ms.$$.fragment,s),m(js.$$.fragment,s),m(gs.$$.fragment,s),m(Ms.$$.fragment,s),m(bs.$$.fragment,s),m(ws.$$.fragment,s),m(Js.$$.fragment,s),m(J.$$.fragment,s),m(xs.$$.fragment,s),m($s.$$.fragment,s),m(ks.$$.fragment,s),m(Cs.$$.fragment,s),m(vs.$$.fragment,s),m(Ys.$$.fragment,s),m(Ns.$$.fragment,s),m(Qs.$$.fragment,s),m(U.$$.fragment,s),m(qs.$$.fragment,s),m(zs.$$.fragment,s),m(Hs.$$.fragment,s),m(Ss.$$.fragment,s),m(Ds.$$.fragment,s),m(Ps.$$.fragment,s),m(Os.$$.fragment,s),m(ea.$$.fragment,s),m(na.$$.fragment,s),m(pa.$$.fragment,s),m(ia.$$.fragment,s),m(ha.$$.fragment,s),m(ma.$$.fragment,s),m(ua.$$.fragment,s),m(ga.$$.fragment,s),m(Ma.$$.fragment,s),m(ya.$$.fragment,s),m(Ta.$$.fragment,s),m(Ja.$$.fragment,s),m($a.$$.fragment,s),m(Ca.$$.fragment,s),m(va.$$.fragment,s),m(Xa.$$.fragment,s),m(Ra.$$.fragment,s),m(Na.$$.fragment,s),m(Ba.$$.fragment,s),m(Qa.$$.fragment,s),m(za.$$.fragment,s),m(Ha.$$.fragment,s),m(x.$$.fragment,s),m(Sa.$$.fragment,s),m(La.$$.fragment,s),m(Pa.$$.fragment,s),m(se.$$.fragment,s),m(ae.$$.fragment,s),m(ne.$$.fragment,s),m(pe.$$.fragment,s),m($.$$.fragment,s),m(ie.$$.fragment,s),m(oe.$$.fragment,s),m(me.$$.fragment,s),rl=!0)},o(s){d(_.$$.fragment,s),d(G.$$.fragment,s),d(T.$$.fragment,s),d(X.$$.fragment,s),d(Y.$$.fragment,s),d(N.$$.fragment,s),d(B.$$.fragment,s),d(W.$$.fragment,s),d(z.$$.fragment,s),d(E.$$.fragment,s),d(S.$$.fragment,s),d(D.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(is.$$.fragment,s),d(cs.$$.fragment,s),d(hs.$$.fragment,s),d(ms.$$.fragment,s),d(js.$$.fragment,s),d(gs.$$.fragment,s),d(Ms.$$.fragment,s),d(bs.$$.fragment,s),d(ws.$$.fragment,s),d(Js.$$.fragment,s),d(J.$$.fragment,s),d(xs.$$.fragment,s),d($s.$$.fragment,s),d(ks.$$.fragment,s),d(Cs.$$.fragment,s),d(vs.$$.fragment,s),d(Ys.$$.fragment,s),d(Ns.$$.fragment,s),d(Qs.$$.fragment,s),d(U.$$.fragment,s),d(qs.$$.fragment,s),d(zs.$$.fragment,s),d(Hs.$$.fragment,s),d(Ss.$$.fragment,s),d(Ds.$$.fragment,s),d(Ps.$$.fragment,s),d(Os.$$.fragment,s),d(ea.$$.fragment,s),d(na.$$.fragment,s),d(pa.$$.fragment,s),d(ia.$$.fragment,s),d(ha.$$.fragment,s),d(ma.$$.fragment,s),d(ua.$$.fragment,s),d(ga.$$.fragment,s),d(Ma.$$.fragment,s),d(ya.$$.fragment,s),d(Ta.$$.fragment,s),d(Ja.$$.fragment,s),d($a.$$.fragment,s),d(Ca.$$.fragment,s),d(va.$$.fragment,s),d(Xa.$$.fragment,s),d(Ra.$$.fragment,s),d(Na.$$.fragment,s),d(Ba.$$.fragment,s),d(Qa.$$.fragment,s),d(za.$$.fragment,s),d(Ha.$$.fragment,s),d(x.$$.fragment,s),d(Sa.$$.fragment,s),d(La.$$.fragment,s),d(Pa.$$.fragment,s),d(se.$$.fragment,s),d(ae.$$.fragment,s),d(ne.$$.fragment,s),d(pe.$$.fragment,s),d($.$$.fragment,s),d(ie.$$.fragment,s),d(oe.$$.fragment,s),d(me.$$.fragment,s),rl=!1},d(s){s&&(e(y),e(f),e(b),e(ge),e(k),e(fe),e(I),e(Me),e(C),e(ye),e(Z),e(be),e(v),e(we),e(Te),e(Je),e(Ue),e(R),e(xe),e($e),e(V),e(_e),e(ke),e(F),e(Ie),e(Ce),e(Q),e(Ze),e(ve),e(q),e(Ge),e(Xe),e(Re),e(H),e(Ye),e(A),e(Ve),e(Ne),e(L),e(Fe),e(Be),e(P),e(Qe),e(We),e(O),e(qe),e(ze),e(as),e(Ee),e(He),e(ts),e(Ae),e(Se),e(ls),e(Le),e(ps),e(De),e(Pe),e(rs),e(Ke),e(Oe),e(st),e(os),e(at),e(et),e(ds),e(tt),e(us),e(nt),e(lt),e(pt),e(fs),e(it),e(rt),e(ys),e(ct),e(ht),e(ot),e(Ts),e(mt),e(dt),e(ut),e(Us),e(jt),e(gt),e(ft),e(_s),e(Mt),e(yt),e(Is),e(bt),e(wt),e(Zs),e(Tt),e(Jt),e(Gs),e(Ut),e(Xs),e(xt),e(Rs),e($t),e(_t),e(Vs),e(kt),e(It),e(Fs),e(Ct),e(Bs),e(Zt),e(vt),e(Gt),e(Ws),e(Xt),e(Rt),e(Yt),e(Es),e(Vt),e(Nt),e(As),e(Ft),e(Bt),e(Ls),e(Qt),e(Wt),e(qt),e(Ks),e(zt),e(Et),e(sa),e(Ht),e(aa),e(At),e(St),e(ta),e(Lt),e(Dt),e(la),e(Pt),e(Kt),e(Ot),e(ra),e(sn),e(ca),e(an),e(en),e(oa),e(tn),e(nn),e(da),e(ln),e(pn),e(ja),e(rn),e(cn),e(fa),e(hn),e(on),e(mn),e(ba),e(dn),e(wa),e(un),e(jn),e(gn),e(Ua),e(fn),e(xa),e(Mn),e(yn),e(_a),e(bn),e(ka),e(wn),e(Ia),e(Tn),e(Jn),e(Za),e(Un),e(xn),e(Ga),e($n),e(_n),e(kn),e(Ya),e(In),e(Va),e(Cn),e(Zn),e(Fa),e(vn),e(Gn),e(Xn),e(Wa),e(Rn),e(qa),e(Yn),e(Vn),e(Ea),e(Nn),e(Fn),e(Bn),e(Aa),e(Qn),e(Wn),e(qn),e(Da),e(zn),e(En),e(Ka),e(Hn),e(Oa),e(An),e(Sn),e(Ln),e(ee),e(Dn),e(te),e(Pn),e(Kn),e(le),e(On),e(sl),e(al),e(el),e(re),e(tl),e(ce),e(nl),e(he),e(ll),e(pl),e(il),e(de)),e(j),u(_,s),u(G,s),u(T,s),u(X,s),u(Y,s),u(N,s),u(B,s),u(W,s),u(z,s),u(E,s),u(S,s),u(D,s),u(K,s),u(ss,s),u(es,s),u(ns,s),u(is,s),u(cs,s),u(hs,s),u(ms,s),u(js,s),u(gs,s),u(Ms,s),u(bs,s),u(ws,s),u(Js,s),u(J,s),u(xs,s),u($s,s),u(ks,s),u(Cs,s),u(vs,s),u(Ys,s),u(Ns,s),u(Qs,s),u(U,s),u(qs,s),u(zs,s),u(Hs,s),u(Ss,s),u(Ds,s),u(Ps,s),u(Os,s),u(ea,s),u(na,s),u(pa,s),u(ia,s),u(ha,s),u(ma,s),u(ua,s),u(ga,s),u(Ma,s),u(ya,s),u(Ta,s),u(Ja,s),u($a,s),u(Ca,s),u(va,s),u(Xa,s),u(Ra,s),u(Na,s),u(Ba,s),u(Qa,s),u(za,s),u(Ha,s),u(x,s),u(Sa,s),u(La,s),u(Pa,s),u(se,s),u(ae,s),u(ne,s),u(pe,s),u($,s),u(ie,s),u(oe,s),u(me,s)}}}const Pp='{"title":"Process","local":"process","sections":[{"title":"Sort, shuffle, select, split, and shard","local":"sort-shuffle-select-split-and-shard","sections":[{"title":"Sort","local":"sort","sections":[],"depth":3},{"title":"Shuffle","local":"shuffle","sections":[],"depth":3},{"title":"Select and Filter","local":"select-and-filter","sections":[],"depth":3},{"title":"Split","local":"split","sections":[],"depth":3},{"title":"Shard","local":"shard","sections":[],"depth":3}],"depth":2},{"title":"Rename, remove, cast, and flatten","local":"rename-remove-cast-and-flatten","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3},{"title":"Flatten","local":"flatten","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Multiprocessing","local":"multiprocessing","sections":[],"depth":3},{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Split long examples","local":"split-long-examples","sections":[],"depth":4},{"title":"Data augmentation","local":"data-augmentation","sections":[],"depth":4}],"depth":3},{"title":"Process multiple splits","local":"process-multiple-splits","sections":[],"depth":3},{"title":"Distributed usage","local":"distributed-usage","sections":[],"depth":3}],"depth":2},{"title":"Batch","local":"batch","sections":[],"depth":2},{"title":"Concatenate","local":"concatenate","sections":[{"title":"Interleave","local":"interleave","sections":[],"depth":3}],"depth":2},{"title":"Format","local":"format","sections":[{"title":"Format transform","local":"format-transform","sections":[],"depth":3}],"depth":2},{"title":"Save","local":"save","sections":[],"depth":2},{"title":"Export","local":"export","sections":[],"depth":2}],"depth":1}';function Kp(w){return Fp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ni extends Bp{constructor(j){super(),Qp(this,j,Kp,Dp,Np,{})}}export{ni as component};
