import{s as zl,o as ql,n as Fs}from"../chunks/scheduler.d586627e.js";import{S as xl,i as Vl,g as n,s as a,r as d,A as Gl,h as i,f as l,c as o,j as Wl,u as p,x as r,k as Xl,y as El,a as t,v as c,d as M,t as u,w as y}from"../chunks/index.8589a59c.js";import{H as ke,g as Yl}from"../chunks/Heading.73928447.js";import{T as Hs}from"../chunks/Tip.84e2336e.js";import{C as T}from"../chunks/CodeBlock.47c46d2c.js";function Ql(j){let m,w="Se o seu modelo for muito semelhante a um modelo dentro da biblioteca, você poderá reutilizar a mesma configuração desse modelo.";return{c(){m=n("p"),m.textContent=w},l(J){m=i(J,"P",{"data-svelte-h":!0}),r(m)!=="svelte-14dq0cm"&&(m.textContent=w)},m(J,f){t(J,m,f)},p:Fs,d(J){J&&l(m)}}}function Hl(j){let m,w="Esta API é experimental e pode ter algumas pequenas alterações nas próximas versões.";return{c(){m=n("p"),m.textContent=w},l(J){m=i(J,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1s1oyxv"&&(m.textContent=w)},m(J,f){t(J,m,f)},p:Fs,d(J){J&&l(m)}}}function Fl(j){let m,w=`Se estiver copiando arquivos de modelagem da biblioteca, você precisará substituir todas as importações relativas na parte superior do arquivo
para importar do pacote <code>transformers</code>.`;return{c(){m=n("p"),m.innerHTML=w},l(J){m=i(J,"P",{"data-svelte-h":!0}),r(m)!=="svelte-jm95tu"&&(m.innerHTML=w)},m(J,f){t(J,m,f)},p:Fs,d(J){J&&l(m)}}}function Sl(j){let m,w,J,f,I,Be,g,Ss=`A biblioteca 🤗 Transformers foi projetada para ser facilmente extensível. Cada modelo é totalmente codificado em uma determinada subpasta
do repositório sem abstração, para que você possa copiar facilmente um arquivo de modelagem e ajustá-lo às suas necessidades.`,Re,v,Ls=`Se você estiver escrevendo um modelo totalmente novo, pode ser mais fácil começar do zero. Neste tutorial, mostraremos
como escrever um modelo customizado e sua configuração para que possa ser usado com Transformers, e como você pode compartilhá-lo
com a comunidade (com o código em que se baseia) para que qualquer pessoa possa usá-lo, mesmo se não estiver presente na biblioteca 🤗 Transformers.`,We,Z,Ps=`Ilustraremos tudo isso em um modelo ResNet, envolvendo a classe ResNet do
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">biblioteca timm</a> em um <code>PreTrainedModel</code>.`,Xe,_,ze,h,Ds=`Antes de mergulharmos no modelo, vamos primeiro escrever sua configuração. A configuração de um modelo é um objeto que
terá todas as informações necessárias para construir o modelo. Como veremos na próxima seção, o modelo só pode
ter um <code>config</code> para ser inicializado, então realmente precisamos que esse objeto seja o mais completo possível.`,qe,A,Ks=`Em nosso exemplo, pegaremos alguns argumentos da classe ResNet que podemos querer ajustar. Diferentes
configurações nos dará os diferentes tipos de ResNets que são possíveis. Em seguida, apenas armazenamos esses argumentos,
após verificar a validade de alguns deles.`,xe,$,Ve,k,Os="As três coisas importantes a serem lembradas ao escrever sua própria configuração são:",Ge,N,el="<li>você tem que herdar de <code>PretrainedConfig</code>,</li> <li>o <code>__init__</code> do seu <code>PretrainedConfig</code> deve aceitar quaisquer kwargs,</li> <li>esses <code>kwargs</code> precisam ser passados para a superclasse <code>__init__</code>.</li>",Ee,B,sl=`A herança é para garantir que você obtenha todas as funcionalidades da biblioteca 🤗 Transformers, enquanto as outras duas
restrições vêm do fato de um <code>PretrainedConfig</code> ter mais campos do que os que você está configurando. Ao recarregar um
config com o método <code>from_pretrained</code>, esses campos precisam ser aceitos pelo seu config e então enviados para a
superclasse.`,Ye,R,ll=`Definir um <code>model_type</code> para sua configuração (aqui <code>model_type=&quot;resnet&quot;</code>) não é obrigatório, a menos que você queira
registrar seu modelo com as classes automáticas (veja a última seção).`,Qe,W,tl=`Com isso feito, você pode facilmente criar e salvar sua configuração como faria com qualquer outra configuração de modelo da
biblioteca. Aqui está como podemos criar uma configuração resnet50d e salvá-la:`,He,X,Fe,z,al=`Isso salvará um arquivo chamado <code>config.json</code> dentro da pasta <code>custom-resnet</code>. Você pode então recarregar sua configuração com o
método <code>from_pretrained</code>:`,Se,q,Le,x,ol=`Você também pode usar qualquer outro método da classe <code>PretrainedConfig</code>, como <code>push_to_hub()</code> para
carregar diretamente sua configuração para o Hub.`,Pe,V,De,G,nl=`Agora que temos nossa configuração ResNet, podemos continuar escrevendo o modelo. Na verdade, escreveremos dois: um que
extrai os recursos ocultos de um lote de imagens (como <code>BertModel</code>) e um que é adequado para classificação de imagem
(como <code>BertForSequenceClassification</code>).`,Ke,E,il=`Como mencionamos antes, escreveremos apenas um wrapper solto do modelo para mantê-lo simples para este exemplo. A única
coisa que precisamos fazer antes de escrever esta classe é um mapa entre os tipos de bloco e as classes de bloco reais. Então o
modelo é definido a partir da configuração passando tudo para a classe <code>ResNet</code>:`,Oe,Y,es,Q,rl="Para o modelo que irá classificar as imagens, vamos apenas alterar o método forward:",ss,H,ls,F,ml=`Em ambos os casos, observe como herdamos de <code>PreTrainedModel</code> e chamamos a inicialização da superclasse com o <code>config</code>
(um pouco parecido quando você escreve um <code>torch.nn.Module</code>). A linha que define o <code>config_class</code> não é obrigatória, a menos que
você deseje registrar seu modelo com as classes automáticas (consulte a última seção).`,ts,U,as,S,dl=`Você pode fazer com que seu modelo retorne o que você quiser,porém retornando um dicionário como fizemos para
<code>ResnetModelForImageClassification</code>, com a função de perda incluída quando os rótulos são passados, vai tornar seu modelo diretamente
utilizável dentro da classe <code>Trainer</code>. Você pode usar outro formato de saída, desde que esteja planejando usar seu próprio
laço de treinamento ou outra biblioteca para treinamento.`,os,L,pl="Agora que temos nossa classe do modelo, vamos criar uma:",ns,P,is,D,cl=`Novamente, você pode usar qualquer um dos métodos do <code>PreTrainedModel</code>, como <code>save_pretrained()</code> ou
<code>push_to_hub()</code>. Usaremos o segundo na próxima seção e veremos como enviar os pesos e
o código do nosso modelo. Mas primeiro, vamos carregar alguns pesos pré-treinados dentro do nosso modelo.`,rs,K,Ml=`Em seu próprio caso de uso, você provavelmente estará treinando seu modelo customizado em seus próprios dados. Para este tutorial ser rápido,
usaremos a versão pré-treinada do resnet50d. Como nosso modelo é apenas um wrapper em torno dele, será
fácil de transferir esses pesos:`,ms,O,ds,ee,ul=`Agora vamos ver como ter certeza de que quando fazemos <code>save_pretrained()</code> ou <code>push_to_hub()</code>, o
código do modelo é salvo.`,ps,se,cs,b,Ms,le,yl=`Primeiro, certifique-se de que seu modelo esteja totalmente definido em um arquivo <code>.py</code>. Ele pode contar com importações relativas para alguns outros arquivos
desde que todos os arquivos estejam no mesmo diretório (ainda não suportamos submódulos para este recurso). Para o nosso exemplo,
vamos definir um arquivo <code>modeling_resnet.py</code> e um arquivo <code>configuration_resnet.py</code> em uma pasta no
diretório de trabalho atual chamado <code>resnet_model</code>. O arquivo de configuração contém o código para <code>ResnetConfig</code> e o arquivo de modelagem
contém o código do <code>ResnetModel</code> e <code>ResnetModelForImageClassification</code>.`,us,te,ys,ae,Jl="O <code>__init__.py</code> pode estar vazio, apenas está lá para que o Python detecte que o <code>resnet_model</code> possa ser usado como um módulo.",Js,C,Ts,oe,Tl="Observe que você pode reutilizar (ou subclasse) uma configuração/modelo existente.",ws,ne,wl=`Para compartilhar seu modelo com a comunidade, siga estas etapas: primeiro importe o modelo ResNet e a configuração do
arquivos criados:`,fs,ie,js,re,fl=`Então você tem que dizer à biblioteca que deseja copiar os arquivos de código desses objetos ao usar o <code>save_pretrained</code>
e registrá-los corretamente com uma determinada classe automáticas (especialmente para modelos), basta executar:`,Us,me,bs,de,jl=`Observe que não há necessidade de especificar uma classe automática para a configuração (há apenas uma classe automática,
<code>AutoConfig</code>), mas é diferente para os modelos. Seu modelo customizado pode ser adequado para muitas tarefas diferentes, então você
tem que especificar qual das classes automáticas é a correta para o seu modelo.`,Cs,pe,Ul="Em seguida, vamos criar a configuração e os modelos como fizemos antes:",Is,ce,gs,Me,bl="Agora para enviar o modelo para o Hub, certifique-se de estar logado. Ou execute no seu terminal:",vs,ue,Zs,ye,Cl="ou a partir do notebook:",_s,Je,hs,Te,Il="Você pode então enviar para seu próprio namespace (ou uma organização da qual você é membro) assim:",As,we,$s,fe,gl=`Além dos pesos do modelo e da configuração no formato json, isso também copiou o modelo e
configuração <code>.py</code> na pasta <code>custom-resnet50d</code> e carregou o resultado para o Hub. Você pode conferir o resultado
neste <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">repositório de modelos</a>.`,ks,je,vl='Consulte o <a href="model_sharing">tutorial de compartilhamento</a> para obter mais informações sobre o método push_to_hub.',Ns,Ue,Bs,be,Zl=`Você pode usar qualquer configuração, modelo ou tokenizador com arquivos de código customizados em seu repositório com as classes automáticas e
o método <code>from_pretrained</code>. Todos os arquivos e códigos carregados no Hub são verificados quanto a malware (consulte a documentação de <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Segurança do Hub</a> para obter mais informações), mas você ainda deve
revisar o código do modelo e o autor para evitar a execução de código malicioso em sua máquina. Defina <code>trust_remote_code=True</code> para usar
um modelo com código customizado:`,Rs,Ce,Ws,Ie,_l=`Também é fortemente recomendado passar um hash de confirmação como uma <code>revisão</code> para garantir que o autor dos modelos não
atualize o código com novas linhas maliciosas (a menos que você confie totalmente nos autores dos modelos).`,Xs,ge,zs,ve,hl=`Observe que ao navegar no histórico de commits do repositório do modelo no Hub, há um botão para copiar facilmente o commit
hash de qualquer commit.`,qs,Ze,xs,_e,Al=`Se você estiver escrevendo uma biblioteca que estende 🤗 Transformers, talvez queira estender as classes automáticas para incluir seus próprios
modelos. Isso é diferente de enviar o código para o Hub no sentido de que os usuários precisarão importar sua biblioteca para
obter os modelos customizados (ao contrário de baixar automaticamente o código do modelo do Hub).`,Vs,he,$l=`Desde que sua configuração tenha um atributo <code>model_type</code> diferente dos tipos de modelo existentes e que as classes do seu modelo
tenha os atributos <code>config_class</code> corretos, você pode simplesmente adicioná-los às classes automáticas assim:`,Gs,Ae,Es,$e,kl=`Observe que o primeiro argumento usado ao registrar sua configuração customizada para <code>AutoConfig</code> precisa corresponder ao <code>model_type</code>
de sua configuração customizada. E o primeiro argumento usado ao registrar seus modelos customizados, para qualquer necessidade de classe de modelo automático
deve corresponder ao <code>config_class</code> desses modelos.`,Ys,Ne,Qs;return I=new ke({props:{title:"Compartilhando modelos customizados",local:"compartilhando-modelos-customizados",headingTag:"h1"}}),_=new ke({props:{title:"Escrevendo uma configuração customizada",local:"escrevendo-uma-configuração-customizada",headingTag:"h2"}}),$=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),q=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),V=new ke({props:{title:"Escrevendo um modelo customizado",local:"escrevendo-um-modelo-customizado",headingTag:"h2"}}),Y=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),H=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),U=new Hs({props:{$$slots:{default:[Ql]},$$scope:{ctx:j}}}),P=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),se=new ke({props:{title:"Enviando o código para o Hub",local:"enviando-o-código-para-o-hub",headingTag:"h2"}}),b=new Hs({props:{warning:!0,$$slots:{default:[Hl]},$$scope:{ctx:j}}}),te=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),C=new Hs({props:{warning:!0,$$slots:{default:[Fl]},$$scope:{ctx:j}}}),ie=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),me=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),ce=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Je=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),we=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Ue=new ke({props:{title:"Usando um modelo com código customizado",local:"usando-um-modelo-com-código-customizado",headingTag:"h2"}}),Ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ze=new ke({props:{title:"Registrando um modelo com código customizado para as classes automáticas",local:"registrando-um-modelo-com-código-customizado-para-as-classes-automáticas",headingTag:"h2"}}),Ae=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){m=n("meta"),w=a(),J=n("p"),f=a(),d(I.$$.fragment),Be=a(),g=n("p"),g.textContent=Ss,Re=a(),v=n("p"),v.textContent=Ls,We=a(),Z=n("p"),Z.innerHTML=Ps,Xe=a(),d(_.$$.fragment),ze=a(),h=n("p"),h.innerHTML=Ds,qe=a(),A=n("p"),A.textContent=Ks,xe=a(),d($.$$.fragment),Ve=a(),k=n("p"),k.textContent=Os,Ge=a(),N=n("ul"),N.innerHTML=el,Ee=a(),B=n("p"),B.innerHTML=sl,Ye=a(),R=n("p"),R.innerHTML=ll,Qe=a(),W=n("p"),W.textContent=tl,He=a(),d(X.$$.fragment),Fe=a(),z=n("p"),z.innerHTML=al,Se=a(),d(q.$$.fragment),Le=a(),x=n("p"),x.innerHTML=ol,Pe=a(),d(V.$$.fragment),De=a(),G=n("p"),G.innerHTML=nl,Ke=a(),E=n("p"),E.innerHTML=il,Oe=a(),d(Y.$$.fragment),es=a(),Q=n("p"),Q.textContent=rl,ss=a(),d(H.$$.fragment),ls=a(),F=n("p"),F.innerHTML=ml,ts=a(),d(U.$$.fragment),as=a(),S=n("p"),S.innerHTML=dl,os=a(),L=n("p"),L.textContent=pl,ns=a(),d(P.$$.fragment),is=a(),D=n("p"),D.innerHTML=cl,rs=a(),K=n("p"),K.textContent=Ml,ms=a(),d(O.$$.fragment),ds=a(),ee=n("p"),ee.innerHTML=ul,ps=a(),d(se.$$.fragment),cs=a(),d(b.$$.fragment),Ms=a(),le=n("p"),le.innerHTML=yl,us=a(),d(te.$$.fragment),ys=a(),ae=n("p"),ae.innerHTML=Jl,Js=a(),d(C.$$.fragment),Ts=a(),oe=n("p"),oe.textContent=Tl,ws=a(),ne=n("p"),ne.textContent=wl,fs=a(),d(ie.$$.fragment),js=a(),re=n("p"),re.innerHTML=fl,Us=a(),d(me.$$.fragment),bs=a(),de=n("p"),de.innerHTML=jl,Cs=a(),pe=n("p"),pe.textContent=Ul,Is=a(),d(ce.$$.fragment),gs=a(),Me=n("p"),Me.textContent=bl,vs=a(),d(ue.$$.fragment),Zs=a(),ye=n("p"),ye.textContent=Cl,_s=a(),d(Je.$$.fragment),hs=a(),Te=n("p"),Te.textContent=Il,As=a(),d(we.$$.fragment),$s=a(),fe=n("p"),fe.innerHTML=gl,ks=a(),je=n("p"),je.innerHTML=vl,Ns=a(),d(Ue.$$.fragment),Bs=a(),be=n("p"),be.innerHTML=Zl,Rs=a(),d(Ce.$$.fragment),Ws=a(),Ie=n("p"),Ie.innerHTML=_l,Xs=a(),d(ge.$$.fragment),zs=a(),ve=n("p"),ve.textContent=hl,qs=a(),d(Ze.$$.fragment),xs=a(),_e=n("p"),_e.textContent=Al,Vs=a(),he=n("p"),he.innerHTML=$l,Gs=a(),d(Ae.$$.fragment),Es=a(),$e=n("p"),$e.innerHTML=kl,Ys=a(),Ne=n("p"),this.h()},l(e){const s=Gl("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(l),w=o(e),J=i(e,"P",{}),Wl(J).forEach(l),f=o(e),p(I.$$.fragment,e),Be=o(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-odiyj7"&&(g.textContent=Ss),Re=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1o4wy9k"&&(v.textContent=Ls),We=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-tgk9jt"&&(Z.innerHTML=Ps),Xe=o(e),p(_.$$.fragment,e),ze=o(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-n7s4gj"&&(h.innerHTML=Ds),qe=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1u9z9q5"&&(A.textContent=Ks),xe=o(e),p($.$$.fragment,e),Ve=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-195qvkc"&&(k.textContent=Os),Ge=o(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-150dyji"&&(N.innerHTML=el),Ee=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-n05z3r"&&(B.innerHTML=sl),Ye=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-n89pvb"&&(R.innerHTML=ll),Qe=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1kfbx3q"&&(W.textContent=tl),He=o(e),p(X.$$.fragment,e),Fe=o(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1fiw1ms"&&(z.innerHTML=al),Se=o(e),p(q.$$.fragment,e),Le=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1xlg64w"&&(x.innerHTML=ol),Pe=o(e),p(V.$$.fragment,e),De=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1y2nbkn"&&(G.innerHTML=nl),Ke=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-cr4a22"&&(E.innerHTML=il),Oe=o(e),p(Y.$$.fragment,e),es=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-10i1rll"&&(Q.textContent=rl),ss=o(e),p(H.$$.fragment,e),ls=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1harvsn"&&(F.innerHTML=ml),ts=o(e),p(U.$$.fragment,e),as=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-z9klot"&&(S.innerHTML=dl),os=o(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-9hgxrt"&&(L.textContent=pl),ns=o(e),p(P.$$.fragment,e),is=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1jg8tw5"&&(D.innerHTML=cl),rs=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-hmddx9"&&(K.textContent=Ml),ms=o(e),p(O.$$.fragment,e),ds=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1665ct6"&&(ee.innerHTML=ul),ps=o(e),p(se.$$.fragment,e),cs=o(e),p(b.$$.fragment,e),Ms=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-el90vp"&&(le.innerHTML=yl),us=o(e),p(te.$$.fragment,e),ys=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-zqclvb"&&(ae.innerHTML=Jl),Js=o(e),p(C.$$.fragment,e),Ts=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-m6y568"&&(oe.textContent=Tl),ws=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-qtwbi0"&&(ne.textContent=wl),fs=o(e),p(ie.$$.fragment,e),js=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ox5gse"&&(re.innerHTML=fl),Us=o(e),p(me.$$.fragment,e),bs=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-ymh6m7"&&(de.innerHTML=jl),Cs=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1383i6p"&&(pe.textContent=Ul),Is=o(e),p(ce.$$.fragment,e),gs=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-j2swg9"&&(Me.textContent=bl),vs=o(e),p(ue.$$.fragment,e),Zs=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-19mmy5v"&&(ye.textContent=Cl),_s=o(e),p(Je.$$.fragment,e),hs=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-i7vys3"&&(Te.textContent=Il),As=o(e),p(we.$$.fragment,e),$s=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-o997h4"&&(fe.innerHTML=gl),ks=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1z72sv"&&(je.innerHTML=vl),Ns=o(e),p(Ue.$$.fragment,e),Bs=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-qgau1t"&&(be.innerHTML=Zl),Rs=o(e),p(Ce.$$.fragment,e),Ws=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-wb5hdk"&&(Ie.innerHTML=_l),Xs=o(e),p(ge.$$.fragment,e),zs=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-a3oim0"&&(ve.textContent=hl),qs=o(e),p(Ze.$$.fragment,e),xs=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1w5mftt"&&(_e.textContent=Al),Vs=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-43b6sj"&&(he.innerHTML=$l),Gs=o(e),p(Ae.$$.fragment,e),Es=o(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-quvwuu"&&($e.innerHTML=kl),Ys=o(e),Ne=i(e,"P",{}),Wl(Ne).forEach(l),this.h()},h(){Xl(m,"name","hf:doc:metadata"),Xl(m,"content",Ll)},m(e,s){El(document.head,m),t(e,w,s),t(e,J,s),t(e,f,s),c(I,e,s),t(e,Be,s),t(e,g,s),t(e,Re,s),t(e,v,s),t(e,We,s),t(e,Z,s),t(e,Xe,s),c(_,e,s),t(e,ze,s),t(e,h,s),t(e,qe,s),t(e,A,s),t(e,xe,s),c($,e,s),t(e,Ve,s),t(e,k,s),t(e,Ge,s),t(e,N,s),t(e,Ee,s),t(e,B,s),t(e,Ye,s),t(e,R,s),t(e,Qe,s),t(e,W,s),t(e,He,s),c(X,e,s),t(e,Fe,s),t(e,z,s),t(e,Se,s),c(q,e,s),t(e,Le,s),t(e,x,s),t(e,Pe,s),c(V,e,s),t(e,De,s),t(e,G,s),t(e,Ke,s),t(e,E,s),t(e,Oe,s),c(Y,e,s),t(e,es,s),t(e,Q,s),t(e,ss,s),c(H,e,s),t(e,ls,s),t(e,F,s),t(e,ts,s),c(U,e,s),t(e,as,s),t(e,S,s),t(e,os,s),t(e,L,s),t(e,ns,s),c(P,e,s),t(e,is,s),t(e,D,s),t(e,rs,s),t(e,K,s),t(e,ms,s),c(O,e,s),t(e,ds,s),t(e,ee,s),t(e,ps,s),c(se,e,s),t(e,cs,s),c(b,e,s),t(e,Ms,s),t(e,le,s),t(e,us,s),c(te,e,s),t(e,ys,s),t(e,ae,s),t(e,Js,s),c(C,e,s),t(e,Ts,s),t(e,oe,s),t(e,ws,s),t(e,ne,s),t(e,fs,s),c(ie,e,s),t(e,js,s),t(e,re,s),t(e,Us,s),c(me,e,s),t(e,bs,s),t(e,de,s),t(e,Cs,s),t(e,pe,s),t(e,Is,s),c(ce,e,s),t(e,gs,s),t(e,Me,s),t(e,vs,s),c(ue,e,s),t(e,Zs,s),t(e,ye,s),t(e,_s,s),c(Je,e,s),t(e,hs,s),t(e,Te,s),t(e,As,s),c(we,e,s),t(e,$s,s),t(e,fe,s),t(e,ks,s),t(e,je,s),t(e,Ns,s),c(Ue,e,s),t(e,Bs,s),t(e,be,s),t(e,Rs,s),c(Ce,e,s),t(e,Ws,s),t(e,Ie,s),t(e,Xs,s),c(ge,e,s),t(e,zs,s),t(e,ve,s),t(e,qs,s),c(Ze,e,s),t(e,xs,s),t(e,_e,s),t(e,Vs,s),t(e,he,s),t(e,Gs,s),c(Ae,e,s),t(e,Es,s),t(e,$e,s),t(e,Ys,s),t(e,Ne,s),Qs=!0},p(e,[s]){const Nl={};s&2&&(Nl.$$scope={dirty:s,ctx:e}),U.$set(Nl);const Bl={};s&2&&(Bl.$$scope={dirty:s,ctx:e}),b.$set(Bl);const Rl={};s&2&&(Rl.$$scope={dirty:s,ctx:e}),C.$set(Rl)},i(e){Qs||(M(I.$$.fragment,e),M(_.$$.fragment,e),M($.$$.fragment,e),M(X.$$.fragment,e),M(q.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(U.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(se.$$.fragment,e),M(b.$$.fragment,e),M(te.$$.fragment,e),M(C.$$.fragment,e),M(ie.$$.fragment,e),M(me.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(Ce.$$.fragment,e),M(ge.$$.fragment,e),M(Ze.$$.fragment,e),M(Ae.$$.fragment,e),Qs=!0)},o(e){u(I.$$.fragment,e),u(_.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(q.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(U.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(b.$$.fragment,e),u(te.$$.fragment,e),u(C.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(ge.$$.fragment,e),u(Ze.$$.fragment,e),u(Ae.$$.fragment,e),Qs=!1},d(e){e&&(l(w),l(J),l(f),l(Be),l(g),l(Re),l(v),l(We),l(Z),l(Xe),l(ze),l(h),l(qe),l(A),l(xe),l(Ve),l(k),l(Ge),l(N),l(Ee),l(B),l(Ye),l(R),l(Qe),l(W),l(He),l(Fe),l(z),l(Se),l(Le),l(x),l(Pe),l(De),l(G),l(Ke),l(E),l(Oe),l(es),l(Q),l(ss),l(ls),l(F),l(ts),l(as),l(S),l(os),l(L),l(ns),l(is),l(D),l(rs),l(K),l(ms),l(ds),l(ee),l(ps),l(cs),l(Ms),l(le),l(us),l(ys),l(ae),l(Js),l(Ts),l(oe),l(ws),l(ne),l(fs),l(js),l(re),l(Us),l(bs),l(de),l(Cs),l(pe),l(Is),l(gs),l(Me),l(vs),l(Zs),l(ye),l(_s),l(hs),l(Te),l(As),l($s),l(fe),l(ks),l(je),l(Ns),l(Bs),l(be),l(Rs),l(Ws),l(Ie),l(Xs),l(zs),l(ve),l(qs),l(xs),l(_e),l(Vs),l(he),l(Gs),l(Es),l($e),l(Ys),l(Ne)),l(m),y(I,e),y(_,e),y($,e),y(X,e),y(q,e),y(V,e),y(Y,e),y(H,e),y(U,e),y(P,e),y(O,e),y(se,e),y(b,e),y(te,e),y(C,e),y(ie,e),y(me,e),y(ce,e),y(ue,e),y(Je,e),y(we,e),y(Ue,e),y(Ce,e),y(ge,e),y(Ze,e),y(Ae,e)}}}const Ll='{"title":"Compartilhando modelos customizados","local":"compartilhando-modelos-customizados","sections":[{"title":"Escrevendo uma configuração customizada","local":"escrevendo-uma-configuração-customizada","sections":[],"depth":2},{"title":"Escrevendo um modelo customizado","local":"escrevendo-um-modelo-customizado","sections":[],"depth":2},{"title":"Enviando o código para o Hub","local":"enviando-o-código-para-o-hub","sections":[],"depth":2},{"title":"Usando um modelo com código customizado","local":"usando-um-modelo-com-código-customizado","sections":[],"depth":2},{"title":"Registrando um modelo com código customizado para as classes automáticas","local":"registrando-um-modelo-com-código-customizado-para-as-classes-automáticas","sections":[],"depth":2}],"depth":1}';function Pl(j){return ql(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Yl}),[]}class lt extends xl{constructor(m){super(),Vl(this,m,Pl,Sl,zl,{})}}export{lt as component};
