import{s as At,o as Yt,n as qt}from"../chunks/scheduler.56730f09.js";import{S as zt,i as Nt,g as p,s as a,r as o,A as Et,h as i,f as e,c as n,j as Pt,u as c,x as r,k as Qt,y as Kt,a as l,v as d,d as f,t as h,w as y}from"../chunks/index.1f144517.js";import{T as Dt}from"../chunks/Tip.41e845e5.js";import{C as w}from"../chunks/CodeBlock.738eeccb.js";import{H as Ut}from"../chunks/Heading.57d46534.js";function Ot(N){let m,$="무작위로 생성된 모델은 “비어 있는” (즉 그때 메모리에 있던 것으로 이뤄진) 텐서로 초기화되며 메모리 공간을 차지합니다. 초기화된 모델/파라미터의 종류에 적합한 분포(예: 정규 분포)에 따른 무작위 초기화는 가능한 한 빠르게 하기 위해 초기화되지 않은 가중치에 대해 3단계 이후에만 수행됩니다!";return{c(){m=p("p"),m.textContent=$},l(M){m=i(M,"P",{"data-svelte-h":!0}),r(m)!=="svelte-5v0cyc"&&(m.textContent=$)},m(M,q){l(M,m,q)},p:qt,d(M){M&&e(m)}}}function ts(N){let m,$,M,q,_,E,g,Ct="매우 큰 사전훈련된 모델을 사용하려면, RAM 사용을 최소화해야 하는 과제가 있습니다. 일반적인 PyTorch 워크플로우는 다음과 같습니다:",K,x,Tt="<li>무작위 가중치로 모델을 생성합니다.</li> <li>사전훈련된 가중치를 불러옵니다.</li> <li>사전훈련된 가중치를 무작위 모델에 적용합니다.</li>",D,b,vt="1단계와 2단계 모두 모델의 전체 버전을 메모리에 적재해야 하며, 대부분 문제가 없지만 모델이 기가바이트급의 용량을 차지하기 시작하면 복사본 2개가 RAM을 초과하여 메모리 부족 이슈를 야기할 수 있습니다. 더 심각한 문제는 분산 학습을 위해 <code>torch.distributed</code>를 사용하는 경우, 프로세스마다 사전훈련된 모델을 로드하고 복사본을 2개씩 RAM에 저장한다는 것입니다.",O,j,tt,u,kt="이 안내서에서는 Transformers가 이 문제를 해결하기 위해 제공하는 솔루션을 살펴봅니다. 주의할 점은 아직 활발히 개발 중인 분야이므로 여기서 설명하는 API가 앞으로 약간 변경될 수 있다는 것입니다.",st,U,et,C,Jt="4.18.0 버전 이후, 10GB 이상의 공간을 차지하는 모델 체크포인트는 자동으로 작은 조각들로 샤딩됩니다. <code>model.save_pretrained(save_dir)</code>를 실행할 때 하나의 단일 체크포인트를 가지게 될 대신, 여러 부분 체크포인트(각각의 크기는 10GB 미만)와 매개변수 이름을 해당 파일에 매핑하는 인덱스가 생성됩니다.",lt,T,Zt="<code>max_shard_size</code> 매개변수로 샤딩 전 최대 크기를 제어할 수 있으므로, 이 예제를 위해 샤드 크기가 작은 일반 크기의 모델을 사용하겠습니다: 전통적인 BERT 모델을 사용해 봅시다.",at,v,nt,k,Bt="<code>save_pretrained()</code>을 사용하여 모델을 저장하면, 모델의 구성과 가중치가 들어있는 두 개의 파일이 있는 새 폴더가 생성됩니다:",pt,J,it,Z,Rt="이제 최대 샤드 크기를 200MB로 사용해 봅시다:",mt,B,rt,R,Gt="모델의 구성에 더해, 세 개의 다른 가중치 파일과 파라미터 이름과 해당 파일의 매핑이 포함된 <code>index.json</code> 파일을 볼 수 있습니다. 이러한 체크포인트는 <code>from_pretrained()</code> 메서드를 사용하여 완전히 다시 로드할 수 있습니다:",ot,G,ct,X,Xt="큰 모델의 경우 이러한 방식으로 처리하는 주된 장점은 위에서 보여준 흐름의 2단계에서, 각 샤드가 이전 샤드 다음에 로드되므로 메모리 사용량이 모델 크기와 가장 큰 샤드의 크기를 초과하지 않는다는 점입니다.",dt,I,It="이 인덱스 파일은 키가 체크포인트에 있는지, 그리고 해당 가중치가 어디에 저장되어 있는지를 결정하는 데 사용됩니다. 이 인덱스를 json과 같이 로드하고 딕셔너리를 얻을 수 있습니다:",ft,H,ht,W,Ht="메타데이터는 현재 모델의 총 크기만 포함됩니다. 앞으로 다른 정보를 추가할 계획입니다:",yt,S,Mt,L,Wt="가중치 맵은 이 인덱스의 주요 부분으로, 각 매개변수 이름(PyTorch 모델 <code>state_dict</code>에서 보통 찾을 수 있는)을 해당 파일에 매핑합니다:",jt,V,wt,F,St="만약 <code>from_pretrained()</code>를 사용하지 않고 모델 내에서 이러한 샤딩된 체크포인트를 직접 가져오려면 (전체 체크포인트를 위해 <code>model.load_state_dict()</code>를 수행하는 것처럼), <code>load_sharded_checkpoint()</code>를 사용해야 합니다.",$t,P,_t,Q,gt,A,Lt="샤딩된 체크포인트는 위에서 언급한 작업 흐름의 2단계에서 메모리 사용량을 줄이지만, 저(低)메모리 설정에서 모델을 사용하기 위해 우리의 Accelerate 라이브러리를 기반으로 한 도구를 활용하는 것이 좋습니다.",xt,Y,Vt='자세한 사항은 다음 가이드를 참조해주세요: <a href="../en/main_classes/model#large-model-loading">Accelerate로 대규모 모델 가져오기 (영문)</a>',bt,z,ut;return _=new Ut({props:{title:"큰 모델 인스턴스화",local:"instantiating-a-big-model",headingTag:"h1"}}),j=new Dt({props:{$$slots:{default:[Ot]},$$scope:{ctx:N}}}),U=new Ut({props:{title:"샤딩된 체크포인트",local:"sharded-checkpoints",headingTag:"h2"}}),v=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)`,wrap:!1}}),J=new w({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQXdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wX2RpciUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCh0bXBfZGlyKSUwQSUyMCUyMCUyMCUyMHByaW50KHNvcnRlZChvcy5saXN0ZGlyKHRtcF9kaXIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tempfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">sorted</span>(os.listdir(tmp_dir)))
[<span class="hljs-string">&#x27;config.json&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>]`,wrap:!1}}),B=new w({props:{code:"d2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KHNvcnRlZChvcy5saXN0ZGlyKHRtcF9kaXIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">sorted</span>(os.listdir(tmp_dir)))
[<span class="hljs-string">&#x27;config.json&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00002-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00003-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model.bin.index.json&#x27;</span>]`,wrap:!1}}),G=new w({props:{code:"d2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMG5ld19tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQodG1wX2Rpcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    new_model = AutoModel.from_pretrained(tmp_dir)`,wrap:!1}}),H=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wX2RpciUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCh0bXBfZGlyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIyMDBNQiUyMiklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihvcy5wYXRoLmpvaW4odG1wX2RpciUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluLmluZGV4Lmpzb24lMjIpJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleCUyMCUzRCUyMGpzb24ubG9hZChmKSUwQSUwQXByaW50KGluZGV4LmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(os.path.join(tmp_dir, <span class="hljs-string">&quot;pytorch_model.bin.index.json&quot;</span>), <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        index = json.load(f)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(index.keys())
dict_keys([<span class="hljs-string">&#x27;metadata&#x27;</span>, <span class="hljs-string">&#x27;weight_map&#x27;</span>])`,wrap:!1}}),S=new w({props:{code:"aW5kZXglNUIlMjJtZXRhZGF0YSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>index[<span class="hljs-string">&quot;metadata&quot;</span>]
{<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">433245184</span>}`,wrap:!1}}),V=new w({props:{code:"aW5kZXglNUIlMjJ3ZWlnaHRfbWFwJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>index[<span class="hljs-string">&quot;weight_map&quot;</span>]
{<span class="hljs-string">&#x27;embeddings.LayerNorm.bias&#x27;</span>: <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>,
 <span class="hljs-string">&#x27;embeddings.LayerNorm.weight&#x27;</span>: <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>,
 ...`,wrap:!1}}),P=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ191dGlscyUyMGltcG9ydCUyMGxvYWRfc2hhcmRlZF9jaGVja3BvaW50JTBBJTBBd2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMGxvYWRfc2hhcmRlZF9jaGVja3BvaW50KG1vZGVsJTJDJTIwdG1wX2Rpcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.modeling_utils <span class="hljs-keyword">import</span> load_sharded_checkpoint

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    load_sharded_checkpoint(model, tmp_dir)`,wrap:!1}}),Q=new Ut({props:{title:"저(低)메모리 로딩",local:"low-memory-loading",headingTag:"h2"}}),{c(){m=p("meta"),$=a(),M=p("p"),q=a(),o(_.$$.fragment),E=a(),g=p("p"),g.textContent=Ct,K=a(),x=p("ol"),x.innerHTML=Tt,D=a(),b=p("p"),b.innerHTML=vt,O=a(),o(j.$$.fragment),tt=a(),u=p("p"),u.textContent=kt,st=a(),o(U.$$.fragment),et=a(),C=p("p"),C.innerHTML=Jt,lt=a(),T=p("p"),T.innerHTML=Zt,at=a(),o(v.$$.fragment),nt=a(),k=p("p"),k.innerHTML=Bt,pt=a(),o(J.$$.fragment),it=a(),Z=p("p"),Z.textContent=Rt,mt=a(),o(B.$$.fragment),rt=a(),R=p("p"),R.innerHTML=Gt,ot=a(),o(G.$$.fragment),ct=a(),X=p("p"),X.textContent=Xt,dt=a(),I=p("p"),I.textContent=It,ft=a(),o(H.$$.fragment),ht=a(),W=p("p"),W.textContent=Ht,yt=a(),o(S.$$.fragment),Mt=a(),L=p("p"),L.innerHTML=Wt,jt=a(),o(V.$$.fragment),wt=a(),F=p("p"),F.innerHTML=St,$t=a(),o(P.$$.fragment),_t=a(),o(Q.$$.fragment),gt=a(),A=p("p"),A.textContent=Lt,xt=a(),Y=p("p"),Y.innerHTML=Vt,bt=a(),z=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(e),$=n(t),M=i(t,"P",{}),Pt(M).forEach(e),q=n(t),c(_.$$.fragment,t),E=n(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-bgpi4t"&&(g.textContent=Ct),K=n(t),x=i(t,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-od014n"&&(x.innerHTML=Tt),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-uxi99l"&&(b.innerHTML=vt),O=n(t),c(j.$$.fragment,t),tt=n(t),u=i(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1xr3byf"&&(u.textContent=kt),st=n(t),c(U.$$.fragment,t),et=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-hfrx14"&&(C.innerHTML=Jt),lt=n(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-tmoic1"&&(T.innerHTML=Zt),at=n(t),c(v.$$.fragment,t),nt=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1akqon3"&&(k.innerHTML=Bt),pt=n(t),c(J.$$.fragment,t),it=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-148f27j"&&(Z.textContent=Rt),mt=n(t),c(B.$$.fragment,t),rt=n(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1fn1hkf"&&(R.innerHTML=Gt),ot=n(t),c(G.$$.fragment,t),ct=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-dbx6i5"&&(X.textContent=Xt),dt=n(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1s70s7e"&&(I.textContent=It),ft=n(t),c(H.$$.fragment,t),ht=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-3pru07"&&(W.textContent=Ht),yt=n(t),c(S.$$.fragment,t),Mt=n(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-fyu3ex"&&(L.innerHTML=Wt),jt=n(t),c(V.$$.fragment,t),wt=n(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1gt3bpq"&&(F.innerHTML=St),$t=n(t),c(P.$$.fragment,t),_t=n(t),c(Q.$$.fragment,t),gt=n(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1w5jvsg"&&(A.textContent=Lt),xt=n(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1u81xgf"&&(Y.innerHTML=Vt),bt=n(t),z=i(t,"P",{}),Pt(z).forEach(e),this.h()},h(){Qt(m,"name","hf:doc:metadata"),Qt(m,"content",ss)},m(t,s){Kt(document.head,m),l(t,$,s),l(t,M,s),l(t,q,s),d(_,t,s),l(t,E,s),l(t,g,s),l(t,K,s),l(t,x,s),l(t,D,s),l(t,b,s),l(t,O,s),d(j,t,s),l(t,tt,s),l(t,u,s),l(t,st,s),d(U,t,s),l(t,et,s),l(t,C,s),l(t,lt,s),l(t,T,s),l(t,at,s),d(v,t,s),l(t,nt,s),l(t,k,s),l(t,pt,s),d(J,t,s),l(t,it,s),l(t,Z,s),l(t,mt,s),d(B,t,s),l(t,rt,s),l(t,R,s),l(t,ot,s),d(G,t,s),l(t,ct,s),l(t,X,s),l(t,dt,s),l(t,I,s),l(t,ft,s),d(H,t,s),l(t,ht,s),l(t,W,s),l(t,yt,s),d(S,t,s),l(t,Mt,s),l(t,L,s),l(t,jt,s),d(V,t,s),l(t,wt,s),l(t,F,s),l(t,$t,s),d(P,t,s),l(t,_t,s),d(Q,t,s),l(t,gt,s),l(t,A,s),l(t,xt,s),l(t,Y,s),l(t,bt,s),l(t,z,s),ut=!0},p(t,[s]){const Ft={};s&2&&(Ft.$$scope={dirty:s,ctx:t}),j.$set(Ft)},i(t){ut||(f(_.$$.fragment,t),f(j.$$.fragment,t),f(U.$$.fragment,t),f(v.$$.fragment,t),f(J.$$.fragment,t),f(B.$$.fragment,t),f(G.$$.fragment,t),f(H.$$.fragment,t),f(S.$$.fragment,t),f(V.$$.fragment,t),f(P.$$.fragment,t),f(Q.$$.fragment,t),ut=!0)},o(t){h(_.$$.fragment,t),h(j.$$.fragment,t),h(U.$$.fragment,t),h(v.$$.fragment,t),h(J.$$.fragment,t),h(B.$$.fragment,t),h(G.$$.fragment,t),h(H.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(P.$$.fragment,t),h(Q.$$.fragment,t),ut=!1},d(t){t&&(e($),e(M),e(q),e(E),e(g),e(K),e(x),e(D),e(b),e(O),e(tt),e(u),e(st),e(et),e(C),e(lt),e(T),e(at),e(nt),e(k),e(pt),e(it),e(Z),e(mt),e(rt),e(R),e(ot),e(ct),e(X),e(dt),e(I),e(ft),e(ht),e(W),e(yt),e(Mt),e(L),e(jt),e(wt),e(F),e($t),e(_t),e(gt),e(A),e(xt),e(Y),e(bt),e(z)),e(m),y(_,t),y(j,t),y(U,t),y(v,t),y(J,t),y(B,t),y(G,t),y(H,t),y(S,t),y(V,t),y(P,t),y(Q,t)}}}const ss='{"title":"큰 모델 인스턴스화","local":"instantiating-a-big-model","sections":[{"title":"샤딩된 체크포인트","local":"sharded-checkpoints","sections":[],"depth":2},{"title":"저(低)메모리 로딩","local":"low-memory-loading","sections":[],"depth":2}],"depth":1}';function es(N){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends zt{constructor(m){super(),Nt(this,m,es,ts,At,{})}}export{ms as component};
