import{s as $t,o as _t,n as Zt}from"../chunks/scheduler.c57aa7ef.js";import{S as kt,i as Wt,g as h,s,r as i,A as jt,h as u,f as a,c as n,j as bt,u as r,x as c,k as Jt,y as vt,a as l,v as p,d,t as m,w as f}from"../chunks/index.c50cb18e.js";import{T as gt}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as g}from"../chunks/Heading.c7d7e0e7.js";function Rt(pe){let o,y='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){o=h("p"),o.innerHTML=y},l(w){o=u(w,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1nbpolx"&&(o.innerHTML=y)},m(w,T){l(w,o,T)},p:Zt,d(w){w&&a(o)}}}function Bt(pe){let o,y='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){o=h("p"),o.innerHTML=y},l(w){o=u(w,"P",{"data-svelte-h":!0}),c(o)!=="svelte-19y7vpj"&&(o.innerHTML=y)},m(w,T){l(w,o,T)},p:Zt,d(w){w&&a(o)}}}function Ut(pe){let o,y,w,T,Z,me,$,et='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',fe,_,tt="This guide explores in more detail other options and features for using LoRA.",he,k,ue,W,at='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',ce,j,lt='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',we,v,Me,R,st="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",ye,B,Te,U,be,L,nt='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. If you’re using LoftQ, <em>do not</em> quantize the base model. You should set up a <code>LoftQConfig</code> instead:',Je,I,ge,b,Ze,C,$e,G,ot='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',_e,V,ke,X,We,Q,it='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. Right now, DoRA only supports non-quantized linear layers. DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',je,F,ve,z,Re,H,rt='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Be,Y,Ue,q,Le,E,pt='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Ie,N,Ce,x,dt='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Ge,A,Ve,S,mt='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Xe,P,ft="First load the base model:",Qe,D,Fe,K,ht="Then we load the first adapter:",ze,O,He,ee,ut="Then load a different adapter and merge it with the first one:",Ye,te,qe,J,Ee,ae,ct="Now, perform inference:",Ne,le,xe,se,Ae,ne,wt='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Se,oe,Pe,ie,Mt='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',De,re,Ke,de,Oe;return Z=new g({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),k=new g({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),U=new g({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),I=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),b=new gt({props:{$$slots:{default:[Rt]},$$scope:{ctx:pe}}}),C=new g({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),V=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),X=new g({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),F=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),z=new g({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Y=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),q=new g({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),N=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),A=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),D=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),O=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),te=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),J=new gt({props:{$$slots:{default:[Bt]},$$scope:{ctx:pe}}}),le=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),se=new g({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),oe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),re=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),{c(){o=h("meta"),y=s(),w=h("p"),T=s(),i(Z.$$.fragment),me=s(),$=h("p"),$.innerHTML=et,fe=s(),_=h("p"),_.textContent=tt,he=s(),i(k.$$.fragment),ue=s(),W=h("p"),W.innerHTML=at,ce=s(),j=h("p"),j.innerHTML=lt,we=s(),i(v.$$.fragment),Me=s(),R=h("p"),R.innerHTML=st,ye=s(),i(B.$$.fragment),Te=s(),i(U.$$.fragment),be=s(),L=h("p"),L.innerHTML=nt,Je=s(),i(I.$$.fragment),ge=s(),i(b.$$.fragment),Ze=s(),i(C.$$.fragment),$e=s(),G=h("p"),G.innerHTML=ot,_e=s(),i(V.$$.fragment),ke=s(),i(X.$$.fragment),We=s(),Q=h("p"),Q.innerHTML=it,je=s(),i(F.$$.fragment),ve=s(),i(z.$$.fragment),Re=s(),H=h("p"),H.innerHTML=rt,Be=s(),i(Y.$$.fragment),Ue=s(),i(q.$$.fragment),Le=s(),E=h("p"),E.innerHTML=pt,Ie=s(),i(N.$$.fragment),Ce=s(),x=h("p"),x.innerHTML=dt,Ge=s(),i(A.$$.fragment),Ve=s(),S=h("p"),S.innerHTML=mt,Xe=s(),P=h("p"),P.textContent=ft,Qe=s(),i(D.$$.fragment),Fe=s(),K=h("p"),K.textContent=ht,ze=s(),i(O.$$.fragment),He=s(),ee=h("p"),ee.textContent=ut,Ye=s(),i(te.$$.fragment),qe=s(),i(J.$$.fragment),Ee=s(),ae=h("p"),ae.textContent=ct,Ne=s(),i(le.$$.fragment),xe=s(),i(se.$$.fragment),Ae=s(),ne=h("p"),ne.innerHTML=wt,Se=s(),i(oe.$$.fragment),Pe=s(),ie=h("p"),ie.innerHTML=Mt,De=s(),i(re.$$.fragment),Ke=s(),de=h("p"),this.h()},l(e){const t=jt("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),w=u(e,"P",{}),bt(w).forEach(a),T=n(e),r(Z.$$.fragment,e),me=n(e),$=u(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-38uxl6"&&($.innerHTML=et),fe=n(e),_=u(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-ovsn32"&&(_.textContent=tt),he=n(e),r(k.$$.fragment,e),ue=n(e),W=u(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-j883mf"&&(W.innerHTML=at),ce=n(e),j=u(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1fujb7a"&&(j.innerHTML=lt),we=n(e),r(v.$$.fragment,e),Me=n(e),R=u(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-mwvui1"&&(R.innerHTML=st),ye=n(e),r(B.$$.fragment,e),Te=n(e),r(U.$$.fragment,e),be=n(e),L=u(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1khsfzg"&&(L.innerHTML=nt),Je=n(e),r(I.$$.fragment,e),ge=n(e),r(b.$$.fragment,e),Ze=n(e),r(C.$$.fragment,e),$e=n(e),G=u(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-omuw13"&&(G.innerHTML=ot),_e=n(e),r(V.$$.fragment,e),ke=n(e),r(X.$$.fragment,e),We=n(e),Q=u(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-5j243m"&&(Q.innerHTML=it),je=n(e),r(F.$$.fragment,e),ve=n(e),r(z.$$.fragment,e),Re=n(e),H=u(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-15vxux2"&&(H.innerHTML=rt),Be=n(e),r(Y.$$.fragment,e),Ue=n(e),r(q.$$.fragment,e),Le=n(e),E=u(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1c3h9aa"&&(E.innerHTML=pt),Ie=n(e),r(N.$$.fragment,e),Ce=n(e),x=u(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-m3cr6r"&&(x.innerHTML=dt),Ge=n(e),r(A.$$.fragment,e),Ve=n(e),S=u(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-kbqhpl"&&(S.innerHTML=mt),Xe=n(e),P=u(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1mwdwt1"&&(P.textContent=ft),Qe=n(e),r(D.$$.fragment,e),Fe=n(e),K=u(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-nuhu05"&&(K.textContent=ht),ze=n(e),r(O.$$.fragment,e),He=n(e),ee=u(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1n53hd9"&&(ee.textContent=ut),Ye=n(e),r(te.$$.fragment,e),qe=n(e),r(J.$$.fragment,e),Ee=n(e),ae=u(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-qwbdkg"&&(ae.textContent=ct),Ne=n(e),r(le.$$.fragment,e),xe=n(e),r(se.$$.fragment,e),Ae=n(e),ne=u(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-ke62q2"&&(ne.innerHTML=wt),Se=n(e),r(oe.$$.fragment,e),Pe=n(e),ie=u(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-cvmoj6"&&(ie.innerHTML=Mt),De=n(e),r(re.$$.fragment,e),Ke=n(e),de=u(e,"P",{}),bt(de).forEach(a),this.h()},h(){Jt(o,"name","hf:doc:metadata"),Jt(o,"content",Lt)},m(e,t){vt(document.head,o),l(e,y,t),l(e,w,t),l(e,T,t),p(Z,e,t),l(e,me,t),l(e,$,t),l(e,fe,t),l(e,_,t),l(e,he,t),p(k,e,t),l(e,ue,t),l(e,W,t),l(e,ce,t),l(e,j,t),l(e,we,t),p(v,e,t),l(e,Me,t),l(e,R,t),l(e,ye,t),p(B,e,t),l(e,Te,t),p(U,e,t),l(e,be,t),l(e,L,t),l(e,Je,t),p(I,e,t),l(e,ge,t),p(b,e,t),l(e,Ze,t),p(C,e,t),l(e,$e,t),l(e,G,t),l(e,_e,t),p(V,e,t),l(e,ke,t),p(X,e,t),l(e,We,t),l(e,Q,t),l(e,je,t),p(F,e,t),l(e,ve,t),p(z,e,t),l(e,Re,t),l(e,H,t),l(e,Be,t),p(Y,e,t),l(e,Ue,t),p(q,e,t),l(e,Le,t),l(e,E,t),l(e,Ie,t),p(N,e,t),l(e,Ce,t),l(e,x,t),l(e,Ge,t),p(A,e,t),l(e,Ve,t),l(e,S,t),l(e,Xe,t),l(e,P,t),l(e,Qe,t),p(D,e,t),l(e,Fe,t),l(e,K,t),l(e,ze,t),p(O,e,t),l(e,He,t),l(e,ee,t),l(e,Ye,t),p(te,e,t),l(e,qe,t),p(J,e,t),l(e,Ee,t),l(e,ae,t),l(e,Ne,t),p(le,e,t),l(e,xe,t),p(se,e,t),l(e,Ae,t),l(e,ne,t),l(e,Se,t),p(oe,e,t),l(e,Pe,t),l(e,ie,t),l(e,De,t),p(re,e,t),l(e,Ke,t),l(e,de,t),Oe=!0},p(e,[t]){const yt={};t&2&&(yt.$$scope={dirty:t,ctx:e}),b.$set(yt);const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:e}),J.$set(Tt)},i(e){Oe||(d(Z.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(b.$$.fragment,e),d(C.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(q.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(J.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),Oe=!0)},o(e){m(Z.$$.fragment,e),m(k.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(b.$$.fragment,e),m(C.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(q.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(J.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),Oe=!1},d(e){e&&(a(y),a(w),a(T),a(me),a($),a(fe),a(_),a(he),a(ue),a(W),a(ce),a(j),a(we),a(Me),a(R),a(ye),a(Te),a(be),a(L),a(Je),a(ge),a(Ze),a($e),a(G),a(_e),a(ke),a(We),a(Q),a(je),a(ve),a(Re),a(H),a(Be),a(Ue),a(Le),a(E),a(Ie),a(Ce),a(x),a(Ge),a(Ve),a(S),a(Xe),a(P),a(Qe),a(Fe),a(K),a(ze),a(He),a(ee),a(Ye),a(qe),a(Ee),a(ae),a(Ne),a(xe),a(Ae),a(ne),a(Se),a(Pe),a(ie),a(De),a(Ke),a(de)),a(o),f(Z,e),f(k,e),f(v,e),f(B,e),f(U,e),f(I,e),f(b,e),f(C,e),f(V,e),f(X,e),f(F,e),f(z,e),f(Y,e),f(q,e),f(N,e),f(A,e),f(D,e),f(O,e),f(te,e),f(J,e),f(le,e),f(se,e),f(oe,e),f(re,e)}}}const Lt='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2}],"depth":1}';function It(pe){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends kt{constructor(o){super(),Wt(this,o,It,Ut,$t,{})}}export{Ft as component};
