import{s as it,o as Mt,n as ot}from"../chunks/scheduler.b108d059.js";import{S as rt,i as pt,g as o,s as a,r as p,A as mt,h as i,f as t,c as n,j as st,u as m,x as M,k as at,y as ut,a as s,v as u,d as c,t as y,w as d}from"../chunks/index.008de539.js";import{T as nt}from"../chunks/Tip.aeb15ab7.js";import{C as J}from"../chunks/CodeBlock.3968c746.js";import{H as je,E as ct}from"../chunks/EditOnGithub.d1c48e3d.js";function yt(Ue){let r,h="The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.";return{c(){r=o("p"),r.innerHTML=h},l(w){r=i(w,"P",{"data-svelte-h":!0}),M(r)!=="svelte-116se2o"&&(r.innerHTML=h)},m(w,U){s(w,r,U)},p:ot,d(w){w&&t(r)}}}function dt(Ue){let r,h='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/vertex-ai/notebooks/evaluate-llms-with-vertex-ai" rel="nofollow">here</a>!';return{c(){r=o("p"),r.innerHTML=h},l(w){r=i(w,"P",{"data-svelte-h":!0}),M(r)!=="svelte-p7026o"&&(r.innerHTML=h)},m(w,U){s(w,r,U)},p:ot,d(w){w&&t(r)}}}function wt(Ue){let r,h,w,U,b,be,f,Il='The <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Gen AI Evaluation Service in Vertex AI</a> lets us evaluate LLMs or Application using existing or your own evaluation criterias. It supports academic metrics like BLEU, ROUGE, or LLM as a Judge with Pointwise and Pairwise metrics or custom metrics you can define yourself. As default LLM as a Judge <code>Gemini 1.5 Pro</code> is used.',fe,I,gl='We can use the Gen AI Evaluation Service to evaluate the performance of open models and finetuned models using Vertex AI Endpoints and compute resources. In this example we will evaluate <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> generated summaries from news articles using a Pointwise metric based on <a href="https://arxiv.org/abs/2303.16634" rel="nofollow">G-Eval</a> Coherence metric.',Ie,g,vl="We will cover the following topics:",ge,v,Bl="<li>Setup / Configuration</li> <li>Deploy Llama 3.1 8B on Vertex AI</li> <li>Evaluate Llama 3.1 8B using different prompts on Coherence</li> <li>Interpret the results</li> <li>Clean up resources</li>",ve,B,Be,G,Gl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Ge,Z,Zl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Ze,C,Ce,W,Cl="For ease of use we define the following environment variables for GCP.",We,V,Wl="<em>Note 1: Make sure to adapt the project ID to your GCP project.</em><br/> <em>Note 2: The Gen AI Evaluation Service is not available in all regions. If you want to use it, you need to select a region that supports it. <code>us-central1</code> is currently supported.</em>",Ve,x,xe,k,Vl="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",ke,X,Xe,E,xl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Ee,A,Ae,S,Se,R,kl='Once everything is set up, we can deploy the Llama 3.1 8B model on Vertex AI. We will use the <code>google-cloud-aiplatform</code> Python SDK to do so. <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-8B-Instruct</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account. More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',Re,Q,Qe,N,Xl='After we are logged in we can “upload” the model i.e. register the model on Vertex AI. If you want to learn more about the arguments you can pass to the <code>upload</code> method, check out <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/vertex-notebook.ipynb" rel="nofollow">Deploy Gemma 7B with TGI on Vertex AI</a>.',Ne,$,$e,_,El="We will deploy the <code>meta-llama/Meta-Llama-3.1-8B-Instruct</code> to 1x NVIDIA L4 accelerator with 24GB memory. We set TGI parameters to allow for a maximum of 8000 input tokens, 8192 maximum total tokens, and 8192 maximum batch prefill tokens.",_e,H,He,T,Fe,F,Al="After the model is deployed, we can test our endpoint. We generate a helper <code>generate</code> function to send requests to the deployed model. This will be later used to send requests to the deployed model and collect the outputs for evaluation.",Ye,Y,Le,L,ze,z,Sl="We will evaluate the Llama 3.1 8B model using different prompts on Coherence. Coherence measures how well the individual sentences within a summarized news article connect together to form a unified and easily understandable narrative.",qe,q,Rl='We are going to use the new <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Generative AI Evaluation Service</a>. The Gen AI Evaluation Service can be used to:',Pe,P,Ql="<li>Model selection: Choose the best pre-trained model for your task based on benchmark results and its performance on your specific data.</li> <li>Generation settings: Tweak model parameters (like temperature) to optimize output for your needs.</li> <li>Prompt engineering: Craft effective prompts and prompt templates to guide the model towards your preferred behavior and responses.</li> <li>Improve and safeguard fine-tuning: Fine-tune a model to improve performance for your use case, while avoiding biases or undesirable behaviors.</li> <li>RAG optimization: Select the most effective Retrieval Augmented Generation (RAG) architecture to enhance performance for your application.</li> <li>Migration: Continuously assess and improve the performance of your AI solution by migrating to newer models when they provide a clear advantage for your specific use case.</li>",De,D,Nl="In our case, we will use it to evaluate different prompt templates to achieve the most coherent summaries using Llama 3.1 8B Instruct.",Ke,K,$l='We are going to use a reference free Pointwise metric based on <a href="https://arxiv.org/abs/2303.16634" rel="nofollow">G-Eval</a> Coherence metric.',Oe,O,_l="The first step is to define our prompt template and create our <code>PointwiseMetric</code>. Vertex AI returns our response from the model in the <code>response</code> field our news article will be made available in the <code>text</code> field.",el,ee,ll,le,Hl='We are going to use <a href="https://huggingface.co/datasets/argilla/news-summary" rel="nofollow">argilla/news-summary</a> dataset consisting of news article from Reuters. We are going to use a random subset of 15 articles to keep the evaluation fast. Feel free to change the dataset and the number of articles to evaluate the model with more data and different topics.',tl,te,sl,se,Fl="Before we can run the evaluation, we need to convert our dataset into a pandas dataframe.",al,ae,nl,ne,Yl="Awesome! We are almost ready. Last step is to define our different summarization prompts we want to use for evaluation.",ol,oe,il,ie,Ll="Now we can iterate over our prompts and create different evaluation tasks, use our coherence metric to evaluate the summaries and collect the results.",Ml,Me,rl,re,zl='Nice, it looks like on our limited test the “simple” prompt yields the best results. We can inspect and compare the results in the GCP Console at <a href="https://console.cloud.google.com/vertex-ai/experiments" rel="nofollow">Vertex AI &gt; Model Development &gt; Experiments</a>.',pl,pe,ql='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/evaluate-llms-with-vertex-ai/assets/experiment-results.png" alt="experiment-results"/>',ml,me,Pl="The overview allows to compare the results across different experiments and to inspect the individual evaluations. Here we can see that the standard deviation of detailed is quite high. This could be because of the low sample size or that we need to improve the prompt further.",ul,ue,Dl='You can find more examples on how to use the Gen AI Evaluation Service in the <a href="https://cloud.google.com/vertex-ai/generative-ai/docs/models/evaluation-overview" rel="nofollow">Vertex AI Generative AI documentation</a> including how to:',cl,ce,Kl='<li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/bring_your_own_autorater_with_custom_metric.ipynb" rel="nofollow">how to customize the LLM as a Judge</a></li> <li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/compare_generative_ai_models.ipynb" rel="nofollow">how to use Pairwise metrics and compare different LLMs</a></li> <li><a href="https://github.com/GoogleCloudPlatform/generative-ai/blob/main/gemini/evaluation/prompt_engineering_gen_ai_evaluation_service_sdk.ipynb" rel="nofollow">how to evaluate different prompts more efficiently</a></li>',yl,ye,dl,de,Ol="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",wl,we,et="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Jl,Je,hl,Ul,Tl,j,jl,he,bl,Te,fl;return b=new je({props:{title:"Evaluate open LLMs with Vertex AI and Gemini",local:"evaluate-open-llms-with-vertex-ai-and-gemini",headingTag:"h1"}}),B=new je({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),C=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwJTIyZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0lNUJldmFsdWF0aW9uJTVEJTIyJTIwJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:'!pip install --upgrade --quiet <span class="hljs-string">&quot;google-cloud-aiplatform[evaluation]&quot;</span>  huggingface_hub transformers datasets',wrap:!1}}),x=new J({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRGdjcC1wYXJ0bmVyc2hpcC00MTIxMDglMEElMjVlbnYlMjBMT0NBVElPTiUzRHVzLWNlbnRyYWwxJTBBJTI1ZW52JTIwQ09OVEFJTkVSX1VSSSUzRHVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMkZodWdnaW5nZmFjZS10ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWN1MTIxLjItMi51YnVudHUyMjA0LnB5MzEw",highlighted:`%env PROJECT_ID=gcp-partnership-<span class="hljs-number">412108</span>
%env LOCATION=us-central1
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>ubuntu2204.py310`,wrap:!1}}),X=new J({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),A=new J({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),S=new je({props:{title:"Deploy Llama 3.1 8B on Vertex AI",local:"deploy-llama-31-8b-on-vertex-ai",headingTag:"h2"}}),Q=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),$=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),H=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQXZlcnRleF9tb2RlbF9uYW1lJTIwJTNEJTIwJTIybGxhbWEtMy0xLThiLWluc3RydWN0JTIyJTBBJTBBbW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0R2ZXJ0ZXhfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2ltYWdlX3VyaSUzRG9zLmdldGVudiglMjJDT05UQUlORVJfVVJJJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2Vudmlyb25tZW50X3ZhcmlhYmxlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjgwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyODE5MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjgxOTIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIVUdHSU5HX0ZBQ0VfSFVCX1RPS0VOJTIyJTNBJTIwZ2V0X3Rva2VuKCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9wb3J0cyUzRCU1QjgwODAlNUQlMkMlMEEpJTBBbW9kZWwud2FpdCgpJTIwJTIwJTIzJTIwd2FpdCUyMGZvciUyMHRoZSUyMG1vZGVsJTIwdG8lMjBiZSUyMHJlZ2lzdGVyZWQlMEElMEElMjMlMjBjcmVhdGUlMjBlbmRwb2ludCUwQWVuZHBvaW50JTIwJTNEJTIwYWlwbGF0Zm9ybS5FbmRwb2ludC5jcmVhdGUoZGlzcGxheV9uYW1lJTNEZiUyMiU3QnZlcnRleF9tb2RlbF9uYW1lJTdELWVuZHBvaW50JTIyKSUwQSUwQSUyMyUyMGRlcGxveSUyMG1vZGVsJTIwdG8lMjAxeCUyME5WSURJQSUyMEw0JTBBZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

vertex_model_name = <span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span>

model = aiplatform.Model.upload(
    display_name=vertex_model_name,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;8000&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;8192&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;8192&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()  <span class="hljs-comment"># wait for the model to be registered</span>

<span class="hljs-comment"># create endpoint</span>
endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">f&quot;<span class="hljs-subst">{vertex_model_name}</span>-endpoint&quot;</span>)

<span class="hljs-comment"># deploy model to 1x NVIDIA L4</span>
deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),T=new nt({props:{warning:!0,$$slots:{default:[yt]},$$scope:{ctx:Ue}}}),Y=new J({props:{code:"aW1wb3J0JTIwcmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMGdyZXAlMjB0aGUlMjBtb2RlbCUyMGlkJTIwZnJvbSUyMHRoZSUyMGNvbnRhaW5lciUyMHNwZWMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlcyUwQW1vZGVsX2lkJTIwJTNEJTIwbmV4dCglMEElMjAlMjAlMjAlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmUuc2VhcmNoKHIndmFsdWUlM0ElMjAlMjIoLiUyQiklMjInJTJDJTIwc3RyKGl0ZW0pKS5ncm91cCgxKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGl0ZW0lMjBpbiUyMGxpc3QobW9kZWwuY29udGFpbmVyX3NwZWMuZW52KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIyTU9ERUxfSUQlMjIlMjBpbiUyMHN0cihpdGVtKSUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBOb25lJTJDJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiklMEElMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC4yJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjIlMkMlMEElN0QlMEElMEElMEFkZWYlMjBnZW5lcmF0ZShwcm9tcHQlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyUzRGdlbmVyYXRpb25fY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMGZvcm1hdHRlZF9wcm9tcHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwZm9ybWF0dGVkX3Byb21wdCUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBnZW5lcmF0aW9uX2NvbmZpZyU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMGRlcGxveWVkX21vZGVsLnByZWRpY3QoaW5zdGFuY2VzJTNEJTVCcGF5bG9hZCU1RCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBnZW5lcmF0ZWRfdGV4dCUwQSUwQSUwQWdlbmVyYXRlKCUyMkhvdyUyMG1hbnklMjBwZW9wbGUlMjBsaXZlJTIwaW4lMjBCZXJsaW4lM0YlMjIlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEElMjMlMjAnVGhlJTIwcG9wdWxhdGlvbiUyMG9mJTIwQmVybGluJTIwaXMlMjBhcHByb3hpbWF0ZWx5JTIwNi41NzglMjBtaWxsaW9uJTIwYXMlMjBvZiUyMG15JTIwY3V0JTIwb2ZmJTIwZGF0YS4lMjBIb3dldmVyJTJDJTIwY29uc2lkZXJpbmclMjBpdCUyMHByb3ZpZGVzJTIwcmVhbC10aW1lJTIwdXBkYXRlcyUyQyUyMHRoZSUyMGN1cnJlbnQlMjBwb3B1bGF0aW9uJTIwbWlnaHQlMjBiZSUyMHNsaWdodGx5JTIwaGlnaGVyJw==",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># grep the model id from the container spec environment variables</span>
model_id = <span class="hljs-built_in">next</span>(
    (
        re.search(<span class="hljs-string">r&#x27;value: &quot;(.+)&quot;&#x27;</span>, <span class="hljs-built_in">str</span>(item)).group(<span class="hljs-number">1</span>)
        <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(model.container_spec.env)
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;MODEL_ID&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(item)
    ),
    <span class="hljs-literal">None</span>,
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>)

generation_config = {
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.2</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>,
}


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">prompt, generation_config=generation_config</span>):
    formatted_prompt = tokenizer.apply_chat_template(
        [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        ],
        tokenize=<span class="hljs-literal">False</span>,
        add_generation_prompt=<span class="hljs-literal">True</span>,
    )

    payload = {<span class="hljs-string">&quot;inputs&quot;</span>: formatted_prompt, <span class="hljs-string">&quot;parameters&quot;</span>: generation_config}
    output = deployed_model.predict(instances=[payload])
    generated_text = output.predictions[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> generated_text


generate(<span class="hljs-string">&quot;How many people live in Berlin?&quot;</span>, generation_config)
<span class="hljs-comment"># &#x27;The population of Berlin is approximately 6.578 million as of my cut off data. However, considering it provides real-time updates, the current population might be slightly higher&#x27;</span>`,wrap:!1}}),L=new je({props:{title:"Evaluate Llama 3.1 8B using different prompts on Coherence",local:"evaluate-llama-31-8b-using-different-prompts-on-coherence",headingTag:"h2"}}),ee=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> vertexai.evaluation <span class="hljs-keyword">import</span> EvalTask, PointwiseMetric

g_eval_coherence = <span class="hljs-string">&quot;&quot;&quot;
You are an expert evaluator. You will be given one summary written for a news article.
Your task is to rate the summary on one metric.
Please make sure you read and understand these instructions carefully. Please keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:

Coherence (1-5) - the collective quality of all sentences. We align this dimension with the DUC quality question of structure and coherence whereby &quot;the summary should be well-structured and well-organized. The summary should not just be a heap of related information, but should build from sentence to a coherent body of information about a topic.&quot;

Evaluation Steps:

1. Read the news article carefully and identify the main topic and key points.
2. Read the summary and compare it to the news article. Check if the summary covers the main topic and key points of the news article, and if it presents them in a clear and logical order.
3. Assign a score for coherence on a scale of 1 to 5, where 1 is the lowest and 5 is the highest based on the Evaluation Criteria.


Example:


Source Text:

{text}

Summary:

{response}

Evaluation Form (scores ONLY):

- Coherence:&quot;&quot;&quot;</span>

metric = PointwiseMetric(
    metric=<span class="hljs-string">&quot;g-eval-coherence&quot;</span>,
    metric_prompt_template=g_eval_coherence,
)`,wrap:!1}}),te=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBc3Vic2V0X3NpemUlMjAlM0QlMjAxNSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYXJnaWxsYSUyRm5ld3Mtc3VtbWFyeSUyMiUyQyUyMHNwbGl0JTNEZiUyMnRyYWluJTIyKS5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKHN1YnNldF9zaXplKSklMEElMEElMjMlMjBwcmludCUyMGZpcnN0JTIwMTUwJTIwY2hhcmFjdGVycyUyMG9mJTIwdGhlJTIwZmlyc3QlMjBhcnRpY2xlJTBBcHJpbnQoZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVEJTVCJTNBMTUwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

subset_size = <span class="hljs-number">15</span>
dataset = load_dataset(<span class="hljs-string">&quot;argilla/news-summary&quot;</span>, split=<span class="hljs-string">f&quot;train&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(subset_size))

<span class="hljs-comment"># print first 150 characters of the first article</span>
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>][:<span class="hljs-number">150</span>])`,wrap:!1}}),ae=new J({props:{code:"JTIzJTIwcmVtb3ZlJTIwYWxsJTIwY29sdW1ucyUyMGV4Y2VwdCUyMGZvciUyMCUyMnRleHQlMjIlMEF0b19yZW1vdmUlMjAlM0QlMjAlNUJjb2wlMjBmb3IlMjBjb2wlMjBpbiUyMGRhdGFzZXQuZmVhdHVyZXMua2V5cygpJTIwaWYlMjBjb2wlMjAhJTNEJTIwJTIydGV4dCUyMiU1RCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKHRvX3JlbW92ZSklMEFkZiUyMCUzRCUyMGRhdGFzZXQudG9fcGFuZGFzKCklMEFkZi5oZWFkKCk=",highlighted:`<span class="hljs-comment"># remove all columns except for &quot;text&quot;</span>
to_remove = [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> dataset.features.keys() <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>]
dataset = dataset.remove_columns(to_remove)
df = dataset.to_pandas()
df.head()`,wrap:!1}}),oe=new J({props:{code:"c3VtbWFyaXphdGlvbl9wcm9tcHRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc2ltcGxlJTIyJTNBJTIwJTIyU3VtbWFyaXplJTIwdGhlJTIwZm9sbG93aW5nJTIwbmV3cyUyMGFydGljbGUlM0ElMjAlN0J0ZXh0JTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZWxpNSUyMiUzQSUyMCUyMlN1bW1hcml6ZSUyMHRoZSUyMGZvbGxvd2luZyUyMG5ld3MlMjBhcnRpY2xlJTIwaW4lMjBhJTIwd2F5JTIwYSUyMDUlMjB5ZWFyJTIwb2xkJTIwd291bGQlMjB1bmRlcnN0YW5kJTNBJTIwJTdCdGV4dCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRldGFpbGVkJTIyJTNBJTIwJTIyJTIyJTIyU3VtbWFyaXplJTIwdGhlJTIwZ2l2ZW4lMjBuZXdzJTIwYXJ0aWNsZSUyQyUyMHRleHQlMkMlMjBpbmNsdWRpbmclMjBhbGwlMjBrZXklMjBwb2ludHMlMjBhbmQlMjBzdXBwb3J0aW5nJTIwZGV0YWlscyUzRiUyMFRoZSUyMHN1bW1hcnklMjBzaG91bGQlMjBiZSUyMGNvbXByZWhlbnNpdmUlMjBhbmQlMjBhY2N1cmF0ZWx5JTIwcmVmbGVjdCUyMHRoZSUyMG1haW4lMjBtZXNzYWdlJTIwYW5kJTIwYXJndW1lbnRzJTIwcHJlc2VudGVkJTIwaW4lMjB0aGUlMjBvcmlnaW5hbCUyMHRleHQlMkMlMjB3aGlsZSUyMGFsc28lMjBiZWluZyUyMGNvbmNpc2UlMjBhbmQlMjBlYXN5JTIwdG8lMjB1bmRlcnN0YW5kLiUyMFRvJTIwZW5zdXJlJTIwYWNjdXJhY3klMkMlMjBwbGVhc2UlMjByZWFkJTIwdGhlJTIwdGV4dCUyMGNhcmVmdWxseSUyMGFuZCUyMHBheSUyMGF0dGVudGlvbiUyMHRvJTIwYW55JTIwbnVhbmNlcyUyMG9yJTIwY29tcGxleGl0aWVzJTIwaW4lMjB0aGUlMjBsYW5ndWFnZS4lMEElMjAlMjAlMEFBcnRpY2xlJTNBJTBBJTdCdGV4dCU3RCUyMiUyMiUyMiUyQyUwQSU3RA==",highlighted:`summarization_prompts = {
    <span class="hljs-string">&quot;simple&quot;</span>: <span class="hljs-string">&quot;Summarize the following news article: {text}&quot;</span>,
    <span class="hljs-string">&quot;eli5&quot;</span>: <span class="hljs-string">&quot;Summarize the following news article in a way a 5 year old would understand: {text}&quot;</span>,
    <span class="hljs-string">&quot;detailed&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Summarize the given news article, text, including all key points and supporting details? The summary should be comprehensive and accurately reflect the main message and arguments presented in the original text, while also being concise and easy to understand. To ensure accuracy, please read the text carefully and pay attention to any nuances or complexities in the language.
  
Article:
{text}&quot;&quot;&quot;</span>,
}`,wrap:!1}}),Me=new J({props:{code:"aW1wb3J0JTIwdXVpZCUwQSUwQSUwQXJlc3VsdHMlMjAlM0QlMjAlN0IlN0QlMEFmb3IlMjBwcm9tcHRfbmFtZSUyQyUyMHByb21wdCUyMGluJTIwc3VtbWFyaXphdGlvbl9wcm9tcHRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBzdW1tYXJpemF0aW9uX3Byb21wdHMlNUJwcm9tcHRfbmFtZSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwYWRkJTIwbmV3JTIwcHJvbXB0JTIwY29sdW1uJTBBJTIwJTIwJTIwJTIwZGYlNUIlMjJwcm9tcHQlMjIlNUQlMjAlM0QlMjBkZiU1QiUyMnRleHQlMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHByb21wdC5mb3JtYXQodGV4dCUzRHgpKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDIuJTIwY3JlYXRlJTIwZXZhbCUyMHRhc2slMEElMjAlMjAlMjAlMjBldmFsX3Rhc2slMjAlM0QlMjBFdmFsVGFzayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0JTNEZGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNzJTNEJTVCbWV0cmljJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhwZXJpbWVudCUzRCUyMmxsYW1hLTMtMS04Yi1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMHJ1biUyMGV2YWwlMjB0YXNrJTBBJTIwJTIwJTIwJTIwJTIzJTIwTm90ZSUzQSUyMElmJTIwdGhlJTIwbGFzdCUyMGl0ZXJhdGlvbiUyMHRha2VzJTIwJTNFJTIwMSUyMG1pbnV0ZSUyMHlvdSUyMG1pZ2h0JTIwbmVlZCUyMHRvJTIwcmV0cnklMjB0aGUlMjBldmFsdWF0aW9uJTBBJTIwJTIwJTIwJTIwZXhwX3Jlc3VsdHMlMjAlM0QlMjBldmFsX3Rhc2suZXZhbHVhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0RnZW5lcmF0ZSUyQyUyMGV4cGVyaW1lbnRfcnVuX25hbWUlM0RmJTIycHJvbXB0LSU3QnByb21wdF9uYW1lJTdELSU3QnN0cih1dWlkLnV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCcHJvbXB0X25hbWUlN0QlM0ElMjAlN0JleHBfcmVzdWx0cy5zdW1tYXJ5X21ldHJpY3MlNUInZy1ldmFsLWNvaGVyZW5jZSUyRm1lYW4nJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJwcm9tcHRfbmFtZSU1RCUyMCUzRCUyMGV4cF9yZXN1bHRzLnN1bW1hcnlfbWV0cmljcyU1QiUyMmctZXZhbC1jb2hlcmVuY2UlMkZtZWFuJTIyJTVEJTBBJTBBZm9yJTIwcHJvbXB0X25hbWUlMkMlMjBzY29yZSUyMGluJTIwc29ydGVkKHJlc3VsdHMuaXRlbXMoKSUyQyUyMGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMSU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0Jwcm9tcHRfbmFtZSU3RCUzQSUyMCU3QnNjb3JlJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> uuid


results = {}
<span class="hljs-keyword">for</span> prompt_name, prompt <span class="hljs-keyword">in</span> summarization_prompts.items():
    prompt = summarization_prompts[prompt_name]

    <span class="hljs-comment"># 1. add new prompt column</span>
    df[<span class="hljs-string">&quot;prompt&quot;</span>] = df[<span class="hljs-string">&quot;text&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: prompt.<span class="hljs-built_in">format</span>(text=x))

    <span class="hljs-comment"># 2. create eval task</span>
    eval_task = EvalTask(
        dataset=df,
        metrics=[metric],
        experiment=<span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span>,
    )
    <span class="hljs-comment"># 3. run eval task</span>
    <span class="hljs-comment"># Note: If the last iteration takes &gt; 1 minute you might need to retry the evaluation</span>
    exp_results = eval_task.evaluate(
        model=generate, experiment_run_name=<span class="hljs-string">f&quot;prompt-<span class="hljs-subst">{prompt_name}</span>-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid.uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt_name}</span>: <span class="hljs-subst">{exp_results.summary_metrics[<span class="hljs-string">&#x27;g-eval-coherence/mean&#x27;</span>]}</span>&quot;</span>)
    results[prompt_name] = exp_results.summary_metrics[<span class="hljs-string">&quot;g-eval-coherence/mean&quot;</span>]

<span class="hljs-keyword">for</span> prompt_name, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(results.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>], reverse=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt_name}</span>: <span class="hljs-subst">{score}</span>&quot;</span>)`,wrap:!1}}),ye=new je({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Je=new J({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),j=new nt({props:{$$slots:{default:[dt]},$$scope:{ctx:Ue}}}),he=new ct({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-evaluate-llms-with-vertex-ai.mdx"}}),{c(){r=o("meta"),h=a(),w=o("p"),U=a(),p(b.$$.fragment),be=a(),f=o("p"),f.innerHTML=Il,fe=a(),I=o("p"),I.innerHTML=gl,Ie=a(),g=o("p"),g.textContent=vl,ge=a(),v=o("ol"),v.innerHTML=Bl,ve=a(),p(B.$$.fragment),Be=a(),G=o("p"),G.innerHTML=Gl,Ge=a(),Z=o("p"),Z.innerHTML=Zl,Ze=a(),p(C.$$.fragment),Ce=a(),W=o("p"),W.textContent=Cl,We=a(),V=o("p"),V.innerHTML=Wl,Ve=a(),p(x.$$.fragment),xe=a(),k=o("p"),k.textContent=Vl,ke=a(),p(X.$$.fragment),Xe=a(),E=o("p"),E.textContent=xl,Ee=a(),p(A.$$.fragment),Ae=a(),p(S.$$.fragment),Se=a(),R=o("p"),R.innerHTML=kl,Re=a(),p(Q.$$.fragment),Qe=a(),N=o("p"),N.innerHTML=Xl,Ne=a(),p($.$$.fragment),$e=a(),_=o("p"),_.innerHTML=El,_e=a(),p(H.$$.fragment),He=a(),p(T.$$.fragment),Fe=a(),F=o("p"),F.innerHTML=Al,Ye=a(),p(Y.$$.fragment),Le=a(),p(L.$$.fragment),ze=a(),z=o("p"),z.textContent=Sl,qe=a(),q=o("p"),q.innerHTML=Rl,Pe=a(),P=o("ul"),P.innerHTML=Ql,De=a(),D=o("p"),D.textContent=Nl,Ke=a(),K=o("p"),K.innerHTML=$l,Oe=a(),O=o("p"),O.innerHTML=_l,el=a(),p(ee.$$.fragment),ll=a(),le=o("p"),le.innerHTML=Hl,tl=a(),p(te.$$.fragment),sl=a(),se=o("p"),se.textContent=Fl,al=a(),p(ae.$$.fragment),nl=a(),ne=o("p"),ne.textContent=Yl,ol=a(),p(oe.$$.fragment),il=a(),ie=o("p"),ie.textContent=Ll,Ml=a(),p(Me.$$.fragment),rl=a(),re=o("p"),re.innerHTML=zl,pl=a(),pe=o("p"),pe.innerHTML=ql,ml=a(),me=o("p"),me.textContent=Pl,ul=a(),ue=o("p"),ue.innerHTML=Dl,cl=a(),ce=o("ul"),ce.innerHTML=Kl,yl=a(),p(ye.$$.fragment),dl=a(),de=o("p"),de.textContent=Ol,wl=a(),we=o("ul"),we.innerHTML=et,Jl=a(),p(Je.$$.fragment),hl=a(),Ul=o("hr"),Tl=a(),p(j.$$.fragment),jl=a(),p(he.$$.fragment),bl=a(),Te=o("p"),this.h()},l(e){const l=mt("svelte-u9bgzb",document.head);r=i(l,"META",{name:!0,content:!0}),l.forEach(t),h=n(e),w=i(e,"P",{}),st(w).forEach(t),U=n(e),m(b.$$.fragment,e),be=n(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-9w0tfp"&&(f.innerHTML=Il),fe=n(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1hlalgy"&&(I.innerHTML=gl),Ie=n(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1x8h9gx"&&(g.textContent=vl),ge=n(e),v=i(e,"OL",{"data-svelte-h":!0}),M(v)!=="svelte-v96lb8"&&(v.innerHTML=Bl),ve=n(e),m(B.$$.fragment,e),Be=n(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1o67gfb"&&(G.innerHTML=Gl),Ge=n(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1ebrquh"&&(Z.innerHTML=Zl),Ze=n(e),m(C.$$.fragment,e),Ce=n(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-b9yt3b"&&(W.textContent=Cl),We=n(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-17i1oe0"&&(V.innerHTML=Wl),Ve=n(e),m(x.$$.fragment,e),xe=n(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-15nvzfz"&&(k.textContent=Vl),ke=n(e),m(X.$$.fragment,e),Xe=n(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1nm8o2l"&&(E.textContent=xl),Ee=n(e),m(A.$$.fragment,e),Ae=n(e),m(S.$$.fragment,e),Se=n(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1pc2g11"&&(R.innerHTML=kl),Re=n(e),m(Q.$$.fragment,e),Qe=n(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-cxbpkk"&&(N.innerHTML=Xl),Ne=n(e),m($.$$.fragment,e),$e=n(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1d3nsxr"&&(_.innerHTML=El),_e=n(e),m(H.$$.fragment,e),He=n(e),m(T.$$.fragment,e),Fe=n(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1hje1na"&&(F.innerHTML=Al),Ye=n(e),m(Y.$$.fragment,e),Le=n(e),m(L.$$.fragment,e),ze=n(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-jxmyui"&&(z.textContent=Sl),qe=n(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-mypgk0"&&(q.innerHTML=Rl),Pe=n(e),P=i(e,"UL",{"data-svelte-h":!0}),M(P)!=="svelte-yebcyg"&&(P.innerHTML=Ql),De=n(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-6hi2wg"&&(D.textContent=Nl),Ke=n(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1oluvmk"&&(K.innerHTML=$l),Oe=n(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-16auxc5"&&(O.innerHTML=_l),el=n(e),m(ee.$$.fragment,e),ll=n(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-w74er7"&&(le.innerHTML=Hl),tl=n(e),m(te.$$.fragment,e),sl=n(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-rcptvg"&&(se.textContent=Fl),al=n(e),m(ae.$$.fragment,e),nl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-14vy74h"&&(ne.textContent=Yl),ol=n(e),m(oe.$$.fragment,e),il=n(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-14hcubr"&&(ie.textContent=Ll),Ml=n(e),m(Me.$$.fragment,e),rl=n(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-4ongu3"&&(re.innerHTML=zl),pl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-42zfmw"&&(pe.innerHTML=ql),ml=n(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-12n1xyx"&&(me.textContent=Pl),ul=n(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-mq5zaw"&&(ue.innerHTML=Dl),cl=n(e),ce=i(e,"UL",{"data-svelte-h":!0}),M(ce)!=="svelte-u8shvx"&&(ce.innerHTML=Kl),yl=n(e),m(ye.$$.fragment,e),dl=n(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-l6tvv1"&&(de.textContent=Ol),wl=n(e),we=i(e,"UL",{"data-svelte-h":!0}),M(we)!=="svelte-16ibgml"&&(we.innerHTML=et),Jl=n(e),m(Je.$$.fragment,e),hl=n(e),Ul=i(e,"HR",{}),Tl=n(e),m(j.$$.fragment,e),jl=n(e),m(he.$$.fragment,e),bl=n(e),Te=i(e,"P",{}),st(Te).forEach(t),this.h()},h(){at(r,"name","hf:doc:metadata"),at(r,"content",Jt)},m(e,l){ut(document.head,r),s(e,h,l),s(e,w,l),s(e,U,l),u(b,e,l),s(e,be,l),s(e,f,l),s(e,fe,l),s(e,I,l),s(e,Ie,l),s(e,g,l),s(e,ge,l),s(e,v,l),s(e,ve,l),u(B,e,l),s(e,Be,l),s(e,G,l),s(e,Ge,l),s(e,Z,l),s(e,Ze,l),u(C,e,l),s(e,Ce,l),s(e,W,l),s(e,We,l),s(e,V,l),s(e,Ve,l),u(x,e,l),s(e,xe,l),s(e,k,l),s(e,ke,l),u(X,e,l),s(e,Xe,l),s(e,E,l),s(e,Ee,l),u(A,e,l),s(e,Ae,l),u(S,e,l),s(e,Se,l),s(e,R,l),s(e,Re,l),u(Q,e,l),s(e,Qe,l),s(e,N,l),s(e,Ne,l),u($,e,l),s(e,$e,l),s(e,_,l),s(e,_e,l),u(H,e,l),s(e,He,l),u(T,e,l),s(e,Fe,l),s(e,F,l),s(e,Ye,l),u(Y,e,l),s(e,Le,l),u(L,e,l),s(e,ze,l),s(e,z,l),s(e,qe,l),s(e,q,l),s(e,Pe,l),s(e,P,l),s(e,De,l),s(e,D,l),s(e,Ke,l),s(e,K,l),s(e,Oe,l),s(e,O,l),s(e,el,l),u(ee,e,l),s(e,ll,l),s(e,le,l),s(e,tl,l),u(te,e,l),s(e,sl,l),s(e,se,l),s(e,al,l),u(ae,e,l),s(e,nl,l),s(e,ne,l),s(e,ol,l),u(oe,e,l),s(e,il,l),s(e,ie,l),s(e,Ml,l),u(Me,e,l),s(e,rl,l),s(e,re,l),s(e,pl,l),s(e,pe,l),s(e,ml,l),s(e,me,l),s(e,ul,l),s(e,ue,l),s(e,cl,l),s(e,ce,l),s(e,yl,l),u(ye,e,l),s(e,dl,l),s(e,de,l),s(e,wl,l),s(e,we,l),s(e,Jl,l),u(Je,e,l),s(e,hl,l),s(e,Ul,l),s(e,Tl,l),u(j,e,l),s(e,jl,l),u(he,e,l),s(e,bl,l),s(e,Te,l),fl=!0},p(e,[l]){const lt={};l&2&&(lt.$$scope={dirty:l,ctx:e}),T.$set(lt);const tt={};l&2&&(tt.$$scope={dirty:l,ctx:e}),j.$set(tt)},i(e){fl||(c(b.$$.fragment,e),c(B.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(A.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c($.$$.fragment,e),c(H.$$.fragment,e),c(T.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(j.$$.fragment,e),c(he.$$.fragment,e),fl=!0)},o(e){y(b.$$.fragment,e),y(B.$$.fragment,e),y(C.$$.fragment,e),y(x.$$.fragment,e),y(X.$$.fragment,e),y(A.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y($.$$.fragment,e),y(H.$$.fragment,e),y(T.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(j.$$.fragment,e),y(he.$$.fragment,e),fl=!1},d(e){e&&(t(h),t(w),t(U),t(be),t(f),t(fe),t(I),t(Ie),t(g),t(ge),t(v),t(ve),t(Be),t(G),t(Ge),t(Z),t(Ze),t(Ce),t(W),t(We),t(V),t(Ve),t(xe),t(k),t(ke),t(Xe),t(E),t(Ee),t(Ae),t(Se),t(R),t(Re),t(Qe),t(N),t(Ne),t($e),t(_),t(_e),t(He),t(Fe),t(F),t(Ye),t(Le),t(ze),t(z),t(qe),t(q),t(Pe),t(P),t(De),t(D),t(Ke),t(K),t(Oe),t(O),t(el),t(ll),t(le),t(tl),t(sl),t(se),t(al),t(nl),t(ne),t(ol),t(il),t(ie),t(Ml),t(rl),t(re),t(pl),t(pe),t(ml),t(me),t(ul),t(ue),t(cl),t(ce),t(yl),t(dl),t(de),t(wl),t(we),t(Jl),t(hl),t(Ul),t(Tl),t(jl),t(bl),t(Te)),t(r),d(b,e),d(B,e),d(C,e),d(x,e),d(X,e),d(A,e),d(S,e),d(Q,e),d($,e),d(H,e),d(T,e),d(Y,e),d(L,e),d(ee,e),d(te,e),d(ae,e),d(oe,e),d(Me,e),d(ye,e),d(Je,e),d(j,e),d(he,e)}}}const Jt='{"title":"Evaluate open LLMs with Vertex AI and Gemini","local":"evaluate-open-llms-with-vertex-ai-and-gemini","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy Llama 3.1 8B on Vertex AI","local":"deploy-llama-31-8b-on-vertex-ai","sections":[],"depth":2},{"title":"Evaluate Llama 3.1 8B using different prompts on Coherence","local":"evaluate-llama-31-8b-using-different-prompts-on-coherence","sections":[],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function ht(Ue){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends rt{constructor(r){super(),pt(this,r,ht,wt,it,{})}}export{It as component};
