import{s as _a,f as Hl,o as Ra,n as Jn}from"../chunks/scheduler.9039eef2.js";import{S as xa,i as $a,g as i,s as n,r as o,A as ka,h as p,f as t,c as a,j as Na,u as r,x as m,k as J,y as Sa,a as s,v as u,d as c,t as M,w as d}from"../chunks/index.cdcc3d35.js";import{T as yn}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function Ya(V){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",w,f,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,w=n(),f=i("p"),f.innerHTML=j},l(g){y=p(g,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),w=a(g),f=p(g,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1dh7n4s"&&(f.innerHTML=j)},m(g,U){s(g,y,U),s(g,w,U),s(g,f,U)},p:Jn,d(g){g&&(t(y),t(w),t(f))}}}function Qa(V){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(w){y=p(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(w,f){s(w,y,f)},p:Jn,d(w){w&&t(y)}}}function Ea(V){let y,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){y=i("p"),y.textContent=T},l(w){y=p(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3zwean"&&(y.textContent=T)},m(w,f){s(w,y,f)},p:Jn,d(w){w&&t(y)}}}function Fa(V){let y,T,w,f,j,g,U,Ll,R,hn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',ql,x,bn="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",Al,$,wn='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',Dl,k,Pl,S,Kl,Y,fn="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",Ol,Q,gn="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",et,E,Tn="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",lt,F,Un="<strong><em>Export via CLI</em></strong>",tt,H,jn="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",st,z,nt,L,Zn="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",at,q,Wn="<strong><em>Export via Python API</em></strong>",it,A,In="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",pt,v,mt,D,ot,P,rt,K,Gn="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",ut,O,Xn="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",ct,ee,Mt,Z,Bn,dt,le,yt,te,Cn="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",Jt,se,ht,ne,Vn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',bt,ae,wt,ie,vn="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",ft,pe,gt,me,Nn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Tt,oe,Ut,re,_n="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",jt,ue,Zt,ce,Rn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',Wt,Me,It,de,xn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',Gt,ye,$n="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",Xt,Je,Bt,he,kn="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Ct,be,Sn="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Vt,we,Yn="<strong><em>Export via CLI</em></strong>",vt,fe,Qn="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",Nt,ge,_t,Te,En="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Rt,Ue,Fn="<strong><em>Export via Python API</em></strong>",xt,je,Hn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",$t,Ze,kt,We,St,Ie,zn="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Yt,Ge,Qt,W,Ln,Et,Xe,Ft,Be,qn="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",Ht,Ce,zt,Ve,An='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',Lt,ve,qt,Ne,Dn="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",At,_e,Dt,Re,Pn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Pt,xe,Kt,$e,Kn='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',Ot,ke,On="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",es,Se,ls,Ye,ts,I,ea,ss,Qe,ns,Ee,as,Fe,la='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',is,N,ps,He,ms,ze,ta='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',os,Le,sa="In <code>optimum-neuron</code>, you can:",rs,qe,na="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",us,Ae,aa='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',cs,De,Ms,Pe,ia="<strong><em>LCM of Stable Diffusion</em></strong>",ds,Ke,ys,Oe,pa="<strong><em>LCM of Stable Diffusion XL</em></strong>",Js,el,hs,ll,bs,tl,ma="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",ws,sl,oa="<strong><em>LCM of Stable Diffusion</em></strong>",fs,nl,gs,al,ra="<strong><em>LCM of Stable Diffusion XL</em></strong>",Ts,il,Us,pl,js,ml,ua='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',Zs,ol,ca="In <code>optimum-neuron</code>, you can:",Ws,rl,Ma="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",Is,ul,da='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',Gs,cl,Xs,Ml,Bs,dl,Cs,yl,ya="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Vs,Jl,vs,_,Ns,hl,_s,bl,Rs,wl,Ja="Low-Rank Adaptation is fast way to Stable Diffusion to adapt styles of generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",xs,fl,$s,G,ha,ks,gl,Ss,Tl,ba="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. The you can use the compiled artifacts to generate styled images.",Ys,Ul,Qs,jl,wa="We can either compile one or multiple ControlNet via the Optimum CLI or programatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",Es,Zl,fa="<li>Export via the Optimum CLI</li>",Fs,Wl,Hs,Il,ga="<li>Export via Python API</li>",zs,Gl,Ls,Xl,qs,Bl,Ta="For text-to-image, we can specify an additional conditioning input.",As,Cl,Ua="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",Ds,Vl,Ps,X,ja,Ks,vl,Os,Nl,Za="With Optimum Neuron, you can also compose multiple ControlNet conditionings from different image inputs:",en,_l,Wa="<li>Compile multiple ControlNet for SD1.5</li>",ln,Rl,tn,xl,Ia="<li>Run SD1.5 with OpenPose and Depth conditionings:</li>",sn,$l,nn,B,Ga,an,kl,pn,Sl,mn,Yl,on,Ql,rn,El,un,C,Xa,cn,Fl,Ba='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Mn,zl,dn;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),k=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),S=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),z=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwNTEyJTIwJTYwJTIzJTIwaGVpZ2h0JTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDUxMiUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjA0JTIwJTYwJTIzJTIwbnVtYmVyJTIwb2YlMjBpbWFnZXMlMjB0byUyMGdlbmVyYXRlJTIwcGVyJTIwcHJvbXB0JTJDJTIwZGVmYXVsdHMlMjB0byUyMDElNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMCU2MCUyMyUyMGNhc3QlMjBvbmx5JTIwbWF0cml4JTIwbXVsdGlwbGljYXRpb24lMjBvcGVyYXRpb25zJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAlNjAlMjMlMjBjYXN0JTIwb3BlcmF0aW9ucyUyMGZyb20lMjBGUDMyJTIwdG8lMjBCRjE2JTYwJTIwJTVDJTBBJTIwJTIwc2RfbmV1cm9uJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),v=new yn({props:{$$slots:{default:[Ya]},$$scope:{ctx:V}}}),D=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),ee=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),le=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),se=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),ae=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),pe=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),oe=new h({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h3"}}),ue=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),Me=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),Je=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),ge=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwMTAyNCUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLXdpZHRoJTIwMTAyNCUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNzY4JTJDJTIwMTAyNCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbl94bCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),Ze=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),We=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Ge=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Xe=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Ce=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),_e=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),xe=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Se=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Ye=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Qe=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Ee=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new yn({props:{$$slots:{default:[Qa]},$$scope:{ctx:V}}}),He=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),De=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Ke=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),el=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),ll=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),nl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),il=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),pl=new h({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),cl=new h({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),Ml=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjBzZHhsX3R1cmJvX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),dl=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Jl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),_=new yn({props:{$$slots:{default:[Ea]},$$scope:{ctx:V}}}),hl=new h({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),bl=new h({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),fl=new b({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),gl=new h({props:{title:"ControlNet",local:"controlnet",headingTag:"h2"}}),Ul=new h({props:{title:"Compile ControlNet",local:"compile-controlnet",headingTag:"h3"}}),Wl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tY29udHJvbG5ldF9pZHMlMjBsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkX25ldXJvbl9jb250cm9sbmV0JTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m runwayml/stable-diffusion-v1-5 --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),Gl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXRfaWQlMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUwQSUwQSUyMyUyMCU1Qk5ldXJvbiU1RCUyMHBpcGVsaW5lJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2lkcyUzRGNvbnRyb2xuZXRfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfbmV1cm9uX2NvbnRyb2xuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),Xl=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Vl=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),vl=new h({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h3"}}),Rl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLWlubGluZS13ZWlnaHRzLW5lZmYlMjAtLW1vZGVsJTIwanlvdW5nMTA1JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwLS1jb250cm9sbmV0X2lkcyUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9vcGVucG9zZSUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMWYxcF9zZDE1X2RlcHRoJTIwLS1oZWlnaHQlMjA1MTIlMjAtLXdpZHRoJTIwNTEyJTIwc2QxNS01MTJ4NTEyLWJmMTYtb3BlbnBvc2UtZGVwdGg=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --inline-weights-neff --model jyoung105/stable-diffusion-v1-5 --task stable-diffusion --auto_cast matmul --auto_cast_type bf16 --batch_size 1 --num_images_per_prompt 1 --controlnet_ids lllyasviel/control_v11p_sd15_openpose lllyasviel/control_v11f1p_sd15_depth --height 512 --width 512 sd15-512x512-bf16-openpose-depth',wrap:!1}}),$l=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># OpenPose+Depth ControlNet</span>
model_id = <span class="hljs-string">&quot;sd15-512x512-bf16-openpose-depth&quot;</span>

<span class="hljs-comment"># Load ControlNet images</span>

<span class="hljs-comment"># 1. openpose</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_openpose/resolve/main/images/input.png&quot;</span>)
processor = OpenposeDetector.from_pretrained(<span class="hljs-string">&#x27;lllyasviel/ControlNet&#x27;</span>)
openpose_image = processor(image)

<span class="hljs-comment"># 2. depth</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_depth/resolve/main/images/input.png&quot;</span>)
depth_estimator = pipeline(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>)
image = depth_estimator(image)[<span class="hljs-string">&#x27;depth&#x27;</span>]
image = np.array(image)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
depth_image = Image.fromarray(image)

images = [openpose_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), depth_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))]

<span class="hljs-comment"># 3. inference</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(model_id)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
prompt = <span class="hljs-string">&quot;a giant in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

image = pipe(prompt=prompt, image=images).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;out.png&#x27;</span>)`,wrap:!1}}),kl=new h({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),Sl=new h({props:{title:"Compile",local:"compile",headingTag:"h3"}}),Yl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0tdGFzayUyMHN0YWJsZS1kaWZmdXNpb24teGwlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjAxMDI0JTIwLS13aWR0aCUyMDEwMjQlMjAtLWNvbnRyb2xuZXRfaWRzJTIwZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMC1zbWFsbCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stabilityai/stable-diffusion-xl-base-1.0 --task stable-diffusion-xl --batch_size 1 --height 1024 --width 1024 --controlnet_ids diffusers/controlnet-canny-sdxl-1.0-small --num_images_per_prompt 1 sdxl_neuron_controlnet/',wrap:!1}}),Ql=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),El=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMElucHV0cyUwQXByb21wdCUyMCUzRCUyMCUyMmFlcmlhbCUyMHZpZXclMkMlMjBhJTIwZnV0dXJpc3RpYyUyMHJlc2VhcmNoJTIwY29tcGxleCUyMGluJTIwYSUyMGJyaWdodCUyMGZvZ2d5JTIwanVuZ2xlJTJDJTIwaGFyZCUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmhmLWxvZ28ucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUwQWNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBnb29kJTIwZ2VuZXJhbGl6YXRpb24lMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMjIpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmh1Z19sYWIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLControlNetPipeline

<span class="hljs-comment"># Inputs</span>
prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)
image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
image = Image.fromarray(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

pipe = NeuronStableDiffusionXLControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_neuron_controlnet&quot;</span>)

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;hug_lab.png&quot;</span>)`,wrap:!1}}),{c(){y=i("meta"),T=n(),w=i("p"),f=n(),o(j.$$.fragment),g=n(),o(U.$$.fragment),Ll=n(),R=i("p"),R.innerHTML=hn,ql=n(),x=i("p"),x.innerHTML=bn,Al=n(),$=i("p"),$.innerHTML=wn,Dl=n(),o(k.$$.fragment),Pl=n(),o(S.$$.fragment),Kl=n(),Y=i("p"),Y.innerHTML=fn,Ol=n(),Q=i("ul"),Q.innerHTML=gn,et=n(),E=i("p"),E.innerHTML=Tn,lt=n(),F=i("p"),F.innerHTML=Un,tt=n(),H=i("p"),H.innerHTML=jn,st=n(),o(z.$$.fragment),nt=n(),L=i("p"),L.innerHTML=Zn,at=n(),q=i("p"),q.innerHTML=Wn,it=n(),A=i("p"),A.innerHTML=In,pt=n(),o(v.$$.fragment),mt=n(),o(D.$$.fragment),ot=n(),o(P.$$.fragment),rt=n(),K=i("p"),K.innerHTML=Gn,ut=n(),O=i("p"),O.textContent=Xn,ct=n(),o(ee.$$.fragment),Mt=n(),Z=i("img"),dt=n(),o(le.$$.fragment),yt=n(),te=i("p"),te.innerHTML=Cn,Jt=n(),o(se.$$.fragment),ht=n(),ne=i("table"),ne.innerHTML=Vn,bt=n(),o(ae.$$.fragment),wt=n(),ie=i("p"),ie.innerHTML=vn,ft=n(),o(pe.$$.fragment),gt=n(),me=i("table"),me.innerHTML=Nn,Tt=n(),o(oe.$$.fragment),Ut=n(),re=i("p"),re.innerHTML=_n,jt=n(),o(ue.$$.fragment),Zt=n(),ce=i("table"),ce.innerHTML=Rn,Wt=n(),o(Me.$$.fragment),It=n(),de=i("p"),de.innerHTML=xn,Gt=n(),ye=i("p"),ye.textContent=$n,Xt=n(),o(Je.$$.fragment),Bt=n(),he=i("p"),he.textContent=kn,Ct=n(),be=i("ul"),be.innerHTML=Sn,Vt=n(),we=i("p"),we.innerHTML=Yn,vt=n(),fe=i("p"),fe.innerHTML=Qn,Nt=n(),o(ge.$$.fragment),_t=n(),Te=i("p"),Te.innerHTML=En,Rt=n(),Ue=i("p"),Ue.innerHTML=Fn,xt=n(),je=i("p"),je.innerHTML=Hn,$t=n(),o(Ze.$$.fragment),kt=n(),o(We.$$.fragment),St=n(),Ie=i("p"),Ie.textContent=zn,Yt=n(),o(Ge.$$.fragment),Qt=n(),W=i("img"),Et=n(),o(Xe.$$.fragment),Ft=n(),Be=i("p"),Be.innerHTML=qn,Ht=n(),o(Ce.$$.fragment),zt=n(),Ve=i("table"),Ve.innerHTML=An,Lt=n(),o(ve.$$.fragment),qt=n(),Ne=i("p"),Ne.innerHTML=Dn,At=n(),o(_e.$$.fragment),Dt=n(),Re=i("table"),Re.innerHTML=Pn,Pt=n(),o(xe.$$.fragment),Kt=n(),$e=i("p"),$e.innerHTML=Kn,Ot=n(),ke=i("ol"),ke.innerHTML=On,es=n(),o(Se.$$.fragment),ls=n(),o(Ye.$$.fragment),ts=n(),I=i("img"),ss=n(),o(Qe.$$.fragment),ns=n(),o(Ee.$$.fragment),as=n(),Fe=i("table"),Fe.innerHTML=la,is=n(),o(N.$$.fragment),ps=n(),o(He.$$.fragment),ms=n(),ze=i("p"),ze.innerHTML=ta,os=n(),Le=i("p"),Le.innerHTML=sa,rs=n(),qe=i("ul"),qe.innerHTML=na,us=n(),Ae=i("p"),Ae.innerHTML=aa,cs=n(),o(De.$$.fragment),Ms=n(),Pe=i("p"),Pe.innerHTML=ia,ds=n(),o(Ke.$$.fragment),ys=n(),Oe=i("p"),Oe.innerHTML=pa,Js=n(),o(el.$$.fragment),hs=n(),o(ll.$$.fragment),bs=n(),tl=i("p"),tl.textContent=ma,ws=n(),sl=i("p"),sl.innerHTML=oa,fs=n(),o(nl.$$.fragment),gs=n(),al=i("p"),al.innerHTML=ra,Ts=n(),o(il.$$.fragment),Us=n(),o(pl.$$.fragment),js=n(),ml=i("p"),ml.innerHTML=ua,Zs=n(),ol=i("p"),ol.innerHTML=ca,Ws=n(),rl=i("ul"),rl.innerHTML=Ma,Is=n(),ul=i("p"),ul.innerHTML=da,Gs=n(),o(cl.$$.fragment),Xs=n(),o(Ml.$$.fragment),Bs=n(),o(dl.$$.fragment),Cs=n(),yl=i("p"),yl.textContent=ya,Vs=n(),o(Jl.$$.fragment),vs=n(),o(_.$$.fragment),Ns=n(),o(hl.$$.fragment),_s=n(),o(bl.$$.fragment),Rs=n(),wl=i("p"),wl.textContent=Ja,xs=n(),o(fl.$$.fragment),$s=n(),G=i("img"),ks=n(),o(gl.$$.fragment),Ss=n(),Tl=i("p"),Tl.textContent=ba,Ys=n(),o(Ul.$$.fragment),Qs=n(),jl=i("p"),jl.innerHTML=wa,Es=n(),Zl=i("ul"),Zl.innerHTML=fa,Fs=n(),o(Wl.$$.fragment),Hs=n(),Il=i("ul"),Il.innerHTML=ga,zs=n(),o(Gl.$$.fragment),Ls=n(),o(Xl.$$.fragment),qs=n(),Bl=i("p"),Bl.textContent=Ta,As=n(),Cl=i("p"),Cl.textContent=Ua,Ds=n(),o(Vl.$$.fragment),Ps=n(),X=i("img"),Ks=n(),o(vl.$$.fragment),Os=n(),Nl=i("p"),Nl.textContent=Za,en=n(),_l=i("ul"),_l.innerHTML=Wa,ln=n(),o(Rl.$$.fragment),tn=n(),xl=i("ul"),xl.innerHTML=Ia,sn=n(),o($l.$$.fragment),nn=n(),B=i("img"),an=n(),o(kl.$$.fragment),pn=n(),o(Sl.$$.fragment),mn=n(),o(Yl.$$.fragment),on=n(),o(Ql.$$.fragment),rn=n(),o(El.$$.fragment),un=n(),C=i("img"),cn=n(),Fl=i("p"),Fl.innerHTML=Ba,Mn=n(),zl=i("p"),this.h()},l(e){const l=ka("svelte-u9bgzb",document.head);y=p(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),w=p(e,"P",{}),Na(w).forEach(t),f=a(e),r(j.$$.fragment,e),g=a(e),r(U.$$.fragment,e),Ll=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-140c11v"&&(R.innerHTML=hn),ql=a(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1g87d8z"&&(x.innerHTML=bn),Al=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1u4t7n7"&&($.innerHTML=wn),Dl=a(e),r(k.$$.fragment,e),Pl=a(e),r(S.$$.fragment,e),Kl=a(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-3qllio"&&(Y.innerHTML=fn),Ol=a(e),Q=p(e,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-1c1t3y0"&&(Q.innerHTML=gn),et=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-15y00oa"&&(E.innerHTML=Tn),lt=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1a2m8iq"&&(F.innerHTML=Un),tt=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ktaj8q"&&(H.innerHTML=jn),st=a(e),r(z.$$.fragment,e),nt=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-jz092x"&&(L.innerHTML=Zn),at=a(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-kxhd34"&&(q.innerHTML=Wn),it=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1bahy14"&&(A.innerHTML=In),pt=a(e),r(v.$$.fragment,e),mt=a(e),r(D.$$.fragment,e),ot=a(e),r(P.$$.fragment,e),rt=a(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1r61oa5"&&(K.innerHTML=Gn),ut=a(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1q8fgqb"&&(O.textContent=Xn),ct=a(e),r(ee.$$.fragment,e),Mt=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),dt=a(e),r(le.$$.fragment,e),yt=a(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-kqnotf"&&(te.innerHTML=Cn),Jt=a(e),r(se.$$.fragment,e),ht=a(e),ne=p(e,"TABLE",{"data-svelte-h":!0}),m(ne)!=="svelte-i6e2ex"&&(ne.innerHTML=Vn),bt=a(e),r(ae.$$.fragment,e),wt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-vhijyl"&&(ie.innerHTML=vn),ft=a(e),r(pe.$$.fragment,e),gt=a(e),me=p(e,"TABLE",{"data-svelte-h":!0}),m(me)!=="svelte-v8z5s8"&&(me.innerHTML=Nn),Tt=a(e),r(oe.$$.fragment,e),Ut=a(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1836mxv"&&(re.innerHTML=_n),jt=a(e),r(ue.$$.fragment,e),Zt=a(e),ce=p(e,"TABLE",{"data-svelte-h":!0}),m(ce)!=="svelte-w6yzym"&&(ce.innerHTML=Rn),Wt=a(e),r(Me.$$.fragment,e),It=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1q6nuso"&&(de.innerHTML=xn),Gt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-7xctqf"&&(ye.textContent=$n),Xt=a(e),r(Je.$$.fragment,e),Bt=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-u4wwem"&&(he.textContent=kn),Ct=a(e),be=p(e,"UL",{"data-svelte-h":!0}),m(be)!=="svelte-17e9k9s"&&(be.innerHTML=Sn),Vt=a(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1a2m8iq"&&(we.innerHTML=Yn),vt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-9niqj3"&&(fe.innerHTML=Qn),Nt=a(e),r(ge.$$.fragment,e),_t=a(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-eias7g"&&(Te.innerHTML=En),Rt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-kxhd34"&&(Ue.innerHTML=Fn),xt=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-17tzr0c"&&(je.innerHTML=Hn),$t=a(e),r(Ze.$$.fragment,e),kt=a(e),r(We.$$.fragment,e),St=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-8q3qyn"&&(Ie.textContent=zn),Yt=a(e),r(Ge.$$.fragment,e),Qt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Et=a(e),r(Xe.$$.fragment,e),Ft=a(e),Be=p(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-luub4o"&&(Be.innerHTML=qn),Ht=a(e),r(Ce.$$.fragment,e),zt=a(e),Ve=p(e,"TABLE",{"data-svelte-h":!0}),m(Ve)!=="svelte-1s0d0pv"&&(Ve.innerHTML=An),Lt=a(e),r(ve.$$.fragment,e),qt=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-11fbw00"&&(Ne.innerHTML=Dn),At=a(e),r(_e.$$.fragment,e),Dt=a(e),Re=p(e,"TABLE",{"data-svelte-h":!0}),m(Re)!=="svelte-18741xe"&&(Re.innerHTML=Pn),Pt=a(e),r(xe.$$.fragment,e),Kt=a(e),$e=p(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1usq821"&&($e.innerHTML=Kn),Ot=a(e),ke=p(e,"OL",{"data-svelte-h":!0}),m(ke)!=="svelte-6p4eqi"&&(ke.innerHTML=On),es=a(e),r(Se.$$.fragment,e),ls=a(e),r(Ye.$$.fragment,e),ts=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ss=a(e),r(Qe.$$.fragment,e),ns=a(e),r(Ee.$$.fragment,e),as=a(e),Fe=p(e,"TABLE",{"data-svelte-h":!0}),m(Fe)!=="svelte-1s7g03c"&&(Fe.innerHTML=la),is=a(e),r(N.$$.fragment,e),ps=a(e),r(He.$$.fragment,e),ms=a(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1ud6a8q"&&(ze.innerHTML=ta),os=a(e),Le=p(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-1ayizu6"&&(Le.innerHTML=sa),rs=a(e),qe=p(e,"UL",{"data-svelte-h":!0}),m(qe)!=="svelte-r4tdj0"&&(qe.innerHTML=na),us=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-c4lhmw"&&(Ae.innerHTML=aa),cs=a(e),r(De.$$.fragment,e),Ms=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-1s0vvjb"&&(Pe.innerHTML=ia),ds=a(e),r(Ke.$$.fragment,e),ys=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-51zp7x"&&(Oe.innerHTML=pa),Js=a(e),r(el.$$.fragment,e),hs=a(e),r(ll.$$.fragment,e),bs=a(e),tl=p(e,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-1ebkvay"&&(tl.textContent=ma),ws=a(e),sl=p(e,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-1s0vvjb"&&(sl.innerHTML=oa),fs=a(e),r(nl.$$.fragment,e),gs=a(e),al=p(e,"P",{"data-svelte-h":!0}),m(al)!=="svelte-51zp7x"&&(al.innerHTML=ra),Ts=a(e),r(il.$$.fragment,e),Us=a(e),r(pl.$$.fragment,e),js=a(e),ml=p(e,"P",{"data-svelte-h":!0}),m(ml)!=="svelte-10h80ju"&&(ml.innerHTML=ua),Zs=a(e),ol=p(e,"P",{"data-svelte-h":!0}),m(ol)!=="svelte-1ayizu6"&&(ol.innerHTML=ca),Ws=a(e),rl=p(e,"UL",{"data-svelte-h":!0}),m(rl)!=="svelte-t7g18i"&&(rl.innerHTML=Ma),Is=a(e),ul=p(e,"P",{"data-svelte-h":!0}),m(ul)!=="svelte-ohwj0a"&&(ul.innerHTML=da),Gs=a(e),r(cl.$$.fragment,e),Xs=a(e),r(Ml.$$.fragment,e),Bs=a(e),r(dl.$$.fragment,e),Cs=a(e),yl=p(e,"P",{"data-svelte-h":!0}),m(yl)!=="svelte-1ebkvay"&&(yl.textContent=ya),Vs=a(e),r(Jl.$$.fragment,e),vs=a(e),r(_.$$.fragment,e),Ns=a(e),r(hl.$$.fragment,e),_s=a(e),r(bl.$$.fragment,e),Rs=a(e),wl=p(e,"P",{"data-svelte-h":!0}),m(wl)!=="svelte-k1lsm0"&&(wl.textContent=Ja),xs=a(e),r(fl.$$.fragment,e),$s=a(e),G=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ks=a(e),r(gl.$$.fragment,e),Ss=a(e),Tl=p(e,"P",{"data-svelte-h":!0}),m(Tl)!=="svelte-15r2htw"&&(Tl.textContent=ba),Ys=a(e),r(Ul.$$.fragment,e),Qs=a(e),jl=p(e,"P",{"data-svelte-h":!0}),m(jl)!=="svelte-clsbw5"&&(jl.innerHTML=wa),Es=a(e),Zl=p(e,"UL",{"data-svelte-h":!0}),m(Zl)!=="svelte-127fndl"&&(Zl.innerHTML=fa),Fs=a(e),r(Wl.$$.fragment,e),Hs=a(e),Il=p(e,"UL",{"data-svelte-h":!0}),m(Il)!=="svelte-zxjvv9"&&(Il.innerHTML=ga),zs=a(e),r(Gl.$$.fragment,e),Ls=a(e),r(Xl.$$.fragment,e),qs=a(e),Bl=p(e,"P",{"data-svelte-h":!0}),m(Bl)!=="svelte-92hvy2"&&(Bl.textContent=Ta),As=a(e),Cl=p(e,"P",{"data-svelte-h":!0}),m(Cl)!=="svelte-e5xot3"&&(Cl.textContent=Ua),Ds=a(e),r(Vl.$$.fragment,e),Ps=a(e),X=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ks=a(e),r(vl.$$.fragment,e),Os=a(e),Nl=p(e,"P",{"data-svelte-h":!0}),m(Nl)!=="svelte-ve8s8f"&&(Nl.textContent=Za),en=a(e),_l=p(e,"UL",{"data-svelte-h":!0}),m(_l)!=="svelte-16kkb80"&&(_l.innerHTML=Wa),ln=a(e),r(Rl.$$.fragment,e),tn=a(e),xl=p(e,"UL",{"data-svelte-h":!0}),m(xl)!=="svelte-1pbmybe"&&(xl.innerHTML=Ia),sn=a(e),r($l.$$.fragment,e),nn=a(e),B=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),an=a(e),r(kl.$$.fragment,e),pn=a(e),r(Sl.$$.fragment,e),mn=a(e),r(Yl.$$.fragment,e),on=a(e),r(Ql.$$.fragment,e),rn=a(e),r(El.$$.fragment,e),un=a(e),C=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),cn=a(e),Fl=p(e,"P",{"data-svelte-h":!0}),m(Fl)!=="svelte-xbi604"&&(Fl.innerHTML=Ba),Mn=a(e),zl=p(e,"P",{}),Na(zl).forEach(t),this.h()},h(){J(y,"name","hf:doc:metadata"),J(y,"content",Ha),Hl(Z.src,Bn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||J(Z,"src",Bn),J(Z,"width","256"),J(Z,"height","256"),J(Z,"alt","stable diffusion generated image"),Hl(W.src,Ln="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||J(W,"src",Ln),J(W,"width","256"),J(W,"height","256"),J(W,"alt","sdxl generated image"),Hl(I.src,ea="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||J(I,"src",ea),J(I,"width","256"),J(I,"height","256"),J(I,"alt","sdxl base + refiner"),Hl(G.src,ha="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||J(G,"src",ha),J(G,"width","256"),J(G,"height","256"),J(G,"alt","stable diffusion generated image with LoRA adapter."),Hl(X.src,ja="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||J(X,"src",ja),J(X,"width","768"),J(X,"height","256"),J(X,"alt","stable diffusion 1.5 generated image with controlnet."),Hl(B.src,Ga="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/multicontrolnet.png")||J(B,"src",Ga),J(B,"width","768"),J(B,"height","256"),J(B,"alt","stable diffusion 1.5 generated image with OpenPose and Depth controlnet."),Hl(C.src,Xa="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/12-sdxl-text2img-controlnet.png?download=true")||J(C,"src",Xa),J(C,"width","768"),J(C,"height","256"),J(C,"alt","stable diffusion xl generated image with controlnet.")},m(e,l){Sa(document.head,y),s(e,T,l),s(e,w,l),s(e,f,l),u(j,e,l),s(e,g,l),u(U,e,l),s(e,Ll,l),s(e,R,l),s(e,ql,l),s(e,x,l),s(e,Al,l),s(e,$,l),s(e,Dl,l),u(k,e,l),s(e,Pl,l),u(S,e,l),s(e,Kl,l),s(e,Y,l),s(e,Ol,l),s(e,Q,l),s(e,et,l),s(e,E,l),s(e,lt,l),s(e,F,l),s(e,tt,l),s(e,H,l),s(e,st,l),u(z,e,l),s(e,nt,l),s(e,L,l),s(e,at,l),s(e,q,l),s(e,it,l),s(e,A,l),s(e,pt,l),u(v,e,l),s(e,mt,l),u(D,e,l),s(e,ot,l),u(P,e,l),s(e,rt,l),s(e,K,l),s(e,ut,l),s(e,O,l),s(e,ct,l),u(ee,e,l),s(e,Mt,l),s(e,Z,l),s(e,dt,l),u(le,e,l),s(e,yt,l),s(e,te,l),s(e,Jt,l),u(se,e,l),s(e,ht,l),s(e,ne,l),s(e,bt,l),u(ae,e,l),s(e,wt,l),s(e,ie,l),s(e,ft,l),u(pe,e,l),s(e,gt,l),s(e,me,l),s(e,Tt,l),u(oe,e,l),s(e,Ut,l),s(e,re,l),s(e,jt,l),u(ue,e,l),s(e,Zt,l),s(e,ce,l),s(e,Wt,l),u(Me,e,l),s(e,It,l),s(e,de,l),s(e,Gt,l),s(e,ye,l),s(e,Xt,l),u(Je,e,l),s(e,Bt,l),s(e,he,l),s(e,Ct,l),s(e,be,l),s(e,Vt,l),s(e,we,l),s(e,vt,l),s(e,fe,l),s(e,Nt,l),u(ge,e,l),s(e,_t,l),s(e,Te,l),s(e,Rt,l),s(e,Ue,l),s(e,xt,l),s(e,je,l),s(e,$t,l),u(Ze,e,l),s(e,kt,l),u(We,e,l),s(e,St,l),s(e,Ie,l),s(e,Yt,l),u(Ge,e,l),s(e,Qt,l),s(e,W,l),s(e,Et,l),u(Xe,e,l),s(e,Ft,l),s(e,Be,l),s(e,Ht,l),u(Ce,e,l),s(e,zt,l),s(e,Ve,l),s(e,Lt,l),u(ve,e,l),s(e,qt,l),s(e,Ne,l),s(e,At,l),u(_e,e,l),s(e,Dt,l),s(e,Re,l),s(e,Pt,l),u(xe,e,l),s(e,Kt,l),s(e,$e,l),s(e,Ot,l),s(e,ke,l),s(e,es,l),u(Se,e,l),s(e,ls,l),u(Ye,e,l),s(e,ts,l),s(e,I,l),s(e,ss,l),u(Qe,e,l),s(e,ns,l),u(Ee,e,l),s(e,as,l),s(e,Fe,l),s(e,is,l),u(N,e,l),s(e,ps,l),u(He,e,l),s(e,ms,l),s(e,ze,l),s(e,os,l),s(e,Le,l),s(e,rs,l),s(e,qe,l),s(e,us,l),s(e,Ae,l),s(e,cs,l),u(De,e,l),s(e,Ms,l),s(e,Pe,l),s(e,ds,l),u(Ke,e,l),s(e,ys,l),s(e,Oe,l),s(e,Js,l),u(el,e,l),s(e,hs,l),u(ll,e,l),s(e,bs,l),s(e,tl,l),s(e,ws,l),s(e,sl,l),s(e,fs,l),u(nl,e,l),s(e,gs,l),s(e,al,l),s(e,Ts,l),u(il,e,l),s(e,Us,l),u(pl,e,l),s(e,js,l),s(e,ml,l),s(e,Zs,l),s(e,ol,l),s(e,Ws,l),s(e,rl,l),s(e,Is,l),s(e,ul,l),s(e,Gs,l),u(cl,e,l),s(e,Xs,l),u(Ml,e,l),s(e,Bs,l),u(dl,e,l),s(e,Cs,l),s(e,yl,l),s(e,Vs,l),u(Jl,e,l),s(e,vs,l),u(_,e,l),s(e,Ns,l),u(hl,e,l),s(e,_s,l),u(bl,e,l),s(e,Rs,l),s(e,wl,l),s(e,xs,l),u(fl,e,l),s(e,$s,l),s(e,G,l),s(e,ks,l),u(gl,e,l),s(e,Ss,l),s(e,Tl,l),s(e,Ys,l),u(Ul,e,l),s(e,Qs,l),s(e,jl,l),s(e,Es,l),s(e,Zl,l),s(e,Fs,l),u(Wl,e,l),s(e,Hs,l),s(e,Il,l),s(e,zs,l),u(Gl,e,l),s(e,Ls,l),u(Xl,e,l),s(e,qs,l),s(e,Bl,l),s(e,As,l),s(e,Cl,l),s(e,Ds,l),u(Vl,e,l),s(e,Ps,l),s(e,X,l),s(e,Ks,l),u(vl,e,l),s(e,Os,l),s(e,Nl,l),s(e,en,l),s(e,_l,l),s(e,ln,l),u(Rl,e,l),s(e,tn,l),s(e,xl,l),s(e,sn,l),u($l,e,l),s(e,nn,l),s(e,B,l),s(e,an,l),u(kl,e,l),s(e,pn,l),u(Sl,e,l),s(e,mn,l),u(Yl,e,l),s(e,on,l),u(Ql,e,l),s(e,rn,l),u(El,e,l),s(e,un,l),s(e,C,l),s(e,cn,l),s(e,Fl,l),s(e,Mn,l),s(e,zl,l),dn=!0},p(e,[l]){const Ca={};l&2&&(Ca.$$scope={dirty:l,ctx:e}),v.$set(Ca);const Va={};l&2&&(Va.$$scope={dirty:l,ctx:e}),N.$set(Va);const va={};l&2&&(va.$$scope={dirty:l,ctx:e}),_.$set(va)},i(e){dn||(c(j.$$.fragment,e),c(U.$$.fragment,e),c(k.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(v.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(Me.$$.fragment,e),c(Je.$$.fragment,e),c(ge.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(Xe.$$.fragment,e),c(Ce.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(xe.$$.fragment,e),c(Se.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),c(Ee.$$.fragment,e),c(N.$$.fragment,e),c(He.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(el.$$.fragment,e),c(ll.$$.fragment,e),c(nl.$$.fragment,e),c(il.$$.fragment,e),c(pl.$$.fragment,e),c(cl.$$.fragment,e),c(Ml.$$.fragment,e),c(dl.$$.fragment,e),c(Jl.$$.fragment,e),c(_.$$.fragment,e),c(hl.$$.fragment,e),c(bl.$$.fragment,e),c(fl.$$.fragment,e),c(gl.$$.fragment,e),c(Ul.$$.fragment,e),c(Wl.$$.fragment,e),c(Gl.$$.fragment,e),c(Xl.$$.fragment,e),c(Vl.$$.fragment,e),c(vl.$$.fragment,e),c(Rl.$$.fragment,e),c($l.$$.fragment,e),c(kl.$$.fragment,e),c(Sl.$$.fragment,e),c(Yl.$$.fragment,e),c(Ql.$$.fragment,e),c(El.$$.fragment,e),dn=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M(k.$$.fragment,e),M(S.$$.fragment,e),M(z.$$.fragment,e),M(v.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(ue.$$.fragment,e),M(Me.$$.fragment,e),M(Je.$$.fragment,e),M(ge.$$.fragment,e),M(Ze.$$.fragment,e),M(We.$$.fragment,e),M(Ge.$$.fragment,e),M(Xe.$$.fragment,e),M(Ce.$$.fragment,e),M(ve.$$.fragment,e),M(_e.$$.fragment,e),M(xe.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(Qe.$$.fragment,e),M(Ee.$$.fragment,e),M(N.$$.fragment,e),M(He.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(el.$$.fragment,e),M(ll.$$.fragment,e),M(nl.$$.fragment,e),M(il.$$.fragment,e),M(pl.$$.fragment,e),M(cl.$$.fragment,e),M(Ml.$$.fragment,e),M(dl.$$.fragment,e),M(Jl.$$.fragment,e),M(_.$$.fragment,e),M(hl.$$.fragment,e),M(bl.$$.fragment,e),M(fl.$$.fragment,e),M(gl.$$.fragment,e),M(Ul.$$.fragment,e),M(Wl.$$.fragment,e),M(Gl.$$.fragment,e),M(Xl.$$.fragment,e),M(Vl.$$.fragment,e),M(vl.$$.fragment,e),M(Rl.$$.fragment,e),M($l.$$.fragment,e),M(kl.$$.fragment,e),M(Sl.$$.fragment,e),M(Yl.$$.fragment,e),M(Ql.$$.fragment,e),M(El.$$.fragment,e),dn=!1},d(e){e&&(t(T),t(w),t(f),t(g),t(Ll),t(R),t(ql),t(x),t(Al),t($),t(Dl),t(Pl),t(Kl),t(Y),t(Ol),t(Q),t(et),t(E),t(lt),t(F),t(tt),t(H),t(st),t(nt),t(L),t(at),t(q),t(it),t(A),t(pt),t(mt),t(ot),t(rt),t(K),t(ut),t(O),t(ct),t(Mt),t(Z),t(dt),t(yt),t(te),t(Jt),t(ht),t(ne),t(bt),t(wt),t(ie),t(ft),t(gt),t(me),t(Tt),t(Ut),t(re),t(jt),t(Zt),t(ce),t(Wt),t(It),t(de),t(Gt),t(ye),t(Xt),t(Bt),t(he),t(Ct),t(be),t(Vt),t(we),t(vt),t(fe),t(Nt),t(_t),t(Te),t(Rt),t(Ue),t(xt),t(je),t($t),t(kt),t(St),t(Ie),t(Yt),t(Qt),t(W),t(Et),t(Ft),t(Be),t(Ht),t(zt),t(Ve),t(Lt),t(qt),t(Ne),t(At),t(Dt),t(Re),t(Pt),t(Kt),t($e),t(Ot),t(ke),t(es),t(ls),t(ts),t(I),t(ss),t(ns),t(as),t(Fe),t(is),t(ps),t(ms),t(ze),t(os),t(Le),t(rs),t(qe),t(us),t(Ae),t(cs),t(Ms),t(Pe),t(ds),t(ys),t(Oe),t(Js),t(hs),t(bs),t(tl),t(ws),t(sl),t(fs),t(gs),t(al),t(Ts),t(Us),t(js),t(ml),t(Zs),t(ol),t(Ws),t(rl),t(Is),t(ul),t(Gs),t(Xs),t(Bs),t(Cs),t(yl),t(Vs),t(vs),t(Ns),t(_s),t(Rs),t(wl),t(xs),t($s),t(G),t(ks),t(Ss),t(Tl),t(Ys),t(Qs),t(jl),t(Es),t(Zl),t(Fs),t(Hs),t(Il),t(zs),t(Ls),t(qs),t(Bl),t(As),t(Cl),t(Ds),t(Ps),t(X),t(Ks),t(Os),t(Nl),t(en),t(_l),t(ln),t(tn),t(xl),t(sn),t(nn),t(B),t(an),t(pn),t(mn),t(on),t(rn),t(un),t(C),t(cn),t(Fl),t(Mn),t(zl)),t(y),d(j,e),d(U,e),d(k,e),d(S,e),d(z,e),d(v,e),d(D,e),d(P,e),d(ee,e),d(le,e),d(se,e),d(ae,e),d(pe,e),d(oe,e),d(ue,e),d(Me,e),d(Je,e),d(ge,e),d(Ze,e),d(We,e),d(Ge,e),d(Xe,e),d(Ce,e),d(ve,e),d(_e,e),d(xe,e),d(Se,e),d(Ye,e),d(Qe,e),d(Ee,e),d(N,e),d(He,e),d(De,e),d(Ke,e),d(el,e),d(ll,e),d(nl,e),d(il,e),d(pl,e),d(cl,e),d(Ml,e),d(dl,e),d(Jl,e),d(_,e),d(hl,e),d(bl,e),d(fl,e),d(gl,e),d(Ul,e),d(Wl,e),d(Gl,e),d(Xl,e),d(Vl,e),d(vl,e),d(Rl,e),d($l,e),d(kl,e),d(Sl,e),d(Yl,e),d(Ql,e),d(El,e)}}}const Ha='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3}],"depth":2},{"title":"ControlNet","local":"controlnet","sections":[{"title":"Compile ControlNet","local":"compile-controlnet","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":3}],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"Compile","local":"compile","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function za(V){return Ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends xa{constructor(y){super(),$a(this,y,za,Fa,_a,{})}}export{Ka as component};
