import{s as $a,o as Za,n as Fl}from"../chunks/scheduler.6062bdaf.js";import{S as Ba,i as Ea,g as p,s as e,r as h,A as xa,h as M,f as a,c as n,j as Ua,u as r,x as i,k as Ca,y as Ia,a as t,v as d,d as o,t as j,w as m}from"../chunks/index.4bca734e.js";import{T as Ql}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as f}from"../chunks/Heading.723dceba.js";function Ga(J){let c,w='<a href="https://huggingface.co/spaces/huggingface/Model_Cards_Writing_Tool" rel="nofollow">New (beta)! Try our experimental Model Card Creator App</a>';return{c(){c=p("p"),c.innerHTML=w},l(u){c=M(u,"P",{"data-svelte-h":!0}),i(c)!=="svelte-19zmsk8"&&(c.innerHTML=w)},m(u,g){t(u,c,g)},p:Fl,d(u){u&&a(c)}}}function Ra(J){let c,w="Note that you will have to have Jinja2 installed to use <code>from_template</code>. You can do so with <code>pip install Jinja2</code>.";return{c(){c=p("p"),c.innerHTML=w},l(u){c=M(u,"P",{"data-svelte-h":!0}),i(c)!=="svelte-tehb0q"&&(c.innerHTML=w)},m(u,g){t(u,c,g)},p:Fl,d(u){u&&a(c)}}}function Xa(J){let c,w='Note that using this function requires you to include the <code>model_name</code> attribute in <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a>.';return{c(){c=p("p"),c.innerHTML=w},l(u){c=M(u,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1d0djs1"&&(c.innerHTML=w)},m(u,g){t(u,c,g)},p:Fl,d(u){u&&a(c)}}}function _a(J){let c,w,u,g,C,Gs,$,Sl=`The <code>huggingface_hub</code> library provides a Python interface to create, share, and update Model Cards.
Visit <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">the dedicated documentation page</a>
for a deeper view of what Model Cards on the Hub are, and how they work under the hood.`,Rs,b,Xs,Z,_s,B,Vl='To load an existing card from the Hub, you can use the <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.RepoCard.load">ModelCard.load()</a> function. Here, we’ll load the card from <a href="https://huggingface.co/nateraw/vit-base-beans" rel="nofollow"><code>nateraw/vit-base-beans</code></a>.',vs,E,ks,x,Hl="This card has some helpful attributes that you may want to access/leverage:",As,I,Ll='<li><code>card.data</code>: Returns a <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> instance with the model card’s metadata. Call <code>.to_dict()</code> on this instance to get the representation as a dictionary.</li> <li><code>card.text</code>: Returns the text of the card, <em>excluding the metadata header</em>.</li> <li><code>card.content</code>: Returns the text content of the card, <em>including the metadata header</em>.</li>',Ys,G,Ws,R,Ns,X,zl="To initialize a Model Card from text, just pass the text content of the card to the <code>ModelCard</code> on init.",Qs,_,Fs,v,ql="Another way you might want to do this is with f-strings. In the following example, we:",Ss,k,Pl='<li>Use <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.CardData.to_yaml">ModelCardData.to_yaml()</a> to convert metadata we defined to YAML so we can use it to insert the YAML block in the model card.</li> <li>Show how you might use a template variable via Python f-strings.</li>',Vs,A,Hs,Y,Dl="The above example would leave us with a card that looks like this:",Ls,W,zs,N,qs,Q,Kl="If you have <code>Jinja2</code> installed, you can create Model Cards from a jinja template file. Let’s see a basic example:",Ps,F,Ds,S,Ol="The resulting card’s markdown looks like this:",Ks,V,Os,H,sa="If you update any card.data, it’ll reflect in the card itself.",sl,L,ll,z,la="Now, as you can see, the metadata header has been updated:",al,q,tl,P,aa='As you update the card data, you can validate the card is still valid against the Hub by calling <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.RepoCard.validate">ModelCard.validate()</a>. This ensures that the card passes any validation rules set up on the Hugging Face Hub.',el,D,nl,K,ta='Instead of using your own template, you can also use the <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">default template</a>, which is a fully featured model card with tons of sections you may want to fill out. Under the hood, it uses <a href="https://jinja.palletsprojects.com/en/3.1.x/" rel="nofollow">Jinja2</a> to fill out a template file.',pl,T,Ml,O,il,ss,cl,ls,ea='If you’re authenticated with the Hugging Face Hub (either by using <code>huggingface-cli login</code> or <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/login#huggingface_hub.login">login()</a>), you can push cards to the Hub by simply calling <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">ModelCard.push_to_hub()</a>. Let’s take a look at how to do that…',hl,as,na="First, we’ll create a new repo called ‘hf-hub-modelcards-pr-test’ under the authenticated user’s namespace:",rl,ts,dl,es,pa="Then, we’ll create a card from the default template (same as the one defined in the section above):",ol,ns,jl,ps,Ma="Finally, we’ll push that up to the hub",ml,Ms,ul,is,ia='You can check out the resulting card <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/blob/main/README.md" rel="nofollow">here</a>.',yl,cs,ca="If you instead wanted to push a card as a pull request, you can just say <code>create_pr=True</code> when calling <code>push_to_hub</code>:",wl,hs,gl,rs,ha='A resulting PR created from this command can be seen <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/discussions/3" rel="nofollow">here</a>.',fl,ds,Jl,os,ra="In this section we will see what metadata are in repo cards and how to update them.",bl,js,da=`<code>metadata</code> refers to a hash map (or key value) context that provides some high-level information about a model, dataset or Space. That information can include details such as the model’s <code>pipeline type</code>, <code>model_id</code> or <code>model_description</code>. For more detail you can take a look to these guides: <a href="https://huggingface.co/docs/hub/model-cards#model-card-metadata" rel="nofollow">Model Card</a>, <a href="https://huggingface.co/docs/hub/datasets-cards#dataset-card-metadata" rel="nofollow">Dataset Card</a> and <a href="https://huggingface.co/docs/hub/spaces-settings#spaces-settings" rel="nofollow">Spaces Settings</a>.
Now lets see some examples on how to update those metadata.`,Tl,ms,oa="Let’s start with a first example:",Ul,us,Cl,ys,ja="With these two lines of code you will update the metadata to set a new <code>pipeline_tag</code>.",$l,ws,ma=`By default, you cannot update a key that is already existing on the card. If you want to do so, you must pass
<code>overwrite=True</code> explicitly:`,Zl,gs,Bl,fs,ua=`It often happen that you want to suggest some changes to a repository
on which you don’t have write permission. You can do that by creating a PR on that repo which will allow the owners to
review and merge your suggestions.`,El,Js,xl,bs,Il,Ts,ya='To include evaluation results in the metadata <code>model-index</code>, you can pass an <a href="/docs/huggingface_hub/v0.22.0.rc0/en/package_reference/cards#huggingface_hub.EvalResult">EvalResult</a> or a list of <code>EvalResult</code> with your associated evaluation results. Under the hood it’ll create the <code>model-index</code> when you call <code>card.data.to_dict()</code>. For more information on how this works, you can check out <a href="https://huggingface.co/docs/hub/models-cards#evaluation-results" rel="nofollow">this section of the Hub docs</a>.',Gl,U,Rl,Us,Xl,Cs,wa="The resulting <code>card.data</code> should look like this:",_l,$s,vl,Zs,ga="If you have more than one evaluation result you’d like to share, just pass a list of <code>EvalResult</code>:",kl,Bs,Al,Es,fa="Which should leave you with the following <code>card.data</code>:",Yl,xs,Wl,Is,Nl;return C=new f({props:{title:"Create and share Model Cards",local:"create-and-share-model-cards",headingTag:"h1"}}),b=new Ql({props:{$$slots:{default:[Ga]},$$scope:{ctx:J}}}),Z=new f({props:{title:"Load a Model Card from the Hub",local:"load-a-model-card-from-the-hub",headingTag:"h2"}}),E=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQubG9hZCgnbmF0ZXJhdyUyRnZpdC1iYXNlLWJlYW5zJyk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard

card = ModelCard.load(<span class="hljs-string">&#x27;nateraw/vit-base-beans&#x27;</span>)`,wrap:!1}}),G=new f({props:{title:"Create Model Cards",local:"create-model-cards",headingTag:"h2"}}),R=new f({props:{title:"From Text",local:"from-text",headingTag:"h3"}}),_=new y({props:{code:"Y29udGVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBY2FyZC5kYXRhLnRvX2RpY3QoKSUyMCUzRCUzRCUyMCU3QidsYW5ndWFnZSclM0ElMjAnZW4nJTJDJTIwJ2xpY2Vuc2UnJTNBJTIwJ21pdCclN0QlMjAlMjAlMjMlMjBUcnVl",highlighted:`content = <span class="hljs-string">&quot;&quot;&quot;
---
language: en
license: mit
---

# My Model Card
&quot;&quot;&quot;</span>

card = ModelCard(content)
card.data.to_dict() == {<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}  <span class="hljs-comment"># True</span>`,wrap:!1}}),A=new y({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5JTNEJ3RpbW0nKSUwQSUwQWV4YW1wbGVfdGVtcGxhdGVfdmFyJTIwJTNEJTIwJ25hdGVyYXcnJTBBY29udGVudCUyMCUzRCUyMGYlMjIlMjIlMjIlMEEtLS0lMEElN0IlMjBjYXJkX2RhdGEudG9feWFtbCgpJTIwJTdEJTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMEFUaGlzJTIwbW9kZWwlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCklMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBcHJpbnQoY2FyZCk=",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library=<span class="hljs-string">&#x27;timm&#x27;</span>)

example_template_var = <span class="hljs-string">&#x27;nateraw&#x27;</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
<span class="hljs-subst">{ card_data.to_yaml() }</span>
---

# My Model Card

This model created by [@<span class="hljs-subst">{example_template_var}</span>](https://github.com/<span class="hljs-subst">{example_template_var}</span>)
&quot;&quot;&quot;</span>

card = ModelCard(content)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),W=new y({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5JTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME15JTIwTW9kZWwlMjBDYXJkJTBBJTBBVGhpcyUyMG1vZGVsJTIwY3JlYXRlZCUyMGJ5JTIwJTVCJTQwbmF0ZXJhdyU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZuYXRlcmF3KQ==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># My Model Card</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://github.com/nateraw)</span>`,wrap:!1}}),N=new f({props:{title:"From a Jinja Template",local:"from-a-jinja-template",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwamluamElMjB0ZW1wbGF0ZSUwQXRlbXBsYXRlX3RleHQlMjAlM0QlMjAlMjIlMjIlMjIlMEEtLS0lMEElN0IlN0IlMjBjYXJkX2RhdGElMjAlN0QlN0QlMEEtLS0lMEElMEElMjMlMjBNb2RlbCUyMENhcmQlMjBmb3IlMjBNeUNvb2xNb2RlbCUwQSUwQVRoaXMlMjBtb2RlbCUyMGRvZXMlMjB0aGlzJTIwYW5kJTIwdGhhdC4lMEElMEFUaGlzJTIwbW9kZWwlMjB3YXMlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0IlN0IlMjBhdXRob3IlMjAlN0QlN0QlNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRiU3QiU3QmF1dGhvciU3RCU3RCkuJTBBJTIyJTIyJTIyLnN0cmlwKCklMEElMEElMjMlMjBXcml0ZSUyMHRoZSUyMHRlbXBsYXRlJTIwdG8lMjBhJTIwZmlsZSUwQVBhdGgoJ2N1c3RvbV90ZW1wbGF0ZS5tZCcpLndyaXRlX3RleHQodGVtcGxhdGVfdGV4dCklMEElMEElMjMlMjBEZWZpbmUlMjBjYXJkJTIwbWV0YWRhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBNb2RlbENhcmREYXRhKGxhbmd1YWdlJTNEJ2VuJyUyQyUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUyMGxpYnJhcnlfbmFtZSUzRCdrZXJhcycpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY2FyZCUyMGZyb20lMjB0ZW1wbGF0ZSUyQyUyMHBhc3NpbmclMjBpdCUyMGFueSUyMGppbmphJTIwdGVtcGxhdGUlMjB2YXJpYWJsZXMlMjB5b3UlMjB3YW50LiUwQSUyMyUyMEluJTIwb3VyJTIwY2FzZSUyQyUyMHdlJ2xsJTIwcGFzcyUyMGF1dGhvciUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGElMkMlMjB0ZW1wbGF0ZV9wYXRoJTNEJ2N1c3RvbV90ZW1wbGF0ZS5tZCclMkMlMjBhdXRob3IlM0QnbmF0ZXJhdycpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzEubWQnKSUwQXByaW50KGNhcmQp",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-comment"># Define your jinja template</span>
template_text = <span class="hljs-string">&quot;&quot;&quot;
---
{{ card_data }}
---

# Model Card for MyCoolModel

This model does this and that.

This model was created by [@{{ author }}](https://hf.co/{{author}}).
&quot;&quot;&quot;</span>.strip()

<span class="hljs-comment"># Write the template to a file</span>
Path(<span class="hljs-string">&#x27;custom_template.md&#x27;</span>).write_text(template_text)

<span class="hljs-comment"># Define card metadata</span>
card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)

<span class="hljs-comment"># Create card from template, passing it any jinja template variables you want.</span>
<span class="hljs-comment"># In our case, we&#x27;ll pass author</span>
card = ModelCard.from_template(card_data, template_path=<span class="hljs-string">&#x27;custom_template.md&#x27;</span>, author=<span class="hljs-string">&#x27;nateraw&#x27;</span>)
card.save(<span class="hljs-string">&#x27;my_model_card_1.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),V=new y({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5X25hbWUlM0ElMjBrZXJhcyUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">keras</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),L=new y({props:{code:"Y2FyZC5kYXRhLmxpYnJhcnlfbmFtZSUyMCUzRCUyMCd0aW1tJyUwQWNhcmQuZGF0YS5sYW5ndWFnZSUyMCUzRCUyMCdmciclMEFjYXJkLmRhdGEubGljZW5zZSUyMCUzRCUyMCdhcGFjaGUtMi4wJyUwQXByaW50KGNhcmQp",highlighted:`card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.library_name</span> = <span class="hljs-string">&#x27;timm&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.language</span> = <span class="hljs-string">&#x27;fr&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.license</span> = <span class="hljs-string">&#x27;apache-2.0&#x27;</span>
<span class="hljs-function"><span class="hljs-title">print</span><span class="hljs-params">(card)</span></span>`,wrap:!1}}),q=new y({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBmciUwQWxpY2Vuc2UlM0ElMjBhcGFjaGUtMi4wJTBBbGlicmFyeV9uYW1lJTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">fr</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">apache-2.0</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),D=new f({props:{title:"From the Default Template",local:"from-the-default-template",headingTag:"h3"}}),T=new Ql({props:{$$slots:{default:[Ra]},$$scope:{ctx:J}}}),O=new y({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzIubWQnKSUwQXByaW50KGNhcmQp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)
card.save(<span class="hljs-string">&#x27;my_model_card_2.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),ss=new f({props:{title:"Share Model Cards",local:"share-model-cards",headingTag:"h2"}}),ts=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUyQyUyMGNyZWF0ZV9yZXBvJTBBJTBBdXNlciUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBcmVwb19pZCUyMCUzRCUyMGYnJTdCdXNlciU3RCUyRmhmLWh1Yi1tb2RlbGNhcmRzLXByLXRlc3QnJTBBdXJsJTIwJTNEJTIwY3JlYXRlX3JlcG8ocmVwb19pZCUyQyUyMGV4aXN0X29rJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami, create_repo

user = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]
repo_id = <span class="hljs-string">f&#x27;<span class="hljs-subst">{user}</span>/hf-hub-modelcards-pr-test&#x27;</span>
url = create_repo(repo_id, exist_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),ns=new y({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)`,wrap:!1}}),Ms=new y({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkKQ==",highlighted:"card.push_to_hub(repo_id)",wrap:!1}}),hs=new y({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:'card.push_to_hub(repo_id, create_pr=<span class="hljs-literal">True</span>)',wrap:!1}}),ds=new f({props:{title:"Update metadata",local:"update-metadata",headingTag:"h2"}}),us=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>})`,wrap:!1}}),gs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlN0QlMkMlMjBvdmVyd3JpdGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-generation&quot;</span>}, overwrite=<span class="hljs-literal">True</span>)`,wrap:!1}}),Js=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJzb21lb25lJTJGbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTdEJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;someone/model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-classification&quot;</span>}, create_pr=<span class="hljs-literal">True</span>)`,wrap:!1}}),bs=new f({props:{title:"Include Evaluation Results",local:"include-evaluation-results",headingTag:"h2"}}),U=new Ql({props:{$$slots:{default:[Xa]},$$scope:{ctx:J}}}),Us=new y({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjApJTBBKSUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGEpJTBBcHJpbnQoY2FyZC5kYXRhKQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = EvalResult(
        task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
        dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
        dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
        metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
        metric_value=<span class="hljs-number">0.7</span>
    )
)

card = ModelCard.from_template(card_data)
<span class="hljs-built_in">print</span>(card.data)`,wrap:!1}}),$s=new y({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>`,wrap:!1}}),Bs=new y({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdmMSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjY1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkLmZyb21fdGVtcGxhdGUoY2FyZF9kYXRhKSUwQWNhcmQuZGF0YQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = [
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
            metric_value=<span class="hljs-number">0.7</span>
        ),
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;f1&#x27;</span>,
            metric_value=<span class="hljs-number">0.65</span>
        )
    ]
)
card = ModelCard.from_template(card_data)
card.data`,wrap:!1}}),xs=new y({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43JTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBmMSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC42NQ==",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: f1</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.65</span>`,wrap:!1}}),{c(){c=p("meta"),w=e(),u=p("p"),g=e(),h(C.$$.fragment),Gs=e(),$=p("p"),$.innerHTML=Sl,Rs=e(),h(b.$$.fragment),Xs=e(),h(Z.$$.fragment),_s=e(),B=p("p"),B.innerHTML=Vl,vs=e(),h(E.$$.fragment),ks=e(),x=p("p"),x.textContent=Hl,As=e(),I=p("ul"),I.innerHTML=Ll,Ys=e(),h(G.$$.fragment),Ws=e(),h(R.$$.fragment),Ns=e(),X=p("p"),X.innerHTML=zl,Qs=e(),h(_.$$.fragment),Fs=e(),v=p("p"),v.textContent=ql,Ss=e(),k=p("ul"),k.innerHTML=Pl,Vs=e(),h(A.$$.fragment),Hs=e(),Y=p("p"),Y.textContent=Dl,Ls=e(),h(W.$$.fragment),zs=e(),h(N.$$.fragment),qs=e(),Q=p("p"),Q.innerHTML=Kl,Ps=e(),h(F.$$.fragment),Ds=e(),S=p("p"),S.textContent=Ol,Ks=e(),h(V.$$.fragment),Os=e(),H=p("p"),H.textContent=sa,sl=e(),h(L.$$.fragment),ll=e(),z=p("p"),z.textContent=la,al=e(),h(q.$$.fragment),tl=e(),P=p("p"),P.innerHTML=aa,el=e(),h(D.$$.fragment),nl=e(),K=p("p"),K.innerHTML=ta,pl=e(),h(T.$$.fragment),Ml=e(),h(O.$$.fragment),il=e(),h(ss.$$.fragment),cl=e(),ls=p("p"),ls.innerHTML=ea,hl=e(),as=p("p"),as.textContent=na,rl=e(),h(ts.$$.fragment),dl=e(),es=p("p"),es.textContent=pa,ol=e(),h(ns.$$.fragment),jl=e(),ps=p("p"),ps.textContent=Ma,ml=e(),h(Ms.$$.fragment),ul=e(),is=p("p"),is.innerHTML=ia,yl=e(),cs=p("p"),cs.innerHTML=ca,wl=e(),h(hs.$$.fragment),gl=e(),rs=p("p"),rs.innerHTML=ha,fl=e(),h(ds.$$.fragment),Jl=e(),os=p("p"),os.textContent=ra,bl=e(),js=p("p"),js.innerHTML=da,Tl=e(),ms=p("p"),ms.textContent=oa,Ul=e(),h(us.$$.fragment),Cl=e(),ys=p("p"),ys.innerHTML=ja,$l=e(),ws=p("p"),ws.innerHTML=ma,Zl=e(),h(gs.$$.fragment),Bl=e(),fs=p("p"),fs.textContent=ua,El=e(),h(Js.$$.fragment),xl=e(),h(bs.$$.fragment),Il=e(),Ts=p("p"),Ts.innerHTML=ya,Gl=e(),h(U.$$.fragment),Rl=e(),h(Us.$$.fragment),Xl=e(),Cs=p("p"),Cs.innerHTML=wa,_l=e(),h($s.$$.fragment),vl=e(),Zs=p("p"),Zs.innerHTML=ga,kl=e(),h(Bs.$$.fragment),Al=e(),Es=p("p"),Es.innerHTML=fa,Yl=e(),h(xs.$$.fragment),Wl=e(),Is=p("p"),this.h()},l(s){const l=xa("svelte-u9bgzb",document.head);c=M(l,"META",{name:!0,content:!0}),l.forEach(a),w=n(s),u=M(s,"P",{}),Ua(u).forEach(a),g=n(s),r(C.$$.fragment,s),Gs=n(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-sb4v4f"&&($.innerHTML=Sl),Rs=n(s),r(b.$$.fragment,s),Xs=n(s),r(Z.$$.fragment,s),_s=n(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-12zs52a"&&(B.innerHTML=Vl),vs=n(s),r(E.$$.fragment,s),ks=n(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-10yvqaf"&&(x.textContent=Hl),As=n(s),I=M(s,"UL",{"data-svelte-h":!0}),i(I)!=="svelte-v8f1s3"&&(I.innerHTML=Ll),Ys=n(s),r(G.$$.fragment,s),Ws=n(s),r(R.$$.fragment,s),Ns=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-17iybkb"&&(X.innerHTML=zl),Qs=n(s),r(_.$$.fragment,s),Fs=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1i1nzes"&&(v.textContent=ql),Ss=n(s),k=M(s,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-1a6aaij"&&(k.innerHTML=Pl),Vs=n(s),r(A.$$.fragment,s),Hs=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-azweip"&&(Y.textContent=Dl),Ls=n(s),r(W.$$.fragment,s),zs=n(s),r(N.$$.fragment,s),qs=n(s),Q=M(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-w5ezj2"&&(Q.innerHTML=Kl),Ps=n(s),r(F.$$.fragment,s),Ds=n(s),S=M(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-186asy8"&&(S.textContent=Ol),Ks=n(s),r(V.$$.fragment,s),Os=n(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1uu9tt7"&&(H.textContent=sa),sl=n(s),r(L.$$.fragment,s),ll=n(s),z=M(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1pjyyfy"&&(z.textContent=la),al=n(s),r(q.$$.fragment,s),tl=n(s),P=M(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-mb4749"&&(P.innerHTML=aa),el=n(s),r(D.$$.fragment,s),nl=n(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-bhtooo"&&(K.innerHTML=ta),pl=n(s),r(T.$$.fragment,s),Ml=n(s),r(O.$$.fragment,s),il=n(s),r(ss.$$.fragment,s),cl=n(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-5emrtz"&&(ls.innerHTML=ea),hl=n(s),as=M(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-4nym2l"&&(as.textContent=na),rl=n(s),r(ts.$$.fragment,s),dl=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-m495as"&&(es.textContent=pa),ol=n(s),r(ns.$$.fragment,s),jl=n(s),ps=M(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-17rhkin"&&(ps.textContent=Ma),ml=n(s),r(Ms.$$.fragment,s),ul=n(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1ecq7w8"&&(is.innerHTML=ia),yl=n(s),cs=M(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-1wkut12"&&(cs.innerHTML=ca),wl=n(s),r(hs.$$.fragment,s),gl=n(s),rs=M(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-bvjuqo"&&(rs.innerHTML=ha),fl=n(s),r(ds.$$.fragment,s),Jl=n(s),os=M(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1r8ornf"&&(os.textContent=ra),bl=n(s),js=M(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-1k83g63"&&(js.innerHTML=da),Tl=n(s),ms=M(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-1myl3lm"&&(ms.textContent=oa),Ul=n(s),r(us.$$.fragment,s),Cl=n(s),ys=M(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1tsl7te"&&(ys.innerHTML=ja),$l=n(s),ws=M(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-jfkfc6"&&(ws.innerHTML=ma),Zl=n(s),r(gs.$$.fragment,s),Bl=n(s),fs=M(s,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-1qf6a5n"&&(fs.textContent=ua),El=n(s),r(Js.$$.fragment,s),xl=n(s),r(bs.$$.fragment,s),Il=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1aj8ifs"&&(Ts.innerHTML=ya),Gl=n(s),r(U.$$.fragment,s),Rl=n(s),r(Us.$$.fragment,s),Xl=n(s),Cs=M(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-ejf86q"&&(Cs.innerHTML=wa),_l=n(s),r($s.$$.fragment,s),vl=n(s),Zs=M(s,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-1k9vy6l"&&(Zs.innerHTML=ga),kl=n(s),r(Bs.$$.fragment,s),Al=n(s),Es=M(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-12f1f8r"&&(Es.innerHTML=fa),Yl=n(s),r(xs.$$.fragment,s),Wl=n(s),Is=M(s,"P",{}),Ua(Is).forEach(a),this.h()},h(){Ca(c,"name","hf:doc:metadata"),Ca(c,"content",va)},m(s,l){Ia(document.head,c),t(s,w,l),t(s,u,l),t(s,g,l),d(C,s,l),t(s,Gs,l),t(s,$,l),t(s,Rs,l),d(b,s,l),t(s,Xs,l),d(Z,s,l),t(s,_s,l),t(s,B,l),t(s,vs,l),d(E,s,l),t(s,ks,l),t(s,x,l),t(s,As,l),t(s,I,l),t(s,Ys,l),d(G,s,l),t(s,Ws,l),d(R,s,l),t(s,Ns,l),t(s,X,l),t(s,Qs,l),d(_,s,l),t(s,Fs,l),t(s,v,l),t(s,Ss,l),t(s,k,l),t(s,Vs,l),d(A,s,l),t(s,Hs,l),t(s,Y,l),t(s,Ls,l),d(W,s,l),t(s,zs,l),d(N,s,l),t(s,qs,l),t(s,Q,l),t(s,Ps,l),d(F,s,l),t(s,Ds,l),t(s,S,l),t(s,Ks,l),d(V,s,l),t(s,Os,l),t(s,H,l),t(s,sl,l),d(L,s,l),t(s,ll,l),t(s,z,l),t(s,al,l),d(q,s,l),t(s,tl,l),t(s,P,l),t(s,el,l),d(D,s,l),t(s,nl,l),t(s,K,l),t(s,pl,l),d(T,s,l),t(s,Ml,l),d(O,s,l),t(s,il,l),d(ss,s,l),t(s,cl,l),t(s,ls,l),t(s,hl,l),t(s,as,l),t(s,rl,l),d(ts,s,l),t(s,dl,l),t(s,es,l),t(s,ol,l),d(ns,s,l),t(s,jl,l),t(s,ps,l),t(s,ml,l),d(Ms,s,l),t(s,ul,l),t(s,is,l),t(s,yl,l),t(s,cs,l),t(s,wl,l),d(hs,s,l),t(s,gl,l),t(s,rs,l),t(s,fl,l),d(ds,s,l),t(s,Jl,l),t(s,os,l),t(s,bl,l),t(s,js,l),t(s,Tl,l),t(s,ms,l),t(s,Ul,l),d(us,s,l),t(s,Cl,l),t(s,ys,l),t(s,$l,l),t(s,ws,l),t(s,Zl,l),d(gs,s,l),t(s,Bl,l),t(s,fs,l),t(s,El,l),d(Js,s,l),t(s,xl,l),d(bs,s,l),t(s,Il,l),t(s,Ts,l),t(s,Gl,l),d(U,s,l),t(s,Rl,l),d(Us,s,l),t(s,Xl,l),t(s,Cs,l),t(s,_l,l),d($s,s,l),t(s,vl,l),t(s,Zs,l),t(s,kl,l),d(Bs,s,l),t(s,Al,l),t(s,Es,l),t(s,Yl,l),d(xs,s,l),t(s,Wl,l),t(s,Is,l),Nl=!0},p(s,[l]){const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),b.$set(Ja);const ba={};l&2&&(ba.$$scope={dirty:l,ctx:s}),T.$set(ba);const Ta={};l&2&&(Ta.$$scope={dirty:l,ctx:s}),U.$set(Ta)},i(s){Nl||(o(C.$$.fragment,s),o(b.$$.fragment,s),o(Z.$$.fragment,s),o(E.$$.fragment,s),o(G.$$.fragment,s),o(R.$$.fragment,s),o(_.$$.fragment,s),o(A.$$.fragment,s),o(W.$$.fragment,s),o(N.$$.fragment,s),o(F.$$.fragment,s),o(V.$$.fragment,s),o(L.$$.fragment,s),o(q.$$.fragment,s),o(D.$$.fragment,s),o(T.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ts.$$.fragment,s),o(ns.$$.fragment,s),o(Ms.$$.fragment,s),o(hs.$$.fragment,s),o(ds.$$.fragment,s),o(us.$$.fragment,s),o(gs.$$.fragment,s),o(Js.$$.fragment,s),o(bs.$$.fragment,s),o(U.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(Bs.$$.fragment,s),o(xs.$$.fragment,s),Nl=!0)},o(s){j(C.$$.fragment,s),j(b.$$.fragment,s),j(Z.$$.fragment,s),j(E.$$.fragment,s),j(G.$$.fragment,s),j(R.$$.fragment,s),j(_.$$.fragment,s),j(A.$$.fragment,s),j(W.$$.fragment,s),j(N.$$.fragment,s),j(F.$$.fragment,s),j(V.$$.fragment,s),j(L.$$.fragment,s),j(q.$$.fragment,s),j(D.$$.fragment,s),j(T.$$.fragment,s),j(O.$$.fragment,s),j(ss.$$.fragment,s),j(ts.$$.fragment,s),j(ns.$$.fragment,s),j(Ms.$$.fragment,s),j(hs.$$.fragment,s),j(ds.$$.fragment,s),j(us.$$.fragment,s),j(gs.$$.fragment,s),j(Js.$$.fragment,s),j(bs.$$.fragment,s),j(U.$$.fragment,s),j(Us.$$.fragment,s),j($s.$$.fragment,s),j(Bs.$$.fragment,s),j(xs.$$.fragment,s),Nl=!1},d(s){s&&(a(w),a(u),a(g),a(Gs),a($),a(Rs),a(Xs),a(_s),a(B),a(vs),a(ks),a(x),a(As),a(I),a(Ys),a(Ws),a(Ns),a(X),a(Qs),a(Fs),a(v),a(Ss),a(k),a(Vs),a(Hs),a(Y),a(Ls),a(zs),a(qs),a(Q),a(Ps),a(Ds),a(S),a(Ks),a(Os),a(H),a(sl),a(ll),a(z),a(al),a(tl),a(P),a(el),a(nl),a(K),a(pl),a(Ml),a(il),a(cl),a(ls),a(hl),a(as),a(rl),a(dl),a(es),a(ol),a(jl),a(ps),a(ml),a(ul),a(is),a(yl),a(cs),a(wl),a(gl),a(rs),a(fl),a(Jl),a(os),a(bl),a(js),a(Tl),a(ms),a(Ul),a(Cl),a(ys),a($l),a(ws),a(Zl),a(Bl),a(fs),a(El),a(xl),a(Il),a(Ts),a(Gl),a(Rl),a(Xl),a(Cs),a(_l),a(vl),a(Zs),a(kl),a(Al),a(Es),a(Yl),a(Wl),a(Is)),a(c),m(C,s),m(b,s),m(Z,s),m(E,s),m(G,s),m(R,s),m(_,s),m(A,s),m(W,s),m(N,s),m(F,s),m(V,s),m(L,s),m(q,s),m(D,s),m(T,s),m(O,s),m(ss,s),m(ts,s),m(ns,s),m(Ms,s),m(hs,s),m(ds,s),m(us,s),m(gs,s),m(Js,s),m(bs,s),m(U,s),m(Us,s),m($s,s),m(Bs,s),m(xs,s)}}}const va='{"title":"Create and share Model Cards","local":"create-and-share-model-cards","sections":[{"title":"Load a Model Card from the Hub","local":"load-a-model-card-from-the-hub","sections":[],"depth":2},{"title":"Create Model Cards","local":"create-model-cards","sections":[{"title":"From Text","local":"from-text","sections":[],"depth":3},{"title":"From a Jinja Template","local":"from-a-jinja-template","sections":[],"depth":3},{"title":"From the Default Template","local":"from-the-default-template","sections":[],"depth":3}],"depth":2},{"title":"Share Model Cards","local":"share-model-cards","sections":[],"depth":2},{"title":"Update metadata","local":"update-metadata","sections":[],"depth":2},{"title":"Include Evaluation Results","local":"include-evaluation-results","sections":[],"depth":2}],"depth":1}';function ka(J){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends Ba{constructor(c){super(),Ea(this,c,ka,_a,$a,{})}}export{Fa as component};
