import{s as Re,n as ke,o as ve}from"../chunks/scheduler.412302f6.js";import{S as _e,i as Xe,g as o,s as a,r as p,A as Qe,h as i,f as t,c as n,j as $e,u as m,x as c,k as Fe,y as ze,a as s,v as M,d as r,t as d,w as y}from"../chunks/index.f36f02f5.js";import{C as u}from"../chunks/CodeBlock.f4a4ce81.js";import{D as He}from"../chunks/DocNotebookDropdown.1a2c1686.js";import{H as we}from"../chunks/Heading.41d80af4.js";function Ee(Te){let h,Y,V,A,J,S,w,N,T,be=`Training Large Language Models (LLMs) on Google Tensor Processing Units (TPUs) with Single Program Multiple Data (SPMD) offers a multitude of benefits. TPUs provide competitive processing power, enabling good training times and allowing researchers to experiment with larger models and datasets efficiently. SPMD architecture optimizes resource utilization by distributing tasks across multiple TPUs, enhancing parallelism and scalability.
The easiest approach to tune a model with SPMD is using Fully Sharded Data Parallel <a href="https://engineering.fb.com/2021/07/15/open-source/fsdp/" rel="nofollow">(FSDP)</a>. Pytorch/XLA most recent and performant implementation is <a href="https://github.com/pytorch/xla/blob/master/docs/fsdpv2.md" rel="nofollow">FSDP v2</a>, that allows to shard weights, activations and outputs.`,P,b,Ue='This example shows to tune one of Meta’s Llama models on single host TPUs. For information on TPUs architecture, you can consult the <a href="https://cloud.google.com/tpu/docs/system-architecture-tpu-vm" rel="nofollow">documentation</a>.',L,U,q,f,fe=`We consider you have already created a single-host TPU VM, such as a <code>v5litepod8</code> setup, and you have ssh access to the machine.
You need to clone <code>optimum-tpu</code> and install few modules:`,D,j,K,g,je="We should then see the familiar Jupyter output that shows the address accessible from a browser:",O,B,ee,G,ge='Since we are going to use the gated <code>llama</code> model, we will need to log in using a <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face token</a>:',le,Z,te,I,se,C,Be=`To fine-tune an LLM, it might be necessary to shard the model across the TPUs to prevent memory issues and enhance tuning performances. Fully Sharded Data Parallel is an algorithm that has been implemented on Pytorch and that allows to wrap modules to distribute them.
When using Pytorch/XLA on TPUs, <a href="https://pytorch.org/xla/master/#fully-sharded-data-parallel-via-spmd" rel="nofollow">FSDPv2</a> is an utility that re-expresses the famous FSDP algorithm using SPMD (Single Program Multiple Data). In <code>optimum-tpu</code> it is possible to use dedicated helpers to use FSPDv2. To enable it, you can use the dedicated function, that should be called at the beginning of the execution:`,ae,W,ne,$,Ge='Then, the tokenizer and model need to be loaded. We will choose <a href="https://huggingface.co/meta-llama/Llama-3.2-1B" rel="nofollow"><code>meta-llama/Llama-3.2-1B</code></a> for this example.',oe,F,pe,R,Ze='To tune the model with the <a href="https://huggingface.co/datasets/Abirate/english_quotes" rel="nofollow">Abirate/english_quotes</a> dataset, you can load it and obtain the <code>quote</code> column:',ie,k,me,v,Ie="You then need to specify the FSDP training arguments to enable the sharding feature, the function will deduce the classes that should be sharded:",Me,_,re,X,Ce="The <code>fsdp_training_args</code> will specify the Pytorch module that needs to be sharded:",de,Q,ye,z,We="Now training can be done as simply as using the standard <code>Trainer</code> class:",ce,H,ue,E,he,x,Je;return J=new He({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/optimum-tpu/blob/main/language-modeling/llama_tuning.ipynb"}]}}),w=new we({props:{title:"Fine-Tune Llama on Google TPU",local:"fine-tune-llama-on-google-tpu",headingTag:"h1"}}),U=new we({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),j=new u({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tdHB1LmdpdCUwQSUyMyUyMEluc3RhbGwlMjBPcHRpbXVtJTIwVFBVJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLiUyMC1mJTIwaHR0cHMlM0ElMkYlMkZzdG9yYWdlLmdvb2dsZWFwaXMuY29tJTJGbGlidHB1LXJlbGVhc2VzJTJGaW5kZXguaHRtbCUwQSUyMyUyMEluc3RhbGwlMjBUUkwlMjBhbmQlMjBQRUZUJTIwZm9yJTIwdHJhaW5pbmclMjAoc2VlJTIwbGF0ZXIlMjBob3clMjB0aGV5JTIwYXJlJTIwdXNlZCklMEFwaXAlMjBpbnN0YWxsJTIwdHJsJTIwcGVmdCUwQSUyMyUyMEluc3RhbGwlMjBKdXB5dGVyJTIwbm90ZWJvb2slMEFwaXAlMjBpbnN0YWxsJTIwLVUlMjBqdXB5dGVybGFiJTIwbm90ZWJvb2slMEElMjMlMjBPcHRpb25hbGx5JTJDJTIwaW5zdGFsbCUyMHdpZGdldHMlMjBleHRlbnNpb25zJTIwZm9yJTIwYmV0dGVyJTIwcmVuZGVyaW5nJTBBcGlwJTIwaW5zdGFsbCUyMGlweXdpZGdldHMlMjB3aWRnZXRzbmJleHRlbnNpb24lMEElMjMlMjBUaGlzJTIwd2lsbCUyMGJlJTIwbmVjZXNzYXJ5JTIwZm9yJTIwdGhlJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUyMGV4YW1wbGUlMEFwaXAlMjBpbnN0YWxsJTIwZGF0YXNldHMlMjBldmFsdWF0ZSUyMGFjY2VsZXJhdGUlMEElMjMlMjBDaGFuZ2UlMjBkaXJlY3RvcnklMjBhbmQlMjBsYXVuY2glMjBKdXB5dGVyJTIwbm90ZWJvb2slMEFjZCUyMG9wdGltdW0tdHB1JTJGZXhhbXBsZXMlMkZsYW5ndWFnZS1tb2RlbGluZyUwQWp1cHl0ZXIlMjBub3RlYm9vayUyMC0tcG9ydCUyMDg4ODg=",highlighted:`git clone https://github.com/huggingface/optimum-tpu.git
<span class="hljs-comment"># Install Optimum TPU</span>
pip install -e . -f https://storage.googleapis.com/libtpu-releases/index.html
<span class="hljs-comment"># Install TRL and PEFT for training (see later how they are used)</span>
pip install trl peft
<span class="hljs-comment"># Install Jupyter notebook</span>
pip install -U jupyterlab notebook
<span class="hljs-comment"># Optionally, install widgets extensions for better rendering</span>
pip install ipywidgets widgetsnbextension
<span class="hljs-comment"># This will be necessary for the language modeling example</span>
pip install datasets evaluate accelerate
<span class="hljs-comment"># Change directory and launch Jupyter notebook</span>
cd optimum-tpu/examples/language-modeling
jupyter notebook --port <span class="hljs-number">8888</span>`,wrap:!1}}),B=new u({props:{code:"aHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTg4ODglMkZ0cmVlJTNGdG9rZW4lM0QzY2ViMjQ2MTlkMGEyZjk5YWNmNWZiYTQxYzUxYjQ3NWIxZGRjZTdjYWRiMmExMzM=",highlighted:'<span class="hljs-attribute">http</span>://localhost:<span class="hljs-number">8888</span>/tree?token=<span class="hljs-number">3</span>ceb24619d0a2f99acf5fba41c51b475b1ddce7cadb2a133',wrap:!1}}),Z=new u({props:{code:"IWh1Z2dpbmdmYWNlLWNsaSUyMGxvZ2luJTIwLS10b2tlbiUyMFlPVVJfSEZfVE9LRU4=",highlighted:"!huggingface-cli login --token YOUR_HF_TOKEN",wrap:!1}}),I=new we({props:{title:"Enable FSDPv2",local:"enable-fsdpv2",headingTag:"h3"}}),W=new u({props:{code:"ZnJvbSUyMG9wdGltdW0udHB1JTIwaW1wb3J0JTIwZnNkcF92MiUwQSUwQSUwQWZzZHBfdjIudXNlX2ZzZHBfdjIoKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.tpu <span class="hljs-keyword">import</span> fsdp_v2


fsdp_v2.use_fsdp_v2()`,wrap:!1}}),F=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTFCJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTIzJTIwQWRkJTIwY3VzdG9tJTIwdG9rZW4lMjBmb3IlMjBwYWRkaW5nJTIwTGxhbWElMEF0b2tlbml6ZXIuYWRkX3NwZWNpYWxfdG9rZW5zKCU3QiUyMnBhZF90b2tlbiUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW4lN0QpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer


model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-comment"># Add custom token for padding Llama</span>
tokenizer.add_special_tokens({<span class="hljs-string">&quot;pad_token&quot;</span>: tokenizer.eos_token})
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16)`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJBYmlyYXRlJTJGZW5nbGlzaF9xdW90ZXMlMjIpJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihzYW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFkZCUyMGElMjBzaW1wbGUlMjBwcm9tcHQlMjBmb3JtYXQlMjB0byUyMHRoZSUyMHF1b3RlcyUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjAlNUJmJTIyR2VuZXJhdGUlMjBhJTIwcXVvdGUlM0ElNUNuJTVDbiU3QnF1b3RlJTdEJTVDbiUyMiUyMGZvciUyMHF1b3RlJTIwaW4lMjBzYW1wbGVzJTVCJTIycXVvdGUlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBFT1MlMjB0b2tlbiUyMHRvJTIwZWFjaCUyMHByb21wdCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjAlNUJwJTIwJTJCJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMGZvciUyMHAlMjBpbiUyMHByb21wdHMlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJwcm9tcHQlMjIlM0ElMjBwcm9tcHRzJTdEJTBBJTBBJTBBJTIzJTIwZGF0YSUyMCUzRCUyMGRhdGEubWFwKGxhbWJkYSUyMHNhbXBsZXMlM0ElMjB0b2tlbml6ZXIoc2FtcGxlcyU1QiUyMnF1b3RlJTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGElMjAlM0QlMjBkYXRhLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRGRhdGElNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


data = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">samples</span>):
    <span class="hljs-comment"># Add a simple prompt format to the quotes</span>
    prompts = [<span class="hljs-string">f&quot;Generate a quote:\\n\\n<span class="hljs-subst">{quote}</span>\\n&quot;</span> <span class="hljs-keyword">for</span> quote <span class="hljs-keyword">in</span> samples[<span class="hljs-string">&quot;quote&quot;</span>]]
    <span class="hljs-comment"># Add EOS token to each prompt</span>
    prompts = [p + tokenizer.eos_token <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> prompts]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts}


<span class="hljs-comment"># data = data.map(lambda samples: tokenizer(samples[&quot;quote&quot;]), batched=True)</span>
data = data.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>, remove_columns=data[<span class="hljs-string">&quot;train&quot;</span>].column_names)`,wrap:!1}}),_=new u({props:{code:"ZnNkcF90cmFpbmluZ19hcmdzJTIwJTNEJTIwZnNkcF92Mi5nZXRfZnNkcF90cmFpbmluZ19hcmdzKG1vZGVsKQ==",highlighted:"fsdp_training_args = fsdp_v2.get_fsdp_training_args(model)",wrap:!1}}),Q=new u({props:{code:"ZnNkcF90cmFpbmluZ19hcmdz",highlighted:"fsdp_training_args",wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxMjglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwciUzRDI1NiUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlMjJhbGwtbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">256</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),E=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGElNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRC0xJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyRm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltJTNEJTIyYWRhZmFjdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhbG9hZGVyX2Ryb3BfbGFzdCUzRFRydWUlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUyMGJ5JTIwRlNEUCUyMHYyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipmc2RwX3RyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnByb21wdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGFja2luZyUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer


trainer = SFTTrainer(
    model=model,
    train_dataset=data[<span class="hljs-string">&quot;train&quot;</span>],
    args=TrainingArguments(
        per_device_train_batch_size=<span class="hljs-number">32</span>,
        num_train_epochs=<span class="hljs-number">10</span>,
        max_steps=-<span class="hljs-number">1</span>,
        output_dir=<span class="hljs-string">&quot;/tmp/output&quot;</span>,
        optim=<span class="hljs-string">&quot;adafactor&quot;</span>,
        logging_steps=<span class="hljs-number">1</span>,
        dataloader_drop_last=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Required by FSDP v2</span>
        **fsdp_training_args,
    ),
    peft_config=lora_config,
    dataset_text_field=<span class="hljs-string">&quot;prompt&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    packing=<span class="hljs-literal">True</span>,
)

trainer.train()`,wrap:!1}}),{c(){h=o("meta"),Y=a(),V=o("p"),A=a(),p(J.$$.fragment),S=a(),p(w.$$.fragment),N=a(),T=o("p"),T.innerHTML=be,P=a(),b=o("p"),b.innerHTML=Ue,L=a(),p(U.$$.fragment),q=a(),f=o("p"),f.innerHTML=fe,D=a(),p(j.$$.fragment),K=a(),g=o("p"),g.textContent=je,O=a(),p(B.$$.fragment),ee=a(),G=o("p"),G.innerHTML=ge,le=a(),p(Z.$$.fragment),te=a(),p(I.$$.fragment),se=a(),C=o("p"),C.innerHTML=Be,ae=a(),p(W.$$.fragment),ne=a(),$=o("p"),$.innerHTML=Ge,oe=a(),p(F.$$.fragment),pe=a(),R=o("p"),R.innerHTML=Ze,ie=a(),p(k.$$.fragment),me=a(),v=o("p"),v.textContent=Ie,Me=a(),p(_.$$.fragment),re=a(),X=o("p"),X.innerHTML=Ce,de=a(),p(Q.$$.fragment),ye=a(),z=o("p"),z.innerHTML=We,ce=a(),p(H.$$.fragment),ue=a(),p(E.$$.fragment),he=a(),x=o("p"),this.h()},l(e){const l=Qe("svelte-u9bgzb",document.head);h=i(l,"META",{name:!0,content:!0}),l.forEach(t),Y=n(e),V=i(e,"P",{}),$e(V).forEach(t),A=n(e),m(J.$$.fragment,e),S=n(e),m(w.$$.fragment,e),N=n(e),T=i(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-d4at2d"&&(T.innerHTML=be),P=n(e),b=i(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1xmhp95"&&(b.innerHTML=Ue),L=n(e),m(U.$$.fragment,e),q=n(e),f=i(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-rn53hz"&&(f.innerHTML=fe),D=n(e),m(j.$$.fragment,e),K=n(e),g=i(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-lrlfqs"&&(g.textContent=je),O=n(e),m(B.$$.fragment,e),ee=n(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-vs989w"&&(G.innerHTML=ge),le=n(e),m(Z.$$.fragment,e),te=n(e),m(I.$$.fragment,e),se=n(e),C=i(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-yyu7nu"&&(C.innerHTML=Be),ae=n(e),m(W.$$.fragment,e),ne=n(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1kv6g7c"&&($.innerHTML=Ge),oe=n(e),m(F.$$.fragment,e),pe=n(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-mykjvz"&&(R.innerHTML=Ze),ie=n(e),m(k.$$.fragment,e),me=n(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1pe66un"&&(v.textContent=Ie),Me=n(e),m(_.$$.fragment,e),re=n(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-fey7xm"&&(X.innerHTML=Ce),de=n(e),m(Q.$$.fragment,e),ye=n(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1bk77jx"&&(z.innerHTML=We),ce=n(e),m(H.$$.fragment,e),ue=n(e),m(E.$$.fragment,e),he=n(e),x=i(e,"P",{}),$e(x).forEach(t),this.h()},h(){Fe(h,"name","hf:doc:metadata"),Fe(h,"content",Ve)},m(e,l){ze(document.head,h),s(e,Y,l),s(e,V,l),s(e,A,l),M(J,e,l),s(e,S,l),M(w,e,l),s(e,N,l),s(e,T,l),s(e,P,l),s(e,b,l),s(e,L,l),M(U,e,l),s(e,q,l),s(e,f,l),s(e,D,l),M(j,e,l),s(e,K,l),s(e,g,l),s(e,O,l),M(B,e,l),s(e,ee,l),s(e,G,l),s(e,le,l),M(Z,e,l),s(e,te,l),M(I,e,l),s(e,se,l),s(e,C,l),s(e,ae,l),M(W,e,l),s(e,ne,l),s(e,$,l),s(e,oe,l),M(F,e,l),s(e,pe,l),s(e,R,l),s(e,ie,l),M(k,e,l),s(e,me,l),s(e,v,l),s(e,Me,l),M(_,e,l),s(e,re,l),s(e,X,l),s(e,de,l),M(Q,e,l),s(e,ye,l),s(e,z,l),s(e,ce,l),M(H,e,l),s(e,ue,l),M(E,e,l),s(e,he,l),s(e,x,l),Je=!0},p:ke,i(e){Je||(r(J.$$.fragment,e),r(w.$$.fragment,e),r(U.$$.fragment,e),r(j.$$.fragment,e),r(B.$$.fragment,e),r(Z.$$.fragment,e),r(I.$$.fragment,e),r(W.$$.fragment,e),r(F.$$.fragment,e),r(k.$$.fragment,e),r(_.$$.fragment,e),r(Q.$$.fragment,e),r(H.$$.fragment,e),r(E.$$.fragment,e),Je=!0)},o(e){d(J.$$.fragment,e),d(w.$$.fragment,e),d(U.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(I.$$.fragment,e),d(W.$$.fragment,e),d(F.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),Je=!1},d(e){e&&(t(Y),t(V),t(A),t(S),t(N),t(T),t(P),t(b),t(L),t(q),t(f),t(D),t(K),t(g),t(O),t(ee),t(G),t(le),t(te),t(se),t(C),t(ae),t(ne),t($),t(oe),t(pe),t(R),t(ie),t(me),t(v),t(Me),t(re),t(X),t(de),t(ye),t(z),t(ce),t(ue),t(he),t(x)),t(h),y(J,e),y(w,e),y(U,e),y(j,e),y(B,e),y(Z,e),y(I,e),y(W,e),y(F,e),y(k,e),y(_,e),y(Q,e),y(H,e),y(E,e)}}}const Ve='{"title":"Fine-Tune Llama on Google TPU","local":"fine-tune-llama-on-google-tpu","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Enable FSDPv2","local":"enable-fsdpv2","sections":[],"depth":3}],"depth":1}';function xe(Te){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends _e{constructor(h){super(),Xe(this,h,xe,Ee,Re,{})}}export{Le as component};
